import { FnO } from "@thi.ng/api";
import type { Path, ZipperOps } from "./api";
export declare class Location<T> {
    protected readonly _node: T;
    protected readonly _ops: ZipperOps<T>;
    protected readonly _path: Path<T> | undefined;
    constructor(node: T, ops: ZipperOps<T>, path?: Path<T>);
    get isBranch(): boolean;
    get isFirst(): boolean;
    get isLast(): boolean;
    get depth(): number;
    get node(): T;
    get children(): T[];
    get path(): T[] | undefined;
    get lefts(): T[] | undefined;
    get rights(): T[] | undefined;
    get left(): Location<T> | undefined;
    get right(): Location<T> | undefined;
    get leftmost(): Location<T>;
    get rightmost(): Location<T>;
    get down(): Location<T> | undefined;
    get up(): Location<T> | undefined;
    get root(): T;
    get prev(): Location<T> | undefined;
    get next(): Location<T> | undefined;
    replace(x: T): Location<T>;
    update(fn: FnO<T, T>, ...xs: any[]): Location<T>;
    insertLeft(x: T): Location<T>;
    insertRight(x: T): Location<T>;
    insertChild(x: T): Location<T>;
    appendChild(x: T): Location<T>;
    remove(): Location<T>;
    protected newNode(node: T, children: T[]): T;
    protected ensureNotRoot(): void;
    private ensureBranch;
}
export declare const zipper: <T>(ops: ZipperOps<T>, node: T) => Location<T>;
export declare const arrayZipper: <T>(root: T[]) => Location<T | T[]>;
//# sourceMappingURL=zipper.d.ts.map