import type { IRandom } from "./api";
/**
 * Returns a no-arg function which produces a random choice of given weighted
 * `choices` and using given {@link IRandom} instance (default {@link SYSTEM}.
 * If `weights` are given, it must be the same size as `choices` (else missing
 * weights will be assumed zero). If omitted entirely, each choice will have
 * same probability.
 *
 * @remarks
 * Throws an error if the `choices` array is empty (requires at least 1 item).
 * If the total sum of `weights` is <= 0 a warning is printed to the console and
 * the resulting function will only ever return the first `choice`.
 *
 * Based on:
 * {@link https://www.electricmonk.nl/log/2009/12/23/weighted-random-distribution/}
 *
 * @param choices -
 * @param weights - optional weights
 */
export declare const weightedRandom: <T>(choices: T[], weights?: ArrayLike<number> | undefined, rnd?: IRandom) => () => T;
//# sourceMappingURL=weighted-random.d.ts.map