import type { IRandom } from "./api";
/**
 * Depending on if `rnd` is given, uses {@link randomBytesFrom} or
 * {@link randomBytes} to fill given (optional) byte array with a new UUIDv4.
 * Creates new Uint8Array if none given.
 *
 * @param buf -
 * @param rnd -
 */
export declare const uuidv4Bytes: (buf?: Uint8Array | undefined, rnd?: IRandom | undefined) => Uint8Array;
/**
 * Returns a UUID string, either from given byte array, or if omitted, using a
 * new UUID v4 produced by {@link uuidv4Bytes}.
 *
 * @param id - byte array
 * @param i - start index
 */
export declare const uuid: (id?: ArrayLike<number> | undefined, i?: number) => string;
//# sourceMappingURL=uuid.d.ts.map