import { Fn0 } from "@thi.ng/api";
import type { IRandom } from "./api";
/**
 * Attempts to draw `k` unique values from given zero-arg function `fn`
 * (presumably a PRNG of sorts) and adds them to `existing` array of unique
 * samples (or creates a new one). Returns the array. Gives up after
 * `maxTrials`.
 *
 * @param k
 * @param fn
 * @param existing
 * @param maxTrials
 */
export declare const uniqueValuesFrom: (k: number, fn: Fn0<number>, existing?: number[], maxTrials?: number) => number[];
/**
 * Similar to (and based o) {@link uniqueValuesFrom}. Attempts to add `k` unique
 * integer indices in the `[0, max)` interval to the (optional) array of
 * pre-`existing` indices (which will never be picked again and new indices will
 * be added to). Returns updated array.
 *
 * @remarks
 * Candidates are drawn from the provided `rnd` {@link IRandom} (default:
 * {@link SYSTEM}) and only `maxTrials` are attempted before giving up.
 *
 * @param k
 * @param max
 * @param existing
 * @param maxTrials
 * @param rnd
 */
export declare const uniqueIndices: (k: number, max: number, existing?: number[] | undefined, maxTrials?: number, rnd?: IRandom) => number[];
//# sourceMappingURL=unique-indices.d.ts.map