import type { IRandom } from "./api";
/**
 * Fills given byte array with random values sourced from given {@link IRandom}
 * instance.
 *
 * @param rnd -
 * @param buf -
 * @param start -
 * @param end -
 */
export declare const randomBytesFrom: (rnd: IRandom, buf: Uint8Array, start?: number, end?: number) => Uint8Array;
/**
 * Fills given byte array with random values. Wrapper for
 * `crypto.getRandomValues()` with automatic fallback to using `Math.random` if
 * platform doesn't provide global crypto instance.
 *
 * @param buf -
 * @param start -
 * @param end -
 */
export declare const randomBytes: (buf: Uint8Array, start?: number, end?: number) => Uint8Array;
//# sourceMappingURL=random-bytes.d.ts.map