'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const defError = (prefix, suffix = (msg) => (msg !== undefined ? ": " + msg : "")) => class extends Error {
    constructor(msg) {
        super(prefix(msg) + suffix(msg));
    }
};

const IllegalArgumentError = defError(() => "illegal argument(s)");
const illegalArgs = (msg) => {
    throw new IllegalArgumentError(msg);
};

const IllegalArityError = defError(() => "illegal arity");
const illegalArity = (n) => {
    throw new IllegalArityError(n);
};

const IllegalStateError = defError(() => "illegal state");
const illegalState = (msg) => {
    throw new IllegalStateError(msg);
};

const OutOfBoundsError = defError(() => "index out of bounds");
const outOfBounds = (index) => {
    throw new OutOfBoundsError(index);
};
const ensureIndex = (index, min, max) => (index < min || index >= max) && outOfBounds(index);
const ensureIndex2 = (x, y, maxX, maxY) => (x < 0 || x >= maxX || y < 0 || y >= maxY) && outOfBounds([x, y]);

const UnsupportedOperationError = defError(() => "unsupported operation");
const unsupported = (msg) => {
    throw new UnsupportedOperationError(msg);
};

exports.IllegalArgumentError = IllegalArgumentError;
exports.IllegalArityError = IllegalArityError;
exports.IllegalStateError = IllegalStateError;
exports.OutOfBoundsError = OutOfBoundsError;
exports.UnsupportedOperationError = UnsupportedOperationError;
exports.defError = defError;
exports.ensureIndex = ensureIndex;
exports.ensureIndex2 = ensureIndex2;
exports.illegalArgs = illegalArgs;
exports.illegalArity = illegalArity;
exports.illegalState = illegalState;
exports.outOfBounds = outOfBounds;
exports.unsupported = unsupported;
