'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const compare = (a, b) => {
    if (a === b) {
        return 0;
    }
    if (a == null) {
        return b == null ? 0 : -1;
    }
    if (b == null) {
        return a == null ? 0 : 1;
    }
    if (typeof a.compare === "function") {
        return a.compare(b);
    }
    if (typeof b.compare === "function") {
        return -b.compare(a);
    }
    return a < b ? -1 : a > b ? 1 : 0;
};

const getKey = (k) => typeof k === "function" ? k : (x) => x[k];
function compareByKey(a, cmp = compare) {
    const k = getKey(a);
    return (x, y) => cmp(k(x), k(y));
}
function compareByKeys2(a, b, cmpA = compare, cmpB = compare) {
    const ka = getKey(a);
    const kb = getKey(b);
    return (x, y) => {
        let res = cmpA(ka(x), ka(y));
        return res === 0 ? cmpB(kb(x), kb(y)) : res;
    };
}
function compareByKeys3(a, b, c, cmpA = compare, cmpB = compare, cmpC = compare) {
    const ka = getKey(a);
    const kb = getKey(b);
    const kc = getKey(c);
    return (x, y) => {
        let res = cmpA(ka(x), ka(y));
        return res === 0
            ? (res = cmpB(kb(x), kb(y))) === 0
                ? cmpC(kc(x), kc(y))
                : res
            : res;
    };
}
function compareByKeys4(a, b, c, d, cmpA = compare, cmpB = compare, cmpC = compare, cmpD = compare) {
    const ka = getKey(a);
    const kb = getKey(b);
    const kc = getKey(c);
    const kd = getKey(d);
    return (x, y) => {
        let res = cmpA(ka(x), ka(y));
        return res === 0
            ? (res = cmpB(kb(x), kb(y))) === 0
                ? (res = cmpC(kc(x), kc(y))) === 0
                    ? cmpD(kd(x), kd(y))
                    : res
                : res
            : res;
    };
}

const compareNumAsc = (a, b) => a - b;
const compareNumDesc = (a, b) => b - a;

const reverse = (cmp) => (a, b) => -cmp(a, b);

exports.compare = compare;
exports.compareByKey = compareByKey;
exports.compareByKeys2 = compareByKeys2;
exports.compareByKeys3 = compareByKeys3;
exports.compareByKeys4 = compareByKeys4;
exports.compareNumAsc = compareNumAsc;
exports.compareNumDesc = compareNumDesc;
exports.reverse = reverse;
