'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const existsAndNotNull = (x) => x != null;

const exists = (t) => t !== undefined;

const hasBigInt = () => typeof BigInt === "function";

const hasCrypto = () => typeof window !== "undefined" && window["crypto"] !== undefined;

const hasMaxLength = (len, x) => x != null && x.length <= len;

const hasMinLength = (len, x) => x != null && x.length >= len;

const isFunction = (x) => typeof x === "function";

const hasPerformance = () => typeof performance !== "undefined" && isFunction(performance.now);

const hasWASM = () => (typeof window !== "undefined" &&
    typeof window["WebAssembly"] !== "undefined") ||
    (typeof global !== "undefined" &&
        typeof global["WebAssembly"] !== "undefined");

const hasWebGL = () => {
    try {
        document.createElement("canvas").getContext("webgl");
        return true;
    }
    catch (e) {
        return false;
    }
};

const hasWebSocket = () => typeof WebSocket !== "undefined";

const implementsFunction = (x, fn) => x != null && typeof x[fn] === "function";

const isAlpha = (x) => /^[a-z]+$/i.test(x);
const isAlphaNum = (x) => /^[a-z0-9]+$/i.test(x);
const isNumeric = (x) => /^[0-9]+$/.test(x);

const isArray = Array.isArray;

const isArrayLike = (x) => x != null && typeof x !== "function" && x.length !== undefined;

const isASCII = (x) => /^[\x00-\x7f]+$/.test(x);
const isPrintableASCII = (x) => /^[\x20-\x7e]+$/.test(x);

const isAsyncIterable = (x) => x != null && typeof x[Symbol.asyncIterator] === "function";

const isBlob = (x) => x instanceof Blob;

const isBoolean = (x) => typeof x === "boolean";

const isChrome = () => typeof window !== "undefined" && !!window["chrome"];

const isDataURL = (x) => /^data:.+\/(.+);base64,/.test(x);

const isDate = (x) => x instanceof Date;

const isEven = (x) => x % 2 === 0;

const isFalse = (x) => x === false;

const isFile = (x) => x instanceof File;

const isFirefox = () => typeof window !== "undefined" && !!window["InstallTrigger"];

const RE$4 = /^(?:[-+]?(?:[0-9]+))?(?:\.[0-9]*)?(?:[eE][\+\-]?(?:[0-9]+))?$/;
const isFloatString = (x) => x.length > 0 && RE$4.test(x);

const isHex = (x) => /^[a-f0-9]+$/i.test(x);

const isString = (x) => typeof x === "string";

const RE$3 = /^#([a-f0-9]{3}|[a-f0-9]{4}(?:[a-f0-9]{2}){0,2})$/i;
const isHexColor = (x) => isString(x) && RE$3.test(x);

const isIE = () => typeof document !== "undefined" &&
    (typeof document["documentMode"] !== "undefined" ||
        navigator.userAgent.indexOf("MSIE") > 0);

const isInRange = (min, max, x) => x >= min && x <= max;

const isInt32 = (x) => typeof x === "number" && (x | 0) === x;

const RE$2 = /^(?:[-+]?(?:0|[1-9][0-9]*))$/;
const isIntString = (x) => RE$2.test(x);

const isIterable = (x) => x != null && typeof x[Symbol.iterator] === "function";

const isMap = (x) => x instanceof Map;

const isMobile = () => typeof navigator !== "undefined" &&
    /mobile|tablet|ip(ad|hone|od)|android|silk|crios/i.test(navigator.userAgent);

const isNaN = (x) => x !== x;

const isNegative = (x) => typeof x === "number" && x < 0;

const isNil = (x) => x == null;

const isNode = () => typeof process === "object" &&
    typeof process.versions === "object" &&
    typeof process.versions.node !== "undefined";

const isNotStringAndIterable = (x) => x != null &&
    typeof x !== "string" &&
    typeof x[Symbol.iterator] === "function";

const isNull = (x) => x === null;

const isNumber = (x) => typeof x === "number";

const isNumericInt = (x) => /^[-+]?\d+$/.test(x);
const isNumericFloat = (x) => /^[-+]?\d*\.?\d+(e[-+]?\d+)?$/i.test(x);

const isObject = (x) => x !== null && typeof x === "object";

const isOdd = (x) => x % 2 !== 0;

const OBJP = Object.getPrototypeOf;
const isPlainObject = (x) => {
    let p;
    return (x != null &&
        typeof x === "object" &&
        ((p = OBJP(x)) === null || OBJP(p) === null));
};

const isPositive = (x) => typeof x === "number" && x > 0;

const isPrimitive = (x) => {
    const t = typeof x;
    return t === "string" || t === "number";
};

const isPromise = (x) => x instanceof Promise;

const isPromiseLike = (x) => x instanceof Promise ||
    (implementsFunction(x, "then") && implementsFunction(x, "catch"));

const ILLEGAL_KEYS = new Set(["__proto__", "prototype", "constructor"]);
const isIllegalKey = (x) => ILLEGAL_KEYS.has(x);
const isProtoPath = (path) => isArray(path)
    ? path.some(isIllegalKey)
    : isString(path)
        ? path.indexOf(".") !== -1
            ? path.split(".").some(isIllegalKey)
            : isIllegalKey(path)
        : false;

const isRegExp = (x) => x instanceof RegExp;

const isSafari = () => typeof navigator !== "undefined" &&
    /Safari/.test(navigator.userAgent) &&
    !isChrome();

const isSet = (x) => x instanceof Set;

const isSymbol = (x) => typeof x === "symbol";

const isTransferable = (x) => x instanceof ArrayBuffer ||
    (typeof SharedArrayBuffer !== "undefined" &&
        x instanceof SharedArrayBuffer) ||
    (typeof MessagePort !== "undefined" && x instanceof MessagePort);

const isTrue = (x) => x === true;

const isTypedArray = (x) => x &&
    (x instanceof Float32Array ||
        x instanceof Float64Array ||
        x instanceof Uint32Array ||
        x instanceof Int32Array ||
        x instanceof Uint8Array ||
        x instanceof Int8Array ||
        x instanceof Uint16Array ||
        x instanceof Int16Array ||
        x instanceof Uint8ClampedArray);

const isUint32 = (x) => typeof x === "number" && x >>> 0 === x;

const isUndefined = (x) => x === undefined;

const RE$1 = /^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i;
const isUUID = (x) => RE$1.test(x);

const RE = /^[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i;
const isUUIDv4 = (x) => RE.test(x);

const isZero = (x) => x === 0;

exports.exists = exists;
exports.existsAndNotNull = existsAndNotNull;
exports.hasBigInt = hasBigInt;
exports.hasCrypto = hasCrypto;
exports.hasMaxLength = hasMaxLength;
exports.hasMinLength = hasMinLength;
exports.hasPerformance = hasPerformance;
exports.hasWASM = hasWASM;
exports.hasWebGL = hasWebGL;
exports.hasWebSocket = hasWebSocket;
exports.implementsFunction = implementsFunction;
exports.isASCII = isASCII;
exports.isAlpha = isAlpha;
exports.isAlphaNum = isAlphaNum;
exports.isArray = isArray;
exports.isArrayLike = isArrayLike;
exports.isAsyncIterable = isAsyncIterable;
exports.isBlob = isBlob;
exports.isBoolean = isBoolean;
exports.isChrome = isChrome;
exports.isDataURL = isDataURL;
exports.isDate = isDate;
exports.isEven = isEven;
exports.isFalse = isFalse;
exports.isFile = isFile;
exports.isFirefox = isFirefox;
exports.isFloatString = isFloatString;
exports.isFunction = isFunction;
exports.isHex = isHex;
exports.isHexColor = isHexColor;
exports.isIE = isIE;
exports.isIllegalKey = isIllegalKey;
exports.isInRange = isInRange;
exports.isInt32 = isInt32;
exports.isIntString = isIntString;
exports.isIterable = isIterable;
exports.isMap = isMap;
exports.isMobile = isMobile;
exports.isNaN = isNaN;
exports.isNegative = isNegative;
exports.isNil = isNil;
exports.isNode = isNode;
exports.isNotStringAndIterable = isNotStringAndIterable;
exports.isNull = isNull;
exports.isNumber = isNumber;
exports.isNumeric = isNumeric;
exports.isNumericFloat = isNumericFloat;
exports.isNumericInt = isNumericInt;
exports.isObject = isObject;
exports.isOdd = isOdd;
exports.isPlainObject = isPlainObject;
exports.isPositive = isPositive;
exports.isPrimitive = isPrimitive;
exports.isPrintableASCII = isPrintableASCII;
exports.isPromise = isPromise;
exports.isPromiseLike = isPromiseLike;
exports.isProtoPath = isProtoPath;
exports.isRegExp = isRegExp;
exports.isSafari = isSafari;
exports.isSet = isSet;
exports.isString = isString;
exports.isSymbol = isSymbol;
exports.isTransferable = isTransferable;
exports.isTrue = isTrue;
exports.isTypedArray = isTypedArray;
exports.isUUID = isUUID;
exports.isUUIDv4 = isUUIDv4;
exports.isUint32 = isUint32;
exports.isUndefined = isUndefined;
exports.isZero = isZero;
