import { LogLevel } from "./api/logger";
export const NULL_LOGGER = Object.freeze({
    level: LogLevel.NONE,
    fine() { },
    debug() { },
    info() { },
    warn() { },
    severe() { },
});
export class ConsoleLogger {
    constructor(id, level = LogLevel.FINE) {
        this.id = id;
        this.level = level;
    }
    fine(...args) {
        this.level <= LogLevel.FINE && this.log("FINE", args);
    }
    debug(...args) {
        this.level <= LogLevel.DEBUG && this.log("DEBUG", args);
    }
    info(...args) {
        this.level <= LogLevel.INFO && this.log("INFO", args);
    }
    warn(...args) {
        this.level <= LogLevel.WARN && this.log("WARN", args);
    }
    severe(...args) {
        this.level <= LogLevel.SEVERE && this.log("SEVERE", args);
    }
    log(level, args) {
        console.log(`[${level}] ${this.id}:`, ...args);
    }
}
