"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OsvOffline = void 0;
const osv_offline_db_1 = require("@renovatebot/osv-offline-db");
const download_1 = require("./download");
class OsvOffline {
    osvOfflineDb;
    // eslint-disable-next-line @typescript-eslint/no-empty-function
    constructor() { }
    /**
     * Asynchronous code required as part of class instantiation
     */
    async initialize() {
        const result = await (0, download_1.tryDownloadDb)();
        if (!result.success) {
            throw result.error;
        }
        this.osvOfflineDb = await osv_offline_db_1.OsvOfflineDb.create();
    }
    /**
     * Asynchronously creates a new instance of {@link OsvOffline}
     * @returns A new instance of {@link OsvOffline}
     */
    static async create() {
        const instance = new OsvOffline();
        await instance.initialize();
        return instance;
    }
    /**
     * Query the local database for any package vulnerabilities
     * @param ecosystem The package ecosystem
     * @param packageName The package name
     * @returns An array of {@link Osv.Vulnerability} or an empty array if none are found
     */
    async getVulnerabilities(ecosystem, packageName) {
        return this.osvOfflineDb.query(ecosystem, packageName);
    }
}
exports.OsvOffline = OsvOffline;
