import { Ecosystem, Osv } from '@renovatebot/osv-offline-db';
export declare class OsvOffline {
    private osvOfflineDb;
    protected constructor();
    /**
     * Asynchronous code required as part of class instantiation
     */
    private initialize;
    /**
     * Asynchronously creates a new instance of {@link OsvOffline}
     * @returns A new instance of {@link OsvOffline}
     */
    static create(): Promise<OsvOffline>;
    /**
     * Query the local database for any package vulnerabilities
     * @param ecosystem The package ecosystem
     * @param packageName The package name
     * @returns An array of {@link Osv.Vulnerability} or an empty array if none are found
     */
    getVulnerabilities(ecosystem: Ecosystem, packageName: string): Promise<Osv.Vulnerability[]>;
}
