"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.packageToPurl = packageToPurl;
// https://github.com/google/osv.dev/blob/edacbd3c32b1d632bad8c5b506a14d0850b2e537/osv/purl_helpers.py#L18-L30
const PURL_ECOSYSTEMS = {
    'crates.io': 'cargo',
    Go: 'golang',
    Hackage: 'hackage',
    Hex: 'hex',
    Maven: 'maven',
    NuGet: 'nuget',
    npm: 'npm',
    Packagist: 'composer',
    PyPI: 'pypi',
    Pub: 'pub',
    RubyGems: 'gem',
};
function urlEncode(packageName) {
    const parts = packageName.split('/');
    return parts.map(encodeURIComponent).join('/');
}
function packageToPurl(ecosystem, packageName) {
    let packageNamePurl = packageName;
    const purlType = PURL_ECOSYSTEMS[ecosystem];
    if (purlType === 'maven') {
        packageNamePurl = packageName.replace(':', '/');
    }
    return `pkg:${purlType}/${urlEncode(packageNamePurl)}`;
}
