"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OsvOfflineDb = void 0;
const os_1 = require("os");
const path_1 = __importDefault(require("path"));
const nedb_1 = __importDefault(require("@seald-io/nedb"));
const ecosystem_1 = require("./ecosystem");
const purl_helper_1 = require("./purl-helper");
class OsvOfflineDb {
    static rootDirectory = process.env.OSV_OFFLINE_ROOT_DIR ?? path_1.default.join((0, os_1.tmpdir)(), 'osv-offline');
    db = {};
    // eslint-disable-next-line @typescript-eslint/no-empty-function
    constructor() { }
    async initialize() {
        for (const ecosystem of ecosystem_1.ecosystems) {
            this.db[ecosystem] = new nedb_1.default({
                filename: path_1.default.join(OsvOfflineDb.rootDirectory, `${ecosystem.toLowerCase()}.nedb`),
            });
            await this.db[ecosystem].loadDatabaseAsync();
        }
    }
    static async create() {
        const osvOfflineDb = new OsvOfflineDb();
        await osvOfflineDb.initialize();
        return osvOfflineDb;
    }
    async query(ecosystem, packageName) {
        return await this.db[ecosystem].findAsync({
            affected: {
                $elemMatch: {
                    package: {
                        name: packageName,
                        ecosystem,
                        purl: (0, purl_helper_1.packageToPurl)(ecosystem, packageName),
                    },
                },
            },
        });
    }
}
exports.OsvOfflineDb = OsvOfflineDb;
