// Generated by IcedCoffeeScript 112.8.1
var IV, WordArray, bufeq_secure, setup, split64, unwrap, wrap;

WordArray = require('triplesec').WordArray;

bufeq_secure = require('./util').bufeq_secure;

IV = WordArray.from_hex("A6A6A6A6A6A6A6A6");

split64 = function(wa) {
  return wa.split(wa.words.length >> 1);
};

exports.wrap = wrap = function(arg) {
  var A, AES, B, C, P, R, cipher, err, i, j, k, key, l, len, len1, m, plaintext, r, ref, t;
  plaintext = arg.plaintext, key = arg.key, cipher = arg.cipher;
  ref = setup({
    input: plaintext,
    key: key,
    cipher: cipher
  }), err = ref[0], P = ref[1], AES = ref[2];
  if (err != null) {
    throw err;
  }
  A = IV;
  R = P;
  t = new WordArray([0, 0]);
  for (j = k = 0; k < 6; j = ++k) {
    for (i = l = 0, len = R.length; l < len; i = ++l) {
      r = R[i];
      t.words[1]++;
      B = A.clone().concat(r);
      AES.encryptBlock(B.words);
      A = B.slice(0, 2);
      R[i] = B.slice(2, 4);
      A.xor(t, {});
    }
  }
  C = A;
  for (m = 0, len1 = R.length; m < len1; m++) {
    r = R[m];
    C.concat(r);
  }
  return C.to_buffer();
};

setup = function(arg) {
  var AES, K, P, a, b, cipher, err, input, key, klass;
  input = arg.input, key = arg.key, cipher = arg.cipher;
  P = split64(WordArray.from_buffer(input));
  K = WordArray.from_buffer(key);
  klass = cipher.klass;
  AES = new klass(K);
  err = null;
  if ((a = cipher.key_size) !== (b = key.length)) {
    err = new Error("Bad key, needed " + a + " bytes, but got " + b);
  }
  return [err, P, AES];
};

exports.unwrap = unwrap = function(arg) {
  var A, AES, B, C, P, R, cipher, ciphertext, err, i, j, k, key, l, len, m, n, r, ref, t;
  ciphertext = arg.ciphertext, key = arg.key, cipher = arg.cipher;
  ref = setup({
    input: ciphertext,
    key: key,
    cipher: cipher
  }), err = ref[0], C = ref[1], AES = ref[2], n = ref[3];
  if (err != null) {
    return [err, null];
  }
  A = C[0];
  R = C.slice(1);
  t = new WordArray([0, 6 * R.length]);
  for (j = k = 0; k < 6; j = ++k) {
    for (i = l = R.length - 1; l >= 0; i = l += -1) {
      r = R[i];
      A.xor(t, {});
      B = A.clone().concat(r);
      AES.decryptBlock(B.words);
      A = B.slice(0, 2);
      R[i] = B.slice(2, 4);
      t.words[1]--;
    }
  }
  if (A.equal(IV)) {
    P = new WordArray([]);
    for (m = 0, len = R.length; m < len; m++) {
      r = R[m];
      P.concat(r);
    }
    return [null, P.to_buffer()];
  } else {
    return [new Error("integrity check failure; got bad IV in decryption"), null];
  }
};

//# sourceMappingURL=rfc3394.js.map
