// Generated by IcedCoffeeScript 112.8.1
var BigInteger, Lock, MRF, MediumRandomFountain, SRF, StrongRandomFountain, WordArray, _mrf, _srf, iced, native_rng, prng, ref;

iced = require('iced-runtime-3');

BigInteger = require('bn').BigInteger;

ref = require('triplesec'), WordArray = ref.WordArray, prng = ref.prng;

native_rng = prng.native_rng;

Lock = require('iced-lock').Lock;

MediumRandomFountain = (function() {
  function MediumRandomFountain() {}

  MediumRandomFountain.prototype.nextBytes = function(v) {
    var b, c, i, j, len, results;
    b = native_rng(v.length);
    results = [];
    for (i = j = 0, len = b.length; j < len; i = ++j) {
      c = b[i];
      results.push(v[i] = c);
    }
    return results;
  };

  MediumRandomFountain.prototype.random_word = function() {
    return native_rng(4).readUInt32BE(0);
  };

  MediumRandomFountain.prototype.random_zn = function(n) {
    var i;
    while (true) {
      i = BigInteger.random_nbit(n.bitLength(), this);
      if (i.compareTo(BigInteger.ONE) > 0 && i.compareTo(n) < 0) {
        return i;
      }
    }
  };

  return MediumRandomFountain;

})();

_mrf = null;

MRF = function() {
  if (_mrf == null) {
    _mrf = new MediumRandomFountain();
  }
  return _mrf;
};

StrongRandomFountain = (function() {
  function StrongRandomFountain() {
    this.buf = null;
    this.lock = new Lock();
  }

  StrongRandomFountain.prototype.random_word = function(cb) {
    var __iced_it, __iced_passed_deferral, wa;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function*() {
      var __iced_deferrals;
      __iced_deferrals = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "StrongRandomFountain::random_word",
        filename: "/home/runner/work/kbpgp/kbpgp/src/rand.iced"
      });
      prng.generate(4, __iced_deferrals.defer({
        assign_fn: (function() {
          return function() {
            return wa = arguments[0];
          };
        })(),
        lineno: 49
      }));
      if (__iced_deferrals.await_exit()) {
        yield;
      }
      return cb(wa.to_buffer().readUInt32BE(0));
    })();
    __iced_it.next();
    return null;
  };

  StrongRandomFountain.prototype.random_double = function(cb) {
    var __iced_it, __iced_passed_deferral, wa;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function*() {
      var __iced_deferrals;
      __iced_deferrals = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "StrongRandomFountain::random_double",
        filename: "/home/runner/work/kbpgp/kbpgp/src/rand.iced"
      });
      prng.generate(8, __iced_deferrals.defer({
        assign_fn: (function() {
          return function() {
            return wa = arguments[0];
          };
        })(),
        lineno: 55
      }));
      if (__iced_deferrals.await_exit()) {
        yield;
      }
      return cb(wa.to_buffer().readDoubleBE(0));
    })();
    __iced_it.next();
    return null;
  };

  StrongRandomFountain.prototype.rand_0_1 = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var ret, w1, w2;
      return function*() {
        var __iced_deferrals, __iced_deferrals1;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "StrongRandomFountain::rand_0_1",
          filename: "/home/runner/work/kbpgp/kbpgp/src/rand.iced"
        });
        _this.random_word(__iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return w1 = arguments[0];
            };
          })(),
          lineno: 61
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "StrongRandomFountain::rand_0_1",
          filename: "/home/runner/work/kbpgp/kbpgp/src/rand.iced"
        });
        _this.random_word(__iced_deferrals1.defer({
          assign_fn: (function() {
            return function() {
              return w2 = arguments[0];
            };
          })(),
          lineno: 62
        }));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        ret = w1 * Math.pow(2, -32) + w2 * Math.pow(2, -64);
        return cb(ret);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  StrongRandomFountain.prototype.random_zn = function(n, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var go, ret;
      return function*() {
        var __iced_deferrals;
        go = true;
        ret = false;
        while (go) {
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "StrongRandomFountain::random_zn",
            filename: "/home/runner/work/kbpgp/kbpgp/src/rand.iced"
          });
          _this.random_nbit(n.bitLength(), __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return ret = arguments[0];
              };
            })(),
            lineno: 72
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
          go = (ret.compareTo(BigInteger.ONE) <= 0) || (ret.compareTo(n) >= 0);
        }
        return cb(ret);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  StrongRandomFountain.prototype.nextBytes = function(v) {
    var i, j, ref1, results;
    results = [];
    for (i = j = 0, ref1 = v.length; 0 <= ref1 ? j < ref1 : j > ref1; i = 0 <= ref1 ? ++j : --j) {
      results.push(v[i] = this.buf[i]);
    }
    return results;
  };

  StrongRandomFountain.prototype.random_word_array = function(nbytes, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var b, d, max_pull, n, ret;
      return function*() {
        var __iced_deferrals, __iced_deferrals1;
        ret = new WordArray();
        max_pull = 512;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "StrongRandomFountain::random_word_array",
          filename: "/home/runner/work/kbpgp/kbpgp/src/rand.iced"
        });
        _this.lock.acquire(__iced_deferrals.defer({
          lineno: 88
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        while ((d = nbytes - ret.sigBytes) > 0) {
          n = Math.min(max_pull, d);
          __iced_deferrals1 = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "StrongRandomFountain::random_word_array",
            filename: "/home/runner/work/kbpgp/kbpgp/src/rand.iced"
          });
          prng.generate(n, __iced_deferrals1.defer({
            assign_fn: (function() {
              return function() {
                return b = arguments[0];
              };
            })(),
            lineno: 91
          }));
          if (__iced_deferrals1.await_exit()) {
            yield;
          }
          ret = ret.concat(b);
        }
        _this.lock.release();
        return cb(ret);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  StrongRandomFountain.prototype.random_bytes = function(nbytes, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var tmp;
      return function*() {
        var __iced_deferrals;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "StrongRandomFountain::random_bytes",
          filename: "/home/runner/work/kbpgp/kbpgp/src/rand.iced"
        });
        _this.random_word_array(nbytes, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return tmp = arguments[0];
            };
          })(),
          lineno: 99
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        return cb(tmp.to_buffer());
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  StrongRandomFountain.prototype.random_nbit = function(nbits, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var nbytes, ret, tmp;
      return function*() {
        var __iced_deferrals, __iced_deferrals1;
        nbytes = (nbits >> 3) + 1;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "StrongRandomFountain::random_nbit",
          filename: "/home/runner/work/kbpgp/kbpgp/src/rand.iced"
        });
        _this.random_bytes(nbytes, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return tmp = arguments[0];
            };
          })(),
          lineno: 106
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "StrongRandomFountain::random_nbit",
          filename: "/home/runner/work/kbpgp/kbpgp/src/rand.iced"
        });
        _this.lock.acquire(__iced_deferrals1.defer({
          lineno: 107
        }));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        _this.buf = tmp;
        ret = BigInteger.random_nbit(nbits, _this);
        _this.lock.release();
        return cb(ret);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return StrongRandomFountain;

})();

_srf = null;

SRF = function() {
  if (_srf == null) {
    _srf = new StrongRandomFountain();
  }
  return _srf;
};

exports.MRF = MRF;

exports.SRF = SRF;

//# sourceMappingURL=rand.js.map
