// Generated by IcedCoffeeScript 112.8.1
var C, KeyBlock, Message, OPS, Warnings, armor, athrow, bufeq_secure, do_message, hashmod, iced, import_key_pgp, katch, konst, make_esc, parse, ref, unix_time, util, verify_clearsign, verify_detached;

iced = require('iced-runtime-3');

make_esc = require('iced-error').make_esc;

OPS = require('../keyfetch').OPS;

konst = require('../const');

C = konst.openpgp;

ref = require('../util'), katch = ref.katch, unix_time = ref.unix_time, athrow = ref.athrow, Warnings = ref.Warnings, bufeq_secure = ref.bufeq_secure;

parse = require('./parser').parse;

import_key_pgp = require('../symmetric').import_key_pgp;

util = require('util');

armor = require('./armor');

hashmod = require('../hash');

verify_clearsign = require('./clearsign').verify;

verify_detached = require('./detachsign').verify;

KeyBlock = (function() {
  function KeyBlock(packets1, opts) {
    this.packets = packets1;
    this.verified_signatures = [];
    this.subkeys = [];
    this.primary = null;
    this.userids = [];
    this.user_attributes = [];
    this.warnings = new Warnings();
    this.opts = opts || {};
    if (this.opts.strict == null) {
      this.opts.strict = true;
    }
  }

  KeyBlock.prototype.to_obj = function() {
    return {
      subkeys: this.subkeys,
      primary: this.primary,
      userids: this.userids
    };
  };

  KeyBlock.prototype._extract_keys = function() {
    var err, i, j, len, p, ref1;
    err = null;
    if (!this.packets.length) {
      err = new Error("No packets; cannot extract a key");
    } else if (!(this.primary = this.packets[0]).is_primary()) {
      err = new Error("First packet must be the primary key");
    } else {
      ref1 = this.packets.slice(1);
      for (i = j = 0, len = ref1.length; j < len; i = ++j) {
        p = ref1[i];
        if (p.is_key_material() && (err == null)) {
          if (p.key.is_toxic()) {
            this.warnings.push("Ignoring toxic subkey (ElGamal Encrypt+Sign)");
          } else if (!p.is_primary()) {
            this.subkeys.push(p);
          } else if (bufeq_secure(p.get_fingerprint(), this.primary.get_fingerprint())) {
            p.set_duplicate_primary();
          } else {
            err = new Error("cannot have 2 primary keys");
          }
        }
      }
    }
    return err;
  };

  KeyBlock.prototype._check_keys = function() {
    return this._check_primary() || this._check_subkeys();
  };

  KeyBlock.prototype._check_primary = function() {
    var err;
    return err = !this.primary.is_self_signed() ? new Error("no valid primary key self-signature or key(s) have expired") : (this.userids = this.primary.get_signed_userids()).length === 0 ? new Error("no valid Userid signed into key") : (this.user_attributes = this.primary.get_signed_user_attributes(), null);
  };

  KeyBlock.prototype._check_subkeys = function() {
    var err, i, j, k, len, msg, subkeys;
    subkeys = this.subkeys;
    err = null;
    this.subkeys = [];
    for (i = j = 0, len = subkeys.length; j < len; i = ++j) {
      k = subkeys[i];
      if (err == null) {
        if (k.is_signed_subkey_of(this.primary, this.opts)) {
          this.subkeys.push(k);
        } else {
          msg = "Subkey " + i + " was invalid; discarding";
          this.warnings.push(msg);
        }
      }
    }
    return err;
  };

  KeyBlock.prototype.process = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err;
      return function*() {
        var __iced_deferrals, ref1;
        err = _this._extract_keys();
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "KeyBlock::process",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
        });
        if (err == null) {
          _this._verify_sigs(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 87
          }));
        }
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        if ((ref1 = _this.opts) != null ? ref1.no_check_keys : void 0) {
          if (err == null) {
            _this.userids = _this.primary.get_signed_userids();
          }
        } else {
          if (err == null) {
            err = _this._check_keys();
          }
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  KeyBlock.prototype._get_issuer = function(i, packet, primary) {
    var fp, iid;
    if ((fp = packet.get_issuer_fingerprint()) != null) {
      return [fp, bufeq_secure(fp, this.primary.get_fingerprint()), this.primary.get_fingerprint()];
    }
    if ((iid = packet.get_issuer_key_id()) != null) {
      return [iid, bufeq_secure(iid, this.primary.get_key_id()), this.primary.get_key_id()];
    }
    this.warnings.push("Signature is missing an issuer (at packet=" + i + ")");
    return [null, false];
  };

  KeyBlock.prototype._verify_sigs = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, expected_ours, i, issuer_id, matches_ours, msg, n_sigs, p, tmp, working_set;
      return function*() {
        var __iced_deferrals, j, len, ref1, ref2;
        err = null;
        working_set = [];
        n_sigs = 0;
        ref1 = _this.packets.slice(1);
        for (i = j = 0, len = ref1.length; j < len; i = ++j) {
          p = ref1[i];
          if (!(err == null)) {
            continue;
          }
          if (!p.is_signature()) {
            if (n_sigs > 0) {
              n_sigs = 0;
              working_set = [];
            }
            if (!p.is_duplicate_primary()) {
              working_set.push(p);
            }
            continue;
          }
          n_sigs++;
          ref2 = _this._get_issuer(i, p, _this.primary), issuer_id = ref2[0], matches_ours = ref2[1], expected_ours = ref2[2];
          if (issuer_id != null) {
            if (!(matches_ours || p.type === C.sig_types.key_revocation)) {
              _this.warnings.push("Skipping signature by another issuer: " + (issuer_id != null ? issuer_id.toString('hex') : void 0) + " != " + (expected_ours != null ? expected_ours.toString('hex') : void 0));
              continue;
            }
            p.key = _this.primary.key;
            p.primary = _this.primary;
            p.is_third_party = !matches_ours;
            __iced_deferrals = new iced.Deferrals(__iced_it, {
              parent: __iced_passed_deferral,
              funcname: "KeyBlock::_verify_sigs",
              filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
            });
            p.verify(working_set, __iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  return tmp = arguments[0];
                };
              })(),
              lineno: 137
            }), _this.opts);
            if (__iced_deferrals.await_exit()) {
              yield;
            }
            if (tmp != null) {
              msg = "Signature failure in packet " + i + ": " + tmp.message + " (" + (issuer_id.toString('hex')) + ")";
              _this.warnings.push(msg);
            } else {
              _this.verified_signatures.push(p);
            }
          }
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return KeyBlock;

})();

Message = (function() {
  function Message(arg) {
    this.keyfetch = arg.keyfetch, this.data_fn = arg.data_fn, this.data = arg.data, this.strict = arg.strict, this.now = arg.now, this.assert_pgp_hash = arg.assert_pgp_hash;
    this.literals = [];
    this.enc_data_packet = null;
    this.warnings = new Warnings();
  }

  Message.prototype._get_session_key = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var enc, err, esk_packets, fingerprint, index, key_ids, key_material, km, p, packet, pkcs5, privk, sesskey;
      return function*() {
        var __iced_deferrals, __iced_deferrals1;
        key_ids = [];
        esk_packets = [];
        err = null;
        pkcs5 = false;
        key_ids = (function() {
          var results;
          results = [];
          while (this.packets.length && (p = this.packets[0].to_esk_packet())) {
            esk_packets.push(p);
            this.packets.shift();
            results.push(p.get_key_id());
          }
          return results;
        }).call(_this);
        if (key_ids.length) {
          enc = true;
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Message::_get_session_key",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
          });
          _this.keyfetch.fetch(key_ids, konst.ops.decrypt, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                km = arguments[1];
                return index = arguments[2];
              };
            })(),
            lineno: 178
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
          if (err == null) {
            packet = esk_packets[index];
            key_material = km.find_pgp_key_material(key_ids[index]);
            fingerprint = key_material.get_fingerprint();
            privk = key_material.key;
            __iced_deferrals1 = new iced.Deferrals(__iced_it, {
              parent: __iced_passed_deferral,
              funcname: "Message::_get_session_key",
              filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
            });
            privk.decrypt_and_unpad(packet.ekey, {
              fingerprint: fingerprint
            }, __iced_deferrals1.defer({
              assign_fn: (function() {
                return function() {
                  err = arguments[0];
                  sesskey = arguments[1];
                  return pkcs5 = arguments[2];
                };
              })(),
              lineno: 184
            }));
            if (__iced_deferrals1.await_exit()) {
              yield;
            }
            if (err == null) {
              _this.encryption_subkey = key_material;
            }
          }
        } else {
          enc = false;
        }
        return cb(err, enc, sesskey, pkcs5);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Message.prototype._find_encrypted_data = function(cb) {
    var err, ret;
    err = ret = null;
    if (this.packets.length && (ret = this.packets[0].to_enc_data_packet())) {
      this.packets.pop();
    } else {
      err = new Error("Could not find encrypted data packet");
    }
    return cb(err, ret);
  };

  Message.prototype._decrypt_with_session_key = function(sesskey, edat, pkcs5, cb) {
    var __iced_it, __iced_passed_deferral, cipher, err, ret;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function*() {
      var __iced_deferrals, ref1;
      ref1 = katch(function() {
        return import_key_pgp(sesskey, pkcs5);
      }), err = ref1[0], cipher = ref1[1];
      if (err == null) {
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Message::_decrypt_with_session_key",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
        });
        edat.decrypt({
          cipher: cipher
        }, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              err = arguments[0];
              return ret = arguments[1];
            };
          })(),
          lineno: 206
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
      }
      return cb(err, ret);
    })();
    __iced_it.next();
    return null;
  };

  Message.prototype._parse = function(raw, cb) {
    var err, packets, ref1;
    ref1 = parse(raw), err = ref1[0], packets = ref1[1];
    return cb(err, packets);
  };

  Message.prototype._decrypt = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var edat, esc, is_enc, packets, pkcs5, plaintext, sesskey;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, __iced_deferrals2, __iced_deferrals3;
        esc = make_esc(cb, "Message::decrypt");
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Message::_decrypt",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
        });
        _this._get_session_key(esc(__iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              is_enc = arguments[0];
              sesskey = arguments[1];
              return pkcs5 = arguments[2];
            };
          })(),
          lineno: 219
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        if (is_enc) {
          __iced_deferrals1 = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Message::_decrypt",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
          });
          _this._find_encrypted_data(esc(__iced_deferrals1.defer({
            assign_fn: (function() {
              return function() {
                return edat = arguments[0];
              };
            })(),
            lineno: 221
          })));
          if (__iced_deferrals1.await_exit()) {
            yield;
          }
          __iced_deferrals2 = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Message::_decrypt",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
          });
          _this._decrypt_with_session_key(sesskey, edat, pkcs5, esc(__iced_deferrals2.defer({
            assign_fn: (function() {
              return function() {
                return plaintext = arguments[0];
              };
            })(),
            lineno: 222
          })));
          if (__iced_deferrals2.await_exit()) {
            yield;
          }
          __iced_deferrals3 = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Message::_decrypt",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
          });
          _this._parse(plaintext, esc(__iced_deferrals3.defer({
            assign_fn: (function() {
              return function() {
                return packets = arguments[0];
              };
            })(),
            lineno: 223
          })));
          if (__iced_deferrals3.await_exit()) {
            yield;
          }
          _this.packets = packets.concat(_this.packets);
        }
        return cb(null);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Message.prototype._inflate = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var esc, inflated, p, packets;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, j, len, ref1;
        packets = [];
        esc = make_esc(cb, "Message::_inflate");
        ref1 = _this.packets;
        for (j = 0, len = ref1.length; j < len; j++) {
          p = ref1[j];
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Message::_inflate",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
          });
          p.inflate(esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return inflated = arguments[0];
              };
            })(),
            lineno: 233
          })));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
          if (inflated != null) {
            __iced_deferrals1 = new iced.Deferrals(__iced_it, {
              parent: __iced_passed_deferral,
              funcname: "Message::_inflate",
              filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
            });
            _this._parse(inflated, esc(__iced_deferrals1.defer({
              assign_fn: (function() {
                return function() {
                  return p = arguments[0];
                };
              })(),
              lineno: 235
            })));
            if (__iced_deferrals1.await_exit()) {
              yield;
            }
            packets.push.apply(packets, p);
          } else {
            packets.push(p);
          }
        }
        _this.packets = packets;
        return cb(null);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Message.prototype._frame_signatures = function() {
    var j, l, len, len1, o, p, payload, ref1, ret, stack;
    ret = [];
    stack = [];
    payload = [];
    ref1 = this.packets;
    for (j = 0, len = ref1.length; j < len; j++) {
      p = ref1[j];
      if (p.tag === C.packet_tags.one_pass_sig) {
        stack.push({
          open: p
        });
      } else if (!stack.length) {

      } else if (p.tag === C.packet_tags.signature) {
        o = stack.pop();
        o.close = p;
        ret.push(o);
      } else {
        payload.push(p);
      }
    }
    for (l = 0, len1 = ret.length; l < len1; l++) {
      o = ret[l];
      o.payload = payload;
    }
    return ret;
  };

  Message.prototype._verify_sig = function(sig, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var a, b, err, i, key_material, km;
      return function*() {
        var __iced_deferrals, __iced_deferrals1;
        err = null;
        if (!bufeq_secure((a = sig.open.key_id), (b = sig.close.get_key_id()))) {
          err = new Error("signature mismatch open v close: " + (a != null ? a.toString('hex') : void 0) + " != " + (b != null ? b.toString('hex') : void 0));
        }
        if (err == null) {
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Message::_verify_sig",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
          });
          _this.keyfetch.fetch([a], konst.ops.verify, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                km = arguments[1];
                return i = arguments[2];
              };
            })(),
            lineno: 274
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
          if (err != null) {
            err = new Error("Can't find a key for " + (a.toString('hex')) + ": " + err.message);
          }
        }
        if (err == null) {
          key_material = km.find_pgp_key_material(a);
          sig.close.key = key_material.key;
          sig.close.subkey_material = key_material;
          sig.close.key_manager = km;
          __iced_deferrals1 = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Message::_verify_sig",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
          });
          sig.close.verify(sig.payload, __iced_deferrals1.defer({
            assign_fn: (function() {
              return function() {
                return err = arguments[0];
              };
            })(),
            lineno: 289
          }), {
            now: _this.now,
            assert_pgp_hash: _this.assert_pgp_hash
          });
          if (__iced_deferrals1.await_exit()) {
            yield;
          }
        } else if (!_this.strict) {
          _this.warnings.push("Problem fetching key " + (a.toString('hex')) + ": " + (err.toString()));
          err = null;
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Message.prototype._verify = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var esc, sig, sigs;
      return function*() {
        var __iced_deferrals, j, len;
        esc = make_esc(cb, "Message::_verify_sigs");
        sigs = _this._frame_signatures();
        for (j = 0, len = sigs.length; j < len; j++) {
          sig = sigs[j];
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Message::_verify",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
          });
          _this._verify_sig(sig, esc(__iced_deferrals.defer({
            lineno: 303
          })));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
        }
        return cb(null);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Message.prototype.collect_literals = function() {
    var j, len, p, ref1, results;
    ref1 = this.packets;
    results = [];
    for (j = 0, len = ref1.length; j < len; j++) {
      p = ref1[j];
      if (p.tag === C.packet_tags.literal) {
        results.push(p);
      }
    }
    return results;
  };

  Message.prototype._process_generic = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, packets;
    packets = arg.packets;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var esc;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, __iced_deferrals2;
        _this.packets = packets;
        esc = make_esc(cb, "Message:process");
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Message::_process_generic",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
        });
        _this._decrypt(esc(__iced_deferrals.defer({
          lineno: 316
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Message::_process_generic",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
        });
        _this._inflate(esc(__iced_deferrals1.defer({
          lineno: 317
        })));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        __iced_deferrals2 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Message::_process_generic",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
        });
        _this._verify(esc(__iced_deferrals2.defer({
          lineno: 318
        })));
        if (__iced_deferrals2.await_exit()) {
          yield;
        }
        return cb(null, _this.collect_literals());
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Message.prototype._verify_clearsign = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, clearsign, packets;
    packets = arg.packets, clearsign = arg.clearsign;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, literal;
      return function*() {
        var __iced_deferrals;
        if (clearsign == null) {
          err = new Error("no clearsign data found");
        } else {
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Message::_verify_clearsign",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
          });
          verify_clearsign({
            packets: packets,
            clearsign: clearsign,
            keyfetch: _this.keyfetch,
            now: _this.now,
            assert_pgp_hash: _this.assert_pgp_hash
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return literal = arguments[1];
              };
            })(),
            lineno: 327
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
        }
        return cb(err, [literal]);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Message.prototype.parse_and_inflate = function(body, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var esc;
      return function*() {
        var __iced_deferrals, __iced_deferrals1;
        esc = make_esc(cb, "Message::parse_and_inflate");
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Message::parse_and_inflate",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
        });
        _this._parse(body, esc(__iced_deferrals.defer({
          assign_fn: (function(__slot_1) {
            return function() {
              return __slot_1.packets = arguments[0];
            };
          })(_this),
          lineno: 334
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Message::parse_and_inflate",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
        });
        _this._inflate(esc(__iced_deferrals1.defer({
          lineno: 335
        })));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        return cb(null, _this.collect_literals());
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Message.prototype.parse_and_process = function(msg, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var esc, literals, packets;
      return function*() {
        var __iced_deferrals, __iced_deferrals1;
        esc = make_esc(cb, "Message::parse_and_process");
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Message::parse_and_process",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
        });
        _this._parse(msg.body, esc(__iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return packets = arguments[0];
            };
          })(),
          lineno: 342
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Message::parse_and_process",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
        });
        _this._process({
          msg: msg,
          packets: packets
        }, esc(__iced_deferrals1.defer({
          assign_fn: (function() {
            return function() {
              return literals = arguments[0];
            };
          })(),
          lineno: 343
        })));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        return cb(null, literals);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Message.prototype._verify_signature = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, packets;
    packets = arg.packets;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, literals;
      return function*() {
        var __iced_deferrals;
        if (!((_this.data != null) || (_this.data_fn != null))) {
          err = new Error("Cannot verify detached signature without data input");
        } else {
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Message::_verify_signature",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
          });
          verify_detached({
            packets: packets,
            data: _this.data,
            data_fn: _this.data_fn,
            keyfetch: _this.keyfetch,
            now: _this.now,
            assert_pgp_hash: _this.assert_pgp_hash
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return literals = arguments[1];
              };
            })(),
            lineno: 352
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
        }
        return cb(err, literals);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Message.prototype._process = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, msg, packets;
    msg = arg.msg, packets = arg.packets;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, literals;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, __iced_deferrals2;
        msg.type || (msg.type = C.message_types.generic);
        switch (msg.type) {
          case C.message_types.generic:
            __iced_deferrals = new iced.Deferrals(__iced_it, {
              parent: __iced_passed_deferral,
              funcname: "Message::_process",
              filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
            });
            _this._process_generic({
              packets: packets
            }, __iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  err = arguments[0];
                  return literals = arguments[1];
                };
              })(),
              lineno: 361
            }));
            if (__iced_deferrals.await_exit()) {
              yield;
            }
            break;
          case C.message_types.clearsign:
            __iced_deferrals1 = new iced.Deferrals(__iced_it, {
              parent: __iced_passed_deferral,
              funcname: "Message::_process",
              filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
            });
            _this._verify_clearsign({
              packets: packets,
              clearsign: msg.clearsign
            }, __iced_deferrals1.defer({
              assign_fn: (function() {
                return function() {
                  err = arguments[0];
                  return literals = arguments[1];
                };
              })(),
              lineno: 363
            }));
            if (__iced_deferrals1.await_exit()) {
              yield;
            }
            break;
          case C.message_types.signature:
            __iced_deferrals2 = new iced.Deferrals(__iced_it, {
              parent: __iced_passed_deferral,
              funcname: "Message::_process",
              filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
            });
            _this._verify_signature({
              packets: packets
            }, __iced_deferrals2.defer({
              assign_fn: (function() {
                return function() {
                  err = arguments[0];
                  return literals = arguments[1];
                };
              })(),
              lineno: 365
            }));
            if (__iced_deferrals2.await_exit()) {
              yield;
            }
            break;
          default:
            err = new Error("Needed a 'generic', 'clearsign', or 'signature' PGP message, got " + msg.type);
        }
        return cb(err, literals);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return Message;

})();

exports.KeyBlock = KeyBlock;

exports.Message = Message;

exports.do_message = do_message = function(arg, cb) {
  var __iced_it, __iced_passed_deferral, armored, data, data_fn, err, esk, keyfetch, literals, msg, msg_type, now, proc, raw, strict, warnings;
  armored = arg.armored, raw = arg.raw, msg_type = arg.msg_type, keyfetch = arg.keyfetch, data_fn = arg.data_fn, data = arg.data, strict = arg.strict, now = arg.now;
  __iced_passed_deferral = iced.findDeferral(arguments);
  __iced_it = (function*() {
    var __iced_deferrals, ref1;
    literals = null;
    err = msg = warnings = esk = null;
    if (armored != null) {
      ref1 = armor.decode(armored), err = ref1[0], msg = ref1[1];
    } else if (raw != null) {
      msg_type || (msg_type = C.message_types.generic);
      msg = {
        body: raw,
        type: msg_type
      };
    } else {
      err = new Error("No input to do_message; need either 'armored' or 'raw' input");
    }
    if (err == null) {
      if (strict == null) {
        strict = true;
      }
      proc = new Message({
        keyfetch: keyfetch,
        data_fn: data_fn,
        data: data,
        strict: strict,
        now: now
      });
      __iced_deferrals = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "do_message",
        filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/processor.iced"
      });
      proc.parse_and_process(msg, __iced_deferrals.defer({
        assign_fn: (function() {
          return function() {
            err = arguments[0];
            return literals = arguments[1];
          };
        })(),
        lineno: 413
      }));
      if (__iced_deferrals.await_exit()) {
        yield;
      }
      warnings = proc.warnings;
      esk = proc.encryption_subkey;
    }
    return cb(err, literals, warnings, esk);
  })();
  __iced_it.next();
  return null;
};

//# sourceMappingURL=processor.js.map
