// Generated by IcedCoffeeScript 112.8.1
var C, Compressed, CompressionParser, Packet, asymmetric, bzipDeflate, bzip_inflate, fake_zip_inflate, fix_zip_deflate, iced, uint_to_buffer, zlib,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

iced = require('iced-runtime-3');

Packet = require('./base').Packet;

C = require('../../const').openpgp;

asymmetric = require('../../asymmetric');

zlib = require('zlib');

uint_to_buffer = require('../../util').uint_to_buffer;

bzipDeflate = require('bzip-deflate');

fake_zip_inflate = function(buf, cb) {
  var __iced_it, __iced_passed_deferral, bufs, call_end, err, inflater;
  __iced_passed_deferral = iced.findDeferral(arguments);
  __iced_it = (function*() {
    var __iced_deferrals, __iced_deferrals1;
    buf = Buffer.concat([Buffer.from([0x78, 0x9c]), buf]);
    inflater = zlib.createInflate({
      flush: zlib.Z_FULL_FLUSH
    });
    bufs = [];
    call_end = function(err) {
      var ret, tmp;
      if ((tmp = cb) != null) {
        if ((err != null) && err.code === "Z_BUF_ERROR") {
          err = null;
        }
        cb = null;
        if (err != null) {
          ret = null;
        } else {
          ret = Buffer.concat(bufs);
        }
        return tmp(err, ret);
      }
    };
    inflater.on('readable', function() {
      var read_buf;
      read_buf = inflater.read();
      if (read_buf != null) {
        return bufs.push(read_buf);
      }
    });
    inflater.on('end', function() {
      return call_end(null);
    });
    inflater.on('error', function(e) {
      return call_end(e);
    });
    __iced_deferrals = new iced.Deferrals(__iced_it, {
      parent: __iced_passed_deferral,
      funcname: "fake_zip_inflate",
      filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/compressed.iced"
    });
    inflater.write(buf, __iced_deferrals.defer({
      assign_fn: (function() {
        return function() {
          return err = arguments[0];
        };
      })(),
      lineno: 53
    }));
    if (__iced_deferrals.await_exit()) {
      yield;
    }
    if (err == null) {
      __iced_deferrals1 = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "fake_zip_inflate",
        filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/compressed.iced"
      });
      inflater.end(err);
      if (__iced_deferrals1.await_exit()) {
        yield;
      }
    }
    if (err != null) {
      return call_end(err);
    }
  })();
  __iced_it.next();
  return null;
};

fix_zip_deflate = function(buf, cb) {
  var __iced_it, __iced_passed_deferral, err, ret;
  __iced_passed_deferral = iced.findDeferral(arguments);
  __iced_it = (function*() {
    var __iced_deferrals;
    __iced_deferrals = new iced.Deferrals(__iced_it, {
      parent: __iced_passed_deferral,
      funcname: "fix_zip_deflate",
      filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/compressed.iced"
    });
    zlib.deflate(buf, __iced_deferrals.defer({
      assign_fn: (function() {
        return function() {
          err = arguments[0];
          return ret = arguments[1];
        };
      })(),
      lineno: 62
    }));
    if (__iced_deferrals.await_exit()) {
      yield;
    }
    return cb(err, ret);
  })();
  __iced_it.next();
  return null;
};

bzip_inflate = function(buf, cb) {
  var e, err, ret;
  err = null;
  try {
    ret = bzipDeflate(buf);
  } catch (error) {
    e = error;
    err = e;
  }
  return cb(err, ret);
};

Compressed = (function(superClass) {
  extend(Compressed, superClass);

  function Compressed(arg) {
    this.algo = arg.algo, this.compressed = arg.compressed, this.inflated = arg.inflated;
  }

  Compressed.parse = function(slice) {
    return (new CompressionParser(slice)).parse();
  };

  Compressed.prototype.inflate = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, ret;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, __iced_deferrals2;
        err = ret = null;
        switch (_this.algo) {
          case C.compression.none:
            ret = _this.compressed;
            break;
          case C.compression.zlib:
            __iced_deferrals = new iced.Deferrals(__iced_it, {
              parent: __iced_passed_deferral,
              funcname: "Compressed::inflate",
              filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/compressed.iced"
            });
            zlib.inflate(_this.compressed, __iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  err = arguments[0];
                  return ret = arguments[1];
                };
              })(),
              lineno: 95
            }));
            if (__iced_deferrals.await_exit()) {
              yield;
            }
            break;
          case C.compression.zip:
            __iced_deferrals1 = new iced.Deferrals(__iced_it, {
              parent: __iced_passed_deferral,
              funcname: "Compressed::inflate",
              filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/compressed.iced"
            });
            fake_zip_inflate(_this.compressed, __iced_deferrals1.defer({
              assign_fn: (function() {
                return function() {
                  err = arguments[0];
                  return ret = arguments[1];
                };
              })(),
              lineno: 97
            }));
            if (__iced_deferrals1.await_exit()) {
              yield;
            }
            break;
          case C.compression.bzip:
            __iced_deferrals2 = new iced.Deferrals(__iced_it, {
              parent: __iced_passed_deferral,
              funcname: "Compressed::inflate",
              filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/compressed.iced"
            });
            bzip_inflate(_this.compressed, __iced_deferrals2.defer({
              assign_fn: (function() {
                return function() {
                  err = arguments[0];
                  return ret = arguments[1];
                };
              })(),
              lineno: 99
            }));
            if (__iced_deferrals2.await_exit()) {
              yield;
            }
            break;
          default:
            err = new Error("no known inflation -- algo: " + _this.algo);
        }
        return cb(err, ret);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Compressed.prototype.deflate = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, ret;
      return function*() {
        var __iced_deferrals, __iced_deferrals1;
        err = ret = null;
        switch (_this.algo) {
          case C.compression.none:
            ret = _this.inflated;
            break;
          case C.compression.zlib:
            __iced_deferrals = new iced.Deferrals(__iced_it, {
              parent: __iced_passed_deferral,
              funcname: "Compressed::deflate",
              filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/compressed.iced"
            });
            zlib.deflate(_this.inflated, __iced_deferrals.defer({
              assign_fn: (function() {
                return function() {
                  err = arguments[0];
                  return ret = arguments[1];
                };
              })(),
              lineno: 111
            }));
            if (__iced_deferrals.await_exit()) {
              yield;
            }
            break;
          case C.compression.zip:
            __iced_deferrals1 = new iced.Deferrals(__iced_it, {
              parent: __iced_passed_deferral,
              funcname: "Compressed::deflate",
              filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/compressed.iced"
            });
            fake_zip_deflate(_this.inflated, __iced_deferrals1.defer({
              assign_fn: (function() {
                return function() {
                  err = arguments[0];
                  return ret = arguments[1];
                };
              })(),
              lineno: 113
            }));
            if (__iced_deferrals1.await_exit()) {
              yield;
            }
            break;
          default:
            err = new Error("no known deflation -- algo: " + _this.algo);
        }
        return cb(err, ret);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Compressed.prototype.write_unframed = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var bufs, err, ret;
      return function*() {
        var __iced_deferrals;
        err = ret = null;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Compressed::write_unframed",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/compressed.iced"
        });
        _this.deflate(__iced_deferrals.defer({
          assign_fn: (function(__slot_1) {
            return function() {
              err = arguments[0];
              return __slot_1.compressed = arguments[1];
            };
          })(_this),
          lineno: 122
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        if (err == null) {
          bufs = [uint_to_buffer(8, _this.algo), _this.compressed];
          ret = Buffer.concat(bufs);
        }
        return cb(err, ret);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Compressed.prototype.write = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, ret, unframed;
      return function*() {
        var __iced_deferrals;
        err = ret = null;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Compressed::write",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/packet/compressed.iced"
        });
        _this.write_unframed(__iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              err = arguments[0];
              return unframed = arguments[1];
            };
          })(),
          lineno: 132
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        if (err == null) {
          ret = _this.frame_packet(C.packet_tags.compressed, unframed);
        }
        return cb(err, ret);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return Compressed;

})(Packet);

CompressionParser = (function() {
  function CompressionParser(slice1) {
    this.slice = slice1;
  }

  CompressionParser.prototype.parse = function() {
    var algo, compressed;
    algo = this.slice.read_uint8();
    compressed = this.slice.consume_rest_to_buffer();
    return new Compressed({
      algo: algo,
      compressed: compressed
    });
  };

  return CompressionParser;

})();

exports.Compressed = Compressed;

//# sourceMappingURL=compressed.js.map
