// Generated by IcedCoffeeScript 112.8.1
var AES, ASP, Base, Decryptor, Encryptor, SlicerBuffer, WordArray, decrypt, encrypt, iced, make_esc, repeat, rng, test, triplesec,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

iced = require('iced-runtime-3');

WordArray = require('triplesec').WordArray;

SlicerBuffer = require('./buffer').SlicerBuffer;

triplesec = require('triplesec');

AES = triplesec.ciphers.AES;

ASP = require('pgp-utils').util.ASP;

make_esc = require('iced-error').make_esc;

repeat = function(b, n) {
  return Buffer.concat([b, b.slice(b.length - n)]);
};

Base = (function() {
  function Base(arg) {
    var asp, key;
    this.block_cipher_class = arg.block_cipher_class, key = arg.key, this.cipher = arg.cipher, this.resync = arg.resync, asp = arg.asp;
    this.block_cipher_class || (this.block_cipher_class = AES);
    this.cipher || (this.cipher = new this.block_cipher_class(WordArray.from_buffer(key)));
    this.block_size = this.cipher.blockSize;
    this.out_bufs = [];
    this.asp = ASP.make(asp);
  }

  Base.prototype.compact = function() {
    var b;
    b = Buffer.concat(this.out_bufs);
    this.out_bufs = [b];
    return b;
  };

  return Base;

})();

Encryptor = (function(superClass) {
  extend(Encryptor, superClass);

  function Encryptor(arg) {
    var asp, block_cipher_class, cipher, key, prefixrandom, resync;
    block_cipher_class = arg.block_cipher_class, key = arg.key, cipher = arg.cipher, prefixrandom = arg.prefixrandom, resync = arg.resync, asp = arg.asp;
    Encryptor.__super__.constructor.call(this, {
      block_cipher_class: block_cipher_class,
      key: key,
      cipher: cipher,
      resync: resync,
      asp: asp
    });
    this._init(prefixrandom);
  }

  Encryptor.prototype._enc = function() {
    this.FRE = WordArray.from_buffer(this.FR);
    return this.cipher.encryptBlock(this.FRE.words, 0);
  };

  Encryptor.prototype._emit_sb = function(sb) {
    var buf, deficit, i, pad;
    buf = (deficit = this.block_size - sb.rem()) > 0 ? (pad = Buffer.from((function() {
      var k, ref, results;
      results = [];
      for (i = k = 0, ref = deficit; 0 <= ref ? k < ref : k > ref; i = 0 <= ref ? ++k : --k) {
        results.push(0);
      }
      return results;
    })()), Buffer.concat([sb.consume_rest_to_buffer(), pad])) : sb.read_buffer(this.block_size);
    return this._emit_buf(buf);
  };

  Encryptor.prototype._emit_buf = function(buf) {
    var wa;
    wa = WordArray.from_buffer(buf.slice(0, this.block_size));
    wa.xor(this.FRE, {
      n_words: Math.min(wa.words.length, this.FRE.words.length)
    });
    buf = wa.to_buffer();
    this.out_bufs.push(buf);
    return this.FR = Buffer.from(buf);
  };

  Encryptor.prototype._init = function(prefixrandom) {
    var b, canary, ct, i, offset;
    this.FR = Buffer.from((function() {
      var k, ref, results;
      results = [];
      for (i = k = 0, ref = this.block_size; 0 <= ref ? k < ref : k > ref; i = 0 <= ref ? ++k : --k) {
        results.push(0);
      }
      return results;
    }).call(this));
    prefixrandom = repeat(prefixrandom, 2);
    this._enc();
    this._emit_buf(prefixrandom);
    this._enc();
    b = this.FRE.to_buffer();
    canary = Buffer.from((function() {
      var k, results;
      results = [];
      for (i = k = 0; k < 2; i = ++k) {
        results.push(b.readUInt8(i) ^ prefixrandom.readUInt8(this.block_size + i));
      }
      return results;
    }).call(this));
    this.out_bufs.push(canary);
    offset = this.resync ? 2 : 0;
    ct = this.compact();
    ct.copy(this.FR, 0, offset, offset + this.block_size);
    return this._enc();
  };

  Encryptor.prototype.enc = function(plaintext, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var buf, ct, esc, j, n_wanted, ret, sb, total, wa;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, k;
        sb = new SlicerBuffer(plaintext);
        esc = make_esc(cb, "Encryptor::enc");
        if (_this.resync) {
          _this._emit_sb(sb);
        } else {
          buf = Buffer.concat([Buffer.from([0, 0]), sb.read_buffer(_this.block_size - 2)]);
          wa = WordArray.from_buffer(buf);
          wa.xor(_this.FRE, {});
          buf = wa.to_buffer().slice(2);
          _this.out_bufs.push(buf);
          ct = _this.compact();
          ct.copy(_this.FR, 0, ct.length - _this.block_size, ct.length);
        }
        total = sb.rem();
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Encryptor::enc",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/ocfb.iced"
        });
        _this.asp.progress({
          what: "ofcb encryption",
          i: 0,
          total: total
        }, esc(__iced_deferrals.defer({
          lineno: 168
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        while ((j = sb.rem())) {
          for (k = 0; k < 4096; k++) {
            _this._enc();
            _this._emit_sb(sb);
            if (!(j = sb.rem())) {
              break;
            }
          }
          __iced_deferrals1 = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Encryptor::enc",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/ocfb.iced"
          });
          _this.asp.progress({
            what: "ofcb encryption",
            i: total - j,
            total: total
          }, esc(__iced_deferrals1.defer({
            lineno: 177
          })));
          if (__iced_deferrals1.await_exit()) {
            yield;
          }
        }
        ret = _this.compact();
        n_wanted = plaintext.length + _this.block_size + 2;
        ret = ret.slice(0, n_wanted);
        return cb(null, ret);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return Encryptor;

})(Base);

Decryptor = (function(superClass) {
  extend(Decryptor, superClass);

  function Decryptor(arg) {
    var asp, block_cipher_class, cipher, key, prefixrandom, resync;
    block_cipher_class = arg.block_cipher_class, key = arg.key, cipher = arg.cipher, prefixrandom = arg.prefixrandom, resync = arg.resync, this.ciphertext = arg.ciphertext, asp = arg.asp;
    Decryptor.__super__.constructor.call(this, {
      block_cipher_class: block_cipher_class,
      key: key,
      cipher: cipher,
      resync: resync,
      asp: asp
    });
    this._init();
  }

  Decryptor.prototype._init = function() {
    return this.reset();
  };

  Decryptor.prototype.reset = function() {
    return this.sb = new SlicerBuffer(this.ciphertext);
  };

  Decryptor.prototype.next_block = function() {
    return WordArray.from_buffer(this.sb.read_buffer_at_most(this.block_size));
  };

  Decryptor.prototype.get_prefix = function() {
    return this._prefix;
  };

  Decryptor.prototype.check = function(cb) {
    var ablock, err, i, iblock, lhs, rhs;
    this.reset();
    iblock = new WordArray((function() {
      var k, ref, results;
      results = [];
      for (i = k = 0, ref = this.block_size / 4; 0 <= ref ? k < ref : k > ref; i = 0 <= ref ? ++k : --k) {
        results.push(0);
      }
      return results;
    }).call(this));
    this.cipher.encryptBlock(iblock.words, 0);
    ablock = this.next_block();
    iblock.xor(ablock, {});
    this._prefix = iblock.to_buffer();
    this.cipher.encryptBlock(ablock.words, 0);
    lhs = iblock.words.slice(-1)[0] & 0xffff;
    rhs = (ablock.words[0] >>> 16) ^ (this.sb.peek_uint16());
    err = lhs === rhs ? null : new Error("Canary block mismatch: " + lhs + " != " + rhs);
    return cb(err);
  };

  Decryptor.prototype.dec = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var ablock, esc, iblock, j, out, total;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, k;
        _this.reset();
        if (_this.resync) {
          _this.sb.advance(2);
        }
        iblock = _this.next_block();
        esc = make_esc(cb, "Decryption::dec");
        total = _this.sb.rem();
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Decryptor::dec",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/ocfb.iced"
        });
        _this.asp.progress({
          what: "ofcb decrypt",
          i: 0,
          total: total
        }, esc(__iced_deferrals.defer({
          lineno: 239
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        while ((j = _this.sb.rem())) {
          for (k = 0; k < 4096; k++) {
            ablock = iblock;
            _this.cipher.encryptBlock(ablock.words, 0);
            iblock = _this.next_block();
            ablock.xor(iblock, {});
            _this.out_bufs.push(ablock.to_buffer().slice(0, iblock.sigBytes));
            if (!(j = _this.sb.rem())) {
              break;
            }
          }
          __iced_deferrals1 = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Decryptor::dec",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/ocfb.iced"
          });
          _this.asp.progress({
            what: "ofcb decrypt",
            i: total - j,
            total: total
          }, esc(__iced_deferrals1.defer({
            lineno: 251
          })));
          if (__iced_deferrals1.await_exit()) {
            yield;
          }
        }
        out = _this.compact();
        if (!_this.resync) {
          out = out.slice(2);
        }
        return cb(null, out);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return Decryptor;

})(Base);

encrypt = function(arg, cb) {
  var asp, block_cipher_class, cipher, eng, key, plaintext, prefixrandom, resync;
  block_cipher_class = arg.block_cipher_class, key = arg.key, cipher = arg.cipher, prefixrandom = arg.prefixrandom, resync = arg.resync, plaintext = arg.plaintext, asp = arg.asp;
  eng = new Encryptor({
    block_cipher_class: block_cipher_class,
    key: key,
    cipher: cipher,
    prefixrandom: prefixrandom,
    resync: resync,
    asp: asp
  });
  return eng.enc(plaintext, cb);
};

decrypt = function(arg, cb) {
  var __iced_it, __iced_passed_deferral, asp, block_cipher_class, cipher, ciphertext, eng, err, key, pt, resync;
  block_cipher_class = arg.block_cipher_class, key = arg.key, cipher = arg.cipher, resync = arg.resync, ciphertext = arg.ciphertext, asp = arg.asp;
  __iced_passed_deferral = iced.findDeferral(arguments);
  __iced_it = (function*() {
    var __iced_deferrals, __iced_deferrals1;
    eng = new Decryptor({
      block_cipher_class: block_cipher_class,
      key: key,
      cipher: cipher,
      resync: resync,
      ciphertext: ciphertext,
      asp: asp
    });
    __iced_deferrals = new iced.Deferrals(__iced_it, {
      parent: __iced_passed_deferral,
      funcname: "decrypt",
      filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/ocfb.iced"
    });
    eng.check(__iced_deferrals.defer({
      assign_fn: (function() {
        return function() {
          return err = arguments[0];
        };
      })(),
      lineno: 267
    }));
    if (__iced_deferrals.await_exit()) {
      yield;
    }
    __iced_deferrals1 = new iced.Deferrals(__iced_it, {
      parent: __iced_passed_deferral,
      funcname: "decrypt",
      filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/ocfb.iced"
    });
    if (err == null) {
      eng.dec(__iced_deferrals1.defer({
        assign_fn: (function() {
          return function() {
            err = arguments[0];
            return pt = arguments[1];
          };
        })(),
        lineno: 268
      }));
    }
    if (__iced_deferrals1.await_exit()) {
      yield;
    }
    return cb(err, pt);
  })();
  __iced_it.next();
  return null;
};

exports.encrypt = encrypt;

exports.decrypt = decrypt;

exports.Decryptor = Decryptor;

rng = require('crypto').rng;

test = function() {
  var block_cipher_class, ct, key, plaintext, prefixrandom, pt;
  plaintext = Buffer.from("a man a plan a canal panama. and you know the rest");
  key = rng(32);
  prefixrandom = Buffer.from([0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]);
  block_cipher_class = AES;
  ct = encrypt({
    block_cipher_class: block_cipher_class,
    key: key,
    prefixrandom: prefixrandom,
    plaintext: plaintext
  });
  console.log(ct.toString('hex'));
  pt = decrypt({
    block_cipher_class: block_cipher_class,
    key: key,
    prefixrandom: prefixrandom,
    ciphertext: ct
  });
  return console.log(pt.toString('utf8'));
};

//# sourceMappingURL=ocfb.js.map
