// Generated by IcedCoffeeScript 112.8.1
var BaseBurner, Burner, C, Compressed, CreationTime, Issuer, Literal, OnePassSignature, PKESK, SEIPD, SHA512, SRF, Signature, WordArray, clearsign, detachsign, dummy_key_id, encode, export_key_pgp, get_cipher, iced, make_esc, make_simple_literals, ref, ref1, ref2, scrub_buffer, triplesec, unix_time,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

iced = require('iced-runtime-3');

make_esc = require('iced-error').make_esc;

OnePassSignature = require('./packet/one_pass_sig').OnePassSignature;

ref = require('./packet/signature'), Signature = ref.Signature, CreationTime = ref.CreationTime, Issuer = ref.Issuer;

Compressed = require('./packet/compressed').Compressed;

Literal = require('./packet/literal').Literal;

unix_time = require('../util').unix_time;

SRF = require('../rand').SRF;

triplesec = require('triplesec');

ref1 = require('../symmetric'), export_key_pgp = ref1.export_key_pgp, get_cipher = ref1.get_cipher;

scrub_buffer = triplesec.util.scrub_buffer;

WordArray = triplesec.WordArray;

ref2 = require('./packet/sess'), SEIPD = ref2.SEIPD, PKESK = ref2.PKESK;

C = require('../const').openpgp;

SHA512 = require('../hash').SHA512;

encode = require('./armor').encode;

clearsign = require('./clearsign');

detachsign = require('./detachsign');

BaseBurner = require('./baseburner').BaseBurner;

dummy_key_id = Buffer.from((function() {
  var i, results;
  results = [];
  for (i = 0; i < 16; i++) {
    results.push(0);
  }
  return results;
})());

Burner = (function(superClass) {
  extend(Burner, superClass);

  function Burner(arg) {
    var asp, encrypt_for, encryption_key, sign_with, signing_key;
    this.literals = arg.literals, this.opts = arg.opts, sign_with = arg.sign_with, encrypt_for = arg.encrypt_for, signing_key = arg.signing_key, encryption_key = arg.encryption_key, asp = arg.asp;
    Burner.__super__.constructor.call(this, {
      sign_with: sign_with,
      encrypt_for: encrypt_for,
      signing_key: signing_key,
      encryption_key: encryption_key,
      asp: asp
    });
    this.packets = [];
    this.opts || (this.opts = {});
    this.signed_payload = null;
  }

  Burner.prototype._frame_literals = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var esc, l, p, sp;
      return function*() {
        var __iced_deferrals, i, len, ref3;
        esc = make_esc(cb, "Burner::_frame_literals");
        sp = [];
        ref3 = _this.literals;
        for (i = 0, len = ref3.length; i < len; i++) {
          l = ref3[i];
          sp.push(l.to_signature_payload());
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Burner::_frame_literals",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
          });
          l.write(esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return p = arguments[0];
              };
            })(),
            lineno: 51
          })));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
          _this.packets.push(p);
        }
        _this.signed_payload = Buffer.concat(sp);
        return cb(null);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Burner.prototype._sign = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var esc, fp, hasher, ops, ops_framed, sig;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, __iced_deferrals2, __iced_deferrals3, ref3, ref4, ref5;
        esc = make_esc(cb, "Burner::_sign");
        hasher = (ref3 = (ref4 = _this.opts) != null ? ref4.hasher : void 0) != null ? ref3 : SHA512;
        ops = new OnePassSignature({
          sig_type: C.sig_types.binary_doc,
          hasher: hasher,
          sig_klass: _this.signing_key.get_klass(),
          key_id: _this.signing_key.get_key_id(),
          is_final: 1
        });
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Burner::_sign",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
        });
        ops.write(esc(__iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return ops_framed = arguments[0];
            };
          })(),
          lineno: 68
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        sig = new Signature({
          type: C.sig_types.binary_doc,
          hasher: hasher,
          key: _this.signing_key.key,
          hashed_subpackets: [new CreationTime(((ref5 = _this.opts) != null ? ref5.now : void 0) || unix_time())],
          unhashed_subpackets: [new Issuer(_this.signing_key.get_key_id())]
        });
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Burner::_sign",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
        });
        _this.asp.progress({
          what: 'sign',
          i: 0,
          total: 1
        }, esc(__iced_deferrals1.defer({
          lineno: 76
        })));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        __iced_deferrals2 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Burner::_sign",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
        });
        sig.write(_this.signed_payload, esc(__iced_deferrals2.defer({
          assign_fn: (function() {
            return function() {
              return fp = arguments[0];
            };
          })(),
          lineno: 77
        })));
        if (__iced_deferrals2.await_exit()) {
          yield;
        }
        __iced_deferrals3 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Burner::_sign",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
        });
        _this.asp.progress({
          what: 'sign',
          i: 1,
          total: 1
        }, esc(__iced_deferrals3.defer({
          lineno: 78
        })));
        if (__iced_deferrals3.await_exit()) {
          yield;
        }
        _this.packets.unshift(ops_framed);
        _this.packets.push(fp);
        return cb(null);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Burner.prototype.collect_packets = function() {
    var ret;
    ret = Buffer.concat(this.packets);
    this.packets = [];
    return ret;
  };

  Burner.prototype._compress = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var esc, inflated, opkt, pkt;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, __iced_deferrals2;
        esc = make_esc(cb, "Burner::_compress");
        inflated = _this.collect_packets();
        pkt = new Compressed({
          algo: C.compression.zlib,
          inflated: inflated
        });
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Burner::_compress",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
        });
        _this.asp.progress({
          what: 'compress',
          i: 0,
          total: 1
        }, esc(__iced_deferrals.defer({
          lineno: 96
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Burner::_compress",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
        });
        pkt.write(esc(__iced_deferrals1.defer({
          assign_fn: (function() {
            return function() {
              return opkt = arguments[0];
            };
          })(),
          lineno: 97
        })));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        __iced_deferrals2 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Burner::_compress",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
        });
        _this.asp.progress({
          what: 'compress',
          i: 1,
          total: 1
        }, esc(__iced_deferrals2.defer({
          lineno: 98
        })));
        if (__iced_deferrals2.await_exit()) {
          yield;
        }
        _this.packets.push(opkt);
        return cb(null);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Burner.prototype._make_session_key = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      return function*() {
        var __iced_deferrals;
        _this._cipher_algo = C.symmetric_key_algorithms.AES256;
        _this._cipher_info = get_cipher(_this._cipher_algo);
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Burner::_make_session_key",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
        });
        SRF().random_bytes(_this._cipher_info.key_size, __iced_deferrals.defer({
          assign_fn: (function(__slot_1) {
            return function() {
              return __slot_1._session_key = arguments[0];
            };
          })(_this),
          lineno: 107
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        _this._cipher = new _this._cipher_info.klass(WordArray.from_buffer(_this._session_key));
        return cb(null);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Burner.prototype.scrub = function() {
    if (this._cipher != null) {
      this._cipher.scrub();
    }
    if (this._session_key != null) {
      return scrub_buffer(this._session_key);
    }
  };

  Burner.prototype._encrypt_session_key_once = function(encryption_key, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var ekey, esc, fingerprint, key_id, payload, pkesk, pkt, pub_k;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, __iced_deferrals2, __iced_deferrals3, __iced_deferrals4, __iced_deferrals5, __iced_deferrals6, ref3, ref4;
        esc = make_esc(cb, "_encrypt_session_key_once");
        payload = export_key_pgp(_this._cipher_algo, _this._session_key);
        pub_k = encryption_key.key;
        fingerprint = encryption_key.get_fingerprint();
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Burner::_encrypt_session_key_once",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
        });
        _this.asp.progress({
          what: 'session key encrypt',
          i: 0,
          total: 1
        }, esc(__iced_deferrals.defer({
          lineno: 124
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Burner::_encrypt_session_key_once",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
        });
        pub_k.pad_and_encrypt(payload, {
          fingerprint: fingerprint
        }, esc(__iced_deferrals1.defer({
          assign_fn: (function() {
            return function() {
              return ekey = arguments[0];
            };
          })(),
          lineno: 125
        })));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        __iced_deferrals2 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Burner::_encrypt_session_key_once",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
        });
        _this.asp.progress({
          what: 'session key encrypt',
          i: 1,
          total: 1
        }, esc(__iced_deferrals2.defer({
          lineno: 126
        })));
        if (__iced_deferrals2.await_exit()) {
          yield;
        }
        if (_this.opts.hide) {
          key_id = dummy_key_id;
          __iced_deferrals3 = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Burner::_encrypt_session_key_once",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
          });
          _this.asp.progress({
            what: 'hide encryption',
            i: 0,
            total: 1
          }, esc(__iced_deferrals3.defer({
            lineno: 129
          })));
          if (__iced_deferrals3.await_exit()) {
            yield;
          }
          __iced_deferrals4 = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Burner::_encrypt_session_key_once",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
          });
          ekey.hide({
            max: (ref3 = _this.opts.hide) != null ? ref3.max : void 0,
            slosh: (ref4 = _this.opts.hide) != null ? ref4.slosh : void 0,
            key: pub_k
          }, esc(__iced_deferrals4.defer({
            lineno: 130
          })));
          if (__iced_deferrals4.await_exit()) {
            yield;
          }
          __iced_deferrals5 = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Burner::_encrypt_session_key_once",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
          });
          _this.asp.progress({
            what: 'hide encryption',
            i: 1,
            total: 1
          }, esc(__iced_deferrals5.defer({
            lineno: 131
          })));
          if (__iced_deferrals5.await_exit()) {
            yield;
          }
        } else {
          key_id = encryption_key.get_key_id();
        }
        pkt = new PKESK({
          crypto_type: pub_k.type,
          key_id: key_id,
          ekey: ekey
        });
        __iced_deferrals6 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Burner::_encrypt_session_key_once",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
        });
        pkt.write(esc(__iced_deferrals6.defer({
          assign_fn: (function() {
            return function() {
              return pkesk = arguments[0];
            };
          })(),
          lineno: 139
        })));
        if (__iced_deferrals6.await_exit()) {
          yield;
        }
        return cb(null, pkesk);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Burner.prototype._encrypt_session_key = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var esc, k, pkesk;
      return function*() {
        var __iced_deferrals, i, len, ref3;
        esc = make_esc(cb, "_encrypt_session_key");
        _this._pkesks = [];
        ref3 = _this.encryption_keys;
        for (i = 0, len = ref3.length; i < len; i++) {
          k = ref3[i];
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Burner::_encrypt_session_key",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
          });
          _this._encrypt_session_key_once(k, esc(__iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                return pkesk = arguments[0];
              };
            })(),
            lineno: 148
          })));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
          _this._pkesks.push(pkesk);
        }
        return cb(null);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Burner.prototype._encrypt_payload = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var asp, esc, pkt, plaintext, prefixrandom;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, __iced_deferrals2;
        esc = make_esc(cb, "Burner::_encrypt_payload");
        plaintext = _this.collect_packets();
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Burner::_encrypt_payload",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
        });
        SRF().random_bytes(_this._cipher.blockSize, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return prefixrandom = arguments[0];
            };
          })(),
          lineno: 157
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        pkt = new SEIPD({});
        asp = _this.asp.section('encrypt payload');
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Burner::_encrypt_payload",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
        });
        pkt.encrypt({
          cipher: _this._cipher,
          plaintext: plaintext,
          prefixrandom: prefixrandom,
          asp: asp
        }, esc(__iced_deferrals1.defer({
          lineno: 160
        })));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        __iced_deferrals2 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Burner::_encrypt_payload",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
        });
        pkt.write(esc(__iced_deferrals2.defer({
          assign_fn: (function() {
            return function() {
              return pkt = arguments[0];
            };
          })(),
          lineno: 161
        })));
        if (__iced_deferrals2.await_exit()) {
          yield;
        }
        scrub_buffer(plaintext);
        _this.packets = _this._pkesks.concat([pkt]);
        return cb(null);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Burner.prototype._encrypt = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var esc;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, __iced_deferrals2;
        esc = make_esc(cb, "Burner::_encrypt");
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Burner::_encrypt",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
        });
        _this._make_session_key(esc(__iced_deferrals.defer({
          lineno: 170
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Burner::_encrypt",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
        });
        _this._encrypt_session_key(esc(__iced_deferrals1.defer({
          lineno: 171
        })));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        __iced_deferrals2 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Burner::_encrypt",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
        });
        _this._encrypt_payload(esc(__iced_deferrals2.defer({
          lineno: 172
        })));
        if (__iced_deferrals2.await_exit()) {
          yield;
        }
        return cb(null);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Burner.prototype.scrub = function() {};

  Burner.prototype.burn = function(cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var esc, output;
      return function*() {
        var __iced_deferrals, __iced_deferrals1, __iced_deferrals2, __iced_deferrals3, __iced_deferrals4;
        esc = make_esc(cb, "Burner::burn");
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Burner::burn",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
        });
        _this._find_keys(esc(__iced_deferrals.defer({
          lineno: 183
        })));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        __iced_deferrals1 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Burner::burn",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
        });
        _this._frame_literals(esc(__iced_deferrals1.defer({
          lineno: 184
        })));
        if (__iced_deferrals1.await_exit()) {
          yield;
        }
        if (_this.signing_key != null) {
          __iced_deferrals2 = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Burner::burn",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
          });
          _this._sign(esc(__iced_deferrals2.defer({
            lineno: 186
          })));
          if (__iced_deferrals2.await_exit()) {
            yield;
          }
        }
        __iced_deferrals3 = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Burner::burn",
          filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
        });
        _this._compress(esc(__iced_deferrals3.defer({
          lineno: 187
        })));
        if (__iced_deferrals3.await_exit()) {
          yield;
        }
        if (_this.encryption_keys != null) {
          __iced_deferrals4 = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Burner::burn",
            filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
          });
          _this._encrypt(esc(__iced_deferrals4.defer({
            lineno: 189
          })));
          if (__iced_deferrals4.await_exit()) {
            yield;
          }
        }
        output = Buffer.concat(_this.packets);
        return cb(null, output);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return Burner;

})(BaseBurner);

exports.Burner = Burner;

exports.make_simple_literals = make_simple_literals = function(msg) {
  return [
    new Literal({
      data: Buffer.from(msg),
      format: C.literal_formats.utf8,
      date: unix_time()
    })
  ];
};

exports.clearsign = clearsign.sign;

exports.detachsign = detachsign.sign;

exports.burn = function(arg, cb) {
  var __iced_it, __iced_passed_deferral, aout, asp, b, encrypt_for, encryption_key, err, literals, msg, opts, raw, sign_with, signing_key;
  msg = arg.msg, literals = arg.literals, sign_with = arg.sign_with, encrypt_for = arg.encrypt_for, signing_key = arg.signing_key, encryption_key = arg.encryption_key, asp = arg.asp, opts = arg.opts;
  __iced_passed_deferral = iced.findDeferral(arguments);
  __iced_it = (function*() {
    var __iced_deferrals;
    if ((msg != null) && (literals == null)) {
      literals = make_simple_literals(msg);
    }
    b = new Burner({
      literals: literals,
      sign_with: sign_with,
      encrypt_for: encrypt_for,
      signing_key: signing_key,
      encryption_key: encryption_key,
      asp: asp,
      opts: opts
    });
    __iced_deferrals = new iced.Deferrals(__iced_it, {
      parent: __iced_passed_deferral,
      funcname: "exports.burn",
      filename: "/home/runner/work/kbpgp/kbpgp/src/openpgp/burner.iced"
    });
    b.burn(__iced_deferrals.defer({
      assign_fn: (function() {
        return function() {
          err = arguments[0];
          return raw = arguments[1];
        };
      })(),
      lineno: 249
    }));
    if (__iced_deferrals.await_exit()) {
      yield;
    }
    b.scrub();
    if ((raw != null) && (err == null)) {
      aout = encode(C.message_types.generic, raw);
    }
    return cb(err, aout, raw);
  })();
  __iced_it.next();
  return null;
};

//# sourceMappingURL=burner.js.map
