// Generated by IcedCoffeeScript 112.8.1
var Encryption, K, P3SKB, Signature, katch;

K = require('../../const').kb;

P3SKB = require('./p3skb').P3SKB;

Signature = require('./signature').Signature;

Encryption = require('./encryption').Encryption;

katch = function(f) {
  var e;
  try {
    return [null, f()];
  } catch (error) {
    e = error;
    return [e, null];
  }
};

exports.alloc = function(arg) {
  var body, err, ref, ret, tag;
  tag = arg.tag, body = arg.body;
  ref = (function() {
    switch (tag) {
      case K.packet_tags.p3skb:
        return katch(function() {
          return P3SKB.alloc({
            tag: tag,
            body: body
          });
        });
      case K.packet_tags.signature:
        return katch(function() {
          return Signature.alloc({
            tag: tag,
            body: body
          });
        });
      case K.packet_tags.encryption:
        return katch(function() {
          return Encryption.alloc({
            tag: tag,
            body: body
          });
        });
      default:
        err = new Error("unknown packet tag: " + tag);
        return [err, null];
    }
  })(), err = ref[0], ret = ref[1];
  return [err, ret];
};

//# sourceMappingURL=alloc.js.map
