// Generated by IcedCoffeeScript 112.8.1
var ASP, BaseKey, BaseKeyPair, C, K, MRF, Output, Pair, Priv, Pub, SRF, bn, bufeq_secure, eme_pkcs1_decode, eme_pkcs1_encode, iced, konst, make_esc, ref, ref1, ref2, ref3,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

iced = require('iced-runtime-3');

bn = require('./bn');

ref = require('./util'), bufeq_secure = ref.bufeq_secure, ASP = ref.ASP;

make_esc = require('iced-error').make_esc;

konst = require('./const');

C = konst.openpgp;

K = konst.kb;

ref1 = require('./basekeypair'), BaseKeyPair = ref1.BaseKeyPair, BaseKey = ref1.BaseKey;

ref2 = require('./rand'), SRF = ref2.SRF, MRF = ref2.MRF;

ref3 = require('./pad'), eme_pkcs1_encode = ref3.eme_pkcs1_encode, eme_pkcs1_decode = ref3.eme_pkcs1_decode;

Pub = (function(superClass) {
  extend(Pub, superClass);

  Pub.type = C.public_key_algorithms.ELGAMAL;

  Pub.prototype.type = Pub.type;

  Pub.ORDER = ['p', 'g', 'y'];

  Pub.prototype.ORDER = Pub.ORDER;

  function Pub(arg) {
    this.p = arg.p, this.g = arg.g, this.y = arg.y;
  }

  Pub.alloc = function(raw) {
    return BaseKey.alloc(Pub, raw);
  };

  Pub.prototype.encrypt = function(m, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var c, k;
      return function*() {
        var __iced_deferrals;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Pub::encrypt",
          filename: "/home/runner/work/kbpgp/kbpgp/src/elgamal.iced"
        });
        SRF().random_zn(_this.p.subtract(bn.nbv(2)), __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return k = arguments[0];
            };
          })(),
          lineno: 35
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        k = k.add(bn.BigInteger.ONE);
        c = [_this.g.modPow(k, _this.p), _this.y.modPow(k, _this.p).multiply(m).mod(_this.p)];
        return cb(c);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return Pub;

})(BaseKey);

Priv = (function(superClass) {
  extend(Priv, superClass);

  Priv.ORDER = ['x'];

  Priv.prototype.ORDER = Priv.ORDER;

  function Priv(arg) {
    this.x = arg.x, this.pub = arg.pub;
  }

  Priv.prototype.serialize = function() {
    return this.x.to_mpi_buffer();
  };

  Priv.alloc = function(raw, pub) {
    return BaseKey.alloc(Priv, raw, {
      pub: pub
    });
  };

  Priv.prototype.decrypt = function(c, cb) {
    var p, ret;
    p = this.pub.p;
    ret = c[0].modPow(this.x, p).modInverse(p).multiply(c[1]).mod(p);
    return cb(null, ret);
  };

  return Priv;

})(BaseKey);

Pair = (function(superClass) {
  extend(Pair, superClass);

  Pair.Pub = Pub;

  Pair.prototype.Pub = Pub;

  Pair.Priv = Priv;

  Pair.prototype.Priv = Priv;

  Pair.type = C.public_key_algorithms.ELGAMAL;

  Pair.klass_name = "ELGAMAL";

  Pair.prototype.type = Pair.type;

  Pair.prototype.get_type = function() {
    return this.type;
  };

  Pair.prototype.fulfills_flags = function(flags) {
    var good_for;
    good_for = this.good_for_flags();
    return (flags & good_for) === flags;
  };

  Pair.prototype.good_for_flags = function() {
    return C.key_flags.encrypt_comm | C.key_flags.encrypt_storage;
  };

  function Pair(arg) {
    var priv, pub;
    pub = arg.pub, priv = arg.priv;
    Pair.__super__.constructor.call(this, {
      pub: pub,
      priv: priv
    });
  }

  Pair.prototype.can_sign = function() {
    return false;
  };

  Pair.parse = function(pub_raw) {
    var ret;
    ret = BaseKeyPair.parse(Pair, pub_raw);
    return ret;
  };

  Pair.prototype.max_value = function() {
    return this.pub.p;
  };

  Pair.prototype.pad_and_encrypt = function(data, params, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var c_mpis, err, m, ret;
      return function*() {
        var __iced_deferrals, __iced_deferrals1;
        err = ret = null;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Pair::pad_and_encrypt",
          filename: "/home/runner/work/kbpgp/kbpgp/src/elgamal.iced"
        });
        eme_pkcs1_encode(data, _this.pub.p.mpi_byte_length(), __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              err = arguments[0];
              return m = arguments[1];
            };
          })(),
          lineno: 112
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        if (err == null) {
          __iced_deferrals1 = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Pair::pad_and_encrypt",
            filename: "/home/runner/work/kbpgp/kbpgp/src/elgamal.iced"
          });
          _this.pub.encrypt(m, __iced_deferrals1.defer({
            assign_fn: (function() {
              return function() {
                return c_mpis = arguments[0];
              };
            })(),
            lineno: 114
          }));
          if (__iced_deferrals1.await_exit()) {
            yield;
          }
          ret = _this.export_output({
            c_mpis: c_mpis
          });
        }
        return cb(err, ret);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Pair.prototype.decrypt_and_unpad = function(ciphertext, params, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var b, err, m, ret;
      return function*() {
        var __iced_deferrals, ref4;
        err = ret = null;
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Pair::decrypt_and_unpad",
          filename: "/home/runner/work/kbpgp/kbpgp/src/elgamal.iced"
        });
        _this.priv.decrypt(ciphertext.c(), __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              err = arguments[0];
              return m = arguments[1];
            };
          })(),
          lineno: 122
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        if (err == null) {
          b = m.to_padded_octets(_this.pub.p);
          ref4 = eme_pkcs1_decode(b), err = ref4[0], ret = ref4[1];
        }
        return cb(err, ret);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Pair.parse_output = function(buf) {
    return Output.parse(buf);
  };

  Pair.prototype.export_output = function(args) {
    return new Output(args);
  };

  return Pair;

})(BaseKeyPair);

Output = (function() {
  function Output(arg) {
    this.c_mpis = arg.c_mpis, this.c_bufs = arg.c_bufs;
  }

  Output.parse = function(buf) {
    var c_mpis, err, i, n, ret;
    c_mpis = (function() {
      var l, ref4, results;
      results = [];
      for (i = l = 0; l < 2; i = ++l) {
        ref4 = bn.mpi_from_buffer(buf), err = ref4[0], ret = ref4[1], buf = ref4[2], n = ref4[3];
        if (err != null) {
          throw err;
        }
        results.push(ret);
      }
      return results;
    })();
    if (buf.length !== 0) {
      throw new Error("junk at the end of input");
    }
    return new Output({
      c_mpis: c_mpis
    });
  };

  Output.prototype.c = function() {
    return this.c_mpis;
  };

  Output.prototype.hide = function(arg, cb) {
    var __iced_it, __iced_passed_deferral, key, max, slosh;
    key = arg.key, max = arg.max, slosh = arg.slosh;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var c_mpi, err, new_c_mpis, tmp;
      return function*() {
        var __iced_deferrals, l, len, ref4;
        max || (max = 4096);
        slosh || (slosh = 128);
        err = null;
        _this.c_bufs = null;
        new_c_mpis = [];
        ref4 = _this.c_mpis;
        for (l = 0, len = ref4.length; l < len; l++) {
          c_mpi = ref4[l];
          __iced_deferrals = new iced.Deferrals(__iced_it, {
            parent: __iced_passed_deferral,
            funcname: "Output::hide",
            filename: "/home/runner/work/kbpgp/kbpgp/src/elgamal.iced"
          });
          key.hide({
            i: c_mpi,
            max: max,
            slosh: slosh
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return tmp = arguments[1];
              };
            })(),
            lineno: 164
          }));
          if (__iced_deferrals.await_exit()) {
            yield;
          }
          new_c_mpis.push(tmp);
          if (err != null) {
            break;
          }
        }
        if (err == null) {
          _this.c_mpis = new_c_mpis;
        }
        return cb(err);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Output.prototype.find = function(arg) {
    var j, key;
    key = arg.key;
    return this.c_mpis = (function() {
      var l, len, ref4, results;
      ref4 = this.c_mpis;
      results = [];
      for (l = 0, len = ref4.length; l < len; l++) {
        j = ref4[l];
        results.push(key.find(j));
      }
      return results;
    }).call(this);
  };

  Output.prototype.get_c_bufs = function() {
    var i;
    if (this.c_bufs != null) {
      return this.c_bufs;
    } else {
      return this.c_bufs = (function() {
        var l, len, ref4, results;
        ref4 = this.c_mpis;
        results = [];
        for (l = 0, len = ref4.length; l < len; l++) {
          i = ref4[l];
          results.push(i.to_mpi_buffer());
        }
        return results;
      }).call(this);
    }
  };

  Output.prototype.output = function() {
    return Buffer.concat(this.get_c_bufs());
  };

  return Output;

})();

exports.ElGamal = exports.Pair = Pair;

//# sourceMappingURL=elgamal.js.map
