// Generated by IcedCoffeeScript 112.8.1
var BaseEccKey, SlicerBuffer, alloc_by_name, alloc_by_nbits, alloc_by_oid, iced, ref;

iced = require('iced-runtime-3');

SlicerBuffer = require('../openpgp/buffer').SlicerBuffer;

ref = require('./curves'), alloc_by_nbits = ref.alloc_by_nbits, alloc_by_oid = ref.alloc_by_oid, alloc_by_name = ref.alloc_by_name;

exports.BaseEccKey = BaseEccKey = (function() {
  function BaseEccKey(arg) {
    this.curve = arg.curve, this.R = arg.R;
  }

  BaseEccKey.prototype.serialize = function() {
    var oid;
    oid = this.curve.oid;
    return Buffer.concat([Buffer.from([oid.length]), oid, this.curve.point_to_mpi_buffer(this.R)]);
  };

  BaseEccKey._alloc = function(klass, raw) {
    var R, curve, err, l, len, oid, pre, pub, ref1, ref2, sb;
    sb = new SlicerBuffer(raw);
    pre = sb.rem();
    l = sb.read_uint8();
    oid = sb.read_buffer(l);
    ref1 = alloc_by_oid(oid), err = ref1[0], curve = ref1[1];
    if (err != null) {
      throw err;
    }
    ref2 = curve.mpi_point_from_slicer_buffer(sb), err = ref2[0], R = ref2[1];
    if (err != null) {
      throw err;
    }
    pub = new klass({
      curve: curve,
      R: R
    });
    pub.read_params(sb);
    len = pre - sb.rem();
    return [pub, len];
  };

  BaseEccKey.alloc = function(klass, raw) {
    var e, err, len, pub, ref1;
    pub = len = err = null;
    try {
      ref1 = BaseEccKey._alloc(klass, raw), pub = ref1[0], len = ref1[1];
    } catch (error) {
      e = error;
      err = e;
    }
    return [err, pub, len];
  };

  BaseEccKey.prototype.validity_check = function(cb) {
    return cb(null);
  };

  return BaseEccKey;

})();

exports.generate = function(arg, cb) {
  var Pair, R, __iced_it, __iced_passed_deferral, asp, curve, curve_name, err, nbits, priv, pub, ret, x;
  nbits = arg.nbits, asp = arg.asp, curve_name = arg.curve_name, Pair = arg.Pair;
  __iced_passed_deferral = iced.findDeferral(arguments);
  __iced_it = (function*() {
    var __iced_deferrals, ref1, ref2;
    ret = null;
    if (curve_name) {
      ref1 = alloc_by_name(curve_name), err = ref1[0], curve = ref1[1];
    } else {
      ref2 = alloc_by_nbits(nbits), err = ref2[0], curve = ref2[1];
    }
    if (err == null) {
      __iced_deferrals = new iced.Deferrals(__iced_it, {
        parent: __iced_passed_deferral,
        funcname: "exports.generate",
        filename: "/home/runner/work/kbpgp/kbpgp/src/ecc/base.iced"
      });
      curve.generate(__iced_deferrals.defer({
        assign_fn: (function() {
          return function() {
            x = arguments[0].x;
            return R = arguments[0].R;
          };
        })(),
        lineno: 58
      }));
      if (__iced_deferrals.await_exit()) {
        yield;
      }
      pub = new Pair.Pub({
        curve: curve,
        R: R
      });
      priv = new Pair.Priv({
        pub: pub,
        x: x
      });
      ret = new Pair({
        pub: pub,
        priv: priv
      });
    }
    return cb(err, ret);
  })();
  __iced_it.next();
  return null;
};

//# sourceMappingURL=base.js.map
