// Generated by IcedCoffeeScript 112.8.1
var ASP, BaseKey, BaseKeyPair, BigInteger, C, K, MRF, Pair, Priv, Pub, SRF, bn, bufeq_secure, iced, konst, make_esc, nbits, nbv, ref, ref1, ref2, ref3,
  extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
  hasProp = {}.hasOwnProperty;

iced = require('iced-runtime-3');

bn = require('./bn');

nbits = bn.nbits, nbv = bn.nbv, BigInteger = bn.BigInteger;

ref = require('./rand'), SRF = ref.SRF, MRF = ref.MRF;

ref1 = require('./util'), bufeq_secure = ref1.bufeq_secure, ASP = ref1.ASP;

make_esc = require('iced-error').make_esc;

konst = require('./const');

C = konst.openpgp;

K = konst.kb;

ref2 = require('./basekeypair'), BaseKey = ref2.BaseKey, BaseKeyPair = ref2.BaseKeyPair;

ref3 = require('./rand'), SRF = ref3.SRF, MRF = ref3.MRF;

Pub = (function(superClass) {
  extend(Pub, superClass);

  Pub.type = C.public_key_algorithms.DSA;

  Pub.prototype.type = Pub.type;

  Pub.ORDER = ['p', 'q', 'g', 'y'];

  Pub.prototype.ORDER = Pub.ORDER;

  function Pub(arg) {
    this.p = arg.p, this.q = arg.q, this.g = arg.g, this.y = arg.y;
  }

  Pub.alloc = function(raw) {
    return BaseKey.alloc(Pub, raw);
  };

  Pub.prototype.trunc_hash = function(h) {
    return bn.bn_from_left_n_bits(h, this.q.bitLength());
  };

  Pub.prototype.nbits = function() {
    var ref4;
    return (ref4 = this.p) != null ? ref4.bitLength() : void 0;
  };

  Pub.prototype.verify = function(arg, h, cb) {
    var err, hi, r, s, u1, u2, v, w;
    r = arg[0], s = arg[1];
    err = null;
    hi = this.trunc_hash(h);
    w = s.modInverse(this.q);
    u1 = hi.multiply(w).mod(this.q);
    u2 = r.multiply(w).mod(this.q);
    v = this.g.modPow(u1, this.p).multiply(this.y.modPow(u2, this.p)).mod(this.p).mod(this.q);
    if (!v.equals(r)) {
      err = new Error("verification failed");
    }
    return cb(err);
  };

  return Pub;

})(BaseKey);

Priv = (function(superClass) {
  extend(Priv, superClass);

  Priv.ORDER = ['x'];

  Priv.prototype.ORDER = Priv.ORDER;

  function Priv(arg) {
    this.x = arg.x, this.pub = arg.pub;
  }

  Priv.alloc = function(raw, pub) {
    return BaseKey.alloc(Priv, raw, {
      pub: pub
    });
  };

  Priv.prototype.sign = function(h, cb) {
    var __iced_it, __iced_passed_deferral;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var err, g, hi, k, p, q, r, s;
      return function*() {
        var __iced_deferrals, ref4;
        err = null;
        ref4 = _this.pub, p = ref4.p, q = ref4.q, g = ref4.g;
        hi = _this.pub.trunc_hash(h);
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Priv::sign",
          filename: "/home/runner/work/kbpgp/kbpgp/src/dsa.iced"
        });
        SRF().random_zn(q.subtract(bn.nbv(2)), __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return k = arguments[0];
            };
          })(),
          lineno: 76
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        k = k.add(bn.BigInteger.ONE);
        r = g.modPow(k, p).mod(q);
        s = (k.modInverse(q).multiply(hi.add(_this.x.multiply(r)))).mod(q);
        return cb([r, s]);
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  return Priv;

})(BaseKey);

Pair = (function(superClass) {
  extend(Pair, superClass);

  Pair.Pub = Pub;

  Pair.prototype.Pub = Pub;

  Pair.Priv = Priv;

  Pair.prototype.Priv = Priv;

  Pair.type = C.public_key_algorithms.DSA;

  Pair.prototype.type = Pair.type;

  Pair.prototype.get_type = function() {
    return this.type;
  };

  Pair.klass_name = "DSA";

  function Pair(arg) {
    var priv, pub;
    pub = arg.pub, priv = arg.priv;
    Pair.__super__.constructor.call(this, {
      pub: pub,
      priv: priv
    });
  }

  Pair.parse = function(pub_raw) {
    return BaseKeyPair.parse(Pair, pub_raw);
  };

  Pair.prototype.can_encrypt = function() {
    return false;
  };

  Pair.prototype.fulfills_flags = function(flags) {
    var good_for;
    good_for = this.good_for_flags();
    return (flags & good_for) === flags;
  };

  Pair.prototype.good_for_flags = function() {
    return C.key_flags.certify_keys | C.key_flags.sign_data;
  };

  Pair.prototype.verify_unpad_and_check_hash = function(arg, cb) {
    var data, hash, hasher, sig;
    sig = arg.sig, data = arg.data, hasher = arg.hasher, hash = arg.hash;
    return this._dsa_verify_update_and_check_hash({
      sig: sig,
      data: data,
      hasher: hasher,
      hash: hash,
      klass: Pair
    }, cb);
  };

  Pair.prototype.pad_and_sign = function(data, arg, cb) {
    var __iced_it, __iced_passed_deferral, hasher;
    hasher = arg.hasher;
    __iced_passed_deferral = iced.findDeferral(arguments);
    __iced_it = (function(_this) {
      var h, s, sig;
      return function*() {
        var __iced_deferrals;
        hasher || (hasher = SHA512);
        h = hasher(data);
        __iced_deferrals = new iced.Deferrals(__iced_it, {
          parent: __iced_passed_deferral,
          funcname: "Pair::pad_and_sign",
          filename: "/home/runner/work/kbpgp/kbpgp/src/dsa.iced"
        });
        _this.priv.sign(h, __iced_deferrals.defer({
          assign_fn: (function() {
            return function() {
              return sig = arguments[0];
            };
          })(),
          lineno: 128
        }));
        if (__iced_deferrals.await_exit()) {
          yield;
        }
        return cb(null, Buffer.concat((function() {
          var i, len, results;
          results = [];
          for (i = 0, len = sig.length; i < len; i++) {
            s = sig[i];
            results.push(s.to_mpi_buffer());
          }
          return results;
        })()));
      };
    })(this)();
    __iced_it.next();
    return null;
  };

  Pair.parse_sig = function(slice) {
    var buf, err, n, ref4, ret;
    buf = slice.peek_rest_to_buffer();
    ref4 = Pair.read_sig_from_buf(buf), err = ref4[0], ret = ref4[1], n = ref4[2];
    if (err != null) {
      throw err;
    }
    slice.advance(n);
    return ret;
  };

  Pair.read_sig_from_buf = function(buf) {
    var err, n, o, order, orig_len, ret, x;
    orig_len = buf.length;
    order = ['r', 's'];
    err = null;
    ret = (function() {
      var i, len, ref4, results;
      results = [];
      for (i = 0, len = order.length; i < len; i++) {
        o = order[i];
        if (!(err == null)) {
          continue;
        }
        ref4 = bn.mpi_from_buffer(buf), err = ref4[0], x = ref4[1], buf = ref4[2];
        results.push(x);
      }
      return results;
    })();
    n = orig_len - buf.length;
    return [err, ret, n];
  };

  return Pair;

})(BaseKeyPair);

exports.DSA = exports.Pair = Pair;

//# sourceMappingURL=dsa.js.map
