// Generated by IcedCoffeeScript 112.8.1
var BaseX, BigInteger, buffer_to_ui8a, nbi, nbs, nbv, ref;

ref = require('bn'), nbv = ref.nbv, nbi = ref.nbi, BigInteger = ref.BigInteger;

nbs = require('./bn').nbs;

buffer_to_ui8a = require('./util').buffer_to_ui8a;

exports.BaseX = BaseX = (function() {
  function BaseX(alphabet) {
    var a, i, j, len, ref1;
    this.alphabet = alphabet;
    this.base = this.alphabet.length;
    this.basebn = nbv(this.base);
    this.lookup = {};
    ref1 = this.alphabet;
    for (i = j = 0, len = ref1.length; j < len; i = ++j) {
      a = ref1[i];
      this.lookup[a] = i;
    }
  }

  BaseX.prototype.encode = function(buffer) {
    var c, chars, j, len, num, pad, q, r;
    num = nbi().fromBuffer(buffer);
    chars = (function() {
      var ref1, results;
      results = [];
      while (num.compareTo(BigInteger.ZERO) > 0) {
        ref1 = num.divideAndRemainder(this.basebn), q = ref1[0], r = ref1[1];
        c = this.alphabet[r.intValue()];
        num = q;
        results.push(c);
      }
      return results;
    }).call(this);
    chars.reverse();
    pad = [];
    for (j = 0, len = buffer.length; j < len; j++) {
      c = buffer[j];
      if (c === 0) {
        pad.push(this.alphabet[0]);
      } else {
        break;
      }
    }
    return (pad.concat(chars)).join('');
  };

  BaseX.prototype.decode = function(str) {
    var base, c, char_index, i, j, k, len, num, pad, ref1, start;
    num = BigInteger.ZERO;
    base = BigInteger.ONE;
    i = 0;
    for (i = j = 0, len = str.length; j < len; i = ++j) {
      c = str[i];
      if (c !== this.alphabet[0]) {
        break;
      }
    }
    start = i;
    pad = Buffer.from((function() {
      var k, ref1, results;
      results = [];
      for (i = k = 0, ref1 = start; 0 <= ref1 ? k < ref1 : k > ref1; i = 0 <= ref1 ? ++k : --k) {
        results.push(0);
      }
      return results;
    })());
    ref1 = str.slice(start);
    for (i = k = ref1.length - 1; k >= 0; i = k += -1) {
      c = ref1[i];
      if ((char_index = this.lookup[c]) == null) {
        throw new Error('Value passed is not a valid BaseX string.');
      }
      num = num.add(base.multiply(nbv(char_index)));
      base = base.multiply(this.basebn);
    }
    return Buffer.concat([pad, Buffer.from(num.toByteArray())]);
  };

  return BaseX;

})();

exports.base58 = new BaseX('123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz');

exports.base32 = new BaseX('abcdefghijkmnpqrstuvwxyz23456789');

exports.base91 = new BaseX('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789`~!@#$%^&*()-_=+{}[]|;:,<>./?');

//# sourceMappingURL=basex.js.map
