"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseWantedDependency = parseWantedDependency;
const validate_npm_package_name_1 = __importDefault(require("validate-npm-package-name"));
function parseWantedDependency(rawWantedDependency) {
    const versionDelimiter = rawWantedDependency.indexOf('@', 1); // starting from 1 to skip the @ that marks scope
    if (versionDelimiter !== -1) {
        const alias = rawWantedDependency.slice(0, versionDelimiter);
        if ((0, validate_npm_package_name_1.default)(alias).validForOldPackages) {
            return {
                alias,
                bareSpecifier: rawWantedDependency.slice(versionDelimiter + 1),
            };
        }
        return {
            bareSpecifier: rawWantedDependency,
        };
    }
    if ((0, validate_npm_package_name_1.default)(rawWantedDependency).validForOldPackages) {
        return {
            alias: rawWantedDependency,
        };
    }
    return {
        bareSpecifier: rawWantedDependency,
    };
}
//# sourceMappingURL=index.js.map