"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseOverrides = parseOverrides;
exports.parsePkgAndParentSelector = parsePkgAndParentSelector;
const error_1 = require("@pnpm/error");
const parse_wanted_dependency_1 = require("@pnpm/parse-wanted-dependency");
const catalogs_resolver_1 = require("@pnpm/catalogs.resolver");
const DELIMITER_REGEX = /[^ |@]>/;
function parseOverrides(overrides, catalogs) {
    const _resolveFromCatalog = catalogs_resolver_1.resolveFromCatalog.bind(null, catalogs ?? {});
    return Object.entries(overrides)
        .map(([selector, newBareSpecifier]) => {
        const result = parsePkgAndParentSelector(selector);
        const resolvedCatalog = (0, catalogs_resolver_1.matchCatalogResolveResult)(_resolveFromCatalog({
            bareSpecifier: newBareSpecifier,
            alias: result.targetPkg.name,
        }), {
            found: ({ resolution }) => resolution.specifier,
            unused: () => undefined,
            misconfiguration: ({ error }) => {
                throw new error_1.PnpmError('CATALOG_IN_OVERRIDES', `Could not resolve a catalog in the overrides: ${error.message}`);
            },
        });
        return {
            selector,
            newBareSpecifier: resolvedCatalog ?? newBareSpecifier,
            ...result,
        };
    });
}
function parsePkgAndParentSelector(selector) {
    let delimiterIndex = selector.search(DELIMITER_REGEX);
    if (delimiterIndex !== -1) {
        delimiterIndex++;
        const parentSelector = selector.substring(0, delimiterIndex);
        const childSelector = selector.substring(delimiterIndex + 1);
        return {
            parentPkg: parsePkgSelector(parentSelector),
            targetPkg: parsePkgSelector(childSelector),
        };
    }
    return {
        targetPkg: parsePkgSelector(selector),
    };
}
function parsePkgSelector(selector) {
    const wantedDep = (0, parse_wanted_dependency_1.parseWantedDependency)(selector);
    if (!wantedDep.alias) {
        throw new error_1.PnpmError('INVALID_SELECTOR', `Cannot parse the "${selector}" selector`);
    }
    return {
        name: wantedDep.alias,
        bareSpecifier: wantedDep.bareSpecifier,
    };
}
//# sourceMappingURL=index.js.map