import { type Catalogs } from '@pnpm/catalogs.types';
export interface VersionOverride {
    selector: string;
    parentPkg?: PackageSelector;
    targetPkg: PackageSelector;
    newBareSpecifier: string;
}
export interface PackageSelector {
    name: string;
    bareSpecifier?: string;
}
export declare function parseOverrides(overrides: Record<string, string>, catalogs?: Catalogs): VersionOverride[];
export declare function parsePkgAndParentSelector(selector: string): Pick<VersionOverride, 'parentPkg' | 'targetPkg'>;
