"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseCatalogProtocol = parseCatalogProtocol;
const CATALOG_PROTOCOL = 'catalog:';
/**
 * Parse a package.json dependency specifier using the catalog: protocol.
 * Returns null if the given specifier does not start with 'catalog:'.
 */
function parseCatalogProtocol(bareSpecifier) {
    if (!bareSpecifier.startsWith(CATALOG_PROTOCOL)) {
        return null;
    }
    const catalogNameRaw = bareSpecifier.slice(CATALOG_PROTOCOL.length).trim();
    // Allow a specifier of 'catalog:' to be a short-hand for 'catalog:default'.
    const catalogNameNormalized = catalogNameRaw === '' ? 'default' : catalogNameRaw;
    return catalogNameNormalized;
}
//# sourceMappingURL=parseCatalogProtocol.js.map