import { AwsCredentialIdentity, ChecksumConstructor, Endpoint, HashConstructor, InitializeMiddleware, MemoizedProvider, Pluggable, Provider, RelativeMiddlewareOptions, SerializeHandlerOptions } from "@smithy/types";
interface PreviouslyResolved {
    credentials: MemoizedProvider<AwsCredentialIdentity>;
    endpoint?: Provider<Endpoint>;
    region: Provider<string>;
    sha256: ChecksumConstructor | HashConstructor;
    signingEscapePath: boolean;
}
/**
 * Config of the middleware to automatically add presigned URL to request.
 * The presigned URL is generated by sigV4
 */
export declare function crossRegionPresignedUrlMiddleware(options: PreviouslyResolved): InitializeMiddleware<any, any>;
export declare const crossRegionPresignedUrlMiddlewareOptions: SerializeHandlerOptions & RelativeMiddlewareOptions;
export declare const getCrossRegionPresignedUrlPlugin: (config: PreviouslyResolved) => Pluggable<any, any>;
export {};
