import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { RDSServiceException as __BaseException } from "./RDSServiceException";
export interface AccountQuota {
  AccountQuotaName?: string | undefined;
  Used?: number | undefined;
  Max?: number | undefined;
}
export interface AccountAttributesMessage {
  AccountQuotas?: AccountQuota[] | undefined;
}
export declare const ActivityStreamMode: {
  readonly async: "async";
  readonly sync: "sync";
};
export type ActivityStreamMode =
  (typeof ActivityStreamMode)[keyof typeof ActivityStreamMode];
export declare const ActivityStreamPolicyStatus: {
  readonly locked: "locked";
  readonly locking_policy: "locking-policy";
  readonly unlocked: "unlocked";
  readonly unlocking_policy: "unlocking-policy";
};
export type ActivityStreamPolicyStatus =
  (typeof ActivityStreamPolicyStatus)[keyof typeof ActivityStreamPolicyStatus];
export declare const ActivityStreamStatus: {
  readonly started: "started";
  readonly starting: "starting";
  readonly stopped: "stopped";
  readonly stopping: "stopping";
};
export type ActivityStreamStatus =
  (typeof ActivityStreamStatus)[keyof typeof ActivityStreamStatus];
export interface AddRoleToDBClusterMessage {
  DBClusterIdentifier: string | undefined;
  RoleArn: string | undefined;
  FeatureName?: string | undefined;
}
export declare class DBClusterNotFoundFault extends __BaseException {
  readonly name: "DBClusterNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBClusterNotFoundFault, __BaseException>
  );
}
export declare class DBClusterRoleAlreadyExistsFault extends __BaseException {
  readonly name: "DBClusterRoleAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBClusterRoleAlreadyExistsFault,
      __BaseException
    >
  );
}
export declare class DBClusterRoleQuotaExceededFault extends __BaseException {
  readonly name: "DBClusterRoleQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBClusterRoleQuotaExceededFault,
      __BaseException
    >
  );
}
export declare class InvalidDBClusterStateFault extends __BaseException {
  readonly name: "InvalidDBClusterStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidDBClusterStateFault, __BaseException>
  );
}
export interface AddRoleToDBInstanceMessage {
  DBInstanceIdentifier: string | undefined;
  RoleArn: string | undefined;
  FeatureName: string | undefined;
}
export declare class DBInstanceNotFoundFault extends __BaseException {
  readonly name: "DBInstanceNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBInstanceNotFoundFault, __BaseException>
  );
}
export declare class DBInstanceRoleAlreadyExistsFault extends __BaseException {
  readonly name: "DBInstanceRoleAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBInstanceRoleAlreadyExistsFault,
      __BaseException
    >
  );
}
export declare class DBInstanceRoleQuotaExceededFault extends __BaseException {
  readonly name: "DBInstanceRoleQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBInstanceRoleQuotaExceededFault,
      __BaseException
    >
  );
}
export declare class InvalidDBInstanceStateFault extends __BaseException {
  readonly name: "InvalidDBInstanceStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidDBInstanceStateFault, __BaseException>
  );
}
export interface AddSourceIdentifierToSubscriptionMessage {
  SubscriptionName: string | undefined;
  SourceIdentifier: string | undefined;
}
export interface EventSubscription {
  CustomerAwsId?: string | undefined;
  CustSubscriptionId?: string | undefined;
  SnsTopicArn?: string | undefined;
  Status?: string | undefined;
  SubscriptionCreationTime?: string | undefined;
  SourceType?: string | undefined;
  SourceIdsList?: string[] | undefined;
  EventCategoriesList?: string[] | undefined;
  Enabled?: boolean | undefined;
  EventSubscriptionArn?: string | undefined;
}
export interface AddSourceIdentifierToSubscriptionResult {
  EventSubscription?: EventSubscription | undefined;
}
export declare class SourceNotFoundFault extends __BaseException {
  readonly name: "SourceNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<SourceNotFoundFault, __BaseException>
  );
}
export declare class SubscriptionNotFoundFault extends __BaseException {
  readonly name: "SubscriptionNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<SubscriptionNotFoundFault, __BaseException>
  );
}
export interface Tag {
  Key?: string | undefined;
  Value?: string | undefined;
}
export interface AddTagsToResourceMessage {
  ResourceName: string | undefined;
  Tags: Tag[] | undefined;
}
export declare class BlueGreenDeploymentNotFoundFault extends __BaseException {
  readonly name: "BlueGreenDeploymentNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      BlueGreenDeploymentNotFoundFault,
      __BaseException
    >
  );
}
export declare class DBProxyNotFoundFault extends __BaseException {
  readonly name: "DBProxyNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBProxyNotFoundFault, __BaseException>
  );
}
export declare class DBProxyTargetGroupNotFoundFault extends __BaseException {
  readonly name: "DBProxyTargetGroupNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBProxyTargetGroupNotFoundFault,
      __BaseException
    >
  );
}
export declare class DBSnapshotNotFoundFault extends __BaseException {
  readonly name: "DBSnapshotNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBSnapshotNotFoundFault, __BaseException>
  );
}
export declare class DBSnapshotTenantDatabaseNotFoundFault extends __BaseException {
  readonly name: "DBSnapshotTenantDatabaseNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBSnapshotTenantDatabaseNotFoundFault,
      __BaseException
    >
  );
}
export declare class IntegrationNotFoundFault extends __BaseException {
  readonly name: "IntegrationNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<IntegrationNotFoundFault, __BaseException>
  );
}
export declare class TenantDatabaseNotFoundFault extends __BaseException {
  readonly name: "TenantDatabaseNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<TenantDatabaseNotFoundFault, __BaseException>
  );
}
export interface ApplyPendingMaintenanceActionMessage {
  ResourceIdentifier: string | undefined;
  ApplyAction: string | undefined;
  OptInType: string | undefined;
}
export interface PendingMaintenanceAction {
  Action?: string | undefined;
  AutoAppliedAfterDate?: Date | undefined;
  ForcedApplyDate?: Date | undefined;
  OptInStatus?: string | undefined;
  CurrentApplyDate?: Date | undefined;
  Description?: string | undefined;
}
export interface ResourcePendingMaintenanceActions {
  ResourceIdentifier?: string | undefined;
  PendingMaintenanceActionDetails?: PendingMaintenanceAction[] | undefined;
}
export interface ApplyPendingMaintenanceActionResult {
  ResourcePendingMaintenanceActions?:
    | ResourcePendingMaintenanceActions
    | undefined;
}
export declare class ResourceNotFoundFault extends __BaseException {
  readonly name: "ResourceNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ResourceNotFoundFault, __BaseException>
  );
}
export declare class AuthorizationAlreadyExistsFault extends __BaseException {
  readonly name: "AuthorizationAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      AuthorizationAlreadyExistsFault,
      __BaseException
    >
  );
}
export declare class AuthorizationQuotaExceededFault extends __BaseException {
  readonly name: "AuthorizationQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      AuthorizationQuotaExceededFault,
      __BaseException
    >
  );
}
export interface AuthorizeDBSecurityGroupIngressMessage {
  DBSecurityGroupName: string | undefined;
  CIDRIP?: string | undefined;
  EC2SecurityGroupName?: string | undefined;
  EC2SecurityGroupId?: string | undefined;
  EC2SecurityGroupOwnerId?: string | undefined;
}
export interface EC2SecurityGroup {
  Status?: string | undefined;
  EC2SecurityGroupName?: string | undefined;
  EC2SecurityGroupId?: string | undefined;
  EC2SecurityGroupOwnerId?: string | undefined;
}
export interface IPRange {
  Status?: string | undefined;
  CIDRIP?: string | undefined;
}
export interface DBSecurityGroup {
  OwnerId?: string | undefined;
  DBSecurityGroupName?: string | undefined;
  DBSecurityGroupDescription?: string | undefined;
  VpcId?: string | undefined;
  EC2SecurityGroups?: EC2SecurityGroup[] | undefined;
  IPRanges?: IPRange[] | undefined;
  DBSecurityGroupArn?: string | undefined;
}
export interface AuthorizeDBSecurityGroupIngressResult {
  DBSecurityGroup?: DBSecurityGroup | undefined;
}
export declare class DBSecurityGroupNotFoundFault extends __BaseException {
  readonly name: "DBSecurityGroupNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBSecurityGroupNotFoundFault, __BaseException>
  );
}
export declare class InvalidDBSecurityGroupStateFault extends __BaseException {
  readonly name: "InvalidDBSecurityGroupStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDBSecurityGroupStateFault,
      __BaseException
    >
  );
}
export interface BacktrackDBClusterMessage {
  DBClusterIdentifier: string | undefined;
  BacktrackTo: Date | undefined;
  Force?: boolean | undefined;
  UseEarliestTimeOnPointInTimeUnavailable?: boolean | undefined;
}
export interface DBClusterBacktrack {
  DBClusterIdentifier?: string | undefined;
  BacktrackIdentifier?: string | undefined;
  BacktrackTo?: Date | undefined;
  BacktrackedFrom?: Date | undefined;
  BacktrackRequestCreationTime?: Date | undefined;
  Status?: string | undefined;
}
export interface CancelExportTaskMessage {
  ExportTaskIdentifier: string | undefined;
}
export declare const ExportSourceType: {
  readonly CLUSTER: "CLUSTER";
  readonly SNAPSHOT: "SNAPSHOT";
};
export type ExportSourceType =
  (typeof ExportSourceType)[keyof typeof ExportSourceType];
export interface ExportTask {
  ExportTaskIdentifier?: string | undefined;
  SourceArn?: string | undefined;
  ExportOnly?: string[] | undefined;
  SnapshotTime?: Date | undefined;
  TaskStartTime?: Date | undefined;
  TaskEndTime?: Date | undefined;
  S3Bucket?: string | undefined;
  S3Prefix?: string | undefined;
  IamRoleArn?: string | undefined;
  KmsKeyId?: string | undefined;
  Status?: string | undefined;
  PercentProgress?: number | undefined;
  TotalExtractedDataInGB?: number | undefined;
  FailureCause?: string | undefined;
  WarningMessage?: string | undefined;
  SourceType?: ExportSourceType | undefined;
}
export declare class ExportTaskNotFoundFault extends __BaseException {
  readonly name: "ExportTaskNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<ExportTaskNotFoundFault, __BaseException>
  );
}
export declare class InvalidExportTaskStateFault extends __BaseException {
  readonly name: "InvalidExportTaskStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidExportTaskStateFault, __BaseException>
  );
}
export interface CopyDBClusterParameterGroupMessage {
  SourceDBClusterParameterGroupIdentifier: string | undefined;
  TargetDBClusterParameterGroupIdentifier: string | undefined;
  TargetDBClusterParameterGroupDescription: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface DBClusterParameterGroup {
  DBClusterParameterGroupName?: string | undefined;
  DBParameterGroupFamily?: string | undefined;
  Description?: string | undefined;
  DBClusterParameterGroupArn?: string | undefined;
}
export interface CopyDBClusterParameterGroupResult {
  DBClusterParameterGroup?: DBClusterParameterGroup | undefined;
}
export declare class DBParameterGroupAlreadyExistsFault extends __BaseException {
  readonly name: "DBParameterGroupAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBParameterGroupAlreadyExistsFault,
      __BaseException
    >
  );
}
export declare class DBParameterGroupNotFoundFault extends __BaseException {
  readonly name: "DBParameterGroupNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBParameterGroupNotFoundFault, __BaseException>
  );
}
export declare class DBParameterGroupQuotaExceededFault extends __BaseException {
  readonly name: "DBParameterGroupQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBParameterGroupQuotaExceededFault,
      __BaseException
    >
  );
}
export interface CopyDBClusterSnapshotMessage {
  SourceDBClusterSnapshotIdentifier: string | undefined;
  TargetDBClusterSnapshotIdentifier: string | undefined;
  KmsKeyId?: string | undefined;
  PreSignedUrl?: string | undefined;
  CopyTags?: boolean | undefined;
  Tags?: Tag[] | undefined;
}
export interface DBClusterSnapshot {
  AvailabilityZones?: string[] | undefined;
  DBClusterSnapshotIdentifier?: string | undefined;
  DBClusterIdentifier?: string | undefined;
  SnapshotCreateTime?: Date | undefined;
  Engine?: string | undefined;
  EngineMode?: string | undefined;
  AllocatedStorage?: number | undefined;
  Status?: string | undefined;
  Port?: number | undefined;
  VpcId?: string | undefined;
  ClusterCreateTime?: Date | undefined;
  MasterUsername?: string | undefined;
  EngineVersion?: string | undefined;
  LicenseModel?: string | undefined;
  SnapshotType?: string | undefined;
  PercentProgress?: number | undefined;
  StorageEncrypted?: boolean | undefined;
  KmsKeyId?: string | undefined;
  DBClusterSnapshotArn?: string | undefined;
  SourceDBClusterSnapshotArn?: string | undefined;
  IAMDatabaseAuthenticationEnabled?: boolean | undefined;
  TagList?: Tag[] | undefined;
  DBSystemId?: string | undefined;
  StorageType?: string | undefined;
  DbClusterResourceId?: string | undefined;
  StorageThroughput?: number | undefined;
}
export interface CopyDBClusterSnapshotResult {
  DBClusterSnapshot?: DBClusterSnapshot | undefined;
}
export declare class DBClusterSnapshotAlreadyExistsFault extends __BaseException {
  readonly name: "DBClusterSnapshotAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBClusterSnapshotAlreadyExistsFault,
      __BaseException
    >
  );
}
export declare class DBClusterSnapshotNotFoundFault extends __BaseException {
  readonly name: "DBClusterSnapshotNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBClusterSnapshotNotFoundFault, __BaseException>
  );
}
export declare class InvalidDBClusterSnapshotStateFault extends __BaseException {
  readonly name: "InvalidDBClusterSnapshotStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDBClusterSnapshotStateFault,
      __BaseException
    >
  );
}
export declare class KMSKeyNotAccessibleFault extends __BaseException {
  readonly name: "KMSKeyNotAccessibleFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<KMSKeyNotAccessibleFault, __BaseException>
  );
}
export declare class SnapshotQuotaExceededFault extends __BaseException {
  readonly name: "SnapshotQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<SnapshotQuotaExceededFault, __BaseException>
  );
}
export interface CopyDBParameterGroupMessage {
  SourceDBParameterGroupIdentifier: string | undefined;
  TargetDBParameterGroupIdentifier: string | undefined;
  TargetDBParameterGroupDescription: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface DBParameterGroup {
  DBParameterGroupName?: string | undefined;
  DBParameterGroupFamily?: string | undefined;
  Description?: string | undefined;
  DBParameterGroupArn?: string | undefined;
}
export interface CopyDBParameterGroupResult {
  DBParameterGroup?: DBParameterGroup | undefined;
}
export interface CopyDBSnapshotMessage {
  SourceDBSnapshotIdentifier: string | undefined;
  TargetDBSnapshotIdentifier: string | undefined;
  KmsKeyId?: string | undefined;
  Tags?: Tag[] | undefined;
  CopyTags?: boolean | undefined;
  PreSignedUrl?: string | undefined;
  OptionGroupName?: string | undefined;
  TargetCustomAvailabilityZone?: string | undefined;
  CopyOptionGroup?: boolean | undefined;
  SnapshotAvailabilityZone?: string | undefined;
  SnapshotTarget?: string | undefined;
}
export interface ProcessorFeature {
  Name?: string | undefined;
  Value?: string | undefined;
}
export interface DBSnapshot {
  DBSnapshotIdentifier?: string | undefined;
  DBInstanceIdentifier?: string | undefined;
  SnapshotCreateTime?: Date | undefined;
  Engine?: string | undefined;
  AllocatedStorage?: number | undefined;
  Status?: string | undefined;
  Port?: number | undefined;
  AvailabilityZone?: string | undefined;
  VpcId?: string | undefined;
  InstanceCreateTime?: Date | undefined;
  MasterUsername?: string | undefined;
  EngineVersion?: string | undefined;
  LicenseModel?: string | undefined;
  SnapshotType?: string | undefined;
  Iops?: number | undefined;
  OptionGroupName?: string | undefined;
  PercentProgress?: number | undefined;
  SourceRegion?: string | undefined;
  SourceDBSnapshotIdentifier?: string | undefined;
  StorageType?: string | undefined;
  TdeCredentialArn?: string | undefined;
  Encrypted?: boolean | undefined;
  KmsKeyId?: string | undefined;
  DBSnapshotArn?: string | undefined;
  Timezone?: string | undefined;
  IAMDatabaseAuthenticationEnabled?: boolean | undefined;
  ProcessorFeatures?: ProcessorFeature[] | undefined;
  DbiResourceId?: string | undefined;
  TagList?: Tag[] | undefined;
  OriginalSnapshotCreateTime?: Date | undefined;
  SnapshotDatabaseTime?: Date | undefined;
  SnapshotTarget?: string | undefined;
  StorageThroughput?: number | undefined;
  DBSystemId?: string | undefined;
  DedicatedLogVolume?: boolean | undefined;
  MultiTenant?: boolean | undefined;
  SnapshotAvailabilityZone?: string | undefined;
}
export interface CopyDBSnapshotResult {
  DBSnapshot?: DBSnapshot | undefined;
}
export declare class CustomAvailabilityZoneNotFoundFault extends __BaseException {
  readonly name: "CustomAvailabilityZoneNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CustomAvailabilityZoneNotFoundFault,
      __BaseException
    >
  );
}
export declare class DBSnapshotAlreadyExistsFault extends __BaseException {
  readonly name: "DBSnapshotAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBSnapshotAlreadyExistsFault, __BaseException>
  );
}
export declare class InvalidDBSnapshotStateFault extends __BaseException {
  readonly name: "InvalidDBSnapshotStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidDBSnapshotStateFault, __BaseException>
  );
}
export interface CopyOptionGroupMessage {
  SourceOptionGroupIdentifier: string | undefined;
  TargetOptionGroupIdentifier: string | undefined;
  TargetOptionGroupDescription: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface DBSecurityGroupMembership {
  DBSecurityGroupName?: string | undefined;
  Status?: string | undefined;
}
export interface OptionSetting {
  Name?: string | undefined;
  Value?: string | undefined;
  DefaultValue?: string | undefined;
  Description?: string | undefined;
  ApplyType?: string | undefined;
  DataType?: string | undefined;
  AllowedValues?: string | undefined;
  IsModifiable?: boolean | undefined;
  IsCollection?: boolean | undefined;
}
export interface VpcSecurityGroupMembership {
  VpcSecurityGroupId?: string | undefined;
  Status?: string | undefined;
}
export interface Option {
  OptionName?: string | undefined;
  OptionDescription?: string | undefined;
  Persistent?: boolean | undefined;
  Permanent?: boolean | undefined;
  Port?: number | undefined;
  OptionVersion?: string | undefined;
  OptionSettings?: OptionSetting[] | undefined;
  DBSecurityGroupMemberships?: DBSecurityGroupMembership[] | undefined;
  VpcSecurityGroupMemberships?: VpcSecurityGroupMembership[] | undefined;
}
export interface OptionGroup {
  OptionGroupName?: string | undefined;
  OptionGroupDescription?: string | undefined;
  EngineName?: string | undefined;
  MajorEngineVersion?: string | undefined;
  Options?: Option[] | undefined;
  AllowsVpcAndNonVpcInstanceMemberships?: boolean | undefined;
  VpcId?: string | undefined;
  OptionGroupArn?: string | undefined;
  SourceOptionGroup?: string | undefined;
  SourceAccountId?: string | undefined;
  CopyTimestamp?: Date | undefined;
}
export interface CopyOptionGroupResult {
  OptionGroup?: OptionGroup | undefined;
}
export declare class OptionGroupAlreadyExistsFault extends __BaseException {
  readonly name: "OptionGroupAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<OptionGroupAlreadyExistsFault, __BaseException>
  );
}
export declare class OptionGroupNotFoundFault extends __BaseException {
  readonly name: "OptionGroupNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<OptionGroupNotFoundFault, __BaseException>
  );
}
export declare class OptionGroupQuotaExceededFault extends __BaseException {
  readonly name: "OptionGroupQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<OptionGroupQuotaExceededFault, __BaseException>
  );
}
export declare class BlueGreenDeploymentAlreadyExistsFault extends __BaseException {
  readonly name: "BlueGreenDeploymentAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      BlueGreenDeploymentAlreadyExistsFault,
      __BaseException
    >
  );
}
export interface CreateBlueGreenDeploymentRequest {
  BlueGreenDeploymentName: string | undefined;
  Source: string | undefined;
  TargetEngineVersion?: string | undefined;
  TargetDBParameterGroupName?: string | undefined;
  TargetDBClusterParameterGroupName?: string | undefined;
  Tags?: Tag[] | undefined;
  TargetDBInstanceClass?: string | undefined;
  UpgradeTargetStorageConfig?: boolean | undefined;
  TargetIops?: number | undefined;
  TargetStorageType?: string | undefined;
  TargetAllocatedStorage?: number | undefined;
  TargetStorageThroughput?: number | undefined;
}
export interface SwitchoverDetail {
  SourceMember?: string | undefined;
  TargetMember?: string | undefined;
  Status?: string | undefined;
}
export interface BlueGreenDeploymentTask {
  Name?: string | undefined;
  Status?: string | undefined;
}
export interface BlueGreenDeployment {
  BlueGreenDeploymentIdentifier?: string | undefined;
  BlueGreenDeploymentName?: string | undefined;
  Source?: string | undefined;
  Target?: string | undefined;
  SwitchoverDetails?: SwitchoverDetail[] | undefined;
  Tasks?: BlueGreenDeploymentTask[] | undefined;
  Status?: string | undefined;
  StatusDetails?: string | undefined;
  CreateTime?: Date | undefined;
  DeleteTime?: Date | undefined;
  TagList?: Tag[] | undefined;
}
export interface CreateBlueGreenDeploymentResponse {
  BlueGreenDeployment?: BlueGreenDeployment | undefined;
}
export declare class DBClusterParameterGroupNotFoundFault extends __BaseException {
  readonly name: "DBClusterParameterGroupNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBClusterParameterGroupNotFoundFault,
      __BaseException
    >
  );
}
export declare class DBClusterQuotaExceededFault extends __BaseException {
  readonly name: "DBClusterQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBClusterQuotaExceededFault, __BaseException>
  );
}
export declare class InstanceQuotaExceededFault extends __BaseException {
  readonly name: "InstanceQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InstanceQuotaExceededFault, __BaseException>
  );
}
export declare class SourceClusterNotSupportedFault extends __BaseException {
  readonly name: "SourceClusterNotSupportedFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<SourceClusterNotSupportedFault, __BaseException>
  );
}
export declare class SourceDatabaseNotSupportedFault extends __BaseException {
  readonly name: "SourceDatabaseNotSupportedFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      SourceDatabaseNotSupportedFault,
      __BaseException
    >
  );
}
export declare class CreateCustomDBEngineVersionFault extends __BaseException {
  readonly name: "CreateCustomDBEngineVersionFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CreateCustomDBEngineVersionFault,
      __BaseException
    >
  );
}
export interface CreateCustomDBEngineVersionMessage {
  Engine: string | undefined;
  EngineVersion: string | undefined;
  DatabaseInstallationFilesS3BucketName?: string | undefined;
  DatabaseInstallationFilesS3Prefix?: string | undefined;
  ImageId?: string | undefined;
  KMSKeyId?: string | undefined;
  Description?: string | undefined;
  Manifest?: string | undefined;
  Tags?: Tag[] | undefined;
  SourceCustomDbEngineVersionIdentifier?: string | undefined;
  UseAwsProvidedLatestImage?: boolean | undefined;
}
export declare class CustomDBEngineVersionAlreadyExistsFault extends __BaseException {
  readonly name: "CustomDBEngineVersionAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CustomDBEngineVersionAlreadyExistsFault,
      __BaseException
    >
  );
}
export declare class CustomDBEngineVersionQuotaExceededFault extends __BaseException {
  readonly name: "CustomDBEngineVersionQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CustomDBEngineVersionQuotaExceededFault,
      __BaseException
    >
  );
}
export interface CharacterSet {
  CharacterSetName?: string | undefined;
  CharacterSetDescription?: string | undefined;
}
export interface CustomDBEngineVersionAMI {
  ImageId?: string | undefined;
  Status?: string | undefined;
}
export interface ServerlessV2FeaturesSupport {
  MinCapacity?: number | undefined;
  MaxCapacity?: number | undefined;
}
export interface Timezone {
  TimezoneName?: string | undefined;
}
export interface UpgradeTarget {
  Engine?: string | undefined;
  EngineVersion?: string | undefined;
  Description?: string | undefined;
  AutoUpgrade?: boolean | undefined;
  IsMajorVersionUpgrade?: boolean | undefined;
  SupportedEngineModes?: string[] | undefined;
  SupportsParallelQuery?: boolean | undefined;
  SupportsGlobalDatabases?: boolean | undefined;
  SupportsBabelfish?: boolean | undefined;
  SupportsLimitlessDatabase?: boolean | undefined;
  SupportsLocalWriteForwarding?: boolean | undefined;
  SupportsIntegrations?: boolean | undefined;
}
export interface DBEngineVersion {
  Engine?: string | undefined;
  EngineVersion?: string | undefined;
  DBParameterGroupFamily?: string | undefined;
  DBEngineDescription?: string | undefined;
  DBEngineVersionDescription?: string | undefined;
  DefaultCharacterSet?: CharacterSet | undefined;
  Image?: CustomDBEngineVersionAMI | undefined;
  DBEngineMediaType?: string | undefined;
  SupportedCharacterSets?: CharacterSet[] | undefined;
  SupportedNcharCharacterSets?: CharacterSet[] | undefined;
  ValidUpgradeTarget?: UpgradeTarget[] | undefined;
  SupportedTimezones?: Timezone[] | undefined;
  ExportableLogTypes?: string[] | undefined;
  SupportsLogExportsToCloudwatchLogs?: boolean | undefined;
  SupportsReadReplica?: boolean | undefined;
  SupportedEngineModes?: string[] | undefined;
  SupportedFeatureNames?: string[] | undefined;
  Status?: string | undefined;
  SupportsParallelQuery?: boolean | undefined;
  SupportsGlobalDatabases?: boolean | undefined;
  MajorEngineVersion?: string | undefined;
  DatabaseInstallationFilesS3BucketName?: string | undefined;
  DatabaseInstallationFilesS3Prefix?: string | undefined;
  DBEngineVersionArn?: string | undefined;
  KMSKeyId?: string | undefined;
  CreateTime?: Date | undefined;
  TagList?: Tag[] | undefined;
  SupportsBabelfish?: boolean | undefined;
  CustomDBEngineVersionManifest?: string | undefined;
  SupportsLimitlessDatabase?: boolean | undefined;
  SupportsCertificateRotationWithoutRestart?: boolean | undefined;
  SupportedCACertificateIdentifiers?: string[] | undefined;
  SupportsLocalWriteForwarding?: boolean | undefined;
  SupportsIntegrations?: boolean | undefined;
  ServerlessV2FeaturesSupport?: ServerlessV2FeaturesSupport | undefined;
}
export declare class Ec2ImagePropertiesNotSupportedFault extends __BaseException {
  readonly name: "Ec2ImagePropertiesNotSupportedFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      Ec2ImagePropertiesNotSupportedFault,
      __BaseException
    >
  );
}
export declare const ClusterScalabilityType: {
  readonly LIMITLESS: "limitless";
  readonly STANDARD: "standard";
};
export type ClusterScalabilityType =
  (typeof ClusterScalabilityType)[keyof typeof ClusterScalabilityType];
export declare const DatabaseInsightsMode: {
  readonly ADVANCED: "advanced";
  readonly STANDARD: "standard";
};
export type DatabaseInsightsMode =
  (typeof DatabaseInsightsMode)[keyof typeof DatabaseInsightsMode];
export declare const ReplicaMode: {
  readonly MOUNTED: "mounted";
  readonly OPEN_READ_ONLY: "open-read-only";
};
export type ReplicaMode = (typeof ReplicaMode)[keyof typeof ReplicaMode];
export interface RdsCustomClusterConfiguration {
  InterconnectSubnetId?: string | undefined;
  TransitGatewayMulticastDomainId?: string | undefined;
  ReplicaMode?: ReplicaMode | undefined;
}
export interface ScalingConfiguration {
  MinCapacity?: number | undefined;
  MaxCapacity?: number | undefined;
  AutoPause?: boolean | undefined;
  SecondsUntilAutoPause?: number | undefined;
  TimeoutAction?: string | undefined;
  SecondsBeforeTimeout?: number | undefined;
}
export interface ServerlessV2ScalingConfiguration {
  MinCapacity?: number | undefined;
  MaxCapacity?: number | undefined;
  SecondsUntilAutoPause?: number | undefined;
}
export interface CreateDBClusterMessage {
  AvailabilityZones?: string[] | undefined;
  BackupRetentionPeriod?: number | undefined;
  CharacterSetName?: string | undefined;
  DatabaseName?: string | undefined;
  DBClusterIdentifier: string | undefined;
  DBClusterParameterGroupName?: string | undefined;
  VpcSecurityGroupIds?: string[] | undefined;
  DBSubnetGroupName?: string | undefined;
  Engine: string | undefined;
  EngineVersion?: string | undefined;
  Port?: number | undefined;
  MasterUsername?: string | undefined;
  MasterUserPassword?: string | undefined;
  OptionGroupName?: string | undefined;
  PreferredBackupWindow?: string | undefined;
  PreferredMaintenanceWindow?: string | undefined;
  ReplicationSourceIdentifier?: string | undefined;
  Tags?: Tag[] | undefined;
  StorageEncrypted?: boolean | undefined;
  KmsKeyId?: string | undefined;
  PreSignedUrl?: string | undefined;
  EnableIAMDatabaseAuthentication?: boolean | undefined;
  BacktrackWindow?: number | undefined;
  EnableCloudwatchLogsExports?: string[] | undefined;
  EngineMode?: string | undefined;
  ScalingConfiguration?: ScalingConfiguration | undefined;
  RdsCustomClusterConfiguration?: RdsCustomClusterConfiguration | undefined;
  DeletionProtection?: boolean | undefined;
  GlobalClusterIdentifier?: string | undefined;
  EnableHttpEndpoint?: boolean | undefined;
  CopyTagsToSnapshot?: boolean | undefined;
  Domain?: string | undefined;
  DomainIAMRoleName?: string | undefined;
  EnableGlobalWriteForwarding?: boolean | undefined;
  DBClusterInstanceClass?: string | undefined;
  AllocatedStorage?: number | undefined;
  StorageType?: string | undefined;
  Iops?: number | undefined;
  PubliclyAccessible?: boolean | undefined;
  AutoMinorVersionUpgrade?: boolean | undefined;
  MonitoringInterval?: number | undefined;
  MonitoringRoleArn?: string | undefined;
  DatabaseInsightsMode?: DatabaseInsightsMode | undefined;
  EnablePerformanceInsights?: boolean | undefined;
  PerformanceInsightsKMSKeyId?: string | undefined;
  PerformanceInsightsRetentionPeriod?: number | undefined;
  EnableLimitlessDatabase?: boolean | undefined;
  ServerlessV2ScalingConfiguration?:
    | ServerlessV2ScalingConfiguration
    | undefined;
  NetworkType?: string | undefined;
  ClusterScalabilityType?: ClusterScalabilityType | undefined;
  DBSystemId?: string | undefined;
  ManageMasterUserPassword?: boolean | undefined;
  MasterUserSecretKmsKeyId?: string | undefined;
  EnableLocalWriteForwarding?: boolean | undefined;
  CACertificateIdentifier?: string | undefined;
  EngineLifecycleSupport?: string | undefined;
}
export interface DBClusterRole {
  RoleArn?: string | undefined;
  Status?: string | undefined;
  FeatureName?: string | undefined;
}
export interface CertificateDetails {
  CAIdentifier?: string | undefined;
  ValidTill?: Date | undefined;
}
export interface DBClusterMember {
  DBInstanceIdentifier?: string | undefined;
  IsClusterWriter?: boolean | undefined;
  DBClusterParameterGroupStatus?: string | undefined;
  PromotionTier?: number | undefined;
}
export interface DBClusterOptionGroupStatus {
  DBClusterOptionGroupName?: string | undefined;
  Status?: string | undefined;
}
export interface DomainMembership {
  Domain?: string | undefined;
  Status?: string | undefined;
  FQDN?: string | undefined;
  IAMRoleName?: string | undefined;
  OU?: string | undefined;
  AuthSecretArn?: string | undefined;
  DnsIps?: string[] | undefined;
}
export declare const WriteForwardingStatus: {
  readonly DISABLED: "disabled";
  readonly DISABLING: "disabling";
  readonly ENABLED: "enabled";
  readonly ENABLING: "enabling";
  readonly UNKNOWN: "unknown";
};
export type WriteForwardingStatus =
  (typeof WriteForwardingStatus)[keyof typeof WriteForwardingStatus];
export declare const LimitlessDatabaseStatus: {
  readonly ACTIVE: "active";
  readonly DISABLED: "disabled";
  readonly DISABLING: "disabling";
  readonly ENABLED: "enabled";
  readonly ENABLING: "enabling";
  readonly ERROR: "error";
  readonly MODIFYING_MAX_CAPACITY: "modifying-max-capacity";
  readonly NOT_IN_USE: "not-in-use";
};
export type LimitlessDatabaseStatus =
  (typeof LimitlessDatabaseStatus)[keyof typeof LimitlessDatabaseStatus];
export interface LimitlessDatabase {
  Status?: LimitlessDatabaseStatus | undefined;
  MinRequiredACU?: number | undefined;
}
export declare const LocalWriteForwardingStatus: {
  readonly DISABLED: "disabled";
  readonly DISABLING: "disabling";
  readonly ENABLED: "enabled";
  readonly ENABLING: "enabling";
  readonly REQUESTED: "requested";
};
export type LocalWriteForwardingStatus =
  (typeof LocalWriteForwardingStatus)[keyof typeof LocalWriteForwardingStatus];
export interface MasterUserSecret {
  SecretArn?: string | undefined;
  SecretStatus?: string | undefined;
  KmsKeyId?: string | undefined;
}
export interface PendingCloudwatchLogsExports {
  LogTypesToEnable?: string[] | undefined;
  LogTypesToDisable?: string[] | undefined;
}
export interface ClusterPendingModifiedValues {
  PendingCloudwatchLogsExports?: PendingCloudwatchLogsExports | undefined;
  DBClusterIdentifier?: string | undefined;
  MasterUserPassword?: string | undefined;
  IAMDatabaseAuthenticationEnabled?: boolean | undefined;
  EngineVersion?: string | undefined;
  BackupRetentionPeriod?: number | undefined;
  AllocatedStorage?: number | undefined;
  RdsCustomClusterConfiguration?: RdsCustomClusterConfiguration | undefined;
  Iops?: number | undefined;
  StorageType?: string | undefined;
  CertificateDetails?: CertificateDetails | undefined;
}
export interface ScalingConfigurationInfo {
  MinCapacity?: number | undefined;
  MaxCapacity?: number | undefined;
  AutoPause?: boolean | undefined;
  SecondsUntilAutoPause?: number | undefined;
  TimeoutAction?: string | undefined;
  SecondsBeforeTimeout?: number | undefined;
}
export interface ServerlessV2ScalingConfigurationInfo {
  MinCapacity?: number | undefined;
  MaxCapacity?: number | undefined;
  SecondsUntilAutoPause?: number | undefined;
}
export interface DBClusterStatusInfo {
  StatusType?: string | undefined;
  Normal?: boolean | undefined;
  Status?: string | undefined;
  Message?: string | undefined;
}
export interface DBCluster {
  AllocatedStorage?: number | undefined;
  AvailabilityZones?: string[] | undefined;
  BackupRetentionPeriod?: number | undefined;
  CharacterSetName?: string | undefined;
  DatabaseName?: string | undefined;
  DBClusterIdentifier?: string | undefined;
  DBClusterParameterGroup?: string | undefined;
  DBSubnetGroup?: string | undefined;
  Status?: string | undefined;
  AutomaticRestartTime?: Date | undefined;
  PercentProgress?: string | undefined;
  EarliestRestorableTime?: Date | undefined;
  Endpoint?: string | undefined;
  ReaderEndpoint?: string | undefined;
  CustomEndpoints?: string[] | undefined;
  MultiAZ?: boolean | undefined;
  Engine?: string | undefined;
  EngineVersion?: string | undefined;
  LatestRestorableTime?: Date | undefined;
  Port?: number | undefined;
  MasterUsername?: string | undefined;
  DBClusterOptionGroupMemberships?: DBClusterOptionGroupStatus[] | undefined;
  PreferredBackupWindow?: string | undefined;
  PreferredMaintenanceWindow?: string | undefined;
  ReplicationSourceIdentifier?: string | undefined;
  ReadReplicaIdentifiers?: string[] | undefined;
  StatusInfos?: DBClusterStatusInfo[] | undefined;
  DBClusterMembers?: DBClusterMember[] | undefined;
  VpcSecurityGroups?: VpcSecurityGroupMembership[] | undefined;
  HostedZoneId?: string | undefined;
  StorageEncrypted?: boolean | undefined;
  KmsKeyId?: string | undefined;
  DbClusterResourceId?: string | undefined;
  DBClusterArn?: string | undefined;
  AssociatedRoles?: DBClusterRole[] | undefined;
  IAMDatabaseAuthenticationEnabled?: boolean | undefined;
  CloneGroupId?: string | undefined;
  ClusterCreateTime?: Date | undefined;
  EarliestBacktrackTime?: Date | undefined;
  BacktrackWindow?: number | undefined;
  BacktrackConsumedChangeRecords?: number | undefined;
  EnabledCloudwatchLogsExports?: string[] | undefined;
  Capacity?: number | undefined;
  EngineMode?: string | undefined;
  ScalingConfigurationInfo?: ScalingConfigurationInfo | undefined;
  RdsCustomClusterConfiguration?: RdsCustomClusterConfiguration | undefined;
  DeletionProtection?: boolean | undefined;
  HttpEndpointEnabled?: boolean | undefined;
  ActivityStreamMode?: ActivityStreamMode | undefined;
  ActivityStreamStatus?: ActivityStreamStatus | undefined;
  ActivityStreamKmsKeyId?: string | undefined;
  ActivityStreamKinesisStreamName?: string | undefined;
  CopyTagsToSnapshot?: boolean | undefined;
  CrossAccountClone?: boolean | undefined;
  DomainMemberships?: DomainMembership[] | undefined;
  TagList?: Tag[] | undefined;
  GlobalClusterIdentifier?: string | undefined;
  GlobalWriteForwardingStatus?: WriteForwardingStatus | undefined;
  GlobalWriteForwardingRequested?: boolean | undefined;
  PendingModifiedValues?: ClusterPendingModifiedValues | undefined;
  DBClusterInstanceClass?: string | undefined;
  StorageType?: string | undefined;
  Iops?: number | undefined;
  PubliclyAccessible?: boolean | undefined;
  AutoMinorVersionUpgrade?: boolean | undefined;
  MonitoringInterval?: number | undefined;
  MonitoringRoleArn?: string | undefined;
  DatabaseInsightsMode?: DatabaseInsightsMode | undefined;
  PerformanceInsightsEnabled?: boolean | undefined;
  PerformanceInsightsKMSKeyId?: string | undefined;
  PerformanceInsightsRetentionPeriod?: number | undefined;
  ServerlessV2ScalingConfiguration?:
    | ServerlessV2ScalingConfigurationInfo
    | undefined;
  NetworkType?: string | undefined;
  DBSystemId?: string | undefined;
  MasterUserSecret?: MasterUserSecret | undefined;
  IOOptimizedNextAllowedModificationTime?: Date | undefined;
  LocalWriteForwardingStatus?: LocalWriteForwardingStatus | undefined;
  AwsBackupRecoveryPointArn?: string | undefined;
  LimitlessDatabase?: LimitlessDatabase | undefined;
  StorageThroughput?: number | undefined;
  ClusterScalabilityType?: ClusterScalabilityType | undefined;
  CertificateDetails?: CertificateDetails | undefined;
  EngineLifecycleSupport?: string | undefined;
}
export interface CreateDBClusterResult {
  DBCluster?: DBCluster | undefined;
}
export declare class DBClusterAlreadyExistsFault extends __BaseException {
  readonly name: "DBClusterAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBClusterAlreadyExistsFault, __BaseException>
  );
}
export declare class DBSubnetGroupDoesNotCoverEnoughAZs extends __BaseException {
  readonly name: "DBSubnetGroupDoesNotCoverEnoughAZs";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBSubnetGroupDoesNotCoverEnoughAZs,
      __BaseException
    >
  );
}
export declare class DBSubnetGroupNotFoundFault extends __BaseException {
  readonly name: "DBSubnetGroupNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBSubnetGroupNotFoundFault, __BaseException>
  );
}
export declare class DomainNotFoundFault extends __BaseException {
  readonly name: "DomainNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DomainNotFoundFault, __BaseException>
  );
}
export declare class GlobalClusterNotFoundFault extends __BaseException {
  readonly name: "GlobalClusterNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<GlobalClusterNotFoundFault, __BaseException>
  );
}
export declare class InsufficientDBInstanceCapacityFault extends __BaseException {
  readonly name: "InsufficientDBInstanceCapacityFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InsufficientDBInstanceCapacityFault,
      __BaseException
    >
  );
}
export declare class InsufficientStorageClusterCapacityFault extends __BaseException {
  readonly name: "InsufficientStorageClusterCapacityFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InsufficientStorageClusterCapacityFault,
      __BaseException
    >
  );
}
export declare class InvalidDBSubnetGroupFault extends __BaseException {
  readonly name: "InvalidDBSubnetGroupFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidDBSubnetGroupFault, __BaseException>
  );
}
export declare class InvalidDBSubnetGroupStateFault extends __BaseException {
  readonly name: "InvalidDBSubnetGroupStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidDBSubnetGroupStateFault, __BaseException>
  );
}
export declare class InvalidGlobalClusterStateFault extends __BaseException {
  readonly name: "InvalidGlobalClusterStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidGlobalClusterStateFault, __BaseException>
  );
}
export declare class InvalidSubnet extends __BaseException {
  readonly name: "InvalidSubnet";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<InvalidSubnet, __BaseException>);
}
export declare class InvalidVPCNetworkStateFault extends __BaseException {
  readonly name: "InvalidVPCNetworkStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidVPCNetworkStateFault, __BaseException>
  );
}
export declare class StorageQuotaExceededFault extends __BaseException {
  readonly name: "StorageQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<StorageQuotaExceededFault, __BaseException>
  );
}
export interface CreateDBClusterEndpointMessage {
  DBClusterIdentifier: string | undefined;
  DBClusterEndpointIdentifier: string | undefined;
  EndpointType: string | undefined;
  StaticMembers?: string[] | undefined;
  ExcludedMembers?: string[] | undefined;
  Tags?: Tag[] | undefined;
}
export interface DBClusterEndpoint {
  DBClusterEndpointIdentifier?: string | undefined;
  DBClusterIdentifier?: string | undefined;
  DBClusterEndpointResourceIdentifier?: string | undefined;
  Endpoint?: string | undefined;
  Status?: string | undefined;
  EndpointType?: string | undefined;
  CustomEndpointType?: string | undefined;
  StaticMembers?: string[] | undefined;
  ExcludedMembers?: string[] | undefined;
  DBClusterEndpointArn?: string | undefined;
}
export declare class DBClusterEndpointAlreadyExistsFault extends __BaseException {
  readonly name: "DBClusterEndpointAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBClusterEndpointAlreadyExistsFault,
      __BaseException
    >
  );
}
export declare class DBClusterEndpointQuotaExceededFault extends __BaseException {
  readonly name: "DBClusterEndpointQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBClusterEndpointQuotaExceededFault,
      __BaseException
    >
  );
}
export interface CreateDBClusterParameterGroupMessage {
  DBClusterParameterGroupName: string | undefined;
  DBParameterGroupFamily: string | undefined;
  Description: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateDBClusterParameterGroupResult {
  DBClusterParameterGroup?: DBClusterParameterGroup | undefined;
}
export interface CreateDBClusterSnapshotMessage {
  DBClusterSnapshotIdentifier: string | undefined;
  DBClusterIdentifier: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateDBClusterSnapshotResult {
  DBClusterSnapshot?: DBClusterSnapshot | undefined;
}
export declare class AuthorizationNotFoundFault extends __BaseException {
  readonly name: "AuthorizationNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<AuthorizationNotFoundFault, __BaseException>
  );
}
export declare class BackupPolicyNotFoundFault extends __BaseException {
  readonly name: "BackupPolicyNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<BackupPolicyNotFoundFault, __BaseException>
  );
}
export declare class CertificateNotFoundFault extends __BaseException {
  readonly name: "CertificateNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<CertificateNotFoundFault, __BaseException>
  );
}
export interface CreateDBInstanceMessage {
  DBName?: string | undefined;
  DBInstanceIdentifier: string | undefined;
  AllocatedStorage?: number | undefined;
  DBInstanceClass: string | undefined;
  Engine: string | undefined;
  MasterUsername?: string | undefined;
  MasterUserPassword?: string | undefined;
  DBSecurityGroups?: string[] | undefined;
  VpcSecurityGroupIds?: string[] | undefined;
  AvailabilityZone?: string | undefined;
  DBSubnetGroupName?: string | undefined;
  PreferredMaintenanceWindow?: string | undefined;
  DBParameterGroupName?: string | undefined;
  BackupRetentionPeriod?: number | undefined;
  PreferredBackupWindow?: string | undefined;
  Port?: number | undefined;
  MultiAZ?: boolean | undefined;
  EngineVersion?: string | undefined;
  AutoMinorVersionUpgrade?: boolean | undefined;
  LicenseModel?: string | undefined;
  Iops?: number | undefined;
  OptionGroupName?: string | undefined;
  CharacterSetName?: string | undefined;
  NcharCharacterSetName?: string | undefined;
  PubliclyAccessible?: boolean | undefined;
  Tags?: Tag[] | undefined;
  DBClusterIdentifier?: string | undefined;
  StorageType?: string | undefined;
  TdeCredentialArn?: string | undefined;
  TdeCredentialPassword?: string | undefined;
  StorageEncrypted?: boolean | undefined;
  KmsKeyId?: string | undefined;
  Domain?: string | undefined;
  DomainFqdn?: string | undefined;
  DomainOu?: string | undefined;
  DomainAuthSecretArn?: string | undefined;
  DomainDnsIps?: string[] | undefined;
  CopyTagsToSnapshot?: boolean | undefined;
  MonitoringInterval?: number | undefined;
  MonitoringRoleArn?: string | undefined;
  DomainIAMRoleName?: string | undefined;
  PromotionTier?: number | undefined;
  Timezone?: string | undefined;
  EnableIAMDatabaseAuthentication?: boolean | undefined;
  DatabaseInsightsMode?: DatabaseInsightsMode | undefined;
  EnablePerformanceInsights?: boolean | undefined;
  PerformanceInsightsKMSKeyId?: string | undefined;
  PerformanceInsightsRetentionPeriod?: number | undefined;
  EnableCloudwatchLogsExports?: string[] | undefined;
  ProcessorFeatures?: ProcessorFeature[] | undefined;
  DeletionProtection?: boolean | undefined;
  MaxAllocatedStorage?: number | undefined;
  EnableCustomerOwnedIp?: boolean | undefined;
  CustomIamInstanceProfile?: string | undefined;
  BackupTarget?: string | undefined;
  NetworkType?: string | undefined;
  StorageThroughput?: number | undefined;
  ManageMasterUserPassword?: boolean | undefined;
  MasterUserSecretKmsKeyId?: string | undefined;
  CACertificateIdentifier?: string | undefined;
  DBSystemId?: string | undefined;
  DedicatedLogVolume?: boolean | undefined;
  MultiTenant?: boolean | undefined;
  EngineLifecycleSupport?: string | undefined;
}
export interface DBInstanceRole {
  RoleArn?: string | undefined;
  FeatureName?: string | undefined;
  Status?: string | undefined;
}
export declare const AutomationMode: {
  readonly ALL_PAUSED: "all-paused";
  readonly FULL: "full";
};
export type AutomationMode =
  (typeof AutomationMode)[keyof typeof AutomationMode];
export interface DBInstanceAutomatedBackupsReplication {
  DBInstanceAutomatedBackupsArn?: string | undefined;
}
export interface DBParameterGroupStatus {
  DBParameterGroupName?: string | undefined;
  ParameterApplyStatus?: string | undefined;
}
export interface AvailabilityZone {
  Name?: string | undefined;
}
export interface Outpost {
  Arn?: string | undefined;
}
export interface Subnet {
  SubnetIdentifier?: string | undefined;
  SubnetAvailabilityZone?: AvailabilityZone | undefined;
  SubnetOutpost?: Outpost | undefined;
  SubnetStatus?: string | undefined;
}
export interface DBSubnetGroup {
  DBSubnetGroupName?: string | undefined;
  DBSubnetGroupDescription?: string | undefined;
  VpcId?: string | undefined;
  SubnetGroupStatus?: string | undefined;
  Subnets?: Subnet[] | undefined;
  DBSubnetGroupArn?: string | undefined;
  SupportedNetworkTypes?: string[] | undefined;
}
export interface Endpoint {
  Address?: string | undefined;
  Port?: number | undefined;
  HostedZoneId?: string | undefined;
}
export interface OptionGroupMembership {
  OptionGroupName?: string | undefined;
  Status?: string | undefined;
}
export interface PendingModifiedValues {
  DBInstanceClass?: string | undefined;
  AllocatedStorage?: number | undefined;
  MasterUserPassword?: string | undefined;
  Port?: number | undefined;
  BackupRetentionPeriod?: number | undefined;
  MultiAZ?: boolean | undefined;
  EngineVersion?: string | undefined;
  LicenseModel?: string | undefined;
  Iops?: number | undefined;
  DBInstanceIdentifier?: string | undefined;
  StorageType?: string | undefined;
  CACertificateIdentifier?: string | undefined;
  DBSubnetGroupName?: string | undefined;
  PendingCloudwatchLogsExports?: PendingCloudwatchLogsExports | undefined;
  ProcessorFeatures?: ProcessorFeature[] | undefined;
  IAMDatabaseAuthenticationEnabled?: boolean | undefined;
  AutomationMode?: AutomationMode | undefined;
  ResumeFullAutomationModeTime?: Date | undefined;
  StorageThroughput?: number | undefined;
  Engine?: string | undefined;
  DedicatedLogVolume?: boolean | undefined;
  MultiTenant?: boolean | undefined;
}
export interface DBInstanceStatusInfo {
  StatusType?: string | undefined;
  Normal?: boolean | undefined;
  Status?: string | undefined;
  Message?: string | undefined;
}
export interface DBInstance {
  DBInstanceIdentifier?: string | undefined;
  DBInstanceClass?: string | undefined;
  Engine?: string | undefined;
  DBInstanceStatus?: string | undefined;
  AutomaticRestartTime?: Date | undefined;
  MasterUsername?: string | undefined;
  DBName?: string | undefined;
  Endpoint?: Endpoint | undefined;
  AllocatedStorage?: number | undefined;
  InstanceCreateTime?: Date | undefined;
  PreferredBackupWindow?: string | undefined;
  BackupRetentionPeriod?: number | undefined;
  DBSecurityGroups?: DBSecurityGroupMembership[] | undefined;
  VpcSecurityGroups?: VpcSecurityGroupMembership[] | undefined;
  DBParameterGroups?: DBParameterGroupStatus[] | undefined;
  AvailabilityZone?: string | undefined;
  DBSubnetGroup?: DBSubnetGroup | undefined;
  PreferredMaintenanceWindow?: string | undefined;
  PendingModifiedValues?: PendingModifiedValues | undefined;
  LatestRestorableTime?: Date | undefined;
  MultiAZ?: boolean | undefined;
  EngineVersion?: string | undefined;
  AutoMinorVersionUpgrade?: boolean | undefined;
  ReadReplicaSourceDBInstanceIdentifier?: string | undefined;
  ReadReplicaDBInstanceIdentifiers?: string[] | undefined;
  ReadReplicaDBClusterIdentifiers?: string[] | undefined;
  ReplicaMode?: ReplicaMode | undefined;
  LicenseModel?: string | undefined;
  Iops?: number | undefined;
  OptionGroupMemberships?: OptionGroupMembership[] | undefined;
  CharacterSetName?: string | undefined;
  NcharCharacterSetName?: string | undefined;
  SecondaryAvailabilityZone?: string | undefined;
  PubliclyAccessible?: boolean | undefined;
  StatusInfos?: DBInstanceStatusInfo[] | undefined;
  StorageType?: string | undefined;
  TdeCredentialArn?: string | undefined;
  DbInstancePort?: number | undefined;
  DBClusterIdentifier?: string | undefined;
  StorageEncrypted?: boolean | undefined;
  KmsKeyId?: string | undefined;
  DbiResourceId?: string | undefined;
  CACertificateIdentifier?: string | undefined;
  DomainMemberships?: DomainMembership[] | undefined;
  CopyTagsToSnapshot?: boolean | undefined;
  MonitoringInterval?: number | undefined;
  EnhancedMonitoringResourceArn?: string | undefined;
  MonitoringRoleArn?: string | undefined;
  PromotionTier?: number | undefined;
  DBInstanceArn?: string | undefined;
  Timezone?: string | undefined;
  IAMDatabaseAuthenticationEnabled?: boolean | undefined;
  DatabaseInsightsMode?: DatabaseInsightsMode | undefined;
  PerformanceInsightsEnabled?: boolean | undefined;
  PerformanceInsightsKMSKeyId?: string | undefined;
  PerformanceInsightsRetentionPeriod?: number | undefined;
  EnabledCloudwatchLogsExports?: string[] | undefined;
  ProcessorFeatures?: ProcessorFeature[] | undefined;
  DeletionProtection?: boolean | undefined;
  AssociatedRoles?: DBInstanceRole[] | undefined;
  ListenerEndpoint?: Endpoint | undefined;
  MaxAllocatedStorage?: number | undefined;
  TagList?: Tag[] | undefined;
  DBInstanceAutomatedBackupsReplications?:
    | DBInstanceAutomatedBackupsReplication[]
    | undefined;
  CustomerOwnedIpEnabled?: boolean | undefined;
  AwsBackupRecoveryPointArn?: string | undefined;
  ActivityStreamStatus?: ActivityStreamStatus | undefined;
  ActivityStreamKmsKeyId?: string | undefined;
  ActivityStreamKinesisStreamName?: string | undefined;
  ActivityStreamMode?: ActivityStreamMode | undefined;
  ActivityStreamEngineNativeAuditFieldsIncluded?: boolean | undefined;
  AutomationMode?: AutomationMode | undefined;
  ResumeFullAutomationModeTime?: Date | undefined;
  CustomIamInstanceProfile?: string | undefined;
  BackupTarget?: string | undefined;
  NetworkType?: string | undefined;
  ActivityStreamPolicyStatus?: ActivityStreamPolicyStatus | undefined;
  StorageThroughput?: number | undefined;
  DBSystemId?: string | undefined;
  MasterUserSecret?: MasterUserSecret | undefined;
  CertificateDetails?: CertificateDetails | undefined;
  ReadReplicaSourceDBClusterIdentifier?: string | undefined;
  PercentProgress?: string | undefined;
  DedicatedLogVolume?: boolean | undefined;
  IsStorageConfigUpgradeAvailable?: boolean | undefined;
  MultiTenant?: boolean | undefined;
  EngineLifecycleSupport?: string | undefined;
}
export interface CreateDBInstanceResult {
  DBInstance?: DBInstance | undefined;
}
export declare class DBInstanceAlreadyExistsFault extends __BaseException {
  readonly name: "DBInstanceAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBInstanceAlreadyExistsFault, __BaseException>
  );
}
export declare class NetworkTypeNotSupported extends __BaseException {
  readonly name: "NetworkTypeNotSupported";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<NetworkTypeNotSupported, __BaseException>
  );
}
export declare class ProvisionedIopsNotAvailableInAZFault extends __BaseException {
  readonly name: "ProvisionedIopsNotAvailableInAZFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ProvisionedIopsNotAvailableInAZFault,
      __BaseException
    >
  );
}
export declare class StorageTypeNotSupportedFault extends __BaseException {
  readonly name: "StorageTypeNotSupportedFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<StorageTypeNotSupportedFault, __BaseException>
  );
}
export declare class TenantDatabaseQuotaExceededFault extends __BaseException {
  readonly name: "TenantDatabaseQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      TenantDatabaseQuotaExceededFault,
      __BaseException
    >
  );
}
export interface CreateDBInstanceReadReplicaMessage {
  DBInstanceIdentifier: string | undefined;
  SourceDBInstanceIdentifier?: string | undefined;
  DBInstanceClass?: string | undefined;
  AvailabilityZone?: string | undefined;
  Port?: number | undefined;
  MultiAZ?: boolean | undefined;
  AutoMinorVersionUpgrade?: boolean | undefined;
  Iops?: number | undefined;
  OptionGroupName?: string | undefined;
  DBParameterGroupName?: string | undefined;
  PubliclyAccessible?: boolean | undefined;
  Tags?: Tag[] | undefined;
  DBSubnetGroupName?: string | undefined;
  VpcSecurityGroupIds?: string[] | undefined;
  StorageType?: string | undefined;
  CopyTagsToSnapshot?: boolean | undefined;
  MonitoringInterval?: number | undefined;
  MonitoringRoleArn?: string | undefined;
  KmsKeyId?: string | undefined;
  PreSignedUrl?: string | undefined;
  EnableIAMDatabaseAuthentication?: boolean | undefined;
  DatabaseInsightsMode?: DatabaseInsightsMode | undefined;
  EnablePerformanceInsights?: boolean | undefined;
  PerformanceInsightsKMSKeyId?: string | undefined;
  PerformanceInsightsRetentionPeriod?: number | undefined;
  EnableCloudwatchLogsExports?: string[] | undefined;
  ProcessorFeatures?: ProcessorFeature[] | undefined;
  UseDefaultProcessorFeatures?: boolean | undefined;
  DeletionProtection?: boolean | undefined;
  Domain?: string | undefined;
  DomainIAMRoleName?: string | undefined;
  DomainFqdn?: string | undefined;
  DomainOu?: string | undefined;
  DomainAuthSecretArn?: string | undefined;
  DomainDnsIps?: string[] | undefined;
  ReplicaMode?: ReplicaMode | undefined;
  MaxAllocatedStorage?: number | undefined;
  CustomIamInstanceProfile?: string | undefined;
  NetworkType?: string | undefined;
  StorageThroughput?: number | undefined;
  EnableCustomerOwnedIp?: boolean | undefined;
  BackupTarget?: string | undefined;
  AllocatedStorage?: number | undefined;
  SourceDBClusterIdentifier?: string | undefined;
  DedicatedLogVolume?: boolean | undefined;
  UpgradeStorageConfig?: boolean | undefined;
  CACertificateIdentifier?: string | undefined;
}
export interface CreateDBInstanceReadReplicaResult {
  DBInstance?: DBInstance | undefined;
}
export declare class DBSubnetGroupNotAllowedFault extends __BaseException {
  readonly name: "DBSubnetGroupNotAllowedFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBSubnetGroupNotAllowedFault, __BaseException>
  );
}
export interface CreateDBParameterGroupMessage {
  DBParameterGroupName: string | undefined;
  DBParameterGroupFamily: string | undefined;
  Description: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateDBParameterGroupResult {
  DBParameterGroup?: DBParameterGroup | undefined;
}
export declare const AuthScheme: {
  readonly SECRETS: "SECRETS";
};
export type AuthScheme = (typeof AuthScheme)[keyof typeof AuthScheme];
export declare const ClientPasswordAuthType: {
  readonly MYSQL_CACHING_SHA2_PASSWORD: "MYSQL_CACHING_SHA2_PASSWORD";
  readonly MYSQL_NATIVE_PASSWORD: "MYSQL_NATIVE_PASSWORD";
  readonly POSTGRES_MD5: "POSTGRES_MD5";
  readonly POSTGRES_SCRAM_SHA_256: "POSTGRES_SCRAM_SHA_256";
  readonly SQL_SERVER_AUTHENTICATION: "SQL_SERVER_AUTHENTICATION";
};
export type ClientPasswordAuthType =
  (typeof ClientPasswordAuthType)[keyof typeof ClientPasswordAuthType];
export declare const IAMAuthMode: {
  readonly DISABLED: "DISABLED";
  readonly ENABLED: "ENABLED";
  readonly REQUIRED: "REQUIRED";
};
export type IAMAuthMode = (typeof IAMAuthMode)[keyof typeof IAMAuthMode];
export interface UserAuthConfig {
  Description?: string | undefined;
  UserName?: string | undefined;
  AuthScheme?: AuthScheme | undefined;
  SecretArn?: string | undefined;
  IAMAuth?: IAMAuthMode | undefined;
  ClientPasswordAuthType?: ClientPasswordAuthType | undefined;
}
export declare const EngineFamily: {
  readonly MYSQL: "MYSQL";
  readonly POSTGRESQL: "POSTGRESQL";
  readonly SQLSERVER: "SQLSERVER";
};
export type EngineFamily = (typeof EngineFamily)[keyof typeof EngineFamily];
export interface CreateDBProxyRequest {
  DBProxyName: string | undefined;
  EngineFamily: EngineFamily | undefined;
  Auth: UserAuthConfig[] | undefined;
  RoleArn: string | undefined;
  VpcSubnetIds: string[] | undefined;
  VpcSecurityGroupIds?: string[] | undefined;
  RequireTLS?: boolean | undefined;
  IdleClientTimeout?: number | undefined;
  DebugLogging?: boolean | undefined;
  Tags?: Tag[] | undefined;
}
export interface UserAuthConfigInfo {
  Description?: string | undefined;
  UserName?: string | undefined;
  AuthScheme?: AuthScheme | undefined;
  SecretArn?: string | undefined;
  IAMAuth?: IAMAuthMode | undefined;
  ClientPasswordAuthType?: ClientPasswordAuthType | undefined;
}
export declare const DBProxyStatus: {
  readonly AVAILABLE: "available";
  readonly CREATING: "creating";
  readonly DELETING: "deleting";
  readonly INCOMPATIBLE_NETWORK: "incompatible-network";
  readonly INSUFFICIENT_RESOURCE_LIMITS: "insufficient-resource-limits";
  readonly MODIFYING: "modifying";
  readonly REACTIVATING: "reactivating";
  readonly SUSPENDED: "suspended";
  readonly SUSPENDING: "suspending";
};
export type DBProxyStatus = (typeof DBProxyStatus)[keyof typeof DBProxyStatus];
export interface DBProxy {
  DBProxyName?: string | undefined;
  DBProxyArn?: string | undefined;
  Status?: DBProxyStatus | undefined;
  EngineFamily?: string | undefined;
  VpcId?: string | undefined;
  VpcSecurityGroupIds?: string[] | undefined;
  VpcSubnetIds?: string[] | undefined;
  Auth?: UserAuthConfigInfo[] | undefined;
  RoleArn?: string | undefined;
  Endpoint?: string | undefined;
  RequireTLS?: boolean | undefined;
  IdleClientTimeout?: number | undefined;
  DebugLogging?: boolean | undefined;
  CreatedDate?: Date | undefined;
  UpdatedDate?: Date | undefined;
}
export interface CreateDBProxyResponse {
  DBProxy?: DBProxy | undefined;
}
export declare class DBProxyAlreadyExistsFault extends __BaseException {
  readonly name: "DBProxyAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBProxyAlreadyExistsFault, __BaseException>
  );
}
export declare class DBProxyQuotaExceededFault extends __BaseException {
  readonly name: "DBProxyQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBProxyQuotaExceededFault, __BaseException>
  );
}
export declare const DBProxyEndpointTargetRole: {
  readonly READ_ONLY: "READ_ONLY";
  readonly READ_WRITE: "READ_WRITE";
};
export type DBProxyEndpointTargetRole =
  (typeof DBProxyEndpointTargetRole)[keyof typeof DBProxyEndpointTargetRole];
export interface CreateDBProxyEndpointRequest {
  DBProxyName: string | undefined;
  DBProxyEndpointName: string | undefined;
  VpcSubnetIds: string[] | undefined;
  VpcSecurityGroupIds?: string[] | undefined;
  TargetRole?: DBProxyEndpointTargetRole | undefined;
  Tags?: Tag[] | undefined;
}
export declare const DBProxyEndpointStatus: {
  readonly AVAILABLE: "available";
  readonly CREATING: "creating";
  readonly DELETING: "deleting";
  readonly INCOMPATIBLE_NETWORK: "incompatible-network";
  readonly INSUFFICIENT_RESOURCE_LIMITS: "insufficient-resource-limits";
  readonly MODIFYING: "modifying";
};
export type DBProxyEndpointStatus =
  (typeof DBProxyEndpointStatus)[keyof typeof DBProxyEndpointStatus];
export interface DBProxyEndpoint {
  DBProxyEndpointName?: string | undefined;
  DBProxyEndpointArn?: string | undefined;
  DBProxyName?: string | undefined;
  Status?: DBProxyEndpointStatus | undefined;
  VpcId?: string | undefined;
  VpcSecurityGroupIds?: string[] | undefined;
  VpcSubnetIds?: string[] | undefined;
  Endpoint?: string | undefined;
  CreatedDate?: Date | undefined;
  TargetRole?: DBProxyEndpointTargetRole | undefined;
  IsDefault?: boolean | undefined;
}
export interface CreateDBProxyEndpointResponse {
  DBProxyEndpoint?: DBProxyEndpoint | undefined;
}
export declare class DBProxyEndpointAlreadyExistsFault extends __BaseException {
  readonly name: "DBProxyEndpointAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBProxyEndpointAlreadyExistsFault,
      __BaseException
    >
  );
}
export declare class DBProxyEndpointQuotaExceededFault extends __BaseException {
  readonly name: "DBProxyEndpointQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBProxyEndpointQuotaExceededFault,
      __BaseException
    >
  );
}
export declare class InvalidDBProxyStateFault extends __BaseException {
  readonly name: "InvalidDBProxyStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidDBProxyStateFault, __BaseException>
  );
}
export interface CreateDBSecurityGroupMessage {
  DBSecurityGroupName: string | undefined;
  DBSecurityGroupDescription: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateDBSecurityGroupResult {
  DBSecurityGroup?: DBSecurityGroup | undefined;
}
export declare class DBSecurityGroupAlreadyExistsFault extends __BaseException {
  readonly name: "DBSecurityGroupAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBSecurityGroupAlreadyExistsFault,
      __BaseException
    >
  );
}
export declare class DBSecurityGroupNotSupportedFault extends __BaseException {
  readonly name: "DBSecurityGroupNotSupportedFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBSecurityGroupNotSupportedFault,
      __BaseException
    >
  );
}
export declare class DBSecurityGroupQuotaExceededFault extends __BaseException {
  readonly name: "DBSecurityGroupQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBSecurityGroupQuotaExceededFault,
      __BaseException
    >
  );
}
export interface CreateDBShardGroupMessage {
  DBShardGroupIdentifier: string | undefined;
  DBClusterIdentifier: string | undefined;
  ComputeRedundancy?: number | undefined;
  MaxACU: number | undefined;
  MinACU?: number | undefined;
  PubliclyAccessible?: boolean | undefined;
  Tags?: Tag[] | undefined;
}
export interface DBShardGroup {
  DBShardGroupResourceId?: string | undefined;
  DBShardGroupIdentifier?: string | undefined;
  DBClusterIdentifier?: string | undefined;
  MaxACU?: number | undefined;
  MinACU?: number | undefined;
  ComputeRedundancy?: number | undefined;
  Status?: string | undefined;
  PubliclyAccessible?: boolean | undefined;
  Endpoint?: string | undefined;
  DBShardGroupArn?: string | undefined;
  TagList?: Tag[] | undefined;
}
export declare class DBShardGroupAlreadyExistsFault extends __BaseException {
  readonly name: "DBShardGroupAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBShardGroupAlreadyExistsFault, __BaseException>
  );
}
export declare class MaxDBShardGroupLimitReached extends __BaseException {
  readonly name: "MaxDBShardGroupLimitReached";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<MaxDBShardGroupLimitReached, __BaseException>
  );
}
export declare class UnsupportedDBEngineVersionFault extends __BaseException {
  readonly name: "UnsupportedDBEngineVersionFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      UnsupportedDBEngineVersionFault,
      __BaseException
    >
  );
}
export interface CreateDBSnapshotMessage {
  DBSnapshotIdentifier: string | undefined;
  DBInstanceIdentifier: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateDBSnapshotResult {
  DBSnapshot?: DBSnapshot | undefined;
}
export interface CreateDBSubnetGroupMessage {
  DBSubnetGroupName: string | undefined;
  DBSubnetGroupDescription: string | undefined;
  SubnetIds: string[] | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateDBSubnetGroupResult {
  DBSubnetGroup?: DBSubnetGroup | undefined;
}
export declare class DBSubnetGroupAlreadyExistsFault extends __BaseException {
  readonly name: "DBSubnetGroupAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBSubnetGroupAlreadyExistsFault,
      __BaseException
    >
  );
}
export declare class DBSubnetGroupQuotaExceededFault extends __BaseException {
  readonly name: "DBSubnetGroupQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBSubnetGroupQuotaExceededFault,
      __BaseException
    >
  );
}
export declare class DBSubnetQuotaExceededFault extends __BaseException {
  readonly name: "DBSubnetQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBSubnetQuotaExceededFault, __BaseException>
  );
}
export interface CreateEventSubscriptionMessage {
  SubscriptionName: string | undefined;
  SnsTopicArn: string | undefined;
  SourceType?: string | undefined;
  EventCategories?: string[] | undefined;
  SourceIds?: string[] | undefined;
  Enabled?: boolean | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateEventSubscriptionResult {
  EventSubscription?: EventSubscription | undefined;
}
export declare class EventSubscriptionQuotaExceededFault extends __BaseException {
  readonly name: "EventSubscriptionQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      EventSubscriptionQuotaExceededFault,
      __BaseException
    >
  );
}
export declare class SNSInvalidTopicFault extends __BaseException {
  readonly name: "SNSInvalidTopicFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<SNSInvalidTopicFault, __BaseException>
  );
}
export declare class SNSNoAuthorizationFault extends __BaseException {
  readonly name: "SNSNoAuthorizationFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<SNSNoAuthorizationFault, __BaseException>
  );
}
export declare class SNSTopicArnNotFoundFault extends __BaseException {
  readonly name: "SNSTopicArnNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<SNSTopicArnNotFoundFault, __BaseException>
  );
}
export declare class SubscriptionAlreadyExistFault extends __BaseException {
  readonly name: "SubscriptionAlreadyExistFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<SubscriptionAlreadyExistFault, __BaseException>
  );
}
export declare class SubscriptionCategoryNotFoundFault extends __BaseException {
  readonly name: "SubscriptionCategoryNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      SubscriptionCategoryNotFoundFault,
      __BaseException
    >
  );
}
export interface CreateGlobalClusterMessage {
  GlobalClusterIdentifier?: string | undefined;
  SourceDBClusterIdentifier?: string | undefined;
  Engine?: string | undefined;
  EngineVersion?: string | undefined;
  EngineLifecycleSupport?: string | undefined;
  DeletionProtection?: boolean | undefined;
  DatabaseName?: string | undefined;
  StorageEncrypted?: boolean | undefined;
  Tags?: Tag[] | undefined;
}
export declare const FailoverStatus: {
  readonly CANCELLING: "cancelling";
  readonly FAILING_OVER: "failing-over";
  readonly PENDING: "pending";
};
export type FailoverStatus =
  (typeof FailoverStatus)[keyof typeof FailoverStatus];
export interface FailoverState {
  Status?: FailoverStatus | undefined;
  FromDbClusterArn?: string | undefined;
  ToDbClusterArn?: string | undefined;
  IsDataLossAllowed?: boolean | undefined;
}
export declare const GlobalClusterMemberSynchronizationStatus: {
  readonly CONNECTED: "connected";
  readonly PENDING_RESYNC: "pending-resync";
};
export type GlobalClusterMemberSynchronizationStatus =
  (typeof GlobalClusterMemberSynchronizationStatus)[keyof typeof GlobalClusterMemberSynchronizationStatus];
export interface GlobalClusterMember {
  DBClusterArn?: string | undefined;
  Readers?: string[] | undefined;
  IsWriter?: boolean | undefined;
  GlobalWriteForwardingStatus?: WriteForwardingStatus | undefined;
  SynchronizationStatus?: GlobalClusterMemberSynchronizationStatus | undefined;
}
export interface GlobalCluster {
  GlobalClusterIdentifier?: string | undefined;
  GlobalClusterResourceId?: string | undefined;
  GlobalClusterArn?: string | undefined;
  Status?: string | undefined;
  Engine?: string | undefined;
  EngineVersion?: string | undefined;
  EngineLifecycleSupport?: string | undefined;
  DatabaseName?: string | undefined;
  StorageEncrypted?: boolean | undefined;
  DeletionProtection?: boolean | undefined;
  GlobalClusterMembers?: GlobalClusterMember[] | undefined;
  Endpoint?: string | undefined;
  FailoverState?: FailoverState | undefined;
  TagList?: Tag[] | undefined;
}
export interface CreateGlobalClusterResult {
  GlobalCluster?: GlobalCluster | undefined;
}
export declare class GlobalClusterAlreadyExistsFault extends __BaseException {
  readonly name: "GlobalClusterAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      GlobalClusterAlreadyExistsFault,
      __BaseException
    >
  );
}
export declare class GlobalClusterQuotaExceededFault extends __BaseException {
  readonly name: "GlobalClusterQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      GlobalClusterQuotaExceededFault,
      __BaseException
    >
  );
}
export interface CreateIntegrationMessage {
  SourceArn: string | undefined;
  TargetArn: string | undefined;
  IntegrationName: string | undefined;
  KMSKeyId?: string | undefined;
  AdditionalEncryptionContext?: Record<string, string> | undefined;
  Tags?: Tag[] | undefined;
  DataFilter?: string | undefined;
  Description?: string | undefined;
}
export interface IntegrationError {
  ErrorCode: string | undefined;
  ErrorMessage?: string | undefined;
}
export declare const IntegrationStatus: {
  readonly ACTIVE: "active";
  readonly CREATING: "creating";
  readonly DELETING: "deleting";
  readonly FAILED: "failed";
  readonly MODIFYING: "modifying";
  readonly NEEDS_ATTENTION: "needs_attention";
  readonly SYNCING: "syncing";
};
export type IntegrationStatus =
  (typeof IntegrationStatus)[keyof typeof IntegrationStatus];
export interface Integration {
  SourceArn?: string | undefined;
  TargetArn?: string | undefined;
  IntegrationName?: string | undefined;
  IntegrationArn?: string | undefined;
  KMSKeyId?: string | undefined;
  AdditionalEncryptionContext?: Record<string, string> | undefined;
  Status?: IntegrationStatus | undefined;
  Tags?: Tag[] | undefined;
  CreateTime?: Date | undefined;
  Errors?: IntegrationError[] | undefined;
  DataFilter?: string | undefined;
  Description?: string | undefined;
}
export declare class IntegrationAlreadyExistsFault extends __BaseException {
  readonly name: "IntegrationAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<IntegrationAlreadyExistsFault, __BaseException>
  );
}
export declare class IntegrationConflictOperationFault extends __BaseException {
  readonly name: "IntegrationConflictOperationFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      IntegrationConflictOperationFault,
      __BaseException
    >
  );
}
export declare class IntegrationQuotaExceededFault extends __BaseException {
  readonly name: "IntegrationQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<IntegrationQuotaExceededFault, __BaseException>
  );
}
export interface CreateOptionGroupMessage {
  OptionGroupName: string | undefined;
  EngineName: string | undefined;
  MajorEngineVersion: string | undefined;
  OptionGroupDescription: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface CreateOptionGroupResult {
  OptionGroup?: OptionGroup | undefined;
}
export interface CreateTenantDatabaseMessage {
  DBInstanceIdentifier: string | undefined;
  TenantDBName: string | undefined;
  MasterUsername: string | undefined;
  MasterUserPassword?: string | undefined;
  CharacterSetName?: string | undefined;
  NcharCharacterSetName?: string | undefined;
  ManageMasterUserPassword?: boolean | undefined;
  MasterUserSecretKmsKeyId?: string | undefined;
  Tags?: Tag[] | undefined;
}
export interface TenantDatabasePendingModifiedValues {
  MasterUserPassword?: string | undefined;
  TenantDBName?: string | undefined;
}
export interface TenantDatabase {
  TenantDatabaseCreateTime?: Date | undefined;
  DBInstanceIdentifier?: string | undefined;
  TenantDBName?: string | undefined;
  Status?: string | undefined;
  MasterUsername?: string | undefined;
  DbiResourceId?: string | undefined;
  TenantDatabaseResourceId?: string | undefined;
  TenantDatabaseARN?: string | undefined;
  CharacterSetName?: string | undefined;
  NcharCharacterSetName?: string | undefined;
  DeletionProtection?: boolean | undefined;
  PendingModifiedValues?: TenantDatabasePendingModifiedValues | undefined;
  MasterUserSecret?: MasterUserSecret | undefined;
  TagList?: Tag[] | undefined;
}
export interface CreateTenantDatabaseResult {
  TenantDatabase?: TenantDatabase | undefined;
}
export declare class TenantDatabaseAlreadyExistsFault extends __BaseException {
  readonly name: "TenantDatabaseAlreadyExistsFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      TenantDatabaseAlreadyExistsFault,
      __BaseException
    >
  );
}
export interface DeleteBlueGreenDeploymentRequest {
  BlueGreenDeploymentIdentifier: string | undefined;
  DeleteTarget?: boolean | undefined;
}
export interface DeleteBlueGreenDeploymentResponse {
  BlueGreenDeployment?: BlueGreenDeployment | undefined;
}
export declare class InvalidBlueGreenDeploymentStateFault extends __BaseException {
  readonly name: "InvalidBlueGreenDeploymentStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidBlueGreenDeploymentStateFault,
      __BaseException
    >
  );
}
export declare class CustomDBEngineVersionNotFoundFault extends __BaseException {
  readonly name: "CustomDBEngineVersionNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      CustomDBEngineVersionNotFoundFault,
      __BaseException
    >
  );
}
export interface DeleteCustomDBEngineVersionMessage {
  Engine: string | undefined;
  EngineVersion: string | undefined;
}
export declare class InvalidCustomDBEngineVersionStateFault extends __BaseException {
  readonly name: "InvalidCustomDBEngineVersionStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidCustomDBEngineVersionStateFault,
      __BaseException
    >
  );
}
export declare class DBClusterAutomatedBackupQuotaExceededFault extends __BaseException {
  readonly name: "DBClusterAutomatedBackupQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBClusterAutomatedBackupQuotaExceededFault,
      __BaseException
    >
  );
}
export interface DeleteDBClusterMessage {
  DBClusterIdentifier: string | undefined;
  SkipFinalSnapshot?: boolean | undefined;
  FinalDBSnapshotIdentifier?: string | undefined;
  DeleteAutomatedBackups?: boolean | undefined;
}
export interface DeleteDBClusterResult {
  DBCluster?: DBCluster | undefined;
}
export declare class DBClusterAutomatedBackupNotFoundFault extends __BaseException {
  readonly name: "DBClusterAutomatedBackupNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBClusterAutomatedBackupNotFoundFault,
      __BaseException
    >
  );
}
export interface DeleteDBClusterAutomatedBackupMessage {
  DbClusterResourceId: string | undefined;
}
export interface RestoreWindow {
  EarliestTime?: Date | undefined;
  LatestTime?: Date | undefined;
}
export interface DBClusterAutomatedBackup {
  Engine?: string | undefined;
  VpcId?: string | undefined;
  DBClusterAutomatedBackupsArn?: string | undefined;
  DBClusterIdentifier?: string | undefined;
  RestoreWindow?: RestoreWindow | undefined;
  MasterUsername?: string | undefined;
  DbClusterResourceId?: string | undefined;
  Region?: string | undefined;
  LicenseModel?: string | undefined;
  Status?: string | undefined;
  IAMDatabaseAuthenticationEnabled?: boolean | undefined;
  ClusterCreateTime?: Date | undefined;
  StorageEncrypted?: boolean | undefined;
  AllocatedStorage?: number | undefined;
  EngineVersion?: string | undefined;
  DBClusterArn?: string | undefined;
  BackupRetentionPeriod?: number | undefined;
  EngineMode?: string | undefined;
  AvailabilityZones?: string[] | undefined;
  Port?: number | undefined;
  KmsKeyId?: string | undefined;
  StorageType?: string | undefined;
  Iops?: number | undefined;
  AwsBackupRecoveryPointArn?: string | undefined;
  StorageThroughput?: number | undefined;
}
export interface DeleteDBClusterAutomatedBackupResult {
  DBClusterAutomatedBackup?: DBClusterAutomatedBackup | undefined;
}
export declare class InvalidDBClusterAutomatedBackupStateFault extends __BaseException {
  readonly name: "InvalidDBClusterAutomatedBackupStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDBClusterAutomatedBackupStateFault,
      __BaseException
    >
  );
}
export declare class DBClusterEndpointNotFoundFault extends __BaseException {
  readonly name: "DBClusterEndpointNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBClusterEndpointNotFoundFault, __BaseException>
  );
}
export interface DeleteDBClusterEndpointMessage {
  DBClusterEndpointIdentifier: string | undefined;
}
export declare class InvalidDBClusterEndpointStateFault extends __BaseException {
  readonly name: "InvalidDBClusterEndpointStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDBClusterEndpointStateFault,
      __BaseException
    >
  );
}
export interface DeleteDBClusterParameterGroupMessage {
  DBClusterParameterGroupName: string | undefined;
}
export declare class InvalidDBParameterGroupStateFault extends __BaseException {
  readonly name: "InvalidDBParameterGroupStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDBParameterGroupStateFault,
      __BaseException
    >
  );
}
export interface DeleteDBClusterSnapshotMessage {
  DBClusterSnapshotIdentifier: string | undefined;
}
export interface DeleteDBClusterSnapshotResult {
  DBClusterSnapshot?: DBClusterSnapshot | undefined;
}
export declare class DBInstanceAutomatedBackupQuotaExceededFault extends __BaseException {
  readonly name: "DBInstanceAutomatedBackupQuotaExceededFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBInstanceAutomatedBackupQuotaExceededFault,
      __BaseException
    >
  );
}
export interface DeleteDBInstanceMessage {
  DBInstanceIdentifier: string | undefined;
  SkipFinalSnapshot?: boolean | undefined;
  FinalDBSnapshotIdentifier?: string | undefined;
  DeleteAutomatedBackups?: boolean | undefined;
}
export interface DeleteDBInstanceResult {
  DBInstance?: DBInstance | undefined;
}
export declare class DBInstanceAutomatedBackupNotFoundFault extends __BaseException {
  readonly name: "DBInstanceAutomatedBackupNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      DBInstanceAutomatedBackupNotFoundFault,
      __BaseException
    >
  );
}
export interface DeleteDBInstanceAutomatedBackupMessage {
  DbiResourceId?: string | undefined;
  DBInstanceAutomatedBackupsArn?: string | undefined;
}
export interface DBInstanceAutomatedBackup {
  DBInstanceArn?: string | undefined;
  DbiResourceId?: string | undefined;
  Region?: string | undefined;
  DBInstanceIdentifier?: string | undefined;
  RestoreWindow?: RestoreWindow | undefined;
  AllocatedStorage?: number | undefined;
  Status?: string | undefined;
  Port?: number | undefined;
  AvailabilityZone?: string | undefined;
  VpcId?: string | undefined;
  InstanceCreateTime?: Date | undefined;
  MasterUsername?: string | undefined;
  Engine?: string | undefined;
  EngineVersion?: string | undefined;
  LicenseModel?: string | undefined;
  Iops?: number | undefined;
  OptionGroupName?: string | undefined;
  TdeCredentialArn?: string | undefined;
  Encrypted?: boolean | undefined;
  StorageType?: string | undefined;
  KmsKeyId?: string | undefined;
  Timezone?: string | undefined;
  IAMDatabaseAuthenticationEnabled?: boolean | undefined;
  BackupRetentionPeriod?: number | undefined;
  DBInstanceAutomatedBackupsArn?: string | undefined;
  DBInstanceAutomatedBackupsReplications?:
    | DBInstanceAutomatedBackupsReplication[]
    | undefined;
  BackupTarget?: string | undefined;
  StorageThroughput?: number | undefined;
  AwsBackupRecoveryPointArn?: string | undefined;
  DedicatedLogVolume?: boolean | undefined;
  MultiTenant?: boolean | undefined;
}
export interface DeleteDBInstanceAutomatedBackupResult {
  DBInstanceAutomatedBackup?: DBInstanceAutomatedBackup | undefined;
}
export declare class InvalidDBInstanceAutomatedBackupStateFault extends __BaseException {
  readonly name: "InvalidDBInstanceAutomatedBackupStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDBInstanceAutomatedBackupStateFault,
      __BaseException
    >
  );
}
export interface DeleteDBParameterGroupMessage {
  DBParameterGroupName: string | undefined;
}
export interface DeleteDBProxyRequest {
  DBProxyName: string | undefined;
}
export interface DeleteDBProxyResponse {
  DBProxy?: DBProxy | undefined;
}
export declare class DBProxyEndpointNotFoundFault extends __BaseException {
  readonly name: "DBProxyEndpointNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBProxyEndpointNotFoundFault, __BaseException>
  );
}
export interface DeleteDBProxyEndpointRequest {
  DBProxyEndpointName: string | undefined;
}
export interface DeleteDBProxyEndpointResponse {
  DBProxyEndpoint?: DBProxyEndpoint | undefined;
}
export declare class InvalidDBProxyEndpointStateFault extends __BaseException {
  readonly name: "InvalidDBProxyEndpointStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidDBProxyEndpointStateFault,
      __BaseException
    >
  );
}
export interface DeleteDBSecurityGroupMessage {
  DBSecurityGroupName: string | undefined;
}
export declare class DBShardGroupNotFoundFault extends __BaseException {
  readonly name: "DBShardGroupNotFoundFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<DBShardGroupNotFoundFault, __BaseException>
  );
}
export interface DeleteDBShardGroupMessage {
  DBShardGroupIdentifier: string | undefined;
}
export declare class InvalidDBShardGroupStateFault extends __BaseException {
  readonly name: "InvalidDBShardGroupStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidDBShardGroupStateFault, __BaseException>
  );
}
export interface DeleteDBSnapshotMessage {
  DBSnapshotIdentifier: string | undefined;
}
export interface DeleteDBSnapshotResult {
  DBSnapshot?: DBSnapshot | undefined;
}
export interface DeleteDBSubnetGroupMessage {
  DBSubnetGroupName: string | undefined;
}
export declare class InvalidDBSubnetStateFault extends __BaseException {
  readonly name: "InvalidDBSubnetStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidDBSubnetStateFault, __BaseException>
  );
}
export interface DeleteEventSubscriptionMessage {
  SubscriptionName: string | undefined;
}
export interface DeleteEventSubscriptionResult {
  EventSubscription?: EventSubscription | undefined;
}
export declare class InvalidEventSubscriptionStateFault extends __BaseException {
  readonly name: "InvalidEventSubscriptionStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      InvalidEventSubscriptionStateFault,
      __BaseException
    >
  );
}
export interface DeleteGlobalClusterMessage {
  GlobalClusterIdentifier: string | undefined;
}
export interface DeleteGlobalClusterResult {
  GlobalCluster?: GlobalCluster | undefined;
}
export interface DeleteIntegrationMessage {
  IntegrationIdentifier: string | undefined;
}
export declare class InvalidIntegrationStateFault extends __BaseException {
  readonly name: "InvalidIntegrationStateFault";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<InvalidIntegrationStateFault, __BaseException>
  );
}
export interface DeleteOptionGroupMessage {
  OptionGroupName: string | undefined;
}
export declare const CreateTenantDatabaseMessageFilterSensitiveLog: (
  obj: CreateTenantDatabaseMessage
) => any;
export declare const TenantDatabasePendingModifiedValuesFilterSensitiveLog: (
  obj: TenantDatabasePendingModifiedValues
) => any;
export declare const TenantDatabaseFilterSensitiveLog: (
  obj: TenantDatabase
) => any;
export declare const CreateTenantDatabaseResultFilterSensitiveLog: (
  obj: CreateTenantDatabaseResult
) => any;
