import { HttpHandlerOptions as __HttpHandlerOptions } from "@smithy/types";
import {
  AddRoleToDBClusterCommandInput,
  AddRoleToDBClusterCommandOutput,
} from "./commands/AddRoleToDBClusterCommand";
import {
  AddRoleToDBInstanceCommandInput,
  AddRoleToDBInstanceCommandOutput,
} from "./commands/AddRoleToDBInstanceCommand";
import {
  AddSourceIdentifierToSubscriptionCommandInput,
  AddSourceIdentifierToSubscriptionCommandOutput,
} from "./commands/AddSourceIdentifierToSubscriptionCommand";
import {
  AddTagsToResourceCommandInput,
  AddTagsToResourceCommandOutput,
} from "./commands/AddTagsToResourceCommand";
import {
  ApplyPendingMaintenanceActionCommandInput,
  ApplyPendingMaintenanceActionCommandOutput,
} from "./commands/ApplyPendingMaintenanceActionCommand";
import {
  AuthorizeDBSecurityGroupIngressCommandInput,
  AuthorizeDBSecurityGroupIngressCommandOutput,
} from "./commands/AuthorizeDBSecurityGroupIngressCommand";
import {
  BacktrackDBClusterCommandInput,
  BacktrackDBClusterCommandOutput,
} from "./commands/BacktrackDBClusterCommand";
import {
  CancelExportTaskCommandInput,
  CancelExportTaskCommandOutput,
} from "./commands/CancelExportTaskCommand";
import {
  CopyDBClusterParameterGroupCommandInput,
  CopyDBClusterParameterGroupCommandOutput,
} from "./commands/CopyDBClusterParameterGroupCommand";
import {
  CopyDBClusterSnapshotCommandInput,
  CopyDBClusterSnapshotCommandOutput,
} from "./commands/CopyDBClusterSnapshotCommand";
import {
  CopyDBParameterGroupCommandInput,
  CopyDBParameterGroupCommandOutput,
} from "./commands/CopyDBParameterGroupCommand";
import {
  CopyDBSnapshotCommandInput,
  CopyDBSnapshotCommandOutput,
} from "./commands/CopyDBSnapshotCommand";
import {
  CopyOptionGroupCommandInput,
  CopyOptionGroupCommandOutput,
} from "./commands/CopyOptionGroupCommand";
import {
  CreateBlueGreenDeploymentCommandInput,
  CreateBlueGreenDeploymentCommandOutput,
} from "./commands/CreateBlueGreenDeploymentCommand";
import {
  CreateCustomDBEngineVersionCommandInput,
  CreateCustomDBEngineVersionCommandOutput,
} from "./commands/CreateCustomDBEngineVersionCommand";
import {
  CreateDBClusterCommandInput,
  CreateDBClusterCommandOutput,
} from "./commands/CreateDBClusterCommand";
import {
  CreateDBClusterEndpointCommandInput,
  CreateDBClusterEndpointCommandOutput,
} from "./commands/CreateDBClusterEndpointCommand";
import {
  CreateDBClusterParameterGroupCommandInput,
  CreateDBClusterParameterGroupCommandOutput,
} from "./commands/CreateDBClusterParameterGroupCommand";
import {
  CreateDBClusterSnapshotCommandInput,
  CreateDBClusterSnapshotCommandOutput,
} from "./commands/CreateDBClusterSnapshotCommand";
import {
  CreateDBInstanceCommandInput,
  CreateDBInstanceCommandOutput,
} from "./commands/CreateDBInstanceCommand";
import {
  CreateDBInstanceReadReplicaCommandInput,
  CreateDBInstanceReadReplicaCommandOutput,
} from "./commands/CreateDBInstanceReadReplicaCommand";
import {
  CreateDBParameterGroupCommandInput,
  CreateDBParameterGroupCommandOutput,
} from "./commands/CreateDBParameterGroupCommand";
import {
  CreateDBProxyCommandInput,
  CreateDBProxyCommandOutput,
} from "./commands/CreateDBProxyCommand";
import {
  CreateDBProxyEndpointCommandInput,
  CreateDBProxyEndpointCommandOutput,
} from "./commands/CreateDBProxyEndpointCommand";
import {
  CreateDBSecurityGroupCommandInput,
  CreateDBSecurityGroupCommandOutput,
} from "./commands/CreateDBSecurityGroupCommand";
import {
  CreateDBShardGroupCommandInput,
  CreateDBShardGroupCommandOutput,
} from "./commands/CreateDBShardGroupCommand";
import {
  CreateDBSnapshotCommandInput,
  CreateDBSnapshotCommandOutput,
} from "./commands/CreateDBSnapshotCommand";
import {
  CreateDBSubnetGroupCommandInput,
  CreateDBSubnetGroupCommandOutput,
} from "./commands/CreateDBSubnetGroupCommand";
import {
  CreateEventSubscriptionCommandInput,
  CreateEventSubscriptionCommandOutput,
} from "./commands/CreateEventSubscriptionCommand";
import {
  CreateGlobalClusterCommandInput,
  CreateGlobalClusterCommandOutput,
} from "./commands/CreateGlobalClusterCommand";
import {
  CreateIntegrationCommandInput,
  CreateIntegrationCommandOutput,
} from "./commands/CreateIntegrationCommand";
import {
  CreateOptionGroupCommandInput,
  CreateOptionGroupCommandOutput,
} from "./commands/CreateOptionGroupCommand";
import {
  CreateTenantDatabaseCommandInput,
  CreateTenantDatabaseCommandOutput,
} from "./commands/CreateTenantDatabaseCommand";
import {
  DeleteBlueGreenDeploymentCommandInput,
  DeleteBlueGreenDeploymentCommandOutput,
} from "./commands/DeleteBlueGreenDeploymentCommand";
import {
  DeleteCustomDBEngineVersionCommandInput,
  DeleteCustomDBEngineVersionCommandOutput,
} from "./commands/DeleteCustomDBEngineVersionCommand";
import {
  DeleteDBClusterAutomatedBackupCommandInput,
  DeleteDBClusterAutomatedBackupCommandOutput,
} from "./commands/DeleteDBClusterAutomatedBackupCommand";
import {
  DeleteDBClusterCommandInput,
  DeleteDBClusterCommandOutput,
} from "./commands/DeleteDBClusterCommand";
import {
  DeleteDBClusterEndpointCommandInput,
  DeleteDBClusterEndpointCommandOutput,
} from "./commands/DeleteDBClusterEndpointCommand";
import {
  DeleteDBClusterParameterGroupCommandInput,
  DeleteDBClusterParameterGroupCommandOutput,
} from "./commands/DeleteDBClusterParameterGroupCommand";
import {
  DeleteDBClusterSnapshotCommandInput,
  DeleteDBClusterSnapshotCommandOutput,
} from "./commands/DeleteDBClusterSnapshotCommand";
import {
  DeleteDBInstanceAutomatedBackupCommandInput,
  DeleteDBInstanceAutomatedBackupCommandOutput,
} from "./commands/DeleteDBInstanceAutomatedBackupCommand";
import {
  DeleteDBInstanceCommandInput,
  DeleteDBInstanceCommandOutput,
} from "./commands/DeleteDBInstanceCommand";
import {
  DeleteDBParameterGroupCommandInput,
  DeleteDBParameterGroupCommandOutput,
} from "./commands/DeleteDBParameterGroupCommand";
import {
  DeleteDBProxyCommandInput,
  DeleteDBProxyCommandOutput,
} from "./commands/DeleteDBProxyCommand";
import {
  DeleteDBProxyEndpointCommandInput,
  DeleteDBProxyEndpointCommandOutput,
} from "./commands/DeleteDBProxyEndpointCommand";
import {
  DeleteDBSecurityGroupCommandInput,
  DeleteDBSecurityGroupCommandOutput,
} from "./commands/DeleteDBSecurityGroupCommand";
import {
  DeleteDBShardGroupCommandInput,
  DeleteDBShardGroupCommandOutput,
} from "./commands/DeleteDBShardGroupCommand";
import {
  DeleteDBSnapshotCommandInput,
  DeleteDBSnapshotCommandOutput,
} from "./commands/DeleteDBSnapshotCommand";
import {
  DeleteDBSubnetGroupCommandInput,
  DeleteDBSubnetGroupCommandOutput,
} from "./commands/DeleteDBSubnetGroupCommand";
import {
  DeleteEventSubscriptionCommandInput,
  DeleteEventSubscriptionCommandOutput,
} from "./commands/DeleteEventSubscriptionCommand";
import {
  DeleteGlobalClusterCommandInput,
  DeleteGlobalClusterCommandOutput,
} from "./commands/DeleteGlobalClusterCommand";
import {
  DeleteIntegrationCommandInput,
  DeleteIntegrationCommandOutput,
} from "./commands/DeleteIntegrationCommand";
import {
  DeleteOptionGroupCommandInput,
  DeleteOptionGroupCommandOutput,
} from "./commands/DeleteOptionGroupCommand";
import {
  DeleteTenantDatabaseCommandInput,
  DeleteTenantDatabaseCommandOutput,
} from "./commands/DeleteTenantDatabaseCommand";
import {
  DeregisterDBProxyTargetsCommandInput,
  DeregisterDBProxyTargetsCommandOutput,
} from "./commands/DeregisterDBProxyTargetsCommand";
import {
  DescribeAccountAttributesCommandInput,
  DescribeAccountAttributesCommandOutput,
} from "./commands/DescribeAccountAttributesCommand";
import {
  DescribeBlueGreenDeploymentsCommandInput,
  DescribeBlueGreenDeploymentsCommandOutput,
} from "./commands/DescribeBlueGreenDeploymentsCommand";
import {
  DescribeCertificatesCommandInput,
  DescribeCertificatesCommandOutput,
} from "./commands/DescribeCertificatesCommand";
import {
  DescribeDBClusterAutomatedBackupsCommandInput,
  DescribeDBClusterAutomatedBackupsCommandOutput,
} from "./commands/DescribeDBClusterAutomatedBackupsCommand";
import {
  DescribeDBClusterBacktracksCommandInput,
  DescribeDBClusterBacktracksCommandOutput,
} from "./commands/DescribeDBClusterBacktracksCommand";
import {
  DescribeDBClusterEndpointsCommandInput,
  DescribeDBClusterEndpointsCommandOutput,
} from "./commands/DescribeDBClusterEndpointsCommand";
import {
  DescribeDBClusterParameterGroupsCommandInput,
  DescribeDBClusterParameterGroupsCommandOutput,
} from "./commands/DescribeDBClusterParameterGroupsCommand";
import {
  DescribeDBClusterParametersCommandInput,
  DescribeDBClusterParametersCommandOutput,
} from "./commands/DescribeDBClusterParametersCommand";
import {
  DescribeDBClustersCommandInput,
  DescribeDBClustersCommandOutput,
} from "./commands/DescribeDBClustersCommand";
import {
  DescribeDBClusterSnapshotAttributesCommandInput,
  DescribeDBClusterSnapshotAttributesCommandOutput,
} from "./commands/DescribeDBClusterSnapshotAttributesCommand";
import {
  DescribeDBClusterSnapshotsCommandInput,
  DescribeDBClusterSnapshotsCommandOutput,
} from "./commands/DescribeDBClusterSnapshotsCommand";
import {
  DescribeDBEngineVersionsCommandInput,
  DescribeDBEngineVersionsCommandOutput,
} from "./commands/DescribeDBEngineVersionsCommand";
import {
  DescribeDBInstanceAutomatedBackupsCommandInput,
  DescribeDBInstanceAutomatedBackupsCommandOutput,
} from "./commands/DescribeDBInstanceAutomatedBackupsCommand";
import {
  DescribeDBInstancesCommandInput,
  DescribeDBInstancesCommandOutput,
} from "./commands/DescribeDBInstancesCommand";
import {
  DescribeDBLogFilesCommandInput,
  DescribeDBLogFilesCommandOutput,
} from "./commands/DescribeDBLogFilesCommand";
import {
  DescribeDBMajorEngineVersionsCommandInput,
  DescribeDBMajorEngineVersionsCommandOutput,
} from "./commands/DescribeDBMajorEngineVersionsCommand";
import {
  DescribeDBParameterGroupsCommandInput,
  DescribeDBParameterGroupsCommandOutput,
} from "./commands/DescribeDBParameterGroupsCommand";
import {
  DescribeDBParametersCommandInput,
  DescribeDBParametersCommandOutput,
} from "./commands/DescribeDBParametersCommand";
import {
  DescribeDBProxiesCommandInput,
  DescribeDBProxiesCommandOutput,
} from "./commands/DescribeDBProxiesCommand";
import {
  DescribeDBProxyEndpointsCommandInput,
  DescribeDBProxyEndpointsCommandOutput,
} from "./commands/DescribeDBProxyEndpointsCommand";
import {
  DescribeDBProxyTargetGroupsCommandInput,
  DescribeDBProxyTargetGroupsCommandOutput,
} from "./commands/DescribeDBProxyTargetGroupsCommand";
import {
  DescribeDBProxyTargetsCommandInput,
  DescribeDBProxyTargetsCommandOutput,
} from "./commands/DescribeDBProxyTargetsCommand";
import {
  DescribeDBRecommendationsCommandInput,
  DescribeDBRecommendationsCommandOutput,
} from "./commands/DescribeDBRecommendationsCommand";
import {
  DescribeDBSecurityGroupsCommandInput,
  DescribeDBSecurityGroupsCommandOutput,
} from "./commands/DescribeDBSecurityGroupsCommand";
import {
  DescribeDBShardGroupsCommandInput,
  DescribeDBShardGroupsCommandOutput,
} from "./commands/DescribeDBShardGroupsCommand";
import {
  DescribeDBSnapshotAttributesCommandInput,
  DescribeDBSnapshotAttributesCommandOutput,
} from "./commands/DescribeDBSnapshotAttributesCommand";
import {
  DescribeDBSnapshotsCommandInput,
  DescribeDBSnapshotsCommandOutput,
} from "./commands/DescribeDBSnapshotsCommand";
import {
  DescribeDBSnapshotTenantDatabasesCommandInput,
  DescribeDBSnapshotTenantDatabasesCommandOutput,
} from "./commands/DescribeDBSnapshotTenantDatabasesCommand";
import {
  DescribeDBSubnetGroupsCommandInput,
  DescribeDBSubnetGroupsCommandOutput,
} from "./commands/DescribeDBSubnetGroupsCommand";
import {
  DescribeEngineDefaultClusterParametersCommandInput,
  DescribeEngineDefaultClusterParametersCommandOutput,
} from "./commands/DescribeEngineDefaultClusterParametersCommand";
import {
  DescribeEngineDefaultParametersCommandInput,
  DescribeEngineDefaultParametersCommandOutput,
} from "./commands/DescribeEngineDefaultParametersCommand";
import {
  DescribeEventCategoriesCommandInput,
  DescribeEventCategoriesCommandOutput,
} from "./commands/DescribeEventCategoriesCommand";
import {
  DescribeEventsCommandInput,
  DescribeEventsCommandOutput,
} from "./commands/DescribeEventsCommand";
import {
  DescribeEventSubscriptionsCommandInput,
  DescribeEventSubscriptionsCommandOutput,
} from "./commands/DescribeEventSubscriptionsCommand";
import {
  DescribeExportTasksCommandInput,
  DescribeExportTasksCommandOutput,
} from "./commands/DescribeExportTasksCommand";
import {
  DescribeGlobalClustersCommandInput,
  DescribeGlobalClustersCommandOutput,
} from "./commands/DescribeGlobalClustersCommand";
import {
  DescribeIntegrationsCommandInput,
  DescribeIntegrationsCommandOutput,
} from "./commands/DescribeIntegrationsCommand";
import {
  DescribeOptionGroupOptionsCommandInput,
  DescribeOptionGroupOptionsCommandOutput,
} from "./commands/DescribeOptionGroupOptionsCommand";
import {
  DescribeOptionGroupsCommandInput,
  DescribeOptionGroupsCommandOutput,
} from "./commands/DescribeOptionGroupsCommand";
import {
  DescribeOrderableDBInstanceOptionsCommandInput,
  DescribeOrderableDBInstanceOptionsCommandOutput,
} from "./commands/DescribeOrderableDBInstanceOptionsCommand";
import {
  DescribePendingMaintenanceActionsCommandInput,
  DescribePendingMaintenanceActionsCommandOutput,
} from "./commands/DescribePendingMaintenanceActionsCommand";
import {
  DescribeReservedDBInstancesCommandInput,
  DescribeReservedDBInstancesCommandOutput,
} from "./commands/DescribeReservedDBInstancesCommand";
import {
  DescribeReservedDBInstancesOfferingsCommandInput,
  DescribeReservedDBInstancesOfferingsCommandOutput,
} from "./commands/DescribeReservedDBInstancesOfferingsCommand";
import {
  DescribeSourceRegionsCommandInput,
  DescribeSourceRegionsCommandOutput,
} from "./commands/DescribeSourceRegionsCommand";
import {
  DescribeTenantDatabasesCommandInput,
  DescribeTenantDatabasesCommandOutput,
} from "./commands/DescribeTenantDatabasesCommand";
import {
  DescribeValidDBInstanceModificationsCommandInput,
  DescribeValidDBInstanceModificationsCommandOutput,
} from "./commands/DescribeValidDBInstanceModificationsCommand";
import {
  DisableHttpEndpointCommandInput,
  DisableHttpEndpointCommandOutput,
} from "./commands/DisableHttpEndpointCommand";
import {
  DownloadDBLogFilePortionCommandInput,
  DownloadDBLogFilePortionCommandOutput,
} from "./commands/DownloadDBLogFilePortionCommand";
import {
  EnableHttpEndpointCommandInput,
  EnableHttpEndpointCommandOutput,
} from "./commands/EnableHttpEndpointCommand";
import {
  FailoverDBClusterCommandInput,
  FailoverDBClusterCommandOutput,
} from "./commands/FailoverDBClusterCommand";
import {
  FailoverGlobalClusterCommandInput,
  FailoverGlobalClusterCommandOutput,
} from "./commands/FailoverGlobalClusterCommand";
import {
  ListTagsForResourceCommandInput,
  ListTagsForResourceCommandOutput,
} from "./commands/ListTagsForResourceCommand";
import {
  ModifyActivityStreamCommandInput,
  ModifyActivityStreamCommandOutput,
} from "./commands/ModifyActivityStreamCommand";
import {
  ModifyCertificatesCommandInput,
  ModifyCertificatesCommandOutput,
} from "./commands/ModifyCertificatesCommand";
import {
  ModifyCurrentDBClusterCapacityCommandInput,
  ModifyCurrentDBClusterCapacityCommandOutput,
} from "./commands/ModifyCurrentDBClusterCapacityCommand";
import {
  ModifyCustomDBEngineVersionCommandInput,
  ModifyCustomDBEngineVersionCommandOutput,
} from "./commands/ModifyCustomDBEngineVersionCommand";
import {
  ModifyDBClusterCommandInput,
  ModifyDBClusterCommandOutput,
} from "./commands/ModifyDBClusterCommand";
import {
  ModifyDBClusterEndpointCommandInput,
  ModifyDBClusterEndpointCommandOutput,
} from "./commands/ModifyDBClusterEndpointCommand";
import {
  ModifyDBClusterParameterGroupCommandInput,
  ModifyDBClusterParameterGroupCommandOutput,
} from "./commands/ModifyDBClusterParameterGroupCommand";
import {
  ModifyDBClusterSnapshotAttributeCommandInput,
  ModifyDBClusterSnapshotAttributeCommandOutput,
} from "./commands/ModifyDBClusterSnapshotAttributeCommand";
import {
  ModifyDBInstanceCommandInput,
  ModifyDBInstanceCommandOutput,
} from "./commands/ModifyDBInstanceCommand";
import {
  ModifyDBParameterGroupCommandInput,
  ModifyDBParameterGroupCommandOutput,
} from "./commands/ModifyDBParameterGroupCommand";
import {
  ModifyDBProxyCommandInput,
  ModifyDBProxyCommandOutput,
} from "./commands/ModifyDBProxyCommand";
import {
  ModifyDBProxyEndpointCommandInput,
  ModifyDBProxyEndpointCommandOutput,
} from "./commands/ModifyDBProxyEndpointCommand";
import {
  ModifyDBProxyTargetGroupCommandInput,
  ModifyDBProxyTargetGroupCommandOutput,
} from "./commands/ModifyDBProxyTargetGroupCommand";
import {
  ModifyDBRecommendationCommandInput,
  ModifyDBRecommendationCommandOutput,
} from "./commands/ModifyDBRecommendationCommand";
import {
  ModifyDBShardGroupCommandInput,
  ModifyDBShardGroupCommandOutput,
} from "./commands/ModifyDBShardGroupCommand";
import {
  ModifyDBSnapshotAttributeCommandInput,
  ModifyDBSnapshotAttributeCommandOutput,
} from "./commands/ModifyDBSnapshotAttributeCommand";
import {
  ModifyDBSnapshotCommandInput,
  ModifyDBSnapshotCommandOutput,
} from "./commands/ModifyDBSnapshotCommand";
import {
  ModifyDBSubnetGroupCommandInput,
  ModifyDBSubnetGroupCommandOutput,
} from "./commands/ModifyDBSubnetGroupCommand";
import {
  ModifyEventSubscriptionCommandInput,
  ModifyEventSubscriptionCommandOutput,
} from "./commands/ModifyEventSubscriptionCommand";
import {
  ModifyGlobalClusterCommandInput,
  ModifyGlobalClusterCommandOutput,
} from "./commands/ModifyGlobalClusterCommand";
import {
  ModifyIntegrationCommandInput,
  ModifyIntegrationCommandOutput,
} from "./commands/ModifyIntegrationCommand";
import {
  ModifyOptionGroupCommandInput,
  ModifyOptionGroupCommandOutput,
} from "./commands/ModifyOptionGroupCommand";
import {
  ModifyTenantDatabaseCommandInput,
  ModifyTenantDatabaseCommandOutput,
} from "./commands/ModifyTenantDatabaseCommand";
import {
  PromoteReadReplicaCommandInput,
  PromoteReadReplicaCommandOutput,
} from "./commands/PromoteReadReplicaCommand";
import {
  PromoteReadReplicaDBClusterCommandInput,
  PromoteReadReplicaDBClusterCommandOutput,
} from "./commands/PromoteReadReplicaDBClusterCommand";
import {
  PurchaseReservedDBInstancesOfferingCommandInput,
  PurchaseReservedDBInstancesOfferingCommandOutput,
} from "./commands/PurchaseReservedDBInstancesOfferingCommand";
import {
  RebootDBClusterCommandInput,
  RebootDBClusterCommandOutput,
} from "./commands/RebootDBClusterCommand";
import {
  RebootDBInstanceCommandInput,
  RebootDBInstanceCommandOutput,
} from "./commands/RebootDBInstanceCommand";
import {
  RebootDBShardGroupCommandInput,
  RebootDBShardGroupCommandOutput,
} from "./commands/RebootDBShardGroupCommand";
import {
  RegisterDBProxyTargetsCommandInput,
  RegisterDBProxyTargetsCommandOutput,
} from "./commands/RegisterDBProxyTargetsCommand";
import {
  RemoveFromGlobalClusterCommandInput,
  RemoveFromGlobalClusterCommandOutput,
} from "./commands/RemoveFromGlobalClusterCommand";
import {
  RemoveRoleFromDBClusterCommandInput,
  RemoveRoleFromDBClusterCommandOutput,
} from "./commands/RemoveRoleFromDBClusterCommand";
import {
  RemoveRoleFromDBInstanceCommandInput,
  RemoveRoleFromDBInstanceCommandOutput,
} from "./commands/RemoveRoleFromDBInstanceCommand";
import {
  RemoveSourceIdentifierFromSubscriptionCommandInput,
  RemoveSourceIdentifierFromSubscriptionCommandOutput,
} from "./commands/RemoveSourceIdentifierFromSubscriptionCommand";
import {
  RemoveTagsFromResourceCommandInput,
  RemoveTagsFromResourceCommandOutput,
} from "./commands/RemoveTagsFromResourceCommand";
import {
  ResetDBClusterParameterGroupCommandInput,
  ResetDBClusterParameterGroupCommandOutput,
} from "./commands/ResetDBClusterParameterGroupCommand";
import {
  ResetDBParameterGroupCommandInput,
  ResetDBParameterGroupCommandOutput,
} from "./commands/ResetDBParameterGroupCommand";
import {
  RestoreDBClusterFromS3CommandInput,
  RestoreDBClusterFromS3CommandOutput,
} from "./commands/RestoreDBClusterFromS3Command";
import {
  RestoreDBClusterFromSnapshotCommandInput,
  RestoreDBClusterFromSnapshotCommandOutput,
} from "./commands/RestoreDBClusterFromSnapshotCommand";
import {
  RestoreDBClusterToPointInTimeCommandInput,
  RestoreDBClusterToPointInTimeCommandOutput,
} from "./commands/RestoreDBClusterToPointInTimeCommand";
import {
  RestoreDBInstanceFromDBSnapshotCommandInput,
  RestoreDBInstanceFromDBSnapshotCommandOutput,
} from "./commands/RestoreDBInstanceFromDBSnapshotCommand";
import {
  RestoreDBInstanceFromS3CommandInput,
  RestoreDBInstanceFromS3CommandOutput,
} from "./commands/RestoreDBInstanceFromS3Command";
import {
  RestoreDBInstanceToPointInTimeCommandInput,
  RestoreDBInstanceToPointInTimeCommandOutput,
} from "./commands/RestoreDBInstanceToPointInTimeCommand";
import {
  RevokeDBSecurityGroupIngressCommandInput,
  RevokeDBSecurityGroupIngressCommandOutput,
} from "./commands/RevokeDBSecurityGroupIngressCommand";
import {
  StartActivityStreamCommandInput,
  StartActivityStreamCommandOutput,
} from "./commands/StartActivityStreamCommand";
import {
  StartDBClusterCommandInput,
  StartDBClusterCommandOutput,
} from "./commands/StartDBClusterCommand";
import {
  StartDBInstanceAutomatedBackupsReplicationCommandInput,
  StartDBInstanceAutomatedBackupsReplicationCommandOutput,
} from "./commands/StartDBInstanceAutomatedBackupsReplicationCommand";
import {
  StartDBInstanceCommandInput,
  StartDBInstanceCommandOutput,
} from "./commands/StartDBInstanceCommand";
import {
  StartExportTaskCommandInput,
  StartExportTaskCommandOutput,
} from "./commands/StartExportTaskCommand";
import {
  StopActivityStreamCommandInput,
  StopActivityStreamCommandOutput,
} from "./commands/StopActivityStreamCommand";
import {
  StopDBClusterCommandInput,
  StopDBClusterCommandOutput,
} from "./commands/StopDBClusterCommand";
import {
  StopDBInstanceAutomatedBackupsReplicationCommandInput,
  StopDBInstanceAutomatedBackupsReplicationCommandOutput,
} from "./commands/StopDBInstanceAutomatedBackupsReplicationCommand";
import {
  StopDBInstanceCommandInput,
  StopDBInstanceCommandOutput,
} from "./commands/StopDBInstanceCommand";
import {
  SwitchoverBlueGreenDeploymentCommandInput,
  SwitchoverBlueGreenDeploymentCommandOutput,
} from "./commands/SwitchoverBlueGreenDeploymentCommand";
import {
  SwitchoverGlobalClusterCommandInput,
  SwitchoverGlobalClusterCommandOutput,
} from "./commands/SwitchoverGlobalClusterCommand";
import {
  SwitchoverReadReplicaCommandInput,
  SwitchoverReadReplicaCommandOutput,
} from "./commands/SwitchoverReadReplicaCommand";
import { RDSClient } from "./RDSClient";
export interface RDS {
  addRoleToDBCluster(
    args: AddRoleToDBClusterCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AddRoleToDBClusterCommandOutput>;
  addRoleToDBCluster(
    args: AddRoleToDBClusterCommandInput,
    cb: (err: any, data?: AddRoleToDBClusterCommandOutput) => void
  ): void;
  addRoleToDBCluster(
    args: AddRoleToDBClusterCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AddRoleToDBClusterCommandOutput) => void
  ): void;
  addRoleToDBInstance(
    args: AddRoleToDBInstanceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AddRoleToDBInstanceCommandOutput>;
  addRoleToDBInstance(
    args: AddRoleToDBInstanceCommandInput,
    cb: (err: any, data?: AddRoleToDBInstanceCommandOutput) => void
  ): void;
  addRoleToDBInstance(
    args: AddRoleToDBInstanceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AddRoleToDBInstanceCommandOutput) => void
  ): void;
  addSourceIdentifierToSubscription(
    args: AddSourceIdentifierToSubscriptionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AddSourceIdentifierToSubscriptionCommandOutput>;
  addSourceIdentifierToSubscription(
    args: AddSourceIdentifierToSubscriptionCommandInput,
    cb: (
      err: any,
      data?: AddSourceIdentifierToSubscriptionCommandOutput
    ) => void
  ): void;
  addSourceIdentifierToSubscription(
    args: AddSourceIdentifierToSubscriptionCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: AddSourceIdentifierToSubscriptionCommandOutput
    ) => void
  ): void;
  addTagsToResource(
    args: AddTagsToResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AddTagsToResourceCommandOutput>;
  addTagsToResource(
    args: AddTagsToResourceCommandInput,
    cb: (err: any, data?: AddTagsToResourceCommandOutput) => void
  ): void;
  addTagsToResource(
    args: AddTagsToResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AddTagsToResourceCommandOutput) => void
  ): void;
  applyPendingMaintenanceAction(
    args: ApplyPendingMaintenanceActionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ApplyPendingMaintenanceActionCommandOutput>;
  applyPendingMaintenanceAction(
    args: ApplyPendingMaintenanceActionCommandInput,
    cb: (err: any, data?: ApplyPendingMaintenanceActionCommandOutput) => void
  ): void;
  applyPendingMaintenanceAction(
    args: ApplyPendingMaintenanceActionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ApplyPendingMaintenanceActionCommandOutput) => void
  ): void;
  authorizeDBSecurityGroupIngress(
    args: AuthorizeDBSecurityGroupIngressCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<AuthorizeDBSecurityGroupIngressCommandOutput>;
  authorizeDBSecurityGroupIngress(
    args: AuthorizeDBSecurityGroupIngressCommandInput,
    cb: (err: any, data?: AuthorizeDBSecurityGroupIngressCommandOutput) => void
  ): void;
  authorizeDBSecurityGroupIngress(
    args: AuthorizeDBSecurityGroupIngressCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: AuthorizeDBSecurityGroupIngressCommandOutput) => void
  ): void;
  backtrackDBCluster(
    args: BacktrackDBClusterCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<BacktrackDBClusterCommandOutput>;
  backtrackDBCluster(
    args: BacktrackDBClusterCommandInput,
    cb: (err: any, data?: BacktrackDBClusterCommandOutput) => void
  ): void;
  backtrackDBCluster(
    args: BacktrackDBClusterCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: BacktrackDBClusterCommandOutput) => void
  ): void;
  cancelExportTask(
    args: CancelExportTaskCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CancelExportTaskCommandOutput>;
  cancelExportTask(
    args: CancelExportTaskCommandInput,
    cb: (err: any, data?: CancelExportTaskCommandOutput) => void
  ): void;
  cancelExportTask(
    args: CancelExportTaskCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CancelExportTaskCommandOutput) => void
  ): void;
  copyDBClusterParameterGroup(
    args: CopyDBClusterParameterGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CopyDBClusterParameterGroupCommandOutput>;
  copyDBClusterParameterGroup(
    args: CopyDBClusterParameterGroupCommandInput,
    cb: (err: any, data?: CopyDBClusterParameterGroupCommandOutput) => void
  ): void;
  copyDBClusterParameterGroup(
    args: CopyDBClusterParameterGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CopyDBClusterParameterGroupCommandOutput) => void
  ): void;
  copyDBClusterSnapshot(
    args: CopyDBClusterSnapshotCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CopyDBClusterSnapshotCommandOutput>;
  copyDBClusterSnapshot(
    args: CopyDBClusterSnapshotCommandInput,
    cb: (err: any, data?: CopyDBClusterSnapshotCommandOutput) => void
  ): void;
  copyDBClusterSnapshot(
    args: CopyDBClusterSnapshotCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CopyDBClusterSnapshotCommandOutput) => void
  ): void;
  copyDBParameterGroup(
    args: CopyDBParameterGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CopyDBParameterGroupCommandOutput>;
  copyDBParameterGroup(
    args: CopyDBParameterGroupCommandInput,
    cb: (err: any, data?: CopyDBParameterGroupCommandOutput) => void
  ): void;
  copyDBParameterGroup(
    args: CopyDBParameterGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CopyDBParameterGroupCommandOutput) => void
  ): void;
  copyDBSnapshot(
    args: CopyDBSnapshotCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CopyDBSnapshotCommandOutput>;
  copyDBSnapshot(
    args: CopyDBSnapshotCommandInput,
    cb: (err: any, data?: CopyDBSnapshotCommandOutput) => void
  ): void;
  copyDBSnapshot(
    args: CopyDBSnapshotCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CopyDBSnapshotCommandOutput) => void
  ): void;
  copyOptionGroup(
    args: CopyOptionGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CopyOptionGroupCommandOutput>;
  copyOptionGroup(
    args: CopyOptionGroupCommandInput,
    cb: (err: any, data?: CopyOptionGroupCommandOutput) => void
  ): void;
  copyOptionGroup(
    args: CopyOptionGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CopyOptionGroupCommandOutput) => void
  ): void;
  createBlueGreenDeployment(
    args: CreateBlueGreenDeploymentCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateBlueGreenDeploymentCommandOutput>;
  createBlueGreenDeployment(
    args: CreateBlueGreenDeploymentCommandInput,
    cb: (err: any, data?: CreateBlueGreenDeploymentCommandOutput) => void
  ): void;
  createBlueGreenDeployment(
    args: CreateBlueGreenDeploymentCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateBlueGreenDeploymentCommandOutput) => void
  ): void;
  createCustomDBEngineVersion(
    args: CreateCustomDBEngineVersionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateCustomDBEngineVersionCommandOutput>;
  createCustomDBEngineVersion(
    args: CreateCustomDBEngineVersionCommandInput,
    cb: (err: any, data?: CreateCustomDBEngineVersionCommandOutput) => void
  ): void;
  createCustomDBEngineVersion(
    args: CreateCustomDBEngineVersionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateCustomDBEngineVersionCommandOutput) => void
  ): void;
  createDBCluster(
    args: CreateDBClusterCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateDBClusterCommandOutput>;
  createDBCluster(
    args: CreateDBClusterCommandInput,
    cb: (err: any, data?: CreateDBClusterCommandOutput) => void
  ): void;
  createDBCluster(
    args: CreateDBClusterCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateDBClusterCommandOutput) => void
  ): void;
  createDBClusterEndpoint(
    args: CreateDBClusterEndpointCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateDBClusterEndpointCommandOutput>;
  createDBClusterEndpoint(
    args: CreateDBClusterEndpointCommandInput,
    cb: (err: any, data?: CreateDBClusterEndpointCommandOutput) => void
  ): void;
  createDBClusterEndpoint(
    args: CreateDBClusterEndpointCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateDBClusterEndpointCommandOutput) => void
  ): void;
  createDBClusterParameterGroup(
    args: CreateDBClusterParameterGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateDBClusterParameterGroupCommandOutput>;
  createDBClusterParameterGroup(
    args: CreateDBClusterParameterGroupCommandInput,
    cb: (err: any, data?: CreateDBClusterParameterGroupCommandOutput) => void
  ): void;
  createDBClusterParameterGroup(
    args: CreateDBClusterParameterGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateDBClusterParameterGroupCommandOutput) => void
  ): void;
  createDBClusterSnapshot(
    args: CreateDBClusterSnapshotCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateDBClusterSnapshotCommandOutput>;
  createDBClusterSnapshot(
    args: CreateDBClusterSnapshotCommandInput,
    cb: (err: any, data?: CreateDBClusterSnapshotCommandOutput) => void
  ): void;
  createDBClusterSnapshot(
    args: CreateDBClusterSnapshotCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateDBClusterSnapshotCommandOutput) => void
  ): void;
  createDBInstance(
    args: CreateDBInstanceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateDBInstanceCommandOutput>;
  createDBInstance(
    args: CreateDBInstanceCommandInput,
    cb: (err: any, data?: CreateDBInstanceCommandOutput) => void
  ): void;
  createDBInstance(
    args: CreateDBInstanceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateDBInstanceCommandOutput) => void
  ): void;
  createDBInstanceReadReplica(
    args: CreateDBInstanceReadReplicaCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateDBInstanceReadReplicaCommandOutput>;
  createDBInstanceReadReplica(
    args: CreateDBInstanceReadReplicaCommandInput,
    cb: (err: any, data?: CreateDBInstanceReadReplicaCommandOutput) => void
  ): void;
  createDBInstanceReadReplica(
    args: CreateDBInstanceReadReplicaCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateDBInstanceReadReplicaCommandOutput) => void
  ): void;
  createDBParameterGroup(
    args: CreateDBParameterGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateDBParameterGroupCommandOutput>;
  createDBParameterGroup(
    args: CreateDBParameterGroupCommandInput,
    cb: (err: any, data?: CreateDBParameterGroupCommandOutput) => void
  ): void;
  createDBParameterGroup(
    args: CreateDBParameterGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateDBParameterGroupCommandOutput) => void
  ): void;
  createDBProxy(
    args: CreateDBProxyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateDBProxyCommandOutput>;
  createDBProxy(
    args: CreateDBProxyCommandInput,
    cb: (err: any, data?: CreateDBProxyCommandOutput) => void
  ): void;
  createDBProxy(
    args: CreateDBProxyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateDBProxyCommandOutput) => void
  ): void;
  createDBProxyEndpoint(
    args: CreateDBProxyEndpointCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateDBProxyEndpointCommandOutput>;
  createDBProxyEndpoint(
    args: CreateDBProxyEndpointCommandInput,
    cb: (err: any, data?: CreateDBProxyEndpointCommandOutput) => void
  ): void;
  createDBProxyEndpoint(
    args: CreateDBProxyEndpointCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateDBProxyEndpointCommandOutput) => void
  ): void;
  createDBSecurityGroup(
    args: CreateDBSecurityGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateDBSecurityGroupCommandOutput>;
  createDBSecurityGroup(
    args: CreateDBSecurityGroupCommandInput,
    cb: (err: any, data?: CreateDBSecurityGroupCommandOutput) => void
  ): void;
  createDBSecurityGroup(
    args: CreateDBSecurityGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateDBSecurityGroupCommandOutput) => void
  ): void;
  createDBShardGroup(
    args: CreateDBShardGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateDBShardGroupCommandOutput>;
  createDBShardGroup(
    args: CreateDBShardGroupCommandInput,
    cb: (err: any, data?: CreateDBShardGroupCommandOutput) => void
  ): void;
  createDBShardGroup(
    args: CreateDBShardGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateDBShardGroupCommandOutput) => void
  ): void;
  createDBSnapshot(
    args: CreateDBSnapshotCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateDBSnapshotCommandOutput>;
  createDBSnapshot(
    args: CreateDBSnapshotCommandInput,
    cb: (err: any, data?: CreateDBSnapshotCommandOutput) => void
  ): void;
  createDBSnapshot(
    args: CreateDBSnapshotCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateDBSnapshotCommandOutput) => void
  ): void;
  createDBSubnetGroup(
    args: CreateDBSubnetGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateDBSubnetGroupCommandOutput>;
  createDBSubnetGroup(
    args: CreateDBSubnetGroupCommandInput,
    cb: (err: any, data?: CreateDBSubnetGroupCommandOutput) => void
  ): void;
  createDBSubnetGroup(
    args: CreateDBSubnetGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateDBSubnetGroupCommandOutput) => void
  ): void;
  createEventSubscription(
    args: CreateEventSubscriptionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateEventSubscriptionCommandOutput>;
  createEventSubscription(
    args: CreateEventSubscriptionCommandInput,
    cb: (err: any, data?: CreateEventSubscriptionCommandOutput) => void
  ): void;
  createEventSubscription(
    args: CreateEventSubscriptionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateEventSubscriptionCommandOutput) => void
  ): void;
  createGlobalCluster(): Promise<CreateGlobalClusterCommandOutput>;
  createGlobalCluster(
    args: CreateGlobalClusterCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateGlobalClusterCommandOutput>;
  createGlobalCluster(
    args: CreateGlobalClusterCommandInput,
    cb: (err: any, data?: CreateGlobalClusterCommandOutput) => void
  ): void;
  createGlobalCluster(
    args: CreateGlobalClusterCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateGlobalClusterCommandOutput) => void
  ): void;
  createIntegration(
    args: CreateIntegrationCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateIntegrationCommandOutput>;
  createIntegration(
    args: CreateIntegrationCommandInput,
    cb: (err: any, data?: CreateIntegrationCommandOutput) => void
  ): void;
  createIntegration(
    args: CreateIntegrationCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateIntegrationCommandOutput) => void
  ): void;
  createOptionGroup(
    args: CreateOptionGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateOptionGroupCommandOutput>;
  createOptionGroup(
    args: CreateOptionGroupCommandInput,
    cb: (err: any, data?: CreateOptionGroupCommandOutput) => void
  ): void;
  createOptionGroup(
    args: CreateOptionGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateOptionGroupCommandOutput) => void
  ): void;
  createTenantDatabase(
    args: CreateTenantDatabaseCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<CreateTenantDatabaseCommandOutput>;
  createTenantDatabase(
    args: CreateTenantDatabaseCommandInput,
    cb: (err: any, data?: CreateTenantDatabaseCommandOutput) => void
  ): void;
  createTenantDatabase(
    args: CreateTenantDatabaseCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: CreateTenantDatabaseCommandOutput) => void
  ): void;
  deleteBlueGreenDeployment(
    args: DeleteBlueGreenDeploymentCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteBlueGreenDeploymentCommandOutput>;
  deleteBlueGreenDeployment(
    args: DeleteBlueGreenDeploymentCommandInput,
    cb: (err: any, data?: DeleteBlueGreenDeploymentCommandOutput) => void
  ): void;
  deleteBlueGreenDeployment(
    args: DeleteBlueGreenDeploymentCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteBlueGreenDeploymentCommandOutput) => void
  ): void;
  deleteCustomDBEngineVersion(
    args: DeleteCustomDBEngineVersionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteCustomDBEngineVersionCommandOutput>;
  deleteCustomDBEngineVersion(
    args: DeleteCustomDBEngineVersionCommandInput,
    cb: (err: any, data?: DeleteCustomDBEngineVersionCommandOutput) => void
  ): void;
  deleteCustomDBEngineVersion(
    args: DeleteCustomDBEngineVersionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteCustomDBEngineVersionCommandOutput) => void
  ): void;
  deleteDBCluster(
    args: DeleteDBClusterCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteDBClusterCommandOutput>;
  deleteDBCluster(
    args: DeleteDBClusterCommandInput,
    cb: (err: any, data?: DeleteDBClusterCommandOutput) => void
  ): void;
  deleteDBCluster(
    args: DeleteDBClusterCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteDBClusterCommandOutput) => void
  ): void;
  deleteDBClusterAutomatedBackup(
    args: DeleteDBClusterAutomatedBackupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteDBClusterAutomatedBackupCommandOutput>;
  deleteDBClusterAutomatedBackup(
    args: DeleteDBClusterAutomatedBackupCommandInput,
    cb: (err: any, data?: DeleteDBClusterAutomatedBackupCommandOutput) => void
  ): void;
  deleteDBClusterAutomatedBackup(
    args: DeleteDBClusterAutomatedBackupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteDBClusterAutomatedBackupCommandOutput) => void
  ): void;
  deleteDBClusterEndpoint(
    args: DeleteDBClusterEndpointCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteDBClusterEndpointCommandOutput>;
  deleteDBClusterEndpoint(
    args: DeleteDBClusterEndpointCommandInput,
    cb: (err: any, data?: DeleteDBClusterEndpointCommandOutput) => void
  ): void;
  deleteDBClusterEndpoint(
    args: DeleteDBClusterEndpointCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteDBClusterEndpointCommandOutput) => void
  ): void;
  deleteDBClusterParameterGroup(
    args: DeleteDBClusterParameterGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteDBClusterParameterGroupCommandOutput>;
  deleteDBClusterParameterGroup(
    args: DeleteDBClusterParameterGroupCommandInput,
    cb: (err: any, data?: DeleteDBClusterParameterGroupCommandOutput) => void
  ): void;
  deleteDBClusterParameterGroup(
    args: DeleteDBClusterParameterGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteDBClusterParameterGroupCommandOutput) => void
  ): void;
  deleteDBClusterSnapshot(
    args: DeleteDBClusterSnapshotCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteDBClusterSnapshotCommandOutput>;
  deleteDBClusterSnapshot(
    args: DeleteDBClusterSnapshotCommandInput,
    cb: (err: any, data?: DeleteDBClusterSnapshotCommandOutput) => void
  ): void;
  deleteDBClusterSnapshot(
    args: DeleteDBClusterSnapshotCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteDBClusterSnapshotCommandOutput) => void
  ): void;
  deleteDBInstance(
    args: DeleteDBInstanceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteDBInstanceCommandOutput>;
  deleteDBInstance(
    args: DeleteDBInstanceCommandInput,
    cb: (err: any, data?: DeleteDBInstanceCommandOutput) => void
  ): void;
  deleteDBInstance(
    args: DeleteDBInstanceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteDBInstanceCommandOutput) => void
  ): void;
  deleteDBInstanceAutomatedBackup(): Promise<DeleteDBInstanceAutomatedBackupCommandOutput>;
  deleteDBInstanceAutomatedBackup(
    args: DeleteDBInstanceAutomatedBackupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteDBInstanceAutomatedBackupCommandOutput>;
  deleteDBInstanceAutomatedBackup(
    args: DeleteDBInstanceAutomatedBackupCommandInput,
    cb: (err: any, data?: DeleteDBInstanceAutomatedBackupCommandOutput) => void
  ): void;
  deleteDBInstanceAutomatedBackup(
    args: DeleteDBInstanceAutomatedBackupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteDBInstanceAutomatedBackupCommandOutput) => void
  ): void;
  deleteDBParameterGroup(
    args: DeleteDBParameterGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteDBParameterGroupCommandOutput>;
  deleteDBParameterGroup(
    args: DeleteDBParameterGroupCommandInput,
    cb: (err: any, data?: DeleteDBParameterGroupCommandOutput) => void
  ): void;
  deleteDBParameterGroup(
    args: DeleteDBParameterGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteDBParameterGroupCommandOutput) => void
  ): void;
  deleteDBProxy(
    args: DeleteDBProxyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteDBProxyCommandOutput>;
  deleteDBProxy(
    args: DeleteDBProxyCommandInput,
    cb: (err: any, data?: DeleteDBProxyCommandOutput) => void
  ): void;
  deleteDBProxy(
    args: DeleteDBProxyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteDBProxyCommandOutput) => void
  ): void;
  deleteDBProxyEndpoint(
    args: DeleteDBProxyEndpointCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteDBProxyEndpointCommandOutput>;
  deleteDBProxyEndpoint(
    args: DeleteDBProxyEndpointCommandInput,
    cb: (err: any, data?: DeleteDBProxyEndpointCommandOutput) => void
  ): void;
  deleteDBProxyEndpoint(
    args: DeleteDBProxyEndpointCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteDBProxyEndpointCommandOutput) => void
  ): void;
  deleteDBSecurityGroup(
    args: DeleteDBSecurityGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteDBSecurityGroupCommandOutput>;
  deleteDBSecurityGroup(
    args: DeleteDBSecurityGroupCommandInput,
    cb: (err: any, data?: DeleteDBSecurityGroupCommandOutput) => void
  ): void;
  deleteDBSecurityGroup(
    args: DeleteDBSecurityGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteDBSecurityGroupCommandOutput) => void
  ): void;
  deleteDBShardGroup(
    args: DeleteDBShardGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteDBShardGroupCommandOutput>;
  deleteDBShardGroup(
    args: DeleteDBShardGroupCommandInput,
    cb: (err: any, data?: DeleteDBShardGroupCommandOutput) => void
  ): void;
  deleteDBShardGroup(
    args: DeleteDBShardGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteDBShardGroupCommandOutput) => void
  ): void;
  deleteDBSnapshot(
    args: DeleteDBSnapshotCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteDBSnapshotCommandOutput>;
  deleteDBSnapshot(
    args: DeleteDBSnapshotCommandInput,
    cb: (err: any, data?: DeleteDBSnapshotCommandOutput) => void
  ): void;
  deleteDBSnapshot(
    args: DeleteDBSnapshotCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteDBSnapshotCommandOutput) => void
  ): void;
  deleteDBSubnetGroup(
    args: DeleteDBSubnetGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteDBSubnetGroupCommandOutput>;
  deleteDBSubnetGroup(
    args: DeleteDBSubnetGroupCommandInput,
    cb: (err: any, data?: DeleteDBSubnetGroupCommandOutput) => void
  ): void;
  deleteDBSubnetGroup(
    args: DeleteDBSubnetGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteDBSubnetGroupCommandOutput) => void
  ): void;
  deleteEventSubscription(
    args: DeleteEventSubscriptionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteEventSubscriptionCommandOutput>;
  deleteEventSubscription(
    args: DeleteEventSubscriptionCommandInput,
    cb: (err: any, data?: DeleteEventSubscriptionCommandOutput) => void
  ): void;
  deleteEventSubscription(
    args: DeleteEventSubscriptionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteEventSubscriptionCommandOutput) => void
  ): void;
  deleteGlobalCluster(
    args: DeleteGlobalClusterCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteGlobalClusterCommandOutput>;
  deleteGlobalCluster(
    args: DeleteGlobalClusterCommandInput,
    cb: (err: any, data?: DeleteGlobalClusterCommandOutput) => void
  ): void;
  deleteGlobalCluster(
    args: DeleteGlobalClusterCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteGlobalClusterCommandOutput) => void
  ): void;
  deleteIntegration(
    args: DeleteIntegrationCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteIntegrationCommandOutput>;
  deleteIntegration(
    args: DeleteIntegrationCommandInput,
    cb: (err: any, data?: DeleteIntegrationCommandOutput) => void
  ): void;
  deleteIntegration(
    args: DeleteIntegrationCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteIntegrationCommandOutput) => void
  ): void;
  deleteOptionGroup(
    args: DeleteOptionGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteOptionGroupCommandOutput>;
  deleteOptionGroup(
    args: DeleteOptionGroupCommandInput,
    cb: (err: any, data?: DeleteOptionGroupCommandOutput) => void
  ): void;
  deleteOptionGroup(
    args: DeleteOptionGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteOptionGroupCommandOutput) => void
  ): void;
  deleteTenantDatabase(
    args: DeleteTenantDatabaseCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeleteTenantDatabaseCommandOutput>;
  deleteTenantDatabase(
    args: DeleteTenantDatabaseCommandInput,
    cb: (err: any, data?: DeleteTenantDatabaseCommandOutput) => void
  ): void;
  deleteTenantDatabase(
    args: DeleteTenantDatabaseCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeleteTenantDatabaseCommandOutput) => void
  ): void;
  deregisterDBProxyTargets(
    args: DeregisterDBProxyTargetsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DeregisterDBProxyTargetsCommandOutput>;
  deregisterDBProxyTargets(
    args: DeregisterDBProxyTargetsCommandInput,
    cb: (err: any, data?: DeregisterDBProxyTargetsCommandOutput) => void
  ): void;
  deregisterDBProxyTargets(
    args: DeregisterDBProxyTargetsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DeregisterDBProxyTargetsCommandOutput) => void
  ): void;
  describeAccountAttributes(): Promise<DescribeAccountAttributesCommandOutput>;
  describeAccountAttributes(
    args: DescribeAccountAttributesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeAccountAttributesCommandOutput>;
  describeAccountAttributes(
    args: DescribeAccountAttributesCommandInput,
    cb: (err: any, data?: DescribeAccountAttributesCommandOutput) => void
  ): void;
  describeAccountAttributes(
    args: DescribeAccountAttributesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeAccountAttributesCommandOutput) => void
  ): void;
  describeBlueGreenDeployments(): Promise<DescribeBlueGreenDeploymentsCommandOutput>;
  describeBlueGreenDeployments(
    args: DescribeBlueGreenDeploymentsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeBlueGreenDeploymentsCommandOutput>;
  describeBlueGreenDeployments(
    args: DescribeBlueGreenDeploymentsCommandInput,
    cb: (err: any, data?: DescribeBlueGreenDeploymentsCommandOutput) => void
  ): void;
  describeBlueGreenDeployments(
    args: DescribeBlueGreenDeploymentsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeBlueGreenDeploymentsCommandOutput) => void
  ): void;
  describeCertificates(): Promise<DescribeCertificatesCommandOutput>;
  describeCertificates(
    args: DescribeCertificatesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeCertificatesCommandOutput>;
  describeCertificates(
    args: DescribeCertificatesCommandInput,
    cb: (err: any, data?: DescribeCertificatesCommandOutput) => void
  ): void;
  describeCertificates(
    args: DescribeCertificatesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeCertificatesCommandOutput) => void
  ): void;
  describeDBClusterAutomatedBackups(): Promise<DescribeDBClusterAutomatedBackupsCommandOutput>;
  describeDBClusterAutomatedBackups(
    args: DescribeDBClusterAutomatedBackupsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBClusterAutomatedBackupsCommandOutput>;
  describeDBClusterAutomatedBackups(
    args: DescribeDBClusterAutomatedBackupsCommandInput,
    cb: (
      err: any,
      data?: DescribeDBClusterAutomatedBackupsCommandOutput
    ) => void
  ): void;
  describeDBClusterAutomatedBackups(
    args: DescribeDBClusterAutomatedBackupsCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: DescribeDBClusterAutomatedBackupsCommandOutput
    ) => void
  ): void;
  describeDBClusterBacktracks(
    args: DescribeDBClusterBacktracksCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBClusterBacktracksCommandOutput>;
  describeDBClusterBacktracks(
    args: DescribeDBClusterBacktracksCommandInput,
    cb: (err: any, data?: DescribeDBClusterBacktracksCommandOutput) => void
  ): void;
  describeDBClusterBacktracks(
    args: DescribeDBClusterBacktracksCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBClusterBacktracksCommandOutput) => void
  ): void;
  describeDBClusterEndpoints(): Promise<DescribeDBClusterEndpointsCommandOutput>;
  describeDBClusterEndpoints(
    args: DescribeDBClusterEndpointsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBClusterEndpointsCommandOutput>;
  describeDBClusterEndpoints(
    args: DescribeDBClusterEndpointsCommandInput,
    cb: (err: any, data?: DescribeDBClusterEndpointsCommandOutput) => void
  ): void;
  describeDBClusterEndpoints(
    args: DescribeDBClusterEndpointsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBClusterEndpointsCommandOutput) => void
  ): void;
  describeDBClusterParameterGroups(): Promise<DescribeDBClusterParameterGroupsCommandOutput>;
  describeDBClusterParameterGroups(
    args: DescribeDBClusterParameterGroupsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBClusterParameterGroupsCommandOutput>;
  describeDBClusterParameterGroups(
    args: DescribeDBClusterParameterGroupsCommandInput,
    cb: (err: any, data?: DescribeDBClusterParameterGroupsCommandOutput) => void
  ): void;
  describeDBClusterParameterGroups(
    args: DescribeDBClusterParameterGroupsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBClusterParameterGroupsCommandOutput) => void
  ): void;
  describeDBClusterParameters(
    args: DescribeDBClusterParametersCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBClusterParametersCommandOutput>;
  describeDBClusterParameters(
    args: DescribeDBClusterParametersCommandInput,
    cb: (err: any, data?: DescribeDBClusterParametersCommandOutput) => void
  ): void;
  describeDBClusterParameters(
    args: DescribeDBClusterParametersCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBClusterParametersCommandOutput) => void
  ): void;
  describeDBClusters(): Promise<DescribeDBClustersCommandOutput>;
  describeDBClusters(
    args: DescribeDBClustersCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBClustersCommandOutput>;
  describeDBClusters(
    args: DescribeDBClustersCommandInput,
    cb: (err: any, data?: DescribeDBClustersCommandOutput) => void
  ): void;
  describeDBClusters(
    args: DescribeDBClustersCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBClustersCommandOutput) => void
  ): void;
  describeDBClusterSnapshotAttributes(
    args: DescribeDBClusterSnapshotAttributesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBClusterSnapshotAttributesCommandOutput>;
  describeDBClusterSnapshotAttributes(
    args: DescribeDBClusterSnapshotAttributesCommandInput,
    cb: (
      err: any,
      data?: DescribeDBClusterSnapshotAttributesCommandOutput
    ) => void
  ): void;
  describeDBClusterSnapshotAttributes(
    args: DescribeDBClusterSnapshotAttributesCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: DescribeDBClusterSnapshotAttributesCommandOutput
    ) => void
  ): void;
  describeDBClusterSnapshots(): Promise<DescribeDBClusterSnapshotsCommandOutput>;
  describeDBClusterSnapshots(
    args: DescribeDBClusterSnapshotsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBClusterSnapshotsCommandOutput>;
  describeDBClusterSnapshots(
    args: DescribeDBClusterSnapshotsCommandInput,
    cb: (err: any, data?: DescribeDBClusterSnapshotsCommandOutput) => void
  ): void;
  describeDBClusterSnapshots(
    args: DescribeDBClusterSnapshotsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBClusterSnapshotsCommandOutput) => void
  ): void;
  describeDBEngineVersions(): Promise<DescribeDBEngineVersionsCommandOutput>;
  describeDBEngineVersions(
    args: DescribeDBEngineVersionsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBEngineVersionsCommandOutput>;
  describeDBEngineVersions(
    args: DescribeDBEngineVersionsCommandInput,
    cb: (err: any, data?: DescribeDBEngineVersionsCommandOutput) => void
  ): void;
  describeDBEngineVersions(
    args: DescribeDBEngineVersionsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBEngineVersionsCommandOutput) => void
  ): void;
  describeDBInstanceAutomatedBackups(): Promise<DescribeDBInstanceAutomatedBackupsCommandOutput>;
  describeDBInstanceAutomatedBackups(
    args: DescribeDBInstanceAutomatedBackupsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBInstanceAutomatedBackupsCommandOutput>;
  describeDBInstanceAutomatedBackups(
    args: DescribeDBInstanceAutomatedBackupsCommandInput,
    cb: (
      err: any,
      data?: DescribeDBInstanceAutomatedBackupsCommandOutput
    ) => void
  ): void;
  describeDBInstanceAutomatedBackups(
    args: DescribeDBInstanceAutomatedBackupsCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: DescribeDBInstanceAutomatedBackupsCommandOutput
    ) => void
  ): void;
  describeDBInstances(): Promise<DescribeDBInstancesCommandOutput>;
  describeDBInstances(
    args: DescribeDBInstancesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBInstancesCommandOutput>;
  describeDBInstances(
    args: DescribeDBInstancesCommandInput,
    cb: (err: any, data?: DescribeDBInstancesCommandOutput) => void
  ): void;
  describeDBInstances(
    args: DescribeDBInstancesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBInstancesCommandOutput) => void
  ): void;
  describeDBLogFiles(
    args: DescribeDBLogFilesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBLogFilesCommandOutput>;
  describeDBLogFiles(
    args: DescribeDBLogFilesCommandInput,
    cb: (err: any, data?: DescribeDBLogFilesCommandOutput) => void
  ): void;
  describeDBLogFiles(
    args: DescribeDBLogFilesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBLogFilesCommandOutput) => void
  ): void;
  describeDBMajorEngineVersions(): Promise<DescribeDBMajorEngineVersionsCommandOutput>;
  describeDBMajorEngineVersions(
    args: DescribeDBMajorEngineVersionsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBMajorEngineVersionsCommandOutput>;
  describeDBMajorEngineVersions(
    args: DescribeDBMajorEngineVersionsCommandInput,
    cb: (err: any, data?: DescribeDBMajorEngineVersionsCommandOutput) => void
  ): void;
  describeDBMajorEngineVersions(
    args: DescribeDBMajorEngineVersionsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBMajorEngineVersionsCommandOutput) => void
  ): void;
  describeDBParameterGroups(): Promise<DescribeDBParameterGroupsCommandOutput>;
  describeDBParameterGroups(
    args: DescribeDBParameterGroupsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBParameterGroupsCommandOutput>;
  describeDBParameterGroups(
    args: DescribeDBParameterGroupsCommandInput,
    cb: (err: any, data?: DescribeDBParameterGroupsCommandOutput) => void
  ): void;
  describeDBParameterGroups(
    args: DescribeDBParameterGroupsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBParameterGroupsCommandOutput) => void
  ): void;
  describeDBParameters(
    args: DescribeDBParametersCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBParametersCommandOutput>;
  describeDBParameters(
    args: DescribeDBParametersCommandInput,
    cb: (err: any, data?: DescribeDBParametersCommandOutput) => void
  ): void;
  describeDBParameters(
    args: DescribeDBParametersCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBParametersCommandOutput) => void
  ): void;
  describeDBProxies(): Promise<DescribeDBProxiesCommandOutput>;
  describeDBProxies(
    args: DescribeDBProxiesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBProxiesCommandOutput>;
  describeDBProxies(
    args: DescribeDBProxiesCommandInput,
    cb: (err: any, data?: DescribeDBProxiesCommandOutput) => void
  ): void;
  describeDBProxies(
    args: DescribeDBProxiesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBProxiesCommandOutput) => void
  ): void;
  describeDBProxyEndpoints(): Promise<DescribeDBProxyEndpointsCommandOutput>;
  describeDBProxyEndpoints(
    args: DescribeDBProxyEndpointsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBProxyEndpointsCommandOutput>;
  describeDBProxyEndpoints(
    args: DescribeDBProxyEndpointsCommandInput,
    cb: (err: any, data?: DescribeDBProxyEndpointsCommandOutput) => void
  ): void;
  describeDBProxyEndpoints(
    args: DescribeDBProxyEndpointsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBProxyEndpointsCommandOutput) => void
  ): void;
  describeDBProxyTargetGroups(
    args: DescribeDBProxyTargetGroupsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBProxyTargetGroupsCommandOutput>;
  describeDBProxyTargetGroups(
    args: DescribeDBProxyTargetGroupsCommandInput,
    cb: (err: any, data?: DescribeDBProxyTargetGroupsCommandOutput) => void
  ): void;
  describeDBProxyTargetGroups(
    args: DescribeDBProxyTargetGroupsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBProxyTargetGroupsCommandOutput) => void
  ): void;
  describeDBProxyTargets(
    args: DescribeDBProxyTargetsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBProxyTargetsCommandOutput>;
  describeDBProxyTargets(
    args: DescribeDBProxyTargetsCommandInput,
    cb: (err: any, data?: DescribeDBProxyTargetsCommandOutput) => void
  ): void;
  describeDBProxyTargets(
    args: DescribeDBProxyTargetsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBProxyTargetsCommandOutput) => void
  ): void;
  describeDBRecommendations(): Promise<DescribeDBRecommendationsCommandOutput>;
  describeDBRecommendations(
    args: DescribeDBRecommendationsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBRecommendationsCommandOutput>;
  describeDBRecommendations(
    args: DescribeDBRecommendationsCommandInput,
    cb: (err: any, data?: DescribeDBRecommendationsCommandOutput) => void
  ): void;
  describeDBRecommendations(
    args: DescribeDBRecommendationsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBRecommendationsCommandOutput) => void
  ): void;
  describeDBSecurityGroups(): Promise<DescribeDBSecurityGroupsCommandOutput>;
  describeDBSecurityGroups(
    args: DescribeDBSecurityGroupsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBSecurityGroupsCommandOutput>;
  describeDBSecurityGroups(
    args: DescribeDBSecurityGroupsCommandInput,
    cb: (err: any, data?: DescribeDBSecurityGroupsCommandOutput) => void
  ): void;
  describeDBSecurityGroups(
    args: DescribeDBSecurityGroupsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBSecurityGroupsCommandOutput) => void
  ): void;
  describeDBShardGroups(): Promise<DescribeDBShardGroupsCommandOutput>;
  describeDBShardGroups(
    args: DescribeDBShardGroupsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBShardGroupsCommandOutput>;
  describeDBShardGroups(
    args: DescribeDBShardGroupsCommandInput,
    cb: (err: any, data?: DescribeDBShardGroupsCommandOutput) => void
  ): void;
  describeDBShardGroups(
    args: DescribeDBShardGroupsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBShardGroupsCommandOutput) => void
  ): void;
  describeDBSnapshotAttributes(
    args: DescribeDBSnapshotAttributesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBSnapshotAttributesCommandOutput>;
  describeDBSnapshotAttributes(
    args: DescribeDBSnapshotAttributesCommandInput,
    cb: (err: any, data?: DescribeDBSnapshotAttributesCommandOutput) => void
  ): void;
  describeDBSnapshotAttributes(
    args: DescribeDBSnapshotAttributesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBSnapshotAttributesCommandOutput) => void
  ): void;
  describeDBSnapshots(): Promise<DescribeDBSnapshotsCommandOutput>;
  describeDBSnapshots(
    args: DescribeDBSnapshotsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBSnapshotsCommandOutput>;
  describeDBSnapshots(
    args: DescribeDBSnapshotsCommandInput,
    cb: (err: any, data?: DescribeDBSnapshotsCommandOutput) => void
  ): void;
  describeDBSnapshots(
    args: DescribeDBSnapshotsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBSnapshotsCommandOutput) => void
  ): void;
  describeDBSnapshotTenantDatabases(): Promise<DescribeDBSnapshotTenantDatabasesCommandOutput>;
  describeDBSnapshotTenantDatabases(
    args: DescribeDBSnapshotTenantDatabasesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBSnapshotTenantDatabasesCommandOutput>;
  describeDBSnapshotTenantDatabases(
    args: DescribeDBSnapshotTenantDatabasesCommandInput,
    cb: (
      err: any,
      data?: DescribeDBSnapshotTenantDatabasesCommandOutput
    ) => void
  ): void;
  describeDBSnapshotTenantDatabases(
    args: DescribeDBSnapshotTenantDatabasesCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: DescribeDBSnapshotTenantDatabasesCommandOutput
    ) => void
  ): void;
  describeDBSubnetGroups(): Promise<DescribeDBSubnetGroupsCommandOutput>;
  describeDBSubnetGroups(
    args: DescribeDBSubnetGroupsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeDBSubnetGroupsCommandOutput>;
  describeDBSubnetGroups(
    args: DescribeDBSubnetGroupsCommandInput,
    cb: (err: any, data?: DescribeDBSubnetGroupsCommandOutput) => void
  ): void;
  describeDBSubnetGroups(
    args: DescribeDBSubnetGroupsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeDBSubnetGroupsCommandOutput) => void
  ): void;
  describeEngineDefaultClusterParameters(
    args: DescribeEngineDefaultClusterParametersCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeEngineDefaultClusterParametersCommandOutput>;
  describeEngineDefaultClusterParameters(
    args: DescribeEngineDefaultClusterParametersCommandInput,
    cb: (
      err: any,
      data?: DescribeEngineDefaultClusterParametersCommandOutput
    ) => void
  ): void;
  describeEngineDefaultClusterParameters(
    args: DescribeEngineDefaultClusterParametersCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: DescribeEngineDefaultClusterParametersCommandOutput
    ) => void
  ): void;
  describeEngineDefaultParameters(
    args: DescribeEngineDefaultParametersCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeEngineDefaultParametersCommandOutput>;
  describeEngineDefaultParameters(
    args: DescribeEngineDefaultParametersCommandInput,
    cb: (err: any, data?: DescribeEngineDefaultParametersCommandOutput) => void
  ): void;
  describeEngineDefaultParameters(
    args: DescribeEngineDefaultParametersCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeEngineDefaultParametersCommandOutput) => void
  ): void;
  describeEventCategories(): Promise<DescribeEventCategoriesCommandOutput>;
  describeEventCategories(
    args: DescribeEventCategoriesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeEventCategoriesCommandOutput>;
  describeEventCategories(
    args: DescribeEventCategoriesCommandInput,
    cb: (err: any, data?: DescribeEventCategoriesCommandOutput) => void
  ): void;
  describeEventCategories(
    args: DescribeEventCategoriesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeEventCategoriesCommandOutput) => void
  ): void;
  describeEvents(): Promise<DescribeEventsCommandOutput>;
  describeEvents(
    args: DescribeEventsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeEventsCommandOutput>;
  describeEvents(
    args: DescribeEventsCommandInput,
    cb: (err: any, data?: DescribeEventsCommandOutput) => void
  ): void;
  describeEvents(
    args: DescribeEventsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeEventsCommandOutput) => void
  ): void;
  describeEventSubscriptions(): Promise<DescribeEventSubscriptionsCommandOutput>;
  describeEventSubscriptions(
    args: DescribeEventSubscriptionsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeEventSubscriptionsCommandOutput>;
  describeEventSubscriptions(
    args: DescribeEventSubscriptionsCommandInput,
    cb: (err: any, data?: DescribeEventSubscriptionsCommandOutput) => void
  ): void;
  describeEventSubscriptions(
    args: DescribeEventSubscriptionsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeEventSubscriptionsCommandOutput) => void
  ): void;
  describeExportTasks(): Promise<DescribeExportTasksCommandOutput>;
  describeExportTasks(
    args: DescribeExportTasksCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeExportTasksCommandOutput>;
  describeExportTasks(
    args: DescribeExportTasksCommandInput,
    cb: (err: any, data?: DescribeExportTasksCommandOutput) => void
  ): void;
  describeExportTasks(
    args: DescribeExportTasksCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeExportTasksCommandOutput) => void
  ): void;
  describeGlobalClusters(): Promise<DescribeGlobalClustersCommandOutput>;
  describeGlobalClusters(
    args: DescribeGlobalClustersCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeGlobalClustersCommandOutput>;
  describeGlobalClusters(
    args: DescribeGlobalClustersCommandInput,
    cb: (err: any, data?: DescribeGlobalClustersCommandOutput) => void
  ): void;
  describeGlobalClusters(
    args: DescribeGlobalClustersCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeGlobalClustersCommandOutput) => void
  ): void;
  describeIntegrations(): Promise<DescribeIntegrationsCommandOutput>;
  describeIntegrations(
    args: DescribeIntegrationsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeIntegrationsCommandOutput>;
  describeIntegrations(
    args: DescribeIntegrationsCommandInput,
    cb: (err: any, data?: DescribeIntegrationsCommandOutput) => void
  ): void;
  describeIntegrations(
    args: DescribeIntegrationsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeIntegrationsCommandOutput) => void
  ): void;
  describeOptionGroupOptions(
    args: DescribeOptionGroupOptionsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeOptionGroupOptionsCommandOutput>;
  describeOptionGroupOptions(
    args: DescribeOptionGroupOptionsCommandInput,
    cb: (err: any, data?: DescribeOptionGroupOptionsCommandOutput) => void
  ): void;
  describeOptionGroupOptions(
    args: DescribeOptionGroupOptionsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeOptionGroupOptionsCommandOutput) => void
  ): void;
  describeOptionGroups(): Promise<DescribeOptionGroupsCommandOutput>;
  describeOptionGroups(
    args: DescribeOptionGroupsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeOptionGroupsCommandOutput>;
  describeOptionGroups(
    args: DescribeOptionGroupsCommandInput,
    cb: (err: any, data?: DescribeOptionGroupsCommandOutput) => void
  ): void;
  describeOptionGroups(
    args: DescribeOptionGroupsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeOptionGroupsCommandOutput) => void
  ): void;
  describeOrderableDBInstanceOptions(
    args: DescribeOrderableDBInstanceOptionsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeOrderableDBInstanceOptionsCommandOutput>;
  describeOrderableDBInstanceOptions(
    args: DescribeOrderableDBInstanceOptionsCommandInput,
    cb: (
      err: any,
      data?: DescribeOrderableDBInstanceOptionsCommandOutput
    ) => void
  ): void;
  describeOrderableDBInstanceOptions(
    args: DescribeOrderableDBInstanceOptionsCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: DescribeOrderableDBInstanceOptionsCommandOutput
    ) => void
  ): void;
  describePendingMaintenanceActions(): Promise<DescribePendingMaintenanceActionsCommandOutput>;
  describePendingMaintenanceActions(
    args: DescribePendingMaintenanceActionsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribePendingMaintenanceActionsCommandOutput>;
  describePendingMaintenanceActions(
    args: DescribePendingMaintenanceActionsCommandInput,
    cb: (
      err: any,
      data?: DescribePendingMaintenanceActionsCommandOutput
    ) => void
  ): void;
  describePendingMaintenanceActions(
    args: DescribePendingMaintenanceActionsCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: DescribePendingMaintenanceActionsCommandOutput
    ) => void
  ): void;
  describeReservedDBInstances(): Promise<DescribeReservedDBInstancesCommandOutput>;
  describeReservedDBInstances(
    args: DescribeReservedDBInstancesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeReservedDBInstancesCommandOutput>;
  describeReservedDBInstances(
    args: DescribeReservedDBInstancesCommandInput,
    cb: (err: any, data?: DescribeReservedDBInstancesCommandOutput) => void
  ): void;
  describeReservedDBInstances(
    args: DescribeReservedDBInstancesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeReservedDBInstancesCommandOutput) => void
  ): void;
  describeReservedDBInstancesOfferings(): Promise<DescribeReservedDBInstancesOfferingsCommandOutput>;
  describeReservedDBInstancesOfferings(
    args: DescribeReservedDBInstancesOfferingsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeReservedDBInstancesOfferingsCommandOutput>;
  describeReservedDBInstancesOfferings(
    args: DescribeReservedDBInstancesOfferingsCommandInput,
    cb: (
      err: any,
      data?: DescribeReservedDBInstancesOfferingsCommandOutput
    ) => void
  ): void;
  describeReservedDBInstancesOfferings(
    args: DescribeReservedDBInstancesOfferingsCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: DescribeReservedDBInstancesOfferingsCommandOutput
    ) => void
  ): void;
  describeSourceRegions(): Promise<DescribeSourceRegionsCommandOutput>;
  describeSourceRegions(
    args: DescribeSourceRegionsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeSourceRegionsCommandOutput>;
  describeSourceRegions(
    args: DescribeSourceRegionsCommandInput,
    cb: (err: any, data?: DescribeSourceRegionsCommandOutput) => void
  ): void;
  describeSourceRegions(
    args: DescribeSourceRegionsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeSourceRegionsCommandOutput) => void
  ): void;
  describeTenantDatabases(): Promise<DescribeTenantDatabasesCommandOutput>;
  describeTenantDatabases(
    args: DescribeTenantDatabasesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeTenantDatabasesCommandOutput>;
  describeTenantDatabases(
    args: DescribeTenantDatabasesCommandInput,
    cb: (err: any, data?: DescribeTenantDatabasesCommandOutput) => void
  ): void;
  describeTenantDatabases(
    args: DescribeTenantDatabasesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DescribeTenantDatabasesCommandOutput) => void
  ): void;
  describeValidDBInstanceModifications(
    args: DescribeValidDBInstanceModificationsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DescribeValidDBInstanceModificationsCommandOutput>;
  describeValidDBInstanceModifications(
    args: DescribeValidDBInstanceModificationsCommandInput,
    cb: (
      err: any,
      data?: DescribeValidDBInstanceModificationsCommandOutput
    ) => void
  ): void;
  describeValidDBInstanceModifications(
    args: DescribeValidDBInstanceModificationsCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: DescribeValidDBInstanceModificationsCommandOutput
    ) => void
  ): void;
  disableHttpEndpoint(
    args: DisableHttpEndpointCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DisableHttpEndpointCommandOutput>;
  disableHttpEndpoint(
    args: DisableHttpEndpointCommandInput,
    cb: (err: any, data?: DisableHttpEndpointCommandOutput) => void
  ): void;
  disableHttpEndpoint(
    args: DisableHttpEndpointCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DisableHttpEndpointCommandOutput) => void
  ): void;
  downloadDBLogFilePortion(
    args: DownloadDBLogFilePortionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<DownloadDBLogFilePortionCommandOutput>;
  downloadDBLogFilePortion(
    args: DownloadDBLogFilePortionCommandInput,
    cb: (err: any, data?: DownloadDBLogFilePortionCommandOutput) => void
  ): void;
  downloadDBLogFilePortion(
    args: DownloadDBLogFilePortionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: DownloadDBLogFilePortionCommandOutput) => void
  ): void;
  enableHttpEndpoint(
    args: EnableHttpEndpointCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<EnableHttpEndpointCommandOutput>;
  enableHttpEndpoint(
    args: EnableHttpEndpointCommandInput,
    cb: (err: any, data?: EnableHttpEndpointCommandOutput) => void
  ): void;
  enableHttpEndpoint(
    args: EnableHttpEndpointCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: EnableHttpEndpointCommandOutput) => void
  ): void;
  failoverDBCluster(
    args: FailoverDBClusterCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<FailoverDBClusterCommandOutput>;
  failoverDBCluster(
    args: FailoverDBClusterCommandInput,
    cb: (err: any, data?: FailoverDBClusterCommandOutput) => void
  ): void;
  failoverDBCluster(
    args: FailoverDBClusterCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: FailoverDBClusterCommandOutput) => void
  ): void;
  failoverGlobalCluster(
    args: FailoverGlobalClusterCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<FailoverGlobalClusterCommandOutput>;
  failoverGlobalCluster(
    args: FailoverGlobalClusterCommandInput,
    cb: (err: any, data?: FailoverGlobalClusterCommandOutput) => void
  ): void;
  failoverGlobalCluster(
    args: FailoverGlobalClusterCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: FailoverGlobalClusterCommandOutput) => void
  ): void;
  listTagsForResource(
    args: ListTagsForResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ListTagsForResourceCommandOutput>;
  listTagsForResource(
    args: ListTagsForResourceCommandInput,
    cb: (err: any, data?: ListTagsForResourceCommandOutput) => void
  ): void;
  listTagsForResource(
    args: ListTagsForResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ListTagsForResourceCommandOutput) => void
  ): void;
  modifyActivityStream(): Promise<ModifyActivityStreamCommandOutput>;
  modifyActivityStream(
    args: ModifyActivityStreamCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyActivityStreamCommandOutput>;
  modifyActivityStream(
    args: ModifyActivityStreamCommandInput,
    cb: (err: any, data?: ModifyActivityStreamCommandOutput) => void
  ): void;
  modifyActivityStream(
    args: ModifyActivityStreamCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyActivityStreamCommandOutput) => void
  ): void;
  modifyCertificates(): Promise<ModifyCertificatesCommandOutput>;
  modifyCertificates(
    args: ModifyCertificatesCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyCertificatesCommandOutput>;
  modifyCertificates(
    args: ModifyCertificatesCommandInput,
    cb: (err: any, data?: ModifyCertificatesCommandOutput) => void
  ): void;
  modifyCertificates(
    args: ModifyCertificatesCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyCertificatesCommandOutput) => void
  ): void;
  modifyCurrentDBClusterCapacity(
    args: ModifyCurrentDBClusterCapacityCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyCurrentDBClusterCapacityCommandOutput>;
  modifyCurrentDBClusterCapacity(
    args: ModifyCurrentDBClusterCapacityCommandInput,
    cb: (err: any, data?: ModifyCurrentDBClusterCapacityCommandOutput) => void
  ): void;
  modifyCurrentDBClusterCapacity(
    args: ModifyCurrentDBClusterCapacityCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyCurrentDBClusterCapacityCommandOutput) => void
  ): void;
  modifyCustomDBEngineVersion(
    args: ModifyCustomDBEngineVersionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyCustomDBEngineVersionCommandOutput>;
  modifyCustomDBEngineVersion(
    args: ModifyCustomDBEngineVersionCommandInput,
    cb: (err: any, data?: ModifyCustomDBEngineVersionCommandOutput) => void
  ): void;
  modifyCustomDBEngineVersion(
    args: ModifyCustomDBEngineVersionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyCustomDBEngineVersionCommandOutput) => void
  ): void;
  modifyDBCluster(
    args: ModifyDBClusterCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyDBClusterCommandOutput>;
  modifyDBCluster(
    args: ModifyDBClusterCommandInput,
    cb: (err: any, data?: ModifyDBClusterCommandOutput) => void
  ): void;
  modifyDBCluster(
    args: ModifyDBClusterCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyDBClusterCommandOutput) => void
  ): void;
  modifyDBClusterEndpoint(
    args: ModifyDBClusterEndpointCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyDBClusterEndpointCommandOutput>;
  modifyDBClusterEndpoint(
    args: ModifyDBClusterEndpointCommandInput,
    cb: (err: any, data?: ModifyDBClusterEndpointCommandOutput) => void
  ): void;
  modifyDBClusterEndpoint(
    args: ModifyDBClusterEndpointCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyDBClusterEndpointCommandOutput) => void
  ): void;
  modifyDBClusterParameterGroup(
    args: ModifyDBClusterParameterGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyDBClusterParameterGroupCommandOutput>;
  modifyDBClusterParameterGroup(
    args: ModifyDBClusterParameterGroupCommandInput,
    cb: (err: any, data?: ModifyDBClusterParameterGroupCommandOutput) => void
  ): void;
  modifyDBClusterParameterGroup(
    args: ModifyDBClusterParameterGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyDBClusterParameterGroupCommandOutput) => void
  ): void;
  modifyDBClusterSnapshotAttribute(
    args: ModifyDBClusterSnapshotAttributeCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyDBClusterSnapshotAttributeCommandOutput>;
  modifyDBClusterSnapshotAttribute(
    args: ModifyDBClusterSnapshotAttributeCommandInput,
    cb: (err: any, data?: ModifyDBClusterSnapshotAttributeCommandOutput) => void
  ): void;
  modifyDBClusterSnapshotAttribute(
    args: ModifyDBClusterSnapshotAttributeCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyDBClusterSnapshotAttributeCommandOutput) => void
  ): void;
  modifyDBInstance(
    args: ModifyDBInstanceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyDBInstanceCommandOutput>;
  modifyDBInstance(
    args: ModifyDBInstanceCommandInput,
    cb: (err: any, data?: ModifyDBInstanceCommandOutput) => void
  ): void;
  modifyDBInstance(
    args: ModifyDBInstanceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyDBInstanceCommandOutput) => void
  ): void;
  modifyDBParameterGroup(
    args: ModifyDBParameterGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyDBParameterGroupCommandOutput>;
  modifyDBParameterGroup(
    args: ModifyDBParameterGroupCommandInput,
    cb: (err: any, data?: ModifyDBParameterGroupCommandOutput) => void
  ): void;
  modifyDBParameterGroup(
    args: ModifyDBParameterGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyDBParameterGroupCommandOutput) => void
  ): void;
  modifyDBProxy(
    args: ModifyDBProxyCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyDBProxyCommandOutput>;
  modifyDBProxy(
    args: ModifyDBProxyCommandInput,
    cb: (err: any, data?: ModifyDBProxyCommandOutput) => void
  ): void;
  modifyDBProxy(
    args: ModifyDBProxyCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyDBProxyCommandOutput) => void
  ): void;
  modifyDBProxyEndpoint(
    args: ModifyDBProxyEndpointCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyDBProxyEndpointCommandOutput>;
  modifyDBProxyEndpoint(
    args: ModifyDBProxyEndpointCommandInput,
    cb: (err: any, data?: ModifyDBProxyEndpointCommandOutput) => void
  ): void;
  modifyDBProxyEndpoint(
    args: ModifyDBProxyEndpointCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyDBProxyEndpointCommandOutput) => void
  ): void;
  modifyDBProxyTargetGroup(
    args: ModifyDBProxyTargetGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyDBProxyTargetGroupCommandOutput>;
  modifyDBProxyTargetGroup(
    args: ModifyDBProxyTargetGroupCommandInput,
    cb: (err: any, data?: ModifyDBProxyTargetGroupCommandOutput) => void
  ): void;
  modifyDBProxyTargetGroup(
    args: ModifyDBProxyTargetGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyDBProxyTargetGroupCommandOutput) => void
  ): void;
  modifyDBRecommendation(
    args: ModifyDBRecommendationCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyDBRecommendationCommandOutput>;
  modifyDBRecommendation(
    args: ModifyDBRecommendationCommandInput,
    cb: (err: any, data?: ModifyDBRecommendationCommandOutput) => void
  ): void;
  modifyDBRecommendation(
    args: ModifyDBRecommendationCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyDBRecommendationCommandOutput) => void
  ): void;
  modifyDBShardGroup(
    args: ModifyDBShardGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyDBShardGroupCommandOutput>;
  modifyDBShardGroup(
    args: ModifyDBShardGroupCommandInput,
    cb: (err: any, data?: ModifyDBShardGroupCommandOutput) => void
  ): void;
  modifyDBShardGroup(
    args: ModifyDBShardGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyDBShardGroupCommandOutput) => void
  ): void;
  modifyDBSnapshot(
    args: ModifyDBSnapshotCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyDBSnapshotCommandOutput>;
  modifyDBSnapshot(
    args: ModifyDBSnapshotCommandInput,
    cb: (err: any, data?: ModifyDBSnapshotCommandOutput) => void
  ): void;
  modifyDBSnapshot(
    args: ModifyDBSnapshotCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyDBSnapshotCommandOutput) => void
  ): void;
  modifyDBSnapshotAttribute(
    args: ModifyDBSnapshotAttributeCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyDBSnapshotAttributeCommandOutput>;
  modifyDBSnapshotAttribute(
    args: ModifyDBSnapshotAttributeCommandInput,
    cb: (err: any, data?: ModifyDBSnapshotAttributeCommandOutput) => void
  ): void;
  modifyDBSnapshotAttribute(
    args: ModifyDBSnapshotAttributeCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyDBSnapshotAttributeCommandOutput) => void
  ): void;
  modifyDBSubnetGroup(
    args: ModifyDBSubnetGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyDBSubnetGroupCommandOutput>;
  modifyDBSubnetGroup(
    args: ModifyDBSubnetGroupCommandInput,
    cb: (err: any, data?: ModifyDBSubnetGroupCommandOutput) => void
  ): void;
  modifyDBSubnetGroup(
    args: ModifyDBSubnetGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyDBSubnetGroupCommandOutput) => void
  ): void;
  modifyEventSubscription(
    args: ModifyEventSubscriptionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyEventSubscriptionCommandOutput>;
  modifyEventSubscription(
    args: ModifyEventSubscriptionCommandInput,
    cb: (err: any, data?: ModifyEventSubscriptionCommandOutput) => void
  ): void;
  modifyEventSubscription(
    args: ModifyEventSubscriptionCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyEventSubscriptionCommandOutput) => void
  ): void;
  modifyGlobalCluster(): Promise<ModifyGlobalClusterCommandOutput>;
  modifyGlobalCluster(
    args: ModifyGlobalClusterCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyGlobalClusterCommandOutput>;
  modifyGlobalCluster(
    args: ModifyGlobalClusterCommandInput,
    cb: (err: any, data?: ModifyGlobalClusterCommandOutput) => void
  ): void;
  modifyGlobalCluster(
    args: ModifyGlobalClusterCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyGlobalClusterCommandOutput) => void
  ): void;
  modifyIntegration(
    args: ModifyIntegrationCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyIntegrationCommandOutput>;
  modifyIntegration(
    args: ModifyIntegrationCommandInput,
    cb: (err: any, data?: ModifyIntegrationCommandOutput) => void
  ): void;
  modifyIntegration(
    args: ModifyIntegrationCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyIntegrationCommandOutput) => void
  ): void;
  modifyOptionGroup(
    args: ModifyOptionGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyOptionGroupCommandOutput>;
  modifyOptionGroup(
    args: ModifyOptionGroupCommandInput,
    cb: (err: any, data?: ModifyOptionGroupCommandOutput) => void
  ): void;
  modifyOptionGroup(
    args: ModifyOptionGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyOptionGroupCommandOutput) => void
  ): void;
  modifyTenantDatabase(
    args: ModifyTenantDatabaseCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ModifyTenantDatabaseCommandOutput>;
  modifyTenantDatabase(
    args: ModifyTenantDatabaseCommandInput,
    cb: (err: any, data?: ModifyTenantDatabaseCommandOutput) => void
  ): void;
  modifyTenantDatabase(
    args: ModifyTenantDatabaseCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ModifyTenantDatabaseCommandOutput) => void
  ): void;
  promoteReadReplica(
    args: PromoteReadReplicaCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<PromoteReadReplicaCommandOutput>;
  promoteReadReplica(
    args: PromoteReadReplicaCommandInput,
    cb: (err: any, data?: PromoteReadReplicaCommandOutput) => void
  ): void;
  promoteReadReplica(
    args: PromoteReadReplicaCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: PromoteReadReplicaCommandOutput) => void
  ): void;
  promoteReadReplicaDBCluster(
    args: PromoteReadReplicaDBClusterCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<PromoteReadReplicaDBClusterCommandOutput>;
  promoteReadReplicaDBCluster(
    args: PromoteReadReplicaDBClusterCommandInput,
    cb: (err: any, data?: PromoteReadReplicaDBClusterCommandOutput) => void
  ): void;
  promoteReadReplicaDBCluster(
    args: PromoteReadReplicaDBClusterCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: PromoteReadReplicaDBClusterCommandOutput) => void
  ): void;
  purchaseReservedDBInstancesOffering(
    args: PurchaseReservedDBInstancesOfferingCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<PurchaseReservedDBInstancesOfferingCommandOutput>;
  purchaseReservedDBInstancesOffering(
    args: PurchaseReservedDBInstancesOfferingCommandInput,
    cb: (
      err: any,
      data?: PurchaseReservedDBInstancesOfferingCommandOutput
    ) => void
  ): void;
  purchaseReservedDBInstancesOffering(
    args: PurchaseReservedDBInstancesOfferingCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: PurchaseReservedDBInstancesOfferingCommandOutput
    ) => void
  ): void;
  rebootDBCluster(
    args: RebootDBClusterCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RebootDBClusterCommandOutput>;
  rebootDBCluster(
    args: RebootDBClusterCommandInput,
    cb: (err: any, data?: RebootDBClusterCommandOutput) => void
  ): void;
  rebootDBCluster(
    args: RebootDBClusterCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RebootDBClusterCommandOutput) => void
  ): void;
  rebootDBInstance(
    args: RebootDBInstanceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RebootDBInstanceCommandOutput>;
  rebootDBInstance(
    args: RebootDBInstanceCommandInput,
    cb: (err: any, data?: RebootDBInstanceCommandOutput) => void
  ): void;
  rebootDBInstance(
    args: RebootDBInstanceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RebootDBInstanceCommandOutput) => void
  ): void;
  rebootDBShardGroup(
    args: RebootDBShardGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RebootDBShardGroupCommandOutput>;
  rebootDBShardGroup(
    args: RebootDBShardGroupCommandInput,
    cb: (err: any, data?: RebootDBShardGroupCommandOutput) => void
  ): void;
  rebootDBShardGroup(
    args: RebootDBShardGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RebootDBShardGroupCommandOutput) => void
  ): void;
  registerDBProxyTargets(
    args: RegisterDBProxyTargetsCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RegisterDBProxyTargetsCommandOutput>;
  registerDBProxyTargets(
    args: RegisterDBProxyTargetsCommandInput,
    cb: (err: any, data?: RegisterDBProxyTargetsCommandOutput) => void
  ): void;
  registerDBProxyTargets(
    args: RegisterDBProxyTargetsCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RegisterDBProxyTargetsCommandOutput) => void
  ): void;
  removeFromGlobalCluster(): Promise<RemoveFromGlobalClusterCommandOutput>;
  removeFromGlobalCluster(
    args: RemoveFromGlobalClusterCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RemoveFromGlobalClusterCommandOutput>;
  removeFromGlobalCluster(
    args: RemoveFromGlobalClusterCommandInput,
    cb: (err: any, data?: RemoveFromGlobalClusterCommandOutput) => void
  ): void;
  removeFromGlobalCluster(
    args: RemoveFromGlobalClusterCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RemoveFromGlobalClusterCommandOutput) => void
  ): void;
  removeRoleFromDBCluster(
    args: RemoveRoleFromDBClusterCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RemoveRoleFromDBClusterCommandOutput>;
  removeRoleFromDBCluster(
    args: RemoveRoleFromDBClusterCommandInput,
    cb: (err: any, data?: RemoveRoleFromDBClusterCommandOutput) => void
  ): void;
  removeRoleFromDBCluster(
    args: RemoveRoleFromDBClusterCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RemoveRoleFromDBClusterCommandOutput) => void
  ): void;
  removeRoleFromDBInstance(
    args: RemoveRoleFromDBInstanceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RemoveRoleFromDBInstanceCommandOutput>;
  removeRoleFromDBInstance(
    args: RemoveRoleFromDBInstanceCommandInput,
    cb: (err: any, data?: RemoveRoleFromDBInstanceCommandOutput) => void
  ): void;
  removeRoleFromDBInstance(
    args: RemoveRoleFromDBInstanceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RemoveRoleFromDBInstanceCommandOutput) => void
  ): void;
  removeSourceIdentifierFromSubscription(
    args: RemoveSourceIdentifierFromSubscriptionCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RemoveSourceIdentifierFromSubscriptionCommandOutput>;
  removeSourceIdentifierFromSubscription(
    args: RemoveSourceIdentifierFromSubscriptionCommandInput,
    cb: (
      err: any,
      data?: RemoveSourceIdentifierFromSubscriptionCommandOutput
    ) => void
  ): void;
  removeSourceIdentifierFromSubscription(
    args: RemoveSourceIdentifierFromSubscriptionCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: RemoveSourceIdentifierFromSubscriptionCommandOutput
    ) => void
  ): void;
  removeTagsFromResource(
    args: RemoveTagsFromResourceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RemoveTagsFromResourceCommandOutput>;
  removeTagsFromResource(
    args: RemoveTagsFromResourceCommandInput,
    cb: (err: any, data?: RemoveTagsFromResourceCommandOutput) => void
  ): void;
  removeTagsFromResource(
    args: RemoveTagsFromResourceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RemoveTagsFromResourceCommandOutput) => void
  ): void;
  resetDBClusterParameterGroup(
    args: ResetDBClusterParameterGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ResetDBClusterParameterGroupCommandOutput>;
  resetDBClusterParameterGroup(
    args: ResetDBClusterParameterGroupCommandInput,
    cb: (err: any, data?: ResetDBClusterParameterGroupCommandOutput) => void
  ): void;
  resetDBClusterParameterGroup(
    args: ResetDBClusterParameterGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ResetDBClusterParameterGroupCommandOutput) => void
  ): void;
  resetDBParameterGroup(
    args: ResetDBParameterGroupCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<ResetDBParameterGroupCommandOutput>;
  resetDBParameterGroup(
    args: ResetDBParameterGroupCommandInput,
    cb: (err: any, data?: ResetDBParameterGroupCommandOutput) => void
  ): void;
  resetDBParameterGroup(
    args: ResetDBParameterGroupCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: ResetDBParameterGroupCommandOutput) => void
  ): void;
  restoreDBClusterFromS3(
    args: RestoreDBClusterFromS3CommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RestoreDBClusterFromS3CommandOutput>;
  restoreDBClusterFromS3(
    args: RestoreDBClusterFromS3CommandInput,
    cb: (err: any, data?: RestoreDBClusterFromS3CommandOutput) => void
  ): void;
  restoreDBClusterFromS3(
    args: RestoreDBClusterFromS3CommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RestoreDBClusterFromS3CommandOutput) => void
  ): void;
  restoreDBClusterFromSnapshot(
    args: RestoreDBClusterFromSnapshotCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RestoreDBClusterFromSnapshotCommandOutput>;
  restoreDBClusterFromSnapshot(
    args: RestoreDBClusterFromSnapshotCommandInput,
    cb: (err: any, data?: RestoreDBClusterFromSnapshotCommandOutput) => void
  ): void;
  restoreDBClusterFromSnapshot(
    args: RestoreDBClusterFromSnapshotCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RestoreDBClusterFromSnapshotCommandOutput) => void
  ): void;
  restoreDBClusterToPointInTime(
    args: RestoreDBClusterToPointInTimeCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RestoreDBClusterToPointInTimeCommandOutput>;
  restoreDBClusterToPointInTime(
    args: RestoreDBClusterToPointInTimeCommandInput,
    cb: (err: any, data?: RestoreDBClusterToPointInTimeCommandOutput) => void
  ): void;
  restoreDBClusterToPointInTime(
    args: RestoreDBClusterToPointInTimeCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RestoreDBClusterToPointInTimeCommandOutput) => void
  ): void;
  restoreDBInstanceFromDBSnapshot(
    args: RestoreDBInstanceFromDBSnapshotCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RestoreDBInstanceFromDBSnapshotCommandOutput>;
  restoreDBInstanceFromDBSnapshot(
    args: RestoreDBInstanceFromDBSnapshotCommandInput,
    cb: (err: any, data?: RestoreDBInstanceFromDBSnapshotCommandOutput) => void
  ): void;
  restoreDBInstanceFromDBSnapshot(
    args: RestoreDBInstanceFromDBSnapshotCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RestoreDBInstanceFromDBSnapshotCommandOutput) => void
  ): void;
  restoreDBInstanceFromS3(
    args: RestoreDBInstanceFromS3CommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RestoreDBInstanceFromS3CommandOutput>;
  restoreDBInstanceFromS3(
    args: RestoreDBInstanceFromS3CommandInput,
    cb: (err: any, data?: RestoreDBInstanceFromS3CommandOutput) => void
  ): void;
  restoreDBInstanceFromS3(
    args: RestoreDBInstanceFromS3CommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RestoreDBInstanceFromS3CommandOutput) => void
  ): void;
  restoreDBInstanceToPointInTime(
    args: RestoreDBInstanceToPointInTimeCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RestoreDBInstanceToPointInTimeCommandOutput>;
  restoreDBInstanceToPointInTime(
    args: RestoreDBInstanceToPointInTimeCommandInput,
    cb: (err: any, data?: RestoreDBInstanceToPointInTimeCommandOutput) => void
  ): void;
  restoreDBInstanceToPointInTime(
    args: RestoreDBInstanceToPointInTimeCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RestoreDBInstanceToPointInTimeCommandOutput) => void
  ): void;
  revokeDBSecurityGroupIngress(
    args: RevokeDBSecurityGroupIngressCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<RevokeDBSecurityGroupIngressCommandOutput>;
  revokeDBSecurityGroupIngress(
    args: RevokeDBSecurityGroupIngressCommandInput,
    cb: (err: any, data?: RevokeDBSecurityGroupIngressCommandOutput) => void
  ): void;
  revokeDBSecurityGroupIngress(
    args: RevokeDBSecurityGroupIngressCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: RevokeDBSecurityGroupIngressCommandOutput) => void
  ): void;
  startActivityStream(
    args: StartActivityStreamCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StartActivityStreamCommandOutput>;
  startActivityStream(
    args: StartActivityStreamCommandInput,
    cb: (err: any, data?: StartActivityStreamCommandOutput) => void
  ): void;
  startActivityStream(
    args: StartActivityStreamCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StartActivityStreamCommandOutput) => void
  ): void;
  startDBCluster(
    args: StartDBClusterCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StartDBClusterCommandOutput>;
  startDBCluster(
    args: StartDBClusterCommandInput,
    cb: (err: any, data?: StartDBClusterCommandOutput) => void
  ): void;
  startDBCluster(
    args: StartDBClusterCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StartDBClusterCommandOutput) => void
  ): void;
  startDBInstance(
    args: StartDBInstanceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StartDBInstanceCommandOutput>;
  startDBInstance(
    args: StartDBInstanceCommandInput,
    cb: (err: any, data?: StartDBInstanceCommandOutput) => void
  ): void;
  startDBInstance(
    args: StartDBInstanceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StartDBInstanceCommandOutput) => void
  ): void;
  startDBInstanceAutomatedBackupsReplication(
    args: StartDBInstanceAutomatedBackupsReplicationCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StartDBInstanceAutomatedBackupsReplicationCommandOutput>;
  startDBInstanceAutomatedBackupsReplication(
    args: StartDBInstanceAutomatedBackupsReplicationCommandInput,
    cb: (
      err: any,
      data?: StartDBInstanceAutomatedBackupsReplicationCommandOutput
    ) => void
  ): void;
  startDBInstanceAutomatedBackupsReplication(
    args: StartDBInstanceAutomatedBackupsReplicationCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: StartDBInstanceAutomatedBackupsReplicationCommandOutput
    ) => void
  ): void;
  startExportTask(
    args: StartExportTaskCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StartExportTaskCommandOutput>;
  startExportTask(
    args: StartExportTaskCommandInput,
    cb: (err: any, data?: StartExportTaskCommandOutput) => void
  ): void;
  startExportTask(
    args: StartExportTaskCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StartExportTaskCommandOutput) => void
  ): void;
  stopActivityStream(
    args: StopActivityStreamCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StopActivityStreamCommandOutput>;
  stopActivityStream(
    args: StopActivityStreamCommandInput,
    cb: (err: any, data?: StopActivityStreamCommandOutput) => void
  ): void;
  stopActivityStream(
    args: StopActivityStreamCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StopActivityStreamCommandOutput) => void
  ): void;
  stopDBCluster(
    args: StopDBClusterCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StopDBClusterCommandOutput>;
  stopDBCluster(
    args: StopDBClusterCommandInput,
    cb: (err: any, data?: StopDBClusterCommandOutput) => void
  ): void;
  stopDBCluster(
    args: StopDBClusterCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StopDBClusterCommandOutput) => void
  ): void;
  stopDBInstance(
    args: StopDBInstanceCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StopDBInstanceCommandOutput>;
  stopDBInstance(
    args: StopDBInstanceCommandInput,
    cb: (err: any, data?: StopDBInstanceCommandOutput) => void
  ): void;
  stopDBInstance(
    args: StopDBInstanceCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: StopDBInstanceCommandOutput) => void
  ): void;
  stopDBInstanceAutomatedBackupsReplication(
    args: StopDBInstanceAutomatedBackupsReplicationCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<StopDBInstanceAutomatedBackupsReplicationCommandOutput>;
  stopDBInstanceAutomatedBackupsReplication(
    args: StopDBInstanceAutomatedBackupsReplicationCommandInput,
    cb: (
      err: any,
      data?: StopDBInstanceAutomatedBackupsReplicationCommandOutput
    ) => void
  ): void;
  stopDBInstanceAutomatedBackupsReplication(
    args: StopDBInstanceAutomatedBackupsReplicationCommandInput,
    options: __HttpHandlerOptions,
    cb: (
      err: any,
      data?: StopDBInstanceAutomatedBackupsReplicationCommandOutput
    ) => void
  ): void;
  switchoverBlueGreenDeployment(
    args: SwitchoverBlueGreenDeploymentCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<SwitchoverBlueGreenDeploymentCommandOutput>;
  switchoverBlueGreenDeployment(
    args: SwitchoverBlueGreenDeploymentCommandInput,
    cb: (err: any, data?: SwitchoverBlueGreenDeploymentCommandOutput) => void
  ): void;
  switchoverBlueGreenDeployment(
    args: SwitchoverBlueGreenDeploymentCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: SwitchoverBlueGreenDeploymentCommandOutput) => void
  ): void;
  switchoverGlobalCluster(
    args: SwitchoverGlobalClusterCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<SwitchoverGlobalClusterCommandOutput>;
  switchoverGlobalCluster(
    args: SwitchoverGlobalClusterCommandInput,
    cb: (err: any, data?: SwitchoverGlobalClusterCommandOutput) => void
  ): void;
  switchoverGlobalCluster(
    args: SwitchoverGlobalClusterCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: SwitchoverGlobalClusterCommandOutput) => void
  ): void;
  switchoverReadReplica(
    args: SwitchoverReadReplicaCommandInput,
    options?: __HttpHandlerOptions
  ): Promise<SwitchoverReadReplicaCommandOutput>;
  switchoverReadReplica(
    args: SwitchoverReadReplicaCommandInput,
    cb: (err: any, data?: SwitchoverReadReplicaCommandOutput) => void
  ): void;
  switchoverReadReplica(
    args: SwitchoverReadReplicaCommandInput,
    options: __HttpHandlerOptions,
    cb: (err: any, data?: SwitchoverReadReplicaCommandOutput) => void
  ): void;
}
export declare class RDS extends RDSClient implements RDS {}
