import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { DescribeDBMajorEngineVersionsRequest, DescribeDBMajorEngineVersionsResponse } from "../models/models_1";
import { RDSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../RDSClient";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DescribeDBMajorEngineVersionsCommand}.
 */
export interface DescribeDBMajorEngineVersionsCommandInput extends DescribeDBMajorEngineVersionsRequest {
}
/**
 * @public
 *
 * The output of {@link DescribeDBMajorEngineVersionsCommand}.
 */
export interface DescribeDBMajorEngineVersionsCommandOutput extends DescribeDBMajorEngineVersionsResponse, __MetadataBearer {
}
declare const DescribeDBMajorEngineVersionsCommand_base: {
    new (input: DescribeDBMajorEngineVersionsCommandInput): import("@smithy/smithy-client").CommandImpl<DescribeDBMajorEngineVersionsCommandInput, DescribeDBMajorEngineVersionsCommandOutput, RDSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (...[input]: [] | [DescribeDBMajorEngineVersionsCommandInput]): import("@smithy/smithy-client").CommandImpl<DescribeDBMajorEngineVersionsCommandInput, DescribeDBMajorEngineVersionsCommandOutput, RDSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Describes the properties of specific major versions of DB engines.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { RDSClient, DescribeDBMajorEngineVersionsCommand } from "@aws-sdk/client-rds"; // ES Modules import
 * // const { RDSClient, DescribeDBMajorEngineVersionsCommand } = require("@aws-sdk/client-rds"); // CommonJS import
 * const client = new RDSClient(config);
 * const input = { // DescribeDBMajorEngineVersionsRequest
 *   Engine: "STRING_VALUE",
 *   MajorEngineVersion: "STRING_VALUE",
 *   Marker: "STRING_VALUE",
 *   MaxRecords: Number("int"),
 * };
 * const command = new DescribeDBMajorEngineVersionsCommand(input);
 * const response = await client.send(command);
 * // { // DescribeDBMajorEngineVersionsResponse
 * //   DBMajorEngineVersions: [ // DBMajorEngineVersionsList
 * //     { // DBMajorEngineVersion
 * //       Engine: "STRING_VALUE",
 * //       MajorEngineVersion: "STRING_VALUE",
 * //       SupportedEngineLifecycles: [ // SupportedEngineLifecycleList
 * //         { // SupportedEngineLifecycle
 * //           LifecycleSupportName: "open-source-rds-standard-support" || "open-source-rds-extended-support", // required
 * //           LifecycleSupportStartDate: new Date("TIMESTAMP"), // required
 * //           LifecycleSupportEndDate: new Date("TIMESTAMP"), // required
 * //         },
 * //       ],
 * //     },
 * //   ],
 * //   Marker: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param DescribeDBMajorEngineVersionsCommandInput - {@link DescribeDBMajorEngineVersionsCommandInput}
 * @returns {@link DescribeDBMajorEngineVersionsCommandOutput}
 * @see {@link DescribeDBMajorEngineVersionsCommandInput} for command's `input` shape.
 * @see {@link DescribeDBMajorEngineVersionsCommandOutput} for command's `response` shape.
 * @see {@link RDSClientResolvedConfig | config} for RDSClient's `config` shape.
 *
 * @throws {@link RDSServiceException}
 * <p>Base exception class for all service exceptions from RDS service.</p>
 *
 *
 * @public
 */
export declare class DescribeDBMajorEngineVersionsCommand extends DescribeDBMajorEngineVersionsCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DescribeDBMajorEngineVersionsRequest;
            output: DescribeDBMajorEngineVersionsResponse;
        };
        sdk: {
            input: DescribeDBMajorEngineVersionsCommandInput;
            output: DescribeDBMajorEngineVersionsCommandOutput;
        };
    };
}
