import { parseXmlBody as parseBody, parseXmlErrorBody as parseErrorBody } from "@aws-sdk/core";
import { HttpRequest as __HttpRequest } from "@smithy/protocol-http";
import { collectBody, decorateServiceException as __decorateServiceException, expectNonNull as __expectNonNull, expectString as __expectString, extendedEncodeURIComponent as __extendedEncodeURIComponent, getArrayIfSingleItem as __getArrayIfSingleItem, parseBoolean as __parseBoolean, parseRfc3339DateTimeWithOffset as __parseRfc3339DateTimeWithOffset, serializeDateTime as __serializeDateTime, serializeFloat as __serializeFloat, strictParseFloat as __strictParseFloat, strictParseInt32 as __strictParseInt32, strictParseLong as __strictParseLong, withBaseException, } from "@smithy/smithy-client";
import { AuthorizationAlreadyExistsFault, AuthorizationNotFoundFault, AuthorizationQuotaExceededFault, BackupPolicyNotFoundFault, BlueGreenDeploymentAlreadyExistsFault, BlueGreenDeploymentNotFoundFault, CertificateNotFoundFault, CreateCustomDBEngineVersionFault, CustomAvailabilityZoneNotFoundFault, CustomDBEngineVersionAlreadyExistsFault, CustomDBEngineVersionNotFoundFault, CustomDBEngineVersionQuotaExceededFault, DBClusterAlreadyExistsFault, DBClusterAutomatedBackupNotFoundFault, DBClusterAutomatedBackupQuotaExceededFault, DBClusterEndpointAlreadyExistsFault, DBClusterEndpointNotFoundFault, DBClusterEndpointQuotaExceededFault, DBClusterNotFoundFault, DBClusterParameterGroupNotFoundFault, DBClusterQuotaExceededFault, DBClusterRoleAlreadyExistsFault, DBClusterRoleQuotaExceededFault, DBClusterSnapshotAlreadyExistsFault, DBClusterSnapshotNotFoundFault, DBInstanceAlreadyExistsFault, DBInstanceAutomatedBackupNotFoundFault, DBInstanceAutomatedBackupQuotaExceededFault, DBInstanceNotFoundFault, DBInstanceRoleAlreadyExistsFault, DBInstanceRoleQuotaExceededFault, DBParameterGroupAlreadyExistsFault, DBParameterGroupNotFoundFault, DBParameterGroupQuotaExceededFault, DBProxyAlreadyExistsFault, DBProxyEndpointAlreadyExistsFault, DBProxyEndpointNotFoundFault, DBProxyEndpointQuotaExceededFault, DBProxyNotFoundFault, DBProxyQuotaExceededFault, DBProxyTargetGroupNotFoundFault, DBSecurityGroupAlreadyExistsFault, DBSecurityGroupNotFoundFault, DBSecurityGroupNotSupportedFault, DBSecurityGroupQuotaExceededFault, DBShardGroupAlreadyExistsFault, DBShardGroupNotFoundFault, DBSnapshotAlreadyExistsFault, DBSnapshotNotFoundFault, DBSnapshotTenantDatabaseNotFoundFault, DBSubnetGroupAlreadyExistsFault, DBSubnetGroupDoesNotCoverEnoughAZs, DBSubnetGroupNotAllowedFault, DBSubnetGroupNotFoundFault, DBSubnetGroupQuotaExceededFault, DBSubnetQuotaExceededFault, DomainNotFoundFault, Ec2ImagePropertiesNotSupportedFault, EventSubscriptionQuotaExceededFault, ExportTaskNotFoundFault, GlobalClusterAlreadyExistsFault, GlobalClusterNotFoundFault, GlobalClusterQuotaExceededFault, InstanceQuotaExceededFault, InsufficientDBInstanceCapacityFault, InsufficientStorageClusterCapacityFault, IntegrationAlreadyExistsFault, IntegrationConflictOperationFault, IntegrationNotFoundFault, IntegrationQuotaExceededFault, InvalidBlueGreenDeploymentStateFault, InvalidCustomDBEngineVersionStateFault, InvalidDBClusterAutomatedBackupStateFault, InvalidDBClusterEndpointStateFault, InvalidDBClusterSnapshotStateFault, InvalidDBClusterStateFault, InvalidDBInstanceAutomatedBackupStateFault, InvalidDBInstanceStateFault, InvalidDBParameterGroupStateFault, InvalidDBProxyEndpointStateFault, InvalidDBProxyStateFault, InvalidDBSecurityGroupStateFault, InvalidDBShardGroupStateFault, InvalidDBSnapshotStateFault, InvalidDBSubnetGroupFault, InvalidDBSubnetGroupStateFault, InvalidDBSubnetStateFault, InvalidEventSubscriptionStateFault, InvalidExportTaskStateFault, InvalidGlobalClusterStateFault, InvalidIntegrationStateFault, InvalidSubnet, InvalidVPCNetworkStateFault, KMSKeyNotAccessibleFault, MaxDBShardGroupLimitReached, NetworkTypeNotSupported, OptionGroupAlreadyExistsFault, OptionGroupNotFoundFault, OptionGroupQuotaExceededFault, ProvisionedIopsNotAvailableInAZFault, ResourceNotFoundFault, SnapshotQuotaExceededFault, SNSInvalidTopicFault, SNSNoAuthorizationFault, SNSTopicArnNotFoundFault, SourceClusterNotSupportedFault, SourceDatabaseNotSupportedFault, SourceNotFoundFault, StorageQuotaExceededFault, StorageTypeNotSupportedFault, SubscriptionAlreadyExistFault, SubscriptionCategoryNotFoundFault, SubscriptionNotFoundFault, TenantDatabaseAlreadyExistsFault, TenantDatabaseNotFoundFault, TenantDatabaseQuotaExceededFault, UnsupportedDBEngineVersionFault, } from "../models/models_0";
import { DBClusterBacktrackNotFoundFault, DBClusterRoleNotFoundFault, DBInstanceNotReadyFault, DBInstanceRoleNotFoundFault, DBLogFileNotFoundFault, DBProxyTargetAlreadyRegisteredFault, DBProxyTargetNotFoundFault, DBUpgradeDependencyFailureFault, ExportTaskAlreadyExistsFault, IamRoleMissingPermissionsFault, IamRoleNotFoundFault, InsufficientAvailableIPsInSubnetFault, InsufficientDBClusterCapacityFault, InvalidDBClusterCapacityFault, InvalidExportOnlyFault, InvalidExportSourceStateFault, InvalidOptionGroupStateFault, InvalidResourceStateFault, InvalidRestoreFault, InvalidS3BucketFault, PointInTimeRestoreNotEnabledFault, ReservedDBInstanceAlreadyExistsFault, ReservedDBInstanceNotFoundFault, ReservedDBInstanceQuotaExceededFault, ReservedDBInstancesOfferingNotFoundFault, SharedSnapshotQuotaExceededFault, StorageTypeNotAvailableFault, SubnetAlreadyInUse, } from "../models/models_1";
import { RDSServiceException as __BaseException } from "../models/RDSServiceException";
export const se_AddRoleToDBClusterCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AddRoleToDBClusterMessage(input, context),
        [_A]: _ARTDBC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AddRoleToDBInstanceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AddRoleToDBInstanceMessage(input, context),
        [_A]: _ARTDBI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AddSourceIdentifierToSubscriptionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AddSourceIdentifierToSubscriptionMessage(input, context),
        [_A]: _ASITS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AddTagsToResourceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AddTagsToResourceMessage(input, context),
        [_A]: _ATTR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ApplyPendingMaintenanceActionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ApplyPendingMaintenanceActionMessage(input, context),
        [_A]: _APMA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_AuthorizeDBSecurityGroupIngressCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_AuthorizeDBSecurityGroupIngressMessage(input, context),
        [_A]: _ADBSGI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_BacktrackDBClusterCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_BacktrackDBClusterMessage(input, context),
        [_A]: _BDBC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CancelExportTaskCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CancelExportTaskMessage(input, context),
        [_A]: _CET,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CopyDBClusterParameterGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CopyDBClusterParameterGroupMessage(input, context),
        [_A]: _CDBCPG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CopyDBClusterSnapshotCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CopyDBClusterSnapshotMessage(input, context),
        [_A]: _CDBCS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CopyDBParameterGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CopyDBParameterGroupMessage(input, context),
        [_A]: _CDBPG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CopyDBSnapshotCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CopyDBSnapshotMessage(input, context),
        [_A]: _CDBS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CopyOptionGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CopyOptionGroupMessage(input, context),
        [_A]: _COG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateBlueGreenDeploymentCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateBlueGreenDeploymentRequest(input, context),
        [_A]: _CBGD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateCustomDBEngineVersionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateCustomDBEngineVersionMessage(input, context),
        [_A]: _CCDBEV,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateDBClusterCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateDBClusterMessage(input, context),
        [_A]: _CDBC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateDBClusterEndpointCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateDBClusterEndpointMessage(input, context),
        [_A]: _CDBCE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateDBClusterParameterGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateDBClusterParameterGroupMessage(input, context),
        [_A]: _CDBCPGr,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateDBClusterSnapshotCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateDBClusterSnapshotMessage(input, context),
        [_A]: _CDBCSr,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateDBInstanceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateDBInstanceMessage(input, context),
        [_A]: _CDBI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateDBInstanceReadReplicaCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateDBInstanceReadReplicaMessage(input, context),
        [_A]: _CDBIRR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateDBParameterGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateDBParameterGroupMessage(input, context),
        [_A]: _CDBPGr,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateDBProxyCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateDBProxyRequest(input, context),
        [_A]: _CDBP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateDBProxyEndpointCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateDBProxyEndpointRequest(input, context),
        [_A]: _CDBPE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateDBSecurityGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateDBSecurityGroupMessage(input, context),
        [_A]: _CDBSG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateDBShardGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateDBShardGroupMessage(input, context),
        [_A]: _CDBSGr,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateDBSnapshotCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateDBSnapshotMessage(input, context),
        [_A]: _CDBSr,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateDBSubnetGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateDBSubnetGroupMessage(input, context),
        [_A]: _CDBSGre,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateEventSubscriptionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateEventSubscriptionMessage(input, context),
        [_A]: _CES,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateGlobalClusterCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateGlobalClusterMessage(input, context),
        [_A]: _CGC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateIntegrationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateIntegrationMessage(input, context),
        [_A]: _CI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateOptionGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateOptionGroupMessage(input, context),
        [_A]: _COGr,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_CreateTenantDatabaseCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_CreateTenantDatabaseMessage(input, context),
        [_A]: _CTD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteBlueGreenDeploymentCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteBlueGreenDeploymentRequest(input, context),
        [_A]: _DBGD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteCustomDBEngineVersionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteCustomDBEngineVersionMessage(input, context),
        [_A]: _DCDBEV,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteDBClusterCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteDBClusterMessage(input, context),
        [_A]: _DDBC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteDBClusterAutomatedBackupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteDBClusterAutomatedBackupMessage(input, context),
        [_A]: _DDBCAB,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteDBClusterEndpointCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteDBClusterEndpointMessage(input, context),
        [_A]: _DDBCE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteDBClusterParameterGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteDBClusterParameterGroupMessage(input, context),
        [_A]: _DDBCPG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteDBClusterSnapshotCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteDBClusterSnapshotMessage(input, context),
        [_A]: _DDBCS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteDBInstanceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteDBInstanceMessage(input, context),
        [_A]: _DDBI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteDBInstanceAutomatedBackupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteDBInstanceAutomatedBackupMessage(input, context),
        [_A]: _DDBIAB,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteDBParameterGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteDBParameterGroupMessage(input, context),
        [_A]: _DDBPG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteDBProxyCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteDBProxyRequest(input, context),
        [_A]: _DDBP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteDBProxyEndpointCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteDBProxyEndpointRequest(input, context),
        [_A]: _DDBPE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteDBSecurityGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteDBSecurityGroupMessage(input, context),
        [_A]: _DDBSG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteDBShardGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteDBShardGroupMessage(input, context),
        [_A]: _DDBSGe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteDBSnapshotCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteDBSnapshotMessage(input, context),
        [_A]: _DDBS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteDBSubnetGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteDBSubnetGroupMessage(input, context),
        [_A]: _DDBSGel,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteEventSubscriptionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteEventSubscriptionMessage(input, context),
        [_A]: _DES,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteGlobalClusterCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteGlobalClusterMessage(input, context),
        [_A]: _DGC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteIntegrationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteIntegrationMessage(input, context),
        [_A]: _DI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteOptionGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteOptionGroupMessage(input, context),
        [_A]: _DOG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeleteTenantDatabaseCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeleteTenantDatabaseMessage(input, context),
        [_A]: _DTD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DeregisterDBProxyTargetsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DeregisterDBProxyTargetsRequest(input, context),
        [_A]: _DDBPT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeAccountAttributesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeAccountAttributesMessage(input, context),
        [_A]: _DAA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeBlueGreenDeploymentsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeBlueGreenDeploymentsRequest(input, context),
        [_A]: _DBGDe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeCertificatesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeCertificatesMessage(input, context),
        [_A]: _DC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBClusterAutomatedBackupsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBClusterAutomatedBackupsMessage(input, context),
        [_A]: _DDBCABe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBClusterBacktracksCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBClusterBacktracksMessage(input, context),
        [_A]: _DDBCB,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBClusterEndpointsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBClusterEndpointsMessage(input, context),
        [_A]: _DDBCEe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBClusterParameterGroupsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBClusterParameterGroupsMessage(input, context),
        [_A]: _DDBCPGe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBClusterParametersCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBClusterParametersMessage(input, context),
        [_A]: _DDBCP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBClustersCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBClustersMessage(input, context),
        [_A]: _DDBCe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBClusterSnapshotAttributesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBClusterSnapshotAttributesMessage(input, context),
        [_A]: _DDBCSA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBClusterSnapshotsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBClusterSnapshotsMessage(input, context),
        [_A]: _DDBCSe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBEngineVersionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBEngineVersionsMessage(input, context),
        [_A]: _DDBEV,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBInstanceAutomatedBackupsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBInstanceAutomatedBackupsMessage(input, context),
        [_A]: _DDBIABe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBInstancesMessage(input, context),
        [_A]: _DDBIe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBLogFilesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBLogFilesMessage(input, context),
        [_A]: _DDBLF,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBMajorEngineVersionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBMajorEngineVersionsRequest(input, context),
        [_A]: _DDBMEV,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBParameterGroupsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBParameterGroupsMessage(input, context),
        [_A]: _DDBPGe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBParametersCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBParametersMessage(input, context),
        [_A]: _DDBPe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBProxiesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBProxiesRequest(input, context),
        [_A]: _DDBPes,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBProxyEndpointsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBProxyEndpointsRequest(input, context),
        [_A]: _DDBPEe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBProxyTargetGroupsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBProxyTargetGroupsRequest(input, context),
        [_A]: _DDBPTG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBProxyTargetsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBProxyTargetsRequest(input, context),
        [_A]: _DDBPTe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBRecommendationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBRecommendationsMessage(input, context),
        [_A]: _DDBR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBSecurityGroupsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBSecurityGroupsMessage(input, context),
        [_A]: _DDBSGes,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBShardGroupsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBShardGroupsMessage(input, context),
        [_A]: _DDBSGesc,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBSnapshotAttributesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBSnapshotAttributesMessage(input, context),
        [_A]: _DDBSA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBSnapshotsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBSnapshotsMessage(input, context),
        [_A]: _DDBSe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBSnapshotTenantDatabasesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBSnapshotTenantDatabasesMessage(input, context),
        [_A]: _DDBSTD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeDBSubnetGroupsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeDBSubnetGroupsMessage(input, context),
        [_A]: _DDBSGescr,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeEngineDefaultClusterParametersCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeEngineDefaultClusterParametersMessage(input, context),
        [_A]: _DEDCP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeEngineDefaultParametersCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeEngineDefaultParametersMessage(input, context),
        [_A]: _DEDP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeEventCategoriesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeEventCategoriesMessage(input, context),
        [_A]: _DEC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeEventsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeEventsMessage(input, context),
        [_A]: _DE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeEventSubscriptionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeEventSubscriptionsMessage(input, context),
        [_A]: _DESe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeExportTasksCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeExportTasksMessage(input, context),
        [_A]: _DET,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeGlobalClustersCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeGlobalClustersMessage(input, context),
        [_A]: _DGCe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeIntegrationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeIntegrationsMessage(input, context),
        [_A]: _DIe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeOptionGroupOptionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeOptionGroupOptionsMessage(input, context),
        [_A]: _DOGO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeOptionGroupsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeOptionGroupsMessage(input, context),
        [_A]: _DOGe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeOrderableDBInstanceOptionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeOrderableDBInstanceOptionsMessage(input, context),
        [_A]: _DODBIO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribePendingMaintenanceActionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribePendingMaintenanceActionsMessage(input, context),
        [_A]: _DPMA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeReservedDBInstancesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeReservedDBInstancesMessage(input, context),
        [_A]: _DRDBI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeReservedDBInstancesOfferingsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeReservedDBInstancesOfferingsMessage(input, context),
        [_A]: _DRDBIO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeSourceRegionsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeSourceRegionsMessage(input, context),
        [_A]: _DSR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeTenantDatabasesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeTenantDatabasesMessage(input, context),
        [_A]: _DTDe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DescribeValidDBInstanceModificationsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DescribeValidDBInstanceModificationsMessage(input, context),
        [_A]: _DVDBIM,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DisableHttpEndpointCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DisableHttpEndpointRequest(input, context),
        [_A]: _DHE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_DownloadDBLogFilePortionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_DownloadDBLogFilePortionMessage(input, context),
        [_A]: _DDBLFP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_EnableHttpEndpointCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_EnableHttpEndpointRequest(input, context),
        [_A]: _EHE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_FailoverDBClusterCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_FailoverDBClusterMessage(input, context),
        [_A]: _FDBC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_FailoverGlobalClusterCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_FailoverGlobalClusterMessage(input, context),
        [_A]: _FGC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ListTagsForResourceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ListTagsForResourceMessage(input, context),
        [_A]: _LTFR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyActivityStreamCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyActivityStreamRequest(input, context),
        [_A]: _MAS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyCertificatesCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyCertificatesMessage(input, context),
        [_A]: _MC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyCurrentDBClusterCapacityCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyCurrentDBClusterCapacityMessage(input, context),
        [_A]: _MCDBCC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyCustomDBEngineVersionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyCustomDBEngineVersionMessage(input, context),
        [_A]: _MCDBEV,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyDBClusterCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyDBClusterMessage(input, context),
        [_A]: _MDBC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyDBClusterEndpointCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyDBClusterEndpointMessage(input, context),
        [_A]: _MDBCE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyDBClusterParameterGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyDBClusterParameterGroupMessage(input, context),
        [_A]: _MDBCPG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyDBClusterSnapshotAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyDBClusterSnapshotAttributeMessage(input, context),
        [_A]: _MDBCSA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyDBInstanceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyDBInstanceMessage(input, context),
        [_A]: _MDBI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyDBParameterGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyDBParameterGroupMessage(input, context),
        [_A]: _MDBPG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyDBProxyCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyDBProxyRequest(input, context),
        [_A]: _MDBP,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyDBProxyEndpointCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyDBProxyEndpointRequest(input, context),
        [_A]: _MDBPE,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyDBProxyTargetGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyDBProxyTargetGroupRequest(input, context),
        [_A]: _MDBPTG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyDBRecommendationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyDBRecommendationMessage(input, context),
        [_A]: _MDBR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyDBShardGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyDBShardGroupMessage(input, context),
        [_A]: _MDBSG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyDBSnapshotCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyDBSnapshotMessage(input, context),
        [_A]: _MDBS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyDBSnapshotAttributeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyDBSnapshotAttributeMessage(input, context),
        [_A]: _MDBSA,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyDBSubnetGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyDBSubnetGroupMessage(input, context),
        [_A]: _MDBSGo,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyEventSubscriptionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyEventSubscriptionMessage(input, context),
        [_A]: _MES,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyGlobalClusterCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyGlobalClusterMessage(input, context),
        [_A]: _MGC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyIntegrationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyIntegrationMessage(input, context),
        [_A]: _MI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyOptionGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyOptionGroupMessage(input, context),
        [_A]: _MOG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ModifyTenantDatabaseCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ModifyTenantDatabaseMessage(input, context),
        [_A]: _MTD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PromoteReadReplicaCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_PromoteReadReplicaMessage(input, context),
        [_A]: _PRR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PromoteReadReplicaDBClusterCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_PromoteReadReplicaDBClusterMessage(input, context),
        [_A]: _PRRDBC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_PurchaseReservedDBInstancesOfferingCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_PurchaseReservedDBInstancesOfferingMessage(input, context),
        [_A]: _PRDBIO,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RebootDBClusterCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RebootDBClusterMessage(input, context),
        [_A]: _RDBC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RebootDBInstanceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RebootDBInstanceMessage(input, context),
        [_A]: _RDBI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RebootDBShardGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RebootDBShardGroupMessage(input, context),
        [_A]: _RDBSG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RegisterDBProxyTargetsCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RegisterDBProxyTargetsRequest(input, context),
        [_A]: _RDBPT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RemoveFromGlobalClusterCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RemoveFromGlobalClusterMessage(input, context),
        [_A]: _RFGC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RemoveRoleFromDBClusterCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RemoveRoleFromDBClusterMessage(input, context),
        [_A]: _RRFDBC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RemoveRoleFromDBInstanceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RemoveRoleFromDBInstanceMessage(input, context),
        [_A]: _RRFDBI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RemoveSourceIdentifierFromSubscriptionCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RemoveSourceIdentifierFromSubscriptionMessage(input, context),
        [_A]: _RSIFS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RemoveTagsFromResourceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RemoveTagsFromResourceMessage(input, context),
        [_A]: _RTFR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ResetDBClusterParameterGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ResetDBClusterParameterGroupMessage(input, context),
        [_A]: _RDBCPG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_ResetDBParameterGroupCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_ResetDBParameterGroupMessage(input, context),
        [_A]: _RDBPG,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RestoreDBClusterFromS3Command = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RestoreDBClusterFromS3Message(input, context),
        [_A]: _RDBCFS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RestoreDBClusterFromSnapshotCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RestoreDBClusterFromSnapshotMessage(input, context),
        [_A]: _RDBCFSe,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RestoreDBClusterToPointInTimeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RestoreDBClusterToPointInTimeMessage(input, context),
        [_A]: _RDBCTPIT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RestoreDBInstanceFromDBSnapshotCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RestoreDBInstanceFromDBSnapshotMessage(input, context),
        [_A]: _RDBIFDBS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RestoreDBInstanceFromS3Command = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RestoreDBInstanceFromS3Message(input, context),
        [_A]: _RDBIFS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RestoreDBInstanceToPointInTimeCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RestoreDBInstanceToPointInTimeMessage(input, context),
        [_A]: _RDBITPIT,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_RevokeDBSecurityGroupIngressCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_RevokeDBSecurityGroupIngressMessage(input, context),
        [_A]: _RDBSGI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_StartActivityStreamCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_StartActivityStreamRequest(input, context),
        [_A]: _SAS,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_StartDBClusterCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_StartDBClusterMessage(input, context),
        [_A]: _SDBC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_StartDBInstanceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_StartDBInstanceMessage(input, context),
        [_A]: _SDBI,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_StartDBInstanceAutomatedBackupsReplicationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_StartDBInstanceAutomatedBackupsReplicationMessage(input, context),
        [_A]: _SDBIABR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_StartExportTaskCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_StartExportTaskMessage(input, context),
        [_A]: _SET,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_StopActivityStreamCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_StopActivityStreamRequest(input, context),
        [_A]: _SASt,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_StopDBClusterCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_StopDBClusterMessage(input, context),
        [_A]: _SDBCt,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_StopDBInstanceCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_StopDBInstanceMessage(input, context),
        [_A]: _SDBIt,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_StopDBInstanceAutomatedBackupsReplicationCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_StopDBInstanceAutomatedBackupsReplicationMessage(input, context),
        [_A]: _SDBIABRt,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_SwitchoverBlueGreenDeploymentCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_SwitchoverBlueGreenDeploymentRequest(input, context),
        [_A]: _SBGD,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_SwitchoverGlobalClusterCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_SwitchoverGlobalClusterMessage(input, context),
        [_A]: _SGC,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const se_SwitchoverReadReplicaCommand = async (input, context) => {
    const headers = SHARED_HEADERS;
    let body;
    body = buildFormUrlencodedString({
        ...se_SwitchoverReadReplicaMessage(input, context),
        [_A]: _SRR,
        [_V]: _,
    });
    return buildHttpRpcRequest(context, headers, "/", undefined, body);
};
export const de_AddRoleToDBClusterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_AddRoleToDBInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_AddSourceIdentifierToSubscriptionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AddSourceIdentifierToSubscriptionResult(data.AddSourceIdentifierToSubscriptionResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AddTagsToResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_ApplyPendingMaintenanceActionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ApplyPendingMaintenanceActionResult(data.ApplyPendingMaintenanceActionResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_AuthorizeDBSecurityGroupIngressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AuthorizeDBSecurityGroupIngressResult(data.AuthorizeDBSecurityGroupIngressResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_BacktrackDBClusterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBClusterBacktrack(data.BacktrackDBClusterResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CancelExportTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ExportTask(data.CancelExportTaskResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CopyDBClusterParameterGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CopyDBClusterParameterGroupResult(data.CopyDBClusterParameterGroupResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CopyDBClusterSnapshotCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CopyDBClusterSnapshotResult(data.CopyDBClusterSnapshotResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CopyDBParameterGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CopyDBParameterGroupResult(data.CopyDBParameterGroupResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CopyDBSnapshotCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CopyDBSnapshotResult(data.CopyDBSnapshotResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CopyOptionGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CopyOptionGroupResult(data.CopyOptionGroupResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateBlueGreenDeploymentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateBlueGreenDeploymentResponse(data.CreateBlueGreenDeploymentResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateCustomDBEngineVersionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBEngineVersion(data.CreateCustomDBEngineVersionResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateDBClusterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateDBClusterResult(data.CreateDBClusterResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateDBClusterEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBClusterEndpoint(data.CreateDBClusterEndpointResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateDBClusterParameterGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateDBClusterParameterGroupResult(data.CreateDBClusterParameterGroupResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateDBClusterSnapshotCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateDBClusterSnapshotResult(data.CreateDBClusterSnapshotResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateDBInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateDBInstanceResult(data.CreateDBInstanceResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateDBInstanceReadReplicaCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateDBInstanceReadReplicaResult(data.CreateDBInstanceReadReplicaResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateDBParameterGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateDBParameterGroupResult(data.CreateDBParameterGroupResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateDBProxyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateDBProxyResponse(data.CreateDBProxyResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateDBProxyEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateDBProxyEndpointResponse(data.CreateDBProxyEndpointResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateDBSecurityGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateDBSecurityGroupResult(data.CreateDBSecurityGroupResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateDBShardGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBShardGroup(data.CreateDBShardGroupResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateDBSnapshotCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateDBSnapshotResult(data.CreateDBSnapshotResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateDBSubnetGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateDBSubnetGroupResult(data.CreateDBSubnetGroupResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateEventSubscriptionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateEventSubscriptionResult(data.CreateEventSubscriptionResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateGlobalClusterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateGlobalClusterResult(data.CreateGlobalClusterResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateIntegrationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_Integration(data.CreateIntegrationResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateOptionGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateOptionGroupResult(data.CreateOptionGroupResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_CreateTenantDatabaseCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CreateTenantDatabaseResult(data.CreateTenantDatabaseResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteBlueGreenDeploymentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteBlueGreenDeploymentResponse(data.DeleteBlueGreenDeploymentResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteCustomDBEngineVersionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBEngineVersion(data.DeleteCustomDBEngineVersionResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteDBClusterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteDBClusterResult(data.DeleteDBClusterResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteDBClusterAutomatedBackupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteDBClusterAutomatedBackupResult(data.DeleteDBClusterAutomatedBackupResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteDBClusterEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBClusterEndpoint(data.DeleteDBClusterEndpointResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteDBClusterParameterGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeleteDBClusterSnapshotCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteDBClusterSnapshotResult(data.DeleteDBClusterSnapshotResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteDBInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteDBInstanceResult(data.DeleteDBInstanceResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteDBInstanceAutomatedBackupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteDBInstanceAutomatedBackupResult(data.DeleteDBInstanceAutomatedBackupResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteDBParameterGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeleteDBProxyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteDBProxyResponse(data.DeleteDBProxyResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteDBProxyEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteDBProxyEndpointResponse(data.DeleteDBProxyEndpointResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteDBSecurityGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeleteDBShardGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBShardGroup(data.DeleteDBShardGroupResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteDBSnapshotCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteDBSnapshotResult(data.DeleteDBSnapshotResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteDBSubnetGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeleteEventSubscriptionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteEventSubscriptionResult(data.DeleteEventSubscriptionResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteGlobalClusterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteGlobalClusterResult(data.DeleteGlobalClusterResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteIntegrationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_Integration(data.DeleteIntegrationResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeleteOptionGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_DeleteTenantDatabaseCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeleteTenantDatabaseResult(data.DeleteTenantDatabaseResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DeregisterDBProxyTargetsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DeregisterDBProxyTargetsResponse(data.DeregisterDBProxyTargetsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeAccountAttributesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_AccountAttributesMessage(data.DescribeAccountAttributesResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeBlueGreenDeploymentsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeBlueGreenDeploymentsResponse(data.DescribeBlueGreenDeploymentsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeCertificatesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_CertificateMessage(data.DescribeCertificatesResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBClusterAutomatedBackupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBClusterAutomatedBackupMessage(data.DescribeDBClusterAutomatedBackupsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBClusterBacktracksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBClusterBacktrackMessage(data.DescribeDBClusterBacktracksResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBClusterEndpointsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBClusterEndpointMessage(data.DescribeDBClusterEndpointsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBClusterParameterGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBClusterParameterGroupsMessage(data.DescribeDBClusterParameterGroupsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBClusterParametersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBClusterParameterGroupDetails(data.DescribeDBClusterParametersResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBClustersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBClusterMessage(data.DescribeDBClustersResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBClusterSnapshotAttributesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeDBClusterSnapshotAttributesResult(data.DescribeDBClusterSnapshotAttributesResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBClusterSnapshotsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBClusterSnapshotMessage(data.DescribeDBClusterSnapshotsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBEngineVersionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBEngineVersionMessage(data.DescribeDBEngineVersionsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBInstanceAutomatedBackupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBInstanceAutomatedBackupMessage(data.DescribeDBInstanceAutomatedBackupsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBInstanceMessage(data.DescribeDBInstancesResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBLogFilesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeDBLogFilesResponse(data.DescribeDBLogFilesResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBMajorEngineVersionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeDBMajorEngineVersionsResponse(data.DescribeDBMajorEngineVersionsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBParameterGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBParameterGroupsMessage(data.DescribeDBParameterGroupsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBParametersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBParameterGroupDetails(data.DescribeDBParametersResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBProxiesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeDBProxiesResponse(data.DescribeDBProxiesResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBProxyEndpointsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeDBProxyEndpointsResponse(data.DescribeDBProxyEndpointsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBProxyTargetGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeDBProxyTargetGroupsResponse(data.DescribeDBProxyTargetGroupsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBProxyTargetsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeDBProxyTargetsResponse(data.DescribeDBProxyTargetsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBRecommendationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBRecommendationsMessage(data.DescribeDBRecommendationsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBSecurityGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBSecurityGroupMessage(data.DescribeDBSecurityGroupsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBShardGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeDBShardGroupsResponse(data.DescribeDBShardGroupsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBSnapshotAttributesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeDBSnapshotAttributesResult(data.DescribeDBSnapshotAttributesResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBSnapshotsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBSnapshotMessage(data.DescribeDBSnapshotsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBSnapshotTenantDatabasesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBSnapshotTenantDatabasesMessage(data.DescribeDBSnapshotTenantDatabasesResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeDBSubnetGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBSubnetGroupMessage(data.DescribeDBSubnetGroupsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeEngineDefaultClusterParametersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeEngineDefaultClusterParametersResult(data.DescribeEngineDefaultClusterParametersResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeEngineDefaultParametersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeEngineDefaultParametersResult(data.DescribeEngineDefaultParametersResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeEventCategoriesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EventCategoriesMessage(data.DescribeEventCategoriesResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeEventsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EventsMessage(data.DescribeEventsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeEventSubscriptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EventSubscriptionsMessage(data.DescribeEventSubscriptionsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeExportTasksCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ExportTasksMessage(data.DescribeExportTasksResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeGlobalClustersCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_GlobalClustersMessage(data.DescribeGlobalClustersResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeIntegrationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeIntegrationsResponse(data.DescribeIntegrationsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeOptionGroupOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_OptionGroupOptionsMessage(data.DescribeOptionGroupOptionsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeOptionGroupsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_OptionGroups(data.DescribeOptionGroupsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeOrderableDBInstanceOptionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_OrderableDBInstanceOptionsMessage(data.DescribeOrderableDBInstanceOptionsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribePendingMaintenanceActionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_PendingMaintenanceActionsMessage(data.DescribePendingMaintenanceActionsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeReservedDBInstancesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ReservedDBInstanceMessage(data.DescribeReservedDBInstancesResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeReservedDBInstancesOfferingsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ReservedDBInstancesOfferingMessage(data.DescribeReservedDBInstancesOfferingsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeSourceRegionsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_SourceRegionMessage(data.DescribeSourceRegionsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeTenantDatabasesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_TenantDatabasesMessage(data.DescribeTenantDatabasesResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DescribeValidDBInstanceModificationsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DescribeValidDBInstanceModificationsResult(data.DescribeValidDBInstanceModificationsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DisableHttpEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DisableHttpEndpointResponse(data.DisableHttpEndpointResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_DownloadDBLogFilePortionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DownloadDBLogFilePortionDetails(data.DownloadDBLogFilePortionResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_EnableHttpEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_EnableHttpEndpointResponse(data.EnableHttpEndpointResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_FailoverDBClusterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_FailoverDBClusterResult(data.FailoverDBClusterResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_FailoverGlobalClusterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_FailoverGlobalClusterResult(data.FailoverGlobalClusterResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ListTagsForResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_TagListMessage(data.ListTagsForResourceResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyActivityStreamCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyActivityStreamResponse(data.ModifyActivityStreamResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyCertificatesCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyCertificatesResult(data.ModifyCertificatesResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyCurrentDBClusterCapacityCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBClusterCapacityInfo(data.ModifyCurrentDBClusterCapacityResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyCustomDBEngineVersionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBEngineVersion(data.ModifyCustomDBEngineVersionResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyDBClusterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyDBClusterResult(data.ModifyDBClusterResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyDBClusterEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBClusterEndpoint(data.ModifyDBClusterEndpointResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyDBClusterParameterGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBClusterParameterGroupNameMessage(data.ModifyDBClusterParameterGroupResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyDBClusterSnapshotAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyDBClusterSnapshotAttributeResult(data.ModifyDBClusterSnapshotAttributeResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyDBInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyDBInstanceResult(data.ModifyDBInstanceResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyDBParameterGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBParameterGroupNameMessage(data.ModifyDBParameterGroupResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyDBProxyCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyDBProxyResponse(data.ModifyDBProxyResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyDBProxyEndpointCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyDBProxyEndpointResponse(data.ModifyDBProxyEndpointResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyDBProxyTargetGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyDBProxyTargetGroupResponse(data.ModifyDBProxyTargetGroupResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyDBRecommendationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBRecommendationMessage(data.ModifyDBRecommendationResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyDBShardGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBShardGroup(data.ModifyDBShardGroupResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyDBSnapshotCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyDBSnapshotResult(data.ModifyDBSnapshotResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyDBSnapshotAttributeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyDBSnapshotAttributeResult(data.ModifyDBSnapshotAttributeResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyDBSubnetGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyDBSubnetGroupResult(data.ModifyDBSubnetGroupResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyEventSubscriptionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyEventSubscriptionResult(data.ModifyEventSubscriptionResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyGlobalClusterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyGlobalClusterResult(data.ModifyGlobalClusterResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyIntegrationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_Integration(data.ModifyIntegrationResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyOptionGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyOptionGroupResult(data.ModifyOptionGroupResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ModifyTenantDatabaseCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ModifyTenantDatabaseResult(data.ModifyTenantDatabaseResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_PromoteReadReplicaCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_PromoteReadReplicaResult(data.PromoteReadReplicaResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_PromoteReadReplicaDBClusterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_PromoteReadReplicaDBClusterResult(data.PromoteReadReplicaDBClusterResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_PurchaseReservedDBInstancesOfferingCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_PurchaseReservedDBInstancesOfferingResult(data.PurchaseReservedDBInstancesOfferingResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RebootDBClusterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RebootDBClusterResult(data.RebootDBClusterResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RebootDBInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RebootDBInstanceResult(data.RebootDBInstanceResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RebootDBShardGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBShardGroup(data.RebootDBShardGroupResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RegisterDBProxyTargetsCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RegisterDBProxyTargetsResponse(data.RegisterDBProxyTargetsResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RemoveFromGlobalClusterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RemoveFromGlobalClusterResult(data.RemoveFromGlobalClusterResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RemoveRoleFromDBClusterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_RemoveRoleFromDBInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_RemoveSourceIdentifierFromSubscriptionCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RemoveSourceIdentifierFromSubscriptionResult(data.RemoveSourceIdentifierFromSubscriptionResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RemoveTagsFromResourceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    await collectBody(output.body, context);
    const response = {
        $metadata: deserializeMetadata(output),
    };
    return response;
};
export const de_ResetDBClusterParameterGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBClusterParameterGroupNameMessage(data.ResetDBClusterParameterGroupResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_ResetDBParameterGroupCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_DBParameterGroupNameMessage(data.ResetDBParameterGroupResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RestoreDBClusterFromS3Command = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RestoreDBClusterFromS3Result(data.RestoreDBClusterFromS3Result, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RestoreDBClusterFromSnapshotCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RestoreDBClusterFromSnapshotResult(data.RestoreDBClusterFromSnapshotResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RestoreDBClusterToPointInTimeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RestoreDBClusterToPointInTimeResult(data.RestoreDBClusterToPointInTimeResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RestoreDBInstanceFromDBSnapshotCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RestoreDBInstanceFromDBSnapshotResult(data.RestoreDBInstanceFromDBSnapshotResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RestoreDBInstanceFromS3Command = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RestoreDBInstanceFromS3Result(data.RestoreDBInstanceFromS3Result, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RestoreDBInstanceToPointInTimeCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RestoreDBInstanceToPointInTimeResult(data.RestoreDBInstanceToPointInTimeResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_RevokeDBSecurityGroupIngressCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_RevokeDBSecurityGroupIngressResult(data.RevokeDBSecurityGroupIngressResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_StartActivityStreamCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_StartActivityStreamResponse(data.StartActivityStreamResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_StartDBClusterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_StartDBClusterResult(data.StartDBClusterResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_StartDBInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_StartDBInstanceResult(data.StartDBInstanceResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_StartDBInstanceAutomatedBackupsReplicationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_StartDBInstanceAutomatedBackupsReplicationResult(data.StartDBInstanceAutomatedBackupsReplicationResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_StartExportTaskCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_ExportTask(data.StartExportTaskResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_StopActivityStreamCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_StopActivityStreamResponse(data.StopActivityStreamResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_StopDBClusterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_StopDBClusterResult(data.StopDBClusterResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_StopDBInstanceCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_StopDBInstanceResult(data.StopDBInstanceResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_StopDBInstanceAutomatedBackupsReplicationCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_StopDBInstanceAutomatedBackupsReplicationResult(data.StopDBInstanceAutomatedBackupsReplicationResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_SwitchoverBlueGreenDeploymentCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_SwitchoverBlueGreenDeploymentResponse(data.SwitchoverBlueGreenDeploymentResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_SwitchoverGlobalClusterCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_SwitchoverGlobalClusterResult(data.SwitchoverGlobalClusterResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
export const de_SwitchoverReadReplicaCommand = async (output, context) => {
    if (output.statusCode >= 300) {
        return de_CommandError(output, context);
    }
    const data = await parseBody(output.body, context);
    let contents = {};
    contents = de_SwitchoverReadReplicaResult(data.SwitchoverReadReplicaResult, context);
    const response = {
        $metadata: deserializeMetadata(output),
        ...contents,
    };
    return response;
};
const de_CommandError = async (output, context) => {
    const parsedOutput = {
        ...output,
        body: await parseErrorBody(output.body, context),
    };
    const errorCode = loadQueryErrorCode(output, parsedOutput.body);
    switch (errorCode) {
        case "DBClusterNotFoundFault":
        case "com.amazonaws.rds#DBClusterNotFoundFault":
            throw await de_DBClusterNotFoundFaultRes(parsedOutput, context);
        case "DBClusterRoleAlreadyExists":
        case "com.amazonaws.rds#DBClusterRoleAlreadyExistsFault":
            throw await de_DBClusterRoleAlreadyExistsFaultRes(parsedOutput, context);
        case "DBClusterRoleQuotaExceeded":
        case "com.amazonaws.rds#DBClusterRoleQuotaExceededFault":
            throw await de_DBClusterRoleQuotaExceededFaultRes(parsedOutput, context);
        case "InvalidDBClusterStateFault":
        case "com.amazonaws.rds#InvalidDBClusterStateFault":
            throw await de_InvalidDBClusterStateFaultRes(parsedOutput, context);
        case "DBInstanceNotFound":
        case "com.amazonaws.rds#DBInstanceNotFoundFault":
            throw await de_DBInstanceNotFoundFaultRes(parsedOutput, context);
        case "DBInstanceRoleAlreadyExists":
        case "com.amazonaws.rds#DBInstanceRoleAlreadyExistsFault":
            throw await de_DBInstanceRoleAlreadyExistsFaultRes(parsedOutput, context);
        case "DBInstanceRoleQuotaExceeded":
        case "com.amazonaws.rds#DBInstanceRoleQuotaExceededFault":
            throw await de_DBInstanceRoleQuotaExceededFaultRes(parsedOutput, context);
        case "InvalidDBInstanceState":
        case "com.amazonaws.rds#InvalidDBInstanceStateFault":
            throw await de_InvalidDBInstanceStateFaultRes(parsedOutput, context);
        case "SourceNotFound":
        case "com.amazonaws.rds#SourceNotFoundFault":
            throw await de_SourceNotFoundFaultRes(parsedOutput, context);
        case "SubscriptionNotFound":
        case "com.amazonaws.rds#SubscriptionNotFoundFault":
            throw await de_SubscriptionNotFoundFaultRes(parsedOutput, context);
        case "BlueGreenDeploymentNotFoundFault":
        case "com.amazonaws.rds#BlueGreenDeploymentNotFoundFault":
            throw await de_BlueGreenDeploymentNotFoundFaultRes(parsedOutput, context);
        case "DBProxyNotFoundFault":
        case "com.amazonaws.rds#DBProxyNotFoundFault":
            throw await de_DBProxyNotFoundFaultRes(parsedOutput, context);
        case "DBProxyTargetGroupNotFoundFault":
        case "com.amazonaws.rds#DBProxyTargetGroupNotFoundFault":
            throw await de_DBProxyTargetGroupNotFoundFaultRes(parsedOutput, context);
        case "DBSnapshotNotFound":
        case "com.amazonaws.rds#DBSnapshotNotFoundFault":
            throw await de_DBSnapshotNotFoundFaultRes(parsedOutput, context);
        case "DBSnapshotTenantDatabaseNotFoundFault":
        case "com.amazonaws.rds#DBSnapshotTenantDatabaseNotFoundFault":
            throw await de_DBSnapshotTenantDatabaseNotFoundFaultRes(parsedOutput, context);
        case "IntegrationNotFoundFault":
        case "com.amazonaws.rds#IntegrationNotFoundFault":
            throw await de_IntegrationNotFoundFaultRes(parsedOutput, context);
        case "TenantDatabaseNotFound":
        case "com.amazonaws.rds#TenantDatabaseNotFoundFault":
            throw await de_TenantDatabaseNotFoundFaultRes(parsedOutput, context);
        case "ResourceNotFoundFault":
        case "com.amazonaws.rds#ResourceNotFoundFault":
            throw await de_ResourceNotFoundFaultRes(parsedOutput, context);
        case "AuthorizationAlreadyExists":
        case "com.amazonaws.rds#AuthorizationAlreadyExistsFault":
            throw await de_AuthorizationAlreadyExistsFaultRes(parsedOutput, context);
        case "AuthorizationQuotaExceeded":
        case "com.amazonaws.rds#AuthorizationQuotaExceededFault":
            throw await de_AuthorizationQuotaExceededFaultRes(parsedOutput, context);
        case "DBSecurityGroupNotFound":
        case "com.amazonaws.rds#DBSecurityGroupNotFoundFault":
            throw await de_DBSecurityGroupNotFoundFaultRes(parsedOutput, context);
        case "InvalidDBSecurityGroupState":
        case "com.amazonaws.rds#InvalidDBSecurityGroupStateFault":
            throw await de_InvalidDBSecurityGroupStateFaultRes(parsedOutput, context);
        case "ExportTaskNotFound":
        case "com.amazonaws.rds#ExportTaskNotFoundFault":
            throw await de_ExportTaskNotFoundFaultRes(parsedOutput, context);
        case "InvalidExportTaskStateFault":
        case "com.amazonaws.rds#InvalidExportTaskStateFault":
            throw await de_InvalidExportTaskStateFaultRes(parsedOutput, context);
        case "DBParameterGroupAlreadyExists":
        case "com.amazonaws.rds#DBParameterGroupAlreadyExistsFault":
            throw await de_DBParameterGroupAlreadyExistsFaultRes(parsedOutput, context);
        case "DBParameterGroupNotFound":
        case "com.amazonaws.rds#DBParameterGroupNotFoundFault":
            throw await de_DBParameterGroupNotFoundFaultRes(parsedOutput, context);
        case "DBParameterGroupQuotaExceeded":
        case "com.amazonaws.rds#DBParameterGroupQuotaExceededFault":
            throw await de_DBParameterGroupQuotaExceededFaultRes(parsedOutput, context);
        case "DBClusterSnapshotAlreadyExistsFault":
        case "com.amazonaws.rds#DBClusterSnapshotAlreadyExistsFault":
            throw await de_DBClusterSnapshotAlreadyExistsFaultRes(parsedOutput, context);
        case "DBClusterSnapshotNotFoundFault":
        case "com.amazonaws.rds#DBClusterSnapshotNotFoundFault":
            throw await de_DBClusterSnapshotNotFoundFaultRes(parsedOutput, context);
        case "InvalidDBClusterSnapshotStateFault":
        case "com.amazonaws.rds#InvalidDBClusterSnapshotStateFault":
            throw await de_InvalidDBClusterSnapshotStateFaultRes(parsedOutput, context);
        case "KMSKeyNotAccessibleFault":
        case "com.amazonaws.rds#KMSKeyNotAccessibleFault":
            throw await de_KMSKeyNotAccessibleFaultRes(parsedOutput, context);
        case "SnapshotQuotaExceeded":
        case "com.amazonaws.rds#SnapshotQuotaExceededFault":
            throw await de_SnapshotQuotaExceededFaultRes(parsedOutput, context);
        case "CustomAvailabilityZoneNotFound":
        case "com.amazonaws.rds#CustomAvailabilityZoneNotFoundFault":
            throw await de_CustomAvailabilityZoneNotFoundFaultRes(parsedOutput, context);
        case "DBSnapshotAlreadyExists":
        case "com.amazonaws.rds#DBSnapshotAlreadyExistsFault":
            throw await de_DBSnapshotAlreadyExistsFaultRes(parsedOutput, context);
        case "InvalidDBSnapshotState":
        case "com.amazonaws.rds#InvalidDBSnapshotStateFault":
            throw await de_InvalidDBSnapshotStateFaultRes(parsedOutput, context);
        case "OptionGroupAlreadyExistsFault":
        case "com.amazonaws.rds#OptionGroupAlreadyExistsFault":
            throw await de_OptionGroupAlreadyExistsFaultRes(parsedOutput, context);
        case "OptionGroupNotFoundFault":
        case "com.amazonaws.rds#OptionGroupNotFoundFault":
            throw await de_OptionGroupNotFoundFaultRes(parsedOutput, context);
        case "OptionGroupQuotaExceededFault":
        case "com.amazonaws.rds#OptionGroupQuotaExceededFault":
            throw await de_OptionGroupQuotaExceededFaultRes(parsedOutput, context);
        case "BlueGreenDeploymentAlreadyExistsFault":
        case "com.amazonaws.rds#BlueGreenDeploymentAlreadyExistsFault":
            throw await de_BlueGreenDeploymentAlreadyExistsFaultRes(parsedOutput, context);
        case "DBClusterParameterGroupNotFound":
        case "com.amazonaws.rds#DBClusterParameterGroupNotFoundFault":
            throw await de_DBClusterParameterGroupNotFoundFaultRes(parsedOutput, context);
        case "DBClusterQuotaExceededFault":
        case "com.amazonaws.rds#DBClusterQuotaExceededFault":
            throw await de_DBClusterQuotaExceededFaultRes(parsedOutput, context);
        case "InstanceQuotaExceeded":
        case "com.amazonaws.rds#InstanceQuotaExceededFault":
            throw await de_InstanceQuotaExceededFaultRes(parsedOutput, context);
        case "SourceClusterNotSupportedFault":
        case "com.amazonaws.rds#SourceClusterNotSupportedFault":
            throw await de_SourceClusterNotSupportedFaultRes(parsedOutput, context);
        case "SourceDatabaseNotSupportedFault":
        case "com.amazonaws.rds#SourceDatabaseNotSupportedFault":
            throw await de_SourceDatabaseNotSupportedFaultRes(parsedOutput, context);
        case "CreateCustomDBEngineVersionFault":
        case "com.amazonaws.rds#CreateCustomDBEngineVersionFault":
            throw await de_CreateCustomDBEngineVersionFaultRes(parsedOutput, context);
        case "CustomDBEngineVersionAlreadyExistsFault":
        case "com.amazonaws.rds#CustomDBEngineVersionAlreadyExistsFault":
            throw await de_CustomDBEngineVersionAlreadyExistsFaultRes(parsedOutput, context);
        case "CustomDBEngineVersionQuotaExceededFault":
        case "com.amazonaws.rds#CustomDBEngineVersionQuotaExceededFault":
            throw await de_CustomDBEngineVersionQuotaExceededFaultRes(parsedOutput, context);
        case "Ec2ImagePropertiesNotSupportedFault":
        case "com.amazonaws.rds#Ec2ImagePropertiesNotSupportedFault":
            throw await de_Ec2ImagePropertiesNotSupportedFaultRes(parsedOutput, context);
        case "DBClusterAlreadyExistsFault":
        case "com.amazonaws.rds#DBClusterAlreadyExistsFault":
            throw await de_DBClusterAlreadyExistsFaultRes(parsedOutput, context);
        case "DBSubnetGroupDoesNotCoverEnoughAZs":
        case "com.amazonaws.rds#DBSubnetGroupDoesNotCoverEnoughAZs":
            throw await de_DBSubnetGroupDoesNotCoverEnoughAZsRes(parsedOutput, context);
        case "DBSubnetGroupNotFoundFault":
        case "com.amazonaws.rds#DBSubnetGroupNotFoundFault":
            throw await de_DBSubnetGroupNotFoundFaultRes(parsedOutput, context);
        case "DomainNotFoundFault":
        case "com.amazonaws.rds#DomainNotFoundFault":
            throw await de_DomainNotFoundFaultRes(parsedOutput, context);
        case "GlobalClusterNotFoundFault":
        case "com.amazonaws.rds#GlobalClusterNotFoundFault":
            throw await de_GlobalClusterNotFoundFaultRes(parsedOutput, context);
        case "InsufficientDBInstanceCapacity":
        case "com.amazonaws.rds#InsufficientDBInstanceCapacityFault":
            throw await de_InsufficientDBInstanceCapacityFaultRes(parsedOutput, context);
        case "InsufficientStorageClusterCapacity":
        case "com.amazonaws.rds#InsufficientStorageClusterCapacityFault":
            throw await de_InsufficientStorageClusterCapacityFaultRes(parsedOutput, context);
        case "InvalidDBSubnetGroupFault":
        case "com.amazonaws.rds#InvalidDBSubnetGroupFault":
            throw await de_InvalidDBSubnetGroupFaultRes(parsedOutput, context);
        case "InvalidDBSubnetGroupStateFault":
        case "com.amazonaws.rds#InvalidDBSubnetGroupStateFault":
            throw await de_InvalidDBSubnetGroupStateFaultRes(parsedOutput, context);
        case "InvalidGlobalClusterStateFault":
        case "com.amazonaws.rds#InvalidGlobalClusterStateFault":
            throw await de_InvalidGlobalClusterStateFaultRes(parsedOutput, context);
        case "InvalidSubnet":
        case "com.amazonaws.rds#InvalidSubnet":
            throw await de_InvalidSubnetRes(parsedOutput, context);
        case "InvalidVPCNetworkStateFault":
        case "com.amazonaws.rds#InvalidVPCNetworkStateFault":
            throw await de_InvalidVPCNetworkStateFaultRes(parsedOutput, context);
        case "StorageQuotaExceeded":
        case "com.amazonaws.rds#StorageQuotaExceededFault":
            throw await de_StorageQuotaExceededFaultRes(parsedOutput, context);
        case "DBClusterEndpointAlreadyExistsFault":
        case "com.amazonaws.rds#DBClusterEndpointAlreadyExistsFault":
            throw await de_DBClusterEndpointAlreadyExistsFaultRes(parsedOutput, context);
        case "DBClusterEndpointQuotaExceededFault":
        case "com.amazonaws.rds#DBClusterEndpointQuotaExceededFault":
            throw await de_DBClusterEndpointQuotaExceededFaultRes(parsedOutput, context);
        case "AuthorizationNotFound":
        case "com.amazonaws.rds#AuthorizationNotFoundFault":
            throw await de_AuthorizationNotFoundFaultRes(parsedOutput, context);
        case "BackupPolicyNotFoundFault":
        case "com.amazonaws.rds#BackupPolicyNotFoundFault":
            throw await de_BackupPolicyNotFoundFaultRes(parsedOutput, context);
        case "CertificateNotFound":
        case "com.amazonaws.rds#CertificateNotFoundFault":
            throw await de_CertificateNotFoundFaultRes(parsedOutput, context);
        case "DBInstanceAlreadyExists":
        case "com.amazonaws.rds#DBInstanceAlreadyExistsFault":
            throw await de_DBInstanceAlreadyExistsFaultRes(parsedOutput, context);
        case "NetworkTypeNotSupported":
        case "com.amazonaws.rds#NetworkTypeNotSupported":
            throw await de_NetworkTypeNotSupportedRes(parsedOutput, context);
        case "ProvisionedIopsNotAvailableInAZFault":
        case "com.amazonaws.rds#ProvisionedIopsNotAvailableInAZFault":
            throw await de_ProvisionedIopsNotAvailableInAZFaultRes(parsedOutput, context);
        case "StorageTypeNotSupported":
        case "com.amazonaws.rds#StorageTypeNotSupportedFault":
            throw await de_StorageTypeNotSupportedFaultRes(parsedOutput, context);
        case "TenantDatabaseQuotaExceeded":
        case "com.amazonaws.rds#TenantDatabaseQuotaExceededFault":
            throw await de_TenantDatabaseQuotaExceededFaultRes(parsedOutput, context);
        case "DBSubnetGroupNotAllowedFault":
        case "com.amazonaws.rds#DBSubnetGroupNotAllowedFault":
            throw await de_DBSubnetGroupNotAllowedFaultRes(parsedOutput, context);
        case "DBProxyAlreadyExistsFault":
        case "com.amazonaws.rds#DBProxyAlreadyExistsFault":
            throw await de_DBProxyAlreadyExistsFaultRes(parsedOutput, context);
        case "DBProxyQuotaExceededFault":
        case "com.amazonaws.rds#DBProxyQuotaExceededFault":
            throw await de_DBProxyQuotaExceededFaultRes(parsedOutput, context);
        case "DBProxyEndpointAlreadyExistsFault":
        case "com.amazonaws.rds#DBProxyEndpointAlreadyExistsFault":
            throw await de_DBProxyEndpointAlreadyExistsFaultRes(parsedOutput, context);
        case "DBProxyEndpointQuotaExceededFault":
        case "com.amazonaws.rds#DBProxyEndpointQuotaExceededFault":
            throw await de_DBProxyEndpointQuotaExceededFaultRes(parsedOutput, context);
        case "InvalidDBProxyStateFault":
        case "com.amazonaws.rds#InvalidDBProxyStateFault":
            throw await de_InvalidDBProxyStateFaultRes(parsedOutput, context);
        case "DBSecurityGroupAlreadyExists":
        case "com.amazonaws.rds#DBSecurityGroupAlreadyExistsFault":
            throw await de_DBSecurityGroupAlreadyExistsFaultRes(parsedOutput, context);
        case "DBSecurityGroupNotSupported":
        case "com.amazonaws.rds#DBSecurityGroupNotSupportedFault":
            throw await de_DBSecurityGroupNotSupportedFaultRes(parsedOutput, context);
        case "QuotaExceeded.DBSecurityGroup":
        case "com.amazonaws.rds#DBSecurityGroupQuotaExceededFault":
            throw await de_DBSecurityGroupQuotaExceededFaultRes(parsedOutput, context);
        case "DBShardGroupAlreadyExists":
        case "com.amazonaws.rds#DBShardGroupAlreadyExistsFault":
            throw await de_DBShardGroupAlreadyExistsFaultRes(parsedOutput, context);
        case "MaxDBShardGroupLimitReached":
        case "com.amazonaws.rds#MaxDBShardGroupLimitReached":
            throw await de_MaxDBShardGroupLimitReachedRes(parsedOutput, context);
        case "UnsupportedDBEngineVersion":
        case "com.amazonaws.rds#UnsupportedDBEngineVersionFault":
            throw await de_UnsupportedDBEngineVersionFaultRes(parsedOutput, context);
        case "DBSubnetGroupAlreadyExists":
        case "com.amazonaws.rds#DBSubnetGroupAlreadyExistsFault":
            throw await de_DBSubnetGroupAlreadyExistsFaultRes(parsedOutput, context);
        case "DBSubnetGroupQuotaExceeded":
        case "com.amazonaws.rds#DBSubnetGroupQuotaExceededFault":
            throw await de_DBSubnetGroupQuotaExceededFaultRes(parsedOutput, context);
        case "DBSubnetQuotaExceededFault":
        case "com.amazonaws.rds#DBSubnetQuotaExceededFault":
            throw await de_DBSubnetQuotaExceededFaultRes(parsedOutput, context);
        case "EventSubscriptionQuotaExceeded":
        case "com.amazonaws.rds#EventSubscriptionQuotaExceededFault":
            throw await de_EventSubscriptionQuotaExceededFaultRes(parsedOutput, context);
        case "SNSInvalidTopic":
        case "com.amazonaws.rds#SNSInvalidTopicFault":
            throw await de_SNSInvalidTopicFaultRes(parsedOutput, context);
        case "SNSNoAuthorization":
        case "com.amazonaws.rds#SNSNoAuthorizationFault":
            throw await de_SNSNoAuthorizationFaultRes(parsedOutput, context);
        case "SNSTopicArnNotFound":
        case "com.amazonaws.rds#SNSTopicArnNotFoundFault":
            throw await de_SNSTopicArnNotFoundFaultRes(parsedOutput, context);
        case "SubscriptionAlreadyExist":
        case "com.amazonaws.rds#SubscriptionAlreadyExistFault":
            throw await de_SubscriptionAlreadyExistFaultRes(parsedOutput, context);
        case "SubscriptionCategoryNotFound":
        case "com.amazonaws.rds#SubscriptionCategoryNotFoundFault":
            throw await de_SubscriptionCategoryNotFoundFaultRes(parsedOutput, context);
        case "GlobalClusterAlreadyExistsFault":
        case "com.amazonaws.rds#GlobalClusterAlreadyExistsFault":
            throw await de_GlobalClusterAlreadyExistsFaultRes(parsedOutput, context);
        case "GlobalClusterQuotaExceededFault":
        case "com.amazonaws.rds#GlobalClusterQuotaExceededFault":
            throw await de_GlobalClusterQuotaExceededFaultRes(parsedOutput, context);
        case "IntegrationAlreadyExistsFault":
        case "com.amazonaws.rds#IntegrationAlreadyExistsFault":
            throw await de_IntegrationAlreadyExistsFaultRes(parsedOutput, context);
        case "IntegrationConflictOperationFault":
        case "com.amazonaws.rds#IntegrationConflictOperationFault":
            throw await de_IntegrationConflictOperationFaultRes(parsedOutput, context);
        case "IntegrationQuotaExceededFault":
        case "com.amazonaws.rds#IntegrationQuotaExceededFault":
            throw await de_IntegrationQuotaExceededFaultRes(parsedOutput, context);
        case "TenantDatabaseAlreadyExists":
        case "com.amazonaws.rds#TenantDatabaseAlreadyExistsFault":
            throw await de_TenantDatabaseAlreadyExistsFaultRes(parsedOutput, context);
        case "InvalidBlueGreenDeploymentStateFault":
        case "com.amazonaws.rds#InvalidBlueGreenDeploymentStateFault":
            throw await de_InvalidBlueGreenDeploymentStateFaultRes(parsedOutput, context);
        case "CustomDBEngineVersionNotFoundFault":
        case "com.amazonaws.rds#CustomDBEngineVersionNotFoundFault":
            throw await de_CustomDBEngineVersionNotFoundFaultRes(parsedOutput, context);
        case "InvalidCustomDBEngineVersionStateFault":
        case "com.amazonaws.rds#InvalidCustomDBEngineVersionStateFault":
            throw await de_InvalidCustomDBEngineVersionStateFaultRes(parsedOutput, context);
        case "DBClusterAutomatedBackupQuotaExceededFault":
        case "com.amazonaws.rds#DBClusterAutomatedBackupQuotaExceededFault":
            throw await de_DBClusterAutomatedBackupQuotaExceededFaultRes(parsedOutput, context);
        case "DBClusterAutomatedBackupNotFoundFault":
        case "com.amazonaws.rds#DBClusterAutomatedBackupNotFoundFault":
            throw await de_DBClusterAutomatedBackupNotFoundFaultRes(parsedOutput, context);
        case "InvalidDBClusterAutomatedBackupStateFault":
        case "com.amazonaws.rds#InvalidDBClusterAutomatedBackupStateFault":
            throw await de_InvalidDBClusterAutomatedBackupStateFaultRes(parsedOutput, context);
        case "DBClusterEndpointNotFoundFault":
        case "com.amazonaws.rds#DBClusterEndpointNotFoundFault":
            throw await de_DBClusterEndpointNotFoundFaultRes(parsedOutput, context);
        case "InvalidDBClusterEndpointStateFault":
        case "com.amazonaws.rds#InvalidDBClusterEndpointStateFault":
            throw await de_InvalidDBClusterEndpointStateFaultRes(parsedOutput, context);
        case "InvalidDBParameterGroupState":
        case "com.amazonaws.rds#InvalidDBParameterGroupStateFault":
            throw await de_InvalidDBParameterGroupStateFaultRes(parsedOutput, context);
        case "DBInstanceAutomatedBackupQuotaExceeded":
        case "com.amazonaws.rds#DBInstanceAutomatedBackupQuotaExceededFault":
            throw await de_DBInstanceAutomatedBackupQuotaExceededFaultRes(parsedOutput, context);
        case "DBInstanceAutomatedBackupNotFound":
        case "com.amazonaws.rds#DBInstanceAutomatedBackupNotFoundFault":
            throw await de_DBInstanceAutomatedBackupNotFoundFaultRes(parsedOutput, context);
        case "InvalidDBInstanceAutomatedBackupState":
        case "com.amazonaws.rds#InvalidDBInstanceAutomatedBackupStateFault":
            throw await de_InvalidDBInstanceAutomatedBackupStateFaultRes(parsedOutput, context);
        case "DBProxyEndpointNotFoundFault":
        case "com.amazonaws.rds#DBProxyEndpointNotFoundFault":
            throw await de_DBProxyEndpointNotFoundFaultRes(parsedOutput, context);
        case "InvalidDBProxyEndpointStateFault":
        case "com.amazonaws.rds#InvalidDBProxyEndpointStateFault":
            throw await de_InvalidDBProxyEndpointStateFaultRes(parsedOutput, context);
        case "DBShardGroupNotFound":
        case "com.amazonaws.rds#DBShardGroupNotFoundFault":
            throw await de_DBShardGroupNotFoundFaultRes(parsedOutput, context);
        case "InvalidDBShardGroupState":
        case "com.amazonaws.rds#InvalidDBShardGroupStateFault":
            throw await de_InvalidDBShardGroupStateFaultRes(parsedOutput, context);
        case "InvalidDBSubnetStateFault":
        case "com.amazonaws.rds#InvalidDBSubnetStateFault":
            throw await de_InvalidDBSubnetStateFaultRes(parsedOutput, context);
        case "InvalidEventSubscriptionState":
        case "com.amazonaws.rds#InvalidEventSubscriptionStateFault":
            throw await de_InvalidEventSubscriptionStateFaultRes(parsedOutput, context);
        case "InvalidIntegrationStateFault":
        case "com.amazonaws.rds#InvalidIntegrationStateFault":
            throw await de_InvalidIntegrationStateFaultRes(parsedOutput, context);
        case "InvalidOptionGroupStateFault":
        case "com.amazonaws.rds#InvalidOptionGroupStateFault":
            throw await de_InvalidOptionGroupStateFaultRes(parsedOutput, context);
        case "DBProxyTargetNotFoundFault":
        case "com.amazonaws.rds#DBProxyTargetNotFoundFault":
            throw await de_DBProxyTargetNotFoundFaultRes(parsedOutput, context);
        case "DBClusterBacktrackNotFoundFault":
        case "com.amazonaws.rds#DBClusterBacktrackNotFoundFault":
            throw await de_DBClusterBacktrackNotFoundFaultRes(parsedOutput, context);
        case "DBInstanceNotReady":
        case "com.amazonaws.rds#DBInstanceNotReadyFault":
            throw await de_DBInstanceNotReadyFaultRes(parsedOutput, context);
        case "ReservedDBInstanceNotFound":
        case "com.amazonaws.rds#ReservedDBInstanceNotFoundFault":
            throw await de_ReservedDBInstanceNotFoundFaultRes(parsedOutput, context);
        case "ReservedDBInstancesOfferingNotFound":
        case "com.amazonaws.rds#ReservedDBInstancesOfferingNotFoundFault":
            throw await de_ReservedDBInstancesOfferingNotFoundFaultRes(parsedOutput, context);
        case "InvalidResourceStateFault":
        case "com.amazonaws.rds#InvalidResourceStateFault":
            throw await de_InvalidResourceStateFaultRes(parsedOutput, context);
        case "DBLogFileNotFoundFault":
        case "com.amazonaws.rds#DBLogFileNotFoundFault":
            throw await de_DBLogFileNotFoundFaultRes(parsedOutput, context);
        case "InvalidDBClusterCapacityFault":
        case "com.amazonaws.rds#InvalidDBClusterCapacityFault":
            throw await de_InvalidDBClusterCapacityFaultRes(parsedOutput, context);
        case "StorageTypeNotAvailableFault":
        case "com.amazonaws.rds#StorageTypeNotAvailableFault":
            throw await de_StorageTypeNotAvailableFaultRes(parsedOutput, context);
        case "SharedSnapshotQuotaExceeded":
        case "com.amazonaws.rds#SharedSnapshotQuotaExceededFault":
            throw await de_SharedSnapshotQuotaExceededFaultRes(parsedOutput, context);
        case "DBUpgradeDependencyFailure":
        case "com.amazonaws.rds#DBUpgradeDependencyFailureFault":
            throw await de_DBUpgradeDependencyFailureFaultRes(parsedOutput, context);
        case "SubnetAlreadyInUse":
        case "com.amazonaws.rds#SubnetAlreadyInUse":
            throw await de_SubnetAlreadyInUseRes(parsedOutput, context);
        case "ReservedDBInstanceAlreadyExists":
        case "com.amazonaws.rds#ReservedDBInstanceAlreadyExistsFault":
            throw await de_ReservedDBInstanceAlreadyExistsFaultRes(parsedOutput, context);
        case "ReservedDBInstanceQuotaExceeded":
        case "com.amazonaws.rds#ReservedDBInstanceQuotaExceededFault":
            throw await de_ReservedDBInstanceQuotaExceededFaultRes(parsedOutput, context);
        case "DBProxyTargetAlreadyRegisteredFault":
        case "com.amazonaws.rds#DBProxyTargetAlreadyRegisteredFault":
            throw await de_DBProxyTargetAlreadyRegisteredFaultRes(parsedOutput, context);
        case "InsufficientAvailableIPsInSubnetFault":
        case "com.amazonaws.rds#InsufficientAvailableIPsInSubnetFault":
            throw await de_InsufficientAvailableIPsInSubnetFaultRes(parsedOutput, context);
        case "DBClusterRoleNotFound":
        case "com.amazonaws.rds#DBClusterRoleNotFoundFault":
            throw await de_DBClusterRoleNotFoundFaultRes(parsedOutput, context);
        case "DBInstanceRoleNotFound":
        case "com.amazonaws.rds#DBInstanceRoleNotFoundFault":
            throw await de_DBInstanceRoleNotFoundFaultRes(parsedOutput, context);
        case "InvalidS3BucketFault":
        case "com.amazonaws.rds#InvalidS3BucketFault":
            throw await de_InvalidS3BucketFaultRes(parsedOutput, context);
        case "InsufficientDBClusterCapacityFault":
        case "com.amazonaws.rds#InsufficientDBClusterCapacityFault":
            throw await de_InsufficientDBClusterCapacityFaultRes(parsedOutput, context);
        case "InvalidRestoreFault":
        case "com.amazonaws.rds#InvalidRestoreFault":
            throw await de_InvalidRestoreFaultRes(parsedOutput, context);
        case "PointInTimeRestoreNotEnabled":
        case "com.amazonaws.rds#PointInTimeRestoreNotEnabledFault":
            throw await de_PointInTimeRestoreNotEnabledFaultRes(parsedOutput, context);
        case "ExportTaskAlreadyExists":
        case "com.amazonaws.rds#ExportTaskAlreadyExistsFault":
            throw await de_ExportTaskAlreadyExistsFaultRes(parsedOutput, context);
        case "IamRoleMissingPermissions":
        case "com.amazonaws.rds#IamRoleMissingPermissionsFault":
            throw await de_IamRoleMissingPermissionsFaultRes(parsedOutput, context);
        case "IamRoleNotFound":
        case "com.amazonaws.rds#IamRoleNotFoundFault":
            throw await de_IamRoleNotFoundFaultRes(parsedOutput, context);
        case "InvalidExportOnly":
        case "com.amazonaws.rds#InvalidExportOnlyFault":
            throw await de_InvalidExportOnlyFaultRes(parsedOutput, context);
        case "InvalidExportSourceState":
        case "com.amazonaws.rds#InvalidExportSourceStateFault":
            throw await de_InvalidExportSourceStateFaultRes(parsedOutput, context);
        default:
            const parsedBody = parsedOutput.body;
            return throwDefaultError({
                output,
                parsedBody: parsedBody.Error,
                errorCode,
            });
    }
};
const de_AuthorizationAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_AuthorizationAlreadyExistsFault(body.Error, context);
    const exception = new AuthorizationAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_AuthorizationNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_AuthorizationNotFoundFault(body.Error, context);
    const exception = new AuthorizationNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_AuthorizationQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_AuthorizationQuotaExceededFault(body.Error, context);
    const exception = new AuthorizationQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_BackupPolicyNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_BackupPolicyNotFoundFault(body.Error, context);
    const exception = new BackupPolicyNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_BlueGreenDeploymentAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_BlueGreenDeploymentAlreadyExistsFault(body.Error, context);
    const exception = new BlueGreenDeploymentAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_BlueGreenDeploymentNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_BlueGreenDeploymentNotFoundFault(body.Error, context);
    const exception = new BlueGreenDeploymentNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CertificateNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_CertificateNotFoundFault(body.Error, context);
    const exception = new CertificateNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CreateCustomDBEngineVersionFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_CreateCustomDBEngineVersionFault(body.Error, context);
    const exception = new CreateCustomDBEngineVersionFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CustomAvailabilityZoneNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_CustomAvailabilityZoneNotFoundFault(body.Error, context);
    const exception = new CustomAvailabilityZoneNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CustomDBEngineVersionAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_CustomDBEngineVersionAlreadyExistsFault(body.Error, context);
    const exception = new CustomDBEngineVersionAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CustomDBEngineVersionNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_CustomDBEngineVersionNotFoundFault(body.Error, context);
    const exception = new CustomDBEngineVersionNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_CustomDBEngineVersionQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_CustomDBEngineVersionQuotaExceededFault(body.Error, context);
    const exception = new CustomDBEngineVersionQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBClusterAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBClusterAlreadyExistsFault(body.Error, context);
    const exception = new DBClusterAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBClusterAutomatedBackupNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBClusterAutomatedBackupNotFoundFault(body.Error, context);
    const exception = new DBClusterAutomatedBackupNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBClusterAutomatedBackupQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBClusterAutomatedBackupQuotaExceededFault(body.Error, context);
    const exception = new DBClusterAutomatedBackupQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBClusterBacktrackNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBClusterBacktrackNotFoundFault(body.Error, context);
    const exception = new DBClusterBacktrackNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBClusterEndpointAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBClusterEndpointAlreadyExistsFault(body.Error, context);
    const exception = new DBClusterEndpointAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBClusterEndpointNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBClusterEndpointNotFoundFault(body.Error, context);
    const exception = new DBClusterEndpointNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBClusterEndpointQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBClusterEndpointQuotaExceededFault(body.Error, context);
    const exception = new DBClusterEndpointQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBClusterNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBClusterNotFoundFault(body.Error, context);
    const exception = new DBClusterNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBClusterParameterGroupNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBClusterParameterGroupNotFoundFault(body.Error, context);
    const exception = new DBClusterParameterGroupNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBClusterQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBClusterQuotaExceededFault(body.Error, context);
    const exception = new DBClusterQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBClusterRoleAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBClusterRoleAlreadyExistsFault(body.Error, context);
    const exception = new DBClusterRoleAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBClusterRoleNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBClusterRoleNotFoundFault(body.Error, context);
    const exception = new DBClusterRoleNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBClusterRoleQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBClusterRoleQuotaExceededFault(body.Error, context);
    const exception = new DBClusterRoleQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBClusterSnapshotAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBClusterSnapshotAlreadyExistsFault(body.Error, context);
    const exception = new DBClusterSnapshotAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBClusterSnapshotNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBClusterSnapshotNotFoundFault(body.Error, context);
    const exception = new DBClusterSnapshotNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBInstanceAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBInstanceAlreadyExistsFault(body.Error, context);
    const exception = new DBInstanceAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBInstanceAutomatedBackupNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBInstanceAutomatedBackupNotFoundFault(body.Error, context);
    const exception = new DBInstanceAutomatedBackupNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBInstanceAutomatedBackupQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBInstanceAutomatedBackupQuotaExceededFault(body.Error, context);
    const exception = new DBInstanceAutomatedBackupQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBInstanceNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBInstanceNotFoundFault(body.Error, context);
    const exception = new DBInstanceNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBInstanceNotReadyFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBInstanceNotReadyFault(body.Error, context);
    const exception = new DBInstanceNotReadyFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBInstanceRoleAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBInstanceRoleAlreadyExistsFault(body.Error, context);
    const exception = new DBInstanceRoleAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBInstanceRoleNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBInstanceRoleNotFoundFault(body.Error, context);
    const exception = new DBInstanceRoleNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBInstanceRoleQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBInstanceRoleQuotaExceededFault(body.Error, context);
    const exception = new DBInstanceRoleQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBLogFileNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBLogFileNotFoundFault(body.Error, context);
    const exception = new DBLogFileNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBParameterGroupAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBParameterGroupAlreadyExistsFault(body.Error, context);
    const exception = new DBParameterGroupAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBParameterGroupNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBParameterGroupNotFoundFault(body.Error, context);
    const exception = new DBParameterGroupNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBParameterGroupQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBParameterGroupQuotaExceededFault(body.Error, context);
    const exception = new DBParameterGroupQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBProxyAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBProxyAlreadyExistsFault(body.Error, context);
    const exception = new DBProxyAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBProxyEndpointAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBProxyEndpointAlreadyExistsFault(body.Error, context);
    const exception = new DBProxyEndpointAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBProxyEndpointNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBProxyEndpointNotFoundFault(body.Error, context);
    const exception = new DBProxyEndpointNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBProxyEndpointQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBProxyEndpointQuotaExceededFault(body.Error, context);
    const exception = new DBProxyEndpointQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBProxyNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBProxyNotFoundFault(body.Error, context);
    const exception = new DBProxyNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBProxyQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBProxyQuotaExceededFault(body.Error, context);
    const exception = new DBProxyQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBProxyTargetAlreadyRegisteredFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBProxyTargetAlreadyRegisteredFault(body.Error, context);
    const exception = new DBProxyTargetAlreadyRegisteredFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBProxyTargetGroupNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBProxyTargetGroupNotFoundFault(body.Error, context);
    const exception = new DBProxyTargetGroupNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBProxyTargetNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBProxyTargetNotFoundFault(body.Error, context);
    const exception = new DBProxyTargetNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBSecurityGroupAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBSecurityGroupAlreadyExistsFault(body.Error, context);
    const exception = new DBSecurityGroupAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBSecurityGroupNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBSecurityGroupNotFoundFault(body.Error, context);
    const exception = new DBSecurityGroupNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBSecurityGroupNotSupportedFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBSecurityGroupNotSupportedFault(body.Error, context);
    const exception = new DBSecurityGroupNotSupportedFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBSecurityGroupQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBSecurityGroupQuotaExceededFault(body.Error, context);
    const exception = new DBSecurityGroupQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBShardGroupAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBShardGroupAlreadyExistsFault(body.Error, context);
    const exception = new DBShardGroupAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBShardGroupNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBShardGroupNotFoundFault(body.Error, context);
    const exception = new DBShardGroupNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBSnapshotAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBSnapshotAlreadyExistsFault(body.Error, context);
    const exception = new DBSnapshotAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBSnapshotNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBSnapshotNotFoundFault(body.Error, context);
    const exception = new DBSnapshotNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBSnapshotTenantDatabaseNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBSnapshotTenantDatabaseNotFoundFault(body.Error, context);
    const exception = new DBSnapshotTenantDatabaseNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBSubnetGroupAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBSubnetGroupAlreadyExistsFault(body.Error, context);
    const exception = new DBSubnetGroupAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBSubnetGroupDoesNotCoverEnoughAZsRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBSubnetGroupDoesNotCoverEnoughAZs(body.Error, context);
    const exception = new DBSubnetGroupDoesNotCoverEnoughAZs({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBSubnetGroupNotAllowedFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBSubnetGroupNotAllowedFault(body.Error, context);
    const exception = new DBSubnetGroupNotAllowedFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBSubnetGroupNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBSubnetGroupNotFoundFault(body.Error, context);
    const exception = new DBSubnetGroupNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBSubnetGroupQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBSubnetGroupQuotaExceededFault(body.Error, context);
    const exception = new DBSubnetGroupQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBSubnetQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBSubnetQuotaExceededFault(body.Error, context);
    const exception = new DBSubnetQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DBUpgradeDependencyFailureFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DBUpgradeDependencyFailureFault(body.Error, context);
    const exception = new DBUpgradeDependencyFailureFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_DomainNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_DomainNotFoundFault(body.Error, context);
    const exception = new DomainNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_Ec2ImagePropertiesNotSupportedFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_Ec2ImagePropertiesNotSupportedFault(body.Error, context);
    const exception = new Ec2ImagePropertiesNotSupportedFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_EventSubscriptionQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_EventSubscriptionQuotaExceededFault(body.Error, context);
    const exception = new EventSubscriptionQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ExportTaskAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_ExportTaskAlreadyExistsFault(body.Error, context);
    const exception = new ExportTaskAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ExportTaskNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_ExportTaskNotFoundFault(body.Error, context);
    const exception = new ExportTaskNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_GlobalClusterAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_GlobalClusterAlreadyExistsFault(body.Error, context);
    const exception = new GlobalClusterAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_GlobalClusterNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_GlobalClusterNotFoundFault(body.Error, context);
    const exception = new GlobalClusterNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_GlobalClusterQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_GlobalClusterQuotaExceededFault(body.Error, context);
    const exception = new GlobalClusterQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_IamRoleMissingPermissionsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_IamRoleMissingPermissionsFault(body.Error, context);
    const exception = new IamRoleMissingPermissionsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_IamRoleNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_IamRoleNotFoundFault(body.Error, context);
    const exception = new IamRoleNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InstanceQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InstanceQuotaExceededFault(body.Error, context);
    const exception = new InstanceQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InsufficientAvailableIPsInSubnetFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InsufficientAvailableIPsInSubnetFault(body.Error, context);
    const exception = new InsufficientAvailableIPsInSubnetFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InsufficientDBClusterCapacityFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InsufficientDBClusterCapacityFault(body.Error, context);
    const exception = new InsufficientDBClusterCapacityFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InsufficientDBInstanceCapacityFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InsufficientDBInstanceCapacityFault(body.Error, context);
    const exception = new InsufficientDBInstanceCapacityFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InsufficientStorageClusterCapacityFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InsufficientStorageClusterCapacityFault(body.Error, context);
    const exception = new InsufficientStorageClusterCapacityFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_IntegrationAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_IntegrationAlreadyExistsFault(body.Error, context);
    const exception = new IntegrationAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_IntegrationConflictOperationFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_IntegrationConflictOperationFault(body.Error, context);
    const exception = new IntegrationConflictOperationFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_IntegrationNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_IntegrationNotFoundFault(body.Error, context);
    const exception = new IntegrationNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_IntegrationQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_IntegrationQuotaExceededFault(body.Error, context);
    const exception = new IntegrationQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidBlueGreenDeploymentStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidBlueGreenDeploymentStateFault(body.Error, context);
    const exception = new InvalidBlueGreenDeploymentStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidCustomDBEngineVersionStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidCustomDBEngineVersionStateFault(body.Error, context);
    const exception = new InvalidCustomDBEngineVersionStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDBClusterAutomatedBackupStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidDBClusterAutomatedBackupStateFault(body.Error, context);
    const exception = new InvalidDBClusterAutomatedBackupStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDBClusterCapacityFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidDBClusterCapacityFault(body.Error, context);
    const exception = new InvalidDBClusterCapacityFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDBClusterEndpointStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidDBClusterEndpointStateFault(body.Error, context);
    const exception = new InvalidDBClusterEndpointStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDBClusterSnapshotStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidDBClusterSnapshotStateFault(body.Error, context);
    const exception = new InvalidDBClusterSnapshotStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDBClusterStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidDBClusterStateFault(body.Error, context);
    const exception = new InvalidDBClusterStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDBInstanceAutomatedBackupStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidDBInstanceAutomatedBackupStateFault(body.Error, context);
    const exception = new InvalidDBInstanceAutomatedBackupStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDBInstanceStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidDBInstanceStateFault(body.Error, context);
    const exception = new InvalidDBInstanceStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDBParameterGroupStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidDBParameterGroupStateFault(body.Error, context);
    const exception = new InvalidDBParameterGroupStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDBProxyEndpointStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidDBProxyEndpointStateFault(body.Error, context);
    const exception = new InvalidDBProxyEndpointStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDBProxyStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidDBProxyStateFault(body.Error, context);
    const exception = new InvalidDBProxyStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDBSecurityGroupStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidDBSecurityGroupStateFault(body.Error, context);
    const exception = new InvalidDBSecurityGroupStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDBShardGroupStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidDBShardGroupStateFault(body.Error, context);
    const exception = new InvalidDBShardGroupStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDBSnapshotStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidDBSnapshotStateFault(body.Error, context);
    const exception = new InvalidDBSnapshotStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDBSubnetGroupFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidDBSubnetGroupFault(body.Error, context);
    const exception = new InvalidDBSubnetGroupFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDBSubnetGroupStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidDBSubnetGroupStateFault(body.Error, context);
    const exception = new InvalidDBSubnetGroupStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidDBSubnetStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidDBSubnetStateFault(body.Error, context);
    const exception = new InvalidDBSubnetStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidEventSubscriptionStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidEventSubscriptionStateFault(body.Error, context);
    const exception = new InvalidEventSubscriptionStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidExportOnlyFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidExportOnlyFault(body.Error, context);
    const exception = new InvalidExportOnlyFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidExportSourceStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidExportSourceStateFault(body.Error, context);
    const exception = new InvalidExportSourceStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidExportTaskStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidExportTaskStateFault(body.Error, context);
    const exception = new InvalidExportTaskStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidGlobalClusterStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidGlobalClusterStateFault(body.Error, context);
    const exception = new InvalidGlobalClusterStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidIntegrationStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidIntegrationStateFault(body.Error, context);
    const exception = new InvalidIntegrationStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidOptionGroupStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidOptionGroupStateFault(body.Error, context);
    const exception = new InvalidOptionGroupStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidResourceStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidResourceStateFault(body.Error, context);
    const exception = new InvalidResourceStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidRestoreFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidRestoreFault(body.Error, context);
    const exception = new InvalidRestoreFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidS3BucketFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidS3BucketFault(body.Error, context);
    const exception = new InvalidS3BucketFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidSubnetRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidSubnet(body.Error, context);
    const exception = new InvalidSubnet({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_InvalidVPCNetworkStateFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_InvalidVPCNetworkStateFault(body.Error, context);
    const exception = new InvalidVPCNetworkStateFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_KMSKeyNotAccessibleFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_KMSKeyNotAccessibleFault(body.Error, context);
    const exception = new KMSKeyNotAccessibleFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_MaxDBShardGroupLimitReachedRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_MaxDBShardGroupLimitReached(body.Error, context);
    const exception = new MaxDBShardGroupLimitReached({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_NetworkTypeNotSupportedRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_NetworkTypeNotSupported(body.Error, context);
    const exception = new NetworkTypeNotSupported({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_OptionGroupAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_OptionGroupAlreadyExistsFault(body.Error, context);
    const exception = new OptionGroupAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_OptionGroupNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_OptionGroupNotFoundFault(body.Error, context);
    const exception = new OptionGroupNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_OptionGroupQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_OptionGroupQuotaExceededFault(body.Error, context);
    const exception = new OptionGroupQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_PointInTimeRestoreNotEnabledFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_PointInTimeRestoreNotEnabledFault(body.Error, context);
    const exception = new PointInTimeRestoreNotEnabledFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ProvisionedIopsNotAvailableInAZFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_ProvisionedIopsNotAvailableInAZFault(body.Error, context);
    const exception = new ProvisionedIopsNotAvailableInAZFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ReservedDBInstanceAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_ReservedDBInstanceAlreadyExistsFault(body.Error, context);
    const exception = new ReservedDBInstanceAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ReservedDBInstanceNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_ReservedDBInstanceNotFoundFault(body.Error, context);
    const exception = new ReservedDBInstanceNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ReservedDBInstanceQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_ReservedDBInstanceQuotaExceededFault(body.Error, context);
    const exception = new ReservedDBInstanceQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ReservedDBInstancesOfferingNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_ReservedDBInstancesOfferingNotFoundFault(body.Error, context);
    const exception = new ReservedDBInstancesOfferingNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_ResourceNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_ResourceNotFoundFault(body.Error, context);
    const exception = new ResourceNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_SharedSnapshotQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_SharedSnapshotQuotaExceededFault(body.Error, context);
    const exception = new SharedSnapshotQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_SnapshotQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_SnapshotQuotaExceededFault(body.Error, context);
    const exception = new SnapshotQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_SNSInvalidTopicFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_SNSInvalidTopicFault(body.Error, context);
    const exception = new SNSInvalidTopicFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_SNSNoAuthorizationFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_SNSNoAuthorizationFault(body.Error, context);
    const exception = new SNSNoAuthorizationFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_SNSTopicArnNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_SNSTopicArnNotFoundFault(body.Error, context);
    const exception = new SNSTopicArnNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_SourceClusterNotSupportedFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_SourceClusterNotSupportedFault(body.Error, context);
    const exception = new SourceClusterNotSupportedFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_SourceDatabaseNotSupportedFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_SourceDatabaseNotSupportedFault(body.Error, context);
    const exception = new SourceDatabaseNotSupportedFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_SourceNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_SourceNotFoundFault(body.Error, context);
    const exception = new SourceNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_StorageQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_StorageQuotaExceededFault(body.Error, context);
    const exception = new StorageQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_StorageTypeNotAvailableFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_StorageTypeNotAvailableFault(body.Error, context);
    const exception = new StorageTypeNotAvailableFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_StorageTypeNotSupportedFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_StorageTypeNotSupportedFault(body.Error, context);
    const exception = new StorageTypeNotSupportedFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_SubnetAlreadyInUseRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_SubnetAlreadyInUse(body.Error, context);
    const exception = new SubnetAlreadyInUse({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_SubscriptionAlreadyExistFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_SubscriptionAlreadyExistFault(body.Error, context);
    const exception = new SubscriptionAlreadyExistFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_SubscriptionCategoryNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_SubscriptionCategoryNotFoundFault(body.Error, context);
    const exception = new SubscriptionCategoryNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_SubscriptionNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_SubscriptionNotFoundFault(body.Error, context);
    const exception = new SubscriptionNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TenantDatabaseAlreadyExistsFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_TenantDatabaseAlreadyExistsFault(body.Error, context);
    const exception = new TenantDatabaseAlreadyExistsFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TenantDatabaseNotFoundFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_TenantDatabaseNotFoundFault(body.Error, context);
    const exception = new TenantDatabaseNotFoundFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_TenantDatabaseQuotaExceededFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_TenantDatabaseQuotaExceededFault(body.Error, context);
    const exception = new TenantDatabaseQuotaExceededFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const de_UnsupportedDBEngineVersionFaultRes = async (parsedOutput, context) => {
    const body = parsedOutput.body;
    const deserialized = de_UnsupportedDBEngineVersionFault(body.Error, context);
    const exception = new UnsupportedDBEngineVersionFault({
        $metadata: deserializeMetadata(parsedOutput),
        ...deserialized,
    });
    return __decorateServiceException(exception, body);
};
const se_AddRoleToDBClusterMessage = (input, context) => {
    const entries = {};
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    if (input[_RA] != null) {
        entries[_RA] = input[_RA];
    }
    if (input[_FN] != null) {
        entries[_FN] = input[_FN];
    }
    return entries;
};
const se_AddRoleToDBInstanceMessage = (input, context) => {
    const entries = {};
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_RA] != null) {
        entries[_RA] = input[_RA];
    }
    if (input[_FN] != null) {
        entries[_FN] = input[_FN];
    }
    return entries;
};
const se_AddSourceIdentifierToSubscriptionMessage = (input, context) => {
    const entries = {};
    if (input[_SN] != null) {
        entries[_SN] = input[_SN];
    }
    if (input[_SI] != null) {
        entries[_SI] = input[_SI];
    }
    return entries;
};
const se_AddTagsToResourceMessage = (input, context) => {
    const entries = {};
    if (input[_RN] != null) {
        entries[_RN] = input[_RN];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ApplyPendingMaintenanceActionMessage = (input, context) => {
    const entries = {};
    if (input[_RI] != null) {
        entries[_RI] = input[_RI];
    }
    if (input[_AA] != null) {
        entries[_AA] = input[_AA];
    }
    if (input[_OIT] != null) {
        entries[_OIT] = input[_OIT];
    }
    return entries;
};
const se_AttributeValueList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`AttributeValue.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_AuthorizeDBSecurityGroupIngressMessage = (input, context) => {
    const entries = {};
    if (input[_DBSGN] != null) {
        entries[_DBSGN] = input[_DBSGN];
    }
    if (input[_CIDRIP] != null) {
        entries[_CIDRIP] = input[_CIDRIP];
    }
    if (input[_ECSGN] != null) {
        entries[_ECSGN] = input[_ECSGN];
    }
    if (input[_ECSGI] != null) {
        entries[_ECSGI] = input[_ECSGI];
    }
    if (input[_ECSGOI] != null) {
        entries[_ECSGOI] = input[_ECSGOI];
    }
    return entries;
};
const se_AvailabilityZones = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`AvailabilityZone.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_BacktrackDBClusterMessage = (input, context) => {
    const entries = {};
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    if (input[_BT] != null) {
        entries[_BT] = __serializeDateTime(input[_BT]);
    }
    if (input[_F] != null) {
        entries[_F] = input[_F];
    }
    if (input[_UETOPITU] != null) {
        entries[_UETOPITU] = input[_UETOPITU];
    }
    return entries;
};
const se_CancelExportTaskMessage = (input, context) => {
    const entries = {};
    if (input[_ETI] != null) {
        entries[_ETI] = input[_ETI];
    }
    return entries;
};
const se_CloudwatchLogsExportConfiguration = (input, context) => {
    const entries = {};
    if (input[_ELT] != null) {
        const memberEntries = se_LogTypeList(input[_ELT], context);
        if (input[_ELT]?.length === 0) {
            entries.EnableLogTypes = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `EnableLogTypes.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DLT] != null) {
        const memberEntries = se_LogTypeList(input[_DLT], context);
        if (input[_DLT]?.length === 0) {
            entries.DisableLogTypes = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DisableLogTypes.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ConnectionPoolConfiguration = (input, context) => {
    const entries = {};
    if (input[_MCP] != null) {
        entries[_MCP] = input[_MCP];
    }
    if (input[_MICP] != null) {
        entries[_MICP] = input[_MICP];
    }
    if (input[_CBT] != null) {
        entries[_CBT] = input[_CBT];
    }
    if (input[_SPF] != null) {
        const memberEntries = se_StringList(input[_SPF], context);
        if (input[_SPF]?.length === 0) {
            entries.SessionPinningFilters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SessionPinningFilters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_IQ] != null) {
        entries[_IQ] = input[_IQ];
    }
    return entries;
};
const se_CopyDBClusterParameterGroupMessage = (input, context) => {
    const entries = {};
    if (input[_SDBCPGI] != null) {
        entries[_SDBCPGI] = input[_SDBCPGI];
    }
    if (input[_TDBCPGI] != null) {
        entries[_TDBCPGI] = input[_TDBCPGI];
    }
    if (input[_TDBCPGD] != null) {
        entries[_TDBCPGD] = input[_TDBCPGD];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CopyDBClusterSnapshotMessage = (input, context) => {
    const entries = {};
    if (input[_SDBCSI] != null) {
        entries[_SDBCSI] = input[_SDBCSI];
    }
    if (input[_TDBCSI] != null) {
        entries[_TDBCSI] = input[_TDBCSI];
    }
    if (input[_KKI] != null) {
        entries[_KKI] = input[_KKI];
    }
    if (input[_PSU] != null) {
        entries[_PSU] = input[_PSU];
    }
    if (input[_CT] != null) {
        entries[_CT] = input[_CT];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CopyDBParameterGroupMessage = (input, context) => {
    const entries = {};
    if (input[_SDBPGI] != null) {
        entries[_SDBPGI] = input[_SDBPGI];
    }
    if (input[_TDBPGI] != null) {
        entries[_TDBPGI] = input[_TDBPGI];
    }
    if (input[_TDBPGD] != null) {
        entries[_TDBPGD] = input[_TDBPGD];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CopyDBSnapshotMessage = (input, context) => {
    const entries = {};
    if (input[_SDBSI] != null) {
        entries[_SDBSI] = input[_SDBSI];
    }
    if (input[_TDBSI] != null) {
        entries[_TDBSI] = input[_TDBSI];
    }
    if (input[_KKI] != null) {
        entries[_KKI] = input[_KKI];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_CT] != null) {
        entries[_CT] = input[_CT];
    }
    if (input[_PSU] != null) {
        entries[_PSU] = input[_PSU];
    }
    if (input[_OGN] != null) {
        entries[_OGN] = input[_OGN];
    }
    if (input[_TCAZ] != null) {
        entries[_TCAZ] = input[_TCAZ];
    }
    if (input[_COG] != null) {
        entries[_COG] = input[_COG];
    }
    if (input[_SAZ] != null) {
        entries[_SAZ] = input[_SAZ];
    }
    if (input[_ST] != null) {
        entries[_ST] = input[_ST];
    }
    return entries;
};
const se_CopyOptionGroupMessage = (input, context) => {
    const entries = {};
    if (input[_SOGI] != null) {
        entries[_SOGI] = input[_SOGI];
    }
    if (input[_TOGI] != null) {
        entries[_TOGI] = input[_TOGI];
    }
    if (input[_TOGD] != null) {
        entries[_TOGD] = input[_TOGD];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateBlueGreenDeploymentRequest = (input, context) => {
    const entries = {};
    if (input[_BGDN] != null) {
        entries[_BGDN] = input[_BGDN];
    }
    if (input[_S] != null) {
        entries[_S] = input[_S];
    }
    if (input[_TEV] != null) {
        entries[_TEV] = input[_TEV];
    }
    if (input[_TDBPGN] != null) {
        entries[_TDBPGN] = input[_TDBPGN];
    }
    if (input[_TDBCPGN] != null) {
        entries[_TDBCPGN] = input[_TDBCPGN];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_TDBIC] != null) {
        entries[_TDBIC] = input[_TDBIC];
    }
    if (input[_UTSC] != null) {
        entries[_UTSC] = input[_UTSC];
    }
    if (input[_TI] != null) {
        entries[_TI] = input[_TI];
    }
    if (input[_TST] != null) {
        entries[_TST] = input[_TST];
    }
    if (input[_TAS] != null) {
        entries[_TAS] = input[_TAS];
    }
    if (input[_TSTa] != null) {
        entries[_TSTa] = input[_TSTa];
    }
    return entries;
};
const se_CreateCustomDBEngineVersionMessage = (input, context) => {
    const entries = {};
    if (input[_E] != null) {
        entries[_E] = input[_E];
    }
    if (input[_EV] != null) {
        entries[_EV] = input[_EV];
    }
    if (input[_DIFSBN] != null) {
        entries[_DIFSBN] = input[_DIFSBN];
    }
    if (input[_DIFSP] != null) {
        entries[_DIFSP] = input[_DIFSP];
    }
    if (input[_II] != null) {
        entries[_II] = input[_II];
    }
    if (input[_KMSKI] != null) {
        entries[_KMSKI] = input[_KMSKI];
    }
    if (input[_D] != null) {
        entries[_D] = input[_D];
    }
    if (input[_M] != null) {
        entries[_M] = input[_M];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_SCDEVI] != null) {
        entries[_SCDEVI] = input[_SCDEVI];
    }
    if (input[_UAPLI] != null) {
        entries[_UAPLI] = input[_UAPLI];
    }
    return entries;
};
const se_CreateDBClusterEndpointMessage = (input, context) => {
    const entries = {};
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    if (input[_DBCEI] != null) {
        entries[_DBCEI] = input[_DBCEI];
    }
    if (input[_ET] != null) {
        entries[_ET] = input[_ET];
    }
    if (input[_SM] != null) {
        const memberEntries = se_StringList(input[_SM], context);
        if (input[_SM]?.length === 0) {
            entries.StaticMembers = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `StaticMembers.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_EM] != null) {
        const memberEntries = se_StringList(input[_EM], context);
        if (input[_EM]?.length === 0) {
            entries.ExcludedMembers = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ExcludedMembers.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateDBClusterMessage = (input, context) => {
    const entries = {};
    if (input[_AZ] != null) {
        const memberEntries = se_AvailabilityZones(input[_AZ], context);
        if (input[_AZ]?.length === 0) {
            entries.AvailabilityZones = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AvailabilityZones.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_BRP] != null) {
        entries[_BRP] = input[_BRP];
    }
    if (input[_CSN] != null) {
        entries[_CSN] = input[_CSN];
    }
    if (input[_DN] != null) {
        entries[_DN] = input[_DN];
    }
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    if (input[_DBCPGN] != null) {
        entries[_DBCPGN] = input[_DBCPGN];
    }
    if (input[_VSGI] != null) {
        const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
        if (input[_VSGI]?.length === 0) {
            entries.VpcSecurityGroupIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcSecurityGroupIds.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DBSGNu] != null) {
        entries[_DBSGNu] = input[_DBSGNu];
    }
    if (input[_E] != null) {
        entries[_E] = input[_E];
    }
    if (input[_EV] != null) {
        entries[_EV] = input[_EV];
    }
    if (input[_P] != null) {
        entries[_P] = input[_P];
    }
    if (input[_MU] != null) {
        entries[_MU] = input[_MU];
    }
    if (input[_MUP] != null) {
        entries[_MUP] = input[_MUP];
    }
    if (input[_OGN] != null) {
        entries[_OGN] = input[_OGN];
    }
    if (input[_PBW] != null) {
        entries[_PBW] = input[_PBW];
    }
    if (input[_PMW] != null) {
        entries[_PMW] = input[_PMW];
    }
    if (input[_RSI] != null) {
        entries[_RSI] = input[_RSI];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_SE] != null) {
        entries[_SE] = input[_SE];
    }
    if (input[_KKI] != null) {
        entries[_KKI] = input[_KKI];
    }
    if (input[_PSU] != null) {
        entries[_PSU] = input[_PSU];
    }
    if (input[_EIAMDA] != null) {
        entries[_EIAMDA] = input[_EIAMDA];
    }
    if (input[_BW] != null) {
        entries[_BW] = input[_BW];
    }
    if (input[_ECLE] != null) {
        const memberEntries = se_LogTypeList(input[_ECLE], context);
        if (input[_ECLE]?.length === 0) {
            entries.EnableCloudwatchLogsExports = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `EnableCloudwatchLogsExports.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_EMn] != null) {
        entries[_EMn] = input[_EMn];
    }
    if (input[_SC] != null) {
        const memberEntries = se_ScalingConfiguration(input[_SC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ScalingConfiguration.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_RCCC] != null) {
        const memberEntries = se_RdsCustomClusterConfiguration(input[_RCCC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `RdsCustomClusterConfiguration.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DP] != null) {
        entries[_DP] = input[_DP];
    }
    if (input[_GCI] != null) {
        entries[_GCI] = input[_GCI];
    }
    if (input[_EHE] != null) {
        entries[_EHE] = input[_EHE];
    }
    if (input[_CTTS] != null) {
        entries[_CTTS] = input[_CTTS];
    }
    if (input[_Do] != null) {
        entries[_Do] = input[_Do];
    }
    if (input[_DIAMRN] != null) {
        entries[_DIAMRN] = input[_DIAMRN];
    }
    if (input[_EGWF] != null) {
        entries[_EGWF] = input[_EGWF];
    }
    if (input[_DBCIC] != null) {
        entries[_DBCIC] = input[_DBCIC];
    }
    if (input[_AS] != null) {
        entries[_AS] = input[_AS];
    }
    if (input[_STt] != null) {
        entries[_STt] = input[_STt];
    }
    if (input[_I] != null) {
        entries[_I] = input[_I];
    }
    if (input[_PA] != null) {
        entries[_PA] = input[_PA];
    }
    if (input[_AMVU] != null) {
        entries[_AMVU] = input[_AMVU];
    }
    if (input[_MIo] != null) {
        entries[_MIo] = input[_MIo];
    }
    if (input[_MRA] != null) {
        entries[_MRA] = input[_MRA];
    }
    if (input[_DIM] != null) {
        entries[_DIM] = input[_DIM];
    }
    if (input[_EPI] != null) {
        entries[_EPI] = input[_EPI];
    }
    if (input[_PIKMSKI] != null) {
        entries[_PIKMSKI] = input[_PIKMSKI];
    }
    if (input[_PIRP] != null) {
        entries[_PIRP] = input[_PIRP];
    }
    if (input[_ELD] != null) {
        entries[_ELD] = input[_ELD];
    }
    if (input[_SVSC] != null) {
        const memberEntries = se_ServerlessV2ScalingConfiguration(input[_SVSC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ServerlessV2ScalingConfiguration.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_CST] != null) {
        entries[_CST] = input[_CST];
    }
    if (input[_DBSI] != null) {
        entries[_DBSI] = input[_DBSI];
    }
    if (input[_MMUP] != null) {
        entries[_MMUP] = input[_MMUP];
    }
    if (input[_MUSKKI] != null) {
        entries[_MUSKKI] = input[_MUSKKI];
    }
    if (input[_ELWF] != null) {
        entries[_ELWF] = input[_ELWF];
    }
    if (input[_CACI] != null) {
        entries[_CACI] = input[_CACI];
    }
    if (input[_ELS] != null) {
        entries[_ELS] = input[_ELS];
    }
    return entries;
};
const se_CreateDBClusterParameterGroupMessage = (input, context) => {
    const entries = {};
    if (input[_DBCPGN] != null) {
        entries[_DBCPGN] = input[_DBCPGN];
    }
    if (input[_DBPGF] != null) {
        entries[_DBPGF] = input[_DBPGF];
    }
    if (input[_D] != null) {
        entries[_D] = input[_D];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateDBClusterSnapshotMessage = (input, context) => {
    const entries = {};
    if (input[_DBCSI] != null) {
        entries[_DBCSI] = input[_DBCSI];
    }
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateDBInstanceMessage = (input, context) => {
    const entries = {};
    if (input[_DBN] != null) {
        entries[_DBN] = input[_DBN];
    }
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_AS] != null) {
        entries[_AS] = input[_AS];
    }
    if (input[_DBIC] != null) {
        entries[_DBIC] = input[_DBIC];
    }
    if (input[_E] != null) {
        entries[_E] = input[_E];
    }
    if (input[_MU] != null) {
        entries[_MU] = input[_MU];
    }
    if (input[_MUP] != null) {
        entries[_MUP] = input[_MUP];
    }
    if (input[_DBSG] != null) {
        const memberEntries = se_DBSecurityGroupNameList(input[_DBSG], context);
        if (input[_DBSG]?.length === 0) {
            entries.DBSecurityGroups = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DBSecurityGroups.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_VSGI] != null) {
        const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
        if (input[_VSGI]?.length === 0) {
            entries.VpcSecurityGroupIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcSecurityGroupIds.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_AZv] != null) {
        entries[_AZv] = input[_AZv];
    }
    if (input[_DBSGNu] != null) {
        entries[_DBSGNu] = input[_DBSGNu];
    }
    if (input[_PMW] != null) {
        entries[_PMW] = input[_PMW];
    }
    if (input[_DBPGN] != null) {
        entries[_DBPGN] = input[_DBPGN];
    }
    if (input[_BRP] != null) {
        entries[_BRP] = input[_BRP];
    }
    if (input[_PBW] != null) {
        entries[_PBW] = input[_PBW];
    }
    if (input[_P] != null) {
        entries[_P] = input[_P];
    }
    if (input[_MAZ] != null) {
        entries[_MAZ] = input[_MAZ];
    }
    if (input[_EV] != null) {
        entries[_EV] = input[_EV];
    }
    if (input[_AMVU] != null) {
        entries[_AMVU] = input[_AMVU];
    }
    if (input[_LM] != null) {
        entries[_LM] = input[_LM];
    }
    if (input[_I] != null) {
        entries[_I] = input[_I];
    }
    if (input[_OGN] != null) {
        entries[_OGN] = input[_OGN];
    }
    if (input[_CSN] != null) {
        entries[_CSN] = input[_CSN];
    }
    if (input[_NCSN] != null) {
        entries[_NCSN] = input[_NCSN];
    }
    if (input[_PA] != null) {
        entries[_PA] = input[_PA];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    if (input[_STt] != null) {
        entries[_STt] = input[_STt];
    }
    if (input[_TCA] != null) {
        entries[_TCA] = input[_TCA];
    }
    if (input[_TCP] != null) {
        entries[_TCP] = input[_TCP];
    }
    if (input[_SE] != null) {
        entries[_SE] = input[_SE];
    }
    if (input[_KKI] != null) {
        entries[_KKI] = input[_KKI];
    }
    if (input[_Do] != null) {
        entries[_Do] = input[_Do];
    }
    if (input[_DF] != null) {
        entries[_DF] = input[_DF];
    }
    if (input[_DO] != null) {
        entries[_DO] = input[_DO];
    }
    if (input[_DASA] != null) {
        entries[_DASA] = input[_DASA];
    }
    if (input[_DDI] != null) {
        const memberEntries = se_StringList(input[_DDI], context);
        if (input[_DDI]?.length === 0) {
            entries.DomainDnsIps = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DomainDnsIps.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_CTTS] != null) {
        entries[_CTTS] = input[_CTTS];
    }
    if (input[_MIo] != null) {
        entries[_MIo] = input[_MIo];
    }
    if (input[_MRA] != null) {
        entries[_MRA] = input[_MRA];
    }
    if (input[_DIAMRN] != null) {
        entries[_DIAMRN] = input[_DIAMRN];
    }
    if (input[_PT] != null) {
        entries[_PT] = input[_PT];
    }
    if (input[_Ti] != null) {
        entries[_Ti] = input[_Ti];
    }
    if (input[_EIAMDA] != null) {
        entries[_EIAMDA] = input[_EIAMDA];
    }
    if (input[_DIM] != null) {
        entries[_DIM] = input[_DIM];
    }
    if (input[_EPI] != null) {
        entries[_EPI] = input[_EPI];
    }
    if (input[_PIKMSKI] != null) {
        entries[_PIKMSKI] = input[_PIKMSKI];
    }
    if (input[_PIRP] != null) {
        entries[_PIRP] = input[_PIRP];
    }
    if (input[_ECLE] != null) {
        const memberEntries = se_LogTypeList(input[_ECLE], context);
        if (input[_ECLE]?.length === 0) {
            entries.EnableCloudwatchLogsExports = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `EnableCloudwatchLogsExports.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_PF] != null) {
        const memberEntries = se_ProcessorFeatureList(input[_PF], context);
        if (input[_PF]?.length === 0) {
            entries.ProcessorFeatures = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ProcessorFeatures.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DP] != null) {
        entries[_DP] = input[_DP];
    }
    if (input[_MASa] != null) {
        entries[_MASa] = input[_MASa];
    }
    if (input[_ECOI] != null) {
        entries[_ECOI] = input[_ECOI];
    }
    if (input[_CIIP] != null) {
        entries[_CIIP] = input[_CIIP];
    }
    if (input[_BTa] != null) {
        entries[_BTa] = input[_BTa];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_STto] != null) {
        entries[_STto] = input[_STto];
    }
    if (input[_MMUP] != null) {
        entries[_MMUP] = input[_MMUP];
    }
    if (input[_MUSKKI] != null) {
        entries[_MUSKKI] = input[_MUSKKI];
    }
    if (input[_CACI] != null) {
        entries[_CACI] = input[_CACI];
    }
    if (input[_DBSI] != null) {
        entries[_DBSI] = input[_DBSI];
    }
    if (input[_DLV] != null) {
        entries[_DLV] = input[_DLV];
    }
    if (input[_MT] != null) {
        entries[_MT] = input[_MT];
    }
    if (input[_ELS] != null) {
        entries[_ELS] = input[_ELS];
    }
    return entries;
};
const se_CreateDBInstanceReadReplicaMessage = (input, context) => {
    const entries = {};
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_SDBII] != null) {
        entries[_SDBII] = input[_SDBII];
    }
    if (input[_DBIC] != null) {
        entries[_DBIC] = input[_DBIC];
    }
    if (input[_AZv] != null) {
        entries[_AZv] = input[_AZv];
    }
    if (input[_P] != null) {
        entries[_P] = input[_P];
    }
    if (input[_MAZ] != null) {
        entries[_MAZ] = input[_MAZ];
    }
    if (input[_AMVU] != null) {
        entries[_AMVU] = input[_AMVU];
    }
    if (input[_I] != null) {
        entries[_I] = input[_I];
    }
    if (input[_OGN] != null) {
        entries[_OGN] = input[_OGN];
    }
    if (input[_DBPGN] != null) {
        entries[_DBPGN] = input[_DBPGN];
    }
    if (input[_PA] != null) {
        entries[_PA] = input[_PA];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DBSGNu] != null) {
        entries[_DBSGNu] = input[_DBSGNu];
    }
    if (input[_VSGI] != null) {
        const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
        if (input[_VSGI]?.length === 0) {
            entries.VpcSecurityGroupIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcSecurityGroupIds.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_STt] != null) {
        entries[_STt] = input[_STt];
    }
    if (input[_CTTS] != null) {
        entries[_CTTS] = input[_CTTS];
    }
    if (input[_MIo] != null) {
        entries[_MIo] = input[_MIo];
    }
    if (input[_MRA] != null) {
        entries[_MRA] = input[_MRA];
    }
    if (input[_KKI] != null) {
        entries[_KKI] = input[_KKI];
    }
    if (input[_PSU] != null) {
        entries[_PSU] = input[_PSU];
    }
    if (input[_EIAMDA] != null) {
        entries[_EIAMDA] = input[_EIAMDA];
    }
    if (input[_DIM] != null) {
        entries[_DIM] = input[_DIM];
    }
    if (input[_EPI] != null) {
        entries[_EPI] = input[_EPI];
    }
    if (input[_PIKMSKI] != null) {
        entries[_PIKMSKI] = input[_PIKMSKI];
    }
    if (input[_PIRP] != null) {
        entries[_PIRP] = input[_PIRP];
    }
    if (input[_ECLE] != null) {
        const memberEntries = se_LogTypeList(input[_ECLE], context);
        if (input[_ECLE]?.length === 0) {
            entries.EnableCloudwatchLogsExports = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `EnableCloudwatchLogsExports.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_PF] != null) {
        const memberEntries = se_ProcessorFeatureList(input[_PF], context);
        if (input[_PF]?.length === 0) {
            entries.ProcessorFeatures = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ProcessorFeatures.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_UDPF] != null) {
        entries[_UDPF] = input[_UDPF];
    }
    if (input[_DP] != null) {
        entries[_DP] = input[_DP];
    }
    if (input[_Do] != null) {
        entries[_Do] = input[_Do];
    }
    if (input[_DIAMRN] != null) {
        entries[_DIAMRN] = input[_DIAMRN];
    }
    if (input[_DF] != null) {
        entries[_DF] = input[_DF];
    }
    if (input[_DO] != null) {
        entries[_DO] = input[_DO];
    }
    if (input[_DASA] != null) {
        entries[_DASA] = input[_DASA];
    }
    if (input[_DDI] != null) {
        const memberEntries = se_StringList(input[_DDI], context);
        if (input[_DDI]?.length === 0) {
            entries.DomainDnsIps = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DomainDnsIps.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_RM] != null) {
        entries[_RM] = input[_RM];
    }
    if (input[_MASa] != null) {
        entries[_MASa] = input[_MASa];
    }
    if (input[_CIIP] != null) {
        entries[_CIIP] = input[_CIIP];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_STto] != null) {
        entries[_STto] = input[_STto];
    }
    if (input[_ECOI] != null) {
        entries[_ECOI] = input[_ECOI];
    }
    if (input[_BTa] != null) {
        entries[_BTa] = input[_BTa];
    }
    if (input[_AS] != null) {
        entries[_AS] = input[_AS];
    }
    if (input[_SDBCI] != null) {
        entries[_SDBCI] = input[_SDBCI];
    }
    if (input[_DLV] != null) {
        entries[_DLV] = input[_DLV];
    }
    if (input[_USC] != null) {
        entries[_USC] = input[_USC];
    }
    if (input[_CACI] != null) {
        entries[_CACI] = input[_CACI];
    }
    return entries;
};
const se_CreateDBParameterGroupMessage = (input, context) => {
    const entries = {};
    if (input[_DBPGN] != null) {
        entries[_DBPGN] = input[_DBPGN];
    }
    if (input[_DBPGF] != null) {
        entries[_DBPGF] = input[_DBPGF];
    }
    if (input[_D] != null) {
        entries[_D] = input[_D];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateDBProxyEndpointRequest = (input, context) => {
    const entries = {};
    if (input[_DBPN] != null) {
        entries[_DBPN] = input[_DBPN];
    }
    if (input[_DBPEN] != null) {
        entries[_DBPEN] = input[_DBPEN];
    }
    if (input[_VSI] != null) {
        const memberEntries = se_StringList(input[_VSI], context);
        if (input[_VSI]?.length === 0) {
            entries.VpcSubnetIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcSubnetIds.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_VSGI] != null) {
        const memberEntries = se_StringList(input[_VSGI], context);
        if (input[_VSGI]?.length === 0) {
            entries.VpcSecurityGroupIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcSecurityGroupIds.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_TR] != null) {
        entries[_TR] = input[_TR];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateDBProxyRequest = (input, context) => {
    const entries = {};
    if (input[_DBPN] != null) {
        entries[_DBPN] = input[_DBPN];
    }
    if (input[_EF] != null) {
        entries[_EF] = input[_EF];
    }
    if (input[_Au] != null) {
        const memberEntries = se_UserAuthConfigList(input[_Au], context);
        if (input[_Au]?.length === 0) {
            entries.Auth = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Auth.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_RA] != null) {
        entries[_RA] = input[_RA];
    }
    if (input[_VSI] != null) {
        const memberEntries = se_StringList(input[_VSI], context);
        if (input[_VSI]?.length === 0) {
            entries.VpcSubnetIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcSubnetIds.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_VSGI] != null) {
        const memberEntries = se_StringList(input[_VSGI], context);
        if (input[_VSGI]?.length === 0) {
            entries.VpcSecurityGroupIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcSecurityGroupIds.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_RTLS] != null) {
        entries[_RTLS] = input[_RTLS];
    }
    if (input[_ICT] != null) {
        entries[_ICT] = input[_ICT];
    }
    if (input[_DL] != null) {
        entries[_DL] = input[_DL];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateDBSecurityGroupMessage = (input, context) => {
    const entries = {};
    if (input[_DBSGN] != null) {
        entries[_DBSGN] = input[_DBSGN];
    }
    if (input[_DBSGD] != null) {
        entries[_DBSGD] = input[_DBSGD];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateDBShardGroupMessage = (input, context) => {
    const entries = {};
    if (input[_DBSGI] != null) {
        entries[_DBSGI] = input[_DBSGI];
    }
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    if (input[_CR] != null) {
        entries[_CR] = input[_CR];
    }
    if (input[_MACU] != null) {
        entries[_MACU] = __serializeFloat(input[_MACU]);
    }
    if (input[_MACUi] != null) {
        entries[_MACUi] = __serializeFloat(input[_MACUi]);
    }
    if (input[_PA] != null) {
        entries[_PA] = input[_PA];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateDBSnapshotMessage = (input, context) => {
    const entries = {};
    if (input[_DBSIn] != null) {
        entries[_DBSIn] = input[_DBSIn];
    }
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateDBSubnetGroupMessage = (input, context) => {
    const entries = {};
    if (input[_DBSGNu] != null) {
        entries[_DBSGNu] = input[_DBSGNu];
    }
    if (input[_DBSGDu] != null) {
        entries[_DBSGDu] = input[_DBSGDu];
    }
    if (input[_SIu] != null) {
        const memberEntries = se_SubnetIdentifierList(input[_SIu], context);
        if (input[_SIu]?.length === 0) {
            entries.SubnetIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SubnetIds.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateEventSubscriptionMessage = (input, context) => {
    const entries = {};
    if (input[_SN] != null) {
        entries[_SN] = input[_SN];
    }
    if (input[_STA] != null) {
        entries[_STA] = input[_STA];
    }
    if (input[_STo] != null) {
        entries[_STo] = input[_STo];
    }
    if (input[_EC] != null) {
        const memberEntries = se_EventCategoriesList(input[_EC], context);
        if (input[_EC]?.length === 0) {
            entries.EventCategories = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `EventCategories.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_SIo] != null) {
        const memberEntries = se_SourceIdsList(input[_SIo], context);
        if (input[_SIo]?.length === 0) {
            entries.SourceIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SourceIds.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_En] != null) {
        entries[_En] = input[_En];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateGlobalClusterMessage = (input, context) => {
    const entries = {};
    if (input[_GCI] != null) {
        entries[_GCI] = input[_GCI];
    }
    if (input[_SDBCI] != null) {
        entries[_SDBCI] = input[_SDBCI];
    }
    if (input[_E] != null) {
        entries[_E] = input[_E];
    }
    if (input[_EV] != null) {
        entries[_EV] = input[_EV];
    }
    if (input[_ELS] != null) {
        entries[_ELS] = input[_ELS];
    }
    if (input[_DP] != null) {
        entries[_DP] = input[_DP];
    }
    if (input[_DN] != null) {
        entries[_DN] = input[_DN];
    }
    if (input[_SE] != null) {
        entries[_SE] = input[_SE];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateIntegrationMessage = (input, context) => {
    const entries = {};
    if (input[_SA] != null) {
        entries[_SA] = input[_SA];
    }
    if (input[_TA] != null) {
        entries[_TA] = input[_TA];
    }
    if (input[_IN] != null) {
        entries[_IN] = input[_IN];
    }
    if (input[_KMSKI] != null) {
        entries[_KMSKI] = input[_KMSKI];
    }
    if (input[_AEC] != null) {
        const memberEntries = se_EncryptionContextMap(input[_AEC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AdditionalEncryptionContext.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DFa] != null) {
        entries[_DFa] = input[_DFa];
    }
    if (input[_D] != null) {
        entries[_D] = input[_D];
    }
    return entries;
};
const se_CreateOptionGroupMessage = (input, context) => {
    const entries = {};
    if (input[_OGN] != null) {
        entries[_OGN] = input[_OGN];
    }
    if (input[_EN] != null) {
        entries[_EN] = input[_EN];
    }
    if (input[_MEV] != null) {
        entries[_MEV] = input[_MEV];
    }
    if (input[_OGD] != null) {
        entries[_OGD] = input[_OGD];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_CreateTenantDatabaseMessage = (input, context) => {
    const entries = {};
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_TDBN] != null) {
        entries[_TDBN] = input[_TDBN];
    }
    if (input[_MU] != null) {
        entries[_MU] = input[_MU];
    }
    if (input[_MUP] != null) {
        entries[_MUP] = input[_MUP];
    }
    if (input[_CSN] != null) {
        entries[_CSN] = input[_CSN];
    }
    if (input[_NCSN] != null) {
        entries[_NCSN] = input[_NCSN];
    }
    if (input[_MMUP] != null) {
        entries[_MMUP] = input[_MMUP];
    }
    if (input[_MUSKKI] != null) {
        entries[_MUSKKI] = input[_MUSKKI];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DBSecurityGroupNameList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`DBSecurityGroupName.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_DeleteBlueGreenDeploymentRequest = (input, context) => {
    const entries = {};
    if (input[_BGDI] != null) {
        entries[_BGDI] = input[_BGDI];
    }
    if (input[_DT] != null) {
        entries[_DT] = input[_DT];
    }
    return entries;
};
const se_DeleteCustomDBEngineVersionMessage = (input, context) => {
    const entries = {};
    if (input[_E] != null) {
        entries[_E] = input[_E];
    }
    if (input[_EV] != null) {
        entries[_EV] = input[_EV];
    }
    return entries;
};
const se_DeleteDBClusterAutomatedBackupMessage = (input, context) => {
    const entries = {};
    if (input[_DCRI] != null) {
        entries[_DCRI] = input[_DCRI];
    }
    return entries;
};
const se_DeleteDBClusterEndpointMessage = (input, context) => {
    const entries = {};
    if (input[_DBCEI] != null) {
        entries[_DBCEI] = input[_DBCEI];
    }
    return entries;
};
const se_DeleteDBClusterMessage = (input, context) => {
    const entries = {};
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    if (input[_SFS] != null) {
        entries[_SFS] = input[_SFS];
    }
    if (input[_FDBSI] != null) {
        entries[_FDBSI] = input[_FDBSI];
    }
    if (input[_DAB] != null) {
        entries[_DAB] = input[_DAB];
    }
    return entries;
};
const se_DeleteDBClusterParameterGroupMessage = (input, context) => {
    const entries = {};
    if (input[_DBCPGN] != null) {
        entries[_DBCPGN] = input[_DBCPGN];
    }
    return entries;
};
const se_DeleteDBClusterSnapshotMessage = (input, context) => {
    const entries = {};
    if (input[_DBCSI] != null) {
        entries[_DBCSI] = input[_DBCSI];
    }
    return entries;
};
const se_DeleteDBInstanceAutomatedBackupMessage = (input, context) => {
    const entries = {};
    if (input[_DRI] != null) {
        entries[_DRI] = input[_DRI];
    }
    if (input[_DBIABA] != null) {
        entries[_DBIABA] = input[_DBIABA];
    }
    return entries;
};
const se_DeleteDBInstanceMessage = (input, context) => {
    const entries = {};
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_SFS] != null) {
        entries[_SFS] = input[_SFS];
    }
    if (input[_FDBSI] != null) {
        entries[_FDBSI] = input[_FDBSI];
    }
    if (input[_DAB] != null) {
        entries[_DAB] = input[_DAB];
    }
    return entries;
};
const se_DeleteDBParameterGroupMessage = (input, context) => {
    const entries = {};
    if (input[_DBPGN] != null) {
        entries[_DBPGN] = input[_DBPGN];
    }
    return entries;
};
const se_DeleteDBProxyEndpointRequest = (input, context) => {
    const entries = {};
    if (input[_DBPEN] != null) {
        entries[_DBPEN] = input[_DBPEN];
    }
    return entries;
};
const se_DeleteDBProxyRequest = (input, context) => {
    const entries = {};
    if (input[_DBPN] != null) {
        entries[_DBPN] = input[_DBPN];
    }
    return entries;
};
const se_DeleteDBSecurityGroupMessage = (input, context) => {
    const entries = {};
    if (input[_DBSGN] != null) {
        entries[_DBSGN] = input[_DBSGN];
    }
    return entries;
};
const se_DeleteDBShardGroupMessage = (input, context) => {
    const entries = {};
    if (input[_DBSGI] != null) {
        entries[_DBSGI] = input[_DBSGI];
    }
    return entries;
};
const se_DeleteDBSnapshotMessage = (input, context) => {
    const entries = {};
    if (input[_DBSIn] != null) {
        entries[_DBSIn] = input[_DBSIn];
    }
    return entries;
};
const se_DeleteDBSubnetGroupMessage = (input, context) => {
    const entries = {};
    if (input[_DBSGNu] != null) {
        entries[_DBSGNu] = input[_DBSGNu];
    }
    return entries;
};
const se_DeleteEventSubscriptionMessage = (input, context) => {
    const entries = {};
    if (input[_SN] != null) {
        entries[_SN] = input[_SN];
    }
    return entries;
};
const se_DeleteGlobalClusterMessage = (input, context) => {
    const entries = {};
    if (input[_GCI] != null) {
        entries[_GCI] = input[_GCI];
    }
    return entries;
};
const se_DeleteIntegrationMessage = (input, context) => {
    const entries = {};
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    return entries;
};
const se_DeleteOptionGroupMessage = (input, context) => {
    const entries = {};
    if (input[_OGN] != null) {
        entries[_OGN] = input[_OGN];
    }
    return entries;
};
const se_DeleteTenantDatabaseMessage = (input, context) => {
    const entries = {};
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_TDBN] != null) {
        entries[_TDBN] = input[_TDBN];
    }
    if (input[_SFS] != null) {
        entries[_SFS] = input[_SFS];
    }
    if (input[_FDBSI] != null) {
        entries[_FDBSI] = input[_FDBSI];
    }
    return entries;
};
const se_DeregisterDBProxyTargetsRequest = (input, context) => {
    const entries = {};
    if (input[_DBPN] != null) {
        entries[_DBPN] = input[_DBPN];
    }
    if (input[_TGN] != null) {
        entries[_TGN] = input[_TGN];
    }
    if (input[_DBIIn] != null) {
        const memberEntries = se_StringList(input[_DBIIn], context);
        if (input[_DBIIn]?.length === 0) {
            entries.DBInstanceIdentifiers = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DBInstanceIdentifiers.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DBCIl] != null) {
        const memberEntries = se_StringList(input[_DBCIl], context);
        if (input[_DBCIl]?.length === 0) {
            entries.DBClusterIdentifiers = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DBClusterIdentifiers.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeAccountAttributesMessage = (input, context) => {
    const entries = {};
    return entries;
};
const se_DescribeBlueGreenDeploymentsRequest = (input, context) => {
    const entries = {};
    if (input[_BGDI] != null) {
        entries[_BGDI] = input[_BGDI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeCertificatesMessage = (input, context) => {
    const entries = {};
    if (input[_CIe] != null) {
        entries[_CIe] = input[_CIe];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeDBClusterAutomatedBackupsMessage = (input, context) => {
    const entries = {};
    if (input[_DCRI] != null) {
        entries[_DCRI] = input[_DCRI];
    }
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeDBClusterBacktracksMessage = (input, context) => {
    const entries = {};
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    if (input[_BI] != null) {
        entries[_BI] = input[_BI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeDBClusterEndpointsMessage = (input, context) => {
    const entries = {};
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    if (input[_DBCEI] != null) {
        entries[_DBCEI] = input[_DBCEI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeDBClusterParameterGroupsMessage = (input, context) => {
    const entries = {};
    if (input[_DBCPGN] != null) {
        entries[_DBCPGN] = input[_DBCPGN];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeDBClusterParametersMessage = (input, context) => {
    const entries = {};
    if (input[_DBCPGN] != null) {
        entries[_DBCPGN] = input[_DBCPGN];
    }
    if (input[_S] != null) {
        entries[_S] = input[_S];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeDBClustersMessage = (input, context) => {
    const entries = {};
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    if (input[_IS] != null) {
        entries[_IS] = input[_IS];
    }
    return entries;
};
const se_DescribeDBClusterSnapshotAttributesMessage = (input, context) => {
    const entries = {};
    if (input[_DBCSI] != null) {
        entries[_DBCSI] = input[_DBCSI];
    }
    return entries;
};
const se_DescribeDBClusterSnapshotsMessage = (input, context) => {
    const entries = {};
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    if (input[_DBCSI] != null) {
        entries[_DBCSI] = input[_DBCSI];
    }
    if (input[_STn] != null) {
        entries[_STn] = input[_STn];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    if (input[_IS] != null) {
        entries[_IS] = input[_IS];
    }
    if (input[_IP] != null) {
        entries[_IP] = input[_IP];
    }
    if (input[_DCRI] != null) {
        entries[_DCRI] = input[_DCRI];
    }
    return entries;
};
const se_DescribeDBEngineVersionsMessage = (input, context) => {
    const entries = {};
    if (input[_E] != null) {
        entries[_E] = input[_E];
    }
    if (input[_EV] != null) {
        entries[_EV] = input[_EV];
    }
    if (input[_DBPGF] != null) {
        entries[_DBPGF] = input[_DBPGF];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    if (input[_DOe] != null) {
        entries[_DOe] = input[_DOe];
    }
    if (input[_LSCS] != null) {
        entries[_LSCS] = input[_LSCS];
    }
    if (input[_LST] != null) {
        entries[_LST] = input[_LST];
    }
    if (input[_IA] != null) {
        entries[_IA] = input[_IA];
    }
    return entries;
};
const se_DescribeDBInstanceAutomatedBackupsMessage = (input, context) => {
    const entries = {};
    if (input[_DRI] != null) {
        entries[_DRI] = input[_DRI];
    }
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    if (input[_DBIABA] != null) {
        entries[_DBIABA] = input[_DBIABA];
    }
    return entries;
};
const se_DescribeDBInstancesMessage = (input, context) => {
    const entries = {};
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeDBLogFilesMessage = (input, context) => {
    const entries = {};
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_FC] != null) {
        entries[_FC] = input[_FC];
    }
    if (input[_FLW] != null) {
        entries[_FLW] = input[_FLW];
    }
    if (input[_FS] != null) {
        entries[_FS] = input[_FS];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeDBMajorEngineVersionsRequest = (input, context) => {
    const entries = {};
    if (input[_E] != null) {
        entries[_E] = input[_E];
    }
    if (input[_MEV] != null) {
        entries[_MEV] = input[_MEV];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeDBParameterGroupsMessage = (input, context) => {
    const entries = {};
    if (input[_DBPGN] != null) {
        entries[_DBPGN] = input[_DBPGN];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeDBParametersMessage = (input, context) => {
    const entries = {};
    if (input[_DBPGN] != null) {
        entries[_DBPGN] = input[_DBPGN];
    }
    if (input[_S] != null) {
        entries[_S] = input[_S];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeDBProxiesRequest = (input, context) => {
    const entries = {};
    if (input[_DBPN] != null) {
        entries[_DBPN] = input[_DBPN];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeDBProxyEndpointsRequest = (input, context) => {
    const entries = {};
    if (input[_DBPN] != null) {
        entries[_DBPN] = input[_DBPN];
    }
    if (input[_DBPEN] != null) {
        entries[_DBPEN] = input[_DBPEN];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeDBProxyTargetGroupsRequest = (input, context) => {
    const entries = {};
    if (input[_DBPN] != null) {
        entries[_DBPN] = input[_DBPN];
    }
    if (input[_TGN] != null) {
        entries[_TGN] = input[_TGN];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeDBProxyTargetsRequest = (input, context) => {
    const entries = {};
    if (input[_DBPN] != null) {
        entries[_DBPN] = input[_DBPN];
    }
    if (input[_TGN] != null) {
        entries[_TGN] = input[_TGN];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeDBRecommendationsMessage = (input, context) => {
    const entries = {};
    if (input[_LUA] != null) {
        entries[_LUA] = __serializeDateTime(input[_LUA]);
    }
    if (input[_LUB] != null) {
        entries[_LUB] = __serializeDateTime(input[_LUB]);
    }
    if (input[_L] != null) {
        entries[_L] = input[_L];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeDBSecurityGroupsMessage = (input, context) => {
    const entries = {};
    if (input[_DBSGN] != null) {
        entries[_DBSGN] = input[_DBSGN];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeDBShardGroupsMessage = (input, context) => {
    const entries = {};
    if (input[_DBSGI] != null) {
        entries[_DBSGI] = input[_DBSGI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeDBSnapshotAttributesMessage = (input, context) => {
    const entries = {};
    if (input[_DBSIn] != null) {
        entries[_DBSIn] = input[_DBSIn];
    }
    return entries;
};
const se_DescribeDBSnapshotsMessage = (input, context) => {
    const entries = {};
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_DBSIn] != null) {
        entries[_DBSIn] = input[_DBSIn];
    }
    if (input[_STn] != null) {
        entries[_STn] = input[_STn];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    if (input[_IS] != null) {
        entries[_IS] = input[_IS];
    }
    if (input[_IP] != null) {
        entries[_IP] = input[_IP];
    }
    if (input[_DRI] != null) {
        entries[_DRI] = input[_DRI];
    }
    return entries;
};
const se_DescribeDBSnapshotTenantDatabasesMessage = (input, context) => {
    const entries = {};
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_DBSIn] != null) {
        entries[_DBSIn] = input[_DBSIn];
    }
    if (input[_STn] != null) {
        entries[_STn] = input[_STn];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    if (input[_DRI] != null) {
        entries[_DRI] = input[_DRI];
    }
    return entries;
};
const se_DescribeDBSubnetGroupsMessage = (input, context) => {
    const entries = {};
    if (input[_DBSGNu] != null) {
        entries[_DBSGNu] = input[_DBSGNu];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeEngineDefaultClusterParametersMessage = (input, context) => {
    const entries = {};
    if (input[_DBPGF] != null) {
        entries[_DBPGF] = input[_DBPGF];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeEngineDefaultParametersMessage = (input, context) => {
    const entries = {};
    if (input[_DBPGF] != null) {
        entries[_DBPGF] = input[_DBPGF];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeEventCategoriesMessage = (input, context) => {
    const entries = {};
    if (input[_STo] != null) {
        entries[_STo] = input[_STo];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeEventsMessage = (input, context) => {
    const entries = {};
    if (input[_SI] != null) {
        entries[_SI] = input[_SI];
    }
    if (input[_STo] != null) {
        entries[_STo] = input[_STo];
    }
    if (input[_STta] != null) {
        entries[_STta] = __serializeDateTime(input[_STta]);
    }
    if (input[_ETn] != null) {
        entries[_ETn] = __serializeDateTime(input[_ETn]);
    }
    if (input[_Du] != null) {
        entries[_Du] = input[_Du];
    }
    if (input[_EC] != null) {
        const memberEntries = se_EventCategoriesList(input[_EC], context);
        if (input[_EC]?.length === 0) {
            entries.EventCategories = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `EventCategories.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeEventSubscriptionsMessage = (input, context) => {
    const entries = {};
    if (input[_SN] != null) {
        entries[_SN] = input[_SN];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeExportTasksMessage = (input, context) => {
    const entries = {};
    if (input[_ETI] != null) {
        entries[_ETI] = input[_ETI];
    }
    if (input[_SA] != null) {
        entries[_SA] = input[_SA];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_STo] != null) {
        entries[_STo] = input[_STo];
    }
    return entries;
};
const se_DescribeGlobalClustersMessage = (input, context) => {
    const entries = {};
    if (input[_GCI] != null) {
        entries[_GCI] = input[_GCI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeIntegrationsMessage = (input, context) => {
    const entries = {};
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeOptionGroupOptionsMessage = (input, context) => {
    const entries = {};
    if (input[_EN] != null) {
        entries[_EN] = input[_EN];
    }
    if (input[_MEV] != null) {
        entries[_MEV] = input[_MEV];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeOptionGroupsMessage = (input, context) => {
    const entries = {};
    if (input[_OGN] != null) {
        entries[_OGN] = input[_OGN];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_EN] != null) {
        entries[_EN] = input[_EN];
    }
    if (input[_MEV] != null) {
        entries[_MEV] = input[_MEV];
    }
    return entries;
};
const se_DescribeOrderableDBInstanceOptionsMessage = (input, context) => {
    const entries = {};
    if (input[_E] != null) {
        entries[_E] = input[_E];
    }
    if (input[_EV] != null) {
        entries[_EV] = input[_EV];
    }
    if (input[_DBIC] != null) {
        entries[_DBIC] = input[_DBIC];
    }
    if (input[_LM] != null) {
        entries[_LM] = input[_LM];
    }
    if (input[_AZG] != null) {
        entries[_AZG] = input[_AZG];
    }
    if (input[_Vp] != null) {
        entries[_Vp] = input[_Vp];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribePendingMaintenanceActionsMessage = (input, context) => {
    const entries = {};
    if (input[_RI] != null) {
        entries[_RI] = input[_RI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeReservedDBInstancesMessage = (input, context) => {
    const entries = {};
    if (input[_RDBII] != null) {
        entries[_RDBII] = input[_RDBII];
    }
    if (input[_RDBIOI] != null) {
        entries[_RDBIOI] = input[_RDBIOI];
    }
    if (input[_DBIC] != null) {
        entries[_DBIC] = input[_DBIC];
    }
    if (input[_Du] != null) {
        entries[_Du] = input[_Du];
    }
    if (input[_PD] != null) {
        entries[_PD] = input[_PD];
    }
    if (input[_OT] != null) {
        entries[_OT] = input[_OT];
    }
    if (input[_MAZ] != null) {
        entries[_MAZ] = input[_MAZ];
    }
    if (input[_LI] != null) {
        entries[_LI] = input[_LI];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeReservedDBInstancesOfferingsMessage = (input, context) => {
    const entries = {};
    if (input[_RDBIOI] != null) {
        entries[_RDBIOI] = input[_RDBIOI];
    }
    if (input[_DBIC] != null) {
        entries[_DBIC] = input[_DBIC];
    }
    if (input[_Du] != null) {
        entries[_Du] = input[_Du];
    }
    if (input[_PD] != null) {
        entries[_PD] = input[_PD];
    }
    if (input[_OT] != null) {
        entries[_OT] = input[_OT];
    }
    if (input[_MAZ] != null) {
        entries[_MAZ] = input[_MAZ];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    return entries;
};
const se_DescribeSourceRegionsMessage = (input, context) => {
    const entries = {};
    if (input[_RNe] != null) {
        entries[_RNe] = input[_RNe];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_DescribeTenantDatabasesMessage = (input, context) => {
    const entries = {};
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_TDBN] != null) {
        entries[_TDBN] = input[_TDBN];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    if (input[_MR] != null) {
        entries[_MR] = input[_MR];
    }
    return entries;
};
const se_DescribeValidDBInstanceModificationsMessage = (input, context) => {
    const entries = {};
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    return entries;
};
const se_DisableHttpEndpointRequest = (input, context) => {
    const entries = {};
    if (input[_RAe] != null) {
        entries[_RAe] = input[_RAe];
    }
    return entries;
};
const se_DownloadDBLogFilePortionMessage = (input, context) => {
    const entries = {};
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_LFN] != null) {
        entries[_LFN] = input[_LFN];
    }
    if (input[_Ma] != null) {
        entries[_Ma] = input[_Ma];
    }
    if (input[_NOL] != null) {
        entries[_NOL] = input[_NOL];
    }
    return entries;
};
const se_EnableHttpEndpointRequest = (input, context) => {
    const entries = {};
    if (input[_RAe] != null) {
        entries[_RAe] = input[_RAe];
    }
    return entries;
};
const se_EncryptionContextMap = (input, context) => {
    const entries = {};
    let counter = 1;
    Object.keys(input)
        .filter((key) => input[key] != null)
        .forEach((key) => {
        entries[`entry.${counter}.key`] = key;
        entries[`entry.${counter}.value`] = input[key];
        counter++;
    });
    return entries;
};
const se_EngineModeList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_EventCategoriesList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`EventCategory.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_FailoverDBClusterMessage = (input, context) => {
    const entries = {};
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    if (input[_TDBII] != null) {
        entries[_TDBII] = input[_TDBII];
    }
    return entries;
};
const se_FailoverGlobalClusterMessage = (input, context) => {
    const entries = {};
    if (input[_GCI] != null) {
        entries[_GCI] = input[_GCI];
    }
    if (input[_TDCI] != null) {
        entries[_TDCI] = input[_TDCI];
    }
    if (input[_ADL] != null) {
        entries[_ADL] = input[_ADL];
    }
    if (input[_Sw] != null) {
        entries[_Sw] = input[_Sw];
    }
    return entries;
};
const se_Filter = (input, context) => {
    const entries = {};
    if (input[_N] != null) {
        entries[_N] = input[_N];
    }
    if (input[_Va] != null) {
        const memberEntries = se_FilterValueList(input[_Va], context);
        if (input[_Va]?.length === 0) {
            entries.Values = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Values.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_FilterList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_Filter(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Filter.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_FilterValueList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`Value.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_KeyList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ListTagsForResourceMessage = (input, context) => {
    const entries = {};
    if (input[_RN] != null) {
        entries[_RN] = input[_RN];
    }
    if (input[_Fi] != null) {
        const memberEntries = se_FilterList(input[_Fi], context);
        if (input[_Fi]?.length === 0) {
            entries.Filters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Filters.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_LogTypeList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_ModifyActivityStreamRequest = (input, context) => {
    const entries = {};
    if (input[_RAe] != null) {
        entries[_RAe] = input[_RAe];
    }
    if (input[_APS] != null) {
        entries[_APS] = input[_APS];
    }
    return entries;
};
const se_ModifyCertificatesMessage = (input, context) => {
    const entries = {};
    if (input[_CIe] != null) {
        entries[_CIe] = input[_CIe];
    }
    if (input[_RCO] != null) {
        entries[_RCO] = input[_RCO];
    }
    return entries;
};
const se_ModifyCurrentDBClusterCapacityMessage = (input, context) => {
    const entries = {};
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    if (input[_C] != null) {
        entries[_C] = input[_C];
    }
    if (input[_SBT] != null) {
        entries[_SBT] = input[_SBT];
    }
    if (input[_TAi] != null) {
        entries[_TAi] = input[_TAi];
    }
    return entries;
};
const se_ModifyCustomDBEngineVersionMessage = (input, context) => {
    const entries = {};
    if (input[_E] != null) {
        entries[_E] = input[_E];
    }
    if (input[_EV] != null) {
        entries[_EV] = input[_EV];
    }
    if (input[_D] != null) {
        entries[_D] = input[_D];
    }
    if (input[_St] != null) {
        entries[_St] = input[_St];
    }
    return entries;
};
const se_ModifyDBClusterEndpointMessage = (input, context) => {
    const entries = {};
    if (input[_DBCEI] != null) {
        entries[_DBCEI] = input[_DBCEI];
    }
    if (input[_ET] != null) {
        entries[_ET] = input[_ET];
    }
    if (input[_SM] != null) {
        const memberEntries = se_StringList(input[_SM], context);
        if (input[_SM]?.length === 0) {
            entries.StaticMembers = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `StaticMembers.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_EM] != null) {
        const memberEntries = se_StringList(input[_EM], context);
        if (input[_EM]?.length === 0) {
            entries.ExcludedMembers = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ExcludedMembers.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ModifyDBClusterMessage = (input, context) => {
    const entries = {};
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    if (input[_NDBCI] != null) {
        entries[_NDBCI] = input[_NDBCI];
    }
    if (input[_AI] != null) {
        entries[_AI] = input[_AI];
    }
    if (input[_BRP] != null) {
        entries[_BRP] = input[_BRP];
    }
    if (input[_DBCPGN] != null) {
        entries[_DBCPGN] = input[_DBCPGN];
    }
    if (input[_VSGI] != null) {
        const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
        if (input[_VSGI]?.length === 0) {
            entries.VpcSecurityGroupIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcSecurityGroupIds.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_P] != null) {
        entries[_P] = input[_P];
    }
    if (input[_MUP] != null) {
        entries[_MUP] = input[_MUP];
    }
    if (input[_OGN] != null) {
        entries[_OGN] = input[_OGN];
    }
    if (input[_PBW] != null) {
        entries[_PBW] = input[_PBW];
    }
    if (input[_PMW] != null) {
        entries[_PMW] = input[_PMW];
    }
    if (input[_EIAMDA] != null) {
        entries[_EIAMDA] = input[_EIAMDA];
    }
    if (input[_BW] != null) {
        entries[_BW] = input[_BW];
    }
    if (input[_CLEC] != null) {
        const memberEntries = se_CloudwatchLogsExportConfiguration(input[_CLEC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `CloudwatchLogsExportConfiguration.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_EV] != null) {
        entries[_EV] = input[_EV];
    }
    if (input[_AMVUl] != null) {
        entries[_AMVUl] = input[_AMVUl];
    }
    if (input[_DBIPGN] != null) {
        entries[_DBIPGN] = input[_DBIPGN];
    }
    if (input[_Do] != null) {
        entries[_Do] = input[_Do];
    }
    if (input[_DIAMRN] != null) {
        entries[_DIAMRN] = input[_DIAMRN];
    }
    if (input[_SC] != null) {
        const memberEntries = se_ScalingConfiguration(input[_SC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ScalingConfiguration.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DP] != null) {
        entries[_DP] = input[_DP];
    }
    if (input[_EHE] != null) {
        entries[_EHE] = input[_EHE];
    }
    if (input[_CTTS] != null) {
        entries[_CTTS] = input[_CTTS];
    }
    if (input[_EGWF] != null) {
        entries[_EGWF] = input[_EGWF];
    }
    if (input[_DBCIC] != null) {
        entries[_DBCIC] = input[_DBCIC];
    }
    if (input[_AS] != null) {
        entries[_AS] = input[_AS];
    }
    if (input[_STt] != null) {
        entries[_STt] = input[_STt];
    }
    if (input[_I] != null) {
        entries[_I] = input[_I];
    }
    if (input[_AMVU] != null) {
        entries[_AMVU] = input[_AMVU];
    }
    if (input[_MIo] != null) {
        entries[_MIo] = input[_MIo];
    }
    if (input[_MRA] != null) {
        entries[_MRA] = input[_MRA];
    }
    if (input[_DIM] != null) {
        entries[_DIM] = input[_DIM];
    }
    if (input[_EPI] != null) {
        entries[_EPI] = input[_EPI];
    }
    if (input[_PIKMSKI] != null) {
        entries[_PIKMSKI] = input[_PIKMSKI];
    }
    if (input[_PIRP] != null) {
        entries[_PIRP] = input[_PIRP];
    }
    if (input[_SVSC] != null) {
        const memberEntries = se_ServerlessV2ScalingConfiguration(input[_SVSC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ServerlessV2ScalingConfiguration.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MMUP] != null) {
        entries[_MMUP] = input[_MMUP];
    }
    if (input[_RMUP] != null) {
        entries[_RMUP] = input[_RMUP];
    }
    if (input[_MUSKKI] != null) {
        entries[_MUSKKI] = input[_MUSKKI];
    }
    if (input[_EMn] != null) {
        entries[_EMn] = input[_EMn];
    }
    if (input[_AEMC] != null) {
        entries[_AEMC] = input[_AEMC];
    }
    if (input[_ELWF] != null) {
        entries[_ELWF] = input[_ELWF];
    }
    if (input[_ABRPA] != null) {
        entries[_ABRPA] = input[_ABRPA];
    }
    if (input[_ELD] != null) {
        entries[_ELD] = input[_ELD];
    }
    if (input[_CACI] != null) {
        entries[_CACI] = input[_CACI];
    }
    return entries;
};
const se_ModifyDBClusterParameterGroupMessage = (input, context) => {
    const entries = {};
    if (input[_DBCPGN] != null) {
        entries[_DBCPGN] = input[_DBCPGN];
    }
    if (input[_Pa] != null) {
        const memberEntries = se_ParametersList(input[_Pa], context);
        if (input[_Pa]?.length === 0) {
            entries.Parameters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Parameters.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ModifyDBClusterSnapshotAttributeMessage = (input, context) => {
    const entries = {};
    if (input[_DBCSI] != null) {
        entries[_DBCSI] = input[_DBCSI];
    }
    if (input[_AN] != null) {
        entries[_AN] = input[_AN];
    }
    if (input[_VTA] != null) {
        const memberEntries = se_AttributeValueList(input[_VTA], context);
        if (input[_VTA]?.length === 0) {
            entries.ValuesToAdd = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ValuesToAdd.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_VTR] != null) {
        const memberEntries = se_AttributeValueList(input[_VTR], context);
        if (input[_VTR]?.length === 0) {
            entries.ValuesToRemove = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ValuesToRemove.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ModifyDBInstanceMessage = (input, context) => {
    const entries = {};
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_AS] != null) {
        entries[_AS] = input[_AS];
    }
    if (input[_DBIC] != null) {
        entries[_DBIC] = input[_DBIC];
    }
    if (input[_DBSGNu] != null) {
        entries[_DBSGNu] = input[_DBSGNu];
    }
    if (input[_DBSG] != null) {
        const memberEntries = se_DBSecurityGroupNameList(input[_DBSG], context);
        if (input[_DBSG]?.length === 0) {
            entries.DBSecurityGroups = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DBSecurityGroups.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_VSGI] != null) {
        const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
        if (input[_VSGI]?.length === 0) {
            entries.VpcSecurityGroupIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcSecurityGroupIds.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_AI] != null) {
        entries[_AI] = input[_AI];
    }
    if (input[_MUP] != null) {
        entries[_MUP] = input[_MUP];
    }
    if (input[_DBPGN] != null) {
        entries[_DBPGN] = input[_DBPGN];
    }
    if (input[_BRP] != null) {
        entries[_BRP] = input[_BRP];
    }
    if (input[_PBW] != null) {
        entries[_PBW] = input[_PBW];
    }
    if (input[_PMW] != null) {
        entries[_PMW] = input[_PMW];
    }
    if (input[_MAZ] != null) {
        entries[_MAZ] = input[_MAZ];
    }
    if (input[_EV] != null) {
        entries[_EV] = input[_EV];
    }
    if (input[_AMVUl] != null) {
        entries[_AMVUl] = input[_AMVUl];
    }
    if (input[_AMVU] != null) {
        entries[_AMVU] = input[_AMVU];
    }
    if (input[_LM] != null) {
        entries[_LM] = input[_LM];
    }
    if (input[_I] != null) {
        entries[_I] = input[_I];
    }
    if (input[_OGN] != null) {
        entries[_OGN] = input[_OGN];
    }
    if (input[_NDBII] != null) {
        entries[_NDBII] = input[_NDBII];
    }
    if (input[_STt] != null) {
        entries[_STt] = input[_STt];
    }
    if (input[_TCA] != null) {
        entries[_TCA] = input[_TCA];
    }
    if (input[_TCP] != null) {
        entries[_TCP] = input[_TCP];
    }
    if (input[_CACI] != null) {
        entries[_CACI] = input[_CACI];
    }
    if (input[_Do] != null) {
        entries[_Do] = input[_Do];
    }
    if (input[_DF] != null) {
        entries[_DF] = input[_DF];
    }
    if (input[_DO] != null) {
        entries[_DO] = input[_DO];
    }
    if (input[_DASA] != null) {
        entries[_DASA] = input[_DASA];
    }
    if (input[_DDI] != null) {
        const memberEntries = se_StringList(input[_DDI], context);
        if (input[_DDI]?.length === 0) {
            entries.DomainDnsIps = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DomainDnsIps.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_CTTS] != null) {
        entries[_CTTS] = input[_CTTS];
    }
    if (input[_MIo] != null) {
        entries[_MIo] = input[_MIo];
    }
    if (input[_DBPNo] != null) {
        entries[_DBPNo] = input[_DBPNo];
    }
    if (input[_PA] != null) {
        entries[_PA] = input[_PA];
    }
    if (input[_MRA] != null) {
        entries[_MRA] = input[_MRA];
    }
    if (input[_DIAMRN] != null) {
        entries[_DIAMRN] = input[_DIAMRN];
    }
    if (input[_DD] != null) {
        entries[_DD] = input[_DD];
    }
    if (input[_PT] != null) {
        entries[_PT] = input[_PT];
    }
    if (input[_EIAMDA] != null) {
        entries[_EIAMDA] = input[_EIAMDA];
    }
    if (input[_DIM] != null) {
        entries[_DIM] = input[_DIM];
    }
    if (input[_EPI] != null) {
        entries[_EPI] = input[_EPI];
    }
    if (input[_PIKMSKI] != null) {
        entries[_PIKMSKI] = input[_PIKMSKI];
    }
    if (input[_PIRP] != null) {
        entries[_PIRP] = input[_PIRP];
    }
    if (input[_CLEC] != null) {
        const memberEntries = se_CloudwatchLogsExportConfiguration(input[_CLEC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `CloudwatchLogsExportConfiguration.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_PF] != null) {
        const memberEntries = se_ProcessorFeatureList(input[_PF], context);
        if (input[_PF]?.length === 0) {
            entries.ProcessorFeatures = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ProcessorFeatures.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_UDPF] != null) {
        entries[_UDPF] = input[_UDPF];
    }
    if (input[_DP] != null) {
        entries[_DP] = input[_DP];
    }
    if (input[_MASa] != null) {
        entries[_MASa] = input[_MASa];
    }
    if (input[_CRR] != null) {
        entries[_CRR] = input[_CRR];
    }
    if (input[_RM] != null) {
        entries[_RM] = input[_RM];
    }
    if (input[_ECOI] != null) {
        entries[_ECOI] = input[_ECOI];
    }
    if (input[_ABRPA] != null) {
        entries[_ABRPA] = input[_ABRPA];
    }
    if (input[_AM] != null) {
        entries[_AM] = input[_AM];
    }
    if (input[_RFAMM] != null) {
        entries[_RFAMM] = input[_RFAMM];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_STto] != null) {
        entries[_STto] = input[_STto];
    }
    if (input[_MMUP] != null) {
        entries[_MMUP] = input[_MMUP];
    }
    if (input[_RMUP] != null) {
        entries[_RMUP] = input[_RMUP];
    }
    if (input[_MUSKKI] != null) {
        entries[_MUSKKI] = input[_MUSKKI];
    }
    if (input[_E] != null) {
        entries[_E] = input[_E];
    }
    if (input[_DLV] != null) {
        entries[_DLV] = input[_DLV];
    }
    if (input[_MT] != null) {
        entries[_MT] = input[_MT];
    }
    return entries;
};
const se_ModifyDBParameterGroupMessage = (input, context) => {
    const entries = {};
    if (input[_DBPGN] != null) {
        entries[_DBPGN] = input[_DBPGN];
    }
    if (input[_Pa] != null) {
        const memberEntries = se_ParametersList(input[_Pa], context);
        if (input[_Pa]?.length === 0) {
            entries.Parameters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Parameters.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ModifyDBProxyEndpointRequest = (input, context) => {
    const entries = {};
    if (input[_DBPEN] != null) {
        entries[_DBPEN] = input[_DBPEN];
    }
    if (input[_NDBPEN] != null) {
        entries[_NDBPEN] = input[_NDBPEN];
    }
    if (input[_VSGI] != null) {
        const memberEntries = se_StringList(input[_VSGI], context);
        if (input[_VSGI]?.length === 0) {
            entries.VpcSecurityGroupIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcSecurityGroupIds.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ModifyDBProxyRequest = (input, context) => {
    const entries = {};
    if (input[_DBPN] != null) {
        entries[_DBPN] = input[_DBPN];
    }
    if (input[_NDBPN] != null) {
        entries[_NDBPN] = input[_NDBPN];
    }
    if (input[_Au] != null) {
        const memberEntries = se_UserAuthConfigList(input[_Au], context);
        if (input[_Au]?.length === 0) {
            entries.Auth = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Auth.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_RTLS] != null) {
        entries[_RTLS] = input[_RTLS];
    }
    if (input[_ICT] != null) {
        entries[_ICT] = input[_ICT];
    }
    if (input[_DL] != null) {
        entries[_DL] = input[_DL];
    }
    if (input[_RA] != null) {
        entries[_RA] = input[_RA];
    }
    if (input[_SG] != null) {
        const memberEntries = se_StringList(input[_SG], context);
        if (input[_SG]?.length === 0) {
            entries.SecurityGroups = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SecurityGroups.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ModifyDBProxyTargetGroupRequest = (input, context) => {
    const entries = {};
    if (input[_TGN] != null) {
        entries[_TGN] = input[_TGN];
    }
    if (input[_DBPN] != null) {
        entries[_DBPN] = input[_DBPN];
    }
    if (input[_CPC] != null) {
        const memberEntries = se_ConnectionPoolConfiguration(input[_CPC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ConnectionPoolConfig.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_NN] != null) {
        entries[_NN] = input[_NN];
    }
    return entries;
};
const se_ModifyDBRecommendationMessage = (input, context) => {
    const entries = {};
    if (input[_RIe] != null) {
        entries[_RIe] = input[_RIe];
    }
    if (input[_L] != null) {
        entries[_L] = input[_L];
    }
    if (input[_St] != null) {
        entries[_St] = input[_St];
    }
    if (input[_RAU] != null) {
        const memberEntries = se_RecommendedActionUpdateList(input[_RAU], context);
        if (input[_RAU]?.length === 0) {
            entries.RecommendedActionUpdates = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `RecommendedActionUpdates.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ModifyDBShardGroupMessage = (input, context) => {
    const entries = {};
    if (input[_DBSGI] != null) {
        entries[_DBSGI] = input[_DBSGI];
    }
    if (input[_MACU] != null) {
        entries[_MACU] = __serializeFloat(input[_MACU]);
    }
    if (input[_MACUi] != null) {
        entries[_MACUi] = __serializeFloat(input[_MACUi]);
    }
    if (input[_CR] != null) {
        entries[_CR] = input[_CR];
    }
    return entries;
};
const se_ModifyDBSnapshotAttributeMessage = (input, context) => {
    const entries = {};
    if (input[_DBSIn] != null) {
        entries[_DBSIn] = input[_DBSIn];
    }
    if (input[_AN] != null) {
        entries[_AN] = input[_AN];
    }
    if (input[_VTA] != null) {
        const memberEntries = se_AttributeValueList(input[_VTA], context);
        if (input[_VTA]?.length === 0) {
            entries.ValuesToAdd = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ValuesToAdd.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_VTR] != null) {
        const memberEntries = se_AttributeValueList(input[_VTR], context);
        if (input[_VTR]?.length === 0) {
            entries.ValuesToRemove = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ValuesToRemove.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ModifyDBSnapshotMessage = (input, context) => {
    const entries = {};
    if (input[_DBSIn] != null) {
        entries[_DBSIn] = input[_DBSIn];
    }
    if (input[_EV] != null) {
        entries[_EV] = input[_EV];
    }
    if (input[_OGN] != null) {
        entries[_OGN] = input[_OGN];
    }
    return entries;
};
const se_ModifyDBSubnetGroupMessage = (input, context) => {
    const entries = {};
    if (input[_DBSGNu] != null) {
        entries[_DBSGNu] = input[_DBSGNu];
    }
    if (input[_DBSGDu] != null) {
        entries[_DBSGDu] = input[_DBSGDu];
    }
    if (input[_SIu] != null) {
        const memberEntries = se_SubnetIdentifierList(input[_SIu], context);
        if (input[_SIu]?.length === 0) {
            entries.SubnetIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SubnetIds.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ModifyEventSubscriptionMessage = (input, context) => {
    const entries = {};
    if (input[_SN] != null) {
        entries[_SN] = input[_SN];
    }
    if (input[_STA] != null) {
        entries[_STA] = input[_STA];
    }
    if (input[_STo] != null) {
        entries[_STo] = input[_STo];
    }
    if (input[_EC] != null) {
        const memberEntries = se_EventCategoriesList(input[_EC], context);
        if (input[_EC]?.length === 0) {
            entries.EventCategories = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `EventCategories.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_En] != null) {
        entries[_En] = input[_En];
    }
    return entries;
};
const se_ModifyGlobalClusterMessage = (input, context) => {
    const entries = {};
    if (input[_GCI] != null) {
        entries[_GCI] = input[_GCI];
    }
    if (input[_NGCI] != null) {
        entries[_NGCI] = input[_NGCI];
    }
    if (input[_DP] != null) {
        entries[_DP] = input[_DP];
    }
    if (input[_EV] != null) {
        entries[_EV] = input[_EV];
    }
    if (input[_AMVUl] != null) {
        entries[_AMVUl] = input[_AMVUl];
    }
    return entries;
};
const se_ModifyIntegrationMessage = (input, context) => {
    const entries = {};
    if (input[_IIn] != null) {
        entries[_IIn] = input[_IIn];
    }
    if (input[_IN] != null) {
        entries[_IN] = input[_IN];
    }
    if (input[_DFa] != null) {
        entries[_DFa] = input[_DFa];
    }
    if (input[_D] != null) {
        entries[_D] = input[_D];
    }
    return entries;
};
const se_ModifyOptionGroupMessage = (input, context) => {
    const entries = {};
    if (input[_OGN] != null) {
        entries[_OGN] = input[_OGN];
    }
    if (input[_OTI] != null) {
        const memberEntries = se_OptionConfigurationList(input[_OTI], context);
        if (input[_OTI]?.length === 0) {
            entries.OptionsToInclude = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `OptionsToInclude.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_OTR] != null) {
        const memberEntries = se_OptionNamesList(input[_OTR], context);
        if (input[_OTR]?.length === 0) {
            entries.OptionsToRemove = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `OptionsToRemove.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_AI] != null) {
        entries[_AI] = input[_AI];
    }
    return entries;
};
const se_ModifyTenantDatabaseMessage = (input, context) => {
    const entries = {};
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_TDBN] != null) {
        entries[_TDBN] = input[_TDBN];
    }
    if (input[_MUP] != null) {
        entries[_MUP] = input[_MUP];
    }
    if (input[_NTDBN] != null) {
        entries[_NTDBN] = input[_NTDBN];
    }
    if (input[_MMUP] != null) {
        entries[_MMUP] = input[_MMUP];
    }
    if (input[_RMUP] != null) {
        entries[_RMUP] = input[_RMUP];
    }
    if (input[_MUSKKI] != null) {
        entries[_MUSKKI] = input[_MUSKKI];
    }
    return entries;
};
const se_OptionConfiguration = (input, context) => {
    const entries = {};
    if (input[_ON] != null) {
        entries[_ON] = input[_ON];
    }
    if (input[_P] != null) {
        entries[_P] = input[_P];
    }
    if (input[_OV] != null) {
        entries[_OV] = input[_OV];
    }
    if (input[_DBSGM] != null) {
        const memberEntries = se_DBSecurityGroupNameList(input[_DBSGM], context);
        if (input[_DBSGM]?.length === 0) {
            entries.DBSecurityGroupMemberships = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DBSecurityGroupMemberships.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_VSGM] != null) {
        const memberEntries = se_VpcSecurityGroupIdList(input[_VSGM], context);
        if (input[_VSGM]?.length === 0) {
            entries.VpcSecurityGroupMemberships = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcSecurityGroupMemberships.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_OS] != null) {
        const memberEntries = se_OptionSettingsList(input[_OS], context);
        if (input[_OS]?.length === 0) {
            entries.OptionSettings = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `OptionSettings.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_OptionConfigurationList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_OptionConfiguration(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`OptionConfiguration.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_OptionNamesList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_OptionSetting = (input, context) => {
    const entries = {};
    if (input[_N] != null) {
        entries[_N] = input[_N];
    }
    if (input[_Val] != null) {
        entries[_Val] = input[_Val];
    }
    if (input[_DV] != null) {
        entries[_DV] = input[_DV];
    }
    if (input[_D] != null) {
        entries[_D] = input[_D];
    }
    if (input[_AT] != null) {
        entries[_AT] = input[_AT];
    }
    if (input[_DTa] != null) {
        entries[_DTa] = input[_DTa];
    }
    if (input[_AV] != null) {
        entries[_AV] = input[_AV];
    }
    if (input[_IM] != null) {
        entries[_IM] = input[_IM];
    }
    if (input[_IC] != null) {
        entries[_IC] = input[_IC];
    }
    return entries;
};
const se_OptionSettingsList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_OptionSetting(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`OptionSetting.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_Parameter = (input, context) => {
    const entries = {};
    if (input[_PN] != null) {
        entries[_PN] = input[_PN];
    }
    if (input[_PV] != null) {
        entries[_PV] = input[_PV];
    }
    if (input[_D] != null) {
        entries[_D] = input[_D];
    }
    if (input[_S] != null) {
        entries[_S] = input[_S];
    }
    if (input[_AT] != null) {
        entries[_AT] = input[_AT];
    }
    if (input[_DTa] != null) {
        entries[_DTa] = input[_DTa];
    }
    if (input[_AV] != null) {
        entries[_AV] = input[_AV];
    }
    if (input[_IM] != null) {
        entries[_IM] = input[_IM];
    }
    if (input[_MEVi] != null) {
        entries[_MEVi] = input[_MEVi];
    }
    if (input[_AMp] != null) {
        entries[_AMp] = input[_AMp];
    }
    if (input[_SEM] != null) {
        const memberEntries = se_EngineModeList(input[_SEM], context);
        if (input[_SEM]?.length === 0) {
            entries.SupportedEngineModes = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `SupportedEngineModes.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ParametersList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_Parameter(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Parameter.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_ProcessorFeature = (input, context) => {
    const entries = {};
    if (input[_N] != null) {
        entries[_N] = input[_N];
    }
    if (input[_Val] != null) {
        entries[_Val] = input[_Val];
    }
    return entries;
};
const se_ProcessorFeatureList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_ProcessorFeature(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`ProcessorFeature.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_PromoteReadReplicaDBClusterMessage = (input, context) => {
    const entries = {};
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    return entries;
};
const se_PromoteReadReplicaMessage = (input, context) => {
    const entries = {};
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_BRP] != null) {
        entries[_BRP] = input[_BRP];
    }
    if (input[_PBW] != null) {
        entries[_PBW] = input[_PBW];
    }
    return entries;
};
const se_PurchaseReservedDBInstancesOfferingMessage = (input, context) => {
    const entries = {};
    if (input[_RDBIOI] != null) {
        entries[_RDBIOI] = input[_RDBIOI];
    }
    if (input[_RDBII] != null) {
        entries[_RDBII] = input[_RDBII];
    }
    if (input[_DBICn] != null) {
        entries[_DBICn] = input[_DBICn];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_RdsCustomClusterConfiguration = (input, context) => {
    const entries = {};
    if (input[_ISI] != null) {
        entries[_ISI] = input[_ISI];
    }
    if (input[_TGMDI] != null) {
        entries[_TGMDI] = input[_TGMDI];
    }
    if (input[_RM] != null) {
        entries[_RM] = input[_RM];
    }
    return entries;
};
const se_RebootDBClusterMessage = (input, context) => {
    const entries = {};
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    return entries;
};
const se_RebootDBInstanceMessage = (input, context) => {
    const entries = {};
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_FF] != null) {
        entries[_FF] = input[_FF];
    }
    return entries;
};
const se_RebootDBShardGroupMessage = (input, context) => {
    const entries = {};
    if (input[_DBSGI] != null) {
        entries[_DBSGI] = input[_DBSGI];
    }
    return entries;
};
const se_RecommendedActionUpdate = (input, context) => {
    const entries = {};
    if (input[_AIc] != null) {
        entries[_AIc] = input[_AIc];
    }
    if (input[_St] != null) {
        entries[_St] = input[_St];
    }
    return entries;
};
const se_RecommendedActionUpdateList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_RecommendedActionUpdate(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`member.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_RegisterDBProxyTargetsRequest = (input, context) => {
    const entries = {};
    if (input[_DBPN] != null) {
        entries[_DBPN] = input[_DBPN];
    }
    if (input[_TGN] != null) {
        entries[_TGN] = input[_TGN];
    }
    if (input[_DBIIn] != null) {
        const memberEntries = se_StringList(input[_DBIIn], context);
        if (input[_DBIIn]?.length === 0) {
            entries.DBInstanceIdentifiers = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DBInstanceIdentifiers.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DBCIl] != null) {
        const memberEntries = se_StringList(input[_DBCIl], context);
        if (input[_DBCIl]?.length === 0) {
            entries.DBClusterIdentifiers = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DBClusterIdentifiers.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_RemoveFromGlobalClusterMessage = (input, context) => {
    const entries = {};
    if (input[_GCI] != null) {
        entries[_GCI] = input[_GCI];
    }
    if (input[_DCI] != null) {
        entries[_DCI] = input[_DCI];
    }
    return entries;
};
const se_RemoveRoleFromDBClusterMessage = (input, context) => {
    const entries = {};
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    if (input[_RA] != null) {
        entries[_RA] = input[_RA];
    }
    if (input[_FN] != null) {
        entries[_FN] = input[_FN];
    }
    return entries;
};
const se_RemoveRoleFromDBInstanceMessage = (input, context) => {
    const entries = {};
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_RA] != null) {
        entries[_RA] = input[_RA];
    }
    if (input[_FN] != null) {
        entries[_FN] = input[_FN];
    }
    return entries;
};
const se_RemoveSourceIdentifierFromSubscriptionMessage = (input, context) => {
    const entries = {};
    if (input[_SN] != null) {
        entries[_SN] = input[_SN];
    }
    if (input[_SI] != null) {
        entries[_SI] = input[_SI];
    }
    return entries;
};
const se_RemoveTagsFromResourceMessage = (input, context) => {
    const entries = {};
    if (input[_RN] != null) {
        entries[_RN] = input[_RN];
    }
    if (input[_TK] != null) {
        const memberEntries = se_KeyList(input[_TK], context);
        if (input[_TK]?.length === 0) {
            entries.TagKeys = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `TagKeys.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ResetDBClusterParameterGroupMessage = (input, context) => {
    const entries = {};
    if (input[_DBCPGN] != null) {
        entries[_DBCPGN] = input[_DBCPGN];
    }
    if (input[_RAP] != null) {
        entries[_RAP] = input[_RAP];
    }
    if (input[_Pa] != null) {
        const memberEntries = se_ParametersList(input[_Pa], context);
        if (input[_Pa]?.length === 0) {
            entries.Parameters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Parameters.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_ResetDBParameterGroupMessage = (input, context) => {
    const entries = {};
    if (input[_DBPGN] != null) {
        entries[_DBPGN] = input[_DBPGN];
    }
    if (input[_RAP] != null) {
        entries[_RAP] = input[_RAP];
    }
    if (input[_Pa] != null) {
        const memberEntries = se_ParametersList(input[_Pa], context);
        if (input[_Pa]?.length === 0) {
            entries.Parameters = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Parameters.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_RestoreDBClusterFromS3Message = (input, context) => {
    const entries = {};
    if (input[_AZ] != null) {
        const memberEntries = se_AvailabilityZones(input[_AZ], context);
        if (input[_AZ]?.length === 0) {
            entries.AvailabilityZones = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AvailabilityZones.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_BRP] != null) {
        entries[_BRP] = input[_BRP];
    }
    if (input[_CSN] != null) {
        entries[_CSN] = input[_CSN];
    }
    if (input[_DN] != null) {
        entries[_DN] = input[_DN];
    }
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    if (input[_DBCPGN] != null) {
        entries[_DBCPGN] = input[_DBCPGN];
    }
    if (input[_VSGI] != null) {
        const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
        if (input[_VSGI]?.length === 0) {
            entries.VpcSecurityGroupIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcSecurityGroupIds.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DBSGNu] != null) {
        entries[_DBSGNu] = input[_DBSGNu];
    }
    if (input[_E] != null) {
        entries[_E] = input[_E];
    }
    if (input[_EV] != null) {
        entries[_EV] = input[_EV];
    }
    if (input[_P] != null) {
        entries[_P] = input[_P];
    }
    if (input[_MU] != null) {
        entries[_MU] = input[_MU];
    }
    if (input[_MUP] != null) {
        entries[_MUP] = input[_MUP];
    }
    if (input[_OGN] != null) {
        entries[_OGN] = input[_OGN];
    }
    if (input[_PBW] != null) {
        entries[_PBW] = input[_PBW];
    }
    if (input[_PMW] != null) {
        entries[_PMW] = input[_PMW];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_SE] != null) {
        entries[_SE] = input[_SE];
    }
    if (input[_KKI] != null) {
        entries[_KKI] = input[_KKI];
    }
    if (input[_EIAMDA] != null) {
        entries[_EIAMDA] = input[_EIAMDA];
    }
    if (input[_SEo] != null) {
        entries[_SEo] = input[_SEo];
    }
    if (input[_SEV] != null) {
        entries[_SEV] = input[_SEV];
    }
    if (input[_SBN] != null) {
        entries[_SBN] = input[_SBN];
    }
    if (input[_SP] != null) {
        entries[_SP] = input[_SP];
    }
    if (input[_SIRA] != null) {
        entries[_SIRA] = input[_SIRA];
    }
    if (input[_BW] != null) {
        entries[_BW] = input[_BW];
    }
    if (input[_ECLE] != null) {
        const memberEntries = se_LogTypeList(input[_ECLE], context);
        if (input[_ECLE]?.length === 0) {
            entries.EnableCloudwatchLogsExports = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `EnableCloudwatchLogsExports.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DP] != null) {
        entries[_DP] = input[_DP];
    }
    if (input[_CTTS] != null) {
        entries[_CTTS] = input[_CTTS];
    }
    if (input[_Do] != null) {
        entries[_Do] = input[_Do];
    }
    if (input[_DIAMRN] != null) {
        entries[_DIAMRN] = input[_DIAMRN];
    }
    if (input[_SVSC] != null) {
        const memberEntries = se_ServerlessV2ScalingConfiguration(input[_SVSC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ServerlessV2ScalingConfiguration.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_MMUP] != null) {
        entries[_MMUP] = input[_MMUP];
    }
    if (input[_MUSKKI] != null) {
        entries[_MUSKKI] = input[_MUSKKI];
    }
    if (input[_STt] != null) {
        entries[_STt] = input[_STt];
    }
    if (input[_ELS] != null) {
        entries[_ELS] = input[_ELS];
    }
    return entries;
};
const se_RestoreDBClusterFromSnapshotMessage = (input, context) => {
    const entries = {};
    if (input[_AZ] != null) {
        const memberEntries = se_AvailabilityZones(input[_AZ], context);
        if (input[_AZ]?.length === 0) {
            entries.AvailabilityZones = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `AvailabilityZones.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    if (input[_SIn] != null) {
        entries[_SIn] = input[_SIn];
    }
    if (input[_E] != null) {
        entries[_E] = input[_E];
    }
    if (input[_EV] != null) {
        entries[_EV] = input[_EV];
    }
    if (input[_P] != null) {
        entries[_P] = input[_P];
    }
    if (input[_DBSGNu] != null) {
        entries[_DBSGNu] = input[_DBSGNu];
    }
    if (input[_DN] != null) {
        entries[_DN] = input[_DN];
    }
    if (input[_OGN] != null) {
        entries[_OGN] = input[_OGN];
    }
    if (input[_VSGI] != null) {
        const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
        if (input[_VSGI]?.length === 0) {
            entries.VpcSecurityGroupIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcSecurityGroupIds.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_KKI] != null) {
        entries[_KKI] = input[_KKI];
    }
    if (input[_EIAMDA] != null) {
        entries[_EIAMDA] = input[_EIAMDA];
    }
    if (input[_BW] != null) {
        entries[_BW] = input[_BW];
    }
    if (input[_ECLE] != null) {
        const memberEntries = se_LogTypeList(input[_ECLE], context);
        if (input[_ECLE]?.length === 0) {
            entries.EnableCloudwatchLogsExports = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `EnableCloudwatchLogsExports.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_EMn] != null) {
        entries[_EMn] = input[_EMn];
    }
    if (input[_SC] != null) {
        const memberEntries = se_ScalingConfiguration(input[_SC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ScalingConfiguration.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DBCPGN] != null) {
        entries[_DBCPGN] = input[_DBCPGN];
    }
    if (input[_DP] != null) {
        entries[_DP] = input[_DP];
    }
    if (input[_CTTS] != null) {
        entries[_CTTS] = input[_CTTS];
    }
    if (input[_Do] != null) {
        entries[_Do] = input[_Do];
    }
    if (input[_DIAMRN] != null) {
        entries[_DIAMRN] = input[_DIAMRN];
    }
    if (input[_DBCIC] != null) {
        entries[_DBCIC] = input[_DBCIC];
    }
    if (input[_STt] != null) {
        entries[_STt] = input[_STt];
    }
    if (input[_I] != null) {
        entries[_I] = input[_I];
    }
    if (input[_PA] != null) {
        entries[_PA] = input[_PA];
    }
    if (input[_SVSC] != null) {
        const memberEntries = se_ServerlessV2ScalingConfiguration(input[_SVSC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ServerlessV2ScalingConfiguration.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_RCCC] != null) {
        const memberEntries = se_RdsCustomClusterConfiguration(input[_RCCC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `RdsCustomClusterConfiguration.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MIo] != null) {
        entries[_MIo] = input[_MIo];
    }
    if (input[_MRA] != null) {
        entries[_MRA] = input[_MRA];
    }
    if (input[_EPI] != null) {
        entries[_EPI] = input[_EPI];
    }
    if (input[_PIKMSKI] != null) {
        entries[_PIKMSKI] = input[_PIKMSKI];
    }
    if (input[_PIRP] != null) {
        entries[_PIRP] = input[_PIRP];
    }
    if (input[_ELS] != null) {
        entries[_ELS] = input[_ELS];
    }
    return entries;
};
const se_RestoreDBClusterToPointInTimeMessage = (input, context) => {
    const entries = {};
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    if (input[_RT] != null) {
        entries[_RT] = input[_RT];
    }
    if (input[_SDBCI] != null) {
        entries[_SDBCI] = input[_SDBCI];
    }
    if (input[_RTT] != null) {
        entries[_RTT] = __serializeDateTime(input[_RTT]);
    }
    if (input[_ULRT] != null) {
        entries[_ULRT] = input[_ULRT];
    }
    if (input[_P] != null) {
        entries[_P] = input[_P];
    }
    if (input[_DBSGNu] != null) {
        entries[_DBSGNu] = input[_DBSGNu];
    }
    if (input[_OGN] != null) {
        entries[_OGN] = input[_OGN];
    }
    if (input[_VSGI] != null) {
        const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
        if (input[_VSGI]?.length === 0) {
            entries.VpcSecurityGroupIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcSecurityGroupIds.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_KKI] != null) {
        entries[_KKI] = input[_KKI];
    }
    if (input[_EIAMDA] != null) {
        entries[_EIAMDA] = input[_EIAMDA];
    }
    if (input[_BW] != null) {
        entries[_BW] = input[_BW];
    }
    if (input[_ECLE] != null) {
        const memberEntries = se_LogTypeList(input[_ECLE], context);
        if (input[_ECLE]?.length === 0) {
            entries.EnableCloudwatchLogsExports = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `EnableCloudwatchLogsExports.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_DBCPGN] != null) {
        entries[_DBCPGN] = input[_DBCPGN];
    }
    if (input[_DP] != null) {
        entries[_DP] = input[_DP];
    }
    if (input[_CTTS] != null) {
        entries[_CTTS] = input[_CTTS];
    }
    if (input[_Do] != null) {
        entries[_Do] = input[_Do];
    }
    if (input[_DIAMRN] != null) {
        entries[_DIAMRN] = input[_DIAMRN];
    }
    if (input[_SC] != null) {
        const memberEntries = se_ScalingConfiguration(input[_SC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ScalingConfiguration.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_EMn] != null) {
        entries[_EMn] = input[_EMn];
    }
    if (input[_DBCIC] != null) {
        entries[_DBCIC] = input[_DBCIC];
    }
    if (input[_STt] != null) {
        entries[_STt] = input[_STt];
    }
    if (input[_PA] != null) {
        entries[_PA] = input[_PA];
    }
    if (input[_I] != null) {
        entries[_I] = input[_I];
    }
    if (input[_SVSC] != null) {
        const memberEntries = se_ServerlessV2ScalingConfiguration(input[_SVSC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ServerlessV2ScalingConfiguration.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_SDCRI] != null) {
        entries[_SDCRI] = input[_SDCRI];
    }
    if (input[_RCCC] != null) {
        const memberEntries = se_RdsCustomClusterConfiguration(input[_RCCC], context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `RdsCustomClusterConfiguration.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_MIo] != null) {
        entries[_MIo] = input[_MIo];
    }
    if (input[_MRA] != null) {
        entries[_MRA] = input[_MRA];
    }
    if (input[_EPI] != null) {
        entries[_EPI] = input[_EPI];
    }
    if (input[_PIKMSKI] != null) {
        entries[_PIKMSKI] = input[_PIKMSKI];
    }
    if (input[_PIRP] != null) {
        entries[_PIRP] = input[_PIRP];
    }
    if (input[_ELS] != null) {
        entries[_ELS] = input[_ELS];
    }
    return entries;
};
const se_RestoreDBInstanceFromDBSnapshotMessage = (input, context) => {
    const entries = {};
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_DBSIn] != null) {
        entries[_DBSIn] = input[_DBSIn];
    }
    if (input[_DBIC] != null) {
        entries[_DBIC] = input[_DBIC];
    }
    if (input[_P] != null) {
        entries[_P] = input[_P];
    }
    if (input[_AZv] != null) {
        entries[_AZv] = input[_AZv];
    }
    if (input[_DBSGNu] != null) {
        entries[_DBSGNu] = input[_DBSGNu];
    }
    if (input[_MAZ] != null) {
        entries[_MAZ] = input[_MAZ];
    }
    if (input[_PA] != null) {
        entries[_PA] = input[_PA];
    }
    if (input[_AMVU] != null) {
        entries[_AMVU] = input[_AMVU];
    }
    if (input[_LM] != null) {
        entries[_LM] = input[_LM];
    }
    if (input[_DBN] != null) {
        entries[_DBN] = input[_DBN];
    }
    if (input[_E] != null) {
        entries[_E] = input[_E];
    }
    if (input[_I] != null) {
        entries[_I] = input[_I];
    }
    if (input[_OGN] != null) {
        entries[_OGN] = input[_OGN];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_STt] != null) {
        entries[_STt] = input[_STt];
    }
    if (input[_TCA] != null) {
        entries[_TCA] = input[_TCA];
    }
    if (input[_TCP] != null) {
        entries[_TCP] = input[_TCP];
    }
    if (input[_VSGI] != null) {
        const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
        if (input[_VSGI]?.length === 0) {
            entries.VpcSecurityGroupIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcSecurityGroupIds.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_Do] != null) {
        entries[_Do] = input[_Do];
    }
    if (input[_DF] != null) {
        entries[_DF] = input[_DF];
    }
    if (input[_DO] != null) {
        entries[_DO] = input[_DO];
    }
    if (input[_DASA] != null) {
        entries[_DASA] = input[_DASA];
    }
    if (input[_DDI] != null) {
        const memberEntries = se_StringList(input[_DDI], context);
        if (input[_DDI]?.length === 0) {
            entries.DomainDnsIps = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DomainDnsIps.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_CTTS] != null) {
        entries[_CTTS] = input[_CTTS];
    }
    if (input[_DIAMRN] != null) {
        entries[_DIAMRN] = input[_DIAMRN];
    }
    if (input[_EIAMDA] != null) {
        entries[_EIAMDA] = input[_EIAMDA];
    }
    if (input[_ECLE] != null) {
        const memberEntries = se_LogTypeList(input[_ECLE], context);
        if (input[_ECLE]?.length === 0) {
            entries.EnableCloudwatchLogsExports = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `EnableCloudwatchLogsExports.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_PF] != null) {
        const memberEntries = se_ProcessorFeatureList(input[_PF], context);
        if (input[_PF]?.length === 0) {
            entries.ProcessorFeatures = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ProcessorFeatures.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_UDPF] != null) {
        entries[_UDPF] = input[_UDPF];
    }
    if (input[_DBPGN] != null) {
        entries[_DBPGN] = input[_DBPGN];
    }
    if (input[_DP] != null) {
        entries[_DP] = input[_DP];
    }
    if (input[_ECOI] != null) {
        entries[_ECOI] = input[_ECOI];
    }
    if (input[_CIIP] != null) {
        entries[_CIIP] = input[_CIIP];
    }
    if (input[_BTa] != null) {
        entries[_BTa] = input[_BTa];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_STto] != null) {
        entries[_STto] = input[_STto];
    }
    if (input[_DBCSI] != null) {
        entries[_DBCSI] = input[_DBCSI];
    }
    if (input[_AS] != null) {
        entries[_AS] = input[_AS];
    }
    if (input[_DLV] != null) {
        entries[_DLV] = input[_DLV];
    }
    if (input[_CACI] != null) {
        entries[_CACI] = input[_CACI];
    }
    if (input[_ELS] != null) {
        entries[_ELS] = input[_ELS];
    }
    if (input[_MMUP] != null) {
        entries[_MMUP] = input[_MMUP];
    }
    if (input[_MUSKKI] != null) {
        entries[_MUSKKI] = input[_MUSKKI];
    }
    return entries;
};
const se_RestoreDBInstanceFromS3Message = (input, context) => {
    const entries = {};
    if (input[_DBN] != null) {
        entries[_DBN] = input[_DBN];
    }
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_AS] != null) {
        entries[_AS] = input[_AS];
    }
    if (input[_DBIC] != null) {
        entries[_DBIC] = input[_DBIC];
    }
    if (input[_E] != null) {
        entries[_E] = input[_E];
    }
    if (input[_MU] != null) {
        entries[_MU] = input[_MU];
    }
    if (input[_MUP] != null) {
        entries[_MUP] = input[_MUP];
    }
    if (input[_DBSG] != null) {
        const memberEntries = se_DBSecurityGroupNameList(input[_DBSG], context);
        if (input[_DBSG]?.length === 0) {
            entries.DBSecurityGroups = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DBSecurityGroups.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_VSGI] != null) {
        const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
        if (input[_VSGI]?.length === 0) {
            entries.VpcSecurityGroupIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcSecurityGroupIds.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_AZv] != null) {
        entries[_AZv] = input[_AZv];
    }
    if (input[_DBSGNu] != null) {
        entries[_DBSGNu] = input[_DBSGNu];
    }
    if (input[_PMW] != null) {
        entries[_PMW] = input[_PMW];
    }
    if (input[_DBPGN] != null) {
        entries[_DBPGN] = input[_DBPGN];
    }
    if (input[_BRP] != null) {
        entries[_BRP] = input[_BRP];
    }
    if (input[_PBW] != null) {
        entries[_PBW] = input[_PBW];
    }
    if (input[_P] != null) {
        entries[_P] = input[_P];
    }
    if (input[_MAZ] != null) {
        entries[_MAZ] = input[_MAZ];
    }
    if (input[_EV] != null) {
        entries[_EV] = input[_EV];
    }
    if (input[_AMVU] != null) {
        entries[_AMVU] = input[_AMVU];
    }
    if (input[_LM] != null) {
        entries[_LM] = input[_LM];
    }
    if (input[_I] != null) {
        entries[_I] = input[_I];
    }
    if (input[_OGN] != null) {
        entries[_OGN] = input[_OGN];
    }
    if (input[_PA] != null) {
        entries[_PA] = input[_PA];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_STt] != null) {
        entries[_STt] = input[_STt];
    }
    if (input[_SE] != null) {
        entries[_SE] = input[_SE];
    }
    if (input[_KKI] != null) {
        entries[_KKI] = input[_KKI];
    }
    if (input[_CTTS] != null) {
        entries[_CTTS] = input[_CTTS];
    }
    if (input[_MIo] != null) {
        entries[_MIo] = input[_MIo];
    }
    if (input[_MRA] != null) {
        entries[_MRA] = input[_MRA];
    }
    if (input[_EIAMDA] != null) {
        entries[_EIAMDA] = input[_EIAMDA];
    }
    if (input[_SEo] != null) {
        entries[_SEo] = input[_SEo];
    }
    if (input[_SEV] != null) {
        entries[_SEV] = input[_SEV];
    }
    if (input[_SBN] != null) {
        entries[_SBN] = input[_SBN];
    }
    if (input[_SP] != null) {
        entries[_SP] = input[_SP];
    }
    if (input[_SIRA] != null) {
        entries[_SIRA] = input[_SIRA];
    }
    if (input[_DIM] != null) {
        entries[_DIM] = input[_DIM];
    }
    if (input[_EPI] != null) {
        entries[_EPI] = input[_EPI];
    }
    if (input[_PIKMSKI] != null) {
        entries[_PIKMSKI] = input[_PIKMSKI];
    }
    if (input[_PIRP] != null) {
        entries[_PIRP] = input[_PIRP];
    }
    if (input[_ECLE] != null) {
        const memberEntries = se_LogTypeList(input[_ECLE], context);
        if (input[_ECLE]?.length === 0) {
            entries.EnableCloudwatchLogsExports = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `EnableCloudwatchLogsExports.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_PF] != null) {
        const memberEntries = se_ProcessorFeatureList(input[_PF], context);
        if (input[_PF]?.length === 0) {
            entries.ProcessorFeatures = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ProcessorFeatures.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_UDPF] != null) {
        entries[_UDPF] = input[_UDPF];
    }
    if (input[_DP] != null) {
        entries[_DP] = input[_DP];
    }
    if (input[_MASa] != null) {
        entries[_MASa] = input[_MASa];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_STto] != null) {
        entries[_STto] = input[_STto];
    }
    if (input[_MMUP] != null) {
        entries[_MMUP] = input[_MMUP];
    }
    if (input[_MUSKKI] != null) {
        entries[_MUSKKI] = input[_MUSKKI];
    }
    if (input[_DLV] != null) {
        entries[_DLV] = input[_DLV];
    }
    if (input[_CACI] != null) {
        entries[_CACI] = input[_CACI];
    }
    if (input[_ELS] != null) {
        entries[_ELS] = input[_ELS];
    }
    return entries;
};
const se_RestoreDBInstanceToPointInTimeMessage = (input, context) => {
    const entries = {};
    if (input[_SDBII] != null) {
        entries[_SDBII] = input[_SDBII];
    }
    if (input[_TDBII] != null) {
        entries[_TDBII] = input[_TDBII];
    }
    if (input[_RTe] != null) {
        entries[_RTe] = __serializeDateTime(input[_RTe]);
    }
    if (input[_ULRT] != null) {
        entries[_ULRT] = input[_ULRT];
    }
    if (input[_DBIC] != null) {
        entries[_DBIC] = input[_DBIC];
    }
    if (input[_P] != null) {
        entries[_P] = input[_P];
    }
    if (input[_AZv] != null) {
        entries[_AZv] = input[_AZv];
    }
    if (input[_DBSGNu] != null) {
        entries[_DBSGNu] = input[_DBSGNu];
    }
    if (input[_MAZ] != null) {
        entries[_MAZ] = input[_MAZ];
    }
    if (input[_PA] != null) {
        entries[_PA] = input[_PA];
    }
    if (input[_AMVU] != null) {
        entries[_AMVU] = input[_AMVU];
    }
    if (input[_LM] != null) {
        entries[_LM] = input[_LM];
    }
    if (input[_DBN] != null) {
        entries[_DBN] = input[_DBN];
    }
    if (input[_E] != null) {
        entries[_E] = input[_E];
    }
    if (input[_I] != null) {
        entries[_I] = input[_I];
    }
    if (input[_OGN] != null) {
        entries[_OGN] = input[_OGN];
    }
    if (input[_CTTS] != null) {
        entries[_CTTS] = input[_CTTS];
    }
    if (input[_T] != null) {
        const memberEntries = se_TagList(input[_T], context);
        if (input[_T]?.length === 0) {
            entries.Tags = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `Tags.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_STt] != null) {
        entries[_STt] = input[_STt];
    }
    if (input[_TCA] != null) {
        entries[_TCA] = input[_TCA];
    }
    if (input[_TCP] != null) {
        entries[_TCP] = input[_TCP];
    }
    if (input[_VSGI] != null) {
        const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
        if (input[_VSGI]?.length === 0) {
            entries.VpcSecurityGroupIds = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `VpcSecurityGroupIds.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_Do] != null) {
        entries[_Do] = input[_Do];
    }
    if (input[_DIAMRN] != null) {
        entries[_DIAMRN] = input[_DIAMRN];
    }
    if (input[_DF] != null) {
        entries[_DF] = input[_DF];
    }
    if (input[_DO] != null) {
        entries[_DO] = input[_DO];
    }
    if (input[_DASA] != null) {
        entries[_DASA] = input[_DASA];
    }
    if (input[_DDI] != null) {
        const memberEntries = se_StringList(input[_DDI], context);
        if (input[_DDI]?.length === 0) {
            entries.DomainDnsIps = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `DomainDnsIps.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_EIAMDA] != null) {
        entries[_EIAMDA] = input[_EIAMDA];
    }
    if (input[_ECLE] != null) {
        const memberEntries = se_LogTypeList(input[_ECLE], context);
        if (input[_ECLE]?.length === 0) {
            entries.EnableCloudwatchLogsExports = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `EnableCloudwatchLogsExports.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_PF] != null) {
        const memberEntries = se_ProcessorFeatureList(input[_PF], context);
        if (input[_PF]?.length === 0) {
            entries.ProcessorFeatures = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ProcessorFeatures.${key}`;
            entries[loc] = value;
        });
    }
    if (input[_UDPF] != null) {
        entries[_UDPF] = input[_UDPF];
    }
    if (input[_DBPGN] != null) {
        entries[_DBPGN] = input[_DBPGN];
    }
    if (input[_DP] != null) {
        entries[_DP] = input[_DP];
    }
    if (input[_SDRI] != null) {
        entries[_SDRI] = input[_SDRI];
    }
    if (input[_MASa] != null) {
        entries[_MASa] = input[_MASa];
    }
    if (input[_SDBIABA] != null) {
        entries[_SDBIABA] = input[_SDBIABA];
    }
    if (input[_ECOI] != null) {
        entries[_ECOI] = input[_ECOI];
    }
    if (input[_CIIP] != null) {
        entries[_CIIP] = input[_CIIP];
    }
    if (input[_BTa] != null) {
        entries[_BTa] = input[_BTa];
    }
    if (input[_NT] != null) {
        entries[_NT] = input[_NT];
    }
    if (input[_STto] != null) {
        entries[_STto] = input[_STto];
    }
    if (input[_AS] != null) {
        entries[_AS] = input[_AS];
    }
    if (input[_DLV] != null) {
        entries[_DLV] = input[_DLV];
    }
    if (input[_CACI] != null) {
        entries[_CACI] = input[_CACI];
    }
    if (input[_ELS] != null) {
        entries[_ELS] = input[_ELS];
    }
    if (input[_MMUP] != null) {
        entries[_MMUP] = input[_MMUP];
    }
    if (input[_MUSKKI] != null) {
        entries[_MUSKKI] = input[_MUSKKI];
    }
    return entries;
};
const se_RevokeDBSecurityGroupIngressMessage = (input, context) => {
    const entries = {};
    if (input[_DBSGN] != null) {
        entries[_DBSGN] = input[_DBSGN];
    }
    if (input[_CIDRIP] != null) {
        entries[_CIDRIP] = input[_CIDRIP];
    }
    if (input[_ECSGN] != null) {
        entries[_ECSGN] = input[_ECSGN];
    }
    if (input[_ECSGI] != null) {
        entries[_ECSGI] = input[_ECSGI];
    }
    if (input[_ECSGOI] != null) {
        entries[_ECSGOI] = input[_ECSGOI];
    }
    return entries;
};
const se_ScalingConfiguration = (input, context) => {
    const entries = {};
    if (input[_MCi] != null) {
        entries[_MCi] = input[_MCi];
    }
    if (input[_MCa] != null) {
        entries[_MCa] = input[_MCa];
    }
    if (input[_AP] != null) {
        entries[_AP] = input[_AP];
    }
    if (input[_SUAP] != null) {
        entries[_SUAP] = input[_SUAP];
    }
    if (input[_TAi] != null) {
        entries[_TAi] = input[_TAi];
    }
    if (input[_SBT] != null) {
        entries[_SBT] = input[_SBT];
    }
    return entries;
};
const se_ServerlessV2ScalingConfiguration = (input, context) => {
    const entries = {};
    if (input[_MCi] != null) {
        entries[_MCi] = __serializeFloat(input[_MCi]);
    }
    if (input[_MCa] != null) {
        entries[_MCa] = __serializeFloat(input[_MCa]);
    }
    if (input[_SUAP] != null) {
        entries[_SUAP] = input[_SUAP];
    }
    return entries;
};
const se_SourceIdsList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`SourceId.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_StartActivityStreamRequest = (input, context) => {
    const entries = {};
    if (input[_RAe] != null) {
        entries[_RAe] = input[_RAe];
    }
    if (input[_Mo] != null) {
        entries[_Mo] = input[_Mo];
    }
    if (input[_KKI] != null) {
        entries[_KKI] = input[_KKI];
    }
    if (input[_AI] != null) {
        entries[_AI] = input[_AI];
    }
    if (input[_ENAFI] != null) {
        entries[_ENAFI] = input[_ENAFI];
    }
    return entries;
};
const se_StartDBClusterMessage = (input, context) => {
    const entries = {};
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    return entries;
};
const se_StartDBInstanceAutomatedBackupsReplicationMessage = (input, context) => {
    const entries = {};
    if (input[_SDBIA] != null) {
        entries[_SDBIA] = input[_SDBIA];
    }
    if (input[_BRP] != null) {
        entries[_BRP] = input[_BRP];
    }
    if (input[_KKI] != null) {
        entries[_KKI] = input[_KKI];
    }
    if (input[_PSU] != null) {
        entries[_PSU] = input[_PSU];
    }
    return entries;
};
const se_StartDBInstanceMessage = (input, context) => {
    const entries = {};
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    return entries;
};
const se_StartExportTaskMessage = (input, context) => {
    const entries = {};
    if (input[_ETI] != null) {
        entries[_ETI] = input[_ETI];
    }
    if (input[_SA] != null) {
        entries[_SA] = input[_SA];
    }
    if (input[_SBN] != null) {
        entries[_SBN] = input[_SBN];
    }
    if (input[_IRA] != null) {
        entries[_IRA] = input[_IRA];
    }
    if (input[_KKI] != null) {
        entries[_KKI] = input[_KKI];
    }
    if (input[_SP] != null) {
        entries[_SP] = input[_SP];
    }
    if (input[_EO] != null) {
        const memberEntries = se_StringList(input[_EO], context);
        if (input[_EO]?.length === 0) {
            entries.ExportOnly = [];
        }
        Object.entries(memberEntries).forEach(([key, value]) => {
            const loc = `ExportOnly.${key}`;
            entries[loc] = value;
        });
    }
    return entries;
};
const se_StopActivityStreamRequest = (input, context) => {
    const entries = {};
    if (input[_RAe] != null) {
        entries[_RAe] = input[_RAe];
    }
    if (input[_AI] != null) {
        entries[_AI] = input[_AI];
    }
    return entries;
};
const se_StopDBClusterMessage = (input, context) => {
    const entries = {};
    if (input[_DBCI] != null) {
        entries[_DBCI] = input[_DBCI];
    }
    return entries;
};
const se_StopDBInstanceAutomatedBackupsReplicationMessage = (input, context) => {
    const entries = {};
    if (input[_SDBIA] != null) {
        entries[_SDBIA] = input[_SDBIA];
    }
    return entries;
};
const se_StopDBInstanceMessage = (input, context) => {
    const entries = {};
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    if (input[_DBSIn] != null) {
        entries[_DBSIn] = input[_DBSIn];
    }
    return entries;
};
const se_StringList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`member.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_SubnetIdentifierList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`SubnetIdentifier.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const se_SwitchoverBlueGreenDeploymentRequest = (input, context) => {
    const entries = {};
    if (input[_BGDI] != null) {
        entries[_BGDI] = input[_BGDI];
    }
    if (input[_STw] != null) {
        entries[_STw] = input[_STw];
    }
    return entries;
};
const se_SwitchoverGlobalClusterMessage = (input, context) => {
    const entries = {};
    if (input[_GCI] != null) {
        entries[_GCI] = input[_GCI];
    }
    if (input[_TDCI] != null) {
        entries[_TDCI] = input[_TDCI];
    }
    return entries;
};
const se_SwitchoverReadReplicaMessage = (input, context) => {
    const entries = {};
    if (input[_DBII] != null) {
        entries[_DBII] = input[_DBII];
    }
    return entries;
};
const se_Tag = (input, context) => {
    const entries = {};
    if (input[_K] != null) {
        entries[_K] = input[_K];
    }
    if (input[_Val] != null) {
        entries[_Val] = input[_Val];
    }
    return entries;
};
const se_TagList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_Tag(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`Tag.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_UserAuthConfig = (input, context) => {
    const entries = {};
    if (input[_D] != null) {
        entries[_D] = input[_D];
    }
    if (input[_UN] != null) {
        entries[_UN] = input[_UN];
    }
    if (input[_ASu] != null) {
        entries[_ASu] = input[_ASu];
    }
    if (input[_SAe] != null) {
        entries[_SAe] = input[_SAe];
    }
    if (input[_IAMA] != null) {
        entries[_IAMA] = input[_IAMA];
    }
    if (input[_CPAT] != null) {
        entries[_CPAT] = input[_CPAT];
    }
    return entries;
};
const se_UserAuthConfigList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        const memberEntries = se_UserAuthConfig(entry, context);
        Object.entries(memberEntries).forEach(([key, value]) => {
            entries[`member.${counter}.${key}`] = value;
        });
        counter++;
    }
    return entries;
};
const se_VpcSecurityGroupIdList = (input, context) => {
    const entries = {};
    let counter = 1;
    for (const entry of input) {
        if (entry === null) {
            continue;
        }
        entries[`VpcSecurityGroupId.${counter}`] = entry;
        counter++;
    }
    return entries;
};
const de_AccountAttributesMessage = (output, context) => {
    const contents = {};
    if (output.AccountQuotas === "") {
        contents[_AQ] = [];
    }
    else if (output[_AQ] != null && output[_AQ][_AQc] != null) {
        contents[_AQ] = de_AccountQuotaList(__getArrayIfSingleItem(output[_AQ][_AQc]), context);
    }
    return contents;
};
const de_AccountQuota = (output, context) => {
    const contents = {};
    if (output[_AQN] != null) {
        contents[_AQN] = __expectString(output[_AQN]);
    }
    if (output[_U] != null) {
        contents[_U] = __strictParseLong(output[_U]);
    }
    if (output[_Max] != null) {
        contents[_Max] = __strictParseLong(output[_Max]);
    }
    return contents;
};
const de_AccountQuotaList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_AccountQuota(entry, context);
    });
};
const de_ActivityStreamModeList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_AddSourceIdentifierToSubscriptionResult = (output, context) => {
    const contents = {};
    if (output[_ES] != null) {
        contents[_ES] = de_EventSubscription(output[_ES], context);
    }
    return contents;
};
const de_ApplyPendingMaintenanceActionResult = (output, context) => {
    const contents = {};
    if (output[_RPMA] != null) {
        contents[_RPMA] = de_ResourcePendingMaintenanceActions(output[_RPMA], context);
    }
    return contents;
};
const de_AttributeValueList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_AuthorizationAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_AuthorizationNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_AuthorizationQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_AuthorizeDBSecurityGroupIngressResult = (output, context) => {
    const contents = {};
    if (output[_DBSGe] != null) {
        contents[_DBSGe] = de_DBSecurityGroup(output[_DBSGe], context);
    }
    return contents;
};
const de_AvailabilityZone = (output, context) => {
    const contents = {};
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    return contents;
};
const de_AvailabilityZoneList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_AvailabilityZone(entry, context);
    });
};
const de_AvailabilityZones = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_AvailableProcessorFeature = (output, context) => {
    const contents = {};
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_DV] != null) {
        contents[_DV] = __expectString(output[_DV]);
    }
    if (output[_AV] != null) {
        contents[_AV] = __expectString(output[_AV]);
    }
    return contents;
};
const de_AvailableProcessorFeatureList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_AvailableProcessorFeature(entry, context);
    });
};
const de_BackupPolicyNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_BlueGreenDeployment = (output, context) => {
    const contents = {};
    if (output[_BGDI] != null) {
        contents[_BGDI] = __expectString(output[_BGDI]);
    }
    if (output[_BGDN] != null) {
        contents[_BGDN] = __expectString(output[_BGDN]);
    }
    if (output[_S] != null) {
        contents[_S] = __expectString(output[_S]);
    }
    if (output[_Ta] != null) {
        contents[_Ta] = __expectString(output[_Ta]);
    }
    if (output.SwitchoverDetails === "") {
        contents[_SD] = [];
    }
    else if (output[_SD] != null && output[_SD][_me] != null) {
        contents[_SD] = de_SwitchoverDetailList(__getArrayIfSingleItem(output[_SD][_me]), context);
    }
    if (output.Tasks === "") {
        contents[_Tas] = [];
    }
    else if (output[_Tas] != null && output[_Tas][_me] != null) {
        contents[_Tas] = de_BlueGreenDeploymentTaskList(__getArrayIfSingleItem(output[_Tas][_me]), context);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_SDt] != null) {
        contents[_SDt] = __expectString(output[_SDt]);
    }
    if (output[_CTr] != null) {
        contents[_CTr] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CTr]));
    }
    if (output[_DTe] != null) {
        contents[_DTe] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_DTe]));
    }
    if (output.TagList === "") {
        contents[_TL] = [];
    }
    else if (output[_TL] != null && output[_TL][_Tag] != null) {
        contents[_TL] = de_TagList(__getArrayIfSingleItem(output[_TL][_Tag]), context);
    }
    return contents;
};
const de_BlueGreenDeploymentAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_BlueGreenDeploymentList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_BlueGreenDeployment(entry, context);
    });
};
const de_BlueGreenDeploymentNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_BlueGreenDeploymentTask = (output, context) => {
    const contents = {};
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    return contents;
};
const de_BlueGreenDeploymentTaskList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_BlueGreenDeploymentTask(entry, context);
    });
};
const de_CACertificateIdentifiersList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_Certificate = (output, context) => {
    const contents = {};
    if (output[_CIe] != null) {
        contents[_CIe] = __expectString(output[_CIe]);
    }
    if (output[_CTe] != null) {
        contents[_CTe] = __expectString(output[_CTe]);
    }
    if (output[_Th] != null) {
        contents[_Th] = __expectString(output[_Th]);
    }
    if (output[_VF] != null) {
        contents[_VF] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_VF]));
    }
    if (output[_VT] != null) {
        contents[_VT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_VT]));
    }
    if (output[_CA] != null) {
        contents[_CA] = __expectString(output[_CA]);
    }
    if (output[_CO] != null) {
        contents[_CO] = __parseBoolean(output[_CO]);
    }
    if (output[_COVT] != null) {
        contents[_COVT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_COVT]));
    }
    return contents;
};
const de_CertificateDetails = (output, context) => {
    const contents = {};
    if (output[_CAI] != null) {
        contents[_CAI] = __expectString(output[_CAI]);
    }
    if (output[_VT] != null) {
        contents[_VT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_VT]));
    }
    return contents;
};
const de_CertificateList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Certificate(entry, context);
    });
};
const de_CertificateMessage = (output, context) => {
    const contents = {};
    if (output[_DCFNL] != null) {
        contents[_DCFNL] = __expectString(output[_DCFNL]);
    }
    if (output.Certificates === "") {
        contents[_Ce] = [];
    }
    else if (output[_Ce] != null && output[_Ce][_Cer] != null) {
        contents[_Ce] = de_CertificateList(__getArrayIfSingleItem(output[_Ce][_Cer]), context);
    }
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    return contents;
};
const de_CertificateNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_CharacterSet = (output, context) => {
    const contents = {};
    if (output[_CSN] != null) {
        contents[_CSN] = __expectString(output[_CSN]);
    }
    if (output[_CSD] != null) {
        contents[_CSD] = __expectString(output[_CSD]);
    }
    return contents;
};
const de_ClusterPendingModifiedValues = (output, context) => {
    const contents = {};
    if (output[_PCLE] != null) {
        contents[_PCLE] = de_PendingCloudwatchLogsExports(output[_PCLE], context);
    }
    if (output[_DBCI] != null) {
        contents[_DBCI] = __expectString(output[_DBCI]);
    }
    if (output[_MUP] != null) {
        contents[_MUP] = __expectString(output[_MUP]);
    }
    if (output[_IAMDAE] != null) {
        contents[_IAMDAE] = __parseBoolean(output[_IAMDAE]);
    }
    if (output[_EV] != null) {
        contents[_EV] = __expectString(output[_EV]);
    }
    if (output[_BRP] != null) {
        contents[_BRP] = __strictParseInt32(output[_BRP]);
    }
    if (output[_AS] != null) {
        contents[_AS] = __strictParseInt32(output[_AS]);
    }
    if (output[_RCCC] != null) {
        contents[_RCCC] = de_RdsCustomClusterConfiguration(output[_RCCC], context);
    }
    if (output[_I] != null) {
        contents[_I] = __strictParseInt32(output[_I]);
    }
    if (output[_STt] != null) {
        contents[_STt] = __expectString(output[_STt]);
    }
    if (output[_CD] != null) {
        contents[_CD] = de_CertificateDetails(output[_CD], context);
    }
    return contents;
};
const de_ConnectionPoolConfigurationInfo = (output, context) => {
    const contents = {};
    if (output[_MCP] != null) {
        contents[_MCP] = __strictParseInt32(output[_MCP]);
    }
    if (output[_MICP] != null) {
        contents[_MICP] = __strictParseInt32(output[_MICP]);
    }
    if (output[_CBT] != null) {
        contents[_CBT] = __strictParseInt32(output[_CBT]);
    }
    if (output.SessionPinningFilters === "") {
        contents[_SPF] = [];
    }
    else if (output[_SPF] != null && output[_SPF][_me] != null) {
        contents[_SPF] = de_StringList(__getArrayIfSingleItem(output[_SPF][_me]), context);
    }
    if (output[_IQ] != null) {
        contents[_IQ] = __expectString(output[_IQ]);
    }
    return contents;
};
const de_ContextAttribute = (output, context) => {
    const contents = {};
    if (output[_K] != null) {
        contents[_K] = __expectString(output[_K]);
    }
    if (output[_Val] != null) {
        contents[_Val] = __expectString(output[_Val]);
    }
    return contents;
};
const de_ContextAttributeList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ContextAttribute(entry, context);
    });
};
const de_CopyDBClusterParameterGroupResult = (output, context) => {
    const contents = {};
    if (output[_DBCPG] != null) {
        contents[_DBCPG] = de_DBClusterParameterGroup(output[_DBCPG], context);
    }
    return contents;
};
const de_CopyDBClusterSnapshotResult = (output, context) => {
    const contents = {};
    if (output[_DBCS] != null) {
        contents[_DBCS] = de_DBClusterSnapshot(output[_DBCS], context);
    }
    return contents;
};
const de_CopyDBParameterGroupResult = (output, context) => {
    const contents = {};
    if (output[_DBPG] != null) {
        contents[_DBPG] = de_DBParameterGroup(output[_DBPG], context);
    }
    return contents;
};
const de_CopyDBSnapshotResult = (output, context) => {
    const contents = {};
    if (output[_DBS] != null) {
        contents[_DBS] = de_DBSnapshot(output[_DBS], context);
    }
    return contents;
};
const de_CopyOptionGroupResult = (output, context) => {
    const contents = {};
    if (output[_OG] != null) {
        contents[_OG] = de_OptionGroup(output[_OG], context);
    }
    return contents;
};
const de_CreateBlueGreenDeploymentResponse = (output, context) => {
    const contents = {};
    if (output[_BGD] != null) {
        contents[_BGD] = de_BlueGreenDeployment(output[_BGD], context);
    }
    return contents;
};
const de_CreateCustomDBEngineVersionFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_CreateDBClusterParameterGroupResult = (output, context) => {
    const contents = {};
    if (output[_DBCPG] != null) {
        contents[_DBCPG] = de_DBClusterParameterGroup(output[_DBCPG], context);
    }
    return contents;
};
const de_CreateDBClusterResult = (output, context) => {
    const contents = {};
    if (output[_DBC] != null) {
        contents[_DBC] = de_DBCluster(output[_DBC], context);
    }
    return contents;
};
const de_CreateDBClusterSnapshotResult = (output, context) => {
    const contents = {};
    if (output[_DBCS] != null) {
        contents[_DBCS] = de_DBClusterSnapshot(output[_DBCS], context);
    }
    return contents;
};
const de_CreateDBInstanceReadReplicaResult = (output, context) => {
    const contents = {};
    if (output[_DBI] != null) {
        contents[_DBI] = de_DBInstance(output[_DBI], context);
    }
    return contents;
};
const de_CreateDBInstanceResult = (output, context) => {
    const contents = {};
    if (output[_DBI] != null) {
        contents[_DBI] = de_DBInstance(output[_DBI], context);
    }
    return contents;
};
const de_CreateDBParameterGroupResult = (output, context) => {
    const contents = {};
    if (output[_DBPG] != null) {
        contents[_DBPG] = de_DBParameterGroup(output[_DBPG], context);
    }
    return contents;
};
const de_CreateDBProxyEndpointResponse = (output, context) => {
    const contents = {};
    if (output[_DBPE] != null) {
        contents[_DBPE] = de_DBProxyEndpoint(output[_DBPE], context);
    }
    return contents;
};
const de_CreateDBProxyResponse = (output, context) => {
    const contents = {};
    if (output[_DBP] != null) {
        contents[_DBP] = de_DBProxy(output[_DBP], context);
    }
    return contents;
};
const de_CreateDBSecurityGroupResult = (output, context) => {
    const contents = {};
    if (output[_DBSGe] != null) {
        contents[_DBSGe] = de_DBSecurityGroup(output[_DBSGe], context);
    }
    return contents;
};
const de_CreateDBSnapshotResult = (output, context) => {
    const contents = {};
    if (output[_DBS] != null) {
        contents[_DBS] = de_DBSnapshot(output[_DBS], context);
    }
    return contents;
};
const de_CreateDBSubnetGroupResult = (output, context) => {
    const contents = {};
    if (output[_DBSGu] != null) {
        contents[_DBSGu] = de_DBSubnetGroup(output[_DBSGu], context);
    }
    return contents;
};
const de_CreateEventSubscriptionResult = (output, context) => {
    const contents = {};
    if (output[_ES] != null) {
        contents[_ES] = de_EventSubscription(output[_ES], context);
    }
    return contents;
};
const de_CreateGlobalClusterResult = (output, context) => {
    const contents = {};
    if (output[_GC] != null) {
        contents[_GC] = de_GlobalCluster(output[_GC], context);
    }
    return contents;
};
const de_CreateOptionGroupResult = (output, context) => {
    const contents = {};
    if (output[_OG] != null) {
        contents[_OG] = de_OptionGroup(output[_OG], context);
    }
    return contents;
};
const de_CreateTenantDatabaseResult = (output, context) => {
    const contents = {};
    if (output[_TD] != null) {
        contents[_TD] = de_TenantDatabase(output[_TD], context);
    }
    return contents;
};
const de_CustomAvailabilityZoneNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_CustomDBEngineVersionAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_CustomDBEngineVersionAMI = (output, context) => {
    const contents = {};
    if (output[_II] != null) {
        contents[_II] = __expectString(output[_II]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    return contents;
};
const de_CustomDBEngineVersionNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_CustomDBEngineVersionQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBCluster = (output, context) => {
    const contents = {};
    if (output[_AS] != null) {
        contents[_AS] = __strictParseInt32(output[_AS]);
    }
    if (output.AvailabilityZones === "") {
        contents[_AZ] = [];
    }
    else if (output[_AZ] != null && output[_AZ][_AZv] != null) {
        contents[_AZ] = de_AvailabilityZones(__getArrayIfSingleItem(output[_AZ][_AZv]), context);
    }
    if (output[_BRP] != null) {
        contents[_BRP] = __strictParseInt32(output[_BRP]);
    }
    if (output[_CSN] != null) {
        contents[_CSN] = __expectString(output[_CSN]);
    }
    if (output[_DN] != null) {
        contents[_DN] = __expectString(output[_DN]);
    }
    if (output[_DBCI] != null) {
        contents[_DBCI] = __expectString(output[_DBCI]);
    }
    if (output[_DBCPG] != null) {
        contents[_DBCPG] = __expectString(output[_DBCPG]);
    }
    if (output[_DBSGu] != null) {
        contents[_DBSGu] = __expectString(output[_DBSGu]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_ART] != null) {
        contents[_ART] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_ART]));
    }
    if (output[_PP] != null) {
        contents[_PP] = __expectString(output[_PP]);
    }
    if (output[_ERT] != null) {
        contents[_ERT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_ERT]));
    }
    if (output[_End] != null) {
        contents[_End] = __expectString(output[_End]);
    }
    if (output[_RE] != null) {
        contents[_RE] = __expectString(output[_RE]);
    }
    if (output.CustomEndpoints === "") {
        contents[_CE] = [];
    }
    else if (output[_CE] != null && output[_CE][_me] != null) {
        contents[_CE] = de_StringList(__getArrayIfSingleItem(output[_CE][_me]), context);
    }
    if (output[_MAZ] != null) {
        contents[_MAZ] = __parseBoolean(output[_MAZ]);
    }
    if (output[_E] != null) {
        contents[_E] = __expectString(output[_E]);
    }
    if (output[_EV] != null) {
        contents[_EV] = __expectString(output[_EV]);
    }
    if (output[_LRT] != null) {
        contents[_LRT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LRT]));
    }
    if (output[_P] != null) {
        contents[_P] = __strictParseInt32(output[_P]);
    }
    if (output[_MU] != null) {
        contents[_MU] = __expectString(output[_MU]);
    }
    if (output.DBClusterOptionGroupMemberships === "") {
        contents[_DBCOGM] = [];
    }
    else if (output[_DBCOGM] != null && output[_DBCOGM][_DBCOG] != null) {
        contents[_DBCOGM] = de_DBClusterOptionGroupMemberships(__getArrayIfSingleItem(output[_DBCOGM][_DBCOG]), context);
    }
    if (output[_PBW] != null) {
        contents[_PBW] = __expectString(output[_PBW]);
    }
    if (output[_PMW] != null) {
        contents[_PMW] = __expectString(output[_PMW]);
    }
    if (output[_RSI] != null) {
        contents[_RSI] = __expectString(output[_RSI]);
    }
    if (output.ReadReplicaIdentifiers === "") {
        contents[_RRI] = [];
    }
    else if (output[_RRI] != null && output[_RRI][_RRIe] != null) {
        contents[_RRI] = de_ReadReplicaIdentifierList(__getArrayIfSingleItem(output[_RRI][_RRIe]), context);
    }
    if (output.StatusInfos === "") {
        contents[_SIt] = [];
    }
    else if (output[_SIt] != null && output[_SIt][_DBCSIl] != null) {
        contents[_SIt] = de_DBClusterStatusInfoList(__getArrayIfSingleItem(output[_SIt][_DBCSIl]), context);
    }
    if (output.DBClusterMembers === "") {
        contents[_DBCM] = [];
    }
    else if (output[_DBCM] != null && output[_DBCM][_DBCMl] != null) {
        contents[_DBCM] = de_DBClusterMemberList(__getArrayIfSingleItem(output[_DBCM][_DBCMl]), context);
    }
    if (output.VpcSecurityGroups === "") {
        contents[_VSG] = [];
    }
    else if (output[_VSG] != null && output[_VSG][_VSGMp] != null) {
        contents[_VSG] = de_VpcSecurityGroupMembershipList(__getArrayIfSingleItem(output[_VSG][_VSGMp]), context);
    }
    if (output[_HZI] != null) {
        contents[_HZI] = __expectString(output[_HZI]);
    }
    if (output[_SE] != null) {
        contents[_SE] = __parseBoolean(output[_SE]);
    }
    if (output[_KKI] != null) {
        contents[_KKI] = __expectString(output[_KKI]);
    }
    if (output[_DCRI] != null) {
        contents[_DCRI] = __expectString(output[_DCRI]);
    }
    if (output[_DBCA] != null) {
        contents[_DBCA] = __expectString(output[_DBCA]);
    }
    if (output.AssociatedRoles === "") {
        contents[_AR] = [];
    }
    else if (output[_AR] != null && output[_AR][_DBCR] != null) {
        contents[_AR] = de_DBClusterRoles(__getArrayIfSingleItem(output[_AR][_DBCR]), context);
    }
    if (output[_IAMDAE] != null) {
        contents[_IAMDAE] = __parseBoolean(output[_IAMDAE]);
    }
    if (output[_CGI] != null) {
        contents[_CGI] = __expectString(output[_CGI]);
    }
    if (output[_CCT] != null) {
        contents[_CCT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CCT]));
    }
    if (output[_EBT] != null) {
        contents[_EBT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_EBT]));
    }
    if (output[_BW] != null) {
        contents[_BW] = __strictParseLong(output[_BW]);
    }
    if (output[_BCCR] != null) {
        contents[_BCCR] = __strictParseLong(output[_BCCR]);
    }
    if (output.EnabledCloudwatchLogsExports === "") {
        contents[_ECLEn] = [];
    }
    else if (output[_ECLEn] != null && output[_ECLEn][_me] != null) {
        contents[_ECLEn] = de_LogTypeList(__getArrayIfSingleItem(output[_ECLEn][_me]), context);
    }
    if (output[_C] != null) {
        contents[_C] = __strictParseInt32(output[_C]);
    }
    if (output[_EMn] != null) {
        contents[_EMn] = __expectString(output[_EMn]);
    }
    if (output[_SCI] != null) {
        contents[_SCI] = de_ScalingConfigurationInfo(output[_SCI], context);
    }
    if (output[_RCCC] != null) {
        contents[_RCCC] = de_RdsCustomClusterConfiguration(output[_RCCC], context);
    }
    if (output[_DP] != null) {
        contents[_DP] = __parseBoolean(output[_DP]);
    }
    if (output[_HEE] != null) {
        contents[_HEE] = __parseBoolean(output[_HEE]);
    }
    if (output[_ASM] != null) {
        contents[_ASM] = __expectString(output[_ASM]);
    }
    if (output[_ASS] != null) {
        contents[_ASS] = __expectString(output[_ASS]);
    }
    if (output[_ASKKI] != null) {
        contents[_ASKKI] = __expectString(output[_ASKKI]);
    }
    if (output[_ASKSN] != null) {
        contents[_ASKSN] = __expectString(output[_ASKSN]);
    }
    if (output[_CTTS] != null) {
        contents[_CTTS] = __parseBoolean(output[_CTTS]);
    }
    if (output[_CAC] != null) {
        contents[_CAC] = __parseBoolean(output[_CAC]);
    }
    if (output.DomainMemberships === "") {
        contents[_DM] = [];
    }
    else if (output[_DM] != null && output[_DM][_DMo] != null) {
        contents[_DM] = de_DomainMembershipList(__getArrayIfSingleItem(output[_DM][_DMo]), context);
    }
    if (output.TagList === "") {
        contents[_TL] = [];
    }
    else if (output[_TL] != null && output[_TL][_Tag] != null) {
        contents[_TL] = de_TagList(__getArrayIfSingleItem(output[_TL][_Tag]), context);
    }
    if (output[_GCI] != null) {
        contents[_GCI] = __expectString(output[_GCI]);
    }
    if (output[_GWFS] != null) {
        contents[_GWFS] = __expectString(output[_GWFS]);
    }
    if (output[_GWFR] != null) {
        contents[_GWFR] = __parseBoolean(output[_GWFR]);
    }
    if (output[_PMV] != null) {
        contents[_PMV] = de_ClusterPendingModifiedValues(output[_PMV], context);
    }
    if (output[_DBCIC] != null) {
        contents[_DBCIC] = __expectString(output[_DBCIC]);
    }
    if (output[_STt] != null) {
        contents[_STt] = __expectString(output[_STt]);
    }
    if (output[_I] != null) {
        contents[_I] = __strictParseInt32(output[_I]);
    }
    if (output[_PA] != null) {
        contents[_PA] = __parseBoolean(output[_PA]);
    }
    if (output[_AMVU] != null) {
        contents[_AMVU] = __parseBoolean(output[_AMVU]);
    }
    if (output[_MIo] != null) {
        contents[_MIo] = __strictParseInt32(output[_MIo]);
    }
    if (output[_MRA] != null) {
        contents[_MRA] = __expectString(output[_MRA]);
    }
    if (output[_DIM] != null) {
        contents[_DIM] = __expectString(output[_DIM]);
    }
    if (output[_PIE] != null) {
        contents[_PIE] = __parseBoolean(output[_PIE]);
    }
    if (output[_PIKMSKI] != null) {
        contents[_PIKMSKI] = __expectString(output[_PIKMSKI]);
    }
    if (output[_PIRP] != null) {
        contents[_PIRP] = __strictParseInt32(output[_PIRP]);
    }
    if (output[_SVSC] != null) {
        contents[_SVSC] = de_ServerlessV2ScalingConfigurationInfo(output[_SVSC], context);
    }
    if (output[_NT] != null) {
        contents[_NT] = __expectString(output[_NT]);
    }
    if (output[_DBSI] != null) {
        contents[_DBSI] = __expectString(output[_DBSI]);
    }
    if (output[_MUS] != null) {
        contents[_MUS] = de_MasterUserSecret(output[_MUS], context);
    }
    if (output[_IOONAMT] != null) {
        contents[_IOONAMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_IOONAMT]));
    }
    if (output[_LWFS] != null) {
        contents[_LWFS] = __expectString(output[_LWFS]);
    }
    if (output[_ABRPA] != null) {
        contents[_ABRPA] = __expectString(output[_ABRPA]);
    }
    if (output[_LD] != null) {
        contents[_LD] = de_LimitlessDatabase(output[_LD], context);
    }
    if (output[_STto] != null) {
        contents[_STto] = __strictParseInt32(output[_STto]);
    }
    if (output[_CST] != null) {
        contents[_CST] = __expectString(output[_CST]);
    }
    if (output[_CD] != null) {
        contents[_CD] = de_CertificateDetails(output[_CD], context);
    }
    if (output[_ELS] != null) {
        contents[_ELS] = __expectString(output[_ELS]);
    }
    return contents;
};
const de_DBClusterAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBClusterAutomatedBackup = (output, context) => {
    const contents = {};
    if (output[_E] != null) {
        contents[_E] = __expectString(output[_E]);
    }
    if (output[_VI] != null) {
        contents[_VI] = __expectString(output[_VI]);
    }
    if (output[_DBCABA] != null) {
        contents[_DBCABA] = __expectString(output[_DBCABA]);
    }
    if (output[_DBCI] != null) {
        contents[_DBCI] = __expectString(output[_DBCI]);
    }
    if (output[_RW] != null) {
        contents[_RW] = de_RestoreWindow(output[_RW], context);
    }
    if (output[_MU] != null) {
        contents[_MU] = __expectString(output[_MU]);
    }
    if (output[_DCRI] != null) {
        contents[_DCRI] = __expectString(output[_DCRI]);
    }
    if (output[_R] != null) {
        contents[_R] = __expectString(output[_R]);
    }
    if (output[_LM] != null) {
        contents[_LM] = __expectString(output[_LM]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_IAMDAE] != null) {
        contents[_IAMDAE] = __parseBoolean(output[_IAMDAE]);
    }
    if (output[_CCT] != null) {
        contents[_CCT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CCT]));
    }
    if (output[_SE] != null) {
        contents[_SE] = __parseBoolean(output[_SE]);
    }
    if (output[_AS] != null) {
        contents[_AS] = __strictParseInt32(output[_AS]);
    }
    if (output[_EV] != null) {
        contents[_EV] = __expectString(output[_EV]);
    }
    if (output[_DBCA] != null) {
        contents[_DBCA] = __expectString(output[_DBCA]);
    }
    if (output[_BRP] != null) {
        contents[_BRP] = __strictParseInt32(output[_BRP]);
    }
    if (output[_EMn] != null) {
        contents[_EMn] = __expectString(output[_EMn]);
    }
    if (output.AvailabilityZones === "") {
        contents[_AZ] = [];
    }
    else if (output[_AZ] != null && output[_AZ][_AZv] != null) {
        contents[_AZ] = de_AvailabilityZones(__getArrayIfSingleItem(output[_AZ][_AZv]), context);
    }
    if (output[_P] != null) {
        contents[_P] = __strictParseInt32(output[_P]);
    }
    if (output[_KKI] != null) {
        contents[_KKI] = __expectString(output[_KKI]);
    }
    if (output[_STt] != null) {
        contents[_STt] = __expectString(output[_STt]);
    }
    if (output[_I] != null) {
        contents[_I] = __strictParseInt32(output[_I]);
    }
    if (output[_ABRPA] != null) {
        contents[_ABRPA] = __expectString(output[_ABRPA]);
    }
    if (output[_STto] != null) {
        contents[_STto] = __strictParseInt32(output[_STto]);
    }
    return contents;
};
const de_DBClusterAutomatedBackupList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBClusterAutomatedBackup(entry, context);
    });
};
const de_DBClusterAutomatedBackupMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.DBClusterAutomatedBackups === "") {
        contents[_DBCAB] = [];
    }
    else if (output[_DBCAB] != null && output[_DBCAB][_DBCABl] != null) {
        contents[_DBCAB] = de_DBClusterAutomatedBackupList(__getArrayIfSingleItem(output[_DBCAB][_DBCABl]), context);
    }
    return contents;
};
const de_DBClusterAutomatedBackupNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBClusterAutomatedBackupQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBClusterBacktrack = (output, context) => {
    const contents = {};
    if (output[_DBCI] != null) {
        contents[_DBCI] = __expectString(output[_DBCI]);
    }
    if (output[_BI] != null) {
        contents[_BI] = __expectString(output[_BI]);
    }
    if (output[_BT] != null) {
        contents[_BT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_BT]));
    }
    if (output[_BF] != null) {
        contents[_BF] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_BF]));
    }
    if (output[_BRCT] != null) {
        contents[_BRCT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_BRCT]));
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    return contents;
};
const de_DBClusterBacktrackList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBClusterBacktrack(entry, context);
    });
};
const de_DBClusterBacktrackMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.DBClusterBacktracks === "") {
        contents[_DBCB] = [];
    }
    else if (output[_DBCB] != null && output[_DBCB][_DBCBl] != null) {
        contents[_DBCB] = de_DBClusterBacktrackList(__getArrayIfSingleItem(output[_DBCB][_DBCBl]), context);
    }
    return contents;
};
const de_DBClusterBacktrackNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBClusterCapacityInfo = (output, context) => {
    const contents = {};
    if (output[_DBCI] != null) {
        contents[_DBCI] = __expectString(output[_DBCI]);
    }
    if (output[_PC] != null) {
        contents[_PC] = __strictParseInt32(output[_PC]);
    }
    if (output[_CC] != null) {
        contents[_CC] = __strictParseInt32(output[_CC]);
    }
    if (output[_SBT] != null) {
        contents[_SBT] = __strictParseInt32(output[_SBT]);
    }
    if (output[_TAi] != null) {
        contents[_TAi] = __expectString(output[_TAi]);
    }
    return contents;
};
const de_DBClusterEndpoint = (output, context) => {
    const contents = {};
    if (output[_DBCEI] != null) {
        contents[_DBCEI] = __expectString(output[_DBCEI]);
    }
    if (output[_DBCI] != null) {
        contents[_DBCI] = __expectString(output[_DBCI]);
    }
    if (output[_DBCERI] != null) {
        contents[_DBCERI] = __expectString(output[_DBCERI]);
    }
    if (output[_End] != null) {
        contents[_End] = __expectString(output[_End]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_ET] != null) {
        contents[_ET] = __expectString(output[_ET]);
    }
    if (output[_CETu] != null) {
        contents[_CETu] = __expectString(output[_CETu]);
    }
    if (output.StaticMembers === "") {
        contents[_SM] = [];
    }
    else if (output[_SM] != null && output[_SM][_me] != null) {
        contents[_SM] = de_StringList(__getArrayIfSingleItem(output[_SM][_me]), context);
    }
    if (output.ExcludedMembers === "") {
        contents[_EM] = [];
    }
    else if (output[_EM] != null && output[_EM][_me] != null) {
        contents[_EM] = de_StringList(__getArrayIfSingleItem(output[_EM][_me]), context);
    }
    if (output[_DBCEA] != null) {
        contents[_DBCEA] = __expectString(output[_DBCEA]);
    }
    return contents;
};
const de_DBClusterEndpointAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBClusterEndpointList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBClusterEndpoint(entry, context);
    });
};
const de_DBClusterEndpointMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.DBClusterEndpoints === "") {
        contents[_DBCE] = [];
    }
    else if (output[_DBCE] != null && output[_DBCE][_DBCEL] != null) {
        contents[_DBCE] = de_DBClusterEndpointList(__getArrayIfSingleItem(output[_DBCE][_DBCEL]), context);
    }
    return contents;
};
const de_DBClusterEndpointNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBClusterEndpointQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBClusterList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBCluster(entry, context);
    });
};
const de_DBClusterMember = (output, context) => {
    const contents = {};
    if (output[_DBII] != null) {
        contents[_DBII] = __expectString(output[_DBII]);
    }
    if (output[_ICW] != null) {
        contents[_ICW] = __parseBoolean(output[_ICW]);
    }
    if (output[_DBCPGS] != null) {
        contents[_DBCPGS] = __expectString(output[_DBCPGS]);
    }
    if (output[_PT] != null) {
        contents[_PT] = __strictParseInt32(output[_PT]);
    }
    return contents;
};
const de_DBClusterMemberList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBClusterMember(entry, context);
    });
};
const de_DBClusterMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.DBClusters === "") {
        contents[_DBCl] = [];
    }
    else if (output[_DBCl] != null && output[_DBCl][_DBC] != null) {
        contents[_DBCl] = de_DBClusterList(__getArrayIfSingleItem(output[_DBCl][_DBC]), context);
    }
    return contents;
};
const de_DBClusterNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBClusterOptionGroupMemberships = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBClusterOptionGroupStatus(entry, context);
    });
};
const de_DBClusterOptionGroupStatus = (output, context) => {
    const contents = {};
    if (output[_DBCOGN] != null) {
        contents[_DBCOGN] = __expectString(output[_DBCOGN]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    return contents;
};
const de_DBClusterParameterGroup = (output, context) => {
    const contents = {};
    if (output[_DBCPGN] != null) {
        contents[_DBCPGN] = __expectString(output[_DBCPGN]);
    }
    if (output[_DBPGF] != null) {
        contents[_DBPGF] = __expectString(output[_DBPGF]);
    }
    if (output[_D] != null) {
        contents[_D] = __expectString(output[_D]);
    }
    if (output[_DBCPGA] != null) {
        contents[_DBCPGA] = __expectString(output[_DBCPGA]);
    }
    return contents;
};
const de_DBClusterParameterGroupDetails = (output, context) => {
    const contents = {};
    if (output.Parameters === "") {
        contents[_Pa] = [];
    }
    else if (output[_Pa] != null && output[_Pa][_Par] != null) {
        contents[_Pa] = de_ParametersList(__getArrayIfSingleItem(output[_Pa][_Par]), context);
    }
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    return contents;
};
const de_DBClusterParameterGroupList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBClusterParameterGroup(entry, context);
    });
};
const de_DBClusterParameterGroupNameMessage = (output, context) => {
    const contents = {};
    if (output[_DBCPGN] != null) {
        contents[_DBCPGN] = __expectString(output[_DBCPGN]);
    }
    return contents;
};
const de_DBClusterParameterGroupNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBClusterParameterGroupsMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.DBClusterParameterGroups === "") {
        contents[_DBCPGl] = [];
    }
    else if (output[_DBCPGl] != null && output[_DBCPGl][_DBCPG] != null) {
        contents[_DBCPGl] = de_DBClusterParameterGroupList(__getArrayIfSingleItem(output[_DBCPGl][_DBCPG]), context);
    }
    return contents;
};
const de_DBClusterQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBClusterRole = (output, context) => {
    const contents = {};
    if (output[_RA] != null) {
        contents[_RA] = __expectString(output[_RA]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_FN] != null) {
        contents[_FN] = __expectString(output[_FN]);
    }
    return contents;
};
const de_DBClusterRoleAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBClusterRoleNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBClusterRoleQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBClusterRoles = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBClusterRole(entry, context);
    });
};
const de_DBClusterSnapshot = (output, context) => {
    const contents = {};
    if (output.AvailabilityZones === "") {
        contents[_AZ] = [];
    }
    else if (output[_AZ] != null && output[_AZ][_AZv] != null) {
        contents[_AZ] = de_AvailabilityZones(__getArrayIfSingleItem(output[_AZ][_AZv]), context);
    }
    if (output[_DBCSI] != null) {
        contents[_DBCSI] = __expectString(output[_DBCSI]);
    }
    if (output[_DBCI] != null) {
        contents[_DBCI] = __expectString(output[_DBCI]);
    }
    if (output[_SCT] != null) {
        contents[_SCT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_SCT]));
    }
    if (output[_E] != null) {
        contents[_E] = __expectString(output[_E]);
    }
    if (output[_EMn] != null) {
        contents[_EMn] = __expectString(output[_EMn]);
    }
    if (output[_AS] != null) {
        contents[_AS] = __strictParseInt32(output[_AS]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_P] != null) {
        contents[_P] = __strictParseInt32(output[_P]);
    }
    if (output[_VI] != null) {
        contents[_VI] = __expectString(output[_VI]);
    }
    if (output[_CCT] != null) {
        contents[_CCT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CCT]));
    }
    if (output[_MU] != null) {
        contents[_MU] = __expectString(output[_MU]);
    }
    if (output[_EV] != null) {
        contents[_EV] = __expectString(output[_EV]);
    }
    if (output[_LM] != null) {
        contents[_LM] = __expectString(output[_LM]);
    }
    if (output[_STn] != null) {
        contents[_STn] = __expectString(output[_STn]);
    }
    if (output[_PP] != null) {
        contents[_PP] = __strictParseInt32(output[_PP]);
    }
    if (output[_SE] != null) {
        contents[_SE] = __parseBoolean(output[_SE]);
    }
    if (output[_KKI] != null) {
        contents[_KKI] = __expectString(output[_KKI]);
    }
    if (output[_DBCSA] != null) {
        contents[_DBCSA] = __expectString(output[_DBCSA]);
    }
    if (output[_SDBCSA] != null) {
        contents[_SDBCSA] = __expectString(output[_SDBCSA]);
    }
    if (output[_IAMDAE] != null) {
        contents[_IAMDAE] = __parseBoolean(output[_IAMDAE]);
    }
    if (output.TagList === "") {
        contents[_TL] = [];
    }
    else if (output[_TL] != null && output[_TL][_Tag] != null) {
        contents[_TL] = de_TagList(__getArrayIfSingleItem(output[_TL][_Tag]), context);
    }
    if (output[_DBSI] != null) {
        contents[_DBSI] = __expectString(output[_DBSI]);
    }
    if (output[_STt] != null) {
        contents[_STt] = __expectString(output[_STt]);
    }
    if (output[_DCRI] != null) {
        contents[_DCRI] = __expectString(output[_DCRI]);
    }
    if (output[_STto] != null) {
        contents[_STto] = __strictParseInt32(output[_STto]);
    }
    return contents;
};
const de_DBClusterSnapshotAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBClusterSnapshotAttribute = (output, context) => {
    const contents = {};
    if (output[_AN] != null) {
        contents[_AN] = __expectString(output[_AN]);
    }
    if (output.AttributeValues === "") {
        contents[_AVt] = [];
    }
    else if (output[_AVt] != null && output[_AVt][_AVtt] != null) {
        contents[_AVt] = de_AttributeValueList(__getArrayIfSingleItem(output[_AVt][_AVtt]), context);
    }
    return contents;
};
const de_DBClusterSnapshotAttributeList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBClusterSnapshotAttribute(entry, context);
    });
};
const de_DBClusterSnapshotAttributesResult = (output, context) => {
    const contents = {};
    if (output[_DBCSI] != null) {
        contents[_DBCSI] = __expectString(output[_DBCSI]);
    }
    if (output.DBClusterSnapshotAttributes === "") {
        contents[_DBCSAl] = [];
    }
    else if (output[_DBCSAl] != null && output[_DBCSAl][_DBCSAlu] != null) {
        contents[_DBCSAl] = de_DBClusterSnapshotAttributeList(__getArrayIfSingleItem(output[_DBCSAl][_DBCSAlu]), context);
    }
    return contents;
};
const de_DBClusterSnapshotList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBClusterSnapshot(entry, context);
    });
};
const de_DBClusterSnapshotMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.DBClusterSnapshots === "") {
        contents[_DBCSl] = [];
    }
    else if (output[_DBCSl] != null && output[_DBCSl][_DBCS] != null) {
        contents[_DBCSl] = de_DBClusterSnapshotList(__getArrayIfSingleItem(output[_DBCSl][_DBCS]), context);
    }
    return contents;
};
const de_DBClusterSnapshotNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBClusterStatusInfo = (output, context) => {
    const contents = {};
    if (output[_STtat] != null) {
        contents[_STtat] = __expectString(output[_STtat]);
    }
    if (output[_No] != null) {
        contents[_No] = __parseBoolean(output[_No]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_Me] != null) {
        contents[_Me] = __expectString(output[_Me]);
    }
    return contents;
};
const de_DBClusterStatusInfoList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBClusterStatusInfo(entry, context);
    });
};
const de_DBEngineVersion = (output, context) => {
    const contents = {};
    if (output[_E] != null) {
        contents[_E] = __expectString(output[_E]);
    }
    if (output[_EV] != null) {
        contents[_EV] = __expectString(output[_EV]);
    }
    if (output[_DBPGF] != null) {
        contents[_DBPGF] = __expectString(output[_DBPGF]);
    }
    if (output[_DBED] != null) {
        contents[_DBED] = __expectString(output[_DBED]);
    }
    if (output[_DBEVD] != null) {
        contents[_DBEVD] = __expectString(output[_DBEVD]);
    }
    if (output[_DCS] != null) {
        contents[_DCS] = de_CharacterSet(output[_DCS], context);
    }
    if (output[_Im] != null) {
        contents[_Im] = de_CustomDBEngineVersionAMI(output[_Im], context);
    }
    if (output[_DBEMT] != null) {
        contents[_DBEMT] = __expectString(output[_DBEMT]);
    }
    if (output.SupportedCharacterSets === "") {
        contents[_SCS] = [];
    }
    else if (output[_SCS] != null && output[_SCS][_CS] != null) {
        contents[_SCS] = de_SupportedCharacterSetsList(__getArrayIfSingleItem(output[_SCS][_CS]), context);
    }
    if (output.SupportedNcharCharacterSets === "") {
        contents[_SNCS] = [];
    }
    else if (output[_SNCS] != null && output[_SNCS][_CS] != null) {
        contents[_SNCS] = de_SupportedCharacterSetsList(__getArrayIfSingleItem(output[_SNCS][_CS]), context);
    }
    if (output.ValidUpgradeTarget === "") {
        contents[_VUT] = [];
    }
    else if (output[_VUT] != null && output[_VUT][_UT] != null) {
        contents[_VUT] = de_ValidUpgradeTargetList(__getArrayIfSingleItem(output[_VUT][_UT]), context);
    }
    if (output.SupportedTimezones === "") {
        contents[_STu] = [];
    }
    else if (output[_STu] != null && output[_STu][_Ti] != null) {
        contents[_STu] = de_SupportedTimezonesList(__getArrayIfSingleItem(output[_STu][_Ti]), context);
    }
    if (output.ExportableLogTypes === "") {
        contents[_ELTx] = [];
    }
    else if (output[_ELTx] != null && output[_ELTx][_me] != null) {
        contents[_ELTx] = de_LogTypeList(__getArrayIfSingleItem(output[_ELTx][_me]), context);
    }
    if (output[_SLETCL] != null) {
        contents[_SLETCL] = __parseBoolean(output[_SLETCL]);
    }
    if (output[_SRRu] != null) {
        contents[_SRRu] = __parseBoolean(output[_SRRu]);
    }
    if (output.SupportedEngineModes === "") {
        contents[_SEM] = [];
    }
    else if (output[_SEM] != null && output[_SEM][_me] != null) {
        contents[_SEM] = de_EngineModeList(__getArrayIfSingleItem(output[_SEM][_me]), context);
    }
    if (output.SupportedFeatureNames === "") {
        contents[_SFN] = [];
    }
    else if (output[_SFN] != null && output[_SFN][_me] != null) {
        contents[_SFN] = de_FeatureNameList(__getArrayIfSingleItem(output[_SFN][_me]), context);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_SPQ] != null) {
        contents[_SPQ] = __parseBoolean(output[_SPQ]);
    }
    if (output[_SGD] != null) {
        contents[_SGD] = __parseBoolean(output[_SGD]);
    }
    if (output[_MEV] != null) {
        contents[_MEV] = __expectString(output[_MEV]);
    }
    if (output[_DIFSBN] != null) {
        contents[_DIFSBN] = __expectString(output[_DIFSBN]);
    }
    if (output[_DIFSP] != null) {
        contents[_DIFSP] = __expectString(output[_DIFSP]);
    }
    if (output[_DBEVA] != null) {
        contents[_DBEVA] = __expectString(output[_DBEVA]);
    }
    if (output[_KMSKI] != null) {
        contents[_KMSKI] = __expectString(output[_KMSKI]);
    }
    if (output[_CTr] != null) {
        contents[_CTr] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CTr]));
    }
    if (output.TagList === "") {
        contents[_TL] = [];
    }
    else if (output[_TL] != null && output[_TL][_Tag] != null) {
        contents[_TL] = de_TagList(__getArrayIfSingleItem(output[_TL][_Tag]), context);
    }
    if (output[_SB] != null) {
        contents[_SB] = __parseBoolean(output[_SB]);
    }
    if (output[_CDBEVM] != null) {
        contents[_CDBEVM] = __expectString(output[_CDBEVM]);
    }
    if (output[_SLD] != null) {
        contents[_SLD] = __parseBoolean(output[_SLD]);
    }
    if (output[_SCRWR] != null) {
        contents[_SCRWR] = __parseBoolean(output[_SCRWR]);
    }
    if (output.SupportedCACertificateIdentifiers === "") {
        contents[_SCACI] = [];
    }
    else if (output[_SCACI] != null && output[_SCACI][_me] != null) {
        contents[_SCACI] = de_CACertificateIdentifiersList(__getArrayIfSingleItem(output[_SCACI][_me]), context);
    }
    if (output[_SLWF] != null) {
        contents[_SLWF] = __parseBoolean(output[_SLWF]);
    }
    if (output[_SIup] != null) {
        contents[_SIup] = __parseBoolean(output[_SIup]);
    }
    if (output[_SVFS] != null) {
        contents[_SVFS] = de_ServerlessV2FeaturesSupport(output[_SVFS], context);
    }
    return contents;
};
const de_DBEngineVersionList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBEngineVersion(entry, context);
    });
};
const de_DBEngineVersionMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.DBEngineVersions === "") {
        contents[_DBEV] = [];
    }
    else if (output[_DBEV] != null && output[_DBEV][_DBEVn] != null) {
        contents[_DBEV] = de_DBEngineVersionList(__getArrayIfSingleItem(output[_DBEV][_DBEVn]), context);
    }
    return contents;
};
const de_DBInstance = (output, context) => {
    const contents = {};
    if (output[_DBII] != null) {
        contents[_DBII] = __expectString(output[_DBII]);
    }
    if (output[_DBIC] != null) {
        contents[_DBIC] = __expectString(output[_DBIC]);
    }
    if (output[_E] != null) {
        contents[_E] = __expectString(output[_E]);
    }
    if (output[_DBIS] != null) {
        contents[_DBIS] = __expectString(output[_DBIS]);
    }
    if (output[_ART] != null) {
        contents[_ART] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_ART]));
    }
    if (output[_MU] != null) {
        contents[_MU] = __expectString(output[_MU]);
    }
    if (output[_DBN] != null) {
        contents[_DBN] = __expectString(output[_DBN]);
    }
    if (output[_End] != null) {
        contents[_End] = de_Endpoint(output[_End], context);
    }
    if (output[_AS] != null) {
        contents[_AS] = __strictParseInt32(output[_AS]);
    }
    if (output[_ICTn] != null) {
        contents[_ICTn] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_ICTn]));
    }
    if (output[_PBW] != null) {
        contents[_PBW] = __expectString(output[_PBW]);
    }
    if (output[_BRP] != null) {
        contents[_BRP] = __strictParseInt32(output[_BRP]);
    }
    if (output.DBSecurityGroups === "") {
        contents[_DBSG] = [];
    }
    else if (output[_DBSG] != null && output[_DBSG][_DBSGe] != null) {
        contents[_DBSG] = de_DBSecurityGroupMembershipList(__getArrayIfSingleItem(output[_DBSG][_DBSGe]), context);
    }
    if (output.VpcSecurityGroups === "") {
        contents[_VSG] = [];
    }
    else if (output[_VSG] != null && output[_VSG][_VSGMp] != null) {
        contents[_VSG] = de_VpcSecurityGroupMembershipList(__getArrayIfSingleItem(output[_VSG][_VSGMp]), context);
    }
    if (output.DBParameterGroups === "") {
        contents[_DBPGa] = [];
    }
    else if (output[_DBPGa] != null && output[_DBPGa][_DBPG] != null) {
        contents[_DBPGa] = de_DBParameterGroupStatusList(__getArrayIfSingleItem(output[_DBPGa][_DBPG]), context);
    }
    if (output[_AZv] != null) {
        contents[_AZv] = __expectString(output[_AZv]);
    }
    if (output[_DBSGu] != null) {
        contents[_DBSGu] = de_DBSubnetGroup(output[_DBSGu], context);
    }
    if (output[_PMW] != null) {
        contents[_PMW] = __expectString(output[_PMW]);
    }
    if (output[_PMV] != null) {
        contents[_PMV] = de_PendingModifiedValues(output[_PMV], context);
    }
    if (output[_LRT] != null) {
        contents[_LRT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LRT]));
    }
    if (output[_MAZ] != null) {
        contents[_MAZ] = __parseBoolean(output[_MAZ]);
    }
    if (output[_EV] != null) {
        contents[_EV] = __expectString(output[_EV]);
    }
    if (output[_AMVU] != null) {
        contents[_AMVU] = __parseBoolean(output[_AMVU]);
    }
    if (output[_RRSDBII] != null) {
        contents[_RRSDBII] = __expectString(output[_RRSDBII]);
    }
    if (output.ReadReplicaDBInstanceIdentifiers === "") {
        contents[_RRDBII] = [];
    }
    else if (output[_RRDBII] != null && output[_RRDBII][_RRDBIIe] != null) {
        contents[_RRDBII] = de_ReadReplicaDBInstanceIdentifierList(__getArrayIfSingleItem(output[_RRDBII][_RRDBIIe]), context);
    }
    if (output.ReadReplicaDBClusterIdentifiers === "") {
        contents[_RRDBCI] = [];
    }
    else if (output[_RRDBCI] != null && output[_RRDBCI][_RRDBCIe] != null) {
        contents[_RRDBCI] = de_ReadReplicaDBClusterIdentifierList(__getArrayIfSingleItem(output[_RRDBCI][_RRDBCIe]), context);
    }
    if (output[_RM] != null) {
        contents[_RM] = __expectString(output[_RM]);
    }
    if (output[_LM] != null) {
        contents[_LM] = __expectString(output[_LM]);
    }
    if (output[_I] != null) {
        contents[_I] = __strictParseInt32(output[_I]);
    }
    if (output.OptionGroupMemberships === "") {
        contents[_OGM] = [];
    }
    else if (output[_OGM] != null && output[_OGM][_OGMp] != null) {
        contents[_OGM] = de_OptionGroupMembershipList(__getArrayIfSingleItem(output[_OGM][_OGMp]), context);
    }
    if (output[_CSN] != null) {
        contents[_CSN] = __expectString(output[_CSN]);
    }
    if (output[_NCSN] != null) {
        contents[_NCSN] = __expectString(output[_NCSN]);
    }
    if (output[_SAZe] != null) {
        contents[_SAZe] = __expectString(output[_SAZe]);
    }
    if (output[_PA] != null) {
        contents[_PA] = __parseBoolean(output[_PA]);
    }
    if (output.StatusInfos === "") {
        contents[_SIt] = [];
    }
    else if (output[_SIt] != null && output[_SIt][_DBISI] != null) {
        contents[_SIt] = de_DBInstanceStatusInfoList(__getArrayIfSingleItem(output[_SIt][_DBISI]), context);
    }
    if (output[_STt] != null) {
        contents[_STt] = __expectString(output[_STt]);
    }
    if (output[_TCA] != null) {
        contents[_TCA] = __expectString(output[_TCA]);
    }
    if (output[_DIP] != null) {
        contents[_DIP] = __strictParseInt32(output[_DIP]);
    }
    if (output[_DBCI] != null) {
        contents[_DBCI] = __expectString(output[_DBCI]);
    }
    if (output[_SE] != null) {
        contents[_SE] = __parseBoolean(output[_SE]);
    }
    if (output[_KKI] != null) {
        contents[_KKI] = __expectString(output[_KKI]);
    }
    if (output[_DRI] != null) {
        contents[_DRI] = __expectString(output[_DRI]);
    }
    if (output[_CACI] != null) {
        contents[_CACI] = __expectString(output[_CACI]);
    }
    if (output.DomainMemberships === "") {
        contents[_DM] = [];
    }
    else if (output[_DM] != null && output[_DM][_DMo] != null) {
        contents[_DM] = de_DomainMembershipList(__getArrayIfSingleItem(output[_DM][_DMo]), context);
    }
    if (output[_CTTS] != null) {
        contents[_CTTS] = __parseBoolean(output[_CTTS]);
    }
    if (output[_MIo] != null) {
        contents[_MIo] = __strictParseInt32(output[_MIo]);
    }
    if (output[_EMRA] != null) {
        contents[_EMRA] = __expectString(output[_EMRA]);
    }
    if (output[_MRA] != null) {
        contents[_MRA] = __expectString(output[_MRA]);
    }
    if (output[_PT] != null) {
        contents[_PT] = __strictParseInt32(output[_PT]);
    }
    if (output[_DBIA] != null) {
        contents[_DBIA] = __expectString(output[_DBIA]);
    }
    if (output[_Ti] != null) {
        contents[_Ti] = __expectString(output[_Ti]);
    }
    if (output[_IAMDAE] != null) {
        contents[_IAMDAE] = __parseBoolean(output[_IAMDAE]);
    }
    if (output[_DIM] != null) {
        contents[_DIM] = __expectString(output[_DIM]);
    }
    if (output[_PIE] != null) {
        contents[_PIE] = __parseBoolean(output[_PIE]);
    }
    if (output[_PIKMSKI] != null) {
        contents[_PIKMSKI] = __expectString(output[_PIKMSKI]);
    }
    if (output[_PIRP] != null) {
        contents[_PIRP] = __strictParseInt32(output[_PIRP]);
    }
    if (output.EnabledCloudwatchLogsExports === "") {
        contents[_ECLEn] = [];
    }
    else if (output[_ECLEn] != null && output[_ECLEn][_me] != null) {
        contents[_ECLEn] = de_LogTypeList(__getArrayIfSingleItem(output[_ECLEn][_me]), context);
    }
    if (output.ProcessorFeatures === "") {
        contents[_PF] = [];
    }
    else if (output[_PF] != null && output[_PF][_PFr] != null) {
        contents[_PF] = de_ProcessorFeatureList(__getArrayIfSingleItem(output[_PF][_PFr]), context);
    }
    if (output[_DP] != null) {
        contents[_DP] = __parseBoolean(output[_DP]);
    }
    if (output.AssociatedRoles === "") {
        contents[_AR] = [];
    }
    else if (output[_AR] != null && output[_AR][_DBIR] != null) {
        contents[_AR] = de_DBInstanceRoles(__getArrayIfSingleItem(output[_AR][_DBIR]), context);
    }
    if (output[_LE] != null) {
        contents[_LE] = de_Endpoint(output[_LE], context);
    }
    if (output[_MASa] != null) {
        contents[_MASa] = __strictParseInt32(output[_MASa]);
    }
    if (output.TagList === "") {
        contents[_TL] = [];
    }
    else if (output[_TL] != null && output[_TL][_Tag] != null) {
        contents[_TL] = de_TagList(__getArrayIfSingleItem(output[_TL][_Tag]), context);
    }
    if (output.DBInstanceAutomatedBackupsReplications === "") {
        contents[_DBIABR] = [];
    }
    else if (output[_DBIABR] != null && output[_DBIABR][_DBIABRn] != null) {
        contents[_DBIABR] = de_DBInstanceAutomatedBackupsReplicationList(__getArrayIfSingleItem(output[_DBIABR][_DBIABRn]), context);
    }
    if (output[_COIE] != null) {
        contents[_COIE] = __parseBoolean(output[_COIE]);
    }
    if (output[_ABRPA] != null) {
        contents[_ABRPA] = __expectString(output[_ABRPA]);
    }
    if (output[_ASS] != null) {
        contents[_ASS] = __expectString(output[_ASS]);
    }
    if (output[_ASKKI] != null) {
        contents[_ASKKI] = __expectString(output[_ASKKI]);
    }
    if (output[_ASKSN] != null) {
        contents[_ASKSN] = __expectString(output[_ASKSN]);
    }
    if (output[_ASM] != null) {
        contents[_ASM] = __expectString(output[_ASM]);
    }
    if (output[_ASENAFI] != null) {
        contents[_ASENAFI] = __parseBoolean(output[_ASENAFI]);
    }
    if (output[_AM] != null) {
        contents[_AM] = __expectString(output[_AM]);
    }
    if (output[_RFAMT] != null) {
        contents[_RFAMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_RFAMT]));
    }
    if (output[_CIIP] != null) {
        contents[_CIIP] = __expectString(output[_CIIP]);
    }
    if (output[_BTa] != null) {
        contents[_BTa] = __expectString(output[_BTa]);
    }
    if (output[_NT] != null) {
        contents[_NT] = __expectString(output[_NT]);
    }
    if (output[_ASPS] != null) {
        contents[_ASPS] = __expectString(output[_ASPS]);
    }
    if (output[_STto] != null) {
        contents[_STto] = __strictParseInt32(output[_STto]);
    }
    if (output[_DBSI] != null) {
        contents[_DBSI] = __expectString(output[_DBSI]);
    }
    if (output[_MUS] != null) {
        contents[_MUS] = de_MasterUserSecret(output[_MUS], context);
    }
    if (output[_CD] != null) {
        contents[_CD] = de_CertificateDetails(output[_CD], context);
    }
    if (output[_RRSDBCI] != null) {
        contents[_RRSDBCI] = __expectString(output[_RRSDBCI]);
    }
    if (output[_PP] != null) {
        contents[_PP] = __expectString(output[_PP]);
    }
    if (output[_DLV] != null) {
        contents[_DLV] = __parseBoolean(output[_DLV]);
    }
    if (output[_ISCUA] != null) {
        contents[_ISCUA] = __parseBoolean(output[_ISCUA]);
    }
    if (output[_MT] != null) {
        contents[_MT] = __parseBoolean(output[_MT]);
    }
    if (output[_ELS] != null) {
        contents[_ELS] = __expectString(output[_ELS]);
    }
    return contents;
};
const de_DBInstanceAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBInstanceAutomatedBackup = (output, context) => {
    const contents = {};
    if (output[_DBIA] != null) {
        contents[_DBIA] = __expectString(output[_DBIA]);
    }
    if (output[_DRI] != null) {
        contents[_DRI] = __expectString(output[_DRI]);
    }
    if (output[_R] != null) {
        contents[_R] = __expectString(output[_R]);
    }
    if (output[_DBII] != null) {
        contents[_DBII] = __expectString(output[_DBII]);
    }
    if (output[_RW] != null) {
        contents[_RW] = de_RestoreWindow(output[_RW], context);
    }
    if (output[_AS] != null) {
        contents[_AS] = __strictParseInt32(output[_AS]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_P] != null) {
        contents[_P] = __strictParseInt32(output[_P]);
    }
    if (output[_AZv] != null) {
        contents[_AZv] = __expectString(output[_AZv]);
    }
    if (output[_VI] != null) {
        contents[_VI] = __expectString(output[_VI]);
    }
    if (output[_ICTn] != null) {
        contents[_ICTn] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_ICTn]));
    }
    if (output[_MU] != null) {
        contents[_MU] = __expectString(output[_MU]);
    }
    if (output[_E] != null) {
        contents[_E] = __expectString(output[_E]);
    }
    if (output[_EV] != null) {
        contents[_EV] = __expectString(output[_EV]);
    }
    if (output[_LM] != null) {
        contents[_LM] = __expectString(output[_LM]);
    }
    if (output[_I] != null) {
        contents[_I] = __strictParseInt32(output[_I]);
    }
    if (output[_OGN] != null) {
        contents[_OGN] = __expectString(output[_OGN]);
    }
    if (output[_TCA] != null) {
        contents[_TCA] = __expectString(output[_TCA]);
    }
    if (output[_Enc] != null) {
        contents[_Enc] = __parseBoolean(output[_Enc]);
    }
    if (output[_STt] != null) {
        contents[_STt] = __expectString(output[_STt]);
    }
    if (output[_KKI] != null) {
        contents[_KKI] = __expectString(output[_KKI]);
    }
    if (output[_Ti] != null) {
        contents[_Ti] = __expectString(output[_Ti]);
    }
    if (output[_IAMDAE] != null) {
        contents[_IAMDAE] = __parseBoolean(output[_IAMDAE]);
    }
    if (output[_BRP] != null) {
        contents[_BRP] = __strictParseInt32(output[_BRP]);
    }
    if (output[_DBIABA] != null) {
        contents[_DBIABA] = __expectString(output[_DBIABA]);
    }
    if (output.DBInstanceAutomatedBackupsReplications === "") {
        contents[_DBIABR] = [];
    }
    else if (output[_DBIABR] != null && output[_DBIABR][_DBIABRn] != null) {
        contents[_DBIABR] = de_DBInstanceAutomatedBackupsReplicationList(__getArrayIfSingleItem(output[_DBIABR][_DBIABRn]), context);
    }
    if (output[_BTa] != null) {
        contents[_BTa] = __expectString(output[_BTa]);
    }
    if (output[_STto] != null) {
        contents[_STto] = __strictParseInt32(output[_STto]);
    }
    if (output[_ABRPA] != null) {
        contents[_ABRPA] = __expectString(output[_ABRPA]);
    }
    if (output[_DLV] != null) {
        contents[_DLV] = __parseBoolean(output[_DLV]);
    }
    if (output[_MT] != null) {
        contents[_MT] = __parseBoolean(output[_MT]);
    }
    return contents;
};
const de_DBInstanceAutomatedBackupList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBInstanceAutomatedBackup(entry, context);
    });
};
const de_DBInstanceAutomatedBackupMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.DBInstanceAutomatedBackups === "") {
        contents[_DBIAB] = [];
    }
    else if (output[_DBIAB] != null && output[_DBIAB][_DBIABn] != null) {
        contents[_DBIAB] = de_DBInstanceAutomatedBackupList(__getArrayIfSingleItem(output[_DBIAB][_DBIABn]), context);
    }
    return contents;
};
const de_DBInstanceAutomatedBackupNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBInstanceAutomatedBackupQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBInstanceAutomatedBackupsReplication = (output, context) => {
    const contents = {};
    if (output[_DBIABA] != null) {
        contents[_DBIABA] = __expectString(output[_DBIABA]);
    }
    return contents;
};
const de_DBInstanceAutomatedBackupsReplicationList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBInstanceAutomatedBackupsReplication(entry, context);
    });
};
const de_DBInstanceList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBInstance(entry, context);
    });
};
const de_DBInstanceMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.DBInstances === "") {
        contents[_DBIn] = [];
    }
    else if (output[_DBIn] != null && output[_DBIn][_DBI] != null) {
        contents[_DBIn] = de_DBInstanceList(__getArrayIfSingleItem(output[_DBIn][_DBI]), context);
    }
    return contents;
};
const de_DBInstanceNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBInstanceNotReadyFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBInstanceRole = (output, context) => {
    const contents = {};
    if (output[_RA] != null) {
        contents[_RA] = __expectString(output[_RA]);
    }
    if (output[_FN] != null) {
        contents[_FN] = __expectString(output[_FN]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    return contents;
};
const de_DBInstanceRoleAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBInstanceRoleNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBInstanceRoleQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBInstanceRoles = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBInstanceRole(entry, context);
    });
};
const de_DBInstanceStatusInfo = (output, context) => {
    const contents = {};
    if (output[_STtat] != null) {
        contents[_STtat] = __expectString(output[_STtat]);
    }
    if (output[_No] != null) {
        contents[_No] = __parseBoolean(output[_No]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_Me] != null) {
        contents[_Me] = __expectString(output[_Me]);
    }
    return contents;
};
const de_DBInstanceStatusInfoList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBInstanceStatusInfo(entry, context);
    });
};
const de_DBLogFileNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBMajorEngineVersion = (output, context) => {
    const contents = {};
    if (output[_E] != null) {
        contents[_E] = __expectString(output[_E]);
    }
    if (output[_MEV] != null) {
        contents[_MEV] = __expectString(output[_MEV]);
    }
    if (output.SupportedEngineLifecycles === "") {
        contents[_SEL] = [];
    }
    else if (output[_SEL] != null && output[_SEL][_SELu] != null) {
        contents[_SEL] = de_SupportedEngineLifecycleList(__getArrayIfSingleItem(output[_SEL][_SELu]), context);
    }
    return contents;
};
const de_DBMajorEngineVersionsList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBMajorEngineVersion(entry, context);
    });
};
const de_DBParameterGroup = (output, context) => {
    const contents = {};
    if (output[_DBPGN] != null) {
        contents[_DBPGN] = __expectString(output[_DBPGN]);
    }
    if (output[_DBPGF] != null) {
        contents[_DBPGF] = __expectString(output[_DBPGF]);
    }
    if (output[_D] != null) {
        contents[_D] = __expectString(output[_D]);
    }
    if (output[_DBPGA] != null) {
        contents[_DBPGA] = __expectString(output[_DBPGA]);
    }
    return contents;
};
const de_DBParameterGroupAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBParameterGroupDetails = (output, context) => {
    const contents = {};
    if (output.Parameters === "") {
        contents[_Pa] = [];
    }
    else if (output[_Pa] != null && output[_Pa][_Par] != null) {
        contents[_Pa] = de_ParametersList(__getArrayIfSingleItem(output[_Pa][_Par]), context);
    }
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    return contents;
};
const de_DBParameterGroupList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBParameterGroup(entry, context);
    });
};
const de_DBParameterGroupNameMessage = (output, context) => {
    const contents = {};
    if (output[_DBPGN] != null) {
        contents[_DBPGN] = __expectString(output[_DBPGN]);
    }
    return contents;
};
const de_DBParameterGroupNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBParameterGroupQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBParameterGroupsMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.DBParameterGroups === "") {
        contents[_DBPGa] = [];
    }
    else if (output[_DBPGa] != null && output[_DBPGa][_DBPG] != null) {
        contents[_DBPGa] = de_DBParameterGroupList(__getArrayIfSingleItem(output[_DBPGa][_DBPG]), context);
    }
    return contents;
};
const de_DBParameterGroupStatus = (output, context) => {
    const contents = {};
    if (output[_DBPGN] != null) {
        contents[_DBPGN] = __expectString(output[_DBPGN]);
    }
    if (output[_PAS] != null) {
        contents[_PAS] = __expectString(output[_PAS]);
    }
    return contents;
};
const de_DBParameterGroupStatusList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBParameterGroupStatus(entry, context);
    });
};
const de_DBProxy = (output, context) => {
    const contents = {};
    if (output[_DBPN] != null) {
        contents[_DBPN] = __expectString(output[_DBPN]);
    }
    if (output[_DBPA] != null) {
        contents[_DBPA] = __expectString(output[_DBPA]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_EF] != null) {
        contents[_EF] = __expectString(output[_EF]);
    }
    if (output[_VI] != null) {
        contents[_VI] = __expectString(output[_VI]);
    }
    if (output.VpcSecurityGroupIds === "") {
        contents[_VSGI] = [];
    }
    else if (output[_VSGI] != null && output[_VSGI][_me] != null) {
        contents[_VSGI] = de_StringList(__getArrayIfSingleItem(output[_VSGI][_me]), context);
    }
    if (output.VpcSubnetIds === "") {
        contents[_VSI] = [];
    }
    else if (output[_VSI] != null && output[_VSI][_me] != null) {
        contents[_VSI] = de_StringList(__getArrayIfSingleItem(output[_VSI][_me]), context);
    }
    if (output.Auth === "") {
        contents[_Au] = [];
    }
    else if (output[_Au] != null && output[_Au][_me] != null) {
        contents[_Au] = de_UserAuthConfigInfoList(__getArrayIfSingleItem(output[_Au][_me]), context);
    }
    if (output[_RA] != null) {
        contents[_RA] = __expectString(output[_RA]);
    }
    if (output[_End] != null) {
        contents[_End] = __expectString(output[_End]);
    }
    if (output[_RTLS] != null) {
        contents[_RTLS] = __parseBoolean(output[_RTLS]);
    }
    if (output[_ICT] != null) {
        contents[_ICT] = __strictParseInt32(output[_ICT]);
    }
    if (output[_DL] != null) {
        contents[_DL] = __parseBoolean(output[_DL]);
    }
    if (output[_CDr] != null) {
        contents[_CDr] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CDr]));
    }
    if (output[_UD] != null) {
        contents[_UD] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_UD]));
    }
    return contents;
};
const de_DBProxyAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBProxyEndpoint = (output, context) => {
    const contents = {};
    if (output[_DBPEN] != null) {
        contents[_DBPEN] = __expectString(output[_DBPEN]);
    }
    if (output[_DBPEA] != null) {
        contents[_DBPEA] = __expectString(output[_DBPEA]);
    }
    if (output[_DBPN] != null) {
        contents[_DBPN] = __expectString(output[_DBPN]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_VI] != null) {
        contents[_VI] = __expectString(output[_VI]);
    }
    if (output.VpcSecurityGroupIds === "") {
        contents[_VSGI] = [];
    }
    else if (output[_VSGI] != null && output[_VSGI][_me] != null) {
        contents[_VSGI] = de_StringList(__getArrayIfSingleItem(output[_VSGI][_me]), context);
    }
    if (output.VpcSubnetIds === "") {
        contents[_VSI] = [];
    }
    else if (output[_VSI] != null && output[_VSI][_me] != null) {
        contents[_VSI] = de_StringList(__getArrayIfSingleItem(output[_VSI][_me]), context);
    }
    if (output[_End] != null) {
        contents[_End] = __expectString(output[_End]);
    }
    if (output[_CDr] != null) {
        contents[_CDr] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CDr]));
    }
    if (output[_TR] != null) {
        contents[_TR] = __expectString(output[_TR]);
    }
    if (output[_ID] != null) {
        contents[_ID] = __parseBoolean(output[_ID]);
    }
    return contents;
};
const de_DBProxyEndpointAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBProxyEndpointList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBProxyEndpoint(entry, context);
    });
};
const de_DBProxyEndpointNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBProxyEndpointQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBProxyList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBProxy(entry, context);
    });
};
const de_DBProxyNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBProxyQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBProxyTarget = (output, context) => {
    const contents = {};
    if (output[_TA] != null) {
        contents[_TA] = __expectString(output[_TA]);
    }
    if (output[_End] != null) {
        contents[_End] = __expectString(output[_End]);
    }
    if (output[_TCI] != null) {
        contents[_TCI] = __expectString(output[_TCI]);
    }
    if (output[_RRId] != null) {
        contents[_RRId] = __expectString(output[_RRId]);
    }
    if (output[_P] != null) {
        contents[_P] = __strictParseInt32(output[_P]);
    }
    if (output[_Ty] != null) {
        contents[_Ty] = __expectString(output[_Ty]);
    }
    if (output[_Ro] != null) {
        contents[_Ro] = __expectString(output[_Ro]);
    }
    if (output[_TH] != null) {
        contents[_TH] = de_TargetHealth(output[_TH], context);
    }
    return contents;
};
const de_DBProxyTargetAlreadyRegisteredFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBProxyTargetGroup = (output, context) => {
    const contents = {};
    if (output[_DBPN] != null) {
        contents[_DBPN] = __expectString(output[_DBPN]);
    }
    if (output[_TGN] != null) {
        contents[_TGN] = __expectString(output[_TGN]);
    }
    if (output[_TGA] != null) {
        contents[_TGA] = __expectString(output[_TGA]);
    }
    if (output[_ID] != null) {
        contents[_ID] = __parseBoolean(output[_ID]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_CPC] != null) {
        contents[_CPC] = de_ConnectionPoolConfigurationInfo(output[_CPC], context);
    }
    if (output[_CDr] != null) {
        contents[_CDr] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CDr]));
    }
    if (output[_UD] != null) {
        contents[_UD] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_UD]));
    }
    return contents;
};
const de_DBProxyTargetGroupNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBProxyTargetNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBRecommendation = (output, context) => {
    const contents = {};
    if (output[_RIe] != null) {
        contents[_RIe] = __expectString(output[_RIe]);
    }
    if (output[_TIy] != null) {
        contents[_TIy] = __expectString(output[_TIy]);
    }
    if (output[_Se] != null) {
        contents[_Se] = __expectString(output[_Se]);
    }
    if (output[_RAe] != null) {
        contents[_RAe] = __expectString(output[_RAe]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_CTre] != null) {
        contents[_CTre] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CTre]));
    }
    if (output[_UTp] != null) {
        contents[_UTp] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_UTp]));
    }
    if (output[_De] != null) {
        contents[_De] = __expectString(output[_De]);
    }
    if (output[_Re] != null) {
        contents[_Re] = __expectString(output[_Re]);
    }
    if (output[_D] != null) {
        contents[_D] = __expectString(output[_D]);
    }
    if (output[_Rea] != null) {
        contents[_Rea] = __expectString(output[_Rea]);
    }
    if (output.RecommendedActions === "") {
        contents[_RAec] = [];
    }
    else if (output[_RAec] != null && output[_RAec][_me] != null) {
        contents[_RAec] = de_RecommendedActionList(__getArrayIfSingleItem(output[_RAec][_me]), context);
    }
    if (output[_Ca] != null) {
        contents[_Ca] = __expectString(output[_Ca]);
    }
    if (output[_S] != null) {
        contents[_S] = __expectString(output[_S]);
    }
    if (output[_TDy] != null) {
        contents[_TDy] = __expectString(output[_TDy]);
    }
    if (output[_TRy] != null) {
        contents[_TRy] = __expectString(output[_TRy]);
    }
    if (output[_Imp] != null) {
        contents[_Imp] = __expectString(output[_Imp]);
    }
    if (output[_AId] != null) {
        contents[_AId] = __expectString(output[_AId]);
    }
    if (output.Links === "") {
        contents[_Li] = [];
    }
    else if (output[_Li] != null && output[_Li][_me] != null) {
        contents[_Li] = de_DocLinkList(__getArrayIfSingleItem(output[_Li][_me]), context);
    }
    if (output[_IDs] != null) {
        contents[_IDs] = de_IssueDetails(output[_IDs], context);
    }
    return contents;
};
const de_DBRecommendationList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBRecommendation(entry, context);
    });
};
const de_DBRecommendationMessage = (output, context) => {
    const contents = {};
    if (output[_DBR] != null) {
        contents[_DBR] = de_DBRecommendation(output[_DBR], context);
    }
    return contents;
};
const de_DBRecommendationsMessage = (output, context) => {
    const contents = {};
    if (output.DBRecommendations === "") {
        contents[_DBRe] = [];
    }
    else if (output[_DBRe] != null && output[_DBRe][_me] != null) {
        contents[_DBRe] = de_DBRecommendationList(__getArrayIfSingleItem(output[_DBRe][_me]), context);
    }
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    return contents;
};
const de_DBSecurityGroup = (output, context) => {
    const contents = {};
    if (output[_OI] != null) {
        contents[_OI] = __expectString(output[_OI]);
    }
    if (output[_DBSGN] != null) {
        contents[_DBSGN] = __expectString(output[_DBSGN]);
    }
    if (output[_DBSGD] != null) {
        contents[_DBSGD] = __expectString(output[_DBSGD]);
    }
    if (output[_VI] != null) {
        contents[_VI] = __expectString(output[_VI]);
    }
    if (output.EC2SecurityGroups === "") {
        contents[_ECSG] = [];
    }
    else if (output[_ECSG] != null && output[_ECSG][_ECSGe] != null) {
        contents[_ECSG] = de_EC2SecurityGroupList(__getArrayIfSingleItem(output[_ECSG][_ECSGe]), context);
    }
    if (output.IPRanges === "") {
        contents[_IPR] = [];
    }
    else if (output[_IPR] != null && output[_IPR][_IPRa] != null) {
        contents[_IPR] = de_IPRangeList(__getArrayIfSingleItem(output[_IPR][_IPRa]), context);
    }
    if (output[_DBSGA] != null) {
        contents[_DBSGA] = __expectString(output[_DBSGA]);
    }
    return contents;
};
const de_DBSecurityGroupAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBSecurityGroupMembership = (output, context) => {
    const contents = {};
    if (output[_DBSGN] != null) {
        contents[_DBSGN] = __expectString(output[_DBSGN]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    return contents;
};
const de_DBSecurityGroupMembershipList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBSecurityGroupMembership(entry, context);
    });
};
const de_DBSecurityGroupMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.DBSecurityGroups === "") {
        contents[_DBSG] = [];
    }
    else if (output[_DBSG] != null && output[_DBSG][_DBSGe] != null) {
        contents[_DBSG] = de_DBSecurityGroups(__getArrayIfSingleItem(output[_DBSG][_DBSGe]), context);
    }
    return contents;
};
const de_DBSecurityGroupNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBSecurityGroupNotSupportedFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBSecurityGroupQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBSecurityGroups = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBSecurityGroup(entry, context);
    });
};
const de_DBShardGroup = (output, context) => {
    const contents = {};
    if (output[_DBSGRI] != null) {
        contents[_DBSGRI] = __expectString(output[_DBSGRI]);
    }
    if (output[_DBSGI] != null) {
        contents[_DBSGI] = __expectString(output[_DBSGI]);
    }
    if (output[_DBCI] != null) {
        contents[_DBCI] = __expectString(output[_DBCI]);
    }
    if (output[_MACU] != null) {
        contents[_MACU] = __strictParseFloat(output[_MACU]);
    }
    if (output[_MACUi] != null) {
        contents[_MACUi] = __strictParseFloat(output[_MACUi]);
    }
    if (output[_CR] != null) {
        contents[_CR] = __strictParseInt32(output[_CR]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_PA] != null) {
        contents[_PA] = __parseBoolean(output[_PA]);
    }
    if (output[_End] != null) {
        contents[_End] = __expectString(output[_End]);
    }
    if (output[_DBSGAh] != null) {
        contents[_DBSGAh] = __expectString(output[_DBSGAh]);
    }
    if (output.TagList === "") {
        contents[_TL] = [];
    }
    else if (output[_TL] != null && output[_TL][_Tag] != null) {
        contents[_TL] = de_TagList(__getArrayIfSingleItem(output[_TL][_Tag]), context);
    }
    return contents;
};
const de_DBShardGroupAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBShardGroupNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBShardGroupsList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBShardGroup(entry, context);
    });
};
const de_DBSnapshot = (output, context) => {
    const contents = {};
    if (output[_DBSIn] != null) {
        contents[_DBSIn] = __expectString(output[_DBSIn]);
    }
    if (output[_DBII] != null) {
        contents[_DBII] = __expectString(output[_DBII]);
    }
    if (output[_SCT] != null) {
        contents[_SCT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_SCT]));
    }
    if (output[_E] != null) {
        contents[_E] = __expectString(output[_E]);
    }
    if (output[_AS] != null) {
        contents[_AS] = __strictParseInt32(output[_AS]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_P] != null) {
        contents[_P] = __strictParseInt32(output[_P]);
    }
    if (output[_AZv] != null) {
        contents[_AZv] = __expectString(output[_AZv]);
    }
    if (output[_VI] != null) {
        contents[_VI] = __expectString(output[_VI]);
    }
    if (output[_ICTn] != null) {
        contents[_ICTn] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_ICTn]));
    }
    if (output[_MU] != null) {
        contents[_MU] = __expectString(output[_MU]);
    }
    if (output[_EV] != null) {
        contents[_EV] = __expectString(output[_EV]);
    }
    if (output[_LM] != null) {
        contents[_LM] = __expectString(output[_LM]);
    }
    if (output[_STn] != null) {
        contents[_STn] = __expectString(output[_STn]);
    }
    if (output[_I] != null) {
        contents[_I] = __strictParseInt32(output[_I]);
    }
    if (output[_OGN] != null) {
        contents[_OGN] = __expectString(output[_OGN]);
    }
    if (output[_PP] != null) {
        contents[_PP] = __strictParseInt32(output[_PP]);
    }
    if (output[_SR] != null) {
        contents[_SR] = __expectString(output[_SR]);
    }
    if (output[_SDBSI] != null) {
        contents[_SDBSI] = __expectString(output[_SDBSI]);
    }
    if (output[_STt] != null) {
        contents[_STt] = __expectString(output[_STt]);
    }
    if (output[_TCA] != null) {
        contents[_TCA] = __expectString(output[_TCA]);
    }
    if (output[_Enc] != null) {
        contents[_Enc] = __parseBoolean(output[_Enc]);
    }
    if (output[_KKI] != null) {
        contents[_KKI] = __expectString(output[_KKI]);
    }
    if (output[_DBSA] != null) {
        contents[_DBSA] = __expectString(output[_DBSA]);
    }
    if (output[_Ti] != null) {
        contents[_Ti] = __expectString(output[_Ti]);
    }
    if (output[_IAMDAE] != null) {
        contents[_IAMDAE] = __parseBoolean(output[_IAMDAE]);
    }
    if (output.ProcessorFeatures === "") {
        contents[_PF] = [];
    }
    else if (output[_PF] != null && output[_PF][_PFr] != null) {
        contents[_PF] = de_ProcessorFeatureList(__getArrayIfSingleItem(output[_PF][_PFr]), context);
    }
    if (output[_DRI] != null) {
        contents[_DRI] = __expectString(output[_DRI]);
    }
    if (output.TagList === "") {
        contents[_TL] = [];
    }
    else if (output[_TL] != null && output[_TL][_Tag] != null) {
        contents[_TL] = de_TagList(__getArrayIfSingleItem(output[_TL][_Tag]), context);
    }
    if (output[_OSCT] != null) {
        contents[_OSCT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_OSCT]));
    }
    if (output[_SDT] != null) {
        contents[_SDT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_SDT]));
    }
    if (output[_ST] != null) {
        contents[_ST] = __expectString(output[_ST]);
    }
    if (output[_STto] != null) {
        contents[_STto] = __strictParseInt32(output[_STto]);
    }
    if (output[_DBSI] != null) {
        contents[_DBSI] = __expectString(output[_DBSI]);
    }
    if (output[_DLV] != null) {
        contents[_DLV] = __parseBoolean(output[_DLV]);
    }
    if (output[_MT] != null) {
        contents[_MT] = __parseBoolean(output[_MT]);
    }
    if (output[_SAZ] != null) {
        contents[_SAZ] = __expectString(output[_SAZ]);
    }
    return contents;
};
const de_DBSnapshotAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBSnapshotAttribute = (output, context) => {
    const contents = {};
    if (output[_AN] != null) {
        contents[_AN] = __expectString(output[_AN]);
    }
    if (output.AttributeValues === "") {
        contents[_AVt] = [];
    }
    else if (output[_AVt] != null && output[_AVt][_AVtt] != null) {
        contents[_AVt] = de_AttributeValueList(__getArrayIfSingleItem(output[_AVt][_AVtt]), context);
    }
    return contents;
};
const de_DBSnapshotAttributeList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBSnapshotAttribute(entry, context);
    });
};
const de_DBSnapshotAttributesResult = (output, context) => {
    const contents = {};
    if (output[_DBSIn] != null) {
        contents[_DBSIn] = __expectString(output[_DBSIn]);
    }
    if (output.DBSnapshotAttributes === "") {
        contents[_DBSAn] = [];
    }
    else if (output[_DBSAn] != null && output[_DBSAn][_DBSAna] != null) {
        contents[_DBSAn] = de_DBSnapshotAttributeList(__getArrayIfSingleItem(output[_DBSAn][_DBSAna]), context);
    }
    return contents;
};
const de_DBSnapshotList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBSnapshot(entry, context);
    });
};
const de_DBSnapshotMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.DBSnapshots === "") {
        contents[_DBSn] = [];
    }
    else if (output[_DBSn] != null && output[_DBSn][_DBS] != null) {
        contents[_DBSn] = de_DBSnapshotList(__getArrayIfSingleItem(output[_DBSn][_DBS]), context);
    }
    return contents;
};
const de_DBSnapshotNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBSnapshotTenantDatabase = (output, context) => {
    const contents = {};
    if (output[_DBSIn] != null) {
        contents[_DBSIn] = __expectString(output[_DBSIn]);
    }
    if (output[_DBII] != null) {
        contents[_DBII] = __expectString(output[_DBII]);
    }
    if (output[_DRI] != null) {
        contents[_DRI] = __expectString(output[_DRI]);
    }
    if (output[_EN] != null) {
        contents[_EN] = __expectString(output[_EN]);
    }
    if (output[_STn] != null) {
        contents[_STn] = __expectString(output[_STn]);
    }
    if (output[_TDCT] != null) {
        contents[_TDCT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_TDCT]));
    }
    if (output[_TDBN] != null) {
        contents[_TDBN] = __expectString(output[_TDBN]);
    }
    if (output[_MU] != null) {
        contents[_MU] = __expectString(output[_MU]);
    }
    if (output[_TDRI] != null) {
        contents[_TDRI] = __expectString(output[_TDRI]);
    }
    if (output[_CSN] != null) {
        contents[_CSN] = __expectString(output[_CSN]);
    }
    if (output[_DBSTDARN] != null) {
        contents[_DBSTDARN] = __expectString(output[_DBSTDARN]);
    }
    if (output[_NCSN] != null) {
        contents[_NCSN] = __expectString(output[_NCSN]);
    }
    if (output.TagList === "") {
        contents[_TL] = [];
    }
    else if (output[_TL] != null && output[_TL][_Tag] != null) {
        contents[_TL] = de_TagList(__getArrayIfSingleItem(output[_TL][_Tag]), context);
    }
    return contents;
};
const de_DBSnapshotTenantDatabaseNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBSnapshotTenantDatabasesList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBSnapshotTenantDatabase(entry, context);
    });
};
const de_DBSnapshotTenantDatabasesMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.DBSnapshotTenantDatabases === "") {
        contents[_DBSTD] = [];
    }
    else if (output[_DBSTD] != null && output[_DBSTD][_DBSTDn] != null) {
        contents[_DBSTD] = de_DBSnapshotTenantDatabasesList(__getArrayIfSingleItem(output[_DBSTD][_DBSTDn]), context);
    }
    return contents;
};
const de_DBSubnetGroup = (output, context) => {
    const contents = {};
    if (output[_DBSGNu] != null) {
        contents[_DBSGNu] = __expectString(output[_DBSGNu]);
    }
    if (output[_DBSGDu] != null) {
        contents[_DBSGDu] = __expectString(output[_DBSGDu]);
    }
    if (output[_VI] != null) {
        contents[_VI] = __expectString(output[_VI]);
    }
    if (output[_SGS] != null) {
        contents[_SGS] = __expectString(output[_SGS]);
    }
    if (output.Subnets === "") {
        contents[_Su] = [];
    }
    else if (output[_Su] != null && output[_Su][_Sub] != null) {
        contents[_Su] = de_SubnetList(__getArrayIfSingleItem(output[_Su][_Sub]), context);
    }
    if (output[_DBSGAu] != null) {
        contents[_DBSGAu] = __expectString(output[_DBSGAu]);
    }
    if (output.SupportedNetworkTypes === "") {
        contents[_SNT] = [];
    }
    else if (output[_SNT] != null && output[_SNT][_me] != null) {
        contents[_SNT] = de_StringList(__getArrayIfSingleItem(output[_SNT][_me]), context);
    }
    return contents;
};
const de_DBSubnetGroupAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBSubnetGroupDoesNotCoverEnoughAZs = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBSubnetGroupMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.DBSubnetGroups === "") {
        contents[_DBSGub] = [];
    }
    else if (output[_DBSGub] != null && output[_DBSGub][_DBSGu] != null) {
        contents[_DBSGub] = de_DBSubnetGroups(__getArrayIfSingleItem(output[_DBSGub][_DBSGu]), context);
    }
    return contents;
};
const de_DBSubnetGroupNotAllowedFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBSubnetGroupNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBSubnetGroupQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBSubnetGroups = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBSubnetGroup(entry, context);
    });
};
const de_DBSubnetQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DBUpgradeDependencyFailureFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DeleteBlueGreenDeploymentResponse = (output, context) => {
    const contents = {};
    if (output[_BGD] != null) {
        contents[_BGD] = de_BlueGreenDeployment(output[_BGD], context);
    }
    return contents;
};
const de_DeleteDBClusterAutomatedBackupResult = (output, context) => {
    const contents = {};
    if (output[_DBCABl] != null) {
        contents[_DBCABl] = de_DBClusterAutomatedBackup(output[_DBCABl], context);
    }
    return contents;
};
const de_DeleteDBClusterResult = (output, context) => {
    const contents = {};
    if (output[_DBC] != null) {
        contents[_DBC] = de_DBCluster(output[_DBC], context);
    }
    return contents;
};
const de_DeleteDBClusterSnapshotResult = (output, context) => {
    const contents = {};
    if (output[_DBCS] != null) {
        contents[_DBCS] = de_DBClusterSnapshot(output[_DBCS], context);
    }
    return contents;
};
const de_DeleteDBInstanceAutomatedBackupResult = (output, context) => {
    const contents = {};
    if (output[_DBIABn] != null) {
        contents[_DBIABn] = de_DBInstanceAutomatedBackup(output[_DBIABn], context);
    }
    return contents;
};
const de_DeleteDBInstanceResult = (output, context) => {
    const contents = {};
    if (output[_DBI] != null) {
        contents[_DBI] = de_DBInstance(output[_DBI], context);
    }
    return contents;
};
const de_DeleteDBProxyEndpointResponse = (output, context) => {
    const contents = {};
    if (output[_DBPE] != null) {
        contents[_DBPE] = de_DBProxyEndpoint(output[_DBPE], context);
    }
    return contents;
};
const de_DeleteDBProxyResponse = (output, context) => {
    const contents = {};
    if (output[_DBP] != null) {
        contents[_DBP] = de_DBProxy(output[_DBP], context);
    }
    return contents;
};
const de_DeleteDBSnapshotResult = (output, context) => {
    const contents = {};
    if (output[_DBS] != null) {
        contents[_DBS] = de_DBSnapshot(output[_DBS], context);
    }
    return contents;
};
const de_DeleteEventSubscriptionResult = (output, context) => {
    const contents = {};
    if (output[_ES] != null) {
        contents[_ES] = de_EventSubscription(output[_ES], context);
    }
    return contents;
};
const de_DeleteGlobalClusterResult = (output, context) => {
    const contents = {};
    if (output[_GC] != null) {
        contents[_GC] = de_GlobalCluster(output[_GC], context);
    }
    return contents;
};
const de_DeleteTenantDatabaseResult = (output, context) => {
    const contents = {};
    if (output[_TD] != null) {
        contents[_TD] = de_TenantDatabase(output[_TD], context);
    }
    return contents;
};
const de_DeregisterDBProxyTargetsResponse = (output, context) => {
    const contents = {};
    return contents;
};
const de_DescribeBlueGreenDeploymentsResponse = (output, context) => {
    const contents = {};
    if (output.BlueGreenDeployments === "") {
        contents[_BGDl] = [];
    }
    else if (output[_BGDl] != null && output[_BGDl][_me] != null) {
        contents[_BGDl] = de_BlueGreenDeploymentList(__getArrayIfSingleItem(output[_BGDl][_me]), context);
    }
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    return contents;
};
const de_DescribeDBClusterSnapshotAttributesResult = (output, context) => {
    const contents = {};
    if (output[_DBCSAR] != null) {
        contents[_DBCSAR] = de_DBClusterSnapshotAttributesResult(output[_DBCSAR], context);
    }
    return contents;
};
const de_DescribeDBLogFilesDetails = (output, context) => {
    const contents = {};
    if (output[_LFN] != null) {
        contents[_LFN] = __expectString(output[_LFN]);
    }
    if (output[_LW] != null) {
        contents[_LW] = __strictParseLong(output[_LW]);
    }
    if (output[_Si] != null) {
        contents[_Si] = __strictParseLong(output[_Si]);
    }
    return contents;
};
const de_DescribeDBLogFilesList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DescribeDBLogFilesDetails(entry, context);
    });
};
const de_DescribeDBLogFilesResponse = (output, context) => {
    const contents = {};
    if (output.DescribeDBLogFiles === "") {
        contents[_DDBLF] = [];
    }
    else if (output[_DDBLF] != null && output[_DDBLF][_DDBLFD] != null) {
        contents[_DDBLF] = de_DescribeDBLogFilesList(__getArrayIfSingleItem(output[_DDBLF][_DDBLFD]), context);
    }
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    return contents;
};
const de_DescribeDBMajorEngineVersionsResponse = (output, context) => {
    const contents = {};
    if (output.DBMajorEngineVersions === "") {
        contents[_DBMEV] = [];
    }
    else if (output[_DBMEV] != null && output[_DBMEV][_DBMEVa] != null) {
        contents[_DBMEV] = de_DBMajorEngineVersionsList(__getArrayIfSingleItem(output[_DBMEV][_DBMEVa]), context);
    }
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    return contents;
};
const de_DescribeDBProxiesResponse = (output, context) => {
    const contents = {};
    if (output.DBProxies === "") {
        contents[_DBPr] = [];
    }
    else if (output[_DBPr] != null && output[_DBPr][_me] != null) {
        contents[_DBPr] = de_DBProxyList(__getArrayIfSingleItem(output[_DBPr][_me]), context);
    }
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    return contents;
};
const de_DescribeDBProxyEndpointsResponse = (output, context) => {
    const contents = {};
    if (output.DBProxyEndpoints === "") {
        contents[_DBPEr] = [];
    }
    else if (output[_DBPEr] != null && output[_DBPEr][_me] != null) {
        contents[_DBPEr] = de_DBProxyEndpointList(__getArrayIfSingleItem(output[_DBPEr][_me]), context);
    }
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    return contents;
};
const de_DescribeDBProxyTargetGroupsResponse = (output, context) => {
    const contents = {};
    if (output.TargetGroups === "") {
        contents[_TG] = [];
    }
    else if (output[_TG] != null && output[_TG][_me] != null) {
        contents[_TG] = de_TargetGroupList(__getArrayIfSingleItem(output[_TG][_me]), context);
    }
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    return contents;
};
const de_DescribeDBProxyTargetsResponse = (output, context) => {
    const contents = {};
    if (output.Targets === "") {
        contents[_Tar] = [];
    }
    else if (output[_Tar] != null && output[_Tar][_me] != null) {
        contents[_Tar] = de_TargetList(__getArrayIfSingleItem(output[_Tar][_me]), context);
    }
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    return contents;
};
const de_DescribeDBShardGroupsResponse = (output, context) => {
    const contents = {};
    if (output.DBShardGroups === "") {
        contents[_DBSGh] = [];
    }
    else if (output[_DBSGh] != null && output[_DBSGh][_DBSGha] != null) {
        contents[_DBSGh] = de_DBShardGroupsList(__getArrayIfSingleItem(output[_DBSGh][_DBSGha]), context);
    }
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    return contents;
};
const de_DescribeDBSnapshotAttributesResult = (output, context) => {
    const contents = {};
    if (output[_DBSAR] != null) {
        contents[_DBSAR] = de_DBSnapshotAttributesResult(output[_DBSAR], context);
    }
    return contents;
};
const de_DescribeEngineDefaultClusterParametersResult = (output, context) => {
    const contents = {};
    if (output[_ED] != null) {
        contents[_ED] = de_EngineDefaults(output[_ED], context);
    }
    return contents;
};
const de_DescribeEngineDefaultParametersResult = (output, context) => {
    const contents = {};
    if (output[_ED] != null) {
        contents[_ED] = de_EngineDefaults(output[_ED], context);
    }
    return contents;
};
const de_DescribeIntegrationsResponse = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.Integrations === "") {
        contents[_In] = [];
    }
    else if (output[_In] != null && output[_In][_Int] != null) {
        contents[_In] = de_IntegrationList(__getArrayIfSingleItem(output[_In][_Int]), context);
    }
    return contents;
};
const de_DescribeValidDBInstanceModificationsResult = (output, context) => {
    const contents = {};
    if (output[_VDBIMM] != null) {
        contents[_VDBIMM] = de_ValidDBInstanceModificationsMessage(output[_VDBIMM], context);
    }
    return contents;
};
const de_DisableHttpEndpointResponse = (output, context) => {
    const contents = {};
    if (output[_RAe] != null) {
        contents[_RAe] = __expectString(output[_RAe]);
    }
    if (output[_HEE] != null) {
        contents[_HEE] = __parseBoolean(output[_HEE]);
    }
    return contents;
};
const de_DocLink = (output, context) => {
    const contents = {};
    if (output[_Te] != null) {
        contents[_Te] = __expectString(output[_Te]);
    }
    if (output[_Ur] != null) {
        contents[_Ur] = __expectString(output[_Ur]);
    }
    return contents;
};
const de_DocLinkList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DocLink(entry, context);
    });
};
const de_DomainMembership = (output, context) => {
    const contents = {};
    if (output[_Do] != null) {
        contents[_Do] = __expectString(output[_Do]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_FQDN] != null) {
        contents[_FQDN] = __expectString(output[_FQDN]);
    }
    if (output[_IAMRN] != null) {
        contents[_IAMRN] = __expectString(output[_IAMRN]);
    }
    if (output[_OU] != null) {
        contents[_OU] = __expectString(output[_OU]);
    }
    if (output[_ASA] != null) {
        contents[_ASA] = __expectString(output[_ASA]);
    }
    if (output.DnsIps === "") {
        contents[_DIn] = [];
    }
    else if (output[_DIn] != null && output[_DIn][_me] != null) {
        contents[_DIn] = de_StringList(__getArrayIfSingleItem(output[_DIn][_me]), context);
    }
    return contents;
};
const de_DomainMembershipList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DomainMembership(entry, context);
    });
};
const de_DomainNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_DoubleRange = (output, context) => {
    const contents = {};
    if (output[_Fr] != null) {
        contents[_Fr] = __strictParseFloat(output[_Fr]);
    }
    if (output[_To] != null) {
        contents[_To] = __strictParseFloat(output[_To]);
    }
    return contents;
};
const de_DoubleRangeList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DoubleRange(entry, context);
    });
};
const de_DownloadDBLogFilePortionDetails = (output, context) => {
    const contents = {};
    if (output[_LFD] != null) {
        contents[_LFD] = __expectString(output[_LFD]);
    }
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output[_ADP] != null) {
        contents[_ADP] = __parseBoolean(output[_ADP]);
    }
    return contents;
};
const de_Ec2ImagePropertiesNotSupportedFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_EC2SecurityGroup = (output, context) => {
    const contents = {};
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_ECSGN] != null) {
        contents[_ECSGN] = __expectString(output[_ECSGN]);
    }
    if (output[_ECSGI] != null) {
        contents[_ECSGI] = __expectString(output[_ECSGI]);
    }
    if (output[_ECSGOI] != null) {
        contents[_ECSGOI] = __expectString(output[_ECSGOI]);
    }
    return contents;
};
const de_EC2SecurityGroupList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_EC2SecurityGroup(entry, context);
    });
};
const de_EnableHttpEndpointResponse = (output, context) => {
    const contents = {};
    if (output[_RAe] != null) {
        contents[_RAe] = __expectString(output[_RAe]);
    }
    if (output[_HEE] != null) {
        contents[_HEE] = __parseBoolean(output[_HEE]);
    }
    return contents;
};
const de_EncryptionContextMap = (output, context) => {
    return output.reduce((acc, pair) => {
        if (pair["value"] === null) {
            return acc;
        }
        acc[pair["key"]] = __expectString(pair["value"]);
        return acc;
    }, {});
};
const de_Endpoint = (output, context) => {
    const contents = {};
    if (output[_Ad] != null) {
        contents[_Ad] = __expectString(output[_Ad]);
    }
    if (output[_P] != null) {
        contents[_P] = __strictParseInt32(output[_P]);
    }
    if (output[_HZI] != null) {
        contents[_HZI] = __expectString(output[_HZI]);
    }
    return contents;
};
const de_EngineDefaults = (output, context) => {
    const contents = {};
    if (output[_DBPGF] != null) {
        contents[_DBPGF] = __expectString(output[_DBPGF]);
    }
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.Parameters === "") {
        contents[_Pa] = [];
    }
    else if (output[_Pa] != null && output[_Pa][_Par] != null) {
        contents[_Pa] = de_ParametersList(__getArrayIfSingleItem(output[_Pa][_Par]), context);
    }
    return contents;
};
const de_EngineModeList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_Event = (output, context) => {
    const contents = {};
    if (output[_SI] != null) {
        contents[_SI] = __expectString(output[_SI]);
    }
    if (output[_STo] != null) {
        contents[_STo] = __expectString(output[_STo]);
    }
    if (output[_Me] != null) {
        contents[_Me] = __expectString(output[_Me]);
    }
    if (output.EventCategories === "") {
        contents[_EC] = [];
    }
    else if (output[_EC] != null && output[_EC][_ECv] != null) {
        contents[_EC] = de_EventCategoriesList(__getArrayIfSingleItem(output[_EC][_ECv]), context);
    }
    if (output[_Da] != null) {
        contents[_Da] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_Da]));
    }
    if (output[_SA] != null) {
        contents[_SA] = __expectString(output[_SA]);
    }
    return contents;
};
const de_EventCategoriesList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_EventCategoriesMap = (output, context) => {
    const contents = {};
    if (output[_STo] != null) {
        contents[_STo] = __expectString(output[_STo]);
    }
    if (output.EventCategories === "") {
        contents[_EC] = [];
    }
    else if (output[_EC] != null && output[_EC][_ECv] != null) {
        contents[_EC] = de_EventCategoriesList(__getArrayIfSingleItem(output[_EC][_ECv]), context);
    }
    return contents;
};
const de_EventCategoriesMapList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_EventCategoriesMap(entry, context);
    });
};
const de_EventCategoriesMessage = (output, context) => {
    const contents = {};
    if (output.EventCategoriesMapList === "") {
        contents[_ECML] = [];
    }
    else if (output[_ECML] != null && output[_ECML][_ECM] != null) {
        contents[_ECML] = de_EventCategoriesMapList(__getArrayIfSingleItem(output[_ECML][_ECM]), context);
    }
    return contents;
};
const de_EventList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Event(entry, context);
    });
};
const de_EventsMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.Events === "") {
        contents[_Ev] = [];
    }
    else if (output[_Ev] != null && output[_Ev][_Eve] != null) {
        contents[_Ev] = de_EventList(__getArrayIfSingleItem(output[_Ev][_Eve]), context);
    }
    return contents;
};
const de_EventSubscription = (output, context) => {
    const contents = {};
    if (output[_CAIu] != null) {
        contents[_CAIu] = __expectString(output[_CAIu]);
    }
    if (output[_CSI] != null) {
        contents[_CSI] = __expectString(output[_CSI]);
    }
    if (output[_STA] != null) {
        contents[_STA] = __expectString(output[_STA]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_SCTu] != null) {
        contents[_SCTu] = __expectString(output[_SCTu]);
    }
    if (output[_STo] != null) {
        contents[_STo] = __expectString(output[_STo]);
    }
    if (output.SourceIdsList === "") {
        contents[_SIL] = [];
    }
    else if (output[_SIL] != null && output[_SIL][_SIou] != null) {
        contents[_SIL] = de_SourceIdsList(__getArrayIfSingleItem(output[_SIL][_SIou]), context);
    }
    if (output.EventCategoriesList === "") {
        contents[_ECL] = [];
    }
    else if (output[_ECL] != null && output[_ECL][_ECv] != null) {
        contents[_ECL] = de_EventCategoriesList(__getArrayIfSingleItem(output[_ECL][_ECv]), context);
    }
    if (output[_En] != null) {
        contents[_En] = __parseBoolean(output[_En]);
    }
    if (output[_ESA] != null) {
        contents[_ESA] = __expectString(output[_ESA]);
    }
    return contents;
};
const de_EventSubscriptionQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_EventSubscriptionsList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_EventSubscription(entry, context);
    });
};
const de_EventSubscriptionsMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.EventSubscriptionsList === "") {
        contents[_ESL] = [];
    }
    else if (output[_ESL] != null && output[_ESL][_ES] != null) {
        contents[_ESL] = de_EventSubscriptionsList(__getArrayIfSingleItem(output[_ESL][_ES]), context);
    }
    return contents;
};
const de_ExportTask = (output, context) => {
    const contents = {};
    if (output[_ETI] != null) {
        contents[_ETI] = __expectString(output[_ETI]);
    }
    if (output[_SA] != null) {
        contents[_SA] = __expectString(output[_SA]);
    }
    if (output.ExportOnly === "") {
        contents[_EO] = [];
    }
    else if (output[_EO] != null && output[_EO][_me] != null) {
        contents[_EO] = de_StringList(__getArrayIfSingleItem(output[_EO][_me]), context);
    }
    if (output[_STna] != null) {
        contents[_STna] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_STna]));
    }
    if (output[_TSTas] != null) {
        contents[_TSTas] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_TSTas]));
    }
    if (output[_TET] != null) {
        contents[_TET] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_TET]));
    }
    if (output[_SBu] != null) {
        contents[_SBu] = __expectString(output[_SBu]);
    }
    if (output[_SP] != null) {
        contents[_SP] = __expectString(output[_SP]);
    }
    if (output[_IRA] != null) {
        contents[_IRA] = __expectString(output[_IRA]);
    }
    if (output[_KKI] != null) {
        contents[_KKI] = __expectString(output[_KKI]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_PP] != null) {
        contents[_PP] = __strictParseInt32(output[_PP]);
    }
    if (output[_TEDIGB] != null) {
        contents[_TEDIGB] = __strictParseInt32(output[_TEDIGB]);
    }
    if (output[_FCa] != null) {
        contents[_FCa] = __expectString(output[_FCa]);
    }
    if (output[_WM] != null) {
        contents[_WM] = __expectString(output[_WM]);
    }
    if (output[_STo] != null) {
        contents[_STo] = __expectString(output[_STo]);
    }
    return contents;
};
const de_ExportTaskAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_ExportTaskNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_ExportTasksList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ExportTask(entry, context);
    });
};
const de_ExportTasksMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.ExportTasks === "") {
        contents[_ETx] = [];
    }
    else if (output[_ETx] != null && output[_ETx][_ETxp] != null) {
        contents[_ETx] = de_ExportTasksList(__getArrayIfSingleItem(output[_ETx][_ETxp]), context);
    }
    return contents;
};
const de_FailoverDBClusterResult = (output, context) => {
    const contents = {};
    if (output[_DBC] != null) {
        contents[_DBC] = de_DBCluster(output[_DBC], context);
    }
    return contents;
};
const de_FailoverGlobalClusterResult = (output, context) => {
    const contents = {};
    if (output[_GC] != null) {
        contents[_GC] = de_GlobalCluster(output[_GC], context);
    }
    return contents;
};
const de_FailoverState = (output, context) => {
    const contents = {};
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_FDCA] != null) {
        contents[_FDCA] = __expectString(output[_FDCA]);
    }
    if (output[_TDCA] != null) {
        contents[_TDCA] = __expectString(output[_TDCA]);
    }
    if (output[_IDLA] != null) {
        contents[_IDLA] = __parseBoolean(output[_IDLA]);
    }
    return contents;
};
const de_FeatureNameList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_GlobalCluster = (output, context) => {
    const contents = {};
    if (output[_GCI] != null) {
        contents[_GCI] = __expectString(output[_GCI]);
    }
    if (output[_GCRI] != null) {
        contents[_GCRI] = __expectString(output[_GCRI]);
    }
    if (output[_GCA] != null) {
        contents[_GCA] = __expectString(output[_GCA]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_E] != null) {
        contents[_E] = __expectString(output[_E]);
    }
    if (output[_EV] != null) {
        contents[_EV] = __expectString(output[_EV]);
    }
    if (output[_ELS] != null) {
        contents[_ELS] = __expectString(output[_ELS]);
    }
    if (output[_DN] != null) {
        contents[_DN] = __expectString(output[_DN]);
    }
    if (output[_SE] != null) {
        contents[_SE] = __parseBoolean(output[_SE]);
    }
    if (output[_DP] != null) {
        contents[_DP] = __parseBoolean(output[_DP]);
    }
    if (output.GlobalClusterMembers === "") {
        contents[_GCM] = [];
    }
    else if (output[_GCM] != null && output[_GCM][_GCMl] != null) {
        contents[_GCM] = de_GlobalClusterMemberList(__getArrayIfSingleItem(output[_GCM][_GCMl]), context);
    }
    if (output[_End] != null) {
        contents[_End] = __expectString(output[_End]);
    }
    if (output[_FSa] != null) {
        contents[_FSa] = de_FailoverState(output[_FSa], context);
    }
    if (output.TagList === "") {
        contents[_TL] = [];
    }
    else if (output[_TL] != null && output[_TL][_Tag] != null) {
        contents[_TL] = de_TagList(__getArrayIfSingleItem(output[_TL][_Tag]), context);
    }
    return contents;
};
const de_GlobalClusterAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_GlobalClusterList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_GlobalCluster(entry, context);
    });
};
const de_GlobalClusterMember = (output, context) => {
    const contents = {};
    if (output[_DBCA] != null) {
        contents[_DBCA] = __expectString(output[_DBCA]);
    }
    if (output.Readers === "") {
        contents[_Read] = [];
    }
    else if (output[_Read] != null && output[_Read][_me] != null) {
        contents[_Read] = de_ReadersArnList(__getArrayIfSingleItem(output[_Read][_me]), context);
    }
    if (output[_IW] != null) {
        contents[_IW] = __parseBoolean(output[_IW]);
    }
    if (output[_GWFS] != null) {
        contents[_GWFS] = __expectString(output[_GWFS]);
    }
    if (output[_SS] != null) {
        contents[_SS] = __expectString(output[_SS]);
    }
    return contents;
};
const de_GlobalClusterMemberList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_GlobalClusterMember(entry, context);
    });
};
const de_GlobalClusterNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_GlobalClusterQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_GlobalClustersMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.GlobalClusters === "") {
        contents[_GCl] = [];
    }
    else if (output[_GCl] != null && output[_GCl][_GCMl] != null) {
        contents[_GCl] = de_GlobalClusterList(__getArrayIfSingleItem(output[_GCl][_GCMl]), context);
    }
    return contents;
};
const de_IamRoleMissingPermissionsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_IamRoleNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InstanceQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InsufficientAvailableIPsInSubnetFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InsufficientDBClusterCapacityFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InsufficientDBInstanceCapacityFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InsufficientStorageClusterCapacityFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_Integration = (output, context) => {
    const contents = {};
    if (output[_SA] != null) {
        contents[_SA] = __expectString(output[_SA]);
    }
    if (output[_TA] != null) {
        contents[_TA] = __expectString(output[_TA]);
    }
    if (output[_IN] != null) {
        contents[_IN] = __expectString(output[_IN]);
    }
    if (output[_IAn] != null) {
        contents[_IAn] = __expectString(output[_IAn]);
    }
    if (output[_KMSKI] != null) {
        contents[_KMSKI] = __expectString(output[_KMSKI]);
    }
    if (output.AdditionalEncryptionContext === "") {
        contents[_AEC] = {};
    }
    else if (output[_AEC] != null && output[_AEC][_e] != null) {
        contents[_AEC] = de_EncryptionContextMap(__getArrayIfSingleItem(output[_AEC][_e]), context);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output.Tags === "") {
        contents[_T] = [];
    }
    else if (output[_T] != null && output[_T][_Tag] != null) {
        contents[_T] = de_TagList(__getArrayIfSingleItem(output[_T][_Tag]), context);
    }
    if (output[_CTr] != null) {
        contents[_CTr] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CTr]));
    }
    if (output.Errors === "") {
        contents[_Er] = [];
    }
    else if (output[_Er] != null && output[_Er][_IE] != null) {
        contents[_Er] = de_IntegrationErrorList(__getArrayIfSingleItem(output[_Er][_IE]), context);
    }
    if (output[_DFa] != null) {
        contents[_DFa] = __expectString(output[_DFa]);
    }
    if (output[_D] != null) {
        contents[_D] = __expectString(output[_D]);
    }
    return contents;
};
const de_IntegrationAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_IntegrationConflictOperationFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_IntegrationError = (output, context) => {
    const contents = {};
    if (output[_ECr] != null) {
        contents[_ECr] = __expectString(output[_ECr]);
    }
    if (output[_EMr] != null) {
        contents[_EMr] = __expectString(output[_EMr]);
    }
    return contents;
};
const de_IntegrationErrorList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_IntegrationError(entry, context);
    });
};
const de_IntegrationList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Integration(entry, context);
    });
};
const de_IntegrationNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_IntegrationQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidBlueGreenDeploymentStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidCustomDBEngineVersionStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidDBClusterAutomatedBackupStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidDBClusterCapacityFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidDBClusterEndpointStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidDBClusterSnapshotStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidDBClusterStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidDBInstanceAutomatedBackupStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidDBInstanceStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidDBParameterGroupStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidDBProxyEndpointStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidDBProxyStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidDBSecurityGroupStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidDBShardGroupStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidDBSnapshotStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidDBSubnetGroupFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidDBSubnetGroupStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidDBSubnetStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidEventSubscriptionStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidExportOnlyFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidExportSourceStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidExportTaskStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidGlobalClusterStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidIntegrationStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidOptionGroupStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidResourceStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidRestoreFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidS3BucketFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidSubnet = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_InvalidVPCNetworkStateFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_IPRange = (output, context) => {
    const contents = {};
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_CIDRIP] != null) {
        contents[_CIDRIP] = __expectString(output[_CIDRIP]);
    }
    return contents;
};
const de_IPRangeList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_IPRange(entry, context);
    });
};
const de_IssueDetails = (output, context) => {
    const contents = {};
    if (output[_PID] != null) {
        contents[_PID] = de_PerformanceIssueDetails(output[_PID], context);
    }
    return contents;
};
const de_KMSKeyNotAccessibleFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_LimitlessDatabase = (output, context) => {
    const contents = {};
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_MRACU] != null) {
        contents[_MRACU] = __strictParseFloat(output[_MRACU]);
    }
    return contents;
};
const de_LogTypeList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_MasterUserSecret = (output, context) => {
    const contents = {};
    if (output[_SAe] != null) {
        contents[_SAe] = __expectString(output[_SAe]);
    }
    if (output[_SSe] != null) {
        contents[_SSe] = __expectString(output[_SSe]);
    }
    if (output[_KKI] != null) {
        contents[_KKI] = __expectString(output[_KKI]);
    }
    return contents;
};
const de_MaxDBShardGroupLimitReached = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_Metric = (output, context) => {
    const contents = {};
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output.References === "") {
        contents[_Ref] = [];
    }
    else if (output[_Ref] != null && output[_Ref][_me] != null) {
        contents[_Ref] = de_MetricReferenceList(__getArrayIfSingleItem(output[_Ref][_me]), context);
    }
    if (output[_SDta] != null) {
        contents[_SDta] = __expectString(output[_SDta]);
    }
    if (output[_MQ] != null) {
        contents[_MQ] = de_MetricQuery(output[_MQ], context);
    }
    return contents;
};
const de_MetricList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Metric(entry, context);
    });
};
const de_MetricQuery = (output, context) => {
    const contents = {};
    if (output[_PIMQ] != null) {
        contents[_PIMQ] = de_PerformanceInsightsMetricQuery(output[_PIMQ], context);
    }
    return contents;
};
const de_MetricReference = (output, context) => {
    const contents = {};
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_RD] != null) {
        contents[_RD] = de_ReferenceDetails(output[_RD], context);
    }
    return contents;
};
const de_MetricReferenceList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_MetricReference(entry, context);
    });
};
const de_MinimumEngineVersionPerAllowedValue = (output, context) => {
    const contents = {};
    if (output[_AVl] != null) {
        contents[_AVl] = __expectString(output[_AVl]);
    }
    if (output[_MEVi] != null) {
        contents[_MEVi] = __expectString(output[_MEVi]);
    }
    return contents;
};
const de_MinimumEngineVersionPerAllowedValueList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_MinimumEngineVersionPerAllowedValue(entry, context);
    });
};
const de_ModifyActivityStreamResponse = (output, context) => {
    const contents = {};
    if (output[_KKI] != null) {
        contents[_KKI] = __expectString(output[_KKI]);
    }
    if (output[_KSN] != null) {
        contents[_KSN] = __expectString(output[_KSN]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_Mo] != null) {
        contents[_Mo] = __expectString(output[_Mo]);
    }
    if (output[_ENAFI] != null) {
        contents[_ENAFI] = __parseBoolean(output[_ENAFI]);
    }
    if (output[_PS] != null) {
        contents[_PS] = __expectString(output[_PS]);
    }
    return contents;
};
const de_ModifyCertificatesResult = (output, context) => {
    const contents = {};
    if (output[_Cer] != null) {
        contents[_Cer] = de_Certificate(output[_Cer], context);
    }
    return contents;
};
const de_ModifyDBClusterResult = (output, context) => {
    const contents = {};
    if (output[_DBC] != null) {
        contents[_DBC] = de_DBCluster(output[_DBC], context);
    }
    return contents;
};
const de_ModifyDBClusterSnapshotAttributeResult = (output, context) => {
    const contents = {};
    if (output[_DBCSAR] != null) {
        contents[_DBCSAR] = de_DBClusterSnapshotAttributesResult(output[_DBCSAR], context);
    }
    return contents;
};
const de_ModifyDBInstanceResult = (output, context) => {
    const contents = {};
    if (output[_DBI] != null) {
        contents[_DBI] = de_DBInstance(output[_DBI], context);
    }
    return contents;
};
const de_ModifyDBProxyEndpointResponse = (output, context) => {
    const contents = {};
    if (output[_DBPE] != null) {
        contents[_DBPE] = de_DBProxyEndpoint(output[_DBPE], context);
    }
    return contents;
};
const de_ModifyDBProxyResponse = (output, context) => {
    const contents = {};
    if (output[_DBP] != null) {
        contents[_DBP] = de_DBProxy(output[_DBP], context);
    }
    return contents;
};
const de_ModifyDBProxyTargetGroupResponse = (output, context) => {
    const contents = {};
    if (output[_DBPTG] != null) {
        contents[_DBPTG] = de_DBProxyTargetGroup(output[_DBPTG], context);
    }
    return contents;
};
const de_ModifyDBSnapshotAttributeResult = (output, context) => {
    const contents = {};
    if (output[_DBSAR] != null) {
        contents[_DBSAR] = de_DBSnapshotAttributesResult(output[_DBSAR], context);
    }
    return contents;
};
const de_ModifyDBSnapshotResult = (output, context) => {
    const contents = {};
    if (output[_DBS] != null) {
        contents[_DBS] = de_DBSnapshot(output[_DBS], context);
    }
    return contents;
};
const de_ModifyDBSubnetGroupResult = (output, context) => {
    const contents = {};
    if (output[_DBSGu] != null) {
        contents[_DBSGu] = de_DBSubnetGroup(output[_DBSGu], context);
    }
    return contents;
};
const de_ModifyEventSubscriptionResult = (output, context) => {
    const contents = {};
    if (output[_ES] != null) {
        contents[_ES] = de_EventSubscription(output[_ES], context);
    }
    return contents;
};
const de_ModifyGlobalClusterResult = (output, context) => {
    const contents = {};
    if (output[_GC] != null) {
        contents[_GC] = de_GlobalCluster(output[_GC], context);
    }
    return contents;
};
const de_ModifyOptionGroupResult = (output, context) => {
    const contents = {};
    if (output[_OG] != null) {
        contents[_OG] = de_OptionGroup(output[_OG], context);
    }
    return contents;
};
const de_ModifyTenantDatabaseResult = (output, context) => {
    const contents = {};
    if (output[_TD] != null) {
        contents[_TD] = de_TenantDatabase(output[_TD], context);
    }
    return contents;
};
const de_NetworkTypeNotSupported = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_Option = (output, context) => {
    const contents = {};
    if (output[_ON] != null) {
        contents[_ON] = __expectString(output[_ON]);
    }
    if (output[_OD] != null) {
        contents[_OD] = __expectString(output[_OD]);
    }
    if (output[_Pe] != null) {
        contents[_Pe] = __parseBoolean(output[_Pe]);
    }
    if (output[_Per] != null) {
        contents[_Per] = __parseBoolean(output[_Per]);
    }
    if (output[_P] != null) {
        contents[_P] = __strictParseInt32(output[_P]);
    }
    if (output[_OV] != null) {
        contents[_OV] = __expectString(output[_OV]);
    }
    if (output.OptionSettings === "") {
        contents[_OS] = [];
    }
    else if (output[_OS] != null && output[_OS][_OSp] != null) {
        contents[_OS] = de_OptionSettingConfigurationList(__getArrayIfSingleItem(output[_OS][_OSp]), context);
    }
    if (output.DBSecurityGroupMemberships === "") {
        contents[_DBSGM] = [];
    }
    else if (output[_DBSGM] != null && output[_DBSGM][_DBSGe] != null) {
        contents[_DBSGM] = de_DBSecurityGroupMembershipList(__getArrayIfSingleItem(output[_DBSGM][_DBSGe]), context);
    }
    if (output.VpcSecurityGroupMemberships === "") {
        contents[_VSGM] = [];
    }
    else if (output[_VSGM] != null && output[_VSGM][_VSGMp] != null) {
        contents[_VSGM] = de_VpcSecurityGroupMembershipList(__getArrayIfSingleItem(output[_VSGM][_VSGMp]), context);
    }
    return contents;
};
const de_OptionGroup = (output, context) => {
    const contents = {};
    if (output[_OGN] != null) {
        contents[_OGN] = __expectString(output[_OGN]);
    }
    if (output[_OGD] != null) {
        contents[_OGD] = __expectString(output[_OGD]);
    }
    if (output[_EN] != null) {
        contents[_EN] = __expectString(output[_EN]);
    }
    if (output[_MEV] != null) {
        contents[_MEV] = __expectString(output[_MEV]);
    }
    if (output.Options === "") {
        contents[_O] = [];
    }
    else if (output[_O] != null && output[_O][_Op] != null) {
        contents[_O] = de_OptionsList(__getArrayIfSingleItem(output[_O][_Op]), context);
    }
    if (output[_AVANVIM] != null) {
        contents[_AVANVIM] = __parseBoolean(output[_AVANVIM]);
    }
    if (output[_VI] != null) {
        contents[_VI] = __expectString(output[_VI]);
    }
    if (output[_OGA] != null) {
        contents[_OGA] = __expectString(output[_OGA]);
    }
    if (output[_SOG] != null) {
        contents[_SOG] = __expectString(output[_SOG]);
    }
    if (output[_SAI] != null) {
        contents[_SAI] = __expectString(output[_SAI]);
    }
    if (output[_CTo] != null) {
        contents[_CTo] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CTo]));
    }
    return contents;
};
const de_OptionGroupAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_OptionGroupMembership = (output, context) => {
    const contents = {};
    if (output[_OGN] != null) {
        contents[_OGN] = __expectString(output[_OGN]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    return contents;
};
const de_OptionGroupMembershipList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_OptionGroupMembership(entry, context);
    });
};
const de_OptionGroupNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_OptionGroupOption = (output, context) => {
    const contents = {};
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_D] != null) {
        contents[_D] = __expectString(output[_D]);
    }
    if (output[_EN] != null) {
        contents[_EN] = __expectString(output[_EN]);
    }
    if (output[_MEV] != null) {
        contents[_MEV] = __expectString(output[_MEV]);
    }
    if (output[_MRMEV] != null) {
        contents[_MRMEV] = __expectString(output[_MRMEV]);
    }
    if (output[_PR] != null) {
        contents[_PR] = __parseBoolean(output[_PR]);
    }
    if (output[_DPe] != null) {
        contents[_DPe] = __strictParseInt32(output[_DPe]);
    }
    if (output.OptionsDependedOn === "") {
        contents[_ODO] = [];
    }
    else if (output[_ODO] != null && output[_ODO][_ON] != null) {
        contents[_ODO] = de_OptionsDependedOn(__getArrayIfSingleItem(output[_ODO][_ON]), context);
    }
    if (output.OptionsConflictsWith === "") {
        contents[_OCW] = [];
    }
    else if (output[_OCW] != null && output[_OCW][_OCN] != null) {
        contents[_OCW] = de_OptionsConflictsWith(__getArrayIfSingleItem(output[_OCW][_OCN]), context);
    }
    if (output[_Pe] != null) {
        contents[_Pe] = __parseBoolean(output[_Pe]);
    }
    if (output[_Per] != null) {
        contents[_Per] = __parseBoolean(output[_Per]);
    }
    if (output[_RAMEVU] != null) {
        contents[_RAMEVU] = __parseBoolean(output[_RAMEVU]);
    }
    if (output[_VO] != null) {
        contents[_VO] = __parseBoolean(output[_VO]);
    }
    if (output[_SOVD] != null) {
        contents[_SOVD] = __parseBoolean(output[_SOVD]);
    }
    if (output.OptionGroupOptionSettings === "") {
        contents[_OGOS] = [];
    }
    else if (output[_OGOS] != null && output[_OGOS][_OGOSp] != null) {
        contents[_OGOS] = de_OptionGroupOptionSettingsList(__getArrayIfSingleItem(output[_OGOS][_OGOSp]), context);
    }
    if (output.OptionGroupOptionVersions === "") {
        contents[_OGOV] = [];
    }
    else if (output[_OGOV] != null && output[_OGOV][_OV] != null) {
        contents[_OGOV] = de_OptionGroupOptionVersionsList(__getArrayIfSingleItem(output[_OGOV][_OV]), context);
    }
    if (output[_CCA] != null) {
        contents[_CCA] = __parseBoolean(output[_CCA]);
    }
    return contents;
};
const de_OptionGroupOptionSetting = (output, context) => {
    const contents = {};
    if (output[_SNe] != null) {
        contents[_SNe] = __expectString(output[_SNe]);
    }
    if (output[_SDe] != null) {
        contents[_SDe] = __expectString(output[_SDe]);
    }
    if (output[_DV] != null) {
        contents[_DV] = __expectString(output[_DV]);
    }
    if (output[_AT] != null) {
        contents[_AT] = __expectString(output[_AT]);
    }
    if (output[_AV] != null) {
        contents[_AV] = __expectString(output[_AV]);
    }
    if (output[_IM] != null) {
        contents[_IM] = __parseBoolean(output[_IM]);
    }
    if (output[_IR] != null) {
        contents[_IR] = __parseBoolean(output[_IR]);
    }
    if (output.MinimumEngineVersionPerAllowedValue === "") {
        contents[_MEVPAV] = [];
    }
    else if (output[_MEVPAV] != null && output[_MEVPAV][_MEVPAV] != null) {
        contents[_MEVPAV] = de_MinimumEngineVersionPerAllowedValueList(__getArrayIfSingleItem(output[_MEVPAV][_MEVPAV]), context);
    }
    return contents;
};
const de_OptionGroupOptionSettingsList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_OptionGroupOptionSetting(entry, context);
    });
};
const de_OptionGroupOptionsList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_OptionGroupOption(entry, context);
    });
};
const de_OptionGroupOptionsMessage = (output, context) => {
    const contents = {};
    if (output.OptionGroupOptions === "") {
        contents[_OGO] = [];
    }
    else if (output[_OGO] != null && output[_OGO][_OGOp] != null) {
        contents[_OGO] = de_OptionGroupOptionsList(__getArrayIfSingleItem(output[_OGO][_OGOp]), context);
    }
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    return contents;
};
const de_OptionGroupOptionVersionsList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_OptionVersion(entry, context);
    });
};
const de_OptionGroupQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_OptionGroups = (output, context) => {
    const contents = {};
    if (output.OptionGroupsList === "") {
        contents[_OGL] = [];
    }
    else if (output[_OGL] != null && output[_OGL][_OG] != null) {
        contents[_OGL] = de_OptionGroupsList(__getArrayIfSingleItem(output[_OGL][_OG]), context);
    }
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    return contents;
};
const de_OptionGroupsList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_OptionGroup(entry, context);
    });
};
const de_OptionsConflictsWith = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_OptionsDependedOn = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_OptionSetting = (output, context) => {
    const contents = {};
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_Val] != null) {
        contents[_Val] = __expectString(output[_Val]);
    }
    if (output[_DV] != null) {
        contents[_DV] = __expectString(output[_DV]);
    }
    if (output[_D] != null) {
        contents[_D] = __expectString(output[_D]);
    }
    if (output[_AT] != null) {
        contents[_AT] = __expectString(output[_AT]);
    }
    if (output[_DTa] != null) {
        contents[_DTa] = __expectString(output[_DTa]);
    }
    if (output[_AV] != null) {
        contents[_AV] = __expectString(output[_AV]);
    }
    if (output[_IM] != null) {
        contents[_IM] = __parseBoolean(output[_IM]);
    }
    if (output[_IC] != null) {
        contents[_IC] = __parseBoolean(output[_IC]);
    }
    return contents;
};
const de_OptionSettingConfigurationList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_OptionSetting(entry, context);
    });
};
const de_OptionsList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Option(entry, context);
    });
};
const de_OptionVersion = (output, context) => {
    const contents = {};
    if (output[_V] != null) {
        contents[_V] = __expectString(output[_V]);
    }
    if (output[_ID] != null) {
        contents[_ID] = __parseBoolean(output[_ID]);
    }
    return contents;
};
const de_OrderableDBInstanceOption = (output, context) => {
    const contents = {};
    if (output[_E] != null) {
        contents[_E] = __expectString(output[_E]);
    }
    if (output[_EV] != null) {
        contents[_EV] = __expectString(output[_EV]);
    }
    if (output[_DBIC] != null) {
        contents[_DBIC] = __expectString(output[_DBIC]);
    }
    if (output[_LM] != null) {
        contents[_LM] = __expectString(output[_LM]);
    }
    if (output[_AZG] != null) {
        contents[_AZG] = __expectString(output[_AZG]);
    }
    if (output.AvailabilityZones === "") {
        contents[_AZ] = [];
    }
    else if (output[_AZ] != null && output[_AZ][_AZv] != null) {
        contents[_AZ] = de_AvailabilityZoneList(__getArrayIfSingleItem(output[_AZ][_AZv]), context);
    }
    if (output[_MAZC] != null) {
        contents[_MAZC] = __parseBoolean(output[_MAZC]);
    }
    if (output[_RRC] != null) {
        contents[_RRC] = __parseBoolean(output[_RRC]);
    }
    if (output[_Vp] != null) {
        contents[_Vp] = __parseBoolean(output[_Vp]);
    }
    if (output[_SSE] != null) {
        contents[_SSE] = __parseBoolean(output[_SSE]);
    }
    if (output[_STt] != null) {
        contents[_STt] = __expectString(output[_STt]);
    }
    if (output[_SIupp] != null) {
        contents[_SIupp] = __parseBoolean(output[_SIupp]);
    }
    if (output[_SEMu] != null) {
        contents[_SEMu] = __parseBoolean(output[_SEMu]);
    }
    if (output[_SIAMDA] != null) {
        contents[_SIAMDA] = __parseBoolean(output[_SIAMDA]);
    }
    if (output[_SPI] != null) {
        contents[_SPI] = __parseBoolean(output[_SPI]);
    }
    if (output[_MSS] != null) {
        contents[_MSS] = __strictParseInt32(output[_MSS]);
    }
    if (output[_MSSa] != null) {
        contents[_MSSa] = __strictParseInt32(output[_MSSa]);
    }
    if (output[_MIPDI] != null) {
        contents[_MIPDI] = __strictParseInt32(output[_MIPDI]);
    }
    if (output[_MIPDIa] != null) {
        contents[_MIPDIa] = __strictParseInt32(output[_MIPDIa]);
    }
    if (output[_MIPG] != null) {
        contents[_MIPG] = __strictParseFloat(output[_MIPG]);
    }
    if (output[_MIPGa] != null) {
        contents[_MIPGa] = __strictParseFloat(output[_MIPGa]);
    }
    if (output.AvailableProcessorFeatures === "") {
        contents[_APF] = [];
    }
    else if (output[_APF] != null && output[_APF][_APFv] != null) {
        contents[_APF] = de_AvailableProcessorFeatureList(__getArrayIfSingleItem(output[_APF][_APFv]), context);
    }
    if (output.SupportedEngineModes === "") {
        contents[_SEM] = [];
    }
    else if (output[_SEM] != null && output[_SEM][_me] != null) {
        contents[_SEM] = de_EngineModeList(__getArrayIfSingleItem(output[_SEM][_me]), context);
    }
    if (output[_SSA] != null) {
        contents[_SSA] = __parseBoolean(output[_SSA]);
    }
    if (output[_SKA] != null) {
        contents[_SKA] = __parseBoolean(output[_SKA]);
    }
    if (output[_OC] != null) {
        contents[_OC] = __parseBoolean(output[_OC]);
    }
    if (output.SupportedActivityStreamModes === "") {
        contents[_SASM] = [];
    }
    else if (output[_SASM] != null && output[_SASM][_me] != null) {
        contents[_SASM] = de_ActivityStreamModeList(__getArrayIfSingleItem(output[_SASM][_me]), context);
    }
    if (output[_SGD] != null) {
        contents[_SGD] = __parseBoolean(output[_SGD]);
    }
    if (output[_SCu] != null) {
        contents[_SCu] = __parseBoolean(output[_SCu]);
    }
    if (output.SupportedNetworkTypes === "") {
        contents[_SNT] = [];
    }
    else if (output[_SNT] != null && output[_SNT][_me] != null) {
        contents[_SNT] = de_StringList(__getArrayIfSingleItem(output[_SNT][_me]), context);
    }
    if (output[_SST] != null) {
        contents[_SST] = __parseBoolean(output[_SST]);
    }
    if (output[_MSTPDI] != null) {
        contents[_MSTPDI] = __strictParseInt32(output[_MSTPDI]);
    }
    if (output[_MSTPDIa] != null) {
        contents[_MSTPDIa] = __strictParseInt32(output[_MSTPDIa]);
    }
    if (output[_MSTPI] != null) {
        contents[_MSTPI] = __strictParseFloat(output[_MSTPI]);
    }
    if (output[_MSTPIa] != null) {
        contents[_MSTPIa] = __strictParseFloat(output[_MSTPIa]);
    }
    if (output[_SDLV] != null) {
        contents[_SDLV] = __parseBoolean(output[_SDLV]);
    }
    return contents;
};
const de_OrderableDBInstanceOptionsList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_OrderableDBInstanceOption(entry, context);
    });
};
const de_OrderableDBInstanceOptionsMessage = (output, context) => {
    const contents = {};
    if (output.OrderableDBInstanceOptions === "") {
        contents[_ODBIO] = [];
    }
    else if (output[_ODBIO] != null && output[_ODBIO][_ODBIOr] != null) {
        contents[_ODBIO] = de_OrderableDBInstanceOptionsList(__getArrayIfSingleItem(output[_ODBIO][_ODBIOr]), context);
    }
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    return contents;
};
const de_Outpost = (output, context) => {
    const contents = {};
    if (output[_Ar] != null) {
        contents[_Ar] = __expectString(output[_Ar]);
    }
    return contents;
};
const de_Parameter = (output, context) => {
    const contents = {};
    if (output[_PN] != null) {
        contents[_PN] = __expectString(output[_PN]);
    }
    if (output[_PV] != null) {
        contents[_PV] = __expectString(output[_PV]);
    }
    if (output[_D] != null) {
        contents[_D] = __expectString(output[_D]);
    }
    if (output[_S] != null) {
        contents[_S] = __expectString(output[_S]);
    }
    if (output[_AT] != null) {
        contents[_AT] = __expectString(output[_AT]);
    }
    if (output[_DTa] != null) {
        contents[_DTa] = __expectString(output[_DTa]);
    }
    if (output[_AV] != null) {
        contents[_AV] = __expectString(output[_AV]);
    }
    if (output[_IM] != null) {
        contents[_IM] = __parseBoolean(output[_IM]);
    }
    if (output[_MEVi] != null) {
        contents[_MEVi] = __expectString(output[_MEVi]);
    }
    if (output[_AMp] != null) {
        contents[_AMp] = __expectString(output[_AMp]);
    }
    if (output.SupportedEngineModes === "") {
        contents[_SEM] = [];
    }
    else if (output[_SEM] != null && output[_SEM][_me] != null) {
        contents[_SEM] = de_EngineModeList(__getArrayIfSingleItem(output[_SEM][_me]), context);
    }
    return contents;
};
const de_ParametersList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Parameter(entry, context);
    });
};
const de_PendingCloudwatchLogsExports = (output, context) => {
    const contents = {};
    if (output.LogTypesToEnable === "") {
        contents[_LTTE] = [];
    }
    else if (output[_LTTE] != null && output[_LTTE][_me] != null) {
        contents[_LTTE] = de_LogTypeList(__getArrayIfSingleItem(output[_LTTE][_me]), context);
    }
    if (output.LogTypesToDisable === "") {
        contents[_LTTD] = [];
    }
    else if (output[_LTTD] != null && output[_LTTD][_me] != null) {
        contents[_LTTD] = de_LogTypeList(__getArrayIfSingleItem(output[_LTTD][_me]), context);
    }
    return contents;
};
const de_PendingMaintenanceAction = (output, context) => {
    const contents = {};
    if (output[_A] != null) {
        contents[_A] = __expectString(output[_A]);
    }
    if (output[_AAAD] != null) {
        contents[_AAAD] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_AAAD]));
    }
    if (output[_FAD] != null) {
        contents[_FAD] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_FAD]));
    }
    if (output[_OIS] != null) {
        contents[_OIS] = __expectString(output[_OIS]);
    }
    if (output[_CAD] != null) {
        contents[_CAD] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_CAD]));
    }
    if (output[_D] != null) {
        contents[_D] = __expectString(output[_D]);
    }
    return contents;
};
const de_PendingMaintenanceActionDetails = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_PendingMaintenanceAction(entry, context);
    });
};
const de_PendingMaintenanceActions = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ResourcePendingMaintenanceActions(entry, context);
    });
};
const de_PendingMaintenanceActionsMessage = (output, context) => {
    const contents = {};
    if (output.PendingMaintenanceActions === "") {
        contents[_PMA] = [];
    }
    else if (output[_PMA] != null && output[_PMA][_RPMA] != null) {
        contents[_PMA] = de_PendingMaintenanceActions(__getArrayIfSingleItem(output[_PMA][_RPMA]), context);
    }
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    return contents;
};
const de_PendingModifiedValues = (output, context) => {
    const contents = {};
    if (output[_DBIC] != null) {
        contents[_DBIC] = __expectString(output[_DBIC]);
    }
    if (output[_AS] != null) {
        contents[_AS] = __strictParseInt32(output[_AS]);
    }
    if (output[_MUP] != null) {
        contents[_MUP] = __expectString(output[_MUP]);
    }
    if (output[_P] != null) {
        contents[_P] = __strictParseInt32(output[_P]);
    }
    if (output[_BRP] != null) {
        contents[_BRP] = __strictParseInt32(output[_BRP]);
    }
    if (output[_MAZ] != null) {
        contents[_MAZ] = __parseBoolean(output[_MAZ]);
    }
    if (output[_EV] != null) {
        contents[_EV] = __expectString(output[_EV]);
    }
    if (output[_LM] != null) {
        contents[_LM] = __expectString(output[_LM]);
    }
    if (output[_I] != null) {
        contents[_I] = __strictParseInt32(output[_I]);
    }
    if (output[_DBII] != null) {
        contents[_DBII] = __expectString(output[_DBII]);
    }
    if (output[_STt] != null) {
        contents[_STt] = __expectString(output[_STt]);
    }
    if (output[_CACI] != null) {
        contents[_CACI] = __expectString(output[_CACI]);
    }
    if (output[_DBSGNu] != null) {
        contents[_DBSGNu] = __expectString(output[_DBSGNu]);
    }
    if (output[_PCLE] != null) {
        contents[_PCLE] = de_PendingCloudwatchLogsExports(output[_PCLE], context);
    }
    if (output.ProcessorFeatures === "") {
        contents[_PF] = [];
    }
    else if (output[_PF] != null && output[_PF][_PFr] != null) {
        contents[_PF] = de_ProcessorFeatureList(__getArrayIfSingleItem(output[_PF][_PFr]), context);
    }
    if (output[_IAMDAE] != null) {
        contents[_IAMDAE] = __parseBoolean(output[_IAMDAE]);
    }
    if (output[_AM] != null) {
        contents[_AM] = __expectString(output[_AM]);
    }
    if (output[_RFAMT] != null) {
        contents[_RFAMT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_RFAMT]));
    }
    if (output[_STto] != null) {
        contents[_STto] = __strictParseInt32(output[_STto]);
    }
    if (output[_E] != null) {
        contents[_E] = __expectString(output[_E]);
    }
    if (output[_DLV] != null) {
        contents[_DLV] = __parseBoolean(output[_DLV]);
    }
    if (output[_MT] != null) {
        contents[_MT] = __parseBoolean(output[_MT]);
    }
    return contents;
};
const de_PerformanceInsightsMetricDimensionGroup = (output, context) => {
    const contents = {};
    if (output.Dimensions === "") {
        contents[_Di] = [];
    }
    else if (output[_Di] != null && output[_Di][_me] != null) {
        contents[_Di] = de_StringList(__getArrayIfSingleItem(output[_Di][_me]), context);
    }
    if (output[_G] != null) {
        contents[_G] = __expectString(output[_G]);
    }
    if (output[_Lim] != null) {
        contents[_Lim] = __strictParseInt32(output[_Lim]);
    }
    return contents;
};
const de_PerformanceInsightsMetricQuery = (output, context) => {
    const contents = {};
    if (output[_GB] != null) {
        contents[_GB] = de_PerformanceInsightsMetricDimensionGroup(output[_GB], context);
    }
    if (output[_Met] != null) {
        contents[_Met] = __expectString(output[_Met]);
    }
    return contents;
};
const de_PerformanceIssueDetails = (output, context) => {
    const contents = {};
    if (output[_STta] != null) {
        contents[_STta] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_STta]));
    }
    if (output[_ETn] != null) {
        contents[_ETn] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_ETn]));
    }
    if (output.Metrics === "") {
        contents[_Metr] = [];
    }
    else if (output[_Metr] != null && output[_Metr][_me] != null) {
        contents[_Metr] = de_MetricList(__getArrayIfSingleItem(output[_Metr][_me]), context);
    }
    if (output[_An] != null) {
        contents[_An] = __expectString(output[_An]);
    }
    return contents;
};
const de_PointInTimeRestoreNotEnabledFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_ProcessorFeature = (output, context) => {
    const contents = {};
    if (output[_N] != null) {
        contents[_N] = __expectString(output[_N]);
    }
    if (output[_Val] != null) {
        contents[_Val] = __expectString(output[_Val]);
    }
    return contents;
};
const de_ProcessorFeatureList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ProcessorFeature(entry, context);
    });
};
const de_PromoteReadReplicaDBClusterResult = (output, context) => {
    const contents = {};
    if (output[_DBC] != null) {
        contents[_DBC] = de_DBCluster(output[_DBC], context);
    }
    return contents;
};
const de_PromoteReadReplicaResult = (output, context) => {
    const contents = {};
    if (output[_DBI] != null) {
        contents[_DBI] = de_DBInstance(output[_DBI], context);
    }
    return contents;
};
const de_ProvisionedIopsNotAvailableInAZFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_PurchaseReservedDBInstancesOfferingResult = (output, context) => {
    const contents = {};
    if (output[_RDBIe] != null) {
        contents[_RDBIe] = de_ReservedDBInstance(output[_RDBIe], context);
    }
    return contents;
};
const de_Range = (output, context) => {
    const contents = {};
    if (output[_Fr] != null) {
        contents[_Fr] = __strictParseInt32(output[_Fr]);
    }
    if (output[_To] != null) {
        contents[_To] = __strictParseInt32(output[_To]);
    }
    if (output[_Ste] != null) {
        contents[_Ste] = __strictParseInt32(output[_Ste]);
    }
    return contents;
};
const de_RangeList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Range(entry, context);
    });
};
const de_RdsCustomClusterConfiguration = (output, context) => {
    const contents = {};
    if (output[_ISI] != null) {
        contents[_ISI] = __expectString(output[_ISI]);
    }
    if (output[_TGMDI] != null) {
        contents[_TGMDI] = __expectString(output[_TGMDI]);
    }
    if (output[_RM] != null) {
        contents[_RM] = __expectString(output[_RM]);
    }
    return contents;
};
const de_ReadersArnList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_ReadReplicaDBClusterIdentifierList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_ReadReplicaDBInstanceIdentifierList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_ReadReplicaIdentifierList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_RebootDBClusterResult = (output, context) => {
    const contents = {};
    if (output[_DBC] != null) {
        contents[_DBC] = de_DBCluster(output[_DBC], context);
    }
    return contents;
};
const de_RebootDBInstanceResult = (output, context) => {
    const contents = {};
    if (output[_DBI] != null) {
        contents[_DBI] = de_DBInstance(output[_DBI], context);
    }
    return contents;
};
const de_RecommendedAction = (output, context) => {
    const contents = {};
    if (output[_AIc] != null) {
        contents[_AIc] = __expectString(output[_AIc]);
    }
    if (output[_Tit] != null) {
        contents[_Tit] = __expectString(output[_Tit]);
    }
    if (output[_D] != null) {
        contents[_D] = __expectString(output[_D]);
    }
    if (output[_Ope] != null) {
        contents[_Ope] = __expectString(output[_Ope]);
    }
    if (output.Parameters === "") {
        contents[_Pa] = [];
    }
    else if (output[_Pa] != null && output[_Pa][_me] != null) {
        contents[_Pa] = de_RecommendedActionParameterList(__getArrayIfSingleItem(output[_Pa][_me]), context);
    }
    if (output.ApplyModes === "") {
        contents[_AMpp] = [];
    }
    else if (output[_AMpp] != null && output[_AMpp][_me] != null) {
        contents[_AMpp] = de_StringList(__getArrayIfSingleItem(output[_AMpp][_me]), context);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_IDs] != null) {
        contents[_IDs] = de_IssueDetails(output[_IDs], context);
    }
    if (output.ContextAttributes === "") {
        contents[_CAo] = [];
    }
    else if (output[_CAo] != null && output[_CAo][_me] != null) {
        contents[_CAo] = de_ContextAttributeList(__getArrayIfSingleItem(output[_CAo][_me]), context);
    }
    return contents;
};
const de_RecommendedActionList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_RecommendedAction(entry, context);
    });
};
const de_RecommendedActionParameter = (output, context) => {
    const contents = {};
    if (output[_K] != null) {
        contents[_K] = __expectString(output[_K]);
    }
    if (output[_Val] != null) {
        contents[_Val] = __expectString(output[_Val]);
    }
    return contents;
};
const de_RecommendedActionParameterList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_RecommendedActionParameter(entry, context);
    });
};
const de_RecurringCharge = (output, context) => {
    const contents = {};
    if (output[_RCA] != null) {
        contents[_RCA] = __strictParseFloat(output[_RCA]);
    }
    if (output[_RCF] != null) {
        contents[_RCF] = __expectString(output[_RCF]);
    }
    return contents;
};
const de_RecurringChargeList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_RecurringCharge(entry, context);
    });
};
const de_ReferenceDetails = (output, context) => {
    const contents = {};
    if (output[_SRD] != null) {
        contents[_SRD] = de_ScalarReferenceDetails(output[_SRD], context);
    }
    return contents;
};
const de_RegisterDBProxyTargetsResponse = (output, context) => {
    const contents = {};
    if (output.DBProxyTargets === "") {
        contents[_DBPT] = [];
    }
    else if (output[_DBPT] != null && output[_DBPT][_me] != null) {
        contents[_DBPT] = de_TargetList(__getArrayIfSingleItem(output[_DBPT][_me]), context);
    }
    return contents;
};
const de_RemoveFromGlobalClusterResult = (output, context) => {
    const contents = {};
    if (output[_GC] != null) {
        contents[_GC] = de_GlobalCluster(output[_GC], context);
    }
    return contents;
};
const de_RemoveSourceIdentifierFromSubscriptionResult = (output, context) => {
    const contents = {};
    if (output[_ES] != null) {
        contents[_ES] = de_EventSubscription(output[_ES], context);
    }
    return contents;
};
const de_ReservedDBInstance = (output, context) => {
    const contents = {};
    if (output[_RDBII] != null) {
        contents[_RDBII] = __expectString(output[_RDBII]);
    }
    if (output[_RDBIOI] != null) {
        contents[_RDBIOI] = __expectString(output[_RDBIOI]);
    }
    if (output[_DBIC] != null) {
        contents[_DBIC] = __expectString(output[_DBIC]);
    }
    if (output[_STta] != null) {
        contents[_STta] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_STta]));
    }
    if (output[_Du] != null) {
        contents[_Du] = __strictParseInt32(output[_Du]);
    }
    if (output[_FP] != null) {
        contents[_FP] = __strictParseFloat(output[_FP]);
    }
    if (output[_UP] != null) {
        contents[_UP] = __strictParseFloat(output[_UP]);
    }
    if (output[_CCu] != null) {
        contents[_CCu] = __expectString(output[_CCu]);
    }
    if (output[_DBICn] != null) {
        contents[_DBICn] = __strictParseInt32(output[_DBICn]);
    }
    if (output[_PD] != null) {
        contents[_PD] = __expectString(output[_PD]);
    }
    if (output[_OT] != null) {
        contents[_OT] = __expectString(output[_OT]);
    }
    if (output[_MAZ] != null) {
        contents[_MAZ] = __parseBoolean(output[_MAZ]);
    }
    if (output[_Sta] != null) {
        contents[_Sta] = __expectString(output[_Sta]);
    }
    if (output.RecurringCharges === "") {
        contents[_RC] = [];
    }
    else if (output[_RC] != null && output[_RC][_RCe] != null) {
        contents[_RC] = de_RecurringChargeList(__getArrayIfSingleItem(output[_RC][_RCe]), context);
    }
    if (output[_RDBIA] != null) {
        contents[_RDBIA] = __expectString(output[_RDBIA]);
    }
    if (output[_LI] != null) {
        contents[_LI] = __expectString(output[_LI]);
    }
    return contents;
};
const de_ReservedDBInstanceAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_ReservedDBInstanceList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ReservedDBInstance(entry, context);
    });
};
const de_ReservedDBInstanceMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.ReservedDBInstances === "") {
        contents[_RDBIes] = [];
    }
    else if (output[_RDBIes] != null && output[_RDBIes][_RDBIe] != null) {
        contents[_RDBIes] = de_ReservedDBInstanceList(__getArrayIfSingleItem(output[_RDBIes][_RDBIe]), context);
    }
    return contents;
};
const de_ReservedDBInstanceNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_ReservedDBInstanceQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_ReservedDBInstancesOffering = (output, context) => {
    const contents = {};
    if (output[_RDBIOI] != null) {
        contents[_RDBIOI] = __expectString(output[_RDBIOI]);
    }
    if (output[_DBIC] != null) {
        contents[_DBIC] = __expectString(output[_DBIC]);
    }
    if (output[_Du] != null) {
        contents[_Du] = __strictParseInt32(output[_Du]);
    }
    if (output[_FP] != null) {
        contents[_FP] = __strictParseFloat(output[_FP]);
    }
    if (output[_UP] != null) {
        contents[_UP] = __strictParseFloat(output[_UP]);
    }
    if (output[_CCu] != null) {
        contents[_CCu] = __expectString(output[_CCu]);
    }
    if (output[_PD] != null) {
        contents[_PD] = __expectString(output[_PD]);
    }
    if (output[_OT] != null) {
        contents[_OT] = __expectString(output[_OT]);
    }
    if (output[_MAZ] != null) {
        contents[_MAZ] = __parseBoolean(output[_MAZ]);
    }
    if (output.RecurringCharges === "") {
        contents[_RC] = [];
    }
    else if (output[_RC] != null && output[_RC][_RCe] != null) {
        contents[_RC] = de_RecurringChargeList(__getArrayIfSingleItem(output[_RC][_RCe]), context);
    }
    return contents;
};
const de_ReservedDBInstancesOfferingList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ReservedDBInstancesOffering(entry, context);
    });
};
const de_ReservedDBInstancesOfferingMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.ReservedDBInstancesOfferings === "") {
        contents[_RDBIO] = [];
    }
    else if (output[_RDBIO] != null && output[_RDBIO][_RDBIOe] != null) {
        contents[_RDBIO] = de_ReservedDBInstancesOfferingList(__getArrayIfSingleItem(output[_RDBIO][_RDBIOe]), context);
    }
    return contents;
};
const de_ReservedDBInstancesOfferingNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_ResourceNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_ResourcePendingMaintenanceActions = (output, context) => {
    const contents = {};
    if (output[_RI] != null) {
        contents[_RI] = __expectString(output[_RI]);
    }
    if (output.PendingMaintenanceActionDetails === "") {
        contents[_PMAD] = [];
    }
    else if (output[_PMAD] != null && output[_PMAD][_PMAe] != null) {
        contents[_PMAD] = de_PendingMaintenanceActionDetails(__getArrayIfSingleItem(output[_PMAD][_PMAe]), context);
    }
    return contents;
};
const de_RestoreDBClusterFromS3Result = (output, context) => {
    const contents = {};
    if (output[_DBC] != null) {
        contents[_DBC] = de_DBCluster(output[_DBC], context);
    }
    return contents;
};
const de_RestoreDBClusterFromSnapshotResult = (output, context) => {
    const contents = {};
    if (output[_DBC] != null) {
        contents[_DBC] = de_DBCluster(output[_DBC], context);
    }
    return contents;
};
const de_RestoreDBClusterToPointInTimeResult = (output, context) => {
    const contents = {};
    if (output[_DBC] != null) {
        contents[_DBC] = de_DBCluster(output[_DBC], context);
    }
    return contents;
};
const de_RestoreDBInstanceFromDBSnapshotResult = (output, context) => {
    const contents = {};
    if (output[_DBI] != null) {
        contents[_DBI] = de_DBInstance(output[_DBI], context);
    }
    return contents;
};
const de_RestoreDBInstanceFromS3Result = (output, context) => {
    const contents = {};
    if (output[_DBI] != null) {
        contents[_DBI] = de_DBInstance(output[_DBI], context);
    }
    return contents;
};
const de_RestoreDBInstanceToPointInTimeResult = (output, context) => {
    const contents = {};
    if (output[_DBI] != null) {
        contents[_DBI] = de_DBInstance(output[_DBI], context);
    }
    return contents;
};
const de_RestoreWindow = (output, context) => {
    const contents = {};
    if (output[_ETa] != null) {
        contents[_ETa] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_ETa]));
    }
    if (output[_LT] != null) {
        contents[_LT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LT]));
    }
    return contents;
};
const de_RevokeDBSecurityGroupIngressResult = (output, context) => {
    const contents = {};
    if (output[_DBSGe] != null) {
        contents[_DBSGe] = de_DBSecurityGroup(output[_DBSGe], context);
    }
    return contents;
};
const de_ScalarReferenceDetails = (output, context) => {
    const contents = {};
    if (output[_Val] != null) {
        contents[_Val] = __strictParseFloat(output[_Val]);
    }
    return contents;
};
const de_ScalingConfigurationInfo = (output, context) => {
    const contents = {};
    if (output[_MCi] != null) {
        contents[_MCi] = __strictParseInt32(output[_MCi]);
    }
    if (output[_MCa] != null) {
        contents[_MCa] = __strictParseInt32(output[_MCa]);
    }
    if (output[_AP] != null) {
        contents[_AP] = __parseBoolean(output[_AP]);
    }
    if (output[_SUAP] != null) {
        contents[_SUAP] = __strictParseInt32(output[_SUAP]);
    }
    if (output[_TAi] != null) {
        contents[_TAi] = __expectString(output[_TAi]);
    }
    if (output[_SBT] != null) {
        contents[_SBT] = __strictParseInt32(output[_SBT]);
    }
    return contents;
};
const de_ServerlessV2FeaturesSupport = (output, context) => {
    const contents = {};
    if (output[_MCi] != null) {
        contents[_MCi] = __strictParseFloat(output[_MCi]);
    }
    if (output[_MCa] != null) {
        contents[_MCa] = __strictParseFloat(output[_MCa]);
    }
    return contents;
};
const de_ServerlessV2ScalingConfigurationInfo = (output, context) => {
    const contents = {};
    if (output[_MCi] != null) {
        contents[_MCi] = __strictParseFloat(output[_MCi]);
    }
    if (output[_MCa] != null) {
        contents[_MCa] = __strictParseFloat(output[_MCa]);
    }
    if (output[_SUAP] != null) {
        contents[_SUAP] = __strictParseInt32(output[_SUAP]);
    }
    return contents;
};
const de_SharedSnapshotQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_SnapshotQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_SNSInvalidTopicFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_SNSNoAuthorizationFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_SNSTopicArnNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_SourceClusterNotSupportedFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_SourceDatabaseNotSupportedFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_SourceIdsList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_SourceNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_SourceRegion = (output, context) => {
    const contents = {};
    if (output[_RNe] != null) {
        contents[_RNe] = __expectString(output[_RNe]);
    }
    if (output[_End] != null) {
        contents[_End] = __expectString(output[_End]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_SDBIABRu] != null) {
        contents[_SDBIABRu] = __parseBoolean(output[_SDBIABRu]);
    }
    return contents;
};
const de_SourceRegionList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_SourceRegion(entry, context);
    });
};
const de_SourceRegionMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.SourceRegions === "") {
        contents[_SRo] = [];
    }
    else if (output[_SRo] != null && output[_SRo][_SR] != null) {
        contents[_SRo] = de_SourceRegionList(__getArrayIfSingleItem(output[_SRo][_SR]), context);
    }
    return contents;
};
const de_StartActivityStreamResponse = (output, context) => {
    const contents = {};
    if (output[_KKI] != null) {
        contents[_KKI] = __expectString(output[_KKI]);
    }
    if (output[_KSN] != null) {
        contents[_KSN] = __expectString(output[_KSN]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_Mo] != null) {
        contents[_Mo] = __expectString(output[_Mo]);
    }
    if (output[_AI] != null) {
        contents[_AI] = __parseBoolean(output[_AI]);
    }
    if (output[_ENAFI] != null) {
        contents[_ENAFI] = __parseBoolean(output[_ENAFI]);
    }
    return contents;
};
const de_StartDBClusterResult = (output, context) => {
    const contents = {};
    if (output[_DBC] != null) {
        contents[_DBC] = de_DBCluster(output[_DBC], context);
    }
    return contents;
};
const de_StartDBInstanceAutomatedBackupsReplicationResult = (output, context) => {
    const contents = {};
    if (output[_DBIABn] != null) {
        contents[_DBIABn] = de_DBInstanceAutomatedBackup(output[_DBIABn], context);
    }
    return contents;
};
const de_StartDBInstanceResult = (output, context) => {
    const contents = {};
    if (output[_DBI] != null) {
        contents[_DBI] = de_DBInstance(output[_DBI], context);
    }
    return contents;
};
const de_StopActivityStreamResponse = (output, context) => {
    const contents = {};
    if (output[_KKI] != null) {
        contents[_KKI] = __expectString(output[_KKI]);
    }
    if (output[_KSN] != null) {
        contents[_KSN] = __expectString(output[_KSN]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    return contents;
};
const de_StopDBClusterResult = (output, context) => {
    const contents = {};
    if (output[_DBC] != null) {
        contents[_DBC] = de_DBCluster(output[_DBC], context);
    }
    return contents;
};
const de_StopDBInstanceAutomatedBackupsReplicationResult = (output, context) => {
    const contents = {};
    if (output[_DBIABn] != null) {
        contents[_DBIABn] = de_DBInstanceAutomatedBackup(output[_DBIABn], context);
    }
    return contents;
};
const de_StopDBInstanceResult = (output, context) => {
    const contents = {};
    if (output[_DBI] != null) {
        contents[_DBI] = de_DBInstance(output[_DBI], context);
    }
    return contents;
};
const de_StorageQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_StorageTypeNotAvailableFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_StorageTypeNotSupportedFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_StringList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return __expectString(entry);
    });
};
const de_Subnet = (output, context) => {
    const contents = {};
    if (output[_SIub] != null) {
        contents[_SIub] = __expectString(output[_SIub]);
    }
    if (output[_SAZu] != null) {
        contents[_SAZu] = de_AvailabilityZone(output[_SAZu], context);
    }
    if (output[_SO] != null) {
        contents[_SO] = de_Outpost(output[_SO], context);
    }
    if (output[_SSu] != null) {
        contents[_SSu] = __expectString(output[_SSu]);
    }
    return contents;
};
const de_SubnetAlreadyInUse = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_SubnetList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Subnet(entry, context);
    });
};
const de_SubscriptionAlreadyExistFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_SubscriptionCategoryNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_SubscriptionNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_SupportedCharacterSetsList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_CharacterSet(entry, context);
    });
};
const de_SupportedEngineLifecycle = (output, context) => {
    const contents = {};
    if (output[_LSN] != null) {
        contents[_LSN] = __expectString(output[_LSN]);
    }
    if (output[_LSSD] != null) {
        contents[_LSSD] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LSSD]));
    }
    if (output[_LSED] != null) {
        contents[_LSED] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_LSED]));
    }
    return contents;
};
const de_SupportedEngineLifecycleList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_SupportedEngineLifecycle(entry, context);
    });
};
const de_SupportedTimezonesList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Timezone(entry, context);
    });
};
const de_SwitchoverBlueGreenDeploymentResponse = (output, context) => {
    const contents = {};
    if (output[_BGD] != null) {
        contents[_BGD] = de_BlueGreenDeployment(output[_BGD], context);
    }
    return contents;
};
const de_SwitchoverDetail = (output, context) => {
    const contents = {};
    if (output[_SMo] != null) {
        contents[_SMo] = __expectString(output[_SMo]);
    }
    if (output[_TM] != null) {
        contents[_TM] = __expectString(output[_TM]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    return contents;
};
const de_SwitchoverDetailList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_SwitchoverDetail(entry, context);
    });
};
const de_SwitchoverGlobalClusterResult = (output, context) => {
    const contents = {};
    if (output[_GC] != null) {
        contents[_GC] = de_GlobalCluster(output[_GC], context);
    }
    return contents;
};
const de_SwitchoverReadReplicaResult = (output, context) => {
    const contents = {};
    if (output[_DBI] != null) {
        contents[_DBI] = de_DBInstance(output[_DBI], context);
    }
    return contents;
};
const de_Tag = (output, context) => {
    const contents = {};
    if (output[_K] != null) {
        contents[_K] = __expectString(output[_K]);
    }
    if (output[_Val] != null) {
        contents[_Val] = __expectString(output[_Val]);
    }
    return contents;
};
const de_TagList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_Tag(entry, context);
    });
};
const de_TagListMessage = (output, context) => {
    const contents = {};
    if (output.TagList === "") {
        contents[_TL] = [];
    }
    else if (output[_TL] != null && output[_TL][_Tag] != null) {
        contents[_TL] = de_TagList(__getArrayIfSingleItem(output[_TL][_Tag]), context);
    }
    return contents;
};
const de_TargetGroupList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBProxyTargetGroup(entry, context);
    });
};
const de_TargetHealth = (output, context) => {
    const contents = {};
    if (output[_Sta] != null) {
        contents[_Sta] = __expectString(output[_Sta]);
    }
    if (output[_Rea] != null) {
        contents[_Rea] = __expectString(output[_Rea]);
    }
    if (output[_D] != null) {
        contents[_D] = __expectString(output[_D]);
    }
    return contents;
};
const de_TargetList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_DBProxyTarget(entry, context);
    });
};
const de_TenantDatabase = (output, context) => {
    const contents = {};
    if (output[_TDCT] != null) {
        contents[_TDCT] = __expectNonNull(__parseRfc3339DateTimeWithOffset(output[_TDCT]));
    }
    if (output[_DBII] != null) {
        contents[_DBII] = __expectString(output[_DBII]);
    }
    if (output[_TDBN] != null) {
        contents[_TDBN] = __expectString(output[_TDBN]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    if (output[_MU] != null) {
        contents[_MU] = __expectString(output[_MU]);
    }
    if (output[_DRI] != null) {
        contents[_DRI] = __expectString(output[_DRI]);
    }
    if (output[_TDRI] != null) {
        contents[_TDRI] = __expectString(output[_TDRI]);
    }
    if (output[_TDARN] != null) {
        contents[_TDARN] = __expectString(output[_TDARN]);
    }
    if (output[_CSN] != null) {
        contents[_CSN] = __expectString(output[_CSN]);
    }
    if (output[_NCSN] != null) {
        contents[_NCSN] = __expectString(output[_NCSN]);
    }
    if (output[_DP] != null) {
        contents[_DP] = __parseBoolean(output[_DP]);
    }
    if (output[_PMV] != null) {
        contents[_PMV] = de_TenantDatabasePendingModifiedValues(output[_PMV], context);
    }
    if (output[_MUS] != null) {
        contents[_MUS] = de_MasterUserSecret(output[_MUS], context);
    }
    if (output.TagList === "") {
        contents[_TL] = [];
    }
    else if (output[_TL] != null && output[_TL][_Tag] != null) {
        contents[_TL] = de_TagList(__getArrayIfSingleItem(output[_TL][_Tag]), context);
    }
    return contents;
};
const de_TenantDatabaseAlreadyExistsFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_TenantDatabaseNotFoundFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_TenantDatabasePendingModifiedValues = (output, context) => {
    const contents = {};
    if (output[_MUP] != null) {
        contents[_MUP] = __expectString(output[_MUP]);
    }
    if (output[_TDBN] != null) {
        contents[_TDBN] = __expectString(output[_TDBN]);
    }
    return contents;
};
const de_TenantDatabaseQuotaExceededFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_TenantDatabasesList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_TenantDatabase(entry, context);
    });
};
const de_TenantDatabasesMessage = (output, context) => {
    const contents = {};
    if (output[_Ma] != null) {
        contents[_Ma] = __expectString(output[_Ma]);
    }
    if (output.TenantDatabases === "") {
        contents[_TDe] = [];
    }
    else if (output[_TDe] != null && output[_TDe][_TD] != null) {
        contents[_TDe] = de_TenantDatabasesList(__getArrayIfSingleItem(output[_TDe][_TD]), context);
    }
    return contents;
};
const de_Timezone = (output, context) => {
    const contents = {};
    if (output[_TN] != null) {
        contents[_TN] = __expectString(output[_TN]);
    }
    return contents;
};
const de_UnsupportedDBEngineVersionFault = (output, context) => {
    const contents = {};
    if (output[_m] != null) {
        contents[_m] = __expectString(output[_m]);
    }
    return contents;
};
const de_UpgradeTarget = (output, context) => {
    const contents = {};
    if (output[_E] != null) {
        contents[_E] = __expectString(output[_E]);
    }
    if (output[_EV] != null) {
        contents[_EV] = __expectString(output[_EV]);
    }
    if (output[_D] != null) {
        contents[_D] = __expectString(output[_D]);
    }
    if (output[_AU] != null) {
        contents[_AU] = __parseBoolean(output[_AU]);
    }
    if (output[_IMVU] != null) {
        contents[_IMVU] = __parseBoolean(output[_IMVU]);
    }
    if (output.SupportedEngineModes === "") {
        contents[_SEM] = [];
    }
    else if (output[_SEM] != null && output[_SEM][_me] != null) {
        contents[_SEM] = de_EngineModeList(__getArrayIfSingleItem(output[_SEM][_me]), context);
    }
    if (output[_SPQ] != null) {
        contents[_SPQ] = __parseBoolean(output[_SPQ]);
    }
    if (output[_SGD] != null) {
        contents[_SGD] = __parseBoolean(output[_SGD]);
    }
    if (output[_SB] != null) {
        contents[_SB] = __parseBoolean(output[_SB]);
    }
    if (output[_SLD] != null) {
        contents[_SLD] = __parseBoolean(output[_SLD]);
    }
    if (output[_SLWF] != null) {
        contents[_SLWF] = __parseBoolean(output[_SLWF]);
    }
    if (output[_SIup] != null) {
        contents[_SIup] = __parseBoolean(output[_SIup]);
    }
    return contents;
};
const de_UserAuthConfigInfo = (output, context) => {
    const contents = {};
    if (output[_D] != null) {
        contents[_D] = __expectString(output[_D]);
    }
    if (output[_UN] != null) {
        contents[_UN] = __expectString(output[_UN]);
    }
    if (output[_ASu] != null) {
        contents[_ASu] = __expectString(output[_ASu]);
    }
    if (output[_SAe] != null) {
        contents[_SAe] = __expectString(output[_SAe]);
    }
    if (output[_IAMA] != null) {
        contents[_IAMA] = __expectString(output[_IAMA]);
    }
    if (output[_CPAT] != null) {
        contents[_CPAT] = __expectString(output[_CPAT]);
    }
    return contents;
};
const de_UserAuthConfigInfoList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_UserAuthConfigInfo(entry, context);
    });
};
const de_ValidDBInstanceModificationsMessage = (output, context) => {
    const contents = {};
    if (output.Storage === "") {
        contents[_Sto] = [];
    }
    else if (output[_Sto] != null && output[_Sto][_VSO] != null) {
        contents[_Sto] = de_ValidStorageOptionsList(__getArrayIfSingleItem(output[_Sto][_VSO]), context);
    }
    if (output.ValidProcessorFeatures === "") {
        contents[_VPF] = [];
    }
    else if (output[_VPF] != null && output[_VPF][_APFv] != null) {
        contents[_VPF] = de_AvailableProcessorFeatureList(__getArrayIfSingleItem(output[_VPF][_APFv]), context);
    }
    if (output[_SDLV] != null) {
        contents[_SDLV] = __parseBoolean(output[_SDLV]);
    }
    return contents;
};
const de_ValidStorageOptions = (output, context) => {
    const contents = {};
    if (output[_STt] != null) {
        contents[_STt] = __expectString(output[_STt]);
    }
    if (output.StorageSize === "") {
        contents[_SSt] = [];
    }
    else if (output[_SSt] != null && output[_SSt][_Ra] != null) {
        contents[_SSt] = de_RangeList(__getArrayIfSingleItem(output[_SSt][_Ra]), context);
    }
    if (output.ProvisionedIops === "") {
        contents[_PI] = [];
    }
    else if (output[_PI] != null && output[_PI][_Ra] != null) {
        contents[_PI] = de_RangeList(__getArrayIfSingleItem(output[_PI][_Ra]), context);
    }
    if (output.IopsToStorageRatio === "") {
        contents[_ITSR] = [];
    }
    else if (output[_ITSR] != null && output[_ITSR][_DR] != null) {
        contents[_ITSR] = de_DoubleRangeList(__getArrayIfSingleItem(output[_ITSR][_DR]), context);
    }
    if (output[_SSA] != null) {
        contents[_SSA] = __parseBoolean(output[_SSA]);
    }
    if (output.ProvisionedStorageThroughput === "") {
        contents[_PST] = [];
    }
    else if (output[_PST] != null && output[_PST][_Ra] != null) {
        contents[_PST] = de_RangeList(__getArrayIfSingleItem(output[_PST][_Ra]), context);
    }
    if (output.StorageThroughputToIopsRatio === "") {
        contents[_STTIR] = [];
    }
    else if (output[_STTIR] != null && output[_STTIR][_DR] != null) {
        contents[_STTIR] = de_DoubleRangeList(__getArrayIfSingleItem(output[_STTIR][_DR]), context);
    }
    return contents;
};
const de_ValidStorageOptionsList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_ValidStorageOptions(entry, context);
    });
};
const de_ValidUpgradeTargetList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_UpgradeTarget(entry, context);
    });
};
const de_VpcSecurityGroupMembership = (output, context) => {
    const contents = {};
    if (output[_VSGIp] != null) {
        contents[_VSGIp] = __expectString(output[_VSGIp]);
    }
    if (output[_St] != null) {
        contents[_St] = __expectString(output[_St]);
    }
    return contents;
};
const de_VpcSecurityGroupMembershipList = (output, context) => {
    return (output || [])
        .filter((e) => e != null)
        .map((entry) => {
        return de_VpcSecurityGroupMembership(entry, context);
    });
};
const deserializeMetadata = (output) => ({
    httpStatusCode: output.statusCode,
    requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
    extendedRequestId: output.headers["x-amz-id-2"],
    cfId: output.headers["x-amz-cf-id"],
});
const collectBodyString = (streamBody, context) => collectBody(streamBody, context).then((body) => context.utf8Encoder(body));
const throwDefaultError = withBaseException(__BaseException);
const buildHttpRpcRequest = async (context, headers, path, resolvedHostname, body) => {
    const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
    const contents = {
        protocol,
        hostname,
        port,
        method: "POST",
        path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
        headers,
    };
    if (resolvedHostname !== undefined) {
        contents.hostname = resolvedHostname;
    }
    if (body !== undefined) {
        contents.body = body;
    }
    return new __HttpRequest(contents);
};
const SHARED_HEADERS = {
    "content-type": "application/x-www-form-urlencoded",
};
const _ = "2014-10-31";
const _A = "Action";
const _AA = "ApplyAction";
const _AAAD = "AutoAppliedAfterDate";
const _ABRPA = "AwsBackupRecoveryPointArn";
const _ADBSGI = "AuthorizeDBSecurityGroupIngress";
const _ADL = "AllowDataLoss";
const _ADP = "AdditionalDataPending";
const _AEC = "AdditionalEncryptionContext";
const _AEMC = "AllowEngineModeChange";
const _AI = "ApplyImmediately";
const _AIc = "ActionId";
const _AId = "AdditionalInfo";
const _AM = "AutomationMode";
const _AMVU = "AutoMinorVersionUpgrade";
const _AMVUl = "AllowMajorVersionUpgrade";
const _AMp = "ApplyMethod";
const _AMpp = "ApplyModes";
const _AN = "AttributeName";
const _AP = "AutoPause";
const _APF = "AvailableProcessorFeatures";
const _APFv = "AvailableProcessorFeature";
const _APMA = "ApplyPendingMaintenanceAction";
const _APS = "AuditPolicyState";
const _AQ = "AccountQuotas";
const _AQN = "AccountQuotaName";
const _AQc = "AccountQuota";
const _AR = "AssociatedRoles";
const _ART = "AutomaticRestartTime";
const _ARTDBC = "AddRoleToDBCluster";
const _ARTDBI = "AddRoleToDBInstance";
const _AS = "AllocatedStorage";
const _ASA = "AuthSecretArn";
const _ASENAFI = "ActivityStreamEngineNativeAuditFieldsIncluded";
const _ASITS = "AddSourceIdentifierToSubscription";
const _ASKKI = "ActivityStreamKmsKeyId";
const _ASKSN = "ActivityStreamKinesisStreamName";
const _ASM = "ActivityStreamMode";
const _ASPS = "ActivityStreamPolicyStatus";
const _ASS = "ActivityStreamStatus";
const _ASu = "AuthScheme";
const _AT = "ApplyType";
const _ATTR = "AddTagsToResource";
const _AU = "AutoUpgrade";
const _AV = "AllowedValues";
const _AVANVIM = "AllowsVpcAndNonVpcInstanceMemberships";
const _AVl = "AllowedValue";
const _AVt = "AttributeValues";
const _AVtt = "AttributeValue";
const _AZ = "AvailabilityZones";
const _AZG = "AvailabilityZoneGroup";
const _AZv = "AvailabilityZone";
const _Ad = "Address";
const _An = "Analysis";
const _Ar = "Arn";
const _Au = "Auth";
const _BCCR = "BacktrackConsumedChangeRecords";
const _BDBC = "BacktrackDBCluster";
const _BF = "BacktrackedFrom";
const _BGD = "BlueGreenDeployment";
const _BGDI = "BlueGreenDeploymentIdentifier";
const _BGDN = "BlueGreenDeploymentName";
const _BGDl = "BlueGreenDeployments";
const _BI = "BacktrackIdentifier";
const _BRCT = "BacktrackRequestCreationTime";
const _BRP = "BackupRetentionPeriod";
const _BT = "BacktrackTo";
const _BTa = "BackupTarget";
const _BW = "BacktrackWindow";
const _C = "Capacity";
const _CA = "CertificateArn";
const _CAC = "CrossAccountClone";
const _CACI = "CACertificateIdentifier";
const _CAD = "CurrentApplyDate";
const _CAI = "CAIdentifier";
const _CAIu = "CustomerAwsId";
const _CAo = "ContextAttributes";
const _CBGD = "CreateBlueGreenDeployment";
const _CBT = "ConnectionBorrowTimeout";
const _CC = "CurrentCapacity";
const _CCA = "CopyableCrossAccount";
const _CCDBEV = "CreateCustomDBEngineVersion";
const _CCT = "ClusterCreateTime";
const _CCu = "CurrencyCode";
const _CD = "CertificateDetails";
const _CDBC = "CreateDBCluster";
const _CDBCE = "CreateDBClusterEndpoint";
const _CDBCPG = "CopyDBClusterParameterGroup";
const _CDBCPGr = "CreateDBClusterParameterGroup";
const _CDBCS = "CopyDBClusterSnapshot";
const _CDBCSr = "CreateDBClusterSnapshot";
const _CDBEVM = "CustomDBEngineVersionManifest";
const _CDBI = "CreateDBInstance";
const _CDBIRR = "CreateDBInstanceReadReplica";
const _CDBP = "CreateDBProxy";
const _CDBPE = "CreateDBProxyEndpoint";
const _CDBPG = "CopyDBParameterGroup";
const _CDBPGr = "CreateDBParameterGroup";
const _CDBS = "CopyDBSnapshot";
const _CDBSG = "CreateDBSecurityGroup";
const _CDBSGr = "CreateDBShardGroup";
const _CDBSGre = "CreateDBSubnetGroup";
const _CDBSr = "CreateDBSnapshot";
const _CDr = "CreatedDate";
const _CE = "CustomEndpoints";
const _CES = "CreateEventSubscription";
const _CET = "CancelExportTask";
const _CETu = "CustomEndpointType";
const _CGC = "CreateGlobalCluster";
const _CGI = "CloneGroupId";
const _CI = "CreateIntegration";
const _CIDRIP = "CIDRIP";
const _CIIP = "CustomIamInstanceProfile";
const _CIe = "CertificateIdentifier";
const _CLEC = "CloudwatchLogsExportConfiguration";
const _CO = "CustomerOverride";
const _COG = "CopyOptionGroup";
const _COGr = "CreateOptionGroup";
const _COIE = "CustomerOwnedIpEnabled";
const _COVT = "CustomerOverrideValidTill";
const _CPAT = "ClientPasswordAuthType";
const _CPC = "ConnectionPoolConfig";
const _CR = "ComputeRedundancy";
const _CRR = "CertificateRotationRestart";
const _CS = "CharacterSet";
const _CSD = "CharacterSetDescription";
const _CSI = "CustSubscriptionId";
const _CSN = "CharacterSetName";
const _CST = "ClusterScalabilityType";
const _CT = "CopyTags";
const _CTD = "CreateTenantDatabase";
const _CTTS = "CopyTagsToSnapshot";
const _CTe = "CertificateType";
const _CTo = "CopyTimestamp";
const _CTr = "CreateTime";
const _CTre = "CreatedTime";
const _Ca = "Category";
const _Ce = "Certificates";
const _Cer = "Certificate";
const _D = "Description";
const _DAA = "DescribeAccountAttributes";
const _DAB = "DeleteAutomatedBackups";
const _DASA = "DomainAuthSecretArn";
const _DBC = "DBCluster";
const _DBCA = "DBClusterArn";
const _DBCAB = "DBClusterAutomatedBackups";
const _DBCABA = "DBClusterAutomatedBackupsArn";
const _DBCABl = "DBClusterAutomatedBackup";
const _DBCB = "DBClusterBacktracks";
const _DBCBl = "DBClusterBacktrack";
const _DBCE = "DBClusterEndpoints";
const _DBCEA = "DBClusterEndpointArn";
const _DBCEI = "DBClusterEndpointIdentifier";
const _DBCEL = "DBClusterEndpointList";
const _DBCERI = "DBClusterEndpointResourceIdentifier";
const _DBCI = "DBClusterIdentifier";
const _DBCIC = "DBClusterInstanceClass";
const _DBCIl = "DBClusterIdentifiers";
const _DBCM = "DBClusterMembers";
const _DBCMl = "DBClusterMember";
const _DBCOG = "DBClusterOptionGroup";
const _DBCOGM = "DBClusterOptionGroupMemberships";
const _DBCOGN = "DBClusterOptionGroupName";
const _DBCPG = "DBClusterParameterGroup";
const _DBCPGA = "DBClusterParameterGroupArn";
const _DBCPGN = "DBClusterParameterGroupName";
const _DBCPGS = "DBClusterParameterGroupStatus";
const _DBCPGl = "DBClusterParameterGroups";
const _DBCR = "DBClusterRole";
const _DBCS = "DBClusterSnapshot";
const _DBCSA = "DBClusterSnapshotArn";
const _DBCSAR = "DBClusterSnapshotAttributesResult";
const _DBCSAl = "DBClusterSnapshotAttributes";
const _DBCSAlu = "DBClusterSnapshotAttribute";
const _DBCSI = "DBClusterSnapshotIdentifier";
const _DBCSIl = "DBClusterStatusInfo";
const _DBCSl = "DBClusterSnapshots";
const _DBCl = "DBClusters";
const _DBED = "DBEngineDescription";
const _DBEMT = "DBEngineMediaType";
const _DBEV = "DBEngineVersions";
const _DBEVA = "DBEngineVersionArn";
const _DBEVD = "DBEngineVersionDescription";
const _DBEVn = "DBEngineVersion";
const _DBGD = "DeleteBlueGreenDeployment";
const _DBGDe = "DescribeBlueGreenDeployments";
const _DBI = "DBInstance";
const _DBIA = "DBInstanceArn";
const _DBIAB = "DBInstanceAutomatedBackups";
const _DBIABA = "DBInstanceAutomatedBackupsArn";
const _DBIABR = "DBInstanceAutomatedBackupsReplications";
const _DBIABRn = "DBInstanceAutomatedBackupsReplication";
const _DBIABn = "DBInstanceAutomatedBackup";
const _DBIC = "DBInstanceClass";
const _DBICn = "DBInstanceCount";
const _DBII = "DBInstanceIdentifier";
const _DBIIn = "DBInstanceIdentifiers";
const _DBIPGN = "DBInstanceParameterGroupName";
const _DBIR = "DBInstanceRole";
const _DBIS = "DBInstanceStatus";
const _DBISI = "DBInstanceStatusInfo";
const _DBIn = "DBInstances";
const _DBMEV = "DBMajorEngineVersions";
const _DBMEVa = "DBMajorEngineVersion";
const _DBN = "DBName";
const _DBP = "DBProxy";
const _DBPA = "DBProxyArn";
const _DBPE = "DBProxyEndpoint";
const _DBPEA = "DBProxyEndpointArn";
const _DBPEN = "DBProxyEndpointName";
const _DBPEr = "DBProxyEndpoints";
const _DBPG = "DBParameterGroup";
const _DBPGA = "DBParameterGroupArn";
const _DBPGF = "DBParameterGroupFamily";
const _DBPGN = "DBParameterGroupName";
const _DBPGa = "DBParameterGroups";
const _DBPN = "DBProxyName";
const _DBPNo = "DBPortNumber";
const _DBPT = "DBProxyTargets";
const _DBPTG = "DBProxyTargetGroup";
const _DBPr = "DBProxies";
const _DBR = "DBRecommendation";
const _DBRe = "DBRecommendations";
const _DBS = "DBSnapshot";
const _DBSA = "DBSnapshotArn";
const _DBSAR = "DBSnapshotAttributesResult";
const _DBSAn = "DBSnapshotAttributes";
const _DBSAna = "DBSnapshotAttribute";
const _DBSG = "DBSecurityGroups";
const _DBSGA = "DBSecurityGroupArn";
const _DBSGAh = "DBShardGroupArn";
const _DBSGAu = "DBSubnetGroupArn";
const _DBSGD = "DBSecurityGroupDescription";
const _DBSGDu = "DBSubnetGroupDescription";
const _DBSGI = "DBShardGroupIdentifier";
const _DBSGM = "DBSecurityGroupMemberships";
const _DBSGN = "DBSecurityGroupName";
const _DBSGNu = "DBSubnetGroupName";
const _DBSGRI = "DBShardGroupResourceId";
const _DBSGe = "DBSecurityGroup";
const _DBSGh = "DBShardGroups";
const _DBSGha = "DBShardGroup";
const _DBSGu = "DBSubnetGroup";
const _DBSGub = "DBSubnetGroups";
const _DBSI = "DBSystemId";
const _DBSIn = "DBSnapshotIdentifier";
const _DBSTD = "DBSnapshotTenantDatabases";
const _DBSTDARN = "DBSnapshotTenantDatabaseARN";
const _DBSTDn = "DBSnapshotTenantDatabase";
const _DBSn = "DBSnapshots";
const _DC = "DescribeCertificates";
const _DCDBEV = "DeleteCustomDBEngineVersion";
const _DCFNL = "DefaultCertificateForNewLaunches";
const _DCI = "DbClusterIdentifier";
const _DCRI = "DbClusterResourceId";
const _DCS = "DefaultCharacterSet";
const _DD = "DisableDomain";
const _DDBC = "DeleteDBCluster";
const _DDBCAB = "DeleteDBClusterAutomatedBackup";
const _DDBCABe = "DescribeDBClusterAutomatedBackups";
const _DDBCB = "DescribeDBClusterBacktracks";
const _DDBCE = "DeleteDBClusterEndpoint";
const _DDBCEe = "DescribeDBClusterEndpoints";
const _DDBCP = "DescribeDBClusterParameters";
const _DDBCPG = "DeleteDBClusterParameterGroup";
const _DDBCPGe = "DescribeDBClusterParameterGroups";
const _DDBCS = "DeleteDBClusterSnapshot";
const _DDBCSA = "DescribeDBClusterSnapshotAttributes";
const _DDBCSe = "DescribeDBClusterSnapshots";
const _DDBCe = "DescribeDBClusters";
const _DDBEV = "DescribeDBEngineVersions";
const _DDBI = "DeleteDBInstance";
const _DDBIAB = "DeleteDBInstanceAutomatedBackup";
const _DDBIABe = "DescribeDBInstanceAutomatedBackups";
const _DDBIe = "DescribeDBInstances";
const _DDBLF = "DescribeDBLogFiles";
const _DDBLFD = "DescribeDBLogFilesDetails";
const _DDBLFP = "DownloadDBLogFilePortion";
const _DDBMEV = "DescribeDBMajorEngineVersions";
const _DDBP = "DeleteDBProxy";
const _DDBPE = "DeleteDBProxyEndpoint";
const _DDBPEe = "DescribeDBProxyEndpoints";
const _DDBPG = "DeleteDBParameterGroup";
const _DDBPGe = "DescribeDBParameterGroups";
const _DDBPT = "DeregisterDBProxyTargets";
const _DDBPTG = "DescribeDBProxyTargetGroups";
const _DDBPTe = "DescribeDBProxyTargets";
const _DDBPe = "DescribeDBParameters";
const _DDBPes = "DescribeDBProxies";
const _DDBR = "DescribeDBRecommendations";
const _DDBS = "DeleteDBSnapshot";
const _DDBSA = "DescribeDBSnapshotAttributes";
const _DDBSG = "DeleteDBSecurityGroup";
const _DDBSGe = "DeleteDBShardGroup";
const _DDBSGel = "DeleteDBSubnetGroup";
const _DDBSGes = "DescribeDBSecurityGroups";
const _DDBSGesc = "DescribeDBShardGroups";
const _DDBSGescr = "DescribeDBSubnetGroups";
const _DDBSTD = "DescribeDBSnapshotTenantDatabases";
const _DDBSe = "DescribeDBSnapshots";
const _DDI = "DomainDnsIps";
const _DE = "DescribeEvents";
const _DEC = "DescribeEventCategories";
const _DEDCP = "DescribeEngineDefaultClusterParameters";
const _DEDP = "DescribeEngineDefaultParameters";
const _DES = "DeleteEventSubscription";
const _DESe = "DescribeEventSubscriptions";
const _DET = "DescribeExportTasks";
const _DF = "DomainFqdn";
const _DFa = "DataFilter";
const _DGC = "DeleteGlobalCluster";
const _DGCe = "DescribeGlobalClusters";
const _DHE = "DisableHttpEndpoint";
const _DI = "DeleteIntegration";
const _DIAMRN = "DomainIAMRoleName";
const _DIFSBN = "DatabaseInstallationFilesS3BucketName";
const _DIFSP = "DatabaseInstallationFilesS3Prefix";
const _DIM = "DatabaseInsightsMode";
const _DIP = "DbInstancePort";
const _DIe = "DescribeIntegrations";
const _DIn = "DnsIps";
const _DL = "DebugLogging";
const _DLT = "DisableLogTypes";
const _DLV = "DedicatedLogVolume";
const _DM = "DomainMemberships";
const _DMo = "DomainMembership";
const _DN = "DatabaseName";
const _DO = "DomainOu";
const _DODBIO = "DescribeOrderableDBInstanceOptions";
const _DOG = "DeleteOptionGroup";
const _DOGO = "DescribeOptionGroupOptions";
const _DOGe = "DescribeOptionGroups";
const _DOe = "DefaultOnly";
const _DP = "DeletionProtection";
const _DPMA = "DescribePendingMaintenanceActions";
const _DPe = "DefaultPort";
const _DR = "DoubleRange";
const _DRDBI = "DescribeReservedDBInstances";
const _DRDBIO = "DescribeReservedDBInstancesOfferings";
const _DRI = "DbiResourceId";
const _DSR = "DescribeSourceRegions";
const _DT = "DeleteTarget";
const _DTD = "DeleteTenantDatabase";
const _DTDe = "DescribeTenantDatabases";
const _DTa = "DataType";
const _DTe = "DeleteTime";
const _DV = "DefaultValue";
const _DVDBIM = "DescribeValidDBInstanceModifications";
const _Da = "Date";
const _De = "Detection";
const _Di = "Dimensions";
const _Do = "Domain";
const _Du = "Duration";
const _E = "Engine";
const _EBT = "EarliestBacktrackTime";
const _EC = "EventCategories";
const _ECL = "EventCategoriesList";
const _ECLE = "EnableCloudwatchLogsExports";
const _ECLEn = "EnabledCloudwatchLogsExports";
const _ECM = "EventCategoriesMap";
const _ECML = "EventCategoriesMapList";
const _ECOI = "EnableCustomerOwnedIp";
const _ECSG = "EC2SecurityGroups";
const _ECSGI = "EC2SecurityGroupId";
const _ECSGN = "EC2SecurityGroupName";
const _ECSGOI = "EC2SecurityGroupOwnerId";
const _ECSGe = "EC2SecurityGroup";
const _ECr = "ErrorCode";
const _ECv = "EventCategory";
const _ED = "EngineDefaults";
const _EF = "EngineFamily";
const _EGWF = "EnableGlobalWriteForwarding";
const _EHE = "EnableHttpEndpoint";
const _EIAMDA = "EnableIAMDatabaseAuthentication";
const _ELD = "EnableLimitlessDatabase";
const _ELS = "EngineLifecycleSupport";
const _ELT = "EnableLogTypes";
const _ELTx = "ExportableLogTypes";
const _ELWF = "EnableLocalWriteForwarding";
const _EM = "ExcludedMembers";
const _EMRA = "EnhancedMonitoringResourceArn";
const _EMn = "EngineMode";
const _EMr = "ErrorMessage";
const _EN = "EngineName";
const _ENAFI = "EngineNativeAuditFieldsIncluded";
const _EO = "ExportOnly";
const _EPI = "EnablePerformanceInsights";
const _ERT = "EarliestRestorableTime";
const _ES = "EventSubscription";
const _ESA = "EventSubscriptionArn";
const _ESL = "EventSubscriptionsList";
const _ET = "EndpointType";
const _ETI = "ExportTaskIdentifier";
const _ETa = "EarliestTime";
const _ETn = "EndTime";
const _ETx = "ExportTasks";
const _ETxp = "ExportTask";
const _EV = "EngineVersion";
const _En = "Enabled";
const _Enc = "Encrypted";
const _End = "Endpoint";
const _Er = "Errors";
const _Ev = "Events";
const _Eve = "Event";
const _F = "Force";
const _FAD = "ForcedApplyDate";
const _FC = "FilenameContains";
const _FCa = "FailureCause";
const _FDBC = "FailoverDBCluster";
const _FDBSI = "FinalDBSnapshotIdentifier";
const _FDCA = "FromDbClusterArn";
const _FF = "ForceFailover";
const _FGC = "FailoverGlobalCluster";
const _FLW = "FileLastWritten";
const _FN = "FeatureName";
const _FP = "FixedPrice";
const _FQDN = "FQDN";
const _FS = "FileSize";
const _FSa = "FailoverState";
const _Fi = "Filters";
const _Fr = "From";
const _G = "Group";
const _GB = "GroupBy";
const _GC = "GlobalCluster";
const _GCA = "GlobalClusterArn";
const _GCI = "GlobalClusterIdentifier";
const _GCM = "GlobalClusterMembers";
const _GCMl = "GlobalClusterMember";
const _GCRI = "GlobalClusterResourceId";
const _GCl = "GlobalClusters";
const _GWFR = "GlobalWriteForwardingRequested";
const _GWFS = "GlobalWriteForwardingStatus";
const _HEE = "HttpEndpointEnabled";
const _HZI = "HostedZoneId";
const _I = "Iops";
const _IA = "IncludeAll";
const _IAMA = "IAMAuth";
const _IAMDAE = "IAMDatabaseAuthenticationEnabled";
const _IAMRN = "IAMRoleName";
const _IAn = "IntegrationArn";
const _IC = "IsCollection";
const _ICT = "IdleClientTimeout";
const _ICTn = "InstanceCreateTime";
const _ICW = "IsClusterWriter";
const _ID = "IsDefault";
const _IDLA = "IsDataLossAllowed";
const _IDs = "IssueDetails";
const _IE = "IntegrationError";
const _II = "ImageId";
const _IIn = "IntegrationIdentifier";
const _IM = "IsModifiable";
const _IMVU = "IsMajorVersionUpgrade";
const _IN = "IntegrationName";
const _IOONAMT = "IOOptimizedNextAllowedModificationTime";
const _IP = "IncludePublic";
const _IPR = "IPRanges";
const _IPRa = "IPRange";
const _IQ = "InitQuery";
const _IR = "IsRequired";
const _IRA = "IamRoleArn";
const _IS = "IncludeShared";
const _ISCUA = "IsStorageConfigUpgradeAvailable";
const _ISI = "InterconnectSubnetId";
const _ITSR = "IopsToStorageRatio";
const _IW = "IsWriter";
const _Im = "Image";
const _Imp = "Impact";
const _In = "Integrations";
const _Int = "Integration";
const _K = "Key";
const _KKI = "KmsKeyId";
const _KMSKI = "KMSKeyId";
const _KSN = "KinesisStreamName";
const _L = "Locale";
const _LD = "LimitlessDatabase";
const _LE = "ListenerEndpoint";
const _LFD = "LogFileData";
const _LFN = "LogFileName";
const _LI = "LeaseId";
const _LM = "LicenseModel";
const _LRT = "LatestRestorableTime";
const _LSCS = "ListSupportedCharacterSets";
const _LSED = "LifecycleSupportEndDate";
const _LSN = "LifecycleSupportName";
const _LSSD = "LifecycleSupportStartDate";
const _LST = "ListSupportedTimezones";
const _LT = "LatestTime";
const _LTFR = "ListTagsForResource";
const _LTTD = "LogTypesToDisable";
const _LTTE = "LogTypesToEnable";
const _LUA = "LastUpdatedAfter";
const _LUB = "LastUpdatedBefore";
const _LW = "LastWritten";
const _LWFS = "LocalWriteForwardingStatus";
const _Li = "Links";
const _Lim = "Limit";
const _M = "Manifest";
const _MACU = "MaxACU";
const _MACUi = "MinACU";
const _MAS = "ModifyActivityStream";
const _MASa = "MaxAllocatedStorage";
const _MAZ = "MultiAZ";
const _MAZC = "MultiAZCapable";
const _MC = "ModifyCertificates";
const _MCDBCC = "ModifyCurrentDBClusterCapacity";
const _MCDBEV = "ModifyCustomDBEngineVersion";
const _MCP = "MaxConnectionsPercent";
const _MCa = "MaxCapacity";
const _MCi = "MinCapacity";
const _MDBC = "ModifyDBCluster";
const _MDBCE = "ModifyDBClusterEndpoint";
const _MDBCPG = "ModifyDBClusterParameterGroup";
const _MDBCSA = "ModifyDBClusterSnapshotAttribute";
const _MDBI = "ModifyDBInstance";
const _MDBP = "ModifyDBProxy";
const _MDBPE = "ModifyDBProxyEndpoint";
const _MDBPG = "ModifyDBParameterGroup";
const _MDBPTG = "ModifyDBProxyTargetGroup";
const _MDBR = "ModifyDBRecommendation";
const _MDBS = "ModifyDBSnapshot";
const _MDBSA = "ModifyDBSnapshotAttribute";
const _MDBSG = "ModifyDBShardGroup";
const _MDBSGo = "ModifyDBSubnetGroup";
const _MES = "ModifyEventSubscription";
const _MEV = "MajorEngineVersion";
const _MEVPAV = "MinimumEngineVersionPerAllowedValue";
const _MEVi = "MinimumEngineVersion";
const _MGC = "ModifyGlobalCluster";
const _MI = "ModifyIntegration";
const _MICP = "MaxIdleConnectionsPercent";
const _MIPDI = "MinIopsPerDbInstance";
const _MIPDIa = "MaxIopsPerDbInstance";
const _MIPG = "MinIopsPerGib";
const _MIPGa = "MaxIopsPerGib";
const _MIo = "MonitoringInterval";
const _MMUP = "ManageMasterUserPassword";
const _MOG = "ModifyOptionGroup";
const _MQ = "MetricQuery";
const _MR = "MaxRecords";
const _MRA = "MonitoringRoleArn";
const _MRACU = "MinRequiredACU";
const _MRMEV = "MinimumRequiredMinorEngineVersion";
const _MSS = "MinStorageSize";
const _MSSa = "MaxStorageSize";
const _MSTPDI = "MinStorageThroughputPerDbInstance";
const _MSTPDIa = "MaxStorageThroughputPerDbInstance";
const _MSTPI = "MinStorageThroughputPerIops";
const _MSTPIa = "MaxStorageThroughputPerIops";
const _MT = "MultiTenant";
const _MTD = "ModifyTenantDatabase";
const _MU = "MasterUsername";
const _MUP = "MasterUserPassword";
const _MUS = "MasterUserSecret";
const _MUSKKI = "MasterUserSecretKmsKeyId";
const _Ma = "Marker";
const _Max = "Max";
const _Me = "Message";
const _Met = "Metric";
const _Metr = "Metrics";
const _Mo = "Mode";
const _N = "Name";
const _NCSN = "NcharCharacterSetName";
const _NDBCI = "NewDBClusterIdentifier";
const _NDBII = "NewDBInstanceIdentifier";
const _NDBPEN = "NewDBProxyEndpointName";
const _NDBPN = "NewDBProxyName";
const _NGCI = "NewGlobalClusterIdentifier";
const _NN = "NewName";
const _NOL = "NumberOfLines";
const _NT = "NetworkType";
const _NTDBN = "NewTenantDBName";
const _No = "Normal";
const _O = "Options";
const _OC = "OutpostCapable";
const _OCN = "OptionConflictName";
const _OCW = "OptionsConflictsWith";
const _OD = "OptionDescription";
const _ODBIO = "OrderableDBInstanceOptions";
const _ODBIOr = "OrderableDBInstanceOption";
const _ODO = "OptionsDependedOn";
const _OG = "OptionGroup";
const _OGA = "OptionGroupArn";
const _OGD = "OptionGroupDescription";
const _OGL = "OptionGroupsList";
const _OGM = "OptionGroupMemberships";
const _OGMp = "OptionGroupMembership";
const _OGN = "OptionGroupName";
const _OGO = "OptionGroupOptions";
const _OGOS = "OptionGroupOptionSettings";
const _OGOSp = "OptionGroupOptionSetting";
const _OGOV = "OptionGroupOptionVersions";
const _OGOp = "OptionGroupOption";
const _OI = "OwnerId";
const _OIS = "OptInStatus";
const _OIT = "OptInType";
const _ON = "OptionName";
const _OS = "OptionSettings";
const _OSCT = "OriginalSnapshotCreateTime";
const _OSp = "OptionSetting";
const _OT = "OfferingType";
const _OTI = "OptionsToInclude";
const _OTR = "OptionsToRemove";
const _OU = "OU";
const _OV = "OptionVersion";
const _Op = "Option";
const _Ope = "Operation";
const _P = "Port";
const _PA = "PubliclyAccessible";
const _PAS = "ParameterApplyStatus";
const _PBW = "PreferredBackupWindow";
const _PC = "PendingCapacity";
const _PCLE = "PendingCloudwatchLogsExports";
const _PD = "ProductDescription";
const _PF = "ProcessorFeatures";
const _PFr = "ProcessorFeature";
const _PI = "ProvisionedIops";
const _PID = "PerformanceIssueDetails";
const _PIE = "PerformanceInsightsEnabled";
const _PIKMSKI = "PerformanceInsightsKMSKeyId";
const _PIMQ = "PerformanceInsightsMetricQuery";
const _PIRP = "PerformanceInsightsRetentionPeriod";
const _PMA = "PendingMaintenanceActions";
const _PMAD = "PendingMaintenanceActionDetails";
const _PMAe = "PendingMaintenanceAction";
const _PMV = "PendingModifiedValues";
const _PMW = "PreferredMaintenanceWindow";
const _PN = "ParameterName";
const _PP = "PercentProgress";
const _PR = "PortRequired";
const _PRDBIO = "PurchaseReservedDBInstancesOffering";
const _PRR = "PromoteReadReplica";
const _PRRDBC = "PromoteReadReplicaDBCluster";
const _PS = "PolicyStatus";
const _PST = "ProvisionedStorageThroughput";
const _PSU = "PreSignedUrl";
const _PT = "PromotionTier";
const _PV = "ParameterValue";
const _Pa = "Parameters";
const _Par = "Parameter";
const _Pe = "Persistent";
const _Per = "Permanent";
const _R = "Region";
const _RA = "RoleArn";
const _RAMEVU = "RequiresAutoMinorEngineVersionUpgrade";
const _RAP = "ResetAllParameters";
const _RAU = "RecommendedActionUpdates";
const _RAe = "ResourceArn";
const _RAec = "RecommendedActions";
const _RC = "RecurringCharges";
const _RCA = "RecurringChargeAmount";
const _RCCC = "RdsCustomClusterConfiguration";
const _RCF = "RecurringChargeFrequency";
const _RCO = "RemoveCustomerOverride";
const _RCe = "RecurringCharge";
const _RD = "ReferenceDetails";
const _RDBC = "RebootDBCluster";
const _RDBCFS = "RestoreDBClusterFromS3";
const _RDBCFSe = "RestoreDBClusterFromSnapshot";
const _RDBCPG = "ResetDBClusterParameterGroup";
const _RDBCTPIT = "RestoreDBClusterToPointInTime";
const _RDBI = "RebootDBInstance";
const _RDBIA = "ReservedDBInstanceArn";
const _RDBIFDBS = "RestoreDBInstanceFromDBSnapshot";
const _RDBIFS = "RestoreDBInstanceFromS3";
const _RDBII = "ReservedDBInstanceId";
const _RDBIO = "ReservedDBInstancesOfferings";
const _RDBIOI = "ReservedDBInstancesOfferingId";
const _RDBIOe = "ReservedDBInstancesOffering";
const _RDBITPIT = "RestoreDBInstanceToPointInTime";
const _RDBIe = "ReservedDBInstance";
const _RDBIes = "ReservedDBInstances";
const _RDBPG = "ResetDBParameterGroup";
const _RDBPT = "RegisterDBProxyTargets";
const _RDBSG = "RebootDBShardGroup";
const _RDBSGI = "RevokeDBSecurityGroupIngress";
const _RE = "ReaderEndpoint";
const _RFAMM = "ResumeFullAutomationModeMinutes";
const _RFAMT = "ResumeFullAutomationModeTime";
const _RFGC = "RemoveFromGlobalCluster";
const _RI = "ResourceIdentifier";
const _RIe = "RecommendationId";
const _RM = "ReplicaMode";
const _RMUP = "RotateMasterUserPassword";
const _RN = "ResourceName";
const _RNe = "RegionName";
const _RPMA = "ResourcePendingMaintenanceActions";
const _RRC = "ReadReplicaCapable";
const _RRDBCI = "ReadReplicaDBClusterIdentifiers";
const _RRDBCIe = "ReadReplicaDBClusterIdentifier";
const _RRDBII = "ReadReplicaDBInstanceIdentifiers";
const _RRDBIIe = "ReadReplicaDBInstanceIdentifier";
const _RRFDBC = "RemoveRoleFromDBCluster";
const _RRFDBI = "RemoveRoleFromDBInstance";
const _RRI = "ReadReplicaIdentifiers";
const _RRId = "RdsResourceId";
const _RRIe = "ReadReplicaIdentifier";
const _RRSDBCI = "ReadReplicaSourceDBClusterIdentifier";
const _RRSDBII = "ReadReplicaSourceDBInstanceIdentifier";
const _RSI = "ReplicationSourceIdentifier";
const _RSIFS = "RemoveSourceIdentifierFromSubscription";
const _RT = "RestoreType";
const _RTFR = "RemoveTagsFromResource";
const _RTLS = "RequireTLS";
const _RTT = "RestoreToTime";
const _RTe = "RestoreTime";
const _RW = "RestoreWindow";
const _Ra = "Range";
const _Re = "Recommendation";
const _Rea = "Reason";
const _Read = "Readers";
const _Ref = "References";
const _Ro = "Role";
const _S = "Source";
const _SA = "SourceArn";
const _SAI = "SourceAccountId";
const _SAS = "StartActivityStream";
const _SASM = "SupportedActivityStreamModes";
const _SASt = "StopActivityStream";
const _SAZ = "SnapshotAvailabilityZone";
const _SAZe = "SecondaryAvailabilityZone";
const _SAZu = "SubnetAvailabilityZone";
const _SAe = "SecretArn";
const _SB = "SupportsBabelfish";
const _SBGD = "SwitchoverBlueGreenDeployment";
const _SBN = "S3BucketName";
const _SBT = "SecondsBeforeTimeout";
const _SBu = "S3Bucket";
const _SC = "ScalingConfiguration";
const _SCACI = "SupportedCACertificateIdentifiers";
const _SCDEVI = "SourceCustomDbEngineVersionIdentifier";
const _SCI = "ScalingConfigurationInfo";
const _SCRWR = "SupportsCertificateRotationWithoutRestart";
const _SCS = "SupportedCharacterSets";
const _SCT = "SnapshotCreateTime";
const _SCTu = "SubscriptionCreationTime";
const _SCu = "SupportsClusters";
const _SD = "SwitchoverDetails";
const _SDBC = "StartDBCluster";
const _SDBCI = "SourceDBClusterIdentifier";
const _SDBCPGI = "SourceDBClusterParameterGroupIdentifier";
const _SDBCSA = "SourceDBClusterSnapshotArn";
const _SDBCSI = "SourceDBClusterSnapshotIdentifier";
const _SDBCt = "StopDBCluster";
const _SDBI = "StartDBInstance";
const _SDBIA = "SourceDBInstanceArn";
const _SDBIABA = "SourceDBInstanceAutomatedBackupsArn";
const _SDBIABR = "StartDBInstanceAutomatedBackupsReplication";
const _SDBIABRt = "StopDBInstanceAutomatedBackupsReplication";
const _SDBIABRu = "SupportsDBInstanceAutomatedBackupsReplication";
const _SDBII = "SourceDBInstanceIdentifier";
const _SDBIt = "StopDBInstance";
const _SDBPGI = "SourceDBParameterGroupIdentifier";
const _SDBSI = "SourceDBSnapshotIdentifier";
const _SDCRI = "SourceDbClusterResourceId";
const _SDLV = "SupportsDedicatedLogVolume";
const _SDRI = "SourceDbiResourceId";
const _SDT = "SnapshotDatabaseTime";
const _SDe = "SettingDescription";
const _SDt = "StatusDetails";
const _SDta = "StatisticsDetails";
const _SE = "StorageEncrypted";
const _SEL = "SupportedEngineLifecycles";
const _SELu = "SupportedEngineLifecycle";
const _SEM = "SupportedEngineModes";
const _SEMu = "SupportsEnhancedMonitoring";
const _SET = "StartExportTask";
const _SEV = "SourceEngineVersion";
const _SEo = "SourceEngine";
const _SFN = "SupportedFeatureNames";
const _SFS = "SkipFinalSnapshot";
const _SG = "SecurityGroups";
const _SGC = "SwitchoverGlobalCluster";
const _SGD = "SupportsGlobalDatabases";
const _SGS = "SubnetGroupStatus";
const _SI = "SourceIdentifier";
const _SIAMDA = "SupportsIAMDatabaseAuthentication";
const _SIL = "SourceIdsList";
const _SIRA = "S3IngestionRoleArn";
const _SIn = "SnapshotIdentifier";
const _SIo = "SourceIds";
const _SIou = "SourceId";
const _SIt = "StatusInfos";
const _SIu = "SubnetIds";
const _SIub = "SubnetIdentifier";
const _SIup = "SupportsIntegrations";
const _SIupp = "SupportsIops";
const _SKA = "SupportsKerberosAuthentication";
const _SLD = "SupportsLimitlessDatabase";
const _SLETCL = "SupportsLogExportsToCloudwatchLogs";
const _SLWF = "SupportsLocalWriteForwarding";
const _SM = "StaticMembers";
const _SMo = "SourceMember";
const _SN = "SubscriptionName";
const _SNCS = "SupportedNcharCharacterSets";
const _SNT = "SupportedNetworkTypes";
const _SNe = "SettingName";
const _SO = "SubnetOutpost";
const _SOG = "SourceOptionGroup";
const _SOGI = "SourceOptionGroupIdentifier";
const _SOVD = "SupportsOptionVersionDowngrade";
const _SP = "S3Prefix";
const _SPF = "SessionPinningFilters";
const _SPI = "SupportsPerformanceInsights";
const _SPQ = "SupportsParallelQuery";
const _SR = "SourceRegion";
const _SRD = "ScalarReferenceDetails";
const _SRR = "SwitchoverReadReplica";
const _SRRu = "SupportsReadReplica";
const _SRo = "SourceRegions";
const _SS = "SynchronizationStatus";
const _SSA = "SupportsStorageAutoscaling";
const _SSE = "SupportsStorageEncryption";
const _SST = "SupportsStorageThroughput";
const _SSe = "SecretStatus";
const _SSt = "StorageSize";
const _SSu = "SubnetStatus";
const _ST = "SnapshotTarget";
const _STA = "SnsTopicArn";
const _STTIR = "StorageThroughputToIopsRatio";
const _STn = "SnapshotType";
const _STna = "SnapshotTime";
const _STo = "SourceType";
const _STt = "StorageType";
const _STta = "StartTime";
const _STtat = "StatusType";
const _STto = "StorageThroughput";
const _STu = "SupportedTimezones";
const _STw = "SwitchoverTimeout";
const _SUAP = "SecondsUntilAutoPause";
const _SVFS = "ServerlessV2FeaturesSupport";
const _SVSC = "ServerlessV2ScalingConfiguration";
const _Se = "Severity";
const _Si = "Size";
const _St = "Status";
const _Sta = "State";
const _Ste = "Step";
const _Sto = "Storage";
const _Su = "Subnets";
const _Sub = "Subnet";
const _Sw = "Switchover";
const _T = "Tags";
const _TA = "TargetArn";
const _TAS = "TargetAllocatedStorage";
const _TAi = "TimeoutAction";
const _TCA = "TdeCredentialArn";
const _TCAZ = "TargetCustomAvailabilityZone";
const _TCI = "TrackedClusterId";
const _TCP = "TdeCredentialPassword";
const _TD = "TenantDatabase";
const _TDARN = "TenantDatabaseARN";
const _TDBCPGD = "TargetDBClusterParameterGroupDescription";
const _TDBCPGI = "TargetDBClusterParameterGroupIdentifier";
const _TDBCPGN = "TargetDBClusterParameterGroupName";
const _TDBCSI = "TargetDBClusterSnapshotIdentifier";
const _TDBIC = "TargetDBInstanceClass";
const _TDBII = "TargetDBInstanceIdentifier";
const _TDBN = "TenantDBName";
const _TDBPGD = "TargetDBParameterGroupDescription";
const _TDBPGI = "TargetDBParameterGroupIdentifier";
const _TDBPGN = "TargetDBParameterGroupName";
const _TDBSI = "TargetDBSnapshotIdentifier";
const _TDCA = "ToDbClusterArn";
const _TDCI = "TargetDbClusterIdentifier";
const _TDCT = "TenantDatabaseCreateTime";
const _TDRI = "TenantDatabaseResourceId";
const _TDe = "TenantDatabases";
const _TDy = "TypeDetection";
const _TEDIGB = "TotalExtractedDataInGB";
const _TET = "TaskEndTime";
const _TEV = "TargetEngineVersion";
const _TG = "TargetGroups";
const _TGA = "TargetGroupArn";
const _TGMDI = "TransitGatewayMulticastDomainId";
const _TGN = "TargetGroupName";
const _TH = "TargetHealth";
const _TI = "TargetIops";
const _TIy = "TypeId";
const _TK = "TagKeys";
const _TL = "TagList";
const _TM = "TargetMember";
const _TN = "TimezoneName";
const _TOGD = "TargetOptionGroupDescription";
const _TOGI = "TargetOptionGroupIdentifier";
const _TR = "TargetRole";
const _TRy = "TypeRecommendation";
const _TST = "TargetStorageType";
const _TSTa = "TargetStorageThroughput";
const _TSTas = "TaskStartTime";
const _Ta = "Target";
const _Tag = "Tag";
const _Tar = "Targets";
const _Tas = "Tasks";
const _Te = "Text";
const _Th = "Thumbprint";
const _Ti = "Timezone";
const _Tit = "Title";
const _To = "To";
const _Ty = "Type";
const _U = "Used";
const _UAPLI = "UseAwsProvidedLatestImage";
const _UD = "UpdatedDate";
const _UDPF = "UseDefaultProcessorFeatures";
const _UETOPITU = "UseEarliestTimeOnPointInTimeUnavailable";
const _ULRT = "UseLatestRestorableTime";
const _UN = "UserName";
const _UP = "UsagePrice";
const _USC = "UpgradeStorageConfig";
const _UT = "UpgradeTarget";
const _UTSC = "UpgradeTargetStorageConfig";
const _UTp = "UpdatedTime";
const _Ur = "Url";
const _V = "Version";
const _VDBIMM = "ValidDBInstanceModificationsMessage";
const _VF = "ValidFrom";
const _VI = "VpcId";
const _VO = "VpcOnly";
const _VPF = "ValidProcessorFeatures";
const _VSG = "VpcSecurityGroups";
const _VSGI = "VpcSecurityGroupIds";
const _VSGIp = "VpcSecurityGroupId";
const _VSGM = "VpcSecurityGroupMemberships";
const _VSGMp = "VpcSecurityGroupMembership";
const _VSI = "VpcSubnetIds";
const _VSO = "ValidStorageOptions";
const _VT = "ValidTill";
const _VTA = "ValuesToAdd";
const _VTR = "ValuesToRemove";
const _VUT = "ValidUpgradeTarget";
const _Va = "Values";
const _Val = "Value";
const _Vp = "Vpc";
const _WM = "WarningMessage";
const _e = "entry";
const _m = "message";
const _me = "member";
const buildFormUrlencodedString = (formEntries) => Object.entries(formEntries)
    .map(([key, value]) => __extendedEncodeURIComponent(key) + "=" + __extendedEncodeURIComponent(value))
    .join("&");
const loadQueryErrorCode = (output, data) => {
    if (data.Error?.Code !== undefined) {
        return data.Error.Code;
    }
    if (output.statusCode == 404) {
        return "NotFound";
    }
};
