import { SENSITIVE_STRING } from "@smithy/smithy-client";
import { TenantDatabaseFilterSensitiveLog, } from "./models_0";
import { RDSServiceException as __BaseException } from "./RDSServiceException";
export class InvalidOptionGroupStateFault extends __BaseException {
    name = "InvalidOptionGroupStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidOptionGroupStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidOptionGroupStateFault.prototype);
    }
}
export class DBProxyTargetNotFoundFault extends __BaseException {
    name = "DBProxyTargetNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBProxyTargetNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBProxyTargetNotFoundFault.prototype);
    }
}
export class DBClusterBacktrackNotFoundFault extends __BaseException {
    name = "DBClusterBacktrackNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBClusterBacktrackNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBClusterBacktrackNotFoundFault.prototype);
    }
}
export const ApplyMethod = {
    immediate: "immediate",
    pending_reboot: "pending-reboot",
};
export class DBInstanceNotReadyFault extends __BaseException {
    name = "DBInstanceNotReadyFault";
    $fault = "server";
    constructor(opts) {
        super({
            name: "DBInstanceNotReadyFault",
            $fault: "server",
            ...opts,
        });
        Object.setPrototypeOf(this, DBInstanceNotReadyFault.prototype);
    }
}
export const LifecycleSupportName = {
    OPEN_SOURCE_RDS_EXTENDED_SUPPORT: "open-source-rds-extended-support",
    OPEN_SOURCE_RDS_STANDARD_SUPPORT: "open-source-rds-standard-support",
};
export const TargetRole = {
    READ_ONLY: "READ_ONLY",
    READ_WRITE: "READ_WRITE",
    UNKNOWN: "UNKNOWN",
};
export const TargetHealthReason = {
    AUTH_FAILURE: "AUTH_FAILURE",
    CONNECTION_FAILED: "CONNECTION_FAILED",
    INVALID_REPLICATION_STATE: "INVALID_REPLICATION_STATE",
    PENDING_PROXY_CAPACITY: "PENDING_PROXY_CAPACITY",
    UNREACHABLE: "UNREACHABLE",
};
export const TargetState = {
    available: "AVAILABLE",
    registering: "REGISTERING",
    unavailable: "UNAVAILABLE",
};
export const TargetType = {
    RDS_INSTANCE: "RDS_INSTANCE",
    RDS_SERVERLESS_ENDPOINT: "RDS_SERVERLESS_ENDPOINT",
    TRACKED_CLUSTER: "TRACKED_CLUSTER",
};
export const SourceType = {
    blue_green_deployment: "blue-green-deployment",
    custom_engine_version: "custom-engine-version",
    db_cluster: "db-cluster",
    db_cluster_snapshot: "db-cluster-snapshot",
    db_instance: "db-instance",
    db_parameter_group: "db-parameter-group",
    db_proxy: "db-proxy",
    db_security_group: "db-security-group",
    db_snapshot: "db-snapshot",
};
export class ReservedDBInstanceNotFoundFault extends __BaseException {
    name = "ReservedDBInstanceNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ReservedDBInstanceNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ReservedDBInstanceNotFoundFault.prototype);
    }
}
export class ReservedDBInstancesOfferingNotFoundFault extends __BaseException {
    name = "ReservedDBInstancesOfferingNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ReservedDBInstancesOfferingNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ReservedDBInstancesOfferingNotFoundFault.prototype);
    }
}
export class InvalidResourceStateFault extends __BaseException {
    name = "InvalidResourceStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidResourceStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidResourceStateFault.prototype);
    }
}
export class DBLogFileNotFoundFault extends __BaseException {
    name = "DBLogFileNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBLogFileNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBLogFileNotFoundFault.prototype);
    }
}
export const AuditPolicyState = {
    LOCKED_POLICY: "locked",
    UNLOCKED_POLICY: "unlocked",
};
export class InvalidDBClusterCapacityFault extends __BaseException {
    name = "InvalidDBClusterCapacityFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidDBClusterCapacityFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidDBClusterCapacityFault.prototype);
    }
}
export const CustomEngineVersionStatus = {
    available: "available",
    inactive: "inactive",
    inactive_except_restore: "inactive-except-restore",
};
export class StorageTypeNotAvailableFault extends __BaseException {
    name = "StorageTypeNotAvailableFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "StorageTypeNotAvailableFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, StorageTypeNotAvailableFault.prototype);
    }
}
export class SharedSnapshotQuotaExceededFault extends __BaseException {
    name = "SharedSnapshotQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "SharedSnapshotQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, SharedSnapshotQuotaExceededFault.prototype);
    }
}
export class DBUpgradeDependencyFailureFault extends __BaseException {
    name = "DBUpgradeDependencyFailureFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBUpgradeDependencyFailureFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBUpgradeDependencyFailureFault.prototype);
    }
}
export class SubnetAlreadyInUse extends __BaseException {
    name = "SubnetAlreadyInUse";
    $fault = "client";
    constructor(opts) {
        super({
            name: "SubnetAlreadyInUse",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, SubnetAlreadyInUse.prototype);
    }
}
export class ReservedDBInstanceAlreadyExistsFault extends __BaseException {
    name = "ReservedDBInstanceAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ReservedDBInstanceAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ReservedDBInstanceAlreadyExistsFault.prototype);
    }
}
export class ReservedDBInstanceQuotaExceededFault extends __BaseException {
    name = "ReservedDBInstanceQuotaExceededFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ReservedDBInstanceQuotaExceededFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ReservedDBInstanceQuotaExceededFault.prototype);
    }
}
export class DBProxyTargetAlreadyRegisteredFault extends __BaseException {
    name = "DBProxyTargetAlreadyRegisteredFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBProxyTargetAlreadyRegisteredFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBProxyTargetAlreadyRegisteredFault.prototype);
    }
}
export class InsufficientAvailableIPsInSubnetFault extends __BaseException {
    name = "InsufficientAvailableIPsInSubnetFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InsufficientAvailableIPsInSubnetFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InsufficientAvailableIPsInSubnetFault.prototype);
    }
}
export class DBClusterRoleNotFoundFault extends __BaseException {
    name = "DBClusterRoleNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBClusterRoleNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBClusterRoleNotFoundFault.prototype);
    }
}
export class DBInstanceRoleNotFoundFault extends __BaseException {
    name = "DBInstanceRoleNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "DBInstanceRoleNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, DBInstanceRoleNotFoundFault.prototype);
    }
}
export class InvalidS3BucketFault extends __BaseException {
    name = "InvalidS3BucketFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidS3BucketFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidS3BucketFault.prototype);
    }
}
export class InsufficientDBClusterCapacityFault extends __BaseException {
    name = "InsufficientDBClusterCapacityFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InsufficientDBClusterCapacityFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InsufficientDBClusterCapacityFault.prototype);
    }
}
export class InvalidRestoreFault extends __BaseException {
    name = "InvalidRestoreFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidRestoreFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidRestoreFault.prototype);
    }
}
export class PointInTimeRestoreNotEnabledFault extends __BaseException {
    name = "PointInTimeRestoreNotEnabledFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "PointInTimeRestoreNotEnabledFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, PointInTimeRestoreNotEnabledFault.prototype);
    }
}
export class ExportTaskAlreadyExistsFault extends __BaseException {
    name = "ExportTaskAlreadyExistsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "ExportTaskAlreadyExistsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ExportTaskAlreadyExistsFault.prototype);
    }
}
export class IamRoleMissingPermissionsFault extends __BaseException {
    name = "IamRoleMissingPermissionsFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "IamRoleMissingPermissionsFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, IamRoleMissingPermissionsFault.prototype);
    }
}
export class IamRoleNotFoundFault extends __BaseException {
    name = "IamRoleNotFoundFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "IamRoleNotFoundFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, IamRoleNotFoundFault.prototype);
    }
}
export class InvalidExportOnlyFault extends __BaseException {
    name = "InvalidExportOnlyFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidExportOnlyFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidExportOnlyFault.prototype);
    }
}
export class InvalidExportSourceStateFault extends __BaseException {
    name = "InvalidExportSourceStateFault";
    $fault = "client";
    constructor(opts) {
        super({
            name: "InvalidExportSourceStateFault",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidExportSourceStateFault.prototype);
    }
}
export const DeleteTenantDatabaseResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TenantDatabase && { TenantDatabase: TenantDatabaseFilterSensitiveLog(obj.TenantDatabase) }),
});
export const TenantDatabasesMessageFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TenantDatabases && {
        TenantDatabases: obj.TenantDatabases.map((item) => TenantDatabaseFilterSensitiveLog(item)),
    }),
});
export const ModifyTenantDatabaseMessageFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.MasterUserPassword && { MasterUserPassword: SENSITIVE_STRING }),
});
export const ModifyTenantDatabaseResultFilterSensitiveLog = (obj) => ({
    ...obj,
    ...(obj.TenantDatabase && { TenantDatabase: TenantDatabaseFilterSensitiveLog(obj.TenantDatabase) }),
});
