"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  ActivityStreamMode: () => ActivityStreamMode,
  ActivityStreamPolicyStatus: () => ActivityStreamPolicyStatus,
  ActivityStreamStatus: () => ActivityStreamStatus,
  AddRoleToDBClusterCommand: () => AddRoleToDBClusterCommand,
  AddRoleToDBInstanceCommand: () => AddRoleToDBInstanceCommand,
  AddSourceIdentifierToSubscriptionCommand: () => AddSourceIdentifierToSubscriptionCommand,
  AddTagsToResourceCommand: () => AddTagsToResourceCommand,
  ApplyMethod: () => ApplyMethod,
  ApplyPendingMaintenanceActionCommand: () => ApplyPendingMaintenanceActionCommand,
  AuditPolicyState: () => AuditPolicyState,
  AuthScheme: () => AuthScheme,
  AuthorizationAlreadyExistsFault: () => AuthorizationAlreadyExistsFault,
  AuthorizationNotFoundFault: () => AuthorizationNotFoundFault,
  AuthorizationQuotaExceededFault: () => AuthorizationQuotaExceededFault,
  AuthorizeDBSecurityGroupIngressCommand: () => AuthorizeDBSecurityGroupIngressCommand,
  AutomationMode: () => AutomationMode,
  BacktrackDBClusterCommand: () => BacktrackDBClusterCommand,
  BackupPolicyNotFoundFault: () => BackupPolicyNotFoundFault,
  BlueGreenDeploymentAlreadyExistsFault: () => BlueGreenDeploymentAlreadyExistsFault,
  BlueGreenDeploymentNotFoundFault: () => BlueGreenDeploymentNotFoundFault,
  CancelExportTaskCommand: () => CancelExportTaskCommand,
  CertificateNotFoundFault: () => CertificateNotFoundFault,
  ClientPasswordAuthType: () => ClientPasswordAuthType,
  ClusterScalabilityType: () => ClusterScalabilityType,
  CopyDBClusterParameterGroupCommand: () => CopyDBClusterParameterGroupCommand,
  CopyDBClusterSnapshotCommand: () => CopyDBClusterSnapshotCommand,
  CopyDBParameterGroupCommand: () => CopyDBParameterGroupCommand,
  CopyDBSnapshotCommand: () => CopyDBSnapshotCommand,
  CopyOptionGroupCommand: () => CopyOptionGroupCommand,
  CreateBlueGreenDeploymentCommand: () => CreateBlueGreenDeploymentCommand,
  CreateCustomDBEngineVersionCommand: () => CreateCustomDBEngineVersionCommand,
  CreateCustomDBEngineVersionFault: () => CreateCustomDBEngineVersionFault,
  CreateDBClusterCommand: () => CreateDBClusterCommand,
  CreateDBClusterEndpointCommand: () => CreateDBClusterEndpointCommand,
  CreateDBClusterParameterGroupCommand: () => CreateDBClusterParameterGroupCommand,
  CreateDBClusterSnapshotCommand: () => CreateDBClusterSnapshotCommand,
  CreateDBInstanceCommand: () => CreateDBInstanceCommand,
  CreateDBInstanceReadReplicaCommand: () => CreateDBInstanceReadReplicaCommand,
  CreateDBParameterGroupCommand: () => CreateDBParameterGroupCommand,
  CreateDBProxyCommand: () => CreateDBProxyCommand,
  CreateDBProxyEndpointCommand: () => CreateDBProxyEndpointCommand,
  CreateDBSecurityGroupCommand: () => CreateDBSecurityGroupCommand,
  CreateDBShardGroupCommand: () => CreateDBShardGroupCommand,
  CreateDBSnapshotCommand: () => CreateDBSnapshotCommand,
  CreateDBSubnetGroupCommand: () => CreateDBSubnetGroupCommand,
  CreateEventSubscriptionCommand: () => CreateEventSubscriptionCommand,
  CreateGlobalClusterCommand: () => CreateGlobalClusterCommand,
  CreateIntegrationCommand: () => CreateIntegrationCommand,
  CreateOptionGroupCommand: () => CreateOptionGroupCommand,
  CreateTenantDatabaseCommand: () => CreateTenantDatabaseCommand,
  CreateTenantDatabaseMessageFilterSensitiveLog: () => CreateTenantDatabaseMessageFilterSensitiveLog,
  CreateTenantDatabaseResultFilterSensitiveLog: () => CreateTenantDatabaseResultFilterSensitiveLog,
  CustomAvailabilityZoneNotFoundFault: () => CustomAvailabilityZoneNotFoundFault,
  CustomDBEngineVersionAlreadyExistsFault: () => CustomDBEngineVersionAlreadyExistsFault,
  CustomDBEngineVersionNotFoundFault: () => CustomDBEngineVersionNotFoundFault,
  CustomDBEngineVersionQuotaExceededFault: () => CustomDBEngineVersionQuotaExceededFault,
  CustomEngineVersionStatus: () => CustomEngineVersionStatus,
  DBClusterAlreadyExistsFault: () => DBClusterAlreadyExistsFault,
  DBClusterAutomatedBackupNotFoundFault: () => DBClusterAutomatedBackupNotFoundFault,
  DBClusterAutomatedBackupQuotaExceededFault: () => DBClusterAutomatedBackupQuotaExceededFault,
  DBClusterBacktrackNotFoundFault: () => DBClusterBacktrackNotFoundFault,
  DBClusterEndpointAlreadyExistsFault: () => DBClusterEndpointAlreadyExistsFault,
  DBClusterEndpointNotFoundFault: () => DBClusterEndpointNotFoundFault,
  DBClusterEndpointQuotaExceededFault: () => DBClusterEndpointQuotaExceededFault,
  DBClusterNotFoundFault: () => DBClusterNotFoundFault,
  DBClusterParameterGroupNotFoundFault: () => DBClusterParameterGroupNotFoundFault,
  DBClusterQuotaExceededFault: () => DBClusterQuotaExceededFault,
  DBClusterRoleAlreadyExistsFault: () => DBClusterRoleAlreadyExistsFault,
  DBClusterRoleNotFoundFault: () => DBClusterRoleNotFoundFault,
  DBClusterRoleQuotaExceededFault: () => DBClusterRoleQuotaExceededFault,
  DBClusterSnapshotAlreadyExistsFault: () => DBClusterSnapshotAlreadyExistsFault,
  DBClusterSnapshotNotFoundFault: () => DBClusterSnapshotNotFoundFault,
  DBInstanceAlreadyExistsFault: () => DBInstanceAlreadyExistsFault,
  DBInstanceAutomatedBackupNotFoundFault: () => DBInstanceAutomatedBackupNotFoundFault,
  DBInstanceAutomatedBackupQuotaExceededFault: () => DBInstanceAutomatedBackupQuotaExceededFault,
  DBInstanceNotFoundFault: () => DBInstanceNotFoundFault,
  DBInstanceNotReadyFault: () => DBInstanceNotReadyFault,
  DBInstanceRoleAlreadyExistsFault: () => DBInstanceRoleAlreadyExistsFault,
  DBInstanceRoleNotFoundFault: () => DBInstanceRoleNotFoundFault,
  DBInstanceRoleQuotaExceededFault: () => DBInstanceRoleQuotaExceededFault,
  DBLogFileNotFoundFault: () => DBLogFileNotFoundFault,
  DBParameterGroupAlreadyExistsFault: () => DBParameterGroupAlreadyExistsFault,
  DBParameterGroupNotFoundFault: () => DBParameterGroupNotFoundFault,
  DBParameterGroupQuotaExceededFault: () => DBParameterGroupQuotaExceededFault,
  DBProxyAlreadyExistsFault: () => DBProxyAlreadyExistsFault,
  DBProxyEndpointAlreadyExistsFault: () => DBProxyEndpointAlreadyExistsFault,
  DBProxyEndpointNotFoundFault: () => DBProxyEndpointNotFoundFault,
  DBProxyEndpointQuotaExceededFault: () => DBProxyEndpointQuotaExceededFault,
  DBProxyEndpointStatus: () => DBProxyEndpointStatus,
  DBProxyEndpointTargetRole: () => DBProxyEndpointTargetRole,
  DBProxyNotFoundFault: () => DBProxyNotFoundFault,
  DBProxyQuotaExceededFault: () => DBProxyQuotaExceededFault,
  DBProxyStatus: () => DBProxyStatus,
  DBProxyTargetAlreadyRegisteredFault: () => DBProxyTargetAlreadyRegisteredFault,
  DBProxyTargetGroupNotFoundFault: () => DBProxyTargetGroupNotFoundFault,
  DBProxyTargetNotFoundFault: () => DBProxyTargetNotFoundFault,
  DBSecurityGroupAlreadyExistsFault: () => DBSecurityGroupAlreadyExistsFault,
  DBSecurityGroupNotFoundFault: () => DBSecurityGroupNotFoundFault,
  DBSecurityGroupNotSupportedFault: () => DBSecurityGroupNotSupportedFault,
  DBSecurityGroupQuotaExceededFault: () => DBSecurityGroupQuotaExceededFault,
  DBShardGroupAlreadyExistsFault: () => DBShardGroupAlreadyExistsFault,
  DBShardGroupNotFoundFault: () => DBShardGroupNotFoundFault,
  DBSnapshotAlreadyExistsFault: () => DBSnapshotAlreadyExistsFault,
  DBSnapshotNotFoundFault: () => DBSnapshotNotFoundFault,
  DBSnapshotTenantDatabaseNotFoundFault: () => DBSnapshotTenantDatabaseNotFoundFault,
  DBSubnetGroupAlreadyExistsFault: () => DBSubnetGroupAlreadyExistsFault,
  DBSubnetGroupDoesNotCoverEnoughAZs: () => DBSubnetGroupDoesNotCoverEnoughAZs,
  DBSubnetGroupNotAllowedFault: () => DBSubnetGroupNotAllowedFault,
  DBSubnetGroupNotFoundFault: () => DBSubnetGroupNotFoundFault,
  DBSubnetGroupQuotaExceededFault: () => DBSubnetGroupQuotaExceededFault,
  DBSubnetQuotaExceededFault: () => DBSubnetQuotaExceededFault,
  DBUpgradeDependencyFailureFault: () => DBUpgradeDependencyFailureFault,
  DatabaseInsightsMode: () => DatabaseInsightsMode,
  DeleteBlueGreenDeploymentCommand: () => DeleteBlueGreenDeploymentCommand,
  DeleteCustomDBEngineVersionCommand: () => DeleteCustomDBEngineVersionCommand,
  DeleteDBClusterAutomatedBackupCommand: () => DeleteDBClusterAutomatedBackupCommand,
  DeleteDBClusterCommand: () => DeleteDBClusterCommand,
  DeleteDBClusterEndpointCommand: () => DeleteDBClusterEndpointCommand,
  DeleteDBClusterParameterGroupCommand: () => DeleteDBClusterParameterGroupCommand,
  DeleteDBClusterSnapshotCommand: () => DeleteDBClusterSnapshotCommand,
  DeleteDBInstanceAutomatedBackupCommand: () => DeleteDBInstanceAutomatedBackupCommand,
  DeleteDBInstanceCommand: () => DeleteDBInstanceCommand,
  DeleteDBParameterGroupCommand: () => DeleteDBParameterGroupCommand,
  DeleteDBProxyCommand: () => DeleteDBProxyCommand,
  DeleteDBProxyEndpointCommand: () => DeleteDBProxyEndpointCommand,
  DeleteDBSecurityGroupCommand: () => DeleteDBSecurityGroupCommand,
  DeleteDBShardGroupCommand: () => DeleteDBShardGroupCommand,
  DeleteDBSnapshotCommand: () => DeleteDBSnapshotCommand,
  DeleteDBSubnetGroupCommand: () => DeleteDBSubnetGroupCommand,
  DeleteEventSubscriptionCommand: () => DeleteEventSubscriptionCommand,
  DeleteGlobalClusterCommand: () => DeleteGlobalClusterCommand,
  DeleteIntegrationCommand: () => DeleteIntegrationCommand,
  DeleteOptionGroupCommand: () => DeleteOptionGroupCommand,
  DeleteTenantDatabaseCommand: () => DeleteTenantDatabaseCommand,
  DeleteTenantDatabaseResultFilterSensitiveLog: () => DeleteTenantDatabaseResultFilterSensitiveLog,
  DeregisterDBProxyTargetsCommand: () => DeregisterDBProxyTargetsCommand,
  DescribeAccountAttributesCommand: () => DescribeAccountAttributesCommand,
  DescribeBlueGreenDeploymentsCommand: () => DescribeBlueGreenDeploymentsCommand,
  DescribeCertificatesCommand: () => DescribeCertificatesCommand,
  DescribeDBClusterAutomatedBackupsCommand: () => DescribeDBClusterAutomatedBackupsCommand,
  DescribeDBClusterBacktracksCommand: () => DescribeDBClusterBacktracksCommand,
  DescribeDBClusterEndpointsCommand: () => DescribeDBClusterEndpointsCommand,
  DescribeDBClusterParameterGroupsCommand: () => DescribeDBClusterParameterGroupsCommand,
  DescribeDBClusterParametersCommand: () => DescribeDBClusterParametersCommand,
  DescribeDBClusterSnapshotAttributesCommand: () => DescribeDBClusterSnapshotAttributesCommand,
  DescribeDBClusterSnapshotsCommand: () => DescribeDBClusterSnapshotsCommand,
  DescribeDBClustersCommand: () => DescribeDBClustersCommand,
  DescribeDBEngineVersionsCommand: () => DescribeDBEngineVersionsCommand,
  DescribeDBInstanceAutomatedBackupsCommand: () => DescribeDBInstanceAutomatedBackupsCommand,
  DescribeDBInstancesCommand: () => DescribeDBInstancesCommand,
  DescribeDBLogFilesCommand: () => DescribeDBLogFilesCommand,
  DescribeDBMajorEngineVersionsCommand: () => DescribeDBMajorEngineVersionsCommand,
  DescribeDBParameterGroupsCommand: () => DescribeDBParameterGroupsCommand,
  DescribeDBParametersCommand: () => DescribeDBParametersCommand,
  DescribeDBProxiesCommand: () => DescribeDBProxiesCommand,
  DescribeDBProxyEndpointsCommand: () => DescribeDBProxyEndpointsCommand,
  DescribeDBProxyTargetGroupsCommand: () => DescribeDBProxyTargetGroupsCommand,
  DescribeDBProxyTargetsCommand: () => DescribeDBProxyTargetsCommand,
  DescribeDBRecommendationsCommand: () => DescribeDBRecommendationsCommand,
  DescribeDBSecurityGroupsCommand: () => DescribeDBSecurityGroupsCommand,
  DescribeDBShardGroupsCommand: () => DescribeDBShardGroupsCommand,
  DescribeDBSnapshotAttributesCommand: () => DescribeDBSnapshotAttributesCommand,
  DescribeDBSnapshotTenantDatabasesCommand: () => DescribeDBSnapshotTenantDatabasesCommand,
  DescribeDBSnapshotsCommand: () => DescribeDBSnapshotsCommand,
  DescribeDBSubnetGroupsCommand: () => DescribeDBSubnetGroupsCommand,
  DescribeEngineDefaultClusterParametersCommand: () => DescribeEngineDefaultClusterParametersCommand,
  DescribeEngineDefaultParametersCommand: () => DescribeEngineDefaultParametersCommand,
  DescribeEventCategoriesCommand: () => DescribeEventCategoriesCommand,
  DescribeEventSubscriptionsCommand: () => DescribeEventSubscriptionsCommand,
  DescribeEventsCommand: () => DescribeEventsCommand,
  DescribeExportTasksCommand: () => DescribeExportTasksCommand,
  DescribeGlobalClustersCommand: () => DescribeGlobalClustersCommand,
  DescribeIntegrationsCommand: () => DescribeIntegrationsCommand,
  DescribeOptionGroupOptionsCommand: () => DescribeOptionGroupOptionsCommand,
  DescribeOptionGroupsCommand: () => DescribeOptionGroupsCommand,
  DescribeOrderableDBInstanceOptionsCommand: () => DescribeOrderableDBInstanceOptionsCommand,
  DescribePendingMaintenanceActionsCommand: () => DescribePendingMaintenanceActionsCommand,
  DescribeReservedDBInstancesCommand: () => DescribeReservedDBInstancesCommand,
  DescribeReservedDBInstancesOfferingsCommand: () => DescribeReservedDBInstancesOfferingsCommand,
  DescribeSourceRegionsCommand: () => DescribeSourceRegionsCommand,
  DescribeTenantDatabasesCommand: () => DescribeTenantDatabasesCommand,
  DescribeValidDBInstanceModificationsCommand: () => DescribeValidDBInstanceModificationsCommand,
  DisableHttpEndpointCommand: () => DisableHttpEndpointCommand,
  DomainNotFoundFault: () => DomainNotFoundFault,
  DownloadDBLogFilePortionCommand: () => DownloadDBLogFilePortionCommand,
  Ec2ImagePropertiesNotSupportedFault: () => Ec2ImagePropertiesNotSupportedFault,
  EnableHttpEndpointCommand: () => EnableHttpEndpointCommand,
  EngineFamily: () => EngineFamily,
  EventSubscriptionQuotaExceededFault: () => EventSubscriptionQuotaExceededFault,
  ExportSourceType: () => ExportSourceType,
  ExportTaskAlreadyExistsFault: () => ExportTaskAlreadyExistsFault,
  ExportTaskNotFoundFault: () => ExportTaskNotFoundFault,
  FailoverDBClusterCommand: () => FailoverDBClusterCommand,
  FailoverGlobalClusterCommand: () => FailoverGlobalClusterCommand,
  FailoverStatus: () => FailoverStatus,
  GlobalClusterAlreadyExistsFault: () => GlobalClusterAlreadyExistsFault,
  GlobalClusterMemberSynchronizationStatus: () => GlobalClusterMemberSynchronizationStatus,
  GlobalClusterNotFoundFault: () => GlobalClusterNotFoundFault,
  GlobalClusterQuotaExceededFault: () => GlobalClusterQuotaExceededFault,
  IAMAuthMode: () => IAMAuthMode,
  IamRoleMissingPermissionsFault: () => IamRoleMissingPermissionsFault,
  IamRoleNotFoundFault: () => IamRoleNotFoundFault,
  InstanceQuotaExceededFault: () => InstanceQuotaExceededFault,
  InsufficientAvailableIPsInSubnetFault: () => InsufficientAvailableIPsInSubnetFault,
  InsufficientDBClusterCapacityFault: () => InsufficientDBClusterCapacityFault,
  InsufficientDBInstanceCapacityFault: () => InsufficientDBInstanceCapacityFault,
  InsufficientStorageClusterCapacityFault: () => InsufficientStorageClusterCapacityFault,
  IntegrationAlreadyExistsFault: () => IntegrationAlreadyExistsFault,
  IntegrationConflictOperationFault: () => IntegrationConflictOperationFault,
  IntegrationNotFoundFault: () => IntegrationNotFoundFault,
  IntegrationQuotaExceededFault: () => IntegrationQuotaExceededFault,
  IntegrationStatus: () => IntegrationStatus,
  InvalidBlueGreenDeploymentStateFault: () => InvalidBlueGreenDeploymentStateFault,
  InvalidCustomDBEngineVersionStateFault: () => InvalidCustomDBEngineVersionStateFault,
  InvalidDBClusterAutomatedBackupStateFault: () => InvalidDBClusterAutomatedBackupStateFault,
  InvalidDBClusterCapacityFault: () => InvalidDBClusterCapacityFault,
  InvalidDBClusterEndpointStateFault: () => InvalidDBClusterEndpointStateFault,
  InvalidDBClusterSnapshotStateFault: () => InvalidDBClusterSnapshotStateFault,
  InvalidDBClusterStateFault: () => InvalidDBClusterStateFault,
  InvalidDBInstanceAutomatedBackupStateFault: () => InvalidDBInstanceAutomatedBackupStateFault,
  InvalidDBInstanceStateFault: () => InvalidDBInstanceStateFault,
  InvalidDBParameterGroupStateFault: () => InvalidDBParameterGroupStateFault,
  InvalidDBProxyEndpointStateFault: () => InvalidDBProxyEndpointStateFault,
  InvalidDBProxyStateFault: () => InvalidDBProxyStateFault,
  InvalidDBSecurityGroupStateFault: () => InvalidDBSecurityGroupStateFault,
  InvalidDBShardGroupStateFault: () => InvalidDBShardGroupStateFault,
  InvalidDBSnapshotStateFault: () => InvalidDBSnapshotStateFault,
  InvalidDBSubnetGroupFault: () => InvalidDBSubnetGroupFault,
  InvalidDBSubnetGroupStateFault: () => InvalidDBSubnetGroupStateFault,
  InvalidDBSubnetStateFault: () => InvalidDBSubnetStateFault,
  InvalidEventSubscriptionStateFault: () => InvalidEventSubscriptionStateFault,
  InvalidExportOnlyFault: () => InvalidExportOnlyFault,
  InvalidExportSourceStateFault: () => InvalidExportSourceStateFault,
  InvalidExportTaskStateFault: () => InvalidExportTaskStateFault,
  InvalidGlobalClusterStateFault: () => InvalidGlobalClusterStateFault,
  InvalidIntegrationStateFault: () => InvalidIntegrationStateFault,
  InvalidOptionGroupStateFault: () => InvalidOptionGroupStateFault,
  InvalidResourceStateFault: () => InvalidResourceStateFault,
  InvalidRestoreFault: () => InvalidRestoreFault,
  InvalidS3BucketFault: () => InvalidS3BucketFault,
  InvalidSubnet: () => InvalidSubnet,
  InvalidVPCNetworkStateFault: () => InvalidVPCNetworkStateFault,
  KMSKeyNotAccessibleFault: () => KMSKeyNotAccessibleFault,
  LifecycleSupportName: () => LifecycleSupportName,
  LimitlessDatabaseStatus: () => LimitlessDatabaseStatus,
  ListTagsForResourceCommand: () => ListTagsForResourceCommand,
  LocalWriteForwardingStatus: () => LocalWriteForwardingStatus,
  MaxDBShardGroupLimitReached: () => MaxDBShardGroupLimitReached,
  ModifyActivityStreamCommand: () => ModifyActivityStreamCommand,
  ModifyCertificatesCommand: () => ModifyCertificatesCommand,
  ModifyCurrentDBClusterCapacityCommand: () => ModifyCurrentDBClusterCapacityCommand,
  ModifyCustomDBEngineVersionCommand: () => ModifyCustomDBEngineVersionCommand,
  ModifyDBClusterCommand: () => ModifyDBClusterCommand,
  ModifyDBClusterEndpointCommand: () => ModifyDBClusterEndpointCommand,
  ModifyDBClusterParameterGroupCommand: () => ModifyDBClusterParameterGroupCommand,
  ModifyDBClusterSnapshotAttributeCommand: () => ModifyDBClusterSnapshotAttributeCommand,
  ModifyDBInstanceCommand: () => ModifyDBInstanceCommand,
  ModifyDBParameterGroupCommand: () => ModifyDBParameterGroupCommand,
  ModifyDBProxyCommand: () => ModifyDBProxyCommand,
  ModifyDBProxyEndpointCommand: () => ModifyDBProxyEndpointCommand,
  ModifyDBProxyTargetGroupCommand: () => ModifyDBProxyTargetGroupCommand,
  ModifyDBRecommendationCommand: () => ModifyDBRecommendationCommand,
  ModifyDBShardGroupCommand: () => ModifyDBShardGroupCommand,
  ModifyDBSnapshotAttributeCommand: () => ModifyDBSnapshotAttributeCommand,
  ModifyDBSnapshotCommand: () => ModifyDBSnapshotCommand,
  ModifyDBSubnetGroupCommand: () => ModifyDBSubnetGroupCommand,
  ModifyEventSubscriptionCommand: () => ModifyEventSubscriptionCommand,
  ModifyGlobalClusterCommand: () => ModifyGlobalClusterCommand,
  ModifyIntegrationCommand: () => ModifyIntegrationCommand,
  ModifyOptionGroupCommand: () => ModifyOptionGroupCommand,
  ModifyTenantDatabaseCommand: () => ModifyTenantDatabaseCommand,
  ModifyTenantDatabaseMessageFilterSensitiveLog: () => ModifyTenantDatabaseMessageFilterSensitiveLog,
  ModifyTenantDatabaseResultFilterSensitiveLog: () => ModifyTenantDatabaseResultFilterSensitiveLog,
  NetworkTypeNotSupported: () => NetworkTypeNotSupported,
  OptionGroupAlreadyExistsFault: () => OptionGroupAlreadyExistsFault,
  OptionGroupNotFoundFault: () => OptionGroupNotFoundFault,
  OptionGroupQuotaExceededFault: () => OptionGroupQuotaExceededFault,
  PointInTimeRestoreNotEnabledFault: () => PointInTimeRestoreNotEnabledFault,
  PromoteReadReplicaCommand: () => PromoteReadReplicaCommand,
  PromoteReadReplicaDBClusterCommand: () => PromoteReadReplicaDBClusterCommand,
  ProvisionedIopsNotAvailableInAZFault: () => ProvisionedIopsNotAvailableInAZFault,
  PurchaseReservedDBInstancesOfferingCommand: () => PurchaseReservedDBInstancesOfferingCommand,
  RDS: () => RDS,
  RDSClient: () => RDSClient,
  RDSServiceException: () => RDSServiceException,
  RebootDBClusterCommand: () => RebootDBClusterCommand,
  RebootDBInstanceCommand: () => RebootDBInstanceCommand,
  RebootDBShardGroupCommand: () => RebootDBShardGroupCommand,
  RegisterDBProxyTargetsCommand: () => RegisterDBProxyTargetsCommand,
  RemoveFromGlobalClusterCommand: () => RemoveFromGlobalClusterCommand,
  RemoveRoleFromDBClusterCommand: () => RemoveRoleFromDBClusterCommand,
  RemoveRoleFromDBInstanceCommand: () => RemoveRoleFromDBInstanceCommand,
  RemoveSourceIdentifierFromSubscriptionCommand: () => RemoveSourceIdentifierFromSubscriptionCommand,
  RemoveTagsFromResourceCommand: () => RemoveTagsFromResourceCommand,
  ReplicaMode: () => ReplicaMode,
  ReservedDBInstanceAlreadyExistsFault: () => ReservedDBInstanceAlreadyExistsFault,
  ReservedDBInstanceNotFoundFault: () => ReservedDBInstanceNotFoundFault,
  ReservedDBInstanceQuotaExceededFault: () => ReservedDBInstanceQuotaExceededFault,
  ReservedDBInstancesOfferingNotFoundFault: () => ReservedDBInstancesOfferingNotFoundFault,
  ResetDBClusterParameterGroupCommand: () => ResetDBClusterParameterGroupCommand,
  ResetDBParameterGroupCommand: () => ResetDBParameterGroupCommand,
  ResourceNotFoundFault: () => ResourceNotFoundFault,
  RestoreDBClusterFromS3Command: () => RestoreDBClusterFromS3Command,
  RestoreDBClusterFromSnapshotCommand: () => RestoreDBClusterFromSnapshotCommand,
  RestoreDBClusterToPointInTimeCommand: () => RestoreDBClusterToPointInTimeCommand,
  RestoreDBInstanceFromDBSnapshotCommand: () => RestoreDBInstanceFromDBSnapshotCommand,
  RestoreDBInstanceFromS3Command: () => RestoreDBInstanceFromS3Command,
  RestoreDBInstanceToPointInTimeCommand: () => RestoreDBInstanceToPointInTimeCommand,
  RevokeDBSecurityGroupIngressCommand: () => RevokeDBSecurityGroupIngressCommand,
  SNSInvalidTopicFault: () => SNSInvalidTopicFault,
  SNSNoAuthorizationFault: () => SNSNoAuthorizationFault,
  SNSTopicArnNotFoundFault: () => SNSTopicArnNotFoundFault,
  SharedSnapshotQuotaExceededFault: () => SharedSnapshotQuotaExceededFault,
  SnapshotQuotaExceededFault: () => SnapshotQuotaExceededFault,
  SourceClusterNotSupportedFault: () => SourceClusterNotSupportedFault,
  SourceDatabaseNotSupportedFault: () => SourceDatabaseNotSupportedFault,
  SourceNotFoundFault: () => SourceNotFoundFault,
  SourceType: () => SourceType,
  StartActivityStreamCommand: () => StartActivityStreamCommand,
  StartDBClusterCommand: () => StartDBClusterCommand,
  StartDBInstanceAutomatedBackupsReplicationCommand: () => StartDBInstanceAutomatedBackupsReplicationCommand,
  StartDBInstanceCommand: () => StartDBInstanceCommand,
  StartExportTaskCommand: () => StartExportTaskCommand,
  StopActivityStreamCommand: () => StopActivityStreamCommand,
  StopDBClusterCommand: () => StopDBClusterCommand,
  StopDBInstanceAutomatedBackupsReplicationCommand: () => StopDBInstanceAutomatedBackupsReplicationCommand,
  StopDBInstanceCommand: () => StopDBInstanceCommand,
  StorageQuotaExceededFault: () => StorageQuotaExceededFault,
  StorageTypeNotAvailableFault: () => StorageTypeNotAvailableFault,
  StorageTypeNotSupportedFault: () => StorageTypeNotSupportedFault,
  SubnetAlreadyInUse: () => SubnetAlreadyInUse,
  SubscriptionAlreadyExistFault: () => SubscriptionAlreadyExistFault,
  SubscriptionCategoryNotFoundFault: () => SubscriptionCategoryNotFoundFault,
  SubscriptionNotFoundFault: () => SubscriptionNotFoundFault,
  SwitchoverBlueGreenDeploymentCommand: () => SwitchoverBlueGreenDeploymentCommand,
  SwitchoverGlobalClusterCommand: () => SwitchoverGlobalClusterCommand,
  SwitchoverReadReplicaCommand: () => SwitchoverReadReplicaCommand,
  TargetHealthReason: () => TargetHealthReason,
  TargetRole: () => TargetRole,
  TargetState: () => TargetState,
  TargetType: () => TargetType,
  TenantDatabaseAlreadyExistsFault: () => TenantDatabaseAlreadyExistsFault,
  TenantDatabaseFilterSensitiveLog: () => TenantDatabaseFilterSensitiveLog,
  TenantDatabaseNotFoundFault: () => TenantDatabaseNotFoundFault,
  TenantDatabasePendingModifiedValuesFilterSensitiveLog: () => TenantDatabasePendingModifiedValuesFilterSensitiveLog,
  TenantDatabaseQuotaExceededFault: () => TenantDatabaseQuotaExceededFault,
  TenantDatabasesMessageFilterSensitiveLog: () => TenantDatabasesMessageFilterSensitiveLog,
  UnsupportedDBEngineVersionFault: () => UnsupportedDBEngineVersionFault,
  WriteForwardingStatus: () => WriteForwardingStatus,
  __Client: () => import_smithy_client.Client,
  paginateDescribeBlueGreenDeployments: () => paginateDescribeBlueGreenDeployments,
  paginateDescribeCertificates: () => paginateDescribeCertificates,
  paginateDescribeDBClusterAutomatedBackups: () => paginateDescribeDBClusterAutomatedBackups,
  paginateDescribeDBClusterBacktracks: () => paginateDescribeDBClusterBacktracks,
  paginateDescribeDBClusterEndpoints: () => paginateDescribeDBClusterEndpoints,
  paginateDescribeDBClusterParameterGroups: () => paginateDescribeDBClusterParameterGroups,
  paginateDescribeDBClusterParameters: () => paginateDescribeDBClusterParameters,
  paginateDescribeDBClusterSnapshots: () => paginateDescribeDBClusterSnapshots,
  paginateDescribeDBClusters: () => paginateDescribeDBClusters,
  paginateDescribeDBEngineVersions: () => paginateDescribeDBEngineVersions,
  paginateDescribeDBInstanceAutomatedBackups: () => paginateDescribeDBInstanceAutomatedBackups,
  paginateDescribeDBInstances: () => paginateDescribeDBInstances,
  paginateDescribeDBLogFiles: () => paginateDescribeDBLogFiles,
  paginateDescribeDBMajorEngineVersions: () => paginateDescribeDBMajorEngineVersions,
  paginateDescribeDBParameterGroups: () => paginateDescribeDBParameterGroups,
  paginateDescribeDBParameters: () => paginateDescribeDBParameters,
  paginateDescribeDBProxies: () => paginateDescribeDBProxies,
  paginateDescribeDBProxyEndpoints: () => paginateDescribeDBProxyEndpoints,
  paginateDescribeDBProxyTargetGroups: () => paginateDescribeDBProxyTargetGroups,
  paginateDescribeDBProxyTargets: () => paginateDescribeDBProxyTargets,
  paginateDescribeDBRecommendations: () => paginateDescribeDBRecommendations,
  paginateDescribeDBSecurityGroups: () => paginateDescribeDBSecurityGroups,
  paginateDescribeDBSnapshotTenantDatabases: () => paginateDescribeDBSnapshotTenantDatabases,
  paginateDescribeDBSnapshots: () => paginateDescribeDBSnapshots,
  paginateDescribeDBSubnetGroups: () => paginateDescribeDBSubnetGroups,
  paginateDescribeEngineDefaultParameters: () => paginateDescribeEngineDefaultParameters,
  paginateDescribeEventSubscriptions: () => paginateDescribeEventSubscriptions,
  paginateDescribeEvents: () => paginateDescribeEvents,
  paginateDescribeExportTasks: () => paginateDescribeExportTasks,
  paginateDescribeGlobalClusters: () => paginateDescribeGlobalClusters,
  paginateDescribeIntegrations: () => paginateDescribeIntegrations,
  paginateDescribeOptionGroupOptions: () => paginateDescribeOptionGroupOptions,
  paginateDescribeOptionGroups: () => paginateDescribeOptionGroups,
  paginateDescribeOrderableDBInstanceOptions: () => paginateDescribeOrderableDBInstanceOptions,
  paginateDescribePendingMaintenanceActions: () => paginateDescribePendingMaintenanceActions,
  paginateDescribeReservedDBInstances: () => paginateDescribeReservedDBInstances,
  paginateDescribeReservedDBInstancesOfferings: () => paginateDescribeReservedDBInstancesOfferings,
  paginateDescribeSourceRegions: () => paginateDescribeSourceRegions,
  paginateDescribeTenantDatabases: () => paginateDescribeTenantDatabases,
  paginateDownloadDBLogFilePortion: () => paginateDownloadDBLogFilePortion,
  waitForDBClusterAvailable: () => waitForDBClusterAvailable,
  waitForDBClusterDeleted: () => waitForDBClusterDeleted,
  waitForDBClusterSnapshotAvailable: () => waitForDBClusterSnapshotAvailable,
  waitForDBClusterSnapshotDeleted: () => waitForDBClusterSnapshotDeleted,
  waitForDBInstanceAvailable: () => waitForDBInstanceAvailable,
  waitForDBInstanceDeleted: () => waitForDBInstanceDeleted,
  waitForDBSnapshotAvailable: () => waitForDBSnapshotAvailable,
  waitForDBSnapshotDeleted: () => waitForDBSnapshotDeleted,
  waitForTenantDatabaseAvailable: () => waitForTenantDatabaseAvailable,
  waitForTenantDatabaseDeleted: () => waitForTenantDatabaseDeleted,
  waitUntilDBClusterAvailable: () => waitUntilDBClusterAvailable,
  waitUntilDBClusterDeleted: () => waitUntilDBClusterDeleted,
  waitUntilDBClusterSnapshotAvailable: () => waitUntilDBClusterSnapshotAvailable,
  waitUntilDBClusterSnapshotDeleted: () => waitUntilDBClusterSnapshotDeleted,
  waitUntilDBInstanceAvailable: () => waitUntilDBInstanceAvailable,
  waitUntilDBInstanceDeleted: () => waitUntilDBInstanceDeleted,
  waitUntilDBSnapshotAvailable: () => waitUntilDBSnapshotAvailable,
  waitUntilDBSnapshotDeleted: () => waitUntilDBSnapshotDeleted,
  waitUntilTenantDatabaseAvailable: () => waitUntilTenantDatabaseAvailable,
  waitUntilTenantDatabaseDeleted: () => waitUntilTenantDatabaseDeleted
});
module.exports = __toCommonJS(index_exports);

// src/RDSClient.ts
var import_middleware_host_header = require("@aws-sdk/middleware-host-header");
var import_middleware_logger = require("@aws-sdk/middleware-logger");
var import_middleware_recursion_detection = require("@aws-sdk/middleware-recursion-detection");
var import_middleware_user_agent = require("@aws-sdk/middleware-user-agent");
var import_config_resolver = require("@smithy/config-resolver");
var import_core = require("@smithy/core");
var import_middleware_content_length = require("@smithy/middleware-content-length");
var import_middleware_endpoint = require("@smithy/middleware-endpoint");
var import_middleware_retry = require("@smithy/middleware-retry");

var import_httpAuthSchemeProvider = require("./auth/httpAuthSchemeProvider");

// src/endpoint/EndpointParameters.ts
var resolveClientEndpointParameters = /* @__PURE__ */ __name((options) => {
  return Object.assign(options, {
    useDualstackEndpoint: options.useDualstackEndpoint ?? false,
    useFipsEndpoint: options.useFipsEndpoint ?? false,
    defaultSigningName: "rds"
  });
}, "resolveClientEndpointParameters");
var commonParams = {
  UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
  Endpoint: { type: "builtInParams", name: "endpoint" },
  Region: { type: "builtInParams", name: "region" },
  UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
};

// src/RDSClient.ts
var import_runtimeConfig = require("././runtimeConfig");

// src/runtimeExtensions.ts
var import_region_config_resolver = require("@aws-sdk/region-config-resolver");
var import_protocol_http = require("@smithy/protocol-http");
var import_smithy_client = require("@smithy/smithy-client");

// src/auth/httpAuthExtensionConfiguration.ts
var getHttpAuthExtensionConfiguration = /* @__PURE__ */ __name((runtimeConfig) => {
  const _httpAuthSchemes = runtimeConfig.httpAuthSchemes;
  let _httpAuthSchemeProvider = runtimeConfig.httpAuthSchemeProvider;
  let _credentials = runtimeConfig.credentials;
  return {
    setHttpAuthScheme(httpAuthScheme) {
      const index = _httpAuthSchemes.findIndex((scheme) => scheme.schemeId === httpAuthScheme.schemeId);
      if (index === -1) {
        _httpAuthSchemes.push(httpAuthScheme);
      } else {
        _httpAuthSchemes.splice(index, 1, httpAuthScheme);
      }
    },
    httpAuthSchemes() {
      return _httpAuthSchemes;
    },
    setHttpAuthSchemeProvider(httpAuthSchemeProvider) {
      _httpAuthSchemeProvider = httpAuthSchemeProvider;
    },
    httpAuthSchemeProvider() {
      return _httpAuthSchemeProvider;
    },
    setCredentials(credentials) {
      _credentials = credentials;
    },
    credentials() {
      return _credentials;
    }
  };
}, "getHttpAuthExtensionConfiguration");
var resolveHttpAuthRuntimeConfig = /* @__PURE__ */ __name((config) => {
  return {
    httpAuthSchemes: config.httpAuthSchemes(),
    httpAuthSchemeProvider: config.httpAuthSchemeProvider(),
    credentials: config.credentials()
  };
}, "resolveHttpAuthRuntimeConfig");

// src/runtimeExtensions.ts
var resolveRuntimeExtensions = /* @__PURE__ */ __name((runtimeConfig, extensions) => {
  const extensionConfiguration = Object.assign(
    (0, import_region_config_resolver.getAwsRegionExtensionConfiguration)(runtimeConfig),
    (0, import_smithy_client.getDefaultExtensionConfiguration)(runtimeConfig),
    (0, import_protocol_http.getHttpHandlerExtensionConfiguration)(runtimeConfig),
    getHttpAuthExtensionConfiguration(runtimeConfig)
  );
  extensions.forEach((extension) => extension.configure(extensionConfiguration));
  return Object.assign(
    runtimeConfig,
    (0, import_region_config_resolver.resolveAwsRegionExtensionConfiguration)(extensionConfiguration),
    (0, import_smithy_client.resolveDefaultRuntimeConfig)(extensionConfiguration),
    (0, import_protocol_http.resolveHttpHandlerRuntimeConfig)(extensionConfiguration),
    resolveHttpAuthRuntimeConfig(extensionConfiguration)
  );
}, "resolveRuntimeExtensions");

// src/RDSClient.ts
var RDSClient = class extends import_smithy_client.Client {
  static {
    __name(this, "RDSClient");
  }
  /**
   * The resolved configuration of RDSClient class. This is resolved and normalized from the {@link RDSClientConfig | constructor configuration interface}.
   */
  config;
  constructor(...[configuration]) {
    const _config_0 = (0, import_runtimeConfig.getRuntimeConfig)(configuration || {});
    super(_config_0);
    this.initConfig = _config_0;
    const _config_1 = resolveClientEndpointParameters(_config_0);
    const _config_2 = (0, import_middleware_user_agent.resolveUserAgentConfig)(_config_1);
    const _config_3 = (0, import_middleware_retry.resolveRetryConfig)(_config_2);
    const _config_4 = (0, import_config_resolver.resolveRegionConfig)(_config_3);
    const _config_5 = (0, import_middleware_host_header.resolveHostHeaderConfig)(_config_4);
    const _config_6 = (0, import_middleware_endpoint.resolveEndpointConfig)(_config_5);
    const _config_7 = (0, import_httpAuthSchemeProvider.resolveHttpAuthSchemeConfig)(_config_6);
    const _config_8 = resolveRuntimeExtensions(_config_7, configuration?.extensions || []);
    this.config = _config_8;
    this.middlewareStack.use((0, import_middleware_user_agent.getUserAgentPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_retry.getRetryPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_content_length.getContentLengthPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_host_header.getHostHeaderPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_logger.getLoggerPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_recursion_detection.getRecursionDetectionPlugin)(this.config));
    this.middlewareStack.use(
      (0, import_core.getHttpAuthSchemeEndpointRuleSetPlugin)(this.config, {
        httpAuthSchemeParametersProvider: import_httpAuthSchemeProvider.defaultRDSHttpAuthSchemeParametersProvider,
        identityProviderConfigProvider: /* @__PURE__ */ __name(async (config) => new import_core.DefaultIdentityProviderConfig({
          "aws.auth#sigv4": config.credentials
        }), "identityProviderConfigProvider")
      })
    );
    this.middlewareStack.use((0, import_core.getHttpSigningPlugin)(this.config));
  }
  /**
   * Destroy underlying resources, like sockets. It's usually not necessary to do this.
   * However in Node.js, it's best to explicitly shut down the client's agent when it is no longer needed.
   * Otherwise, sockets might stay open for quite a long time before the server terminates them.
   */
  destroy() {
    super.destroy();
  }
};

// src/RDS.ts


// src/commands/AddRoleToDBClusterCommand.ts

var import_middleware_serde = require("@smithy/middleware-serde");


// src/protocols/Aws_query.ts
var import_core2 = require("@aws-sdk/core");



// src/models/models_0.ts


// src/models/RDSServiceException.ts

var RDSServiceException = class _RDSServiceException extends import_smithy_client.ServiceException {
  static {
    __name(this, "RDSServiceException");
  }
  /**
   * @internal
   */
  constructor(options) {
    super(options);
    Object.setPrototypeOf(this, _RDSServiceException.prototype);
  }
};

// src/models/models_0.ts
var ActivityStreamMode = {
  async: "async",
  sync: "sync"
};
var ActivityStreamPolicyStatus = {
  locked: "locked",
  locking_policy: "locking-policy",
  unlocked: "unlocked",
  unlocking_policy: "unlocking-policy"
};
var ActivityStreamStatus = {
  started: "started",
  starting: "starting",
  stopped: "stopped",
  stopping: "stopping"
};
var DBClusterNotFoundFault = class _DBClusterNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DBClusterNotFoundFault");
  }
  name = "DBClusterNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBClusterNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBClusterNotFoundFault.prototype);
  }
};
var DBClusterRoleAlreadyExistsFault = class _DBClusterRoleAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "DBClusterRoleAlreadyExistsFault");
  }
  name = "DBClusterRoleAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBClusterRoleAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBClusterRoleAlreadyExistsFault.prototype);
  }
};
var DBClusterRoleQuotaExceededFault = class _DBClusterRoleQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "DBClusterRoleQuotaExceededFault");
  }
  name = "DBClusterRoleQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBClusterRoleQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBClusterRoleQuotaExceededFault.prototype);
  }
};
var InvalidDBClusterStateFault = class _InvalidDBClusterStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidDBClusterStateFault");
  }
  name = "InvalidDBClusterStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDBClusterStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDBClusterStateFault.prototype);
  }
};
var DBInstanceNotFoundFault = class _DBInstanceNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DBInstanceNotFoundFault");
  }
  name = "DBInstanceNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBInstanceNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBInstanceNotFoundFault.prototype);
  }
};
var DBInstanceRoleAlreadyExistsFault = class _DBInstanceRoleAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "DBInstanceRoleAlreadyExistsFault");
  }
  name = "DBInstanceRoleAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBInstanceRoleAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBInstanceRoleAlreadyExistsFault.prototype);
  }
};
var DBInstanceRoleQuotaExceededFault = class _DBInstanceRoleQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "DBInstanceRoleQuotaExceededFault");
  }
  name = "DBInstanceRoleQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBInstanceRoleQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBInstanceRoleQuotaExceededFault.prototype);
  }
};
var InvalidDBInstanceStateFault = class _InvalidDBInstanceStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidDBInstanceStateFault");
  }
  name = "InvalidDBInstanceStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDBInstanceStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDBInstanceStateFault.prototype);
  }
};
var SourceNotFoundFault = class _SourceNotFoundFault extends RDSServiceException {
  static {
    __name(this, "SourceNotFoundFault");
  }
  name = "SourceNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "SourceNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _SourceNotFoundFault.prototype);
  }
};
var SubscriptionNotFoundFault = class _SubscriptionNotFoundFault extends RDSServiceException {
  static {
    __name(this, "SubscriptionNotFoundFault");
  }
  name = "SubscriptionNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "SubscriptionNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _SubscriptionNotFoundFault.prototype);
  }
};
var BlueGreenDeploymentNotFoundFault = class _BlueGreenDeploymentNotFoundFault extends RDSServiceException {
  static {
    __name(this, "BlueGreenDeploymentNotFoundFault");
  }
  name = "BlueGreenDeploymentNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "BlueGreenDeploymentNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _BlueGreenDeploymentNotFoundFault.prototype);
  }
};
var DBProxyNotFoundFault = class _DBProxyNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DBProxyNotFoundFault");
  }
  name = "DBProxyNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBProxyNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBProxyNotFoundFault.prototype);
  }
};
var DBProxyTargetGroupNotFoundFault = class _DBProxyTargetGroupNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DBProxyTargetGroupNotFoundFault");
  }
  name = "DBProxyTargetGroupNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBProxyTargetGroupNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBProxyTargetGroupNotFoundFault.prototype);
  }
};
var DBSnapshotNotFoundFault = class _DBSnapshotNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DBSnapshotNotFoundFault");
  }
  name = "DBSnapshotNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBSnapshotNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBSnapshotNotFoundFault.prototype);
  }
};
var DBSnapshotTenantDatabaseNotFoundFault = class _DBSnapshotTenantDatabaseNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DBSnapshotTenantDatabaseNotFoundFault");
  }
  name = "DBSnapshotTenantDatabaseNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBSnapshotTenantDatabaseNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBSnapshotTenantDatabaseNotFoundFault.prototype);
  }
};
var IntegrationNotFoundFault = class _IntegrationNotFoundFault extends RDSServiceException {
  static {
    __name(this, "IntegrationNotFoundFault");
  }
  name = "IntegrationNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "IntegrationNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _IntegrationNotFoundFault.prototype);
  }
};
var TenantDatabaseNotFoundFault = class _TenantDatabaseNotFoundFault extends RDSServiceException {
  static {
    __name(this, "TenantDatabaseNotFoundFault");
  }
  name = "TenantDatabaseNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TenantDatabaseNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TenantDatabaseNotFoundFault.prototype);
  }
};
var ResourceNotFoundFault = class _ResourceNotFoundFault extends RDSServiceException {
  static {
    __name(this, "ResourceNotFoundFault");
  }
  name = "ResourceNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceNotFoundFault.prototype);
  }
};
var AuthorizationAlreadyExistsFault = class _AuthorizationAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "AuthorizationAlreadyExistsFault");
  }
  name = "AuthorizationAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AuthorizationAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AuthorizationAlreadyExistsFault.prototype);
  }
};
var AuthorizationQuotaExceededFault = class _AuthorizationQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "AuthorizationQuotaExceededFault");
  }
  name = "AuthorizationQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AuthorizationQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AuthorizationQuotaExceededFault.prototype);
  }
};
var DBSecurityGroupNotFoundFault = class _DBSecurityGroupNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DBSecurityGroupNotFoundFault");
  }
  name = "DBSecurityGroupNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBSecurityGroupNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBSecurityGroupNotFoundFault.prototype);
  }
};
var InvalidDBSecurityGroupStateFault = class _InvalidDBSecurityGroupStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidDBSecurityGroupStateFault");
  }
  name = "InvalidDBSecurityGroupStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDBSecurityGroupStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDBSecurityGroupStateFault.prototype);
  }
};
var ExportSourceType = {
  CLUSTER: "CLUSTER",
  SNAPSHOT: "SNAPSHOT"
};
var ExportTaskNotFoundFault = class _ExportTaskNotFoundFault extends RDSServiceException {
  static {
    __name(this, "ExportTaskNotFoundFault");
  }
  name = "ExportTaskNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ExportTaskNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ExportTaskNotFoundFault.prototype);
  }
};
var InvalidExportTaskStateFault = class _InvalidExportTaskStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidExportTaskStateFault");
  }
  name = "InvalidExportTaskStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidExportTaskStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidExportTaskStateFault.prototype);
  }
};
var DBParameterGroupAlreadyExistsFault = class _DBParameterGroupAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "DBParameterGroupAlreadyExistsFault");
  }
  name = "DBParameterGroupAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBParameterGroupAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBParameterGroupAlreadyExistsFault.prototype);
  }
};
var DBParameterGroupNotFoundFault = class _DBParameterGroupNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DBParameterGroupNotFoundFault");
  }
  name = "DBParameterGroupNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBParameterGroupNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBParameterGroupNotFoundFault.prototype);
  }
};
var DBParameterGroupQuotaExceededFault = class _DBParameterGroupQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "DBParameterGroupQuotaExceededFault");
  }
  name = "DBParameterGroupQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBParameterGroupQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBParameterGroupQuotaExceededFault.prototype);
  }
};
var DBClusterSnapshotAlreadyExistsFault = class _DBClusterSnapshotAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "DBClusterSnapshotAlreadyExistsFault");
  }
  name = "DBClusterSnapshotAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBClusterSnapshotAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBClusterSnapshotAlreadyExistsFault.prototype);
  }
};
var DBClusterSnapshotNotFoundFault = class _DBClusterSnapshotNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DBClusterSnapshotNotFoundFault");
  }
  name = "DBClusterSnapshotNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBClusterSnapshotNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBClusterSnapshotNotFoundFault.prototype);
  }
};
var InvalidDBClusterSnapshotStateFault = class _InvalidDBClusterSnapshotStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidDBClusterSnapshotStateFault");
  }
  name = "InvalidDBClusterSnapshotStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDBClusterSnapshotStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDBClusterSnapshotStateFault.prototype);
  }
};
var KMSKeyNotAccessibleFault = class _KMSKeyNotAccessibleFault extends RDSServiceException {
  static {
    __name(this, "KMSKeyNotAccessibleFault");
  }
  name = "KMSKeyNotAccessibleFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "KMSKeyNotAccessibleFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _KMSKeyNotAccessibleFault.prototype);
  }
};
var SnapshotQuotaExceededFault = class _SnapshotQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "SnapshotQuotaExceededFault");
  }
  name = "SnapshotQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "SnapshotQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _SnapshotQuotaExceededFault.prototype);
  }
};
var CustomAvailabilityZoneNotFoundFault = class _CustomAvailabilityZoneNotFoundFault extends RDSServiceException {
  static {
    __name(this, "CustomAvailabilityZoneNotFoundFault");
  }
  name = "CustomAvailabilityZoneNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CustomAvailabilityZoneNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CustomAvailabilityZoneNotFoundFault.prototype);
  }
};
var DBSnapshotAlreadyExistsFault = class _DBSnapshotAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "DBSnapshotAlreadyExistsFault");
  }
  name = "DBSnapshotAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBSnapshotAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBSnapshotAlreadyExistsFault.prototype);
  }
};
var InvalidDBSnapshotStateFault = class _InvalidDBSnapshotStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidDBSnapshotStateFault");
  }
  name = "InvalidDBSnapshotStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDBSnapshotStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDBSnapshotStateFault.prototype);
  }
};
var OptionGroupAlreadyExistsFault = class _OptionGroupAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "OptionGroupAlreadyExistsFault");
  }
  name = "OptionGroupAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OptionGroupAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OptionGroupAlreadyExistsFault.prototype);
  }
};
var OptionGroupNotFoundFault = class _OptionGroupNotFoundFault extends RDSServiceException {
  static {
    __name(this, "OptionGroupNotFoundFault");
  }
  name = "OptionGroupNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OptionGroupNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OptionGroupNotFoundFault.prototype);
  }
};
var OptionGroupQuotaExceededFault = class _OptionGroupQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "OptionGroupQuotaExceededFault");
  }
  name = "OptionGroupQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "OptionGroupQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _OptionGroupQuotaExceededFault.prototype);
  }
};
var BlueGreenDeploymentAlreadyExistsFault = class _BlueGreenDeploymentAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "BlueGreenDeploymentAlreadyExistsFault");
  }
  name = "BlueGreenDeploymentAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "BlueGreenDeploymentAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _BlueGreenDeploymentAlreadyExistsFault.prototype);
  }
};
var DBClusterParameterGroupNotFoundFault = class _DBClusterParameterGroupNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DBClusterParameterGroupNotFoundFault");
  }
  name = "DBClusterParameterGroupNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBClusterParameterGroupNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBClusterParameterGroupNotFoundFault.prototype);
  }
};
var DBClusterQuotaExceededFault = class _DBClusterQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "DBClusterQuotaExceededFault");
  }
  name = "DBClusterQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBClusterQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBClusterQuotaExceededFault.prototype);
  }
};
var InstanceQuotaExceededFault = class _InstanceQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "InstanceQuotaExceededFault");
  }
  name = "InstanceQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InstanceQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InstanceQuotaExceededFault.prototype);
  }
};
var SourceClusterNotSupportedFault = class _SourceClusterNotSupportedFault extends RDSServiceException {
  static {
    __name(this, "SourceClusterNotSupportedFault");
  }
  name = "SourceClusterNotSupportedFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "SourceClusterNotSupportedFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _SourceClusterNotSupportedFault.prototype);
  }
};
var SourceDatabaseNotSupportedFault = class _SourceDatabaseNotSupportedFault extends RDSServiceException {
  static {
    __name(this, "SourceDatabaseNotSupportedFault");
  }
  name = "SourceDatabaseNotSupportedFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "SourceDatabaseNotSupportedFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _SourceDatabaseNotSupportedFault.prototype);
  }
};
var CreateCustomDBEngineVersionFault = class _CreateCustomDBEngineVersionFault extends RDSServiceException {
  static {
    __name(this, "CreateCustomDBEngineVersionFault");
  }
  name = "CreateCustomDBEngineVersionFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CreateCustomDBEngineVersionFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CreateCustomDBEngineVersionFault.prototype);
  }
};
var CustomDBEngineVersionAlreadyExistsFault = class _CustomDBEngineVersionAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "CustomDBEngineVersionAlreadyExistsFault");
  }
  name = "CustomDBEngineVersionAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CustomDBEngineVersionAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CustomDBEngineVersionAlreadyExistsFault.prototype);
  }
};
var CustomDBEngineVersionQuotaExceededFault = class _CustomDBEngineVersionQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "CustomDBEngineVersionQuotaExceededFault");
  }
  name = "CustomDBEngineVersionQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CustomDBEngineVersionQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CustomDBEngineVersionQuotaExceededFault.prototype);
  }
};
var Ec2ImagePropertiesNotSupportedFault = class _Ec2ImagePropertiesNotSupportedFault extends RDSServiceException {
  static {
    __name(this, "Ec2ImagePropertiesNotSupportedFault");
  }
  name = "Ec2ImagePropertiesNotSupportedFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "Ec2ImagePropertiesNotSupportedFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _Ec2ImagePropertiesNotSupportedFault.prototype);
  }
};
var ClusterScalabilityType = {
  LIMITLESS: "limitless",
  STANDARD: "standard"
};
var DatabaseInsightsMode = {
  ADVANCED: "advanced",
  STANDARD: "standard"
};
var ReplicaMode = {
  MOUNTED: "mounted",
  OPEN_READ_ONLY: "open-read-only"
};
var WriteForwardingStatus = {
  DISABLED: "disabled",
  DISABLING: "disabling",
  ENABLED: "enabled",
  ENABLING: "enabling",
  UNKNOWN: "unknown"
};
var LimitlessDatabaseStatus = {
  ACTIVE: "active",
  DISABLED: "disabled",
  DISABLING: "disabling",
  ENABLED: "enabled",
  ENABLING: "enabling",
  ERROR: "error",
  MODIFYING_MAX_CAPACITY: "modifying-max-capacity",
  NOT_IN_USE: "not-in-use"
};
var LocalWriteForwardingStatus = {
  DISABLED: "disabled",
  DISABLING: "disabling",
  ENABLED: "enabled",
  ENABLING: "enabling",
  REQUESTED: "requested"
};
var DBClusterAlreadyExistsFault = class _DBClusterAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "DBClusterAlreadyExistsFault");
  }
  name = "DBClusterAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBClusterAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBClusterAlreadyExistsFault.prototype);
  }
};
var DBSubnetGroupDoesNotCoverEnoughAZs = class _DBSubnetGroupDoesNotCoverEnoughAZs extends RDSServiceException {
  static {
    __name(this, "DBSubnetGroupDoesNotCoverEnoughAZs");
  }
  name = "DBSubnetGroupDoesNotCoverEnoughAZs";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBSubnetGroupDoesNotCoverEnoughAZs",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBSubnetGroupDoesNotCoverEnoughAZs.prototype);
  }
};
var DBSubnetGroupNotFoundFault = class _DBSubnetGroupNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DBSubnetGroupNotFoundFault");
  }
  name = "DBSubnetGroupNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBSubnetGroupNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBSubnetGroupNotFoundFault.prototype);
  }
};
var DomainNotFoundFault = class _DomainNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DomainNotFoundFault");
  }
  name = "DomainNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DomainNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DomainNotFoundFault.prototype);
  }
};
var GlobalClusterNotFoundFault = class _GlobalClusterNotFoundFault extends RDSServiceException {
  static {
    __name(this, "GlobalClusterNotFoundFault");
  }
  name = "GlobalClusterNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "GlobalClusterNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _GlobalClusterNotFoundFault.prototype);
  }
};
var InsufficientDBInstanceCapacityFault = class _InsufficientDBInstanceCapacityFault extends RDSServiceException {
  static {
    __name(this, "InsufficientDBInstanceCapacityFault");
  }
  name = "InsufficientDBInstanceCapacityFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InsufficientDBInstanceCapacityFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InsufficientDBInstanceCapacityFault.prototype);
  }
};
var InsufficientStorageClusterCapacityFault = class _InsufficientStorageClusterCapacityFault extends RDSServiceException {
  static {
    __name(this, "InsufficientStorageClusterCapacityFault");
  }
  name = "InsufficientStorageClusterCapacityFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InsufficientStorageClusterCapacityFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InsufficientStorageClusterCapacityFault.prototype);
  }
};
var InvalidDBSubnetGroupFault = class _InvalidDBSubnetGroupFault extends RDSServiceException {
  static {
    __name(this, "InvalidDBSubnetGroupFault");
  }
  name = "InvalidDBSubnetGroupFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDBSubnetGroupFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDBSubnetGroupFault.prototype);
  }
};
var InvalidDBSubnetGroupStateFault = class _InvalidDBSubnetGroupStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidDBSubnetGroupStateFault");
  }
  name = "InvalidDBSubnetGroupStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDBSubnetGroupStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDBSubnetGroupStateFault.prototype);
  }
};
var InvalidGlobalClusterStateFault = class _InvalidGlobalClusterStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidGlobalClusterStateFault");
  }
  name = "InvalidGlobalClusterStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidGlobalClusterStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidGlobalClusterStateFault.prototype);
  }
};
var InvalidSubnet = class _InvalidSubnet extends RDSServiceException {
  static {
    __name(this, "InvalidSubnet");
  }
  name = "InvalidSubnet";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidSubnet",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidSubnet.prototype);
  }
};
var InvalidVPCNetworkStateFault = class _InvalidVPCNetworkStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidVPCNetworkStateFault");
  }
  name = "InvalidVPCNetworkStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidVPCNetworkStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidVPCNetworkStateFault.prototype);
  }
};
var StorageQuotaExceededFault = class _StorageQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "StorageQuotaExceededFault");
  }
  name = "StorageQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "StorageQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _StorageQuotaExceededFault.prototype);
  }
};
var DBClusterEndpointAlreadyExistsFault = class _DBClusterEndpointAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "DBClusterEndpointAlreadyExistsFault");
  }
  name = "DBClusterEndpointAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBClusterEndpointAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBClusterEndpointAlreadyExistsFault.prototype);
  }
};
var DBClusterEndpointQuotaExceededFault = class _DBClusterEndpointQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "DBClusterEndpointQuotaExceededFault");
  }
  name = "DBClusterEndpointQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBClusterEndpointQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBClusterEndpointQuotaExceededFault.prototype);
  }
};
var AuthorizationNotFoundFault = class _AuthorizationNotFoundFault extends RDSServiceException {
  static {
    __name(this, "AuthorizationNotFoundFault");
  }
  name = "AuthorizationNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AuthorizationNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AuthorizationNotFoundFault.prototype);
  }
};
var BackupPolicyNotFoundFault = class _BackupPolicyNotFoundFault extends RDSServiceException {
  static {
    __name(this, "BackupPolicyNotFoundFault");
  }
  name = "BackupPolicyNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "BackupPolicyNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _BackupPolicyNotFoundFault.prototype);
  }
};
var CertificateNotFoundFault = class _CertificateNotFoundFault extends RDSServiceException {
  static {
    __name(this, "CertificateNotFoundFault");
  }
  name = "CertificateNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CertificateNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CertificateNotFoundFault.prototype);
  }
};
var AutomationMode = {
  ALL_PAUSED: "all-paused",
  FULL: "full"
};
var DBInstanceAlreadyExistsFault = class _DBInstanceAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "DBInstanceAlreadyExistsFault");
  }
  name = "DBInstanceAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBInstanceAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBInstanceAlreadyExistsFault.prototype);
  }
};
var NetworkTypeNotSupported = class _NetworkTypeNotSupported extends RDSServiceException {
  static {
    __name(this, "NetworkTypeNotSupported");
  }
  name = "NetworkTypeNotSupported";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NetworkTypeNotSupported",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NetworkTypeNotSupported.prototype);
  }
};
var ProvisionedIopsNotAvailableInAZFault = class _ProvisionedIopsNotAvailableInAZFault extends RDSServiceException {
  static {
    __name(this, "ProvisionedIopsNotAvailableInAZFault");
  }
  name = "ProvisionedIopsNotAvailableInAZFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ProvisionedIopsNotAvailableInAZFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ProvisionedIopsNotAvailableInAZFault.prototype);
  }
};
var StorageTypeNotSupportedFault = class _StorageTypeNotSupportedFault extends RDSServiceException {
  static {
    __name(this, "StorageTypeNotSupportedFault");
  }
  name = "StorageTypeNotSupportedFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "StorageTypeNotSupportedFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _StorageTypeNotSupportedFault.prototype);
  }
};
var TenantDatabaseQuotaExceededFault = class _TenantDatabaseQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "TenantDatabaseQuotaExceededFault");
  }
  name = "TenantDatabaseQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TenantDatabaseQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TenantDatabaseQuotaExceededFault.prototype);
  }
};
var DBSubnetGroupNotAllowedFault = class _DBSubnetGroupNotAllowedFault extends RDSServiceException {
  static {
    __name(this, "DBSubnetGroupNotAllowedFault");
  }
  name = "DBSubnetGroupNotAllowedFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBSubnetGroupNotAllowedFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBSubnetGroupNotAllowedFault.prototype);
  }
};
var AuthScheme = {
  SECRETS: "SECRETS"
};
var ClientPasswordAuthType = {
  MYSQL_CACHING_SHA2_PASSWORD: "MYSQL_CACHING_SHA2_PASSWORD",
  MYSQL_NATIVE_PASSWORD: "MYSQL_NATIVE_PASSWORD",
  POSTGRES_MD5: "POSTGRES_MD5",
  POSTGRES_SCRAM_SHA_256: "POSTGRES_SCRAM_SHA_256",
  SQL_SERVER_AUTHENTICATION: "SQL_SERVER_AUTHENTICATION"
};
var IAMAuthMode = {
  DISABLED: "DISABLED",
  ENABLED: "ENABLED",
  REQUIRED: "REQUIRED"
};
var EngineFamily = {
  MYSQL: "MYSQL",
  POSTGRESQL: "POSTGRESQL",
  SQLSERVER: "SQLSERVER"
};
var DBProxyStatus = {
  AVAILABLE: "available",
  CREATING: "creating",
  DELETING: "deleting",
  INCOMPATIBLE_NETWORK: "incompatible-network",
  INSUFFICIENT_RESOURCE_LIMITS: "insufficient-resource-limits",
  MODIFYING: "modifying",
  REACTIVATING: "reactivating",
  SUSPENDED: "suspended",
  SUSPENDING: "suspending"
};
var DBProxyAlreadyExistsFault = class _DBProxyAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "DBProxyAlreadyExistsFault");
  }
  name = "DBProxyAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBProxyAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBProxyAlreadyExistsFault.prototype);
  }
};
var DBProxyQuotaExceededFault = class _DBProxyQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "DBProxyQuotaExceededFault");
  }
  name = "DBProxyQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBProxyQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBProxyQuotaExceededFault.prototype);
  }
};
var DBProxyEndpointTargetRole = {
  READ_ONLY: "READ_ONLY",
  READ_WRITE: "READ_WRITE"
};
var DBProxyEndpointStatus = {
  AVAILABLE: "available",
  CREATING: "creating",
  DELETING: "deleting",
  INCOMPATIBLE_NETWORK: "incompatible-network",
  INSUFFICIENT_RESOURCE_LIMITS: "insufficient-resource-limits",
  MODIFYING: "modifying"
};
var DBProxyEndpointAlreadyExistsFault = class _DBProxyEndpointAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "DBProxyEndpointAlreadyExistsFault");
  }
  name = "DBProxyEndpointAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBProxyEndpointAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBProxyEndpointAlreadyExistsFault.prototype);
  }
};
var DBProxyEndpointQuotaExceededFault = class _DBProxyEndpointQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "DBProxyEndpointQuotaExceededFault");
  }
  name = "DBProxyEndpointQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBProxyEndpointQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBProxyEndpointQuotaExceededFault.prototype);
  }
};
var InvalidDBProxyStateFault = class _InvalidDBProxyStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidDBProxyStateFault");
  }
  name = "InvalidDBProxyStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDBProxyStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDBProxyStateFault.prototype);
  }
};
var DBSecurityGroupAlreadyExistsFault = class _DBSecurityGroupAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "DBSecurityGroupAlreadyExistsFault");
  }
  name = "DBSecurityGroupAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBSecurityGroupAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBSecurityGroupAlreadyExistsFault.prototype);
  }
};
var DBSecurityGroupNotSupportedFault = class _DBSecurityGroupNotSupportedFault extends RDSServiceException {
  static {
    __name(this, "DBSecurityGroupNotSupportedFault");
  }
  name = "DBSecurityGroupNotSupportedFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBSecurityGroupNotSupportedFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBSecurityGroupNotSupportedFault.prototype);
  }
};
var DBSecurityGroupQuotaExceededFault = class _DBSecurityGroupQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "DBSecurityGroupQuotaExceededFault");
  }
  name = "DBSecurityGroupQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBSecurityGroupQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBSecurityGroupQuotaExceededFault.prototype);
  }
};
var DBShardGroupAlreadyExistsFault = class _DBShardGroupAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "DBShardGroupAlreadyExistsFault");
  }
  name = "DBShardGroupAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBShardGroupAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBShardGroupAlreadyExistsFault.prototype);
  }
};
var MaxDBShardGroupLimitReached = class _MaxDBShardGroupLimitReached extends RDSServiceException {
  static {
    __name(this, "MaxDBShardGroupLimitReached");
  }
  name = "MaxDBShardGroupLimitReached";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "MaxDBShardGroupLimitReached",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _MaxDBShardGroupLimitReached.prototype);
  }
};
var UnsupportedDBEngineVersionFault = class _UnsupportedDBEngineVersionFault extends RDSServiceException {
  static {
    __name(this, "UnsupportedDBEngineVersionFault");
  }
  name = "UnsupportedDBEngineVersionFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "UnsupportedDBEngineVersionFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _UnsupportedDBEngineVersionFault.prototype);
  }
};
var DBSubnetGroupAlreadyExistsFault = class _DBSubnetGroupAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "DBSubnetGroupAlreadyExistsFault");
  }
  name = "DBSubnetGroupAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBSubnetGroupAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBSubnetGroupAlreadyExistsFault.prototype);
  }
};
var DBSubnetGroupQuotaExceededFault = class _DBSubnetGroupQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "DBSubnetGroupQuotaExceededFault");
  }
  name = "DBSubnetGroupQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBSubnetGroupQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBSubnetGroupQuotaExceededFault.prototype);
  }
};
var DBSubnetQuotaExceededFault = class _DBSubnetQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "DBSubnetQuotaExceededFault");
  }
  name = "DBSubnetQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBSubnetQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBSubnetQuotaExceededFault.prototype);
  }
};
var EventSubscriptionQuotaExceededFault = class _EventSubscriptionQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "EventSubscriptionQuotaExceededFault");
  }
  name = "EventSubscriptionQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "EventSubscriptionQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _EventSubscriptionQuotaExceededFault.prototype);
  }
};
var SNSInvalidTopicFault = class _SNSInvalidTopicFault extends RDSServiceException {
  static {
    __name(this, "SNSInvalidTopicFault");
  }
  name = "SNSInvalidTopicFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "SNSInvalidTopicFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _SNSInvalidTopicFault.prototype);
  }
};
var SNSNoAuthorizationFault = class _SNSNoAuthorizationFault extends RDSServiceException {
  static {
    __name(this, "SNSNoAuthorizationFault");
  }
  name = "SNSNoAuthorizationFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "SNSNoAuthorizationFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _SNSNoAuthorizationFault.prototype);
  }
};
var SNSTopicArnNotFoundFault = class _SNSTopicArnNotFoundFault extends RDSServiceException {
  static {
    __name(this, "SNSTopicArnNotFoundFault");
  }
  name = "SNSTopicArnNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "SNSTopicArnNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _SNSTopicArnNotFoundFault.prototype);
  }
};
var SubscriptionAlreadyExistFault = class _SubscriptionAlreadyExistFault extends RDSServiceException {
  static {
    __name(this, "SubscriptionAlreadyExistFault");
  }
  name = "SubscriptionAlreadyExistFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "SubscriptionAlreadyExistFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _SubscriptionAlreadyExistFault.prototype);
  }
};
var SubscriptionCategoryNotFoundFault = class _SubscriptionCategoryNotFoundFault extends RDSServiceException {
  static {
    __name(this, "SubscriptionCategoryNotFoundFault");
  }
  name = "SubscriptionCategoryNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "SubscriptionCategoryNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _SubscriptionCategoryNotFoundFault.prototype);
  }
};
var FailoverStatus = {
  CANCELLING: "cancelling",
  FAILING_OVER: "failing-over",
  PENDING: "pending"
};
var GlobalClusterMemberSynchronizationStatus = {
  CONNECTED: "connected",
  PENDING_RESYNC: "pending-resync"
};
var GlobalClusterAlreadyExistsFault = class _GlobalClusterAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "GlobalClusterAlreadyExistsFault");
  }
  name = "GlobalClusterAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "GlobalClusterAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _GlobalClusterAlreadyExistsFault.prototype);
  }
};
var GlobalClusterQuotaExceededFault = class _GlobalClusterQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "GlobalClusterQuotaExceededFault");
  }
  name = "GlobalClusterQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "GlobalClusterQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _GlobalClusterQuotaExceededFault.prototype);
  }
};
var IntegrationStatus = {
  ACTIVE: "active",
  CREATING: "creating",
  DELETING: "deleting",
  FAILED: "failed",
  MODIFYING: "modifying",
  NEEDS_ATTENTION: "needs_attention",
  SYNCING: "syncing"
};
var IntegrationAlreadyExistsFault = class _IntegrationAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "IntegrationAlreadyExistsFault");
  }
  name = "IntegrationAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "IntegrationAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _IntegrationAlreadyExistsFault.prototype);
  }
};
var IntegrationConflictOperationFault = class _IntegrationConflictOperationFault extends RDSServiceException {
  static {
    __name(this, "IntegrationConflictOperationFault");
  }
  name = "IntegrationConflictOperationFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "IntegrationConflictOperationFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _IntegrationConflictOperationFault.prototype);
  }
};
var IntegrationQuotaExceededFault = class _IntegrationQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "IntegrationQuotaExceededFault");
  }
  name = "IntegrationQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "IntegrationQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _IntegrationQuotaExceededFault.prototype);
  }
};
var TenantDatabaseAlreadyExistsFault = class _TenantDatabaseAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "TenantDatabaseAlreadyExistsFault");
  }
  name = "TenantDatabaseAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "TenantDatabaseAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _TenantDatabaseAlreadyExistsFault.prototype);
  }
};
var InvalidBlueGreenDeploymentStateFault = class _InvalidBlueGreenDeploymentStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidBlueGreenDeploymentStateFault");
  }
  name = "InvalidBlueGreenDeploymentStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidBlueGreenDeploymentStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidBlueGreenDeploymentStateFault.prototype);
  }
};
var CustomDBEngineVersionNotFoundFault = class _CustomDBEngineVersionNotFoundFault extends RDSServiceException {
  static {
    __name(this, "CustomDBEngineVersionNotFoundFault");
  }
  name = "CustomDBEngineVersionNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "CustomDBEngineVersionNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _CustomDBEngineVersionNotFoundFault.prototype);
  }
};
var InvalidCustomDBEngineVersionStateFault = class _InvalidCustomDBEngineVersionStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidCustomDBEngineVersionStateFault");
  }
  name = "InvalidCustomDBEngineVersionStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidCustomDBEngineVersionStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidCustomDBEngineVersionStateFault.prototype);
  }
};
var DBClusterAutomatedBackupQuotaExceededFault = class _DBClusterAutomatedBackupQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "DBClusterAutomatedBackupQuotaExceededFault");
  }
  name = "DBClusterAutomatedBackupQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBClusterAutomatedBackupQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBClusterAutomatedBackupQuotaExceededFault.prototype);
  }
};
var DBClusterAutomatedBackupNotFoundFault = class _DBClusterAutomatedBackupNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DBClusterAutomatedBackupNotFoundFault");
  }
  name = "DBClusterAutomatedBackupNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBClusterAutomatedBackupNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBClusterAutomatedBackupNotFoundFault.prototype);
  }
};
var InvalidDBClusterAutomatedBackupStateFault = class _InvalidDBClusterAutomatedBackupStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidDBClusterAutomatedBackupStateFault");
  }
  name = "InvalidDBClusterAutomatedBackupStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDBClusterAutomatedBackupStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDBClusterAutomatedBackupStateFault.prototype);
  }
};
var DBClusterEndpointNotFoundFault = class _DBClusterEndpointNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DBClusterEndpointNotFoundFault");
  }
  name = "DBClusterEndpointNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBClusterEndpointNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBClusterEndpointNotFoundFault.prototype);
  }
};
var InvalidDBClusterEndpointStateFault = class _InvalidDBClusterEndpointStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidDBClusterEndpointStateFault");
  }
  name = "InvalidDBClusterEndpointStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDBClusterEndpointStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDBClusterEndpointStateFault.prototype);
  }
};
var InvalidDBParameterGroupStateFault = class _InvalidDBParameterGroupStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidDBParameterGroupStateFault");
  }
  name = "InvalidDBParameterGroupStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDBParameterGroupStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDBParameterGroupStateFault.prototype);
  }
};
var DBInstanceAutomatedBackupQuotaExceededFault = class _DBInstanceAutomatedBackupQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "DBInstanceAutomatedBackupQuotaExceededFault");
  }
  name = "DBInstanceAutomatedBackupQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBInstanceAutomatedBackupQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBInstanceAutomatedBackupQuotaExceededFault.prototype);
  }
};
var DBInstanceAutomatedBackupNotFoundFault = class _DBInstanceAutomatedBackupNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DBInstanceAutomatedBackupNotFoundFault");
  }
  name = "DBInstanceAutomatedBackupNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBInstanceAutomatedBackupNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBInstanceAutomatedBackupNotFoundFault.prototype);
  }
};
var InvalidDBInstanceAutomatedBackupStateFault = class _InvalidDBInstanceAutomatedBackupStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidDBInstanceAutomatedBackupStateFault");
  }
  name = "InvalidDBInstanceAutomatedBackupStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDBInstanceAutomatedBackupStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDBInstanceAutomatedBackupStateFault.prototype);
  }
};
var DBProxyEndpointNotFoundFault = class _DBProxyEndpointNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DBProxyEndpointNotFoundFault");
  }
  name = "DBProxyEndpointNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBProxyEndpointNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBProxyEndpointNotFoundFault.prototype);
  }
};
var InvalidDBProxyEndpointStateFault = class _InvalidDBProxyEndpointStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidDBProxyEndpointStateFault");
  }
  name = "InvalidDBProxyEndpointStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDBProxyEndpointStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDBProxyEndpointStateFault.prototype);
  }
};
var DBShardGroupNotFoundFault = class _DBShardGroupNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DBShardGroupNotFoundFault");
  }
  name = "DBShardGroupNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBShardGroupNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBShardGroupNotFoundFault.prototype);
  }
};
var InvalidDBShardGroupStateFault = class _InvalidDBShardGroupStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidDBShardGroupStateFault");
  }
  name = "InvalidDBShardGroupStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDBShardGroupStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDBShardGroupStateFault.prototype);
  }
};
var InvalidDBSubnetStateFault = class _InvalidDBSubnetStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidDBSubnetStateFault");
  }
  name = "InvalidDBSubnetStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDBSubnetStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDBSubnetStateFault.prototype);
  }
};
var InvalidEventSubscriptionStateFault = class _InvalidEventSubscriptionStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidEventSubscriptionStateFault");
  }
  name = "InvalidEventSubscriptionStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidEventSubscriptionStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidEventSubscriptionStateFault.prototype);
  }
};
var InvalidIntegrationStateFault = class _InvalidIntegrationStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidIntegrationStateFault");
  }
  name = "InvalidIntegrationStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidIntegrationStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidIntegrationStateFault.prototype);
  }
};
var CreateTenantDatabaseMessageFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.MasterUserPassword && { MasterUserPassword: import_smithy_client.SENSITIVE_STRING }
}), "CreateTenantDatabaseMessageFilterSensitiveLog");
var TenantDatabasePendingModifiedValuesFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.MasterUserPassword && { MasterUserPassword: import_smithy_client.SENSITIVE_STRING }
}), "TenantDatabasePendingModifiedValuesFilterSensitiveLog");
var TenantDatabaseFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.PendingModifiedValues && {
    PendingModifiedValues: TenantDatabasePendingModifiedValuesFilterSensitiveLog(obj.PendingModifiedValues)
  }
}), "TenantDatabaseFilterSensitiveLog");
var CreateTenantDatabaseResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.TenantDatabase && { TenantDatabase: TenantDatabaseFilterSensitiveLog(obj.TenantDatabase) }
}), "CreateTenantDatabaseResultFilterSensitiveLog");

// src/models/models_1.ts

var InvalidOptionGroupStateFault = class _InvalidOptionGroupStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidOptionGroupStateFault");
  }
  name = "InvalidOptionGroupStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidOptionGroupStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidOptionGroupStateFault.prototype);
  }
};
var DBProxyTargetNotFoundFault = class _DBProxyTargetNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DBProxyTargetNotFoundFault");
  }
  name = "DBProxyTargetNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBProxyTargetNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBProxyTargetNotFoundFault.prototype);
  }
};
var DBClusterBacktrackNotFoundFault = class _DBClusterBacktrackNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DBClusterBacktrackNotFoundFault");
  }
  name = "DBClusterBacktrackNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBClusterBacktrackNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBClusterBacktrackNotFoundFault.prototype);
  }
};
var ApplyMethod = {
  immediate: "immediate",
  pending_reboot: "pending-reboot"
};
var DBInstanceNotReadyFault = class _DBInstanceNotReadyFault extends RDSServiceException {
  static {
    __name(this, "DBInstanceNotReadyFault");
  }
  name = "DBInstanceNotReadyFault";
  $fault = "server";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBInstanceNotReadyFault",
      $fault: "server",
      ...opts
    });
    Object.setPrototypeOf(this, _DBInstanceNotReadyFault.prototype);
  }
};
var LifecycleSupportName = {
  OPEN_SOURCE_RDS_EXTENDED_SUPPORT: "open-source-rds-extended-support",
  OPEN_SOURCE_RDS_STANDARD_SUPPORT: "open-source-rds-standard-support"
};
var TargetRole = {
  READ_ONLY: "READ_ONLY",
  READ_WRITE: "READ_WRITE",
  UNKNOWN: "UNKNOWN"
};
var TargetHealthReason = {
  AUTH_FAILURE: "AUTH_FAILURE",
  CONNECTION_FAILED: "CONNECTION_FAILED",
  INVALID_REPLICATION_STATE: "INVALID_REPLICATION_STATE",
  PENDING_PROXY_CAPACITY: "PENDING_PROXY_CAPACITY",
  UNREACHABLE: "UNREACHABLE"
};
var TargetState = {
  available: "AVAILABLE",
  registering: "REGISTERING",
  unavailable: "UNAVAILABLE"
};
var TargetType = {
  RDS_INSTANCE: "RDS_INSTANCE",
  RDS_SERVERLESS_ENDPOINT: "RDS_SERVERLESS_ENDPOINT",
  TRACKED_CLUSTER: "TRACKED_CLUSTER"
};
var SourceType = {
  blue_green_deployment: "blue-green-deployment",
  custom_engine_version: "custom-engine-version",
  db_cluster: "db-cluster",
  db_cluster_snapshot: "db-cluster-snapshot",
  db_instance: "db-instance",
  db_parameter_group: "db-parameter-group",
  db_proxy: "db-proxy",
  db_security_group: "db-security-group",
  db_snapshot: "db-snapshot"
};
var ReservedDBInstanceNotFoundFault = class _ReservedDBInstanceNotFoundFault extends RDSServiceException {
  static {
    __name(this, "ReservedDBInstanceNotFoundFault");
  }
  name = "ReservedDBInstanceNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ReservedDBInstanceNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ReservedDBInstanceNotFoundFault.prototype);
  }
};
var ReservedDBInstancesOfferingNotFoundFault = class _ReservedDBInstancesOfferingNotFoundFault extends RDSServiceException {
  static {
    __name(this, "ReservedDBInstancesOfferingNotFoundFault");
  }
  name = "ReservedDBInstancesOfferingNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ReservedDBInstancesOfferingNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ReservedDBInstancesOfferingNotFoundFault.prototype);
  }
};
var InvalidResourceStateFault = class _InvalidResourceStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidResourceStateFault");
  }
  name = "InvalidResourceStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidResourceStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidResourceStateFault.prototype);
  }
};
var DBLogFileNotFoundFault = class _DBLogFileNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DBLogFileNotFoundFault");
  }
  name = "DBLogFileNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBLogFileNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBLogFileNotFoundFault.prototype);
  }
};
var AuditPolicyState = {
  LOCKED_POLICY: "locked",
  UNLOCKED_POLICY: "unlocked"
};
var InvalidDBClusterCapacityFault = class _InvalidDBClusterCapacityFault extends RDSServiceException {
  static {
    __name(this, "InvalidDBClusterCapacityFault");
  }
  name = "InvalidDBClusterCapacityFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidDBClusterCapacityFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidDBClusterCapacityFault.prototype);
  }
};
var CustomEngineVersionStatus = {
  available: "available",
  inactive: "inactive",
  inactive_except_restore: "inactive-except-restore"
};
var StorageTypeNotAvailableFault = class _StorageTypeNotAvailableFault extends RDSServiceException {
  static {
    __name(this, "StorageTypeNotAvailableFault");
  }
  name = "StorageTypeNotAvailableFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "StorageTypeNotAvailableFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _StorageTypeNotAvailableFault.prototype);
  }
};
var SharedSnapshotQuotaExceededFault = class _SharedSnapshotQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "SharedSnapshotQuotaExceededFault");
  }
  name = "SharedSnapshotQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "SharedSnapshotQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _SharedSnapshotQuotaExceededFault.prototype);
  }
};
var DBUpgradeDependencyFailureFault = class _DBUpgradeDependencyFailureFault extends RDSServiceException {
  static {
    __name(this, "DBUpgradeDependencyFailureFault");
  }
  name = "DBUpgradeDependencyFailureFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBUpgradeDependencyFailureFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBUpgradeDependencyFailureFault.prototype);
  }
};
var SubnetAlreadyInUse = class _SubnetAlreadyInUse extends RDSServiceException {
  static {
    __name(this, "SubnetAlreadyInUse");
  }
  name = "SubnetAlreadyInUse";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "SubnetAlreadyInUse",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _SubnetAlreadyInUse.prototype);
  }
};
var ReservedDBInstanceAlreadyExistsFault = class _ReservedDBInstanceAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "ReservedDBInstanceAlreadyExistsFault");
  }
  name = "ReservedDBInstanceAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ReservedDBInstanceAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ReservedDBInstanceAlreadyExistsFault.prototype);
  }
};
var ReservedDBInstanceQuotaExceededFault = class _ReservedDBInstanceQuotaExceededFault extends RDSServiceException {
  static {
    __name(this, "ReservedDBInstanceQuotaExceededFault");
  }
  name = "ReservedDBInstanceQuotaExceededFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ReservedDBInstanceQuotaExceededFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ReservedDBInstanceQuotaExceededFault.prototype);
  }
};
var DBProxyTargetAlreadyRegisteredFault = class _DBProxyTargetAlreadyRegisteredFault extends RDSServiceException {
  static {
    __name(this, "DBProxyTargetAlreadyRegisteredFault");
  }
  name = "DBProxyTargetAlreadyRegisteredFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBProxyTargetAlreadyRegisteredFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBProxyTargetAlreadyRegisteredFault.prototype);
  }
};
var InsufficientAvailableIPsInSubnetFault = class _InsufficientAvailableIPsInSubnetFault extends RDSServiceException {
  static {
    __name(this, "InsufficientAvailableIPsInSubnetFault");
  }
  name = "InsufficientAvailableIPsInSubnetFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InsufficientAvailableIPsInSubnetFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InsufficientAvailableIPsInSubnetFault.prototype);
  }
};
var DBClusterRoleNotFoundFault = class _DBClusterRoleNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DBClusterRoleNotFoundFault");
  }
  name = "DBClusterRoleNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBClusterRoleNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBClusterRoleNotFoundFault.prototype);
  }
};
var DBInstanceRoleNotFoundFault = class _DBInstanceRoleNotFoundFault extends RDSServiceException {
  static {
    __name(this, "DBInstanceRoleNotFoundFault");
  }
  name = "DBInstanceRoleNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "DBInstanceRoleNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _DBInstanceRoleNotFoundFault.prototype);
  }
};
var InvalidS3BucketFault = class _InvalidS3BucketFault extends RDSServiceException {
  static {
    __name(this, "InvalidS3BucketFault");
  }
  name = "InvalidS3BucketFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidS3BucketFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidS3BucketFault.prototype);
  }
};
var InsufficientDBClusterCapacityFault = class _InsufficientDBClusterCapacityFault extends RDSServiceException {
  static {
    __name(this, "InsufficientDBClusterCapacityFault");
  }
  name = "InsufficientDBClusterCapacityFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InsufficientDBClusterCapacityFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InsufficientDBClusterCapacityFault.prototype);
  }
};
var InvalidRestoreFault = class _InvalidRestoreFault extends RDSServiceException {
  static {
    __name(this, "InvalidRestoreFault");
  }
  name = "InvalidRestoreFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidRestoreFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidRestoreFault.prototype);
  }
};
var PointInTimeRestoreNotEnabledFault = class _PointInTimeRestoreNotEnabledFault extends RDSServiceException {
  static {
    __name(this, "PointInTimeRestoreNotEnabledFault");
  }
  name = "PointInTimeRestoreNotEnabledFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "PointInTimeRestoreNotEnabledFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _PointInTimeRestoreNotEnabledFault.prototype);
  }
};
var ExportTaskAlreadyExistsFault = class _ExportTaskAlreadyExistsFault extends RDSServiceException {
  static {
    __name(this, "ExportTaskAlreadyExistsFault");
  }
  name = "ExportTaskAlreadyExistsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ExportTaskAlreadyExistsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ExportTaskAlreadyExistsFault.prototype);
  }
};
var IamRoleMissingPermissionsFault = class _IamRoleMissingPermissionsFault extends RDSServiceException {
  static {
    __name(this, "IamRoleMissingPermissionsFault");
  }
  name = "IamRoleMissingPermissionsFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "IamRoleMissingPermissionsFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _IamRoleMissingPermissionsFault.prototype);
  }
};
var IamRoleNotFoundFault = class _IamRoleNotFoundFault extends RDSServiceException {
  static {
    __name(this, "IamRoleNotFoundFault");
  }
  name = "IamRoleNotFoundFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "IamRoleNotFoundFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _IamRoleNotFoundFault.prototype);
  }
};
var InvalidExportOnlyFault = class _InvalidExportOnlyFault extends RDSServiceException {
  static {
    __name(this, "InvalidExportOnlyFault");
  }
  name = "InvalidExportOnlyFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidExportOnlyFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidExportOnlyFault.prototype);
  }
};
var InvalidExportSourceStateFault = class _InvalidExportSourceStateFault extends RDSServiceException {
  static {
    __name(this, "InvalidExportSourceStateFault");
  }
  name = "InvalidExportSourceStateFault";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidExportSourceStateFault",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidExportSourceStateFault.prototype);
  }
};
var DeleteTenantDatabaseResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.TenantDatabase && { TenantDatabase: TenantDatabaseFilterSensitiveLog(obj.TenantDatabase) }
}), "DeleteTenantDatabaseResultFilterSensitiveLog");
var TenantDatabasesMessageFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.TenantDatabases && {
    TenantDatabases: obj.TenantDatabases.map((item) => TenantDatabaseFilterSensitiveLog(item))
  }
}), "TenantDatabasesMessageFilterSensitiveLog");
var ModifyTenantDatabaseMessageFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.MasterUserPassword && { MasterUserPassword: import_smithy_client.SENSITIVE_STRING }
}), "ModifyTenantDatabaseMessageFilterSensitiveLog");
var ModifyTenantDatabaseResultFilterSensitiveLog = /* @__PURE__ */ __name((obj) => ({
  ...obj,
  ...obj.TenantDatabase && { TenantDatabase: TenantDatabaseFilterSensitiveLog(obj.TenantDatabase) }
}), "ModifyTenantDatabaseResultFilterSensitiveLog");

// src/protocols/Aws_query.ts
var se_AddRoleToDBClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_AddRoleToDBClusterMessage(input, context),
    [_A]: _ARTDBC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_AddRoleToDBClusterCommand");
var se_AddRoleToDBInstanceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_AddRoleToDBInstanceMessage(input, context),
    [_A]: _ARTDBI,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_AddRoleToDBInstanceCommand");
var se_AddSourceIdentifierToSubscriptionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_AddSourceIdentifierToSubscriptionMessage(input, context),
    [_A]: _ASITS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_AddSourceIdentifierToSubscriptionCommand");
var se_AddTagsToResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_AddTagsToResourceMessage(input, context),
    [_A]: _ATTR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_AddTagsToResourceCommand");
var se_ApplyPendingMaintenanceActionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ApplyPendingMaintenanceActionMessage(input, context),
    [_A]: _APMA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ApplyPendingMaintenanceActionCommand");
var se_AuthorizeDBSecurityGroupIngressCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_AuthorizeDBSecurityGroupIngressMessage(input, context),
    [_A]: _ADBSGI,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_AuthorizeDBSecurityGroupIngressCommand");
var se_BacktrackDBClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_BacktrackDBClusterMessage(input, context),
    [_A]: _BDBC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_BacktrackDBClusterCommand");
var se_CancelExportTaskCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CancelExportTaskMessage(input, context),
    [_A]: _CET,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CancelExportTaskCommand");
var se_CopyDBClusterParameterGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CopyDBClusterParameterGroupMessage(input, context),
    [_A]: _CDBCPG,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CopyDBClusterParameterGroupCommand");
var se_CopyDBClusterSnapshotCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CopyDBClusterSnapshotMessage(input, context),
    [_A]: _CDBCS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CopyDBClusterSnapshotCommand");
var se_CopyDBParameterGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CopyDBParameterGroupMessage(input, context),
    [_A]: _CDBPG,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CopyDBParameterGroupCommand");
var se_CopyDBSnapshotCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CopyDBSnapshotMessage(input, context),
    [_A]: _CDBS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CopyDBSnapshotCommand");
var se_CopyOptionGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CopyOptionGroupMessage(input, context),
    [_A]: _COG,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CopyOptionGroupCommand");
var se_CreateBlueGreenDeploymentCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateBlueGreenDeploymentRequest(input, context),
    [_A]: _CBGD,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateBlueGreenDeploymentCommand");
var se_CreateCustomDBEngineVersionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateCustomDBEngineVersionMessage(input, context),
    [_A]: _CCDBEV,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateCustomDBEngineVersionCommand");
var se_CreateDBClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateDBClusterMessage(input, context),
    [_A]: _CDBC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateDBClusterCommand");
var se_CreateDBClusterEndpointCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateDBClusterEndpointMessage(input, context),
    [_A]: _CDBCE,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateDBClusterEndpointCommand");
var se_CreateDBClusterParameterGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateDBClusterParameterGroupMessage(input, context),
    [_A]: _CDBCPGr,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateDBClusterParameterGroupCommand");
var se_CreateDBClusterSnapshotCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateDBClusterSnapshotMessage(input, context),
    [_A]: _CDBCSr,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateDBClusterSnapshotCommand");
var se_CreateDBInstanceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateDBInstanceMessage(input, context),
    [_A]: _CDBI,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateDBInstanceCommand");
var se_CreateDBInstanceReadReplicaCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateDBInstanceReadReplicaMessage(input, context),
    [_A]: _CDBIRR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateDBInstanceReadReplicaCommand");
var se_CreateDBParameterGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateDBParameterGroupMessage(input, context),
    [_A]: _CDBPGr,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateDBParameterGroupCommand");
var se_CreateDBProxyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateDBProxyRequest(input, context),
    [_A]: _CDBP,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateDBProxyCommand");
var se_CreateDBProxyEndpointCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateDBProxyEndpointRequest(input, context),
    [_A]: _CDBPE,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateDBProxyEndpointCommand");
var se_CreateDBSecurityGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateDBSecurityGroupMessage(input, context),
    [_A]: _CDBSG,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateDBSecurityGroupCommand");
var se_CreateDBShardGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateDBShardGroupMessage(input, context),
    [_A]: _CDBSGr,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateDBShardGroupCommand");
var se_CreateDBSnapshotCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateDBSnapshotMessage(input, context),
    [_A]: _CDBSr,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateDBSnapshotCommand");
var se_CreateDBSubnetGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateDBSubnetGroupMessage(input, context),
    [_A]: _CDBSGre,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateDBSubnetGroupCommand");
var se_CreateEventSubscriptionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateEventSubscriptionMessage(input, context),
    [_A]: _CES,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateEventSubscriptionCommand");
var se_CreateGlobalClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateGlobalClusterMessage(input, context),
    [_A]: _CGC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateGlobalClusterCommand");
var se_CreateIntegrationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateIntegrationMessage(input, context),
    [_A]: _CI,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateIntegrationCommand");
var se_CreateOptionGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateOptionGroupMessage(input, context),
    [_A]: _COGr,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateOptionGroupCommand");
var se_CreateTenantDatabaseCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_CreateTenantDatabaseMessage(input, context),
    [_A]: _CTD,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_CreateTenantDatabaseCommand");
var se_DeleteBlueGreenDeploymentCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteBlueGreenDeploymentRequest(input, context),
    [_A]: _DBGD,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteBlueGreenDeploymentCommand");
var se_DeleteCustomDBEngineVersionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteCustomDBEngineVersionMessage(input, context),
    [_A]: _DCDBEV,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteCustomDBEngineVersionCommand");
var se_DeleteDBClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteDBClusterMessage(input, context),
    [_A]: _DDBC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteDBClusterCommand");
var se_DeleteDBClusterAutomatedBackupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteDBClusterAutomatedBackupMessage(input, context),
    [_A]: _DDBCAB,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteDBClusterAutomatedBackupCommand");
var se_DeleteDBClusterEndpointCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteDBClusterEndpointMessage(input, context),
    [_A]: _DDBCE,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteDBClusterEndpointCommand");
var se_DeleteDBClusterParameterGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteDBClusterParameterGroupMessage(input, context),
    [_A]: _DDBCPG,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteDBClusterParameterGroupCommand");
var se_DeleteDBClusterSnapshotCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteDBClusterSnapshotMessage(input, context),
    [_A]: _DDBCS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteDBClusterSnapshotCommand");
var se_DeleteDBInstanceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteDBInstanceMessage(input, context),
    [_A]: _DDBI,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteDBInstanceCommand");
var se_DeleteDBInstanceAutomatedBackupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteDBInstanceAutomatedBackupMessage(input, context),
    [_A]: _DDBIAB,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteDBInstanceAutomatedBackupCommand");
var se_DeleteDBParameterGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteDBParameterGroupMessage(input, context),
    [_A]: _DDBPG,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteDBParameterGroupCommand");
var se_DeleteDBProxyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteDBProxyRequest(input, context),
    [_A]: _DDBP,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteDBProxyCommand");
var se_DeleteDBProxyEndpointCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteDBProxyEndpointRequest(input, context),
    [_A]: _DDBPE,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteDBProxyEndpointCommand");
var se_DeleteDBSecurityGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteDBSecurityGroupMessage(input, context),
    [_A]: _DDBSG,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteDBSecurityGroupCommand");
var se_DeleteDBShardGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteDBShardGroupMessage(input, context),
    [_A]: _DDBSGe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteDBShardGroupCommand");
var se_DeleteDBSnapshotCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteDBSnapshotMessage(input, context),
    [_A]: _DDBS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteDBSnapshotCommand");
var se_DeleteDBSubnetGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteDBSubnetGroupMessage(input, context),
    [_A]: _DDBSGel,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteDBSubnetGroupCommand");
var se_DeleteEventSubscriptionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteEventSubscriptionMessage(input, context),
    [_A]: _DES,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteEventSubscriptionCommand");
var se_DeleteGlobalClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteGlobalClusterMessage(input, context),
    [_A]: _DGC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteGlobalClusterCommand");
var se_DeleteIntegrationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteIntegrationMessage(input, context),
    [_A]: _DI,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteIntegrationCommand");
var se_DeleteOptionGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteOptionGroupMessage(input, context),
    [_A]: _DOG,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteOptionGroupCommand");
var se_DeleteTenantDatabaseCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeleteTenantDatabaseMessage(input, context),
    [_A]: _DTD,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeleteTenantDatabaseCommand");
var se_DeregisterDBProxyTargetsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DeregisterDBProxyTargetsRequest(input, context),
    [_A]: _DDBPT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DeregisterDBProxyTargetsCommand");
var se_DescribeAccountAttributesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeAccountAttributesMessage(input, context),
    [_A]: _DAA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeAccountAttributesCommand");
var se_DescribeBlueGreenDeploymentsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeBlueGreenDeploymentsRequest(input, context),
    [_A]: _DBGDe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeBlueGreenDeploymentsCommand");
var se_DescribeCertificatesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeCertificatesMessage(input, context),
    [_A]: _DC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeCertificatesCommand");
var se_DescribeDBClusterAutomatedBackupsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBClusterAutomatedBackupsMessage(input, context),
    [_A]: _DDBCABe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBClusterAutomatedBackupsCommand");
var se_DescribeDBClusterBacktracksCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBClusterBacktracksMessage(input, context),
    [_A]: _DDBCB,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBClusterBacktracksCommand");
var se_DescribeDBClusterEndpointsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBClusterEndpointsMessage(input, context),
    [_A]: _DDBCEe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBClusterEndpointsCommand");
var se_DescribeDBClusterParameterGroupsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBClusterParameterGroupsMessage(input, context),
    [_A]: _DDBCPGe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBClusterParameterGroupsCommand");
var se_DescribeDBClusterParametersCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBClusterParametersMessage(input, context),
    [_A]: _DDBCP,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBClusterParametersCommand");
var se_DescribeDBClustersCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBClustersMessage(input, context),
    [_A]: _DDBCe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBClustersCommand");
var se_DescribeDBClusterSnapshotAttributesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBClusterSnapshotAttributesMessage(input, context),
    [_A]: _DDBCSA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBClusterSnapshotAttributesCommand");
var se_DescribeDBClusterSnapshotsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBClusterSnapshotsMessage(input, context),
    [_A]: _DDBCSe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBClusterSnapshotsCommand");
var se_DescribeDBEngineVersionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBEngineVersionsMessage(input, context),
    [_A]: _DDBEV,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBEngineVersionsCommand");
var se_DescribeDBInstanceAutomatedBackupsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBInstanceAutomatedBackupsMessage(input, context),
    [_A]: _DDBIABe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBInstanceAutomatedBackupsCommand");
var se_DescribeDBInstancesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBInstancesMessage(input, context),
    [_A]: _DDBIe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBInstancesCommand");
var se_DescribeDBLogFilesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBLogFilesMessage(input, context),
    [_A]: _DDBLF,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBLogFilesCommand");
var se_DescribeDBMajorEngineVersionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBMajorEngineVersionsRequest(input, context),
    [_A]: _DDBMEV,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBMajorEngineVersionsCommand");
var se_DescribeDBParameterGroupsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBParameterGroupsMessage(input, context),
    [_A]: _DDBPGe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBParameterGroupsCommand");
var se_DescribeDBParametersCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBParametersMessage(input, context),
    [_A]: _DDBPe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBParametersCommand");
var se_DescribeDBProxiesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBProxiesRequest(input, context),
    [_A]: _DDBPes,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBProxiesCommand");
var se_DescribeDBProxyEndpointsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBProxyEndpointsRequest(input, context),
    [_A]: _DDBPEe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBProxyEndpointsCommand");
var se_DescribeDBProxyTargetGroupsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBProxyTargetGroupsRequest(input, context),
    [_A]: _DDBPTG,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBProxyTargetGroupsCommand");
var se_DescribeDBProxyTargetsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBProxyTargetsRequest(input, context),
    [_A]: _DDBPTe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBProxyTargetsCommand");
var se_DescribeDBRecommendationsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBRecommendationsMessage(input, context),
    [_A]: _DDBR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBRecommendationsCommand");
var se_DescribeDBSecurityGroupsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBSecurityGroupsMessage(input, context),
    [_A]: _DDBSGes,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBSecurityGroupsCommand");
var se_DescribeDBShardGroupsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBShardGroupsMessage(input, context),
    [_A]: _DDBSGesc,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBShardGroupsCommand");
var se_DescribeDBSnapshotAttributesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBSnapshotAttributesMessage(input, context),
    [_A]: _DDBSA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBSnapshotAttributesCommand");
var se_DescribeDBSnapshotsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBSnapshotsMessage(input, context),
    [_A]: _DDBSe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBSnapshotsCommand");
var se_DescribeDBSnapshotTenantDatabasesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBSnapshotTenantDatabasesMessage(input, context),
    [_A]: _DDBSTD,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBSnapshotTenantDatabasesCommand");
var se_DescribeDBSubnetGroupsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeDBSubnetGroupsMessage(input, context),
    [_A]: _DDBSGescr,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeDBSubnetGroupsCommand");
var se_DescribeEngineDefaultClusterParametersCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeEngineDefaultClusterParametersMessage(input, context),
    [_A]: _DEDCP,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeEngineDefaultClusterParametersCommand");
var se_DescribeEngineDefaultParametersCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeEngineDefaultParametersMessage(input, context),
    [_A]: _DEDP,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeEngineDefaultParametersCommand");
var se_DescribeEventCategoriesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeEventCategoriesMessage(input, context),
    [_A]: _DEC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeEventCategoriesCommand");
var se_DescribeEventsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeEventsMessage(input, context),
    [_A]: _DE,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeEventsCommand");
var se_DescribeEventSubscriptionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeEventSubscriptionsMessage(input, context),
    [_A]: _DESe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeEventSubscriptionsCommand");
var se_DescribeExportTasksCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeExportTasksMessage(input, context),
    [_A]: _DET,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeExportTasksCommand");
var se_DescribeGlobalClustersCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeGlobalClustersMessage(input, context),
    [_A]: _DGCe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeGlobalClustersCommand");
var se_DescribeIntegrationsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeIntegrationsMessage(input, context),
    [_A]: _DIe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeIntegrationsCommand");
var se_DescribeOptionGroupOptionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeOptionGroupOptionsMessage(input, context),
    [_A]: _DOGO,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeOptionGroupOptionsCommand");
var se_DescribeOptionGroupsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeOptionGroupsMessage(input, context),
    [_A]: _DOGe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeOptionGroupsCommand");
var se_DescribeOrderableDBInstanceOptionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeOrderableDBInstanceOptionsMessage(input, context),
    [_A]: _DODBIO,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeOrderableDBInstanceOptionsCommand");
var se_DescribePendingMaintenanceActionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribePendingMaintenanceActionsMessage(input, context),
    [_A]: _DPMA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribePendingMaintenanceActionsCommand");
var se_DescribeReservedDBInstancesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeReservedDBInstancesMessage(input, context),
    [_A]: _DRDBI,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeReservedDBInstancesCommand");
var se_DescribeReservedDBInstancesOfferingsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeReservedDBInstancesOfferingsMessage(input, context),
    [_A]: _DRDBIO,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeReservedDBInstancesOfferingsCommand");
var se_DescribeSourceRegionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeSourceRegionsMessage(input, context),
    [_A]: _DSR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeSourceRegionsCommand");
var se_DescribeTenantDatabasesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeTenantDatabasesMessage(input, context),
    [_A]: _DTDe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeTenantDatabasesCommand");
var se_DescribeValidDBInstanceModificationsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DescribeValidDBInstanceModificationsMessage(input, context),
    [_A]: _DVDBIM,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DescribeValidDBInstanceModificationsCommand");
var se_DisableHttpEndpointCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DisableHttpEndpointRequest(input, context),
    [_A]: _DHE,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DisableHttpEndpointCommand");
var se_DownloadDBLogFilePortionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_DownloadDBLogFilePortionMessage(input, context),
    [_A]: _DDBLFP,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_DownloadDBLogFilePortionCommand");
var se_EnableHttpEndpointCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_EnableHttpEndpointRequest(input, context),
    [_A]: _EHE,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_EnableHttpEndpointCommand");
var se_FailoverDBClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_FailoverDBClusterMessage(input, context),
    [_A]: _FDBC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_FailoverDBClusterCommand");
var se_FailoverGlobalClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_FailoverGlobalClusterMessage(input, context),
    [_A]: _FGC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_FailoverGlobalClusterCommand");
var se_ListTagsForResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ListTagsForResourceMessage(input, context),
    [_A]: _LTFR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ListTagsForResourceCommand");
var se_ModifyActivityStreamCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyActivityStreamRequest(input, context),
    [_A]: _MAS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyActivityStreamCommand");
var se_ModifyCertificatesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyCertificatesMessage(input, context),
    [_A]: _MC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyCertificatesCommand");
var se_ModifyCurrentDBClusterCapacityCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyCurrentDBClusterCapacityMessage(input, context),
    [_A]: _MCDBCC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyCurrentDBClusterCapacityCommand");
var se_ModifyCustomDBEngineVersionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyCustomDBEngineVersionMessage(input, context),
    [_A]: _MCDBEV,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyCustomDBEngineVersionCommand");
var se_ModifyDBClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyDBClusterMessage(input, context),
    [_A]: _MDBC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyDBClusterCommand");
var se_ModifyDBClusterEndpointCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyDBClusterEndpointMessage(input, context),
    [_A]: _MDBCE,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyDBClusterEndpointCommand");
var se_ModifyDBClusterParameterGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyDBClusterParameterGroupMessage(input, context),
    [_A]: _MDBCPG,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyDBClusterParameterGroupCommand");
var se_ModifyDBClusterSnapshotAttributeCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyDBClusterSnapshotAttributeMessage(input, context),
    [_A]: _MDBCSA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyDBClusterSnapshotAttributeCommand");
var se_ModifyDBInstanceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyDBInstanceMessage(input, context),
    [_A]: _MDBI,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyDBInstanceCommand");
var se_ModifyDBParameterGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyDBParameterGroupMessage(input, context),
    [_A]: _MDBPG,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyDBParameterGroupCommand");
var se_ModifyDBProxyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyDBProxyRequest(input, context),
    [_A]: _MDBP,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyDBProxyCommand");
var se_ModifyDBProxyEndpointCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyDBProxyEndpointRequest(input, context),
    [_A]: _MDBPE,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyDBProxyEndpointCommand");
var se_ModifyDBProxyTargetGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyDBProxyTargetGroupRequest(input, context),
    [_A]: _MDBPTG,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyDBProxyTargetGroupCommand");
var se_ModifyDBRecommendationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyDBRecommendationMessage(input, context),
    [_A]: _MDBR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyDBRecommendationCommand");
var se_ModifyDBShardGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyDBShardGroupMessage(input, context),
    [_A]: _MDBSG,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyDBShardGroupCommand");
var se_ModifyDBSnapshotCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyDBSnapshotMessage(input, context),
    [_A]: _MDBS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyDBSnapshotCommand");
var se_ModifyDBSnapshotAttributeCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyDBSnapshotAttributeMessage(input, context),
    [_A]: _MDBSA,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyDBSnapshotAttributeCommand");
var se_ModifyDBSubnetGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyDBSubnetGroupMessage(input, context),
    [_A]: _MDBSGo,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyDBSubnetGroupCommand");
var se_ModifyEventSubscriptionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyEventSubscriptionMessage(input, context),
    [_A]: _MES,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyEventSubscriptionCommand");
var se_ModifyGlobalClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyGlobalClusterMessage(input, context),
    [_A]: _MGC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyGlobalClusterCommand");
var se_ModifyIntegrationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyIntegrationMessage(input, context),
    [_A]: _MI,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyIntegrationCommand");
var se_ModifyOptionGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyOptionGroupMessage(input, context),
    [_A]: _MOG,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyOptionGroupCommand");
var se_ModifyTenantDatabaseCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ModifyTenantDatabaseMessage(input, context),
    [_A]: _MTD,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ModifyTenantDatabaseCommand");
var se_PromoteReadReplicaCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_PromoteReadReplicaMessage(input, context),
    [_A]: _PRR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PromoteReadReplicaCommand");
var se_PromoteReadReplicaDBClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_PromoteReadReplicaDBClusterMessage(input, context),
    [_A]: _PRRDBC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PromoteReadReplicaDBClusterCommand");
var se_PurchaseReservedDBInstancesOfferingCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_PurchaseReservedDBInstancesOfferingMessage(input, context),
    [_A]: _PRDBIO,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_PurchaseReservedDBInstancesOfferingCommand");
var se_RebootDBClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_RebootDBClusterMessage(input, context),
    [_A]: _RDBC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RebootDBClusterCommand");
var se_RebootDBInstanceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_RebootDBInstanceMessage(input, context),
    [_A]: _RDBI,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RebootDBInstanceCommand");
var se_RebootDBShardGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_RebootDBShardGroupMessage(input, context),
    [_A]: _RDBSG,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RebootDBShardGroupCommand");
var se_RegisterDBProxyTargetsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_RegisterDBProxyTargetsRequest(input, context),
    [_A]: _RDBPT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RegisterDBProxyTargetsCommand");
var se_RemoveFromGlobalClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_RemoveFromGlobalClusterMessage(input, context),
    [_A]: _RFGC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RemoveFromGlobalClusterCommand");
var se_RemoveRoleFromDBClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_RemoveRoleFromDBClusterMessage(input, context),
    [_A]: _RRFDBC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RemoveRoleFromDBClusterCommand");
var se_RemoveRoleFromDBInstanceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_RemoveRoleFromDBInstanceMessage(input, context),
    [_A]: _RRFDBI,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RemoveRoleFromDBInstanceCommand");
var se_RemoveSourceIdentifierFromSubscriptionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_RemoveSourceIdentifierFromSubscriptionMessage(input, context),
    [_A]: _RSIFS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RemoveSourceIdentifierFromSubscriptionCommand");
var se_RemoveTagsFromResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_RemoveTagsFromResourceMessage(input, context),
    [_A]: _RTFR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RemoveTagsFromResourceCommand");
var se_ResetDBClusterParameterGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ResetDBClusterParameterGroupMessage(input, context),
    [_A]: _RDBCPG,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ResetDBClusterParameterGroupCommand");
var se_ResetDBParameterGroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_ResetDBParameterGroupMessage(input, context),
    [_A]: _RDBPG,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_ResetDBParameterGroupCommand");
var se_RestoreDBClusterFromS3Command = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_RestoreDBClusterFromS3Message(input, context),
    [_A]: _RDBCFS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RestoreDBClusterFromS3Command");
var se_RestoreDBClusterFromSnapshotCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_RestoreDBClusterFromSnapshotMessage(input, context),
    [_A]: _RDBCFSe,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RestoreDBClusterFromSnapshotCommand");
var se_RestoreDBClusterToPointInTimeCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_RestoreDBClusterToPointInTimeMessage(input, context),
    [_A]: _RDBCTPIT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RestoreDBClusterToPointInTimeCommand");
var se_RestoreDBInstanceFromDBSnapshotCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_RestoreDBInstanceFromDBSnapshotMessage(input, context),
    [_A]: _RDBIFDBS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RestoreDBInstanceFromDBSnapshotCommand");
var se_RestoreDBInstanceFromS3Command = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_RestoreDBInstanceFromS3Message(input, context),
    [_A]: _RDBIFS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RestoreDBInstanceFromS3Command");
var se_RestoreDBInstanceToPointInTimeCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_RestoreDBInstanceToPointInTimeMessage(input, context),
    [_A]: _RDBITPIT,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RestoreDBInstanceToPointInTimeCommand");
var se_RevokeDBSecurityGroupIngressCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_RevokeDBSecurityGroupIngressMessage(input, context),
    [_A]: _RDBSGI,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_RevokeDBSecurityGroupIngressCommand");
var se_StartActivityStreamCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_StartActivityStreamRequest(input, context),
    [_A]: _SAS,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StartActivityStreamCommand");
var se_StartDBClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_StartDBClusterMessage(input, context),
    [_A]: _SDBC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StartDBClusterCommand");
var se_StartDBInstanceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_StartDBInstanceMessage(input, context),
    [_A]: _SDBI,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StartDBInstanceCommand");
var se_StartDBInstanceAutomatedBackupsReplicationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_StartDBInstanceAutomatedBackupsReplicationMessage(input, context),
    [_A]: _SDBIABR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StartDBInstanceAutomatedBackupsReplicationCommand");
var se_StartExportTaskCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_StartExportTaskMessage(input, context),
    [_A]: _SET,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StartExportTaskCommand");
var se_StopActivityStreamCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_StopActivityStreamRequest(input, context),
    [_A]: _SASt,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StopActivityStreamCommand");
var se_StopDBClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_StopDBClusterMessage(input, context),
    [_A]: _SDBCt,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StopDBClusterCommand");
var se_StopDBInstanceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_StopDBInstanceMessage(input, context),
    [_A]: _SDBIt,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StopDBInstanceCommand");
var se_StopDBInstanceAutomatedBackupsReplicationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_StopDBInstanceAutomatedBackupsReplicationMessage(input, context),
    [_A]: _SDBIABRt,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_StopDBInstanceAutomatedBackupsReplicationCommand");
var se_SwitchoverBlueGreenDeploymentCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_SwitchoverBlueGreenDeploymentRequest(input, context),
    [_A]: _SBGD,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SwitchoverBlueGreenDeploymentCommand");
var se_SwitchoverGlobalClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_SwitchoverGlobalClusterMessage(input, context),
    [_A]: _SGC,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SwitchoverGlobalClusterCommand");
var se_SwitchoverReadReplicaCommand = /* @__PURE__ */ __name(async (input, context) => {
  const headers = SHARED_HEADERS;
  let body;
  body = buildFormUrlencodedString({
    ...se_SwitchoverReadReplicaMessage(input, context),
    [_A]: _SRR,
    [_V]: _
  });
  return buildHttpRpcRequest(context, headers, "/", void 0, body);
}, "se_SwitchoverReadReplicaCommand");
var de_AddRoleToDBClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_AddRoleToDBClusterCommand");
var de_AddRoleToDBInstanceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_AddRoleToDBInstanceCommand");
var de_AddSourceIdentifierToSubscriptionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_AddSourceIdentifierToSubscriptionResult(data.AddSourceIdentifierToSubscriptionResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_AddSourceIdentifierToSubscriptionCommand");
var de_AddTagsToResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_AddTagsToResourceCommand");
var de_ApplyPendingMaintenanceActionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ApplyPendingMaintenanceActionResult(data.ApplyPendingMaintenanceActionResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ApplyPendingMaintenanceActionCommand");
var de_AuthorizeDBSecurityGroupIngressCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_AuthorizeDBSecurityGroupIngressResult(data.AuthorizeDBSecurityGroupIngressResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_AuthorizeDBSecurityGroupIngressCommand");
var de_BacktrackDBClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBClusterBacktrack(data.BacktrackDBClusterResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_BacktrackDBClusterCommand");
var de_CancelExportTaskCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ExportTask(data.CancelExportTaskResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CancelExportTaskCommand");
var de_CopyDBClusterParameterGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CopyDBClusterParameterGroupResult(data.CopyDBClusterParameterGroupResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CopyDBClusterParameterGroupCommand");
var de_CopyDBClusterSnapshotCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CopyDBClusterSnapshotResult(data.CopyDBClusterSnapshotResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CopyDBClusterSnapshotCommand");
var de_CopyDBParameterGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CopyDBParameterGroupResult(data.CopyDBParameterGroupResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CopyDBParameterGroupCommand");
var de_CopyDBSnapshotCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CopyDBSnapshotResult(data.CopyDBSnapshotResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CopyDBSnapshotCommand");
var de_CopyOptionGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CopyOptionGroupResult(data.CopyOptionGroupResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CopyOptionGroupCommand");
var de_CreateBlueGreenDeploymentCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateBlueGreenDeploymentResponse(data.CreateBlueGreenDeploymentResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateBlueGreenDeploymentCommand");
var de_CreateCustomDBEngineVersionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBEngineVersion(data.CreateCustomDBEngineVersionResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateCustomDBEngineVersionCommand");
var de_CreateDBClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateDBClusterResult(data.CreateDBClusterResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateDBClusterCommand");
var de_CreateDBClusterEndpointCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBClusterEndpoint(data.CreateDBClusterEndpointResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateDBClusterEndpointCommand");
var de_CreateDBClusterParameterGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateDBClusterParameterGroupResult(data.CreateDBClusterParameterGroupResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateDBClusterParameterGroupCommand");
var de_CreateDBClusterSnapshotCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateDBClusterSnapshotResult(data.CreateDBClusterSnapshotResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateDBClusterSnapshotCommand");
var de_CreateDBInstanceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateDBInstanceResult(data.CreateDBInstanceResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateDBInstanceCommand");
var de_CreateDBInstanceReadReplicaCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateDBInstanceReadReplicaResult(data.CreateDBInstanceReadReplicaResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateDBInstanceReadReplicaCommand");
var de_CreateDBParameterGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateDBParameterGroupResult(data.CreateDBParameterGroupResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateDBParameterGroupCommand");
var de_CreateDBProxyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateDBProxyResponse(data.CreateDBProxyResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateDBProxyCommand");
var de_CreateDBProxyEndpointCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateDBProxyEndpointResponse(data.CreateDBProxyEndpointResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateDBProxyEndpointCommand");
var de_CreateDBSecurityGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateDBSecurityGroupResult(data.CreateDBSecurityGroupResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateDBSecurityGroupCommand");
var de_CreateDBShardGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBShardGroup(data.CreateDBShardGroupResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateDBShardGroupCommand");
var de_CreateDBSnapshotCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateDBSnapshotResult(data.CreateDBSnapshotResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateDBSnapshotCommand");
var de_CreateDBSubnetGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateDBSubnetGroupResult(data.CreateDBSubnetGroupResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateDBSubnetGroupCommand");
var de_CreateEventSubscriptionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateEventSubscriptionResult(data.CreateEventSubscriptionResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateEventSubscriptionCommand");
var de_CreateGlobalClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateGlobalClusterResult(data.CreateGlobalClusterResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateGlobalClusterCommand");
var de_CreateIntegrationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_Integration(data.CreateIntegrationResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateIntegrationCommand");
var de_CreateOptionGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateOptionGroupResult(data.CreateOptionGroupResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateOptionGroupCommand");
var de_CreateTenantDatabaseCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CreateTenantDatabaseResult(data.CreateTenantDatabaseResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_CreateTenantDatabaseCommand");
var de_DeleteBlueGreenDeploymentCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DeleteBlueGreenDeploymentResponse(data.DeleteBlueGreenDeploymentResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteBlueGreenDeploymentCommand");
var de_DeleteCustomDBEngineVersionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBEngineVersion(data.DeleteCustomDBEngineVersionResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteCustomDBEngineVersionCommand");
var de_DeleteDBClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DeleteDBClusterResult(data.DeleteDBClusterResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteDBClusterCommand");
var de_DeleteDBClusterAutomatedBackupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DeleteDBClusterAutomatedBackupResult(data.DeleteDBClusterAutomatedBackupResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteDBClusterAutomatedBackupCommand");
var de_DeleteDBClusterEndpointCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBClusterEndpoint(data.DeleteDBClusterEndpointResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteDBClusterEndpointCommand");
var de_DeleteDBClusterParameterGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_DeleteDBClusterParameterGroupCommand");
var de_DeleteDBClusterSnapshotCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DeleteDBClusterSnapshotResult(data.DeleteDBClusterSnapshotResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteDBClusterSnapshotCommand");
var de_DeleteDBInstanceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DeleteDBInstanceResult(data.DeleteDBInstanceResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteDBInstanceCommand");
var de_DeleteDBInstanceAutomatedBackupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DeleteDBInstanceAutomatedBackupResult(data.DeleteDBInstanceAutomatedBackupResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteDBInstanceAutomatedBackupCommand");
var de_DeleteDBParameterGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_DeleteDBParameterGroupCommand");
var de_DeleteDBProxyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DeleteDBProxyResponse(data.DeleteDBProxyResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteDBProxyCommand");
var de_DeleteDBProxyEndpointCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DeleteDBProxyEndpointResponse(data.DeleteDBProxyEndpointResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteDBProxyEndpointCommand");
var de_DeleteDBSecurityGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_DeleteDBSecurityGroupCommand");
var de_DeleteDBShardGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBShardGroup(data.DeleteDBShardGroupResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteDBShardGroupCommand");
var de_DeleteDBSnapshotCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DeleteDBSnapshotResult(data.DeleteDBSnapshotResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteDBSnapshotCommand");
var de_DeleteDBSubnetGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_DeleteDBSubnetGroupCommand");
var de_DeleteEventSubscriptionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DeleteEventSubscriptionResult(data.DeleteEventSubscriptionResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteEventSubscriptionCommand");
var de_DeleteGlobalClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DeleteGlobalClusterResult(data.DeleteGlobalClusterResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteGlobalClusterCommand");
var de_DeleteIntegrationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_Integration(data.DeleteIntegrationResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteIntegrationCommand");
var de_DeleteOptionGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_DeleteOptionGroupCommand");
var de_DeleteTenantDatabaseCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DeleteTenantDatabaseResult(data.DeleteTenantDatabaseResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeleteTenantDatabaseCommand");
var de_DeregisterDBProxyTargetsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DeregisterDBProxyTargetsResponse(data.DeregisterDBProxyTargetsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DeregisterDBProxyTargetsCommand");
var de_DescribeAccountAttributesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_AccountAttributesMessage(data.DescribeAccountAttributesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeAccountAttributesCommand");
var de_DescribeBlueGreenDeploymentsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeBlueGreenDeploymentsResponse(data.DescribeBlueGreenDeploymentsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeBlueGreenDeploymentsCommand");
var de_DescribeCertificatesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_CertificateMessage(data.DescribeCertificatesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeCertificatesCommand");
var de_DescribeDBClusterAutomatedBackupsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBClusterAutomatedBackupMessage(data.DescribeDBClusterAutomatedBackupsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBClusterAutomatedBackupsCommand");
var de_DescribeDBClusterBacktracksCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBClusterBacktrackMessage(data.DescribeDBClusterBacktracksResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBClusterBacktracksCommand");
var de_DescribeDBClusterEndpointsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBClusterEndpointMessage(data.DescribeDBClusterEndpointsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBClusterEndpointsCommand");
var de_DescribeDBClusterParameterGroupsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBClusterParameterGroupsMessage(data.DescribeDBClusterParameterGroupsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBClusterParameterGroupsCommand");
var de_DescribeDBClusterParametersCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBClusterParameterGroupDetails(data.DescribeDBClusterParametersResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBClusterParametersCommand");
var de_DescribeDBClustersCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBClusterMessage(data.DescribeDBClustersResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBClustersCommand");
var de_DescribeDBClusterSnapshotAttributesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeDBClusterSnapshotAttributesResult(data.DescribeDBClusterSnapshotAttributesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBClusterSnapshotAttributesCommand");
var de_DescribeDBClusterSnapshotsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBClusterSnapshotMessage(data.DescribeDBClusterSnapshotsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBClusterSnapshotsCommand");
var de_DescribeDBEngineVersionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBEngineVersionMessage(data.DescribeDBEngineVersionsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBEngineVersionsCommand");
var de_DescribeDBInstanceAutomatedBackupsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBInstanceAutomatedBackupMessage(data.DescribeDBInstanceAutomatedBackupsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBInstanceAutomatedBackupsCommand");
var de_DescribeDBInstancesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBInstanceMessage(data.DescribeDBInstancesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBInstancesCommand");
var de_DescribeDBLogFilesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeDBLogFilesResponse(data.DescribeDBLogFilesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBLogFilesCommand");
var de_DescribeDBMajorEngineVersionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeDBMajorEngineVersionsResponse(data.DescribeDBMajorEngineVersionsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBMajorEngineVersionsCommand");
var de_DescribeDBParameterGroupsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBParameterGroupsMessage(data.DescribeDBParameterGroupsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBParameterGroupsCommand");
var de_DescribeDBParametersCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBParameterGroupDetails(data.DescribeDBParametersResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBParametersCommand");
var de_DescribeDBProxiesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeDBProxiesResponse(data.DescribeDBProxiesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBProxiesCommand");
var de_DescribeDBProxyEndpointsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeDBProxyEndpointsResponse(data.DescribeDBProxyEndpointsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBProxyEndpointsCommand");
var de_DescribeDBProxyTargetGroupsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeDBProxyTargetGroupsResponse(data.DescribeDBProxyTargetGroupsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBProxyTargetGroupsCommand");
var de_DescribeDBProxyTargetsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeDBProxyTargetsResponse(data.DescribeDBProxyTargetsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBProxyTargetsCommand");
var de_DescribeDBRecommendationsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBRecommendationsMessage(data.DescribeDBRecommendationsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBRecommendationsCommand");
var de_DescribeDBSecurityGroupsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBSecurityGroupMessage(data.DescribeDBSecurityGroupsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBSecurityGroupsCommand");
var de_DescribeDBShardGroupsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeDBShardGroupsResponse(data.DescribeDBShardGroupsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBShardGroupsCommand");
var de_DescribeDBSnapshotAttributesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeDBSnapshotAttributesResult(data.DescribeDBSnapshotAttributesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBSnapshotAttributesCommand");
var de_DescribeDBSnapshotsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBSnapshotMessage(data.DescribeDBSnapshotsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBSnapshotsCommand");
var de_DescribeDBSnapshotTenantDatabasesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBSnapshotTenantDatabasesMessage(data.DescribeDBSnapshotTenantDatabasesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBSnapshotTenantDatabasesCommand");
var de_DescribeDBSubnetGroupsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBSubnetGroupMessage(data.DescribeDBSubnetGroupsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeDBSubnetGroupsCommand");
var de_DescribeEngineDefaultClusterParametersCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeEngineDefaultClusterParametersResult(
    data.DescribeEngineDefaultClusterParametersResult,
    context
  );
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeEngineDefaultClusterParametersCommand");
var de_DescribeEngineDefaultParametersCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeEngineDefaultParametersResult(data.DescribeEngineDefaultParametersResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeEngineDefaultParametersCommand");
var de_DescribeEventCategoriesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_EventCategoriesMessage(data.DescribeEventCategoriesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeEventCategoriesCommand");
var de_DescribeEventsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_EventsMessage(data.DescribeEventsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeEventsCommand");
var de_DescribeEventSubscriptionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_EventSubscriptionsMessage(data.DescribeEventSubscriptionsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeEventSubscriptionsCommand");
var de_DescribeExportTasksCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ExportTasksMessage(data.DescribeExportTasksResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeExportTasksCommand");
var de_DescribeGlobalClustersCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_GlobalClustersMessage(data.DescribeGlobalClustersResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeGlobalClustersCommand");
var de_DescribeIntegrationsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeIntegrationsResponse(data.DescribeIntegrationsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeIntegrationsCommand");
var de_DescribeOptionGroupOptionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_OptionGroupOptionsMessage(data.DescribeOptionGroupOptionsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeOptionGroupOptionsCommand");
var de_DescribeOptionGroupsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_OptionGroups(data.DescribeOptionGroupsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeOptionGroupsCommand");
var de_DescribeOrderableDBInstanceOptionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_OrderableDBInstanceOptionsMessage(data.DescribeOrderableDBInstanceOptionsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeOrderableDBInstanceOptionsCommand");
var de_DescribePendingMaintenanceActionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_PendingMaintenanceActionsMessage(data.DescribePendingMaintenanceActionsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribePendingMaintenanceActionsCommand");
var de_DescribeReservedDBInstancesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ReservedDBInstanceMessage(data.DescribeReservedDBInstancesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeReservedDBInstancesCommand");
var de_DescribeReservedDBInstancesOfferingsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ReservedDBInstancesOfferingMessage(data.DescribeReservedDBInstancesOfferingsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeReservedDBInstancesOfferingsCommand");
var de_DescribeSourceRegionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_SourceRegionMessage(data.DescribeSourceRegionsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeSourceRegionsCommand");
var de_DescribeTenantDatabasesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_TenantDatabasesMessage(data.DescribeTenantDatabasesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeTenantDatabasesCommand");
var de_DescribeValidDBInstanceModificationsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DescribeValidDBInstanceModificationsResult(data.DescribeValidDBInstanceModificationsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DescribeValidDBInstanceModificationsCommand");
var de_DisableHttpEndpointCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DisableHttpEndpointResponse(data.DisableHttpEndpointResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DisableHttpEndpointCommand");
var de_DownloadDBLogFilePortionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DownloadDBLogFilePortionDetails(data.DownloadDBLogFilePortionResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_DownloadDBLogFilePortionCommand");
var de_EnableHttpEndpointCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_EnableHttpEndpointResponse(data.EnableHttpEndpointResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_EnableHttpEndpointCommand");
var de_FailoverDBClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_FailoverDBClusterResult(data.FailoverDBClusterResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_FailoverDBClusterCommand");
var de_FailoverGlobalClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_FailoverGlobalClusterResult(data.FailoverGlobalClusterResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_FailoverGlobalClusterCommand");
var de_ListTagsForResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_TagListMessage(data.ListTagsForResourceResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ListTagsForResourceCommand");
var de_ModifyActivityStreamCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ModifyActivityStreamResponse(data.ModifyActivityStreamResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyActivityStreamCommand");
var de_ModifyCertificatesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ModifyCertificatesResult(data.ModifyCertificatesResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyCertificatesCommand");
var de_ModifyCurrentDBClusterCapacityCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBClusterCapacityInfo(data.ModifyCurrentDBClusterCapacityResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyCurrentDBClusterCapacityCommand");
var de_ModifyCustomDBEngineVersionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBEngineVersion(data.ModifyCustomDBEngineVersionResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyCustomDBEngineVersionCommand");
var de_ModifyDBClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ModifyDBClusterResult(data.ModifyDBClusterResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyDBClusterCommand");
var de_ModifyDBClusterEndpointCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBClusterEndpoint(data.ModifyDBClusterEndpointResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyDBClusterEndpointCommand");
var de_ModifyDBClusterParameterGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBClusterParameterGroupNameMessage(data.ModifyDBClusterParameterGroupResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyDBClusterParameterGroupCommand");
var de_ModifyDBClusterSnapshotAttributeCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ModifyDBClusterSnapshotAttributeResult(data.ModifyDBClusterSnapshotAttributeResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyDBClusterSnapshotAttributeCommand");
var de_ModifyDBInstanceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ModifyDBInstanceResult(data.ModifyDBInstanceResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyDBInstanceCommand");
var de_ModifyDBParameterGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBParameterGroupNameMessage(data.ModifyDBParameterGroupResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyDBParameterGroupCommand");
var de_ModifyDBProxyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ModifyDBProxyResponse(data.ModifyDBProxyResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyDBProxyCommand");
var de_ModifyDBProxyEndpointCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ModifyDBProxyEndpointResponse(data.ModifyDBProxyEndpointResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyDBProxyEndpointCommand");
var de_ModifyDBProxyTargetGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ModifyDBProxyTargetGroupResponse(data.ModifyDBProxyTargetGroupResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyDBProxyTargetGroupCommand");
var de_ModifyDBRecommendationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBRecommendationMessage(data.ModifyDBRecommendationResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyDBRecommendationCommand");
var de_ModifyDBShardGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBShardGroup(data.ModifyDBShardGroupResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyDBShardGroupCommand");
var de_ModifyDBSnapshotCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ModifyDBSnapshotResult(data.ModifyDBSnapshotResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyDBSnapshotCommand");
var de_ModifyDBSnapshotAttributeCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ModifyDBSnapshotAttributeResult(data.ModifyDBSnapshotAttributeResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyDBSnapshotAttributeCommand");
var de_ModifyDBSubnetGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ModifyDBSubnetGroupResult(data.ModifyDBSubnetGroupResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyDBSubnetGroupCommand");
var de_ModifyEventSubscriptionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ModifyEventSubscriptionResult(data.ModifyEventSubscriptionResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyEventSubscriptionCommand");
var de_ModifyGlobalClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ModifyGlobalClusterResult(data.ModifyGlobalClusterResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyGlobalClusterCommand");
var de_ModifyIntegrationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_Integration(data.ModifyIntegrationResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyIntegrationCommand");
var de_ModifyOptionGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ModifyOptionGroupResult(data.ModifyOptionGroupResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyOptionGroupCommand");
var de_ModifyTenantDatabaseCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ModifyTenantDatabaseResult(data.ModifyTenantDatabaseResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ModifyTenantDatabaseCommand");
var de_PromoteReadReplicaCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_PromoteReadReplicaResult(data.PromoteReadReplicaResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PromoteReadReplicaCommand");
var de_PromoteReadReplicaDBClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_PromoteReadReplicaDBClusterResult(data.PromoteReadReplicaDBClusterResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PromoteReadReplicaDBClusterCommand");
var de_PurchaseReservedDBInstancesOfferingCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_PurchaseReservedDBInstancesOfferingResult(data.PurchaseReservedDBInstancesOfferingResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_PurchaseReservedDBInstancesOfferingCommand");
var de_RebootDBClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_RebootDBClusterResult(data.RebootDBClusterResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RebootDBClusterCommand");
var de_RebootDBInstanceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_RebootDBInstanceResult(data.RebootDBInstanceResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RebootDBInstanceCommand");
var de_RebootDBShardGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBShardGroup(data.RebootDBShardGroupResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RebootDBShardGroupCommand");
var de_RegisterDBProxyTargetsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_RegisterDBProxyTargetsResponse(data.RegisterDBProxyTargetsResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RegisterDBProxyTargetsCommand");
var de_RemoveFromGlobalClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_RemoveFromGlobalClusterResult(data.RemoveFromGlobalClusterResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RemoveFromGlobalClusterCommand");
var de_RemoveRoleFromDBClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_RemoveRoleFromDBClusterCommand");
var de_RemoveRoleFromDBInstanceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_RemoveRoleFromDBInstanceCommand");
var de_RemoveSourceIdentifierFromSubscriptionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_RemoveSourceIdentifierFromSubscriptionResult(
    data.RemoveSourceIdentifierFromSubscriptionResult,
    context
  );
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RemoveSourceIdentifierFromSubscriptionCommand");
var de_RemoveTagsFromResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  await (0, import_smithy_client.collectBody)(output.body, context);
  const response = {
    $metadata: deserializeMetadata(output)
  };
  return response;
}, "de_RemoveTagsFromResourceCommand");
var de_ResetDBClusterParameterGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBClusterParameterGroupNameMessage(data.ResetDBClusterParameterGroupResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ResetDBClusterParameterGroupCommand");
var de_ResetDBParameterGroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_DBParameterGroupNameMessage(data.ResetDBParameterGroupResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_ResetDBParameterGroupCommand");
var de_RestoreDBClusterFromS3Command = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_RestoreDBClusterFromS3Result(data.RestoreDBClusterFromS3Result, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RestoreDBClusterFromS3Command");
var de_RestoreDBClusterFromSnapshotCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_RestoreDBClusterFromSnapshotResult(data.RestoreDBClusterFromSnapshotResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RestoreDBClusterFromSnapshotCommand");
var de_RestoreDBClusterToPointInTimeCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_RestoreDBClusterToPointInTimeResult(data.RestoreDBClusterToPointInTimeResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RestoreDBClusterToPointInTimeCommand");
var de_RestoreDBInstanceFromDBSnapshotCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_RestoreDBInstanceFromDBSnapshotResult(data.RestoreDBInstanceFromDBSnapshotResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RestoreDBInstanceFromDBSnapshotCommand");
var de_RestoreDBInstanceFromS3Command = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_RestoreDBInstanceFromS3Result(data.RestoreDBInstanceFromS3Result, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RestoreDBInstanceFromS3Command");
var de_RestoreDBInstanceToPointInTimeCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_RestoreDBInstanceToPointInTimeResult(data.RestoreDBInstanceToPointInTimeResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RestoreDBInstanceToPointInTimeCommand");
var de_RevokeDBSecurityGroupIngressCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_RevokeDBSecurityGroupIngressResult(data.RevokeDBSecurityGroupIngressResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_RevokeDBSecurityGroupIngressCommand");
var de_StartActivityStreamCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_StartActivityStreamResponse(data.StartActivityStreamResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StartActivityStreamCommand");
var de_StartDBClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_StartDBClusterResult(data.StartDBClusterResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StartDBClusterCommand");
var de_StartDBInstanceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_StartDBInstanceResult(data.StartDBInstanceResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StartDBInstanceCommand");
var de_StartDBInstanceAutomatedBackupsReplicationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_StartDBInstanceAutomatedBackupsReplicationResult(
    data.StartDBInstanceAutomatedBackupsReplicationResult,
    context
  );
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StartDBInstanceAutomatedBackupsReplicationCommand");
var de_StartExportTaskCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_ExportTask(data.StartExportTaskResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StartExportTaskCommand");
var de_StopActivityStreamCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_StopActivityStreamResponse(data.StopActivityStreamResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StopActivityStreamCommand");
var de_StopDBClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_StopDBClusterResult(data.StopDBClusterResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StopDBClusterCommand");
var de_StopDBInstanceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_StopDBInstanceResult(data.StopDBInstanceResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StopDBInstanceCommand");
var de_StopDBInstanceAutomatedBackupsReplicationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_StopDBInstanceAutomatedBackupsReplicationResult(
    data.StopDBInstanceAutomatedBackupsReplicationResult,
    context
  );
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_StopDBInstanceAutomatedBackupsReplicationCommand");
var de_SwitchoverBlueGreenDeploymentCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_SwitchoverBlueGreenDeploymentResponse(data.SwitchoverBlueGreenDeploymentResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_SwitchoverBlueGreenDeploymentCommand");
var de_SwitchoverGlobalClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_SwitchoverGlobalClusterResult(data.SwitchoverGlobalClusterResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_SwitchoverGlobalClusterCommand");
var de_SwitchoverReadReplicaCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const data = await (0, import_core2.parseXmlBody)(output.body, context);
  let contents = {};
  contents = de_SwitchoverReadReplicaResult(data.SwitchoverReadReplicaResult, context);
  const response = {
    $metadata: deserializeMetadata(output),
    ...contents
  };
  return response;
}, "de_SwitchoverReadReplicaCommand");
var de_CommandError = /* @__PURE__ */ __name(async (output, context) => {
  const parsedOutput = {
    ...output,
    body: await (0, import_core2.parseXmlErrorBody)(output.body, context)
  };
  const errorCode = loadQueryErrorCode(output, parsedOutput.body);
  switch (errorCode) {
    case "DBClusterNotFoundFault":
    case "com.amazonaws.rds#DBClusterNotFoundFault":
      throw await de_DBClusterNotFoundFaultRes(parsedOutput, context);
    case "DBClusterRoleAlreadyExists":
    case "com.amazonaws.rds#DBClusterRoleAlreadyExistsFault":
      throw await de_DBClusterRoleAlreadyExistsFaultRes(parsedOutput, context);
    case "DBClusterRoleQuotaExceeded":
    case "com.amazonaws.rds#DBClusterRoleQuotaExceededFault":
      throw await de_DBClusterRoleQuotaExceededFaultRes(parsedOutput, context);
    case "InvalidDBClusterStateFault":
    case "com.amazonaws.rds#InvalidDBClusterStateFault":
      throw await de_InvalidDBClusterStateFaultRes(parsedOutput, context);
    case "DBInstanceNotFound":
    case "com.amazonaws.rds#DBInstanceNotFoundFault":
      throw await de_DBInstanceNotFoundFaultRes(parsedOutput, context);
    case "DBInstanceRoleAlreadyExists":
    case "com.amazonaws.rds#DBInstanceRoleAlreadyExistsFault":
      throw await de_DBInstanceRoleAlreadyExistsFaultRes(parsedOutput, context);
    case "DBInstanceRoleQuotaExceeded":
    case "com.amazonaws.rds#DBInstanceRoleQuotaExceededFault":
      throw await de_DBInstanceRoleQuotaExceededFaultRes(parsedOutput, context);
    case "InvalidDBInstanceState":
    case "com.amazonaws.rds#InvalidDBInstanceStateFault":
      throw await de_InvalidDBInstanceStateFaultRes(parsedOutput, context);
    case "SourceNotFound":
    case "com.amazonaws.rds#SourceNotFoundFault":
      throw await de_SourceNotFoundFaultRes(parsedOutput, context);
    case "SubscriptionNotFound":
    case "com.amazonaws.rds#SubscriptionNotFoundFault":
      throw await de_SubscriptionNotFoundFaultRes(parsedOutput, context);
    case "BlueGreenDeploymentNotFoundFault":
    case "com.amazonaws.rds#BlueGreenDeploymentNotFoundFault":
      throw await de_BlueGreenDeploymentNotFoundFaultRes(parsedOutput, context);
    case "DBProxyNotFoundFault":
    case "com.amazonaws.rds#DBProxyNotFoundFault":
      throw await de_DBProxyNotFoundFaultRes(parsedOutput, context);
    case "DBProxyTargetGroupNotFoundFault":
    case "com.amazonaws.rds#DBProxyTargetGroupNotFoundFault":
      throw await de_DBProxyTargetGroupNotFoundFaultRes(parsedOutput, context);
    case "DBSnapshotNotFound":
    case "com.amazonaws.rds#DBSnapshotNotFoundFault":
      throw await de_DBSnapshotNotFoundFaultRes(parsedOutput, context);
    case "DBSnapshotTenantDatabaseNotFoundFault":
    case "com.amazonaws.rds#DBSnapshotTenantDatabaseNotFoundFault":
      throw await de_DBSnapshotTenantDatabaseNotFoundFaultRes(parsedOutput, context);
    case "IntegrationNotFoundFault":
    case "com.amazonaws.rds#IntegrationNotFoundFault":
      throw await de_IntegrationNotFoundFaultRes(parsedOutput, context);
    case "TenantDatabaseNotFound":
    case "com.amazonaws.rds#TenantDatabaseNotFoundFault":
      throw await de_TenantDatabaseNotFoundFaultRes(parsedOutput, context);
    case "ResourceNotFoundFault":
    case "com.amazonaws.rds#ResourceNotFoundFault":
      throw await de_ResourceNotFoundFaultRes(parsedOutput, context);
    case "AuthorizationAlreadyExists":
    case "com.amazonaws.rds#AuthorizationAlreadyExistsFault":
      throw await de_AuthorizationAlreadyExistsFaultRes(parsedOutput, context);
    case "AuthorizationQuotaExceeded":
    case "com.amazonaws.rds#AuthorizationQuotaExceededFault":
      throw await de_AuthorizationQuotaExceededFaultRes(parsedOutput, context);
    case "DBSecurityGroupNotFound":
    case "com.amazonaws.rds#DBSecurityGroupNotFoundFault":
      throw await de_DBSecurityGroupNotFoundFaultRes(parsedOutput, context);
    case "InvalidDBSecurityGroupState":
    case "com.amazonaws.rds#InvalidDBSecurityGroupStateFault":
      throw await de_InvalidDBSecurityGroupStateFaultRes(parsedOutput, context);
    case "ExportTaskNotFound":
    case "com.amazonaws.rds#ExportTaskNotFoundFault":
      throw await de_ExportTaskNotFoundFaultRes(parsedOutput, context);
    case "InvalidExportTaskStateFault":
    case "com.amazonaws.rds#InvalidExportTaskStateFault":
      throw await de_InvalidExportTaskStateFaultRes(parsedOutput, context);
    case "DBParameterGroupAlreadyExists":
    case "com.amazonaws.rds#DBParameterGroupAlreadyExistsFault":
      throw await de_DBParameterGroupAlreadyExistsFaultRes(parsedOutput, context);
    case "DBParameterGroupNotFound":
    case "com.amazonaws.rds#DBParameterGroupNotFoundFault":
      throw await de_DBParameterGroupNotFoundFaultRes(parsedOutput, context);
    case "DBParameterGroupQuotaExceeded":
    case "com.amazonaws.rds#DBParameterGroupQuotaExceededFault":
      throw await de_DBParameterGroupQuotaExceededFaultRes(parsedOutput, context);
    case "DBClusterSnapshotAlreadyExistsFault":
    case "com.amazonaws.rds#DBClusterSnapshotAlreadyExistsFault":
      throw await de_DBClusterSnapshotAlreadyExistsFaultRes(parsedOutput, context);
    case "DBClusterSnapshotNotFoundFault":
    case "com.amazonaws.rds#DBClusterSnapshotNotFoundFault":
      throw await de_DBClusterSnapshotNotFoundFaultRes(parsedOutput, context);
    case "InvalidDBClusterSnapshotStateFault":
    case "com.amazonaws.rds#InvalidDBClusterSnapshotStateFault":
      throw await de_InvalidDBClusterSnapshotStateFaultRes(parsedOutput, context);
    case "KMSKeyNotAccessibleFault":
    case "com.amazonaws.rds#KMSKeyNotAccessibleFault":
      throw await de_KMSKeyNotAccessibleFaultRes(parsedOutput, context);
    case "SnapshotQuotaExceeded":
    case "com.amazonaws.rds#SnapshotQuotaExceededFault":
      throw await de_SnapshotQuotaExceededFaultRes(parsedOutput, context);
    case "CustomAvailabilityZoneNotFound":
    case "com.amazonaws.rds#CustomAvailabilityZoneNotFoundFault":
      throw await de_CustomAvailabilityZoneNotFoundFaultRes(parsedOutput, context);
    case "DBSnapshotAlreadyExists":
    case "com.amazonaws.rds#DBSnapshotAlreadyExistsFault":
      throw await de_DBSnapshotAlreadyExistsFaultRes(parsedOutput, context);
    case "InvalidDBSnapshotState":
    case "com.amazonaws.rds#InvalidDBSnapshotStateFault":
      throw await de_InvalidDBSnapshotStateFaultRes(parsedOutput, context);
    case "OptionGroupAlreadyExistsFault":
    case "com.amazonaws.rds#OptionGroupAlreadyExistsFault":
      throw await de_OptionGroupAlreadyExistsFaultRes(parsedOutput, context);
    case "OptionGroupNotFoundFault":
    case "com.amazonaws.rds#OptionGroupNotFoundFault":
      throw await de_OptionGroupNotFoundFaultRes(parsedOutput, context);
    case "OptionGroupQuotaExceededFault":
    case "com.amazonaws.rds#OptionGroupQuotaExceededFault":
      throw await de_OptionGroupQuotaExceededFaultRes(parsedOutput, context);
    case "BlueGreenDeploymentAlreadyExistsFault":
    case "com.amazonaws.rds#BlueGreenDeploymentAlreadyExistsFault":
      throw await de_BlueGreenDeploymentAlreadyExistsFaultRes(parsedOutput, context);
    case "DBClusterParameterGroupNotFound":
    case "com.amazonaws.rds#DBClusterParameterGroupNotFoundFault":
      throw await de_DBClusterParameterGroupNotFoundFaultRes(parsedOutput, context);
    case "DBClusterQuotaExceededFault":
    case "com.amazonaws.rds#DBClusterQuotaExceededFault":
      throw await de_DBClusterQuotaExceededFaultRes(parsedOutput, context);
    case "InstanceQuotaExceeded":
    case "com.amazonaws.rds#InstanceQuotaExceededFault":
      throw await de_InstanceQuotaExceededFaultRes(parsedOutput, context);
    case "SourceClusterNotSupportedFault":
    case "com.amazonaws.rds#SourceClusterNotSupportedFault":
      throw await de_SourceClusterNotSupportedFaultRes(parsedOutput, context);
    case "SourceDatabaseNotSupportedFault":
    case "com.amazonaws.rds#SourceDatabaseNotSupportedFault":
      throw await de_SourceDatabaseNotSupportedFaultRes(parsedOutput, context);
    case "CreateCustomDBEngineVersionFault":
    case "com.amazonaws.rds#CreateCustomDBEngineVersionFault":
      throw await de_CreateCustomDBEngineVersionFaultRes(parsedOutput, context);
    case "CustomDBEngineVersionAlreadyExistsFault":
    case "com.amazonaws.rds#CustomDBEngineVersionAlreadyExistsFault":
      throw await de_CustomDBEngineVersionAlreadyExistsFaultRes(parsedOutput, context);
    case "CustomDBEngineVersionQuotaExceededFault":
    case "com.amazonaws.rds#CustomDBEngineVersionQuotaExceededFault":
      throw await de_CustomDBEngineVersionQuotaExceededFaultRes(parsedOutput, context);
    case "Ec2ImagePropertiesNotSupportedFault":
    case "com.amazonaws.rds#Ec2ImagePropertiesNotSupportedFault":
      throw await de_Ec2ImagePropertiesNotSupportedFaultRes(parsedOutput, context);
    case "DBClusterAlreadyExistsFault":
    case "com.amazonaws.rds#DBClusterAlreadyExistsFault":
      throw await de_DBClusterAlreadyExistsFaultRes(parsedOutput, context);
    case "DBSubnetGroupDoesNotCoverEnoughAZs":
    case "com.amazonaws.rds#DBSubnetGroupDoesNotCoverEnoughAZs":
      throw await de_DBSubnetGroupDoesNotCoverEnoughAZsRes(parsedOutput, context);
    case "DBSubnetGroupNotFoundFault":
    case "com.amazonaws.rds#DBSubnetGroupNotFoundFault":
      throw await de_DBSubnetGroupNotFoundFaultRes(parsedOutput, context);
    case "DomainNotFoundFault":
    case "com.amazonaws.rds#DomainNotFoundFault":
      throw await de_DomainNotFoundFaultRes(parsedOutput, context);
    case "GlobalClusterNotFoundFault":
    case "com.amazonaws.rds#GlobalClusterNotFoundFault":
      throw await de_GlobalClusterNotFoundFaultRes(parsedOutput, context);
    case "InsufficientDBInstanceCapacity":
    case "com.amazonaws.rds#InsufficientDBInstanceCapacityFault":
      throw await de_InsufficientDBInstanceCapacityFaultRes(parsedOutput, context);
    case "InsufficientStorageClusterCapacity":
    case "com.amazonaws.rds#InsufficientStorageClusterCapacityFault":
      throw await de_InsufficientStorageClusterCapacityFaultRes(parsedOutput, context);
    case "InvalidDBSubnetGroupFault":
    case "com.amazonaws.rds#InvalidDBSubnetGroupFault":
      throw await de_InvalidDBSubnetGroupFaultRes(parsedOutput, context);
    case "InvalidDBSubnetGroupStateFault":
    case "com.amazonaws.rds#InvalidDBSubnetGroupStateFault":
      throw await de_InvalidDBSubnetGroupStateFaultRes(parsedOutput, context);
    case "InvalidGlobalClusterStateFault":
    case "com.amazonaws.rds#InvalidGlobalClusterStateFault":
      throw await de_InvalidGlobalClusterStateFaultRes(parsedOutput, context);
    case "InvalidSubnet":
    case "com.amazonaws.rds#InvalidSubnet":
      throw await de_InvalidSubnetRes(parsedOutput, context);
    case "InvalidVPCNetworkStateFault":
    case "com.amazonaws.rds#InvalidVPCNetworkStateFault":
      throw await de_InvalidVPCNetworkStateFaultRes(parsedOutput, context);
    case "StorageQuotaExceeded":
    case "com.amazonaws.rds#StorageQuotaExceededFault":
      throw await de_StorageQuotaExceededFaultRes(parsedOutput, context);
    case "DBClusterEndpointAlreadyExistsFault":
    case "com.amazonaws.rds#DBClusterEndpointAlreadyExistsFault":
      throw await de_DBClusterEndpointAlreadyExistsFaultRes(parsedOutput, context);
    case "DBClusterEndpointQuotaExceededFault":
    case "com.amazonaws.rds#DBClusterEndpointQuotaExceededFault":
      throw await de_DBClusterEndpointQuotaExceededFaultRes(parsedOutput, context);
    case "AuthorizationNotFound":
    case "com.amazonaws.rds#AuthorizationNotFoundFault":
      throw await de_AuthorizationNotFoundFaultRes(parsedOutput, context);
    case "BackupPolicyNotFoundFault":
    case "com.amazonaws.rds#BackupPolicyNotFoundFault":
      throw await de_BackupPolicyNotFoundFaultRes(parsedOutput, context);
    case "CertificateNotFound":
    case "com.amazonaws.rds#CertificateNotFoundFault":
      throw await de_CertificateNotFoundFaultRes(parsedOutput, context);
    case "DBInstanceAlreadyExists":
    case "com.amazonaws.rds#DBInstanceAlreadyExistsFault":
      throw await de_DBInstanceAlreadyExistsFaultRes(parsedOutput, context);
    case "NetworkTypeNotSupported":
    case "com.amazonaws.rds#NetworkTypeNotSupported":
      throw await de_NetworkTypeNotSupportedRes(parsedOutput, context);
    case "ProvisionedIopsNotAvailableInAZFault":
    case "com.amazonaws.rds#ProvisionedIopsNotAvailableInAZFault":
      throw await de_ProvisionedIopsNotAvailableInAZFaultRes(parsedOutput, context);
    case "StorageTypeNotSupported":
    case "com.amazonaws.rds#StorageTypeNotSupportedFault":
      throw await de_StorageTypeNotSupportedFaultRes(parsedOutput, context);
    case "TenantDatabaseQuotaExceeded":
    case "com.amazonaws.rds#TenantDatabaseQuotaExceededFault":
      throw await de_TenantDatabaseQuotaExceededFaultRes(parsedOutput, context);
    case "DBSubnetGroupNotAllowedFault":
    case "com.amazonaws.rds#DBSubnetGroupNotAllowedFault":
      throw await de_DBSubnetGroupNotAllowedFaultRes(parsedOutput, context);
    case "DBProxyAlreadyExistsFault":
    case "com.amazonaws.rds#DBProxyAlreadyExistsFault":
      throw await de_DBProxyAlreadyExistsFaultRes(parsedOutput, context);
    case "DBProxyQuotaExceededFault":
    case "com.amazonaws.rds#DBProxyQuotaExceededFault":
      throw await de_DBProxyQuotaExceededFaultRes(parsedOutput, context);
    case "DBProxyEndpointAlreadyExistsFault":
    case "com.amazonaws.rds#DBProxyEndpointAlreadyExistsFault":
      throw await de_DBProxyEndpointAlreadyExistsFaultRes(parsedOutput, context);
    case "DBProxyEndpointQuotaExceededFault":
    case "com.amazonaws.rds#DBProxyEndpointQuotaExceededFault":
      throw await de_DBProxyEndpointQuotaExceededFaultRes(parsedOutput, context);
    case "InvalidDBProxyStateFault":
    case "com.amazonaws.rds#InvalidDBProxyStateFault":
      throw await de_InvalidDBProxyStateFaultRes(parsedOutput, context);
    case "DBSecurityGroupAlreadyExists":
    case "com.amazonaws.rds#DBSecurityGroupAlreadyExistsFault":
      throw await de_DBSecurityGroupAlreadyExistsFaultRes(parsedOutput, context);
    case "DBSecurityGroupNotSupported":
    case "com.amazonaws.rds#DBSecurityGroupNotSupportedFault":
      throw await de_DBSecurityGroupNotSupportedFaultRes(parsedOutput, context);
    case "QuotaExceeded.DBSecurityGroup":
    case "com.amazonaws.rds#DBSecurityGroupQuotaExceededFault":
      throw await de_DBSecurityGroupQuotaExceededFaultRes(parsedOutput, context);
    case "DBShardGroupAlreadyExists":
    case "com.amazonaws.rds#DBShardGroupAlreadyExistsFault":
      throw await de_DBShardGroupAlreadyExistsFaultRes(parsedOutput, context);
    case "MaxDBShardGroupLimitReached":
    case "com.amazonaws.rds#MaxDBShardGroupLimitReached":
      throw await de_MaxDBShardGroupLimitReachedRes(parsedOutput, context);
    case "UnsupportedDBEngineVersion":
    case "com.amazonaws.rds#UnsupportedDBEngineVersionFault":
      throw await de_UnsupportedDBEngineVersionFaultRes(parsedOutput, context);
    case "DBSubnetGroupAlreadyExists":
    case "com.amazonaws.rds#DBSubnetGroupAlreadyExistsFault":
      throw await de_DBSubnetGroupAlreadyExistsFaultRes(parsedOutput, context);
    case "DBSubnetGroupQuotaExceeded":
    case "com.amazonaws.rds#DBSubnetGroupQuotaExceededFault":
      throw await de_DBSubnetGroupQuotaExceededFaultRes(parsedOutput, context);
    case "DBSubnetQuotaExceededFault":
    case "com.amazonaws.rds#DBSubnetQuotaExceededFault":
      throw await de_DBSubnetQuotaExceededFaultRes(parsedOutput, context);
    case "EventSubscriptionQuotaExceeded":
    case "com.amazonaws.rds#EventSubscriptionQuotaExceededFault":
      throw await de_EventSubscriptionQuotaExceededFaultRes(parsedOutput, context);
    case "SNSInvalidTopic":
    case "com.amazonaws.rds#SNSInvalidTopicFault":
      throw await de_SNSInvalidTopicFaultRes(parsedOutput, context);
    case "SNSNoAuthorization":
    case "com.amazonaws.rds#SNSNoAuthorizationFault":
      throw await de_SNSNoAuthorizationFaultRes(parsedOutput, context);
    case "SNSTopicArnNotFound":
    case "com.amazonaws.rds#SNSTopicArnNotFoundFault":
      throw await de_SNSTopicArnNotFoundFaultRes(parsedOutput, context);
    case "SubscriptionAlreadyExist":
    case "com.amazonaws.rds#SubscriptionAlreadyExistFault":
      throw await de_SubscriptionAlreadyExistFaultRes(parsedOutput, context);
    case "SubscriptionCategoryNotFound":
    case "com.amazonaws.rds#SubscriptionCategoryNotFoundFault":
      throw await de_SubscriptionCategoryNotFoundFaultRes(parsedOutput, context);
    case "GlobalClusterAlreadyExistsFault":
    case "com.amazonaws.rds#GlobalClusterAlreadyExistsFault":
      throw await de_GlobalClusterAlreadyExistsFaultRes(parsedOutput, context);
    case "GlobalClusterQuotaExceededFault":
    case "com.amazonaws.rds#GlobalClusterQuotaExceededFault":
      throw await de_GlobalClusterQuotaExceededFaultRes(parsedOutput, context);
    case "IntegrationAlreadyExistsFault":
    case "com.amazonaws.rds#IntegrationAlreadyExistsFault":
      throw await de_IntegrationAlreadyExistsFaultRes(parsedOutput, context);
    case "IntegrationConflictOperationFault":
    case "com.amazonaws.rds#IntegrationConflictOperationFault":
      throw await de_IntegrationConflictOperationFaultRes(parsedOutput, context);
    case "IntegrationQuotaExceededFault":
    case "com.amazonaws.rds#IntegrationQuotaExceededFault":
      throw await de_IntegrationQuotaExceededFaultRes(parsedOutput, context);
    case "TenantDatabaseAlreadyExists":
    case "com.amazonaws.rds#TenantDatabaseAlreadyExistsFault":
      throw await de_TenantDatabaseAlreadyExistsFaultRes(parsedOutput, context);
    case "InvalidBlueGreenDeploymentStateFault":
    case "com.amazonaws.rds#InvalidBlueGreenDeploymentStateFault":
      throw await de_InvalidBlueGreenDeploymentStateFaultRes(parsedOutput, context);
    case "CustomDBEngineVersionNotFoundFault":
    case "com.amazonaws.rds#CustomDBEngineVersionNotFoundFault":
      throw await de_CustomDBEngineVersionNotFoundFaultRes(parsedOutput, context);
    case "InvalidCustomDBEngineVersionStateFault":
    case "com.amazonaws.rds#InvalidCustomDBEngineVersionStateFault":
      throw await de_InvalidCustomDBEngineVersionStateFaultRes(parsedOutput, context);
    case "DBClusterAutomatedBackupQuotaExceededFault":
    case "com.amazonaws.rds#DBClusterAutomatedBackupQuotaExceededFault":
      throw await de_DBClusterAutomatedBackupQuotaExceededFaultRes(parsedOutput, context);
    case "DBClusterAutomatedBackupNotFoundFault":
    case "com.amazonaws.rds#DBClusterAutomatedBackupNotFoundFault":
      throw await de_DBClusterAutomatedBackupNotFoundFaultRes(parsedOutput, context);
    case "InvalidDBClusterAutomatedBackupStateFault":
    case "com.amazonaws.rds#InvalidDBClusterAutomatedBackupStateFault":
      throw await de_InvalidDBClusterAutomatedBackupStateFaultRes(parsedOutput, context);
    case "DBClusterEndpointNotFoundFault":
    case "com.amazonaws.rds#DBClusterEndpointNotFoundFault":
      throw await de_DBClusterEndpointNotFoundFaultRes(parsedOutput, context);
    case "InvalidDBClusterEndpointStateFault":
    case "com.amazonaws.rds#InvalidDBClusterEndpointStateFault":
      throw await de_InvalidDBClusterEndpointStateFaultRes(parsedOutput, context);
    case "InvalidDBParameterGroupState":
    case "com.amazonaws.rds#InvalidDBParameterGroupStateFault":
      throw await de_InvalidDBParameterGroupStateFaultRes(parsedOutput, context);
    case "DBInstanceAutomatedBackupQuotaExceeded":
    case "com.amazonaws.rds#DBInstanceAutomatedBackupQuotaExceededFault":
      throw await de_DBInstanceAutomatedBackupQuotaExceededFaultRes(parsedOutput, context);
    case "DBInstanceAutomatedBackupNotFound":
    case "com.amazonaws.rds#DBInstanceAutomatedBackupNotFoundFault":
      throw await de_DBInstanceAutomatedBackupNotFoundFaultRes(parsedOutput, context);
    case "InvalidDBInstanceAutomatedBackupState":
    case "com.amazonaws.rds#InvalidDBInstanceAutomatedBackupStateFault":
      throw await de_InvalidDBInstanceAutomatedBackupStateFaultRes(parsedOutput, context);
    case "DBProxyEndpointNotFoundFault":
    case "com.amazonaws.rds#DBProxyEndpointNotFoundFault":
      throw await de_DBProxyEndpointNotFoundFaultRes(parsedOutput, context);
    case "InvalidDBProxyEndpointStateFault":
    case "com.amazonaws.rds#InvalidDBProxyEndpointStateFault":
      throw await de_InvalidDBProxyEndpointStateFaultRes(parsedOutput, context);
    case "DBShardGroupNotFound":
    case "com.amazonaws.rds#DBShardGroupNotFoundFault":
      throw await de_DBShardGroupNotFoundFaultRes(parsedOutput, context);
    case "InvalidDBShardGroupState":
    case "com.amazonaws.rds#InvalidDBShardGroupStateFault":
      throw await de_InvalidDBShardGroupStateFaultRes(parsedOutput, context);
    case "InvalidDBSubnetStateFault":
    case "com.amazonaws.rds#InvalidDBSubnetStateFault":
      throw await de_InvalidDBSubnetStateFaultRes(parsedOutput, context);
    case "InvalidEventSubscriptionState":
    case "com.amazonaws.rds#InvalidEventSubscriptionStateFault":
      throw await de_InvalidEventSubscriptionStateFaultRes(parsedOutput, context);
    case "InvalidIntegrationStateFault":
    case "com.amazonaws.rds#InvalidIntegrationStateFault":
      throw await de_InvalidIntegrationStateFaultRes(parsedOutput, context);
    case "InvalidOptionGroupStateFault":
    case "com.amazonaws.rds#InvalidOptionGroupStateFault":
      throw await de_InvalidOptionGroupStateFaultRes(parsedOutput, context);
    case "DBProxyTargetNotFoundFault":
    case "com.amazonaws.rds#DBProxyTargetNotFoundFault":
      throw await de_DBProxyTargetNotFoundFaultRes(parsedOutput, context);
    case "DBClusterBacktrackNotFoundFault":
    case "com.amazonaws.rds#DBClusterBacktrackNotFoundFault":
      throw await de_DBClusterBacktrackNotFoundFaultRes(parsedOutput, context);
    case "DBInstanceNotReady":
    case "com.amazonaws.rds#DBInstanceNotReadyFault":
      throw await de_DBInstanceNotReadyFaultRes(parsedOutput, context);
    case "ReservedDBInstanceNotFound":
    case "com.amazonaws.rds#ReservedDBInstanceNotFoundFault":
      throw await de_ReservedDBInstanceNotFoundFaultRes(parsedOutput, context);
    case "ReservedDBInstancesOfferingNotFound":
    case "com.amazonaws.rds#ReservedDBInstancesOfferingNotFoundFault":
      throw await de_ReservedDBInstancesOfferingNotFoundFaultRes(parsedOutput, context);
    case "InvalidResourceStateFault":
    case "com.amazonaws.rds#InvalidResourceStateFault":
      throw await de_InvalidResourceStateFaultRes(parsedOutput, context);
    case "DBLogFileNotFoundFault":
    case "com.amazonaws.rds#DBLogFileNotFoundFault":
      throw await de_DBLogFileNotFoundFaultRes(parsedOutput, context);
    case "InvalidDBClusterCapacityFault":
    case "com.amazonaws.rds#InvalidDBClusterCapacityFault":
      throw await de_InvalidDBClusterCapacityFaultRes(parsedOutput, context);
    case "StorageTypeNotAvailableFault":
    case "com.amazonaws.rds#StorageTypeNotAvailableFault":
      throw await de_StorageTypeNotAvailableFaultRes(parsedOutput, context);
    case "SharedSnapshotQuotaExceeded":
    case "com.amazonaws.rds#SharedSnapshotQuotaExceededFault":
      throw await de_SharedSnapshotQuotaExceededFaultRes(parsedOutput, context);
    case "DBUpgradeDependencyFailure":
    case "com.amazonaws.rds#DBUpgradeDependencyFailureFault":
      throw await de_DBUpgradeDependencyFailureFaultRes(parsedOutput, context);
    case "SubnetAlreadyInUse":
    case "com.amazonaws.rds#SubnetAlreadyInUse":
      throw await de_SubnetAlreadyInUseRes(parsedOutput, context);
    case "ReservedDBInstanceAlreadyExists":
    case "com.amazonaws.rds#ReservedDBInstanceAlreadyExistsFault":
      throw await de_ReservedDBInstanceAlreadyExistsFaultRes(parsedOutput, context);
    case "ReservedDBInstanceQuotaExceeded":
    case "com.amazonaws.rds#ReservedDBInstanceQuotaExceededFault":
      throw await de_ReservedDBInstanceQuotaExceededFaultRes(parsedOutput, context);
    case "DBProxyTargetAlreadyRegisteredFault":
    case "com.amazonaws.rds#DBProxyTargetAlreadyRegisteredFault":
      throw await de_DBProxyTargetAlreadyRegisteredFaultRes(parsedOutput, context);
    case "InsufficientAvailableIPsInSubnetFault":
    case "com.amazonaws.rds#InsufficientAvailableIPsInSubnetFault":
      throw await de_InsufficientAvailableIPsInSubnetFaultRes(parsedOutput, context);
    case "DBClusterRoleNotFound":
    case "com.amazonaws.rds#DBClusterRoleNotFoundFault":
      throw await de_DBClusterRoleNotFoundFaultRes(parsedOutput, context);
    case "DBInstanceRoleNotFound":
    case "com.amazonaws.rds#DBInstanceRoleNotFoundFault":
      throw await de_DBInstanceRoleNotFoundFaultRes(parsedOutput, context);
    case "InvalidS3BucketFault":
    case "com.amazonaws.rds#InvalidS3BucketFault":
      throw await de_InvalidS3BucketFaultRes(parsedOutput, context);
    case "InsufficientDBClusterCapacityFault":
    case "com.amazonaws.rds#InsufficientDBClusterCapacityFault":
      throw await de_InsufficientDBClusterCapacityFaultRes(parsedOutput, context);
    case "InvalidRestoreFault":
    case "com.amazonaws.rds#InvalidRestoreFault":
      throw await de_InvalidRestoreFaultRes(parsedOutput, context);
    case "PointInTimeRestoreNotEnabled":
    case "com.amazonaws.rds#PointInTimeRestoreNotEnabledFault":
      throw await de_PointInTimeRestoreNotEnabledFaultRes(parsedOutput, context);
    case "ExportTaskAlreadyExists":
    case "com.amazonaws.rds#ExportTaskAlreadyExistsFault":
      throw await de_ExportTaskAlreadyExistsFaultRes(parsedOutput, context);
    case "IamRoleMissingPermissions":
    case "com.amazonaws.rds#IamRoleMissingPermissionsFault":
      throw await de_IamRoleMissingPermissionsFaultRes(parsedOutput, context);
    case "IamRoleNotFound":
    case "com.amazonaws.rds#IamRoleNotFoundFault":
      throw await de_IamRoleNotFoundFaultRes(parsedOutput, context);
    case "InvalidExportOnly":
    case "com.amazonaws.rds#InvalidExportOnlyFault":
      throw await de_InvalidExportOnlyFaultRes(parsedOutput, context);
    case "InvalidExportSourceState":
    case "com.amazonaws.rds#InvalidExportSourceStateFault":
      throw await de_InvalidExportSourceStateFaultRes(parsedOutput, context);
    default:
      const parsedBody = parsedOutput.body;
      return throwDefaultError({
        output,
        parsedBody: parsedBody.Error,
        errorCode
      });
  }
}, "de_CommandError");
var de_AuthorizationAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_AuthorizationAlreadyExistsFault(body.Error, context);
  const exception = new AuthorizationAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AuthorizationAlreadyExistsFaultRes");
var de_AuthorizationNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_AuthorizationNotFoundFault(body.Error, context);
  const exception = new AuthorizationNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AuthorizationNotFoundFaultRes");
var de_AuthorizationQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_AuthorizationQuotaExceededFault(body.Error, context);
  const exception = new AuthorizationQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_AuthorizationQuotaExceededFaultRes");
var de_BackupPolicyNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_BackupPolicyNotFoundFault(body.Error, context);
  const exception = new BackupPolicyNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_BackupPolicyNotFoundFaultRes");
var de_BlueGreenDeploymentAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_BlueGreenDeploymentAlreadyExistsFault(body.Error, context);
  const exception = new BlueGreenDeploymentAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_BlueGreenDeploymentAlreadyExistsFaultRes");
var de_BlueGreenDeploymentNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_BlueGreenDeploymentNotFoundFault(body.Error, context);
  const exception = new BlueGreenDeploymentNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_BlueGreenDeploymentNotFoundFaultRes");
var de_CertificateNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_CertificateNotFoundFault(body.Error, context);
  const exception = new CertificateNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CertificateNotFoundFaultRes");
var de_CreateCustomDBEngineVersionFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_CreateCustomDBEngineVersionFault(body.Error, context);
  const exception = new CreateCustomDBEngineVersionFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CreateCustomDBEngineVersionFaultRes");
var de_CustomAvailabilityZoneNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_CustomAvailabilityZoneNotFoundFault(body.Error, context);
  const exception = new CustomAvailabilityZoneNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CustomAvailabilityZoneNotFoundFaultRes");
var de_CustomDBEngineVersionAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_CustomDBEngineVersionAlreadyExistsFault(body.Error, context);
  const exception = new CustomDBEngineVersionAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CustomDBEngineVersionAlreadyExistsFaultRes");
var de_CustomDBEngineVersionNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_CustomDBEngineVersionNotFoundFault(body.Error, context);
  const exception = new CustomDBEngineVersionNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CustomDBEngineVersionNotFoundFaultRes");
var de_CustomDBEngineVersionQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_CustomDBEngineVersionQuotaExceededFault(body.Error, context);
  const exception = new CustomDBEngineVersionQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_CustomDBEngineVersionQuotaExceededFaultRes");
var de_DBClusterAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBClusterAlreadyExistsFault(body.Error, context);
  const exception = new DBClusterAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBClusterAlreadyExistsFaultRes");
var de_DBClusterAutomatedBackupNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBClusterAutomatedBackupNotFoundFault(body.Error, context);
  const exception = new DBClusterAutomatedBackupNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBClusterAutomatedBackupNotFoundFaultRes");
var de_DBClusterAutomatedBackupQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBClusterAutomatedBackupQuotaExceededFault(body.Error, context);
  const exception = new DBClusterAutomatedBackupQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBClusterAutomatedBackupQuotaExceededFaultRes");
var de_DBClusterBacktrackNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBClusterBacktrackNotFoundFault(body.Error, context);
  const exception = new DBClusterBacktrackNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBClusterBacktrackNotFoundFaultRes");
var de_DBClusterEndpointAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBClusterEndpointAlreadyExistsFault(body.Error, context);
  const exception = new DBClusterEndpointAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBClusterEndpointAlreadyExistsFaultRes");
var de_DBClusterEndpointNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBClusterEndpointNotFoundFault(body.Error, context);
  const exception = new DBClusterEndpointNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBClusterEndpointNotFoundFaultRes");
var de_DBClusterEndpointQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBClusterEndpointQuotaExceededFault(body.Error, context);
  const exception = new DBClusterEndpointQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBClusterEndpointQuotaExceededFaultRes");
var de_DBClusterNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBClusterNotFoundFault(body.Error, context);
  const exception = new DBClusterNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBClusterNotFoundFaultRes");
var de_DBClusterParameterGroupNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBClusterParameterGroupNotFoundFault(body.Error, context);
  const exception = new DBClusterParameterGroupNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBClusterParameterGroupNotFoundFaultRes");
var de_DBClusterQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBClusterQuotaExceededFault(body.Error, context);
  const exception = new DBClusterQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBClusterQuotaExceededFaultRes");
var de_DBClusterRoleAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBClusterRoleAlreadyExistsFault(body.Error, context);
  const exception = new DBClusterRoleAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBClusterRoleAlreadyExistsFaultRes");
var de_DBClusterRoleNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBClusterRoleNotFoundFault(body.Error, context);
  const exception = new DBClusterRoleNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBClusterRoleNotFoundFaultRes");
var de_DBClusterRoleQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBClusterRoleQuotaExceededFault(body.Error, context);
  const exception = new DBClusterRoleQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBClusterRoleQuotaExceededFaultRes");
var de_DBClusterSnapshotAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBClusterSnapshotAlreadyExistsFault(body.Error, context);
  const exception = new DBClusterSnapshotAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBClusterSnapshotAlreadyExistsFaultRes");
var de_DBClusterSnapshotNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBClusterSnapshotNotFoundFault(body.Error, context);
  const exception = new DBClusterSnapshotNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBClusterSnapshotNotFoundFaultRes");
var de_DBInstanceAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBInstanceAlreadyExistsFault(body.Error, context);
  const exception = new DBInstanceAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBInstanceAlreadyExistsFaultRes");
var de_DBInstanceAutomatedBackupNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBInstanceAutomatedBackupNotFoundFault(body.Error, context);
  const exception = new DBInstanceAutomatedBackupNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBInstanceAutomatedBackupNotFoundFaultRes");
var de_DBInstanceAutomatedBackupQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBInstanceAutomatedBackupQuotaExceededFault(body.Error, context);
  const exception = new DBInstanceAutomatedBackupQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBInstanceAutomatedBackupQuotaExceededFaultRes");
var de_DBInstanceNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBInstanceNotFoundFault(body.Error, context);
  const exception = new DBInstanceNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBInstanceNotFoundFaultRes");
var de_DBInstanceNotReadyFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBInstanceNotReadyFault(body.Error, context);
  const exception = new DBInstanceNotReadyFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBInstanceNotReadyFaultRes");
var de_DBInstanceRoleAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBInstanceRoleAlreadyExistsFault(body.Error, context);
  const exception = new DBInstanceRoleAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBInstanceRoleAlreadyExistsFaultRes");
var de_DBInstanceRoleNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBInstanceRoleNotFoundFault(body.Error, context);
  const exception = new DBInstanceRoleNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBInstanceRoleNotFoundFaultRes");
var de_DBInstanceRoleQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBInstanceRoleQuotaExceededFault(body.Error, context);
  const exception = new DBInstanceRoleQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBInstanceRoleQuotaExceededFaultRes");
var de_DBLogFileNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBLogFileNotFoundFault(body.Error, context);
  const exception = new DBLogFileNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBLogFileNotFoundFaultRes");
var de_DBParameterGroupAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBParameterGroupAlreadyExistsFault(body.Error, context);
  const exception = new DBParameterGroupAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBParameterGroupAlreadyExistsFaultRes");
var de_DBParameterGroupNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBParameterGroupNotFoundFault(body.Error, context);
  const exception = new DBParameterGroupNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBParameterGroupNotFoundFaultRes");
var de_DBParameterGroupQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBParameterGroupQuotaExceededFault(body.Error, context);
  const exception = new DBParameterGroupQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBParameterGroupQuotaExceededFaultRes");
var de_DBProxyAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBProxyAlreadyExistsFault(body.Error, context);
  const exception = new DBProxyAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBProxyAlreadyExistsFaultRes");
var de_DBProxyEndpointAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBProxyEndpointAlreadyExistsFault(body.Error, context);
  const exception = new DBProxyEndpointAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBProxyEndpointAlreadyExistsFaultRes");
var de_DBProxyEndpointNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBProxyEndpointNotFoundFault(body.Error, context);
  const exception = new DBProxyEndpointNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBProxyEndpointNotFoundFaultRes");
var de_DBProxyEndpointQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBProxyEndpointQuotaExceededFault(body.Error, context);
  const exception = new DBProxyEndpointQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBProxyEndpointQuotaExceededFaultRes");
var de_DBProxyNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBProxyNotFoundFault(body.Error, context);
  const exception = new DBProxyNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBProxyNotFoundFaultRes");
var de_DBProxyQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBProxyQuotaExceededFault(body.Error, context);
  const exception = new DBProxyQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBProxyQuotaExceededFaultRes");
var de_DBProxyTargetAlreadyRegisteredFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBProxyTargetAlreadyRegisteredFault(body.Error, context);
  const exception = new DBProxyTargetAlreadyRegisteredFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBProxyTargetAlreadyRegisteredFaultRes");
var de_DBProxyTargetGroupNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBProxyTargetGroupNotFoundFault(body.Error, context);
  const exception = new DBProxyTargetGroupNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBProxyTargetGroupNotFoundFaultRes");
var de_DBProxyTargetNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBProxyTargetNotFoundFault(body.Error, context);
  const exception = new DBProxyTargetNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBProxyTargetNotFoundFaultRes");
var de_DBSecurityGroupAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBSecurityGroupAlreadyExistsFault(body.Error, context);
  const exception = new DBSecurityGroupAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBSecurityGroupAlreadyExistsFaultRes");
var de_DBSecurityGroupNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBSecurityGroupNotFoundFault(body.Error, context);
  const exception = new DBSecurityGroupNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBSecurityGroupNotFoundFaultRes");
var de_DBSecurityGroupNotSupportedFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBSecurityGroupNotSupportedFault(body.Error, context);
  const exception = new DBSecurityGroupNotSupportedFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBSecurityGroupNotSupportedFaultRes");
var de_DBSecurityGroupQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBSecurityGroupQuotaExceededFault(body.Error, context);
  const exception = new DBSecurityGroupQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBSecurityGroupQuotaExceededFaultRes");
var de_DBShardGroupAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBShardGroupAlreadyExistsFault(body.Error, context);
  const exception = new DBShardGroupAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBShardGroupAlreadyExistsFaultRes");
var de_DBShardGroupNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBShardGroupNotFoundFault(body.Error, context);
  const exception = new DBShardGroupNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBShardGroupNotFoundFaultRes");
var de_DBSnapshotAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBSnapshotAlreadyExistsFault(body.Error, context);
  const exception = new DBSnapshotAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBSnapshotAlreadyExistsFaultRes");
var de_DBSnapshotNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBSnapshotNotFoundFault(body.Error, context);
  const exception = new DBSnapshotNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBSnapshotNotFoundFaultRes");
var de_DBSnapshotTenantDatabaseNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBSnapshotTenantDatabaseNotFoundFault(body.Error, context);
  const exception = new DBSnapshotTenantDatabaseNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBSnapshotTenantDatabaseNotFoundFaultRes");
var de_DBSubnetGroupAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBSubnetGroupAlreadyExistsFault(body.Error, context);
  const exception = new DBSubnetGroupAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBSubnetGroupAlreadyExistsFaultRes");
var de_DBSubnetGroupDoesNotCoverEnoughAZsRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBSubnetGroupDoesNotCoverEnoughAZs(body.Error, context);
  const exception = new DBSubnetGroupDoesNotCoverEnoughAZs({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBSubnetGroupDoesNotCoverEnoughAZsRes");
var de_DBSubnetGroupNotAllowedFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBSubnetGroupNotAllowedFault(body.Error, context);
  const exception = new DBSubnetGroupNotAllowedFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBSubnetGroupNotAllowedFaultRes");
var de_DBSubnetGroupNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBSubnetGroupNotFoundFault(body.Error, context);
  const exception = new DBSubnetGroupNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBSubnetGroupNotFoundFaultRes");
var de_DBSubnetGroupQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBSubnetGroupQuotaExceededFault(body.Error, context);
  const exception = new DBSubnetGroupQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBSubnetGroupQuotaExceededFaultRes");
var de_DBSubnetQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBSubnetQuotaExceededFault(body.Error, context);
  const exception = new DBSubnetQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBSubnetQuotaExceededFaultRes");
var de_DBUpgradeDependencyFailureFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DBUpgradeDependencyFailureFault(body.Error, context);
  const exception = new DBUpgradeDependencyFailureFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DBUpgradeDependencyFailureFaultRes");
var de_DomainNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_DomainNotFoundFault(body.Error, context);
  const exception = new DomainNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_DomainNotFoundFaultRes");
var de_Ec2ImagePropertiesNotSupportedFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_Ec2ImagePropertiesNotSupportedFault(body.Error, context);
  const exception = new Ec2ImagePropertiesNotSupportedFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_Ec2ImagePropertiesNotSupportedFaultRes");
var de_EventSubscriptionQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_EventSubscriptionQuotaExceededFault(body.Error, context);
  const exception = new EventSubscriptionQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_EventSubscriptionQuotaExceededFaultRes");
var de_ExportTaskAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_ExportTaskAlreadyExistsFault(body.Error, context);
  const exception = new ExportTaskAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ExportTaskAlreadyExistsFaultRes");
var de_ExportTaskNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_ExportTaskNotFoundFault(body.Error, context);
  const exception = new ExportTaskNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ExportTaskNotFoundFaultRes");
var de_GlobalClusterAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_GlobalClusterAlreadyExistsFault(body.Error, context);
  const exception = new GlobalClusterAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_GlobalClusterAlreadyExistsFaultRes");
var de_GlobalClusterNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_GlobalClusterNotFoundFault(body.Error, context);
  const exception = new GlobalClusterNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_GlobalClusterNotFoundFaultRes");
var de_GlobalClusterQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_GlobalClusterQuotaExceededFault(body.Error, context);
  const exception = new GlobalClusterQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_GlobalClusterQuotaExceededFaultRes");
var de_IamRoleMissingPermissionsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_IamRoleMissingPermissionsFault(body.Error, context);
  const exception = new IamRoleMissingPermissionsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_IamRoleMissingPermissionsFaultRes");
var de_IamRoleNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_IamRoleNotFoundFault(body.Error, context);
  const exception = new IamRoleNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_IamRoleNotFoundFaultRes");
var de_InstanceQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InstanceQuotaExceededFault(body.Error, context);
  const exception = new InstanceQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InstanceQuotaExceededFaultRes");
var de_InsufficientAvailableIPsInSubnetFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InsufficientAvailableIPsInSubnetFault(body.Error, context);
  const exception = new InsufficientAvailableIPsInSubnetFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InsufficientAvailableIPsInSubnetFaultRes");
var de_InsufficientDBClusterCapacityFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InsufficientDBClusterCapacityFault(body.Error, context);
  const exception = new InsufficientDBClusterCapacityFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InsufficientDBClusterCapacityFaultRes");
var de_InsufficientDBInstanceCapacityFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InsufficientDBInstanceCapacityFault(body.Error, context);
  const exception = new InsufficientDBInstanceCapacityFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InsufficientDBInstanceCapacityFaultRes");
var de_InsufficientStorageClusterCapacityFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InsufficientStorageClusterCapacityFault(body.Error, context);
  const exception = new InsufficientStorageClusterCapacityFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InsufficientStorageClusterCapacityFaultRes");
var de_IntegrationAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_IntegrationAlreadyExistsFault(body.Error, context);
  const exception = new IntegrationAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_IntegrationAlreadyExistsFaultRes");
var de_IntegrationConflictOperationFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_IntegrationConflictOperationFault(body.Error, context);
  const exception = new IntegrationConflictOperationFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_IntegrationConflictOperationFaultRes");
var de_IntegrationNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_IntegrationNotFoundFault(body.Error, context);
  const exception = new IntegrationNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_IntegrationNotFoundFaultRes");
var de_IntegrationQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_IntegrationQuotaExceededFault(body.Error, context);
  const exception = new IntegrationQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_IntegrationQuotaExceededFaultRes");
var de_InvalidBlueGreenDeploymentStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidBlueGreenDeploymentStateFault(body.Error, context);
  const exception = new InvalidBlueGreenDeploymentStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidBlueGreenDeploymentStateFaultRes");
var de_InvalidCustomDBEngineVersionStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidCustomDBEngineVersionStateFault(body.Error, context);
  const exception = new InvalidCustomDBEngineVersionStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidCustomDBEngineVersionStateFaultRes");
var de_InvalidDBClusterAutomatedBackupStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidDBClusterAutomatedBackupStateFault(body.Error, context);
  const exception = new InvalidDBClusterAutomatedBackupStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDBClusterAutomatedBackupStateFaultRes");
var de_InvalidDBClusterCapacityFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidDBClusterCapacityFault(body.Error, context);
  const exception = new InvalidDBClusterCapacityFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDBClusterCapacityFaultRes");
var de_InvalidDBClusterEndpointStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidDBClusterEndpointStateFault(body.Error, context);
  const exception = new InvalidDBClusterEndpointStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDBClusterEndpointStateFaultRes");
var de_InvalidDBClusterSnapshotStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidDBClusterSnapshotStateFault(body.Error, context);
  const exception = new InvalidDBClusterSnapshotStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDBClusterSnapshotStateFaultRes");
var de_InvalidDBClusterStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidDBClusterStateFault(body.Error, context);
  const exception = new InvalidDBClusterStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDBClusterStateFaultRes");
var de_InvalidDBInstanceAutomatedBackupStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidDBInstanceAutomatedBackupStateFault(body.Error, context);
  const exception = new InvalidDBInstanceAutomatedBackupStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDBInstanceAutomatedBackupStateFaultRes");
var de_InvalidDBInstanceStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidDBInstanceStateFault(body.Error, context);
  const exception = new InvalidDBInstanceStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDBInstanceStateFaultRes");
var de_InvalidDBParameterGroupStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidDBParameterGroupStateFault(body.Error, context);
  const exception = new InvalidDBParameterGroupStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDBParameterGroupStateFaultRes");
var de_InvalidDBProxyEndpointStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidDBProxyEndpointStateFault(body.Error, context);
  const exception = new InvalidDBProxyEndpointStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDBProxyEndpointStateFaultRes");
var de_InvalidDBProxyStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidDBProxyStateFault(body.Error, context);
  const exception = new InvalidDBProxyStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDBProxyStateFaultRes");
var de_InvalidDBSecurityGroupStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidDBSecurityGroupStateFault(body.Error, context);
  const exception = new InvalidDBSecurityGroupStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDBSecurityGroupStateFaultRes");
var de_InvalidDBShardGroupStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidDBShardGroupStateFault(body.Error, context);
  const exception = new InvalidDBShardGroupStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDBShardGroupStateFaultRes");
var de_InvalidDBSnapshotStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidDBSnapshotStateFault(body.Error, context);
  const exception = new InvalidDBSnapshotStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDBSnapshotStateFaultRes");
var de_InvalidDBSubnetGroupFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidDBSubnetGroupFault(body.Error, context);
  const exception = new InvalidDBSubnetGroupFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDBSubnetGroupFaultRes");
var de_InvalidDBSubnetGroupStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidDBSubnetGroupStateFault(body.Error, context);
  const exception = new InvalidDBSubnetGroupStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDBSubnetGroupStateFaultRes");
var de_InvalidDBSubnetStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidDBSubnetStateFault(body.Error, context);
  const exception = new InvalidDBSubnetStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidDBSubnetStateFaultRes");
var de_InvalidEventSubscriptionStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidEventSubscriptionStateFault(body.Error, context);
  const exception = new InvalidEventSubscriptionStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidEventSubscriptionStateFaultRes");
var de_InvalidExportOnlyFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidExportOnlyFault(body.Error, context);
  const exception = new InvalidExportOnlyFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidExportOnlyFaultRes");
var de_InvalidExportSourceStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidExportSourceStateFault(body.Error, context);
  const exception = new InvalidExportSourceStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidExportSourceStateFaultRes");
var de_InvalidExportTaskStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidExportTaskStateFault(body.Error, context);
  const exception = new InvalidExportTaskStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidExportTaskStateFaultRes");
var de_InvalidGlobalClusterStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidGlobalClusterStateFault(body.Error, context);
  const exception = new InvalidGlobalClusterStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidGlobalClusterStateFaultRes");
var de_InvalidIntegrationStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidIntegrationStateFault(body.Error, context);
  const exception = new InvalidIntegrationStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidIntegrationStateFaultRes");
var de_InvalidOptionGroupStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidOptionGroupStateFault(body.Error, context);
  const exception = new InvalidOptionGroupStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidOptionGroupStateFaultRes");
var de_InvalidResourceStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidResourceStateFault(body.Error, context);
  const exception = new InvalidResourceStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidResourceStateFaultRes");
var de_InvalidRestoreFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidRestoreFault(body.Error, context);
  const exception = new InvalidRestoreFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidRestoreFaultRes");
var de_InvalidS3BucketFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidS3BucketFault(body.Error, context);
  const exception = new InvalidS3BucketFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidS3BucketFaultRes");
var de_InvalidSubnetRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidSubnet(body.Error, context);
  const exception = new InvalidSubnet({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidSubnetRes");
var de_InvalidVPCNetworkStateFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_InvalidVPCNetworkStateFault(body.Error, context);
  const exception = new InvalidVPCNetworkStateFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_InvalidVPCNetworkStateFaultRes");
var de_KMSKeyNotAccessibleFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_KMSKeyNotAccessibleFault(body.Error, context);
  const exception = new KMSKeyNotAccessibleFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_KMSKeyNotAccessibleFaultRes");
var de_MaxDBShardGroupLimitReachedRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_MaxDBShardGroupLimitReached(body.Error, context);
  const exception = new MaxDBShardGroupLimitReached({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_MaxDBShardGroupLimitReachedRes");
var de_NetworkTypeNotSupportedRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_NetworkTypeNotSupported(body.Error, context);
  const exception = new NetworkTypeNotSupported({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_NetworkTypeNotSupportedRes");
var de_OptionGroupAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_OptionGroupAlreadyExistsFault(body.Error, context);
  const exception = new OptionGroupAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OptionGroupAlreadyExistsFaultRes");
var de_OptionGroupNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_OptionGroupNotFoundFault(body.Error, context);
  const exception = new OptionGroupNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OptionGroupNotFoundFaultRes");
var de_OptionGroupQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_OptionGroupQuotaExceededFault(body.Error, context);
  const exception = new OptionGroupQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_OptionGroupQuotaExceededFaultRes");
var de_PointInTimeRestoreNotEnabledFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_PointInTimeRestoreNotEnabledFault(body.Error, context);
  const exception = new PointInTimeRestoreNotEnabledFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_PointInTimeRestoreNotEnabledFaultRes");
var de_ProvisionedIopsNotAvailableInAZFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_ProvisionedIopsNotAvailableInAZFault(body.Error, context);
  const exception = new ProvisionedIopsNotAvailableInAZFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ProvisionedIopsNotAvailableInAZFaultRes");
var de_ReservedDBInstanceAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_ReservedDBInstanceAlreadyExistsFault(body.Error, context);
  const exception = new ReservedDBInstanceAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ReservedDBInstanceAlreadyExistsFaultRes");
var de_ReservedDBInstanceNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_ReservedDBInstanceNotFoundFault(body.Error, context);
  const exception = new ReservedDBInstanceNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ReservedDBInstanceNotFoundFaultRes");
var de_ReservedDBInstanceQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_ReservedDBInstanceQuotaExceededFault(body.Error, context);
  const exception = new ReservedDBInstanceQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ReservedDBInstanceQuotaExceededFaultRes");
var de_ReservedDBInstancesOfferingNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_ReservedDBInstancesOfferingNotFoundFault(body.Error, context);
  const exception = new ReservedDBInstancesOfferingNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ReservedDBInstancesOfferingNotFoundFaultRes");
var de_ResourceNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_ResourceNotFoundFault(body.Error, context);
  const exception = new ResourceNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_ResourceNotFoundFaultRes");
var de_SharedSnapshotQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_SharedSnapshotQuotaExceededFault(body.Error, context);
  const exception = new SharedSnapshotQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_SharedSnapshotQuotaExceededFaultRes");
var de_SnapshotQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_SnapshotQuotaExceededFault(body.Error, context);
  const exception = new SnapshotQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_SnapshotQuotaExceededFaultRes");
var de_SNSInvalidTopicFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_SNSInvalidTopicFault(body.Error, context);
  const exception = new SNSInvalidTopicFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_SNSInvalidTopicFaultRes");
var de_SNSNoAuthorizationFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_SNSNoAuthorizationFault(body.Error, context);
  const exception = new SNSNoAuthorizationFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_SNSNoAuthorizationFaultRes");
var de_SNSTopicArnNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_SNSTopicArnNotFoundFault(body.Error, context);
  const exception = new SNSTopicArnNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_SNSTopicArnNotFoundFaultRes");
var de_SourceClusterNotSupportedFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_SourceClusterNotSupportedFault(body.Error, context);
  const exception = new SourceClusterNotSupportedFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_SourceClusterNotSupportedFaultRes");
var de_SourceDatabaseNotSupportedFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_SourceDatabaseNotSupportedFault(body.Error, context);
  const exception = new SourceDatabaseNotSupportedFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_SourceDatabaseNotSupportedFaultRes");
var de_SourceNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_SourceNotFoundFault(body.Error, context);
  const exception = new SourceNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_SourceNotFoundFaultRes");
var de_StorageQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_StorageQuotaExceededFault(body.Error, context);
  const exception = new StorageQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_StorageQuotaExceededFaultRes");
var de_StorageTypeNotAvailableFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_StorageTypeNotAvailableFault(body.Error, context);
  const exception = new StorageTypeNotAvailableFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_StorageTypeNotAvailableFaultRes");
var de_StorageTypeNotSupportedFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_StorageTypeNotSupportedFault(body.Error, context);
  const exception = new StorageTypeNotSupportedFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_StorageTypeNotSupportedFaultRes");
var de_SubnetAlreadyInUseRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_SubnetAlreadyInUse(body.Error, context);
  const exception = new SubnetAlreadyInUse({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_SubnetAlreadyInUseRes");
var de_SubscriptionAlreadyExistFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_SubscriptionAlreadyExistFault(body.Error, context);
  const exception = new SubscriptionAlreadyExistFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_SubscriptionAlreadyExistFaultRes");
var de_SubscriptionCategoryNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_SubscriptionCategoryNotFoundFault(body.Error, context);
  const exception = new SubscriptionCategoryNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_SubscriptionCategoryNotFoundFaultRes");
var de_SubscriptionNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_SubscriptionNotFoundFault(body.Error, context);
  const exception = new SubscriptionNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_SubscriptionNotFoundFaultRes");
var de_TenantDatabaseAlreadyExistsFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_TenantDatabaseAlreadyExistsFault(body.Error, context);
  const exception = new TenantDatabaseAlreadyExistsFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TenantDatabaseAlreadyExistsFaultRes");
var de_TenantDatabaseNotFoundFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_TenantDatabaseNotFoundFault(body.Error, context);
  const exception = new TenantDatabaseNotFoundFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TenantDatabaseNotFoundFaultRes");
var de_TenantDatabaseQuotaExceededFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_TenantDatabaseQuotaExceededFault(body.Error, context);
  const exception = new TenantDatabaseQuotaExceededFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_TenantDatabaseQuotaExceededFaultRes");
var de_UnsupportedDBEngineVersionFaultRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const body = parsedOutput.body;
  const deserialized = de_UnsupportedDBEngineVersionFault(body.Error, context);
  const exception = new UnsupportedDBEngineVersionFault({
    $metadata: deserializeMetadata(parsedOutput),
    ...deserialized
  });
  return (0, import_smithy_client.decorateServiceException)(exception, body);
}, "de_UnsupportedDBEngineVersionFaultRes");
var se_AddRoleToDBClusterMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  if (input[_RA] != null) {
    entries[_RA] = input[_RA];
  }
  if (input[_FN] != null) {
    entries[_FN] = input[_FN];
  }
  return entries;
}, "se_AddRoleToDBClusterMessage");
var se_AddRoleToDBInstanceMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_RA] != null) {
    entries[_RA] = input[_RA];
  }
  if (input[_FN] != null) {
    entries[_FN] = input[_FN];
  }
  return entries;
}, "se_AddRoleToDBInstanceMessage");
var se_AddSourceIdentifierToSubscriptionMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_SI] != null) {
    entries[_SI] = input[_SI];
  }
  return entries;
}, "se_AddSourceIdentifierToSubscriptionMessage");
var se_AddTagsToResourceMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RN] != null) {
    entries[_RN] = input[_RN];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_AddTagsToResourceMessage");
var se_ApplyPendingMaintenanceActionMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RI] != null) {
    entries[_RI] = input[_RI];
  }
  if (input[_AA] != null) {
    entries[_AA] = input[_AA];
  }
  if (input[_OIT] != null) {
    entries[_OIT] = input[_OIT];
  }
  return entries;
}, "se_ApplyPendingMaintenanceActionMessage");
var se_AttributeValueList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`AttributeValue.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_AttributeValueList");
var se_AuthorizeDBSecurityGroupIngressMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBSGN] != null) {
    entries[_DBSGN] = input[_DBSGN];
  }
  if (input[_CIDRIP] != null) {
    entries[_CIDRIP] = input[_CIDRIP];
  }
  if (input[_ECSGN] != null) {
    entries[_ECSGN] = input[_ECSGN];
  }
  if (input[_ECSGI] != null) {
    entries[_ECSGI] = input[_ECSGI];
  }
  if (input[_ECSGOI] != null) {
    entries[_ECSGOI] = input[_ECSGOI];
  }
  return entries;
}, "se_AuthorizeDBSecurityGroupIngressMessage");
var se_AvailabilityZones = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`AvailabilityZone.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_AvailabilityZones");
var se_BacktrackDBClusterMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  if (input[_BT] != null) {
    entries[_BT] = (0, import_smithy_client.serializeDateTime)(input[_BT]);
  }
  if (input[_F] != null) {
    entries[_F] = input[_F];
  }
  if (input[_UETOPITU] != null) {
    entries[_UETOPITU] = input[_UETOPITU];
  }
  return entries;
}, "se_BacktrackDBClusterMessage");
var se_CancelExportTaskMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_ETI] != null) {
    entries[_ETI] = input[_ETI];
  }
  return entries;
}, "se_CancelExportTaskMessage");
var se_CloudwatchLogsExportConfiguration = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_ELT] != null) {
    const memberEntries = se_LogTypeList(input[_ELT], context);
    if (input[_ELT]?.length === 0) {
      entries.EnableLogTypes = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `EnableLogTypes.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_DLT] != null) {
    const memberEntries = se_LogTypeList(input[_DLT], context);
    if (input[_DLT]?.length === 0) {
      entries.DisableLogTypes = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `DisableLogTypes.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CloudwatchLogsExportConfiguration");
var se_ConnectionPoolConfiguration = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_MCP] != null) {
    entries[_MCP] = input[_MCP];
  }
  if (input[_MICP] != null) {
    entries[_MICP] = input[_MICP];
  }
  if (input[_CBT] != null) {
    entries[_CBT] = input[_CBT];
  }
  if (input[_SPF] != null) {
    const memberEntries = se_StringList(input[_SPF], context);
    if (input[_SPF]?.length === 0) {
      entries.SessionPinningFilters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `SessionPinningFilters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_IQ] != null) {
    entries[_IQ] = input[_IQ];
  }
  return entries;
}, "se_ConnectionPoolConfiguration");
var se_CopyDBClusterParameterGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SDBCPGI] != null) {
    entries[_SDBCPGI] = input[_SDBCPGI];
  }
  if (input[_TDBCPGI] != null) {
    entries[_TDBCPGI] = input[_TDBCPGI];
  }
  if (input[_TDBCPGD] != null) {
    entries[_TDBCPGD] = input[_TDBCPGD];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CopyDBClusterParameterGroupMessage");
var se_CopyDBClusterSnapshotMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SDBCSI] != null) {
    entries[_SDBCSI] = input[_SDBCSI];
  }
  if (input[_TDBCSI] != null) {
    entries[_TDBCSI] = input[_TDBCSI];
  }
  if (input[_KKI] != null) {
    entries[_KKI] = input[_KKI];
  }
  if (input[_PSU] != null) {
    entries[_PSU] = input[_PSU];
  }
  if (input[_CT] != null) {
    entries[_CT] = input[_CT];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CopyDBClusterSnapshotMessage");
var se_CopyDBParameterGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SDBPGI] != null) {
    entries[_SDBPGI] = input[_SDBPGI];
  }
  if (input[_TDBPGI] != null) {
    entries[_TDBPGI] = input[_TDBPGI];
  }
  if (input[_TDBPGD] != null) {
    entries[_TDBPGD] = input[_TDBPGD];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CopyDBParameterGroupMessage");
var se_CopyDBSnapshotMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SDBSI] != null) {
    entries[_SDBSI] = input[_SDBSI];
  }
  if (input[_TDBSI] != null) {
    entries[_TDBSI] = input[_TDBSI];
  }
  if (input[_KKI] != null) {
    entries[_KKI] = input[_KKI];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_CT] != null) {
    entries[_CT] = input[_CT];
  }
  if (input[_PSU] != null) {
    entries[_PSU] = input[_PSU];
  }
  if (input[_OGN] != null) {
    entries[_OGN] = input[_OGN];
  }
  if (input[_TCAZ] != null) {
    entries[_TCAZ] = input[_TCAZ];
  }
  if (input[_COG] != null) {
    entries[_COG] = input[_COG];
  }
  if (input[_SAZ] != null) {
    entries[_SAZ] = input[_SAZ];
  }
  if (input[_ST] != null) {
    entries[_ST] = input[_ST];
  }
  return entries;
}, "se_CopyDBSnapshotMessage");
var se_CopyOptionGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SOGI] != null) {
    entries[_SOGI] = input[_SOGI];
  }
  if (input[_TOGI] != null) {
    entries[_TOGI] = input[_TOGI];
  }
  if (input[_TOGD] != null) {
    entries[_TOGD] = input[_TOGD];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CopyOptionGroupMessage");
var se_CreateBlueGreenDeploymentRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_BGDN] != null) {
    entries[_BGDN] = input[_BGDN];
  }
  if (input[_S] != null) {
    entries[_S] = input[_S];
  }
  if (input[_TEV] != null) {
    entries[_TEV] = input[_TEV];
  }
  if (input[_TDBPGN] != null) {
    entries[_TDBPGN] = input[_TDBPGN];
  }
  if (input[_TDBCPGN] != null) {
    entries[_TDBCPGN] = input[_TDBCPGN];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_TDBIC] != null) {
    entries[_TDBIC] = input[_TDBIC];
  }
  if (input[_UTSC] != null) {
    entries[_UTSC] = input[_UTSC];
  }
  if (input[_TI] != null) {
    entries[_TI] = input[_TI];
  }
  if (input[_TST] != null) {
    entries[_TST] = input[_TST];
  }
  if (input[_TAS] != null) {
    entries[_TAS] = input[_TAS];
  }
  if (input[_TSTa] != null) {
    entries[_TSTa] = input[_TSTa];
  }
  return entries;
}, "se_CreateBlueGreenDeploymentRequest");
var se_CreateCustomDBEngineVersionMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_E] != null) {
    entries[_E] = input[_E];
  }
  if (input[_EV] != null) {
    entries[_EV] = input[_EV];
  }
  if (input[_DIFSBN] != null) {
    entries[_DIFSBN] = input[_DIFSBN];
  }
  if (input[_DIFSP] != null) {
    entries[_DIFSP] = input[_DIFSP];
  }
  if (input[_II] != null) {
    entries[_II] = input[_II];
  }
  if (input[_KMSKI] != null) {
    entries[_KMSKI] = input[_KMSKI];
  }
  if (input[_D] != null) {
    entries[_D] = input[_D];
  }
  if (input[_M] != null) {
    entries[_M] = input[_M];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_SCDEVI] != null) {
    entries[_SCDEVI] = input[_SCDEVI];
  }
  if (input[_UAPLI] != null) {
    entries[_UAPLI] = input[_UAPLI];
  }
  return entries;
}, "se_CreateCustomDBEngineVersionMessage");
var se_CreateDBClusterEndpointMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  if (input[_DBCEI] != null) {
    entries[_DBCEI] = input[_DBCEI];
  }
  if (input[_ET] != null) {
    entries[_ET] = input[_ET];
  }
  if (input[_SM] != null) {
    const memberEntries = se_StringList(input[_SM], context);
    if (input[_SM]?.length === 0) {
      entries.StaticMembers = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `StaticMembers.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_EM] != null) {
    const memberEntries = se_StringList(input[_EM], context);
    if (input[_EM]?.length === 0) {
      entries.ExcludedMembers = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ExcludedMembers.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CreateDBClusterEndpointMessage");
var se_CreateDBClusterMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_AZ] != null) {
    const memberEntries = se_AvailabilityZones(input[_AZ], context);
    if (input[_AZ]?.length === 0) {
      entries.AvailabilityZones = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `AvailabilityZones.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_BRP] != null) {
    entries[_BRP] = input[_BRP];
  }
  if (input[_CSN] != null) {
    entries[_CSN] = input[_CSN];
  }
  if (input[_DN] != null) {
    entries[_DN] = input[_DN];
  }
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  if (input[_DBCPGN] != null) {
    entries[_DBCPGN] = input[_DBCPGN];
  }
  if (input[_VSGI] != null) {
    const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
    if (input[_VSGI]?.length === 0) {
      entries.VpcSecurityGroupIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `VpcSecurityGroupIds.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_DBSGNu] != null) {
    entries[_DBSGNu] = input[_DBSGNu];
  }
  if (input[_E] != null) {
    entries[_E] = input[_E];
  }
  if (input[_EV] != null) {
    entries[_EV] = input[_EV];
  }
  if (input[_P] != null) {
    entries[_P] = input[_P];
  }
  if (input[_MU] != null) {
    entries[_MU] = input[_MU];
  }
  if (input[_MUP] != null) {
    entries[_MUP] = input[_MUP];
  }
  if (input[_OGN] != null) {
    entries[_OGN] = input[_OGN];
  }
  if (input[_PBW] != null) {
    entries[_PBW] = input[_PBW];
  }
  if (input[_PMW] != null) {
    entries[_PMW] = input[_PMW];
  }
  if (input[_RSI] != null) {
    entries[_RSI] = input[_RSI];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_SE] != null) {
    entries[_SE] = input[_SE];
  }
  if (input[_KKI] != null) {
    entries[_KKI] = input[_KKI];
  }
  if (input[_PSU] != null) {
    entries[_PSU] = input[_PSU];
  }
  if (input[_EIAMDA] != null) {
    entries[_EIAMDA] = input[_EIAMDA];
  }
  if (input[_BW] != null) {
    entries[_BW] = input[_BW];
  }
  if (input[_ECLE] != null) {
    const memberEntries = se_LogTypeList(input[_ECLE], context);
    if (input[_ECLE]?.length === 0) {
      entries.EnableCloudwatchLogsExports = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `EnableCloudwatchLogsExports.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_EMn] != null) {
    entries[_EMn] = input[_EMn];
  }
  if (input[_SC] != null) {
    const memberEntries = se_ScalingConfiguration(input[_SC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ScalingConfiguration.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_RCCC] != null) {
    const memberEntries = se_RdsCustomClusterConfiguration(input[_RCCC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `RdsCustomClusterConfiguration.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_DP] != null) {
    entries[_DP] = input[_DP];
  }
  if (input[_GCI] != null) {
    entries[_GCI] = input[_GCI];
  }
  if (input[_EHE] != null) {
    entries[_EHE] = input[_EHE];
  }
  if (input[_CTTS] != null) {
    entries[_CTTS] = input[_CTTS];
  }
  if (input[_Do] != null) {
    entries[_Do] = input[_Do];
  }
  if (input[_DIAMRN] != null) {
    entries[_DIAMRN] = input[_DIAMRN];
  }
  if (input[_EGWF] != null) {
    entries[_EGWF] = input[_EGWF];
  }
  if (input[_DBCIC] != null) {
    entries[_DBCIC] = input[_DBCIC];
  }
  if (input[_AS] != null) {
    entries[_AS] = input[_AS];
  }
  if (input[_STt] != null) {
    entries[_STt] = input[_STt];
  }
  if (input[_I] != null) {
    entries[_I] = input[_I];
  }
  if (input[_PA] != null) {
    entries[_PA] = input[_PA];
  }
  if (input[_AMVU] != null) {
    entries[_AMVU] = input[_AMVU];
  }
  if (input[_MIo] != null) {
    entries[_MIo] = input[_MIo];
  }
  if (input[_MRA] != null) {
    entries[_MRA] = input[_MRA];
  }
  if (input[_DIM] != null) {
    entries[_DIM] = input[_DIM];
  }
  if (input[_EPI] != null) {
    entries[_EPI] = input[_EPI];
  }
  if (input[_PIKMSKI] != null) {
    entries[_PIKMSKI] = input[_PIKMSKI];
  }
  if (input[_PIRP] != null) {
    entries[_PIRP] = input[_PIRP];
  }
  if (input[_ELD] != null) {
    entries[_ELD] = input[_ELD];
  }
  if (input[_SVSC] != null) {
    const memberEntries = se_ServerlessV2ScalingConfiguration(input[_SVSC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ServerlessV2ScalingConfiguration.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_CST] != null) {
    entries[_CST] = input[_CST];
  }
  if (input[_DBSI] != null) {
    entries[_DBSI] = input[_DBSI];
  }
  if (input[_MMUP] != null) {
    entries[_MMUP] = input[_MMUP];
  }
  if (input[_MUSKKI] != null) {
    entries[_MUSKKI] = input[_MUSKKI];
  }
  if (input[_ELWF] != null) {
    entries[_ELWF] = input[_ELWF];
  }
  if (input[_CACI] != null) {
    entries[_CACI] = input[_CACI];
  }
  if (input[_ELS] != null) {
    entries[_ELS] = input[_ELS];
  }
  return entries;
}, "se_CreateDBClusterMessage");
var se_CreateDBClusterParameterGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCPGN] != null) {
    entries[_DBCPGN] = input[_DBCPGN];
  }
  if (input[_DBPGF] != null) {
    entries[_DBPGF] = input[_DBPGF];
  }
  if (input[_D] != null) {
    entries[_D] = input[_D];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CreateDBClusterParameterGroupMessage");
var se_CreateDBClusterSnapshotMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCSI] != null) {
    entries[_DBCSI] = input[_DBCSI];
  }
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CreateDBClusterSnapshotMessage");
var se_CreateDBInstanceMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBN] != null) {
    entries[_DBN] = input[_DBN];
  }
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_AS] != null) {
    entries[_AS] = input[_AS];
  }
  if (input[_DBIC] != null) {
    entries[_DBIC] = input[_DBIC];
  }
  if (input[_E] != null) {
    entries[_E] = input[_E];
  }
  if (input[_MU] != null) {
    entries[_MU] = input[_MU];
  }
  if (input[_MUP] != null) {
    entries[_MUP] = input[_MUP];
  }
  if (input[_DBSG] != null) {
    const memberEntries = se_DBSecurityGroupNameList(input[_DBSG], context);
    if (input[_DBSG]?.length === 0) {
      entries.DBSecurityGroups = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `DBSecurityGroups.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_VSGI] != null) {
    const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
    if (input[_VSGI]?.length === 0) {
      entries.VpcSecurityGroupIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `VpcSecurityGroupIds.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_AZv] != null) {
    entries[_AZv] = input[_AZv];
  }
  if (input[_DBSGNu] != null) {
    entries[_DBSGNu] = input[_DBSGNu];
  }
  if (input[_PMW] != null) {
    entries[_PMW] = input[_PMW];
  }
  if (input[_DBPGN] != null) {
    entries[_DBPGN] = input[_DBPGN];
  }
  if (input[_BRP] != null) {
    entries[_BRP] = input[_BRP];
  }
  if (input[_PBW] != null) {
    entries[_PBW] = input[_PBW];
  }
  if (input[_P] != null) {
    entries[_P] = input[_P];
  }
  if (input[_MAZ] != null) {
    entries[_MAZ] = input[_MAZ];
  }
  if (input[_EV] != null) {
    entries[_EV] = input[_EV];
  }
  if (input[_AMVU] != null) {
    entries[_AMVU] = input[_AMVU];
  }
  if (input[_LM] != null) {
    entries[_LM] = input[_LM];
  }
  if (input[_I] != null) {
    entries[_I] = input[_I];
  }
  if (input[_OGN] != null) {
    entries[_OGN] = input[_OGN];
  }
  if (input[_CSN] != null) {
    entries[_CSN] = input[_CSN];
  }
  if (input[_NCSN] != null) {
    entries[_NCSN] = input[_NCSN];
  }
  if (input[_PA] != null) {
    entries[_PA] = input[_PA];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  if (input[_STt] != null) {
    entries[_STt] = input[_STt];
  }
  if (input[_TCA] != null) {
    entries[_TCA] = input[_TCA];
  }
  if (input[_TCP] != null) {
    entries[_TCP] = input[_TCP];
  }
  if (input[_SE] != null) {
    entries[_SE] = input[_SE];
  }
  if (input[_KKI] != null) {
    entries[_KKI] = input[_KKI];
  }
  if (input[_Do] != null) {
    entries[_Do] = input[_Do];
  }
  if (input[_DF] != null) {
    entries[_DF] = input[_DF];
  }
  if (input[_DO] != null) {
    entries[_DO] = input[_DO];
  }
  if (input[_DASA] != null) {
    entries[_DASA] = input[_DASA];
  }
  if (input[_DDI] != null) {
    const memberEntries = se_StringList(input[_DDI], context);
    if (input[_DDI]?.length === 0) {
      entries.DomainDnsIps = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `DomainDnsIps.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_CTTS] != null) {
    entries[_CTTS] = input[_CTTS];
  }
  if (input[_MIo] != null) {
    entries[_MIo] = input[_MIo];
  }
  if (input[_MRA] != null) {
    entries[_MRA] = input[_MRA];
  }
  if (input[_DIAMRN] != null) {
    entries[_DIAMRN] = input[_DIAMRN];
  }
  if (input[_PT] != null) {
    entries[_PT] = input[_PT];
  }
  if (input[_Ti] != null) {
    entries[_Ti] = input[_Ti];
  }
  if (input[_EIAMDA] != null) {
    entries[_EIAMDA] = input[_EIAMDA];
  }
  if (input[_DIM] != null) {
    entries[_DIM] = input[_DIM];
  }
  if (input[_EPI] != null) {
    entries[_EPI] = input[_EPI];
  }
  if (input[_PIKMSKI] != null) {
    entries[_PIKMSKI] = input[_PIKMSKI];
  }
  if (input[_PIRP] != null) {
    entries[_PIRP] = input[_PIRP];
  }
  if (input[_ECLE] != null) {
    const memberEntries = se_LogTypeList(input[_ECLE], context);
    if (input[_ECLE]?.length === 0) {
      entries.EnableCloudwatchLogsExports = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `EnableCloudwatchLogsExports.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_PF] != null) {
    const memberEntries = se_ProcessorFeatureList(input[_PF], context);
    if (input[_PF]?.length === 0) {
      entries.ProcessorFeatures = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ProcessorFeatures.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_DP] != null) {
    entries[_DP] = input[_DP];
  }
  if (input[_MASa] != null) {
    entries[_MASa] = input[_MASa];
  }
  if (input[_ECOI] != null) {
    entries[_ECOI] = input[_ECOI];
  }
  if (input[_CIIP] != null) {
    entries[_CIIP] = input[_CIIP];
  }
  if (input[_BTa] != null) {
    entries[_BTa] = input[_BTa];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_STto] != null) {
    entries[_STto] = input[_STto];
  }
  if (input[_MMUP] != null) {
    entries[_MMUP] = input[_MMUP];
  }
  if (input[_MUSKKI] != null) {
    entries[_MUSKKI] = input[_MUSKKI];
  }
  if (input[_CACI] != null) {
    entries[_CACI] = input[_CACI];
  }
  if (input[_DBSI] != null) {
    entries[_DBSI] = input[_DBSI];
  }
  if (input[_DLV] != null) {
    entries[_DLV] = input[_DLV];
  }
  if (input[_MT] != null) {
    entries[_MT] = input[_MT];
  }
  if (input[_ELS] != null) {
    entries[_ELS] = input[_ELS];
  }
  return entries;
}, "se_CreateDBInstanceMessage");
var se_CreateDBInstanceReadReplicaMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_SDBII] != null) {
    entries[_SDBII] = input[_SDBII];
  }
  if (input[_DBIC] != null) {
    entries[_DBIC] = input[_DBIC];
  }
  if (input[_AZv] != null) {
    entries[_AZv] = input[_AZv];
  }
  if (input[_P] != null) {
    entries[_P] = input[_P];
  }
  if (input[_MAZ] != null) {
    entries[_MAZ] = input[_MAZ];
  }
  if (input[_AMVU] != null) {
    entries[_AMVU] = input[_AMVU];
  }
  if (input[_I] != null) {
    entries[_I] = input[_I];
  }
  if (input[_OGN] != null) {
    entries[_OGN] = input[_OGN];
  }
  if (input[_DBPGN] != null) {
    entries[_DBPGN] = input[_DBPGN];
  }
  if (input[_PA] != null) {
    entries[_PA] = input[_PA];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_DBSGNu] != null) {
    entries[_DBSGNu] = input[_DBSGNu];
  }
  if (input[_VSGI] != null) {
    const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
    if (input[_VSGI]?.length === 0) {
      entries.VpcSecurityGroupIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `VpcSecurityGroupIds.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_STt] != null) {
    entries[_STt] = input[_STt];
  }
  if (input[_CTTS] != null) {
    entries[_CTTS] = input[_CTTS];
  }
  if (input[_MIo] != null) {
    entries[_MIo] = input[_MIo];
  }
  if (input[_MRA] != null) {
    entries[_MRA] = input[_MRA];
  }
  if (input[_KKI] != null) {
    entries[_KKI] = input[_KKI];
  }
  if (input[_PSU] != null) {
    entries[_PSU] = input[_PSU];
  }
  if (input[_EIAMDA] != null) {
    entries[_EIAMDA] = input[_EIAMDA];
  }
  if (input[_DIM] != null) {
    entries[_DIM] = input[_DIM];
  }
  if (input[_EPI] != null) {
    entries[_EPI] = input[_EPI];
  }
  if (input[_PIKMSKI] != null) {
    entries[_PIKMSKI] = input[_PIKMSKI];
  }
  if (input[_PIRP] != null) {
    entries[_PIRP] = input[_PIRP];
  }
  if (input[_ECLE] != null) {
    const memberEntries = se_LogTypeList(input[_ECLE], context);
    if (input[_ECLE]?.length === 0) {
      entries.EnableCloudwatchLogsExports = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `EnableCloudwatchLogsExports.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_PF] != null) {
    const memberEntries = se_ProcessorFeatureList(input[_PF], context);
    if (input[_PF]?.length === 0) {
      entries.ProcessorFeatures = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ProcessorFeatures.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_UDPF] != null) {
    entries[_UDPF] = input[_UDPF];
  }
  if (input[_DP] != null) {
    entries[_DP] = input[_DP];
  }
  if (input[_Do] != null) {
    entries[_Do] = input[_Do];
  }
  if (input[_DIAMRN] != null) {
    entries[_DIAMRN] = input[_DIAMRN];
  }
  if (input[_DF] != null) {
    entries[_DF] = input[_DF];
  }
  if (input[_DO] != null) {
    entries[_DO] = input[_DO];
  }
  if (input[_DASA] != null) {
    entries[_DASA] = input[_DASA];
  }
  if (input[_DDI] != null) {
    const memberEntries = se_StringList(input[_DDI], context);
    if (input[_DDI]?.length === 0) {
      entries.DomainDnsIps = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `DomainDnsIps.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_RM] != null) {
    entries[_RM] = input[_RM];
  }
  if (input[_MASa] != null) {
    entries[_MASa] = input[_MASa];
  }
  if (input[_CIIP] != null) {
    entries[_CIIP] = input[_CIIP];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_STto] != null) {
    entries[_STto] = input[_STto];
  }
  if (input[_ECOI] != null) {
    entries[_ECOI] = input[_ECOI];
  }
  if (input[_BTa] != null) {
    entries[_BTa] = input[_BTa];
  }
  if (input[_AS] != null) {
    entries[_AS] = input[_AS];
  }
  if (input[_SDBCI] != null) {
    entries[_SDBCI] = input[_SDBCI];
  }
  if (input[_DLV] != null) {
    entries[_DLV] = input[_DLV];
  }
  if (input[_USC] != null) {
    entries[_USC] = input[_USC];
  }
  if (input[_CACI] != null) {
    entries[_CACI] = input[_CACI];
  }
  return entries;
}, "se_CreateDBInstanceReadReplicaMessage");
var se_CreateDBParameterGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBPGN] != null) {
    entries[_DBPGN] = input[_DBPGN];
  }
  if (input[_DBPGF] != null) {
    entries[_DBPGF] = input[_DBPGF];
  }
  if (input[_D] != null) {
    entries[_D] = input[_D];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CreateDBParameterGroupMessage");
var se_CreateDBProxyEndpointRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBPN] != null) {
    entries[_DBPN] = input[_DBPN];
  }
  if (input[_DBPEN] != null) {
    entries[_DBPEN] = input[_DBPEN];
  }
  if (input[_VSI] != null) {
    const memberEntries = se_StringList(input[_VSI], context);
    if (input[_VSI]?.length === 0) {
      entries.VpcSubnetIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `VpcSubnetIds.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_VSGI] != null) {
    const memberEntries = se_StringList(input[_VSGI], context);
    if (input[_VSGI]?.length === 0) {
      entries.VpcSecurityGroupIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `VpcSecurityGroupIds.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_TR] != null) {
    entries[_TR] = input[_TR];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CreateDBProxyEndpointRequest");
var se_CreateDBProxyRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBPN] != null) {
    entries[_DBPN] = input[_DBPN];
  }
  if (input[_EF] != null) {
    entries[_EF] = input[_EF];
  }
  if (input[_Au] != null) {
    const memberEntries = se_UserAuthConfigList(input[_Au], context);
    if (input[_Au]?.length === 0) {
      entries.Auth = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Auth.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_RA] != null) {
    entries[_RA] = input[_RA];
  }
  if (input[_VSI] != null) {
    const memberEntries = se_StringList(input[_VSI], context);
    if (input[_VSI]?.length === 0) {
      entries.VpcSubnetIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `VpcSubnetIds.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_VSGI] != null) {
    const memberEntries = se_StringList(input[_VSGI], context);
    if (input[_VSGI]?.length === 0) {
      entries.VpcSecurityGroupIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `VpcSecurityGroupIds.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_RTLS] != null) {
    entries[_RTLS] = input[_RTLS];
  }
  if (input[_ICT] != null) {
    entries[_ICT] = input[_ICT];
  }
  if (input[_DL] != null) {
    entries[_DL] = input[_DL];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CreateDBProxyRequest");
var se_CreateDBSecurityGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBSGN] != null) {
    entries[_DBSGN] = input[_DBSGN];
  }
  if (input[_DBSGD] != null) {
    entries[_DBSGD] = input[_DBSGD];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CreateDBSecurityGroupMessage");
var se_CreateDBShardGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBSGI] != null) {
    entries[_DBSGI] = input[_DBSGI];
  }
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  if (input[_CR] != null) {
    entries[_CR] = input[_CR];
  }
  if (input[_MACU] != null) {
    entries[_MACU] = (0, import_smithy_client.serializeFloat)(input[_MACU]);
  }
  if (input[_MACUi] != null) {
    entries[_MACUi] = (0, import_smithy_client.serializeFloat)(input[_MACUi]);
  }
  if (input[_PA] != null) {
    entries[_PA] = input[_PA];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CreateDBShardGroupMessage");
var se_CreateDBSnapshotMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBSIn] != null) {
    entries[_DBSIn] = input[_DBSIn];
  }
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CreateDBSnapshotMessage");
var se_CreateDBSubnetGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBSGNu] != null) {
    entries[_DBSGNu] = input[_DBSGNu];
  }
  if (input[_DBSGDu] != null) {
    entries[_DBSGDu] = input[_DBSGDu];
  }
  if (input[_SIu] != null) {
    const memberEntries = se_SubnetIdentifierList(input[_SIu], context);
    if (input[_SIu]?.length === 0) {
      entries.SubnetIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `SubnetIds.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CreateDBSubnetGroupMessage");
var se_CreateEventSubscriptionMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_STA] != null) {
    entries[_STA] = input[_STA];
  }
  if (input[_STo] != null) {
    entries[_STo] = input[_STo];
  }
  if (input[_EC] != null) {
    const memberEntries = se_EventCategoriesList(input[_EC], context);
    if (input[_EC]?.length === 0) {
      entries.EventCategories = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `EventCategories.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_SIo] != null) {
    const memberEntries = se_SourceIdsList(input[_SIo], context);
    if (input[_SIo]?.length === 0) {
      entries.SourceIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `SourceIds.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_En] != null) {
    entries[_En] = input[_En];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CreateEventSubscriptionMessage");
var se_CreateGlobalClusterMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_GCI] != null) {
    entries[_GCI] = input[_GCI];
  }
  if (input[_SDBCI] != null) {
    entries[_SDBCI] = input[_SDBCI];
  }
  if (input[_E] != null) {
    entries[_E] = input[_E];
  }
  if (input[_EV] != null) {
    entries[_EV] = input[_EV];
  }
  if (input[_ELS] != null) {
    entries[_ELS] = input[_ELS];
  }
  if (input[_DP] != null) {
    entries[_DP] = input[_DP];
  }
  if (input[_DN] != null) {
    entries[_DN] = input[_DN];
  }
  if (input[_SE] != null) {
    entries[_SE] = input[_SE];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CreateGlobalClusterMessage");
var se_CreateIntegrationMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SA] != null) {
    entries[_SA] = input[_SA];
  }
  if (input[_TA] != null) {
    entries[_TA] = input[_TA];
  }
  if (input[_IN] != null) {
    entries[_IN] = input[_IN];
  }
  if (input[_KMSKI] != null) {
    entries[_KMSKI] = input[_KMSKI];
  }
  if (input[_AEC] != null) {
    const memberEntries = se_EncryptionContextMap(input[_AEC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `AdditionalEncryptionContext.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_DFa] != null) {
    entries[_DFa] = input[_DFa];
  }
  if (input[_D] != null) {
    entries[_D] = input[_D];
  }
  return entries;
}, "se_CreateIntegrationMessage");
var se_CreateOptionGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_OGN] != null) {
    entries[_OGN] = input[_OGN];
  }
  if (input[_EN] != null) {
    entries[_EN] = input[_EN];
  }
  if (input[_MEV] != null) {
    entries[_MEV] = input[_MEV];
  }
  if (input[_OGD] != null) {
    entries[_OGD] = input[_OGD];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CreateOptionGroupMessage");
var se_CreateTenantDatabaseMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_TDBN] != null) {
    entries[_TDBN] = input[_TDBN];
  }
  if (input[_MU] != null) {
    entries[_MU] = input[_MU];
  }
  if (input[_MUP] != null) {
    entries[_MUP] = input[_MUP];
  }
  if (input[_CSN] != null) {
    entries[_CSN] = input[_CSN];
  }
  if (input[_NCSN] != null) {
    entries[_NCSN] = input[_NCSN];
  }
  if (input[_MMUP] != null) {
    entries[_MMUP] = input[_MMUP];
  }
  if (input[_MUSKKI] != null) {
    entries[_MUSKKI] = input[_MUSKKI];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_CreateTenantDatabaseMessage");
var se_DBSecurityGroupNameList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`DBSecurityGroupName.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_DBSecurityGroupNameList");
var se_DeleteBlueGreenDeploymentRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_BGDI] != null) {
    entries[_BGDI] = input[_BGDI];
  }
  if (input[_DT] != null) {
    entries[_DT] = input[_DT];
  }
  return entries;
}, "se_DeleteBlueGreenDeploymentRequest");
var se_DeleteCustomDBEngineVersionMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_E] != null) {
    entries[_E] = input[_E];
  }
  if (input[_EV] != null) {
    entries[_EV] = input[_EV];
  }
  return entries;
}, "se_DeleteCustomDBEngineVersionMessage");
var se_DeleteDBClusterAutomatedBackupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DCRI] != null) {
    entries[_DCRI] = input[_DCRI];
  }
  return entries;
}, "se_DeleteDBClusterAutomatedBackupMessage");
var se_DeleteDBClusterEndpointMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCEI] != null) {
    entries[_DBCEI] = input[_DBCEI];
  }
  return entries;
}, "se_DeleteDBClusterEndpointMessage");
var se_DeleteDBClusterMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  if (input[_SFS] != null) {
    entries[_SFS] = input[_SFS];
  }
  if (input[_FDBSI] != null) {
    entries[_FDBSI] = input[_FDBSI];
  }
  if (input[_DAB] != null) {
    entries[_DAB] = input[_DAB];
  }
  return entries;
}, "se_DeleteDBClusterMessage");
var se_DeleteDBClusterParameterGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCPGN] != null) {
    entries[_DBCPGN] = input[_DBCPGN];
  }
  return entries;
}, "se_DeleteDBClusterParameterGroupMessage");
var se_DeleteDBClusterSnapshotMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCSI] != null) {
    entries[_DBCSI] = input[_DBCSI];
  }
  return entries;
}, "se_DeleteDBClusterSnapshotMessage");
var se_DeleteDBInstanceAutomatedBackupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DRI] != null) {
    entries[_DRI] = input[_DRI];
  }
  if (input[_DBIABA] != null) {
    entries[_DBIABA] = input[_DBIABA];
  }
  return entries;
}, "se_DeleteDBInstanceAutomatedBackupMessage");
var se_DeleteDBInstanceMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_SFS] != null) {
    entries[_SFS] = input[_SFS];
  }
  if (input[_FDBSI] != null) {
    entries[_FDBSI] = input[_FDBSI];
  }
  if (input[_DAB] != null) {
    entries[_DAB] = input[_DAB];
  }
  return entries;
}, "se_DeleteDBInstanceMessage");
var se_DeleteDBParameterGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBPGN] != null) {
    entries[_DBPGN] = input[_DBPGN];
  }
  return entries;
}, "se_DeleteDBParameterGroupMessage");
var se_DeleteDBProxyEndpointRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBPEN] != null) {
    entries[_DBPEN] = input[_DBPEN];
  }
  return entries;
}, "se_DeleteDBProxyEndpointRequest");
var se_DeleteDBProxyRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBPN] != null) {
    entries[_DBPN] = input[_DBPN];
  }
  return entries;
}, "se_DeleteDBProxyRequest");
var se_DeleteDBSecurityGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBSGN] != null) {
    entries[_DBSGN] = input[_DBSGN];
  }
  return entries;
}, "se_DeleteDBSecurityGroupMessage");
var se_DeleteDBShardGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBSGI] != null) {
    entries[_DBSGI] = input[_DBSGI];
  }
  return entries;
}, "se_DeleteDBShardGroupMessage");
var se_DeleteDBSnapshotMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBSIn] != null) {
    entries[_DBSIn] = input[_DBSIn];
  }
  return entries;
}, "se_DeleteDBSnapshotMessage");
var se_DeleteDBSubnetGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBSGNu] != null) {
    entries[_DBSGNu] = input[_DBSGNu];
  }
  return entries;
}, "se_DeleteDBSubnetGroupMessage");
var se_DeleteEventSubscriptionMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  return entries;
}, "se_DeleteEventSubscriptionMessage");
var se_DeleteGlobalClusterMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_GCI] != null) {
    entries[_GCI] = input[_GCI];
  }
  return entries;
}, "se_DeleteGlobalClusterMessage");
var se_DeleteIntegrationMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_IIn] != null) {
    entries[_IIn] = input[_IIn];
  }
  return entries;
}, "se_DeleteIntegrationMessage");
var se_DeleteOptionGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_OGN] != null) {
    entries[_OGN] = input[_OGN];
  }
  return entries;
}, "se_DeleteOptionGroupMessage");
var se_DeleteTenantDatabaseMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_TDBN] != null) {
    entries[_TDBN] = input[_TDBN];
  }
  if (input[_SFS] != null) {
    entries[_SFS] = input[_SFS];
  }
  if (input[_FDBSI] != null) {
    entries[_FDBSI] = input[_FDBSI];
  }
  return entries;
}, "se_DeleteTenantDatabaseMessage");
var se_DeregisterDBProxyTargetsRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBPN] != null) {
    entries[_DBPN] = input[_DBPN];
  }
  if (input[_TGN] != null) {
    entries[_TGN] = input[_TGN];
  }
  if (input[_DBIIn] != null) {
    const memberEntries = se_StringList(input[_DBIIn], context);
    if (input[_DBIIn]?.length === 0) {
      entries.DBInstanceIdentifiers = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `DBInstanceIdentifiers.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_DBCIl] != null) {
    const memberEntries = se_StringList(input[_DBCIl], context);
    if (input[_DBCIl]?.length === 0) {
      entries.DBClusterIdentifiers = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `DBClusterIdentifiers.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_DeregisterDBProxyTargetsRequest");
var se_DescribeAccountAttributesMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  return entries;
}, "se_DescribeAccountAttributesMessage");
var se_DescribeBlueGreenDeploymentsRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_BGDI] != null) {
    entries[_BGDI] = input[_BGDI];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  return entries;
}, "se_DescribeBlueGreenDeploymentsRequest");
var se_DescribeCertificatesMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_CIe] != null) {
    entries[_CIe] = input[_CIe];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeCertificatesMessage");
var se_DescribeDBClusterAutomatedBackupsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DCRI] != null) {
    entries[_DCRI] = input[_DCRI];
  }
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeDBClusterAutomatedBackupsMessage");
var se_DescribeDBClusterBacktracksMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  if (input[_BI] != null) {
    entries[_BI] = input[_BI];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeDBClusterBacktracksMessage");
var se_DescribeDBClusterEndpointsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  if (input[_DBCEI] != null) {
    entries[_DBCEI] = input[_DBCEI];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeDBClusterEndpointsMessage");
var se_DescribeDBClusterParameterGroupsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCPGN] != null) {
    entries[_DBCPGN] = input[_DBCPGN];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeDBClusterParameterGroupsMessage");
var se_DescribeDBClusterParametersMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCPGN] != null) {
    entries[_DBCPGN] = input[_DBCPGN];
  }
  if (input[_S] != null) {
    entries[_S] = input[_S];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeDBClusterParametersMessage");
var se_DescribeDBClustersMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  if (input[_IS] != null) {
    entries[_IS] = input[_IS];
  }
  return entries;
}, "se_DescribeDBClustersMessage");
var se_DescribeDBClusterSnapshotAttributesMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCSI] != null) {
    entries[_DBCSI] = input[_DBCSI];
  }
  return entries;
}, "se_DescribeDBClusterSnapshotAttributesMessage");
var se_DescribeDBClusterSnapshotsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  if (input[_DBCSI] != null) {
    entries[_DBCSI] = input[_DBCSI];
  }
  if (input[_STn] != null) {
    entries[_STn] = input[_STn];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  if (input[_IS] != null) {
    entries[_IS] = input[_IS];
  }
  if (input[_IP] != null) {
    entries[_IP] = input[_IP];
  }
  if (input[_DCRI] != null) {
    entries[_DCRI] = input[_DCRI];
  }
  return entries;
}, "se_DescribeDBClusterSnapshotsMessage");
var se_DescribeDBEngineVersionsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_E] != null) {
    entries[_E] = input[_E];
  }
  if (input[_EV] != null) {
    entries[_EV] = input[_EV];
  }
  if (input[_DBPGF] != null) {
    entries[_DBPGF] = input[_DBPGF];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  if (input[_DOe] != null) {
    entries[_DOe] = input[_DOe];
  }
  if (input[_LSCS] != null) {
    entries[_LSCS] = input[_LSCS];
  }
  if (input[_LST] != null) {
    entries[_LST] = input[_LST];
  }
  if (input[_IA] != null) {
    entries[_IA] = input[_IA];
  }
  return entries;
}, "se_DescribeDBEngineVersionsMessage");
var se_DescribeDBInstanceAutomatedBackupsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DRI] != null) {
    entries[_DRI] = input[_DRI];
  }
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  if (input[_DBIABA] != null) {
    entries[_DBIABA] = input[_DBIABA];
  }
  return entries;
}, "se_DescribeDBInstanceAutomatedBackupsMessage");
var se_DescribeDBInstancesMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeDBInstancesMessage");
var se_DescribeDBLogFilesMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_FC] != null) {
    entries[_FC] = input[_FC];
  }
  if (input[_FLW] != null) {
    entries[_FLW] = input[_FLW];
  }
  if (input[_FS] != null) {
    entries[_FS] = input[_FS];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeDBLogFilesMessage");
var se_DescribeDBMajorEngineVersionsRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_E] != null) {
    entries[_E] = input[_E];
  }
  if (input[_MEV] != null) {
    entries[_MEV] = input[_MEV];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  return entries;
}, "se_DescribeDBMajorEngineVersionsRequest");
var se_DescribeDBParameterGroupsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBPGN] != null) {
    entries[_DBPGN] = input[_DBPGN];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeDBParameterGroupsMessage");
var se_DescribeDBParametersMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBPGN] != null) {
    entries[_DBPGN] = input[_DBPGN];
  }
  if (input[_S] != null) {
    entries[_S] = input[_S];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeDBParametersMessage");
var se_DescribeDBProxiesRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBPN] != null) {
    entries[_DBPN] = input[_DBPN];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  return entries;
}, "se_DescribeDBProxiesRequest");
var se_DescribeDBProxyEndpointsRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBPN] != null) {
    entries[_DBPN] = input[_DBPN];
  }
  if (input[_DBPEN] != null) {
    entries[_DBPEN] = input[_DBPEN];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  return entries;
}, "se_DescribeDBProxyEndpointsRequest");
var se_DescribeDBProxyTargetGroupsRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBPN] != null) {
    entries[_DBPN] = input[_DBPN];
  }
  if (input[_TGN] != null) {
    entries[_TGN] = input[_TGN];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  return entries;
}, "se_DescribeDBProxyTargetGroupsRequest");
var se_DescribeDBProxyTargetsRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBPN] != null) {
    entries[_DBPN] = input[_DBPN];
  }
  if (input[_TGN] != null) {
    entries[_TGN] = input[_TGN];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  return entries;
}, "se_DescribeDBProxyTargetsRequest");
var se_DescribeDBRecommendationsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_LUA] != null) {
    entries[_LUA] = (0, import_smithy_client.serializeDateTime)(input[_LUA]);
  }
  if (input[_LUB] != null) {
    entries[_LUB] = (0, import_smithy_client.serializeDateTime)(input[_LUB]);
  }
  if (input[_L] != null) {
    entries[_L] = input[_L];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeDBRecommendationsMessage");
var se_DescribeDBSecurityGroupsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBSGN] != null) {
    entries[_DBSGN] = input[_DBSGN];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeDBSecurityGroupsMessage");
var se_DescribeDBShardGroupsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBSGI] != null) {
    entries[_DBSGI] = input[_DBSGI];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  return entries;
}, "se_DescribeDBShardGroupsMessage");
var se_DescribeDBSnapshotAttributesMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBSIn] != null) {
    entries[_DBSIn] = input[_DBSIn];
  }
  return entries;
}, "se_DescribeDBSnapshotAttributesMessage");
var se_DescribeDBSnapshotsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_DBSIn] != null) {
    entries[_DBSIn] = input[_DBSIn];
  }
  if (input[_STn] != null) {
    entries[_STn] = input[_STn];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  if (input[_IS] != null) {
    entries[_IS] = input[_IS];
  }
  if (input[_IP] != null) {
    entries[_IP] = input[_IP];
  }
  if (input[_DRI] != null) {
    entries[_DRI] = input[_DRI];
  }
  return entries;
}, "se_DescribeDBSnapshotsMessage");
var se_DescribeDBSnapshotTenantDatabasesMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_DBSIn] != null) {
    entries[_DBSIn] = input[_DBSIn];
  }
  if (input[_STn] != null) {
    entries[_STn] = input[_STn];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  if (input[_DRI] != null) {
    entries[_DRI] = input[_DRI];
  }
  return entries;
}, "se_DescribeDBSnapshotTenantDatabasesMessage");
var se_DescribeDBSubnetGroupsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBSGNu] != null) {
    entries[_DBSGNu] = input[_DBSGNu];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeDBSubnetGroupsMessage");
var se_DescribeEngineDefaultClusterParametersMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBPGF] != null) {
    entries[_DBPGF] = input[_DBPGF];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeEngineDefaultClusterParametersMessage");
var se_DescribeEngineDefaultParametersMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBPGF] != null) {
    entries[_DBPGF] = input[_DBPGF];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeEngineDefaultParametersMessage");
var se_DescribeEventCategoriesMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_STo] != null) {
    entries[_STo] = input[_STo];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_DescribeEventCategoriesMessage");
var se_DescribeEventsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SI] != null) {
    entries[_SI] = input[_SI];
  }
  if (input[_STo] != null) {
    entries[_STo] = input[_STo];
  }
  if (input[_STta] != null) {
    entries[_STta] = (0, import_smithy_client.serializeDateTime)(input[_STta]);
  }
  if (input[_ETn] != null) {
    entries[_ETn] = (0, import_smithy_client.serializeDateTime)(input[_ETn]);
  }
  if (input[_Du] != null) {
    entries[_Du] = input[_Du];
  }
  if (input[_EC] != null) {
    const memberEntries = se_EventCategoriesList(input[_EC], context);
    if (input[_EC]?.length === 0) {
      entries.EventCategories = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `EventCategories.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeEventsMessage");
var se_DescribeEventSubscriptionsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeEventSubscriptionsMessage");
var se_DescribeExportTasksMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_ETI] != null) {
    entries[_ETI] = input[_ETI];
  }
  if (input[_SA] != null) {
    entries[_SA] = input[_SA];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_STo] != null) {
    entries[_STo] = input[_STo];
  }
  return entries;
}, "se_DescribeExportTasksMessage");
var se_DescribeGlobalClustersMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_GCI] != null) {
    entries[_GCI] = input[_GCI];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeGlobalClustersMessage");
var se_DescribeIntegrationsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_IIn] != null) {
    entries[_IIn] = input[_IIn];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeIntegrationsMessage");
var se_DescribeOptionGroupOptionsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_EN] != null) {
    entries[_EN] = input[_EN];
  }
  if (input[_MEV] != null) {
    entries[_MEV] = input[_MEV];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeOptionGroupOptionsMessage");
var se_DescribeOptionGroupsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_OGN] != null) {
    entries[_OGN] = input[_OGN];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_EN] != null) {
    entries[_EN] = input[_EN];
  }
  if (input[_MEV] != null) {
    entries[_MEV] = input[_MEV];
  }
  return entries;
}, "se_DescribeOptionGroupsMessage");
var se_DescribeOrderableDBInstanceOptionsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_E] != null) {
    entries[_E] = input[_E];
  }
  if (input[_EV] != null) {
    entries[_EV] = input[_EV];
  }
  if (input[_DBIC] != null) {
    entries[_DBIC] = input[_DBIC];
  }
  if (input[_LM] != null) {
    entries[_LM] = input[_LM];
  }
  if (input[_AZG] != null) {
    entries[_AZG] = input[_AZG];
  }
  if (input[_Vp] != null) {
    entries[_Vp] = input[_Vp];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeOrderableDBInstanceOptionsMessage");
var se_DescribePendingMaintenanceActionsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RI] != null) {
    entries[_RI] = input[_RI];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  return entries;
}, "se_DescribePendingMaintenanceActionsMessage");
var se_DescribeReservedDBInstancesMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RDBII] != null) {
    entries[_RDBII] = input[_RDBII];
  }
  if (input[_RDBIOI] != null) {
    entries[_RDBIOI] = input[_RDBIOI];
  }
  if (input[_DBIC] != null) {
    entries[_DBIC] = input[_DBIC];
  }
  if (input[_Du] != null) {
    entries[_Du] = input[_Du];
  }
  if (input[_PD] != null) {
    entries[_PD] = input[_PD];
  }
  if (input[_OT] != null) {
    entries[_OT] = input[_OT];
  }
  if (input[_MAZ] != null) {
    entries[_MAZ] = input[_MAZ];
  }
  if (input[_LI] != null) {
    entries[_LI] = input[_LI];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeReservedDBInstancesMessage");
var se_DescribeReservedDBInstancesOfferingsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RDBIOI] != null) {
    entries[_RDBIOI] = input[_RDBIOI];
  }
  if (input[_DBIC] != null) {
    entries[_DBIC] = input[_DBIC];
  }
  if (input[_Du] != null) {
    entries[_Du] = input[_Du];
  }
  if (input[_PD] != null) {
    entries[_PD] = input[_PD];
  }
  if (input[_OT] != null) {
    entries[_OT] = input[_OT];
  }
  if (input[_MAZ] != null) {
    entries[_MAZ] = input[_MAZ];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  return entries;
}, "se_DescribeReservedDBInstancesOfferingsMessage");
var se_DescribeSourceRegionsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RNe] != null) {
    entries[_RNe] = input[_RNe];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_DescribeSourceRegionsMessage");
var se_DescribeTenantDatabasesMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_TDBN] != null) {
    entries[_TDBN] = input[_TDBN];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  if (input[_MR] != null) {
    entries[_MR] = input[_MR];
  }
  return entries;
}, "se_DescribeTenantDatabasesMessage");
var se_DescribeValidDBInstanceModificationsMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  return entries;
}, "se_DescribeValidDBInstanceModificationsMessage");
var se_DisableHttpEndpointRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RAe] != null) {
    entries[_RAe] = input[_RAe];
  }
  return entries;
}, "se_DisableHttpEndpointRequest");
var se_DownloadDBLogFilePortionMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_LFN] != null) {
    entries[_LFN] = input[_LFN];
  }
  if (input[_Ma] != null) {
    entries[_Ma] = input[_Ma];
  }
  if (input[_NOL] != null) {
    entries[_NOL] = input[_NOL];
  }
  return entries;
}, "se_DownloadDBLogFilePortionMessage");
var se_EnableHttpEndpointRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RAe] != null) {
    entries[_RAe] = input[_RAe];
  }
  return entries;
}, "se_EnableHttpEndpointRequest");
var se_EncryptionContextMap = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  Object.keys(input).filter((key) => input[key] != null).forEach((key) => {
    entries[`entry.${counter}.key`] = key;
    entries[`entry.${counter}.value`] = input[key];
    counter++;
  });
  return entries;
}, "se_EncryptionContextMap");
var se_EngineModeList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_EngineModeList");
var se_EventCategoriesList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`EventCategory.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_EventCategoriesList");
var se_FailoverDBClusterMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  if (input[_TDBII] != null) {
    entries[_TDBII] = input[_TDBII];
  }
  return entries;
}, "se_FailoverDBClusterMessage");
var se_FailoverGlobalClusterMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_GCI] != null) {
    entries[_GCI] = input[_GCI];
  }
  if (input[_TDCI] != null) {
    entries[_TDCI] = input[_TDCI];
  }
  if (input[_ADL] != null) {
    entries[_ADL] = input[_ADL];
  }
  if (input[_Sw] != null) {
    entries[_Sw] = input[_Sw];
  }
  return entries;
}, "se_FailoverGlobalClusterMessage");
var se_Filter = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_N] != null) {
    entries[_N] = input[_N];
  }
  if (input[_Va] != null) {
    const memberEntries = se_FilterValueList(input[_Va], context);
    if (input[_Va]?.length === 0) {
      entries.Values = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Values.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_Filter");
var se_FilterList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    const memberEntries = se_Filter(entry, context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      entries[`Filter.${counter}.${key}`] = value;
    });
    counter++;
  }
  return entries;
}, "se_FilterList");
var se_FilterValueList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`Value.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_FilterValueList");
var se_KeyList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_KeyList");
var se_ListTagsForResourceMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RN] != null) {
    entries[_RN] = input[_RN];
  }
  if (input[_Fi] != null) {
    const memberEntries = se_FilterList(input[_Fi], context);
    if (input[_Fi]?.length === 0) {
      entries.Filters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Filters.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_ListTagsForResourceMessage");
var se_LogTypeList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_LogTypeList");
var se_ModifyActivityStreamRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RAe] != null) {
    entries[_RAe] = input[_RAe];
  }
  if (input[_APS] != null) {
    entries[_APS] = input[_APS];
  }
  return entries;
}, "se_ModifyActivityStreamRequest");
var se_ModifyCertificatesMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_CIe] != null) {
    entries[_CIe] = input[_CIe];
  }
  if (input[_RCO] != null) {
    entries[_RCO] = input[_RCO];
  }
  return entries;
}, "se_ModifyCertificatesMessage");
var se_ModifyCurrentDBClusterCapacityMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  if (input[_C] != null) {
    entries[_C] = input[_C];
  }
  if (input[_SBT] != null) {
    entries[_SBT] = input[_SBT];
  }
  if (input[_TAi] != null) {
    entries[_TAi] = input[_TAi];
  }
  return entries;
}, "se_ModifyCurrentDBClusterCapacityMessage");
var se_ModifyCustomDBEngineVersionMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_E] != null) {
    entries[_E] = input[_E];
  }
  if (input[_EV] != null) {
    entries[_EV] = input[_EV];
  }
  if (input[_D] != null) {
    entries[_D] = input[_D];
  }
  if (input[_St] != null) {
    entries[_St] = input[_St];
  }
  return entries;
}, "se_ModifyCustomDBEngineVersionMessage");
var se_ModifyDBClusterEndpointMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCEI] != null) {
    entries[_DBCEI] = input[_DBCEI];
  }
  if (input[_ET] != null) {
    entries[_ET] = input[_ET];
  }
  if (input[_SM] != null) {
    const memberEntries = se_StringList(input[_SM], context);
    if (input[_SM]?.length === 0) {
      entries.StaticMembers = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `StaticMembers.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_EM] != null) {
    const memberEntries = se_StringList(input[_EM], context);
    if (input[_EM]?.length === 0) {
      entries.ExcludedMembers = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ExcludedMembers.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_ModifyDBClusterEndpointMessage");
var se_ModifyDBClusterMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  if (input[_NDBCI] != null) {
    entries[_NDBCI] = input[_NDBCI];
  }
  if (input[_AI] != null) {
    entries[_AI] = input[_AI];
  }
  if (input[_BRP] != null) {
    entries[_BRP] = input[_BRP];
  }
  if (input[_DBCPGN] != null) {
    entries[_DBCPGN] = input[_DBCPGN];
  }
  if (input[_VSGI] != null) {
    const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
    if (input[_VSGI]?.length === 0) {
      entries.VpcSecurityGroupIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `VpcSecurityGroupIds.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_P] != null) {
    entries[_P] = input[_P];
  }
  if (input[_MUP] != null) {
    entries[_MUP] = input[_MUP];
  }
  if (input[_OGN] != null) {
    entries[_OGN] = input[_OGN];
  }
  if (input[_PBW] != null) {
    entries[_PBW] = input[_PBW];
  }
  if (input[_PMW] != null) {
    entries[_PMW] = input[_PMW];
  }
  if (input[_EIAMDA] != null) {
    entries[_EIAMDA] = input[_EIAMDA];
  }
  if (input[_BW] != null) {
    entries[_BW] = input[_BW];
  }
  if (input[_CLEC] != null) {
    const memberEntries = se_CloudwatchLogsExportConfiguration(input[_CLEC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `CloudwatchLogsExportConfiguration.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_EV] != null) {
    entries[_EV] = input[_EV];
  }
  if (input[_AMVUl] != null) {
    entries[_AMVUl] = input[_AMVUl];
  }
  if (input[_DBIPGN] != null) {
    entries[_DBIPGN] = input[_DBIPGN];
  }
  if (input[_Do] != null) {
    entries[_Do] = input[_Do];
  }
  if (input[_DIAMRN] != null) {
    entries[_DIAMRN] = input[_DIAMRN];
  }
  if (input[_SC] != null) {
    const memberEntries = se_ScalingConfiguration(input[_SC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ScalingConfiguration.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_DP] != null) {
    entries[_DP] = input[_DP];
  }
  if (input[_EHE] != null) {
    entries[_EHE] = input[_EHE];
  }
  if (input[_CTTS] != null) {
    entries[_CTTS] = input[_CTTS];
  }
  if (input[_EGWF] != null) {
    entries[_EGWF] = input[_EGWF];
  }
  if (input[_DBCIC] != null) {
    entries[_DBCIC] = input[_DBCIC];
  }
  if (input[_AS] != null) {
    entries[_AS] = input[_AS];
  }
  if (input[_STt] != null) {
    entries[_STt] = input[_STt];
  }
  if (input[_I] != null) {
    entries[_I] = input[_I];
  }
  if (input[_AMVU] != null) {
    entries[_AMVU] = input[_AMVU];
  }
  if (input[_MIo] != null) {
    entries[_MIo] = input[_MIo];
  }
  if (input[_MRA] != null) {
    entries[_MRA] = input[_MRA];
  }
  if (input[_DIM] != null) {
    entries[_DIM] = input[_DIM];
  }
  if (input[_EPI] != null) {
    entries[_EPI] = input[_EPI];
  }
  if (input[_PIKMSKI] != null) {
    entries[_PIKMSKI] = input[_PIKMSKI];
  }
  if (input[_PIRP] != null) {
    entries[_PIRP] = input[_PIRP];
  }
  if (input[_SVSC] != null) {
    const memberEntries = se_ServerlessV2ScalingConfiguration(input[_SVSC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ServerlessV2ScalingConfiguration.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_MMUP] != null) {
    entries[_MMUP] = input[_MMUP];
  }
  if (input[_RMUP] != null) {
    entries[_RMUP] = input[_RMUP];
  }
  if (input[_MUSKKI] != null) {
    entries[_MUSKKI] = input[_MUSKKI];
  }
  if (input[_EMn] != null) {
    entries[_EMn] = input[_EMn];
  }
  if (input[_AEMC] != null) {
    entries[_AEMC] = input[_AEMC];
  }
  if (input[_ELWF] != null) {
    entries[_ELWF] = input[_ELWF];
  }
  if (input[_ABRPA] != null) {
    entries[_ABRPA] = input[_ABRPA];
  }
  if (input[_ELD] != null) {
    entries[_ELD] = input[_ELD];
  }
  if (input[_CACI] != null) {
    entries[_CACI] = input[_CACI];
  }
  return entries;
}, "se_ModifyDBClusterMessage");
var se_ModifyDBClusterParameterGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCPGN] != null) {
    entries[_DBCPGN] = input[_DBCPGN];
  }
  if (input[_Pa] != null) {
    const memberEntries = se_ParametersList(input[_Pa], context);
    if (input[_Pa]?.length === 0) {
      entries.Parameters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Parameters.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_ModifyDBClusterParameterGroupMessage");
var se_ModifyDBClusterSnapshotAttributeMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCSI] != null) {
    entries[_DBCSI] = input[_DBCSI];
  }
  if (input[_AN] != null) {
    entries[_AN] = input[_AN];
  }
  if (input[_VTA] != null) {
    const memberEntries = se_AttributeValueList(input[_VTA], context);
    if (input[_VTA]?.length === 0) {
      entries.ValuesToAdd = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ValuesToAdd.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_VTR] != null) {
    const memberEntries = se_AttributeValueList(input[_VTR], context);
    if (input[_VTR]?.length === 0) {
      entries.ValuesToRemove = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ValuesToRemove.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_ModifyDBClusterSnapshotAttributeMessage");
var se_ModifyDBInstanceMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_AS] != null) {
    entries[_AS] = input[_AS];
  }
  if (input[_DBIC] != null) {
    entries[_DBIC] = input[_DBIC];
  }
  if (input[_DBSGNu] != null) {
    entries[_DBSGNu] = input[_DBSGNu];
  }
  if (input[_DBSG] != null) {
    const memberEntries = se_DBSecurityGroupNameList(input[_DBSG], context);
    if (input[_DBSG]?.length === 0) {
      entries.DBSecurityGroups = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `DBSecurityGroups.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_VSGI] != null) {
    const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
    if (input[_VSGI]?.length === 0) {
      entries.VpcSecurityGroupIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `VpcSecurityGroupIds.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_AI] != null) {
    entries[_AI] = input[_AI];
  }
  if (input[_MUP] != null) {
    entries[_MUP] = input[_MUP];
  }
  if (input[_DBPGN] != null) {
    entries[_DBPGN] = input[_DBPGN];
  }
  if (input[_BRP] != null) {
    entries[_BRP] = input[_BRP];
  }
  if (input[_PBW] != null) {
    entries[_PBW] = input[_PBW];
  }
  if (input[_PMW] != null) {
    entries[_PMW] = input[_PMW];
  }
  if (input[_MAZ] != null) {
    entries[_MAZ] = input[_MAZ];
  }
  if (input[_EV] != null) {
    entries[_EV] = input[_EV];
  }
  if (input[_AMVUl] != null) {
    entries[_AMVUl] = input[_AMVUl];
  }
  if (input[_AMVU] != null) {
    entries[_AMVU] = input[_AMVU];
  }
  if (input[_LM] != null) {
    entries[_LM] = input[_LM];
  }
  if (input[_I] != null) {
    entries[_I] = input[_I];
  }
  if (input[_OGN] != null) {
    entries[_OGN] = input[_OGN];
  }
  if (input[_NDBII] != null) {
    entries[_NDBII] = input[_NDBII];
  }
  if (input[_STt] != null) {
    entries[_STt] = input[_STt];
  }
  if (input[_TCA] != null) {
    entries[_TCA] = input[_TCA];
  }
  if (input[_TCP] != null) {
    entries[_TCP] = input[_TCP];
  }
  if (input[_CACI] != null) {
    entries[_CACI] = input[_CACI];
  }
  if (input[_Do] != null) {
    entries[_Do] = input[_Do];
  }
  if (input[_DF] != null) {
    entries[_DF] = input[_DF];
  }
  if (input[_DO] != null) {
    entries[_DO] = input[_DO];
  }
  if (input[_DASA] != null) {
    entries[_DASA] = input[_DASA];
  }
  if (input[_DDI] != null) {
    const memberEntries = se_StringList(input[_DDI], context);
    if (input[_DDI]?.length === 0) {
      entries.DomainDnsIps = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `DomainDnsIps.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_CTTS] != null) {
    entries[_CTTS] = input[_CTTS];
  }
  if (input[_MIo] != null) {
    entries[_MIo] = input[_MIo];
  }
  if (input[_DBPNo] != null) {
    entries[_DBPNo] = input[_DBPNo];
  }
  if (input[_PA] != null) {
    entries[_PA] = input[_PA];
  }
  if (input[_MRA] != null) {
    entries[_MRA] = input[_MRA];
  }
  if (input[_DIAMRN] != null) {
    entries[_DIAMRN] = input[_DIAMRN];
  }
  if (input[_DD] != null) {
    entries[_DD] = input[_DD];
  }
  if (input[_PT] != null) {
    entries[_PT] = input[_PT];
  }
  if (input[_EIAMDA] != null) {
    entries[_EIAMDA] = input[_EIAMDA];
  }
  if (input[_DIM] != null) {
    entries[_DIM] = input[_DIM];
  }
  if (input[_EPI] != null) {
    entries[_EPI] = input[_EPI];
  }
  if (input[_PIKMSKI] != null) {
    entries[_PIKMSKI] = input[_PIKMSKI];
  }
  if (input[_PIRP] != null) {
    entries[_PIRP] = input[_PIRP];
  }
  if (input[_CLEC] != null) {
    const memberEntries = se_CloudwatchLogsExportConfiguration(input[_CLEC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `CloudwatchLogsExportConfiguration.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_PF] != null) {
    const memberEntries = se_ProcessorFeatureList(input[_PF], context);
    if (input[_PF]?.length === 0) {
      entries.ProcessorFeatures = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ProcessorFeatures.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_UDPF] != null) {
    entries[_UDPF] = input[_UDPF];
  }
  if (input[_DP] != null) {
    entries[_DP] = input[_DP];
  }
  if (input[_MASa] != null) {
    entries[_MASa] = input[_MASa];
  }
  if (input[_CRR] != null) {
    entries[_CRR] = input[_CRR];
  }
  if (input[_RM] != null) {
    entries[_RM] = input[_RM];
  }
  if (input[_ECOI] != null) {
    entries[_ECOI] = input[_ECOI];
  }
  if (input[_ABRPA] != null) {
    entries[_ABRPA] = input[_ABRPA];
  }
  if (input[_AM] != null) {
    entries[_AM] = input[_AM];
  }
  if (input[_RFAMM] != null) {
    entries[_RFAMM] = input[_RFAMM];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_STto] != null) {
    entries[_STto] = input[_STto];
  }
  if (input[_MMUP] != null) {
    entries[_MMUP] = input[_MMUP];
  }
  if (input[_RMUP] != null) {
    entries[_RMUP] = input[_RMUP];
  }
  if (input[_MUSKKI] != null) {
    entries[_MUSKKI] = input[_MUSKKI];
  }
  if (input[_E] != null) {
    entries[_E] = input[_E];
  }
  if (input[_DLV] != null) {
    entries[_DLV] = input[_DLV];
  }
  if (input[_MT] != null) {
    entries[_MT] = input[_MT];
  }
  return entries;
}, "se_ModifyDBInstanceMessage");
var se_ModifyDBParameterGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBPGN] != null) {
    entries[_DBPGN] = input[_DBPGN];
  }
  if (input[_Pa] != null) {
    const memberEntries = se_ParametersList(input[_Pa], context);
    if (input[_Pa]?.length === 0) {
      entries.Parameters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Parameters.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_ModifyDBParameterGroupMessage");
var se_ModifyDBProxyEndpointRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBPEN] != null) {
    entries[_DBPEN] = input[_DBPEN];
  }
  if (input[_NDBPEN] != null) {
    entries[_NDBPEN] = input[_NDBPEN];
  }
  if (input[_VSGI] != null) {
    const memberEntries = se_StringList(input[_VSGI], context);
    if (input[_VSGI]?.length === 0) {
      entries.VpcSecurityGroupIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `VpcSecurityGroupIds.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_ModifyDBProxyEndpointRequest");
var se_ModifyDBProxyRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBPN] != null) {
    entries[_DBPN] = input[_DBPN];
  }
  if (input[_NDBPN] != null) {
    entries[_NDBPN] = input[_NDBPN];
  }
  if (input[_Au] != null) {
    const memberEntries = se_UserAuthConfigList(input[_Au], context);
    if (input[_Au]?.length === 0) {
      entries.Auth = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Auth.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_RTLS] != null) {
    entries[_RTLS] = input[_RTLS];
  }
  if (input[_ICT] != null) {
    entries[_ICT] = input[_ICT];
  }
  if (input[_DL] != null) {
    entries[_DL] = input[_DL];
  }
  if (input[_RA] != null) {
    entries[_RA] = input[_RA];
  }
  if (input[_SG] != null) {
    const memberEntries = se_StringList(input[_SG], context);
    if (input[_SG]?.length === 0) {
      entries.SecurityGroups = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `SecurityGroups.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_ModifyDBProxyRequest");
var se_ModifyDBProxyTargetGroupRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_TGN] != null) {
    entries[_TGN] = input[_TGN];
  }
  if (input[_DBPN] != null) {
    entries[_DBPN] = input[_DBPN];
  }
  if (input[_CPC] != null) {
    const memberEntries = se_ConnectionPoolConfiguration(input[_CPC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ConnectionPoolConfig.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_NN] != null) {
    entries[_NN] = input[_NN];
  }
  return entries;
}, "se_ModifyDBProxyTargetGroupRequest");
var se_ModifyDBRecommendationMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RIe] != null) {
    entries[_RIe] = input[_RIe];
  }
  if (input[_L] != null) {
    entries[_L] = input[_L];
  }
  if (input[_St] != null) {
    entries[_St] = input[_St];
  }
  if (input[_RAU] != null) {
    const memberEntries = se_RecommendedActionUpdateList(input[_RAU], context);
    if (input[_RAU]?.length === 0) {
      entries.RecommendedActionUpdates = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `RecommendedActionUpdates.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_ModifyDBRecommendationMessage");
var se_ModifyDBShardGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBSGI] != null) {
    entries[_DBSGI] = input[_DBSGI];
  }
  if (input[_MACU] != null) {
    entries[_MACU] = (0, import_smithy_client.serializeFloat)(input[_MACU]);
  }
  if (input[_MACUi] != null) {
    entries[_MACUi] = (0, import_smithy_client.serializeFloat)(input[_MACUi]);
  }
  if (input[_CR] != null) {
    entries[_CR] = input[_CR];
  }
  return entries;
}, "se_ModifyDBShardGroupMessage");
var se_ModifyDBSnapshotAttributeMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBSIn] != null) {
    entries[_DBSIn] = input[_DBSIn];
  }
  if (input[_AN] != null) {
    entries[_AN] = input[_AN];
  }
  if (input[_VTA] != null) {
    const memberEntries = se_AttributeValueList(input[_VTA], context);
    if (input[_VTA]?.length === 0) {
      entries.ValuesToAdd = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ValuesToAdd.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_VTR] != null) {
    const memberEntries = se_AttributeValueList(input[_VTR], context);
    if (input[_VTR]?.length === 0) {
      entries.ValuesToRemove = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ValuesToRemove.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_ModifyDBSnapshotAttributeMessage");
var se_ModifyDBSnapshotMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBSIn] != null) {
    entries[_DBSIn] = input[_DBSIn];
  }
  if (input[_EV] != null) {
    entries[_EV] = input[_EV];
  }
  if (input[_OGN] != null) {
    entries[_OGN] = input[_OGN];
  }
  return entries;
}, "se_ModifyDBSnapshotMessage");
var se_ModifyDBSubnetGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBSGNu] != null) {
    entries[_DBSGNu] = input[_DBSGNu];
  }
  if (input[_DBSGDu] != null) {
    entries[_DBSGDu] = input[_DBSGDu];
  }
  if (input[_SIu] != null) {
    const memberEntries = se_SubnetIdentifierList(input[_SIu], context);
    if (input[_SIu]?.length === 0) {
      entries.SubnetIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `SubnetIds.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_ModifyDBSubnetGroupMessage");
var se_ModifyEventSubscriptionMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_STA] != null) {
    entries[_STA] = input[_STA];
  }
  if (input[_STo] != null) {
    entries[_STo] = input[_STo];
  }
  if (input[_EC] != null) {
    const memberEntries = se_EventCategoriesList(input[_EC], context);
    if (input[_EC]?.length === 0) {
      entries.EventCategories = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `EventCategories.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_En] != null) {
    entries[_En] = input[_En];
  }
  return entries;
}, "se_ModifyEventSubscriptionMessage");
var se_ModifyGlobalClusterMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_GCI] != null) {
    entries[_GCI] = input[_GCI];
  }
  if (input[_NGCI] != null) {
    entries[_NGCI] = input[_NGCI];
  }
  if (input[_DP] != null) {
    entries[_DP] = input[_DP];
  }
  if (input[_EV] != null) {
    entries[_EV] = input[_EV];
  }
  if (input[_AMVUl] != null) {
    entries[_AMVUl] = input[_AMVUl];
  }
  return entries;
}, "se_ModifyGlobalClusterMessage");
var se_ModifyIntegrationMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_IIn] != null) {
    entries[_IIn] = input[_IIn];
  }
  if (input[_IN] != null) {
    entries[_IN] = input[_IN];
  }
  if (input[_DFa] != null) {
    entries[_DFa] = input[_DFa];
  }
  if (input[_D] != null) {
    entries[_D] = input[_D];
  }
  return entries;
}, "se_ModifyIntegrationMessage");
var se_ModifyOptionGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_OGN] != null) {
    entries[_OGN] = input[_OGN];
  }
  if (input[_OTI] != null) {
    const memberEntries = se_OptionConfigurationList(input[_OTI], context);
    if (input[_OTI]?.length === 0) {
      entries.OptionsToInclude = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `OptionsToInclude.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_OTR] != null) {
    const memberEntries = se_OptionNamesList(input[_OTR], context);
    if (input[_OTR]?.length === 0) {
      entries.OptionsToRemove = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `OptionsToRemove.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_AI] != null) {
    entries[_AI] = input[_AI];
  }
  return entries;
}, "se_ModifyOptionGroupMessage");
var se_ModifyTenantDatabaseMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_TDBN] != null) {
    entries[_TDBN] = input[_TDBN];
  }
  if (input[_MUP] != null) {
    entries[_MUP] = input[_MUP];
  }
  if (input[_NTDBN] != null) {
    entries[_NTDBN] = input[_NTDBN];
  }
  if (input[_MMUP] != null) {
    entries[_MMUP] = input[_MMUP];
  }
  if (input[_RMUP] != null) {
    entries[_RMUP] = input[_RMUP];
  }
  if (input[_MUSKKI] != null) {
    entries[_MUSKKI] = input[_MUSKKI];
  }
  return entries;
}, "se_ModifyTenantDatabaseMessage");
var se_OptionConfiguration = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_ON] != null) {
    entries[_ON] = input[_ON];
  }
  if (input[_P] != null) {
    entries[_P] = input[_P];
  }
  if (input[_OV] != null) {
    entries[_OV] = input[_OV];
  }
  if (input[_DBSGM] != null) {
    const memberEntries = se_DBSecurityGroupNameList(input[_DBSGM], context);
    if (input[_DBSGM]?.length === 0) {
      entries.DBSecurityGroupMemberships = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `DBSecurityGroupMemberships.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_VSGM] != null) {
    const memberEntries = se_VpcSecurityGroupIdList(input[_VSGM], context);
    if (input[_VSGM]?.length === 0) {
      entries.VpcSecurityGroupMemberships = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `VpcSecurityGroupMemberships.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_OS] != null) {
    const memberEntries = se_OptionSettingsList(input[_OS], context);
    if (input[_OS]?.length === 0) {
      entries.OptionSettings = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `OptionSettings.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_OptionConfiguration");
var se_OptionConfigurationList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    const memberEntries = se_OptionConfiguration(entry, context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      entries[`OptionConfiguration.${counter}.${key}`] = value;
    });
    counter++;
  }
  return entries;
}, "se_OptionConfigurationList");
var se_OptionNamesList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_OptionNamesList");
var se_OptionSetting = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_N] != null) {
    entries[_N] = input[_N];
  }
  if (input[_Val] != null) {
    entries[_Val] = input[_Val];
  }
  if (input[_DV] != null) {
    entries[_DV] = input[_DV];
  }
  if (input[_D] != null) {
    entries[_D] = input[_D];
  }
  if (input[_AT] != null) {
    entries[_AT] = input[_AT];
  }
  if (input[_DTa] != null) {
    entries[_DTa] = input[_DTa];
  }
  if (input[_AV] != null) {
    entries[_AV] = input[_AV];
  }
  if (input[_IM] != null) {
    entries[_IM] = input[_IM];
  }
  if (input[_IC] != null) {
    entries[_IC] = input[_IC];
  }
  return entries;
}, "se_OptionSetting");
var se_OptionSettingsList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    const memberEntries = se_OptionSetting(entry, context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      entries[`OptionSetting.${counter}.${key}`] = value;
    });
    counter++;
  }
  return entries;
}, "se_OptionSettingsList");
var se_Parameter = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_PN] != null) {
    entries[_PN] = input[_PN];
  }
  if (input[_PV] != null) {
    entries[_PV] = input[_PV];
  }
  if (input[_D] != null) {
    entries[_D] = input[_D];
  }
  if (input[_S] != null) {
    entries[_S] = input[_S];
  }
  if (input[_AT] != null) {
    entries[_AT] = input[_AT];
  }
  if (input[_DTa] != null) {
    entries[_DTa] = input[_DTa];
  }
  if (input[_AV] != null) {
    entries[_AV] = input[_AV];
  }
  if (input[_IM] != null) {
    entries[_IM] = input[_IM];
  }
  if (input[_MEVi] != null) {
    entries[_MEVi] = input[_MEVi];
  }
  if (input[_AMp] != null) {
    entries[_AMp] = input[_AMp];
  }
  if (input[_SEM] != null) {
    const memberEntries = se_EngineModeList(input[_SEM], context);
    if (input[_SEM]?.length === 0) {
      entries.SupportedEngineModes = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `SupportedEngineModes.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_Parameter");
var se_ParametersList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    const memberEntries = se_Parameter(entry, context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      entries[`Parameter.${counter}.${key}`] = value;
    });
    counter++;
  }
  return entries;
}, "se_ParametersList");
var se_ProcessorFeature = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_N] != null) {
    entries[_N] = input[_N];
  }
  if (input[_Val] != null) {
    entries[_Val] = input[_Val];
  }
  return entries;
}, "se_ProcessorFeature");
var se_ProcessorFeatureList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    const memberEntries = se_ProcessorFeature(entry, context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      entries[`ProcessorFeature.${counter}.${key}`] = value;
    });
    counter++;
  }
  return entries;
}, "se_ProcessorFeatureList");
var se_PromoteReadReplicaDBClusterMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  return entries;
}, "se_PromoteReadReplicaDBClusterMessage");
var se_PromoteReadReplicaMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_BRP] != null) {
    entries[_BRP] = input[_BRP];
  }
  if (input[_PBW] != null) {
    entries[_PBW] = input[_PBW];
  }
  return entries;
}, "se_PromoteReadReplicaMessage");
var se_PurchaseReservedDBInstancesOfferingMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RDBIOI] != null) {
    entries[_RDBIOI] = input[_RDBIOI];
  }
  if (input[_RDBII] != null) {
    entries[_RDBII] = input[_RDBII];
  }
  if (input[_DBICn] != null) {
    entries[_DBICn] = input[_DBICn];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_PurchaseReservedDBInstancesOfferingMessage");
var se_RdsCustomClusterConfiguration = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_ISI] != null) {
    entries[_ISI] = input[_ISI];
  }
  if (input[_TGMDI] != null) {
    entries[_TGMDI] = input[_TGMDI];
  }
  if (input[_RM] != null) {
    entries[_RM] = input[_RM];
  }
  return entries;
}, "se_RdsCustomClusterConfiguration");
var se_RebootDBClusterMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  return entries;
}, "se_RebootDBClusterMessage");
var se_RebootDBInstanceMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_FF] != null) {
    entries[_FF] = input[_FF];
  }
  return entries;
}, "se_RebootDBInstanceMessage");
var se_RebootDBShardGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBSGI] != null) {
    entries[_DBSGI] = input[_DBSGI];
  }
  return entries;
}, "se_RebootDBShardGroupMessage");
var se_RecommendedActionUpdate = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_AIc] != null) {
    entries[_AIc] = input[_AIc];
  }
  if (input[_St] != null) {
    entries[_St] = input[_St];
  }
  return entries;
}, "se_RecommendedActionUpdate");
var se_RecommendedActionUpdateList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    const memberEntries = se_RecommendedActionUpdate(entry, context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      entries[`member.${counter}.${key}`] = value;
    });
    counter++;
  }
  return entries;
}, "se_RecommendedActionUpdateList");
var se_RegisterDBProxyTargetsRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBPN] != null) {
    entries[_DBPN] = input[_DBPN];
  }
  if (input[_TGN] != null) {
    entries[_TGN] = input[_TGN];
  }
  if (input[_DBIIn] != null) {
    const memberEntries = se_StringList(input[_DBIIn], context);
    if (input[_DBIIn]?.length === 0) {
      entries.DBInstanceIdentifiers = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `DBInstanceIdentifiers.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_DBCIl] != null) {
    const memberEntries = se_StringList(input[_DBCIl], context);
    if (input[_DBCIl]?.length === 0) {
      entries.DBClusterIdentifiers = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `DBClusterIdentifiers.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_RegisterDBProxyTargetsRequest");
var se_RemoveFromGlobalClusterMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_GCI] != null) {
    entries[_GCI] = input[_GCI];
  }
  if (input[_DCI] != null) {
    entries[_DCI] = input[_DCI];
  }
  return entries;
}, "se_RemoveFromGlobalClusterMessage");
var se_RemoveRoleFromDBClusterMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  if (input[_RA] != null) {
    entries[_RA] = input[_RA];
  }
  if (input[_FN] != null) {
    entries[_FN] = input[_FN];
  }
  return entries;
}, "se_RemoveRoleFromDBClusterMessage");
var se_RemoveRoleFromDBInstanceMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_RA] != null) {
    entries[_RA] = input[_RA];
  }
  if (input[_FN] != null) {
    entries[_FN] = input[_FN];
  }
  return entries;
}, "se_RemoveRoleFromDBInstanceMessage");
var se_RemoveSourceIdentifierFromSubscriptionMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SN] != null) {
    entries[_SN] = input[_SN];
  }
  if (input[_SI] != null) {
    entries[_SI] = input[_SI];
  }
  return entries;
}, "se_RemoveSourceIdentifierFromSubscriptionMessage");
var se_RemoveTagsFromResourceMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RN] != null) {
    entries[_RN] = input[_RN];
  }
  if (input[_TK] != null) {
    const memberEntries = se_KeyList(input[_TK], context);
    if (input[_TK]?.length === 0) {
      entries.TagKeys = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `TagKeys.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_RemoveTagsFromResourceMessage");
var se_ResetDBClusterParameterGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCPGN] != null) {
    entries[_DBCPGN] = input[_DBCPGN];
  }
  if (input[_RAP] != null) {
    entries[_RAP] = input[_RAP];
  }
  if (input[_Pa] != null) {
    const memberEntries = se_ParametersList(input[_Pa], context);
    if (input[_Pa]?.length === 0) {
      entries.Parameters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Parameters.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_ResetDBClusterParameterGroupMessage");
var se_ResetDBParameterGroupMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBPGN] != null) {
    entries[_DBPGN] = input[_DBPGN];
  }
  if (input[_RAP] != null) {
    entries[_RAP] = input[_RAP];
  }
  if (input[_Pa] != null) {
    const memberEntries = se_ParametersList(input[_Pa], context);
    if (input[_Pa]?.length === 0) {
      entries.Parameters = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Parameters.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_ResetDBParameterGroupMessage");
var se_RestoreDBClusterFromS3Message = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_AZ] != null) {
    const memberEntries = se_AvailabilityZones(input[_AZ], context);
    if (input[_AZ]?.length === 0) {
      entries.AvailabilityZones = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `AvailabilityZones.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_BRP] != null) {
    entries[_BRP] = input[_BRP];
  }
  if (input[_CSN] != null) {
    entries[_CSN] = input[_CSN];
  }
  if (input[_DN] != null) {
    entries[_DN] = input[_DN];
  }
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  if (input[_DBCPGN] != null) {
    entries[_DBCPGN] = input[_DBCPGN];
  }
  if (input[_VSGI] != null) {
    const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
    if (input[_VSGI]?.length === 0) {
      entries.VpcSecurityGroupIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `VpcSecurityGroupIds.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_DBSGNu] != null) {
    entries[_DBSGNu] = input[_DBSGNu];
  }
  if (input[_E] != null) {
    entries[_E] = input[_E];
  }
  if (input[_EV] != null) {
    entries[_EV] = input[_EV];
  }
  if (input[_P] != null) {
    entries[_P] = input[_P];
  }
  if (input[_MU] != null) {
    entries[_MU] = input[_MU];
  }
  if (input[_MUP] != null) {
    entries[_MUP] = input[_MUP];
  }
  if (input[_OGN] != null) {
    entries[_OGN] = input[_OGN];
  }
  if (input[_PBW] != null) {
    entries[_PBW] = input[_PBW];
  }
  if (input[_PMW] != null) {
    entries[_PMW] = input[_PMW];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_SE] != null) {
    entries[_SE] = input[_SE];
  }
  if (input[_KKI] != null) {
    entries[_KKI] = input[_KKI];
  }
  if (input[_EIAMDA] != null) {
    entries[_EIAMDA] = input[_EIAMDA];
  }
  if (input[_SEo] != null) {
    entries[_SEo] = input[_SEo];
  }
  if (input[_SEV] != null) {
    entries[_SEV] = input[_SEV];
  }
  if (input[_SBN] != null) {
    entries[_SBN] = input[_SBN];
  }
  if (input[_SP] != null) {
    entries[_SP] = input[_SP];
  }
  if (input[_SIRA] != null) {
    entries[_SIRA] = input[_SIRA];
  }
  if (input[_BW] != null) {
    entries[_BW] = input[_BW];
  }
  if (input[_ECLE] != null) {
    const memberEntries = se_LogTypeList(input[_ECLE], context);
    if (input[_ECLE]?.length === 0) {
      entries.EnableCloudwatchLogsExports = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `EnableCloudwatchLogsExports.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_DP] != null) {
    entries[_DP] = input[_DP];
  }
  if (input[_CTTS] != null) {
    entries[_CTTS] = input[_CTTS];
  }
  if (input[_Do] != null) {
    entries[_Do] = input[_Do];
  }
  if (input[_DIAMRN] != null) {
    entries[_DIAMRN] = input[_DIAMRN];
  }
  if (input[_SVSC] != null) {
    const memberEntries = se_ServerlessV2ScalingConfiguration(input[_SVSC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ServerlessV2ScalingConfiguration.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_MMUP] != null) {
    entries[_MMUP] = input[_MMUP];
  }
  if (input[_MUSKKI] != null) {
    entries[_MUSKKI] = input[_MUSKKI];
  }
  if (input[_STt] != null) {
    entries[_STt] = input[_STt];
  }
  if (input[_ELS] != null) {
    entries[_ELS] = input[_ELS];
  }
  return entries;
}, "se_RestoreDBClusterFromS3Message");
var se_RestoreDBClusterFromSnapshotMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_AZ] != null) {
    const memberEntries = se_AvailabilityZones(input[_AZ], context);
    if (input[_AZ]?.length === 0) {
      entries.AvailabilityZones = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `AvailabilityZones.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  if (input[_SIn] != null) {
    entries[_SIn] = input[_SIn];
  }
  if (input[_E] != null) {
    entries[_E] = input[_E];
  }
  if (input[_EV] != null) {
    entries[_EV] = input[_EV];
  }
  if (input[_P] != null) {
    entries[_P] = input[_P];
  }
  if (input[_DBSGNu] != null) {
    entries[_DBSGNu] = input[_DBSGNu];
  }
  if (input[_DN] != null) {
    entries[_DN] = input[_DN];
  }
  if (input[_OGN] != null) {
    entries[_OGN] = input[_OGN];
  }
  if (input[_VSGI] != null) {
    const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
    if (input[_VSGI]?.length === 0) {
      entries.VpcSecurityGroupIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `VpcSecurityGroupIds.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_KKI] != null) {
    entries[_KKI] = input[_KKI];
  }
  if (input[_EIAMDA] != null) {
    entries[_EIAMDA] = input[_EIAMDA];
  }
  if (input[_BW] != null) {
    entries[_BW] = input[_BW];
  }
  if (input[_ECLE] != null) {
    const memberEntries = se_LogTypeList(input[_ECLE], context);
    if (input[_ECLE]?.length === 0) {
      entries.EnableCloudwatchLogsExports = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `EnableCloudwatchLogsExports.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_EMn] != null) {
    entries[_EMn] = input[_EMn];
  }
  if (input[_SC] != null) {
    const memberEntries = se_ScalingConfiguration(input[_SC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ScalingConfiguration.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_DBCPGN] != null) {
    entries[_DBCPGN] = input[_DBCPGN];
  }
  if (input[_DP] != null) {
    entries[_DP] = input[_DP];
  }
  if (input[_CTTS] != null) {
    entries[_CTTS] = input[_CTTS];
  }
  if (input[_Do] != null) {
    entries[_Do] = input[_Do];
  }
  if (input[_DIAMRN] != null) {
    entries[_DIAMRN] = input[_DIAMRN];
  }
  if (input[_DBCIC] != null) {
    entries[_DBCIC] = input[_DBCIC];
  }
  if (input[_STt] != null) {
    entries[_STt] = input[_STt];
  }
  if (input[_I] != null) {
    entries[_I] = input[_I];
  }
  if (input[_PA] != null) {
    entries[_PA] = input[_PA];
  }
  if (input[_SVSC] != null) {
    const memberEntries = se_ServerlessV2ScalingConfiguration(input[_SVSC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ServerlessV2ScalingConfiguration.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_RCCC] != null) {
    const memberEntries = se_RdsCustomClusterConfiguration(input[_RCCC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `RdsCustomClusterConfiguration.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MIo] != null) {
    entries[_MIo] = input[_MIo];
  }
  if (input[_MRA] != null) {
    entries[_MRA] = input[_MRA];
  }
  if (input[_EPI] != null) {
    entries[_EPI] = input[_EPI];
  }
  if (input[_PIKMSKI] != null) {
    entries[_PIKMSKI] = input[_PIKMSKI];
  }
  if (input[_PIRP] != null) {
    entries[_PIRP] = input[_PIRP];
  }
  if (input[_ELS] != null) {
    entries[_ELS] = input[_ELS];
  }
  return entries;
}, "se_RestoreDBClusterFromSnapshotMessage");
var se_RestoreDBClusterToPointInTimeMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  if (input[_RT] != null) {
    entries[_RT] = input[_RT];
  }
  if (input[_SDBCI] != null) {
    entries[_SDBCI] = input[_SDBCI];
  }
  if (input[_RTT] != null) {
    entries[_RTT] = (0, import_smithy_client.serializeDateTime)(input[_RTT]);
  }
  if (input[_ULRT] != null) {
    entries[_ULRT] = input[_ULRT];
  }
  if (input[_P] != null) {
    entries[_P] = input[_P];
  }
  if (input[_DBSGNu] != null) {
    entries[_DBSGNu] = input[_DBSGNu];
  }
  if (input[_OGN] != null) {
    entries[_OGN] = input[_OGN];
  }
  if (input[_VSGI] != null) {
    const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
    if (input[_VSGI]?.length === 0) {
      entries.VpcSecurityGroupIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `VpcSecurityGroupIds.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_KKI] != null) {
    entries[_KKI] = input[_KKI];
  }
  if (input[_EIAMDA] != null) {
    entries[_EIAMDA] = input[_EIAMDA];
  }
  if (input[_BW] != null) {
    entries[_BW] = input[_BW];
  }
  if (input[_ECLE] != null) {
    const memberEntries = se_LogTypeList(input[_ECLE], context);
    if (input[_ECLE]?.length === 0) {
      entries.EnableCloudwatchLogsExports = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `EnableCloudwatchLogsExports.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_DBCPGN] != null) {
    entries[_DBCPGN] = input[_DBCPGN];
  }
  if (input[_DP] != null) {
    entries[_DP] = input[_DP];
  }
  if (input[_CTTS] != null) {
    entries[_CTTS] = input[_CTTS];
  }
  if (input[_Do] != null) {
    entries[_Do] = input[_Do];
  }
  if (input[_DIAMRN] != null) {
    entries[_DIAMRN] = input[_DIAMRN];
  }
  if (input[_SC] != null) {
    const memberEntries = se_ScalingConfiguration(input[_SC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ScalingConfiguration.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_EMn] != null) {
    entries[_EMn] = input[_EMn];
  }
  if (input[_DBCIC] != null) {
    entries[_DBCIC] = input[_DBCIC];
  }
  if (input[_STt] != null) {
    entries[_STt] = input[_STt];
  }
  if (input[_PA] != null) {
    entries[_PA] = input[_PA];
  }
  if (input[_I] != null) {
    entries[_I] = input[_I];
  }
  if (input[_SVSC] != null) {
    const memberEntries = se_ServerlessV2ScalingConfiguration(input[_SVSC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ServerlessV2ScalingConfiguration.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_SDCRI] != null) {
    entries[_SDCRI] = input[_SDCRI];
  }
  if (input[_RCCC] != null) {
    const memberEntries = se_RdsCustomClusterConfiguration(input[_RCCC], context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `RdsCustomClusterConfiguration.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_MIo] != null) {
    entries[_MIo] = input[_MIo];
  }
  if (input[_MRA] != null) {
    entries[_MRA] = input[_MRA];
  }
  if (input[_EPI] != null) {
    entries[_EPI] = input[_EPI];
  }
  if (input[_PIKMSKI] != null) {
    entries[_PIKMSKI] = input[_PIKMSKI];
  }
  if (input[_PIRP] != null) {
    entries[_PIRP] = input[_PIRP];
  }
  if (input[_ELS] != null) {
    entries[_ELS] = input[_ELS];
  }
  return entries;
}, "se_RestoreDBClusterToPointInTimeMessage");
var se_RestoreDBInstanceFromDBSnapshotMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_DBSIn] != null) {
    entries[_DBSIn] = input[_DBSIn];
  }
  if (input[_DBIC] != null) {
    entries[_DBIC] = input[_DBIC];
  }
  if (input[_P] != null) {
    entries[_P] = input[_P];
  }
  if (input[_AZv] != null) {
    entries[_AZv] = input[_AZv];
  }
  if (input[_DBSGNu] != null) {
    entries[_DBSGNu] = input[_DBSGNu];
  }
  if (input[_MAZ] != null) {
    entries[_MAZ] = input[_MAZ];
  }
  if (input[_PA] != null) {
    entries[_PA] = input[_PA];
  }
  if (input[_AMVU] != null) {
    entries[_AMVU] = input[_AMVU];
  }
  if (input[_LM] != null) {
    entries[_LM] = input[_LM];
  }
  if (input[_DBN] != null) {
    entries[_DBN] = input[_DBN];
  }
  if (input[_E] != null) {
    entries[_E] = input[_E];
  }
  if (input[_I] != null) {
    entries[_I] = input[_I];
  }
  if (input[_OGN] != null) {
    entries[_OGN] = input[_OGN];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_STt] != null) {
    entries[_STt] = input[_STt];
  }
  if (input[_TCA] != null) {
    entries[_TCA] = input[_TCA];
  }
  if (input[_TCP] != null) {
    entries[_TCP] = input[_TCP];
  }
  if (input[_VSGI] != null) {
    const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
    if (input[_VSGI]?.length === 0) {
      entries.VpcSecurityGroupIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `VpcSecurityGroupIds.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Do] != null) {
    entries[_Do] = input[_Do];
  }
  if (input[_DF] != null) {
    entries[_DF] = input[_DF];
  }
  if (input[_DO] != null) {
    entries[_DO] = input[_DO];
  }
  if (input[_DASA] != null) {
    entries[_DASA] = input[_DASA];
  }
  if (input[_DDI] != null) {
    const memberEntries = se_StringList(input[_DDI], context);
    if (input[_DDI]?.length === 0) {
      entries.DomainDnsIps = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `DomainDnsIps.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_CTTS] != null) {
    entries[_CTTS] = input[_CTTS];
  }
  if (input[_DIAMRN] != null) {
    entries[_DIAMRN] = input[_DIAMRN];
  }
  if (input[_EIAMDA] != null) {
    entries[_EIAMDA] = input[_EIAMDA];
  }
  if (input[_ECLE] != null) {
    const memberEntries = se_LogTypeList(input[_ECLE], context);
    if (input[_ECLE]?.length === 0) {
      entries.EnableCloudwatchLogsExports = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `EnableCloudwatchLogsExports.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_PF] != null) {
    const memberEntries = se_ProcessorFeatureList(input[_PF], context);
    if (input[_PF]?.length === 0) {
      entries.ProcessorFeatures = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ProcessorFeatures.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_UDPF] != null) {
    entries[_UDPF] = input[_UDPF];
  }
  if (input[_DBPGN] != null) {
    entries[_DBPGN] = input[_DBPGN];
  }
  if (input[_DP] != null) {
    entries[_DP] = input[_DP];
  }
  if (input[_ECOI] != null) {
    entries[_ECOI] = input[_ECOI];
  }
  if (input[_CIIP] != null) {
    entries[_CIIP] = input[_CIIP];
  }
  if (input[_BTa] != null) {
    entries[_BTa] = input[_BTa];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_STto] != null) {
    entries[_STto] = input[_STto];
  }
  if (input[_DBCSI] != null) {
    entries[_DBCSI] = input[_DBCSI];
  }
  if (input[_AS] != null) {
    entries[_AS] = input[_AS];
  }
  if (input[_DLV] != null) {
    entries[_DLV] = input[_DLV];
  }
  if (input[_CACI] != null) {
    entries[_CACI] = input[_CACI];
  }
  if (input[_ELS] != null) {
    entries[_ELS] = input[_ELS];
  }
  if (input[_MMUP] != null) {
    entries[_MMUP] = input[_MMUP];
  }
  if (input[_MUSKKI] != null) {
    entries[_MUSKKI] = input[_MUSKKI];
  }
  return entries;
}, "se_RestoreDBInstanceFromDBSnapshotMessage");
var se_RestoreDBInstanceFromS3Message = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBN] != null) {
    entries[_DBN] = input[_DBN];
  }
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_AS] != null) {
    entries[_AS] = input[_AS];
  }
  if (input[_DBIC] != null) {
    entries[_DBIC] = input[_DBIC];
  }
  if (input[_E] != null) {
    entries[_E] = input[_E];
  }
  if (input[_MU] != null) {
    entries[_MU] = input[_MU];
  }
  if (input[_MUP] != null) {
    entries[_MUP] = input[_MUP];
  }
  if (input[_DBSG] != null) {
    const memberEntries = se_DBSecurityGroupNameList(input[_DBSG], context);
    if (input[_DBSG]?.length === 0) {
      entries.DBSecurityGroups = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `DBSecurityGroups.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_VSGI] != null) {
    const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
    if (input[_VSGI]?.length === 0) {
      entries.VpcSecurityGroupIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `VpcSecurityGroupIds.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_AZv] != null) {
    entries[_AZv] = input[_AZv];
  }
  if (input[_DBSGNu] != null) {
    entries[_DBSGNu] = input[_DBSGNu];
  }
  if (input[_PMW] != null) {
    entries[_PMW] = input[_PMW];
  }
  if (input[_DBPGN] != null) {
    entries[_DBPGN] = input[_DBPGN];
  }
  if (input[_BRP] != null) {
    entries[_BRP] = input[_BRP];
  }
  if (input[_PBW] != null) {
    entries[_PBW] = input[_PBW];
  }
  if (input[_P] != null) {
    entries[_P] = input[_P];
  }
  if (input[_MAZ] != null) {
    entries[_MAZ] = input[_MAZ];
  }
  if (input[_EV] != null) {
    entries[_EV] = input[_EV];
  }
  if (input[_AMVU] != null) {
    entries[_AMVU] = input[_AMVU];
  }
  if (input[_LM] != null) {
    entries[_LM] = input[_LM];
  }
  if (input[_I] != null) {
    entries[_I] = input[_I];
  }
  if (input[_OGN] != null) {
    entries[_OGN] = input[_OGN];
  }
  if (input[_PA] != null) {
    entries[_PA] = input[_PA];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_STt] != null) {
    entries[_STt] = input[_STt];
  }
  if (input[_SE] != null) {
    entries[_SE] = input[_SE];
  }
  if (input[_KKI] != null) {
    entries[_KKI] = input[_KKI];
  }
  if (input[_CTTS] != null) {
    entries[_CTTS] = input[_CTTS];
  }
  if (input[_MIo] != null) {
    entries[_MIo] = input[_MIo];
  }
  if (input[_MRA] != null) {
    entries[_MRA] = input[_MRA];
  }
  if (input[_EIAMDA] != null) {
    entries[_EIAMDA] = input[_EIAMDA];
  }
  if (input[_SEo] != null) {
    entries[_SEo] = input[_SEo];
  }
  if (input[_SEV] != null) {
    entries[_SEV] = input[_SEV];
  }
  if (input[_SBN] != null) {
    entries[_SBN] = input[_SBN];
  }
  if (input[_SP] != null) {
    entries[_SP] = input[_SP];
  }
  if (input[_SIRA] != null) {
    entries[_SIRA] = input[_SIRA];
  }
  if (input[_DIM] != null) {
    entries[_DIM] = input[_DIM];
  }
  if (input[_EPI] != null) {
    entries[_EPI] = input[_EPI];
  }
  if (input[_PIKMSKI] != null) {
    entries[_PIKMSKI] = input[_PIKMSKI];
  }
  if (input[_PIRP] != null) {
    entries[_PIRP] = input[_PIRP];
  }
  if (input[_ECLE] != null) {
    const memberEntries = se_LogTypeList(input[_ECLE], context);
    if (input[_ECLE]?.length === 0) {
      entries.EnableCloudwatchLogsExports = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `EnableCloudwatchLogsExports.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_PF] != null) {
    const memberEntries = se_ProcessorFeatureList(input[_PF], context);
    if (input[_PF]?.length === 0) {
      entries.ProcessorFeatures = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ProcessorFeatures.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_UDPF] != null) {
    entries[_UDPF] = input[_UDPF];
  }
  if (input[_DP] != null) {
    entries[_DP] = input[_DP];
  }
  if (input[_MASa] != null) {
    entries[_MASa] = input[_MASa];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_STto] != null) {
    entries[_STto] = input[_STto];
  }
  if (input[_MMUP] != null) {
    entries[_MMUP] = input[_MMUP];
  }
  if (input[_MUSKKI] != null) {
    entries[_MUSKKI] = input[_MUSKKI];
  }
  if (input[_DLV] != null) {
    entries[_DLV] = input[_DLV];
  }
  if (input[_CACI] != null) {
    entries[_CACI] = input[_CACI];
  }
  if (input[_ELS] != null) {
    entries[_ELS] = input[_ELS];
  }
  return entries;
}, "se_RestoreDBInstanceFromS3Message");
var se_RestoreDBInstanceToPointInTimeMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SDBII] != null) {
    entries[_SDBII] = input[_SDBII];
  }
  if (input[_TDBII] != null) {
    entries[_TDBII] = input[_TDBII];
  }
  if (input[_RTe] != null) {
    entries[_RTe] = (0, import_smithy_client.serializeDateTime)(input[_RTe]);
  }
  if (input[_ULRT] != null) {
    entries[_ULRT] = input[_ULRT];
  }
  if (input[_DBIC] != null) {
    entries[_DBIC] = input[_DBIC];
  }
  if (input[_P] != null) {
    entries[_P] = input[_P];
  }
  if (input[_AZv] != null) {
    entries[_AZv] = input[_AZv];
  }
  if (input[_DBSGNu] != null) {
    entries[_DBSGNu] = input[_DBSGNu];
  }
  if (input[_MAZ] != null) {
    entries[_MAZ] = input[_MAZ];
  }
  if (input[_PA] != null) {
    entries[_PA] = input[_PA];
  }
  if (input[_AMVU] != null) {
    entries[_AMVU] = input[_AMVU];
  }
  if (input[_LM] != null) {
    entries[_LM] = input[_LM];
  }
  if (input[_DBN] != null) {
    entries[_DBN] = input[_DBN];
  }
  if (input[_E] != null) {
    entries[_E] = input[_E];
  }
  if (input[_I] != null) {
    entries[_I] = input[_I];
  }
  if (input[_OGN] != null) {
    entries[_OGN] = input[_OGN];
  }
  if (input[_CTTS] != null) {
    entries[_CTTS] = input[_CTTS];
  }
  if (input[_T] != null) {
    const memberEntries = se_TagList(input[_T], context);
    if (input[_T]?.length === 0) {
      entries.Tags = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `Tags.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_STt] != null) {
    entries[_STt] = input[_STt];
  }
  if (input[_TCA] != null) {
    entries[_TCA] = input[_TCA];
  }
  if (input[_TCP] != null) {
    entries[_TCP] = input[_TCP];
  }
  if (input[_VSGI] != null) {
    const memberEntries = se_VpcSecurityGroupIdList(input[_VSGI], context);
    if (input[_VSGI]?.length === 0) {
      entries.VpcSecurityGroupIds = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `VpcSecurityGroupIds.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_Do] != null) {
    entries[_Do] = input[_Do];
  }
  if (input[_DIAMRN] != null) {
    entries[_DIAMRN] = input[_DIAMRN];
  }
  if (input[_DF] != null) {
    entries[_DF] = input[_DF];
  }
  if (input[_DO] != null) {
    entries[_DO] = input[_DO];
  }
  if (input[_DASA] != null) {
    entries[_DASA] = input[_DASA];
  }
  if (input[_DDI] != null) {
    const memberEntries = se_StringList(input[_DDI], context);
    if (input[_DDI]?.length === 0) {
      entries.DomainDnsIps = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `DomainDnsIps.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_EIAMDA] != null) {
    entries[_EIAMDA] = input[_EIAMDA];
  }
  if (input[_ECLE] != null) {
    const memberEntries = se_LogTypeList(input[_ECLE], context);
    if (input[_ECLE]?.length === 0) {
      entries.EnableCloudwatchLogsExports = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `EnableCloudwatchLogsExports.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_PF] != null) {
    const memberEntries = se_ProcessorFeatureList(input[_PF], context);
    if (input[_PF]?.length === 0) {
      entries.ProcessorFeatures = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ProcessorFeatures.${key}`;
      entries[loc] = value;
    });
  }
  if (input[_UDPF] != null) {
    entries[_UDPF] = input[_UDPF];
  }
  if (input[_DBPGN] != null) {
    entries[_DBPGN] = input[_DBPGN];
  }
  if (input[_DP] != null) {
    entries[_DP] = input[_DP];
  }
  if (input[_SDRI] != null) {
    entries[_SDRI] = input[_SDRI];
  }
  if (input[_MASa] != null) {
    entries[_MASa] = input[_MASa];
  }
  if (input[_SDBIABA] != null) {
    entries[_SDBIABA] = input[_SDBIABA];
  }
  if (input[_ECOI] != null) {
    entries[_ECOI] = input[_ECOI];
  }
  if (input[_CIIP] != null) {
    entries[_CIIP] = input[_CIIP];
  }
  if (input[_BTa] != null) {
    entries[_BTa] = input[_BTa];
  }
  if (input[_NT] != null) {
    entries[_NT] = input[_NT];
  }
  if (input[_STto] != null) {
    entries[_STto] = input[_STto];
  }
  if (input[_AS] != null) {
    entries[_AS] = input[_AS];
  }
  if (input[_DLV] != null) {
    entries[_DLV] = input[_DLV];
  }
  if (input[_CACI] != null) {
    entries[_CACI] = input[_CACI];
  }
  if (input[_ELS] != null) {
    entries[_ELS] = input[_ELS];
  }
  if (input[_MMUP] != null) {
    entries[_MMUP] = input[_MMUP];
  }
  if (input[_MUSKKI] != null) {
    entries[_MUSKKI] = input[_MUSKKI];
  }
  return entries;
}, "se_RestoreDBInstanceToPointInTimeMessage");
var se_RevokeDBSecurityGroupIngressMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBSGN] != null) {
    entries[_DBSGN] = input[_DBSGN];
  }
  if (input[_CIDRIP] != null) {
    entries[_CIDRIP] = input[_CIDRIP];
  }
  if (input[_ECSGN] != null) {
    entries[_ECSGN] = input[_ECSGN];
  }
  if (input[_ECSGI] != null) {
    entries[_ECSGI] = input[_ECSGI];
  }
  if (input[_ECSGOI] != null) {
    entries[_ECSGOI] = input[_ECSGOI];
  }
  return entries;
}, "se_RevokeDBSecurityGroupIngressMessage");
var se_ScalingConfiguration = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_MCi] != null) {
    entries[_MCi] = input[_MCi];
  }
  if (input[_MCa] != null) {
    entries[_MCa] = input[_MCa];
  }
  if (input[_AP] != null) {
    entries[_AP] = input[_AP];
  }
  if (input[_SUAP] != null) {
    entries[_SUAP] = input[_SUAP];
  }
  if (input[_TAi] != null) {
    entries[_TAi] = input[_TAi];
  }
  if (input[_SBT] != null) {
    entries[_SBT] = input[_SBT];
  }
  return entries;
}, "se_ScalingConfiguration");
var se_ServerlessV2ScalingConfiguration = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_MCi] != null) {
    entries[_MCi] = (0, import_smithy_client.serializeFloat)(input[_MCi]);
  }
  if (input[_MCa] != null) {
    entries[_MCa] = (0, import_smithy_client.serializeFloat)(input[_MCa]);
  }
  if (input[_SUAP] != null) {
    entries[_SUAP] = input[_SUAP];
  }
  return entries;
}, "se_ServerlessV2ScalingConfiguration");
var se_SourceIdsList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`SourceId.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_SourceIdsList");
var se_StartActivityStreamRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RAe] != null) {
    entries[_RAe] = input[_RAe];
  }
  if (input[_Mo] != null) {
    entries[_Mo] = input[_Mo];
  }
  if (input[_KKI] != null) {
    entries[_KKI] = input[_KKI];
  }
  if (input[_AI] != null) {
    entries[_AI] = input[_AI];
  }
  if (input[_ENAFI] != null) {
    entries[_ENAFI] = input[_ENAFI];
  }
  return entries;
}, "se_StartActivityStreamRequest");
var se_StartDBClusterMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  return entries;
}, "se_StartDBClusterMessage");
var se_StartDBInstanceAutomatedBackupsReplicationMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SDBIA] != null) {
    entries[_SDBIA] = input[_SDBIA];
  }
  if (input[_BRP] != null) {
    entries[_BRP] = input[_BRP];
  }
  if (input[_KKI] != null) {
    entries[_KKI] = input[_KKI];
  }
  if (input[_PSU] != null) {
    entries[_PSU] = input[_PSU];
  }
  return entries;
}, "se_StartDBInstanceAutomatedBackupsReplicationMessage");
var se_StartDBInstanceMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  return entries;
}, "se_StartDBInstanceMessage");
var se_StartExportTaskMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_ETI] != null) {
    entries[_ETI] = input[_ETI];
  }
  if (input[_SA] != null) {
    entries[_SA] = input[_SA];
  }
  if (input[_SBN] != null) {
    entries[_SBN] = input[_SBN];
  }
  if (input[_IRA] != null) {
    entries[_IRA] = input[_IRA];
  }
  if (input[_KKI] != null) {
    entries[_KKI] = input[_KKI];
  }
  if (input[_SP] != null) {
    entries[_SP] = input[_SP];
  }
  if (input[_EO] != null) {
    const memberEntries = se_StringList(input[_EO], context);
    if (input[_EO]?.length === 0) {
      entries.ExportOnly = [];
    }
    Object.entries(memberEntries).forEach(([key, value]) => {
      const loc = `ExportOnly.${key}`;
      entries[loc] = value;
    });
  }
  return entries;
}, "se_StartExportTaskMessage");
var se_StopActivityStreamRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_RAe] != null) {
    entries[_RAe] = input[_RAe];
  }
  if (input[_AI] != null) {
    entries[_AI] = input[_AI];
  }
  return entries;
}, "se_StopActivityStreamRequest");
var se_StopDBClusterMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBCI] != null) {
    entries[_DBCI] = input[_DBCI];
  }
  return entries;
}, "se_StopDBClusterMessage");
var se_StopDBInstanceAutomatedBackupsReplicationMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_SDBIA] != null) {
    entries[_SDBIA] = input[_SDBIA];
  }
  return entries;
}, "se_StopDBInstanceAutomatedBackupsReplicationMessage");
var se_StopDBInstanceMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  if (input[_DBSIn] != null) {
    entries[_DBSIn] = input[_DBSIn];
  }
  return entries;
}, "se_StopDBInstanceMessage");
var se_StringList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`member.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_StringList");
var se_SubnetIdentifierList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`SubnetIdentifier.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_SubnetIdentifierList");
var se_SwitchoverBlueGreenDeploymentRequest = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_BGDI] != null) {
    entries[_BGDI] = input[_BGDI];
  }
  if (input[_STw] != null) {
    entries[_STw] = input[_STw];
  }
  return entries;
}, "se_SwitchoverBlueGreenDeploymentRequest");
var se_SwitchoverGlobalClusterMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_GCI] != null) {
    entries[_GCI] = input[_GCI];
  }
  if (input[_TDCI] != null) {
    entries[_TDCI] = input[_TDCI];
  }
  return entries;
}, "se_SwitchoverGlobalClusterMessage");
var se_SwitchoverReadReplicaMessage = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_DBII] != null) {
    entries[_DBII] = input[_DBII];
  }
  return entries;
}, "se_SwitchoverReadReplicaMessage");
var se_Tag = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_K] != null) {
    entries[_K] = input[_K];
  }
  if (input[_Val] != null) {
    entries[_Val] = input[_Val];
  }
  return entries;
}, "se_Tag");
var se_TagList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    const memberEntries = se_Tag(entry, context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      entries[`Tag.${counter}.${key}`] = value;
    });
    counter++;
  }
  return entries;
}, "se_TagList");
var se_UserAuthConfig = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  if (input[_D] != null) {
    entries[_D] = input[_D];
  }
  if (input[_UN] != null) {
    entries[_UN] = input[_UN];
  }
  if (input[_ASu] != null) {
    entries[_ASu] = input[_ASu];
  }
  if (input[_SAe] != null) {
    entries[_SAe] = input[_SAe];
  }
  if (input[_IAMA] != null) {
    entries[_IAMA] = input[_IAMA];
  }
  if (input[_CPAT] != null) {
    entries[_CPAT] = input[_CPAT];
  }
  return entries;
}, "se_UserAuthConfig");
var se_UserAuthConfigList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    const memberEntries = se_UserAuthConfig(entry, context);
    Object.entries(memberEntries).forEach(([key, value]) => {
      entries[`member.${counter}.${key}`] = value;
    });
    counter++;
  }
  return entries;
}, "se_UserAuthConfigList");
var se_VpcSecurityGroupIdList = /* @__PURE__ */ __name((input, context) => {
  const entries = {};
  let counter = 1;
  for (const entry of input) {
    if (entry === null) {
      continue;
    }
    entries[`VpcSecurityGroupId.${counter}`] = entry;
    counter++;
  }
  return entries;
}, "se_VpcSecurityGroupIdList");
var de_AccountAttributesMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.AccountQuotas === "") {
    contents[_AQ] = [];
  } else if (output[_AQ] != null && output[_AQ][_AQc] != null) {
    contents[_AQ] = de_AccountQuotaList((0, import_smithy_client.getArrayIfSingleItem)(output[_AQ][_AQc]), context);
  }
  return contents;
}, "de_AccountAttributesMessage");
var de_AccountQuota = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_AQN] != null) {
    contents[_AQN] = (0, import_smithy_client.expectString)(output[_AQN]);
  }
  if (output[_U] != null) {
    contents[_U] = (0, import_smithy_client.strictParseLong)(output[_U]);
  }
  if (output[_Max] != null) {
    contents[_Max] = (0, import_smithy_client.strictParseLong)(output[_Max]);
  }
  return contents;
}, "de_AccountQuota");
var de_AccountQuotaList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_AccountQuota(entry, context);
  });
}, "de_AccountQuotaList");
var de_ActivityStreamModeList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_ActivityStreamModeList");
var de_AddSourceIdentifierToSubscriptionResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_ES] != null) {
    contents[_ES] = de_EventSubscription(output[_ES], context);
  }
  return contents;
}, "de_AddSourceIdentifierToSubscriptionResult");
var de_ApplyPendingMaintenanceActionResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RPMA] != null) {
    contents[_RPMA] = de_ResourcePendingMaintenanceActions(output[_RPMA], context);
  }
  return contents;
}, "de_ApplyPendingMaintenanceActionResult");
var de_AttributeValueList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_AttributeValueList");
var de_AuthorizationAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_AuthorizationAlreadyExistsFault");
var de_AuthorizationNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_AuthorizationNotFoundFault");
var de_AuthorizationQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_AuthorizationQuotaExceededFault");
var de_AuthorizeDBSecurityGroupIngressResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBSGe] != null) {
    contents[_DBSGe] = de_DBSecurityGroup(output[_DBSGe], context);
  }
  return contents;
}, "de_AuthorizeDBSecurityGroupIngressResult");
var de_AvailabilityZone = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  return contents;
}, "de_AvailabilityZone");
var de_AvailabilityZoneList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_AvailabilityZone(entry, context);
  });
}, "de_AvailabilityZoneList");
var de_AvailabilityZones = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_AvailabilityZones");
var de_AvailableProcessorFeature = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_DV] != null) {
    contents[_DV] = (0, import_smithy_client.expectString)(output[_DV]);
  }
  if (output[_AV] != null) {
    contents[_AV] = (0, import_smithy_client.expectString)(output[_AV]);
  }
  return contents;
}, "de_AvailableProcessorFeature");
var de_AvailableProcessorFeatureList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_AvailableProcessorFeature(entry, context);
  });
}, "de_AvailableProcessorFeatureList");
var de_BackupPolicyNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_BackupPolicyNotFoundFault");
var de_BlueGreenDeployment = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_BGDI] != null) {
    contents[_BGDI] = (0, import_smithy_client.expectString)(output[_BGDI]);
  }
  if (output[_BGDN] != null) {
    contents[_BGDN] = (0, import_smithy_client.expectString)(output[_BGDN]);
  }
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.expectString)(output[_S]);
  }
  if (output[_Ta] != null) {
    contents[_Ta] = (0, import_smithy_client.expectString)(output[_Ta]);
  }
  if (output.SwitchoverDetails === "") {
    contents[_SD] = [];
  } else if (output[_SD] != null && output[_SD][_me] != null) {
    contents[_SD] = de_SwitchoverDetailList((0, import_smithy_client.getArrayIfSingleItem)(output[_SD][_me]), context);
  }
  if (output.Tasks === "") {
    contents[_Tas] = [];
  } else if (output[_Tas] != null && output[_Tas][_me] != null) {
    contents[_Tas] = de_BlueGreenDeploymentTaskList((0, import_smithy_client.getArrayIfSingleItem)(output[_Tas][_me]), context);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_SDt] != null) {
    contents[_SDt] = (0, import_smithy_client.expectString)(output[_SDt]);
  }
  if (output[_CTr] != null) {
    contents[_CTr] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTr]));
  }
  if (output[_DTe] != null) {
    contents[_DTe] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_DTe]));
  }
  if (output.TagList === "") {
    contents[_TL] = [];
  } else if (output[_TL] != null && output[_TL][_Tag] != null) {
    contents[_TL] = de_TagList((0, import_smithy_client.getArrayIfSingleItem)(output[_TL][_Tag]), context);
  }
  return contents;
}, "de_BlueGreenDeployment");
var de_BlueGreenDeploymentAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_BlueGreenDeploymentAlreadyExistsFault");
var de_BlueGreenDeploymentList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_BlueGreenDeployment(entry, context);
  });
}, "de_BlueGreenDeploymentList");
var de_BlueGreenDeploymentNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_BlueGreenDeploymentNotFoundFault");
var de_BlueGreenDeploymentTask = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  return contents;
}, "de_BlueGreenDeploymentTask");
var de_BlueGreenDeploymentTaskList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_BlueGreenDeploymentTask(entry, context);
  });
}, "de_BlueGreenDeploymentTaskList");
var de_CACertificateIdentifiersList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_CACertificateIdentifiersList");
var de_Certificate = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_CIe] != null) {
    contents[_CIe] = (0, import_smithy_client.expectString)(output[_CIe]);
  }
  if (output[_CTe] != null) {
    contents[_CTe] = (0, import_smithy_client.expectString)(output[_CTe]);
  }
  if (output[_Th] != null) {
    contents[_Th] = (0, import_smithy_client.expectString)(output[_Th]);
  }
  if (output[_VF] != null) {
    contents[_VF] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_VF]));
  }
  if (output[_VT] != null) {
    contents[_VT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_VT]));
  }
  if (output[_CA] != null) {
    contents[_CA] = (0, import_smithy_client.expectString)(output[_CA]);
  }
  if (output[_CO] != null) {
    contents[_CO] = (0, import_smithy_client.parseBoolean)(output[_CO]);
  }
  if (output[_COVT] != null) {
    contents[_COVT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_COVT]));
  }
  return contents;
}, "de_Certificate");
var de_CertificateDetails = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_CAI] != null) {
    contents[_CAI] = (0, import_smithy_client.expectString)(output[_CAI]);
  }
  if (output[_VT] != null) {
    contents[_VT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_VT]));
  }
  return contents;
}, "de_CertificateDetails");
var de_CertificateList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Certificate(entry, context);
  });
}, "de_CertificateList");
var de_CertificateMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DCFNL] != null) {
    contents[_DCFNL] = (0, import_smithy_client.expectString)(output[_DCFNL]);
  }
  if (output.Certificates === "") {
    contents[_Ce] = [];
  } else if (output[_Ce] != null && output[_Ce][_Cer] != null) {
    contents[_Ce] = de_CertificateList((0, import_smithy_client.getArrayIfSingleItem)(output[_Ce][_Cer]), context);
  }
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  return contents;
}, "de_CertificateMessage");
var de_CertificateNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_CertificateNotFoundFault");
var de_CharacterSet = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_CSN] != null) {
    contents[_CSN] = (0, import_smithy_client.expectString)(output[_CSN]);
  }
  if (output[_CSD] != null) {
    contents[_CSD] = (0, import_smithy_client.expectString)(output[_CSD]);
  }
  return contents;
}, "de_CharacterSet");
var de_ClusterPendingModifiedValues = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_PCLE] != null) {
    contents[_PCLE] = de_PendingCloudwatchLogsExports(output[_PCLE], context);
  }
  if (output[_DBCI] != null) {
    contents[_DBCI] = (0, import_smithy_client.expectString)(output[_DBCI]);
  }
  if (output[_MUP] != null) {
    contents[_MUP] = (0, import_smithy_client.expectString)(output[_MUP]);
  }
  if (output[_IAMDAE] != null) {
    contents[_IAMDAE] = (0, import_smithy_client.parseBoolean)(output[_IAMDAE]);
  }
  if (output[_EV] != null) {
    contents[_EV] = (0, import_smithy_client.expectString)(output[_EV]);
  }
  if (output[_BRP] != null) {
    contents[_BRP] = (0, import_smithy_client.strictParseInt32)(output[_BRP]);
  }
  if (output[_AS] != null) {
    contents[_AS] = (0, import_smithy_client.strictParseInt32)(output[_AS]);
  }
  if (output[_RCCC] != null) {
    contents[_RCCC] = de_RdsCustomClusterConfiguration(output[_RCCC], context);
  }
  if (output[_I] != null) {
    contents[_I] = (0, import_smithy_client.strictParseInt32)(output[_I]);
  }
  if (output[_STt] != null) {
    contents[_STt] = (0, import_smithy_client.expectString)(output[_STt]);
  }
  if (output[_CD] != null) {
    contents[_CD] = de_CertificateDetails(output[_CD], context);
  }
  return contents;
}, "de_ClusterPendingModifiedValues");
var de_ConnectionPoolConfigurationInfo = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_MCP] != null) {
    contents[_MCP] = (0, import_smithy_client.strictParseInt32)(output[_MCP]);
  }
  if (output[_MICP] != null) {
    contents[_MICP] = (0, import_smithy_client.strictParseInt32)(output[_MICP]);
  }
  if (output[_CBT] != null) {
    contents[_CBT] = (0, import_smithy_client.strictParseInt32)(output[_CBT]);
  }
  if (output.SessionPinningFilters === "") {
    contents[_SPF] = [];
  } else if (output[_SPF] != null && output[_SPF][_me] != null) {
    contents[_SPF] = de_StringList((0, import_smithy_client.getArrayIfSingleItem)(output[_SPF][_me]), context);
  }
  if (output[_IQ] != null) {
    contents[_IQ] = (0, import_smithy_client.expectString)(output[_IQ]);
  }
  return contents;
}, "de_ConnectionPoolConfigurationInfo");
var de_ContextAttribute = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_K] != null) {
    contents[_K] = (0, import_smithy_client.expectString)(output[_K]);
  }
  if (output[_Val] != null) {
    contents[_Val] = (0, import_smithy_client.expectString)(output[_Val]);
  }
  return contents;
}, "de_ContextAttribute");
var de_ContextAttributeList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ContextAttribute(entry, context);
  });
}, "de_ContextAttributeList");
var de_CopyDBClusterParameterGroupResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBCPG] != null) {
    contents[_DBCPG] = de_DBClusterParameterGroup(output[_DBCPG], context);
  }
  return contents;
}, "de_CopyDBClusterParameterGroupResult");
var de_CopyDBClusterSnapshotResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBCS] != null) {
    contents[_DBCS] = de_DBClusterSnapshot(output[_DBCS], context);
  }
  return contents;
}, "de_CopyDBClusterSnapshotResult");
var de_CopyDBParameterGroupResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBPG] != null) {
    contents[_DBPG] = de_DBParameterGroup(output[_DBPG], context);
  }
  return contents;
}, "de_CopyDBParameterGroupResult");
var de_CopyDBSnapshotResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBS] != null) {
    contents[_DBS] = de_DBSnapshot(output[_DBS], context);
  }
  return contents;
}, "de_CopyDBSnapshotResult");
var de_CopyOptionGroupResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_OG] != null) {
    contents[_OG] = de_OptionGroup(output[_OG], context);
  }
  return contents;
}, "de_CopyOptionGroupResult");
var de_CreateBlueGreenDeploymentResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_BGD] != null) {
    contents[_BGD] = de_BlueGreenDeployment(output[_BGD], context);
  }
  return contents;
}, "de_CreateBlueGreenDeploymentResponse");
var de_CreateCustomDBEngineVersionFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_CreateCustomDBEngineVersionFault");
var de_CreateDBClusterParameterGroupResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBCPG] != null) {
    contents[_DBCPG] = de_DBClusterParameterGroup(output[_DBCPG], context);
  }
  return contents;
}, "de_CreateDBClusterParameterGroupResult");
var de_CreateDBClusterResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBC] != null) {
    contents[_DBC] = de_DBCluster(output[_DBC], context);
  }
  return contents;
}, "de_CreateDBClusterResult");
var de_CreateDBClusterSnapshotResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBCS] != null) {
    contents[_DBCS] = de_DBClusterSnapshot(output[_DBCS], context);
  }
  return contents;
}, "de_CreateDBClusterSnapshotResult");
var de_CreateDBInstanceReadReplicaResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBI] != null) {
    contents[_DBI] = de_DBInstance(output[_DBI], context);
  }
  return contents;
}, "de_CreateDBInstanceReadReplicaResult");
var de_CreateDBInstanceResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBI] != null) {
    contents[_DBI] = de_DBInstance(output[_DBI], context);
  }
  return contents;
}, "de_CreateDBInstanceResult");
var de_CreateDBParameterGroupResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBPG] != null) {
    contents[_DBPG] = de_DBParameterGroup(output[_DBPG], context);
  }
  return contents;
}, "de_CreateDBParameterGroupResult");
var de_CreateDBProxyEndpointResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBPE] != null) {
    contents[_DBPE] = de_DBProxyEndpoint(output[_DBPE], context);
  }
  return contents;
}, "de_CreateDBProxyEndpointResponse");
var de_CreateDBProxyResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBP] != null) {
    contents[_DBP] = de_DBProxy(output[_DBP], context);
  }
  return contents;
}, "de_CreateDBProxyResponse");
var de_CreateDBSecurityGroupResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBSGe] != null) {
    contents[_DBSGe] = de_DBSecurityGroup(output[_DBSGe], context);
  }
  return contents;
}, "de_CreateDBSecurityGroupResult");
var de_CreateDBSnapshotResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBS] != null) {
    contents[_DBS] = de_DBSnapshot(output[_DBS], context);
  }
  return contents;
}, "de_CreateDBSnapshotResult");
var de_CreateDBSubnetGroupResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBSGu] != null) {
    contents[_DBSGu] = de_DBSubnetGroup(output[_DBSGu], context);
  }
  return contents;
}, "de_CreateDBSubnetGroupResult");
var de_CreateEventSubscriptionResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_ES] != null) {
    contents[_ES] = de_EventSubscription(output[_ES], context);
  }
  return contents;
}, "de_CreateEventSubscriptionResult");
var de_CreateGlobalClusterResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_GC] != null) {
    contents[_GC] = de_GlobalCluster(output[_GC], context);
  }
  return contents;
}, "de_CreateGlobalClusterResult");
var de_CreateOptionGroupResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_OG] != null) {
    contents[_OG] = de_OptionGroup(output[_OG], context);
  }
  return contents;
}, "de_CreateOptionGroupResult");
var de_CreateTenantDatabaseResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_TD] != null) {
    contents[_TD] = de_TenantDatabase(output[_TD], context);
  }
  return contents;
}, "de_CreateTenantDatabaseResult");
var de_CustomAvailabilityZoneNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_CustomAvailabilityZoneNotFoundFault");
var de_CustomDBEngineVersionAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_CustomDBEngineVersionAlreadyExistsFault");
var de_CustomDBEngineVersionAMI = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_II] != null) {
    contents[_II] = (0, import_smithy_client.expectString)(output[_II]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  return contents;
}, "de_CustomDBEngineVersionAMI");
var de_CustomDBEngineVersionNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_CustomDBEngineVersionNotFoundFault");
var de_CustomDBEngineVersionQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_CustomDBEngineVersionQuotaExceededFault");
var de_DBCluster = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_AS] != null) {
    contents[_AS] = (0, import_smithy_client.strictParseInt32)(output[_AS]);
  }
  if (output.AvailabilityZones === "") {
    contents[_AZ] = [];
  } else if (output[_AZ] != null && output[_AZ][_AZv] != null) {
    contents[_AZ] = de_AvailabilityZones((0, import_smithy_client.getArrayIfSingleItem)(output[_AZ][_AZv]), context);
  }
  if (output[_BRP] != null) {
    contents[_BRP] = (0, import_smithy_client.strictParseInt32)(output[_BRP]);
  }
  if (output[_CSN] != null) {
    contents[_CSN] = (0, import_smithy_client.expectString)(output[_CSN]);
  }
  if (output[_DN] != null) {
    contents[_DN] = (0, import_smithy_client.expectString)(output[_DN]);
  }
  if (output[_DBCI] != null) {
    contents[_DBCI] = (0, import_smithy_client.expectString)(output[_DBCI]);
  }
  if (output[_DBCPG] != null) {
    contents[_DBCPG] = (0, import_smithy_client.expectString)(output[_DBCPG]);
  }
  if (output[_DBSGu] != null) {
    contents[_DBSGu] = (0, import_smithy_client.expectString)(output[_DBSGu]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_ART] != null) {
    contents[_ART] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_ART]));
  }
  if (output[_PP] != null) {
    contents[_PP] = (0, import_smithy_client.expectString)(output[_PP]);
  }
  if (output[_ERT] != null) {
    contents[_ERT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_ERT]));
  }
  if (output[_End] != null) {
    contents[_End] = (0, import_smithy_client.expectString)(output[_End]);
  }
  if (output[_RE] != null) {
    contents[_RE] = (0, import_smithy_client.expectString)(output[_RE]);
  }
  if (output.CustomEndpoints === "") {
    contents[_CE] = [];
  } else if (output[_CE] != null && output[_CE][_me] != null) {
    contents[_CE] = de_StringList((0, import_smithy_client.getArrayIfSingleItem)(output[_CE][_me]), context);
  }
  if (output[_MAZ] != null) {
    contents[_MAZ] = (0, import_smithy_client.parseBoolean)(output[_MAZ]);
  }
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.expectString)(output[_E]);
  }
  if (output[_EV] != null) {
    contents[_EV] = (0, import_smithy_client.expectString)(output[_EV]);
  }
  if (output[_LRT] != null) {
    contents[_LRT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LRT]));
  }
  if (output[_P] != null) {
    contents[_P] = (0, import_smithy_client.strictParseInt32)(output[_P]);
  }
  if (output[_MU] != null) {
    contents[_MU] = (0, import_smithy_client.expectString)(output[_MU]);
  }
  if (output.DBClusterOptionGroupMemberships === "") {
    contents[_DBCOGM] = [];
  } else if (output[_DBCOGM] != null && output[_DBCOGM][_DBCOG] != null) {
    contents[_DBCOGM] = de_DBClusterOptionGroupMemberships((0, import_smithy_client.getArrayIfSingleItem)(output[_DBCOGM][_DBCOG]), context);
  }
  if (output[_PBW] != null) {
    contents[_PBW] = (0, import_smithy_client.expectString)(output[_PBW]);
  }
  if (output[_PMW] != null) {
    contents[_PMW] = (0, import_smithy_client.expectString)(output[_PMW]);
  }
  if (output[_RSI] != null) {
    contents[_RSI] = (0, import_smithy_client.expectString)(output[_RSI]);
  }
  if (output.ReadReplicaIdentifiers === "") {
    contents[_RRI] = [];
  } else if (output[_RRI] != null && output[_RRI][_RRIe] != null) {
    contents[_RRI] = de_ReadReplicaIdentifierList((0, import_smithy_client.getArrayIfSingleItem)(output[_RRI][_RRIe]), context);
  }
  if (output.StatusInfos === "") {
    contents[_SIt] = [];
  } else if (output[_SIt] != null && output[_SIt][_DBCSIl] != null) {
    contents[_SIt] = de_DBClusterStatusInfoList((0, import_smithy_client.getArrayIfSingleItem)(output[_SIt][_DBCSIl]), context);
  }
  if (output.DBClusterMembers === "") {
    contents[_DBCM] = [];
  } else if (output[_DBCM] != null && output[_DBCM][_DBCMl] != null) {
    contents[_DBCM] = de_DBClusterMemberList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBCM][_DBCMl]), context);
  }
  if (output.VpcSecurityGroups === "") {
    contents[_VSG] = [];
  } else if (output[_VSG] != null && output[_VSG][_VSGMp] != null) {
    contents[_VSG] = de_VpcSecurityGroupMembershipList((0, import_smithy_client.getArrayIfSingleItem)(output[_VSG][_VSGMp]), context);
  }
  if (output[_HZI] != null) {
    contents[_HZI] = (0, import_smithy_client.expectString)(output[_HZI]);
  }
  if (output[_SE] != null) {
    contents[_SE] = (0, import_smithy_client.parseBoolean)(output[_SE]);
  }
  if (output[_KKI] != null) {
    contents[_KKI] = (0, import_smithy_client.expectString)(output[_KKI]);
  }
  if (output[_DCRI] != null) {
    contents[_DCRI] = (0, import_smithy_client.expectString)(output[_DCRI]);
  }
  if (output[_DBCA] != null) {
    contents[_DBCA] = (0, import_smithy_client.expectString)(output[_DBCA]);
  }
  if (output.AssociatedRoles === "") {
    contents[_AR] = [];
  } else if (output[_AR] != null && output[_AR][_DBCR] != null) {
    contents[_AR] = de_DBClusterRoles((0, import_smithy_client.getArrayIfSingleItem)(output[_AR][_DBCR]), context);
  }
  if (output[_IAMDAE] != null) {
    contents[_IAMDAE] = (0, import_smithy_client.parseBoolean)(output[_IAMDAE]);
  }
  if (output[_CGI] != null) {
    contents[_CGI] = (0, import_smithy_client.expectString)(output[_CGI]);
  }
  if (output[_CCT] != null) {
    contents[_CCT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CCT]));
  }
  if (output[_EBT] != null) {
    contents[_EBT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_EBT]));
  }
  if (output[_BW] != null) {
    contents[_BW] = (0, import_smithy_client.strictParseLong)(output[_BW]);
  }
  if (output[_BCCR] != null) {
    contents[_BCCR] = (0, import_smithy_client.strictParseLong)(output[_BCCR]);
  }
  if (output.EnabledCloudwatchLogsExports === "") {
    contents[_ECLEn] = [];
  } else if (output[_ECLEn] != null && output[_ECLEn][_me] != null) {
    contents[_ECLEn] = de_LogTypeList((0, import_smithy_client.getArrayIfSingleItem)(output[_ECLEn][_me]), context);
  }
  if (output[_C] != null) {
    contents[_C] = (0, import_smithy_client.strictParseInt32)(output[_C]);
  }
  if (output[_EMn] != null) {
    contents[_EMn] = (0, import_smithy_client.expectString)(output[_EMn]);
  }
  if (output[_SCI] != null) {
    contents[_SCI] = de_ScalingConfigurationInfo(output[_SCI], context);
  }
  if (output[_RCCC] != null) {
    contents[_RCCC] = de_RdsCustomClusterConfiguration(output[_RCCC], context);
  }
  if (output[_DP] != null) {
    contents[_DP] = (0, import_smithy_client.parseBoolean)(output[_DP]);
  }
  if (output[_HEE] != null) {
    contents[_HEE] = (0, import_smithy_client.parseBoolean)(output[_HEE]);
  }
  if (output[_ASM] != null) {
    contents[_ASM] = (0, import_smithy_client.expectString)(output[_ASM]);
  }
  if (output[_ASS] != null) {
    contents[_ASS] = (0, import_smithy_client.expectString)(output[_ASS]);
  }
  if (output[_ASKKI] != null) {
    contents[_ASKKI] = (0, import_smithy_client.expectString)(output[_ASKKI]);
  }
  if (output[_ASKSN] != null) {
    contents[_ASKSN] = (0, import_smithy_client.expectString)(output[_ASKSN]);
  }
  if (output[_CTTS] != null) {
    contents[_CTTS] = (0, import_smithy_client.parseBoolean)(output[_CTTS]);
  }
  if (output[_CAC] != null) {
    contents[_CAC] = (0, import_smithy_client.parseBoolean)(output[_CAC]);
  }
  if (output.DomainMemberships === "") {
    contents[_DM] = [];
  } else if (output[_DM] != null && output[_DM][_DMo] != null) {
    contents[_DM] = de_DomainMembershipList((0, import_smithy_client.getArrayIfSingleItem)(output[_DM][_DMo]), context);
  }
  if (output.TagList === "") {
    contents[_TL] = [];
  } else if (output[_TL] != null && output[_TL][_Tag] != null) {
    contents[_TL] = de_TagList((0, import_smithy_client.getArrayIfSingleItem)(output[_TL][_Tag]), context);
  }
  if (output[_GCI] != null) {
    contents[_GCI] = (0, import_smithy_client.expectString)(output[_GCI]);
  }
  if (output[_GWFS] != null) {
    contents[_GWFS] = (0, import_smithy_client.expectString)(output[_GWFS]);
  }
  if (output[_GWFR] != null) {
    contents[_GWFR] = (0, import_smithy_client.parseBoolean)(output[_GWFR]);
  }
  if (output[_PMV] != null) {
    contents[_PMV] = de_ClusterPendingModifiedValues(output[_PMV], context);
  }
  if (output[_DBCIC] != null) {
    contents[_DBCIC] = (0, import_smithy_client.expectString)(output[_DBCIC]);
  }
  if (output[_STt] != null) {
    contents[_STt] = (0, import_smithy_client.expectString)(output[_STt]);
  }
  if (output[_I] != null) {
    contents[_I] = (0, import_smithy_client.strictParseInt32)(output[_I]);
  }
  if (output[_PA] != null) {
    contents[_PA] = (0, import_smithy_client.parseBoolean)(output[_PA]);
  }
  if (output[_AMVU] != null) {
    contents[_AMVU] = (0, import_smithy_client.parseBoolean)(output[_AMVU]);
  }
  if (output[_MIo] != null) {
    contents[_MIo] = (0, import_smithy_client.strictParseInt32)(output[_MIo]);
  }
  if (output[_MRA] != null) {
    contents[_MRA] = (0, import_smithy_client.expectString)(output[_MRA]);
  }
  if (output[_DIM] != null) {
    contents[_DIM] = (0, import_smithy_client.expectString)(output[_DIM]);
  }
  if (output[_PIE] != null) {
    contents[_PIE] = (0, import_smithy_client.parseBoolean)(output[_PIE]);
  }
  if (output[_PIKMSKI] != null) {
    contents[_PIKMSKI] = (0, import_smithy_client.expectString)(output[_PIKMSKI]);
  }
  if (output[_PIRP] != null) {
    contents[_PIRP] = (0, import_smithy_client.strictParseInt32)(output[_PIRP]);
  }
  if (output[_SVSC] != null) {
    contents[_SVSC] = de_ServerlessV2ScalingConfigurationInfo(output[_SVSC], context);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  if (output[_DBSI] != null) {
    contents[_DBSI] = (0, import_smithy_client.expectString)(output[_DBSI]);
  }
  if (output[_MUS] != null) {
    contents[_MUS] = de_MasterUserSecret(output[_MUS], context);
  }
  if (output[_IOONAMT] != null) {
    contents[_IOONAMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_IOONAMT]));
  }
  if (output[_LWFS] != null) {
    contents[_LWFS] = (0, import_smithy_client.expectString)(output[_LWFS]);
  }
  if (output[_ABRPA] != null) {
    contents[_ABRPA] = (0, import_smithy_client.expectString)(output[_ABRPA]);
  }
  if (output[_LD] != null) {
    contents[_LD] = de_LimitlessDatabase(output[_LD], context);
  }
  if (output[_STto] != null) {
    contents[_STto] = (0, import_smithy_client.strictParseInt32)(output[_STto]);
  }
  if (output[_CST] != null) {
    contents[_CST] = (0, import_smithy_client.expectString)(output[_CST]);
  }
  if (output[_CD] != null) {
    contents[_CD] = de_CertificateDetails(output[_CD], context);
  }
  if (output[_ELS] != null) {
    contents[_ELS] = (0, import_smithy_client.expectString)(output[_ELS]);
  }
  return contents;
}, "de_DBCluster");
var de_DBClusterAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBClusterAlreadyExistsFault");
var de_DBClusterAutomatedBackup = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.expectString)(output[_E]);
  }
  if (output[_VI] != null) {
    contents[_VI] = (0, import_smithy_client.expectString)(output[_VI]);
  }
  if (output[_DBCABA] != null) {
    contents[_DBCABA] = (0, import_smithy_client.expectString)(output[_DBCABA]);
  }
  if (output[_DBCI] != null) {
    contents[_DBCI] = (0, import_smithy_client.expectString)(output[_DBCI]);
  }
  if (output[_RW] != null) {
    contents[_RW] = de_RestoreWindow(output[_RW], context);
  }
  if (output[_MU] != null) {
    contents[_MU] = (0, import_smithy_client.expectString)(output[_MU]);
  }
  if (output[_DCRI] != null) {
    contents[_DCRI] = (0, import_smithy_client.expectString)(output[_DCRI]);
  }
  if (output[_R] != null) {
    contents[_R] = (0, import_smithy_client.expectString)(output[_R]);
  }
  if (output[_LM] != null) {
    contents[_LM] = (0, import_smithy_client.expectString)(output[_LM]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_IAMDAE] != null) {
    contents[_IAMDAE] = (0, import_smithy_client.parseBoolean)(output[_IAMDAE]);
  }
  if (output[_CCT] != null) {
    contents[_CCT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CCT]));
  }
  if (output[_SE] != null) {
    contents[_SE] = (0, import_smithy_client.parseBoolean)(output[_SE]);
  }
  if (output[_AS] != null) {
    contents[_AS] = (0, import_smithy_client.strictParseInt32)(output[_AS]);
  }
  if (output[_EV] != null) {
    contents[_EV] = (0, import_smithy_client.expectString)(output[_EV]);
  }
  if (output[_DBCA] != null) {
    contents[_DBCA] = (0, import_smithy_client.expectString)(output[_DBCA]);
  }
  if (output[_BRP] != null) {
    contents[_BRP] = (0, import_smithy_client.strictParseInt32)(output[_BRP]);
  }
  if (output[_EMn] != null) {
    contents[_EMn] = (0, import_smithy_client.expectString)(output[_EMn]);
  }
  if (output.AvailabilityZones === "") {
    contents[_AZ] = [];
  } else if (output[_AZ] != null && output[_AZ][_AZv] != null) {
    contents[_AZ] = de_AvailabilityZones((0, import_smithy_client.getArrayIfSingleItem)(output[_AZ][_AZv]), context);
  }
  if (output[_P] != null) {
    contents[_P] = (0, import_smithy_client.strictParseInt32)(output[_P]);
  }
  if (output[_KKI] != null) {
    contents[_KKI] = (0, import_smithy_client.expectString)(output[_KKI]);
  }
  if (output[_STt] != null) {
    contents[_STt] = (0, import_smithy_client.expectString)(output[_STt]);
  }
  if (output[_I] != null) {
    contents[_I] = (0, import_smithy_client.strictParseInt32)(output[_I]);
  }
  if (output[_ABRPA] != null) {
    contents[_ABRPA] = (0, import_smithy_client.expectString)(output[_ABRPA]);
  }
  if (output[_STto] != null) {
    contents[_STto] = (0, import_smithy_client.strictParseInt32)(output[_STto]);
  }
  return contents;
}, "de_DBClusterAutomatedBackup");
var de_DBClusterAutomatedBackupList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBClusterAutomatedBackup(entry, context);
  });
}, "de_DBClusterAutomatedBackupList");
var de_DBClusterAutomatedBackupMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.DBClusterAutomatedBackups === "") {
    contents[_DBCAB] = [];
  } else if (output[_DBCAB] != null && output[_DBCAB][_DBCABl] != null) {
    contents[_DBCAB] = de_DBClusterAutomatedBackupList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBCAB][_DBCABl]), context);
  }
  return contents;
}, "de_DBClusterAutomatedBackupMessage");
var de_DBClusterAutomatedBackupNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBClusterAutomatedBackupNotFoundFault");
var de_DBClusterAutomatedBackupQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBClusterAutomatedBackupQuotaExceededFault");
var de_DBClusterBacktrack = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBCI] != null) {
    contents[_DBCI] = (0, import_smithy_client.expectString)(output[_DBCI]);
  }
  if (output[_BI] != null) {
    contents[_BI] = (0, import_smithy_client.expectString)(output[_BI]);
  }
  if (output[_BT] != null) {
    contents[_BT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_BT]));
  }
  if (output[_BF] != null) {
    contents[_BF] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_BF]));
  }
  if (output[_BRCT] != null) {
    contents[_BRCT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_BRCT]));
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  return contents;
}, "de_DBClusterBacktrack");
var de_DBClusterBacktrackList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBClusterBacktrack(entry, context);
  });
}, "de_DBClusterBacktrackList");
var de_DBClusterBacktrackMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.DBClusterBacktracks === "") {
    contents[_DBCB] = [];
  } else if (output[_DBCB] != null && output[_DBCB][_DBCBl] != null) {
    contents[_DBCB] = de_DBClusterBacktrackList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBCB][_DBCBl]), context);
  }
  return contents;
}, "de_DBClusterBacktrackMessage");
var de_DBClusterBacktrackNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBClusterBacktrackNotFoundFault");
var de_DBClusterCapacityInfo = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBCI] != null) {
    contents[_DBCI] = (0, import_smithy_client.expectString)(output[_DBCI]);
  }
  if (output[_PC] != null) {
    contents[_PC] = (0, import_smithy_client.strictParseInt32)(output[_PC]);
  }
  if (output[_CC] != null) {
    contents[_CC] = (0, import_smithy_client.strictParseInt32)(output[_CC]);
  }
  if (output[_SBT] != null) {
    contents[_SBT] = (0, import_smithy_client.strictParseInt32)(output[_SBT]);
  }
  if (output[_TAi] != null) {
    contents[_TAi] = (0, import_smithy_client.expectString)(output[_TAi]);
  }
  return contents;
}, "de_DBClusterCapacityInfo");
var de_DBClusterEndpoint = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBCEI] != null) {
    contents[_DBCEI] = (0, import_smithy_client.expectString)(output[_DBCEI]);
  }
  if (output[_DBCI] != null) {
    contents[_DBCI] = (0, import_smithy_client.expectString)(output[_DBCI]);
  }
  if (output[_DBCERI] != null) {
    contents[_DBCERI] = (0, import_smithy_client.expectString)(output[_DBCERI]);
  }
  if (output[_End] != null) {
    contents[_End] = (0, import_smithy_client.expectString)(output[_End]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_ET] != null) {
    contents[_ET] = (0, import_smithy_client.expectString)(output[_ET]);
  }
  if (output[_CETu] != null) {
    contents[_CETu] = (0, import_smithy_client.expectString)(output[_CETu]);
  }
  if (output.StaticMembers === "") {
    contents[_SM] = [];
  } else if (output[_SM] != null && output[_SM][_me] != null) {
    contents[_SM] = de_StringList((0, import_smithy_client.getArrayIfSingleItem)(output[_SM][_me]), context);
  }
  if (output.ExcludedMembers === "") {
    contents[_EM] = [];
  } else if (output[_EM] != null && output[_EM][_me] != null) {
    contents[_EM] = de_StringList((0, import_smithy_client.getArrayIfSingleItem)(output[_EM][_me]), context);
  }
  if (output[_DBCEA] != null) {
    contents[_DBCEA] = (0, import_smithy_client.expectString)(output[_DBCEA]);
  }
  return contents;
}, "de_DBClusterEndpoint");
var de_DBClusterEndpointAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBClusterEndpointAlreadyExistsFault");
var de_DBClusterEndpointList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBClusterEndpoint(entry, context);
  });
}, "de_DBClusterEndpointList");
var de_DBClusterEndpointMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.DBClusterEndpoints === "") {
    contents[_DBCE] = [];
  } else if (output[_DBCE] != null && output[_DBCE][_DBCEL] != null) {
    contents[_DBCE] = de_DBClusterEndpointList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBCE][_DBCEL]), context);
  }
  return contents;
}, "de_DBClusterEndpointMessage");
var de_DBClusterEndpointNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBClusterEndpointNotFoundFault");
var de_DBClusterEndpointQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBClusterEndpointQuotaExceededFault");
var de_DBClusterList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBCluster(entry, context);
  });
}, "de_DBClusterList");
var de_DBClusterMember = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBII] != null) {
    contents[_DBII] = (0, import_smithy_client.expectString)(output[_DBII]);
  }
  if (output[_ICW] != null) {
    contents[_ICW] = (0, import_smithy_client.parseBoolean)(output[_ICW]);
  }
  if (output[_DBCPGS] != null) {
    contents[_DBCPGS] = (0, import_smithy_client.expectString)(output[_DBCPGS]);
  }
  if (output[_PT] != null) {
    contents[_PT] = (0, import_smithy_client.strictParseInt32)(output[_PT]);
  }
  return contents;
}, "de_DBClusterMember");
var de_DBClusterMemberList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBClusterMember(entry, context);
  });
}, "de_DBClusterMemberList");
var de_DBClusterMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.DBClusters === "") {
    contents[_DBCl] = [];
  } else if (output[_DBCl] != null && output[_DBCl][_DBC] != null) {
    contents[_DBCl] = de_DBClusterList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBCl][_DBC]), context);
  }
  return contents;
}, "de_DBClusterMessage");
var de_DBClusterNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBClusterNotFoundFault");
var de_DBClusterOptionGroupMemberships = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBClusterOptionGroupStatus(entry, context);
  });
}, "de_DBClusterOptionGroupMemberships");
var de_DBClusterOptionGroupStatus = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBCOGN] != null) {
    contents[_DBCOGN] = (0, import_smithy_client.expectString)(output[_DBCOGN]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  return contents;
}, "de_DBClusterOptionGroupStatus");
var de_DBClusterParameterGroup = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBCPGN] != null) {
    contents[_DBCPGN] = (0, import_smithy_client.expectString)(output[_DBCPGN]);
  }
  if (output[_DBPGF] != null) {
    contents[_DBPGF] = (0, import_smithy_client.expectString)(output[_DBPGF]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output[_DBCPGA] != null) {
    contents[_DBCPGA] = (0, import_smithy_client.expectString)(output[_DBCPGA]);
  }
  return contents;
}, "de_DBClusterParameterGroup");
var de_DBClusterParameterGroupDetails = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Parameters === "") {
    contents[_Pa] = [];
  } else if (output[_Pa] != null && output[_Pa][_Par] != null) {
    contents[_Pa] = de_ParametersList((0, import_smithy_client.getArrayIfSingleItem)(output[_Pa][_Par]), context);
  }
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  return contents;
}, "de_DBClusterParameterGroupDetails");
var de_DBClusterParameterGroupList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBClusterParameterGroup(entry, context);
  });
}, "de_DBClusterParameterGroupList");
var de_DBClusterParameterGroupNameMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBCPGN] != null) {
    contents[_DBCPGN] = (0, import_smithy_client.expectString)(output[_DBCPGN]);
  }
  return contents;
}, "de_DBClusterParameterGroupNameMessage");
var de_DBClusterParameterGroupNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBClusterParameterGroupNotFoundFault");
var de_DBClusterParameterGroupsMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.DBClusterParameterGroups === "") {
    contents[_DBCPGl] = [];
  } else if (output[_DBCPGl] != null && output[_DBCPGl][_DBCPG] != null) {
    contents[_DBCPGl] = de_DBClusterParameterGroupList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBCPGl][_DBCPG]), context);
  }
  return contents;
}, "de_DBClusterParameterGroupsMessage");
var de_DBClusterQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBClusterQuotaExceededFault");
var de_DBClusterRole = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RA] != null) {
    contents[_RA] = (0, import_smithy_client.expectString)(output[_RA]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_FN] != null) {
    contents[_FN] = (0, import_smithy_client.expectString)(output[_FN]);
  }
  return contents;
}, "de_DBClusterRole");
var de_DBClusterRoleAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBClusterRoleAlreadyExistsFault");
var de_DBClusterRoleNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBClusterRoleNotFoundFault");
var de_DBClusterRoleQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBClusterRoleQuotaExceededFault");
var de_DBClusterRoles = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBClusterRole(entry, context);
  });
}, "de_DBClusterRoles");
var de_DBClusterSnapshot = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.AvailabilityZones === "") {
    contents[_AZ] = [];
  } else if (output[_AZ] != null && output[_AZ][_AZv] != null) {
    contents[_AZ] = de_AvailabilityZones((0, import_smithy_client.getArrayIfSingleItem)(output[_AZ][_AZv]), context);
  }
  if (output[_DBCSI] != null) {
    contents[_DBCSI] = (0, import_smithy_client.expectString)(output[_DBCSI]);
  }
  if (output[_DBCI] != null) {
    contents[_DBCI] = (0, import_smithy_client.expectString)(output[_DBCI]);
  }
  if (output[_SCT] != null) {
    contents[_SCT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_SCT]));
  }
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.expectString)(output[_E]);
  }
  if (output[_EMn] != null) {
    contents[_EMn] = (0, import_smithy_client.expectString)(output[_EMn]);
  }
  if (output[_AS] != null) {
    contents[_AS] = (0, import_smithy_client.strictParseInt32)(output[_AS]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_P] != null) {
    contents[_P] = (0, import_smithy_client.strictParseInt32)(output[_P]);
  }
  if (output[_VI] != null) {
    contents[_VI] = (0, import_smithy_client.expectString)(output[_VI]);
  }
  if (output[_CCT] != null) {
    contents[_CCT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CCT]));
  }
  if (output[_MU] != null) {
    contents[_MU] = (0, import_smithy_client.expectString)(output[_MU]);
  }
  if (output[_EV] != null) {
    contents[_EV] = (0, import_smithy_client.expectString)(output[_EV]);
  }
  if (output[_LM] != null) {
    contents[_LM] = (0, import_smithy_client.expectString)(output[_LM]);
  }
  if (output[_STn] != null) {
    contents[_STn] = (0, import_smithy_client.expectString)(output[_STn]);
  }
  if (output[_PP] != null) {
    contents[_PP] = (0, import_smithy_client.strictParseInt32)(output[_PP]);
  }
  if (output[_SE] != null) {
    contents[_SE] = (0, import_smithy_client.parseBoolean)(output[_SE]);
  }
  if (output[_KKI] != null) {
    contents[_KKI] = (0, import_smithy_client.expectString)(output[_KKI]);
  }
  if (output[_DBCSA] != null) {
    contents[_DBCSA] = (0, import_smithy_client.expectString)(output[_DBCSA]);
  }
  if (output[_SDBCSA] != null) {
    contents[_SDBCSA] = (0, import_smithy_client.expectString)(output[_SDBCSA]);
  }
  if (output[_IAMDAE] != null) {
    contents[_IAMDAE] = (0, import_smithy_client.parseBoolean)(output[_IAMDAE]);
  }
  if (output.TagList === "") {
    contents[_TL] = [];
  } else if (output[_TL] != null && output[_TL][_Tag] != null) {
    contents[_TL] = de_TagList((0, import_smithy_client.getArrayIfSingleItem)(output[_TL][_Tag]), context);
  }
  if (output[_DBSI] != null) {
    contents[_DBSI] = (0, import_smithy_client.expectString)(output[_DBSI]);
  }
  if (output[_STt] != null) {
    contents[_STt] = (0, import_smithy_client.expectString)(output[_STt]);
  }
  if (output[_DCRI] != null) {
    contents[_DCRI] = (0, import_smithy_client.expectString)(output[_DCRI]);
  }
  if (output[_STto] != null) {
    contents[_STto] = (0, import_smithy_client.strictParseInt32)(output[_STto]);
  }
  return contents;
}, "de_DBClusterSnapshot");
var de_DBClusterSnapshotAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBClusterSnapshotAlreadyExistsFault");
var de_DBClusterSnapshotAttribute = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_AN] != null) {
    contents[_AN] = (0, import_smithy_client.expectString)(output[_AN]);
  }
  if (output.AttributeValues === "") {
    contents[_AVt] = [];
  } else if (output[_AVt] != null && output[_AVt][_AVtt] != null) {
    contents[_AVt] = de_AttributeValueList((0, import_smithy_client.getArrayIfSingleItem)(output[_AVt][_AVtt]), context);
  }
  return contents;
}, "de_DBClusterSnapshotAttribute");
var de_DBClusterSnapshotAttributeList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBClusterSnapshotAttribute(entry, context);
  });
}, "de_DBClusterSnapshotAttributeList");
var de_DBClusterSnapshotAttributesResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBCSI] != null) {
    contents[_DBCSI] = (0, import_smithy_client.expectString)(output[_DBCSI]);
  }
  if (output.DBClusterSnapshotAttributes === "") {
    contents[_DBCSAl] = [];
  } else if (output[_DBCSAl] != null && output[_DBCSAl][_DBCSAlu] != null) {
    contents[_DBCSAl] = de_DBClusterSnapshotAttributeList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBCSAl][_DBCSAlu]), context);
  }
  return contents;
}, "de_DBClusterSnapshotAttributesResult");
var de_DBClusterSnapshotList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBClusterSnapshot(entry, context);
  });
}, "de_DBClusterSnapshotList");
var de_DBClusterSnapshotMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.DBClusterSnapshots === "") {
    contents[_DBCSl] = [];
  } else if (output[_DBCSl] != null && output[_DBCSl][_DBCS] != null) {
    contents[_DBCSl] = de_DBClusterSnapshotList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBCSl][_DBCS]), context);
  }
  return contents;
}, "de_DBClusterSnapshotMessage");
var de_DBClusterSnapshotNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBClusterSnapshotNotFoundFault");
var de_DBClusterStatusInfo = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_STtat] != null) {
    contents[_STtat] = (0, import_smithy_client.expectString)(output[_STtat]);
  }
  if (output[_No] != null) {
    contents[_No] = (0, import_smithy_client.parseBoolean)(output[_No]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(output[_Me]);
  }
  return contents;
}, "de_DBClusterStatusInfo");
var de_DBClusterStatusInfoList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBClusterStatusInfo(entry, context);
  });
}, "de_DBClusterStatusInfoList");
var de_DBEngineVersion = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.expectString)(output[_E]);
  }
  if (output[_EV] != null) {
    contents[_EV] = (0, import_smithy_client.expectString)(output[_EV]);
  }
  if (output[_DBPGF] != null) {
    contents[_DBPGF] = (0, import_smithy_client.expectString)(output[_DBPGF]);
  }
  if (output[_DBED] != null) {
    contents[_DBED] = (0, import_smithy_client.expectString)(output[_DBED]);
  }
  if (output[_DBEVD] != null) {
    contents[_DBEVD] = (0, import_smithy_client.expectString)(output[_DBEVD]);
  }
  if (output[_DCS] != null) {
    contents[_DCS] = de_CharacterSet(output[_DCS], context);
  }
  if (output[_Im] != null) {
    contents[_Im] = de_CustomDBEngineVersionAMI(output[_Im], context);
  }
  if (output[_DBEMT] != null) {
    contents[_DBEMT] = (0, import_smithy_client.expectString)(output[_DBEMT]);
  }
  if (output.SupportedCharacterSets === "") {
    contents[_SCS] = [];
  } else if (output[_SCS] != null && output[_SCS][_CS] != null) {
    contents[_SCS] = de_SupportedCharacterSetsList((0, import_smithy_client.getArrayIfSingleItem)(output[_SCS][_CS]), context);
  }
  if (output.SupportedNcharCharacterSets === "") {
    contents[_SNCS] = [];
  } else if (output[_SNCS] != null && output[_SNCS][_CS] != null) {
    contents[_SNCS] = de_SupportedCharacterSetsList((0, import_smithy_client.getArrayIfSingleItem)(output[_SNCS][_CS]), context);
  }
  if (output.ValidUpgradeTarget === "") {
    contents[_VUT] = [];
  } else if (output[_VUT] != null && output[_VUT][_UT] != null) {
    contents[_VUT] = de_ValidUpgradeTargetList((0, import_smithy_client.getArrayIfSingleItem)(output[_VUT][_UT]), context);
  }
  if (output.SupportedTimezones === "") {
    contents[_STu] = [];
  } else if (output[_STu] != null && output[_STu][_Ti] != null) {
    contents[_STu] = de_SupportedTimezonesList((0, import_smithy_client.getArrayIfSingleItem)(output[_STu][_Ti]), context);
  }
  if (output.ExportableLogTypes === "") {
    contents[_ELTx] = [];
  } else if (output[_ELTx] != null && output[_ELTx][_me] != null) {
    contents[_ELTx] = de_LogTypeList((0, import_smithy_client.getArrayIfSingleItem)(output[_ELTx][_me]), context);
  }
  if (output[_SLETCL] != null) {
    contents[_SLETCL] = (0, import_smithy_client.parseBoolean)(output[_SLETCL]);
  }
  if (output[_SRRu] != null) {
    contents[_SRRu] = (0, import_smithy_client.parseBoolean)(output[_SRRu]);
  }
  if (output.SupportedEngineModes === "") {
    contents[_SEM] = [];
  } else if (output[_SEM] != null && output[_SEM][_me] != null) {
    contents[_SEM] = de_EngineModeList((0, import_smithy_client.getArrayIfSingleItem)(output[_SEM][_me]), context);
  }
  if (output.SupportedFeatureNames === "") {
    contents[_SFN] = [];
  } else if (output[_SFN] != null && output[_SFN][_me] != null) {
    contents[_SFN] = de_FeatureNameList((0, import_smithy_client.getArrayIfSingleItem)(output[_SFN][_me]), context);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_SPQ] != null) {
    contents[_SPQ] = (0, import_smithy_client.parseBoolean)(output[_SPQ]);
  }
  if (output[_SGD] != null) {
    contents[_SGD] = (0, import_smithy_client.parseBoolean)(output[_SGD]);
  }
  if (output[_MEV] != null) {
    contents[_MEV] = (0, import_smithy_client.expectString)(output[_MEV]);
  }
  if (output[_DIFSBN] != null) {
    contents[_DIFSBN] = (0, import_smithy_client.expectString)(output[_DIFSBN]);
  }
  if (output[_DIFSP] != null) {
    contents[_DIFSP] = (0, import_smithy_client.expectString)(output[_DIFSP]);
  }
  if (output[_DBEVA] != null) {
    contents[_DBEVA] = (0, import_smithy_client.expectString)(output[_DBEVA]);
  }
  if (output[_KMSKI] != null) {
    contents[_KMSKI] = (0, import_smithy_client.expectString)(output[_KMSKI]);
  }
  if (output[_CTr] != null) {
    contents[_CTr] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTr]));
  }
  if (output.TagList === "") {
    contents[_TL] = [];
  } else if (output[_TL] != null && output[_TL][_Tag] != null) {
    contents[_TL] = de_TagList((0, import_smithy_client.getArrayIfSingleItem)(output[_TL][_Tag]), context);
  }
  if (output[_SB] != null) {
    contents[_SB] = (0, import_smithy_client.parseBoolean)(output[_SB]);
  }
  if (output[_CDBEVM] != null) {
    contents[_CDBEVM] = (0, import_smithy_client.expectString)(output[_CDBEVM]);
  }
  if (output[_SLD] != null) {
    contents[_SLD] = (0, import_smithy_client.parseBoolean)(output[_SLD]);
  }
  if (output[_SCRWR] != null) {
    contents[_SCRWR] = (0, import_smithy_client.parseBoolean)(output[_SCRWR]);
  }
  if (output.SupportedCACertificateIdentifiers === "") {
    contents[_SCACI] = [];
  } else if (output[_SCACI] != null && output[_SCACI][_me] != null) {
    contents[_SCACI] = de_CACertificateIdentifiersList((0, import_smithy_client.getArrayIfSingleItem)(output[_SCACI][_me]), context);
  }
  if (output[_SLWF] != null) {
    contents[_SLWF] = (0, import_smithy_client.parseBoolean)(output[_SLWF]);
  }
  if (output[_SIup] != null) {
    contents[_SIup] = (0, import_smithy_client.parseBoolean)(output[_SIup]);
  }
  if (output[_SVFS] != null) {
    contents[_SVFS] = de_ServerlessV2FeaturesSupport(output[_SVFS], context);
  }
  return contents;
}, "de_DBEngineVersion");
var de_DBEngineVersionList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBEngineVersion(entry, context);
  });
}, "de_DBEngineVersionList");
var de_DBEngineVersionMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.DBEngineVersions === "") {
    contents[_DBEV] = [];
  } else if (output[_DBEV] != null && output[_DBEV][_DBEVn] != null) {
    contents[_DBEV] = de_DBEngineVersionList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBEV][_DBEVn]), context);
  }
  return contents;
}, "de_DBEngineVersionMessage");
var de_DBInstance = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBII] != null) {
    contents[_DBII] = (0, import_smithy_client.expectString)(output[_DBII]);
  }
  if (output[_DBIC] != null) {
    contents[_DBIC] = (0, import_smithy_client.expectString)(output[_DBIC]);
  }
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.expectString)(output[_E]);
  }
  if (output[_DBIS] != null) {
    contents[_DBIS] = (0, import_smithy_client.expectString)(output[_DBIS]);
  }
  if (output[_ART] != null) {
    contents[_ART] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_ART]));
  }
  if (output[_MU] != null) {
    contents[_MU] = (0, import_smithy_client.expectString)(output[_MU]);
  }
  if (output[_DBN] != null) {
    contents[_DBN] = (0, import_smithy_client.expectString)(output[_DBN]);
  }
  if (output[_End] != null) {
    contents[_End] = de_Endpoint(output[_End], context);
  }
  if (output[_AS] != null) {
    contents[_AS] = (0, import_smithy_client.strictParseInt32)(output[_AS]);
  }
  if (output[_ICTn] != null) {
    contents[_ICTn] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_ICTn]));
  }
  if (output[_PBW] != null) {
    contents[_PBW] = (0, import_smithy_client.expectString)(output[_PBW]);
  }
  if (output[_BRP] != null) {
    contents[_BRP] = (0, import_smithy_client.strictParseInt32)(output[_BRP]);
  }
  if (output.DBSecurityGroups === "") {
    contents[_DBSG] = [];
  } else if (output[_DBSG] != null && output[_DBSG][_DBSGe] != null) {
    contents[_DBSG] = de_DBSecurityGroupMembershipList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBSG][_DBSGe]), context);
  }
  if (output.VpcSecurityGroups === "") {
    contents[_VSG] = [];
  } else if (output[_VSG] != null && output[_VSG][_VSGMp] != null) {
    contents[_VSG] = de_VpcSecurityGroupMembershipList((0, import_smithy_client.getArrayIfSingleItem)(output[_VSG][_VSGMp]), context);
  }
  if (output.DBParameterGroups === "") {
    contents[_DBPGa] = [];
  } else if (output[_DBPGa] != null && output[_DBPGa][_DBPG] != null) {
    contents[_DBPGa] = de_DBParameterGroupStatusList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBPGa][_DBPG]), context);
  }
  if (output[_AZv] != null) {
    contents[_AZv] = (0, import_smithy_client.expectString)(output[_AZv]);
  }
  if (output[_DBSGu] != null) {
    contents[_DBSGu] = de_DBSubnetGroup(output[_DBSGu], context);
  }
  if (output[_PMW] != null) {
    contents[_PMW] = (0, import_smithy_client.expectString)(output[_PMW]);
  }
  if (output[_PMV] != null) {
    contents[_PMV] = de_PendingModifiedValues(output[_PMV], context);
  }
  if (output[_LRT] != null) {
    contents[_LRT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LRT]));
  }
  if (output[_MAZ] != null) {
    contents[_MAZ] = (0, import_smithy_client.parseBoolean)(output[_MAZ]);
  }
  if (output[_EV] != null) {
    contents[_EV] = (0, import_smithy_client.expectString)(output[_EV]);
  }
  if (output[_AMVU] != null) {
    contents[_AMVU] = (0, import_smithy_client.parseBoolean)(output[_AMVU]);
  }
  if (output[_RRSDBII] != null) {
    contents[_RRSDBII] = (0, import_smithy_client.expectString)(output[_RRSDBII]);
  }
  if (output.ReadReplicaDBInstanceIdentifiers === "") {
    contents[_RRDBII] = [];
  } else if (output[_RRDBII] != null && output[_RRDBII][_RRDBIIe] != null) {
    contents[_RRDBII] = de_ReadReplicaDBInstanceIdentifierList(
      (0, import_smithy_client.getArrayIfSingleItem)(output[_RRDBII][_RRDBIIe]),
      context
    );
  }
  if (output.ReadReplicaDBClusterIdentifiers === "") {
    contents[_RRDBCI] = [];
  } else if (output[_RRDBCI] != null && output[_RRDBCI][_RRDBCIe] != null) {
    contents[_RRDBCI] = de_ReadReplicaDBClusterIdentifierList(
      (0, import_smithy_client.getArrayIfSingleItem)(output[_RRDBCI][_RRDBCIe]),
      context
    );
  }
  if (output[_RM] != null) {
    contents[_RM] = (0, import_smithy_client.expectString)(output[_RM]);
  }
  if (output[_LM] != null) {
    contents[_LM] = (0, import_smithy_client.expectString)(output[_LM]);
  }
  if (output[_I] != null) {
    contents[_I] = (0, import_smithy_client.strictParseInt32)(output[_I]);
  }
  if (output.OptionGroupMemberships === "") {
    contents[_OGM] = [];
  } else if (output[_OGM] != null && output[_OGM][_OGMp] != null) {
    contents[_OGM] = de_OptionGroupMembershipList((0, import_smithy_client.getArrayIfSingleItem)(output[_OGM][_OGMp]), context);
  }
  if (output[_CSN] != null) {
    contents[_CSN] = (0, import_smithy_client.expectString)(output[_CSN]);
  }
  if (output[_NCSN] != null) {
    contents[_NCSN] = (0, import_smithy_client.expectString)(output[_NCSN]);
  }
  if (output[_SAZe] != null) {
    contents[_SAZe] = (0, import_smithy_client.expectString)(output[_SAZe]);
  }
  if (output[_PA] != null) {
    contents[_PA] = (0, import_smithy_client.parseBoolean)(output[_PA]);
  }
  if (output.StatusInfos === "") {
    contents[_SIt] = [];
  } else if (output[_SIt] != null && output[_SIt][_DBISI] != null) {
    contents[_SIt] = de_DBInstanceStatusInfoList((0, import_smithy_client.getArrayIfSingleItem)(output[_SIt][_DBISI]), context);
  }
  if (output[_STt] != null) {
    contents[_STt] = (0, import_smithy_client.expectString)(output[_STt]);
  }
  if (output[_TCA] != null) {
    contents[_TCA] = (0, import_smithy_client.expectString)(output[_TCA]);
  }
  if (output[_DIP] != null) {
    contents[_DIP] = (0, import_smithy_client.strictParseInt32)(output[_DIP]);
  }
  if (output[_DBCI] != null) {
    contents[_DBCI] = (0, import_smithy_client.expectString)(output[_DBCI]);
  }
  if (output[_SE] != null) {
    contents[_SE] = (0, import_smithy_client.parseBoolean)(output[_SE]);
  }
  if (output[_KKI] != null) {
    contents[_KKI] = (0, import_smithy_client.expectString)(output[_KKI]);
  }
  if (output[_DRI] != null) {
    contents[_DRI] = (0, import_smithy_client.expectString)(output[_DRI]);
  }
  if (output[_CACI] != null) {
    contents[_CACI] = (0, import_smithy_client.expectString)(output[_CACI]);
  }
  if (output.DomainMemberships === "") {
    contents[_DM] = [];
  } else if (output[_DM] != null && output[_DM][_DMo] != null) {
    contents[_DM] = de_DomainMembershipList((0, import_smithy_client.getArrayIfSingleItem)(output[_DM][_DMo]), context);
  }
  if (output[_CTTS] != null) {
    contents[_CTTS] = (0, import_smithy_client.parseBoolean)(output[_CTTS]);
  }
  if (output[_MIo] != null) {
    contents[_MIo] = (0, import_smithy_client.strictParseInt32)(output[_MIo]);
  }
  if (output[_EMRA] != null) {
    contents[_EMRA] = (0, import_smithy_client.expectString)(output[_EMRA]);
  }
  if (output[_MRA] != null) {
    contents[_MRA] = (0, import_smithy_client.expectString)(output[_MRA]);
  }
  if (output[_PT] != null) {
    contents[_PT] = (0, import_smithy_client.strictParseInt32)(output[_PT]);
  }
  if (output[_DBIA] != null) {
    contents[_DBIA] = (0, import_smithy_client.expectString)(output[_DBIA]);
  }
  if (output[_Ti] != null) {
    contents[_Ti] = (0, import_smithy_client.expectString)(output[_Ti]);
  }
  if (output[_IAMDAE] != null) {
    contents[_IAMDAE] = (0, import_smithy_client.parseBoolean)(output[_IAMDAE]);
  }
  if (output[_DIM] != null) {
    contents[_DIM] = (0, import_smithy_client.expectString)(output[_DIM]);
  }
  if (output[_PIE] != null) {
    contents[_PIE] = (0, import_smithy_client.parseBoolean)(output[_PIE]);
  }
  if (output[_PIKMSKI] != null) {
    contents[_PIKMSKI] = (0, import_smithy_client.expectString)(output[_PIKMSKI]);
  }
  if (output[_PIRP] != null) {
    contents[_PIRP] = (0, import_smithy_client.strictParseInt32)(output[_PIRP]);
  }
  if (output.EnabledCloudwatchLogsExports === "") {
    contents[_ECLEn] = [];
  } else if (output[_ECLEn] != null && output[_ECLEn][_me] != null) {
    contents[_ECLEn] = de_LogTypeList((0, import_smithy_client.getArrayIfSingleItem)(output[_ECLEn][_me]), context);
  }
  if (output.ProcessorFeatures === "") {
    contents[_PF] = [];
  } else if (output[_PF] != null && output[_PF][_PFr] != null) {
    contents[_PF] = de_ProcessorFeatureList((0, import_smithy_client.getArrayIfSingleItem)(output[_PF][_PFr]), context);
  }
  if (output[_DP] != null) {
    contents[_DP] = (0, import_smithy_client.parseBoolean)(output[_DP]);
  }
  if (output.AssociatedRoles === "") {
    contents[_AR] = [];
  } else if (output[_AR] != null && output[_AR][_DBIR] != null) {
    contents[_AR] = de_DBInstanceRoles((0, import_smithy_client.getArrayIfSingleItem)(output[_AR][_DBIR]), context);
  }
  if (output[_LE] != null) {
    contents[_LE] = de_Endpoint(output[_LE], context);
  }
  if (output[_MASa] != null) {
    contents[_MASa] = (0, import_smithy_client.strictParseInt32)(output[_MASa]);
  }
  if (output.TagList === "") {
    contents[_TL] = [];
  } else if (output[_TL] != null && output[_TL][_Tag] != null) {
    contents[_TL] = de_TagList((0, import_smithy_client.getArrayIfSingleItem)(output[_TL][_Tag]), context);
  }
  if (output.DBInstanceAutomatedBackupsReplications === "") {
    contents[_DBIABR] = [];
  } else if (output[_DBIABR] != null && output[_DBIABR][_DBIABRn] != null) {
    contents[_DBIABR] = de_DBInstanceAutomatedBackupsReplicationList(
      (0, import_smithy_client.getArrayIfSingleItem)(output[_DBIABR][_DBIABRn]),
      context
    );
  }
  if (output[_COIE] != null) {
    contents[_COIE] = (0, import_smithy_client.parseBoolean)(output[_COIE]);
  }
  if (output[_ABRPA] != null) {
    contents[_ABRPA] = (0, import_smithy_client.expectString)(output[_ABRPA]);
  }
  if (output[_ASS] != null) {
    contents[_ASS] = (0, import_smithy_client.expectString)(output[_ASS]);
  }
  if (output[_ASKKI] != null) {
    contents[_ASKKI] = (0, import_smithy_client.expectString)(output[_ASKKI]);
  }
  if (output[_ASKSN] != null) {
    contents[_ASKSN] = (0, import_smithy_client.expectString)(output[_ASKSN]);
  }
  if (output[_ASM] != null) {
    contents[_ASM] = (0, import_smithy_client.expectString)(output[_ASM]);
  }
  if (output[_ASENAFI] != null) {
    contents[_ASENAFI] = (0, import_smithy_client.parseBoolean)(output[_ASENAFI]);
  }
  if (output[_AM] != null) {
    contents[_AM] = (0, import_smithy_client.expectString)(output[_AM]);
  }
  if (output[_RFAMT] != null) {
    contents[_RFAMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_RFAMT]));
  }
  if (output[_CIIP] != null) {
    contents[_CIIP] = (0, import_smithy_client.expectString)(output[_CIIP]);
  }
  if (output[_BTa] != null) {
    contents[_BTa] = (0, import_smithy_client.expectString)(output[_BTa]);
  }
  if (output[_NT] != null) {
    contents[_NT] = (0, import_smithy_client.expectString)(output[_NT]);
  }
  if (output[_ASPS] != null) {
    contents[_ASPS] = (0, import_smithy_client.expectString)(output[_ASPS]);
  }
  if (output[_STto] != null) {
    contents[_STto] = (0, import_smithy_client.strictParseInt32)(output[_STto]);
  }
  if (output[_DBSI] != null) {
    contents[_DBSI] = (0, import_smithy_client.expectString)(output[_DBSI]);
  }
  if (output[_MUS] != null) {
    contents[_MUS] = de_MasterUserSecret(output[_MUS], context);
  }
  if (output[_CD] != null) {
    contents[_CD] = de_CertificateDetails(output[_CD], context);
  }
  if (output[_RRSDBCI] != null) {
    contents[_RRSDBCI] = (0, import_smithy_client.expectString)(output[_RRSDBCI]);
  }
  if (output[_PP] != null) {
    contents[_PP] = (0, import_smithy_client.expectString)(output[_PP]);
  }
  if (output[_DLV] != null) {
    contents[_DLV] = (0, import_smithy_client.parseBoolean)(output[_DLV]);
  }
  if (output[_ISCUA] != null) {
    contents[_ISCUA] = (0, import_smithy_client.parseBoolean)(output[_ISCUA]);
  }
  if (output[_MT] != null) {
    contents[_MT] = (0, import_smithy_client.parseBoolean)(output[_MT]);
  }
  if (output[_ELS] != null) {
    contents[_ELS] = (0, import_smithy_client.expectString)(output[_ELS]);
  }
  return contents;
}, "de_DBInstance");
var de_DBInstanceAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBInstanceAlreadyExistsFault");
var de_DBInstanceAutomatedBackup = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBIA] != null) {
    contents[_DBIA] = (0, import_smithy_client.expectString)(output[_DBIA]);
  }
  if (output[_DRI] != null) {
    contents[_DRI] = (0, import_smithy_client.expectString)(output[_DRI]);
  }
  if (output[_R] != null) {
    contents[_R] = (0, import_smithy_client.expectString)(output[_R]);
  }
  if (output[_DBII] != null) {
    contents[_DBII] = (0, import_smithy_client.expectString)(output[_DBII]);
  }
  if (output[_RW] != null) {
    contents[_RW] = de_RestoreWindow(output[_RW], context);
  }
  if (output[_AS] != null) {
    contents[_AS] = (0, import_smithy_client.strictParseInt32)(output[_AS]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_P] != null) {
    contents[_P] = (0, import_smithy_client.strictParseInt32)(output[_P]);
  }
  if (output[_AZv] != null) {
    contents[_AZv] = (0, import_smithy_client.expectString)(output[_AZv]);
  }
  if (output[_VI] != null) {
    contents[_VI] = (0, import_smithy_client.expectString)(output[_VI]);
  }
  if (output[_ICTn] != null) {
    contents[_ICTn] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_ICTn]));
  }
  if (output[_MU] != null) {
    contents[_MU] = (0, import_smithy_client.expectString)(output[_MU]);
  }
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.expectString)(output[_E]);
  }
  if (output[_EV] != null) {
    contents[_EV] = (0, import_smithy_client.expectString)(output[_EV]);
  }
  if (output[_LM] != null) {
    contents[_LM] = (0, import_smithy_client.expectString)(output[_LM]);
  }
  if (output[_I] != null) {
    contents[_I] = (0, import_smithy_client.strictParseInt32)(output[_I]);
  }
  if (output[_OGN] != null) {
    contents[_OGN] = (0, import_smithy_client.expectString)(output[_OGN]);
  }
  if (output[_TCA] != null) {
    contents[_TCA] = (0, import_smithy_client.expectString)(output[_TCA]);
  }
  if (output[_Enc] != null) {
    contents[_Enc] = (0, import_smithy_client.parseBoolean)(output[_Enc]);
  }
  if (output[_STt] != null) {
    contents[_STt] = (0, import_smithy_client.expectString)(output[_STt]);
  }
  if (output[_KKI] != null) {
    contents[_KKI] = (0, import_smithy_client.expectString)(output[_KKI]);
  }
  if (output[_Ti] != null) {
    contents[_Ti] = (0, import_smithy_client.expectString)(output[_Ti]);
  }
  if (output[_IAMDAE] != null) {
    contents[_IAMDAE] = (0, import_smithy_client.parseBoolean)(output[_IAMDAE]);
  }
  if (output[_BRP] != null) {
    contents[_BRP] = (0, import_smithy_client.strictParseInt32)(output[_BRP]);
  }
  if (output[_DBIABA] != null) {
    contents[_DBIABA] = (0, import_smithy_client.expectString)(output[_DBIABA]);
  }
  if (output.DBInstanceAutomatedBackupsReplications === "") {
    contents[_DBIABR] = [];
  } else if (output[_DBIABR] != null && output[_DBIABR][_DBIABRn] != null) {
    contents[_DBIABR] = de_DBInstanceAutomatedBackupsReplicationList(
      (0, import_smithy_client.getArrayIfSingleItem)(output[_DBIABR][_DBIABRn]),
      context
    );
  }
  if (output[_BTa] != null) {
    contents[_BTa] = (0, import_smithy_client.expectString)(output[_BTa]);
  }
  if (output[_STto] != null) {
    contents[_STto] = (0, import_smithy_client.strictParseInt32)(output[_STto]);
  }
  if (output[_ABRPA] != null) {
    contents[_ABRPA] = (0, import_smithy_client.expectString)(output[_ABRPA]);
  }
  if (output[_DLV] != null) {
    contents[_DLV] = (0, import_smithy_client.parseBoolean)(output[_DLV]);
  }
  if (output[_MT] != null) {
    contents[_MT] = (0, import_smithy_client.parseBoolean)(output[_MT]);
  }
  return contents;
}, "de_DBInstanceAutomatedBackup");
var de_DBInstanceAutomatedBackupList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBInstanceAutomatedBackup(entry, context);
  });
}, "de_DBInstanceAutomatedBackupList");
var de_DBInstanceAutomatedBackupMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.DBInstanceAutomatedBackups === "") {
    contents[_DBIAB] = [];
  } else if (output[_DBIAB] != null && output[_DBIAB][_DBIABn] != null) {
    contents[_DBIAB] = de_DBInstanceAutomatedBackupList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBIAB][_DBIABn]), context);
  }
  return contents;
}, "de_DBInstanceAutomatedBackupMessage");
var de_DBInstanceAutomatedBackupNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBInstanceAutomatedBackupNotFoundFault");
var de_DBInstanceAutomatedBackupQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBInstanceAutomatedBackupQuotaExceededFault");
var de_DBInstanceAutomatedBackupsReplication = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBIABA] != null) {
    contents[_DBIABA] = (0, import_smithy_client.expectString)(output[_DBIABA]);
  }
  return contents;
}, "de_DBInstanceAutomatedBackupsReplication");
var de_DBInstanceAutomatedBackupsReplicationList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBInstanceAutomatedBackupsReplication(entry, context);
  });
}, "de_DBInstanceAutomatedBackupsReplicationList");
var de_DBInstanceList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBInstance(entry, context);
  });
}, "de_DBInstanceList");
var de_DBInstanceMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.DBInstances === "") {
    contents[_DBIn] = [];
  } else if (output[_DBIn] != null && output[_DBIn][_DBI] != null) {
    contents[_DBIn] = de_DBInstanceList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBIn][_DBI]), context);
  }
  return contents;
}, "de_DBInstanceMessage");
var de_DBInstanceNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBInstanceNotFoundFault");
var de_DBInstanceNotReadyFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBInstanceNotReadyFault");
var de_DBInstanceRole = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RA] != null) {
    contents[_RA] = (0, import_smithy_client.expectString)(output[_RA]);
  }
  if (output[_FN] != null) {
    contents[_FN] = (0, import_smithy_client.expectString)(output[_FN]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  return contents;
}, "de_DBInstanceRole");
var de_DBInstanceRoleAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBInstanceRoleAlreadyExistsFault");
var de_DBInstanceRoleNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBInstanceRoleNotFoundFault");
var de_DBInstanceRoleQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBInstanceRoleQuotaExceededFault");
var de_DBInstanceRoles = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBInstanceRole(entry, context);
  });
}, "de_DBInstanceRoles");
var de_DBInstanceStatusInfo = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_STtat] != null) {
    contents[_STtat] = (0, import_smithy_client.expectString)(output[_STtat]);
  }
  if (output[_No] != null) {
    contents[_No] = (0, import_smithy_client.parseBoolean)(output[_No]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(output[_Me]);
  }
  return contents;
}, "de_DBInstanceStatusInfo");
var de_DBInstanceStatusInfoList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBInstanceStatusInfo(entry, context);
  });
}, "de_DBInstanceStatusInfoList");
var de_DBLogFileNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBLogFileNotFoundFault");
var de_DBMajorEngineVersion = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.expectString)(output[_E]);
  }
  if (output[_MEV] != null) {
    contents[_MEV] = (0, import_smithy_client.expectString)(output[_MEV]);
  }
  if (output.SupportedEngineLifecycles === "") {
    contents[_SEL] = [];
  } else if (output[_SEL] != null && output[_SEL][_SELu] != null) {
    contents[_SEL] = de_SupportedEngineLifecycleList((0, import_smithy_client.getArrayIfSingleItem)(output[_SEL][_SELu]), context);
  }
  return contents;
}, "de_DBMajorEngineVersion");
var de_DBMajorEngineVersionsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBMajorEngineVersion(entry, context);
  });
}, "de_DBMajorEngineVersionsList");
var de_DBParameterGroup = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBPGN] != null) {
    contents[_DBPGN] = (0, import_smithy_client.expectString)(output[_DBPGN]);
  }
  if (output[_DBPGF] != null) {
    contents[_DBPGF] = (0, import_smithy_client.expectString)(output[_DBPGF]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output[_DBPGA] != null) {
    contents[_DBPGA] = (0, import_smithy_client.expectString)(output[_DBPGA]);
  }
  return contents;
}, "de_DBParameterGroup");
var de_DBParameterGroupAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBParameterGroupAlreadyExistsFault");
var de_DBParameterGroupDetails = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Parameters === "") {
    contents[_Pa] = [];
  } else if (output[_Pa] != null && output[_Pa][_Par] != null) {
    contents[_Pa] = de_ParametersList((0, import_smithy_client.getArrayIfSingleItem)(output[_Pa][_Par]), context);
  }
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  return contents;
}, "de_DBParameterGroupDetails");
var de_DBParameterGroupList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBParameterGroup(entry, context);
  });
}, "de_DBParameterGroupList");
var de_DBParameterGroupNameMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBPGN] != null) {
    contents[_DBPGN] = (0, import_smithy_client.expectString)(output[_DBPGN]);
  }
  return contents;
}, "de_DBParameterGroupNameMessage");
var de_DBParameterGroupNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBParameterGroupNotFoundFault");
var de_DBParameterGroupQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBParameterGroupQuotaExceededFault");
var de_DBParameterGroupsMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.DBParameterGroups === "") {
    contents[_DBPGa] = [];
  } else if (output[_DBPGa] != null && output[_DBPGa][_DBPG] != null) {
    contents[_DBPGa] = de_DBParameterGroupList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBPGa][_DBPG]), context);
  }
  return contents;
}, "de_DBParameterGroupsMessage");
var de_DBParameterGroupStatus = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBPGN] != null) {
    contents[_DBPGN] = (0, import_smithy_client.expectString)(output[_DBPGN]);
  }
  if (output[_PAS] != null) {
    contents[_PAS] = (0, import_smithy_client.expectString)(output[_PAS]);
  }
  return contents;
}, "de_DBParameterGroupStatus");
var de_DBParameterGroupStatusList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBParameterGroupStatus(entry, context);
  });
}, "de_DBParameterGroupStatusList");
var de_DBProxy = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBPN] != null) {
    contents[_DBPN] = (0, import_smithy_client.expectString)(output[_DBPN]);
  }
  if (output[_DBPA] != null) {
    contents[_DBPA] = (0, import_smithy_client.expectString)(output[_DBPA]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_EF] != null) {
    contents[_EF] = (0, import_smithy_client.expectString)(output[_EF]);
  }
  if (output[_VI] != null) {
    contents[_VI] = (0, import_smithy_client.expectString)(output[_VI]);
  }
  if (output.VpcSecurityGroupIds === "") {
    contents[_VSGI] = [];
  } else if (output[_VSGI] != null && output[_VSGI][_me] != null) {
    contents[_VSGI] = de_StringList((0, import_smithy_client.getArrayIfSingleItem)(output[_VSGI][_me]), context);
  }
  if (output.VpcSubnetIds === "") {
    contents[_VSI] = [];
  } else if (output[_VSI] != null && output[_VSI][_me] != null) {
    contents[_VSI] = de_StringList((0, import_smithy_client.getArrayIfSingleItem)(output[_VSI][_me]), context);
  }
  if (output.Auth === "") {
    contents[_Au] = [];
  } else if (output[_Au] != null && output[_Au][_me] != null) {
    contents[_Au] = de_UserAuthConfigInfoList((0, import_smithy_client.getArrayIfSingleItem)(output[_Au][_me]), context);
  }
  if (output[_RA] != null) {
    contents[_RA] = (0, import_smithy_client.expectString)(output[_RA]);
  }
  if (output[_End] != null) {
    contents[_End] = (0, import_smithy_client.expectString)(output[_End]);
  }
  if (output[_RTLS] != null) {
    contents[_RTLS] = (0, import_smithy_client.parseBoolean)(output[_RTLS]);
  }
  if (output[_ICT] != null) {
    contents[_ICT] = (0, import_smithy_client.strictParseInt32)(output[_ICT]);
  }
  if (output[_DL] != null) {
    contents[_DL] = (0, import_smithy_client.parseBoolean)(output[_DL]);
  }
  if (output[_CDr] != null) {
    contents[_CDr] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CDr]));
  }
  if (output[_UD] != null) {
    contents[_UD] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_UD]));
  }
  return contents;
}, "de_DBProxy");
var de_DBProxyAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBProxyAlreadyExistsFault");
var de_DBProxyEndpoint = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBPEN] != null) {
    contents[_DBPEN] = (0, import_smithy_client.expectString)(output[_DBPEN]);
  }
  if (output[_DBPEA] != null) {
    contents[_DBPEA] = (0, import_smithy_client.expectString)(output[_DBPEA]);
  }
  if (output[_DBPN] != null) {
    contents[_DBPN] = (0, import_smithy_client.expectString)(output[_DBPN]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_VI] != null) {
    contents[_VI] = (0, import_smithy_client.expectString)(output[_VI]);
  }
  if (output.VpcSecurityGroupIds === "") {
    contents[_VSGI] = [];
  } else if (output[_VSGI] != null && output[_VSGI][_me] != null) {
    contents[_VSGI] = de_StringList((0, import_smithy_client.getArrayIfSingleItem)(output[_VSGI][_me]), context);
  }
  if (output.VpcSubnetIds === "") {
    contents[_VSI] = [];
  } else if (output[_VSI] != null && output[_VSI][_me] != null) {
    contents[_VSI] = de_StringList((0, import_smithy_client.getArrayIfSingleItem)(output[_VSI][_me]), context);
  }
  if (output[_End] != null) {
    contents[_End] = (0, import_smithy_client.expectString)(output[_End]);
  }
  if (output[_CDr] != null) {
    contents[_CDr] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CDr]));
  }
  if (output[_TR] != null) {
    contents[_TR] = (0, import_smithy_client.expectString)(output[_TR]);
  }
  if (output[_ID] != null) {
    contents[_ID] = (0, import_smithy_client.parseBoolean)(output[_ID]);
  }
  return contents;
}, "de_DBProxyEndpoint");
var de_DBProxyEndpointAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBProxyEndpointAlreadyExistsFault");
var de_DBProxyEndpointList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBProxyEndpoint(entry, context);
  });
}, "de_DBProxyEndpointList");
var de_DBProxyEndpointNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBProxyEndpointNotFoundFault");
var de_DBProxyEndpointQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBProxyEndpointQuotaExceededFault");
var de_DBProxyList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBProxy(entry, context);
  });
}, "de_DBProxyList");
var de_DBProxyNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBProxyNotFoundFault");
var de_DBProxyQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBProxyQuotaExceededFault");
var de_DBProxyTarget = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_TA] != null) {
    contents[_TA] = (0, import_smithy_client.expectString)(output[_TA]);
  }
  if (output[_End] != null) {
    contents[_End] = (0, import_smithy_client.expectString)(output[_End]);
  }
  if (output[_TCI] != null) {
    contents[_TCI] = (0, import_smithy_client.expectString)(output[_TCI]);
  }
  if (output[_RRId] != null) {
    contents[_RRId] = (0, import_smithy_client.expectString)(output[_RRId]);
  }
  if (output[_P] != null) {
    contents[_P] = (0, import_smithy_client.strictParseInt32)(output[_P]);
  }
  if (output[_Ty] != null) {
    contents[_Ty] = (0, import_smithy_client.expectString)(output[_Ty]);
  }
  if (output[_Ro] != null) {
    contents[_Ro] = (0, import_smithy_client.expectString)(output[_Ro]);
  }
  if (output[_TH] != null) {
    contents[_TH] = de_TargetHealth(output[_TH], context);
  }
  return contents;
}, "de_DBProxyTarget");
var de_DBProxyTargetAlreadyRegisteredFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBProxyTargetAlreadyRegisteredFault");
var de_DBProxyTargetGroup = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBPN] != null) {
    contents[_DBPN] = (0, import_smithy_client.expectString)(output[_DBPN]);
  }
  if (output[_TGN] != null) {
    contents[_TGN] = (0, import_smithy_client.expectString)(output[_TGN]);
  }
  if (output[_TGA] != null) {
    contents[_TGA] = (0, import_smithy_client.expectString)(output[_TGA]);
  }
  if (output[_ID] != null) {
    contents[_ID] = (0, import_smithy_client.parseBoolean)(output[_ID]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_CPC] != null) {
    contents[_CPC] = de_ConnectionPoolConfigurationInfo(output[_CPC], context);
  }
  if (output[_CDr] != null) {
    contents[_CDr] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CDr]));
  }
  if (output[_UD] != null) {
    contents[_UD] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_UD]));
  }
  return contents;
}, "de_DBProxyTargetGroup");
var de_DBProxyTargetGroupNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBProxyTargetGroupNotFoundFault");
var de_DBProxyTargetNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBProxyTargetNotFoundFault");
var de_DBRecommendation = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RIe] != null) {
    contents[_RIe] = (0, import_smithy_client.expectString)(output[_RIe]);
  }
  if (output[_TIy] != null) {
    contents[_TIy] = (0, import_smithy_client.expectString)(output[_TIy]);
  }
  if (output[_Se] != null) {
    contents[_Se] = (0, import_smithy_client.expectString)(output[_Se]);
  }
  if (output[_RAe] != null) {
    contents[_RAe] = (0, import_smithy_client.expectString)(output[_RAe]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_CTre] != null) {
    contents[_CTre] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTre]));
  }
  if (output[_UTp] != null) {
    contents[_UTp] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_UTp]));
  }
  if (output[_De] != null) {
    contents[_De] = (0, import_smithy_client.expectString)(output[_De]);
  }
  if (output[_Re] != null) {
    contents[_Re] = (0, import_smithy_client.expectString)(output[_Re]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output[_Rea] != null) {
    contents[_Rea] = (0, import_smithy_client.expectString)(output[_Rea]);
  }
  if (output.RecommendedActions === "") {
    contents[_RAec] = [];
  } else if (output[_RAec] != null && output[_RAec][_me] != null) {
    contents[_RAec] = de_RecommendedActionList((0, import_smithy_client.getArrayIfSingleItem)(output[_RAec][_me]), context);
  }
  if (output[_Ca] != null) {
    contents[_Ca] = (0, import_smithy_client.expectString)(output[_Ca]);
  }
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.expectString)(output[_S]);
  }
  if (output[_TDy] != null) {
    contents[_TDy] = (0, import_smithy_client.expectString)(output[_TDy]);
  }
  if (output[_TRy] != null) {
    contents[_TRy] = (0, import_smithy_client.expectString)(output[_TRy]);
  }
  if (output[_Imp] != null) {
    contents[_Imp] = (0, import_smithy_client.expectString)(output[_Imp]);
  }
  if (output[_AId] != null) {
    contents[_AId] = (0, import_smithy_client.expectString)(output[_AId]);
  }
  if (output.Links === "") {
    contents[_Li] = [];
  } else if (output[_Li] != null && output[_Li][_me] != null) {
    contents[_Li] = de_DocLinkList((0, import_smithy_client.getArrayIfSingleItem)(output[_Li][_me]), context);
  }
  if (output[_IDs] != null) {
    contents[_IDs] = de_IssueDetails(output[_IDs], context);
  }
  return contents;
}, "de_DBRecommendation");
var de_DBRecommendationList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBRecommendation(entry, context);
  });
}, "de_DBRecommendationList");
var de_DBRecommendationMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBR] != null) {
    contents[_DBR] = de_DBRecommendation(output[_DBR], context);
  }
  return contents;
}, "de_DBRecommendationMessage");
var de_DBRecommendationsMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.DBRecommendations === "") {
    contents[_DBRe] = [];
  } else if (output[_DBRe] != null && output[_DBRe][_me] != null) {
    contents[_DBRe] = de_DBRecommendationList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBRe][_me]), context);
  }
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  return contents;
}, "de_DBRecommendationsMessage");
var de_DBSecurityGroup = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_OI] != null) {
    contents[_OI] = (0, import_smithy_client.expectString)(output[_OI]);
  }
  if (output[_DBSGN] != null) {
    contents[_DBSGN] = (0, import_smithy_client.expectString)(output[_DBSGN]);
  }
  if (output[_DBSGD] != null) {
    contents[_DBSGD] = (0, import_smithy_client.expectString)(output[_DBSGD]);
  }
  if (output[_VI] != null) {
    contents[_VI] = (0, import_smithy_client.expectString)(output[_VI]);
  }
  if (output.EC2SecurityGroups === "") {
    contents[_ECSG] = [];
  } else if (output[_ECSG] != null && output[_ECSG][_ECSGe] != null) {
    contents[_ECSG] = de_EC2SecurityGroupList((0, import_smithy_client.getArrayIfSingleItem)(output[_ECSG][_ECSGe]), context);
  }
  if (output.IPRanges === "") {
    contents[_IPR] = [];
  } else if (output[_IPR] != null && output[_IPR][_IPRa] != null) {
    contents[_IPR] = de_IPRangeList((0, import_smithy_client.getArrayIfSingleItem)(output[_IPR][_IPRa]), context);
  }
  if (output[_DBSGA] != null) {
    contents[_DBSGA] = (0, import_smithy_client.expectString)(output[_DBSGA]);
  }
  return contents;
}, "de_DBSecurityGroup");
var de_DBSecurityGroupAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBSecurityGroupAlreadyExistsFault");
var de_DBSecurityGroupMembership = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBSGN] != null) {
    contents[_DBSGN] = (0, import_smithy_client.expectString)(output[_DBSGN]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  return contents;
}, "de_DBSecurityGroupMembership");
var de_DBSecurityGroupMembershipList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBSecurityGroupMembership(entry, context);
  });
}, "de_DBSecurityGroupMembershipList");
var de_DBSecurityGroupMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.DBSecurityGroups === "") {
    contents[_DBSG] = [];
  } else if (output[_DBSG] != null && output[_DBSG][_DBSGe] != null) {
    contents[_DBSG] = de_DBSecurityGroups((0, import_smithy_client.getArrayIfSingleItem)(output[_DBSG][_DBSGe]), context);
  }
  return contents;
}, "de_DBSecurityGroupMessage");
var de_DBSecurityGroupNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBSecurityGroupNotFoundFault");
var de_DBSecurityGroupNotSupportedFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBSecurityGroupNotSupportedFault");
var de_DBSecurityGroupQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBSecurityGroupQuotaExceededFault");
var de_DBSecurityGroups = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBSecurityGroup(entry, context);
  });
}, "de_DBSecurityGroups");
var de_DBShardGroup = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBSGRI] != null) {
    contents[_DBSGRI] = (0, import_smithy_client.expectString)(output[_DBSGRI]);
  }
  if (output[_DBSGI] != null) {
    contents[_DBSGI] = (0, import_smithy_client.expectString)(output[_DBSGI]);
  }
  if (output[_DBCI] != null) {
    contents[_DBCI] = (0, import_smithy_client.expectString)(output[_DBCI]);
  }
  if (output[_MACU] != null) {
    contents[_MACU] = (0, import_smithy_client.strictParseFloat)(output[_MACU]);
  }
  if (output[_MACUi] != null) {
    contents[_MACUi] = (0, import_smithy_client.strictParseFloat)(output[_MACUi]);
  }
  if (output[_CR] != null) {
    contents[_CR] = (0, import_smithy_client.strictParseInt32)(output[_CR]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_PA] != null) {
    contents[_PA] = (0, import_smithy_client.parseBoolean)(output[_PA]);
  }
  if (output[_End] != null) {
    contents[_End] = (0, import_smithy_client.expectString)(output[_End]);
  }
  if (output[_DBSGAh] != null) {
    contents[_DBSGAh] = (0, import_smithy_client.expectString)(output[_DBSGAh]);
  }
  if (output.TagList === "") {
    contents[_TL] = [];
  } else if (output[_TL] != null && output[_TL][_Tag] != null) {
    contents[_TL] = de_TagList((0, import_smithy_client.getArrayIfSingleItem)(output[_TL][_Tag]), context);
  }
  return contents;
}, "de_DBShardGroup");
var de_DBShardGroupAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBShardGroupAlreadyExistsFault");
var de_DBShardGroupNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBShardGroupNotFoundFault");
var de_DBShardGroupsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBShardGroup(entry, context);
  });
}, "de_DBShardGroupsList");
var de_DBSnapshot = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBSIn] != null) {
    contents[_DBSIn] = (0, import_smithy_client.expectString)(output[_DBSIn]);
  }
  if (output[_DBII] != null) {
    contents[_DBII] = (0, import_smithy_client.expectString)(output[_DBII]);
  }
  if (output[_SCT] != null) {
    contents[_SCT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_SCT]));
  }
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.expectString)(output[_E]);
  }
  if (output[_AS] != null) {
    contents[_AS] = (0, import_smithy_client.strictParseInt32)(output[_AS]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_P] != null) {
    contents[_P] = (0, import_smithy_client.strictParseInt32)(output[_P]);
  }
  if (output[_AZv] != null) {
    contents[_AZv] = (0, import_smithy_client.expectString)(output[_AZv]);
  }
  if (output[_VI] != null) {
    contents[_VI] = (0, import_smithy_client.expectString)(output[_VI]);
  }
  if (output[_ICTn] != null) {
    contents[_ICTn] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_ICTn]));
  }
  if (output[_MU] != null) {
    contents[_MU] = (0, import_smithy_client.expectString)(output[_MU]);
  }
  if (output[_EV] != null) {
    contents[_EV] = (0, import_smithy_client.expectString)(output[_EV]);
  }
  if (output[_LM] != null) {
    contents[_LM] = (0, import_smithy_client.expectString)(output[_LM]);
  }
  if (output[_STn] != null) {
    contents[_STn] = (0, import_smithy_client.expectString)(output[_STn]);
  }
  if (output[_I] != null) {
    contents[_I] = (0, import_smithy_client.strictParseInt32)(output[_I]);
  }
  if (output[_OGN] != null) {
    contents[_OGN] = (0, import_smithy_client.expectString)(output[_OGN]);
  }
  if (output[_PP] != null) {
    contents[_PP] = (0, import_smithy_client.strictParseInt32)(output[_PP]);
  }
  if (output[_SR] != null) {
    contents[_SR] = (0, import_smithy_client.expectString)(output[_SR]);
  }
  if (output[_SDBSI] != null) {
    contents[_SDBSI] = (0, import_smithy_client.expectString)(output[_SDBSI]);
  }
  if (output[_STt] != null) {
    contents[_STt] = (0, import_smithy_client.expectString)(output[_STt]);
  }
  if (output[_TCA] != null) {
    contents[_TCA] = (0, import_smithy_client.expectString)(output[_TCA]);
  }
  if (output[_Enc] != null) {
    contents[_Enc] = (0, import_smithy_client.parseBoolean)(output[_Enc]);
  }
  if (output[_KKI] != null) {
    contents[_KKI] = (0, import_smithy_client.expectString)(output[_KKI]);
  }
  if (output[_DBSA] != null) {
    contents[_DBSA] = (0, import_smithy_client.expectString)(output[_DBSA]);
  }
  if (output[_Ti] != null) {
    contents[_Ti] = (0, import_smithy_client.expectString)(output[_Ti]);
  }
  if (output[_IAMDAE] != null) {
    contents[_IAMDAE] = (0, import_smithy_client.parseBoolean)(output[_IAMDAE]);
  }
  if (output.ProcessorFeatures === "") {
    contents[_PF] = [];
  } else if (output[_PF] != null && output[_PF][_PFr] != null) {
    contents[_PF] = de_ProcessorFeatureList((0, import_smithy_client.getArrayIfSingleItem)(output[_PF][_PFr]), context);
  }
  if (output[_DRI] != null) {
    contents[_DRI] = (0, import_smithy_client.expectString)(output[_DRI]);
  }
  if (output.TagList === "") {
    contents[_TL] = [];
  } else if (output[_TL] != null && output[_TL][_Tag] != null) {
    contents[_TL] = de_TagList((0, import_smithy_client.getArrayIfSingleItem)(output[_TL][_Tag]), context);
  }
  if (output[_OSCT] != null) {
    contents[_OSCT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_OSCT]));
  }
  if (output[_SDT] != null) {
    contents[_SDT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_SDT]));
  }
  if (output[_ST] != null) {
    contents[_ST] = (0, import_smithy_client.expectString)(output[_ST]);
  }
  if (output[_STto] != null) {
    contents[_STto] = (0, import_smithy_client.strictParseInt32)(output[_STto]);
  }
  if (output[_DBSI] != null) {
    contents[_DBSI] = (0, import_smithy_client.expectString)(output[_DBSI]);
  }
  if (output[_DLV] != null) {
    contents[_DLV] = (0, import_smithy_client.parseBoolean)(output[_DLV]);
  }
  if (output[_MT] != null) {
    contents[_MT] = (0, import_smithy_client.parseBoolean)(output[_MT]);
  }
  if (output[_SAZ] != null) {
    contents[_SAZ] = (0, import_smithy_client.expectString)(output[_SAZ]);
  }
  return contents;
}, "de_DBSnapshot");
var de_DBSnapshotAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBSnapshotAlreadyExistsFault");
var de_DBSnapshotAttribute = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_AN] != null) {
    contents[_AN] = (0, import_smithy_client.expectString)(output[_AN]);
  }
  if (output.AttributeValues === "") {
    contents[_AVt] = [];
  } else if (output[_AVt] != null && output[_AVt][_AVtt] != null) {
    contents[_AVt] = de_AttributeValueList((0, import_smithy_client.getArrayIfSingleItem)(output[_AVt][_AVtt]), context);
  }
  return contents;
}, "de_DBSnapshotAttribute");
var de_DBSnapshotAttributeList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBSnapshotAttribute(entry, context);
  });
}, "de_DBSnapshotAttributeList");
var de_DBSnapshotAttributesResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBSIn] != null) {
    contents[_DBSIn] = (0, import_smithy_client.expectString)(output[_DBSIn]);
  }
  if (output.DBSnapshotAttributes === "") {
    contents[_DBSAn] = [];
  } else if (output[_DBSAn] != null && output[_DBSAn][_DBSAna] != null) {
    contents[_DBSAn] = de_DBSnapshotAttributeList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBSAn][_DBSAna]), context);
  }
  return contents;
}, "de_DBSnapshotAttributesResult");
var de_DBSnapshotList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBSnapshot(entry, context);
  });
}, "de_DBSnapshotList");
var de_DBSnapshotMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.DBSnapshots === "") {
    contents[_DBSn] = [];
  } else if (output[_DBSn] != null && output[_DBSn][_DBS] != null) {
    contents[_DBSn] = de_DBSnapshotList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBSn][_DBS]), context);
  }
  return contents;
}, "de_DBSnapshotMessage");
var de_DBSnapshotNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBSnapshotNotFoundFault");
var de_DBSnapshotTenantDatabase = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBSIn] != null) {
    contents[_DBSIn] = (0, import_smithy_client.expectString)(output[_DBSIn]);
  }
  if (output[_DBII] != null) {
    contents[_DBII] = (0, import_smithy_client.expectString)(output[_DBII]);
  }
  if (output[_DRI] != null) {
    contents[_DRI] = (0, import_smithy_client.expectString)(output[_DRI]);
  }
  if (output[_EN] != null) {
    contents[_EN] = (0, import_smithy_client.expectString)(output[_EN]);
  }
  if (output[_STn] != null) {
    contents[_STn] = (0, import_smithy_client.expectString)(output[_STn]);
  }
  if (output[_TDCT] != null) {
    contents[_TDCT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_TDCT]));
  }
  if (output[_TDBN] != null) {
    contents[_TDBN] = (0, import_smithy_client.expectString)(output[_TDBN]);
  }
  if (output[_MU] != null) {
    contents[_MU] = (0, import_smithy_client.expectString)(output[_MU]);
  }
  if (output[_TDRI] != null) {
    contents[_TDRI] = (0, import_smithy_client.expectString)(output[_TDRI]);
  }
  if (output[_CSN] != null) {
    contents[_CSN] = (0, import_smithy_client.expectString)(output[_CSN]);
  }
  if (output[_DBSTDARN] != null) {
    contents[_DBSTDARN] = (0, import_smithy_client.expectString)(output[_DBSTDARN]);
  }
  if (output[_NCSN] != null) {
    contents[_NCSN] = (0, import_smithy_client.expectString)(output[_NCSN]);
  }
  if (output.TagList === "") {
    contents[_TL] = [];
  } else if (output[_TL] != null && output[_TL][_Tag] != null) {
    contents[_TL] = de_TagList((0, import_smithy_client.getArrayIfSingleItem)(output[_TL][_Tag]), context);
  }
  return contents;
}, "de_DBSnapshotTenantDatabase");
var de_DBSnapshotTenantDatabaseNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBSnapshotTenantDatabaseNotFoundFault");
var de_DBSnapshotTenantDatabasesList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBSnapshotTenantDatabase(entry, context);
  });
}, "de_DBSnapshotTenantDatabasesList");
var de_DBSnapshotTenantDatabasesMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.DBSnapshotTenantDatabases === "") {
    contents[_DBSTD] = [];
  } else if (output[_DBSTD] != null && output[_DBSTD][_DBSTDn] != null) {
    contents[_DBSTD] = de_DBSnapshotTenantDatabasesList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBSTD][_DBSTDn]), context);
  }
  return contents;
}, "de_DBSnapshotTenantDatabasesMessage");
var de_DBSubnetGroup = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBSGNu] != null) {
    contents[_DBSGNu] = (0, import_smithy_client.expectString)(output[_DBSGNu]);
  }
  if (output[_DBSGDu] != null) {
    contents[_DBSGDu] = (0, import_smithy_client.expectString)(output[_DBSGDu]);
  }
  if (output[_VI] != null) {
    contents[_VI] = (0, import_smithy_client.expectString)(output[_VI]);
  }
  if (output[_SGS] != null) {
    contents[_SGS] = (0, import_smithy_client.expectString)(output[_SGS]);
  }
  if (output.Subnets === "") {
    contents[_Su] = [];
  } else if (output[_Su] != null && output[_Su][_Sub] != null) {
    contents[_Su] = de_SubnetList((0, import_smithy_client.getArrayIfSingleItem)(output[_Su][_Sub]), context);
  }
  if (output[_DBSGAu] != null) {
    contents[_DBSGAu] = (0, import_smithy_client.expectString)(output[_DBSGAu]);
  }
  if (output.SupportedNetworkTypes === "") {
    contents[_SNT] = [];
  } else if (output[_SNT] != null && output[_SNT][_me] != null) {
    contents[_SNT] = de_StringList((0, import_smithy_client.getArrayIfSingleItem)(output[_SNT][_me]), context);
  }
  return contents;
}, "de_DBSubnetGroup");
var de_DBSubnetGroupAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBSubnetGroupAlreadyExistsFault");
var de_DBSubnetGroupDoesNotCoverEnoughAZs = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBSubnetGroupDoesNotCoverEnoughAZs");
var de_DBSubnetGroupMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.DBSubnetGroups === "") {
    contents[_DBSGub] = [];
  } else if (output[_DBSGub] != null && output[_DBSGub][_DBSGu] != null) {
    contents[_DBSGub] = de_DBSubnetGroups((0, import_smithy_client.getArrayIfSingleItem)(output[_DBSGub][_DBSGu]), context);
  }
  return contents;
}, "de_DBSubnetGroupMessage");
var de_DBSubnetGroupNotAllowedFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBSubnetGroupNotAllowedFault");
var de_DBSubnetGroupNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBSubnetGroupNotFoundFault");
var de_DBSubnetGroupQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBSubnetGroupQuotaExceededFault");
var de_DBSubnetGroups = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBSubnetGroup(entry, context);
  });
}, "de_DBSubnetGroups");
var de_DBSubnetQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBSubnetQuotaExceededFault");
var de_DBUpgradeDependencyFailureFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DBUpgradeDependencyFailureFault");
var de_DeleteBlueGreenDeploymentResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_BGD] != null) {
    contents[_BGD] = de_BlueGreenDeployment(output[_BGD], context);
  }
  return contents;
}, "de_DeleteBlueGreenDeploymentResponse");
var de_DeleteDBClusterAutomatedBackupResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBCABl] != null) {
    contents[_DBCABl] = de_DBClusterAutomatedBackup(output[_DBCABl], context);
  }
  return contents;
}, "de_DeleteDBClusterAutomatedBackupResult");
var de_DeleteDBClusterResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBC] != null) {
    contents[_DBC] = de_DBCluster(output[_DBC], context);
  }
  return contents;
}, "de_DeleteDBClusterResult");
var de_DeleteDBClusterSnapshotResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBCS] != null) {
    contents[_DBCS] = de_DBClusterSnapshot(output[_DBCS], context);
  }
  return contents;
}, "de_DeleteDBClusterSnapshotResult");
var de_DeleteDBInstanceAutomatedBackupResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBIABn] != null) {
    contents[_DBIABn] = de_DBInstanceAutomatedBackup(output[_DBIABn], context);
  }
  return contents;
}, "de_DeleteDBInstanceAutomatedBackupResult");
var de_DeleteDBInstanceResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBI] != null) {
    contents[_DBI] = de_DBInstance(output[_DBI], context);
  }
  return contents;
}, "de_DeleteDBInstanceResult");
var de_DeleteDBProxyEndpointResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBPE] != null) {
    contents[_DBPE] = de_DBProxyEndpoint(output[_DBPE], context);
  }
  return contents;
}, "de_DeleteDBProxyEndpointResponse");
var de_DeleteDBProxyResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBP] != null) {
    contents[_DBP] = de_DBProxy(output[_DBP], context);
  }
  return contents;
}, "de_DeleteDBProxyResponse");
var de_DeleteDBSnapshotResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBS] != null) {
    contents[_DBS] = de_DBSnapshot(output[_DBS], context);
  }
  return contents;
}, "de_DeleteDBSnapshotResult");
var de_DeleteEventSubscriptionResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_ES] != null) {
    contents[_ES] = de_EventSubscription(output[_ES], context);
  }
  return contents;
}, "de_DeleteEventSubscriptionResult");
var de_DeleteGlobalClusterResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_GC] != null) {
    contents[_GC] = de_GlobalCluster(output[_GC], context);
  }
  return contents;
}, "de_DeleteGlobalClusterResult");
var de_DeleteTenantDatabaseResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_TD] != null) {
    contents[_TD] = de_TenantDatabase(output[_TD], context);
  }
  return contents;
}, "de_DeleteTenantDatabaseResult");
var de_DeregisterDBProxyTargetsResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  return contents;
}, "de_DeregisterDBProxyTargetsResponse");
var de_DescribeBlueGreenDeploymentsResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.BlueGreenDeployments === "") {
    contents[_BGDl] = [];
  } else if (output[_BGDl] != null && output[_BGDl][_me] != null) {
    contents[_BGDl] = de_BlueGreenDeploymentList((0, import_smithy_client.getArrayIfSingleItem)(output[_BGDl][_me]), context);
  }
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  return contents;
}, "de_DescribeBlueGreenDeploymentsResponse");
var de_DescribeDBClusterSnapshotAttributesResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBCSAR] != null) {
    contents[_DBCSAR] = de_DBClusterSnapshotAttributesResult(output[_DBCSAR], context);
  }
  return contents;
}, "de_DescribeDBClusterSnapshotAttributesResult");
var de_DescribeDBLogFilesDetails = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_LFN] != null) {
    contents[_LFN] = (0, import_smithy_client.expectString)(output[_LFN]);
  }
  if (output[_LW] != null) {
    contents[_LW] = (0, import_smithy_client.strictParseLong)(output[_LW]);
  }
  if (output[_Si] != null) {
    contents[_Si] = (0, import_smithy_client.strictParseLong)(output[_Si]);
  }
  return contents;
}, "de_DescribeDBLogFilesDetails");
var de_DescribeDBLogFilesList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DescribeDBLogFilesDetails(entry, context);
  });
}, "de_DescribeDBLogFilesList");
var de_DescribeDBLogFilesResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.DescribeDBLogFiles === "") {
    contents[_DDBLF] = [];
  } else if (output[_DDBLF] != null && output[_DDBLF][_DDBLFD] != null) {
    contents[_DDBLF] = de_DescribeDBLogFilesList((0, import_smithy_client.getArrayIfSingleItem)(output[_DDBLF][_DDBLFD]), context);
  }
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  return contents;
}, "de_DescribeDBLogFilesResponse");
var de_DescribeDBMajorEngineVersionsResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.DBMajorEngineVersions === "") {
    contents[_DBMEV] = [];
  } else if (output[_DBMEV] != null && output[_DBMEV][_DBMEVa] != null) {
    contents[_DBMEV] = de_DBMajorEngineVersionsList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBMEV][_DBMEVa]), context);
  }
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  return contents;
}, "de_DescribeDBMajorEngineVersionsResponse");
var de_DescribeDBProxiesResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.DBProxies === "") {
    contents[_DBPr] = [];
  } else if (output[_DBPr] != null && output[_DBPr][_me] != null) {
    contents[_DBPr] = de_DBProxyList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBPr][_me]), context);
  }
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  return contents;
}, "de_DescribeDBProxiesResponse");
var de_DescribeDBProxyEndpointsResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.DBProxyEndpoints === "") {
    contents[_DBPEr] = [];
  } else if (output[_DBPEr] != null && output[_DBPEr][_me] != null) {
    contents[_DBPEr] = de_DBProxyEndpointList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBPEr][_me]), context);
  }
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  return contents;
}, "de_DescribeDBProxyEndpointsResponse");
var de_DescribeDBProxyTargetGroupsResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.TargetGroups === "") {
    contents[_TG] = [];
  } else if (output[_TG] != null && output[_TG][_me] != null) {
    contents[_TG] = de_TargetGroupList((0, import_smithy_client.getArrayIfSingleItem)(output[_TG][_me]), context);
  }
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  return contents;
}, "de_DescribeDBProxyTargetGroupsResponse");
var de_DescribeDBProxyTargetsResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Targets === "") {
    contents[_Tar] = [];
  } else if (output[_Tar] != null && output[_Tar][_me] != null) {
    contents[_Tar] = de_TargetList((0, import_smithy_client.getArrayIfSingleItem)(output[_Tar][_me]), context);
  }
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  return contents;
}, "de_DescribeDBProxyTargetsResponse");
var de_DescribeDBShardGroupsResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.DBShardGroups === "") {
    contents[_DBSGh] = [];
  } else if (output[_DBSGh] != null && output[_DBSGh][_DBSGha] != null) {
    contents[_DBSGh] = de_DBShardGroupsList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBSGh][_DBSGha]), context);
  }
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  return contents;
}, "de_DescribeDBShardGroupsResponse");
var de_DescribeDBSnapshotAttributesResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBSAR] != null) {
    contents[_DBSAR] = de_DBSnapshotAttributesResult(output[_DBSAR], context);
  }
  return contents;
}, "de_DescribeDBSnapshotAttributesResult");
var de_DescribeEngineDefaultClusterParametersResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_ED] != null) {
    contents[_ED] = de_EngineDefaults(output[_ED], context);
  }
  return contents;
}, "de_DescribeEngineDefaultClusterParametersResult");
var de_DescribeEngineDefaultParametersResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_ED] != null) {
    contents[_ED] = de_EngineDefaults(output[_ED], context);
  }
  return contents;
}, "de_DescribeEngineDefaultParametersResult");
var de_DescribeIntegrationsResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.Integrations === "") {
    contents[_In] = [];
  } else if (output[_In] != null && output[_In][_Int] != null) {
    contents[_In] = de_IntegrationList((0, import_smithy_client.getArrayIfSingleItem)(output[_In][_Int]), context);
  }
  return contents;
}, "de_DescribeIntegrationsResponse");
var de_DescribeValidDBInstanceModificationsResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_VDBIMM] != null) {
    contents[_VDBIMM] = de_ValidDBInstanceModificationsMessage(output[_VDBIMM], context);
  }
  return contents;
}, "de_DescribeValidDBInstanceModificationsResult");
var de_DisableHttpEndpointResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RAe] != null) {
    contents[_RAe] = (0, import_smithy_client.expectString)(output[_RAe]);
  }
  if (output[_HEE] != null) {
    contents[_HEE] = (0, import_smithy_client.parseBoolean)(output[_HEE]);
  }
  return contents;
}, "de_DisableHttpEndpointResponse");
var de_DocLink = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Te] != null) {
    contents[_Te] = (0, import_smithy_client.expectString)(output[_Te]);
  }
  if (output[_Ur] != null) {
    contents[_Ur] = (0, import_smithy_client.expectString)(output[_Ur]);
  }
  return contents;
}, "de_DocLink");
var de_DocLinkList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DocLink(entry, context);
  });
}, "de_DocLinkList");
var de_DomainMembership = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Do] != null) {
    contents[_Do] = (0, import_smithy_client.expectString)(output[_Do]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_FQDN] != null) {
    contents[_FQDN] = (0, import_smithy_client.expectString)(output[_FQDN]);
  }
  if (output[_IAMRN] != null) {
    contents[_IAMRN] = (0, import_smithy_client.expectString)(output[_IAMRN]);
  }
  if (output[_OU] != null) {
    contents[_OU] = (0, import_smithy_client.expectString)(output[_OU]);
  }
  if (output[_ASA] != null) {
    contents[_ASA] = (0, import_smithy_client.expectString)(output[_ASA]);
  }
  if (output.DnsIps === "") {
    contents[_DIn] = [];
  } else if (output[_DIn] != null && output[_DIn][_me] != null) {
    contents[_DIn] = de_StringList((0, import_smithy_client.getArrayIfSingleItem)(output[_DIn][_me]), context);
  }
  return contents;
}, "de_DomainMembership");
var de_DomainMembershipList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DomainMembership(entry, context);
  });
}, "de_DomainMembershipList");
var de_DomainNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_DomainNotFoundFault");
var de_DoubleRange = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Fr] != null) {
    contents[_Fr] = (0, import_smithy_client.strictParseFloat)(output[_Fr]);
  }
  if (output[_To] != null) {
    contents[_To] = (0, import_smithy_client.strictParseFloat)(output[_To]);
  }
  return contents;
}, "de_DoubleRange");
var de_DoubleRangeList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DoubleRange(entry, context);
  });
}, "de_DoubleRangeList");
var de_DownloadDBLogFilePortionDetails = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_LFD] != null) {
    contents[_LFD] = (0, import_smithy_client.expectString)(output[_LFD]);
  }
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output[_ADP] != null) {
    contents[_ADP] = (0, import_smithy_client.parseBoolean)(output[_ADP]);
  }
  return contents;
}, "de_DownloadDBLogFilePortionDetails");
var de_Ec2ImagePropertiesNotSupportedFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_Ec2ImagePropertiesNotSupportedFault");
var de_EC2SecurityGroup = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_ECSGN] != null) {
    contents[_ECSGN] = (0, import_smithy_client.expectString)(output[_ECSGN]);
  }
  if (output[_ECSGI] != null) {
    contents[_ECSGI] = (0, import_smithy_client.expectString)(output[_ECSGI]);
  }
  if (output[_ECSGOI] != null) {
    contents[_ECSGOI] = (0, import_smithy_client.expectString)(output[_ECSGOI]);
  }
  return contents;
}, "de_EC2SecurityGroup");
var de_EC2SecurityGroupList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_EC2SecurityGroup(entry, context);
  });
}, "de_EC2SecurityGroupList");
var de_EnableHttpEndpointResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RAe] != null) {
    contents[_RAe] = (0, import_smithy_client.expectString)(output[_RAe]);
  }
  if (output[_HEE] != null) {
    contents[_HEE] = (0, import_smithy_client.parseBoolean)(output[_HEE]);
  }
  return contents;
}, "de_EnableHttpEndpointResponse");
var de_EncryptionContextMap = /* @__PURE__ */ __name((output, context) => {
  return output.reduce((acc, pair) => {
    if (pair["value"] === null) {
      return acc;
    }
    acc[pair["key"]] = (0, import_smithy_client.expectString)(pair["value"]);
    return acc;
  }, {});
}, "de_EncryptionContextMap");
var de_Endpoint = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ad] != null) {
    contents[_Ad] = (0, import_smithy_client.expectString)(output[_Ad]);
  }
  if (output[_P] != null) {
    contents[_P] = (0, import_smithy_client.strictParseInt32)(output[_P]);
  }
  if (output[_HZI] != null) {
    contents[_HZI] = (0, import_smithy_client.expectString)(output[_HZI]);
  }
  return contents;
}, "de_Endpoint");
var de_EngineDefaults = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBPGF] != null) {
    contents[_DBPGF] = (0, import_smithy_client.expectString)(output[_DBPGF]);
  }
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.Parameters === "") {
    contents[_Pa] = [];
  } else if (output[_Pa] != null && output[_Pa][_Par] != null) {
    contents[_Pa] = de_ParametersList((0, import_smithy_client.getArrayIfSingleItem)(output[_Pa][_Par]), context);
  }
  return contents;
}, "de_EngineDefaults");
var de_EngineModeList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_EngineModeList");
var de_Event = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SI] != null) {
    contents[_SI] = (0, import_smithy_client.expectString)(output[_SI]);
  }
  if (output[_STo] != null) {
    contents[_STo] = (0, import_smithy_client.expectString)(output[_STo]);
  }
  if (output[_Me] != null) {
    contents[_Me] = (0, import_smithy_client.expectString)(output[_Me]);
  }
  if (output.EventCategories === "") {
    contents[_EC] = [];
  } else if (output[_EC] != null && output[_EC][_ECv] != null) {
    contents[_EC] = de_EventCategoriesList((0, import_smithy_client.getArrayIfSingleItem)(output[_EC][_ECv]), context);
  }
  if (output[_Da] != null) {
    contents[_Da] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_Da]));
  }
  if (output[_SA] != null) {
    contents[_SA] = (0, import_smithy_client.expectString)(output[_SA]);
  }
  return contents;
}, "de_Event");
var de_EventCategoriesList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_EventCategoriesList");
var de_EventCategoriesMap = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_STo] != null) {
    contents[_STo] = (0, import_smithy_client.expectString)(output[_STo]);
  }
  if (output.EventCategories === "") {
    contents[_EC] = [];
  } else if (output[_EC] != null && output[_EC][_ECv] != null) {
    contents[_EC] = de_EventCategoriesList((0, import_smithy_client.getArrayIfSingleItem)(output[_EC][_ECv]), context);
  }
  return contents;
}, "de_EventCategoriesMap");
var de_EventCategoriesMapList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_EventCategoriesMap(entry, context);
  });
}, "de_EventCategoriesMapList");
var de_EventCategoriesMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.EventCategoriesMapList === "") {
    contents[_ECML] = [];
  } else if (output[_ECML] != null && output[_ECML][_ECM] != null) {
    contents[_ECML] = de_EventCategoriesMapList((0, import_smithy_client.getArrayIfSingleItem)(output[_ECML][_ECM]), context);
  }
  return contents;
}, "de_EventCategoriesMessage");
var de_EventList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Event(entry, context);
  });
}, "de_EventList");
var de_EventsMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.Events === "") {
    contents[_Ev] = [];
  } else if (output[_Ev] != null && output[_Ev][_Eve] != null) {
    contents[_Ev] = de_EventList((0, import_smithy_client.getArrayIfSingleItem)(output[_Ev][_Eve]), context);
  }
  return contents;
}, "de_EventsMessage");
var de_EventSubscription = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_CAIu] != null) {
    contents[_CAIu] = (0, import_smithy_client.expectString)(output[_CAIu]);
  }
  if (output[_CSI] != null) {
    contents[_CSI] = (0, import_smithy_client.expectString)(output[_CSI]);
  }
  if (output[_STA] != null) {
    contents[_STA] = (0, import_smithy_client.expectString)(output[_STA]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_SCTu] != null) {
    contents[_SCTu] = (0, import_smithy_client.expectString)(output[_SCTu]);
  }
  if (output[_STo] != null) {
    contents[_STo] = (0, import_smithy_client.expectString)(output[_STo]);
  }
  if (output.SourceIdsList === "") {
    contents[_SIL] = [];
  } else if (output[_SIL] != null && output[_SIL][_SIou] != null) {
    contents[_SIL] = de_SourceIdsList((0, import_smithy_client.getArrayIfSingleItem)(output[_SIL][_SIou]), context);
  }
  if (output.EventCategoriesList === "") {
    contents[_ECL] = [];
  } else if (output[_ECL] != null && output[_ECL][_ECv] != null) {
    contents[_ECL] = de_EventCategoriesList((0, import_smithy_client.getArrayIfSingleItem)(output[_ECL][_ECv]), context);
  }
  if (output[_En] != null) {
    contents[_En] = (0, import_smithy_client.parseBoolean)(output[_En]);
  }
  if (output[_ESA] != null) {
    contents[_ESA] = (0, import_smithy_client.expectString)(output[_ESA]);
  }
  return contents;
}, "de_EventSubscription");
var de_EventSubscriptionQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_EventSubscriptionQuotaExceededFault");
var de_EventSubscriptionsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_EventSubscription(entry, context);
  });
}, "de_EventSubscriptionsList");
var de_EventSubscriptionsMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.EventSubscriptionsList === "") {
    contents[_ESL] = [];
  } else if (output[_ESL] != null && output[_ESL][_ES] != null) {
    contents[_ESL] = de_EventSubscriptionsList((0, import_smithy_client.getArrayIfSingleItem)(output[_ESL][_ES]), context);
  }
  return contents;
}, "de_EventSubscriptionsMessage");
var de_ExportTask = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_ETI] != null) {
    contents[_ETI] = (0, import_smithy_client.expectString)(output[_ETI]);
  }
  if (output[_SA] != null) {
    contents[_SA] = (0, import_smithy_client.expectString)(output[_SA]);
  }
  if (output.ExportOnly === "") {
    contents[_EO] = [];
  } else if (output[_EO] != null && output[_EO][_me] != null) {
    contents[_EO] = de_StringList((0, import_smithy_client.getArrayIfSingleItem)(output[_EO][_me]), context);
  }
  if (output[_STna] != null) {
    contents[_STna] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_STna]));
  }
  if (output[_TSTas] != null) {
    contents[_TSTas] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_TSTas]));
  }
  if (output[_TET] != null) {
    contents[_TET] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_TET]));
  }
  if (output[_SBu] != null) {
    contents[_SBu] = (0, import_smithy_client.expectString)(output[_SBu]);
  }
  if (output[_SP] != null) {
    contents[_SP] = (0, import_smithy_client.expectString)(output[_SP]);
  }
  if (output[_IRA] != null) {
    contents[_IRA] = (0, import_smithy_client.expectString)(output[_IRA]);
  }
  if (output[_KKI] != null) {
    contents[_KKI] = (0, import_smithy_client.expectString)(output[_KKI]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_PP] != null) {
    contents[_PP] = (0, import_smithy_client.strictParseInt32)(output[_PP]);
  }
  if (output[_TEDIGB] != null) {
    contents[_TEDIGB] = (0, import_smithy_client.strictParseInt32)(output[_TEDIGB]);
  }
  if (output[_FCa] != null) {
    contents[_FCa] = (0, import_smithy_client.expectString)(output[_FCa]);
  }
  if (output[_WM] != null) {
    contents[_WM] = (0, import_smithy_client.expectString)(output[_WM]);
  }
  if (output[_STo] != null) {
    contents[_STo] = (0, import_smithy_client.expectString)(output[_STo]);
  }
  return contents;
}, "de_ExportTask");
var de_ExportTaskAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_ExportTaskAlreadyExistsFault");
var de_ExportTaskNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_ExportTaskNotFoundFault");
var de_ExportTasksList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ExportTask(entry, context);
  });
}, "de_ExportTasksList");
var de_ExportTasksMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.ExportTasks === "") {
    contents[_ETx] = [];
  } else if (output[_ETx] != null && output[_ETx][_ETxp] != null) {
    contents[_ETx] = de_ExportTasksList((0, import_smithy_client.getArrayIfSingleItem)(output[_ETx][_ETxp]), context);
  }
  return contents;
}, "de_ExportTasksMessage");
var de_FailoverDBClusterResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBC] != null) {
    contents[_DBC] = de_DBCluster(output[_DBC], context);
  }
  return contents;
}, "de_FailoverDBClusterResult");
var de_FailoverGlobalClusterResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_GC] != null) {
    contents[_GC] = de_GlobalCluster(output[_GC], context);
  }
  return contents;
}, "de_FailoverGlobalClusterResult");
var de_FailoverState = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_FDCA] != null) {
    contents[_FDCA] = (0, import_smithy_client.expectString)(output[_FDCA]);
  }
  if (output[_TDCA] != null) {
    contents[_TDCA] = (0, import_smithy_client.expectString)(output[_TDCA]);
  }
  if (output[_IDLA] != null) {
    contents[_IDLA] = (0, import_smithy_client.parseBoolean)(output[_IDLA]);
  }
  return contents;
}, "de_FailoverState");
var de_FeatureNameList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_FeatureNameList");
var de_GlobalCluster = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_GCI] != null) {
    contents[_GCI] = (0, import_smithy_client.expectString)(output[_GCI]);
  }
  if (output[_GCRI] != null) {
    contents[_GCRI] = (0, import_smithy_client.expectString)(output[_GCRI]);
  }
  if (output[_GCA] != null) {
    contents[_GCA] = (0, import_smithy_client.expectString)(output[_GCA]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.expectString)(output[_E]);
  }
  if (output[_EV] != null) {
    contents[_EV] = (0, import_smithy_client.expectString)(output[_EV]);
  }
  if (output[_ELS] != null) {
    contents[_ELS] = (0, import_smithy_client.expectString)(output[_ELS]);
  }
  if (output[_DN] != null) {
    contents[_DN] = (0, import_smithy_client.expectString)(output[_DN]);
  }
  if (output[_SE] != null) {
    contents[_SE] = (0, import_smithy_client.parseBoolean)(output[_SE]);
  }
  if (output[_DP] != null) {
    contents[_DP] = (0, import_smithy_client.parseBoolean)(output[_DP]);
  }
  if (output.GlobalClusterMembers === "") {
    contents[_GCM] = [];
  } else if (output[_GCM] != null && output[_GCM][_GCMl] != null) {
    contents[_GCM] = de_GlobalClusterMemberList((0, import_smithy_client.getArrayIfSingleItem)(output[_GCM][_GCMl]), context);
  }
  if (output[_End] != null) {
    contents[_End] = (0, import_smithy_client.expectString)(output[_End]);
  }
  if (output[_FSa] != null) {
    contents[_FSa] = de_FailoverState(output[_FSa], context);
  }
  if (output.TagList === "") {
    contents[_TL] = [];
  } else if (output[_TL] != null && output[_TL][_Tag] != null) {
    contents[_TL] = de_TagList((0, import_smithy_client.getArrayIfSingleItem)(output[_TL][_Tag]), context);
  }
  return contents;
}, "de_GlobalCluster");
var de_GlobalClusterAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_GlobalClusterAlreadyExistsFault");
var de_GlobalClusterList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_GlobalCluster(entry, context);
  });
}, "de_GlobalClusterList");
var de_GlobalClusterMember = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBCA] != null) {
    contents[_DBCA] = (0, import_smithy_client.expectString)(output[_DBCA]);
  }
  if (output.Readers === "") {
    contents[_Read] = [];
  } else if (output[_Read] != null && output[_Read][_me] != null) {
    contents[_Read] = de_ReadersArnList((0, import_smithy_client.getArrayIfSingleItem)(output[_Read][_me]), context);
  }
  if (output[_IW] != null) {
    contents[_IW] = (0, import_smithy_client.parseBoolean)(output[_IW]);
  }
  if (output[_GWFS] != null) {
    contents[_GWFS] = (0, import_smithy_client.expectString)(output[_GWFS]);
  }
  if (output[_SS] != null) {
    contents[_SS] = (0, import_smithy_client.expectString)(output[_SS]);
  }
  return contents;
}, "de_GlobalClusterMember");
var de_GlobalClusterMemberList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_GlobalClusterMember(entry, context);
  });
}, "de_GlobalClusterMemberList");
var de_GlobalClusterNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_GlobalClusterNotFoundFault");
var de_GlobalClusterQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_GlobalClusterQuotaExceededFault");
var de_GlobalClustersMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.GlobalClusters === "") {
    contents[_GCl] = [];
  } else if (output[_GCl] != null && output[_GCl][_GCMl] != null) {
    contents[_GCl] = de_GlobalClusterList((0, import_smithy_client.getArrayIfSingleItem)(output[_GCl][_GCMl]), context);
  }
  return contents;
}, "de_GlobalClustersMessage");
var de_IamRoleMissingPermissionsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_IamRoleMissingPermissionsFault");
var de_IamRoleNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_IamRoleNotFoundFault");
var de_InstanceQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InstanceQuotaExceededFault");
var de_InsufficientAvailableIPsInSubnetFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InsufficientAvailableIPsInSubnetFault");
var de_InsufficientDBClusterCapacityFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InsufficientDBClusterCapacityFault");
var de_InsufficientDBInstanceCapacityFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InsufficientDBInstanceCapacityFault");
var de_InsufficientStorageClusterCapacityFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InsufficientStorageClusterCapacityFault");
var de_Integration = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SA] != null) {
    contents[_SA] = (0, import_smithy_client.expectString)(output[_SA]);
  }
  if (output[_TA] != null) {
    contents[_TA] = (0, import_smithy_client.expectString)(output[_TA]);
  }
  if (output[_IN] != null) {
    contents[_IN] = (0, import_smithy_client.expectString)(output[_IN]);
  }
  if (output[_IAn] != null) {
    contents[_IAn] = (0, import_smithy_client.expectString)(output[_IAn]);
  }
  if (output[_KMSKI] != null) {
    contents[_KMSKI] = (0, import_smithy_client.expectString)(output[_KMSKI]);
  }
  if (output.AdditionalEncryptionContext === "") {
    contents[_AEC] = {};
  } else if (output[_AEC] != null && output[_AEC][_e] != null) {
    contents[_AEC] = de_EncryptionContextMap((0, import_smithy_client.getArrayIfSingleItem)(output[_AEC][_e]), context);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output.Tags === "") {
    contents[_T] = [];
  } else if (output[_T] != null && output[_T][_Tag] != null) {
    contents[_T] = de_TagList((0, import_smithy_client.getArrayIfSingleItem)(output[_T][_Tag]), context);
  }
  if (output[_CTr] != null) {
    contents[_CTr] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTr]));
  }
  if (output.Errors === "") {
    contents[_Er] = [];
  } else if (output[_Er] != null && output[_Er][_IE] != null) {
    contents[_Er] = de_IntegrationErrorList((0, import_smithy_client.getArrayIfSingleItem)(output[_Er][_IE]), context);
  }
  if (output[_DFa] != null) {
    contents[_DFa] = (0, import_smithy_client.expectString)(output[_DFa]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  return contents;
}, "de_Integration");
var de_IntegrationAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_IntegrationAlreadyExistsFault");
var de_IntegrationConflictOperationFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_IntegrationConflictOperationFault");
var de_IntegrationError = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_ECr] != null) {
    contents[_ECr] = (0, import_smithy_client.expectString)(output[_ECr]);
  }
  if (output[_EMr] != null) {
    contents[_EMr] = (0, import_smithy_client.expectString)(output[_EMr]);
  }
  return contents;
}, "de_IntegrationError");
var de_IntegrationErrorList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_IntegrationError(entry, context);
  });
}, "de_IntegrationErrorList");
var de_IntegrationList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Integration(entry, context);
  });
}, "de_IntegrationList");
var de_IntegrationNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_IntegrationNotFoundFault");
var de_IntegrationQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_IntegrationQuotaExceededFault");
var de_InvalidBlueGreenDeploymentStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidBlueGreenDeploymentStateFault");
var de_InvalidCustomDBEngineVersionStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidCustomDBEngineVersionStateFault");
var de_InvalidDBClusterAutomatedBackupStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidDBClusterAutomatedBackupStateFault");
var de_InvalidDBClusterCapacityFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidDBClusterCapacityFault");
var de_InvalidDBClusterEndpointStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidDBClusterEndpointStateFault");
var de_InvalidDBClusterSnapshotStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidDBClusterSnapshotStateFault");
var de_InvalidDBClusterStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidDBClusterStateFault");
var de_InvalidDBInstanceAutomatedBackupStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidDBInstanceAutomatedBackupStateFault");
var de_InvalidDBInstanceStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidDBInstanceStateFault");
var de_InvalidDBParameterGroupStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidDBParameterGroupStateFault");
var de_InvalidDBProxyEndpointStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidDBProxyEndpointStateFault");
var de_InvalidDBProxyStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidDBProxyStateFault");
var de_InvalidDBSecurityGroupStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidDBSecurityGroupStateFault");
var de_InvalidDBShardGroupStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidDBShardGroupStateFault");
var de_InvalidDBSnapshotStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidDBSnapshotStateFault");
var de_InvalidDBSubnetGroupFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidDBSubnetGroupFault");
var de_InvalidDBSubnetGroupStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidDBSubnetGroupStateFault");
var de_InvalidDBSubnetStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidDBSubnetStateFault");
var de_InvalidEventSubscriptionStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidEventSubscriptionStateFault");
var de_InvalidExportOnlyFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidExportOnlyFault");
var de_InvalidExportSourceStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidExportSourceStateFault");
var de_InvalidExportTaskStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidExportTaskStateFault");
var de_InvalidGlobalClusterStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidGlobalClusterStateFault");
var de_InvalidIntegrationStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidIntegrationStateFault");
var de_InvalidOptionGroupStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidOptionGroupStateFault");
var de_InvalidResourceStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidResourceStateFault");
var de_InvalidRestoreFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidRestoreFault");
var de_InvalidS3BucketFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidS3BucketFault");
var de_InvalidSubnet = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidSubnet");
var de_InvalidVPCNetworkStateFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_InvalidVPCNetworkStateFault");
var de_IPRange = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_CIDRIP] != null) {
    contents[_CIDRIP] = (0, import_smithy_client.expectString)(output[_CIDRIP]);
  }
  return contents;
}, "de_IPRange");
var de_IPRangeList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_IPRange(entry, context);
  });
}, "de_IPRangeList");
var de_IssueDetails = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_PID] != null) {
    contents[_PID] = de_PerformanceIssueDetails(output[_PID], context);
  }
  return contents;
}, "de_IssueDetails");
var de_KMSKeyNotAccessibleFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_KMSKeyNotAccessibleFault");
var de_LimitlessDatabase = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_MRACU] != null) {
    contents[_MRACU] = (0, import_smithy_client.strictParseFloat)(output[_MRACU]);
  }
  return contents;
}, "de_LimitlessDatabase");
var de_LogTypeList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_LogTypeList");
var de_MasterUserSecret = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SAe] != null) {
    contents[_SAe] = (0, import_smithy_client.expectString)(output[_SAe]);
  }
  if (output[_SSe] != null) {
    contents[_SSe] = (0, import_smithy_client.expectString)(output[_SSe]);
  }
  if (output[_KKI] != null) {
    contents[_KKI] = (0, import_smithy_client.expectString)(output[_KKI]);
  }
  return contents;
}, "de_MasterUserSecret");
var de_MaxDBShardGroupLimitReached = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_MaxDBShardGroupLimitReached");
var de_Metric = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output.References === "") {
    contents[_Ref] = [];
  } else if (output[_Ref] != null && output[_Ref][_me] != null) {
    contents[_Ref] = de_MetricReferenceList((0, import_smithy_client.getArrayIfSingleItem)(output[_Ref][_me]), context);
  }
  if (output[_SDta] != null) {
    contents[_SDta] = (0, import_smithy_client.expectString)(output[_SDta]);
  }
  if (output[_MQ] != null) {
    contents[_MQ] = de_MetricQuery(output[_MQ], context);
  }
  return contents;
}, "de_Metric");
var de_MetricList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Metric(entry, context);
  });
}, "de_MetricList");
var de_MetricQuery = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_PIMQ] != null) {
    contents[_PIMQ] = de_PerformanceInsightsMetricQuery(output[_PIMQ], context);
  }
  return contents;
}, "de_MetricQuery");
var de_MetricReference = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_RD] != null) {
    contents[_RD] = de_ReferenceDetails(output[_RD], context);
  }
  return contents;
}, "de_MetricReference");
var de_MetricReferenceList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_MetricReference(entry, context);
  });
}, "de_MetricReferenceList");
var de_MinimumEngineVersionPerAllowedValue = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_AVl] != null) {
    contents[_AVl] = (0, import_smithy_client.expectString)(output[_AVl]);
  }
  if (output[_MEVi] != null) {
    contents[_MEVi] = (0, import_smithy_client.expectString)(output[_MEVi]);
  }
  return contents;
}, "de_MinimumEngineVersionPerAllowedValue");
var de_MinimumEngineVersionPerAllowedValueList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_MinimumEngineVersionPerAllowedValue(entry, context);
  });
}, "de_MinimumEngineVersionPerAllowedValueList");
var de_ModifyActivityStreamResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_KKI] != null) {
    contents[_KKI] = (0, import_smithy_client.expectString)(output[_KKI]);
  }
  if (output[_KSN] != null) {
    contents[_KSN] = (0, import_smithy_client.expectString)(output[_KSN]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_Mo] != null) {
    contents[_Mo] = (0, import_smithy_client.expectString)(output[_Mo]);
  }
  if (output[_ENAFI] != null) {
    contents[_ENAFI] = (0, import_smithy_client.parseBoolean)(output[_ENAFI]);
  }
  if (output[_PS] != null) {
    contents[_PS] = (0, import_smithy_client.expectString)(output[_PS]);
  }
  return contents;
}, "de_ModifyActivityStreamResponse");
var de_ModifyCertificatesResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Cer] != null) {
    contents[_Cer] = de_Certificate(output[_Cer], context);
  }
  return contents;
}, "de_ModifyCertificatesResult");
var de_ModifyDBClusterResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBC] != null) {
    contents[_DBC] = de_DBCluster(output[_DBC], context);
  }
  return contents;
}, "de_ModifyDBClusterResult");
var de_ModifyDBClusterSnapshotAttributeResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBCSAR] != null) {
    contents[_DBCSAR] = de_DBClusterSnapshotAttributesResult(output[_DBCSAR], context);
  }
  return contents;
}, "de_ModifyDBClusterSnapshotAttributeResult");
var de_ModifyDBInstanceResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBI] != null) {
    contents[_DBI] = de_DBInstance(output[_DBI], context);
  }
  return contents;
}, "de_ModifyDBInstanceResult");
var de_ModifyDBProxyEndpointResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBPE] != null) {
    contents[_DBPE] = de_DBProxyEndpoint(output[_DBPE], context);
  }
  return contents;
}, "de_ModifyDBProxyEndpointResponse");
var de_ModifyDBProxyResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBP] != null) {
    contents[_DBP] = de_DBProxy(output[_DBP], context);
  }
  return contents;
}, "de_ModifyDBProxyResponse");
var de_ModifyDBProxyTargetGroupResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBPTG] != null) {
    contents[_DBPTG] = de_DBProxyTargetGroup(output[_DBPTG], context);
  }
  return contents;
}, "de_ModifyDBProxyTargetGroupResponse");
var de_ModifyDBSnapshotAttributeResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBSAR] != null) {
    contents[_DBSAR] = de_DBSnapshotAttributesResult(output[_DBSAR], context);
  }
  return contents;
}, "de_ModifyDBSnapshotAttributeResult");
var de_ModifyDBSnapshotResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBS] != null) {
    contents[_DBS] = de_DBSnapshot(output[_DBS], context);
  }
  return contents;
}, "de_ModifyDBSnapshotResult");
var de_ModifyDBSubnetGroupResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBSGu] != null) {
    contents[_DBSGu] = de_DBSubnetGroup(output[_DBSGu], context);
  }
  return contents;
}, "de_ModifyDBSubnetGroupResult");
var de_ModifyEventSubscriptionResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_ES] != null) {
    contents[_ES] = de_EventSubscription(output[_ES], context);
  }
  return contents;
}, "de_ModifyEventSubscriptionResult");
var de_ModifyGlobalClusterResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_GC] != null) {
    contents[_GC] = de_GlobalCluster(output[_GC], context);
  }
  return contents;
}, "de_ModifyGlobalClusterResult");
var de_ModifyOptionGroupResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_OG] != null) {
    contents[_OG] = de_OptionGroup(output[_OG], context);
  }
  return contents;
}, "de_ModifyOptionGroupResult");
var de_ModifyTenantDatabaseResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_TD] != null) {
    contents[_TD] = de_TenantDatabase(output[_TD], context);
  }
  return contents;
}, "de_ModifyTenantDatabaseResult");
var de_NetworkTypeNotSupported = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_NetworkTypeNotSupported");
var de_Option = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_ON] != null) {
    contents[_ON] = (0, import_smithy_client.expectString)(output[_ON]);
  }
  if (output[_OD] != null) {
    contents[_OD] = (0, import_smithy_client.expectString)(output[_OD]);
  }
  if (output[_Pe] != null) {
    contents[_Pe] = (0, import_smithy_client.parseBoolean)(output[_Pe]);
  }
  if (output[_Per] != null) {
    contents[_Per] = (0, import_smithy_client.parseBoolean)(output[_Per]);
  }
  if (output[_P] != null) {
    contents[_P] = (0, import_smithy_client.strictParseInt32)(output[_P]);
  }
  if (output[_OV] != null) {
    contents[_OV] = (0, import_smithy_client.expectString)(output[_OV]);
  }
  if (output.OptionSettings === "") {
    contents[_OS] = [];
  } else if (output[_OS] != null && output[_OS][_OSp] != null) {
    contents[_OS] = de_OptionSettingConfigurationList((0, import_smithy_client.getArrayIfSingleItem)(output[_OS][_OSp]), context);
  }
  if (output.DBSecurityGroupMemberships === "") {
    contents[_DBSGM] = [];
  } else if (output[_DBSGM] != null && output[_DBSGM][_DBSGe] != null) {
    contents[_DBSGM] = de_DBSecurityGroupMembershipList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBSGM][_DBSGe]), context);
  }
  if (output.VpcSecurityGroupMemberships === "") {
    contents[_VSGM] = [];
  } else if (output[_VSGM] != null && output[_VSGM][_VSGMp] != null) {
    contents[_VSGM] = de_VpcSecurityGroupMembershipList((0, import_smithy_client.getArrayIfSingleItem)(output[_VSGM][_VSGMp]), context);
  }
  return contents;
}, "de_Option");
var de_OptionGroup = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_OGN] != null) {
    contents[_OGN] = (0, import_smithy_client.expectString)(output[_OGN]);
  }
  if (output[_OGD] != null) {
    contents[_OGD] = (0, import_smithy_client.expectString)(output[_OGD]);
  }
  if (output[_EN] != null) {
    contents[_EN] = (0, import_smithy_client.expectString)(output[_EN]);
  }
  if (output[_MEV] != null) {
    contents[_MEV] = (0, import_smithy_client.expectString)(output[_MEV]);
  }
  if (output.Options === "") {
    contents[_O] = [];
  } else if (output[_O] != null && output[_O][_Op] != null) {
    contents[_O] = de_OptionsList((0, import_smithy_client.getArrayIfSingleItem)(output[_O][_Op]), context);
  }
  if (output[_AVANVIM] != null) {
    contents[_AVANVIM] = (0, import_smithy_client.parseBoolean)(output[_AVANVIM]);
  }
  if (output[_VI] != null) {
    contents[_VI] = (0, import_smithy_client.expectString)(output[_VI]);
  }
  if (output[_OGA] != null) {
    contents[_OGA] = (0, import_smithy_client.expectString)(output[_OGA]);
  }
  if (output[_SOG] != null) {
    contents[_SOG] = (0, import_smithy_client.expectString)(output[_SOG]);
  }
  if (output[_SAI] != null) {
    contents[_SAI] = (0, import_smithy_client.expectString)(output[_SAI]);
  }
  if (output[_CTo] != null) {
    contents[_CTo] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CTo]));
  }
  return contents;
}, "de_OptionGroup");
var de_OptionGroupAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_OptionGroupAlreadyExistsFault");
var de_OptionGroupMembership = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_OGN] != null) {
    contents[_OGN] = (0, import_smithy_client.expectString)(output[_OGN]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  return contents;
}, "de_OptionGroupMembership");
var de_OptionGroupMembershipList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_OptionGroupMembership(entry, context);
  });
}, "de_OptionGroupMembershipList");
var de_OptionGroupNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_OptionGroupNotFoundFault");
var de_OptionGroupOption = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output[_EN] != null) {
    contents[_EN] = (0, import_smithy_client.expectString)(output[_EN]);
  }
  if (output[_MEV] != null) {
    contents[_MEV] = (0, import_smithy_client.expectString)(output[_MEV]);
  }
  if (output[_MRMEV] != null) {
    contents[_MRMEV] = (0, import_smithy_client.expectString)(output[_MRMEV]);
  }
  if (output[_PR] != null) {
    contents[_PR] = (0, import_smithy_client.parseBoolean)(output[_PR]);
  }
  if (output[_DPe] != null) {
    contents[_DPe] = (0, import_smithy_client.strictParseInt32)(output[_DPe]);
  }
  if (output.OptionsDependedOn === "") {
    contents[_ODO] = [];
  } else if (output[_ODO] != null && output[_ODO][_ON] != null) {
    contents[_ODO] = de_OptionsDependedOn((0, import_smithy_client.getArrayIfSingleItem)(output[_ODO][_ON]), context);
  }
  if (output.OptionsConflictsWith === "") {
    contents[_OCW] = [];
  } else if (output[_OCW] != null && output[_OCW][_OCN] != null) {
    contents[_OCW] = de_OptionsConflictsWith((0, import_smithy_client.getArrayIfSingleItem)(output[_OCW][_OCN]), context);
  }
  if (output[_Pe] != null) {
    contents[_Pe] = (0, import_smithy_client.parseBoolean)(output[_Pe]);
  }
  if (output[_Per] != null) {
    contents[_Per] = (0, import_smithy_client.parseBoolean)(output[_Per]);
  }
  if (output[_RAMEVU] != null) {
    contents[_RAMEVU] = (0, import_smithy_client.parseBoolean)(output[_RAMEVU]);
  }
  if (output[_VO] != null) {
    contents[_VO] = (0, import_smithy_client.parseBoolean)(output[_VO]);
  }
  if (output[_SOVD] != null) {
    contents[_SOVD] = (0, import_smithy_client.parseBoolean)(output[_SOVD]);
  }
  if (output.OptionGroupOptionSettings === "") {
    contents[_OGOS] = [];
  } else if (output[_OGOS] != null && output[_OGOS][_OGOSp] != null) {
    contents[_OGOS] = de_OptionGroupOptionSettingsList((0, import_smithy_client.getArrayIfSingleItem)(output[_OGOS][_OGOSp]), context);
  }
  if (output.OptionGroupOptionVersions === "") {
    contents[_OGOV] = [];
  } else if (output[_OGOV] != null && output[_OGOV][_OV] != null) {
    contents[_OGOV] = de_OptionGroupOptionVersionsList((0, import_smithy_client.getArrayIfSingleItem)(output[_OGOV][_OV]), context);
  }
  if (output[_CCA] != null) {
    contents[_CCA] = (0, import_smithy_client.parseBoolean)(output[_CCA]);
  }
  return contents;
}, "de_OptionGroupOption");
var de_OptionGroupOptionSetting = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SNe] != null) {
    contents[_SNe] = (0, import_smithy_client.expectString)(output[_SNe]);
  }
  if (output[_SDe] != null) {
    contents[_SDe] = (0, import_smithy_client.expectString)(output[_SDe]);
  }
  if (output[_DV] != null) {
    contents[_DV] = (0, import_smithy_client.expectString)(output[_DV]);
  }
  if (output[_AT] != null) {
    contents[_AT] = (0, import_smithy_client.expectString)(output[_AT]);
  }
  if (output[_AV] != null) {
    contents[_AV] = (0, import_smithy_client.expectString)(output[_AV]);
  }
  if (output[_IM] != null) {
    contents[_IM] = (0, import_smithy_client.parseBoolean)(output[_IM]);
  }
  if (output[_IR] != null) {
    contents[_IR] = (0, import_smithy_client.parseBoolean)(output[_IR]);
  }
  if (output.MinimumEngineVersionPerAllowedValue === "") {
    contents[_MEVPAV] = [];
  } else if (output[_MEVPAV] != null && output[_MEVPAV][_MEVPAV] != null) {
    contents[_MEVPAV] = de_MinimumEngineVersionPerAllowedValueList(
      (0, import_smithy_client.getArrayIfSingleItem)(output[_MEVPAV][_MEVPAV]),
      context
    );
  }
  return contents;
}, "de_OptionGroupOptionSetting");
var de_OptionGroupOptionSettingsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_OptionGroupOptionSetting(entry, context);
  });
}, "de_OptionGroupOptionSettingsList");
var de_OptionGroupOptionsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_OptionGroupOption(entry, context);
  });
}, "de_OptionGroupOptionsList");
var de_OptionGroupOptionsMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.OptionGroupOptions === "") {
    contents[_OGO] = [];
  } else if (output[_OGO] != null && output[_OGO][_OGOp] != null) {
    contents[_OGO] = de_OptionGroupOptionsList((0, import_smithy_client.getArrayIfSingleItem)(output[_OGO][_OGOp]), context);
  }
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  return contents;
}, "de_OptionGroupOptionsMessage");
var de_OptionGroupOptionVersionsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_OptionVersion(entry, context);
  });
}, "de_OptionGroupOptionVersionsList");
var de_OptionGroupQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_OptionGroupQuotaExceededFault");
var de_OptionGroups = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.OptionGroupsList === "") {
    contents[_OGL] = [];
  } else if (output[_OGL] != null && output[_OGL][_OG] != null) {
    contents[_OGL] = de_OptionGroupsList((0, import_smithy_client.getArrayIfSingleItem)(output[_OGL][_OG]), context);
  }
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  return contents;
}, "de_OptionGroups");
var de_OptionGroupsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_OptionGroup(entry, context);
  });
}, "de_OptionGroupsList");
var de_OptionsConflictsWith = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_OptionsConflictsWith");
var de_OptionsDependedOn = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_OptionsDependedOn");
var de_OptionSetting = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_Val] != null) {
    contents[_Val] = (0, import_smithy_client.expectString)(output[_Val]);
  }
  if (output[_DV] != null) {
    contents[_DV] = (0, import_smithy_client.expectString)(output[_DV]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output[_AT] != null) {
    contents[_AT] = (0, import_smithy_client.expectString)(output[_AT]);
  }
  if (output[_DTa] != null) {
    contents[_DTa] = (0, import_smithy_client.expectString)(output[_DTa]);
  }
  if (output[_AV] != null) {
    contents[_AV] = (0, import_smithy_client.expectString)(output[_AV]);
  }
  if (output[_IM] != null) {
    contents[_IM] = (0, import_smithy_client.parseBoolean)(output[_IM]);
  }
  if (output[_IC] != null) {
    contents[_IC] = (0, import_smithy_client.parseBoolean)(output[_IC]);
  }
  return contents;
}, "de_OptionSetting");
var de_OptionSettingConfigurationList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_OptionSetting(entry, context);
  });
}, "de_OptionSettingConfigurationList");
var de_OptionsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Option(entry, context);
  });
}, "de_OptionsList");
var de_OptionVersion = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_V] != null) {
    contents[_V] = (0, import_smithy_client.expectString)(output[_V]);
  }
  if (output[_ID] != null) {
    contents[_ID] = (0, import_smithy_client.parseBoolean)(output[_ID]);
  }
  return contents;
}, "de_OptionVersion");
var de_OrderableDBInstanceOption = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.expectString)(output[_E]);
  }
  if (output[_EV] != null) {
    contents[_EV] = (0, import_smithy_client.expectString)(output[_EV]);
  }
  if (output[_DBIC] != null) {
    contents[_DBIC] = (0, import_smithy_client.expectString)(output[_DBIC]);
  }
  if (output[_LM] != null) {
    contents[_LM] = (0, import_smithy_client.expectString)(output[_LM]);
  }
  if (output[_AZG] != null) {
    contents[_AZG] = (0, import_smithy_client.expectString)(output[_AZG]);
  }
  if (output.AvailabilityZones === "") {
    contents[_AZ] = [];
  } else if (output[_AZ] != null && output[_AZ][_AZv] != null) {
    contents[_AZ] = de_AvailabilityZoneList((0, import_smithy_client.getArrayIfSingleItem)(output[_AZ][_AZv]), context);
  }
  if (output[_MAZC] != null) {
    contents[_MAZC] = (0, import_smithy_client.parseBoolean)(output[_MAZC]);
  }
  if (output[_RRC] != null) {
    contents[_RRC] = (0, import_smithy_client.parseBoolean)(output[_RRC]);
  }
  if (output[_Vp] != null) {
    contents[_Vp] = (0, import_smithy_client.parseBoolean)(output[_Vp]);
  }
  if (output[_SSE] != null) {
    contents[_SSE] = (0, import_smithy_client.parseBoolean)(output[_SSE]);
  }
  if (output[_STt] != null) {
    contents[_STt] = (0, import_smithy_client.expectString)(output[_STt]);
  }
  if (output[_SIupp] != null) {
    contents[_SIupp] = (0, import_smithy_client.parseBoolean)(output[_SIupp]);
  }
  if (output[_SEMu] != null) {
    contents[_SEMu] = (0, import_smithy_client.parseBoolean)(output[_SEMu]);
  }
  if (output[_SIAMDA] != null) {
    contents[_SIAMDA] = (0, import_smithy_client.parseBoolean)(output[_SIAMDA]);
  }
  if (output[_SPI] != null) {
    contents[_SPI] = (0, import_smithy_client.parseBoolean)(output[_SPI]);
  }
  if (output[_MSS] != null) {
    contents[_MSS] = (0, import_smithy_client.strictParseInt32)(output[_MSS]);
  }
  if (output[_MSSa] != null) {
    contents[_MSSa] = (0, import_smithy_client.strictParseInt32)(output[_MSSa]);
  }
  if (output[_MIPDI] != null) {
    contents[_MIPDI] = (0, import_smithy_client.strictParseInt32)(output[_MIPDI]);
  }
  if (output[_MIPDIa] != null) {
    contents[_MIPDIa] = (0, import_smithy_client.strictParseInt32)(output[_MIPDIa]);
  }
  if (output[_MIPG] != null) {
    contents[_MIPG] = (0, import_smithy_client.strictParseFloat)(output[_MIPG]);
  }
  if (output[_MIPGa] != null) {
    contents[_MIPGa] = (0, import_smithy_client.strictParseFloat)(output[_MIPGa]);
  }
  if (output.AvailableProcessorFeatures === "") {
    contents[_APF] = [];
  } else if (output[_APF] != null && output[_APF][_APFv] != null) {
    contents[_APF] = de_AvailableProcessorFeatureList((0, import_smithy_client.getArrayIfSingleItem)(output[_APF][_APFv]), context);
  }
  if (output.SupportedEngineModes === "") {
    contents[_SEM] = [];
  } else if (output[_SEM] != null && output[_SEM][_me] != null) {
    contents[_SEM] = de_EngineModeList((0, import_smithy_client.getArrayIfSingleItem)(output[_SEM][_me]), context);
  }
  if (output[_SSA] != null) {
    contents[_SSA] = (0, import_smithy_client.parseBoolean)(output[_SSA]);
  }
  if (output[_SKA] != null) {
    contents[_SKA] = (0, import_smithy_client.parseBoolean)(output[_SKA]);
  }
  if (output[_OC] != null) {
    contents[_OC] = (0, import_smithy_client.parseBoolean)(output[_OC]);
  }
  if (output.SupportedActivityStreamModes === "") {
    contents[_SASM] = [];
  } else if (output[_SASM] != null && output[_SASM][_me] != null) {
    contents[_SASM] = de_ActivityStreamModeList((0, import_smithy_client.getArrayIfSingleItem)(output[_SASM][_me]), context);
  }
  if (output[_SGD] != null) {
    contents[_SGD] = (0, import_smithy_client.parseBoolean)(output[_SGD]);
  }
  if (output[_SCu] != null) {
    contents[_SCu] = (0, import_smithy_client.parseBoolean)(output[_SCu]);
  }
  if (output.SupportedNetworkTypes === "") {
    contents[_SNT] = [];
  } else if (output[_SNT] != null && output[_SNT][_me] != null) {
    contents[_SNT] = de_StringList((0, import_smithy_client.getArrayIfSingleItem)(output[_SNT][_me]), context);
  }
  if (output[_SST] != null) {
    contents[_SST] = (0, import_smithy_client.parseBoolean)(output[_SST]);
  }
  if (output[_MSTPDI] != null) {
    contents[_MSTPDI] = (0, import_smithy_client.strictParseInt32)(output[_MSTPDI]);
  }
  if (output[_MSTPDIa] != null) {
    contents[_MSTPDIa] = (0, import_smithy_client.strictParseInt32)(output[_MSTPDIa]);
  }
  if (output[_MSTPI] != null) {
    contents[_MSTPI] = (0, import_smithy_client.strictParseFloat)(output[_MSTPI]);
  }
  if (output[_MSTPIa] != null) {
    contents[_MSTPIa] = (0, import_smithy_client.strictParseFloat)(output[_MSTPIa]);
  }
  if (output[_SDLV] != null) {
    contents[_SDLV] = (0, import_smithy_client.parseBoolean)(output[_SDLV]);
  }
  return contents;
}, "de_OrderableDBInstanceOption");
var de_OrderableDBInstanceOptionsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_OrderableDBInstanceOption(entry, context);
  });
}, "de_OrderableDBInstanceOptionsList");
var de_OrderableDBInstanceOptionsMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.OrderableDBInstanceOptions === "") {
    contents[_ODBIO] = [];
  } else if (output[_ODBIO] != null && output[_ODBIO][_ODBIOr] != null) {
    contents[_ODBIO] = de_OrderableDBInstanceOptionsList((0, import_smithy_client.getArrayIfSingleItem)(output[_ODBIO][_ODBIOr]), context);
  }
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  return contents;
}, "de_OrderableDBInstanceOptionsMessage");
var de_Outpost = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ar] != null) {
    contents[_Ar] = (0, import_smithy_client.expectString)(output[_Ar]);
  }
  return contents;
}, "de_Outpost");
var de_Parameter = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_PN] != null) {
    contents[_PN] = (0, import_smithy_client.expectString)(output[_PN]);
  }
  if (output[_PV] != null) {
    contents[_PV] = (0, import_smithy_client.expectString)(output[_PV]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output[_S] != null) {
    contents[_S] = (0, import_smithy_client.expectString)(output[_S]);
  }
  if (output[_AT] != null) {
    contents[_AT] = (0, import_smithy_client.expectString)(output[_AT]);
  }
  if (output[_DTa] != null) {
    contents[_DTa] = (0, import_smithy_client.expectString)(output[_DTa]);
  }
  if (output[_AV] != null) {
    contents[_AV] = (0, import_smithy_client.expectString)(output[_AV]);
  }
  if (output[_IM] != null) {
    contents[_IM] = (0, import_smithy_client.parseBoolean)(output[_IM]);
  }
  if (output[_MEVi] != null) {
    contents[_MEVi] = (0, import_smithy_client.expectString)(output[_MEVi]);
  }
  if (output[_AMp] != null) {
    contents[_AMp] = (0, import_smithy_client.expectString)(output[_AMp]);
  }
  if (output.SupportedEngineModes === "") {
    contents[_SEM] = [];
  } else if (output[_SEM] != null && output[_SEM][_me] != null) {
    contents[_SEM] = de_EngineModeList((0, import_smithy_client.getArrayIfSingleItem)(output[_SEM][_me]), context);
  }
  return contents;
}, "de_Parameter");
var de_ParametersList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Parameter(entry, context);
  });
}, "de_ParametersList");
var de_PendingCloudwatchLogsExports = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.LogTypesToEnable === "") {
    contents[_LTTE] = [];
  } else if (output[_LTTE] != null && output[_LTTE][_me] != null) {
    contents[_LTTE] = de_LogTypeList((0, import_smithy_client.getArrayIfSingleItem)(output[_LTTE][_me]), context);
  }
  if (output.LogTypesToDisable === "") {
    contents[_LTTD] = [];
  } else if (output[_LTTD] != null && output[_LTTD][_me] != null) {
    contents[_LTTD] = de_LogTypeList((0, import_smithy_client.getArrayIfSingleItem)(output[_LTTD][_me]), context);
  }
  return contents;
}, "de_PendingCloudwatchLogsExports");
var de_PendingMaintenanceAction = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_A] != null) {
    contents[_A] = (0, import_smithy_client.expectString)(output[_A]);
  }
  if (output[_AAAD] != null) {
    contents[_AAAD] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_AAAD]));
  }
  if (output[_FAD] != null) {
    contents[_FAD] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_FAD]));
  }
  if (output[_OIS] != null) {
    contents[_OIS] = (0, import_smithy_client.expectString)(output[_OIS]);
  }
  if (output[_CAD] != null) {
    contents[_CAD] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_CAD]));
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  return contents;
}, "de_PendingMaintenanceAction");
var de_PendingMaintenanceActionDetails = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_PendingMaintenanceAction(entry, context);
  });
}, "de_PendingMaintenanceActionDetails");
var de_PendingMaintenanceActions = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ResourcePendingMaintenanceActions(entry, context);
  });
}, "de_PendingMaintenanceActions");
var de_PendingMaintenanceActionsMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.PendingMaintenanceActions === "") {
    contents[_PMA] = [];
  } else if (output[_PMA] != null && output[_PMA][_RPMA] != null) {
    contents[_PMA] = de_PendingMaintenanceActions((0, import_smithy_client.getArrayIfSingleItem)(output[_PMA][_RPMA]), context);
  }
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  return contents;
}, "de_PendingMaintenanceActionsMessage");
var de_PendingModifiedValues = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBIC] != null) {
    contents[_DBIC] = (0, import_smithy_client.expectString)(output[_DBIC]);
  }
  if (output[_AS] != null) {
    contents[_AS] = (0, import_smithy_client.strictParseInt32)(output[_AS]);
  }
  if (output[_MUP] != null) {
    contents[_MUP] = (0, import_smithy_client.expectString)(output[_MUP]);
  }
  if (output[_P] != null) {
    contents[_P] = (0, import_smithy_client.strictParseInt32)(output[_P]);
  }
  if (output[_BRP] != null) {
    contents[_BRP] = (0, import_smithy_client.strictParseInt32)(output[_BRP]);
  }
  if (output[_MAZ] != null) {
    contents[_MAZ] = (0, import_smithy_client.parseBoolean)(output[_MAZ]);
  }
  if (output[_EV] != null) {
    contents[_EV] = (0, import_smithy_client.expectString)(output[_EV]);
  }
  if (output[_LM] != null) {
    contents[_LM] = (0, import_smithy_client.expectString)(output[_LM]);
  }
  if (output[_I] != null) {
    contents[_I] = (0, import_smithy_client.strictParseInt32)(output[_I]);
  }
  if (output[_DBII] != null) {
    contents[_DBII] = (0, import_smithy_client.expectString)(output[_DBII]);
  }
  if (output[_STt] != null) {
    contents[_STt] = (0, import_smithy_client.expectString)(output[_STt]);
  }
  if (output[_CACI] != null) {
    contents[_CACI] = (0, import_smithy_client.expectString)(output[_CACI]);
  }
  if (output[_DBSGNu] != null) {
    contents[_DBSGNu] = (0, import_smithy_client.expectString)(output[_DBSGNu]);
  }
  if (output[_PCLE] != null) {
    contents[_PCLE] = de_PendingCloudwatchLogsExports(output[_PCLE], context);
  }
  if (output.ProcessorFeatures === "") {
    contents[_PF] = [];
  } else if (output[_PF] != null && output[_PF][_PFr] != null) {
    contents[_PF] = de_ProcessorFeatureList((0, import_smithy_client.getArrayIfSingleItem)(output[_PF][_PFr]), context);
  }
  if (output[_IAMDAE] != null) {
    contents[_IAMDAE] = (0, import_smithy_client.parseBoolean)(output[_IAMDAE]);
  }
  if (output[_AM] != null) {
    contents[_AM] = (0, import_smithy_client.expectString)(output[_AM]);
  }
  if (output[_RFAMT] != null) {
    contents[_RFAMT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_RFAMT]));
  }
  if (output[_STto] != null) {
    contents[_STto] = (0, import_smithy_client.strictParseInt32)(output[_STto]);
  }
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.expectString)(output[_E]);
  }
  if (output[_DLV] != null) {
    contents[_DLV] = (0, import_smithy_client.parseBoolean)(output[_DLV]);
  }
  if (output[_MT] != null) {
    contents[_MT] = (0, import_smithy_client.parseBoolean)(output[_MT]);
  }
  return contents;
}, "de_PendingModifiedValues");
var de_PerformanceInsightsMetricDimensionGroup = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Dimensions === "") {
    contents[_Di] = [];
  } else if (output[_Di] != null && output[_Di][_me] != null) {
    contents[_Di] = de_StringList((0, import_smithy_client.getArrayIfSingleItem)(output[_Di][_me]), context);
  }
  if (output[_G] != null) {
    contents[_G] = (0, import_smithy_client.expectString)(output[_G]);
  }
  if (output[_Lim] != null) {
    contents[_Lim] = (0, import_smithy_client.strictParseInt32)(output[_Lim]);
  }
  return contents;
}, "de_PerformanceInsightsMetricDimensionGroup");
var de_PerformanceInsightsMetricQuery = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_GB] != null) {
    contents[_GB] = de_PerformanceInsightsMetricDimensionGroup(output[_GB], context);
  }
  if (output[_Met] != null) {
    contents[_Met] = (0, import_smithy_client.expectString)(output[_Met]);
  }
  return contents;
}, "de_PerformanceInsightsMetricQuery");
var de_PerformanceIssueDetails = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_STta] != null) {
    contents[_STta] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_STta]));
  }
  if (output[_ETn] != null) {
    contents[_ETn] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_ETn]));
  }
  if (output.Metrics === "") {
    contents[_Metr] = [];
  } else if (output[_Metr] != null && output[_Metr][_me] != null) {
    contents[_Metr] = de_MetricList((0, import_smithy_client.getArrayIfSingleItem)(output[_Metr][_me]), context);
  }
  if (output[_An] != null) {
    contents[_An] = (0, import_smithy_client.expectString)(output[_An]);
  }
  return contents;
}, "de_PerformanceIssueDetails");
var de_PointInTimeRestoreNotEnabledFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_PointInTimeRestoreNotEnabledFault");
var de_ProcessorFeature = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_N] != null) {
    contents[_N] = (0, import_smithy_client.expectString)(output[_N]);
  }
  if (output[_Val] != null) {
    contents[_Val] = (0, import_smithy_client.expectString)(output[_Val]);
  }
  return contents;
}, "de_ProcessorFeature");
var de_ProcessorFeatureList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ProcessorFeature(entry, context);
  });
}, "de_ProcessorFeatureList");
var de_PromoteReadReplicaDBClusterResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBC] != null) {
    contents[_DBC] = de_DBCluster(output[_DBC], context);
  }
  return contents;
}, "de_PromoteReadReplicaDBClusterResult");
var de_PromoteReadReplicaResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBI] != null) {
    contents[_DBI] = de_DBInstance(output[_DBI], context);
  }
  return contents;
}, "de_PromoteReadReplicaResult");
var de_ProvisionedIopsNotAvailableInAZFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_ProvisionedIopsNotAvailableInAZFault");
var de_PurchaseReservedDBInstancesOfferingResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RDBIe] != null) {
    contents[_RDBIe] = de_ReservedDBInstance(output[_RDBIe], context);
  }
  return contents;
}, "de_PurchaseReservedDBInstancesOfferingResult");
var de_Range = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Fr] != null) {
    contents[_Fr] = (0, import_smithy_client.strictParseInt32)(output[_Fr]);
  }
  if (output[_To] != null) {
    contents[_To] = (0, import_smithy_client.strictParseInt32)(output[_To]);
  }
  if (output[_Ste] != null) {
    contents[_Ste] = (0, import_smithy_client.strictParseInt32)(output[_Ste]);
  }
  return contents;
}, "de_Range");
var de_RangeList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Range(entry, context);
  });
}, "de_RangeList");
var de_RdsCustomClusterConfiguration = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_ISI] != null) {
    contents[_ISI] = (0, import_smithy_client.expectString)(output[_ISI]);
  }
  if (output[_TGMDI] != null) {
    contents[_TGMDI] = (0, import_smithy_client.expectString)(output[_TGMDI]);
  }
  if (output[_RM] != null) {
    contents[_RM] = (0, import_smithy_client.expectString)(output[_RM]);
  }
  return contents;
}, "de_RdsCustomClusterConfiguration");
var de_ReadersArnList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_ReadersArnList");
var de_ReadReplicaDBClusterIdentifierList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_ReadReplicaDBClusterIdentifierList");
var de_ReadReplicaDBInstanceIdentifierList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_ReadReplicaDBInstanceIdentifierList");
var de_ReadReplicaIdentifierList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_ReadReplicaIdentifierList");
var de_RebootDBClusterResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBC] != null) {
    contents[_DBC] = de_DBCluster(output[_DBC], context);
  }
  return contents;
}, "de_RebootDBClusterResult");
var de_RebootDBInstanceResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBI] != null) {
    contents[_DBI] = de_DBInstance(output[_DBI], context);
  }
  return contents;
}, "de_RebootDBInstanceResult");
var de_RecommendedAction = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_AIc] != null) {
    contents[_AIc] = (0, import_smithy_client.expectString)(output[_AIc]);
  }
  if (output[_Tit] != null) {
    contents[_Tit] = (0, import_smithy_client.expectString)(output[_Tit]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output[_Ope] != null) {
    contents[_Ope] = (0, import_smithy_client.expectString)(output[_Ope]);
  }
  if (output.Parameters === "") {
    contents[_Pa] = [];
  } else if (output[_Pa] != null && output[_Pa][_me] != null) {
    contents[_Pa] = de_RecommendedActionParameterList((0, import_smithy_client.getArrayIfSingleItem)(output[_Pa][_me]), context);
  }
  if (output.ApplyModes === "") {
    contents[_AMpp] = [];
  } else if (output[_AMpp] != null && output[_AMpp][_me] != null) {
    contents[_AMpp] = de_StringList((0, import_smithy_client.getArrayIfSingleItem)(output[_AMpp][_me]), context);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_IDs] != null) {
    contents[_IDs] = de_IssueDetails(output[_IDs], context);
  }
  if (output.ContextAttributes === "") {
    contents[_CAo] = [];
  } else if (output[_CAo] != null && output[_CAo][_me] != null) {
    contents[_CAo] = de_ContextAttributeList((0, import_smithy_client.getArrayIfSingleItem)(output[_CAo][_me]), context);
  }
  return contents;
}, "de_RecommendedAction");
var de_RecommendedActionList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_RecommendedAction(entry, context);
  });
}, "de_RecommendedActionList");
var de_RecommendedActionParameter = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_K] != null) {
    contents[_K] = (0, import_smithy_client.expectString)(output[_K]);
  }
  if (output[_Val] != null) {
    contents[_Val] = (0, import_smithy_client.expectString)(output[_Val]);
  }
  return contents;
}, "de_RecommendedActionParameter");
var de_RecommendedActionParameterList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_RecommendedActionParameter(entry, context);
  });
}, "de_RecommendedActionParameterList");
var de_RecurringCharge = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RCA] != null) {
    contents[_RCA] = (0, import_smithy_client.strictParseFloat)(output[_RCA]);
  }
  if (output[_RCF] != null) {
    contents[_RCF] = (0, import_smithy_client.expectString)(output[_RCF]);
  }
  return contents;
}, "de_RecurringCharge");
var de_RecurringChargeList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_RecurringCharge(entry, context);
  });
}, "de_RecurringChargeList");
var de_ReferenceDetails = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SRD] != null) {
    contents[_SRD] = de_ScalarReferenceDetails(output[_SRD], context);
  }
  return contents;
}, "de_ReferenceDetails");
var de_RegisterDBProxyTargetsResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.DBProxyTargets === "") {
    contents[_DBPT] = [];
  } else if (output[_DBPT] != null && output[_DBPT][_me] != null) {
    contents[_DBPT] = de_TargetList((0, import_smithy_client.getArrayIfSingleItem)(output[_DBPT][_me]), context);
  }
  return contents;
}, "de_RegisterDBProxyTargetsResponse");
var de_RemoveFromGlobalClusterResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_GC] != null) {
    contents[_GC] = de_GlobalCluster(output[_GC], context);
  }
  return contents;
}, "de_RemoveFromGlobalClusterResult");
var de_RemoveSourceIdentifierFromSubscriptionResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_ES] != null) {
    contents[_ES] = de_EventSubscription(output[_ES], context);
  }
  return contents;
}, "de_RemoveSourceIdentifierFromSubscriptionResult");
var de_ReservedDBInstance = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RDBII] != null) {
    contents[_RDBII] = (0, import_smithy_client.expectString)(output[_RDBII]);
  }
  if (output[_RDBIOI] != null) {
    contents[_RDBIOI] = (0, import_smithy_client.expectString)(output[_RDBIOI]);
  }
  if (output[_DBIC] != null) {
    contents[_DBIC] = (0, import_smithy_client.expectString)(output[_DBIC]);
  }
  if (output[_STta] != null) {
    contents[_STta] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_STta]));
  }
  if (output[_Du] != null) {
    contents[_Du] = (0, import_smithy_client.strictParseInt32)(output[_Du]);
  }
  if (output[_FP] != null) {
    contents[_FP] = (0, import_smithy_client.strictParseFloat)(output[_FP]);
  }
  if (output[_UP] != null) {
    contents[_UP] = (0, import_smithy_client.strictParseFloat)(output[_UP]);
  }
  if (output[_CCu] != null) {
    contents[_CCu] = (0, import_smithy_client.expectString)(output[_CCu]);
  }
  if (output[_DBICn] != null) {
    contents[_DBICn] = (0, import_smithy_client.strictParseInt32)(output[_DBICn]);
  }
  if (output[_PD] != null) {
    contents[_PD] = (0, import_smithy_client.expectString)(output[_PD]);
  }
  if (output[_OT] != null) {
    contents[_OT] = (0, import_smithy_client.expectString)(output[_OT]);
  }
  if (output[_MAZ] != null) {
    contents[_MAZ] = (0, import_smithy_client.parseBoolean)(output[_MAZ]);
  }
  if (output[_Sta] != null) {
    contents[_Sta] = (0, import_smithy_client.expectString)(output[_Sta]);
  }
  if (output.RecurringCharges === "") {
    contents[_RC] = [];
  } else if (output[_RC] != null && output[_RC][_RCe] != null) {
    contents[_RC] = de_RecurringChargeList((0, import_smithy_client.getArrayIfSingleItem)(output[_RC][_RCe]), context);
  }
  if (output[_RDBIA] != null) {
    contents[_RDBIA] = (0, import_smithy_client.expectString)(output[_RDBIA]);
  }
  if (output[_LI] != null) {
    contents[_LI] = (0, import_smithy_client.expectString)(output[_LI]);
  }
  return contents;
}, "de_ReservedDBInstance");
var de_ReservedDBInstanceAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_ReservedDBInstanceAlreadyExistsFault");
var de_ReservedDBInstanceList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ReservedDBInstance(entry, context);
  });
}, "de_ReservedDBInstanceList");
var de_ReservedDBInstanceMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.ReservedDBInstances === "") {
    contents[_RDBIes] = [];
  } else if (output[_RDBIes] != null && output[_RDBIes][_RDBIe] != null) {
    contents[_RDBIes] = de_ReservedDBInstanceList((0, import_smithy_client.getArrayIfSingleItem)(output[_RDBIes][_RDBIe]), context);
  }
  return contents;
}, "de_ReservedDBInstanceMessage");
var de_ReservedDBInstanceNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_ReservedDBInstanceNotFoundFault");
var de_ReservedDBInstanceQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_ReservedDBInstanceQuotaExceededFault");
var de_ReservedDBInstancesOffering = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RDBIOI] != null) {
    contents[_RDBIOI] = (0, import_smithy_client.expectString)(output[_RDBIOI]);
  }
  if (output[_DBIC] != null) {
    contents[_DBIC] = (0, import_smithy_client.expectString)(output[_DBIC]);
  }
  if (output[_Du] != null) {
    contents[_Du] = (0, import_smithy_client.strictParseInt32)(output[_Du]);
  }
  if (output[_FP] != null) {
    contents[_FP] = (0, import_smithy_client.strictParseFloat)(output[_FP]);
  }
  if (output[_UP] != null) {
    contents[_UP] = (0, import_smithy_client.strictParseFloat)(output[_UP]);
  }
  if (output[_CCu] != null) {
    contents[_CCu] = (0, import_smithy_client.expectString)(output[_CCu]);
  }
  if (output[_PD] != null) {
    contents[_PD] = (0, import_smithy_client.expectString)(output[_PD]);
  }
  if (output[_OT] != null) {
    contents[_OT] = (0, import_smithy_client.expectString)(output[_OT]);
  }
  if (output[_MAZ] != null) {
    contents[_MAZ] = (0, import_smithy_client.parseBoolean)(output[_MAZ]);
  }
  if (output.RecurringCharges === "") {
    contents[_RC] = [];
  } else if (output[_RC] != null && output[_RC][_RCe] != null) {
    contents[_RC] = de_RecurringChargeList((0, import_smithy_client.getArrayIfSingleItem)(output[_RC][_RCe]), context);
  }
  return contents;
}, "de_ReservedDBInstancesOffering");
var de_ReservedDBInstancesOfferingList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ReservedDBInstancesOffering(entry, context);
  });
}, "de_ReservedDBInstancesOfferingList");
var de_ReservedDBInstancesOfferingMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.ReservedDBInstancesOfferings === "") {
    contents[_RDBIO] = [];
  } else if (output[_RDBIO] != null && output[_RDBIO][_RDBIOe] != null) {
    contents[_RDBIO] = de_ReservedDBInstancesOfferingList((0, import_smithy_client.getArrayIfSingleItem)(output[_RDBIO][_RDBIOe]), context);
  }
  return contents;
}, "de_ReservedDBInstancesOfferingMessage");
var de_ReservedDBInstancesOfferingNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_ReservedDBInstancesOfferingNotFoundFault");
var de_ResourceNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_ResourceNotFoundFault");
var de_ResourcePendingMaintenanceActions = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RI] != null) {
    contents[_RI] = (0, import_smithy_client.expectString)(output[_RI]);
  }
  if (output.PendingMaintenanceActionDetails === "") {
    contents[_PMAD] = [];
  } else if (output[_PMAD] != null && output[_PMAD][_PMAe] != null) {
    contents[_PMAD] = de_PendingMaintenanceActionDetails((0, import_smithy_client.getArrayIfSingleItem)(output[_PMAD][_PMAe]), context);
  }
  return contents;
}, "de_ResourcePendingMaintenanceActions");
var de_RestoreDBClusterFromS3Result = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBC] != null) {
    contents[_DBC] = de_DBCluster(output[_DBC], context);
  }
  return contents;
}, "de_RestoreDBClusterFromS3Result");
var de_RestoreDBClusterFromSnapshotResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBC] != null) {
    contents[_DBC] = de_DBCluster(output[_DBC], context);
  }
  return contents;
}, "de_RestoreDBClusterFromSnapshotResult");
var de_RestoreDBClusterToPointInTimeResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBC] != null) {
    contents[_DBC] = de_DBCluster(output[_DBC], context);
  }
  return contents;
}, "de_RestoreDBClusterToPointInTimeResult");
var de_RestoreDBInstanceFromDBSnapshotResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBI] != null) {
    contents[_DBI] = de_DBInstance(output[_DBI], context);
  }
  return contents;
}, "de_RestoreDBInstanceFromDBSnapshotResult");
var de_RestoreDBInstanceFromS3Result = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBI] != null) {
    contents[_DBI] = de_DBInstance(output[_DBI], context);
  }
  return contents;
}, "de_RestoreDBInstanceFromS3Result");
var de_RestoreDBInstanceToPointInTimeResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBI] != null) {
    contents[_DBI] = de_DBInstance(output[_DBI], context);
  }
  return contents;
}, "de_RestoreDBInstanceToPointInTimeResult");
var de_RestoreWindow = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_ETa] != null) {
    contents[_ETa] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_ETa]));
  }
  if (output[_LT] != null) {
    contents[_LT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LT]));
  }
  return contents;
}, "de_RestoreWindow");
var de_RevokeDBSecurityGroupIngressResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBSGe] != null) {
    contents[_DBSGe] = de_DBSecurityGroup(output[_DBSGe], context);
  }
  return contents;
}, "de_RevokeDBSecurityGroupIngressResult");
var de_ScalarReferenceDetails = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Val] != null) {
    contents[_Val] = (0, import_smithy_client.strictParseFloat)(output[_Val]);
  }
  return contents;
}, "de_ScalarReferenceDetails");
var de_ScalingConfigurationInfo = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_MCi] != null) {
    contents[_MCi] = (0, import_smithy_client.strictParseInt32)(output[_MCi]);
  }
  if (output[_MCa] != null) {
    contents[_MCa] = (0, import_smithy_client.strictParseInt32)(output[_MCa]);
  }
  if (output[_AP] != null) {
    contents[_AP] = (0, import_smithy_client.parseBoolean)(output[_AP]);
  }
  if (output[_SUAP] != null) {
    contents[_SUAP] = (0, import_smithy_client.strictParseInt32)(output[_SUAP]);
  }
  if (output[_TAi] != null) {
    contents[_TAi] = (0, import_smithy_client.expectString)(output[_TAi]);
  }
  if (output[_SBT] != null) {
    contents[_SBT] = (0, import_smithy_client.strictParseInt32)(output[_SBT]);
  }
  return contents;
}, "de_ScalingConfigurationInfo");
var de_ServerlessV2FeaturesSupport = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_MCi] != null) {
    contents[_MCi] = (0, import_smithy_client.strictParseFloat)(output[_MCi]);
  }
  if (output[_MCa] != null) {
    contents[_MCa] = (0, import_smithy_client.strictParseFloat)(output[_MCa]);
  }
  return contents;
}, "de_ServerlessV2FeaturesSupport");
var de_ServerlessV2ScalingConfigurationInfo = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_MCi] != null) {
    contents[_MCi] = (0, import_smithy_client.strictParseFloat)(output[_MCi]);
  }
  if (output[_MCa] != null) {
    contents[_MCa] = (0, import_smithy_client.strictParseFloat)(output[_MCa]);
  }
  if (output[_SUAP] != null) {
    contents[_SUAP] = (0, import_smithy_client.strictParseInt32)(output[_SUAP]);
  }
  return contents;
}, "de_ServerlessV2ScalingConfigurationInfo");
var de_SharedSnapshotQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_SharedSnapshotQuotaExceededFault");
var de_SnapshotQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_SnapshotQuotaExceededFault");
var de_SNSInvalidTopicFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_SNSInvalidTopicFault");
var de_SNSNoAuthorizationFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_SNSNoAuthorizationFault");
var de_SNSTopicArnNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_SNSTopicArnNotFoundFault");
var de_SourceClusterNotSupportedFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_SourceClusterNotSupportedFault");
var de_SourceDatabaseNotSupportedFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_SourceDatabaseNotSupportedFault");
var de_SourceIdsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_SourceIdsList");
var de_SourceNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_SourceNotFoundFault");
var de_SourceRegion = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_RNe] != null) {
    contents[_RNe] = (0, import_smithy_client.expectString)(output[_RNe]);
  }
  if (output[_End] != null) {
    contents[_End] = (0, import_smithy_client.expectString)(output[_End]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_SDBIABRu] != null) {
    contents[_SDBIABRu] = (0, import_smithy_client.parseBoolean)(output[_SDBIABRu]);
  }
  return contents;
}, "de_SourceRegion");
var de_SourceRegionList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_SourceRegion(entry, context);
  });
}, "de_SourceRegionList");
var de_SourceRegionMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.SourceRegions === "") {
    contents[_SRo] = [];
  } else if (output[_SRo] != null && output[_SRo][_SR] != null) {
    contents[_SRo] = de_SourceRegionList((0, import_smithy_client.getArrayIfSingleItem)(output[_SRo][_SR]), context);
  }
  return contents;
}, "de_SourceRegionMessage");
var de_StartActivityStreamResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_KKI] != null) {
    contents[_KKI] = (0, import_smithy_client.expectString)(output[_KKI]);
  }
  if (output[_KSN] != null) {
    contents[_KSN] = (0, import_smithy_client.expectString)(output[_KSN]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_Mo] != null) {
    contents[_Mo] = (0, import_smithy_client.expectString)(output[_Mo]);
  }
  if (output[_AI] != null) {
    contents[_AI] = (0, import_smithy_client.parseBoolean)(output[_AI]);
  }
  if (output[_ENAFI] != null) {
    contents[_ENAFI] = (0, import_smithy_client.parseBoolean)(output[_ENAFI]);
  }
  return contents;
}, "de_StartActivityStreamResponse");
var de_StartDBClusterResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBC] != null) {
    contents[_DBC] = de_DBCluster(output[_DBC], context);
  }
  return contents;
}, "de_StartDBClusterResult");
var de_StartDBInstanceAutomatedBackupsReplicationResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBIABn] != null) {
    contents[_DBIABn] = de_DBInstanceAutomatedBackup(output[_DBIABn], context);
  }
  return contents;
}, "de_StartDBInstanceAutomatedBackupsReplicationResult");
var de_StartDBInstanceResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBI] != null) {
    contents[_DBI] = de_DBInstance(output[_DBI], context);
  }
  return contents;
}, "de_StartDBInstanceResult");
var de_StopActivityStreamResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_KKI] != null) {
    contents[_KKI] = (0, import_smithy_client.expectString)(output[_KKI]);
  }
  if (output[_KSN] != null) {
    contents[_KSN] = (0, import_smithy_client.expectString)(output[_KSN]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  return contents;
}, "de_StopActivityStreamResponse");
var de_StopDBClusterResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBC] != null) {
    contents[_DBC] = de_DBCluster(output[_DBC], context);
  }
  return contents;
}, "de_StopDBClusterResult");
var de_StopDBInstanceAutomatedBackupsReplicationResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBIABn] != null) {
    contents[_DBIABn] = de_DBInstanceAutomatedBackup(output[_DBIABn], context);
  }
  return contents;
}, "de_StopDBInstanceAutomatedBackupsReplicationResult");
var de_StopDBInstanceResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBI] != null) {
    contents[_DBI] = de_DBInstance(output[_DBI], context);
  }
  return contents;
}, "de_StopDBInstanceResult");
var de_StorageQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_StorageQuotaExceededFault");
var de_StorageTypeNotAvailableFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_StorageTypeNotAvailableFault");
var de_StorageTypeNotSupportedFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_StorageTypeNotSupportedFault");
var de_StringList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return (0, import_smithy_client.expectString)(entry);
  });
}, "de_StringList");
var de_Subnet = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SIub] != null) {
    contents[_SIub] = (0, import_smithy_client.expectString)(output[_SIub]);
  }
  if (output[_SAZu] != null) {
    contents[_SAZu] = de_AvailabilityZone(output[_SAZu], context);
  }
  if (output[_SO] != null) {
    contents[_SO] = de_Outpost(output[_SO], context);
  }
  if (output[_SSu] != null) {
    contents[_SSu] = (0, import_smithy_client.expectString)(output[_SSu]);
  }
  return contents;
}, "de_Subnet");
var de_SubnetAlreadyInUse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_SubnetAlreadyInUse");
var de_SubnetList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Subnet(entry, context);
  });
}, "de_SubnetList");
var de_SubscriptionAlreadyExistFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_SubscriptionAlreadyExistFault");
var de_SubscriptionCategoryNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_SubscriptionCategoryNotFoundFault");
var de_SubscriptionNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_SubscriptionNotFoundFault");
var de_SupportedCharacterSetsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_CharacterSet(entry, context);
  });
}, "de_SupportedCharacterSetsList");
var de_SupportedEngineLifecycle = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_LSN] != null) {
    contents[_LSN] = (0, import_smithy_client.expectString)(output[_LSN]);
  }
  if (output[_LSSD] != null) {
    contents[_LSSD] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LSSD]));
  }
  if (output[_LSED] != null) {
    contents[_LSED] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_LSED]));
  }
  return contents;
}, "de_SupportedEngineLifecycle");
var de_SupportedEngineLifecycleList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_SupportedEngineLifecycle(entry, context);
  });
}, "de_SupportedEngineLifecycleList");
var de_SupportedTimezonesList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Timezone(entry, context);
  });
}, "de_SupportedTimezonesList");
var de_SwitchoverBlueGreenDeploymentResponse = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_BGD] != null) {
    contents[_BGD] = de_BlueGreenDeployment(output[_BGD], context);
  }
  return contents;
}, "de_SwitchoverBlueGreenDeploymentResponse");
var de_SwitchoverDetail = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_SMo] != null) {
    contents[_SMo] = (0, import_smithy_client.expectString)(output[_SMo]);
  }
  if (output[_TM] != null) {
    contents[_TM] = (0, import_smithy_client.expectString)(output[_TM]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  return contents;
}, "de_SwitchoverDetail");
var de_SwitchoverDetailList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_SwitchoverDetail(entry, context);
  });
}, "de_SwitchoverDetailList");
var de_SwitchoverGlobalClusterResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_GC] != null) {
    contents[_GC] = de_GlobalCluster(output[_GC], context);
  }
  return contents;
}, "de_SwitchoverGlobalClusterResult");
var de_SwitchoverReadReplicaResult = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_DBI] != null) {
    contents[_DBI] = de_DBInstance(output[_DBI], context);
  }
  return contents;
}, "de_SwitchoverReadReplicaResult");
var de_Tag = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_K] != null) {
    contents[_K] = (0, import_smithy_client.expectString)(output[_K]);
  }
  if (output[_Val] != null) {
    contents[_Val] = (0, import_smithy_client.expectString)(output[_Val]);
  }
  return contents;
}, "de_Tag");
var de_TagList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_Tag(entry, context);
  });
}, "de_TagList");
var de_TagListMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.TagList === "") {
    contents[_TL] = [];
  } else if (output[_TL] != null && output[_TL][_Tag] != null) {
    contents[_TL] = de_TagList((0, import_smithy_client.getArrayIfSingleItem)(output[_TL][_Tag]), context);
  }
  return contents;
}, "de_TagListMessage");
var de_TargetGroupList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBProxyTargetGroup(entry, context);
  });
}, "de_TargetGroupList");
var de_TargetHealth = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Sta] != null) {
    contents[_Sta] = (0, import_smithy_client.expectString)(output[_Sta]);
  }
  if (output[_Rea] != null) {
    contents[_Rea] = (0, import_smithy_client.expectString)(output[_Rea]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  return contents;
}, "de_TargetHealth");
var de_TargetList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_DBProxyTarget(entry, context);
  });
}, "de_TargetList");
var de_TenantDatabase = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_TDCT] != null) {
    contents[_TDCT] = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseRfc3339DateTimeWithOffset)(output[_TDCT]));
  }
  if (output[_DBII] != null) {
    contents[_DBII] = (0, import_smithy_client.expectString)(output[_DBII]);
  }
  if (output[_TDBN] != null) {
    contents[_TDBN] = (0, import_smithy_client.expectString)(output[_TDBN]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  if (output[_MU] != null) {
    contents[_MU] = (0, import_smithy_client.expectString)(output[_MU]);
  }
  if (output[_DRI] != null) {
    contents[_DRI] = (0, import_smithy_client.expectString)(output[_DRI]);
  }
  if (output[_TDRI] != null) {
    contents[_TDRI] = (0, import_smithy_client.expectString)(output[_TDRI]);
  }
  if (output[_TDARN] != null) {
    contents[_TDARN] = (0, import_smithy_client.expectString)(output[_TDARN]);
  }
  if (output[_CSN] != null) {
    contents[_CSN] = (0, import_smithy_client.expectString)(output[_CSN]);
  }
  if (output[_NCSN] != null) {
    contents[_NCSN] = (0, import_smithy_client.expectString)(output[_NCSN]);
  }
  if (output[_DP] != null) {
    contents[_DP] = (0, import_smithy_client.parseBoolean)(output[_DP]);
  }
  if (output[_PMV] != null) {
    contents[_PMV] = de_TenantDatabasePendingModifiedValues(output[_PMV], context);
  }
  if (output[_MUS] != null) {
    contents[_MUS] = de_MasterUserSecret(output[_MUS], context);
  }
  if (output.TagList === "") {
    contents[_TL] = [];
  } else if (output[_TL] != null && output[_TL][_Tag] != null) {
    contents[_TL] = de_TagList((0, import_smithy_client.getArrayIfSingleItem)(output[_TL][_Tag]), context);
  }
  return contents;
}, "de_TenantDatabase");
var de_TenantDatabaseAlreadyExistsFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_TenantDatabaseAlreadyExistsFault");
var de_TenantDatabaseNotFoundFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_TenantDatabaseNotFoundFault");
var de_TenantDatabasePendingModifiedValues = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_MUP] != null) {
    contents[_MUP] = (0, import_smithy_client.expectString)(output[_MUP]);
  }
  if (output[_TDBN] != null) {
    contents[_TDBN] = (0, import_smithy_client.expectString)(output[_TDBN]);
  }
  return contents;
}, "de_TenantDatabasePendingModifiedValues");
var de_TenantDatabaseQuotaExceededFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_TenantDatabaseQuotaExceededFault");
var de_TenantDatabasesList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_TenantDatabase(entry, context);
  });
}, "de_TenantDatabasesList");
var de_TenantDatabasesMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_Ma] != null) {
    contents[_Ma] = (0, import_smithy_client.expectString)(output[_Ma]);
  }
  if (output.TenantDatabases === "") {
    contents[_TDe] = [];
  } else if (output[_TDe] != null && output[_TDe][_TD] != null) {
    contents[_TDe] = de_TenantDatabasesList((0, import_smithy_client.getArrayIfSingleItem)(output[_TDe][_TD]), context);
  }
  return contents;
}, "de_TenantDatabasesMessage");
var de_Timezone = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_TN] != null) {
    contents[_TN] = (0, import_smithy_client.expectString)(output[_TN]);
  }
  return contents;
}, "de_Timezone");
var de_UnsupportedDBEngineVersionFault = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_m] != null) {
    contents[_m] = (0, import_smithy_client.expectString)(output[_m]);
  }
  return contents;
}, "de_UnsupportedDBEngineVersionFault");
var de_UpgradeTarget = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_E] != null) {
    contents[_E] = (0, import_smithy_client.expectString)(output[_E]);
  }
  if (output[_EV] != null) {
    contents[_EV] = (0, import_smithy_client.expectString)(output[_EV]);
  }
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output[_AU] != null) {
    contents[_AU] = (0, import_smithy_client.parseBoolean)(output[_AU]);
  }
  if (output[_IMVU] != null) {
    contents[_IMVU] = (0, import_smithy_client.parseBoolean)(output[_IMVU]);
  }
  if (output.SupportedEngineModes === "") {
    contents[_SEM] = [];
  } else if (output[_SEM] != null && output[_SEM][_me] != null) {
    contents[_SEM] = de_EngineModeList((0, import_smithy_client.getArrayIfSingleItem)(output[_SEM][_me]), context);
  }
  if (output[_SPQ] != null) {
    contents[_SPQ] = (0, import_smithy_client.parseBoolean)(output[_SPQ]);
  }
  if (output[_SGD] != null) {
    contents[_SGD] = (0, import_smithy_client.parseBoolean)(output[_SGD]);
  }
  if (output[_SB] != null) {
    contents[_SB] = (0, import_smithy_client.parseBoolean)(output[_SB]);
  }
  if (output[_SLD] != null) {
    contents[_SLD] = (0, import_smithy_client.parseBoolean)(output[_SLD]);
  }
  if (output[_SLWF] != null) {
    contents[_SLWF] = (0, import_smithy_client.parseBoolean)(output[_SLWF]);
  }
  if (output[_SIup] != null) {
    contents[_SIup] = (0, import_smithy_client.parseBoolean)(output[_SIup]);
  }
  return contents;
}, "de_UpgradeTarget");
var de_UserAuthConfigInfo = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_D] != null) {
    contents[_D] = (0, import_smithy_client.expectString)(output[_D]);
  }
  if (output[_UN] != null) {
    contents[_UN] = (0, import_smithy_client.expectString)(output[_UN]);
  }
  if (output[_ASu] != null) {
    contents[_ASu] = (0, import_smithy_client.expectString)(output[_ASu]);
  }
  if (output[_SAe] != null) {
    contents[_SAe] = (0, import_smithy_client.expectString)(output[_SAe]);
  }
  if (output[_IAMA] != null) {
    contents[_IAMA] = (0, import_smithy_client.expectString)(output[_IAMA]);
  }
  if (output[_CPAT] != null) {
    contents[_CPAT] = (0, import_smithy_client.expectString)(output[_CPAT]);
  }
  return contents;
}, "de_UserAuthConfigInfo");
var de_UserAuthConfigInfoList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_UserAuthConfigInfo(entry, context);
  });
}, "de_UserAuthConfigInfoList");
var de_ValidDBInstanceModificationsMessage = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output.Storage === "") {
    contents[_Sto] = [];
  } else if (output[_Sto] != null && output[_Sto][_VSO] != null) {
    contents[_Sto] = de_ValidStorageOptionsList((0, import_smithy_client.getArrayIfSingleItem)(output[_Sto][_VSO]), context);
  }
  if (output.ValidProcessorFeatures === "") {
    contents[_VPF] = [];
  } else if (output[_VPF] != null && output[_VPF][_APFv] != null) {
    contents[_VPF] = de_AvailableProcessorFeatureList((0, import_smithy_client.getArrayIfSingleItem)(output[_VPF][_APFv]), context);
  }
  if (output[_SDLV] != null) {
    contents[_SDLV] = (0, import_smithy_client.parseBoolean)(output[_SDLV]);
  }
  return contents;
}, "de_ValidDBInstanceModificationsMessage");
var de_ValidStorageOptions = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_STt] != null) {
    contents[_STt] = (0, import_smithy_client.expectString)(output[_STt]);
  }
  if (output.StorageSize === "") {
    contents[_SSt] = [];
  } else if (output[_SSt] != null && output[_SSt][_Ra] != null) {
    contents[_SSt] = de_RangeList((0, import_smithy_client.getArrayIfSingleItem)(output[_SSt][_Ra]), context);
  }
  if (output.ProvisionedIops === "") {
    contents[_PI] = [];
  } else if (output[_PI] != null && output[_PI][_Ra] != null) {
    contents[_PI] = de_RangeList((0, import_smithy_client.getArrayIfSingleItem)(output[_PI][_Ra]), context);
  }
  if (output.IopsToStorageRatio === "") {
    contents[_ITSR] = [];
  } else if (output[_ITSR] != null && output[_ITSR][_DR] != null) {
    contents[_ITSR] = de_DoubleRangeList((0, import_smithy_client.getArrayIfSingleItem)(output[_ITSR][_DR]), context);
  }
  if (output[_SSA] != null) {
    contents[_SSA] = (0, import_smithy_client.parseBoolean)(output[_SSA]);
  }
  if (output.ProvisionedStorageThroughput === "") {
    contents[_PST] = [];
  } else if (output[_PST] != null && output[_PST][_Ra] != null) {
    contents[_PST] = de_RangeList((0, import_smithy_client.getArrayIfSingleItem)(output[_PST][_Ra]), context);
  }
  if (output.StorageThroughputToIopsRatio === "") {
    contents[_STTIR] = [];
  } else if (output[_STTIR] != null && output[_STTIR][_DR] != null) {
    contents[_STTIR] = de_DoubleRangeList((0, import_smithy_client.getArrayIfSingleItem)(output[_STTIR][_DR]), context);
  }
  return contents;
}, "de_ValidStorageOptions");
var de_ValidStorageOptionsList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_ValidStorageOptions(entry, context);
  });
}, "de_ValidStorageOptionsList");
var de_ValidUpgradeTargetList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_UpgradeTarget(entry, context);
  });
}, "de_ValidUpgradeTargetList");
var de_VpcSecurityGroupMembership = /* @__PURE__ */ __name((output, context) => {
  const contents = {};
  if (output[_VSGIp] != null) {
    contents[_VSGIp] = (0, import_smithy_client.expectString)(output[_VSGIp]);
  }
  if (output[_St] != null) {
    contents[_St] = (0, import_smithy_client.expectString)(output[_St]);
  }
  return contents;
}, "de_VpcSecurityGroupMembership");
var de_VpcSecurityGroupMembershipList = /* @__PURE__ */ __name((output, context) => {
  return (output || []).filter((e) => e != null).map((entry) => {
    return de_VpcSecurityGroupMembership(entry, context);
  });
}, "de_VpcSecurityGroupMembershipList");
var deserializeMetadata = /* @__PURE__ */ __name((output) => ({
  httpStatusCode: output.statusCode,
  requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
  extendedRequestId: output.headers["x-amz-id-2"],
  cfId: output.headers["x-amz-cf-id"]
}), "deserializeMetadata");
var throwDefaultError = (0, import_smithy_client.withBaseException)(RDSServiceException);
var buildHttpRpcRequest = /* @__PURE__ */ __name(async (context, headers, path, resolvedHostname, body) => {
  const { hostname, protocol = "https", port, path: basePath } = await context.endpoint();
  const contents = {
    protocol,
    hostname,
    port,
    method: "POST",
    path: basePath.endsWith("/") ? basePath.slice(0, -1) + path : basePath + path,
    headers
  };
  if (resolvedHostname !== void 0) {
    contents.hostname = resolvedHostname;
  }
  if (body !== void 0) {
    contents.body = body;
  }
  return new import_protocol_http.HttpRequest(contents);
}, "buildHttpRpcRequest");
var SHARED_HEADERS = {
  "content-type": "application/x-www-form-urlencoded"
};
var _ = "2014-10-31";
var _A = "Action";
var _AA = "ApplyAction";
var _AAAD = "AutoAppliedAfterDate";
var _ABRPA = "AwsBackupRecoveryPointArn";
var _ADBSGI = "AuthorizeDBSecurityGroupIngress";
var _ADL = "AllowDataLoss";
var _ADP = "AdditionalDataPending";
var _AEC = "AdditionalEncryptionContext";
var _AEMC = "AllowEngineModeChange";
var _AI = "ApplyImmediately";
var _AIc = "ActionId";
var _AId = "AdditionalInfo";
var _AM = "AutomationMode";
var _AMVU = "AutoMinorVersionUpgrade";
var _AMVUl = "AllowMajorVersionUpgrade";
var _AMp = "ApplyMethod";
var _AMpp = "ApplyModes";
var _AN = "AttributeName";
var _AP = "AutoPause";
var _APF = "AvailableProcessorFeatures";
var _APFv = "AvailableProcessorFeature";
var _APMA = "ApplyPendingMaintenanceAction";
var _APS = "AuditPolicyState";
var _AQ = "AccountQuotas";
var _AQN = "AccountQuotaName";
var _AQc = "AccountQuota";
var _AR = "AssociatedRoles";
var _ART = "AutomaticRestartTime";
var _ARTDBC = "AddRoleToDBCluster";
var _ARTDBI = "AddRoleToDBInstance";
var _AS = "AllocatedStorage";
var _ASA = "AuthSecretArn";
var _ASENAFI = "ActivityStreamEngineNativeAuditFieldsIncluded";
var _ASITS = "AddSourceIdentifierToSubscription";
var _ASKKI = "ActivityStreamKmsKeyId";
var _ASKSN = "ActivityStreamKinesisStreamName";
var _ASM = "ActivityStreamMode";
var _ASPS = "ActivityStreamPolicyStatus";
var _ASS = "ActivityStreamStatus";
var _ASu = "AuthScheme";
var _AT = "ApplyType";
var _ATTR = "AddTagsToResource";
var _AU = "AutoUpgrade";
var _AV = "AllowedValues";
var _AVANVIM = "AllowsVpcAndNonVpcInstanceMemberships";
var _AVl = "AllowedValue";
var _AVt = "AttributeValues";
var _AVtt = "AttributeValue";
var _AZ = "AvailabilityZones";
var _AZG = "AvailabilityZoneGroup";
var _AZv = "AvailabilityZone";
var _Ad = "Address";
var _An = "Analysis";
var _Ar = "Arn";
var _Au = "Auth";
var _BCCR = "BacktrackConsumedChangeRecords";
var _BDBC = "BacktrackDBCluster";
var _BF = "BacktrackedFrom";
var _BGD = "BlueGreenDeployment";
var _BGDI = "BlueGreenDeploymentIdentifier";
var _BGDN = "BlueGreenDeploymentName";
var _BGDl = "BlueGreenDeployments";
var _BI = "BacktrackIdentifier";
var _BRCT = "BacktrackRequestCreationTime";
var _BRP = "BackupRetentionPeriod";
var _BT = "BacktrackTo";
var _BTa = "BackupTarget";
var _BW = "BacktrackWindow";
var _C = "Capacity";
var _CA = "CertificateArn";
var _CAC = "CrossAccountClone";
var _CACI = "CACertificateIdentifier";
var _CAD = "CurrentApplyDate";
var _CAI = "CAIdentifier";
var _CAIu = "CustomerAwsId";
var _CAo = "ContextAttributes";
var _CBGD = "CreateBlueGreenDeployment";
var _CBT = "ConnectionBorrowTimeout";
var _CC = "CurrentCapacity";
var _CCA = "CopyableCrossAccount";
var _CCDBEV = "CreateCustomDBEngineVersion";
var _CCT = "ClusterCreateTime";
var _CCu = "CurrencyCode";
var _CD = "CertificateDetails";
var _CDBC = "CreateDBCluster";
var _CDBCE = "CreateDBClusterEndpoint";
var _CDBCPG = "CopyDBClusterParameterGroup";
var _CDBCPGr = "CreateDBClusterParameterGroup";
var _CDBCS = "CopyDBClusterSnapshot";
var _CDBCSr = "CreateDBClusterSnapshot";
var _CDBEVM = "CustomDBEngineVersionManifest";
var _CDBI = "CreateDBInstance";
var _CDBIRR = "CreateDBInstanceReadReplica";
var _CDBP = "CreateDBProxy";
var _CDBPE = "CreateDBProxyEndpoint";
var _CDBPG = "CopyDBParameterGroup";
var _CDBPGr = "CreateDBParameterGroup";
var _CDBS = "CopyDBSnapshot";
var _CDBSG = "CreateDBSecurityGroup";
var _CDBSGr = "CreateDBShardGroup";
var _CDBSGre = "CreateDBSubnetGroup";
var _CDBSr = "CreateDBSnapshot";
var _CDr = "CreatedDate";
var _CE = "CustomEndpoints";
var _CES = "CreateEventSubscription";
var _CET = "CancelExportTask";
var _CETu = "CustomEndpointType";
var _CGC = "CreateGlobalCluster";
var _CGI = "CloneGroupId";
var _CI = "CreateIntegration";
var _CIDRIP = "CIDRIP";
var _CIIP = "CustomIamInstanceProfile";
var _CIe = "CertificateIdentifier";
var _CLEC = "CloudwatchLogsExportConfiguration";
var _CO = "CustomerOverride";
var _COG = "CopyOptionGroup";
var _COGr = "CreateOptionGroup";
var _COIE = "CustomerOwnedIpEnabled";
var _COVT = "CustomerOverrideValidTill";
var _CPAT = "ClientPasswordAuthType";
var _CPC = "ConnectionPoolConfig";
var _CR = "ComputeRedundancy";
var _CRR = "CertificateRotationRestart";
var _CS = "CharacterSet";
var _CSD = "CharacterSetDescription";
var _CSI = "CustSubscriptionId";
var _CSN = "CharacterSetName";
var _CST = "ClusterScalabilityType";
var _CT = "CopyTags";
var _CTD = "CreateTenantDatabase";
var _CTTS = "CopyTagsToSnapshot";
var _CTe = "CertificateType";
var _CTo = "CopyTimestamp";
var _CTr = "CreateTime";
var _CTre = "CreatedTime";
var _Ca = "Category";
var _Ce = "Certificates";
var _Cer = "Certificate";
var _D = "Description";
var _DAA = "DescribeAccountAttributes";
var _DAB = "DeleteAutomatedBackups";
var _DASA = "DomainAuthSecretArn";
var _DBC = "DBCluster";
var _DBCA = "DBClusterArn";
var _DBCAB = "DBClusterAutomatedBackups";
var _DBCABA = "DBClusterAutomatedBackupsArn";
var _DBCABl = "DBClusterAutomatedBackup";
var _DBCB = "DBClusterBacktracks";
var _DBCBl = "DBClusterBacktrack";
var _DBCE = "DBClusterEndpoints";
var _DBCEA = "DBClusterEndpointArn";
var _DBCEI = "DBClusterEndpointIdentifier";
var _DBCEL = "DBClusterEndpointList";
var _DBCERI = "DBClusterEndpointResourceIdentifier";
var _DBCI = "DBClusterIdentifier";
var _DBCIC = "DBClusterInstanceClass";
var _DBCIl = "DBClusterIdentifiers";
var _DBCM = "DBClusterMembers";
var _DBCMl = "DBClusterMember";
var _DBCOG = "DBClusterOptionGroup";
var _DBCOGM = "DBClusterOptionGroupMemberships";
var _DBCOGN = "DBClusterOptionGroupName";
var _DBCPG = "DBClusterParameterGroup";
var _DBCPGA = "DBClusterParameterGroupArn";
var _DBCPGN = "DBClusterParameterGroupName";
var _DBCPGS = "DBClusterParameterGroupStatus";
var _DBCPGl = "DBClusterParameterGroups";
var _DBCR = "DBClusterRole";
var _DBCS = "DBClusterSnapshot";
var _DBCSA = "DBClusterSnapshotArn";
var _DBCSAR = "DBClusterSnapshotAttributesResult";
var _DBCSAl = "DBClusterSnapshotAttributes";
var _DBCSAlu = "DBClusterSnapshotAttribute";
var _DBCSI = "DBClusterSnapshotIdentifier";
var _DBCSIl = "DBClusterStatusInfo";
var _DBCSl = "DBClusterSnapshots";
var _DBCl = "DBClusters";
var _DBED = "DBEngineDescription";
var _DBEMT = "DBEngineMediaType";
var _DBEV = "DBEngineVersions";
var _DBEVA = "DBEngineVersionArn";
var _DBEVD = "DBEngineVersionDescription";
var _DBEVn = "DBEngineVersion";
var _DBGD = "DeleteBlueGreenDeployment";
var _DBGDe = "DescribeBlueGreenDeployments";
var _DBI = "DBInstance";
var _DBIA = "DBInstanceArn";
var _DBIAB = "DBInstanceAutomatedBackups";
var _DBIABA = "DBInstanceAutomatedBackupsArn";
var _DBIABR = "DBInstanceAutomatedBackupsReplications";
var _DBIABRn = "DBInstanceAutomatedBackupsReplication";
var _DBIABn = "DBInstanceAutomatedBackup";
var _DBIC = "DBInstanceClass";
var _DBICn = "DBInstanceCount";
var _DBII = "DBInstanceIdentifier";
var _DBIIn = "DBInstanceIdentifiers";
var _DBIPGN = "DBInstanceParameterGroupName";
var _DBIR = "DBInstanceRole";
var _DBIS = "DBInstanceStatus";
var _DBISI = "DBInstanceStatusInfo";
var _DBIn = "DBInstances";
var _DBMEV = "DBMajorEngineVersions";
var _DBMEVa = "DBMajorEngineVersion";
var _DBN = "DBName";
var _DBP = "DBProxy";
var _DBPA = "DBProxyArn";
var _DBPE = "DBProxyEndpoint";
var _DBPEA = "DBProxyEndpointArn";
var _DBPEN = "DBProxyEndpointName";
var _DBPEr = "DBProxyEndpoints";
var _DBPG = "DBParameterGroup";
var _DBPGA = "DBParameterGroupArn";
var _DBPGF = "DBParameterGroupFamily";
var _DBPGN = "DBParameterGroupName";
var _DBPGa = "DBParameterGroups";
var _DBPN = "DBProxyName";
var _DBPNo = "DBPortNumber";
var _DBPT = "DBProxyTargets";
var _DBPTG = "DBProxyTargetGroup";
var _DBPr = "DBProxies";
var _DBR = "DBRecommendation";
var _DBRe = "DBRecommendations";
var _DBS = "DBSnapshot";
var _DBSA = "DBSnapshotArn";
var _DBSAR = "DBSnapshotAttributesResult";
var _DBSAn = "DBSnapshotAttributes";
var _DBSAna = "DBSnapshotAttribute";
var _DBSG = "DBSecurityGroups";
var _DBSGA = "DBSecurityGroupArn";
var _DBSGAh = "DBShardGroupArn";
var _DBSGAu = "DBSubnetGroupArn";
var _DBSGD = "DBSecurityGroupDescription";
var _DBSGDu = "DBSubnetGroupDescription";
var _DBSGI = "DBShardGroupIdentifier";
var _DBSGM = "DBSecurityGroupMemberships";
var _DBSGN = "DBSecurityGroupName";
var _DBSGNu = "DBSubnetGroupName";
var _DBSGRI = "DBShardGroupResourceId";
var _DBSGe = "DBSecurityGroup";
var _DBSGh = "DBShardGroups";
var _DBSGha = "DBShardGroup";
var _DBSGu = "DBSubnetGroup";
var _DBSGub = "DBSubnetGroups";
var _DBSI = "DBSystemId";
var _DBSIn = "DBSnapshotIdentifier";
var _DBSTD = "DBSnapshotTenantDatabases";
var _DBSTDARN = "DBSnapshotTenantDatabaseARN";
var _DBSTDn = "DBSnapshotTenantDatabase";
var _DBSn = "DBSnapshots";
var _DC = "DescribeCertificates";
var _DCDBEV = "DeleteCustomDBEngineVersion";
var _DCFNL = "DefaultCertificateForNewLaunches";
var _DCI = "DbClusterIdentifier";
var _DCRI = "DbClusterResourceId";
var _DCS = "DefaultCharacterSet";
var _DD = "DisableDomain";
var _DDBC = "DeleteDBCluster";
var _DDBCAB = "DeleteDBClusterAutomatedBackup";
var _DDBCABe = "DescribeDBClusterAutomatedBackups";
var _DDBCB = "DescribeDBClusterBacktracks";
var _DDBCE = "DeleteDBClusterEndpoint";
var _DDBCEe = "DescribeDBClusterEndpoints";
var _DDBCP = "DescribeDBClusterParameters";
var _DDBCPG = "DeleteDBClusterParameterGroup";
var _DDBCPGe = "DescribeDBClusterParameterGroups";
var _DDBCS = "DeleteDBClusterSnapshot";
var _DDBCSA = "DescribeDBClusterSnapshotAttributes";
var _DDBCSe = "DescribeDBClusterSnapshots";
var _DDBCe = "DescribeDBClusters";
var _DDBEV = "DescribeDBEngineVersions";
var _DDBI = "DeleteDBInstance";
var _DDBIAB = "DeleteDBInstanceAutomatedBackup";
var _DDBIABe = "DescribeDBInstanceAutomatedBackups";
var _DDBIe = "DescribeDBInstances";
var _DDBLF = "DescribeDBLogFiles";
var _DDBLFD = "DescribeDBLogFilesDetails";
var _DDBLFP = "DownloadDBLogFilePortion";
var _DDBMEV = "DescribeDBMajorEngineVersions";
var _DDBP = "DeleteDBProxy";
var _DDBPE = "DeleteDBProxyEndpoint";
var _DDBPEe = "DescribeDBProxyEndpoints";
var _DDBPG = "DeleteDBParameterGroup";
var _DDBPGe = "DescribeDBParameterGroups";
var _DDBPT = "DeregisterDBProxyTargets";
var _DDBPTG = "DescribeDBProxyTargetGroups";
var _DDBPTe = "DescribeDBProxyTargets";
var _DDBPe = "DescribeDBParameters";
var _DDBPes = "DescribeDBProxies";
var _DDBR = "DescribeDBRecommendations";
var _DDBS = "DeleteDBSnapshot";
var _DDBSA = "DescribeDBSnapshotAttributes";
var _DDBSG = "DeleteDBSecurityGroup";
var _DDBSGe = "DeleteDBShardGroup";
var _DDBSGel = "DeleteDBSubnetGroup";
var _DDBSGes = "DescribeDBSecurityGroups";
var _DDBSGesc = "DescribeDBShardGroups";
var _DDBSGescr = "DescribeDBSubnetGroups";
var _DDBSTD = "DescribeDBSnapshotTenantDatabases";
var _DDBSe = "DescribeDBSnapshots";
var _DDI = "DomainDnsIps";
var _DE = "DescribeEvents";
var _DEC = "DescribeEventCategories";
var _DEDCP = "DescribeEngineDefaultClusterParameters";
var _DEDP = "DescribeEngineDefaultParameters";
var _DES = "DeleteEventSubscription";
var _DESe = "DescribeEventSubscriptions";
var _DET = "DescribeExportTasks";
var _DF = "DomainFqdn";
var _DFa = "DataFilter";
var _DGC = "DeleteGlobalCluster";
var _DGCe = "DescribeGlobalClusters";
var _DHE = "DisableHttpEndpoint";
var _DI = "DeleteIntegration";
var _DIAMRN = "DomainIAMRoleName";
var _DIFSBN = "DatabaseInstallationFilesS3BucketName";
var _DIFSP = "DatabaseInstallationFilesS3Prefix";
var _DIM = "DatabaseInsightsMode";
var _DIP = "DbInstancePort";
var _DIe = "DescribeIntegrations";
var _DIn = "DnsIps";
var _DL = "DebugLogging";
var _DLT = "DisableLogTypes";
var _DLV = "DedicatedLogVolume";
var _DM = "DomainMemberships";
var _DMo = "DomainMembership";
var _DN = "DatabaseName";
var _DO = "DomainOu";
var _DODBIO = "DescribeOrderableDBInstanceOptions";
var _DOG = "DeleteOptionGroup";
var _DOGO = "DescribeOptionGroupOptions";
var _DOGe = "DescribeOptionGroups";
var _DOe = "DefaultOnly";
var _DP = "DeletionProtection";
var _DPMA = "DescribePendingMaintenanceActions";
var _DPe = "DefaultPort";
var _DR = "DoubleRange";
var _DRDBI = "DescribeReservedDBInstances";
var _DRDBIO = "DescribeReservedDBInstancesOfferings";
var _DRI = "DbiResourceId";
var _DSR = "DescribeSourceRegions";
var _DT = "DeleteTarget";
var _DTD = "DeleteTenantDatabase";
var _DTDe = "DescribeTenantDatabases";
var _DTa = "DataType";
var _DTe = "DeleteTime";
var _DV = "DefaultValue";
var _DVDBIM = "DescribeValidDBInstanceModifications";
var _Da = "Date";
var _De = "Detection";
var _Di = "Dimensions";
var _Do = "Domain";
var _Du = "Duration";
var _E = "Engine";
var _EBT = "EarliestBacktrackTime";
var _EC = "EventCategories";
var _ECL = "EventCategoriesList";
var _ECLE = "EnableCloudwatchLogsExports";
var _ECLEn = "EnabledCloudwatchLogsExports";
var _ECM = "EventCategoriesMap";
var _ECML = "EventCategoriesMapList";
var _ECOI = "EnableCustomerOwnedIp";
var _ECSG = "EC2SecurityGroups";
var _ECSGI = "EC2SecurityGroupId";
var _ECSGN = "EC2SecurityGroupName";
var _ECSGOI = "EC2SecurityGroupOwnerId";
var _ECSGe = "EC2SecurityGroup";
var _ECr = "ErrorCode";
var _ECv = "EventCategory";
var _ED = "EngineDefaults";
var _EF = "EngineFamily";
var _EGWF = "EnableGlobalWriteForwarding";
var _EHE = "EnableHttpEndpoint";
var _EIAMDA = "EnableIAMDatabaseAuthentication";
var _ELD = "EnableLimitlessDatabase";
var _ELS = "EngineLifecycleSupport";
var _ELT = "EnableLogTypes";
var _ELTx = "ExportableLogTypes";
var _ELWF = "EnableLocalWriteForwarding";
var _EM = "ExcludedMembers";
var _EMRA = "EnhancedMonitoringResourceArn";
var _EMn = "EngineMode";
var _EMr = "ErrorMessage";
var _EN = "EngineName";
var _ENAFI = "EngineNativeAuditFieldsIncluded";
var _EO = "ExportOnly";
var _EPI = "EnablePerformanceInsights";
var _ERT = "EarliestRestorableTime";
var _ES = "EventSubscription";
var _ESA = "EventSubscriptionArn";
var _ESL = "EventSubscriptionsList";
var _ET = "EndpointType";
var _ETI = "ExportTaskIdentifier";
var _ETa = "EarliestTime";
var _ETn = "EndTime";
var _ETx = "ExportTasks";
var _ETxp = "ExportTask";
var _EV = "EngineVersion";
var _En = "Enabled";
var _Enc = "Encrypted";
var _End = "Endpoint";
var _Er = "Errors";
var _Ev = "Events";
var _Eve = "Event";
var _F = "Force";
var _FAD = "ForcedApplyDate";
var _FC = "FilenameContains";
var _FCa = "FailureCause";
var _FDBC = "FailoverDBCluster";
var _FDBSI = "FinalDBSnapshotIdentifier";
var _FDCA = "FromDbClusterArn";
var _FF = "ForceFailover";
var _FGC = "FailoverGlobalCluster";
var _FLW = "FileLastWritten";
var _FN = "FeatureName";
var _FP = "FixedPrice";
var _FQDN = "FQDN";
var _FS = "FileSize";
var _FSa = "FailoverState";
var _Fi = "Filters";
var _Fr = "From";
var _G = "Group";
var _GB = "GroupBy";
var _GC = "GlobalCluster";
var _GCA = "GlobalClusterArn";
var _GCI = "GlobalClusterIdentifier";
var _GCM = "GlobalClusterMembers";
var _GCMl = "GlobalClusterMember";
var _GCRI = "GlobalClusterResourceId";
var _GCl = "GlobalClusters";
var _GWFR = "GlobalWriteForwardingRequested";
var _GWFS = "GlobalWriteForwardingStatus";
var _HEE = "HttpEndpointEnabled";
var _HZI = "HostedZoneId";
var _I = "Iops";
var _IA = "IncludeAll";
var _IAMA = "IAMAuth";
var _IAMDAE = "IAMDatabaseAuthenticationEnabled";
var _IAMRN = "IAMRoleName";
var _IAn = "IntegrationArn";
var _IC = "IsCollection";
var _ICT = "IdleClientTimeout";
var _ICTn = "InstanceCreateTime";
var _ICW = "IsClusterWriter";
var _ID = "IsDefault";
var _IDLA = "IsDataLossAllowed";
var _IDs = "IssueDetails";
var _IE = "IntegrationError";
var _II = "ImageId";
var _IIn = "IntegrationIdentifier";
var _IM = "IsModifiable";
var _IMVU = "IsMajorVersionUpgrade";
var _IN = "IntegrationName";
var _IOONAMT = "IOOptimizedNextAllowedModificationTime";
var _IP = "IncludePublic";
var _IPR = "IPRanges";
var _IPRa = "IPRange";
var _IQ = "InitQuery";
var _IR = "IsRequired";
var _IRA = "IamRoleArn";
var _IS = "IncludeShared";
var _ISCUA = "IsStorageConfigUpgradeAvailable";
var _ISI = "InterconnectSubnetId";
var _ITSR = "IopsToStorageRatio";
var _IW = "IsWriter";
var _Im = "Image";
var _Imp = "Impact";
var _In = "Integrations";
var _Int = "Integration";
var _K = "Key";
var _KKI = "KmsKeyId";
var _KMSKI = "KMSKeyId";
var _KSN = "KinesisStreamName";
var _L = "Locale";
var _LD = "LimitlessDatabase";
var _LE = "ListenerEndpoint";
var _LFD = "LogFileData";
var _LFN = "LogFileName";
var _LI = "LeaseId";
var _LM = "LicenseModel";
var _LRT = "LatestRestorableTime";
var _LSCS = "ListSupportedCharacterSets";
var _LSED = "LifecycleSupportEndDate";
var _LSN = "LifecycleSupportName";
var _LSSD = "LifecycleSupportStartDate";
var _LST = "ListSupportedTimezones";
var _LT = "LatestTime";
var _LTFR = "ListTagsForResource";
var _LTTD = "LogTypesToDisable";
var _LTTE = "LogTypesToEnable";
var _LUA = "LastUpdatedAfter";
var _LUB = "LastUpdatedBefore";
var _LW = "LastWritten";
var _LWFS = "LocalWriteForwardingStatus";
var _Li = "Links";
var _Lim = "Limit";
var _M = "Manifest";
var _MACU = "MaxACU";
var _MACUi = "MinACU";
var _MAS = "ModifyActivityStream";
var _MASa = "MaxAllocatedStorage";
var _MAZ = "MultiAZ";
var _MAZC = "MultiAZCapable";
var _MC = "ModifyCertificates";
var _MCDBCC = "ModifyCurrentDBClusterCapacity";
var _MCDBEV = "ModifyCustomDBEngineVersion";
var _MCP = "MaxConnectionsPercent";
var _MCa = "MaxCapacity";
var _MCi = "MinCapacity";
var _MDBC = "ModifyDBCluster";
var _MDBCE = "ModifyDBClusterEndpoint";
var _MDBCPG = "ModifyDBClusterParameterGroup";
var _MDBCSA = "ModifyDBClusterSnapshotAttribute";
var _MDBI = "ModifyDBInstance";
var _MDBP = "ModifyDBProxy";
var _MDBPE = "ModifyDBProxyEndpoint";
var _MDBPG = "ModifyDBParameterGroup";
var _MDBPTG = "ModifyDBProxyTargetGroup";
var _MDBR = "ModifyDBRecommendation";
var _MDBS = "ModifyDBSnapshot";
var _MDBSA = "ModifyDBSnapshotAttribute";
var _MDBSG = "ModifyDBShardGroup";
var _MDBSGo = "ModifyDBSubnetGroup";
var _MES = "ModifyEventSubscription";
var _MEV = "MajorEngineVersion";
var _MEVPAV = "MinimumEngineVersionPerAllowedValue";
var _MEVi = "MinimumEngineVersion";
var _MGC = "ModifyGlobalCluster";
var _MI = "ModifyIntegration";
var _MICP = "MaxIdleConnectionsPercent";
var _MIPDI = "MinIopsPerDbInstance";
var _MIPDIa = "MaxIopsPerDbInstance";
var _MIPG = "MinIopsPerGib";
var _MIPGa = "MaxIopsPerGib";
var _MIo = "MonitoringInterval";
var _MMUP = "ManageMasterUserPassword";
var _MOG = "ModifyOptionGroup";
var _MQ = "MetricQuery";
var _MR = "MaxRecords";
var _MRA = "MonitoringRoleArn";
var _MRACU = "MinRequiredACU";
var _MRMEV = "MinimumRequiredMinorEngineVersion";
var _MSS = "MinStorageSize";
var _MSSa = "MaxStorageSize";
var _MSTPDI = "MinStorageThroughputPerDbInstance";
var _MSTPDIa = "MaxStorageThroughputPerDbInstance";
var _MSTPI = "MinStorageThroughputPerIops";
var _MSTPIa = "MaxStorageThroughputPerIops";
var _MT = "MultiTenant";
var _MTD = "ModifyTenantDatabase";
var _MU = "MasterUsername";
var _MUP = "MasterUserPassword";
var _MUS = "MasterUserSecret";
var _MUSKKI = "MasterUserSecretKmsKeyId";
var _Ma = "Marker";
var _Max = "Max";
var _Me = "Message";
var _Met = "Metric";
var _Metr = "Metrics";
var _Mo = "Mode";
var _N = "Name";
var _NCSN = "NcharCharacterSetName";
var _NDBCI = "NewDBClusterIdentifier";
var _NDBII = "NewDBInstanceIdentifier";
var _NDBPEN = "NewDBProxyEndpointName";
var _NDBPN = "NewDBProxyName";
var _NGCI = "NewGlobalClusterIdentifier";
var _NN = "NewName";
var _NOL = "NumberOfLines";
var _NT = "NetworkType";
var _NTDBN = "NewTenantDBName";
var _No = "Normal";
var _O = "Options";
var _OC = "OutpostCapable";
var _OCN = "OptionConflictName";
var _OCW = "OptionsConflictsWith";
var _OD = "OptionDescription";
var _ODBIO = "OrderableDBInstanceOptions";
var _ODBIOr = "OrderableDBInstanceOption";
var _ODO = "OptionsDependedOn";
var _OG = "OptionGroup";
var _OGA = "OptionGroupArn";
var _OGD = "OptionGroupDescription";
var _OGL = "OptionGroupsList";
var _OGM = "OptionGroupMemberships";
var _OGMp = "OptionGroupMembership";
var _OGN = "OptionGroupName";
var _OGO = "OptionGroupOptions";
var _OGOS = "OptionGroupOptionSettings";
var _OGOSp = "OptionGroupOptionSetting";
var _OGOV = "OptionGroupOptionVersions";
var _OGOp = "OptionGroupOption";
var _OI = "OwnerId";
var _OIS = "OptInStatus";
var _OIT = "OptInType";
var _ON = "OptionName";
var _OS = "OptionSettings";
var _OSCT = "OriginalSnapshotCreateTime";
var _OSp = "OptionSetting";
var _OT = "OfferingType";
var _OTI = "OptionsToInclude";
var _OTR = "OptionsToRemove";
var _OU = "OU";
var _OV = "OptionVersion";
var _Op = "Option";
var _Ope = "Operation";
var _P = "Port";
var _PA = "PubliclyAccessible";
var _PAS = "ParameterApplyStatus";
var _PBW = "PreferredBackupWindow";
var _PC = "PendingCapacity";
var _PCLE = "PendingCloudwatchLogsExports";
var _PD = "ProductDescription";
var _PF = "ProcessorFeatures";
var _PFr = "ProcessorFeature";
var _PI = "ProvisionedIops";
var _PID = "PerformanceIssueDetails";
var _PIE = "PerformanceInsightsEnabled";
var _PIKMSKI = "PerformanceInsightsKMSKeyId";
var _PIMQ = "PerformanceInsightsMetricQuery";
var _PIRP = "PerformanceInsightsRetentionPeriod";
var _PMA = "PendingMaintenanceActions";
var _PMAD = "PendingMaintenanceActionDetails";
var _PMAe = "PendingMaintenanceAction";
var _PMV = "PendingModifiedValues";
var _PMW = "PreferredMaintenanceWindow";
var _PN = "ParameterName";
var _PP = "PercentProgress";
var _PR = "PortRequired";
var _PRDBIO = "PurchaseReservedDBInstancesOffering";
var _PRR = "PromoteReadReplica";
var _PRRDBC = "PromoteReadReplicaDBCluster";
var _PS = "PolicyStatus";
var _PST = "ProvisionedStorageThroughput";
var _PSU = "PreSignedUrl";
var _PT = "PromotionTier";
var _PV = "ParameterValue";
var _Pa = "Parameters";
var _Par = "Parameter";
var _Pe = "Persistent";
var _Per = "Permanent";
var _R = "Region";
var _RA = "RoleArn";
var _RAMEVU = "RequiresAutoMinorEngineVersionUpgrade";
var _RAP = "ResetAllParameters";
var _RAU = "RecommendedActionUpdates";
var _RAe = "ResourceArn";
var _RAec = "RecommendedActions";
var _RC = "RecurringCharges";
var _RCA = "RecurringChargeAmount";
var _RCCC = "RdsCustomClusterConfiguration";
var _RCF = "RecurringChargeFrequency";
var _RCO = "RemoveCustomerOverride";
var _RCe = "RecurringCharge";
var _RD = "ReferenceDetails";
var _RDBC = "RebootDBCluster";
var _RDBCFS = "RestoreDBClusterFromS3";
var _RDBCFSe = "RestoreDBClusterFromSnapshot";
var _RDBCPG = "ResetDBClusterParameterGroup";
var _RDBCTPIT = "RestoreDBClusterToPointInTime";
var _RDBI = "RebootDBInstance";
var _RDBIA = "ReservedDBInstanceArn";
var _RDBIFDBS = "RestoreDBInstanceFromDBSnapshot";
var _RDBIFS = "RestoreDBInstanceFromS3";
var _RDBII = "ReservedDBInstanceId";
var _RDBIO = "ReservedDBInstancesOfferings";
var _RDBIOI = "ReservedDBInstancesOfferingId";
var _RDBIOe = "ReservedDBInstancesOffering";
var _RDBITPIT = "RestoreDBInstanceToPointInTime";
var _RDBIe = "ReservedDBInstance";
var _RDBIes = "ReservedDBInstances";
var _RDBPG = "ResetDBParameterGroup";
var _RDBPT = "RegisterDBProxyTargets";
var _RDBSG = "RebootDBShardGroup";
var _RDBSGI = "RevokeDBSecurityGroupIngress";
var _RE = "ReaderEndpoint";
var _RFAMM = "ResumeFullAutomationModeMinutes";
var _RFAMT = "ResumeFullAutomationModeTime";
var _RFGC = "RemoveFromGlobalCluster";
var _RI = "ResourceIdentifier";
var _RIe = "RecommendationId";
var _RM = "ReplicaMode";
var _RMUP = "RotateMasterUserPassword";
var _RN = "ResourceName";
var _RNe = "RegionName";
var _RPMA = "ResourcePendingMaintenanceActions";
var _RRC = "ReadReplicaCapable";
var _RRDBCI = "ReadReplicaDBClusterIdentifiers";
var _RRDBCIe = "ReadReplicaDBClusterIdentifier";
var _RRDBII = "ReadReplicaDBInstanceIdentifiers";
var _RRDBIIe = "ReadReplicaDBInstanceIdentifier";
var _RRFDBC = "RemoveRoleFromDBCluster";
var _RRFDBI = "RemoveRoleFromDBInstance";
var _RRI = "ReadReplicaIdentifiers";
var _RRId = "RdsResourceId";
var _RRIe = "ReadReplicaIdentifier";
var _RRSDBCI = "ReadReplicaSourceDBClusterIdentifier";
var _RRSDBII = "ReadReplicaSourceDBInstanceIdentifier";
var _RSI = "ReplicationSourceIdentifier";
var _RSIFS = "RemoveSourceIdentifierFromSubscription";
var _RT = "RestoreType";
var _RTFR = "RemoveTagsFromResource";
var _RTLS = "RequireTLS";
var _RTT = "RestoreToTime";
var _RTe = "RestoreTime";
var _RW = "RestoreWindow";
var _Ra = "Range";
var _Re = "Recommendation";
var _Rea = "Reason";
var _Read = "Readers";
var _Ref = "References";
var _Ro = "Role";
var _S = "Source";
var _SA = "SourceArn";
var _SAI = "SourceAccountId";
var _SAS = "StartActivityStream";
var _SASM = "SupportedActivityStreamModes";
var _SASt = "StopActivityStream";
var _SAZ = "SnapshotAvailabilityZone";
var _SAZe = "SecondaryAvailabilityZone";
var _SAZu = "SubnetAvailabilityZone";
var _SAe = "SecretArn";
var _SB = "SupportsBabelfish";
var _SBGD = "SwitchoverBlueGreenDeployment";
var _SBN = "S3BucketName";
var _SBT = "SecondsBeforeTimeout";
var _SBu = "S3Bucket";
var _SC = "ScalingConfiguration";
var _SCACI = "SupportedCACertificateIdentifiers";
var _SCDEVI = "SourceCustomDbEngineVersionIdentifier";
var _SCI = "ScalingConfigurationInfo";
var _SCRWR = "SupportsCertificateRotationWithoutRestart";
var _SCS = "SupportedCharacterSets";
var _SCT = "SnapshotCreateTime";
var _SCTu = "SubscriptionCreationTime";
var _SCu = "SupportsClusters";
var _SD = "SwitchoverDetails";
var _SDBC = "StartDBCluster";
var _SDBCI = "SourceDBClusterIdentifier";
var _SDBCPGI = "SourceDBClusterParameterGroupIdentifier";
var _SDBCSA = "SourceDBClusterSnapshotArn";
var _SDBCSI = "SourceDBClusterSnapshotIdentifier";
var _SDBCt = "StopDBCluster";
var _SDBI = "StartDBInstance";
var _SDBIA = "SourceDBInstanceArn";
var _SDBIABA = "SourceDBInstanceAutomatedBackupsArn";
var _SDBIABR = "StartDBInstanceAutomatedBackupsReplication";
var _SDBIABRt = "StopDBInstanceAutomatedBackupsReplication";
var _SDBIABRu = "SupportsDBInstanceAutomatedBackupsReplication";
var _SDBII = "SourceDBInstanceIdentifier";
var _SDBIt = "StopDBInstance";
var _SDBPGI = "SourceDBParameterGroupIdentifier";
var _SDBSI = "SourceDBSnapshotIdentifier";
var _SDCRI = "SourceDbClusterResourceId";
var _SDLV = "SupportsDedicatedLogVolume";
var _SDRI = "SourceDbiResourceId";
var _SDT = "SnapshotDatabaseTime";
var _SDe = "SettingDescription";
var _SDt = "StatusDetails";
var _SDta = "StatisticsDetails";
var _SE = "StorageEncrypted";
var _SEL = "SupportedEngineLifecycles";
var _SELu = "SupportedEngineLifecycle";
var _SEM = "SupportedEngineModes";
var _SEMu = "SupportsEnhancedMonitoring";
var _SET = "StartExportTask";
var _SEV = "SourceEngineVersion";
var _SEo = "SourceEngine";
var _SFN = "SupportedFeatureNames";
var _SFS = "SkipFinalSnapshot";
var _SG = "SecurityGroups";
var _SGC = "SwitchoverGlobalCluster";
var _SGD = "SupportsGlobalDatabases";
var _SGS = "SubnetGroupStatus";
var _SI = "SourceIdentifier";
var _SIAMDA = "SupportsIAMDatabaseAuthentication";
var _SIL = "SourceIdsList";
var _SIRA = "S3IngestionRoleArn";
var _SIn = "SnapshotIdentifier";
var _SIo = "SourceIds";
var _SIou = "SourceId";
var _SIt = "StatusInfos";
var _SIu = "SubnetIds";
var _SIub = "SubnetIdentifier";
var _SIup = "SupportsIntegrations";
var _SIupp = "SupportsIops";
var _SKA = "SupportsKerberosAuthentication";
var _SLD = "SupportsLimitlessDatabase";
var _SLETCL = "SupportsLogExportsToCloudwatchLogs";
var _SLWF = "SupportsLocalWriteForwarding";
var _SM = "StaticMembers";
var _SMo = "SourceMember";
var _SN = "SubscriptionName";
var _SNCS = "SupportedNcharCharacterSets";
var _SNT = "SupportedNetworkTypes";
var _SNe = "SettingName";
var _SO = "SubnetOutpost";
var _SOG = "SourceOptionGroup";
var _SOGI = "SourceOptionGroupIdentifier";
var _SOVD = "SupportsOptionVersionDowngrade";
var _SP = "S3Prefix";
var _SPF = "SessionPinningFilters";
var _SPI = "SupportsPerformanceInsights";
var _SPQ = "SupportsParallelQuery";
var _SR = "SourceRegion";
var _SRD = "ScalarReferenceDetails";
var _SRR = "SwitchoverReadReplica";
var _SRRu = "SupportsReadReplica";
var _SRo = "SourceRegions";
var _SS = "SynchronizationStatus";
var _SSA = "SupportsStorageAutoscaling";
var _SSE = "SupportsStorageEncryption";
var _SST = "SupportsStorageThroughput";
var _SSe = "SecretStatus";
var _SSt = "StorageSize";
var _SSu = "SubnetStatus";
var _ST = "SnapshotTarget";
var _STA = "SnsTopicArn";
var _STTIR = "StorageThroughputToIopsRatio";
var _STn = "SnapshotType";
var _STna = "SnapshotTime";
var _STo = "SourceType";
var _STt = "StorageType";
var _STta = "StartTime";
var _STtat = "StatusType";
var _STto = "StorageThroughput";
var _STu = "SupportedTimezones";
var _STw = "SwitchoverTimeout";
var _SUAP = "SecondsUntilAutoPause";
var _SVFS = "ServerlessV2FeaturesSupport";
var _SVSC = "ServerlessV2ScalingConfiguration";
var _Se = "Severity";
var _Si = "Size";
var _St = "Status";
var _Sta = "State";
var _Ste = "Step";
var _Sto = "Storage";
var _Su = "Subnets";
var _Sub = "Subnet";
var _Sw = "Switchover";
var _T = "Tags";
var _TA = "TargetArn";
var _TAS = "TargetAllocatedStorage";
var _TAi = "TimeoutAction";
var _TCA = "TdeCredentialArn";
var _TCAZ = "TargetCustomAvailabilityZone";
var _TCI = "TrackedClusterId";
var _TCP = "TdeCredentialPassword";
var _TD = "TenantDatabase";
var _TDARN = "TenantDatabaseARN";
var _TDBCPGD = "TargetDBClusterParameterGroupDescription";
var _TDBCPGI = "TargetDBClusterParameterGroupIdentifier";
var _TDBCPGN = "TargetDBClusterParameterGroupName";
var _TDBCSI = "TargetDBClusterSnapshotIdentifier";
var _TDBIC = "TargetDBInstanceClass";
var _TDBII = "TargetDBInstanceIdentifier";
var _TDBN = "TenantDBName";
var _TDBPGD = "TargetDBParameterGroupDescription";
var _TDBPGI = "TargetDBParameterGroupIdentifier";
var _TDBPGN = "TargetDBParameterGroupName";
var _TDBSI = "TargetDBSnapshotIdentifier";
var _TDCA = "ToDbClusterArn";
var _TDCI = "TargetDbClusterIdentifier";
var _TDCT = "TenantDatabaseCreateTime";
var _TDRI = "TenantDatabaseResourceId";
var _TDe = "TenantDatabases";
var _TDy = "TypeDetection";
var _TEDIGB = "TotalExtractedDataInGB";
var _TET = "TaskEndTime";
var _TEV = "TargetEngineVersion";
var _TG = "TargetGroups";
var _TGA = "TargetGroupArn";
var _TGMDI = "TransitGatewayMulticastDomainId";
var _TGN = "TargetGroupName";
var _TH = "TargetHealth";
var _TI = "TargetIops";
var _TIy = "TypeId";
var _TK = "TagKeys";
var _TL = "TagList";
var _TM = "TargetMember";
var _TN = "TimezoneName";
var _TOGD = "TargetOptionGroupDescription";
var _TOGI = "TargetOptionGroupIdentifier";
var _TR = "TargetRole";
var _TRy = "TypeRecommendation";
var _TST = "TargetStorageType";
var _TSTa = "TargetStorageThroughput";
var _TSTas = "TaskStartTime";
var _Ta = "Target";
var _Tag = "Tag";
var _Tar = "Targets";
var _Tas = "Tasks";
var _Te = "Text";
var _Th = "Thumbprint";
var _Ti = "Timezone";
var _Tit = "Title";
var _To = "To";
var _Ty = "Type";
var _U = "Used";
var _UAPLI = "UseAwsProvidedLatestImage";
var _UD = "UpdatedDate";
var _UDPF = "UseDefaultProcessorFeatures";
var _UETOPITU = "UseEarliestTimeOnPointInTimeUnavailable";
var _ULRT = "UseLatestRestorableTime";
var _UN = "UserName";
var _UP = "UsagePrice";
var _USC = "UpgradeStorageConfig";
var _UT = "UpgradeTarget";
var _UTSC = "UpgradeTargetStorageConfig";
var _UTp = "UpdatedTime";
var _Ur = "Url";
var _V = "Version";
var _VDBIMM = "ValidDBInstanceModificationsMessage";
var _VF = "ValidFrom";
var _VI = "VpcId";
var _VO = "VpcOnly";
var _VPF = "ValidProcessorFeatures";
var _VSG = "VpcSecurityGroups";
var _VSGI = "VpcSecurityGroupIds";
var _VSGIp = "VpcSecurityGroupId";
var _VSGM = "VpcSecurityGroupMemberships";
var _VSGMp = "VpcSecurityGroupMembership";
var _VSI = "VpcSubnetIds";
var _VSO = "ValidStorageOptions";
var _VT = "ValidTill";
var _VTA = "ValuesToAdd";
var _VTR = "ValuesToRemove";
var _VUT = "ValidUpgradeTarget";
var _Va = "Values";
var _Val = "Value";
var _Vp = "Vpc";
var _WM = "WarningMessage";
var _e = "entry";
var _m = "message";
var _me = "member";
var buildFormUrlencodedString = /* @__PURE__ */ __name((formEntries) => Object.entries(formEntries).map(([key, value]) => (0, import_smithy_client.extendedEncodeURIComponent)(key) + "=" + (0, import_smithy_client.extendedEncodeURIComponent)(value)).join("&"), "buildFormUrlencodedString");
var loadQueryErrorCode = /* @__PURE__ */ __name((output, data) => {
  if (data.Error?.Code !== void 0) {
    return data.Error.Code;
  }
  if (output.statusCode == 404) {
    return "NotFound";
  }
}, "loadQueryErrorCode");

// src/commands/AddRoleToDBClusterCommand.ts
var AddRoleToDBClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "AddRoleToDBCluster", {}).n("RDSClient", "AddRoleToDBClusterCommand").f(void 0, void 0).ser(se_AddRoleToDBClusterCommand).de(de_AddRoleToDBClusterCommand).build() {
  static {
    __name(this, "AddRoleToDBClusterCommand");
  }
};

// src/commands/AddRoleToDBInstanceCommand.ts



var AddRoleToDBInstanceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "AddRoleToDBInstance", {}).n("RDSClient", "AddRoleToDBInstanceCommand").f(void 0, void 0).ser(se_AddRoleToDBInstanceCommand).de(de_AddRoleToDBInstanceCommand).build() {
  static {
    __name(this, "AddRoleToDBInstanceCommand");
  }
};

// src/commands/AddSourceIdentifierToSubscriptionCommand.ts



var AddSourceIdentifierToSubscriptionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "AddSourceIdentifierToSubscription", {}).n("RDSClient", "AddSourceIdentifierToSubscriptionCommand").f(void 0, void 0).ser(se_AddSourceIdentifierToSubscriptionCommand).de(de_AddSourceIdentifierToSubscriptionCommand).build() {
  static {
    __name(this, "AddSourceIdentifierToSubscriptionCommand");
  }
};

// src/commands/AddTagsToResourceCommand.ts



var AddTagsToResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "AddTagsToResource", {}).n("RDSClient", "AddTagsToResourceCommand").f(void 0, void 0).ser(se_AddTagsToResourceCommand).de(de_AddTagsToResourceCommand).build() {
  static {
    __name(this, "AddTagsToResourceCommand");
  }
};

// src/commands/ApplyPendingMaintenanceActionCommand.ts



var ApplyPendingMaintenanceActionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ApplyPendingMaintenanceAction", {}).n("RDSClient", "ApplyPendingMaintenanceActionCommand").f(void 0, void 0).ser(se_ApplyPendingMaintenanceActionCommand).de(de_ApplyPendingMaintenanceActionCommand).build() {
  static {
    __name(this, "ApplyPendingMaintenanceActionCommand");
  }
};

// src/commands/AuthorizeDBSecurityGroupIngressCommand.ts



var AuthorizeDBSecurityGroupIngressCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "AuthorizeDBSecurityGroupIngress", {}).n("RDSClient", "AuthorizeDBSecurityGroupIngressCommand").f(void 0, void 0).ser(se_AuthorizeDBSecurityGroupIngressCommand).de(de_AuthorizeDBSecurityGroupIngressCommand).build() {
  static {
    __name(this, "AuthorizeDBSecurityGroupIngressCommand");
  }
};

// src/commands/BacktrackDBClusterCommand.ts



var BacktrackDBClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "BacktrackDBCluster", {}).n("RDSClient", "BacktrackDBClusterCommand").f(void 0, void 0).ser(se_BacktrackDBClusterCommand).de(de_BacktrackDBClusterCommand).build() {
  static {
    __name(this, "BacktrackDBClusterCommand");
  }
};

// src/commands/CancelExportTaskCommand.ts



var CancelExportTaskCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CancelExportTask", {}).n("RDSClient", "CancelExportTaskCommand").f(void 0, void 0).ser(se_CancelExportTaskCommand).de(de_CancelExportTaskCommand).build() {
  static {
    __name(this, "CancelExportTaskCommand");
  }
};

// src/commands/CopyDBClusterParameterGroupCommand.ts



var CopyDBClusterParameterGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CopyDBClusterParameterGroup", {}).n("RDSClient", "CopyDBClusterParameterGroupCommand").f(void 0, void 0).ser(se_CopyDBClusterParameterGroupCommand).de(de_CopyDBClusterParameterGroupCommand).build() {
  static {
    __name(this, "CopyDBClusterParameterGroupCommand");
  }
};

// src/commands/CopyDBClusterSnapshotCommand.ts
var import_middleware_sdk_rds = require("@aws-sdk/middleware-sdk-rds");



var CopyDBClusterSnapshotCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions()),
    (0, import_middleware_sdk_rds.getCrossRegionPresignedUrlPlugin)(config)
  ];
}).s("AmazonRDSv19", "CopyDBClusterSnapshot", {}).n("RDSClient", "CopyDBClusterSnapshotCommand").f(void 0, void 0).ser(se_CopyDBClusterSnapshotCommand).de(de_CopyDBClusterSnapshotCommand).build() {
  static {
    __name(this, "CopyDBClusterSnapshotCommand");
  }
};

// src/commands/CopyDBParameterGroupCommand.ts



var CopyDBParameterGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CopyDBParameterGroup", {}).n("RDSClient", "CopyDBParameterGroupCommand").f(void 0, void 0).ser(se_CopyDBParameterGroupCommand).de(de_CopyDBParameterGroupCommand).build() {
  static {
    __name(this, "CopyDBParameterGroupCommand");
  }
};

// src/commands/CopyDBSnapshotCommand.ts




var CopyDBSnapshotCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions()),
    (0, import_middleware_sdk_rds.getCrossRegionPresignedUrlPlugin)(config)
  ];
}).s("AmazonRDSv19", "CopyDBSnapshot", {}).n("RDSClient", "CopyDBSnapshotCommand").f(void 0, void 0).ser(se_CopyDBSnapshotCommand).de(de_CopyDBSnapshotCommand).build() {
  static {
    __name(this, "CopyDBSnapshotCommand");
  }
};

// src/commands/CopyOptionGroupCommand.ts



var CopyOptionGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CopyOptionGroup", {}).n("RDSClient", "CopyOptionGroupCommand").f(void 0, void 0).ser(se_CopyOptionGroupCommand).de(de_CopyOptionGroupCommand).build() {
  static {
    __name(this, "CopyOptionGroupCommand");
  }
};

// src/commands/CreateBlueGreenDeploymentCommand.ts



var CreateBlueGreenDeploymentCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CreateBlueGreenDeployment", {}).n("RDSClient", "CreateBlueGreenDeploymentCommand").f(void 0, void 0).ser(se_CreateBlueGreenDeploymentCommand).de(de_CreateBlueGreenDeploymentCommand).build() {
  static {
    __name(this, "CreateBlueGreenDeploymentCommand");
  }
};

// src/commands/CreateCustomDBEngineVersionCommand.ts



var CreateCustomDBEngineVersionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CreateCustomDBEngineVersion", {}).n("RDSClient", "CreateCustomDBEngineVersionCommand").f(void 0, void 0).ser(se_CreateCustomDBEngineVersionCommand).de(de_CreateCustomDBEngineVersionCommand).build() {
  static {
    __name(this, "CreateCustomDBEngineVersionCommand");
  }
};

// src/commands/CreateDBClusterCommand.ts




var CreateDBClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions()),
    (0, import_middleware_sdk_rds.getCrossRegionPresignedUrlPlugin)(config)
  ];
}).s("AmazonRDSv19", "CreateDBCluster", {}).n("RDSClient", "CreateDBClusterCommand").f(void 0, void 0).ser(se_CreateDBClusterCommand).de(de_CreateDBClusterCommand).build() {
  static {
    __name(this, "CreateDBClusterCommand");
  }
};

// src/commands/CreateDBClusterEndpointCommand.ts



var CreateDBClusterEndpointCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CreateDBClusterEndpoint", {}).n("RDSClient", "CreateDBClusterEndpointCommand").f(void 0, void 0).ser(se_CreateDBClusterEndpointCommand).de(de_CreateDBClusterEndpointCommand).build() {
  static {
    __name(this, "CreateDBClusterEndpointCommand");
  }
};

// src/commands/CreateDBClusterParameterGroupCommand.ts



var CreateDBClusterParameterGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CreateDBClusterParameterGroup", {}).n("RDSClient", "CreateDBClusterParameterGroupCommand").f(void 0, void 0).ser(se_CreateDBClusterParameterGroupCommand).de(de_CreateDBClusterParameterGroupCommand).build() {
  static {
    __name(this, "CreateDBClusterParameterGroupCommand");
  }
};

// src/commands/CreateDBClusterSnapshotCommand.ts



var CreateDBClusterSnapshotCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CreateDBClusterSnapshot", {}).n("RDSClient", "CreateDBClusterSnapshotCommand").f(void 0, void 0).ser(se_CreateDBClusterSnapshotCommand).de(de_CreateDBClusterSnapshotCommand).build() {
  static {
    __name(this, "CreateDBClusterSnapshotCommand");
  }
};

// src/commands/CreateDBInstanceCommand.ts



var CreateDBInstanceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CreateDBInstance", {}).n("RDSClient", "CreateDBInstanceCommand").f(void 0, void 0).ser(se_CreateDBInstanceCommand).de(de_CreateDBInstanceCommand).build() {
  static {
    __name(this, "CreateDBInstanceCommand");
  }
};

// src/commands/CreateDBInstanceReadReplicaCommand.ts




var CreateDBInstanceReadReplicaCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions()),
    (0, import_middleware_sdk_rds.getCrossRegionPresignedUrlPlugin)(config)
  ];
}).s("AmazonRDSv19", "CreateDBInstanceReadReplica", {}).n("RDSClient", "CreateDBInstanceReadReplicaCommand").f(void 0, void 0).ser(se_CreateDBInstanceReadReplicaCommand).de(de_CreateDBInstanceReadReplicaCommand).build() {
  static {
    __name(this, "CreateDBInstanceReadReplicaCommand");
  }
};

// src/commands/CreateDBParameterGroupCommand.ts



var CreateDBParameterGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CreateDBParameterGroup", {}).n("RDSClient", "CreateDBParameterGroupCommand").f(void 0, void 0).ser(se_CreateDBParameterGroupCommand).de(de_CreateDBParameterGroupCommand).build() {
  static {
    __name(this, "CreateDBParameterGroupCommand");
  }
};

// src/commands/CreateDBProxyCommand.ts



var CreateDBProxyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CreateDBProxy", {}).n("RDSClient", "CreateDBProxyCommand").f(void 0, void 0).ser(se_CreateDBProxyCommand).de(de_CreateDBProxyCommand).build() {
  static {
    __name(this, "CreateDBProxyCommand");
  }
};

// src/commands/CreateDBProxyEndpointCommand.ts



var CreateDBProxyEndpointCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CreateDBProxyEndpoint", {}).n("RDSClient", "CreateDBProxyEndpointCommand").f(void 0, void 0).ser(se_CreateDBProxyEndpointCommand).de(de_CreateDBProxyEndpointCommand).build() {
  static {
    __name(this, "CreateDBProxyEndpointCommand");
  }
};

// src/commands/CreateDBSecurityGroupCommand.ts



var CreateDBSecurityGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CreateDBSecurityGroup", {}).n("RDSClient", "CreateDBSecurityGroupCommand").f(void 0, void 0).ser(se_CreateDBSecurityGroupCommand).de(de_CreateDBSecurityGroupCommand).build() {
  static {
    __name(this, "CreateDBSecurityGroupCommand");
  }
};

// src/commands/CreateDBShardGroupCommand.ts



var CreateDBShardGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CreateDBShardGroup", {}).n("RDSClient", "CreateDBShardGroupCommand").f(void 0, void 0).ser(se_CreateDBShardGroupCommand).de(de_CreateDBShardGroupCommand).build() {
  static {
    __name(this, "CreateDBShardGroupCommand");
  }
};

// src/commands/CreateDBSnapshotCommand.ts



var CreateDBSnapshotCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CreateDBSnapshot", {}).n("RDSClient", "CreateDBSnapshotCommand").f(void 0, void 0).ser(se_CreateDBSnapshotCommand).de(de_CreateDBSnapshotCommand).build() {
  static {
    __name(this, "CreateDBSnapshotCommand");
  }
};

// src/commands/CreateDBSubnetGroupCommand.ts



var CreateDBSubnetGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CreateDBSubnetGroup", {}).n("RDSClient", "CreateDBSubnetGroupCommand").f(void 0, void 0).ser(se_CreateDBSubnetGroupCommand).de(de_CreateDBSubnetGroupCommand).build() {
  static {
    __name(this, "CreateDBSubnetGroupCommand");
  }
};

// src/commands/CreateEventSubscriptionCommand.ts



var CreateEventSubscriptionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CreateEventSubscription", {}).n("RDSClient", "CreateEventSubscriptionCommand").f(void 0, void 0).ser(se_CreateEventSubscriptionCommand).de(de_CreateEventSubscriptionCommand).build() {
  static {
    __name(this, "CreateEventSubscriptionCommand");
  }
};

// src/commands/CreateGlobalClusterCommand.ts



var CreateGlobalClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CreateGlobalCluster", {}).n("RDSClient", "CreateGlobalClusterCommand").f(void 0, void 0).ser(se_CreateGlobalClusterCommand).de(de_CreateGlobalClusterCommand).build() {
  static {
    __name(this, "CreateGlobalClusterCommand");
  }
};

// src/commands/CreateIntegrationCommand.ts



var CreateIntegrationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CreateIntegration", {}).n("RDSClient", "CreateIntegrationCommand").f(void 0, void 0).ser(se_CreateIntegrationCommand).de(de_CreateIntegrationCommand).build() {
  static {
    __name(this, "CreateIntegrationCommand");
  }
};

// src/commands/CreateOptionGroupCommand.ts



var CreateOptionGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CreateOptionGroup", {}).n("RDSClient", "CreateOptionGroupCommand").f(void 0, void 0).ser(se_CreateOptionGroupCommand).de(de_CreateOptionGroupCommand).build() {
  static {
    __name(this, "CreateOptionGroupCommand");
  }
};

// src/commands/CreateTenantDatabaseCommand.ts



var CreateTenantDatabaseCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "CreateTenantDatabase", {}).n("RDSClient", "CreateTenantDatabaseCommand").f(CreateTenantDatabaseMessageFilterSensitiveLog, CreateTenantDatabaseResultFilterSensitiveLog).ser(se_CreateTenantDatabaseCommand).de(de_CreateTenantDatabaseCommand).build() {
  static {
    __name(this, "CreateTenantDatabaseCommand");
  }
};

// src/commands/DeleteBlueGreenDeploymentCommand.ts



var DeleteBlueGreenDeploymentCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeleteBlueGreenDeployment", {}).n("RDSClient", "DeleteBlueGreenDeploymentCommand").f(void 0, void 0).ser(se_DeleteBlueGreenDeploymentCommand).de(de_DeleteBlueGreenDeploymentCommand).build() {
  static {
    __name(this, "DeleteBlueGreenDeploymentCommand");
  }
};

// src/commands/DeleteCustomDBEngineVersionCommand.ts



var DeleteCustomDBEngineVersionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeleteCustomDBEngineVersion", {}).n("RDSClient", "DeleteCustomDBEngineVersionCommand").f(void 0, void 0).ser(se_DeleteCustomDBEngineVersionCommand).de(de_DeleteCustomDBEngineVersionCommand).build() {
  static {
    __name(this, "DeleteCustomDBEngineVersionCommand");
  }
};

// src/commands/DeleteDBClusterAutomatedBackupCommand.ts



var DeleteDBClusterAutomatedBackupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeleteDBClusterAutomatedBackup", {}).n("RDSClient", "DeleteDBClusterAutomatedBackupCommand").f(void 0, void 0).ser(se_DeleteDBClusterAutomatedBackupCommand).de(de_DeleteDBClusterAutomatedBackupCommand).build() {
  static {
    __name(this, "DeleteDBClusterAutomatedBackupCommand");
  }
};

// src/commands/DeleteDBClusterCommand.ts



var DeleteDBClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeleteDBCluster", {}).n("RDSClient", "DeleteDBClusterCommand").f(void 0, void 0).ser(se_DeleteDBClusterCommand).de(de_DeleteDBClusterCommand).build() {
  static {
    __name(this, "DeleteDBClusterCommand");
  }
};

// src/commands/DeleteDBClusterEndpointCommand.ts



var DeleteDBClusterEndpointCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeleteDBClusterEndpoint", {}).n("RDSClient", "DeleteDBClusterEndpointCommand").f(void 0, void 0).ser(se_DeleteDBClusterEndpointCommand).de(de_DeleteDBClusterEndpointCommand).build() {
  static {
    __name(this, "DeleteDBClusterEndpointCommand");
  }
};

// src/commands/DeleteDBClusterParameterGroupCommand.ts



var DeleteDBClusterParameterGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeleteDBClusterParameterGroup", {}).n("RDSClient", "DeleteDBClusterParameterGroupCommand").f(void 0, void 0).ser(se_DeleteDBClusterParameterGroupCommand).de(de_DeleteDBClusterParameterGroupCommand).build() {
  static {
    __name(this, "DeleteDBClusterParameterGroupCommand");
  }
};

// src/commands/DeleteDBClusterSnapshotCommand.ts



var DeleteDBClusterSnapshotCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeleteDBClusterSnapshot", {}).n("RDSClient", "DeleteDBClusterSnapshotCommand").f(void 0, void 0).ser(se_DeleteDBClusterSnapshotCommand).de(de_DeleteDBClusterSnapshotCommand).build() {
  static {
    __name(this, "DeleteDBClusterSnapshotCommand");
  }
};

// src/commands/DeleteDBInstanceAutomatedBackupCommand.ts



var DeleteDBInstanceAutomatedBackupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeleteDBInstanceAutomatedBackup", {}).n("RDSClient", "DeleteDBInstanceAutomatedBackupCommand").f(void 0, void 0).ser(se_DeleteDBInstanceAutomatedBackupCommand).de(de_DeleteDBInstanceAutomatedBackupCommand).build() {
  static {
    __name(this, "DeleteDBInstanceAutomatedBackupCommand");
  }
};

// src/commands/DeleteDBInstanceCommand.ts



var DeleteDBInstanceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeleteDBInstance", {}).n("RDSClient", "DeleteDBInstanceCommand").f(void 0, void 0).ser(se_DeleteDBInstanceCommand).de(de_DeleteDBInstanceCommand).build() {
  static {
    __name(this, "DeleteDBInstanceCommand");
  }
};

// src/commands/DeleteDBParameterGroupCommand.ts



var DeleteDBParameterGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeleteDBParameterGroup", {}).n("RDSClient", "DeleteDBParameterGroupCommand").f(void 0, void 0).ser(se_DeleteDBParameterGroupCommand).de(de_DeleteDBParameterGroupCommand).build() {
  static {
    __name(this, "DeleteDBParameterGroupCommand");
  }
};

// src/commands/DeleteDBProxyCommand.ts



var DeleteDBProxyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeleteDBProxy", {}).n("RDSClient", "DeleteDBProxyCommand").f(void 0, void 0).ser(se_DeleteDBProxyCommand).de(de_DeleteDBProxyCommand).build() {
  static {
    __name(this, "DeleteDBProxyCommand");
  }
};

// src/commands/DeleteDBProxyEndpointCommand.ts



var DeleteDBProxyEndpointCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeleteDBProxyEndpoint", {}).n("RDSClient", "DeleteDBProxyEndpointCommand").f(void 0, void 0).ser(se_DeleteDBProxyEndpointCommand).de(de_DeleteDBProxyEndpointCommand).build() {
  static {
    __name(this, "DeleteDBProxyEndpointCommand");
  }
};

// src/commands/DeleteDBSecurityGroupCommand.ts



var DeleteDBSecurityGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeleteDBSecurityGroup", {}).n("RDSClient", "DeleteDBSecurityGroupCommand").f(void 0, void 0).ser(se_DeleteDBSecurityGroupCommand).de(de_DeleteDBSecurityGroupCommand).build() {
  static {
    __name(this, "DeleteDBSecurityGroupCommand");
  }
};

// src/commands/DeleteDBShardGroupCommand.ts



var DeleteDBShardGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeleteDBShardGroup", {}).n("RDSClient", "DeleteDBShardGroupCommand").f(void 0, void 0).ser(se_DeleteDBShardGroupCommand).de(de_DeleteDBShardGroupCommand).build() {
  static {
    __name(this, "DeleteDBShardGroupCommand");
  }
};

// src/commands/DeleteDBSnapshotCommand.ts



var DeleteDBSnapshotCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeleteDBSnapshot", {}).n("RDSClient", "DeleteDBSnapshotCommand").f(void 0, void 0).ser(se_DeleteDBSnapshotCommand).de(de_DeleteDBSnapshotCommand).build() {
  static {
    __name(this, "DeleteDBSnapshotCommand");
  }
};

// src/commands/DeleteDBSubnetGroupCommand.ts



var DeleteDBSubnetGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeleteDBSubnetGroup", {}).n("RDSClient", "DeleteDBSubnetGroupCommand").f(void 0, void 0).ser(se_DeleteDBSubnetGroupCommand).de(de_DeleteDBSubnetGroupCommand).build() {
  static {
    __name(this, "DeleteDBSubnetGroupCommand");
  }
};

// src/commands/DeleteEventSubscriptionCommand.ts



var DeleteEventSubscriptionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeleteEventSubscription", {}).n("RDSClient", "DeleteEventSubscriptionCommand").f(void 0, void 0).ser(se_DeleteEventSubscriptionCommand).de(de_DeleteEventSubscriptionCommand).build() {
  static {
    __name(this, "DeleteEventSubscriptionCommand");
  }
};

// src/commands/DeleteGlobalClusterCommand.ts



var DeleteGlobalClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeleteGlobalCluster", {}).n("RDSClient", "DeleteGlobalClusterCommand").f(void 0, void 0).ser(se_DeleteGlobalClusterCommand).de(de_DeleteGlobalClusterCommand).build() {
  static {
    __name(this, "DeleteGlobalClusterCommand");
  }
};

// src/commands/DeleteIntegrationCommand.ts



var DeleteIntegrationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeleteIntegration", {}).n("RDSClient", "DeleteIntegrationCommand").f(void 0, void 0).ser(se_DeleteIntegrationCommand).de(de_DeleteIntegrationCommand).build() {
  static {
    __name(this, "DeleteIntegrationCommand");
  }
};

// src/commands/DeleteOptionGroupCommand.ts



var DeleteOptionGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeleteOptionGroup", {}).n("RDSClient", "DeleteOptionGroupCommand").f(void 0, void 0).ser(se_DeleteOptionGroupCommand).de(de_DeleteOptionGroupCommand).build() {
  static {
    __name(this, "DeleteOptionGroupCommand");
  }
};

// src/commands/DeleteTenantDatabaseCommand.ts



var DeleteTenantDatabaseCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeleteTenantDatabase", {}).n("RDSClient", "DeleteTenantDatabaseCommand").f(void 0, DeleteTenantDatabaseResultFilterSensitiveLog).ser(se_DeleteTenantDatabaseCommand).de(de_DeleteTenantDatabaseCommand).build() {
  static {
    __name(this, "DeleteTenantDatabaseCommand");
  }
};

// src/commands/DeregisterDBProxyTargetsCommand.ts



var DeregisterDBProxyTargetsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DeregisterDBProxyTargets", {}).n("RDSClient", "DeregisterDBProxyTargetsCommand").f(void 0, void 0).ser(se_DeregisterDBProxyTargetsCommand).de(de_DeregisterDBProxyTargetsCommand).build() {
  static {
    __name(this, "DeregisterDBProxyTargetsCommand");
  }
};

// src/commands/DescribeAccountAttributesCommand.ts



var DescribeAccountAttributesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeAccountAttributes", {}).n("RDSClient", "DescribeAccountAttributesCommand").f(void 0, void 0).ser(se_DescribeAccountAttributesCommand).de(de_DescribeAccountAttributesCommand).build() {
  static {
    __name(this, "DescribeAccountAttributesCommand");
  }
};

// src/commands/DescribeBlueGreenDeploymentsCommand.ts



var DescribeBlueGreenDeploymentsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeBlueGreenDeployments", {}).n("RDSClient", "DescribeBlueGreenDeploymentsCommand").f(void 0, void 0).ser(se_DescribeBlueGreenDeploymentsCommand).de(de_DescribeBlueGreenDeploymentsCommand).build() {
  static {
    __name(this, "DescribeBlueGreenDeploymentsCommand");
  }
};

// src/commands/DescribeCertificatesCommand.ts



var DescribeCertificatesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeCertificates", {}).n("RDSClient", "DescribeCertificatesCommand").f(void 0, void 0).ser(se_DescribeCertificatesCommand).de(de_DescribeCertificatesCommand).build() {
  static {
    __name(this, "DescribeCertificatesCommand");
  }
};

// src/commands/DescribeDBClusterAutomatedBackupsCommand.ts



var DescribeDBClusterAutomatedBackupsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBClusterAutomatedBackups", {}).n("RDSClient", "DescribeDBClusterAutomatedBackupsCommand").f(void 0, void 0).ser(se_DescribeDBClusterAutomatedBackupsCommand).de(de_DescribeDBClusterAutomatedBackupsCommand).build() {
  static {
    __name(this, "DescribeDBClusterAutomatedBackupsCommand");
  }
};

// src/commands/DescribeDBClusterBacktracksCommand.ts



var DescribeDBClusterBacktracksCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBClusterBacktracks", {}).n("RDSClient", "DescribeDBClusterBacktracksCommand").f(void 0, void 0).ser(se_DescribeDBClusterBacktracksCommand).de(de_DescribeDBClusterBacktracksCommand).build() {
  static {
    __name(this, "DescribeDBClusterBacktracksCommand");
  }
};

// src/commands/DescribeDBClusterEndpointsCommand.ts



var DescribeDBClusterEndpointsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBClusterEndpoints", {}).n("RDSClient", "DescribeDBClusterEndpointsCommand").f(void 0, void 0).ser(se_DescribeDBClusterEndpointsCommand).de(de_DescribeDBClusterEndpointsCommand).build() {
  static {
    __name(this, "DescribeDBClusterEndpointsCommand");
  }
};

// src/commands/DescribeDBClusterParameterGroupsCommand.ts



var DescribeDBClusterParameterGroupsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBClusterParameterGroups", {}).n("RDSClient", "DescribeDBClusterParameterGroupsCommand").f(void 0, void 0).ser(se_DescribeDBClusterParameterGroupsCommand).de(de_DescribeDBClusterParameterGroupsCommand).build() {
  static {
    __name(this, "DescribeDBClusterParameterGroupsCommand");
  }
};

// src/commands/DescribeDBClusterParametersCommand.ts



var DescribeDBClusterParametersCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBClusterParameters", {}).n("RDSClient", "DescribeDBClusterParametersCommand").f(void 0, void 0).ser(se_DescribeDBClusterParametersCommand).de(de_DescribeDBClusterParametersCommand).build() {
  static {
    __name(this, "DescribeDBClusterParametersCommand");
  }
};

// src/commands/DescribeDBClustersCommand.ts



var DescribeDBClustersCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBClusters", {}).n("RDSClient", "DescribeDBClustersCommand").f(void 0, void 0).ser(se_DescribeDBClustersCommand).de(de_DescribeDBClustersCommand).build() {
  static {
    __name(this, "DescribeDBClustersCommand");
  }
};

// src/commands/DescribeDBClusterSnapshotAttributesCommand.ts



var DescribeDBClusterSnapshotAttributesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBClusterSnapshotAttributes", {}).n("RDSClient", "DescribeDBClusterSnapshotAttributesCommand").f(void 0, void 0).ser(se_DescribeDBClusterSnapshotAttributesCommand).de(de_DescribeDBClusterSnapshotAttributesCommand).build() {
  static {
    __name(this, "DescribeDBClusterSnapshotAttributesCommand");
  }
};

// src/commands/DescribeDBClusterSnapshotsCommand.ts



var DescribeDBClusterSnapshotsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBClusterSnapshots", {}).n("RDSClient", "DescribeDBClusterSnapshotsCommand").f(void 0, void 0).ser(se_DescribeDBClusterSnapshotsCommand).de(de_DescribeDBClusterSnapshotsCommand).build() {
  static {
    __name(this, "DescribeDBClusterSnapshotsCommand");
  }
};

// src/commands/DescribeDBEngineVersionsCommand.ts



var DescribeDBEngineVersionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBEngineVersions", {}).n("RDSClient", "DescribeDBEngineVersionsCommand").f(void 0, void 0).ser(se_DescribeDBEngineVersionsCommand).de(de_DescribeDBEngineVersionsCommand).build() {
  static {
    __name(this, "DescribeDBEngineVersionsCommand");
  }
};

// src/commands/DescribeDBInstanceAutomatedBackupsCommand.ts



var DescribeDBInstanceAutomatedBackupsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBInstanceAutomatedBackups", {}).n("RDSClient", "DescribeDBInstanceAutomatedBackupsCommand").f(void 0, void 0).ser(se_DescribeDBInstanceAutomatedBackupsCommand).de(de_DescribeDBInstanceAutomatedBackupsCommand).build() {
  static {
    __name(this, "DescribeDBInstanceAutomatedBackupsCommand");
  }
};

// src/commands/DescribeDBInstancesCommand.ts



var DescribeDBInstancesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBInstances", {}).n("RDSClient", "DescribeDBInstancesCommand").f(void 0, void 0).ser(se_DescribeDBInstancesCommand).de(de_DescribeDBInstancesCommand).build() {
  static {
    __name(this, "DescribeDBInstancesCommand");
  }
};

// src/commands/DescribeDBLogFilesCommand.ts



var DescribeDBLogFilesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBLogFiles", {}).n("RDSClient", "DescribeDBLogFilesCommand").f(void 0, void 0).ser(se_DescribeDBLogFilesCommand).de(de_DescribeDBLogFilesCommand).build() {
  static {
    __name(this, "DescribeDBLogFilesCommand");
  }
};

// src/commands/DescribeDBMajorEngineVersionsCommand.ts



var DescribeDBMajorEngineVersionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBMajorEngineVersions", {}).n("RDSClient", "DescribeDBMajorEngineVersionsCommand").f(void 0, void 0).ser(se_DescribeDBMajorEngineVersionsCommand).de(de_DescribeDBMajorEngineVersionsCommand).build() {
  static {
    __name(this, "DescribeDBMajorEngineVersionsCommand");
  }
};

// src/commands/DescribeDBParameterGroupsCommand.ts



var DescribeDBParameterGroupsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBParameterGroups", {}).n("RDSClient", "DescribeDBParameterGroupsCommand").f(void 0, void 0).ser(se_DescribeDBParameterGroupsCommand).de(de_DescribeDBParameterGroupsCommand).build() {
  static {
    __name(this, "DescribeDBParameterGroupsCommand");
  }
};

// src/commands/DescribeDBParametersCommand.ts



var DescribeDBParametersCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBParameters", {}).n("RDSClient", "DescribeDBParametersCommand").f(void 0, void 0).ser(se_DescribeDBParametersCommand).de(de_DescribeDBParametersCommand).build() {
  static {
    __name(this, "DescribeDBParametersCommand");
  }
};

// src/commands/DescribeDBProxiesCommand.ts



var DescribeDBProxiesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBProxies", {}).n("RDSClient", "DescribeDBProxiesCommand").f(void 0, void 0).ser(se_DescribeDBProxiesCommand).de(de_DescribeDBProxiesCommand).build() {
  static {
    __name(this, "DescribeDBProxiesCommand");
  }
};

// src/commands/DescribeDBProxyEndpointsCommand.ts



var DescribeDBProxyEndpointsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBProxyEndpoints", {}).n("RDSClient", "DescribeDBProxyEndpointsCommand").f(void 0, void 0).ser(se_DescribeDBProxyEndpointsCommand).de(de_DescribeDBProxyEndpointsCommand).build() {
  static {
    __name(this, "DescribeDBProxyEndpointsCommand");
  }
};

// src/commands/DescribeDBProxyTargetGroupsCommand.ts



var DescribeDBProxyTargetGroupsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBProxyTargetGroups", {}).n("RDSClient", "DescribeDBProxyTargetGroupsCommand").f(void 0, void 0).ser(se_DescribeDBProxyTargetGroupsCommand).de(de_DescribeDBProxyTargetGroupsCommand).build() {
  static {
    __name(this, "DescribeDBProxyTargetGroupsCommand");
  }
};

// src/commands/DescribeDBProxyTargetsCommand.ts



var DescribeDBProxyTargetsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBProxyTargets", {}).n("RDSClient", "DescribeDBProxyTargetsCommand").f(void 0, void 0).ser(se_DescribeDBProxyTargetsCommand).de(de_DescribeDBProxyTargetsCommand).build() {
  static {
    __name(this, "DescribeDBProxyTargetsCommand");
  }
};

// src/commands/DescribeDBRecommendationsCommand.ts



var DescribeDBRecommendationsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBRecommendations", {}).n("RDSClient", "DescribeDBRecommendationsCommand").f(void 0, void 0).ser(se_DescribeDBRecommendationsCommand).de(de_DescribeDBRecommendationsCommand).build() {
  static {
    __name(this, "DescribeDBRecommendationsCommand");
  }
};

// src/commands/DescribeDBSecurityGroupsCommand.ts



var DescribeDBSecurityGroupsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBSecurityGroups", {}).n("RDSClient", "DescribeDBSecurityGroupsCommand").f(void 0, void 0).ser(se_DescribeDBSecurityGroupsCommand).de(de_DescribeDBSecurityGroupsCommand).build() {
  static {
    __name(this, "DescribeDBSecurityGroupsCommand");
  }
};

// src/commands/DescribeDBShardGroupsCommand.ts



var DescribeDBShardGroupsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBShardGroups", {}).n("RDSClient", "DescribeDBShardGroupsCommand").f(void 0, void 0).ser(se_DescribeDBShardGroupsCommand).de(de_DescribeDBShardGroupsCommand).build() {
  static {
    __name(this, "DescribeDBShardGroupsCommand");
  }
};

// src/commands/DescribeDBSnapshotAttributesCommand.ts



var DescribeDBSnapshotAttributesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBSnapshotAttributes", {}).n("RDSClient", "DescribeDBSnapshotAttributesCommand").f(void 0, void 0).ser(se_DescribeDBSnapshotAttributesCommand).de(de_DescribeDBSnapshotAttributesCommand).build() {
  static {
    __name(this, "DescribeDBSnapshotAttributesCommand");
  }
};

// src/commands/DescribeDBSnapshotsCommand.ts



var DescribeDBSnapshotsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBSnapshots", {}).n("RDSClient", "DescribeDBSnapshotsCommand").f(void 0, void 0).ser(se_DescribeDBSnapshotsCommand).de(de_DescribeDBSnapshotsCommand).build() {
  static {
    __name(this, "DescribeDBSnapshotsCommand");
  }
};

// src/commands/DescribeDBSnapshotTenantDatabasesCommand.ts



var DescribeDBSnapshotTenantDatabasesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBSnapshotTenantDatabases", {}).n("RDSClient", "DescribeDBSnapshotTenantDatabasesCommand").f(void 0, void 0).ser(se_DescribeDBSnapshotTenantDatabasesCommand).de(de_DescribeDBSnapshotTenantDatabasesCommand).build() {
  static {
    __name(this, "DescribeDBSnapshotTenantDatabasesCommand");
  }
};

// src/commands/DescribeDBSubnetGroupsCommand.ts



var DescribeDBSubnetGroupsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeDBSubnetGroups", {}).n("RDSClient", "DescribeDBSubnetGroupsCommand").f(void 0, void 0).ser(se_DescribeDBSubnetGroupsCommand).de(de_DescribeDBSubnetGroupsCommand).build() {
  static {
    __name(this, "DescribeDBSubnetGroupsCommand");
  }
};

// src/commands/DescribeEngineDefaultClusterParametersCommand.ts



var DescribeEngineDefaultClusterParametersCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeEngineDefaultClusterParameters", {}).n("RDSClient", "DescribeEngineDefaultClusterParametersCommand").f(void 0, void 0).ser(se_DescribeEngineDefaultClusterParametersCommand).de(de_DescribeEngineDefaultClusterParametersCommand).build() {
  static {
    __name(this, "DescribeEngineDefaultClusterParametersCommand");
  }
};

// src/commands/DescribeEngineDefaultParametersCommand.ts



var DescribeEngineDefaultParametersCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeEngineDefaultParameters", {}).n("RDSClient", "DescribeEngineDefaultParametersCommand").f(void 0, void 0).ser(se_DescribeEngineDefaultParametersCommand).de(de_DescribeEngineDefaultParametersCommand).build() {
  static {
    __name(this, "DescribeEngineDefaultParametersCommand");
  }
};

// src/commands/DescribeEventCategoriesCommand.ts



var DescribeEventCategoriesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeEventCategories", {}).n("RDSClient", "DescribeEventCategoriesCommand").f(void 0, void 0).ser(se_DescribeEventCategoriesCommand).de(de_DescribeEventCategoriesCommand).build() {
  static {
    __name(this, "DescribeEventCategoriesCommand");
  }
};

// src/commands/DescribeEventsCommand.ts



var DescribeEventsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeEvents", {}).n("RDSClient", "DescribeEventsCommand").f(void 0, void 0).ser(se_DescribeEventsCommand).de(de_DescribeEventsCommand).build() {
  static {
    __name(this, "DescribeEventsCommand");
  }
};

// src/commands/DescribeEventSubscriptionsCommand.ts



var DescribeEventSubscriptionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeEventSubscriptions", {}).n("RDSClient", "DescribeEventSubscriptionsCommand").f(void 0, void 0).ser(se_DescribeEventSubscriptionsCommand).de(de_DescribeEventSubscriptionsCommand).build() {
  static {
    __name(this, "DescribeEventSubscriptionsCommand");
  }
};

// src/commands/DescribeExportTasksCommand.ts



var DescribeExportTasksCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeExportTasks", {}).n("RDSClient", "DescribeExportTasksCommand").f(void 0, void 0).ser(se_DescribeExportTasksCommand).de(de_DescribeExportTasksCommand).build() {
  static {
    __name(this, "DescribeExportTasksCommand");
  }
};

// src/commands/DescribeGlobalClustersCommand.ts



var DescribeGlobalClustersCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeGlobalClusters", {}).n("RDSClient", "DescribeGlobalClustersCommand").f(void 0, void 0).ser(se_DescribeGlobalClustersCommand).de(de_DescribeGlobalClustersCommand).build() {
  static {
    __name(this, "DescribeGlobalClustersCommand");
  }
};

// src/commands/DescribeIntegrationsCommand.ts



var DescribeIntegrationsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeIntegrations", {}).n("RDSClient", "DescribeIntegrationsCommand").f(void 0, void 0).ser(se_DescribeIntegrationsCommand).de(de_DescribeIntegrationsCommand).build() {
  static {
    __name(this, "DescribeIntegrationsCommand");
  }
};

// src/commands/DescribeOptionGroupOptionsCommand.ts



var DescribeOptionGroupOptionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeOptionGroupOptions", {}).n("RDSClient", "DescribeOptionGroupOptionsCommand").f(void 0, void 0).ser(se_DescribeOptionGroupOptionsCommand).de(de_DescribeOptionGroupOptionsCommand).build() {
  static {
    __name(this, "DescribeOptionGroupOptionsCommand");
  }
};

// src/commands/DescribeOptionGroupsCommand.ts



var DescribeOptionGroupsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeOptionGroups", {}).n("RDSClient", "DescribeOptionGroupsCommand").f(void 0, void 0).ser(se_DescribeOptionGroupsCommand).de(de_DescribeOptionGroupsCommand).build() {
  static {
    __name(this, "DescribeOptionGroupsCommand");
  }
};

// src/commands/DescribeOrderableDBInstanceOptionsCommand.ts



var DescribeOrderableDBInstanceOptionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeOrderableDBInstanceOptions", {}).n("RDSClient", "DescribeOrderableDBInstanceOptionsCommand").f(void 0, void 0).ser(se_DescribeOrderableDBInstanceOptionsCommand).de(de_DescribeOrderableDBInstanceOptionsCommand).build() {
  static {
    __name(this, "DescribeOrderableDBInstanceOptionsCommand");
  }
};

// src/commands/DescribePendingMaintenanceActionsCommand.ts



var DescribePendingMaintenanceActionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribePendingMaintenanceActions", {}).n("RDSClient", "DescribePendingMaintenanceActionsCommand").f(void 0, void 0).ser(se_DescribePendingMaintenanceActionsCommand).de(de_DescribePendingMaintenanceActionsCommand).build() {
  static {
    __name(this, "DescribePendingMaintenanceActionsCommand");
  }
};

// src/commands/DescribeReservedDBInstancesCommand.ts



var DescribeReservedDBInstancesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeReservedDBInstances", {}).n("RDSClient", "DescribeReservedDBInstancesCommand").f(void 0, void 0).ser(se_DescribeReservedDBInstancesCommand).de(de_DescribeReservedDBInstancesCommand).build() {
  static {
    __name(this, "DescribeReservedDBInstancesCommand");
  }
};

// src/commands/DescribeReservedDBInstancesOfferingsCommand.ts



var DescribeReservedDBInstancesOfferingsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeReservedDBInstancesOfferings", {}).n("RDSClient", "DescribeReservedDBInstancesOfferingsCommand").f(void 0, void 0).ser(se_DescribeReservedDBInstancesOfferingsCommand).de(de_DescribeReservedDBInstancesOfferingsCommand).build() {
  static {
    __name(this, "DescribeReservedDBInstancesOfferingsCommand");
  }
};

// src/commands/DescribeSourceRegionsCommand.ts



var DescribeSourceRegionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeSourceRegions", {}).n("RDSClient", "DescribeSourceRegionsCommand").f(void 0, void 0).ser(se_DescribeSourceRegionsCommand).de(de_DescribeSourceRegionsCommand).build() {
  static {
    __name(this, "DescribeSourceRegionsCommand");
  }
};

// src/commands/DescribeTenantDatabasesCommand.ts



var DescribeTenantDatabasesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeTenantDatabases", {}).n("RDSClient", "DescribeTenantDatabasesCommand").f(void 0, TenantDatabasesMessageFilterSensitiveLog).ser(se_DescribeTenantDatabasesCommand).de(de_DescribeTenantDatabasesCommand).build() {
  static {
    __name(this, "DescribeTenantDatabasesCommand");
  }
};

// src/commands/DescribeValidDBInstanceModificationsCommand.ts



var DescribeValidDBInstanceModificationsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DescribeValidDBInstanceModifications", {}).n("RDSClient", "DescribeValidDBInstanceModificationsCommand").f(void 0, void 0).ser(se_DescribeValidDBInstanceModificationsCommand).de(de_DescribeValidDBInstanceModificationsCommand).build() {
  static {
    __name(this, "DescribeValidDBInstanceModificationsCommand");
  }
};

// src/commands/DisableHttpEndpointCommand.ts



var DisableHttpEndpointCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DisableHttpEndpoint", {}).n("RDSClient", "DisableHttpEndpointCommand").f(void 0, void 0).ser(se_DisableHttpEndpointCommand).de(de_DisableHttpEndpointCommand).build() {
  static {
    __name(this, "DisableHttpEndpointCommand");
  }
};

// src/commands/DownloadDBLogFilePortionCommand.ts



var DownloadDBLogFilePortionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "DownloadDBLogFilePortion", {}).n("RDSClient", "DownloadDBLogFilePortionCommand").f(void 0, void 0).ser(se_DownloadDBLogFilePortionCommand).de(de_DownloadDBLogFilePortionCommand).build() {
  static {
    __name(this, "DownloadDBLogFilePortionCommand");
  }
};

// src/commands/EnableHttpEndpointCommand.ts



var EnableHttpEndpointCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "EnableHttpEndpoint", {}).n("RDSClient", "EnableHttpEndpointCommand").f(void 0, void 0).ser(se_EnableHttpEndpointCommand).de(de_EnableHttpEndpointCommand).build() {
  static {
    __name(this, "EnableHttpEndpointCommand");
  }
};

// src/commands/FailoverDBClusterCommand.ts



var FailoverDBClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "FailoverDBCluster", {}).n("RDSClient", "FailoverDBClusterCommand").f(void 0, void 0).ser(se_FailoverDBClusterCommand).de(de_FailoverDBClusterCommand).build() {
  static {
    __name(this, "FailoverDBClusterCommand");
  }
};

// src/commands/FailoverGlobalClusterCommand.ts



var FailoverGlobalClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "FailoverGlobalCluster", {}).n("RDSClient", "FailoverGlobalClusterCommand").f(void 0, void 0).ser(se_FailoverGlobalClusterCommand).de(de_FailoverGlobalClusterCommand).build() {
  static {
    __name(this, "FailoverGlobalClusterCommand");
  }
};

// src/commands/ListTagsForResourceCommand.ts



var ListTagsForResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ListTagsForResource", {}).n("RDSClient", "ListTagsForResourceCommand").f(void 0, void 0).ser(se_ListTagsForResourceCommand).de(de_ListTagsForResourceCommand).build() {
  static {
    __name(this, "ListTagsForResourceCommand");
  }
};

// src/commands/ModifyActivityStreamCommand.ts



var ModifyActivityStreamCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyActivityStream", {}).n("RDSClient", "ModifyActivityStreamCommand").f(void 0, void 0).ser(se_ModifyActivityStreamCommand).de(de_ModifyActivityStreamCommand).build() {
  static {
    __name(this, "ModifyActivityStreamCommand");
  }
};

// src/commands/ModifyCertificatesCommand.ts



var ModifyCertificatesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyCertificates", {}).n("RDSClient", "ModifyCertificatesCommand").f(void 0, void 0).ser(se_ModifyCertificatesCommand).de(de_ModifyCertificatesCommand).build() {
  static {
    __name(this, "ModifyCertificatesCommand");
  }
};

// src/commands/ModifyCurrentDBClusterCapacityCommand.ts



var ModifyCurrentDBClusterCapacityCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyCurrentDBClusterCapacity", {}).n("RDSClient", "ModifyCurrentDBClusterCapacityCommand").f(void 0, void 0).ser(se_ModifyCurrentDBClusterCapacityCommand).de(de_ModifyCurrentDBClusterCapacityCommand).build() {
  static {
    __name(this, "ModifyCurrentDBClusterCapacityCommand");
  }
};

// src/commands/ModifyCustomDBEngineVersionCommand.ts



var ModifyCustomDBEngineVersionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyCustomDBEngineVersion", {}).n("RDSClient", "ModifyCustomDBEngineVersionCommand").f(void 0, void 0).ser(se_ModifyCustomDBEngineVersionCommand).de(de_ModifyCustomDBEngineVersionCommand).build() {
  static {
    __name(this, "ModifyCustomDBEngineVersionCommand");
  }
};

// src/commands/ModifyDBClusterCommand.ts



var ModifyDBClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyDBCluster", {}).n("RDSClient", "ModifyDBClusterCommand").f(void 0, void 0).ser(se_ModifyDBClusterCommand).de(de_ModifyDBClusterCommand).build() {
  static {
    __name(this, "ModifyDBClusterCommand");
  }
};

// src/commands/ModifyDBClusterEndpointCommand.ts



var ModifyDBClusterEndpointCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyDBClusterEndpoint", {}).n("RDSClient", "ModifyDBClusterEndpointCommand").f(void 0, void 0).ser(se_ModifyDBClusterEndpointCommand).de(de_ModifyDBClusterEndpointCommand).build() {
  static {
    __name(this, "ModifyDBClusterEndpointCommand");
  }
};

// src/commands/ModifyDBClusterParameterGroupCommand.ts



var ModifyDBClusterParameterGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyDBClusterParameterGroup", {}).n("RDSClient", "ModifyDBClusterParameterGroupCommand").f(void 0, void 0).ser(se_ModifyDBClusterParameterGroupCommand).de(de_ModifyDBClusterParameterGroupCommand).build() {
  static {
    __name(this, "ModifyDBClusterParameterGroupCommand");
  }
};

// src/commands/ModifyDBClusterSnapshotAttributeCommand.ts



var ModifyDBClusterSnapshotAttributeCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyDBClusterSnapshotAttribute", {}).n("RDSClient", "ModifyDBClusterSnapshotAttributeCommand").f(void 0, void 0).ser(se_ModifyDBClusterSnapshotAttributeCommand).de(de_ModifyDBClusterSnapshotAttributeCommand).build() {
  static {
    __name(this, "ModifyDBClusterSnapshotAttributeCommand");
  }
};

// src/commands/ModifyDBInstanceCommand.ts



var ModifyDBInstanceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyDBInstance", {}).n("RDSClient", "ModifyDBInstanceCommand").f(void 0, void 0).ser(se_ModifyDBInstanceCommand).de(de_ModifyDBInstanceCommand).build() {
  static {
    __name(this, "ModifyDBInstanceCommand");
  }
};

// src/commands/ModifyDBParameterGroupCommand.ts



var ModifyDBParameterGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyDBParameterGroup", {}).n("RDSClient", "ModifyDBParameterGroupCommand").f(void 0, void 0).ser(se_ModifyDBParameterGroupCommand).de(de_ModifyDBParameterGroupCommand).build() {
  static {
    __name(this, "ModifyDBParameterGroupCommand");
  }
};

// src/commands/ModifyDBProxyCommand.ts



var ModifyDBProxyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyDBProxy", {}).n("RDSClient", "ModifyDBProxyCommand").f(void 0, void 0).ser(se_ModifyDBProxyCommand).de(de_ModifyDBProxyCommand).build() {
  static {
    __name(this, "ModifyDBProxyCommand");
  }
};

// src/commands/ModifyDBProxyEndpointCommand.ts



var ModifyDBProxyEndpointCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyDBProxyEndpoint", {}).n("RDSClient", "ModifyDBProxyEndpointCommand").f(void 0, void 0).ser(se_ModifyDBProxyEndpointCommand).de(de_ModifyDBProxyEndpointCommand).build() {
  static {
    __name(this, "ModifyDBProxyEndpointCommand");
  }
};

// src/commands/ModifyDBProxyTargetGroupCommand.ts



var ModifyDBProxyTargetGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyDBProxyTargetGroup", {}).n("RDSClient", "ModifyDBProxyTargetGroupCommand").f(void 0, void 0).ser(se_ModifyDBProxyTargetGroupCommand).de(de_ModifyDBProxyTargetGroupCommand).build() {
  static {
    __name(this, "ModifyDBProxyTargetGroupCommand");
  }
};

// src/commands/ModifyDBRecommendationCommand.ts



var ModifyDBRecommendationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyDBRecommendation", {}).n("RDSClient", "ModifyDBRecommendationCommand").f(void 0, void 0).ser(se_ModifyDBRecommendationCommand).de(de_ModifyDBRecommendationCommand).build() {
  static {
    __name(this, "ModifyDBRecommendationCommand");
  }
};

// src/commands/ModifyDBShardGroupCommand.ts



var ModifyDBShardGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyDBShardGroup", {}).n("RDSClient", "ModifyDBShardGroupCommand").f(void 0, void 0).ser(se_ModifyDBShardGroupCommand).de(de_ModifyDBShardGroupCommand).build() {
  static {
    __name(this, "ModifyDBShardGroupCommand");
  }
};

// src/commands/ModifyDBSnapshotAttributeCommand.ts



var ModifyDBSnapshotAttributeCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyDBSnapshotAttribute", {}).n("RDSClient", "ModifyDBSnapshotAttributeCommand").f(void 0, void 0).ser(se_ModifyDBSnapshotAttributeCommand).de(de_ModifyDBSnapshotAttributeCommand).build() {
  static {
    __name(this, "ModifyDBSnapshotAttributeCommand");
  }
};

// src/commands/ModifyDBSnapshotCommand.ts



var ModifyDBSnapshotCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyDBSnapshot", {}).n("RDSClient", "ModifyDBSnapshotCommand").f(void 0, void 0).ser(se_ModifyDBSnapshotCommand).de(de_ModifyDBSnapshotCommand).build() {
  static {
    __name(this, "ModifyDBSnapshotCommand");
  }
};

// src/commands/ModifyDBSubnetGroupCommand.ts



var ModifyDBSubnetGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyDBSubnetGroup", {}).n("RDSClient", "ModifyDBSubnetGroupCommand").f(void 0, void 0).ser(se_ModifyDBSubnetGroupCommand).de(de_ModifyDBSubnetGroupCommand).build() {
  static {
    __name(this, "ModifyDBSubnetGroupCommand");
  }
};

// src/commands/ModifyEventSubscriptionCommand.ts



var ModifyEventSubscriptionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyEventSubscription", {}).n("RDSClient", "ModifyEventSubscriptionCommand").f(void 0, void 0).ser(se_ModifyEventSubscriptionCommand).de(de_ModifyEventSubscriptionCommand).build() {
  static {
    __name(this, "ModifyEventSubscriptionCommand");
  }
};

// src/commands/ModifyGlobalClusterCommand.ts



var ModifyGlobalClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyGlobalCluster", {}).n("RDSClient", "ModifyGlobalClusterCommand").f(void 0, void 0).ser(se_ModifyGlobalClusterCommand).de(de_ModifyGlobalClusterCommand).build() {
  static {
    __name(this, "ModifyGlobalClusterCommand");
  }
};

// src/commands/ModifyIntegrationCommand.ts



var ModifyIntegrationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyIntegration", {}).n("RDSClient", "ModifyIntegrationCommand").f(void 0, void 0).ser(se_ModifyIntegrationCommand).de(de_ModifyIntegrationCommand).build() {
  static {
    __name(this, "ModifyIntegrationCommand");
  }
};

// src/commands/ModifyOptionGroupCommand.ts



var ModifyOptionGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyOptionGroup", {}).n("RDSClient", "ModifyOptionGroupCommand").f(void 0, void 0).ser(se_ModifyOptionGroupCommand).de(de_ModifyOptionGroupCommand).build() {
  static {
    __name(this, "ModifyOptionGroupCommand");
  }
};

// src/commands/ModifyTenantDatabaseCommand.ts



var ModifyTenantDatabaseCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ModifyTenantDatabase", {}).n("RDSClient", "ModifyTenantDatabaseCommand").f(ModifyTenantDatabaseMessageFilterSensitiveLog, ModifyTenantDatabaseResultFilterSensitiveLog).ser(se_ModifyTenantDatabaseCommand).de(de_ModifyTenantDatabaseCommand).build() {
  static {
    __name(this, "ModifyTenantDatabaseCommand");
  }
};

// src/commands/PromoteReadReplicaCommand.ts



var PromoteReadReplicaCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "PromoteReadReplica", {}).n("RDSClient", "PromoteReadReplicaCommand").f(void 0, void 0).ser(se_PromoteReadReplicaCommand).de(de_PromoteReadReplicaCommand).build() {
  static {
    __name(this, "PromoteReadReplicaCommand");
  }
};

// src/commands/PromoteReadReplicaDBClusterCommand.ts



var PromoteReadReplicaDBClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "PromoteReadReplicaDBCluster", {}).n("RDSClient", "PromoteReadReplicaDBClusterCommand").f(void 0, void 0).ser(se_PromoteReadReplicaDBClusterCommand).de(de_PromoteReadReplicaDBClusterCommand).build() {
  static {
    __name(this, "PromoteReadReplicaDBClusterCommand");
  }
};

// src/commands/PurchaseReservedDBInstancesOfferingCommand.ts



var PurchaseReservedDBInstancesOfferingCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "PurchaseReservedDBInstancesOffering", {}).n("RDSClient", "PurchaseReservedDBInstancesOfferingCommand").f(void 0, void 0).ser(se_PurchaseReservedDBInstancesOfferingCommand).de(de_PurchaseReservedDBInstancesOfferingCommand).build() {
  static {
    __name(this, "PurchaseReservedDBInstancesOfferingCommand");
  }
};

// src/commands/RebootDBClusterCommand.ts



var RebootDBClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "RebootDBCluster", {}).n("RDSClient", "RebootDBClusterCommand").f(void 0, void 0).ser(se_RebootDBClusterCommand).de(de_RebootDBClusterCommand).build() {
  static {
    __name(this, "RebootDBClusterCommand");
  }
};

// src/commands/RebootDBInstanceCommand.ts



var RebootDBInstanceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "RebootDBInstance", {}).n("RDSClient", "RebootDBInstanceCommand").f(void 0, void 0).ser(se_RebootDBInstanceCommand).de(de_RebootDBInstanceCommand).build() {
  static {
    __name(this, "RebootDBInstanceCommand");
  }
};

// src/commands/RebootDBShardGroupCommand.ts



var RebootDBShardGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "RebootDBShardGroup", {}).n("RDSClient", "RebootDBShardGroupCommand").f(void 0, void 0).ser(se_RebootDBShardGroupCommand).de(de_RebootDBShardGroupCommand).build() {
  static {
    __name(this, "RebootDBShardGroupCommand");
  }
};

// src/commands/RegisterDBProxyTargetsCommand.ts



var RegisterDBProxyTargetsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "RegisterDBProxyTargets", {}).n("RDSClient", "RegisterDBProxyTargetsCommand").f(void 0, void 0).ser(se_RegisterDBProxyTargetsCommand).de(de_RegisterDBProxyTargetsCommand).build() {
  static {
    __name(this, "RegisterDBProxyTargetsCommand");
  }
};

// src/commands/RemoveFromGlobalClusterCommand.ts



var RemoveFromGlobalClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "RemoveFromGlobalCluster", {}).n("RDSClient", "RemoveFromGlobalClusterCommand").f(void 0, void 0).ser(se_RemoveFromGlobalClusterCommand).de(de_RemoveFromGlobalClusterCommand).build() {
  static {
    __name(this, "RemoveFromGlobalClusterCommand");
  }
};

// src/commands/RemoveRoleFromDBClusterCommand.ts



var RemoveRoleFromDBClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "RemoveRoleFromDBCluster", {}).n("RDSClient", "RemoveRoleFromDBClusterCommand").f(void 0, void 0).ser(se_RemoveRoleFromDBClusterCommand).de(de_RemoveRoleFromDBClusterCommand).build() {
  static {
    __name(this, "RemoveRoleFromDBClusterCommand");
  }
};

// src/commands/RemoveRoleFromDBInstanceCommand.ts



var RemoveRoleFromDBInstanceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "RemoveRoleFromDBInstance", {}).n("RDSClient", "RemoveRoleFromDBInstanceCommand").f(void 0, void 0).ser(se_RemoveRoleFromDBInstanceCommand).de(de_RemoveRoleFromDBInstanceCommand).build() {
  static {
    __name(this, "RemoveRoleFromDBInstanceCommand");
  }
};

// src/commands/RemoveSourceIdentifierFromSubscriptionCommand.ts



var RemoveSourceIdentifierFromSubscriptionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "RemoveSourceIdentifierFromSubscription", {}).n("RDSClient", "RemoveSourceIdentifierFromSubscriptionCommand").f(void 0, void 0).ser(se_RemoveSourceIdentifierFromSubscriptionCommand).de(de_RemoveSourceIdentifierFromSubscriptionCommand).build() {
  static {
    __name(this, "RemoveSourceIdentifierFromSubscriptionCommand");
  }
};

// src/commands/RemoveTagsFromResourceCommand.ts



var RemoveTagsFromResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "RemoveTagsFromResource", {}).n("RDSClient", "RemoveTagsFromResourceCommand").f(void 0, void 0).ser(se_RemoveTagsFromResourceCommand).de(de_RemoveTagsFromResourceCommand).build() {
  static {
    __name(this, "RemoveTagsFromResourceCommand");
  }
};

// src/commands/ResetDBClusterParameterGroupCommand.ts



var ResetDBClusterParameterGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ResetDBClusterParameterGroup", {}).n("RDSClient", "ResetDBClusterParameterGroupCommand").f(void 0, void 0).ser(se_ResetDBClusterParameterGroupCommand).de(de_ResetDBClusterParameterGroupCommand).build() {
  static {
    __name(this, "ResetDBClusterParameterGroupCommand");
  }
};

// src/commands/ResetDBParameterGroupCommand.ts



var ResetDBParameterGroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "ResetDBParameterGroup", {}).n("RDSClient", "ResetDBParameterGroupCommand").f(void 0, void 0).ser(se_ResetDBParameterGroupCommand).de(de_ResetDBParameterGroupCommand).build() {
  static {
    __name(this, "ResetDBParameterGroupCommand");
  }
};

// src/commands/RestoreDBClusterFromS3Command.ts



var RestoreDBClusterFromS3Command = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "RestoreDBClusterFromS3", {}).n("RDSClient", "RestoreDBClusterFromS3Command").f(void 0, void 0).ser(se_RestoreDBClusterFromS3Command).de(de_RestoreDBClusterFromS3Command).build() {
  static {
    __name(this, "RestoreDBClusterFromS3Command");
  }
};

// src/commands/RestoreDBClusterFromSnapshotCommand.ts



var RestoreDBClusterFromSnapshotCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "RestoreDBClusterFromSnapshot", {}).n("RDSClient", "RestoreDBClusterFromSnapshotCommand").f(void 0, void 0).ser(se_RestoreDBClusterFromSnapshotCommand).de(de_RestoreDBClusterFromSnapshotCommand).build() {
  static {
    __name(this, "RestoreDBClusterFromSnapshotCommand");
  }
};

// src/commands/RestoreDBClusterToPointInTimeCommand.ts



var RestoreDBClusterToPointInTimeCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "RestoreDBClusterToPointInTime", {}).n("RDSClient", "RestoreDBClusterToPointInTimeCommand").f(void 0, void 0).ser(se_RestoreDBClusterToPointInTimeCommand).de(de_RestoreDBClusterToPointInTimeCommand).build() {
  static {
    __name(this, "RestoreDBClusterToPointInTimeCommand");
  }
};

// src/commands/RestoreDBInstanceFromDBSnapshotCommand.ts



var RestoreDBInstanceFromDBSnapshotCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "RestoreDBInstanceFromDBSnapshot", {}).n("RDSClient", "RestoreDBInstanceFromDBSnapshotCommand").f(void 0, void 0).ser(se_RestoreDBInstanceFromDBSnapshotCommand).de(de_RestoreDBInstanceFromDBSnapshotCommand).build() {
  static {
    __name(this, "RestoreDBInstanceFromDBSnapshotCommand");
  }
};

// src/commands/RestoreDBInstanceFromS3Command.ts



var RestoreDBInstanceFromS3Command = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "RestoreDBInstanceFromS3", {}).n("RDSClient", "RestoreDBInstanceFromS3Command").f(void 0, void 0).ser(se_RestoreDBInstanceFromS3Command).de(de_RestoreDBInstanceFromS3Command).build() {
  static {
    __name(this, "RestoreDBInstanceFromS3Command");
  }
};

// src/commands/RestoreDBInstanceToPointInTimeCommand.ts



var RestoreDBInstanceToPointInTimeCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "RestoreDBInstanceToPointInTime", {}).n("RDSClient", "RestoreDBInstanceToPointInTimeCommand").f(void 0, void 0).ser(se_RestoreDBInstanceToPointInTimeCommand).de(de_RestoreDBInstanceToPointInTimeCommand).build() {
  static {
    __name(this, "RestoreDBInstanceToPointInTimeCommand");
  }
};

// src/commands/RevokeDBSecurityGroupIngressCommand.ts



var RevokeDBSecurityGroupIngressCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "RevokeDBSecurityGroupIngress", {}).n("RDSClient", "RevokeDBSecurityGroupIngressCommand").f(void 0, void 0).ser(se_RevokeDBSecurityGroupIngressCommand).de(de_RevokeDBSecurityGroupIngressCommand).build() {
  static {
    __name(this, "RevokeDBSecurityGroupIngressCommand");
  }
};

// src/commands/StartActivityStreamCommand.ts



var StartActivityStreamCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "StartActivityStream", {}).n("RDSClient", "StartActivityStreamCommand").f(void 0, void 0).ser(se_StartActivityStreamCommand).de(de_StartActivityStreamCommand).build() {
  static {
    __name(this, "StartActivityStreamCommand");
  }
};

// src/commands/StartDBClusterCommand.ts



var StartDBClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "StartDBCluster", {}).n("RDSClient", "StartDBClusterCommand").f(void 0, void 0).ser(se_StartDBClusterCommand).de(de_StartDBClusterCommand).build() {
  static {
    __name(this, "StartDBClusterCommand");
  }
};

// src/commands/StartDBInstanceAutomatedBackupsReplicationCommand.ts




var StartDBInstanceAutomatedBackupsReplicationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions()),
    (0, import_middleware_sdk_rds.getCrossRegionPresignedUrlPlugin)(config)
  ];
}).s("AmazonRDSv19", "StartDBInstanceAutomatedBackupsReplication", {}).n("RDSClient", "StartDBInstanceAutomatedBackupsReplicationCommand").f(void 0, void 0).ser(se_StartDBInstanceAutomatedBackupsReplicationCommand).de(de_StartDBInstanceAutomatedBackupsReplicationCommand).build() {
  static {
    __name(this, "StartDBInstanceAutomatedBackupsReplicationCommand");
  }
};

// src/commands/StartDBInstanceCommand.ts



var StartDBInstanceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "StartDBInstance", {}).n("RDSClient", "StartDBInstanceCommand").f(void 0, void 0).ser(se_StartDBInstanceCommand).de(de_StartDBInstanceCommand).build() {
  static {
    __name(this, "StartDBInstanceCommand");
  }
};

// src/commands/StartExportTaskCommand.ts



var StartExportTaskCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "StartExportTask", {}).n("RDSClient", "StartExportTaskCommand").f(void 0, void 0).ser(se_StartExportTaskCommand).de(de_StartExportTaskCommand).build() {
  static {
    __name(this, "StartExportTaskCommand");
  }
};

// src/commands/StopActivityStreamCommand.ts



var StopActivityStreamCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "StopActivityStream", {}).n("RDSClient", "StopActivityStreamCommand").f(void 0, void 0).ser(se_StopActivityStreamCommand).de(de_StopActivityStreamCommand).build() {
  static {
    __name(this, "StopActivityStreamCommand");
  }
};

// src/commands/StopDBClusterCommand.ts



var StopDBClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "StopDBCluster", {}).n("RDSClient", "StopDBClusterCommand").f(void 0, void 0).ser(se_StopDBClusterCommand).de(de_StopDBClusterCommand).build() {
  static {
    __name(this, "StopDBClusterCommand");
  }
};

// src/commands/StopDBInstanceAutomatedBackupsReplicationCommand.ts



var StopDBInstanceAutomatedBackupsReplicationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "StopDBInstanceAutomatedBackupsReplication", {}).n("RDSClient", "StopDBInstanceAutomatedBackupsReplicationCommand").f(void 0, void 0).ser(se_StopDBInstanceAutomatedBackupsReplicationCommand).de(de_StopDBInstanceAutomatedBackupsReplicationCommand).build() {
  static {
    __name(this, "StopDBInstanceAutomatedBackupsReplicationCommand");
  }
};

// src/commands/StopDBInstanceCommand.ts



var StopDBInstanceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "StopDBInstance", {}).n("RDSClient", "StopDBInstanceCommand").f(void 0, void 0).ser(se_StopDBInstanceCommand).de(de_StopDBInstanceCommand).build() {
  static {
    __name(this, "StopDBInstanceCommand");
  }
};

// src/commands/SwitchoverBlueGreenDeploymentCommand.ts



var SwitchoverBlueGreenDeploymentCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "SwitchoverBlueGreenDeployment", {}).n("RDSClient", "SwitchoverBlueGreenDeploymentCommand").f(void 0, void 0).ser(se_SwitchoverBlueGreenDeploymentCommand).de(de_SwitchoverBlueGreenDeploymentCommand).build() {
  static {
    __name(this, "SwitchoverBlueGreenDeploymentCommand");
  }
};

// src/commands/SwitchoverGlobalClusterCommand.ts



var SwitchoverGlobalClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "SwitchoverGlobalCluster", {}).n("RDSClient", "SwitchoverGlobalClusterCommand").f(void 0, void 0).ser(se_SwitchoverGlobalClusterCommand).de(de_SwitchoverGlobalClusterCommand).build() {
  static {
    __name(this, "SwitchoverGlobalClusterCommand");
  }
};

// src/commands/SwitchoverReadReplicaCommand.ts



var SwitchoverReadReplicaCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AmazonRDSv19", "SwitchoverReadReplica", {}).n("RDSClient", "SwitchoverReadReplicaCommand").f(void 0, void 0).ser(se_SwitchoverReadReplicaCommand).de(de_SwitchoverReadReplicaCommand).build() {
  static {
    __name(this, "SwitchoverReadReplicaCommand");
  }
};

// src/RDS.ts
var commands = {
  AddRoleToDBClusterCommand,
  AddRoleToDBInstanceCommand,
  AddSourceIdentifierToSubscriptionCommand,
  AddTagsToResourceCommand,
  ApplyPendingMaintenanceActionCommand,
  AuthorizeDBSecurityGroupIngressCommand,
  BacktrackDBClusterCommand,
  CancelExportTaskCommand,
  CopyDBClusterParameterGroupCommand,
  CopyDBClusterSnapshotCommand,
  CopyDBParameterGroupCommand,
  CopyDBSnapshotCommand,
  CopyOptionGroupCommand,
  CreateBlueGreenDeploymentCommand,
  CreateCustomDBEngineVersionCommand,
  CreateDBClusterCommand,
  CreateDBClusterEndpointCommand,
  CreateDBClusterParameterGroupCommand,
  CreateDBClusterSnapshotCommand,
  CreateDBInstanceCommand,
  CreateDBInstanceReadReplicaCommand,
  CreateDBParameterGroupCommand,
  CreateDBProxyCommand,
  CreateDBProxyEndpointCommand,
  CreateDBSecurityGroupCommand,
  CreateDBShardGroupCommand,
  CreateDBSnapshotCommand,
  CreateDBSubnetGroupCommand,
  CreateEventSubscriptionCommand,
  CreateGlobalClusterCommand,
  CreateIntegrationCommand,
  CreateOptionGroupCommand,
  CreateTenantDatabaseCommand,
  DeleteBlueGreenDeploymentCommand,
  DeleteCustomDBEngineVersionCommand,
  DeleteDBClusterCommand,
  DeleteDBClusterAutomatedBackupCommand,
  DeleteDBClusterEndpointCommand,
  DeleteDBClusterParameterGroupCommand,
  DeleteDBClusterSnapshotCommand,
  DeleteDBInstanceCommand,
  DeleteDBInstanceAutomatedBackupCommand,
  DeleteDBParameterGroupCommand,
  DeleteDBProxyCommand,
  DeleteDBProxyEndpointCommand,
  DeleteDBSecurityGroupCommand,
  DeleteDBShardGroupCommand,
  DeleteDBSnapshotCommand,
  DeleteDBSubnetGroupCommand,
  DeleteEventSubscriptionCommand,
  DeleteGlobalClusterCommand,
  DeleteIntegrationCommand,
  DeleteOptionGroupCommand,
  DeleteTenantDatabaseCommand,
  DeregisterDBProxyTargetsCommand,
  DescribeAccountAttributesCommand,
  DescribeBlueGreenDeploymentsCommand,
  DescribeCertificatesCommand,
  DescribeDBClusterAutomatedBackupsCommand,
  DescribeDBClusterBacktracksCommand,
  DescribeDBClusterEndpointsCommand,
  DescribeDBClusterParameterGroupsCommand,
  DescribeDBClusterParametersCommand,
  DescribeDBClustersCommand,
  DescribeDBClusterSnapshotAttributesCommand,
  DescribeDBClusterSnapshotsCommand,
  DescribeDBEngineVersionsCommand,
  DescribeDBInstanceAutomatedBackupsCommand,
  DescribeDBInstancesCommand,
  DescribeDBLogFilesCommand,
  DescribeDBMajorEngineVersionsCommand,
  DescribeDBParameterGroupsCommand,
  DescribeDBParametersCommand,
  DescribeDBProxiesCommand,
  DescribeDBProxyEndpointsCommand,
  DescribeDBProxyTargetGroupsCommand,
  DescribeDBProxyTargetsCommand,
  DescribeDBRecommendationsCommand,
  DescribeDBSecurityGroupsCommand,
  DescribeDBShardGroupsCommand,
  DescribeDBSnapshotAttributesCommand,
  DescribeDBSnapshotsCommand,
  DescribeDBSnapshotTenantDatabasesCommand,
  DescribeDBSubnetGroupsCommand,
  DescribeEngineDefaultClusterParametersCommand,
  DescribeEngineDefaultParametersCommand,
  DescribeEventCategoriesCommand,
  DescribeEventsCommand,
  DescribeEventSubscriptionsCommand,
  DescribeExportTasksCommand,
  DescribeGlobalClustersCommand,
  DescribeIntegrationsCommand,
  DescribeOptionGroupOptionsCommand,
  DescribeOptionGroupsCommand,
  DescribeOrderableDBInstanceOptionsCommand,
  DescribePendingMaintenanceActionsCommand,
  DescribeReservedDBInstancesCommand,
  DescribeReservedDBInstancesOfferingsCommand,
  DescribeSourceRegionsCommand,
  DescribeTenantDatabasesCommand,
  DescribeValidDBInstanceModificationsCommand,
  DisableHttpEndpointCommand,
  DownloadDBLogFilePortionCommand,
  EnableHttpEndpointCommand,
  FailoverDBClusterCommand,
  FailoverGlobalClusterCommand,
  ListTagsForResourceCommand,
  ModifyActivityStreamCommand,
  ModifyCertificatesCommand,
  ModifyCurrentDBClusterCapacityCommand,
  ModifyCustomDBEngineVersionCommand,
  ModifyDBClusterCommand,
  ModifyDBClusterEndpointCommand,
  ModifyDBClusterParameterGroupCommand,
  ModifyDBClusterSnapshotAttributeCommand,
  ModifyDBInstanceCommand,
  ModifyDBParameterGroupCommand,
  ModifyDBProxyCommand,
  ModifyDBProxyEndpointCommand,
  ModifyDBProxyTargetGroupCommand,
  ModifyDBRecommendationCommand,
  ModifyDBShardGroupCommand,
  ModifyDBSnapshotCommand,
  ModifyDBSnapshotAttributeCommand,
  ModifyDBSubnetGroupCommand,
  ModifyEventSubscriptionCommand,
  ModifyGlobalClusterCommand,
  ModifyIntegrationCommand,
  ModifyOptionGroupCommand,
  ModifyTenantDatabaseCommand,
  PromoteReadReplicaCommand,
  PromoteReadReplicaDBClusterCommand,
  PurchaseReservedDBInstancesOfferingCommand,
  RebootDBClusterCommand,
  RebootDBInstanceCommand,
  RebootDBShardGroupCommand,
  RegisterDBProxyTargetsCommand,
  RemoveFromGlobalClusterCommand,
  RemoveRoleFromDBClusterCommand,
  RemoveRoleFromDBInstanceCommand,
  RemoveSourceIdentifierFromSubscriptionCommand,
  RemoveTagsFromResourceCommand,
  ResetDBClusterParameterGroupCommand,
  ResetDBParameterGroupCommand,
  RestoreDBClusterFromS3Command,
  RestoreDBClusterFromSnapshotCommand,
  RestoreDBClusterToPointInTimeCommand,
  RestoreDBInstanceFromDBSnapshotCommand,
  RestoreDBInstanceFromS3Command,
  RestoreDBInstanceToPointInTimeCommand,
  RevokeDBSecurityGroupIngressCommand,
  StartActivityStreamCommand,
  StartDBClusterCommand,
  StartDBInstanceCommand,
  StartDBInstanceAutomatedBackupsReplicationCommand,
  StartExportTaskCommand,
  StopActivityStreamCommand,
  StopDBClusterCommand,
  StopDBInstanceCommand,
  StopDBInstanceAutomatedBackupsReplicationCommand,
  SwitchoverBlueGreenDeploymentCommand,
  SwitchoverGlobalClusterCommand,
  SwitchoverReadReplicaCommand
};
var RDS = class extends RDSClient {
  static {
    __name(this, "RDS");
  }
};
(0, import_smithy_client.createAggregatedClient)(commands, RDS);

// src/pagination/DescribeBlueGreenDeploymentsPaginator.ts

var paginateDescribeBlueGreenDeployments = (0, import_core.createPaginator)(RDSClient, DescribeBlueGreenDeploymentsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeCertificatesPaginator.ts

var paginateDescribeCertificates = (0, import_core.createPaginator)(RDSClient, DescribeCertificatesCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBClusterAutomatedBackupsPaginator.ts

var paginateDescribeDBClusterAutomatedBackups = (0, import_core.createPaginator)(RDSClient, DescribeDBClusterAutomatedBackupsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBClusterBacktracksPaginator.ts

var paginateDescribeDBClusterBacktracks = (0, import_core.createPaginator)(RDSClient, DescribeDBClusterBacktracksCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBClusterEndpointsPaginator.ts

var paginateDescribeDBClusterEndpoints = (0, import_core.createPaginator)(RDSClient, DescribeDBClusterEndpointsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBClusterParameterGroupsPaginator.ts

var paginateDescribeDBClusterParameterGroups = (0, import_core.createPaginator)(RDSClient, DescribeDBClusterParameterGroupsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBClusterParametersPaginator.ts

var paginateDescribeDBClusterParameters = (0, import_core.createPaginator)(RDSClient, DescribeDBClusterParametersCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBClusterSnapshotsPaginator.ts

var paginateDescribeDBClusterSnapshots = (0, import_core.createPaginator)(RDSClient, DescribeDBClusterSnapshotsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBClustersPaginator.ts

var paginateDescribeDBClusters = (0, import_core.createPaginator)(RDSClient, DescribeDBClustersCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBEngineVersionsPaginator.ts

var paginateDescribeDBEngineVersions = (0, import_core.createPaginator)(RDSClient, DescribeDBEngineVersionsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBInstanceAutomatedBackupsPaginator.ts

var paginateDescribeDBInstanceAutomatedBackups = (0, import_core.createPaginator)(RDSClient, DescribeDBInstanceAutomatedBackupsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBInstancesPaginator.ts

var paginateDescribeDBInstances = (0, import_core.createPaginator)(RDSClient, DescribeDBInstancesCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBLogFilesPaginator.ts

var paginateDescribeDBLogFiles = (0, import_core.createPaginator)(RDSClient, DescribeDBLogFilesCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBMajorEngineVersionsPaginator.ts

var paginateDescribeDBMajorEngineVersions = (0, import_core.createPaginator)(RDSClient, DescribeDBMajorEngineVersionsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBParameterGroupsPaginator.ts

var paginateDescribeDBParameterGroups = (0, import_core.createPaginator)(RDSClient, DescribeDBParameterGroupsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBParametersPaginator.ts

var paginateDescribeDBParameters = (0, import_core.createPaginator)(RDSClient, DescribeDBParametersCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBProxiesPaginator.ts

var paginateDescribeDBProxies = (0, import_core.createPaginator)(RDSClient, DescribeDBProxiesCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBProxyEndpointsPaginator.ts

var paginateDescribeDBProxyEndpoints = (0, import_core.createPaginator)(RDSClient, DescribeDBProxyEndpointsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBProxyTargetGroupsPaginator.ts

var paginateDescribeDBProxyTargetGroups = (0, import_core.createPaginator)(RDSClient, DescribeDBProxyTargetGroupsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBProxyTargetsPaginator.ts

var paginateDescribeDBProxyTargets = (0, import_core.createPaginator)(RDSClient, DescribeDBProxyTargetsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBRecommendationsPaginator.ts

var paginateDescribeDBRecommendations = (0, import_core.createPaginator)(RDSClient, DescribeDBRecommendationsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBSecurityGroupsPaginator.ts

var paginateDescribeDBSecurityGroups = (0, import_core.createPaginator)(RDSClient, DescribeDBSecurityGroupsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBSnapshotTenantDatabasesPaginator.ts

var paginateDescribeDBSnapshotTenantDatabases = (0, import_core.createPaginator)(RDSClient, DescribeDBSnapshotTenantDatabasesCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBSnapshotsPaginator.ts

var paginateDescribeDBSnapshots = (0, import_core.createPaginator)(RDSClient, DescribeDBSnapshotsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeDBSubnetGroupsPaginator.ts

var paginateDescribeDBSubnetGroups = (0, import_core.createPaginator)(RDSClient, DescribeDBSubnetGroupsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeEngineDefaultParametersPaginator.ts

var paginateDescribeEngineDefaultParameters = (0, import_core.createPaginator)(RDSClient, DescribeEngineDefaultParametersCommand, "Marker", "EngineDefaults.Marker", "MaxRecords");

// src/pagination/DescribeEventSubscriptionsPaginator.ts

var paginateDescribeEventSubscriptions = (0, import_core.createPaginator)(RDSClient, DescribeEventSubscriptionsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeEventsPaginator.ts

var paginateDescribeEvents = (0, import_core.createPaginator)(RDSClient, DescribeEventsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeExportTasksPaginator.ts

var paginateDescribeExportTasks = (0, import_core.createPaginator)(RDSClient, DescribeExportTasksCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeGlobalClustersPaginator.ts

var paginateDescribeGlobalClusters = (0, import_core.createPaginator)(RDSClient, DescribeGlobalClustersCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeIntegrationsPaginator.ts

var paginateDescribeIntegrations = (0, import_core.createPaginator)(RDSClient, DescribeIntegrationsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeOptionGroupOptionsPaginator.ts

var paginateDescribeOptionGroupOptions = (0, import_core.createPaginator)(RDSClient, DescribeOptionGroupOptionsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeOptionGroupsPaginator.ts

var paginateDescribeOptionGroups = (0, import_core.createPaginator)(RDSClient, DescribeOptionGroupsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeOrderableDBInstanceOptionsPaginator.ts

var paginateDescribeOrderableDBInstanceOptions = (0, import_core.createPaginator)(RDSClient, DescribeOrderableDBInstanceOptionsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribePendingMaintenanceActionsPaginator.ts

var paginateDescribePendingMaintenanceActions = (0, import_core.createPaginator)(RDSClient, DescribePendingMaintenanceActionsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeReservedDBInstancesOfferingsPaginator.ts

var paginateDescribeReservedDBInstancesOfferings = (0, import_core.createPaginator)(RDSClient, DescribeReservedDBInstancesOfferingsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeReservedDBInstancesPaginator.ts

var paginateDescribeReservedDBInstances = (0, import_core.createPaginator)(RDSClient, DescribeReservedDBInstancesCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeSourceRegionsPaginator.ts

var paginateDescribeSourceRegions = (0, import_core.createPaginator)(RDSClient, DescribeSourceRegionsCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DescribeTenantDatabasesPaginator.ts

var paginateDescribeTenantDatabases = (0, import_core.createPaginator)(RDSClient, DescribeTenantDatabasesCommand, "Marker", "Marker", "MaxRecords");

// src/pagination/DownloadDBLogFilePortionPaginator.ts

var paginateDownloadDBLogFilePortion = (0, import_core.createPaginator)(RDSClient, DownloadDBLogFilePortionCommand, "Marker", "Marker", "NumberOfLines");

// src/waiters/waitForDBClusterAvailable.ts
var import_util_waiter = require("@smithy/util-waiter");
var checkState = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeDBClustersCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBClusters);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      let allStringEq_5 = returnComparator().length > 0;
      for (const element_4 of returnComparator()) {
        allStringEq_5 = allStringEq_5 && element_4 == "available";
      }
      if (allStringEq_5) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBClusters);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "deleted") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBClusters);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "deleting") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBClusters);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "failed") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBClusters);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "incompatible-restore") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBClusters);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "incompatible-parameters") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForDBClusterAvailable = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
}, "waitForDBClusterAvailable");
var waitUntilDBClusterAvailable = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilDBClusterAvailable");

// src/waiters/waitForDBClusterDeleted.ts

var checkState2 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeDBClustersCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.DBClusters.length == 0;
      }, "returnComparator");
      if (returnComparator() == true) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBClusters);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "creating") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBClusters);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "modifying") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBClusters);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "rebooting") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBClusters);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "resetting-master-credentials") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
    if (exception.name && exception.name == "DBClusterNotFoundFault") {
      return { state: import_util_waiter.WaiterState.SUCCESS, reason };
    }
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForDBClusterDeleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState2);
}, "waitForDBClusterDeleted");
var waitUntilDBClusterDeleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState2);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilDBClusterDeleted");

// src/waiters/waitForDBClusterSnapshotAvailable.ts

var checkState3 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeDBClusterSnapshotsCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBClusterSnapshots);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      let allStringEq_5 = returnComparator().length > 0;
      for (const element_4 of returnComparator()) {
        allStringEq_5 = allStringEq_5 && element_4 == "available";
      }
      if (allStringEq_5) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBClusterSnapshots);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "deleted") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBClusterSnapshots);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "deleting") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBClusterSnapshots);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "failed") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBClusterSnapshots);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "incompatible-restore") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBClusterSnapshots);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "incompatible-parameters") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForDBClusterSnapshotAvailable = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState3);
}, "waitForDBClusterSnapshotAvailable");
var waitUntilDBClusterSnapshotAvailable = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState3);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilDBClusterSnapshotAvailable");

// src/waiters/waitForDBClusterSnapshotDeleted.ts

var checkState4 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeDBClusterSnapshotsCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.DBClusterSnapshots.length == 0;
      }, "returnComparator");
      if (returnComparator() == true) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBClusterSnapshots);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "creating") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBClusterSnapshots);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "modifying") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBClusterSnapshots);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "rebooting") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBClusterSnapshots);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "resetting-master-credentials") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
    if (exception.name && exception.name == "DBClusterSnapshotNotFoundFault") {
      return { state: import_util_waiter.WaiterState.SUCCESS, reason };
    }
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForDBClusterSnapshotDeleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState4);
}, "waitForDBClusterSnapshotDeleted");
var waitUntilDBClusterSnapshotDeleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState4);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilDBClusterSnapshotDeleted");

// src/waiters/waitForDBInstanceAvailable.ts

var checkState5 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeDBInstancesCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBInstances);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.DBInstanceStatus;
        });
        return projection_3;
      }, "returnComparator");
      let allStringEq_5 = returnComparator().length > 0;
      for (const element_4 of returnComparator()) {
        allStringEq_5 = allStringEq_5 && element_4 == "available";
      }
      if (allStringEq_5) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBInstances);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.DBInstanceStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "deleted") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBInstances);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.DBInstanceStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "deleting") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBInstances);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.DBInstanceStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "failed") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBInstances);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.DBInstanceStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "incompatible-restore") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBInstances);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.DBInstanceStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "incompatible-parameters") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForDBInstanceAvailable = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState5);
}, "waitForDBInstanceAvailable");
var waitUntilDBInstanceAvailable = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState5);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilDBInstanceAvailable");

// src/waiters/waitForDBInstanceDeleted.ts

var checkState6 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeDBInstancesCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.DBInstances.length == 0;
      }, "returnComparator");
      if (returnComparator() == true) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBInstances);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.DBInstanceStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "creating") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBInstances);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.DBInstanceStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "modifying") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBInstances);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.DBInstanceStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "rebooting") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBInstances);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.DBInstanceStatus;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "resetting-master-credentials") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
    if (exception.name && exception.name == "DBInstanceNotFoundFault") {
      return { state: import_util_waiter.WaiterState.SUCCESS, reason };
    }
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForDBInstanceDeleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState6);
}, "waitForDBInstanceDeleted");
var waitUntilDBInstanceDeleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState6);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilDBInstanceDeleted");

// src/waiters/waitForDBSnapshotAvailable.ts

var checkState7 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeDBSnapshotsCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBSnapshots);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      let allStringEq_5 = returnComparator().length > 0;
      for (const element_4 of returnComparator()) {
        allStringEq_5 = allStringEq_5 && element_4 == "available";
      }
      if (allStringEq_5) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBSnapshots);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "deleted") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBSnapshots);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "deleting") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBSnapshots);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "failed") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBSnapshots);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "incompatible-restore") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBSnapshots);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "incompatible-parameters") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForDBSnapshotAvailable = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState7);
}, "waitForDBSnapshotAvailable");
var waitUntilDBSnapshotAvailable = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState7);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilDBSnapshotAvailable");

// src/waiters/waitForDBSnapshotDeleted.ts

var checkState8 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeDBSnapshotsCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.DBSnapshots.length == 0;
      }, "returnComparator");
      if (returnComparator() == true) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBSnapshots);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "creating") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBSnapshots);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "modifying") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBSnapshots);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "rebooting") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.DBSnapshots);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "resetting-master-credentials") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
    if (exception.name && exception.name == "DBSnapshotNotFoundFault") {
      return { state: import_util_waiter.WaiterState.SUCCESS, reason };
    }
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForDBSnapshotDeleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState8);
}, "waitForDBSnapshotDeleted");
var waitUntilDBSnapshotDeleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState8);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilDBSnapshotDeleted");

// src/waiters/waitForTenantDatabaseAvailable.ts

var checkState9 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeTenantDatabasesCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.TenantDatabases);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      let allStringEq_5 = returnComparator().length > 0;
      for (const element_4 of returnComparator()) {
        allStringEq_5 = allStringEq_5 && element_4 == "available";
      }
      if (allStringEq_5) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.TenantDatabases);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "deleted") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.TenantDatabases);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "incompatible-parameters") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        const flat_1 = [].concat(...result.TenantDatabases);
        const projection_3 = flat_1.map((element_2) => {
          return element_2.Status;
        });
        return projection_3;
      }, "returnComparator");
      for (const anyStringEq_4 of returnComparator()) {
        if (anyStringEq_4 == "incompatible-restore") {
          return { state: import_util_waiter.WaiterState.FAILURE, reason };
        }
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForTenantDatabaseAvailable = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState9);
}, "waitForTenantDatabaseAvailable");
var waitUntilTenantDatabaseAvailable = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState9);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilTenantDatabaseAvailable");

// src/waiters/waitForTenantDatabaseDeleted.ts

var checkState10 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeTenantDatabasesCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.TenantDatabases.length == 0;
      }, "returnComparator");
      if (returnComparator() == true) {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
    if (exception.name && exception.name == "DBInstanceNotFoundFault") {
      return { state: import_util_waiter.WaiterState.SUCCESS, reason };
    }
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForTenantDatabaseDeleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState10);
}, "waitForTenantDatabaseDeleted");
var waitUntilTenantDatabaseDeleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState10);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilTenantDatabaseDeleted");
// Annotate the CommonJS export names for ESM import in node:

0 && (module.exports = {
  RDSServiceException,
  __Client,
  RDSClient,
  RDS,
  $Command,
  AddRoleToDBClusterCommand,
  AddRoleToDBInstanceCommand,
  AddSourceIdentifierToSubscriptionCommand,
  AddTagsToResourceCommand,
  ApplyPendingMaintenanceActionCommand,
  AuthorizeDBSecurityGroupIngressCommand,
  BacktrackDBClusterCommand,
  CancelExportTaskCommand,
  CopyDBClusterParameterGroupCommand,
  CopyDBClusterSnapshotCommand,
  CopyDBParameterGroupCommand,
  CopyDBSnapshotCommand,
  CopyOptionGroupCommand,
  CreateBlueGreenDeploymentCommand,
  CreateCustomDBEngineVersionCommand,
  CreateDBClusterCommand,
  CreateDBClusterEndpointCommand,
  CreateDBClusterParameterGroupCommand,
  CreateDBClusterSnapshotCommand,
  CreateDBInstanceCommand,
  CreateDBInstanceReadReplicaCommand,
  CreateDBParameterGroupCommand,
  CreateDBProxyCommand,
  CreateDBProxyEndpointCommand,
  CreateDBSecurityGroupCommand,
  CreateDBShardGroupCommand,
  CreateDBSnapshotCommand,
  CreateDBSubnetGroupCommand,
  CreateEventSubscriptionCommand,
  CreateGlobalClusterCommand,
  CreateIntegrationCommand,
  CreateOptionGroupCommand,
  CreateTenantDatabaseCommand,
  DeleteBlueGreenDeploymentCommand,
  DeleteCustomDBEngineVersionCommand,
  DeleteDBClusterAutomatedBackupCommand,
  DeleteDBClusterCommand,
  DeleteDBClusterEndpointCommand,
  DeleteDBClusterParameterGroupCommand,
  DeleteDBClusterSnapshotCommand,
  DeleteDBInstanceAutomatedBackupCommand,
  DeleteDBInstanceCommand,
  DeleteDBParameterGroupCommand,
  DeleteDBProxyCommand,
  DeleteDBProxyEndpointCommand,
  DeleteDBSecurityGroupCommand,
  DeleteDBShardGroupCommand,
  DeleteDBSnapshotCommand,
  DeleteDBSubnetGroupCommand,
  DeleteEventSubscriptionCommand,
  DeleteGlobalClusterCommand,
  DeleteIntegrationCommand,
  DeleteOptionGroupCommand,
  DeleteTenantDatabaseCommand,
  DeregisterDBProxyTargetsCommand,
  DescribeAccountAttributesCommand,
  DescribeBlueGreenDeploymentsCommand,
  DescribeCertificatesCommand,
  DescribeDBClusterAutomatedBackupsCommand,
  DescribeDBClusterBacktracksCommand,
  DescribeDBClusterEndpointsCommand,
  DescribeDBClusterParameterGroupsCommand,
  DescribeDBClusterParametersCommand,
  DescribeDBClusterSnapshotAttributesCommand,
  DescribeDBClusterSnapshotsCommand,
  DescribeDBClustersCommand,
  DescribeDBEngineVersionsCommand,
  DescribeDBInstanceAutomatedBackupsCommand,
  DescribeDBInstancesCommand,
  DescribeDBLogFilesCommand,
  DescribeDBMajorEngineVersionsCommand,
  DescribeDBParameterGroupsCommand,
  DescribeDBParametersCommand,
  DescribeDBProxiesCommand,
  DescribeDBProxyEndpointsCommand,
  DescribeDBProxyTargetGroupsCommand,
  DescribeDBProxyTargetsCommand,
  DescribeDBRecommendationsCommand,
  DescribeDBSecurityGroupsCommand,
  DescribeDBShardGroupsCommand,
  DescribeDBSnapshotAttributesCommand,
  DescribeDBSnapshotTenantDatabasesCommand,
  DescribeDBSnapshotsCommand,
  DescribeDBSubnetGroupsCommand,
  DescribeEngineDefaultClusterParametersCommand,
  DescribeEngineDefaultParametersCommand,
  DescribeEventCategoriesCommand,
  DescribeEventSubscriptionsCommand,
  DescribeEventsCommand,
  DescribeExportTasksCommand,
  DescribeGlobalClustersCommand,
  DescribeIntegrationsCommand,
  DescribeOptionGroupOptionsCommand,
  DescribeOptionGroupsCommand,
  DescribeOrderableDBInstanceOptionsCommand,
  DescribePendingMaintenanceActionsCommand,
  DescribeReservedDBInstancesCommand,
  DescribeReservedDBInstancesOfferingsCommand,
  DescribeSourceRegionsCommand,
  DescribeTenantDatabasesCommand,
  DescribeValidDBInstanceModificationsCommand,
  DisableHttpEndpointCommand,
  DownloadDBLogFilePortionCommand,
  EnableHttpEndpointCommand,
  FailoverDBClusterCommand,
  FailoverGlobalClusterCommand,
  ListTagsForResourceCommand,
  ModifyActivityStreamCommand,
  ModifyCertificatesCommand,
  ModifyCurrentDBClusterCapacityCommand,
  ModifyCustomDBEngineVersionCommand,
  ModifyDBClusterCommand,
  ModifyDBClusterEndpointCommand,
  ModifyDBClusterParameterGroupCommand,
  ModifyDBClusterSnapshotAttributeCommand,
  ModifyDBInstanceCommand,
  ModifyDBParameterGroupCommand,
  ModifyDBProxyCommand,
  ModifyDBProxyEndpointCommand,
  ModifyDBProxyTargetGroupCommand,
  ModifyDBRecommendationCommand,
  ModifyDBShardGroupCommand,
  ModifyDBSnapshotAttributeCommand,
  ModifyDBSnapshotCommand,
  ModifyDBSubnetGroupCommand,
  ModifyEventSubscriptionCommand,
  ModifyGlobalClusterCommand,
  ModifyIntegrationCommand,
  ModifyOptionGroupCommand,
  ModifyTenantDatabaseCommand,
  PromoteReadReplicaCommand,
  PromoteReadReplicaDBClusterCommand,
  PurchaseReservedDBInstancesOfferingCommand,
  RebootDBClusterCommand,
  RebootDBInstanceCommand,
  RebootDBShardGroupCommand,
  RegisterDBProxyTargetsCommand,
  RemoveFromGlobalClusterCommand,
  RemoveRoleFromDBClusterCommand,
  RemoveRoleFromDBInstanceCommand,
  RemoveSourceIdentifierFromSubscriptionCommand,
  RemoveTagsFromResourceCommand,
  ResetDBClusterParameterGroupCommand,
  ResetDBParameterGroupCommand,
  RestoreDBClusterFromS3Command,
  RestoreDBClusterFromSnapshotCommand,
  RestoreDBClusterToPointInTimeCommand,
  RestoreDBInstanceFromDBSnapshotCommand,
  RestoreDBInstanceFromS3Command,
  RestoreDBInstanceToPointInTimeCommand,
  RevokeDBSecurityGroupIngressCommand,
  StartActivityStreamCommand,
  StartDBClusterCommand,
  StartDBInstanceAutomatedBackupsReplicationCommand,
  StartDBInstanceCommand,
  StartExportTaskCommand,
  StopActivityStreamCommand,
  StopDBClusterCommand,
  StopDBInstanceAutomatedBackupsReplicationCommand,
  StopDBInstanceCommand,
  SwitchoverBlueGreenDeploymentCommand,
  SwitchoverGlobalClusterCommand,
  SwitchoverReadReplicaCommand,
  paginateDescribeBlueGreenDeployments,
  paginateDescribeCertificates,
  paginateDescribeDBClusterAutomatedBackups,
  paginateDescribeDBClusterBacktracks,
  paginateDescribeDBClusterEndpoints,
  paginateDescribeDBClusterParameterGroups,
  paginateDescribeDBClusterParameters,
  paginateDescribeDBClusterSnapshots,
  paginateDescribeDBClusters,
  paginateDescribeDBEngineVersions,
  paginateDescribeDBInstanceAutomatedBackups,
  paginateDescribeDBInstances,
  paginateDescribeDBLogFiles,
  paginateDescribeDBMajorEngineVersions,
  paginateDescribeDBParameterGroups,
  paginateDescribeDBParameters,
  paginateDescribeDBProxies,
  paginateDescribeDBProxyEndpoints,
  paginateDescribeDBProxyTargetGroups,
  paginateDescribeDBProxyTargets,
  paginateDescribeDBRecommendations,
  paginateDescribeDBSecurityGroups,
  paginateDescribeDBSnapshotTenantDatabases,
  paginateDescribeDBSnapshots,
  paginateDescribeDBSubnetGroups,
  paginateDescribeEngineDefaultParameters,
  paginateDescribeEventSubscriptions,
  paginateDescribeEvents,
  paginateDescribeExportTasks,
  paginateDescribeGlobalClusters,
  paginateDescribeIntegrations,
  paginateDescribeOptionGroupOptions,
  paginateDescribeOptionGroups,
  paginateDescribeOrderableDBInstanceOptions,
  paginateDescribePendingMaintenanceActions,
  paginateDescribeReservedDBInstancesOfferings,
  paginateDescribeReservedDBInstances,
  paginateDescribeSourceRegions,
  paginateDescribeTenantDatabases,
  paginateDownloadDBLogFilePortion,
  waitForDBClusterAvailable,
  waitUntilDBClusterAvailable,
  waitForDBClusterDeleted,
  waitUntilDBClusterDeleted,
  waitForDBClusterSnapshotAvailable,
  waitUntilDBClusterSnapshotAvailable,
  waitForDBClusterSnapshotDeleted,
  waitUntilDBClusterSnapshotDeleted,
  waitForDBInstanceAvailable,
  waitUntilDBInstanceAvailable,
  waitForDBInstanceDeleted,
  waitUntilDBInstanceDeleted,
  waitForDBSnapshotAvailable,
  waitUntilDBSnapshotAvailable,
  waitForDBSnapshotDeleted,
  waitUntilDBSnapshotDeleted,
  waitForTenantDatabaseAvailable,
  waitUntilTenantDatabaseAvailable,
  waitForTenantDatabaseDeleted,
  waitUntilTenantDatabaseDeleted,
  ActivityStreamMode,
  ActivityStreamPolicyStatus,
  ActivityStreamStatus,
  DBClusterNotFoundFault,
  DBClusterRoleAlreadyExistsFault,
  DBClusterRoleQuotaExceededFault,
  InvalidDBClusterStateFault,
  DBInstanceNotFoundFault,
  DBInstanceRoleAlreadyExistsFault,
  DBInstanceRoleQuotaExceededFault,
  InvalidDBInstanceStateFault,
  SourceNotFoundFault,
  SubscriptionNotFoundFault,
  BlueGreenDeploymentNotFoundFault,
  DBProxyNotFoundFault,
  DBProxyTargetGroupNotFoundFault,
  DBSnapshotNotFoundFault,
  DBSnapshotTenantDatabaseNotFoundFault,
  IntegrationNotFoundFault,
  TenantDatabaseNotFoundFault,
  ResourceNotFoundFault,
  AuthorizationAlreadyExistsFault,
  AuthorizationQuotaExceededFault,
  DBSecurityGroupNotFoundFault,
  InvalidDBSecurityGroupStateFault,
  ExportSourceType,
  ExportTaskNotFoundFault,
  InvalidExportTaskStateFault,
  DBParameterGroupAlreadyExistsFault,
  DBParameterGroupNotFoundFault,
  DBParameterGroupQuotaExceededFault,
  DBClusterSnapshotAlreadyExistsFault,
  DBClusterSnapshotNotFoundFault,
  InvalidDBClusterSnapshotStateFault,
  KMSKeyNotAccessibleFault,
  SnapshotQuotaExceededFault,
  CustomAvailabilityZoneNotFoundFault,
  DBSnapshotAlreadyExistsFault,
  InvalidDBSnapshotStateFault,
  OptionGroupAlreadyExistsFault,
  OptionGroupNotFoundFault,
  OptionGroupQuotaExceededFault,
  BlueGreenDeploymentAlreadyExistsFault,
  DBClusterParameterGroupNotFoundFault,
  DBClusterQuotaExceededFault,
  InstanceQuotaExceededFault,
  SourceClusterNotSupportedFault,
  SourceDatabaseNotSupportedFault,
  CreateCustomDBEngineVersionFault,
  CustomDBEngineVersionAlreadyExistsFault,
  CustomDBEngineVersionQuotaExceededFault,
  Ec2ImagePropertiesNotSupportedFault,
  ClusterScalabilityType,
  DatabaseInsightsMode,
  ReplicaMode,
  WriteForwardingStatus,
  LimitlessDatabaseStatus,
  LocalWriteForwardingStatus,
  DBClusterAlreadyExistsFault,
  DBSubnetGroupDoesNotCoverEnoughAZs,
  DBSubnetGroupNotFoundFault,
  DomainNotFoundFault,
  GlobalClusterNotFoundFault,
  InsufficientDBInstanceCapacityFault,
  InsufficientStorageClusterCapacityFault,
  InvalidDBSubnetGroupFault,
  InvalidDBSubnetGroupStateFault,
  InvalidGlobalClusterStateFault,
  InvalidSubnet,
  InvalidVPCNetworkStateFault,
  StorageQuotaExceededFault,
  DBClusterEndpointAlreadyExistsFault,
  DBClusterEndpointQuotaExceededFault,
  AuthorizationNotFoundFault,
  BackupPolicyNotFoundFault,
  CertificateNotFoundFault,
  AutomationMode,
  DBInstanceAlreadyExistsFault,
  NetworkTypeNotSupported,
  ProvisionedIopsNotAvailableInAZFault,
  StorageTypeNotSupportedFault,
  TenantDatabaseQuotaExceededFault,
  DBSubnetGroupNotAllowedFault,
  AuthScheme,
  ClientPasswordAuthType,
  IAMAuthMode,
  EngineFamily,
  DBProxyStatus,
  DBProxyAlreadyExistsFault,
  DBProxyQuotaExceededFault,
  DBProxyEndpointTargetRole,
  DBProxyEndpointStatus,
  DBProxyEndpointAlreadyExistsFault,
  DBProxyEndpointQuotaExceededFault,
  InvalidDBProxyStateFault,
  DBSecurityGroupAlreadyExistsFault,
  DBSecurityGroupNotSupportedFault,
  DBSecurityGroupQuotaExceededFault,
  DBShardGroupAlreadyExistsFault,
  MaxDBShardGroupLimitReached,
  UnsupportedDBEngineVersionFault,
  DBSubnetGroupAlreadyExistsFault,
  DBSubnetGroupQuotaExceededFault,
  DBSubnetQuotaExceededFault,
  EventSubscriptionQuotaExceededFault,
  SNSInvalidTopicFault,
  SNSNoAuthorizationFault,
  SNSTopicArnNotFoundFault,
  SubscriptionAlreadyExistFault,
  SubscriptionCategoryNotFoundFault,
  FailoverStatus,
  GlobalClusterMemberSynchronizationStatus,
  GlobalClusterAlreadyExistsFault,
  GlobalClusterQuotaExceededFault,
  IntegrationStatus,
  IntegrationAlreadyExistsFault,
  IntegrationConflictOperationFault,
  IntegrationQuotaExceededFault,
  TenantDatabaseAlreadyExistsFault,
  InvalidBlueGreenDeploymentStateFault,
  CustomDBEngineVersionNotFoundFault,
  InvalidCustomDBEngineVersionStateFault,
  DBClusterAutomatedBackupQuotaExceededFault,
  DBClusterAutomatedBackupNotFoundFault,
  InvalidDBClusterAutomatedBackupStateFault,
  DBClusterEndpointNotFoundFault,
  InvalidDBClusterEndpointStateFault,
  InvalidDBParameterGroupStateFault,
  DBInstanceAutomatedBackupQuotaExceededFault,
  DBInstanceAutomatedBackupNotFoundFault,
  InvalidDBInstanceAutomatedBackupStateFault,
  DBProxyEndpointNotFoundFault,
  InvalidDBProxyEndpointStateFault,
  DBShardGroupNotFoundFault,
  InvalidDBShardGroupStateFault,
  InvalidDBSubnetStateFault,
  InvalidEventSubscriptionStateFault,
  InvalidIntegrationStateFault,
  CreateTenantDatabaseMessageFilterSensitiveLog,
  TenantDatabasePendingModifiedValuesFilterSensitiveLog,
  TenantDatabaseFilterSensitiveLog,
  CreateTenantDatabaseResultFilterSensitiveLog,
  InvalidOptionGroupStateFault,
  DBProxyTargetNotFoundFault,
  DBClusterBacktrackNotFoundFault,
  ApplyMethod,
  DBInstanceNotReadyFault,
  LifecycleSupportName,
  TargetRole,
  TargetHealthReason,
  TargetState,
  TargetType,
  SourceType,
  ReservedDBInstanceNotFoundFault,
  ReservedDBInstancesOfferingNotFoundFault,
  InvalidResourceStateFault,
  DBLogFileNotFoundFault,
  AuditPolicyState,
  InvalidDBClusterCapacityFault,
  CustomEngineVersionStatus,
  StorageTypeNotAvailableFault,
  SharedSnapshotQuotaExceededFault,
  DBUpgradeDependencyFailureFault,
  SubnetAlreadyInUse,
  ReservedDBInstanceAlreadyExistsFault,
  ReservedDBInstanceQuotaExceededFault,
  DBProxyTargetAlreadyRegisteredFault,
  InsufficientAvailableIPsInSubnetFault,
  DBClusterRoleNotFoundFault,
  DBInstanceRoleNotFoundFault,
  InvalidS3BucketFault,
  InsufficientDBClusterCapacityFault,
  InvalidRestoreFault,
  PointInTimeRestoreNotEnabledFault,
  ExportTaskAlreadyExistsFault,
  IamRoleMissingPermissionsFault,
  IamRoleNotFoundFault,
  InvalidExportOnlyFault,
  InvalidExportSourceStateFault,
  DeleteTenantDatabaseResultFilterSensitiveLog,
  TenantDatabasesMessageFilterSensitiveLog,
  ModifyTenantDatabaseMessageFilterSensitiveLog,
  ModifyTenantDatabaseResultFilterSensitiveLog
});

