import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { EKSServiceException as __BaseException } from "./EKSServiceException";
export declare const AuthenticationMode: {
  readonly API: "API";
  readonly API_AND_CONFIG_MAP: "API_AND_CONFIG_MAP";
  readonly CONFIG_MAP: "CONFIG_MAP";
};
export type AuthenticationMode =
  (typeof AuthenticationMode)[keyof typeof AuthenticationMode];
export interface AccessConfigResponse {
  bootstrapClusterCreatorAdminPermissions?: boolean | undefined;
  authenticationMode?: AuthenticationMode | undefined;
}
export declare class AccessDeniedException extends __BaseException {
  readonly name: "AccessDeniedException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<AccessDeniedException, __BaseException>
  );
}
export interface AccessEntry {
  clusterName?: string | undefined;
  principalArn?: string | undefined;
  kubernetesGroups?: string[] | undefined;
  accessEntryArn?: string | undefined;
  createdAt?: Date | undefined;
  modifiedAt?: Date | undefined;
  tags?: Record<string, string> | undefined;
  username?: string | undefined;
  type?: string | undefined;
}
export interface AccessPolicy {
  name?: string | undefined;
  arn?: string | undefined;
}
export declare const AccessScopeType: {
  readonly cluster: "cluster";
  readonly namespace: "namespace";
};
export type AccessScopeType =
  (typeof AccessScopeType)[keyof typeof AccessScopeType];
export interface AccessScope {
  type?: AccessScopeType | undefined;
  namespaces?: string[] | undefined;
}
export declare const AddonIssueCode: {
  readonly ACCESS_DENIED: "AccessDenied";
  readonly ADDON_PERMISSION_FAILURE: "AddonPermissionFailure";
  readonly ADDON_SUBSCRIPTION_NEEDED: "AddonSubscriptionNeeded";
  readonly ADMISSION_REQUEST_DENIED: "AdmissionRequestDenied";
  readonly CLUSTER_UNREACHABLE: "ClusterUnreachable";
  readonly CONFIGURATION_CONFLICT: "ConfigurationConflict";
  readonly INSUFFICIENT_NUMBER_OF_REPLICAS: "InsufficientNumberOfReplicas";
  readonly INTERNAL_FAILURE: "InternalFailure";
  readonly K8S_RESOURCE_NOT_FOUND: "K8sResourceNotFound";
  readonly UNSUPPORTED_ADDON_MODIFICATION: "UnsupportedAddonModification";
};
export type AddonIssueCode =
  (typeof AddonIssueCode)[keyof typeof AddonIssueCode];
export interface AddonIssue {
  code?: AddonIssueCode | undefined;
  message?: string | undefined;
  resourceIds?: string[] | undefined;
}
export interface AddonHealth {
  issues?: AddonIssue[] | undefined;
}
export interface MarketplaceInformation {
  productId?: string | undefined;
  productUrl?: string | undefined;
}
export declare const AddonStatus: {
  readonly ACTIVE: "ACTIVE";
  readonly CREATE_FAILED: "CREATE_FAILED";
  readonly CREATING: "CREATING";
  readonly DEGRADED: "DEGRADED";
  readonly DELETE_FAILED: "DELETE_FAILED";
  readonly DELETING: "DELETING";
  readonly UPDATE_FAILED: "UPDATE_FAILED";
  readonly UPDATING: "UPDATING";
};
export type AddonStatus = (typeof AddonStatus)[keyof typeof AddonStatus];
export interface Addon {
  addonName?: string | undefined;
  clusterName?: string | undefined;
  status?: AddonStatus | undefined;
  addonVersion?: string | undefined;
  health?: AddonHealth | undefined;
  addonArn?: string | undefined;
  createdAt?: Date | undefined;
  modifiedAt?: Date | undefined;
  serviceAccountRoleArn?: string | undefined;
  tags?: Record<string, string> | undefined;
  publisher?: string | undefined;
  owner?: string | undefined;
  marketplaceInformation?: MarketplaceInformation | undefined;
  configurationValues?: string | undefined;
  podIdentityAssociations?: string[] | undefined;
}
export interface AddonCompatibilityDetail {
  name?: string | undefined;
  compatibleVersions?: string[] | undefined;
}
export interface Compatibility {
  clusterVersion?: string | undefined;
  platformVersions?: string[] | undefined;
  defaultVersion?: boolean | undefined;
}
export interface AddonVersionInfo {
  addonVersion?: string | undefined;
  architecture?: string[] | undefined;
  computeTypes?: string[] | undefined;
  compatibilities?: Compatibility[] | undefined;
  requiresConfiguration?: boolean | undefined;
  requiresIamPermissions?: boolean | undefined;
}
export interface AddonInfo {
  addonName?: string | undefined;
  type?: string | undefined;
  addonVersions?: AddonVersionInfo[] | undefined;
  publisher?: string | undefined;
  owner?: string | undefined;
  marketplaceInformation?: MarketplaceInformation | undefined;
}
export interface AddonPodIdentityAssociations {
  serviceAccount: string | undefined;
  roleArn: string | undefined;
}
export interface AddonPodIdentityConfiguration {
  serviceAccount?: string | undefined;
  recommendedManagedPolicies?: string[] | undefined;
}
export declare const AMITypes: {
  readonly AL2023_ARM_64_NVIDIA: "AL2023_ARM_64_NVIDIA";
  readonly AL2023_ARM_64_STANDARD: "AL2023_ARM_64_STANDARD";
  readonly AL2023_x86_64_NEURON: "AL2023_x86_64_NEURON";
  readonly AL2023_x86_64_NVIDIA: "AL2023_x86_64_NVIDIA";
  readonly AL2023_x86_64_STANDARD: "AL2023_x86_64_STANDARD";
  readonly AL2_ARM_64: "AL2_ARM_64";
  readonly AL2_x86_64: "AL2_x86_64";
  readonly AL2_x86_64_GPU: "AL2_x86_64_GPU";
  readonly BOTTLEROCKET_ARM_64: "BOTTLEROCKET_ARM_64";
  readonly BOTTLEROCKET_ARM_64_FIPS: "BOTTLEROCKET_ARM_64_FIPS";
  readonly BOTTLEROCKET_ARM_64_NVIDIA: "BOTTLEROCKET_ARM_64_NVIDIA";
  readonly BOTTLEROCKET_x86_64: "BOTTLEROCKET_x86_64";
  readonly BOTTLEROCKET_x86_64_FIPS: "BOTTLEROCKET_x86_64_FIPS";
  readonly BOTTLEROCKET_x86_64_NVIDIA: "BOTTLEROCKET_x86_64_NVIDIA";
  readonly CUSTOM: "CUSTOM";
  readonly WINDOWS_CORE_2019_x86_64: "WINDOWS_CORE_2019_x86_64";
  readonly WINDOWS_CORE_2022_x86_64: "WINDOWS_CORE_2022_x86_64";
  readonly WINDOWS_FULL_2019_x86_64: "WINDOWS_FULL_2019_x86_64";
  readonly WINDOWS_FULL_2022_x86_64: "WINDOWS_FULL_2022_x86_64";
};
export type AMITypes = (typeof AMITypes)[keyof typeof AMITypes];
export interface AssociateAccessPolicyRequest {
  clusterName: string | undefined;
  principalArn: string | undefined;
  policyArn: string | undefined;
  accessScope: AccessScope | undefined;
}
export interface AssociatedAccessPolicy {
  policyArn?: string | undefined;
  accessScope?: AccessScope | undefined;
  associatedAt?: Date | undefined;
  modifiedAt?: Date | undefined;
}
export interface AssociateAccessPolicyResponse {
  clusterName?: string | undefined;
  principalArn?: string | undefined;
  associatedAccessPolicy?: AssociatedAccessPolicy | undefined;
}
export declare class InvalidParameterException extends __BaseException {
  readonly name: "InvalidParameterException";
  readonly $fault: "client";
  clusterName?: string | undefined;
  nodegroupName?: string | undefined;
  fargateProfileName?: string | undefined;
  addonName?: string | undefined;
  subscriptionId?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidParameterException, __BaseException>
  );
}
export declare class InvalidRequestException extends __BaseException {
  readonly name: "InvalidRequestException";
  readonly $fault: "client";
  clusterName?: string | undefined;
  nodegroupName?: string | undefined;
  addonName?: string | undefined;
  subscriptionId?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidRequestException, __BaseException>
  );
}
export declare class ResourceNotFoundException extends __BaseException {
  readonly name: "ResourceNotFoundException";
  readonly $fault: "client";
  clusterName?: string | undefined;
  nodegroupName?: string | undefined;
  fargateProfileName?: string | undefined;
  addonName?: string | undefined;
  subscriptionId?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<ResourceNotFoundException, __BaseException>
  );
}
export declare class ServerException extends __BaseException {
  readonly name: "ServerException";
  readonly $fault: "server";
  clusterName?: string | undefined;
  nodegroupName?: string | undefined;
  addonName?: string | undefined;
  subscriptionId?: string | undefined;
  constructor(opts: __ExceptionOptionType<ServerException, __BaseException>);
}
export interface Provider {
  keyArn?: string | undefined;
}
export interface EncryptionConfig {
  resources?: string[] | undefined;
  provider?: Provider | undefined;
}
export interface AssociateEncryptionConfigRequest {
  clusterName: string | undefined;
  encryptionConfig: EncryptionConfig[] | undefined;
  clientRequestToken?: string | undefined;
}
export declare const ErrorCode: {
  readonly ACCESS_DENIED: "AccessDenied";
  readonly ADMISSION_REQUEST_DENIED: "AdmissionRequestDenied";
  readonly CLUSTER_UNREACHABLE: "ClusterUnreachable";
  readonly CONFIGURATION_CONFLICT: "ConfigurationConflict";
  readonly ENI_LIMIT_REACHED: "EniLimitReached";
  readonly INSUFFICIENT_FREE_ADDRESSES: "InsufficientFreeAddresses";
  readonly INSUFFICIENT_NUMBER_OF_REPLICAS: "InsufficientNumberOfReplicas";
  readonly IP_NOT_AVAILABLE: "IpNotAvailable";
  readonly K8S_RESOURCE_NOT_FOUND: "K8sResourceNotFound";
  readonly NODE_CREATION_FAILURE: "NodeCreationFailure";
  readonly OPERATION_NOT_PERMITTED: "OperationNotPermitted";
  readonly POD_EVICTION_FAILURE: "PodEvictionFailure";
  readonly SECURITY_GROUP_NOT_FOUND: "SecurityGroupNotFound";
  readonly SUBNET_NOT_FOUND: "SubnetNotFound";
  readonly UNKNOWN: "Unknown";
  readonly UNSUPPORTED_ADDON_MODIFICATION: "UnsupportedAddonModification";
  readonly VPC_ID_NOT_FOUND: "VpcIdNotFound";
};
export type ErrorCode = (typeof ErrorCode)[keyof typeof ErrorCode];
export interface ErrorDetail {
  errorCode?: ErrorCode | undefined;
  errorMessage?: string | undefined;
  resourceIds?: string[] | undefined;
}
export declare const UpdateParamType: {
  readonly ADDON_VERSION: "AddonVersion";
  readonly AUTHENTICATION_MODE: "AuthenticationMode";
  readonly CLUSTER_LOGGING: "ClusterLogging";
  readonly COMPUTE_CONFIG: "ComputeConfig";
  readonly CONFIGURATION_VALUES: "ConfigurationValues";
  readonly DESIRED_SIZE: "DesiredSize";
  readonly ENCRYPTION_CONFIG: "EncryptionConfig";
  readonly ENDPOINT_PRIVATE_ACCESS: "EndpointPrivateAccess";
  readonly ENDPOINT_PUBLIC_ACCESS: "EndpointPublicAccess";
  readonly IDENTITY_PROVIDER_CONFIG: "IdentityProviderConfig";
  readonly KUBERNETES_NETWORK_CONFIG: "KubernetesNetworkConfig";
  readonly LABELS_TO_ADD: "LabelsToAdd";
  readonly LABELS_TO_REMOVE: "LabelsToRemove";
  readonly LAUNCH_TEMPLATE_NAME: "LaunchTemplateName";
  readonly LAUNCH_TEMPLATE_VERSION: "LaunchTemplateVersion";
  readonly MAX_SIZE: "MaxSize";
  readonly MAX_UNAVAILABLE: "MaxUnavailable";
  readonly MAX_UNAVAILABLE_PERCENTAGE: "MaxUnavailablePercentage";
  readonly MIN_SIZE: "MinSize";
  readonly NODE_REPAIR_ENABLED: "NodeRepairEnabled";
  readonly PLATFORM_VERSION: "PlatformVersion";
  readonly POD_IDENTITY_ASSOCIATIONS: "PodIdentityAssociations";
  readonly PUBLIC_ACCESS_CIDRS: "PublicAccessCidrs";
  readonly RELEASE_VERSION: "ReleaseVersion";
  readonly REMOTE_NETWORK_CONFIG: "RemoteNetworkConfig";
  readonly RESOLVE_CONFLICTS: "ResolveConflicts";
  readonly SECURITY_GROUPS: "SecurityGroups";
  readonly SERVICE_ACCOUNT_ROLE_ARN: "ServiceAccountRoleArn";
  readonly STORAGE_CONFIG: "StorageConfig";
  readonly SUBNETS: "Subnets";
  readonly TAINTS_TO_ADD: "TaintsToAdd";
  readonly TAINTS_TO_REMOVE: "TaintsToRemove";
  readonly UPDATE_STRATEGY: "UpdateStrategy";
  readonly UPGRADE_POLICY: "UpgradePolicy";
  readonly VERSION: "Version";
  readonly ZONAL_SHIFT_CONFIG: "ZonalShiftConfig";
};
export type UpdateParamType =
  (typeof UpdateParamType)[keyof typeof UpdateParamType];
export interface UpdateParam {
  type?: UpdateParamType | undefined;
  value?: string | undefined;
}
export declare const UpdateStatus: {
  readonly CANCELLED: "Cancelled";
  readonly FAILED: "Failed";
  readonly IN_PROGRESS: "InProgress";
  readonly SUCCESSFUL: "Successful";
};
export type UpdateStatus = (typeof UpdateStatus)[keyof typeof UpdateStatus];
export declare const UpdateType: {
  readonly ACCESS_CONFIG_UPDATE: "AccessConfigUpdate";
  readonly ADDON_UPDATE: "AddonUpdate";
  readonly ASSOCIATE_ENCRYPTION_CONFIG: "AssociateEncryptionConfig";
  readonly ASSOCIATE_IDENTITY_PROVIDER_CONFIG: "AssociateIdentityProviderConfig";
  readonly AUTO_MODE_UPDATE: "AutoModeUpdate";
  readonly CONFIG_UPDATE: "ConfigUpdate";
  readonly DISASSOCIATE_IDENTITY_PROVIDER_CONFIG: "DisassociateIdentityProviderConfig";
  readonly ENDPOINT_ACCESS_UPDATE: "EndpointAccessUpdate";
  readonly LOGGING_UPDATE: "LoggingUpdate";
  readonly REMOTE_NETWORK_CONFIG_UPDATE: "RemoteNetworkConfigUpdate";
  readonly UPGRADE_POLICY_UPDATE: "UpgradePolicyUpdate";
  readonly VERSION_UPDATE: "VersionUpdate";
  readonly VPC_CONFIG_UPDATE: "VpcConfigUpdate";
  readonly ZONAL_SHIFT_CONFIG_UPDATE: "ZonalShiftConfigUpdate";
};
export type UpdateType = (typeof UpdateType)[keyof typeof UpdateType];
export interface Update {
  id?: string | undefined;
  status?: UpdateStatus | undefined;
  type?: UpdateType | undefined;
  params?: UpdateParam[] | undefined;
  createdAt?: Date | undefined;
  errors?: ErrorDetail[] | undefined;
}
export interface AssociateEncryptionConfigResponse {
  update?: Update | undefined;
}
export declare class ClientException extends __BaseException {
  readonly name: "ClientException";
  readonly $fault: "client";
  clusterName?: string | undefined;
  nodegroupName?: string | undefined;
  addonName?: string | undefined;
  subscriptionId?: string | undefined;
  constructor(opts: __ExceptionOptionType<ClientException, __BaseException>);
}
export declare class ResourceInUseException extends __BaseException {
  readonly name: "ResourceInUseException";
  readonly $fault: "client";
  clusterName?: string | undefined;
  nodegroupName?: string | undefined;
  addonName?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<ResourceInUseException, __BaseException>
  );
}
export declare class ThrottlingException extends __BaseException {
  readonly name: "ThrottlingException";
  readonly $fault: "client";
  clusterName?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<ThrottlingException, __BaseException>
  );
}
export interface OidcIdentityProviderConfigRequest {
  identityProviderConfigName: string | undefined;
  issuerUrl: string | undefined;
  clientId: string | undefined;
  usernameClaim?: string | undefined;
  usernamePrefix?: string | undefined;
  groupsClaim?: string | undefined;
  groupsPrefix?: string | undefined;
  requiredClaims?: Record<string, string> | undefined;
}
export interface AssociateIdentityProviderConfigRequest {
  clusterName: string | undefined;
  oidc: OidcIdentityProviderConfigRequest | undefined;
  tags?: Record<string, string> | undefined;
  clientRequestToken?: string | undefined;
}
export interface AssociateIdentityProviderConfigResponse {
  update?: Update | undefined;
  tags?: Record<string, string> | undefined;
}
export interface AutoScalingGroup {
  name?: string | undefined;
}
export interface CreateAccessEntryRequest {
  clusterName: string | undefined;
  principalArn: string | undefined;
  kubernetesGroups?: string[] | undefined;
  tags?: Record<string, string> | undefined;
  clientRequestToken?: string | undefined;
  username?: string | undefined;
  type?: string | undefined;
}
export interface CreateAccessEntryResponse {
  accessEntry?: AccessEntry | undefined;
}
export declare class ResourceLimitExceededException extends __BaseException {
  readonly name: "ResourceLimitExceededException";
  readonly $fault: "client";
  clusterName?: string | undefined;
  nodegroupName?: string | undefined;
  subscriptionId?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<ResourceLimitExceededException, __BaseException>
  );
}
export declare const ResolveConflicts: {
  readonly NONE: "NONE";
  readonly OVERWRITE: "OVERWRITE";
  readonly PRESERVE: "PRESERVE";
};
export type ResolveConflicts =
  (typeof ResolveConflicts)[keyof typeof ResolveConflicts];
export interface CreateAddonRequest {
  clusterName: string | undefined;
  addonName: string | undefined;
  addonVersion?: string | undefined;
  serviceAccountRoleArn?: string | undefined;
  resolveConflicts?: ResolveConflicts | undefined;
  clientRequestToken?: string | undefined;
  tags?: Record<string, string> | undefined;
  configurationValues?: string | undefined;
  podIdentityAssociations?: AddonPodIdentityAssociations[] | undefined;
}
export interface CreateAddonResponse {
  addon?: Addon | undefined;
}
export interface CreateAccessConfigRequest {
  bootstrapClusterCreatorAdminPermissions?: boolean | undefined;
  authenticationMode?: AuthenticationMode | undefined;
}
export interface ComputeConfigRequest {
  enabled?: boolean | undefined;
  nodePools?: string[] | undefined;
  nodeRoleArn?: string | undefined;
}
export interface ElasticLoadBalancing {
  enabled?: boolean | undefined;
}
export declare const IpFamily: {
  readonly IPV4: "ipv4";
  readonly IPV6: "ipv6";
};
export type IpFamily = (typeof IpFamily)[keyof typeof IpFamily];
export interface KubernetesNetworkConfigRequest {
  serviceIpv4Cidr?: string | undefined;
  ipFamily?: IpFamily | undefined;
  elasticLoadBalancing?: ElasticLoadBalancing | undefined;
}
export declare const LogType: {
  readonly API: "api";
  readonly AUDIT: "audit";
  readonly AUTHENTICATOR: "authenticator";
  readonly CONTROLLER_MANAGER: "controllerManager";
  readonly SCHEDULER: "scheduler";
};
export type LogType = (typeof LogType)[keyof typeof LogType];
export interface LogSetup {
  types?: LogType[] | undefined;
  enabled?: boolean | undefined;
}
export interface Logging {
  clusterLogging?: LogSetup[] | undefined;
}
export interface ControlPlanePlacementRequest {
  groupName?: string | undefined;
}
export interface OutpostConfigRequest {
  outpostArns: string[] | undefined;
  controlPlaneInstanceType: string | undefined;
  controlPlanePlacement?: ControlPlanePlacementRequest | undefined;
}
export interface RemoteNodeNetwork {
  cidrs?: string[] | undefined;
}
export interface RemotePodNetwork {
  cidrs?: string[] | undefined;
}
export interface RemoteNetworkConfigRequest {
  remoteNodeNetworks?: RemoteNodeNetwork[] | undefined;
  remotePodNetworks?: RemotePodNetwork[] | undefined;
}
export interface VpcConfigRequest {
  subnetIds?: string[] | undefined;
  securityGroupIds?: string[] | undefined;
  endpointPublicAccess?: boolean | undefined;
  endpointPrivateAccess?: boolean | undefined;
  publicAccessCidrs?: string[] | undefined;
}
export interface BlockStorage {
  enabled?: boolean | undefined;
}
export interface StorageConfigRequest {
  blockStorage?: BlockStorage | undefined;
}
export declare const SupportType: {
  readonly EXTENDED: "EXTENDED";
  readonly STANDARD: "STANDARD";
};
export type SupportType = (typeof SupportType)[keyof typeof SupportType];
export interface UpgradePolicyRequest {
  supportType?: SupportType | undefined;
}
export interface ZonalShiftConfigRequest {
  enabled?: boolean | undefined;
}
export interface CreateClusterRequest {
  name: string | undefined;
  version?: string | undefined;
  roleArn: string | undefined;
  resourcesVpcConfig: VpcConfigRequest | undefined;
  kubernetesNetworkConfig?: KubernetesNetworkConfigRequest | undefined;
  logging?: Logging | undefined;
  clientRequestToken?: string | undefined;
  tags?: Record<string, string> | undefined;
  encryptionConfig?: EncryptionConfig[] | undefined;
  outpostConfig?: OutpostConfigRequest | undefined;
  accessConfig?: CreateAccessConfigRequest | undefined;
  bootstrapSelfManagedAddons?: boolean | undefined;
  upgradePolicy?: UpgradePolicyRequest | undefined;
  zonalShiftConfig?: ZonalShiftConfigRequest | undefined;
  remoteNetworkConfig?: RemoteNetworkConfigRequest | undefined;
  computeConfig?: ComputeConfigRequest | undefined;
  storageConfig?: StorageConfigRequest | undefined;
}
export interface Certificate {
  data?: string | undefined;
}
export interface ComputeConfigResponse {
  enabled?: boolean | undefined;
  nodePools?: string[] | undefined;
  nodeRoleArn?: string | undefined;
}
export interface ConnectorConfigResponse {
  activationId?: string | undefined;
  activationCode?: string | undefined;
  activationExpiry?: Date | undefined;
  provider?: string | undefined;
  roleArn?: string | undefined;
}
export declare const ClusterIssueCode: {
  readonly ACCESS_DENIED: "AccessDenied";
  readonly CLUSTER_UNREACHABLE: "ClusterUnreachable";
  readonly CONFIGURATION_CONFLICT: "ConfigurationConflict";
  readonly EC2_SECURITY_GROUP_NOT_FOUND: "Ec2SecurityGroupNotFound";
  readonly EC2_SERVICE_NOT_SUBSCRIBED: "Ec2ServiceNotSubscribed";
  readonly EC2_SUBNET_NOT_FOUND: "Ec2SubnetNotFound";
  readonly IAM_ROLE_NOT_FOUND: "IamRoleNotFound";
  readonly INSUFFICIENT_FREE_ADDRESSES: "InsufficientFreeAddresses";
  readonly INTERNAL_FAILURE: "InternalFailure";
  readonly KMS_GRANT_REVOKED: "KmsGrantRevoked";
  readonly KMS_KEY_DISABLED: "KmsKeyDisabled";
  readonly KMS_KEY_MARKED_FOR_DELETION: "KmsKeyMarkedForDeletion";
  readonly KMS_KEY_NOT_FOUND: "KmsKeyNotFound";
  readonly OTHER: "Other";
  readonly RESOURCE_LIMIT_EXCEEDED: "ResourceLimitExceeded";
  readonly RESOURCE_NOT_FOUND: "ResourceNotFound";
  readonly STS_REGIONAL_ENDPOINT_DISABLED: "StsRegionalEndpointDisabled";
  readonly UNSUPPORTED_VERSION: "UnsupportedVersion";
  readonly VPC_NOT_FOUND: "VpcNotFound";
};
export type ClusterIssueCode =
  (typeof ClusterIssueCode)[keyof typeof ClusterIssueCode];
export interface ClusterIssue {
  code?: ClusterIssueCode | undefined;
  message?: string | undefined;
  resourceIds?: string[] | undefined;
}
export interface ClusterHealth {
  issues?: ClusterIssue[] | undefined;
}
export interface OIDC {
  issuer?: string | undefined;
}
export interface Identity {
  oidc?: OIDC | undefined;
}
export interface KubernetesNetworkConfigResponse {
  serviceIpv4Cidr?: string | undefined;
  serviceIpv6Cidr?: string | undefined;
  ipFamily?: IpFamily | undefined;
  elasticLoadBalancing?: ElasticLoadBalancing | undefined;
}
export interface ControlPlanePlacementResponse {
  groupName?: string | undefined;
}
export interface OutpostConfigResponse {
  outpostArns: string[] | undefined;
  controlPlaneInstanceType: string | undefined;
  controlPlanePlacement?: ControlPlanePlacementResponse | undefined;
}
export interface RemoteNetworkConfigResponse {
  remoteNodeNetworks?: RemoteNodeNetwork[] | undefined;
  remotePodNetworks?: RemotePodNetwork[] | undefined;
}
export interface VpcConfigResponse {
  subnetIds?: string[] | undefined;
  securityGroupIds?: string[] | undefined;
  clusterSecurityGroupId?: string | undefined;
  vpcId?: string | undefined;
  endpointPublicAccess?: boolean | undefined;
  endpointPrivateAccess?: boolean | undefined;
  publicAccessCidrs?: string[] | undefined;
}
export declare const ClusterStatus: {
  readonly ACTIVE: "ACTIVE";
  readonly CREATING: "CREATING";
  readonly DELETING: "DELETING";
  readonly FAILED: "FAILED";
  readonly PENDING: "PENDING";
  readonly UPDATING: "UPDATING";
};
export type ClusterStatus = (typeof ClusterStatus)[keyof typeof ClusterStatus];
export interface StorageConfigResponse {
  blockStorage?: BlockStorage | undefined;
}
export interface UpgradePolicyResponse {
  supportType?: SupportType | undefined;
}
export interface ZonalShiftConfigResponse {
  enabled?: boolean | undefined;
}
export interface Cluster {
  name?: string | undefined;
  arn?: string | undefined;
  createdAt?: Date | undefined;
  version?: string | undefined;
  endpoint?: string | undefined;
  roleArn?: string | undefined;
  resourcesVpcConfig?: VpcConfigResponse | undefined;
  kubernetesNetworkConfig?: KubernetesNetworkConfigResponse | undefined;
  logging?: Logging | undefined;
  identity?: Identity | undefined;
  status?: ClusterStatus | undefined;
  certificateAuthority?: Certificate | undefined;
  clientRequestToken?: string | undefined;
  platformVersion?: string | undefined;
  tags?: Record<string, string> | undefined;
  encryptionConfig?: EncryptionConfig[] | undefined;
  connectorConfig?: ConnectorConfigResponse | undefined;
  id?: string | undefined;
  health?: ClusterHealth | undefined;
  outpostConfig?: OutpostConfigResponse | undefined;
  accessConfig?: AccessConfigResponse | undefined;
  upgradePolicy?: UpgradePolicyResponse | undefined;
  zonalShiftConfig?: ZonalShiftConfigResponse | undefined;
  remoteNetworkConfig?: RemoteNetworkConfigResponse | undefined;
  computeConfig?: ComputeConfigResponse | undefined;
  storageConfig?: StorageConfigResponse | undefined;
}
export interface CreateClusterResponse {
  cluster?: Cluster | undefined;
}
export declare class ServiceUnavailableException extends __BaseException {
  readonly name: "ServiceUnavailableException";
  readonly $fault: "server";
  constructor(
    opts: __ExceptionOptionType<ServiceUnavailableException, __BaseException>
  );
}
export declare class UnsupportedAvailabilityZoneException extends __BaseException {
  readonly name: "UnsupportedAvailabilityZoneException";
  readonly $fault: "client";
  clusterName?: string | undefined;
  nodegroupName?: string | undefined;
  validZones?: string[] | undefined;
  constructor(
    opts: __ExceptionOptionType<
      UnsupportedAvailabilityZoneException,
      __BaseException
    >
  );
}
export declare const EksAnywhereSubscriptionLicenseType: {
  readonly Cluster: "Cluster";
};
export type EksAnywhereSubscriptionLicenseType =
  (typeof EksAnywhereSubscriptionLicenseType)[keyof typeof EksAnywhereSubscriptionLicenseType];
export declare const EksAnywhereSubscriptionTermUnit: {
  readonly MONTHS: "MONTHS";
};
export type EksAnywhereSubscriptionTermUnit =
  (typeof EksAnywhereSubscriptionTermUnit)[keyof typeof EksAnywhereSubscriptionTermUnit];
export interface EksAnywhereSubscriptionTerm {
  duration?: number | undefined;
  unit?: EksAnywhereSubscriptionTermUnit | undefined;
}
export interface CreateEksAnywhereSubscriptionRequest {
  name: string | undefined;
  term: EksAnywhereSubscriptionTerm | undefined;
  licenseQuantity?: number | undefined;
  licenseType?: EksAnywhereSubscriptionLicenseType | undefined;
  autoRenew?: boolean | undefined;
  clientRequestToken?: string | undefined;
  tags?: Record<string, string> | undefined;
}
export interface License {
  id?: string | undefined;
  token?: string | undefined;
}
export interface EksAnywhereSubscription {
  id?: string | undefined;
  arn?: string | undefined;
  createdAt?: Date | undefined;
  effectiveDate?: Date | undefined;
  expirationDate?: Date | undefined;
  licenseQuantity?: number | undefined;
  licenseType?: EksAnywhereSubscriptionLicenseType | undefined;
  term?: EksAnywhereSubscriptionTerm | undefined;
  status?: string | undefined;
  autoRenew?: boolean | undefined;
  licenseArns?: string[] | undefined;
  licenses?: License[] | undefined;
  tags?: Record<string, string> | undefined;
}
export interface CreateEksAnywhereSubscriptionResponse {
  subscription?: EksAnywhereSubscription | undefined;
}
export interface FargateProfileSelector {
  namespace?: string | undefined;
  labels?: Record<string, string> | undefined;
}
export interface CreateFargateProfileRequest {
  fargateProfileName: string | undefined;
  clusterName: string | undefined;
  podExecutionRoleArn: string | undefined;
  subnets?: string[] | undefined;
  selectors?: FargateProfileSelector[] | undefined;
  clientRequestToken?: string | undefined;
  tags?: Record<string, string> | undefined;
}
export declare const FargateProfileIssueCode: {
  readonly ACCESS_DENIED: "AccessDenied";
  readonly CLUSTER_UNREACHABLE: "ClusterUnreachable";
  readonly INTERNAL_FAILURE: "InternalFailure";
  readonly POD_EXECUTION_ROLE_ALREADY_IN_USE: "PodExecutionRoleAlreadyInUse";
};
export type FargateProfileIssueCode =
  (typeof FargateProfileIssueCode)[keyof typeof FargateProfileIssueCode];
export interface FargateProfileIssue {
  code?: FargateProfileIssueCode | undefined;
  message?: string | undefined;
  resourceIds?: string[] | undefined;
}
export interface FargateProfileHealth {
  issues?: FargateProfileIssue[] | undefined;
}
export declare const FargateProfileStatus: {
  readonly ACTIVE: "ACTIVE";
  readonly CREATE_FAILED: "CREATE_FAILED";
  readonly CREATING: "CREATING";
  readonly DELETE_FAILED: "DELETE_FAILED";
  readonly DELETING: "DELETING";
};
export type FargateProfileStatus =
  (typeof FargateProfileStatus)[keyof typeof FargateProfileStatus];
export interface FargateProfile {
  fargateProfileName?: string | undefined;
  fargateProfileArn?: string | undefined;
  clusterName?: string | undefined;
  createdAt?: Date | undefined;
  podExecutionRoleArn?: string | undefined;
  subnets?: string[] | undefined;
  selectors?: FargateProfileSelector[] | undefined;
  status?: FargateProfileStatus | undefined;
  tags?: Record<string, string> | undefined;
  health?: FargateProfileHealth | undefined;
}
export interface CreateFargateProfileResponse {
  fargateProfile?: FargateProfile | undefined;
}
export declare const CapacityTypes: {
  readonly CAPACITY_BLOCK: "CAPACITY_BLOCK";
  readonly ON_DEMAND: "ON_DEMAND";
  readonly SPOT: "SPOT";
};
export type CapacityTypes = (typeof CapacityTypes)[keyof typeof CapacityTypes];
export interface LaunchTemplateSpecification {
  name?: string | undefined;
  version?: string | undefined;
  id?: string | undefined;
}
export interface NodeRepairConfig {
  enabled?: boolean | undefined;
}
export interface RemoteAccessConfig {
  ec2SshKey?: string | undefined;
  sourceSecurityGroups?: string[] | undefined;
}
export interface NodegroupScalingConfig {
  minSize?: number | undefined;
  maxSize?: number | undefined;
  desiredSize?: number | undefined;
}
export declare const TaintEffect: {
  readonly NO_EXECUTE: "NO_EXECUTE";
  readonly NO_SCHEDULE: "NO_SCHEDULE";
  readonly PREFER_NO_SCHEDULE: "PREFER_NO_SCHEDULE";
};
export type TaintEffect = (typeof TaintEffect)[keyof typeof TaintEffect];
export interface Taint {
  key?: string | undefined;
  value?: string | undefined;
  effect?: TaintEffect | undefined;
}
export declare const NodegroupUpdateStrategies: {
  readonly DEFAULT: "DEFAULT";
  readonly MINIMAL: "MINIMAL";
};
export type NodegroupUpdateStrategies =
  (typeof NodegroupUpdateStrategies)[keyof typeof NodegroupUpdateStrategies];
export interface NodegroupUpdateConfig {
  maxUnavailable?: number | undefined;
  maxUnavailablePercentage?: number | undefined;
  updateStrategy?: NodegroupUpdateStrategies | undefined;
}
export interface CreateNodegroupRequest {
  clusterName: string | undefined;
  nodegroupName: string | undefined;
  scalingConfig?: NodegroupScalingConfig | undefined;
  diskSize?: number | undefined;
  subnets: string[] | undefined;
  instanceTypes?: string[] | undefined;
  amiType?: AMITypes | undefined;
  remoteAccess?: RemoteAccessConfig | undefined;
  nodeRole: string | undefined;
  labels?: Record<string, string> | undefined;
  taints?: Taint[] | undefined;
  tags?: Record<string, string> | undefined;
  clientRequestToken?: string | undefined;
  launchTemplate?: LaunchTemplateSpecification | undefined;
  updateConfig?: NodegroupUpdateConfig | undefined;
  nodeRepairConfig?: NodeRepairConfig | undefined;
  capacityType?: CapacityTypes | undefined;
  version?: string | undefined;
  releaseVersion?: string | undefined;
}
export declare const NodegroupIssueCode: {
  readonly ACCESS_DENIED: "AccessDenied";
  readonly AMI_ID_NOT_FOUND: "AmiIdNotFound";
  readonly ASG_INSTANCE_LAUNCH_FAILURES: "AsgInstanceLaunchFailures";
  readonly AUTO_SCALING_GROUP_INSTANCE_REFRESH_ACTIVE: "AutoScalingGroupInstanceRefreshActive";
  readonly AUTO_SCALING_GROUP_INVALID_CONFIGURATION: "AutoScalingGroupInvalidConfiguration";
  readonly AUTO_SCALING_GROUP_NOT_FOUND: "AutoScalingGroupNotFound";
  readonly AUTO_SCALING_GROUP_OPT_IN_REQUIRED: "AutoScalingGroupOptInRequired";
  readonly AUTO_SCALING_GROUP_RATE_LIMIT_EXCEEDED: "AutoScalingGroupRateLimitExceeded";
  readonly CLUSTER_UNREACHABLE: "ClusterUnreachable";
  readonly EC2_INSTANCE_TYPE_DOES_NOT_EXIST: "Ec2InstanceTypeDoesNotExist";
  readonly EC2_LAUNCH_TEMPLATE_DELETION_FAILURE: "Ec2LaunchTemplateDeletionFailure";
  readonly EC2_LAUNCH_TEMPLATE_INVALID_CONFIGURATION: "Ec2LaunchTemplateInvalidConfiguration";
  readonly EC2_LAUNCH_TEMPLATE_MAX_LIMIT_EXCEEDED: "Ec2LaunchTemplateMaxLimitExceeded";
  readonly EC2_LAUNCH_TEMPLATE_NOT_FOUND: "Ec2LaunchTemplateNotFound";
  readonly EC2_LAUNCH_TEMPLATE_VERSION_MAX_LIMIT_EXCEEDED: "Ec2LaunchTemplateVersionMaxLimitExceeded";
  readonly EC2_LAUNCH_TEMPLATE_VERSION_MISMATCH: "Ec2LaunchTemplateVersionMismatch";
  readonly EC2_SECURITY_GROUP_DELETION_FAILURE: "Ec2SecurityGroupDeletionFailure";
  readonly EC2_SECURITY_GROUP_NOT_FOUND: "Ec2SecurityGroupNotFound";
  readonly EC2_SUBNET_INVALID_CONFIGURATION: "Ec2SubnetInvalidConfiguration";
  readonly EC2_SUBNET_LIST_TOO_LONG: "Ec2SubnetListTooLong";
  readonly EC2_SUBNET_MISSING_IPV6_ASSIGNMENT: "Ec2SubnetMissingIpv6Assignment";
  readonly EC2_SUBNET_NOT_FOUND: "Ec2SubnetNotFound";
  readonly IAM_INSTANCE_PROFILE_NOT_FOUND: "IamInstanceProfileNotFound";
  readonly IAM_LIMIT_EXCEEDED: "IamLimitExceeded";
  readonly IAM_NODE_ROLE_NOT_FOUND: "IamNodeRoleNotFound";
  readonly IAM_THROTTLING: "IamThrottling";
  readonly INSTANCE_LIMIT_EXCEEDED: "InstanceLimitExceeded";
  readonly INSUFFICIENT_FREE_ADDRESSES: "InsufficientFreeAddresses";
  readonly INTERNAL_FAILURE: "InternalFailure";
  readonly KUBERNETES_LABEL_INVALID: "KubernetesLabelInvalid";
  readonly LIMIT_EXCEEDED: "LimitExceeded";
  readonly NODE_CREATION_FAILURE: "NodeCreationFailure";
  readonly NODE_TERMINATION_FAILURE: "NodeTerminationFailure";
  readonly POD_EVICTION_FAILURE: "PodEvictionFailure";
  readonly SOURCE_EC2_LAUNCH_TEMPLATE_NOT_FOUND: "SourceEc2LaunchTemplateNotFound";
  readonly UNKNOWN: "Unknown";
};
export type NodegroupIssueCode =
  (typeof NodegroupIssueCode)[keyof typeof NodegroupIssueCode];
export interface Issue {
  code?: NodegroupIssueCode | undefined;
  message?: string | undefined;
  resourceIds?: string[] | undefined;
}
export interface NodegroupHealth {
  issues?: Issue[] | undefined;
}
export interface NodegroupResources {
  autoScalingGroups?: AutoScalingGroup[] | undefined;
  remoteAccessSecurityGroup?: string | undefined;
}
export declare const NodegroupStatus: {
  readonly ACTIVE: "ACTIVE";
  readonly CREATE_FAILED: "CREATE_FAILED";
  readonly CREATING: "CREATING";
  readonly DEGRADED: "DEGRADED";
  readonly DELETE_FAILED: "DELETE_FAILED";
  readonly DELETING: "DELETING";
  readonly UPDATING: "UPDATING";
};
export type NodegroupStatus =
  (typeof NodegroupStatus)[keyof typeof NodegroupStatus];
export interface Nodegroup {
  nodegroupName?: string | undefined;
  nodegroupArn?: string | undefined;
  clusterName?: string | undefined;
  version?: string | undefined;
  releaseVersion?: string | undefined;
  createdAt?: Date | undefined;
  modifiedAt?: Date | undefined;
  status?: NodegroupStatus | undefined;
  capacityType?: CapacityTypes | undefined;
  scalingConfig?: NodegroupScalingConfig | undefined;
  instanceTypes?: string[] | undefined;
  subnets?: string[] | undefined;
  remoteAccess?: RemoteAccessConfig | undefined;
  amiType?: AMITypes | undefined;
  nodeRole?: string | undefined;
  labels?: Record<string, string> | undefined;
  taints?: Taint[] | undefined;
  resources?: NodegroupResources | undefined;
  diskSize?: number | undefined;
  health?: NodegroupHealth | undefined;
  updateConfig?: NodegroupUpdateConfig | undefined;
  nodeRepairConfig?: NodeRepairConfig | undefined;
  launchTemplate?: LaunchTemplateSpecification | undefined;
  tags?: Record<string, string> | undefined;
}
export interface CreateNodegroupResponse {
  nodegroup?: Nodegroup | undefined;
}
export interface CreatePodIdentityAssociationRequest {
  clusterName: string | undefined;
  namespace: string | undefined;
  serviceAccount: string | undefined;
  roleArn: string | undefined;
  clientRequestToken?: string | undefined;
  tags?: Record<string, string> | undefined;
  disableSessionTags?: boolean | undefined;
  targetRoleArn?: string | undefined;
}
export interface PodIdentityAssociation {
  clusterName?: string | undefined;
  namespace?: string | undefined;
  serviceAccount?: string | undefined;
  roleArn?: string | undefined;
  associationArn?: string | undefined;
  associationId?: string | undefined;
  tags?: Record<string, string> | undefined;
  createdAt?: Date | undefined;
  modifiedAt?: Date | undefined;
  ownerArn?: string | undefined;
  disableSessionTags?: boolean | undefined;
  targetRoleArn?: string | undefined;
  externalId?: string | undefined;
}
export interface CreatePodIdentityAssociationResponse {
  association?: PodIdentityAssociation | undefined;
}
export interface DeleteAccessEntryRequest {
  clusterName: string | undefined;
  principalArn: string | undefined;
}
export interface DeleteAccessEntryResponse {}
export interface DeleteAddonRequest {
  clusterName: string | undefined;
  addonName: string | undefined;
  preserve?: boolean | undefined;
}
export interface DeleteAddonResponse {
  addon?: Addon | undefined;
}
export interface DeleteClusterRequest {
  name: string | undefined;
}
export interface DeleteClusterResponse {
  cluster?: Cluster | undefined;
}
export interface DeleteEksAnywhereSubscriptionRequest {
  id: string | undefined;
}
export interface DeleteEksAnywhereSubscriptionResponse {
  subscription?: EksAnywhereSubscription | undefined;
}
export interface DeleteFargateProfileRequest {
  clusterName: string | undefined;
  fargateProfileName: string | undefined;
}
export interface DeleteFargateProfileResponse {
  fargateProfile?: FargateProfile | undefined;
}
export interface DeleteNodegroupRequest {
  clusterName: string | undefined;
  nodegroupName: string | undefined;
}
export interface DeleteNodegroupResponse {
  nodegroup?: Nodegroup | undefined;
}
export interface DeletePodIdentityAssociationRequest {
  clusterName: string | undefined;
  associationId: string | undefined;
}
export interface DeletePodIdentityAssociationResponse {
  association?: PodIdentityAssociation | undefined;
}
export interface DeregisterClusterRequest {
  name: string | undefined;
}
export interface DeregisterClusterResponse {
  cluster?: Cluster | undefined;
}
export interface DescribeAccessEntryRequest {
  clusterName: string | undefined;
  principalArn: string | undefined;
}
export interface DescribeAccessEntryResponse {
  accessEntry?: AccessEntry | undefined;
}
export interface DescribeAddonRequest {
  clusterName: string | undefined;
  addonName: string | undefined;
}
export interface DescribeAddonResponse {
  addon?: Addon | undefined;
}
export interface DescribeAddonConfigurationRequest {
  addonName: string | undefined;
  addonVersion: string | undefined;
}
export interface DescribeAddonConfigurationResponse {
  addonName?: string | undefined;
  addonVersion?: string | undefined;
  configurationSchema?: string | undefined;
  podIdentityConfiguration?: AddonPodIdentityConfiguration[] | undefined;
}
export interface DescribeAddonVersionsRequest {
  kubernetesVersion?: string | undefined;
  maxResults?: number | undefined;
  nextToken?: string | undefined;
  addonName?: string | undefined;
  types?: string[] | undefined;
  publishers?: string[] | undefined;
  owners?: string[] | undefined;
}
export interface DescribeAddonVersionsResponse {
  addons?: AddonInfo[] | undefined;
  nextToken?: string | undefined;
}
export interface DescribeClusterRequest {
  name: string | undefined;
}
export interface DescribeClusterResponse {
  cluster?: Cluster | undefined;
}
export declare const ClusterVersionStatus: {
  readonly extended_support: "extended-support";
  readonly standard_support: "standard-support";
  readonly unsupported: "unsupported";
};
export type ClusterVersionStatus =
  (typeof ClusterVersionStatus)[keyof typeof ClusterVersionStatus];
export declare const VersionStatus: {
  readonly EXTENDED_SUPPORT: "EXTENDED_SUPPORT";
  readonly STANDARD_SUPPORT: "STANDARD_SUPPORT";
  readonly UNSUPPORTED: "UNSUPPORTED";
};
export type VersionStatus = (typeof VersionStatus)[keyof typeof VersionStatus];
export interface DescribeClusterVersionsRequest {
  clusterType?: string | undefined;
  maxResults?: number | undefined;
  nextToken?: string | undefined;
  defaultOnly?: boolean | undefined;
  includeAll?: boolean | undefined;
  clusterVersions?: string[] | undefined;
  status?: ClusterVersionStatus | undefined;
  versionStatus?: VersionStatus | undefined;
}
export interface ClusterVersionInformation {
  clusterVersion?: string | undefined;
  clusterType?: string | undefined;
  defaultPlatformVersion?: string | undefined;
  defaultVersion?: boolean | undefined;
  releaseDate?: Date | undefined;
  endOfStandardSupportDate?: Date | undefined;
  endOfExtendedSupportDate?: Date | undefined;
  status?: ClusterVersionStatus | undefined;
  versionStatus?: VersionStatus | undefined;
  kubernetesPatchVersion?: string | undefined;
}
export interface DescribeClusterVersionsResponse {
  nextToken?: string | undefined;
  clusterVersions?: ClusterVersionInformation[] | undefined;
}
export interface DescribeEksAnywhereSubscriptionRequest {
  id: string | undefined;
}
export interface DescribeEksAnywhereSubscriptionResponse {
  subscription?: EksAnywhereSubscription | undefined;
}
export interface DescribeFargateProfileRequest {
  clusterName: string | undefined;
  fargateProfileName: string | undefined;
}
export interface DescribeFargateProfileResponse {
  fargateProfile?: FargateProfile | undefined;
}
export interface IdentityProviderConfig {
  type: string | undefined;
  name: string | undefined;
}
export interface DescribeIdentityProviderConfigRequest {
  clusterName: string | undefined;
  identityProviderConfig: IdentityProviderConfig | undefined;
}
export declare const ConfigStatus: {
  readonly ACTIVE: "ACTIVE";
  readonly CREATING: "CREATING";
  readonly DELETING: "DELETING";
};
export type ConfigStatus = (typeof ConfigStatus)[keyof typeof ConfigStatus];
export interface OidcIdentityProviderConfig {
  identityProviderConfigName?: string | undefined;
  identityProviderConfigArn?: string | undefined;
  clusterName?: string | undefined;
  issuerUrl?: string | undefined;
  clientId?: string | undefined;
  usernameClaim?: string | undefined;
  usernamePrefix?: string | undefined;
  groupsClaim?: string | undefined;
  groupsPrefix?: string | undefined;
  requiredClaims?: Record<string, string> | undefined;
  tags?: Record<string, string> | undefined;
  status?: ConfigStatus | undefined;
}
export interface IdentityProviderConfigResponse {
  oidc?: OidcIdentityProviderConfig | undefined;
}
export interface DescribeIdentityProviderConfigResponse {
  identityProviderConfig?: IdentityProviderConfigResponse | undefined;
}
export interface DescribeInsightRequest {
  clusterName: string | undefined;
  id: string | undefined;
}
export declare const Category: {
  readonly MISCONFIGURATION: "MISCONFIGURATION";
  readonly UPGRADE_READINESS: "UPGRADE_READINESS";
};
export type Category = (typeof Category)[keyof typeof Category];
export interface ClientStat {
  userAgent?: string | undefined;
  numberOfRequestsLast30Days?: number | undefined;
  lastRequestTime?: Date | undefined;
}
export interface DeprecationDetail {
  usage?: string | undefined;
  replacedWith?: string | undefined;
  stopServingVersion?: string | undefined;
  startServingReplacementVersion?: string | undefined;
  clientStats?: ClientStat[] | undefined;
}
export interface InsightCategorySpecificSummary {
  deprecationDetails?: DeprecationDetail[] | undefined;
  addonCompatibilityDetails?: AddonCompatibilityDetail[] | undefined;
}
export declare const InsightStatusValue: {
  readonly ERROR: "ERROR";
  readonly PASSING: "PASSING";
  readonly UNKNOWN: "UNKNOWN";
  readonly WARNING: "WARNING";
};
export type InsightStatusValue =
  (typeof InsightStatusValue)[keyof typeof InsightStatusValue];
export interface InsightStatus {
  status?: InsightStatusValue | undefined;
  reason?: string | undefined;
}
export interface InsightResourceDetail {
  insightStatus?: InsightStatus | undefined;
  kubernetesResourceUri?: string | undefined;
  arn?: string | undefined;
}
export interface Insight {
  id?: string | undefined;
  name?: string | undefined;
  category?: Category | undefined;
  kubernetesVersion?: string | undefined;
  lastRefreshTime?: Date | undefined;
  lastTransitionTime?: Date | undefined;
  description?: string | undefined;
  insightStatus?: InsightStatus | undefined;
  recommendation?: string | undefined;
  additionalInfo?: Record<string, string> | undefined;
  resources?: InsightResourceDetail[] | undefined;
  categorySpecificSummary?: InsightCategorySpecificSummary | undefined;
}
export interface DescribeInsightResponse {
  insight?: Insight | undefined;
}
export interface DescribeNodegroupRequest {
  clusterName: string | undefined;
  nodegroupName: string | undefined;
}
export interface DescribeNodegroupResponse {
  nodegroup?: Nodegroup | undefined;
}
export interface DescribePodIdentityAssociationRequest {
  clusterName: string | undefined;
  associationId: string | undefined;
}
export interface DescribePodIdentityAssociationResponse {
  association?: PodIdentityAssociation | undefined;
}
export interface DescribeUpdateRequest {
  name: string | undefined;
  updateId: string | undefined;
  nodegroupName?: string | undefined;
  addonName?: string | undefined;
}
export interface DescribeUpdateResponse {
  update?: Update | undefined;
}
export interface DisassociateAccessPolicyRequest {
  clusterName: string | undefined;
  principalArn: string | undefined;
  policyArn: string | undefined;
}
export interface DisassociateAccessPolicyResponse {}
export interface DisassociateIdentityProviderConfigRequest {
  clusterName: string | undefined;
  identityProviderConfig: IdentityProviderConfig | undefined;
  clientRequestToken?: string | undefined;
}
export interface DisassociateIdentityProviderConfigResponse {
  update?: Update | undefined;
}
export interface ListAccessEntriesRequest {
  clusterName: string | undefined;
  associatedPolicyArn?: string | undefined;
  maxResults?: number | undefined;
  nextToken?: string | undefined;
}
export interface ListAccessEntriesResponse {
  accessEntries?: string[] | undefined;
  nextToken?: string | undefined;
}
export interface ListAccessPoliciesRequest {
  maxResults?: number | undefined;
  nextToken?: string | undefined;
}
export interface ListAccessPoliciesResponse {
  accessPolicies?: AccessPolicy[] | undefined;
  nextToken?: string | undefined;
}
export interface ListAddonsRequest {
  clusterName: string | undefined;
  maxResults?: number | undefined;
  nextToken?: string | undefined;
}
export interface ListAddonsResponse {
  addons?: string[] | undefined;
  nextToken?: string | undefined;
}
export interface ListAssociatedAccessPoliciesRequest {
  clusterName: string | undefined;
  principalArn: string | undefined;
  maxResults?: number | undefined;
  nextToken?: string | undefined;
}
export interface ListAssociatedAccessPoliciesResponse {
  clusterName?: string | undefined;
  principalArn?: string | undefined;
  nextToken?: string | undefined;
  associatedAccessPolicies?: AssociatedAccessPolicy[] | undefined;
}
export interface ListClustersRequest {
  maxResults?: number | undefined;
  nextToken?: string | undefined;
  include?: string[] | undefined;
}
export interface ListClustersResponse {
  clusters?: string[] | undefined;
  nextToken?: string | undefined;
}
export declare const EksAnywhereSubscriptionStatus: {
  readonly ACTIVE: "ACTIVE";
  readonly CREATING: "CREATING";
  readonly DELETING: "DELETING";
  readonly EXPIRED: "EXPIRED";
  readonly EXPIRING: "EXPIRING";
  readonly UPDATING: "UPDATING";
};
export type EksAnywhereSubscriptionStatus =
  (typeof EksAnywhereSubscriptionStatus)[keyof typeof EksAnywhereSubscriptionStatus];
export interface ListEksAnywhereSubscriptionsRequest {
  maxResults?: number | undefined;
  nextToken?: string | undefined;
  includeStatus?: EksAnywhereSubscriptionStatus[] | undefined;
}
export interface ListEksAnywhereSubscriptionsResponse {
  subscriptions?: EksAnywhereSubscription[] | undefined;
  nextToken?: string | undefined;
}
export interface ListFargateProfilesRequest {
  clusterName: string | undefined;
  maxResults?: number | undefined;
  nextToken?: string | undefined;
}
export interface ListFargateProfilesResponse {
  fargateProfileNames?: string[] | undefined;
  nextToken?: string | undefined;
}
export interface ListIdentityProviderConfigsRequest {
  clusterName: string | undefined;
  maxResults?: number | undefined;
  nextToken?: string | undefined;
}
export interface ListIdentityProviderConfigsResponse {
  identityProviderConfigs?: IdentityProviderConfig[] | undefined;
  nextToken?: string | undefined;
}
export interface InsightsFilter {
  categories?: Category[] | undefined;
  kubernetesVersions?: string[] | undefined;
  statuses?: InsightStatusValue[] | undefined;
}
export interface ListInsightsRequest {
  clusterName: string | undefined;
  filter?: InsightsFilter | undefined;
  maxResults?: number | undefined;
  nextToken?: string | undefined;
}
export interface InsightSummary {
  id?: string | undefined;
  name?: string | undefined;
  category?: Category | undefined;
  kubernetesVersion?: string | undefined;
  lastRefreshTime?: Date | undefined;
  lastTransitionTime?: Date | undefined;
  description?: string | undefined;
  insightStatus?: InsightStatus | undefined;
}
export interface ListInsightsResponse {
  insights?: InsightSummary[] | undefined;
  nextToken?: string | undefined;
}
export interface ListNodegroupsRequest {
  clusterName: string | undefined;
  maxResults?: number | undefined;
  nextToken?: string | undefined;
}
export interface ListNodegroupsResponse {
  nodegroups?: string[] | undefined;
  nextToken?: string | undefined;
}
export interface ListPodIdentityAssociationsRequest {
  clusterName: string | undefined;
  namespace?: string | undefined;
  serviceAccount?: string | undefined;
  maxResults?: number | undefined;
  nextToken?: string | undefined;
}
export interface PodIdentityAssociationSummary {
  clusterName?: string | undefined;
  namespace?: string | undefined;
  serviceAccount?: string | undefined;
  associationArn?: string | undefined;
  associationId?: string | undefined;
  ownerArn?: string | undefined;
}
export interface ListPodIdentityAssociationsResponse {
  associations?: PodIdentityAssociationSummary[] | undefined;
  nextToken?: string | undefined;
}
export declare class BadRequestException extends __BaseException {
  readonly name: "BadRequestException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<BadRequestException, __BaseException>
  );
}
export interface ListTagsForResourceRequest {
  resourceArn: string | undefined;
}
export interface ListTagsForResourceResponse {
  tags?: Record<string, string> | undefined;
}
export declare class NotFoundException extends __BaseException {
  readonly name: "NotFoundException";
  readonly $fault: "client";
  constructor(opts: __ExceptionOptionType<NotFoundException, __BaseException>);
}
export interface ListUpdatesRequest {
  name: string | undefined;
  nodegroupName?: string | undefined;
  addonName?: string | undefined;
  nextToken?: string | undefined;
  maxResults?: number | undefined;
}
export interface ListUpdatesResponse {
  updateIds?: string[] | undefined;
  nextToken?: string | undefined;
}
export declare const ConnectorConfigProvider: {
  readonly AKS: "AKS";
  readonly ANTHOS: "ANTHOS";
  readonly EC2: "EC2";
  readonly EKS_ANYWHERE: "EKS_ANYWHERE";
  readonly GKE: "GKE";
  readonly OPENSHIFT: "OPENSHIFT";
  readonly OTHER: "OTHER";
  readonly RANCHER: "RANCHER";
  readonly TANZU: "TANZU";
};
export type ConnectorConfigProvider =
  (typeof ConnectorConfigProvider)[keyof typeof ConnectorConfigProvider];
export interface ConnectorConfigRequest {
  roleArn: string | undefined;
  provider: ConnectorConfigProvider | undefined;
}
export interface RegisterClusterRequest {
  name: string | undefined;
  connectorConfig: ConnectorConfigRequest | undefined;
  clientRequestToken?: string | undefined;
  tags?: Record<string, string> | undefined;
}
export interface RegisterClusterResponse {
  cluster?: Cluster | undefined;
}
export declare class ResourcePropagationDelayException extends __BaseException {
  readonly name: "ResourcePropagationDelayException";
  readonly $fault: "client";
  constructor(
    opts: __ExceptionOptionType<
      ResourcePropagationDelayException,
      __BaseException
    >
  );
}
export interface TagResourceRequest {
  resourceArn: string | undefined;
  tags: Record<string, string> | undefined;
}
export interface TagResourceResponse {}
export interface UntagResourceRequest {
  resourceArn: string | undefined;
  tagKeys: string[] | undefined;
}
export interface UntagResourceResponse {}
export interface UpdateAccessEntryRequest {
  clusterName: string | undefined;
  principalArn: string | undefined;
  kubernetesGroups?: string[] | undefined;
  clientRequestToken?: string | undefined;
  username?: string | undefined;
}
export interface UpdateAccessEntryResponse {
  accessEntry?: AccessEntry | undefined;
}
export interface UpdateAddonRequest {
  clusterName: string | undefined;
  addonName: string | undefined;
  addonVersion?: string | undefined;
  serviceAccountRoleArn?: string | undefined;
  resolveConflicts?: ResolveConflicts | undefined;
  clientRequestToken?: string | undefined;
  configurationValues?: string | undefined;
  podIdentityAssociations?: AddonPodIdentityAssociations[] | undefined;
}
export interface UpdateAddonResponse {
  update?: Update | undefined;
}
export interface UpdateAccessConfigRequest {
  authenticationMode?: AuthenticationMode | undefined;
}
export interface UpdateClusterConfigRequest {
  name: string | undefined;
  resourcesVpcConfig?: VpcConfigRequest | undefined;
  logging?: Logging | undefined;
  clientRequestToken?: string | undefined;
  accessConfig?: UpdateAccessConfigRequest | undefined;
  upgradePolicy?: UpgradePolicyRequest | undefined;
  zonalShiftConfig?: ZonalShiftConfigRequest | undefined;
  computeConfig?: ComputeConfigRequest | undefined;
  kubernetesNetworkConfig?: KubernetesNetworkConfigRequest | undefined;
  storageConfig?: StorageConfigRequest | undefined;
  remoteNetworkConfig?: RemoteNetworkConfigRequest | undefined;
}
export interface UpdateClusterConfigResponse {
  update?: Update | undefined;
}
export declare class InvalidStateException extends __BaseException {
  readonly name: "InvalidStateException";
  readonly $fault: "client";
  clusterName?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidStateException, __BaseException>
  );
}
export interface UpdateClusterVersionRequest {
  name: string | undefined;
  version: string | undefined;
  clientRequestToken?: string | undefined;
  force?: boolean | undefined;
}
export interface UpdateClusterVersionResponse {
  update?: Update | undefined;
}
export interface UpdateEksAnywhereSubscriptionRequest {
  id: string | undefined;
  autoRenew: boolean | undefined;
  clientRequestToken?: string | undefined;
}
export interface UpdateEksAnywhereSubscriptionResponse {
  subscription?: EksAnywhereSubscription | undefined;
}
export interface UpdateLabelsPayload {
  addOrUpdateLabels?: Record<string, string> | undefined;
  removeLabels?: string[] | undefined;
}
export interface UpdateTaintsPayload {
  addOrUpdateTaints?: Taint[] | undefined;
  removeTaints?: Taint[] | undefined;
}
export interface UpdateNodegroupConfigRequest {
  clusterName: string | undefined;
  nodegroupName: string | undefined;
  labels?: UpdateLabelsPayload | undefined;
  taints?: UpdateTaintsPayload | undefined;
  scalingConfig?: NodegroupScalingConfig | undefined;
  updateConfig?: NodegroupUpdateConfig | undefined;
  nodeRepairConfig?: NodeRepairConfig | undefined;
  clientRequestToken?: string | undefined;
}
export interface UpdateNodegroupConfigResponse {
  update?: Update | undefined;
}
export interface UpdateNodegroupVersionRequest {
  clusterName: string | undefined;
  nodegroupName: string | undefined;
  version?: string | undefined;
  releaseVersion?: string | undefined;
  launchTemplate?: LaunchTemplateSpecification | undefined;
  force?: boolean | undefined;
  clientRequestToken?: string | undefined;
}
export interface UpdateNodegroupVersionResponse {
  update?: Update | undefined;
}
export interface UpdatePodIdentityAssociationRequest {
  clusterName: string | undefined;
  associationId: string | undefined;
  roleArn?: string | undefined;
  clientRequestToken?: string | undefined;
  disableSessionTags?: boolean | undefined;
  targetRoleArn?: string | undefined;
}
export interface UpdatePodIdentityAssociationResponse {
  association?: PodIdentityAssociation | undefined;
}
