/**
 * <p>Amazon Elastic Kubernetes Service (Amazon EKS) is a managed service that makes it easy for you to run Kubernetes on
 *             Amazon Web Services without needing to setup or maintain your own Kubernetes control plane. Kubernetes is an
 *             open-source system for automating the deployment, scaling, and management of
 *             containerized applications.</p>
 *          <p>Amazon EKS runs up-to-date versions of the open-source Kubernetes software, so you can use all
 *             the existing plugins and tooling from the Kubernetes community. Applications running on Amazon EKS
 *             are fully compatible with applications running on any standard Kubernetes environment,
 *             whether running in on-premises data centers or public clouds. This means that you can
 *             easily migrate any standard Kubernetes application to Amazon EKS without any code modification
 *             required.</p>
 *
 * @packageDocumentation
 */
export * from "./EKSClient";
export * from "./EKS";
export { ClientInputEndpointParameters } from "./endpoint/EndpointParameters";
export type { RuntimeExtension } from "./runtimeExtensions";
export type { EKSExtensionConfiguration } from "./extensionConfiguration";
export * from "./commands";
export * from "./pagination";
export * from "./waiters";
export * from "./models";
export { EKSServiceException } from "./models/EKSServiceException";
