import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EKSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EKSClient";
import { UpdateEksAnywhereSubscriptionRequest, UpdateEksAnywhereSubscriptionResponse } from "../models/models_0";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link UpdateEksAnywhereSubscriptionCommand}.
 */
export interface UpdateEksAnywhereSubscriptionCommandInput extends UpdateEksAnywhereSubscriptionRequest {
}
/**
 * @public
 *
 * The output of {@link UpdateEksAnywhereSubscriptionCommand}.
 */
export interface UpdateEksAnywhereSubscriptionCommandOutput extends UpdateEksAnywhereSubscriptionResponse, __MetadataBearer {
}
declare const UpdateEksAnywhereSubscriptionCommand_base: {
    new (input: UpdateEksAnywhereSubscriptionCommandInput): import("@smithy/smithy-client").CommandImpl<UpdateEksAnywhereSubscriptionCommandInput, UpdateEksAnywhereSubscriptionCommandOutput, EKSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: UpdateEksAnywhereSubscriptionCommandInput): import("@smithy/smithy-client").CommandImpl<UpdateEksAnywhereSubscriptionCommandInput, UpdateEksAnywhereSubscriptionCommandOutput, EKSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Update an EKS Anywhere Subscription. Only auto renewal and tags can be updated after
 *             subscription creation.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EKSClient, UpdateEksAnywhereSubscriptionCommand } from "@aws-sdk/client-eks"; // ES Modules import
 * // const { EKSClient, UpdateEksAnywhereSubscriptionCommand } = require("@aws-sdk/client-eks"); // CommonJS import
 * const client = new EKSClient(config);
 * const input = { // UpdateEksAnywhereSubscriptionRequest
 *   id: "STRING_VALUE", // required
 *   autoRenew: true || false, // required
 *   clientRequestToken: "STRING_VALUE",
 * };
 * const command = new UpdateEksAnywhereSubscriptionCommand(input);
 * const response = await client.send(command);
 * // { // UpdateEksAnywhereSubscriptionResponse
 * //   subscription: { // EksAnywhereSubscription
 * //     id: "STRING_VALUE",
 * //     arn: "STRING_VALUE",
 * //     createdAt: new Date("TIMESTAMP"),
 * //     effectiveDate: new Date("TIMESTAMP"),
 * //     expirationDate: new Date("TIMESTAMP"),
 * //     licenseQuantity: Number("int"),
 * //     licenseType: "Cluster",
 * //     term: { // EksAnywhereSubscriptionTerm
 * //       duration: Number("int"),
 * //       unit: "MONTHS",
 * //     },
 * //     status: "STRING_VALUE",
 * //     autoRenew: true || false,
 * //     licenseArns: [ // StringList
 * //       "STRING_VALUE",
 * //     ],
 * //     licenses: [ // LicenseList
 * //       { // License
 * //         id: "STRING_VALUE",
 * //         token: "STRING_VALUE",
 * //       },
 * //     ],
 * //     tags: { // TagMap
 * //       "<keys>": "STRING_VALUE",
 * //     },
 * //   },
 * // };
 *
 * ```
 *
 * @param UpdateEksAnywhereSubscriptionCommandInput - {@link UpdateEksAnywhereSubscriptionCommandInput}
 * @returns {@link UpdateEksAnywhereSubscriptionCommandOutput}
 * @see {@link UpdateEksAnywhereSubscriptionCommandInput} for command's `input` shape.
 * @see {@link UpdateEksAnywhereSubscriptionCommandOutput} for command's `response` shape.
 * @see {@link EKSClientResolvedConfig | config} for EKSClient's `config` shape.
 *
 * @throws {@link ClientException} (client fault)
 *  <p>These errors are usually caused by a client action. Actions can include using an
 *             action or resource on behalf of an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html">IAM principal</a> that doesn't have permissions to use
 *             the action or resource or specifying an identifier that is not valid.</p>
 *
 * @throws {@link InvalidParameterException} (client fault)
 *  <p>The specified parameter is invalid. Review the available parameters for the API
 *             request.</p>
 *
 * @throws {@link InvalidRequestException} (client fault)
 *  <p>The request is invalid given the state of the cluster. Check the state of the cluster
 *             and the associated operations.</p>
 *
 * @throws {@link ResourceNotFoundException} (client fault)
 *  <p>The specified resource could not be found. You can view your available clusters with
 *                 <code>ListClusters</code>. You can view your available managed node groups with
 *                 <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Amazon Web Services Region
 *             specific.</p>
 *
 * @throws {@link ServerException} (server fault)
 *  <p>These errors are usually caused by a server-side issue.</p>
 *
 * @throws {@link EKSServiceException}
 * <p>Base exception class for all service exceptions from EKS service.</p>
 *
 *
 * @public
 */
export declare class UpdateEksAnywhereSubscriptionCommand extends UpdateEksAnywhereSubscriptionCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: UpdateEksAnywhereSubscriptionRequest;
            output: UpdateEksAnywhereSubscriptionResponse;
        };
        sdk: {
            input: UpdateEksAnywhereSubscriptionCommandInput;
            output: UpdateEksAnywhereSubscriptionCommandOutput;
        };
    };
}
