import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EKSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EKSClient";
import { ListAccessEntriesRequest, ListAccessEntriesResponse } from "../models/models_0";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link ListAccessEntriesCommand}.
 */
export interface ListAccessEntriesCommandInput extends ListAccessEntriesRequest {
}
/**
 * @public
 *
 * The output of {@link ListAccessEntriesCommand}.
 */
export interface ListAccessEntriesCommandOutput extends ListAccessEntriesResponse, __MetadataBearer {
}
declare const ListAccessEntriesCommand_base: {
    new (input: ListAccessEntriesCommandInput): import("@smithy/smithy-client").CommandImpl<ListAccessEntriesCommandInput, ListAccessEntriesCommandOutput, EKSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: ListAccessEntriesCommandInput): import("@smithy/smithy-client").CommandImpl<ListAccessEntriesCommandInput, ListAccessEntriesCommandOutput, EKSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Lists the access entries for your cluster.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EKSClient, ListAccessEntriesCommand } from "@aws-sdk/client-eks"; // ES Modules import
 * // const { EKSClient, ListAccessEntriesCommand } = require("@aws-sdk/client-eks"); // CommonJS import
 * const client = new EKSClient(config);
 * const input = { // ListAccessEntriesRequest
 *   clusterName: "STRING_VALUE", // required
 *   associatedPolicyArn: "STRING_VALUE",
 *   maxResults: Number("int"),
 *   nextToken: "STRING_VALUE",
 * };
 * const command = new ListAccessEntriesCommand(input);
 * const response = await client.send(command);
 * // { // ListAccessEntriesResponse
 * //   accessEntries: [ // StringList
 * //     "STRING_VALUE",
 * //   ],
 * //   nextToken: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param ListAccessEntriesCommandInput - {@link ListAccessEntriesCommandInput}
 * @returns {@link ListAccessEntriesCommandOutput}
 * @see {@link ListAccessEntriesCommandInput} for command's `input` shape.
 * @see {@link ListAccessEntriesCommandOutput} for command's `response` shape.
 * @see {@link EKSClientResolvedConfig | config} for EKSClient's `config` shape.
 *
 * @throws {@link InvalidParameterException} (client fault)
 *  <p>The specified parameter is invalid. Review the available parameters for the API
 *             request.</p>
 *
 * @throws {@link InvalidRequestException} (client fault)
 *  <p>The request is invalid given the state of the cluster. Check the state of the cluster
 *             and the associated operations.</p>
 *
 * @throws {@link ResourceNotFoundException} (client fault)
 *  <p>The specified resource could not be found. You can view your available clusters with
 *                 <code>ListClusters</code>. You can view your available managed node groups with
 *                 <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Amazon Web Services Region
 *             specific.</p>
 *
 * @throws {@link ServerException} (server fault)
 *  <p>These errors are usually caused by a server-side issue.</p>
 *
 * @throws {@link EKSServiceException}
 * <p>Base exception class for all service exceptions from EKS service.</p>
 *
 *
 * @public
 */
export declare class ListAccessEntriesCommand extends ListAccessEntriesCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: ListAccessEntriesRequest;
            output: ListAccessEntriesResponse;
        };
        sdk: {
            input: ListAccessEntriesCommandInput;
            output: ListAccessEntriesCommandOutput;
        };
    };
}
