import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EKSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EKSClient";
import { DisassociateAccessPolicyRequest, DisassociateAccessPolicyResponse } from "../models/models_0";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DisassociateAccessPolicyCommand}.
 */
export interface DisassociateAccessPolicyCommandInput extends DisassociateAccessPolicyRequest {
}
/**
 * @public
 *
 * The output of {@link DisassociateAccessPolicyCommand}.
 */
export interface DisassociateAccessPolicyCommandOutput extends DisassociateAccessPolicyResponse, __MetadataBearer {
}
declare const DisassociateAccessPolicyCommand_base: {
    new (input: DisassociateAccessPolicyCommandInput): import("@smithy/smithy-client").CommandImpl<DisassociateAccessPolicyCommandInput, DisassociateAccessPolicyCommandOutput, EKSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DisassociateAccessPolicyCommandInput): import("@smithy/smithy-client").CommandImpl<DisassociateAccessPolicyCommandInput, DisassociateAccessPolicyCommandOutput, EKSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Disassociates an access policy from an access entry.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EKSClient, DisassociateAccessPolicyCommand } from "@aws-sdk/client-eks"; // ES Modules import
 * // const { EKSClient, DisassociateAccessPolicyCommand } = require("@aws-sdk/client-eks"); // CommonJS import
 * const client = new EKSClient(config);
 * const input = { // DisassociateAccessPolicyRequest
 *   clusterName: "STRING_VALUE", // required
 *   principalArn: "STRING_VALUE", // required
 *   policyArn: "STRING_VALUE", // required
 * };
 * const command = new DisassociateAccessPolicyCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param DisassociateAccessPolicyCommandInput - {@link DisassociateAccessPolicyCommandInput}
 * @returns {@link DisassociateAccessPolicyCommandOutput}
 * @see {@link DisassociateAccessPolicyCommandInput} for command's `input` shape.
 * @see {@link DisassociateAccessPolicyCommandOutput} for command's `response` shape.
 * @see {@link EKSClientResolvedConfig | config} for EKSClient's `config` shape.
 *
 * @throws {@link InvalidRequestException} (client fault)
 *  <p>The request is invalid given the state of the cluster. Check the state of the cluster
 *             and the associated operations.</p>
 *
 * @throws {@link ResourceNotFoundException} (client fault)
 *  <p>The specified resource could not be found. You can view your available clusters with
 *                 <code>ListClusters</code>. You can view your available managed node groups with
 *                 <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Amazon Web Services Region
 *             specific.</p>
 *
 * @throws {@link ServerException} (server fault)
 *  <p>These errors are usually caused by a server-side issue.</p>
 *
 * @throws {@link EKSServiceException}
 * <p>Base exception class for all service exceptions from EKS service.</p>
 *
 *
 * @public
 */
export declare class DisassociateAccessPolicyCommand extends DisassociateAccessPolicyCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DisassociateAccessPolicyRequest;
            output: {};
        };
        sdk: {
            input: DisassociateAccessPolicyCommandInput;
            output: DisassociateAccessPolicyCommandOutput;
        };
    };
}
