import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EKSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EKSClient";
import { DescribePodIdentityAssociationRequest, DescribePodIdentityAssociationResponse } from "../models/models_0";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DescribePodIdentityAssociationCommand}.
 */
export interface DescribePodIdentityAssociationCommandInput extends DescribePodIdentityAssociationRequest {
}
/**
 * @public
 *
 * The output of {@link DescribePodIdentityAssociationCommand}.
 */
export interface DescribePodIdentityAssociationCommandOutput extends DescribePodIdentityAssociationResponse, __MetadataBearer {
}
declare const DescribePodIdentityAssociationCommand_base: {
    new (input: DescribePodIdentityAssociationCommandInput): import("@smithy/smithy-client").CommandImpl<DescribePodIdentityAssociationCommandInput, DescribePodIdentityAssociationCommandOutput, EKSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DescribePodIdentityAssociationCommandInput): import("@smithy/smithy-client").CommandImpl<DescribePodIdentityAssociationCommandInput, DescribePodIdentityAssociationCommandOutput, EKSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Returns descriptive information about an EKS Pod Identity association.</p>
 *          <p>This action requires the ID of the association. You can get the ID from the response to
 *             the <code>CreatePodIdentityAssocation</code> for newly created associations. Or, you can
 *             list the IDs for associations with <code>ListPodIdentityAssociations</code> and filter the
 *             list by namespace or service account.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EKSClient, DescribePodIdentityAssociationCommand } from "@aws-sdk/client-eks"; // ES Modules import
 * // const { EKSClient, DescribePodIdentityAssociationCommand } = require("@aws-sdk/client-eks"); // CommonJS import
 * const client = new EKSClient(config);
 * const input = { // DescribePodIdentityAssociationRequest
 *   clusterName: "STRING_VALUE", // required
 *   associationId: "STRING_VALUE", // required
 * };
 * const command = new DescribePodIdentityAssociationCommand(input);
 * const response = await client.send(command);
 * // { // DescribePodIdentityAssociationResponse
 * //   association: { // PodIdentityAssociation
 * //     clusterName: "STRING_VALUE",
 * //     namespace: "STRING_VALUE",
 * //     serviceAccount: "STRING_VALUE",
 * //     roleArn: "STRING_VALUE",
 * //     associationArn: "STRING_VALUE",
 * //     associationId: "STRING_VALUE",
 * //     tags: { // TagMap
 * //       "<keys>": "STRING_VALUE",
 * //     },
 * //     createdAt: new Date("TIMESTAMP"),
 * //     modifiedAt: new Date("TIMESTAMP"),
 * //     ownerArn: "STRING_VALUE",
 * //     disableSessionTags: true || false,
 * //     targetRoleArn: "STRING_VALUE",
 * //     externalId: "STRING_VALUE",
 * //   },
 * // };
 *
 * ```
 *
 * @param DescribePodIdentityAssociationCommandInput - {@link DescribePodIdentityAssociationCommandInput}
 * @returns {@link DescribePodIdentityAssociationCommandOutput}
 * @see {@link DescribePodIdentityAssociationCommandInput} for command's `input` shape.
 * @see {@link DescribePodIdentityAssociationCommandOutput} for command's `response` shape.
 * @see {@link EKSClientResolvedConfig | config} for EKSClient's `config` shape.
 *
 * @throws {@link InvalidParameterException} (client fault)
 *  <p>The specified parameter is invalid. Review the available parameters for the API
 *             request.</p>
 *
 * @throws {@link InvalidRequestException} (client fault)
 *  <p>The request is invalid given the state of the cluster. Check the state of the cluster
 *             and the associated operations.</p>
 *
 * @throws {@link ResourceNotFoundException} (client fault)
 *  <p>The specified resource could not be found. You can view your available clusters with
 *                 <code>ListClusters</code>. You can view your available managed node groups with
 *                 <code>ListNodegroups</code>. Amazon EKS clusters and node groups are Amazon Web Services Region
 *             specific.</p>
 *
 * @throws {@link ServerException} (server fault)
 *  <p>These errors are usually caused by a server-side issue.</p>
 *
 * @throws {@link EKSServiceException}
 * <p>Base exception class for all service exceptions from EKS service.</p>
 *
 *
 * @public
 */
export declare class DescribePodIdentityAssociationCommand extends DescribePodIdentityAssociationCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DescribePodIdentityAssociationRequest;
            output: DescribePodIdentityAssociationResponse;
        };
        sdk: {
            input: DescribePodIdentityAssociationCommandInput;
            output: DescribePodIdentityAssociationCommandOutput;
        };
    };
}
