import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { EKSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../EKSClient";
import { CreateEksAnywhereSubscriptionRequest, CreateEksAnywhereSubscriptionResponse } from "../models/models_0";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link CreateEksAnywhereSubscriptionCommand}.
 */
export interface CreateEksAnywhereSubscriptionCommandInput extends CreateEksAnywhereSubscriptionRequest {
}
/**
 * @public
 *
 * The output of {@link CreateEksAnywhereSubscriptionCommand}.
 */
export interface CreateEksAnywhereSubscriptionCommandOutput extends CreateEksAnywhereSubscriptionResponse, __MetadataBearer {
}
declare const CreateEksAnywhereSubscriptionCommand_base: {
    new (input: CreateEksAnywhereSubscriptionCommandInput): import("@smithy/smithy-client").CommandImpl<CreateEksAnywhereSubscriptionCommandInput, CreateEksAnywhereSubscriptionCommandOutput, EKSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: CreateEksAnywhereSubscriptionCommandInput): import("@smithy/smithy-client").CommandImpl<CreateEksAnywhereSubscriptionCommandInput, CreateEksAnywhereSubscriptionCommandOutput, EKSClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Creates an EKS Anywhere subscription. When a subscription is created, it is a contract
 *             agreement for the length of the term specified in the request. Licenses that are used to
 *             validate support are provisioned in Amazon Web Services License Manager and the caller account is
 *             granted access to EKS Anywhere Curated Packages.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { EKSClient, CreateEksAnywhereSubscriptionCommand } from "@aws-sdk/client-eks"; // ES Modules import
 * // const { EKSClient, CreateEksAnywhereSubscriptionCommand } = require("@aws-sdk/client-eks"); // CommonJS import
 * const client = new EKSClient(config);
 * const input = { // CreateEksAnywhereSubscriptionRequest
 *   name: "STRING_VALUE", // required
 *   term: { // EksAnywhereSubscriptionTerm
 *     duration: Number("int"),
 *     unit: "MONTHS",
 *   },
 *   licenseQuantity: Number("int"),
 *   licenseType: "Cluster",
 *   autoRenew: true || false,
 *   clientRequestToken: "STRING_VALUE",
 *   tags: { // TagMap
 *     "<keys>": "STRING_VALUE",
 *   },
 * };
 * const command = new CreateEksAnywhereSubscriptionCommand(input);
 * const response = await client.send(command);
 * // { // CreateEksAnywhereSubscriptionResponse
 * //   subscription: { // EksAnywhereSubscription
 * //     id: "STRING_VALUE",
 * //     arn: "STRING_VALUE",
 * //     createdAt: new Date("TIMESTAMP"),
 * //     effectiveDate: new Date("TIMESTAMP"),
 * //     expirationDate: new Date("TIMESTAMP"),
 * //     licenseQuantity: Number("int"),
 * //     licenseType: "Cluster",
 * //     term: { // EksAnywhereSubscriptionTerm
 * //       duration: Number("int"),
 * //       unit: "MONTHS",
 * //     },
 * //     status: "STRING_VALUE",
 * //     autoRenew: true || false,
 * //     licenseArns: [ // StringList
 * //       "STRING_VALUE",
 * //     ],
 * //     licenses: [ // LicenseList
 * //       { // License
 * //         id: "STRING_VALUE",
 * //         token: "STRING_VALUE",
 * //       },
 * //     ],
 * //     tags: { // TagMap
 * //       "<keys>": "STRING_VALUE",
 * //     },
 * //   },
 * // };
 *
 * ```
 *
 * @param CreateEksAnywhereSubscriptionCommandInput - {@link CreateEksAnywhereSubscriptionCommandInput}
 * @returns {@link CreateEksAnywhereSubscriptionCommandOutput}
 * @see {@link CreateEksAnywhereSubscriptionCommandInput} for command's `input` shape.
 * @see {@link CreateEksAnywhereSubscriptionCommandOutput} for command's `response` shape.
 * @see {@link EKSClientResolvedConfig | config} for EKSClient's `config` shape.
 *
 * @throws {@link ClientException} (client fault)
 *  <p>These errors are usually caused by a client action. Actions can include using an
 *             action or resource on behalf of an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html">IAM principal</a> that doesn't have permissions to use
 *             the action or resource or specifying an identifier that is not valid.</p>
 *
 * @throws {@link InvalidParameterException} (client fault)
 *  <p>The specified parameter is invalid. Review the available parameters for the API
 *             request.</p>
 *
 * @throws {@link ResourceLimitExceededException} (client fault)
 *  <p>You have encountered a service limit on the specified resource.</p>
 *
 * @throws {@link ServerException} (server fault)
 *  <p>These errors are usually caused by a server-side issue.</p>
 *
 * @throws {@link ServiceUnavailableException} (server fault)
 *  <p>The service is unavailable. Back off and retry the operation.</p>
 *
 * @throws {@link EKSServiceException}
 * <p>Base exception class for all service exceptions from EKS service.</p>
 *
 *
 * @public
 */
export declare class CreateEksAnywhereSubscriptionCommand extends CreateEksAnywhereSubscriptionCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: CreateEksAnywhereSubscriptionRequest;
            output: CreateEksAnywhereSubscriptionResponse;
        };
        sdk: {
            input: CreateEksAnywhereSubscriptionCommandInput;
            output: CreateEksAnywhereSubscriptionCommandOutput;
        };
    };
}
