import { checkExceptions, createWaiter, WaiterState } from "@smithy/util-waiter";
import { DescribeAddonCommand } from "../commands/DescribeAddonCommand";
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new DescribeAddonCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                return result.addon.status;
            };
            if (returnComparator() === "DELETE_FAILED") {
                return { state: WaiterState.FAILURE, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "ResourceNotFoundException") {
            return { state: WaiterState.SUCCESS, reason };
        }
    }
    return { state: WaiterState.RETRY, reason };
};
export const waitForAddonDeleted = async (params, input) => {
    const serviceDefaults = { minDelay: 10, maxDelay: 120 };
    return createWaiter({ ...serviceDefaults, ...params }, input, checkState);
};
export const waitUntilAddonDeleted = async (params, input) => {
    const serviceDefaults = { minDelay: 10, maxDelay: 120 };
    const result = await createWaiter({ ...serviceDefaults, ...params }, input, checkState);
    return checkExceptions(result);
};
