import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DescribeIdentityProviderConfigCommand, se_DescribeIdentityProviderConfigCommand, } from "../protocols/Aws_restJson1";
export { $Command };
export class DescribeIdentityProviderConfigCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AWSWesleyFrontend", "DescribeIdentityProviderConfig", {})
    .n("EKSClient", "DescribeIdentityProviderConfigCommand")
    .f(void 0, void 0)
    .ser(se_DescribeIdentityProviderConfigCommand)
    .de(de_DescribeIdentityProviderConfigCommand)
    .build() {
}
