import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DeleteAddonCommand, se_DeleteAddonCommand } from "../protocols/Aws_restJson1";
export { $Command };
export class DeleteAddonCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("AWSWesleyFrontend", "DeleteAddon", {})
    .n("EKSClient", "DeleteAddonCommand")
    .f(void 0, void 0)
    .ser(se_DeleteAddonCommand)
    .de(de_DeleteAddonCommand)
    .build() {
}
