"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  AMITypes: () => AMITypes,
  AccessDeniedException: () => AccessDeniedException,
  AccessScopeType: () => AccessScopeType,
  AddonIssueCode: () => AddonIssueCode,
  AddonStatus: () => AddonStatus,
  AssociateAccessPolicyCommand: () => AssociateAccessPolicyCommand,
  AssociateEncryptionConfigCommand: () => AssociateEncryptionConfigCommand,
  AssociateIdentityProviderConfigCommand: () => AssociateIdentityProviderConfigCommand,
  AuthenticationMode: () => AuthenticationMode,
  BadRequestException: () => BadRequestException,
  CapacityTypes: () => CapacityTypes,
  Category: () => Category,
  ClientException: () => ClientException,
  ClusterIssueCode: () => ClusterIssueCode,
  ClusterStatus: () => ClusterStatus,
  ClusterVersionStatus: () => ClusterVersionStatus,
  ConfigStatus: () => ConfigStatus,
  ConnectorConfigProvider: () => ConnectorConfigProvider,
  CreateAccessEntryCommand: () => CreateAccessEntryCommand,
  CreateAddonCommand: () => CreateAddonCommand,
  CreateClusterCommand: () => CreateClusterCommand,
  CreateEksAnywhereSubscriptionCommand: () => CreateEksAnywhereSubscriptionCommand,
  CreateFargateProfileCommand: () => CreateFargateProfileCommand,
  CreateNodegroupCommand: () => CreateNodegroupCommand,
  CreatePodIdentityAssociationCommand: () => CreatePodIdentityAssociationCommand,
  DeleteAccessEntryCommand: () => DeleteAccessEntryCommand,
  DeleteAddonCommand: () => DeleteAddonCommand,
  DeleteClusterCommand: () => DeleteClusterCommand,
  DeleteEksAnywhereSubscriptionCommand: () => DeleteEksAnywhereSubscriptionCommand,
  DeleteFargateProfileCommand: () => DeleteFargateProfileCommand,
  DeleteNodegroupCommand: () => DeleteNodegroupCommand,
  DeletePodIdentityAssociationCommand: () => DeletePodIdentityAssociationCommand,
  DeregisterClusterCommand: () => DeregisterClusterCommand,
  DescribeAccessEntryCommand: () => DescribeAccessEntryCommand,
  DescribeAddonCommand: () => DescribeAddonCommand,
  DescribeAddonConfigurationCommand: () => DescribeAddonConfigurationCommand,
  DescribeAddonVersionsCommand: () => DescribeAddonVersionsCommand,
  DescribeClusterCommand: () => DescribeClusterCommand,
  DescribeClusterVersionsCommand: () => DescribeClusterVersionsCommand,
  DescribeEksAnywhereSubscriptionCommand: () => DescribeEksAnywhereSubscriptionCommand,
  DescribeFargateProfileCommand: () => DescribeFargateProfileCommand,
  DescribeIdentityProviderConfigCommand: () => DescribeIdentityProviderConfigCommand,
  DescribeInsightCommand: () => DescribeInsightCommand,
  DescribeNodegroupCommand: () => DescribeNodegroupCommand,
  DescribePodIdentityAssociationCommand: () => DescribePodIdentityAssociationCommand,
  DescribeUpdateCommand: () => DescribeUpdateCommand,
  DisassociateAccessPolicyCommand: () => DisassociateAccessPolicyCommand,
  DisassociateIdentityProviderConfigCommand: () => DisassociateIdentityProviderConfigCommand,
  EKS: () => EKS,
  EKSClient: () => EKSClient,
  EKSServiceException: () => EKSServiceException,
  EksAnywhereSubscriptionLicenseType: () => EksAnywhereSubscriptionLicenseType,
  EksAnywhereSubscriptionStatus: () => EksAnywhereSubscriptionStatus,
  EksAnywhereSubscriptionTermUnit: () => EksAnywhereSubscriptionTermUnit,
  ErrorCode: () => ErrorCode,
  FargateProfileIssueCode: () => FargateProfileIssueCode,
  FargateProfileStatus: () => FargateProfileStatus,
  InsightStatusValue: () => InsightStatusValue,
  InvalidParameterException: () => InvalidParameterException,
  InvalidRequestException: () => InvalidRequestException,
  InvalidStateException: () => InvalidStateException,
  IpFamily: () => IpFamily,
  ListAccessEntriesCommand: () => ListAccessEntriesCommand,
  ListAccessPoliciesCommand: () => ListAccessPoliciesCommand,
  ListAddonsCommand: () => ListAddonsCommand,
  ListAssociatedAccessPoliciesCommand: () => ListAssociatedAccessPoliciesCommand,
  ListClustersCommand: () => ListClustersCommand,
  ListEksAnywhereSubscriptionsCommand: () => ListEksAnywhereSubscriptionsCommand,
  ListFargateProfilesCommand: () => ListFargateProfilesCommand,
  ListIdentityProviderConfigsCommand: () => ListIdentityProviderConfigsCommand,
  ListInsightsCommand: () => ListInsightsCommand,
  ListNodegroupsCommand: () => ListNodegroupsCommand,
  ListPodIdentityAssociationsCommand: () => ListPodIdentityAssociationsCommand,
  ListTagsForResourceCommand: () => ListTagsForResourceCommand,
  ListUpdatesCommand: () => ListUpdatesCommand,
  LogType: () => LogType,
  NodegroupIssueCode: () => NodegroupIssueCode,
  NodegroupStatus: () => NodegroupStatus,
  NodegroupUpdateStrategies: () => NodegroupUpdateStrategies,
  NotFoundException: () => NotFoundException,
  RegisterClusterCommand: () => RegisterClusterCommand,
  ResolveConflicts: () => ResolveConflicts,
  ResourceInUseException: () => ResourceInUseException,
  ResourceLimitExceededException: () => ResourceLimitExceededException,
  ResourceNotFoundException: () => ResourceNotFoundException,
  ResourcePropagationDelayException: () => ResourcePropagationDelayException,
  ServerException: () => ServerException,
  ServiceUnavailableException: () => ServiceUnavailableException,
  SupportType: () => SupportType,
  TagResourceCommand: () => TagResourceCommand,
  TaintEffect: () => TaintEffect,
  ThrottlingException: () => ThrottlingException,
  UnsupportedAvailabilityZoneException: () => UnsupportedAvailabilityZoneException,
  UntagResourceCommand: () => UntagResourceCommand,
  UpdateAccessEntryCommand: () => UpdateAccessEntryCommand,
  UpdateAddonCommand: () => UpdateAddonCommand,
  UpdateClusterConfigCommand: () => UpdateClusterConfigCommand,
  UpdateClusterVersionCommand: () => UpdateClusterVersionCommand,
  UpdateEksAnywhereSubscriptionCommand: () => UpdateEksAnywhereSubscriptionCommand,
  UpdateNodegroupConfigCommand: () => UpdateNodegroupConfigCommand,
  UpdateNodegroupVersionCommand: () => UpdateNodegroupVersionCommand,
  UpdateParamType: () => UpdateParamType,
  UpdatePodIdentityAssociationCommand: () => UpdatePodIdentityAssociationCommand,
  UpdateStatus: () => UpdateStatus,
  UpdateType: () => UpdateType,
  VersionStatus: () => VersionStatus,
  __Client: () => import_smithy_client.Client,
  paginateDescribeAddonVersions: () => paginateDescribeAddonVersions,
  paginateDescribeClusterVersions: () => paginateDescribeClusterVersions,
  paginateListAccessEntries: () => paginateListAccessEntries,
  paginateListAccessPolicies: () => paginateListAccessPolicies,
  paginateListAddons: () => paginateListAddons,
  paginateListAssociatedAccessPolicies: () => paginateListAssociatedAccessPolicies,
  paginateListClusters: () => paginateListClusters,
  paginateListEksAnywhereSubscriptions: () => paginateListEksAnywhereSubscriptions,
  paginateListFargateProfiles: () => paginateListFargateProfiles,
  paginateListIdentityProviderConfigs: () => paginateListIdentityProviderConfigs,
  paginateListInsights: () => paginateListInsights,
  paginateListNodegroups: () => paginateListNodegroups,
  paginateListPodIdentityAssociations: () => paginateListPodIdentityAssociations,
  paginateListUpdates: () => paginateListUpdates,
  waitForAddonActive: () => waitForAddonActive,
  waitForAddonDeleted: () => waitForAddonDeleted,
  waitForClusterActive: () => waitForClusterActive,
  waitForClusterDeleted: () => waitForClusterDeleted,
  waitForFargateProfileActive: () => waitForFargateProfileActive,
  waitForFargateProfileDeleted: () => waitForFargateProfileDeleted,
  waitForNodegroupActive: () => waitForNodegroupActive,
  waitForNodegroupDeleted: () => waitForNodegroupDeleted,
  waitUntilAddonActive: () => waitUntilAddonActive,
  waitUntilAddonDeleted: () => waitUntilAddonDeleted,
  waitUntilClusterActive: () => waitUntilClusterActive,
  waitUntilClusterDeleted: () => waitUntilClusterDeleted,
  waitUntilFargateProfileActive: () => waitUntilFargateProfileActive,
  waitUntilFargateProfileDeleted: () => waitUntilFargateProfileDeleted,
  waitUntilNodegroupActive: () => waitUntilNodegroupActive,
  waitUntilNodegroupDeleted: () => waitUntilNodegroupDeleted
});
module.exports = __toCommonJS(index_exports);

// src/EKSClient.ts
var import_middleware_host_header = require("@aws-sdk/middleware-host-header");
var import_middleware_logger = require("@aws-sdk/middleware-logger");
var import_middleware_recursion_detection = require("@aws-sdk/middleware-recursion-detection");
var import_middleware_user_agent = require("@aws-sdk/middleware-user-agent");
var import_config_resolver = require("@smithy/config-resolver");
var import_core = require("@smithy/core");
var import_middleware_content_length = require("@smithy/middleware-content-length");
var import_middleware_endpoint = require("@smithy/middleware-endpoint");
var import_middleware_retry = require("@smithy/middleware-retry");

var import_httpAuthSchemeProvider = require("./auth/httpAuthSchemeProvider");

// src/endpoint/EndpointParameters.ts
var resolveClientEndpointParameters = /* @__PURE__ */ __name((options) => {
  return Object.assign(options, {
    useDualstackEndpoint: options.useDualstackEndpoint ?? false,
    useFipsEndpoint: options.useFipsEndpoint ?? false,
    defaultSigningName: "eks"
  });
}, "resolveClientEndpointParameters");
var commonParams = {
  UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
  Endpoint: { type: "builtInParams", name: "endpoint" },
  Region: { type: "builtInParams", name: "region" },
  UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" }
};

// src/EKSClient.ts
var import_runtimeConfig = require("././runtimeConfig");

// src/runtimeExtensions.ts
var import_region_config_resolver = require("@aws-sdk/region-config-resolver");
var import_protocol_http = require("@smithy/protocol-http");
var import_smithy_client = require("@smithy/smithy-client");

// src/auth/httpAuthExtensionConfiguration.ts
var getHttpAuthExtensionConfiguration = /* @__PURE__ */ __name((runtimeConfig) => {
  const _httpAuthSchemes = runtimeConfig.httpAuthSchemes;
  let _httpAuthSchemeProvider = runtimeConfig.httpAuthSchemeProvider;
  let _credentials = runtimeConfig.credentials;
  return {
    setHttpAuthScheme(httpAuthScheme) {
      const index = _httpAuthSchemes.findIndex((scheme) => scheme.schemeId === httpAuthScheme.schemeId);
      if (index === -1) {
        _httpAuthSchemes.push(httpAuthScheme);
      } else {
        _httpAuthSchemes.splice(index, 1, httpAuthScheme);
      }
    },
    httpAuthSchemes() {
      return _httpAuthSchemes;
    },
    setHttpAuthSchemeProvider(httpAuthSchemeProvider) {
      _httpAuthSchemeProvider = httpAuthSchemeProvider;
    },
    httpAuthSchemeProvider() {
      return _httpAuthSchemeProvider;
    },
    setCredentials(credentials) {
      _credentials = credentials;
    },
    credentials() {
      return _credentials;
    }
  };
}, "getHttpAuthExtensionConfiguration");
var resolveHttpAuthRuntimeConfig = /* @__PURE__ */ __name((config) => {
  return {
    httpAuthSchemes: config.httpAuthSchemes(),
    httpAuthSchemeProvider: config.httpAuthSchemeProvider(),
    credentials: config.credentials()
  };
}, "resolveHttpAuthRuntimeConfig");

// src/runtimeExtensions.ts
var resolveRuntimeExtensions = /* @__PURE__ */ __name((runtimeConfig, extensions) => {
  const extensionConfiguration = Object.assign(
    (0, import_region_config_resolver.getAwsRegionExtensionConfiguration)(runtimeConfig),
    (0, import_smithy_client.getDefaultExtensionConfiguration)(runtimeConfig),
    (0, import_protocol_http.getHttpHandlerExtensionConfiguration)(runtimeConfig),
    getHttpAuthExtensionConfiguration(runtimeConfig)
  );
  extensions.forEach((extension) => extension.configure(extensionConfiguration));
  return Object.assign(
    runtimeConfig,
    (0, import_region_config_resolver.resolveAwsRegionExtensionConfiguration)(extensionConfiguration),
    (0, import_smithy_client.resolveDefaultRuntimeConfig)(extensionConfiguration),
    (0, import_protocol_http.resolveHttpHandlerRuntimeConfig)(extensionConfiguration),
    resolveHttpAuthRuntimeConfig(extensionConfiguration)
  );
}, "resolveRuntimeExtensions");

// src/EKSClient.ts
var EKSClient = class extends import_smithy_client.Client {
  static {
    __name(this, "EKSClient");
  }
  /**
   * The resolved configuration of EKSClient class. This is resolved and normalized from the {@link EKSClientConfig | constructor configuration interface}.
   */
  config;
  constructor(...[configuration]) {
    const _config_0 = (0, import_runtimeConfig.getRuntimeConfig)(configuration || {});
    super(_config_0);
    this.initConfig = _config_0;
    const _config_1 = resolveClientEndpointParameters(_config_0);
    const _config_2 = (0, import_middleware_user_agent.resolveUserAgentConfig)(_config_1);
    const _config_3 = (0, import_middleware_retry.resolveRetryConfig)(_config_2);
    const _config_4 = (0, import_config_resolver.resolveRegionConfig)(_config_3);
    const _config_5 = (0, import_middleware_host_header.resolveHostHeaderConfig)(_config_4);
    const _config_6 = (0, import_middleware_endpoint.resolveEndpointConfig)(_config_5);
    const _config_7 = (0, import_httpAuthSchemeProvider.resolveHttpAuthSchemeConfig)(_config_6);
    const _config_8 = resolveRuntimeExtensions(_config_7, configuration?.extensions || []);
    this.config = _config_8;
    this.middlewareStack.use((0, import_middleware_user_agent.getUserAgentPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_retry.getRetryPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_content_length.getContentLengthPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_host_header.getHostHeaderPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_logger.getLoggerPlugin)(this.config));
    this.middlewareStack.use((0, import_middleware_recursion_detection.getRecursionDetectionPlugin)(this.config));
    this.middlewareStack.use(
      (0, import_core.getHttpAuthSchemeEndpointRuleSetPlugin)(this.config, {
        httpAuthSchemeParametersProvider: import_httpAuthSchemeProvider.defaultEKSHttpAuthSchemeParametersProvider,
        identityProviderConfigProvider: /* @__PURE__ */ __name(async (config) => new import_core.DefaultIdentityProviderConfig({
          "aws.auth#sigv4": config.credentials
        }), "identityProviderConfigProvider")
      })
    );
    this.middlewareStack.use((0, import_core.getHttpSigningPlugin)(this.config));
  }
  /**
   * Destroy underlying resources, like sockets. It's usually not necessary to do this.
   * However in Node.js, it's best to explicitly shut down the client's agent when it is no longer needed.
   * Otherwise, sockets might stay open for quite a long time before the server terminates them.
   */
  destroy() {
    super.destroy();
  }
};

// src/EKS.ts


// src/commands/AssociateAccessPolicyCommand.ts

var import_middleware_serde = require("@smithy/middleware-serde");


// src/protocols/Aws_restJson1.ts
var import_core2 = require("@aws-sdk/core");


var import_uuid = require("uuid");

// src/models/EKSServiceException.ts

var EKSServiceException = class _EKSServiceException extends import_smithy_client.ServiceException {
  static {
    __name(this, "EKSServiceException");
  }
  /**
   * @internal
   */
  constructor(options) {
    super(options);
    Object.setPrototypeOf(this, _EKSServiceException.prototype);
  }
};

// src/models/models_0.ts
var AuthenticationMode = {
  API: "API",
  API_AND_CONFIG_MAP: "API_AND_CONFIG_MAP",
  CONFIG_MAP: "CONFIG_MAP"
};
var AccessDeniedException = class _AccessDeniedException extends EKSServiceException {
  static {
    __name(this, "AccessDeniedException");
  }
  name = "AccessDeniedException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "AccessDeniedException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _AccessDeniedException.prototype);
  }
};
var AccessScopeType = {
  cluster: "cluster",
  namespace: "namespace"
};
var AddonIssueCode = {
  ACCESS_DENIED: "AccessDenied",
  ADDON_PERMISSION_FAILURE: "AddonPermissionFailure",
  ADDON_SUBSCRIPTION_NEEDED: "AddonSubscriptionNeeded",
  ADMISSION_REQUEST_DENIED: "AdmissionRequestDenied",
  CLUSTER_UNREACHABLE: "ClusterUnreachable",
  CONFIGURATION_CONFLICT: "ConfigurationConflict",
  INSUFFICIENT_NUMBER_OF_REPLICAS: "InsufficientNumberOfReplicas",
  INTERNAL_FAILURE: "InternalFailure",
  K8S_RESOURCE_NOT_FOUND: "K8sResourceNotFound",
  UNSUPPORTED_ADDON_MODIFICATION: "UnsupportedAddonModification"
};
var AddonStatus = {
  ACTIVE: "ACTIVE",
  CREATE_FAILED: "CREATE_FAILED",
  CREATING: "CREATING",
  DEGRADED: "DEGRADED",
  DELETE_FAILED: "DELETE_FAILED",
  DELETING: "DELETING",
  UPDATE_FAILED: "UPDATE_FAILED",
  UPDATING: "UPDATING"
};
var AMITypes = {
  AL2023_ARM_64_NVIDIA: "AL2023_ARM_64_NVIDIA",
  AL2023_ARM_64_STANDARD: "AL2023_ARM_64_STANDARD",
  AL2023_x86_64_NEURON: "AL2023_x86_64_NEURON",
  AL2023_x86_64_NVIDIA: "AL2023_x86_64_NVIDIA",
  AL2023_x86_64_STANDARD: "AL2023_x86_64_STANDARD",
  AL2_ARM_64: "AL2_ARM_64",
  AL2_x86_64: "AL2_x86_64",
  AL2_x86_64_GPU: "AL2_x86_64_GPU",
  BOTTLEROCKET_ARM_64: "BOTTLEROCKET_ARM_64",
  BOTTLEROCKET_ARM_64_FIPS: "BOTTLEROCKET_ARM_64_FIPS",
  BOTTLEROCKET_ARM_64_NVIDIA: "BOTTLEROCKET_ARM_64_NVIDIA",
  BOTTLEROCKET_x86_64: "BOTTLEROCKET_x86_64",
  BOTTLEROCKET_x86_64_FIPS: "BOTTLEROCKET_x86_64_FIPS",
  BOTTLEROCKET_x86_64_NVIDIA: "BOTTLEROCKET_x86_64_NVIDIA",
  CUSTOM: "CUSTOM",
  WINDOWS_CORE_2019_x86_64: "WINDOWS_CORE_2019_x86_64",
  WINDOWS_CORE_2022_x86_64: "WINDOWS_CORE_2022_x86_64",
  WINDOWS_FULL_2019_x86_64: "WINDOWS_FULL_2019_x86_64",
  WINDOWS_FULL_2022_x86_64: "WINDOWS_FULL_2022_x86_64"
};
var InvalidParameterException = class _InvalidParameterException extends EKSServiceException {
  static {
    __name(this, "InvalidParameterException");
  }
  name = "InvalidParameterException";
  $fault = "client";
  /**
   * <p>The Amazon EKS cluster associated with the exception.</p>
   * @public
   */
  clusterName;
  /**
   * <p>The Amazon EKS managed node group associated with the exception.</p>
   * @public
   */
  nodegroupName;
  /**
   * <p>The Fargate profile associated with the exception.</p>
   * @public
   */
  fargateProfileName;
  /**
   * <p>The specified parameter for the add-on name is invalid. Review the available
   *             parameters for the API request</p>
   * @public
   */
  addonName;
  /**
   * <p>The Amazon EKS subscription ID with the exception.</p>
   * @public
   */
  subscriptionId;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidParameterException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidParameterException.prototype);
    this.clusterName = opts.clusterName;
    this.nodegroupName = opts.nodegroupName;
    this.fargateProfileName = opts.fargateProfileName;
    this.addonName = opts.addonName;
    this.subscriptionId = opts.subscriptionId;
  }
};
var InvalidRequestException = class _InvalidRequestException extends EKSServiceException {
  static {
    __name(this, "InvalidRequestException");
  }
  name = "InvalidRequestException";
  $fault = "client";
  /**
   * <p>The Amazon EKS cluster associated with the exception.</p>
   * @public
   */
  clusterName;
  /**
   * <p>The Amazon EKS managed node group associated with the exception.</p>
   * @public
   */
  nodegroupName;
  /**
   * <p>The request is invalid given the state of the add-on name. Check the state of the
   *             cluster and the associated operations.</p>
   * @public
   */
  addonName;
  /**
   * <p>The Amazon EKS subscription ID with the exception.</p>
   * @public
   */
  subscriptionId;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidRequestException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidRequestException.prototype);
    this.clusterName = opts.clusterName;
    this.nodegroupName = opts.nodegroupName;
    this.addonName = opts.addonName;
    this.subscriptionId = opts.subscriptionId;
  }
};
var ResourceNotFoundException = class _ResourceNotFoundException extends EKSServiceException {
  static {
    __name(this, "ResourceNotFoundException");
  }
  name = "ResourceNotFoundException";
  $fault = "client";
  /**
   * <p>The Amazon EKS cluster associated with the exception.</p>
   * @public
   */
  clusterName;
  /**
   * <p>The Amazon EKS managed node group associated with the exception.</p>
   * @public
   */
  nodegroupName;
  /**
   * <p>The Fargate profile associated with the exception.</p>
   * @public
   */
  fargateProfileName;
  /**
   * <p>The Amazon EKS add-on name associated with the exception.</p>
   * @public
   */
  addonName;
  /**
   * <p>The Amazon EKS subscription ID with the exception.</p>
   * @public
   */
  subscriptionId;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceNotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceNotFoundException.prototype);
    this.clusterName = opts.clusterName;
    this.nodegroupName = opts.nodegroupName;
    this.fargateProfileName = opts.fargateProfileName;
    this.addonName = opts.addonName;
    this.subscriptionId = opts.subscriptionId;
  }
};
var ServerException = class _ServerException extends EKSServiceException {
  static {
    __name(this, "ServerException");
  }
  name = "ServerException";
  $fault = "server";
  /**
   * <p>The Amazon EKS cluster associated with the exception.</p>
   * @public
   */
  clusterName;
  /**
   * <p>The Amazon EKS managed node group associated with the exception.</p>
   * @public
   */
  nodegroupName;
  /**
   * <p>The Amazon EKS add-on name associated with the exception.</p>
   * @public
   */
  addonName;
  /**
   * <p>The Amazon EKS subscription ID with the exception.</p>
   * @public
   */
  subscriptionId;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ServerException",
      $fault: "server",
      ...opts
    });
    Object.setPrototypeOf(this, _ServerException.prototype);
    this.clusterName = opts.clusterName;
    this.nodegroupName = opts.nodegroupName;
    this.addonName = opts.addonName;
    this.subscriptionId = opts.subscriptionId;
  }
};
var ErrorCode = {
  ACCESS_DENIED: "AccessDenied",
  ADMISSION_REQUEST_DENIED: "AdmissionRequestDenied",
  CLUSTER_UNREACHABLE: "ClusterUnreachable",
  CONFIGURATION_CONFLICT: "ConfigurationConflict",
  ENI_LIMIT_REACHED: "EniLimitReached",
  INSUFFICIENT_FREE_ADDRESSES: "InsufficientFreeAddresses",
  INSUFFICIENT_NUMBER_OF_REPLICAS: "InsufficientNumberOfReplicas",
  IP_NOT_AVAILABLE: "IpNotAvailable",
  K8S_RESOURCE_NOT_FOUND: "K8sResourceNotFound",
  NODE_CREATION_FAILURE: "NodeCreationFailure",
  OPERATION_NOT_PERMITTED: "OperationNotPermitted",
  POD_EVICTION_FAILURE: "PodEvictionFailure",
  SECURITY_GROUP_NOT_FOUND: "SecurityGroupNotFound",
  SUBNET_NOT_FOUND: "SubnetNotFound",
  UNKNOWN: "Unknown",
  UNSUPPORTED_ADDON_MODIFICATION: "UnsupportedAddonModification",
  VPC_ID_NOT_FOUND: "VpcIdNotFound"
};
var UpdateParamType = {
  ADDON_VERSION: "AddonVersion",
  AUTHENTICATION_MODE: "AuthenticationMode",
  CLUSTER_LOGGING: "ClusterLogging",
  COMPUTE_CONFIG: "ComputeConfig",
  CONFIGURATION_VALUES: "ConfigurationValues",
  DESIRED_SIZE: "DesiredSize",
  ENCRYPTION_CONFIG: "EncryptionConfig",
  ENDPOINT_PRIVATE_ACCESS: "EndpointPrivateAccess",
  ENDPOINT_PUBLIC_ACCESS: "EndpointPublicAccess",
  IDENTITY_PROVIDER_CONFIG: "IdentityProviderConfig",
  KUBERNETES_NETWORK_CONFIG: "KubernetesNetworkConfig",
  LABELS_TO_ADD: "LabelsToAdd",
  LABELS_TO_REMOVE: "LabelsToRemove",
  LAUNCH_TEMPLATE_NAME: "LaunchTemplateName",
  LAUNCH_TEMPLATE_VERSION: "LaunchTemplateVersion",
  MAX_SIZE: "MaxSize",
  MAX_UNAVAILABLE: "MaxUnavailable",
  MAX_UNAVAILABLE_PERCENTAGE: "MaxUnavailablePercentage",
  MIN_SIZE: "MinSize",
  NODE_REPAIR_ENABLED: "NodeRepairEnabled",
  PLATFORM_VERSION: "PlatformVersion",
  POD_IDENTITY_ASSOCIATIONS: "PodIdentityAssociations",
  PUBLIC_ACCESS_CIDRS: "PublicAccessCidrs",
  RELEASE_VERSION: "ReleaseVersion",
  REMOTE_NETWORK_CONFIG: "RemoteNetworkConfig",
  RESOLVE_CONFLICTS: "ResolveConflicts",
  SECURITY_GROUPS: "SecurityGroups",
  SERVICE_ACCOUNT_ROLE_ARN: "ServiceAccountRoleArn",
  STORAGE_CONFIG: "StorageConfig",
  SUBNETS: "Subnets",
  TAINTS_TO_ADD: "TaintsToAdd",
  TAINTS_TO_REMOVE: "TaintsToRemove",
  UPDATE_STRATEGY: "UpdateStrategy",
  UPGRADE_POLICY: "UpgradePolicy",
  VERSION: "Version",
  ZONAL_SHIFT_CONFIG: "ZonalShiftConfig"
};
var UpdateStatus = {
  CANCELLED: "Cancelled",
  FAILED: "Failed",
  IN_PROGRESS: "InProgress",
  SUCCESSFUL: "Successful"
};
var UpdateType = {
  ACCESS_CONFIG_UPDATE: "AccessConfigUpdate",
  ADDON_UPDATE: "AddonUpdate",
  ASSOCIATE_ENCRYPTION_CONFIG: "AssociateEncryptionConfig",
  ASSOCIATE_IDENTITY_PROVIDER_CONFIG: "AssociateIdentityProviderConfig",
  AUTO_MODE_UPDATE: "AutoModeUpdate",
  CONFIG_UPDATE: "ConfigUpdate",
  DISASSOCIATE_IDENTITY_PROVIDER_CONFIG: "DisassociateIdentityProviderConfig",
  ENDPOINT_ACCESS_UPDATE: "EndpointAccessUpdate",
  LOGGING_UPDATE: "LoggingUpdate",
  REMOTE_NETWORK_CONFIG_UPDATE: "RemoteNetworkConfigUpdate",
  UPGRADE_POLICY_UPDATE: "UpgradePolicyUpdate",
  VERSION_UPDATE: "VersionUpdate",
  VPC_CONFIG_UPDATE: "VpcConfigUpdate",
  ZONAL_SHIFT_CONFIG_UPDATE: "ZonalShiftConfigUpdate"
};
var ClientException = class _ClientException extends EKSServiceException {
  static {
    __name(this, "ClientException");
  }
  name = "ClientException";
  $fault = "client";
  /**
   * <p>The Amazon EKS cluster associated with the exception.</p>
   * @public
   */
  clusterName;
  /**
   * <p>The Amazon EKS managed node group associated with the exception.</p>
   * @public
   */
  nodegroupName;
  /**
   * <p>The Amazon EKS add-on name associated with the exception.</p>
   * @public
   */
  addonName;
  /**
   * <p>The Amazon EKS subscription ID with the exception.</p>
   * @public
   */
  subscriptionId;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ClientException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ClientException.prototype);
    this.clusterName = opts.clusterName;
    this.nodegroupName = opts.nodegroupName;
    this.addonName = opts.addonName;
    this.subscriptionId = opts.subscriptionId;
  }
};
var ResourceInUseException = class _ResourceInUseException extends EKSServiceException {
  static {
    __name(this, "ResourceInUseException");
  }
  name = "ResourceInUseException";
  $fault = "client";
  /**
   * <p>The Amazon EKS cluster associated with the exception.</p>
   * @public
   */
  clusterName;
  /**
   * <p>The Amazon EKS managed node group associated with the exception.</p>
   * @public
   */
  nodegroupName;
  /**
   * <p>The specified add-on name is in use.</p>
   * @public
   */
  addonName;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceInUseException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceInUseException.prototype);
    this.clusterName = opts.clusterName;
    this.nodegroupName = opts.nodegroupName;
    this.addonName = opts.addonName;
  }
};
var ThrottlingException = class _ThrottlingException extends EKSServiceException {
  static {
    __name(this, "ThrottlingException");
  }
  name = "ThrottlingException";
  $fault = "client";
  /**
   * <p>The Amazon EKS cluster associated with the exception.</p>
   * @public
   */
  clusterName;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ThrottlingException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ThrottlingException.prototype);
    this.clusterName = opts.clusterName;
  }
};
var ResourceLimitExceededException = class _ResourceLimitExceededException extends EKSServiceException {
  static {
    __name(this, "ResourceLimitExceededException");
  }
  name = "ResourceLimitExceededException";
  $fault = "client";
  /**
   * <p>The Amazon EKS cluster associated with the exception.</p>
   * @public
   */
  clusterName;
  /**
   * <p>The Amazon EKS managed node group associated with the exception.</p>
   * @public
   */
  nodegroupName;
  /**
   * <p>The Amazon EKS subscription ID with the exception.</p>
   * @public
   */
  subscriptionId;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourceLimitExceededException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourceLimitExceededException.prototype);
    this.clusterName = opts.clusterName;
    this.nodegroupName = opts.nodegroupName;
    this.subscriptionId = opts.subscriptionId;
  }
};
var ResolveConflicts = {
  NONE: "NONE",
  OVERWRITE: "OVERWRITE",
  PRESERVE: "PRESERVE"
};
var IpFamily = {
  IPV4: "ipv4",
  IPV6: "ipv6"
};
var LogType = {
  API: "api",
  AUDIT: "audit",
  AUTHENTICATOR: "authenticator",
  CONTROLLER_MANAGER: "controllerManager",
  SCHEDULER: "scheduler"
};
var SupportType = {
  EXTENDED: "EXTENDED",
  STANDARD: "STANDARD"
};
var ClusterIssueCode = {
  ACCESS_DENIED: "AccessDenied",
  CLUSTER_UNREACHABLE: "ClusterUnreachable",
  CONFIGURATION_CONFLICT: "ConfigurationConflict",
  EC2_SECURITY_GROUP_NOT_FOUND: "Ec2SecurityGroupNotFound",
  EC2_SERVICE_NOT_SUBSCRIBED: "Ec2ServiceNotSubscribed",
  EC2_SUBNET_NOT_FOUND: "Ec2SubnetNotFound",
  IAM_ROLE_NOT_FOUND: "IamRoleNotFound",
  INSUFFICIENT_FREE_ADDRESSES: "InsufficientFreeAddresses",
  INTERNAL_FAILURE: "InternalFailure",
  KMS_GRANT_REVOKED: "KmsGrantRevoked",
  KMS_KEY_DISABLED: "KmsKeyDisabled",
  KMS_KEY_MARKED_FOR_DELETION: "KmsKeyMarkedForDeletion",
  KMS_KEY_NOT_FOUND: "KmsKeyNotFound",
  OTHER: "Other",
  RESOURCE_LIMIT_EXCEEDED: "ResourceLimitExceeded",
  RESOURCE_NOT_FOUND: "ResourceNotFound",
  STS_REGIONAL_ENDPOINT_DISABLED: "StsRegionalEndpointDisabled",
  UNSUPPORTED_VERSION: "UnsupportedVersion",
  VPC_NOT_FOUND: "VpcNotFound"
};
var ClusterStatus = {
  ACTIVE: "ACTIVE",
  CREATING: "CREATING",
  DELETING: "DELETING",
  FAILED: "FAILED",
  PENDING: "PENDING",
  UPDATING: "UPDATING"
};
var ServiceUnavailableException = class _ServiceUnavailableException extends EKSServiceException {
  static {
    __name(this, "ServiceUnavailableException");
  }
  name = "ServiceUnavailableException";
  $fault = "server";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ServiceUnavailableException",
      $fault: "server",
      ...opts
    });
    Object.setPrototypeOf(this, _ServiceUnavailableException.prototype);
  }
};
var UnsupportedAvailabilityZoneException = class _UnsupportedAvailabilityZoneException extends EKSServiceException {
  static {
    __name(this, "UnsupportedAvailabilityZoneException");
  }
  name = "UnsupportedAvailabilityZoneException";
  $fault = "client";
  /**
   * <p>The Amazon EKS cluster associated with the exception.</p>
   * @public
   */
  clusterName;
  /**
   * <p>The Amazon EKS managed node group associated with the exception.</p>
   * @public
   */
  nodegroupName;
  /**
   * <p>The supported Availability Zones for your account. Choose subnets in these Availability Zones for your
   *             cluster.</p>
   * @public
   */
  validZones;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "UnsupportedAvailabilityZoneException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _UnsupportedAvailabilityZoneException.prototype);
    this.clusterName = opts.clusterName;
    this.nodegroupName = opts.nodegroupName;
    this.validZones = opts.validZones;
  }
};
var EksAnywhereSubscriptionLicenseType = {
  Cluster: "Cluster"
};
var EksAnywhereSubscriptionTermUnit = {
  MONTHS: "MONTHS"
};
var FargateProfileIssueCode = {
  ACCESS_DENIED: "AccessDenied",
  CLUSTER_UNREACHABLE: "ClusterUnreachable",
  INTERNAL_FAILURE: "InternalFailure",
  POD_EXECUTION_ROLE_ALREADY_IN_USE: "PodExecutionRoleAlreadyInUse"
};
var FargateProfileStatus = {
  ACTIVE: "ACTIVE",
  CREATE_FAILED: "CREATE_FAILED",
  CREATING: "CREATING",
  DELETE_FAILED: "DELETE_FAILED",
  DELETING: "DELETING"
};
var CapacityTypes = {
  CAPACITY_BLOCK: "CAPACITY_BLOCK",
  ON_DEMAND: "ON_DEMAND",
  SPOT: "SPOT"
};
var TaintEffect = {
  NO_EXECUTE: "NO_EXECUTE",
  NO_SCHEDULE: "NO_SCHEDULE",
  PREFER_NO_SCHEDULE: "PREFER_NO_SCHEDULE"
};
var NodegroupUpdateStrategies = {
  DEFAULT: "DEFAULT",
  MINIMAL: "MINIMAL"
};
var NodegroupIssueCode = {
  ACCESS_DENIED: "AccessDenied",
  AMI_ID_NOT_FOUND: "AmiIdNotFound",
  ASG_INSTANCE_LAUNCH_FAILURES: "AsgInstanceLaunchFailures",
  AUTO_SCALING_GROUP_INSTANCE_REFRESH_ACTIVE: "AutoScalingGroupInstanceRefreshActive",
  AUTO_SCALING_GROUP_INVALID_CONFIGURATION: "AutoScalingGroupInvalidConfiguration",
  AUTO_SCALING_GROUP_NOT_FOUND: "AutoScalingGroupNotFound",
  AUTO_SCALING_GROUP_OPT_IN_REQUIRED: "AutoScalingGroupOptInRequired",
  AUTO_SCALING_GROUP_RATE_LIMIT_EXCEEDED: "AutoScalingGroupRateLimitExceeded",
  CLUSTER_UNREACHABLE: "ClusterUnreachable",
  EC2_INSTANCE_TYPE_DOES_NOT_EXIST: "Ec2InstanceTypeDoesNotExist",
  EC2_LAUNCH_TEMPLATE_DELETION_FAILURE: "Ec2LaunchTemplateDeletionFailure",
  EC2_LAUNCH_TEMPLATE_INVALID_CONFIGURATION: "Ec2LaunchTemplateInvalidConfiguration",
  EC2_LAUNCH_TEMPLATE_MAX_LIMIT_EXCEEDED: "Ec2LaunchTemplateMaxLimitExceeded",
  EC2_LAUNCH_TEMPLATE_NOT_FOUND: "Ec2LaunchTemplateNotFound",
  EC2_LAUNCH_TEMPLATE_VERSION_MAX_LIMIT_EXCEEDED: "Ec2LaunchTemplateVersionMaxLimitExceeded",
  EC2_LAUNCH_TEMPLATE_VERSION_MISMATCH: "Ec2LaunchTemplateVersionMismatch",
  EC2_SECURITY_GROUP_DELETION_FAILURE: "Ec2SecurityGroupDeletionFailure",
  EC2_SECURITY_GROUP_NOT_FOUND: "Ec2SecurityGroupNotFound",
  EC2_SUBNET_INVALID_CONFIGURATION: "Ec2SubnetInvalidConfiguration",
  EC2_SUBNET_LIST_TOO_LONG: "Ec2SubnetListTooLong",
  EC2_SUBNET_MISSING_IPV6_ASSIGNMENT: "Ec2SubnetMissingIpv6Assignment",
  EC2_SUBNET_NOT_FOUND: "Ec2SubnetNotFound",
  IAM_INSTANCE_PROFILE_NOT_FOUND: "IamInstanceProfileNotFound",
  IAM_LIMIT_EXCEEDED: "IamLimitExceeded",
  IAM_NODE_ROLE_NOT_FOUND: "IamNodeRoleNotFound",
  IAM_THROTTLING: "IamThrottling",
  INSTANCE_LIMIT_EXCEEDED: "InstanceLimitExceeded",
  INSUFFICIENT_FREE_ADDRESSES: "InsufficientFreeAddresses",
  INTERNAL_FAILURE: "InternalFailure",
  KUBERNETES_LABEL_INVALID: "KubernetesLabelInvalid",
  LIMIT_EXCEEDED: "LimitExceeded",
  NODE_CREATION_FAILURE: "NodeCreationFailure",
  NODE_TERMINATION_FAILURE: "NodeTerminationFailure",
  POD_EVICTION_FAILURE: "PodEvictionFailure",
  SOURCE_EC2_LAUNCH_TEMPLATE_NOT_FOUND: "SourceEc2LaunchTemplateNotFound",
  UNKNOWN: "Unknown"
};
var NodegroupStatus = {
  ACTIVE: "ACTIVE",
  CREATE_FAILED: "CREATE_FAILED",
  CREATING: "CREATING",
  DEGRADED: "DEGRADED",
  DELETE_FAILED: "DELETE_FAILED",
  DELETING: "DELETING",
  UPDATING: "UPDATING"
};
var ClusterVersionStatus = {
  extended_support: "extended-support",
  standard_support: "standard-support",
  unsupported: "unsupported"
};
var VersionStatus = {
  EXTENDED_SUPPORT: "EXTENDED_SUPPORT",
  STANDARD_SUPPORT: "STANDARD_SUPPORT",
  UNSUPPORTED: "UNSUPPORTED"
};
var ConfigStatus = {
  ACTIVE: "ACTIVE",
  CREATING: "CREATING",
  DELETING: "DELETING"
};
var Category = {
  MISCONFIGURATION: "MISCONFIGURATION",
  UPGRADE_READINESS: "UPGRADE_READINESS"
};
var InsightStatusValue = {
  ERROR: "ERROR",
  PASSING: "PASSING",
  UNKNOWN: "UNKNOWN",
  WARNING: "WARNING"
};
var EksAnywhereSubscriptionStatus = {
  ACTIVE: "ACTIVE",
  CREATING: "CREATING",
  DELETING: "DELETING",
  EXPIRED: "EXPIRED",
  EXPIRING: "EXPIRING",
  UPDATING: "UPDATING"
};
var BadRequestException = class _BadRequestException extends EKSServiceException {
  static {
    __name(this, "BadRequestException");
  }
  name = "BadRequestException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "BadRequestException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _BadRequestException.prototype);
  }
};
var NotFoundException = class _NotFoundException extends EKSServiceException {
  static {
    __name(this, "NotFoundException");
  }
  name = "NotFoundException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "NotFoundException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _NotFoundException.prototype);
  }
};
var ConnectorConfigProvider = {
  AKS: "AKS",
  ANTHOS: "ANTHOS",
  EC2: "EC2",
  EKS_ANYWHERE: "EKS_ANYWHERE",
  GKE: "GKE",
  OPENSHIFT: "OPENSHIFT",
  OTHER: "OTHER",
  RANCHER: "RANCHER",
  TANZU: "TANZU"
};
var ResourcePropagationDelayException = class _ResourcePropagationDelayException extends EKSServiceException {
  static {
    __name(this, "ResourcePropagationDelayException");
  }
  name = "ResourcePropagationDelayException";
  $fault = "client";
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "ResourcePropagationDelayException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _ResourcePropagationDelayException.prototype);
  }
};
var InvalidStateException = class _InvalidStateException extends EKSServiceException {
  static {
    __name(this, "InvalidStateException");
  }
  name = "InvalidStateException";
  $fault = "client";
  /**
   * <p>The Amazon EKS cluster associated with the exception.</p>
   * @public
   */
  clusterName;
  /**
   * @internal
   */
  constructor(opts) {
    super({
      name: "InvalidStateException",
      $fault: "client",
      ...opts
    });
    Object.setPrototypeOf(this, _InvalidStateException.prototype);
    this.clusterName = opts.clusterName;
  }
};

// src/protocols/Aws_restJson1.ts
var se_AssociateAccessPolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/clusters/{clusterName}/access-entries/{principalArn}/access-policies");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  b.p("principalArn", () => input.principalArn, "{principalArn}", false);
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      accessScope: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "accessScope"),
      policyArn: []
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_AssociateAccessPolicyCommand");
var se_AssociateEncryptionConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/clusters/{clusterName}/encryption-config/associate");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
      encryptionConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "encryptionConfig")
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_AssociateEncryptionConfigCommand");
var se_AssociateIdentityProviderConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/clusters/{clusterName}/identity-provider-configs/associate");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
      oidc: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "oidc"),
      tags: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "tags")
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_AssociateIdentityProviderConfigCommand");
var se_CreateAccessEntryCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/clusters/{clusterName}/access-entries");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
      kubernetesGroups: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "kubernetesGroups"),
      principalArn: [],
      tags: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "tags"),
      type: [],
      username: []
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateAccessEntryCommand");
var se_CreateAddonCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/clusters/{clusterName}/addons");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      addonName: [],
      addonVersion: [],
      clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
      configurationValues: [],
      podIdentityAssociations: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "podIdentityAssociations"),
      resolveConflicts: [],
      serviceAccountRoleArn: [],
      tags: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "tags")
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateAddonCommand");
var se_CreateClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/clusters");
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      accessConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "accessConfig"),
      bootstrapSelfManagedAddons: [],
      clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
      computeConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "computeConfig"),
      encryptionConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "encryptionConfig"),
      kubernetesNetworkConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "kubernetesNetworkConfig"),
      logging: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "logging"),
      name: [],
      outpostConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "outpostConfig"),
      remoteNetworkConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "remoteNetworkConfig"),
      resourcesVpcConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "resourcesVpcConfig"),
      roleArn: [],
      storageConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "storageConfig"),
      tags: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "tags"),
      upgradePolicy: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "upgradePolicy"),
      version: [],
      zonalShiftConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "zonalShiftConfig")
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateClusterCommand");
var se_CreateEksAnywhereSubscriptionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/eks-anywhere-subscriptions");
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      autoRenew: [],
      clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
      licenseQuantity: [],
      licenseType: [],
      name: [],
      tags: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "tags"),
      term: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "term")
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateEksAnywhereSubscriptionCommand");
var se_CreateFargateProfileCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/clusters/{clusterName}/fargate-profiles");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
      fargateProfileName: [],
      podExecutionRoleArn: [],
      selectors: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "selectors"),
      subnets: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "subnets"),
      tags: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "tags")
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateFargateProfileCommand");
var se_CreateNodegroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/clusters/{clusterName}/node-groups");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      amiType: [],
      capacityType: [],
      clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
      diskSize: [],
      instanceTypes: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "instanceTypes"),
      labels: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "labels"),
      launchTemplate: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "launchTemplate"),
      nodeRepairConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "nodeRepairConfig"),
      nodeRole: [],
      nodegroupName: [],
      releaseVersion: [],
      remoteAccess: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "remoteAccess"),
      scalingConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "scalingConfig"),
      subnets: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "subnets"),
      tags: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "tags"),
      taints: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "taints"),
      updateConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "updateConfig"),
      version: []
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreateNodegroupCommand");
var se_CreatePodIdentityAssociationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/clusters/{clusterName}/pod-identity-associations");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
      disableSessionTags: [],
      namespace: [],
      roleArn: [],
      serviceAccount: [],
      tags: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "tags"),
      targetRoleArn: []
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_CreatePodIdentityAssociationCommand");
var se_DeleteAccessEntryCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{clusterName}/access-entries/{principalArn}");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  b.p("principalArn", () => input.principalArn, "{principalArn}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteAccessEntryCommand");
var se_DeleteAddonCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{clusterName}/addons/{addonName}");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  b.p("addonName", () => input.addonName, "{addonName}", false);
  const query = (0, import_smithy_client.map)({
    [_p]: [() => input.preserve !== void 0, () => input[_p].toString()]
  });
  let body;
  b.m("DELETE").h(headers).q(query).b(body);
  return b.build();
}, "se_DeleteAddonCommand");
var se_DeleteClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{name}");
  b.p("name", () => input.name, "{name}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteClusterCommand");
var se_DeleteEksAnywhereSubscriptionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/eks-anywhere-subscriptions/{id}");
  b.p("id", () => input.id, "{id}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteEksAnywhereSubscriptionCommand");
var se_DeleteFargateProfileCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{clusterName}/fargate-profiles/{fargateProfileName}");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  b.p("fargateProfileName", () => input.fargateProfileName, "{fargateProfileName}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteFargateProfileCommand");
var se_DeleteNodegroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{clusterName}/node-groups/{nodegroupName}");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  b.p("nodegroupName", () => input.nodegroupName, "{nodegroupName}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeleteNodegroupCommand");
var se_DeletePodIdentityAssociationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{clusterName}/pod-identity-associations/{associationId}");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  b.p("associationId", () => input.associationId, "{associationId}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeletePodIdentityAssociationCommand");
var se_DeregisterClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/cluster-registrations/{name}");
  b.p("name", () => input.name, "{name}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DeregisterClusterCommand");
var se_DescribeAccessEntryCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{clusterName}/access-entries/{principalArn}");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  b.p("principalArn", () => input.principalArn, "{principalArn}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_DescribeAccessEntryCommand");
var se_DescribeAddonCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{clusterName}/addons/{addonName}");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  b.p("addonName", () => input.addonName, "{addonName}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_DescribeAddonCommand");
var se_DescribeAddonConfigurationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/addons/configuration-schemas");
  const query = (0, import_smithy_client.map)({
    [_aN]: [, (0, import_smithy_client.expectNonNull)(input[_aN], `addonName`)],
    [_aV]: [, (0, import_smithy_client.expectNonNull)(input[_aV], `addonVersion`)]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_DescribeAddonConfigurationCommand");
var se_DescribeAddonVersionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/addons/supported-versions");
  const query = (0, import_smithy_client.map)({
    [_kV]: [, input[_kV]],
    [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
    [_nT]: [, input[_nT]],
    [_aN]: [, input[_aN]],
    [_t]: [() => input.types !== void 0, () => input[_t] || []],
    [_pu]: [() => input.publishers !== void 0, () => input[_pu] || []],
    [_o]: [() => input.owners !== void 0, () => input[_o] || []]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_DescribeAddonVersionsCommand");
var se_DescribeClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{name}");
  b.p("name", () => input.name, "{name}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_DescribeClusterCommand");
var se_DescribeClusterVersionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/cluster-versions");
  const query = (0, import_smithy_client.map)({
    [_cT]: [, input[_cT]],
    [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
    [_nT]: [, input[_nT]],
    [_dO]: [() => input.defaultOnly !== void 0, () => input[_dO].toString()],
    [_iA]: [() => input.includeAll !== void 0, () => input[_iA].toString()],
    [_cV]: [() => input.clusterVersions !== void 0, () => input[_cV] || []],
    [_s]: [, input[_s]],
    [_vS]: [, input[_vS]]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_DescribeClusterVersionsCommand");
var se_DescribeEksAnywhereSubscriptionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/eks-anywhere-subscriptions/{id}");
  b.p("id", () => input.id, "{id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_DescribeEksAnywhereSubscriptionCommand");
var se_DescribeFargateProfileCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{clusterName}/fargate-profiles/{fargateProfileName}");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  b.p("fargateProfileName", () => input.fargateProfileName, "{fargateProfileName}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_DescribeFargateProfileCommand");
var se_DescribeIdentityProviderConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/clusters/{clusterName}/identity-provider-configs/describe");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      identityProviderConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "identityProviderConfig")
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_DescribeIdentityProviderConfigCommand");
var se_DescribeInsightCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{clusterName}/insights/{id}");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  b.p("id", () => input.id, "{id}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_DescribeInsightCommand");
var se_DescribeNodegroupCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{clusterName}/node-groups/{nodegroupName}");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  b.p("nodegroupName", () => input.nodegroupName, "{nodegroupName}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_DescribeNodegroupCommand");
var se_DescribePodIdentityAssociationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{clusterName}/pod-identity-associations/{associationId}");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  b.p("associationId", () => input.associationId, "{associationId}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_DescribePodIdentityAssociationCommand");
var se_DescribeUpdateCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{name}/updates/{updateId}");
  b.p("name", () => input.name, "{name}", false);
  b.p("updateId", () => input.updateId, "{updateId}", false);
  const query = (0, import_smithy_client.map)({
    [_nN]: [, input[_nN]],
    [_aN]: [, input[_aN]]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_DescribeUpdateCommand");
var se_DisassociateAccessPolicyCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{clusterName}/access-entries/{principalArn}/access-policies/{policyArn}");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  b.p("principalArn", () => input.principalArn, "{principalArn}", false);
  b.p("policyArn", () => input.policyArn, "{policyArn}", false);
  let body;
  b.m("DELETE").h(headers).b(body);
  return b.build();
}, "se_DisassociateAccessPolicyCommand");
var se_DisassociateIdentityProviderConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/clusters/{clusterName}/identity-provider-configs/disassociate");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
      identityProviderConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "identityProviderConfig")
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_DisassociateIdentityProviderConfigCommand");
var se_ListAccessEntriesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{clusterName}/access-entries");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  const query = (0, import_smithy_client.map)({
    [_aPA]: [, input[_aPA]],
    [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
    [_nT]: [, input[_nT]]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListAccessEntriesCommand");
var se_ListAccessPoliciesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/access-policies");
  const query = (0, import_smithy_client.map)({
    [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
    [_nT]: [, input[_nT]]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListAccessPoliciesCommand");
var se_ListAddonsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{clusterName}/addons");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  const query = (0, import_smithy_client.map)({
    [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
    [_nT]: [, input[_nT]]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListAddonsCommand");
var se_ListAssociatedAccessPoliciesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{clusterName}/access-entries/{principalArn}/access-policies");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  b.p("principalArn", () => input.principalArn, "{principalArn}", false);
  const query = (0, import_smithy_client.map)({
    [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
    [_nT]: [, input[_nT]]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListAssociatedAccessPoliciesCommand");
var se_ListClustersCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters");
  const query = (0, import_smithy_client.map)({
    [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
    [_nT]: [, input[_nT]],
    [_i]: [() => input.include !== void 0, () => input[_i] || []]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListClustersCommand");
var se_ListEksAnywhereSubscriptionsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/eks-anywhere-subscriptions");
  const query = (0, import_smithy_client.map)({
    [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
    [_nT]: [, input[_nT]],
    [_iS]: [() => input.includeStatus !== void 0, () => input[_iS] || []]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListEksAnywhereSubscriptionsCommand");
var se_ListFargateProfilesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{clusterName}/fargate-profiles");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  const query = (0, import_smithy_client.map)({
    [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
    [_nT]: [, input[_nT]]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListFargateProfilesCommand");
var se_ListIdentityProviderConfigsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{clusterName}/identity-provider-configs");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  const query = (0, import_smithy_client.map)({
    [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
    [_nT]: [, input[_nT]]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListIdentityProviderConfigsCommand");
var se_ListInsightsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/clusters/{clusterName}/insights");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      filter: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "filter"),
      maxResults: [],
      nextToken: []
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_ListInsightsCommand");
var se_ListNodegroupsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{clusterName}/node-groups");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  const query = (0, import_smithy_client.map)({
    [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
    [_nT]: [, input[_nT]]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListNodegroupsCommand");
var se_ListPodIdentityAssociationsCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{clusterName}/pod-identity-associations");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  const query = (0, import_smithy_client.map)({
    [_n]: [, input[_n]],
    [_sA]: [, input[_sA]],
    [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()],
    [_nT]: [, input[_nT]]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListPodIdentityAssociationsCommand");
var se_ListTagsForResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/tags/{resourceArn}");
  b.p("resourceArn", () => input.resourceArn, "{resourceArn}", false);
  let body;
  b.m("GET").h(headers).b(body);
  return b.build();
}, "se_ListTagsForResourceCommand");
var se_ListUpdatesCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/clusters/{name}/updates");
  b.p("name", () => input.name, "{name}", false);
  const query = (0, import_smithy_client.map)({
    [_nN]: [, input[_nN]],
    [_aN]: [, input[_aN]],
    [_nT]: [, input[_nT]],
    [_mR]: [() => input.maxResults !== void 0, () => input[_mR].toString()]
  });
  let body;
  b.m("GET").h(headers).q(query).b(body);
  return b.build();
}, "se_ListUpdatesCommand");
var se_RegisterClusterCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/cluster-registrations");
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
      connectorConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "connectorConfig"),
      name: [],
      tags: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "tags")
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_RegisterClusterCommand");
var se_TagResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/tags/{resourceArn}");
  b.p("resourceArn", () => input.resourceArn, "{resourceArn}", false);
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      tags: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "tags")
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_TagResourceCommand");
var se_UntagResourceCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {};
  b.bp("/tags/{resourceArn}");
  b.p("resourceArn", () => input.resourceArn, "{resourceArn}", false);
  const query = (0, import_smithy_client.map)({
    [_tK]: [(0, import_smithy_client.expectNonNull)(input.tagKeys, `tagKeys`) != null, () => input[_tK] || []]
  });
  let body;
  b.m("DELETE").h(headers).q(query).b(body);
  return b.build();
}, "se_UntagResourceCommand");
var se_UpdateAccessEntryCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/clusters/{clusterName}/access-entries/{principalArn}");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  b.p("principalArn", () => input.principalArn, "{principalArn}", false);
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
      kubernetesGroups: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "kubernetesGroups"),
      username: []
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_UpdateAccessEntryCommand");
var se_UpdateAddonCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/clusters/{clusterName}/addons/{addonName}/update");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  b.p("addonName", () => input.addonName, "{addonName}", false);
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      addonVersion: [],
      clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
      configurationValues: [],
      podIdentityAssociations: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "podIdentityAssociations"),
      resolveConflicts: [],
      serviceAccountRoleArn: []
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_UpdateAddonCommand");
var se_UpdateClusterConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/clusters/{name}/update-config");
  b.p("name", () => input.name, "{name}", false);
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      accessConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "accessConfig"),
      clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
      computeConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "computeConfig"),
      kubernetesNetworkConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "kubernetesNetworkConfig"),
      logging: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "logging"),
      remoteNetworkConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "remoteNetworkConfig"),
      resourcesVpcConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "resourcesVpcConfig"),
      storageConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "storageConfig"),
      upgradePolicy: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "upgradePolicy"),
      zonalShiftConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "zonalShiftConfig")
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_UpdateClusterConfigCommand");
var se_UpdateClusterVersionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/clusters/{name}/updates");
  b.p("name", () => input.name, "{name}", false);
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
      force: [],
      version: []
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_UpdateClusterVersionCommand");
var se_UpdateEksAnywhereSubscriptionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/eks-anywhere-subscriptions/{id}");
  b.p("id", () => input.id, "{id}", false);
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      autoRenew: [],
      clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()]
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_UpdateEksAnywhereSubscriptionCommand");
var se_UpdateNodegroupConfigCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/clusters/{clusterName}/node-groups/{nodegroupName}/update-config");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  b.p("nodegroupName", () => input.nodegroupName, "{nodegroupName}", false);
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
      labels: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "labels"),
      nodeRepairConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "nodeRepairConfig"),
      scalingConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "scalingConfig"),
      taints: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "taints"),
      updateConfig: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "updateConfig")
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_UpdateNodegroupConfigCommand");
var se_UpdateNodegroupVersionCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/clusters/{clusterName}/node-groups/{nodegroupName}/update-version");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  b.p("nodegroupName", () => input.nodegroupName, "{nodegroupName}", false);
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
      force: [],
      launchTemplate: /* @__PURE__ */ __name((_) => (0, import_smithy_client._json)(_), "launchTemplate"),
      releaseVersion: [],
      version: []
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_UpdateNodegroupVersionCommand");
var se_UpdatePodIdentityAssociationCommand = /* @__PURE__ */ __name(async (input, context) => {
  const b = (0, import_core.requestBuilder)(input, context);
  const headers = {
    "content-type": "application/json"
  };
  b.bp("/clusters/{clusterName}/pod-identity-associations/{associationId}");
  b.p("clusterName", () => input.clusterName, "{clusterName}", false);
  b.p("associationId", () => input.associationId, "{associationId}", false);
  let body;
  body = JSON.stringify(
    (0, import_smithy_client.take)(input, {
      clientRequestToken: [true, (_) => _ ?? (0, import_uuid.v4)()],
      disableSessionTags: [],
      roleArn: [],
      targetRoleArn: []
    })
  );
  b.m("POST").h(headers).b(body);
  return b.build();
}, "se_UpdatePodIdentityAssociationCommand");
var de_AssociateAccessPolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    associatedAccessPolicy: /* @__PURE__ */ __name((_) => de_AssociatedAccessPolicy(_, context), "associatedAccessPolicy"),
    clusterName: import_smithy_client.expectString,
    principalArn: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  return contents;
}, "de_AssociateAccessPolicyCommand");
var de_AssociateEncryptionConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    update: /* @__PURE__ */ __name((_) => de_Update(_, context), "update")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_AssociateEncryptionConfigCommand");
var de_AssociateIdentityProviderConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    tags: import_smithy_client._json,
    update: /* @__PURE__ */ __name((_) => de_Update(_, context), "update")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_AssociateIdentityProviderConfigCommand");
var de_CreateAccessEntryCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    accessEntry: /* @__PURE__ */ __name((_) => de_AccessEntry(_, context), "accessEntry")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_CreateAccessEntryCommand");
var de_CreateAddonCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    addon: /* @__PURE__ */ __name((_) => de_Addon(_, context), "addon")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_CreateAddonCommand");
var de_CreateClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    cluster: /* @__PURE__ */ __name((_) => de_Cluster(_, context), "cluster")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_CreateClusterCommand");
var de_CreateEksAnywhereSubscriptionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    subscription: /* @__PURE__ */ __name((_) => de_EksAnywhereSubscription(_, context), "subscription")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_CreateEksAnywhereSubscriptionCommand");
var de_CreateFargateProfileCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    fargateProfile: /* @__PURE__ */ __name((_) => de_FargateProfile(_, context), "fargateProfile")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_CreateFargateProfileCommand");
var de_CreateNodegroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    nodegroup: /* @__PURE__ */ __name((_) => de_Nodegroup(_, context), "nodegroup")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_CreateNodegroupCommand");
var de_CreatePodIdentityAssociationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    association: /* @__PURE__ */ __name((_) => de_PodIdentityAssociation(_, context), "association")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_CreatePodIdentityAssociationCommand");
var de_DeleteAccessEntryCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_DeleteAccessEntryCommand");
var de_DeleteAddonCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    addon: /* @__PURE__ */ __name((_) => de_Addon(_, context), "addon")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_DeleteAddonCommand");
var de_DeleteClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    cluster: /* @__PURE__ */ __name((_) => de_Cluster(_, context), "cluster")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_DeleteClusterCommand");
var de_DeleteEksAnywhereSubscriptionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    subscription: /* @__PURE__ */ __name((_) => de_EksAnywhereSubscription(_, context), "subscription")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_DeleteEksAnywhereSubscriptionCommand");
var de_DeleteFargateProfileCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    fargateProfile: /* @__PURE__ */ __name((_) => de_FargateProfile(_, context), "fargateProfile")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_DeleteFargateProfileCommand");
var de_DeleteNodegroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    nodegroup: /* @__PURE__ */ __name((_) => de_Nodegroup(_, context), "nodegroup")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_DeleteNodegroupCommand");
var de_DeletePodIdentityAssociationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    association: /* @__PURE__ */ __name((_) => de_PodIdentityAssociation(_, context), "association")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_DeletePodIdentityAssociationCommand");
var de_DeregisterClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    cluster: /* @__PURE__ */ __name((_) => de_Cluster(_, context), "cluster")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_DeregisterClusterCommand");
var de_DescribeAccessEntryCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    accessEntry: /* @__PURE__ */ __name((_) => de_AccessEntry(_, context), "accessEntry")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_DescribeAccessEntryCommand");
var de_DescribeAddonCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    addon: /* @__PURE__ */ __name((_) => de_Addon(_, context), "addon")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_DescribeAddonCommand");
var de_DescribeAddonConfigurationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    addonName: import_smithy_client.expectString,
    addonVersion: import_smithy_client.expectString,
    configurationSchema: import_smithy_client.expectString,
    podIdentityConfiguration: import_smithy_client._json
  });
  Object.assign(contents, doc);
  return contents;
}, "de_DescribeAddonConfigurationCommand");
var de_DescribeAddonVersionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    addons: import_smithy_client._json,
    nextToken: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  return contents;
}, "de_DescribeAddonVersionsCommand");
var de_DescribeClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    cluster: /* @__PURE__ */ __name((_) => de_Cluster(_, context), "cluster")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_DescribeClusterCommand");
var de_DescribeClusterVersionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    clusterVersions: /* @__PURE__ */ __name((_) => de_ClusterVersionList(_, context), "clusterVersions"),
    nextToken: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  return contents;
}, "de_DescribeClusterVersionsCommand");
var de_DescribeEksAnywhereSubscriptionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    subscription: /* @__PURE__ */ __name((_) => de_EksAnywhereSubscription(_, context), "subscription")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_DescribeEksAnywhereSubscriptionCommand");
var de_DescribeFargateProfileCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    fargateProfile: /* @__PURE__ */ __name((_) => de_FargateProfile(_, context), "fargateProfile")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_DescribeFargateProfileCommand");
var de_DescribeIdentityProviderConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    identityProviderConfig: import_smithy_client._json
  });
  Object.assign(contents, doc);
  return contents;
}, "de_DescribeIdentityProviderConfigCommand");
var de_DescribeInsightCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    insight: /* @__PURE__ */ __name((_) => de_Insight(_, context), "insight")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_DescribeInsightCommand");
var de_DescribeNodegroupCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    nodegroup: /* @__PURE__ */ __name((_) => de_Nodegroup(_, context), "nodegroup")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_DescribeNodegroupCommand");
var de_DescribePodIdentityAssociationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    association: /* @__PURE__ */ __name((_) => de_PodIdentityAssociation(_, context), "association")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_DescribePodIdentityAssociationCommand");
var de_DescribeUpdateCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    update: /* @__PURE__ */ __name((_) => de_Update(_, context), "update")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_DescribeUpdateCommand");
var de_DisassociateAccessPolicyCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_DisassociateAccessPolicyCommand");
var de_DisassociateIdentityProviderConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    update: /* @__PURE__ */ __name((_) => de_Update(_, context), "update")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_DisassociateIdentityProviderConfigCommand");
var de_ListAccessEntriesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    accessEntries: import_smithy_client._json,
    nextToken: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  return contents;
}, "de_ListAccessEntriesCommand");
var de_ListAccessPoliciesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    accessPolicies: import_smithy_client._json,
    nextToken: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  return contents;
}, "de_ListAccessPoliciesCommand");
var de_ListAddonsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    addons: import_smithy_client._json,
    nextToken: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  return contents;
}, "de_ListAddonsCommand");
var de_ListAssociatedAccessPoliciesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    associatedAccessPolicies: /* @__PURE__ */ __name((_) => de_AssociatedAccessPoliciesList(_, context), "associatedAccessPolicies"),
    clusterName: import_smithy_client.expectString,
    nextToken: import_smithy_client.expectString,
    principalArn: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  return contents;
}, "de_ListAssociatedAccessPoliciesCommand");
var de_ListClustersCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    clusters: import_smithy_client._json,
    nextToken: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  return contents;
}, "de_ListClustersCommand");
var de_ListEksAnywhereSubscriptionsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    nextToken: import_smithy_client.expectString,
    subscriptions: /* @__PURE__ */ __name((_) => de_EksAnywhereSubscriptionList(_, context), "subscriptions")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_ListEksAnywhereSubscriptionsCommand");
var de_ListFargateProfilesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    fargateProfileNames: import_smithy_client._json,
    nextToken: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  return contents;
}, "de_ListFargateProfilesCommand");
var de_ListIdentityProviderConfigsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    identityProviderConfigs: import_smithy_client._json,
    nextToken: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  return contents;
}, "de_ListIdentityProviderConfigsCommand");
var de_ListInsightsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    insights: /* @__PURE__ */ __name((_) => de_InsightSummaries(_, context), "insights"),
    nextToken: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  return contents;
}, "de_ListInsightsCommand");
var de_ListNodegroupsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    nextToken: import_smithy_client.expectString,
    nodegroups: import_smithy_client._json
  });
  Object.assign(contents, doc);
  return contents;
}, "de_ListNodegroupsCommand");
var de_ListPodIdentityAssociationsCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    associations: import_smithy_client._json,
    nextToken: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  return contents;
}, "de_ListPodIdentityAssociationsCommand");
var de_ListTagsForResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    tags: import_smithy_client._json
  });
  Object.assign(contents, doc);
  return contents;
}, "de_ListTagsForResourceCommand");
var de_ListUpdatesCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    nextToken: import_smithy_client.expectString,
    updateIds: import_smithy_client._json
  });
  Object.assign(contents, doc);
  return contents;
}, "de_ListUpdatesCommand");
var de_RegisterClusterCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    cluster: /* @__PURE__ */ __name((_) => de_Cluster(_, context), "cluster")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_RegisterClusterCommand");
var de_TagResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_TagResourceCommand");
var de_UntagResourceCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  await (0, import_smithy_client.collectBody)(output.body, context);
  return contents;
}, "de_UntagResourceCommand");
var de_UpdateAccessEntryCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    accessEntry: /* @__PURE__ */ __name((_) => de_AccessEntry(_, context), "accessEntry")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_UpdateAccessEntryCommand");
var de_UpdateAddonCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    update: /* @__PURE__ */ __name((_) => de_Update(_, context), "update")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_UpdateAddonCommand");
var de_UpdateClusterConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    update: /* @__PURE__ */ __name((_) => de_Update(_, context), "update")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_UpdateClusterConfigCommand");
var de_UpdateClusterVersionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    update: /* @__PURE__ */ __name((_) => de_Update(_, context), "update")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_UpdateClusterVersionCommand");
var de_UpdateEksAnywhereSubscriptionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    subscription: /* @__PURE__ */ __name((_) => de_EksAnywhereSubscription(_, context), "subscription")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_UpdateEksAnywhereSubscriptionCommand");
var de_UpdateNodegroupConfigCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    update: /* @__PURE__ */ __name((_) => de_Update(_, context), "update")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_UpdateNodegroupConfigCommand");
var de_UpdateNodegroupVersionCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    update: /* @__PURE__ */ __name((_) => de_Update(_, context), "update")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_UpdateNodegroupVersionCommand");
var de_UpdatePodIdentityAssociationCommand = /* @__PURE__ */ __name(async (output, context) => {
  if (output.statusCode !== 200 && output.statusCode >= 300) {
    return de_CommandError(output, context);
  }
  const contents = (0, import_smithy_client.map)({
    $metadata: deserializeMetadata(output)
  });
  const data = (0, import_smithy_client.expectNonNull)((0, import_smithy_client.expectObject)(await (0, import_core2.parseJsonBody)(output.body, context)), "body");
  const doc = (0, import_smithy_client.take)(data, {
    association: /* @__PURE__ */ __name((_) => de_PodIdentityAssociation(_, context), "association")
  });
  Object.assign(contents, doc);
  return contents;
}, "de_UpdatePodIdentityAssociationCommand");
var de_CommandError = /* @__PURE__ */ __name(async (output, context) => {
  const parsedOutput = {
    ...output,
    body: await (0, import_core2.parseJsonErrorBody)(output.body, context)
  };
  const errorCode = (0, import_core2.loadRestJsonErrorCode)(output, parsedOutput.body);
  switch (errorCode) {
    case "InvalidParameterException":
    case "com.amazonaws.eks#InvalidParameterException":
      throw await de_InvalidParameterExceptionRes(parsedOutput, context);
    case "InvalidRequestException":
    case "com.amazonaws.eks#InvalidRequestException":
      throw await de_InvalidRequestExceptionRes(parsedOutput, context);
    case "ResourceNotFoundException":
    case "com.amazonaws.eks#ResourceNotFoundException":
      throw await de_ResourceNotFoundExceptionRes(parsedOutput, context);
    case "ServerException":
    case "com.amazonaws.eks#ServerException":
      throw await de_ServerExceptionRes(parsedOutput, context);
    case "ClientException":
    case "com.amazonaws.eks#ClientException":
      throw await de_ClientExceptionRes(parsedOutput, context);
    case "ResourceInUseException":
    case "com.amazonaws.eks#ResourceInUseException":
      throw await de_ResourceInUseExceptionRes(parsedOutput, context);
    case "ThrottlingException":
    case "com.amazonaws.eks#ThrottlingException":
      throw await de_ThrottlingExceptionRes(parsedOutput, context);
    case "ResourceLimitExceededException":
    case "com.amazonaws.eks#ResourceLimitExceededException":
      throw await de_ResourceLimitExceededExceptionRes(parsedOutput, context);
    case "ServiceUnavailableException":
    case "com.amazonaws.eks#ServiceUnavailableException":
      throw await de_ServiceUnavailableExceptionRes(parsedOutput, context);
    case "UnsupportedAvailabilityZoneException":
    case "com.amazonaws.eks#UnsupportedAvailabilityZoneException":
      throw await de_UnsupportedAvailabilityZoneExceptionRes(parsedOutput, context);
    case "AccessDeniedException":
    case "com.amazonaws.eks#AccessDeniedException":
      throw await de_AccessDeniedExceptionRes(parsedOutput, context);
    case "BadRequestException":
    case "com.amazonaws.eks#BadRequestException":
      throw await de_BadRequestExceptionRes(parsedOutput, context);
    case "NotFoundException":
    case "com.amazonaws.eks#NotFoundException":
      throw await de_NotFoundExceptionRes(parsedOutput, context);
    case "ResourcePropagationDelayException":
    case "com.amazonaws.eks#ResourcePropagationDelayException":
      throw await de_ResourcePropagationDelayExceptionRes(parsedOutput, context);
    case "InvalidStateException":
    case "com.amazonaws.eks#InvalidStateException":
      throw await de_InvalidStateExceptionRes(parsedOutput, context);
    default:
      const parsedBody = parsedOutput.body;
      return throwDefaultError({
        output,
        parsedBody,
        errorCode
      });
  }
}, "de_CommandError");
var throwDefaultError = (0, import_smithy_client.withBaseException)(EKSServiceException);
var de_AccessDeniedExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body;
  const doc = (0, import_smithy_client.take)(data, {
    message: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  const exception = new AccessDeniedException({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body);
}, "de_AccessDeniedExceptionRes");
var de_BadRequestExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body;
  const doc = (0, import_smithy_client.take)(data, {
    message: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  const exception = new BadRequestException({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body);
}, "de_BadRequestExceptionRes");
var de_ClientExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body;
  const doc = (0, import_smithy_client.take)(data, {
    addonName: import_smithy_client.expectString,
    clusterName: import_smithy_client.expectString,
    message: import_smithy_client.expectString,
    nodegroupName: import_smithy_client.expectString,
    subscriptionId: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  const exception = new ClientException({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body);
}, "de_ClientExceptionRes");
var de_InvalidParameterExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body;
  const doc = (0, import_smithy_client.take)(data, {
    addonName: import_smithy_client.expectString,
    clusterName: import_smithy_client.expectString,
    fargateProfileName: import_smithy_client.expectString,
    message: import_smithy_client.expectString,
    nodegroupName: import_smithy_client.expectString,
    subscriptionId: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  const exception = new InvalidParameterException({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body);
}, "de_InvalidParameterExceptionRes");
var de_InvalidRequestExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body;
  const doc = (0, import_smithy_client.take)(data, {
    addonName: import_smithy_client.expectString,
    clusterName: import_smithy_client.expectString,
    message: import_smithy_client.expectString,
    nodegroupName: import_smithy_client.expectString,
    subscriptionId: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  const exception = new InvalidRequestException({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body);
}, "de_InvalidRequestExceptionRes");
var de_InvalidStateExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body;
  const doc = (0, import_smithy_client.take)(data, {
    clusterName: import_smithy_client.expectString,
    message: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  const exception = new InvalidStateException({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body);
}, "de_InvalidStateExceptionRes");
var de_NotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body;
  const doc = (0, import_smithy_client.take)(data, {
    message: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  const exception = new NotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body);
}, "de_NotFoundExceptionRes");
var de_ResourceInUseExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body;
  const doc = (0, import_smithy_client.take)(data, {
    addonName: import_smithy_client.expectString,
    clusterName: import_smithy_client.expectString,
    message: import_smithy_client.expectString,
    nodegroupName: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  const exception = new ResourceInUseException({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body);
}, "de_ResourceInUseExceptionRes");
var de_ResourceLimitExceededExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body;
  const doc = (0, import_smithy_client.take)(data, {
    clusterName: import_smithy_client.expectString,
    message: import_smithy_client.expectString,
    nodegroupName: import_smithy_client.expectString,
    subscriptionId: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  const exception = new ResourceLimitExceededException({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body);
}, "de_ResourceLimitExceededExceptionRes");
var de_ResourceNotFoundExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body;
  const doc = (0, import_smithy_client.take)(data, {
    addonName: import_smithy_client.expectString,
    clusterName: import_smithy_client.expectString,
    fargateProfileName: import_smithy_client.expectString,
    message: import_smithy_client.expectString,
    nodegroupName: import_smithy_client.expectString,
    subscriptionId: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  const exception = new ResourceNotFoundException({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body);
}, "de_ResourceNotFoundExceptionRes");
var de_ResourcePropagationDelayExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body;
  const doc = (0, import_smithy_client.take)(data, {
    message: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  const exception = new ResourcePropagationDelayException({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body);
}, "de_ResourcePropagationDelayExceptionRes");
var de_ServerExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body;
  const doc = (0, import_smithy_client.take)(data, {
    addonName: import_smithy_client.expectString,
    clusterName: import_smithy_client.expectString,
    message: import_smithy_client.expectString,
    nodegroupName: import_smithy_client.expectString,
    subscriptionId: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  const exception = new ServerException({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body);
}, "de_ServerExceptionRes");
var de_ServiceUnavailableExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body;
  const doc = (0, import_smithy_client.take)(data, {
    message: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  const exception = new ServiceUnavailableException({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body);
}, "de_ServiceUnavailableExceptionRes");
var de_ThrottlingExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body;
  const doc = (0, import_smithy_client.take)(data, {
    clusterName: import_smithy_client.expectString,
    message: import_smithy_client.expectString
  });
  Object.assign(contents, doc);
  const exception = new ThrottlingException({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body);
}, "de_ThrottlingExceptionRes");
var de_UnsupportedAvailabilityZoneExceptionRes = /* @__PURE__ */ __name(async (parsedOutput, context) => {
  const contents = (0, import_smithy_client.map)({});
  const data = parsedOutput.body;
  const doc = (0, import_smithy_client.take)(data, {
    clusterName: import_smithy_client.expectString,
    message: import_smithy_client.expectString,
    nodegroupName: import_smithy_client.expectString,
    validZones: import_smithy_client._json
  });
  Object.assign(contents, doc);
  const exception = new UnsupportedAvailabilityZoneException({
    $metadata: deserializeMetadata(parsedOutput),
    ...contents
  });
  return (0, import_smithy_client.decorateServiceException)(exception, parsedOutput.body);
}, "de_UnsupportedAvailabilityZoneExceptionRes");
var de_AccessEntry = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    accessEntryArn: import_smithy_client.expectString,
    clusterName: import_smithy_client.expectString,
    createdAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "createdAt"),
    kubernetesGroups: import_smithy_client._json,
    modifiedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "modifiedAt"),
    principalArn: import_smithy_client.expectString,
    tags: import_smithy_client._json,
    type: import_smithy_client.expectString,
    username: import_smithy_client.expectString
  });
}, "de_AccessEntry");
var de_Addon = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    addonArn: import_smithy_client.expectString,
    addonName: import_smithy_client.expectString,
    addonVersion: import_smithy_client.expectString,
    clusterName: import_smithy_client.expectString,
    configurationValues: import_smithy_client.expectString,
    createdAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "createdAt"),
    health: import_smithy_client._json,
    marketplaceInformation: import_smithy_client._json,
    modifiedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "modifiedAt"),
    owner: import_smithy_client.expectString,
    podIdentityAssociations: import_smithy_client._json,
    publisher: import_smithy_client.expectString,
    serviceAccountRoleArn: import_smithy_client.expectString,
    status: import_smithy_client.expectString,
    tags: import_smithy_client._json
  });
}, "de_Addon");
var de_AssociatedAccessPoliciesList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_AssociatedAccessPolicy(entry, context);
  });
  return retVal;
}, "de_AssociatedAccessPoliciesList");
var de_AssociatedAccessPolicy = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    accessScope: import_smithy_client._json,
    associatedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "associatedAt"),
    modifiedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "modifiedAt"),
    policyArn: import_smithy_client.expectString
  });
}, "de_AssociatedAccessPolicy");
var de_ClientStat = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    lastRequestTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "lastRequestTime"),
    numberOfRequestsLast30Days: import_smithy_client.expectInt32,
    userAgent: import_smithy_client.expectString
  });
}, "de_ClientStat");
var de_ClientStats = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ClientStat(entry, context);
  });
  return retVal;
}, "de_ClientStats");
var de_Cluster = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    accessConfig: import_smithy_client._json,
    arn: import_smithy_client.expectString,
    certificateAuthority: import_smithy_client._json,
    clientRequestToken: import_smithy_client.expectString,
    computeConfig: import_smithy_client._json,
    connectorConfig: /* @__PURE__ */ __name((_) => de_ConnectorConfigResponse(_, context), "connectorConfig"),
    createdAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "createdAt"),
    encryptionConfig: import_smithy_client._json,
    endpoint: import_smithy_client.expectString,
    health: import_smithy_client._json,
    id: import_smithy_client.expectString,
    identity: import_smithy_client._json,
    kubernetesNetworkConfig: import_smithy_client._json,
    logging: import_smithy_client._json,
    name: import_smithy_client.expectString,
    outpostConfig: import_smithy_client._json,
    platformVersion: import_smithy_client.expectString,
    remoteNetworkConfig: import_smithy_client._json,
    resourcesVpcConfig: import_smithy_client._json,
    roleArn: import_smithy_client.expectString,
    status: import_smithy_client.expectString,
    storageConfig: import_smithy_client._json,
    tags: import_smithy_client._json,
    upgradePolicy: import_smithy_client._json,
    version: import_smithy_client.expectString,
    zonalShiftConfig: import_smithy_client._json
  });
}, "de_Cluster");
var de_ClusterVersionInformation = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    clusterType: import_smithy_client.expectString,
    clusterVersion: import_smithy_client.expectString,
    defaultPlatformVersion: import_smithy_client.expectString,
    defaultVersion: import_smithy_client.expectBoolean,
    endOfExtendedSupportDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "endOfExtendedSupportDate"),
    endOfStandardSupportDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "endOfStandardSupportDate"),
    kubernetesPatchVersion: import_smithy_client.expectString,
    releaseDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "releaseDate"),
    status: import_smithy_client.expectString,
    versionStatus: import_smithy_client.expectString
  });
}, "de_ClusterVersionInformation");
var de_ClusterVersionList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_ClusterVersionInformation(entry, context);
  });
  return retVal;
}, "de_ClusterVersionList");
var de_ConnectorConfigResponse = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    activationCode: import_smithy_client.expectString,
    activationExpiry: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "activationExpiry"),
    activationId: import_smithy_client.expectString,
    provider: import_smithy_client.expectString,
    roleArn: import_smithy_client.expectString
  });
}, "de_ConnectorConfigResponse");
var de_DeprecationDetail = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    clientStats: /* @__PURE__ */ __name((_) => de_ClientStats(_, context), "clientStats"),
    replacedWith: import_smithy_client.expectString,
    startServingReplacementVersion: import_smithy_client.expectString,
    stopServingVersion: import_smithy_client.expectString,
    usage: import_smithy_client.expectString
  });
}, "de_DeprecationDetail");
var de_DeprecationDetails = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_DeprecationDetail(entry, context);
  });
  return retVal;
}, "de_DeprecationDetails");
var de_EksAnywhereSubscription = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    arn: import_smithy_client.expectString,
    autoRenew: import_smithy_client.expectBoolean,
    createdAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "createdAt"),
    effectiveDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "effectiveDate"),
    expirationDate: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "expirationDate"),
    id: import_smithy_client.expectString,
    licenseArns: import_smithy_client._json,
    licenseQuantity: import_smithy_client.expectInt32,
    licenseType: import_smithy_client.expectString,
    licenses: import_smithy_client._json,
    status: import_smithy_client.expectString,
    tags: import_smithy_client._json,
    term: import_smithy_client._json
  });
}, "de_EksAnywhereSubscription");
var de_EksAnywhereSubscriptionList = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_EksAnywhereSubscription(entry, context);
  });
  return retVal;
}, "de_EksAnywhereSubscriptionList");
var de_FargateProfile = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    clusterName: import_smithy_client.expectString,
    createdAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "createdAt"),
    fargateProfileArn: import_smithy_client.expectString,
    fargateProfileName: import_smithy_client.expectString,
    health: import_smithy_client._json,
    podExecutionRoleArn: import_smithy_client.expectString,
    selectors: import_smithy_client._json,
    status: import_smithy_client.expectString,
    subnets: import_smithy_client._json,
    tags: import_smithy_client._json
  });
}, "de_FargateProfile");
var de_Insight = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    additionalInfo: import_smithy_client._json,
    category: import_smithy_client.expectString,
    categorySpecificSummary: /* @__PURE__ */ __name((_) => de_InsightCategorySpecificSummary(_, context), "categorySpecificSummary"),
    description: import_smithy_client.expectString,
    id: import_smithy_client.expectString,
    insightStatus: import_smithy_client._json,
    kubernetesVersion: import_smithy_client.expectString,
    lastRefreshTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "lastRefreshTime"),
    lastTransitionTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "lastTransitionTime"),
    name: import_smithy_client.expectString,
    recommendation: import_smithy_client.expectString,
    resources: import_smithy_client._json
  });
}, "de_Insight");
var de_InsightCategorySpecificSummary = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    addonCompatibilityDetails: import_smithy_client._json,
    deprecationDetails: /* @__PURE__ */ __name((_) => de_DeprecationDetails(_, context), "deprecationDetails")
  });
}, "de_InsightCategorySpecificSummary");
var de_InsightSummaries = /* @__PURE__ */ __name((output, context) => {
  const retVal = (output || []).filter((e) => e != null).map((entry) => {
    return de_InsightSummary(entry, context);
  });
  return retVal;
}, "de_InsightSummaries");
var de_InsightSummary = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    category: import_smithy_client.expectString,
    description: import_smithy_client.expectString,
    id: import_smithy_client.expectString,
    insightStatus: import_smithy_client._json,
    kubernetesVersion: import_smithy_client.expectString,
    lastRefreshTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "lastRefreshTime"),
    lastTransitionTime: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "lastTransitionTime"),
    name: import_smithy_client.expectString
  });
}, "de_InsightSummary");
var de_Nodegroup = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    amiType: import_smithy_client.expectString,
    capacityType: import_smithy_client.expectString,
    clusterName: import_smithy_client.expectString,
    createdAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "createdAt"),
    diskSize: import_smithy_client.expectInt32,
    health: import_smithy_client._json,
    instanceTypes: import_smithy_client._json,
    labels: import_smithy_client._json,
    launchTemplate: import_smithy_client._json,
    modifiedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "modifiedAt"),
    nodeRepairConfig: import_smithy_client._json,
    nodeRole: import_smithy_client.expectString,
    nodegroupArn: import_smithy_client.expectString,
    nodegroupName: import_smithy_client.expectString,
    releaseVersion: import_smithy_client.expectString,
    remoteAccess: import_smithy_client._json,
    resources: import_smithy_client._json,
    scalingConfig: import_smithy_client._json,
    status: import_smithy_client.expectString,
    subnets: import_smithy_client._json,
    tags: import_smithy_client._json,
    taints: import_smithy_client._json,
    updateConfig: import_smithy_client._json,
    version: import_smithy_client.expectString
  });
}, "de_Nodegroup");
var de_PodIdentityAssociation = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    associationArn: import_smithy_client.expectString,
    associationId: import_smithy_client.expectString,
    clusterName: import_smithy_client.expectString,
    createdAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "createdAt"),
    disableSessionTags: import_smithy_client.expectBoolean,
    externalId: import_smithy_client.expectString,
    modifiedAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "modifiedAt"),
    namespace: import_smithy_client.expectString,
    ownerArn: import_smithy_client.expectString,
    roleArn: import_smithy_client.expectString,
    serviceAccount: import_smithy_client.expectString,
    tags: import_smithy_client._json,
    targetRoleArn: import_smithy_client.expectString
  });
}, "de_PodIdentityAssociation");
var de_Update = /* @__PURE__ */ __name((output, context) => {
  return (0, import_smithy_client.take)(output, {
    createdAt: /* @__PURE__ */ __name((_) => (0, import_smithy_client.expectNonNull)((0, import_smithy_client.parseEpochTimestamp)((0, import_smithy_client.expectNumber)(_))), "createdAt"),
    errors: import_smithy_client._json,
    id: import_smithy_client.expectString,
    params: import_smithy_client._json,
    status: import_smithy_client.expectString,
    type: import_smithy_client.expectString
  });
}, "de_Update");
var deserializeMetadata = /* @__PURE__ */ __name((output) => ({
  httpStatusCode: output.statusCode,
  requestId: output.headers["x-amzn-requestid"] ?? output.headers["x-amzn-request-id"] ?? output.headers["x-amz-request-id"],
  extendedRequestId: output.headers["x-amz-id-2"],
  cfId: output.headers["x-amz-cf-id"]
}), "deserializeMetadata");
var _aN = "addonName";
var _aPA = "associatedPolicyArn";
var _aV = "addonVersion";
var _cT = "clusterType";
var _cV = "clusterVersions";
var _dO = "defaultOnly";
var _i = "include";
var _iA = "includeAll";
var _iS = "includeStatus";
var _kV = "kubernetesVersion";
var _mR = "maxResults";
var _n = "namespace";
var _nN = "nodegroupName";
var _nT = "nextToken";
var _o = "owners";
var _p = "preserve";
var _pu = "publishers";
var _s = "status";
var _sA = "serviceAccount";
var _t = "types";
var _tK = "tagKeys";
var _vS = "versionStatus";

// src/commands/AssociateAccessPolicyCommand.ts
var AssociateAccessPolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "AssociateAccessPolicy", {}).n("EKSClient", "AssociateAccessPolicyCommand").f(void 0, void 0).ser(se_AssociateAccessPolicyCommand).de(de_AssociateAccessPolicyCommand).build() {
  static {
    __name(this, "AssociateAccessPolicyCommand");
  }
};

// src/commands/AssociateEncryptionConfigCommand.ts



var AssociateEncryptionConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "AssociateEncryptionConfig", {}).n("EKSClient", "AssociateEncryptionConfigCommand").f(void 0, void 0).ser(se_AssociateEncryptionConfigCommand).de(de_AssociateEncryptionConfigCommand).build() {
  static {
    __name(this, "AssociateEncryptionConfigCommand");
  }
};

// src/commands/AssociateIdentityProviderConfigCommand.ts



var AssociateIdentityProviderConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "AssociateIdentityProviderConfig", {}).n("EKSClient", "AssociateIdentityProviderConfigCommand").f(void 0, void 0).ser(se_AssociateIdentityProviderConfigCommand).de(de_AssociateIdentityProviderConfigCommand).build() {
  static {
    __name(this, "AssociateIdentityProviderConfigCommand");
  }
};

// src/commands/CreateAccessEntryCommand.ts



var CreateAccessEntryCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "CreateAccessEntry", {}).n("EKSClient", "CreateAccessEntryCommand").f(void 0, void 0).ser(se_CreateAccessEntryCommand).de(de_CreateAccessEntryCommand).build() {
  static {
    __name(this, "CreateAccessEntryCommand");
  }
};

// src/commands/CreateAddonCommand.ts



var CreateAddonCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "CreateAddon", {}).n("EKSClient", "CreateAddonCommand").f(void 0, void 0).ser(se_CreateAddonCommand).de(de_CreateAddonCommand).build() {
  static {
    __name(this, "CreateAddonCommand");
  }
};

// src/commands/CreateClusterCommand.ts



var CreateClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "CreateCluster", {}).n("EKSClient", "CreateClusterCommand").f(void 0, void 0).ser(se_CreateClusterCommand).de(de_CreateClusterCommand).build() {
  static {
    __name(this, "CreateClusterCommand");
  }
};

// src/commands/CreateEksAnywhereSubscriptionCommand.ts



var CreateEksAnywhereSubscriptionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "CreateEksAnywhereSubscription", {}).n("EKSClient", "CreateEksAnywhereSubscriptionCommand").f(void 0, void 0).ser(se_CreateEksAnywhereSubscriptionCommand).de(de_CreateEksAnywhereSubscriptionCommand).build() {
  static {
    __name(this, "CreateEksAnywhereSubscriptionCommand");
  }
};

// src/commands/CreateFargateProfileCommand.ts



var CreateFargateProfileCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "CreateFargateProfile", {}).n("EKSClient", "CreateFargateProfileCommand").f(void 0, void 0).ser(se_CreateFargateProfileCommand).de(de_CreateFargateProfileCommand).build() {
  static {
    __name(this, "CreateFargateProfileCommand");
  }
};

// src/commands/CreateNodegroupCommand.ts



var CreateNodegroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "CreateNodegroup", {}).n("EKSClient", "CreateNodegroupCommand").f(void 0, void 0).ser(se_CreateNodegroupCommand).de(de_CreateNodegroupCommand).build() {
  static {
    __name(this, "CreateNodegroupCommand");
  }
};

// src/commands/CreatePodIdentityAssociationCommand.ts



var CreatePodIdentityAssociationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "CreatePodIdentityAssociation", {}).n("EKSClient", "CreatePodIdentityAssociationCommand").f(void 0, void 0).ser(se_CreatePodIdentityAssociationCommand).de(de_CreatePodIdentityAssociationCommand).build() {
  static {
    __name(this, "CreatePodIdentityAssociationCommand");
  }
};

// src/commands/DeleteAccessEntryCommand.ts



var DeleteAccessEntryCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DeleteAccessEntry", {}).n("EKSClient", "DeleteAccessEntryCommand").f(void 0, void 0).ser(se_DeleteAccessEntryCommand).de(de_DeleteAccessEntryCommand).build() {
  static {
    __name(this, "DeleteAccessEntryCommand");
  }
};

// src/commands/DeleteAddonCommand.ts



var DeleteAddonCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DeleteAddon", {}).n("EKSClient", "DeleteAddonCommand").f(void 0, void 0).ser(se_DeleteAddonCommand).de(de_DeleteAddonCommand).build() {
  static {
    __name(this, "DeleteAddonCommand");
  }
};

// src/commands/DeleteClusterCommand.ts



var DeleteClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DeleteCluster", {}).n("EKSClient", "DeleteClusterCommand").f(void 0, void 0).ser(se_DeleteClusterCommand).de(de_DeleteClusterCommand).build() {
  static {
    __name(this, "DeleteClusterCommand");
  }
};

// src/commands/DeleteEksAnywhereSubscriptionCommand.ts



var DeleteEksAnywhereSubscriptionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DeleteEksAnywhereSubscription", {}).n("EKSClient", "DeleteEksAnywhereSubscriptionCommand").f(void 0, void 0).ser(se_DeleteEksAnywhereSubscriptionCommand).de(de_DeleteEksAnywhereSubscriptionCommand).build() {
  static {
    __name(this, "DeleteEksAnywhereSubscriptionCommand");
  }
};

// src/commands/DeleteFargateProfileCommand.ts



var DeleteFargateProfileCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DeleteFargateProfile", {}).n("EKSClient", "DeleteFargateProfileCommand").f(void 0, void 0).ser(se_DeleteFargateProfileCommand).de(de_DeleteFargateProfileCommand).build() {
  static {
    __name(this, "DeleteFargateProfileCommand");
  }
};

// src/commands/DeleteNodegroupCommand.ts



var DeleteNodegroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DeleteNodegroup", {}).n("EKSClient", "DeleteNodegroupCommand").f(void 0, void 0).ser(se_DeleteNodegroupCommand).de(de_DeleteNodegroupCommand).build() {
  static {
    __name(this, "DeleteNodegroupCommand");
  }
};

// src/commands/DeletePodIdentityAssociationCommand.ts



var DeletePodIdentityAssociationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DeletePodIdentityAssociation", {}).n("EKSClient", "DeletePodIdentityAssociationCommand").f(void 0, void 0).ser(se_DeletePodIdentityAssociationCommand).de(de_DeletePodIdentityAssociationCommand).build() {
  static {
    __name(this, "DeletePodIdentityAssociationCommand");
  }
};

// src/commands/DeregisterClusterCommand.ts



var DeregisterClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DeregisterCluster", {}).n("EKSClient", "DeregisterClusterCommand").f(void 0, void 0).ser(se_DeregisterClusterCommand).de(de_DeregisterClusterCommand).build() {
  static {
    __name(this, "DeregisterClusterCommand");
  }
};

// src/commands/DescribeAccessEntryCommand.ts



var DescribeAccessEntryCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DescribeAccessEntry", {}).n("EKSClient", "DescribeAccessEntryCommand").f(void 0, void 0).ser(se_DescribeAccessEntryCommand).de(de_DescribeAccessEntryCommand).build() {
  static {
    __name(this, "DescribeAccessEntryCommand");
  }
};

// src/commands/DescribeAddonCommand.ts



var DescribeAddonCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DescribeAddon", {}).n("EKSClient", "DescribeAddonCommand").f(void 0, void 0).ser(se_DescribeAddonCommand).de(de_DescribeAddonCommand).build() {
  static {
    __name(this, "DescribeAddonCommand");
  }
};

// src/commands/DescribeAddonConfigurationCommand.ts



var DescribeAddonConfigurationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DescribeAddonConfiguration", {}).n("EKSClient", "DescribeAddonConfigurationCommand").f(void 0, void 0).ser(se_DescribeAddonConfigurationCommand).de(de_DescribeAddonConfigurationCommand).build() {
  static {
    __name(this, "DescribeAddonConfigurationCommand");
  }
};

// src/commands/DescribeAddonVersionsCommand.ts



var DescribeAddonVersionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DescribeAddonVersions", {}).n("EKSClient", "DescribeAddonVersionsCommand").f(void 0, void 0).ser(se_DescribeAddonVersionsCommand).de(de_DescribeAddonVersionsCommand).build() {
  static {
    __name(this, "DescribeAddonVersionsCommand");
  }
};

// src/commands/DescribeClusterCommand.ts



var DescribeClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DescribeCluster", {}).n("EKSClient", "DescribeClusterCommand").f(void 0, void 0).ser(se_DescribeClusterCommand).de(de_DescribeClusterCommand).build() {
  static {
    __name(this, "DescribeClusterCommand");
  }
};

// src/commands/DescribeClusterVersionsCommand.ts



var DescribeClusterVersionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DescribeClusterVersions", {}).n("EKSClient", "DescribeClusterVersionsCommand").f(void 0, void 0).ser(se_DescribeClusterVersionsCommand).de(de_DescribeClusterVersionsCommand).build() {
  static {
    __name(this, "DescribeClusterVersionsCommand");
  }
};

// src/commands/DescribeEksAnywhereSubscriptionCommand.ts



var DescribeEksAnywhereSubscriptionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DescribeEksAnywhereSubscription", {}).n("EKSClient", "DescribeEksAnywhereSubscriptionCommand").f(void 0, void 0).ser(se_DescribeEksAnywhereSubscriptionCommand).de(de_DescribeEksAnywhereSubscriptionCommand).build() {
  static {
    __name(this, "DescribeEksAnywhereSubscriptionCommand");
  }
};

// src/commands/DescribeFargateProfileCommand.ts



var DescribeFargateProfileCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DescribeFargateProfile", {}).n("EKSClient", "DescribeFargateProfileCommand").f(void 0, void 0).ser(se_DescribeFargateProfileCommand).de(de_DescribeFargateProfileCommand).build() {
  static {
    __name(this, "DescribeFargateProfileCommand");
  }
};

// src/commands/DescribeIdentityProviderConfigCommand.ts



var DescribeIdentityProviderConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DescribeIdentityProviderConfig", {}).n("EKSClient", "DescribeIdentityProviderConfigCommand").f(void 0, void 0).ser(se_DescribeIdentityProviderConfigCommand).de(de_DescribeIdentityProviderConfigCommand).build() {
  static {
    __name(this, "DescribeIdentityProviderConfigCommand");
  }
};

// src/commands/DescribeInsightCommand.ts



var DescribeInsightCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DescribeInsight", {}).n("EKSClient", "DescribeInsightCommand").f(void 0, void 0).ser(se_DescribeInsightCommand).de(de_DescribeInsightCommand).build() {
  static {
    __name(this, "DescribeInsightCommand");
  }
};

// src/commands/DescribeNodegroupCommand.ts



var DescribeNodegroupCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DescribeNodegroup", {}).n("EKSClient", "DescribeNodegroupCommand").f(void 0, void 0).ser(se_DescribeNodegroupCommand).de(de_DescribeNodegroupCommand).build() {
  static {
    __name(this, "DescribeNodegroupCommand");
  }
};

// src/commands/DescribePodIdentityAssociationCommand.ts



var DescribePodIdentityAssociationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DescribePodIdentityAssociation", {}).n("EKSClient", "DescribePodIdentityAssociationCommand").f(void 0, void 0).ser(se_DescribePodIdentityAssociationCommand).de(de_DescribePodIdentityAssociationCommand).build() {
  static {
    __name(this, "DescribePodIdentityAssociationCommand");
  }
};

// src/commands/DescribeUpdateCommand.ts



var DescribeUpdateCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DescribeUpdate", {}).n("EKSClient", "DescribeUpdateCommand").f(void 0, void 0).ser(se_DescribeUpdateCommand).de(de_DescribeUpdateCommand).build() {
  static {
    __name(this, "DescribeUpdateCommand");
  }
};

// src/commands/DisassociateAccessPolicyCommand.ts



var DisassociateAccessPolicyCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DisassociateAccessPolicy", {}).n("EKSClient", "DisassociateAccessPolicyCommand").f(void 0, void 0).ser(se_DisassociateAccessPolicyCommand).de(de_DisassociateAccessPolicyCommand).build() {
  static {
    __name(this, "DisassociateAccessPolicyCommand");
  }
};

// src/commands/DisassociateIdentityProviderConfigCommand.ts



var DisassociateIdentityProviderConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "DisassociateIdentityProviderConfig", {}).n("EKSClient", "DisassociateIdentityProviderConfigCommand").f(void 0, void 0).ser(se_DisassociateIdentityProviderConfigCommand).de(de_DisassociateIdentityProviderConfigCommand).build() {
  static {
    __name(this, "DisassociateIdentityProviderConfigCommand");
  }
};

// src/commands/ListAccessEntriesCommand.ts



var ListAccessEntriesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "ListAccessEntries", {}).n("EKSClient", "ListAccessEntriesCommand").f(void 0, void 0).ser(se_ListAccessEntriesCommand).de(de_ListAccessEntriesCommand).build() {
  static {
    __name(this, "ListAccessEntriesCommand");
  }
};

// src/commands/ListAccessPoliciesCommand.ts



var ListAccessPoliciesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "ListAccessPolicies", {}).n("EKSClient", "ListAccessPoliciesCommand").f(void 0, void 0).ser(se_ListAccessPoliciesCommand).de(de_ListAccessPoliciesCommand).build() {
  static {
    __name(this, "ListAccessPoliciesCommand");
  }
};

// src/commands/ListAddonsCommand.ts



var ListAddonsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "ListAddons", {}).n("EKSClient", "ListAddonsCommand").f(void 0, void 0).ser(se_ListAddonsCommand).de(de_ListAddonsCommand).build() {
  static {
    __name(this, "ListAddonsCommand");
  }
};

// src/commands/ListAssociatedAccessPoliciesCommand.ts



var ListAssociatedAccessPoliciesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "ListAssociatedAccessPolicies", {}).n("EKSClient", "ListAssociatedAccessPoliciesCommand").f(void 0, void 0).ser(se_ListAssociatedAccessPoliciesCommand).de(de_ListAssociatedAccessPoliciesCommand).build() {
  static {
    __name(this, "ListAssociatedAccessPoliciesCommand");
  }
};

// src/commands/ListClustersCommand.ts



var ListClustersCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "ListClusters", {}).n("EKSClient", "ListClustersCommand").f(void 0, void 0).ser(se_ListClustersCommand).de(de_ListClustersCommand).build() {
  static {
    __name(this, "ListClustersCommand");
  }
};

// src/commands/ListEksAnywhereSubscriptionsCommand.ts



var ListEksAnywhereSubscriptionsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "ListEksAnywhereSubscriptions", {}).n("EKSClient", "ListEksAnywhereSubscriptionsCommand").f(void 0, void 0).ser(se_ListEksAnywhereSubscriptionsCommand).de(de_ListEksAnywhereSubscriptionsCommand).build() {
  static {
    __name(this, "ListEksAnywhereSubscriptionsCommand");
  }
};

// src/commands/ListFargateProfilesCommand.ts



var ListFargateProfilesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "ListFargateProfiles", {}).n("EKSClient", "ListFargateProfilesCommand").f(void 0, void 0).ser(se_ListFargateProfilesCommand).de(de_ListFargateProfilesCommand).build() {
  static {
    __name(this, "ListFargateProfilesCommand");
  }
};

// src/commands/ListIdentityProviderConfigsCommand.ts



var ListIdentityProviderConfigsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "ListIdentityProviderConfigs", {}).n("EKSClient", "ListIdentityProviderConfigsCommand").f(void 0, void 0).ser(se_ListIdentityProviderConfigsCommand).de(de_ListIdentityProviderConfigsCommand).build() {
  static {
    __name(this, "ListIdentityProviderConfigsCommand");
  }
};

// src/commands/ListInsightsCommand.ts



var ListInsightsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "ListInsights", {}).n("EKSClient", "ListInsightsCommand").f(void 0, void 0).ser(se_ListInsightsCommand).de(de_ListInsightsCommand).build() {
  static {
    __name(this, "ListInsightsCommand");
  }
};

// src/commands/ListNodegroupsCommand.ts



var ListNodegroupsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "ListNodegroups", {}).n("EKSClient", "ListNodegroupsCommand").f(void 0, void 0).ser(se_ListNodegroupsCommand).de(de_ListNodegroupsCommand).build() {
  static {
    __name(this, "ListNodegroupsCommand");
  }
};

// src/commands/ListPodIdentityAssociationsCommand.ts



var ListPodIdentityAssociationsCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "ListPodIdentityAssociations", {}).n("EKSClient", "ListPodIdentityAssociationsCommand").f(void 0, void 0).ser(se_ListPodIdentityAssociationsCommand).de(de_ListPodIdentityAssociationsCommand).build() {
  static {
    __name(this, "ListPodIdentityAssociationsCommand");
  }
};

// src/commands/ListTagsForResourceCommand.ts



var ListTagsForResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "ListTagsForResource", {}).n("EKSClient", "ListTagsForResourceCommand").f(void 0, void 0).ser(se_ListTagsForResourceCommand).de(de_ListTagsForResourceCommand).build() {
  static {
    __name(this, "ListTagsForResourceCommand");
  }
};

// src/commands/ListUpdatesCommand.ts



var ListUpdatesCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "ListUpdates", {}).n("EKSClient", "ListUpdatesCommand").f(void 0, void 0).ser(se_ListUpdatesCommand).de(de_ListUpdatesCommand).build() {
  static {
    __name(this, "ListUpdatesCommand");
  }
};

// src/commands/RegisterClusterCommand.ts



var RegisterClusterCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "RegisterCluster", {}).n("EKSClient", "RegisterClusterCommand").f(void 0, void 0).ser(se_RegisterClusterCommand).de(de_RegisterClusterCommand).build() {
  static {
    __name(this, "RegisterClusterCommand");
  }
};

// src/commands/TagResourceCommand.ts



var TagResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "TagResource", {}).n("EKSClient", "TagResourceCommand").f(void 0, void 0).ser(se_TagResourceCommand).de(de_TagResourceCommand).build() {
  static {
    __name(this, "TagResourceCommand");
  }
};

// src/commands/UntagResourceCommand.ts



var UntagResourceCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "UntagResource", {}).n("EKSClient", "UntagResourceCommand").f(void 0, void 0).ser(se_UntagResourceCommand).de(de_UntagResourceCommand).build() {
  static {
    __name(this, "UntagResourceCommand");
  }
};

// src/commands/UpdateAccessEntryCommand.ts



var UpdateAccessEntryCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "UpdateAccessEntry", {}).n("EKSClient", "UpdateAccessEntryCommand").f(void 0, void 0).ser(se_UpdateAccessEntryCommand).de(de_UpdateAccessEntryCommand).build() {
  static {
    __name(this, "UpdateAccessEntryCommand");
  }
};

// src/commands/UpdateAddonCommand.ts



var UpdateAddonCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "UpdateAddon", {}).n("EKSClient", "UpdateAddonCommand").f(void 0, void 0).ser(se_UpdateAddonCommand).de(de_UpdateAddonCommand).build() {
  static {
    __name(this, "UpdateAddonCommand");
  }
};

// src/commands/UpdateClusterConfigCommand.ts



var UpdateClusterConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "UpdateClusterConfig", {}).n("EKSClient", "UpdateClusterConfigCommand").f(void 0, void 0).ser(se_UpdateClusterConfigCommand).de(de_UpdateClusterConfigCommand).build() {
  static {
    __name(this, "UpdateClusterConfigCommand");
  }
};

// src/commands/UpdateClusterVersionCommand.ts



var UpdateClusterVersionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "UpdateClusterVersion", {}).n("EKSClient", "UpdateClusterVersionCommand").f(void 0, void 0).ser(se_UpdateClusterVersionCommand).de(de_UpdateClusterVersionCommand).build() {
  static {
    __name(this, "UpdateClusterVersionCommand");
  }
};

// src/commands/UpdateEksAnywhereSubscriptionCommand.ts



var UpdateEksAnywhereSubscriptionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "UpdateEksAnywhereSubscription", {}).n("EKSClient", "UpdateEksAnywhereSubscriptionCommand").f(void 0, void 0).ser(se_UpdateEksAnywhereSubscriptionCommand).de(de_UpdateEksAnywhereSubscriptionCommand).build() {
  static {
    __name(this, "UpdateEksAnywhereSubscriptionCommand");
  }
};

// src/commands/UpdateNodegroupConfigCommand.ts



var UpdateNodegroupConfigCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "UpdateNodegroupConfig", {}).n("EKSClient", "UpdateNodegroupConfigCommand").f(void 0, void 0).ser(se_UpdateNodegroupConfigCommand).de(de_UpdateNodegroupConfigCommand).build() {
  static {
    __name(this, "UpdateNodegroupConfigCommand");
  }
};

// src/commands/UpdateNodegroupVersionCommand.ts



var UpdateNodegroupVersionCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "UpdateNodegroupVersion", {}).n("EKSClient", "UpdateNodegroupVersionCommand").f(void 0, void 0).ser(se_UpdateNodegroupVersionCommand).de(de_UpdateNodegroupVersionCommand).build() {
  static {
    __name(this, "UpdateNodegroupVersionCommand");
  }
};

// src/commands/UpdatePodIdentityAssociationCommand.ts



var UpdatePodIdentityAssociationCommand = class extends import_smithy_client.Command.classBuilder().ep(commonParams).m(function(Command, cs, config, o) {
  return [
    (0, import_middleware_serde.getSerdePlugin)(config, this.serialize, this.deserialize),
    (0, import_middleware_endpoint.getEndpointPlugin)(config, Command.getEndpointParameterInstructions())
  ];
}).s("AWSWesleyFrontend", "UpdatePodIdentityAssociation", {}).n("EKSClient", "UpdatePodIdentityAssociationCommand").f(void 0, void 0).ser(se_UpdatePodIdentityAssociationCommand).de(de_UpdatePodIdentityAssociationCommand).build() {
  static {
    __name(this, "UpdatePodIdentityAssociationCommand");
  }
};

// src/EKS.ts
var commands = {
  AssociateAccessPolicyCommand,
  AssociateEncryptionConfigCommand,
  AssociateIdentityProviderConfigCommand,
  CreateAccessEntryCommand,
  CreateAddonCommand,
  CreateClusterCommand,
  CreateEksAnywhereSubscriptionCommand,
  CreateFargateProfileCommand,
  CreateNodegroupCommand,
  CreatePodIdentityAssociationCommand,
  DeleteAccessEntryCommand,
  DeleteAddonCommand,
  DeleteClusterCommand,
  DeleteEksAnywhereSubscriptionCommand,
  DeleteFargateProfileCommand,
  DeleteNodegroupCommand,
  DeletePodIdentityAssociationCommand,
  DeregisterClusterCommand,
  DescribeAccessEntryCommand,
  DescribeAddonCommand,
  DescribeAddonConfigurationCommand,
  DescribeAddonVersionsCommand,
  DescribeClusterCommand,
  DescribeClusterVersionsCommand,
  DescribeEksAnywhereSubscriptionCommand,
  DescribeFargateProfileCommand,
  DescribeIdentityProviderConfigCommand,
  DescribeInsightCommand,
  DescribeNodegroupCommand,
  DescribePodIdentityAssociationCommand,
  DescribeUpdateCommand,
  DisassociateAccessPolicyCommand,
  DisassociateIdentityProviderConfigCommand,
  ListAccessEntriesCommand,
  ListAccessPoliciesCommand,
  ListAddonsCommand,
  ListAssociatedAccessPoliciesCommand,
  ListClustersCommand,
  ListEksAnywhereSubscriptionsCommand,
  ListFargateProfilesCommand,
  ListIdentityProviderConfigsCommand,
  ListInsightsCommand,
  ListNodegroupsCommand,
  ListPodIdentityAssociationsCommand,
  ListTagsForResourceCommand,
  ListUpdatesCommand,
  RegisterClusterCommand,
  TagResourceCommand,
  UntagResourceCommand,
  UpdateAccessEntryCommand,
  UpdateAddonCommand,
  UpdateClusterConfigCommand,
  UpdateClusterVersionCommand,
  UpdateEksAnywhereSubscriptionCommand,
  UpdateNodegroupConfigCommand,
  UpdateNodegroupVersionCommand,
  UpdatePodIdentityAssociationCommand
};
var EKS = class extends EKSClient {
  static {
    __name(this, "EKS");
  }
};
(0, import_smithy_client.createAggregatedClient)(commands, EKS);

// src/pagination/DescribeAddonVersionsPaginator.ts

var paginateDescribeAddonVersions = (0, import_core.createPaginator)(EKSClient, DescribeAddonVersionsCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/DescribeClusterVersionsPaginator.ts

var paginateDescribeClusterVersions = (0, import_core.createPaginator)(EKSClient, DescribeClusterVersionsCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListAccessEntriesPaginator.ts

var paginateListAccessEntries = (0, import_core.createPaginator)(EKSClient, ListAccessEntriesCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListAccessPoliciesPaginator.ts

var paginateListAccessPolicies = (0, import_core.createPaginator)(EKSClient, ListAccessPoliciesCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListAddonsPaginator.ts

var paginateListAddons = (0, import_core.createPaginator)(EKSClient, ListAddonsCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListAssociatedAccessPoliciesPaginator.ts

var paginateListAssociatedAccessPolicies = (0, import_core.createPaginator)(EKSClient, ListAssociatedAccessPoliciesCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListClustersPaginator.ts

var paginateListClusters = (0, import_core.createPaginator)(EKSClient, ListClustersCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListEksAnywhereSubscriptionsPaginator.ts

var paginateListEksAnywhereSubscriptions = (0, import_core.createPaginator)(EKSClient, ListEksAnywhereSubscriptionsCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListFargateProfilesPaginator.ts

var paginateListFargateProfiles = (0, import_core.createPaginator)(EKSClient, ListFargateProfilesCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListIdentityProviderConfigsPaginator.ts

var paginateListIdentityProviderConfigs = (0, import_core.createPaginator)(EKSClient, ListIdentityProviderConfigsCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListInsightsPaginator.ts

var paginateListInsights = (0, import_core.createPaginator)(EKSClient, ListInsightsCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListNodegroupsPaginator.ts

var paginateListNodegroups = (0, import_core.createPaginator)(EKSClient, ListNodegroupsCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListPodIdentityAssociationsPaginator.ts

var paginateListPodIdentityAssociations = (0, import_core.createPaginator)(EKSClient, ListPodIdentityAssociationsCommand, "nextToken", "nextToken", "maxResults");

// src/pagination/ListUpdatesPaginator.ts

var paginateListUpdates = (0, import_core.createPaginator)(EKSClient, ListUpdatesCommand, "nextToken", "nextToken", "maxResults");

// src/waiters/waitForAddonActive.ts
var import_util_waiter = require("@smithy/util-waiter");
var checkState = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeAddonCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.addon.status;
      }, "returnComparator");
      if (returnComparator() === "CREATE_FAILED") {
        return { state: import_util_waiter.WaiterState.FAILURE, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.addon.status;
      }, "returnComparator");
      if (returnComparator() === "DEGRADED") {
        return { state: import_util_waiter.WaiterState.FAILURE, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.addon.status;
      }, "returnComparator");
      if (returnComparator() === "ACTIVE") {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForAddonActive = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 10, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
}, "waitForAddonActive");
var waitUntilAddonActive = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 10, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilAddonActive");

// src/waiters/waitForAddonDeleted.ts

var checkState2 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeAddonCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.addon.status;
      }, "returnComparator");
      if (returnComparator() === "DELETE_FAILED") {
        return { state: import_util_waiter.WaiterState.FAILURE, reason };
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
    if (exception.name && exception.name == "ResourceNotFoundException") {
      return { state: import_util_waiter.WaiterState.SUCCESS, reason };
    }
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForAddonDeleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 10, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState2);
}, "waitForAddonDeleted");
var waitUntilAddonDeleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 10, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState2);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilAddonDeleted");

// src/waiters/waitForClusterActive.ts

var checkState3 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeClusterCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.cluster.status;
      }, "returnComparator");
      if (returnComparator() === "DELETING") {
        return { state: import_util_waiter.WaiterState.FAILURE, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.cluster.status;
      }, "returnComparator");
      if (returnComparator() === "FAILED") {
        return { state: import_util_waiter.WaiterState.FAILURE, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.cluster.status;
      }, "returnComparator");
      if (returnComparator() === "ACTIVE") {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForClusterActive = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState3);
}, "waitForClusterActive");
var waitUntilClusterActive = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState3);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilClusterActive");

// src/waiters/waitForClusterDeleted.ts

var checkState4 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeClusterCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.cluster.status;
      }, "returnComparator");
      if (returnComparator() === "ACTIVE") {
        return { state: import_util_waiter.WaiterState.FAILURE, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.cluster.status;
      }, "returnComparator");
      if (returnComparator() === "CREATING") {
        return { state: import_util_waiter.WaiterState.FAILURE, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.cluster.status;
      }, "returnComparator");
      if (returnComparator() === "PENDING") {
        return { state: import_util_waiter.WaiterState.FAILURE, reason };
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
    if (exception.name && exception.name == "ResourceNotFoundException") {
      return { state: import_util_waiter.WaiterState.SUCCESS, reason };
    }
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForClusterDeleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState4);
}, "waitForClusterDeleted");
var waitUntilClusterDeleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState4);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilClusterDeleted");

// src/waiters/waitForFargateProfileActive.ts

var checkState5 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeFargateProfileCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.fargateProfile.status;
      }, "returnComparator");
      if (returnComparator() === "CREATE_FAILED") {
        return { state: import_util_waiter.WaiterState.FAILURE, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.fargateProfile.status;
      }, "returnComparator");
      if (returnComparator() === "ACTIVE") {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForFargateProfileActive = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 10, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState5);
}, "waitForFargateProfileActive");
var waitUntilFargateProfileActive = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 10, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState5);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilFargateProfileActive");

// src/waiters/waitForFargateProfileDeleted.ts

var checkState6 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeFargateProfileCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.fargateProfile.status;
      }, "returnComparator");
      if (returnComparator() === "DELETE_FAILED") {
        return { state: import_util_waiter.WaiterState.FAILURE, reason };
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
    if (exception.name && exception.name == "ResourceNotFoundException") {
      return { state: import_util_waiter.WaiterState.SUCCESS, reason };
    }
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForFargateProfileDeleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState6);
}, "waitForFargateProfileDeleted");
var waitUntilFargateProfileDeleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState6);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilFargateProfileDeleted");

// src/waiters/waitForNodegroupActive.ts

var checkState7 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeNodegroupCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.nodegroup.status;
      }, "returnComparator");
      if (returnComparator() === "CREATE_FAILED") {
        return { state: import_util_waiter.WaiterState.FAILURE, reason };
      }
    } catch (e) {
    }
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.nodegroup.status;
      }, "returnComparator");
      if (returnComparator() === "ACTIVE") {
        return { state: import_util_waiter.WaiterState.SUCCESS, reason };
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForNodegroupActive = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState7);
}, "waitForNodegroupActive");
var waitUntilNodegroupActive = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState7);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilNodegroupActive");

// src/waiters/waitForNodegroupDeleted.ts

var checkState8 = /* @__PURE__ */ __name(async (client, input) => {
  let reason;
  try {
    const result = await client.send(new DescribeNodegroupCommand(input));
    reason = result;
    try {
      const returnComparator = /* @__PURE__ */ __name(() => {
        return result.nodegroup.status;
      }, "returnComparator");
      if (returnComparator() === "DELETE_FAILED") {
        return { state: import_util_waiter.WaiterState.FAILURE, reason };
      }
    } catch (e) {
    }
  } catch (exception) {
    reason = exception;
    if (exception.name && exception.name == "ResourceNotFoundException") {
      return { state: import_util_waiter.WaiterState.SUCCESS, reason };
    }
  }
  return { state: import_util_waiter.WaiterState.RETRY, reason };
}, "checkState");
var waitForNodegroupDeleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  return (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState8);
}, "waitForNodegroupDeleted");
var waitUntilNodegroupDeleted = /* @__PURE__ */ __name(async (params, input) => {
  const serviceDefaults = { minDelay: 30, maxDelay: 120 };
  const result = await (0, import_util_waiter.createWaiter)({ ...serviceDefaults, ...params }, input, checkState8);
  return (0, import_util_waiter.checkExceptions)(result);
}, "waitUntilNodegroupDeleted");
// Annotate the CommonJS export names for ESM import in node:

0 && (module.exports = {
  EKSServiceException,
  __Client,
  EKSClient,
  EKS,
  $Command,
  AssociateAccessPolicyCommand,
  AssociateEncryptionConfigCommand,
  AssociateIdentityProviderConfigCommand,
  CreateAccessEntryCommand,
  CreateAddonCommand,
  CreateClusterCommand,
  CreateEksAnywhereSubscriptionCommand,
  CreateFargateProfileCommand,
  CreateNodegroupCommand,
  CreatePodIdentityAssociationCommand,
  DeleteAccessEntryCommand,
  DeleteAddonCommand,
  DeleteClusterCommand,
  DeleteEksAnywhereSubscriptionCommand,
  DeleteFargateProfileCommand,
  DeleteNodegroupCommand,
  DeletePodIdentityAssociationCommand,
  DeregisterClusterCommand,
  DescribeAccessEntryCommand,
  DescribeAddonCommand,
  DescribeAddonConfigurationCommand,
  DescribeAddonVersionsCommand,
  DescribeClusterCommand,
  DescribeClusterVersionsCommand,
  DescribeEksAnywhereSubscriptionCommand,
  DescribeFargateProfileCommand,
  DescribeIdentityProviderConfigCommand,
  DescribeInsightCommand,
  DescribeNodegroupCommand,
  DescribePodIdentityAssociationCommand,
  DescribeUpdateCommand,
  DisassociateAccessPolicyCommand,
  DisassociateIdentityProviderConfigCommand,
  ListAccessEntriesCommand,
  ListAccessPoliciesCommand,
  ListAddonsCommand,
  ListAssociatedAccessPoliciesCommand,
  ListClustersCommand,
  ListEksAnywhereSubscriptionsCommand,
  ListFargateProfilesCommand,
  ListIdentityProviderConfigsCommand,
  ListInsightsCommand,
  ListNodegroupsCommand,
  ListPodIdentityAssociationsCommand,
  ListTagsForResourceCommand,
  ListUpdatesCommand,
  RegisterClusterCommand,
  TagResourceCommand,
  UntagResourceCommand,
  UpdateAccessEntryCommand,
  UpdateAddonCommand,
  UpdateClusterConfigCommand,
  UpdateClusterVersionCommand,
  UpdateEksAnywhereSubscriptionCommand,
  UpdateNodegroupConfigCommand,
  UpdateNodegroupVersionCommand,
  UpdatePodIdentityAssociationCommand,
  paginateDescribeAddonVersions,
  paginateDescribeClusterVersions,
  paginateListAccessEntries,
  paginateListAccessPolicies,
  paginateListAddons,
  paginateListAssociatedAccessPolicies,
  paginateListClusters,
  paginateListEksAnywhereSubscriptions,
  paginateListFargateProfiles,
  paginateListIdentityProviderConfigs,
  paginateListInsights,
  paginateListNodegroups,
  paginateListPodIdentityAssociations,
  paginateListUpdates,
  waitForAddonActive,
  waitUntilAddonActive,
  waitForAddonDeleted,
  waitUntilAddonDeleted,
  waitForClusterActive,
  waitUntilClusterActive,
  waitForClusterDeleted,
  waitUntilClusterDeleted,
  waitForFargateProfileActive,
  waitUntilFargateProfileActive,
  waitForFargateProfileDeleted,
  waitUntilFargateProfileDeleted,
  waitForNodegroupActive,
  waitUntilNodegroupActive,
  waitForNodegroupDeleted,
  waitUntilNodegroupDeleted,
  AuthenticationMode,
  AccessDeniedException,
  AccessScopeType,
  AddonIssueCode,
  AddonStatus,
  AMITypes,
  InvalidParameterException,
  InvalidRequestException,
  ResourceNotFoundException,
  ServerException,
  ErrorCode,
  UpdateParamType,
  UpdateStatus,
  UpdateType,
  ClientException,
  ResourceInUseException,
  ThrottlingException,
  ResourceLimitExceededException,
  ResolveConflicts,
  IpFamily,
  LogType,
  SupportType,
  ClusterIssueCode,
  ClusterStatus,
  ServiceUnavailableException,
  UnsupportedAvailabilityZoneException,
  EksAnywhereSubscriptionLicenseType,
  EksAnywhereSubscriptionTermUnit,
  FargateProfileIssueCode,
  FargateProfileStatus,
  CapacityTypes,
  TaintEffect,
  NodegroupUpdateStrategies,
  NodegroupIssueCode,
  NodegroupStatus,
  ClusterVersionStatus,
  VersionStatus,
  ConfigStatus,
  Category,
  InsightStatusValue,
  EksAnywhereSubscriptionStatus,
  BadRequestException,
  NotFoundException,
  ConnectorConfigProvider,
  ResourcePropagationDelayException,
  InvalidStateException
});

