import {
  AwsSdkSigV4AuthInputConfig,
  AwsSdkSigV4AuthResolvedConfig,
  AwsSdkSigV4PreviouslyResolved,
} from "@aws-sdk/core";
import {
  HandlerExecutionContext,
  HttpAuthScheme,
  HttpAuthSchemeParameters,
  HttpAuthSchemeParametersProvider,
  HttpAuthSchemeProvider,
  Provider,
} from "@smithy/types";
import { ECRClientResolvedConfig } from "../ECRClient";
export interface ECRHttpAuthSchemeParameters extends HttpAuthSchemeParameters {
  region?: string;
}
export interface ECRHttpAuthSchemeParametersProvider
  extends HttpAuthSchemeParametersProvider<
    ECRClientResolvedConfig,
    HandlerExecutionContext,
    ECRHttpAuthSchemeParameters,
    object
  > {}
export declare const defaultECRHttpAuthSchemeParametersProvider: (
  config: ECRClientResolvedConfig,
  context: HandlerExecutionContext,
  input: object
) => Promise<ECRHttpAuthSchemeParameters>;
export interface ECRHttpAuthSchemeProvider
  extends HttpAuthSchemeProvider<ECRHttpAuthSchemeParameters> {}
export declare const defaultECRHttpAuthSchemeProvider: ECRHttpAuthSchemeProvider;
export interface HttpAuthSchemeInputConfig extends AwsSdkSigV4AuthInputConfig {
  authSchemePreference?: string[] | Provider<string[]>;
  httpAuthSchemes?: HttpAuthScheme[];
  httpAuthSchemeProvider?: ECRHttpAuthSchemeProvider;
}
export interface HttpAuthSchemeResolvedConfig
  extends AwsSdkSigV4AuthResolvedConfig {
  readonly authSchemePreference: Provider<string[]>;
  readonly httpAuthSchemes: HttpAuthScheme[];
  readonly httpAuthSchemeProvider: ECRHttpAuthSchemeProvider;
}
export declare const resolveHttpAuthSchemeConfig: <T>(
  config: T & HttpAuthSchemeInputConfig & AwsSdkSigV4PreviouslyResolved
) => T & HttpAuthSchemeResolvedConfig;
