import {
  HostHeaderInputConfig,
  HostHeaderResolvedConfig,
} from "@aws-sdk/middleware-host-header";
import {
  UserAgentInputConfig,
  UserAgentResolvedConfig,
} from "@aws-sdk/middleware-user-agent";
import {
  RegionInputConfig,
  RegionResolvedConfig,
} from "@smithy/config-resolver";
import {
  EndpointInputConfig,
  EndpointResolvedConfig,
} from "@smithy/middleware-endpoint";
import {
  RetryInputConfig,
  RetryResolvedConfig,
} from "@smithy/middleware-retry";
import { HttpHandlerUserInput as __HttpHandlerUserInput } from "@smithy/protocol-http";
import {
  Client as __Client,
  DefaultsMode as __DefaultsMode,
  SmithyConfiguration as __SmithyConfiguration,
  SmithyResolvedConfiguration as __SmithyResolvedConfiguration,
} from "@smithy/smithy-client";
import {
  AwsCredentialIdentityProvider,
  BodyLengthCalculator as __BodyLengthCalculator,
  CheckOptionalClientConfig as __CheckOptionalClientConfig,
  ChecksumConstructor as __ChecksumConstructor,
  Decoder as __Decoder,
  Encoder as __Encoder,
  HashConstructor as __HashConstructor,
  HttpHandlerOptions as __HttpHandlerOptions,
  Logger as __Logger,
  Provider as __Provider,
  Provider,
  StreamCollector as __StreamCollector,
  UrlParser as __UrlParser,
  UserAgent as __UserAgent,
} from "@smithy/types";
import {
  HttpAuthSchemeInputConfig,
  HttpAuthSchemeResolvedConfig,
} from "./auth/httpAuthSchemeProvider";
import {
  BatchCheckLayerAvailabilityCommandInput,
  BatchCheckLayerAvailabilityCommandOutput,
} from "./commands/BatchCheckLayerAvailabilityCommand";
import {
  BatchDeleteImageCommandInput,
  BatchDeleteImageCommandOutput,
} from "./commands/BatchDeleteImageCommand";
import {
  BatchGetImageCommandInput,
  BatchGetImageCommandOutput,
} from "./commands/BatchGetImageCommand";
import {
  BatchGetRepositoryScanningConfigurationCommandInput,
  BatchGetRepositoryScanningConfigurationCommandOutput,
} from "./commands/BatchGetRepositoryScanningConfigurationCommand";
import {
  CompleteLayerUploadCommandInput,
  CompleteLayerUploadCommandOutput,
} from "./commands/CompleteLayerUploadCommand";
import {
  CreatePullThroughCacheRuleCommandInput,
  CreatePullThroughCacheRuleCommandOutput,
} from "./commands/CreatePullThroughCacheRuleCommand";
import {
  CreateRepositoryCommandInput,
  CreateRepositoryCommandOutput,
} from "./commands/CreateRepositoryCommand";
import {
  CreateRepositoryCreationTemplateCommandInput,
  CreateRepositoryCreationTemplateCommandOutput,
} from "./commands/CreateRepositoryCreationTemplateCommand";
import {
  DeleteLifecyclePolicyCommandInput,
  DeleteLifecyclePolicyCommandOutput,
} from "./commands/DeleteLifecyclePolicyCommand";
import {
  DeletePullThroughCacheRuleCommandInput,
  DeletePullThroughCacheRuleCommandOutput,
} from "./commands/DeletePullThroughCacheRuleCommand";
import {
  DeleteRegistryPolicyCommandInput,
  DeleteRegistryPolicyCommandOutput,
} from "./commands/DeleteRegistryPolicyCommand";
import {
  DeleteRepositoryCommandInput,
  DeleteRepositoryCommandOutput,
} from "./commands/DeleteRepositoryCommand";
import {
  DeleteRepositoryCreationTemplateCommandInput,
  DeleteRepositoryCreationTemplateCommandOutput,
} from "./commands/DeleteRepositoryCreationTemplateCommand";
import {
  DeleteRepositoryPolicyCommandInput,
  DeleteRepositoryPolicyCommandOutput,
} from "./commands/DeleteRepositoryPolicyCommand";
import {
  DescribeImageReplicationStatusCommandInput,
  DescribeImageReplicationStatusCommandOutput,
} from "./commands/DescribeImageReplicationStatusCommand";
import {
  DescribeImageScanFindingsCommandInput,
  DescribeImageScanFindingsCommandOutput,
} from "./commands/DescribeImageScanFindingsCommand";
import {
  DescribeImagesCommandInput,
  DescribeImagesCommandOutput,
} from "./commands/DescribeImagesCommand";
import {
  DescribePullThroughCacheRulesCommandInput,
  DescribePullThroughCacheRulesCommandOutput,
} from "./commands/DescribePullThroughCacheRulesCommand";
import {
  DescribeRegistryCommandInput,
  DescribeRegistryCommandOutput,
} from "./commands/DescribeRegistryCommand";
import {
  DescribeRepositoriesCommandInput,
  DescribeRepositoriesCommandOutput,
} from "./commands/DescribeRepositoriesCommand";
import {
  DescribeRepositoryCreationTemplatesCommandInput,
  DescribeRepositoryCreationTemplatesCommandOutput,
} from "./commands/DescribeRepositoryCreationTemplatesCommand";
import {
  GetAccountSettingCommandInput,
  GetAccountSettingCommandOutput,
} from "./commands/GetAccountSettingCommand";
import {
  GetAuthorizationTokenCommandInput,
  GetAuthorizationTokenCommandOutput,
} from "./commands/GetAuthorizationTokenCommand";
import {
  GetDownloadUrlForLayerCommandInput,
  GetDownloadUrlForLayerCommandOutput,
} from "./commands/GetDownloadUrlForLayerCommand";
import {
  GetLifecyclePolicyCommandInput,
  GetLifecyclePolicyCommandOutput,
} from "./commands/GetLifecyclePolicyCommand";
import {
  GetLifecyclePolicyPreviewCommandInput,
  GetLifecyclePolicyPreviewCommandOutput,
} from "./commands/GetLifecyclePolicyPreviewCommand";
import {
  GetRegistryPolicyCommandInput,
  GetRegistryPolicyCommandOutput,
} from "./commands/GetRegistryPolicyCommand";
import {
  GetRegistryScanningConfigurationCommandInput,
  GetRegistryScanningConfigurationCommandOutput,
} from "./commands/GetRegistryScanningConfigurationCommand";
import {
  GetRepositoryPolicyCommandInput,
  GetRepositoryPolicyCommandOutput,
} from "./commands/GetRepositoryPolicyCommand";
import {
  InitiateLayerUploadCommandInput,
  InitiateLayerUploadCommandOutput,
} from "./commands/InitiateLayerUploadCommand";
import {
  ListImagesCommandInput,
  ListImagesCommandOutput,
} from "./commands/ListImagesCommand";
import {
  ListTagsForResourceCommandInput,
  ListTagsForResourceCommandOutput,
} from "./commands/ListTagsForResourceCommand";
import {
  PutAccountSettingCommandInput,
  PutAccountSettingCommandOutput,
} from "./commands/PutAccountSettingCommand";
import {
  PutImageCommandInput,
  PutImageCommandOutput,
} from "./commands/PutImageCommand";
import {
  PutImageScanningConfigurationCommandInput,
  PutImageScanningConfigurationCommandOutput,
} from "./commands/PutImageScanningConfigurationCommand";
import {
  PutImageTagMutabilityCommandInput,
  PutImageTagMutabilityCommandOutput,
} from "./commands/PutImageTagMutabilityCommand";
import {
  PutLifecyclePolicyCommandInput,
  PutLifecyclePolicyCommandOutput,
} from "./commands/PutLifecyclePolicyCommand";
import {
  PutRegistryPolicyCommandInput,
  PutRegistryPolicyCommandOutput,
} from "./commands/PutRegistryPolicyCommand";
import {
  PutRegistryScanningConfigurationCommandInput,
  PutRegistryScanningConfigurationCommandOutput,
} from "./commands/PutRegistryScanningConfigurationCommand";
import {
  PutReplicationConfigurationCommandInput,
  PutReplicationConfigurationCommandOutput,
} from "./commands/PutReplicationConfigurationCommand";
import {
  SetRepositoryPolicyCommandInput,
  SetRepositoryPolicyCommandOutput,
} from "./commands/SetRepositoryPolicyCommand";
import {
  StartImageScanCommandInput,
  StartImageScanCommandOutput,
} from "./commands/StartImageScanCommand";
import {
  StartLifecyclePolicyPreviewCommandInput,
  StartLifecyclePolicyPreviewCommandOutput,
} from "./commands/StartLifecyclePolicyPreviewCommand";
import {
  TagResourceCommandInput,
  TagResourceCommandOutput,
} from "./commands/TagResourceCommand";
import {
  UntagResourceCommandInput,
  UntagResourceCommandOutput,
} from "./commands/UntagResourceCommand";
import {
  UpdatePullThroughCacheRuleCommandInput,
  UpdatePullThroughCacheRuleCommandOutput,
} from "./commands/UpdatePullThroughCacheRuleCommand";
import {
  UpdateRepositoryCreationTemplateCommandInput,
  UpdateRepositoryCreationTemplateCommandOutput,
} from "./commands/UpdateRepositoryCreationTemplateCommand";
import {
  UploadLayerPartCommandInput,
  UploadLayerPartCommandOutput,
} from "./commands/UploadLayerPartCommand";
import {
  ValidatePullThroughCacheRuleCommandInput,
  ValidatePullThroughCacheRuleCommandOutput,
} from "./commands/ValidatePullThroughCacheRuleCommand";
import {
  ClientInputEndpointParameters,
  ClientResolvedEndpointParameters,
  EndpointParameters,
} from "./endpoint/EndpointParameters";
import { RuntimeExtension, RuntimeExtensionsConfig } from "./runtimeExtensions";
export { __Client };
export type ServiceInputTypes =
  | BatchCheckLayerAvailabilityCommandInput
  | BatchDeleteImageCommandInput
  | BatchGetImageCommandInput
  | BatchGetRepositoryScanningConfigurationCommandInput
  | CompleteLayerUploadCommandInput
  | CreatePullThroughCacheRuleCommandInput
  | CreateRepositoryCommandInput
  | CreateRepositoryCreationTemplateCommandInput
  | DeleteLifecyclePolicyCommandInput
  | DeletePullThroughCacheRuleCommandInput
  | DeleteRegistryPolicyCommandInput
  | DeleteRepositoryCommandInput
  | DeleteRepositoryCreationTemplateCommandInput
  | DeleteRepositoryPolicyCommandInput
  | DescribeImageReplicationStatusCommandInput
  | DescribeImageScanFindingsCommandInput
  | DescribeImagesCommandInput
  | DescribePullThroughCacheRulesCommandInput
  | DescribeRegistryCommandInput
  | DescribeRepositoriesCommandInput
  | DescribeRepositoryCreationTemplatesCommandInput
  | GetAccountSettingCommandInput
  | GetAuthorizationTokenCommandInput
  | GetDownloadUrlForLayerCommandInput
  | GetLifecyclePolicyCommandInput
  | GetLifecyclePolicyPreviewCommandInput
  | GetRegistryPolicyCommandInput
  | GetRegistryScanningConfigurationCommandInput
  | GetRepositoryPolicyCommandInput
  | InitiateLayerUploadCommandInput
  | ListImagesCommandInput
  | ListTagsForResourceCommandInput
  | PutAccountSettingCommandInput
  | PutImageCommandInput
  | PutImageScanningConfigurationCommandInput
  | PutImageTagMutabilityCommandInput
  | PutLifecyclePolicyCommandInput
  | PutRegistryPolicyCommandInput
  | PutRegistryScanningConfigurationCommandInput
  | PutReplicationConfigurationCommandInput
  | SetRepositoryPolicyCommandInput
  | StartImageScanCommandInput
  | StartLifecyclePolicyPreviewCommandInput
  | TagResourceCommandInput
  | UntagResourceCommandInput
  | UpdatePullThroughCacheRuleCommandInput
  | UpdateRepositoryCreationTemplateCommandInput
  | UploadLayerPartCommandInput
  | ValidatePullThroughCacheRuleCommandInput;
export type ServiceOutputTypes =
  | BatchCheckLayerAvailabilityCommandOutput
  | BatchDeleteImageCommandOutput
  | BatchGetImageCommandOutput
  | BatchGetRepositoryScanningConfigurationCommandOutput
  | CompleteLayerUploadCommandOutput
  | CreatePullThroughCacheRuleCommandOutput
  | CreateRepositoryCommandOutput
  | CreateRepositoryCreationTemplateCommandOutput
  | DeleteLifecyclePolicyCommandOutput
  | DeletePullThroughCacheRuleCommandOutput
  | DeleteRegistryPolicyCommandOutput
  | DeleteRepositoryCommandOutput
  | DeleteRepositoryCreationTemplateCommandOutput
  | DeleteRepositoryPolicyCommandOutput
  | DescribeImageReplicationStatusCommandOutput
  | DescribeImageScanFindingsCommandOutput
  | DescribeImagesCommandOutput
  | DescribePullThroughCacheRulesCommandOutput
  | DescribeRegistryCommandOutput
  | DescribeRepositoriesCommandOutput
  | DescribeRepositoryCreationTemplatesCommandOutput
  | GetAccountSettingCommandOutput
  | GetAuthorizationTokenCommandOutput
  | GetDownloadUrlForLayerCommandOutput
  | GetLifecyclePolicyCommandOutput
  | GetLifecyclePolicyPreviewCommandOutput
  | GetRegistryPolicyCommandOutput
  | GetRegistryScanningConfigurationCommandOutput
  | GetRepositoryPolicyCommandOutput
  | InitiateLayerUploadCommandOutput
  | ListImagesCommandOutput
  | ListTagsForResourceCommandOutput
  | PutAccountSettingCommandOutput
  | PutImageCommandOutput
  | PutImageScanningConfigurationCommandOutput
  | PutImageTagMutabilityCommandOutput
  | PutLifecyclePolicyCommandOutput
  | PutRegistryPolicyCommandOutput
  | PutRegistryScanningConfigurationCommandOutput
  | PutReplicationConfigurationCommandOutput
  | SetRepositoryPolicyCommandOutput
  | StartImageScanCommandOutput
  | StartLifecyclePolicyPreviewCommandOutput
  | TagResourceCommandOutput
  | UntagResourceCommandOutput
  | UpdatePullThroughCacheRuleCommandOutput
  | UpdateRepositoryCreationTemplateCommandOutput
  | UploadLayerPartCommandOutput
  | ValidatePullThroughCacheRuleCommandOutput;
export interface ClientDefaults
  extends Partial<__SmithyConfiguration<__HttpHandlerOptions>> {
  requestHandler?: __HttpHandlerUserInput;
  sha256?: __ChecksumConstructor | __HashConstructor;
  urlParser?: __UrlParser;
  bodyLengthChecker?: __BodyLengthCalculator;
  streamCollector?: __StreamCollector;
  base64Decoder?: __Decoder;
  base64Encoder?: __Encoder;
  utf8Decoder?: __Decoder;
  utf8Encoder?: __Encoder;
  runtime?: string;
  disableHostPrefix?: boolean;
  serviceId?: string;
  useDualstackEndpoint?: boolean | __Provider<boolean>;
  useFipsEndpoint?: boolean | __Provider<boolean>;
  region?: string | __Provider<string>;
  profile?: string;
  defaultUserAgentProvider?: Provider<__UserAgent>;
  credentialDefaultProvider?: (input: any) => AwsCredentialIdentityProvider;
  maxAttempts?: number | __Provider<number>;
  retryMode?: string | __Provider<string>;
  logger?: __Logger;
  extensions?: RuntimeExtension[];
  defaultsMode?: __DefaultsMode | __Provider<__DefaultsMode>;
}
export type ECRClientConfigType = Partial<
  __SmithyConfiguration<__HttpHandlerOptions>
> &
  ClientDefaults &
  UserAgentInputConfig &
  RetryInputConfig &
  RegionInputConfig &
  HostHeaderInputConfig &
  EndpointInputConfig<EndpointParameters> &
  HttpAuthSchemeInputConfig &
  ClientInputEndpointParameters;
export interface ECRClientConfig extends ECRClientConfigType {}
export type ECRClientResolvedConfigType =
  __SmithyResolvedConfiguration<__HttpHandlerOptions> &
    Required<ClientDefaults> &
    RuntimeExtensionsConfig &
    UserAgentResolvedConfig &
    RetryResolvedConfig &
    RegionResolvedConfig &
    HostHeaderResolvedConfig &
    EndpointResolvedConfig<EndpointParameters> &
    HttpAuthSchemeResolvedConfig &
    ClientResolvedEndpointParameters;
export interface ECRClientResolvedConfig extends ECRClientResolvedConfigType {}
export declare class ECRClient extends __Client<
  __HttpHandlerOptions,
  ServiceInputTypes,
  ServiceOutputTypes,
  ECRClientResolvedConfig
> {
  readonly config: ECRClientResolvedConfig;
  constructor(...[configuration]: __CheckOptionalClientConfig<ECRClientConfig>);
  destroy(): void;
}
