import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { ECRClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ECRClient";
import { UpdateRepositoryCreationTemplateRequest, UpdateRepositoryCreationTemplateResponse } from "../models/models_0";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link UpdateRepositoryCreationTemplateCommand}.
 */
export interface UpdateRepositoryCreationTemplateCommandInput extends UpdateRepositoryCreationTemplateRequest {
}
/**
 * @public
 *
 * The output of {@link UpdateRepositoryCreationTemplateCommand}.
 */
export interface UpdateRepositoryCreationTemplateCommandOutput extends UpdateRepositoryCreationTemplateResponse, __MetadataBearer {
}
declare const UpdateRepositoryCreationTemplateCommand_base: {
    new (input: UpdateRepositoryCreationTemplateCommandInput): import("@smithy/smithy-client").CommandImpl<UpdateRepositoryCreationTemplateCommandInput, UpdateRepositoryCreationTemplateCommandOutput, ECRClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: UpdateRepositoryCreationTemplateCommandInput): import("@smithy/smithy-client").CommandImpl<UpdateRepositoryCreationTemplateCommandInput, UpdateRepositoryCreationTemplateCommandOutput, ECRClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Updates an existing repository creation template.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ECRClient, UpdateRepositoryCreationTemplateCommand } from "@aws-sdk/client-ecr"; // ES Modules import
 * // const { ECRClient, UpdateRepositoryCreationTemplateCommand } = require("@aws-sdk/client-ecr"); // CommonJS import
 * const client = new ECRClient(config);
 * const input = { // UpdateRepositoryCreationTemplateRequest
 *   prefix: "STRING_VALUE", // required
 *   description: "STRING_VALUE",
 *   encryptionConfiguration: { // EncryptionConfigurationForRepositoryCreationTemplate
 *     encryptionType: "AES256" || "KMS" || "KMS_DSSE", // required
 *     kmsKey: "STRING_VALUE",
 *   },
 *   resourceTags: [ // TagList
 *     { // Tag
 *       Key: "STRING_VALUE", // required
 *       Value: "STRING_VALUE", // required
 *     },
 *   ],
 *   imageTagMutability: "MUTABLE" || "IMMUTABLE",
 *   repositoryPolicy: "STRING_VALUE",
 *   lifecyclePolicy: "STRING_VALUE",
 *   appliedFor: [ // RCTAppliedForList
 *     "REPLICATION" || "PULL_THROUGH_CACHE",
 *   ],
 *   customRoleArn: "STRING_VALUE",
 * };
 * const command = new UpdateRepositoryCreationTemplateCommand(input);
 * const response = await client.send(command);
 * // { // UpdateRepositoryCreationTemplateResponse
 * //   registryId: "STRING_VALUE",
 * //   repositoryCreationTemplate: { // RepositoryCreationTemplate
 * //     prefix: "STRING_VALUE",
 * //     description: "STRING_VALUE",
 * //     encryptionConfiguration: { // EncryptionConfigurationForRepositoryCreationTemplate
 * //       encryptionType: "AES256" || "KMS" || "KMS_DSSE", // required
 * //       kmsKey: "STRING_VALUE",
 * //     },
 * //     resourceTags: [ // TagList
 * //       { // Tag
 * //         Key: "STRING_VALUE", // required
 * //         Value: "STRING_VALUE", // required
 * //       },
 * //     ],
 * //     imageTagMutability: "MUTABLE" || "IMMUTABLE",
 * //     repositoryPolicy: "STRING_VALUE",
 * //     lifecyclePolicy: "STRING_VALUE",
 * //     appliedFor: [ // RCTAppliedForList
 * //       "REPLICATION" || "PULL_THROUGH_CACHE",
 * //     ],
 * //     customRoleArn: "STRING_VALUE",
 * //     createdAt: new Date("TIMESTAMP"),
 * //     updatedAt: new Date("TIMESTAMP"),
 * //   },
 * // };
 *
 * ```
 *
 * @param UpdateRepositoryCreationTemplateCommandInput - {@link UpdateRepositoryCreationTemplateCommandInput}
 * @returns {@link UpdateRepositoryCreationTemplateCommandOutput}
 * @see {@link UpdateRepositoryCreationTemplateCommandInput} for command's `input` shape.
 * @see {@link UpdateRepositoryCreationTemplateCommandOutput} for command's `response` shape.
 * @see {@link ECRClientResolvedConfig | config} for ECRClient's `config` shape.
 *
 * @throws {@link InvalidParameterException} (client fault)
 *  <p>The specified parameter is invalid. Review the available parameters for the API
 *             request.</p>
 *
 * @throws {@link ServerException} (server fault)
 *  <p>These errors are usually caused by a server-side issue.</p>
 *
 * @throws {@link TemplateNotFoundException} (client fault)
 *  <p>The specified repository creation template can't be found. Verify the registry ID and
 *             prefix and try again.</p>
 *
 * @throws {@link ValidationException} (client fault)
 *  <p>There was an exception validating this request.</p>
 *
 * @throws {@link ECRServiceException}
 * <p>Base exception class for all service exceptions from ECR service.</p>
 *
 *
 * @public
 */
export declare class UpdateRepositoryCreationTemplateCommand extends UpdateRepositoryCreationTemplateCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: UpdateRepositoryCreationTemplateRequest;
            output: UpdateRepositoryCreationTemplateResponse;
        };
        sdk: {
            input: UpdateRepositoryCreationTemplateCommandInput;
            output: UpdateRepositoryCreationTemplateCommandOutput;
        };
    };
}
