import { checkExceptions, createWaiter, WaiterState } from "@smithy/util-waiter";
import { GetLifecyclePolicyPreviewCommand, } from "../commands/GetLifecyclePolicyPreviewCommand";
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new GetLifecyclePolicyPreviewCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                return result.status;
            };
            if (returnComparator() === "COMPLETE") {
                return { state: WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
        try {
            const returnComparator = () => {
                return result.status;
            };
            if (returnComparator() === "FAILED") {
                return { state: WaiterState.FAILURE, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
    }
    return { state: WaiterState.RETRY, reason };
};
export const waitForLifecyclePolicyPreviewComplete = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    return createWaiter({ ...serviceDefaults, ...params }, input, checkState);
};
export const waitUntilLifecyclePolicyPreviewComplete = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    const result = await createWaiter({ ...serviceDefaults, ...params }, input, checkState);
    return checkExceptions(result);
};
